/* MainWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*-
 * Copyright 2018-2022 elementary, Inc. (https://elementary.io)
 *           2014 Marvin Beckers <beckersmarvin@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Marvin Beckers <beckersmarvin@gmail.com>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <granite-7.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <langinfo.h>

#define PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX "win."
#define PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_CLEAR "action-clear"
#define PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT "action-insert"
#define PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION "action-function"
#define PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_UNDO "action-undo"
#define PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_COPY "action-copy"
#define PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PASTE "action-paste"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PANTHEON_CALCULATOR_TYPE_MAIN_WINDOW (pantheon_calculator_main_window_get_type ())
#define PANTHEON_CALCULATOR_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_CALCULATOR_TYPE_MAIN_WINDOW, PantheonCalculatorMainWindow))
#define PANTHEON_CALCULATOR_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_CALCULATOR_TYPE_MAIN_WINDOW, PantheonCalculatorMainWindowClass))
#define PANTHEON_CALCULATOR_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_CALCULATOR_TYPE_MAIN_WINDOW))
#define PANTHEON_CALCULATOR_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_CALCULATOR_TYPE_MAIN_WINDOW))
#define PANTHEON_CALCULATOR_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_CALCULATOR_TYPE_MAIN_WINDOW, PantheonCalculatorMainWindowClass))

typedef struct _PantheonCalculatorMainWindow PantheonCalculatorMainWindow;
typedef struct _PantheonCalculatorMainWindowClass PantheonCalculatorMainWindowClass;
typedef struct _PantheonCalculatorMainWindowPrivate PantheonCalculatorMainWindowPrivate;

#define PANTHEON_CALCULATOR_TYPE_HISTORY_DIALOG (pantheon_calculator_history_dialog_get_type ())
#define PANTHEON_CALCULATOR_HISTORY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_CALCULATOR_TYPE_HISTORY_DIALOG, PantheonCalculatorHistoryDialog))
#define PANTHEON_CALCULATOR_HISTORY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_CALCULATOR_TYPE_HISTORY_DIALOG, PantheonCalculatorHistoryDialogClass))
#define PANTHEON_CALCULATOR_IS_HISTORY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_CALCULATOR_TYPE_HISTORY_DIALOG))
#define PANTHEON_CALCULATOR_IS_HISTORY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_CALCULATOR_TYPE_HISTORY_DIALOG))
#define PANTHEON_CALCULATOR_HISTORY_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_CALCULATOR_TYPE_HISTORY_DIALOG, PantheonCalculatorHistoryDialogClass))

typedef struct _PantheonCalculatorHistoryDialog PantheonCalculatorHistoryDialog;
typedef struct _PantheonCalculatorHistoryDialogClass PantheonCalculatorHistoryDialogClass;

#define PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION (pantheon_calculator_core_evaluation_get_type ())
#define PANTHEON_CALCULATOR_CORE_EVALUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION, PantheonCalculatorCoreEvaluation))
#define PANTHEON_CALCULATOR_CORE_EVALUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION, PantheonCalculatorCoreEvaluationClass))
#define PANTHEON_CALCULATOR_CORE_IS_EVALUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION))
#define PANTHEON_CALCULATOR_CORE_IS_EVALUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION))
#define PANTHEON_CALCULATOR_CORE_EVALUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION, PantheonCalculatorCoreEvaluationClass))

typedef struct _PantheonCalculatorCoreEvaluation PantheonCalculatorCoreEvaluation;
typedef struct _PantheonCalculatorCoreEvaluationClass PantheonCalculatorCoreEvaluationClass;

#define PANTHEON_CALCULATOR_MAIN_WINDOW_TYPE_HISTORY (pantheon_calculator_main_window_history_get_type ())
typedef struct _PantheonCalculatorMainWindowHistory PantheonCalculatorMainWindowHistory;
enum  {
	PANTHEON_CALCULATOR_MAIN_WINDOW_0_PROPERTY,
	PANTHEON_CALCULATOR_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* pantheon_calculator_main_window_properties[PANTHEON_CALCULATOR_MAIN_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PantheonCalculatorMainWindowGetClipboardTextData PantheonCalculatorMainWindowGetClipboardTextData;

#define PANTHEON_CALCULATOR_CORE_TYPE_OUT_ERROR (pantheon_calculator_core_out_error_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _PantheonCalculatorCoreEvaluationPrivate PantheonCalculatorCoreEvaluationPrivate;

#define PANTHEON_CALCULATOR_CORE_TYPE_SCANNER (pantheon_calculator_core_scanner_get_type ())
#define PANTHEON_CALCULATOR_CORE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScanner))
#define PANTHEON_CALCULATOR_CORE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScannerClass))
#define PANTHEON_CALCULATOR_CORE_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER))
#define PANTHEON_CALCULATOR_CORE_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER))
#define PANTHEON_CALCULATOR_CORE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScannerClass))

typedef struct _PantheonCalculatorCoreScanner PantheonCalculatorCoreScanner;
typedef struct _PantheonCalculatorCoreScannerClass PantheonCalculatorCoreScannerClass;
typedef struct _Block2Data Block2Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define PANTHEON_CALCULATOR_TYPE_BUTTON (pantheon_calculator_button_get_type ())
#define PANTHEON_CALCULATOR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_CALCULATOR_TYPE_BUTTON, PantheonCalculatorButton))
#define PANTHEON_CALCULATOR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_CALCULATOR_TYPE_BUTTON, PantheonCalculatorButtonClass))
#define PANTHEON_CALCULATOR_IS_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_CALCULATOR_TYPE_BUTTON))
#define PANTHEON_CALCULATOR_IS_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_CALCULATOR_TYPE_BUTTON))
#define PANTHEON_CALCULATOR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_CALCULATOR_TYPE_BUTTON, PantheonCalculatorButtonClass))

typedef struct _PantheonCalculatorButton PantheonCalculatorButton;
typedef struct _PantheonCalculatorButtonClass PantheonCalculatorButtonClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _PantheonCalculatorMainWindow {
	GtkApplicationWindow parent_instance;
	PantheonCalculatorMainWindowPrivate * priv;
};

struct _PantheonCalculatorMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _PantheonCalculatorMainWindowHistory {
	gchar* exp;
	gchar* output;
};

struct _PantheonCalculatorMainWindowPrivate {
	GtkRevealer* extended_revealer;
	GtkEntry* entry;
	GtkButton* button_calc;
	GtkButton* button_history;
	GtkButton* button_ans;
	GtkButton* button_del;
	GtkButton* button_mr;
	GtkButton* button_mc;
	GtkButton* button_gt;
	GtkToggleButton* button_extended;
	PantheonCalculatorHistoryDialog* history_dialog;
	GtkInfoBar* infobar;
	GtkLabel* infobar_label;
	PantheonCalculatorCoreEvaluation* eval;
	GList* history;
	gint position;
	gint decimal_places;
	gdouble memory_value;
};

struct _PantheonCalculatorMainWindowGetClipboardTextData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PantheonCalculatorMainWindow* self;
	gchar* result;
	gchar* _tmp0_;
	GtkEntry* _tmp1_;
	GdkClipboard* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* e;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

typedef enum  {
	PANTHEON_CALCULATOR_CORE_OUT_ERROR_EVAL_ERROR,
	PANTHEON_CALCULATOR_CORE_OUT_ERROR_CHECK_ERROR,
	PANTHEON_CALCULATOR_CORE_OUT_ERROR_SHUNTING_ERROR,
	PANTHEON_CALCULATOR_CORE_OUT_ERROR_SCANNER_ERROR
} PantheonCalculatorCoreOUT_ERROR;
#define PANTHEON_CALCULATOR_CORE_OUT_ERROR pantheon_calculator_core_out_error_quark ()

struct _PantheonCalculatorCoreEvaluation {
	GObject parent_instance;
	PantheonCalculatorCoreEvaluationPrivate * priv;
	PantheonCalculatorCoreScanner* scanner;
};

struct _PantheonCalculatorCoreEvaluationClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	PantheonCalculatorMainWindow* self;
	gdouble grand_total;
};

static gint PantheonCalculatorMainWindow_private_offset;
static gpointer pantheon_calculator_main_window_parent_class = NULL;
static GSettings* pantheon_calculator_main_window_settings;
static GSettings* pantheon_calculator_main_window_settings = NULL;

VALA_EXTERN GType pantheon_calculator_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonCalculatorMainWindow, g_object_unref)
VALA_EXTERN GType pantheon_calculator_history_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonCalculatorHistoryDialog, g_object_unref)
VALA_EXTERN GType pantheon_calculator_core_evaluation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonCalculatorCoreEvaluation, g_object_unref)
VALA_EXTERN GType pantheon_calculator_main_window_history_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PantheonCalculatorMainWindowHistory* pantheon_calculator_main_window_history_dup (const PantheonCalculatorMainWindowHistory* self);
VALA_EXTERN void pantheon_calculator_main_window_history_free (PantheonCalculatorMainWindowHistory* self);
VALA_EXTERN void pantheon_calculator_main_window_history_copy (const PantheonCalculatorMainWindowHistory* self,
                                                   PantheonCalculatorMainWindowHistory* dest);
VALA_EXTERN void pantheon_calculator_main_window_history_destroy (PantheonCalculatorMainWindowHistory* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PantheonCalculatorMainWindowHistory, pantheon_calculator_main_window_history_destroy)
static void pantheon_calculator_main_window_action_insert (PantheonCalculatorMainWindow* self,
                                                    GSimpleAction* action,
                                                    GVariant* variant);
static void _pantheon_calculator_main_window_action_insert_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                      GVariant* parameter,
                                                                                      gpointer self);
static void pantheon_calculator_main_window_action_function (PantheonCalculatorMainWindow* self,
                                                      GSimpleAction* action,
                                                      GVariant* variant);
static void _pantheon_calculator_main_window_action_function_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                        GVariant* parameter,
                                                                                        gpointer self);
static void pantheon_calculator_main_window_action_clear (PantheonCalculatorMainWindow* self);
static void _pantheon_calculator_main_window_action_clear_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
static void pantheon_calculator_main_window_undo (PantheonCalculatorMainWindow* self);
static void _pantheon_calculator_main_window_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void pantheon_calculator_main_window_copy (PantheonCalculatorMainWindow* self);
static void _pantheon_calculator_main_window_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void pantheon_calculator_main_window_paste (PantheonCalculatorMainWindow* self);
static void _pantheon_calculator_main_window_paste_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void _pantheon_calculator_main_window_history_free0_ (gpointer var);
static inline void _g_list_free__pantheon_calculator_main_window_history_free0_ (GList* self);
VALA_EXTERN PantheonCalculatorMainWindow* pantheon_calculator_main_window_new (GtkApplication* application);
VALA_EXTERN PantheonCalculatorMainWindow* pantheon_calculator_main_window_construct (GType object_type,
                                                                         GtkApplication* application);
static void pantheon_calculator_main_window_get_clipboard_text (PantheonCalculatorMainWindow* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static gchar* pantheon_calculator_main_window_get_clipboard_text_finish (PantheonCalculatorMainWindow* self,
                                                                  GAsyncResult* _res_);
static void __lambda33_ (PantheonCalculatorMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda33__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void pantheon_calculator_main_window_get_clipboard_text_data_free (gpointer _data);
static gboolean pantheon_calculator_main_window_get_clipboard_text_co (PantheonCalculatorMainWindowGetClipboardTextData* _data_);
static void pantheon_calculator_main_window_get_clipboard_text_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static void pantheon_calculator_main_window_button_calc_clicked (PantheonCalculatorMainWindow* self);
VALA_EXTERN GQuark pantheon_calculator_core_out_error_quark (void);
VALA_EXTERN GType pantheon_calculator_core_out_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* pantheon_calculator_core_evaluation_evaluate (PantheonCalculatorCoreEvaluation* self,
                                                     const gchar* str,
                                                     gint d_places,
                                                     GError** error);
static void pantheon_calculator_main_window_update_history_dialog (PantheonCalculatorMainWindow* self,
                                                            PantheonCalculatorMainWindowHistory* entry);
static void pantheon_calculator_main_window_remove_error (PantheonCalculatorMainWindow* self);
static void pantheon_calculator_main_window_button_reciprocal_clicked (PantheonCalculatorMainWindow* self);
static void pantheon_calculator_main_window_button_del_clicked (PantheonCalculatorMainWindow* self);
static void pantheon_calculator_main_window_button_memory_store_clicked (PantheonCalculatorMainWindow* self);
VALA_EXTERN GType pantheon_calculator_core_scanner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonCalculatorCoreScanner, g_object_unref)
VALA_EXTERN const gchar* pantheon_calculator_core_scanner_get_decimal_symbol (PantheonCalculatorCoreScanner* self);
static void pantheon_calculator_main_window_button_memory_add_clicked (PantheonCalculatorMainWindow* self);
static void pantheon_calculator_main_window_button_memory_subtract_clicked (PantheonCalculatorMainWindow* self);
static void pantheon_calculator_main_window_button_memory_clear_clicked (PantheonCalculatorMainWindow* self);
static void pantheon_calculator_main_window_button_gt_clicked (PantheonCalculatorMainWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda34_ (Block2Data* _data2_,
                  PantheonCalculatorMainWindowHistory* list_entry);
static void ___lambda34__gfunc (gconstpointer data,
                         gpointer self);
static gchar* pantheon_calculator_main_window_number_to_string (PantheonCalculatorMainWindow* self,
                                                         gdouble number);
VALA_EXTERN const gchar* pantheon_calculator_core_scanner_get_separator_symbol (PantheonCalculatorCoreScanner* self);
static void pantheon_calculator_main_window_button_ans_clicked (PantheonCalculatorMainWindow* self);
static void pantheon_calculator_main_window_history_added (PantheonCalculatorMainWindow* self,
                                                    const gchar* input);
static void pantheon_calculator_main_window_toggle_grid (PantheonCalculatorMainWindow* self,
                                                  GtkToggleButton* button);
static void pantheon_calculator_main_window_show_history (PantheonCalculatorMainWindow* self,
                                                   GtkButton* button);
VALA_EXTERN PantheonCalculatorHistoryDialog* pantheon_calculator_history_dialog_new (GList* _history);
VALA_EXTERN PantheonCalculatorHistoryDialog* pantheon_calculator_history_dialog_construct (GType object_type,
                                                                               GList* _history);
static void _pantheon_calculator_main_window_history_added_pantheon_calculator_history_dialog_added (PantheonCalculatorHistoryDialog* _sender,
                                                                                              const gchar* text,
                                                                                              gpointer self);
static void __lambda35_ (PantheonCalculatorMainWindow* self);
static void __lambda36_ (PantheonCalculatorMainWindow* self,
                  PantheonCalculatorMainWindowHistory* entry);
static void ___lambda36__gfunc (gconstpointer data,
                         gpointer self);
static void ___lambda35__pantheon_calculator_history_dialog_clear_history (PantheonCalculatorHistoryDialog* _sender,
                                                                    gpointer self);
static void __lambda37_ (PantheonCalculatorMainWindow* self);
static void ___lambda37__gtk_widget_hide (GtkWidget* _sender,
                                   gpointer self);
VALA_EXTERN void pantheon_calculator_history_dialog_append (PantheonCalculatorHistoryDialog* self,
                                                PantheonCalculatorMainWindowHistory* entry);
static void pantheon_calculator_main_window_replace_text (PantheonCalculatorMainWindow* self,
                                                   const gchar* new_text,
                                                   gint new_text_length,
                                                   gint* position);
static GObject * pantheon_calculator_main_window_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
VALA_EXTERN PantheonCalculatorCoreEvaluation* pantheon_calculator_core_evaluation_new (void);
VALA_EXTERN PantheonCalculatorCoreEvaluation* pantheon_calculator_core_evaluation_construct (GType object_type);
static void _pantheon_calculator_main_window_toggle_grid_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                             gpointer self);
static void _pantheon_calculator_main_window_show_history_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
VALA_EXTERN GType pantheon_calculator_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonCalculatorButton, g_object_unref)
VALA_EXTERN PantheonCalculatorButton* pantheon_calculator_button_new (const gchar* label);
VALA_EXTERN PantheonCalculatorButton* pantheon_calculator_button_construct (GType object_type,
                                                                const gchar* label);
VALA_EXTERN PantheonCalculatorButton* pantheon_calculator_button_new_from_icon_name (const gchar* icon_name);
VALA_EXTERN PantheonCalculatorButton* pantheon_calculator_button_construct_from_icon_name (GType object_type,
                                                                               const gchar* icon_name);
static void _pantheon_calculator_main_window_remove_error_gtk_editable_changed (GtkEditable* _sender,
                                                                         gpointer self);
static void _pantheon_calculator_main_window_button_calc_clicked_gtk_entry_activate (GtkEntry* _sender,
                                                                              gpointer self);
static void _pantheon_calculator_main_window_replace_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                             const gchar* text,
                                                                             gint length,
                                                                             gint* position,
                                                                             gpointer self);
static void _pantheon_calculator_main_window___lambda38_ (PantheonCalculatorMainWindow* self);
static void __pantheon_calculator_main_window___lambda38__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _pantheon_calculator_main_window___lambda39_ (PantheonCalculatorMainWindow* self);
static void __pantheon_calculator_main_window___lambda39__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _pantheon_calculator_main_window___lambda40_ (PantheonCalculatorMainWindow* self);
static void __pantheon_calculator_main_window___lambda40__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _pantheon_calculator_main_window___lambda41_ (PantheonCalculatorMainWindow* self);
static void __pantheon_calculator_main_window___lambda41__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _pantheon_calculator_main_window___lambda42_ (PantheonCalculatorMainWindow* self);
static void __pantheon_calculator_main_window___lambda42__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _pantheon_calculator_main_window___lambda43_ (PantheonCalculatorMainWindow* self);
static void __pantheon_calculator_main_window___lambda43__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _pantheon_calculator_main_window___lambda44_ (PantheonCalculatorMainWindow* self);
static void __pantheon_calculator_main_window___lambda44__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _pantheon_calculator_main_window___lambda45_ (PantheonCalculatorMainWindow* self);
static void __pantheon_calculator_main_window___lambda45__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _pantheon_calculator_main_window___lambda46_ (PantheonCalculatorMainWindow* self);
static void __pantheon_calculator_main_window___lambda46__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _pantheon_calculator_main_window___lambda47_ (PantheonCalculatorMainWindow* self);
static void __pantheon_calculator_main_window___lambda47__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void pantheon_calculator_main_window_finalize (GObject * obj);
static GType pantheon_calculator_main_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GActionEntry PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_ENTRIES[6] = {{PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT, _pantheon_calculator_main_window_action_insert_gsimple_action_activate_callback, "s"}, {PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION, _pantheon_calculator_main_window_action_function_gsimple_action_activate_callback, "s"}, {PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_CLEAR, _pantheon_calculator_main_window_action_clear_gsimple_action_activate_callback}, {PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_UNDO, _pantheon_calculator_main_window_undo_gsimple_action_activate_callback}, {PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_COPY, _pantheon_calculator_main_window_copy_gsimple_action_activate_callback}, {PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PASTE, _pantheon_calculator_main_window_paste_gsimple_action_activate_callback}};

static inline gpointer
pantheon_calculator_main_window_get_instance_private (PantheonCalculatorMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonCalculatorMainWindow_private_offset);
}

static void
_pantheon_calculator_main_window_action_insert_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self)
{
	pantheon_calculator_main_window_action_insert ((PantheonCalculatorMainWindow*) self, action, parameter);
}

static void
_pantheon_calculator_main_window_action_function_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self)
{
	pantheon_calculator_main_window_action_function ((PantheonCalculatorMainWindow*) self, action, parameter);
}

static void
_pantheon_calculator_main_window_action_clear_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	pantheon_calculator_main_window_action_clear ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	pantheon_calculator_main_window_undo ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	pantheon_calculator_main_window_copy ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window_paste_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	pantheon_calculator_main_window_paste ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window_history_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (pantheon_calculator_main_window_history_free (var), NULL));
}

static inline void
_g_list_free__pantheon_calculator_main_window_history_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _pantheon_calculator_main_window_history_free0_);
}

PantheonCalculatorMainWindow*
pantheon_calculator_main_window_construct (GType object_type,
                                           GtkApplication* application)
{
	PantheonCalculatorMainWindow * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	self = (PantheonCalculatorMainWindow*) g_object_new (object_type, "application", application, NULL);
	return self;
}

PantheonCalculatorMainWindow*
pantheon_calculator_main_window_new (GtkApplication* application)
{
	return pantheon_calculator_main_window_construct (PANTHEON_CALCULATOR_TYPE_MAIN_WINDOW, application);
}

static void
pantheon_calculator_main_window_undo (PantheonCalculatorMainWindow* self)
{
	GList* previous_entry = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history;
	_tmp1_ = g_list_last (_tmp0_);
	previous_entry = _tmp1_;
	_tmp2_ = previous_entry;
	if (_tmp2_ != NULL) {
		GtkEntry* _tmp3_;
		GList* _tmp4_;
		gconstpointer _tmp5_;
		const gchar* _tmp6_;
		GList* _tmp7_;
		_tmp3_ = self->priv->entry;
		_tmp4_ = previous_entry;
		_tmp5_ = _tmp4_->data;
		_tmp6_ = (*((PantheonCalculatorMainWindowHistory*) _tmp5_)).exp;
		gtk_editable_set_text ((GtkEditable*) _tmp3_, _tmp6_);
		_tmp7_ = previous_entry;
		self->priv->history = g_list_remove_link (self->priv->history, _tmp7_);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
pantheon_calculator_main_window_copy (PantheonCalculatorMainWindow* self)
{
	gint start = 0;
	gint end = 0;
	GtkEntry* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean text_selected = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	gtk_editable_get_selection_bounds ((GtkEditable*) _tmp0_, &_tmp1_, &_tmp2_);
	start = _tmp1_;
	end = _tmp2_;
	text_selected = (end - start) != 0;
	if (!text_selected) {
		GtkEntry* _tmp3_;
		GdkClipboard* _tmp4_;
		GtkEntry* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = self->priv->entry;
		_tmp4_ = gtk_widget_get_clipboard ((GtkWidget*) _tmp3_);
		_tmp5_ = self->priv->entry;
		_tmp6_ = gtk_editable_get_text ((GtkEditable*) _tmp5_);
		_tmp7_ = _tmp6_;
		gdk_clipboard_set_text (_tmp4_, _tmp7_);
	} else {
		GtkEntry* _tmp8_;
		GdkClipboard* _tmp9_;
		GtkEntry* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp8_ = self->priv->entry;
		_tmp9_ = gtk_widget_get_clipboard ((GtkWidget*) _tmp8_);
		_tmp10_ = self->priv->entry;
		_tmp11_ = gtk_editable_get_text ((GtkEditable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = string_slice (_tmp12_, (glong) start, (glong) end);
		_tmp14_ = _tmp13_;
		gdk_clipboard_set_text (_tmp9_, _tmp14_);
		_g_free0 (_tmp14_);
	}
}

static void
__lambda33_ (PantheonCalculatorMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint start = 0;
	gint end = 0;
	GtkEntry* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* before = NULL;
	GtkEntry* _tmp5_;
	gchar* _tmp6_;
	gchar* after = NULL;
	GtkEntry* _tmp7_;
	gchar* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkEntry* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	g_return_if_fail (res != NULL);
	_tmp0_ = pantheon_calculator_main_window_get_clipboard_text_finish (self, res);
	text = _tmp0_;
	_tmp1_ = text;
	if (_tmp1_ == NULL) {
		_g_free0 (text);
		return;
	}
	_tmp2_ = self->priv->entry;
	gtk_editable_get_selection_bounds ((GtkEditable*) _tmp2_, &_tmp3_, &_tmp4_);
	start = _tmp3_;
	end = _tmp4_;
	_tmp5_ = self->priv->entry;
	_tmp6_ = gtk_editable_get_chars ((GtkEditable*) _tmp5_, 0, start);
	before = _tmp6_;
	_tmp7_ = self->priv->entry;
	_tmp8_ = gtk_editable_get_chars ((GtkEditable*) _tmp7_, end, -1);
	after = _tmp8_;
	_tmp9_ = self->priv->entry;
	_tmp10_ = before;
	_tmp11_ = text;
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = after;
	_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	gtk_editable_set_text ((GtkEditable*) _tmp9_, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_tmp17_ = self->priv->entry;
	_tmp18_ = before;
	_tmp19_ = text;
	gtk_editable_set_position ((GtkEditable*) _tmp17_, g_utf8_strlen (_tmp18_, (gssize) -1) + g_utf8_strlen (_tmp19_, (gssize) -1));
	_g_free0 (after);
	_g_free0 (before);
	_g_free0 (text);
}

static void
___lambda33__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda33_ ((PantheonCalculatorMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
pantheon_calculator_main_window_paste (PantheonCalculatorMainWindow* self)
{
	g_return_if_fail (self != NULL);
	pantheon_calculator_main_window_get_clipboard_text (self, ___lambda33__gasync_ready_callback, g_object_ref (self));
}

static void
pantheon_calculator_main_window_get_clipboard_text_data_free (gpointer _data)
{
	PantheonCalculatorMainWindowGetClipboardTextData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PantheonCalculatorMainWindowGetClipboardTextData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pantheon_calculator_main_window_get_clipboard_text (PantheonCalculatorMainWindow* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	PantheonCalculatorMainWindowGetClipboardTextData* _data_;
	PantheonCalculatorMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PantheonCalculatorMainWindowGetClipboardTextData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pantheon_calculator_main_window_get_clipboard_text_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pantheon_calculator_main_window_get_clipboard_text_co (_data_);
}

static gchar*
pantheon_calculator_main_window_get_clipboard_text_finish (PantheonCalculatorMainWindow* self,
                                                           GAsyncResult* _res_)
{
	gchar* result;
	PantheonCalculatorMainWindowGetClipboardTextData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
pantheon_calculator_main_window_get_clipboard_text_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	PantheonCalculatorMainWindowGetClipboardTextData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pantheon_calculator_main_window_get_clipboard_text_co (_data_);
}

static gboolean
pantheon_calculator_main_window_get_clipboard_text_co (PantheonCalculatorMainWindowGetClipboardTextData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = _data_->self->priv->entry;
		_data_->_tmp2_ = gtk_widget_get_clipboard ((GtkWidget*) _data_->_tmp1_);
		_data_->_state_ = 1;
		gdk_clipboard_read_text_async (_data_->_tmp2_, NULL, pantheon_calculator_main_window_get_clipboard_text_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = gdk_clipboard_read_text_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_data_->result = _data_->_tmp4_;
		_g_free0 (_data_->_tmp0_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_warning ("MainWindow.vala:547: %s", _data_->_tmp6_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pantheon_calculator_main_window_action_insert (PantheonCalculatorMainWindow* self,
                                               GSimpleAction* action,
                                               GVariant* variant)
{
	gchar* token = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint new_position = 0;
	GtkEntry* _tmp2_;
	gint selection_start = 0;
	gint selection_end = 0;
	gint selection_length = 0;
	gboolean is_text_selected = FALSE;
	GtkEntry* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gint cursor_position = 0;
	GtkEntry* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GtkEntry* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GtkEntry* _tmp14_;
	GtkEntry* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	token = _tmp1_;
	_tmp2_ = self->priv->entry;
	new_position = gtk_editable_get_position ((GtkEditable*) _tmp2_);
	_tmp3_ = self->priv->entry;
	_tmp6_ = gtk_editable_get_selection_bounds ((GtkEditable*) _tmp3_, &_tmp4_, &_tmp5_);
	selection_start = _tmp4_;
	selection_end = _tmp5_;
	is_text_selected = _tmp6_;
	if (is_text_selected) {
		GtkEntry* _tmp7_;
		new_position = selection_end;
		_tmp7_ = self->priv->entry;
		gtk_editable_delete_selection ((GtkEditable*) _tmp7_);
		selection_length = selection_end - selection_start;
		new_position -= selection_length;
	}
	_tmp8_ = self->priv->entry;
	g_object_get ((GtkEditable*) _tmp8_, "cursor-position", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	cursor_position = _tmp10_;
	_tmp11_ = self->priv->entry;
	_tmp12_ = token;
	gtk_editable_insert_text ((GtkEditable*) _tmp11_, _tmp12_, -1, &cursor_position);
	_tmp13_ = token;
	new_position += g_utf8_strlen (_tmp13_, (gssize) -1);
	_tmp14_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->entry;
	gtk_editable_set_position ((GtkEditable*) _tmp15_, new_position);
	_g_free0 (token);
}

static void
pantheon_calculator_main_window_action_function (PantheonCalculatorMainWindow* self,
                                                 GSimpleAction* action,
                                                 GVariant* variant)
{
	gchar* token = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint selection_start = 0;
	gint selection_end = 0;
	GtkEntry* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	token = _tmp1_;
	selection_start = -1;
	selection_end = -1;
	_tmp2_ = self->priv->entry;
	_tmp5_ = gtk_editable_get_selection_bounds ((GtkEditable*) _tmp2_, &_tmp3_, &_tmp4_);
	selection_start = _tmp3_;
	selection_end = _tmp4_;
	if (_tmp5_) {
		gint new_position = 0;
		gchar* selected_text = NULL;
		GtkEntry* _tmp6_;
		gchar* _tmp7_;
		gchar* function_call = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GtkEntry* _tmp16_;
		GtkEntry* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		GtkEntry* _tmp20_;
		GtkEntry* _tmp21_;
		new_position = selection_start;
		_tmp6_ = self->priv->entry;
		_tmp7_ = gtk_editable_get_chars ((GtkEditable*) _tmp6_, selection_start, selection_end);
		selected_text = _tmp7_;
		_tmp8_ = token;
		_tmp9_ = g_strconcat (_tmp8_, "(", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = selected_text;
		_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, ")", NULL);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp10_);
		function_call = _tmp15_;
		_tmp16_ = self->priv->entry;
		g_signal_emit_by_name ((GtkEditable*) _tmp16_, "delete-text", selection_start, selection_end);
		_tmp17_ = self->priv->entry;
		_tmp18_ = function_call;
		g_signal_emit_by_name ((GtkEditable*) _tmp17_, "insert-text", _tmp18_, -1, &selection_start);
		_tmp19_ = function_call;
		new_position += g_utf8_strlen (_tmp19_, (gssize) -1);
		_tmp20_ = self->priv->entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp20_);
		_tmp21_ = self->priv->entry;
		gtk_editable_set_position ((GtkEditable*) _tmp21_, new_position);
		_g_free0 (function_call);
		_g_free0 (selected_text);
	} else {
		g_action_group_activate_action ((GActionGroup*) self, PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT, variant);
	}
	_g_free0 (token);
}

static gpointer
_pantheon_calculator_main_window_history_dup0 (gpointer self)
{
	return self ? pantheon_calculator_main_window_history_dup (self) : NULL;
}

static void
pantheon_calculator_main_window_button_calc_clicked (PantheonCalculatorMainWindow* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	GtkEntry* _tmp32_;
	GtkEntry* _tmp33_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	self->priv->position = gtk_editable_get_position ((GtkEditable*) _tmp0_);
	_tmp1_ = self->priv->entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	if (g_strcmp0 (_tmp2_, "") != 0) {
		{
			gchar* output = NULL;
			PantheonCalculatorCoreEvaluation* _tmp3_;
			GtkEntry* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			GtkEntry* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp3_ = self->priv->eval;
			_tmp4_ = self->priv->entry;
			_tmp5_ = gtk_editable_get_text ((GtkEditable*) _tmp4_);
			_tmp6_ = pantheon_calculator_core_evaluation_evaluate (_tmp3_, _tmp5_, self->priv->decimal_places, &_inner_error0_);
			output = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_OUT_ERROR) {
					goto __catch0_pantheon_calculator_core_out_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp7_ = self->priv->entry;
			_tmp8_ = gtk_editable_get_text ((GtkEditable*) _tmp7_);
			_tmp9_ = output;
			if (g_strcmp0 (_tmp8_, _tmp9_) != 0) {
				PantheonCalculatorMainWindowHistory history_entry = {0};
				GtkEntry* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				PantheonCalculatorMainWindowHistory _tmp15_ = {0};
				PantheonCalculatorMainWindowHistory _tmp16_;
				PantheonCalculatorMainWindowHistory _tmp17_;
				PantheonCalculatorMainWindowHistory* _tmp18_;
				PantheonCalculatorMainWindowHistory _tmp19_;
				GtkEntry* _tmp20_;
				const gchar* _tmp21_;
				GtkButton* _tmp22_;
				GtkButton* _tmp23_;
				GtkButton* _tmp24_;
				const gchar* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				_tmp10_ = self->priv->entry;
				_tmp11_ = gtk_editable_get_text ((GtkEditable*) _tmp10_);
				_tmp12_ = g_strdup (_tmp11_);
				_tmp13_ = output;
				_tmp14_ = g_strdup (_tmp13_);
				memset (&_tmp15_, 0, sizeof (PantheonCalculatorMainWindowHistory));
				_g_free0 (_tmp15_.exp);
				_tmp15_.exp = _tmp12_;
				_g_free0 (_tmp15_.output);
				_tmp15_.output = _tmp14_;
				history_entry = _tmp15_;
				_tmp16_ = history_entry;
				_tmp17_ = _tmp16_;
				_tmp18_ = _pantheon_calculator_main_window_history_dup0 (&_tmp17_);
				self->priv->history = g_list_append (self->priv->history, _tmp18_);
				_tmp19_ = history_entry;
				pantheon_calculator_main_window_update_history_dialog (self, &_tmp19_);
				_tmp20_ = self->priv->entry;
				_tmp21_ = output;
				gtk_editable_set_text ((GtkEditable*) _tmp20_, _tmp21_);
				_tmp22_ = self->priv->button_history;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, TRUE);
				_tmp23_ = self->priv->button_ans;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, TRUE);
				_tmp24_ = self->priv->button_gt;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, TRUE);
				_tmp25_ = output;
				_tmp26_ = strlen (_tmp25_);
				_tmp27_ = _tmp26_;
				self->priv->position = _tmp27_;
				pantheon_calculator_main_window_remove_error (self);
				pantheon_calculator_main_window_history_destroy (&history_entry);
			}
			_g_free0 (output);
		}
		goto __finally0;
		__catch0_pantheon_calculator_core_out_error:
		{
			GError* e = NULL;
			GtkLabel* _tmp28_;
			GError* _tmp29_;
			const gchar* _tmp30_;
			GtkInfoBar* _tmp31_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp28_ = self->priv->infobar_label;
			_tmp29_ = e;
			_tmp30_ = _tmp29_->message;
			gtk_label_set_label (_tmp28_, _tmp30_);
			_tmp31_ = self->priv->infobar;
			gtk_info_bar_set_revealed (_tmp31_, TRUE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		pantheon_calculator_main_window_remove_error (self);
	}
	_tmp32_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->entry;
	gtk_editable_set_position ((GtkEditable*) _tmp33_, self->priv->position);
}

static void
pantheon_calculator_main_window_button_reciprocal_clicked (PantheonCalculatorMainWindow* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = self->priv->entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = g_strconcat ("1/(", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, ")", NULL);
	_tmp6_ = _tmp5_;
	gtk_editable_set_text ((GtkEditable*) _tmp0_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	pantheon_calculator_main_window_button_calc_clicked (self);
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
pantheon_calculator_main_window_button_del_clicked (PantheonCalculatorMainWindow* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkEntry* _tmp19_;
	GtkEntry* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	self->priv->position = gtk_editable_get_position ((GtkEditable*) _tmp0_);
	_tmp1_ = self->priv->entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		gchar* new_text = NULL;
		gchar* _tmp5_;
		gint index = 0;
		gunichar c = 0U;
		GList* news = NULL;
		GList* _tmp12_;
		GtkEntry* _tmp17_;
		const gchar* _tmp18_;
		_tmp5_ = g_strdup ("");
		new_text = _tmp5_;
		index = 0;
		news = NULL;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					GtkEntry* _tmp8_;
					const gchar* _tmp9_;
					gunichar _tmp10_ = 0U;
					gboolean _tmp11_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = self->priv->entry;
					_tmp9_ = gtk_editable_get_text ((GtkEditable*) _tmp8_);
					_tmp11_ = string_get_next_char (_tmp9_, &index, &_tmp10_);
					c = _tmp10_;
					if (!_tmp11_) {
						break;
					}
					if ((i + 1) != self->priv->position) {
						news = g_list_append (news, (gpointer) ((gintptr) c));
					}
				}
			}
		}
		_tmp12_ = news;
		{
			GList* u_collection = NULL;
			GList* u_it = NULL;
			u_collection = _tmp12_;
			for (u_it = u_collection; u_it != NULL; u_it = u_it->next) {
				gunichar u = 0U;
				u = (gunichar) ((gintptr) u_it->data);
				{
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp13_ = new_text;
					_tmp14_ = g_unichar_to_string (u);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strconcat (_tmp13_, _tmp15_, NULL);
					_g_free0 (new_text);
					new_text = _tmp16_;
					_g_free0 (_tmp15_);
				}
			}
		}
		_tmp17_ = self->priv->entry;
		_tmp18_ = new_text;
		gtk_editable_set_text ((GtkEditable*) _tmp17_, _tmp18_);
		(news == NULL) ? NULL : (news = (g_list_free (news), NULL));
		_g_free0 (new_text);
	}
	_tmp19_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->entry;
	gtk_editable_set_position ((GtkEditable*) _tmp20_, self->priv->position - 1);
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
pantheon_calculator_main_window_button_memory_store_clicked (PantheonCalculatorMainWindow* self)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		{
			gchar* output = NULL;
			PantheonCalculatorCoreEvaluation* _tmp2_;
			GtkEntry* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			PantheonCalculatorCoreEvaluation* _tmp7_;
			PantheonCalculatorCoreScanner* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GtkButton* _tmp13_;
			GtkButton* _tmp14_;
			_tmp2_ = self->priv->eval;
			_tmp3_ = self->priv->entry;
			_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
			_tmp5_ = pantheon_calculator_core_evaluation_evaluate (_tmp2_, _tmp4_, self->priv->decimal_places, &_inner_error0_);
			output = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_OUT_ERROR) {
					goto __catch0_pantheon_calculator_core_out_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp6_ = output;
			_tmp7_ = self->priv->eval;
			_tmp8_ = _tmp7_->scanner;
			_tmp9_ = pantheon_calculator_core_scanner_get_decimal_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = string_replace (_tmp6_, _tmp10_, ".");
			_tmp12_ = _tmp11_;
			self->priv->memory_value = double_parse (_tmp12_);
			_g_free0 (_tmp12_);
			_tmp13_ = self->priv->button_mr;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, TRUE);
			_tmp14_ = self->priv->button_mc;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
			_g_free0 (output);
		}
		goto __finally0;
		__catch0_pantheon_calculator_core_out_error:
		{
			GError* e = NULL;
			GtkLabel* _tmp15_;
			GError* _tmp16_;
			const gchar* _tmp17_;
			GtkInfoBar* _tmp18_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = self->priv->infobar_label;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			gtk_label_set_label (_tmp15_, _tmp17_);
			_tmp18_ = self->priv->infobar;
			gtk_info_bar_set_revealed (_tmp18_, TRUE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
pantheon_calculator_main_window_button_memory_add_clicked (PantheonCalculatorMainWindow* self)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		{
			gchar* output = NULL;
			PantheonCalculatorCoreEvaluation* _tmp2_;
			GtkEntry* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			PantheonCalculatorCoreEvaluation* _tmp7_;
			PantheonCalculatorCoreScanner* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp2_ = self->priv->eval;
			_tmp3_ = self->priv->entry;
			_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
			_tmp5_ = pantheon_calculator_core_evaluation_evaluate (_tmp2_, _tmp4_, self->priv->decimal_places, &_inner_error0_);
			output = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_OUT_ERROR) {
					goto __catch0_pantheon_calculator_core_out_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp6_ = output;
			_tmp7_ = self->priv->eval;
			_tmp8_ = _tmp7_->scanner;
			_tmp9_ = pantheon_calculator_core_scanner_get_decimal_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = string_replace (_tmp6_, _tmp10_, ".");
			_tmp12_ = _tmp11_;
			self->priv->memory_value = self->priv->memory_value + double_parse (_tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (output);
		}
		goto __finally0;
		__catch0_pantheon_calculator_core_out_error:
		{
			GError* e = NULL;
			GtkLabel* _tmp13_;
			GError* _tmp14_;
			const gchar* _tmp15_;
			GtkInfoBar* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = self->priv->infobar_label;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			gtk_label_set_label (_tmp13_, _tmp15_);
			_tmp16_ = self->priv->infobar;
			gtk_info_bar_set_revealed (_tmp16_, TRUE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
pantheon_calculator_main_window_button_memory_subtract_clicked (PantheonCalculatorMainWindow* self)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		{
			gchar* output = NULL;
			PantheonCalculatorCoreEvaluation* _tmp2_;
			GtkEntry* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			PantheonCalculatorCoreEvaluation* _tmp7_;
			PantheonCalculatorCoreScanner* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp2_ = self->priv->eval;
			_tmp3_ = self->priv->entry;
			_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
			_tmp5_ = pantheon_calculator_core_evaluation_evaluate (_tmp2_, _tmp4_, self->priv->decimal_places, &_inner_error0_);
			output = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_OUT_ERROR) {
					goto __catch0_pantheon_calculator_core_out_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp6_ = output;
			_tmp7_ = self->priv->eval;
			_tmp8_ = _tmp7_->scanner;
			_tmp9_ = pantheon_calculator_core_scanner_get_decimal_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = string_replace (_tmp6_, _tmp10_, ".");
			_tmp12_ = _tmp11_;
			self->priv->memory_value = self->priv->memory_value - double_parse (_tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (output);
		}
		goto __finally0;
		__catch0_pantheon_calculator_core_out_error:
		{
			GError* e = NULL;
			GtkLabel* _tmp13_;
			GError* _tmp14_;
			const gchar* _tmp15_;
			GtkInfoBar* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = self->priv->infobar_label;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			gtk_label_set_label (_tmp13_, _tmp15_);
			_tmp16_ = self->priv->infobar;
			gtk_info_bar_set_revealed (_tmp16_, TRUE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
pantheon_calculator_main_window_button_memory_clear_clicked (PantheonCalculatorMainWindow* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->memory_value = (gdouble) 0;
	_tmp0_ = self->priv->button_mr;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->button_mc;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PantheonCalculatorMainWindow* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda34_ (Block2Data* _data2_,
             PantheonCalculatorMainWindowHistory* list_entry)
{
	PantheonCalculatorMainWindow* self;
	const gchar* _tmp0_;
	PantheonCalculatorCoreEvaluation* _tmp1_;
	PantheonCalculatorCoreScanner* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	self = _data2_->self;
	_tmp0_ = (*list_entry).output;
	_tmp1_ = self->priv->eval;
	_tmp2_ = _tmp1_->scanner;
	_tmp3_ = pantheon_calculator_core_scanner_get_decimal_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp0_, _tmp4_, ".");
	_tmp6_ = _tmp5_;
	_data2_->grand_total += double_parse (_tmp6_);
	_g_free0 (_tmp6_);
}

static void
___lambda34__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda34_ (self, (PantheonCalculatorMainWindowHistory*) data);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static void
pantheon_calculator_main_window_button_gt_clicked (PantheonCalculatorMainWindow* self)
{
	Block2Data* _data2_;
	GList* _tmp0_;
	GtkEntry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkEntry* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	pantheon_calculator_main_window_action_clear (self);
	_data2_->grand_total = (gdouble) 0;
	_tmp0_ = self->priv->history;
	g_list_foreach (_tmp0_, ___lambda34__gfunc, _data2_);
	_tmp1_ = self->priv->entry;
	_tmp2_ = pantheon_calculator_main_window_number_to_string (self, _data2_->grand_total);
	_tmp3_ = _tmp2_;
	gtk_editable_set_text ((GtkEditable*) _tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->entry;
	_tmp5_ = double_to_string (_data2_->grand_total);
	_tmp6_ = _tmp5_;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_editable_set_position ((GtkEditable*) _tmp4_, _tmp8_);
	_g_free0 (_tmp6_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
pantheon_calculator_main_window_number_to_string (PantheonCalculatorMainWindow* self,
                                                  gdouble number)
{
	gchar* shortened_number = NULL;
	gchar* _tmp0_;
	gchar* number_localized = NULL;
	const gchar* _tmp1_;
	PantheonCalculatorCoreEvaluation* _tmp2_;
	PantheonCalculatorCoreScanner* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp10_;
	PantheonCalculatorCoreEvaluation* _tmp11_;
	PantheonCalculatorCoreScanner* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GString* builder = NULL;
	const gchar* _tmp17_;
	GString* _tmp18_;
	gint decimal_pos = 0;
	const gchar* _tmp19_;
	PantheonCalculatorCoreEvaluation* _tmp20_;
	PantheonCalculatorCoreScanner* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gint end_position = 0;
	const gchar* _tmp27_;
	GString* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%.9f", number);
	shortened_number = _tmp0_;
	_tmp1_ = shortened_number;
	_tmp2_ = self->priv->eval;
	_tmp3_ = _tmp2_->scanner;
	_tmp4_ = pantheon_calculator_core_scanner_get_decimal_symbol (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_replace (_tmp1_, ".", _tmp5_);
	number_localized = _tmp6_;
	while (TRUE) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = number_localized;
		if (!g_str_has_suffix (_tmp7_, "0")) {
			break;
		}
		_tmp8_ = number_localized;
		_tmp9_ = string_slice (_tmp8_, (glong) 0, (glong) -1);
		_g_free0 (number_localized);
		number_localized = _tmp9_;
	}
	_tmp10_ = number_localized;
	_tmp11_ = self->priv->eval;
	_tmp12_ = _tmp11_->scanner;
	_tmp13_ = pantheon_calculator_core_scanner_get_decimal_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	if (g_str_has_suffix (_tmp10_, _tmp14_)) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = number_localized;
		_tmp16_ = string_slice (_tmp15_, (glong) 0, (glong) -1);
		_g_free0 (number_localized);
		number_localized = _tmp16_;
	}
	_tmp17_ = number_localized;
	_tmp18_ = g_string_new (_tmp17_);
	builder = _tmp18_;
	_tmp19_ = number_localized;
	_tmp20_ = self->priv->eval;
	_tmp21_ = _tmp20_->scanner;
	_tmp22_ = pantheon_calculator_core_scanner_get_decimal_symbol (_tmp21_);
	_tmp23_ = _tmp22_;
	decimal_pos = string_last_index_of (_tmp19_, _tmp23_, 0);
	if (decimal_pos == -1) {
		const gchar* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp24_ = number_localized;
		_tmp25_ = strlen (_tmp24_);
		_tmp26_ = _tmp25_;
		decimal_pos = _tmp26_;
	}
	end_position = 0;
	_tmp27_ = number_localized;
	if (g_str_has_prefix (_tmp27_, "-")) {
		end_position = 1;
	}
	{
		gint i = 0;
		i = decimal_pos - 3;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				GString* _tmp29_;
				PantheonCalculatorCoreEvaluation* _tmp30_;
				PantheonCalculatorCoreScanner* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				if (!_tmp28_) {
					i -= 3;
				}
				_tmp28_ = FALSE;
				if (!(i > end_position)) {
					break;
				}
				_tmp29_ = builder;
				_tmp30_ = self->priv->eval;
				_tmp31_ = _tmp30_->scanner;
				_tmp32_ = pantheon_calculator_core_scanner_get_separator_symbol (_tmp31_);
				_tmp33_ = _tmp32_;
				g_string_insert (_tmp29_, (gssize) i, _tmp33_);
			}
		}
	}
	_tmp34_ = builder;
	_tmp35_ = _tmp34_->str;
	_tmp36_ = g_strdup (_tmp35_);
	result = _tmp36_;
	_g_string_free0 (builder);
	_g_free0 (number_localized);
	_g_free0 (shortened_number);
	return result;
}

static void
pantheon_calculator_main_window_action_clear (PantheonCalculatorMainWindow* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->position = 0;
	_tmp0_ = self->priv->entry;
	gtk_editable_set_text ((GtkEditable*) _tmp0_, "");
	_tmp1_ = self->priv->entry;
	gtk_root_set_focus ((GtkRoot*) self, (GtkWidget*) _tmp1_);
	pantheon_calculator_main_window_remove_error (self);
	_tmp2_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->entry;
	gtk_editable_set_position ((GtkEditable*) _tmp3_, self->priv->position);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
pantheon_calculator_main_window_button_ans_clicked (PantheonCalculatorMainWindow* self)
{
	GtkEntry* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	self->priv->position = gtk_editable_get_position ((GtkEditable*) _tmp0_);
	_tmp1_ = self->priv->history;
	if (((gint) g_list_length (_tmp1_)) > 0) {
		GList* last = NULL;
		GList* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		gconstpointer _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp2_ = self->priv->history;
		_tmp3_ = g_list_last (_tmp2_);
		last = _tmp3_;
		_tmp4_ = last;
		_tmp5_ = _tmp4_->data;
		_tmp6_ = (*((PantheonCalculatorMainWindowHistory*) _tmp5_)).output;
		_tmp7_ = string_to_string (_tmp6_);
		pantheon_calculator_main_window_history_added (self, _tmp7_);
	}
}

static void
pantheon_calculator_main_window_toggle_grid (PantheonCalculatorMainWindow* self,
                                             GtkToggleButton* button)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->entry;
	self->priv->position = gtk_editable_get_position ((GtkEditable*) _tmp0_);
	if (gtk_toggle_button_get_active (button)) {
		GtkRevealer* _tmp1_;
		gtk_button_set_icon_name ((GtkButton*) button, "pane-show-symbolic");
		gtk_widget_set_tooltip_text ((GtkWidget*) button, _ ("Hide extended functionality"));
		_tmp1_ = self->priv->extended_revealer;
		gtk_revealer_set_reveal_child (_tmp1_, TRUE);
	} else {
		GtkRevealer* _tmp2_;
		gtk_button_set_icon_name ((GtkButton*) button, "pane-hide-symbolic");
		gtk_widget_set_tooltip_text ((GtkWidget*) button, _ ("Show extended functionality"));
		_tmp2_ = self->priv->extended_revealer;
		gtk_revealer_set_reveal_child (_tmp2_, FALSE);
	}
	_tmp3_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->entry;
	gtk_editable_set_position ((GtkEditable*) _tmp4_, self->priv->position);
}

static void
_pantheon_calculator_main_window_history_added_pantheon_calculator_history_dialog_added (PantheonCalculatorHistoryDialog* _sender,
                                                                                         const gchar* text,
                                                                                         gpointer self)
{
	pantheon_calculator_main_window_history_added ((PantheonCalculatorMainWindow*) self, text);
}

static void
__lambda36_ (PantheonCalculatorMainWindow* self,
             PantheonCalculatorMainWindowHistory* entry)
{
	GList* _tmp0_;
	GList* _tmp1_;
	_tmp0_ = self->priv->history;
	_tmp1_ = g_list_find (_tmp0_, entry);
	self->priv->history = g_list_delete_link (self->priv->history, _tmp1_);
}

static void
___lambda36__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda36_ ((PantheonCalculatorMainWindow*) self, (PantheonCalculatorMainWindowHistory*) data);
}

static void
__lambda35_ (PantheonCalculatorMainWindow* self)
{
	GList* _tmp0_;
	GtkButton* _tmp1_;
	_tmp0_ = self->priv->history;
	g_list_foreach (_tmp0_, ___lambda36__gfunc, self);
	_tmp1_ = self->priv->button_ans;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
}

static void
___lambda35__pantheon_calculator_history_dialog_clear_history (PantheonCalculatorHistoryDialog* _sender,
                                                               gpointer self)
{
	__lambda35_ ((PantheonCalculatorMainWindow*) self);
}

static void
__lambda37_ (PantheonCalculatorMainWindow* self)
{
	GtkButton* _tmp0_;
	GList* _tmp1_;
	_tmp0_ = self->priv->button_history;
	_tmp1_ = self->priv->history;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_ != NULL);
}

static void
___lambda37__gtk_widget_hide (GtkWidget* _sender,
                              gpointer self)
{
	__lambda37_ ((PantheonCalculatorMainWindow*) self);
}

static void
pantheon_calculator_main_window_show_history (PantheonCalculatorMainWindow* self,
                                              GtkButton* button)
{
	GtkEntry* _tmp0_;
	GList* _tmp1_;
	GtkWindow* _tmp2_;
	PantheonCalculatorHistoryDialog* _tmp3_ = NULL;
	PantheonCalculatorHistoryDialog* _tmp4_;
	PantheonCalculatorHistoryDialog* _tmp5_;
	PantheonCalculatorHistoryDialog* _tmp6_;
	PantheonCalculatorHistoryDialog* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->entry;
	self->priv->position = gtk_editable_get_position ((GtkEditable*) _tmp0_);
	_tmp1_ = self->priv->history;
	_tmp2_ = _g_object_ref0 ((GtkWindow*) self);
	_tmp3_ = pantheon_calculator_history_dialog_new (_tmp1_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->history_dialog);
	self->priv->history_dialog = _tmp3_;
	_tmp4_ = self->priv->history_dialog;
	gtk_window_present ((GtkWindow*) _tmp4_);
	_tmp5_ = self->priv->history_dialog;
	g_signal_connect_object (_tmp5_, "added", (GCallback) _pantheon_calculator_main_window_history_added_pantheon_calculator_history_dialog_added, self, 0);
	_tmp6_ = self->priv->history_dialog;
	g_signal_connect_object (_tmp6_, "clear-history", (GCallback) ___lambda35__pantheon_calculator_history_dialog_clear_history, self, 0);
	_tmp7_ = self->priv->history_dialog;
	g_signal_connect_object ((GtkWidget*) _tmp7_, "hide", (GCallback) ___lambda37__gtk_widget_hide, self, 0);
}

static void
pantheon_calculator_main_window_update_history_dialog (PantheonCalculatorMainWindow* self,
                                                       PantheonCalculatorMainWindowHistory* entry)
{
	PantheonCalculatorHistoryDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->history_dialog;
	if (_tmp0_ != NULL) {
		PantheonCalculatorHistoryDialog* _tmp1_;
		PantheonCalculatorMainWindowHistory _tmp2_;
		_tmp1_ = self->priv->history_dialog;
		_tmp2_ = *entry;
		pantheon_calculator_history_dialog_append (_tmp1_, &_tmp2_);
	}
}

static void
pantheon_calculator_main_window_history_added (PantheonCalculatorMainWindow* self,
                                               const gchar* input)
{
	gint cursor_position = 0;
	GtkEntry* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkEntry* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	_tmp0_ = self->priv->entry;
	g_object_get ((GtkEditable*) _tmp0_, "cursor-position", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	cursor_position = _tmp2_;
	_tmp3_ = self->priv->entry;
	gtk_editable_insert_text ((GtkEditable*) _tmp3_, input, -1, &cursor_position);
	_tmp4_ = strlen (input);
	_tmp5_ = _tmp4_;
	self->priv->position = self->priv->position + _tmp5_;
	_tmp6_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->entry;
	gtk_editable_set_position ((GtkEditable*) _tmp7_, self->priv->position);
}

static void
pantheon_calculator_main_window_remove_error (PantheonCalculatorMainWindow* self)
{
	GtkInfoBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->infobar;
	gtk_info_bar_set_revealed (_tmp0_, FALSE);
}

static void
pantheon_calculator_main_window_replace_text (PantheonCalculatorMainWindow* self,
                                              const gchar* new_text,
                                              gint new_text_length,
                                              gint* position)
{
	gchar* replacement_text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = g_strdup ("");
	replacement_text = _tmp0_;
	_tmp1_ = new_text;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string (".")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string (","))))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = nl_langinfo (RADIXCHAR);
				_tmp5_ = g_strdup (_tmp4_);
				_g_free0 (replacement_text);
				replacement_text = _tmp5_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("/")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("÷");
				_g_free0 (replacement_text);
				replacement_text = _tmp6_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("*")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("×");
				_g_free0 (replacement_text);
				replacement_text = _tmp7_;
				break;
			}
		}
	}
	_tmp9_ = replacement_text;
	if (g_strcmp0 (_tmp9_, "") != 0) {
		const gchar* _tmp10_;
		_tmp10_ = replacement_text;
		_tmp8_ = g_strcmp0 (_tmp10_, new_text) != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GtkEntry* _tmp11_;
		const gchar* _tmp12_;
		GtkEntry* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		const gchar* _tmp16_;
		GtkEntry* _tmp17_;
		GtkEditable* _tmp18_;
		_tmp11_ = self->priv->entry;
		_tmp12_ = replacement_text;
		_tmp13_ = self->priv->entry;
		g_object_get ((GtkEditable*) _tmp13_, "cursor-position", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = replacement_text;
		gtk_editable_insert_text ((GtkEditable*) _tmp11_, _tmp12_, _tmp15_ + g_utf8_strlen (_tmp16_, (gssize) -1), position);
		_tmp17_ = self->priv->entry;
		_tmp18_ = gtk_editable_get_delegate ((GtkEditable*) _tmp17_);
		g_signal_stop_emission_by_name ((void*) _tmp18_, "insert-text");
	}
	_g_free0 (replacement_text);
}

void
pantheon_calculator_main_window_history_copy (const PantheonCalculatorMainWindowHistory* self,
                                              PantheonCalculatorMainWindowHistory* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).exp;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).exp);
	(*dest).exp = _tmp1_;
	_tmp2_ = (*self).output;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).output);
	(*dest).output = _tmp3_;
}

void
pantheon_calculator_main_window_history_destroy (PantheonCalculatorMainWindowHistory* self)
{
	_g_free0 ((*self).exp);
	_g_free0 ((*self).output);
}

PantheonCalculatorMainWindowHistory*
pantheon_calculator_main_window_history_dup (const PantheonCalculatorMainWindowHistory* self)
{
	PantheonCalculatorMainWindowHistory* dup;
	dup = g_new0 (PantheonCalculatorMainWindowHistory, 1);
	pantheon_calculator_main_window_history_copy (self, dup);
	return dup;
}

void
pantheon_calculator_main_window_history_free (PantheonCalculatorMainWindowHistory* self)
{
	pantheon_calculator_main_window_history_destroy (self);
	g_free (self);
}

static GType
pantheon_calculator_main_window_history_get_type_once (void)
{
	GType pantheon_calculator_main_window_history_type_id;
	pantheon_calculator_main_window_history_type_id = g_boxed_type_register_static ("PantheonCalculatorMainWindowHistory", (GBoxedCopyFunc) pantheon_calculator_main_window_history_dup, (GBoxedFreeFunc) pantheon_calculator_main_window_history_free);
	return pantheon_calculator_main_window_history_type_id;
}

GType
pantheon_calculator_main_window_history_get_type (void)
{
	static volatile gsize pantheon_calculator_main_window_history_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_main_window_history_type_id__once)) {
		GType pantheon_calculator_main_window_history_type_id;
		pantheon_calculator_main_window_history_type_id = pantheon_calculator_main_window_history_get_type_once ();
		g_once_init_leave (&pantheon_calculator_main_window_history_type_id__once, pantheon_calculator_main_window_history_type_id);
	}
	return pantheon_calculator_main_window_history_type_id__once;
}

static void
_pantheon_calculator_main_window_toggle_grid_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                        gpointer self)
{
	pantheon_calculator_main_window_toggle_grid ((PantheonCalculatorMainWindow*) self, _sender);
}

static void
_pantheon_calculator_main_window_show_history_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	pantheon_calculator_main_window_show_history ((PantheonCalculatorMainWindow*) self, _sender);
}

static void
_pantheon_calculator_main_window_remove_error_gtk_editable_changed (GtkEditable* _sender,
                                                                    gpointer self)
{
	pantheon_calculator_main_window_remove_error ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window_button_calc_clicked_gtk_entry_activate (GtkEntry* _sender,
                                                                         gpointer self)
{
	pantheon_calculator_main_window_button_calc_clicked ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window_replace_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                        const gchar* text,
                                                                        gint length,
                                                                        gint* position,
                                                                        gpointer self)
{
	pantheon_calculator_main_window_replace_text ((PantheonCalculatorMainWindow*) self, text, length, position);
}

static void
_pantheon_calculator_main_window___lambda38_ (PantheonCalculatorMainWindow* self)
{
	pantheon_calculator_main_window_button_calc_clicked (self);
}

static void
__pantheon_calculator_main_window___lambda38__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_pantheon_calculator_main_window___lambda38_ ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window___lambda39_ (PantheonCalculatorMainWindow* self)
{
	pantheon_calculator_main_window_button_del_clicked (self);
}

static void
__pantheon_calculator_main_window___lambda39__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_pantheon_calculator_main_window___lambda39_ ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window___lambda40_ (PantheonCalculatorMainWindow* self)
{
	pantheon_calculator_main_window_button_ans_clicked (self);
}

static void
__pantheon_calculator_main_window___lambda40__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_pantheon_calculator_main_window___lambda40_ ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window___lambda41_ (PantheonCalculatorMainWindow* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	_tmp0_ = pantheon_calculator_main_window_number_to_string (self, self->priv->memory_value);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_new_string (_tmp1_);
	g_variant_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	g_action_group_activate_action ((GActionGroup*) self, PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT, _tmp3_);
	_g_variant_unref0 (_tmp3_);
	_g_free0 (_tmp1_);
}

static void
__pantheon_calculator_main_window___lambda41__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_pantheon_calculator_main_window___lambda41_ ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window___lambda42_ (PantheonCalculatorMainWindow* self)
{
	pantheon_calculator_main_window_button_memory_store_clicked (self);
}

static void
__pantheon_calculator_main_window___lambda42__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_pantheon_calculator_main_window___lambda42_ ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window___lambda43_ (PantheonCalculatorMainWindow* self)
{
	pantheon_calculator_main_window_button_memory_add_clicked (self);
}

static void
__pantheon_calculator_main_window___lambda43__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_pantheon_calculator_main_window___lambda43_ ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window___lambda44_ (PantheonCalculatorMainWindow* self)
{
	pantheon_calculator_main_window_button_memory_subtract_clicked (self);
}

static void
__pantheon_calculator_main_window___lambda44__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_pantheon_calculator_main_window___lambda44_ ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window___lambda45_ (PantheonCalculatorMainWindow* self)
{
	pantheon_calculator_main_window_button_memory_clear_clicked (self);
}

static void
__pantheon_calculator_main_window___lambda45__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_pantheon_calculator_main_window___lambda45_ ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window___lambda46_ (PantheonCalculatorMainWindow* self)
{
	pantheon_calculator_main_window_button_gt_clicked (self);
}

static void
__pantheon_calculator_main_window___lambda46__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_pantheon_calculator_main_window___lambda46_ ((PantheonCalculatorMainWindow*) self);
}

static void
_pantheon_calculator_main_window___lambda47_ (PantheonCalculatorMainWindow* self)
{
	pantheon_calculator_main_window_button_reciprocal_clicked (self);
}

static void
__pantheon_calculator_main_window___lambda47__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_pantheon_calculator_main_window___lambda47_ ((PantheonCalculatorMainWindow*) self);
}

static GObject *
pantheon_calculator_main_window_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonCalculatorMainWindow * self;
	GtkApplication* application_instance = NULL;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GtkApplication* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GtkApplication* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GtkApplication* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GtkApplication* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GSettings* _tmp18_;
	PantheonCalculatorCoreEvaluation* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkToggleButton* _tmp22_ = NULL;
	GtkToggleButton* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GtkButton* _tmp26_ = NULL;
	GtkButton* _tmp27_;
	GtkHeaderBar* headerbar = NULL;
	GtkLabel* _tmp28_;
	GtkHeaderBar* _tmp29_ = NULL;
	GtkHeaderBar* _tmp30_;
	GtkToggleButton* _tmp31_;
	GtkHeaderBar* _tmp32_;
	GtkButton* _tmp33_;
	GtkHeaderBar* _tmp34_;
	GtkHeaderBar* _tmp35_;
	GtkEntry* _tmp36_ = NULL;
	GtkEntry* _tmp37_;
	gchar* _tmp38_;
	PantheonCalculatorButton* _tmp39_ = NULL;
	GtkButton* _tmp40_;
	GtkButton* _tmp41_;
	gchar* _tmp42_;
	PantheonCalculatorButton* _tmp43_ = NULL;
	gchar* _tmp44_;
	PantheonCalculatorButton* _tmp45_ = NULL;
	PantheonCalculatorButton* button_clr = NULL;
	gchar* _tmp46_;
	PantheonCalculatorButton* _tmp47_ = NULL;
	PantheonCalculatorButton* _tmp48_;
	GtkApplication* _tmp49_;
	PantheonCalculatorButton* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar** _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gchar* _tmp56_;
	gchar* _tmp57_;
	PantheonCalculatorButton* _tmp58_;
	PantheonCalculatorButton* button_add = NULL;
	gchar* _tmp59_;
	GVariant* _tmp60_;
	gchar* _tmp61_;
	PantheonCalculatorButton* _tmp62_ = NULL;
	PantheonCalculatorButton* _tmp63_;
	PantheonCalculatorButton* button_sub = NULL;
	gchar* _tmp64_;
	GVariant* _tmp65_;
	gchar* _tmp66_;
	PantheonCalculatorButton* _tmp67_ = NULL;
	PantheonCalculatorButton* _tmp68_;
	PantheonCalculatorButton* button_mult = NULL;
	gchar* _tmp69_;
	GVariant* _tmp70_;
	gchar* _tmp71_;
	PantheonCalculatorButton* _tmp72_ = NULL;
	PantheonCalculatorButton* _tmp73_;
	PantheonCalculatorButton* button_div = NULL;
	gchar* _tmp74_;
	GVariant* _tmp75_;
	gchar* _tmp76_;
	PantheonCalculatorButton* _tmp77_ = NULL;
	PantheonCalculatorButton* _tmp78_;
	PantheonCalculatorButton* button_0 = NULL;
	gchar* _tmp79_;
	GVariant* _tmp80_;
	PantheonCalculatorButton* _tmp81_ = NULL;
	PantheonCalculatorButton* button_point = NULL;
	const gchar* _tmp82_;
	gchar* _tmp83_;
	const gchar* _tmp84_;
	GVariant* _tmp85_;
	PantheonCalculatorButton* _tmp86_ = NULL;
	PantheonCalculatorButton* button_percent = NULL;
	gchar* _tmp87_;
	GVariant* _tmp88_;
	gchar* _tmp89_;
	PantheonCalculatorButton* _tmp90_ = NULL;
	PantheonCalculatorButton* button_1 = NULL;
	gchar* _tmp91_;
	GVariant* _tmp92_;
	PantheonCalculatorButton* _tmp93_ = NULL;
	PantheonCalculatorButton* button_2 = NULL;
	gchar* _tmp94_;
	GVariant* _tmp95_;
	PantheonCalculatorButton* _tmp96_ = NULL;
	PantheonCalculatorButton* button_3 = NULL;
	gchar* _tmp97_;
	GVariant* _tmp98_;
	PantheonCalculatorButton* _tmp99_ = NULL;
	PantheonCalculatorButton* button_4 = NULL;
	gchar* _tmp100_;
	GVariant* _tmp101_;
	PantheonCalculatorButton* _tmp102_ = NULL;
	PantheonCalculatorButton* button_5 = NULL;
	gchar* _tmp103_;
	GVariant* _tmp104_;
	PantheonCalculatorButton* _tmp105_ = NULL;
	PantheonCalculatorButton* button_6 = NULL;
	gchar* _tmp106_;
	GVariant* _tmp107_;
	PantheonCalculatorButton* _tmp108_ = NULL;
	PantheonCalculatorButton* button_7 = NULL;
	gchar* _tmp109_;
	GVariant* _tmp110_;
	PantheonCalculatorButton* _tmp111_ = NULL;
	PantheonCalculatorButton* button_8 = NULL;
	gchar* _tmp112_;
	GVariant* _tmp113_;
	PantheonCalculatorButton* _tmp114_ = NULL;
	PantheonCalculatorButton* button_9 = NULL;
	gchar* _tmp115_;
	GVariant* _tmp116_;
	PantheonCalculatorButton* _tmp117_ = NULL;
	GtkGrid* basic_grid = NULL;
	GtkGrid* _tmp118_ = NULL;
	GtkGrid* _tmp119_;
	GtkEntry* _tmp120_;
	GtkGrid* _tmp121_;
	PantheonCalculatorButton* _tmp122_;
	GtkGrid* _tmp123_;
	GtkButton* _tmp124_;
	GtkGrid* _tmp125_;
	PantheonCalculatorButton* _tmp126_;
	GtkGrid* _tmp127_;
	PantheonCalculatorButton* _tmp128_;
	GtkGrid* _tmp129_;
	PantheonCalculatorButton* _tmp130_;
	GtkGrid* _tmp131_;
	PantheonCalculatorButton* _tmp132_;
	GtkGrid* _tmp133_;
	PantheonCalculatorButton* _tmp134_;
	GtkGrid* _tmp135_;
	PantheonCalculatorButton* _tmp136_;
	GtkGrid* _tmp137_;
	PantheonCalculatorButton* _tmp138_;
	GtkGrid* _tmp139_;
	PantheonCalculatorButton* _tmp140_;
	GtkGrid* _tmp141_;
	PantheonCalculatorButton* _tmp142_;
	GtkGrid* _tmp143_;
	PantheonCalculatorButton* _tmp144_;
	GtkGrid* _tmp145_;
	PantheonCalculatorButton* _tmp146_;
	GtkGrid* _tmp147_;
	PantheonCalculatorButton* _tmp148_;
	GtkGrid* _tmp149_;
	PantheonCalculatorButton* _tmp150_;
	GtkGrid* _tmp151_;
	PantheonCalculatorButton* _tmp152_;
	GtkGrid* _tmp153_;
	PantheonCalculatorButton* _tmp154_;
	GtkGrid* _tmp155_;
	PantheonCalculatorButton* _tmp156_;
	GtkGrid* _tmp157_;
	GtkButton* _tmp158_;
	GtkGrid* _tmp159_;
	GtkButton* _tmp160_;
	PantheonCalculatorButton* button_ms = NULL;
	gchar* _tmp161_;
	PantheonCalculatorButton* _tmp162_ = NULL;
	gchar* _tmp163_;
	PantheonCalculatorButton* _tmp164_ = NULL;
	PantheonCalculatorButton* button_m_add = NULL;
	gchar* _tmp165_;
	PantheonCalculatorButton* _tmp166_ = NULL;
	PantheonCalculatorButton* button_m_sub = NULL;
	gchar* _tmp167_;
	PantheonCalculatorButton* _tmp168_ = NULL;
	gchar* _tmp169_;
	PantheonCalculatorButton* _tmp170_ = NULL;
	gchar* _tmp171_;
	PantheonCalculatorButton* _tmp172_ = NULL;
	PantheonCalculatorButton* button_par_left = NULL;
	gchar* _tmp173_;
	GVariant* _tmp174_;
	gchar* _tmp175_;
	PantheonCalculatorButton* _tmp176_ = NULL;
	PantheonCalculatorButton* button_par_right = NULL;
	gchar* _tmp177_;
	GVariant* _tmp178_;
	gchar* _tmp179_;
	PantheonCalculatorButton* _tmp180_ = NULL;
	PantheonCalculatorButton* button_pow = NULL;
	gchar* _tmp181_;
	GVariant* _tmp182_;
	gchar* _tmp183_;
	PantheonCalculatorButton* _tmp184_ = NULL;
	PantheonCalculatorButton* button_sr = NULL;
	gchar* _tmp185_;
	GVariant* _tmp186_;
	gchar* _tmp187_;
	PantheonCalculatorButton* _tmp188_ = NULL;
	PantheonCalculatorButton* button_sin = NULL;
	gchar* _tmp189_;
	GVariant* _tmp190_;
	gchar* _tmp191_;
	PantheonCalculatorButton* _tmp192_ = NULL;
	PantheonCalculatorButton* button_sinh = NULL;
	gchar* _tmp193_;
	GVariant* _tmp194_;
	gchar* _tmp195_;
	PantheonCalculatorButton* _tmp196_ = NULL;
	PantheonCalculatorButton* button_cos = NULL;
	gchar* _tmp197_;
	GVariant* _tmp198_;
	gchar* _tmp199_;
	PantheonCalculatorButton* _tmp200_ = NULL;
	PantheonCalculatorButton* button_cosh = NULL;
	gchar* _tmp201_;
	GVariant* _tmp202_;
	gchar* _tmp203_;
	PantheonCalculatorButton* _tmp204_ = NULL;
	PantheonCalculatorButton* button_tan = NULL;
	gchar* _tmp205_;
	GVariant* _tmp206_;
	gchar* _tmp207_;
	PantheonCalculatorButton* _tmp208_ = NULL;
	PantheonCalculatorButton* button_tanh = NULL;
	gchar* _tmp209_;
	GVariant* _tmp210_;
	gchar* _tmp211_;
	PantheonCalculatorButton* _tmp212_ = NULL;
	PantheonCalculatorButton* button_pi = NULL;
	gchar* _tmp213_;
	GVariant* _tmp214_;
	gchar* _tmp215_;
	PantheonCalculatorButton* _tmp216_ = NULL;
	PantheonCalculatorButton* button_e = NULL;
	gchar* _tmp217_;
	GVariant* _tmp218_;
	gchar* _tmp219_;
	PantheonCalculatorButton* _tmp220_ = NULL;
	PantheonCalculatorButton* button_log = NULL;
	gchar* _tmp221_;
	GVariant* _tmp222_;
	gchar* _tmp223_;
	PantheonCalculatorButton* _tmp224_ = NULL;
	PantheonCalculatorButton* button_ln = NULL;
	gchar* _tmp225_;
	GVariant* _tmp226_;
	gchar* _tmp227_;
	PantheonCalculatorButton* _tmp228_ = NULL;
	PantheonCalculatorButton* button_asin = NULL;
	gchar* _tmp229_;
	GVariant* _tmp230_;
	gchar* _tmp231_;
	PantheonCalculatorButton* _tmp232_ = NULL;
	PantheonCalculatorButton* button_acos = NULL;
	gchar* _tmp233_;
	GVariant* _tmp234_;
	gchar* _tmp235_;
	PantheonCalculatorButton* _tmp236_ = NULL;
	PantheonCalculatorButton* button_atan = NULL;
	gchar* _tmp237_;
	GVariant* _tmp238_;
	gchar* _tmp239_;
	PantheonCalculatorButton* _tmp240_ = NULL;
	PantheonCalculatorButton* button_reciprocal = NULL;
	gchar* _tmp241_;
	PantheonCalculatorButton* _tmp242_ = NULL;
	GtkGrid* extended_grid = NULL;
	GtkGrid* _tmp243_ = NULL;
	GtkGrid* _tmp244_;
	PantheonCalculatorButton* _tmp245_;
	GtkGrid* _tmp246_;
	PantheonCalculatorButton* _tmp247_;
	GtkGrid* _tmp248_;
	PantheonCalculatorButton* _tmp249_;
	GtkGrid* _tmp250_;
	PantheonCalculatorButton* _tmp251_;
	GtkGrid* _tmp252_;
	GtkButton* _tmp253_;
	GtkGrid* _tmp254_;
	PantheonCalculatorButton* _tmp255_;
	GtkGrid* _tmp256_;
	PantheonCalculatorButton* _tmp257_;
	GtkGrid* _tmp258_;
	PantheonCalculatorButton* _tmp259_;
	GtkGrid* _tmp260_;
	PantheonCalculatorButton* _tmp261_;
	GtkGrid* _tmp262_;
	PantheonCalculatorButton* _tmp263_;
	GtkGrid* _tmp264_;
	PantheonCalculatorButton* _tmp265_;
	GtkGrid* _tmp266_;
	PantheonCalculatorButton* _tmp267_;
	GtkGrid* _tmp268_;
	PantheonCalculatorButton* _tmp269_;
	GtkGrid* _tmp270_;
	PantheonCalculatorButton* _tmp271_;
	GtkGrid* _tmp272_;
	PantheonCalculatorButton* _tmp273_;
	GtkGrid* _tmp274_;
	PantheonCalculatorButton* _tmp275_;
	GtkGrid* _tmp276_;
	GtkButton* _tmp277_;
	GtkGrid* _tmp278_;
	PantheonCalculatorButton* _tmp279_;
	GtkGrid* _tmp280_;
	PantheonCalculatorButton* _tmp281_;
	GtkGrid* _tmp282_;
	PantheonCalculatorButton* _tmp283_;
	GtkGrid* _tmp284_;
	GtkButton* _tmp285_;
	GtkGrid* _tmp286_;
	PantheonCalculatorButton* _tmp287_;
	GtkGrid* _tmp288_;
	PantheonCalculatorButton* _tmp289_;
	GtkGrid* _tmp290_;
	PantheonCalculatorButton* _tmp291_;
	GtkGrid* _tmp292_;
	GtkWidget* _tmp293_;
	GtkRevealer* _tmp294_ = NULL;
	GtkBox* main_grid = NULL;
	GtkBox* _tmp295_ = NULL;
	GtkBox* _tmp296_;
	GtkGrid* _tmp297_;
	GtkBox* _tmp298_;
	GtkRevealer* _tmp299_;
	GtkLabel* _tmp300_;
	GtkInfoBar* _tmp301_ = NULL;
	GtkInfoBar* _tmp302_;
	GtkLabel* _tmp303_;
	GtkBox* global_box = NULL;
	GtkBox* _tmp304_;
	GtkBox* _tmp305_;
	GtkInfoBar* _tmp306_;
	GtkBox* _tmp307_;
	GtkBox* _tmp308_;
	GtkBox* _tmp309_;
	GtkHeaderBar* _tmp310_;
	GtkEntry* _tmp311_;
	GtkEntry* _tmp312_;
	GtkEntry* _tmp313_;
	GtkEntry* _tmp314_;
	GtkEditable* _tmp315_;
	GtkButton* _tmp316_;
	GtkButton* _tmp317_;
	GtkButton* _tmp318_;
	GtkButton* _tmp319_;
	PantheonCalculatorButton* _tmp320_;
	PantheonCalculatorButton* _tmp321_;
	PantheonCalculatorButton* _tmp322_;
	GtkButton* _tmp323_;
	GtkButton* _tmp324_;
	PantheonCalculatorButton* _tmp325_;
	GSettings* _tmp326_;
	GtkToggleButton* _tmp327_;
	GtkApplication* _tmp328_;
	GList* _tmp329_;
	parent_class = G_OBJECT_CLASS (pantheon_calculator_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_CALCULATOR_TYPE_MAIN_WINDOW, PantheonCalculatorMainWindow);
	g_action_map_add_action_entries ((GActionMap*) self, PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	application_instance = _tmp1_;
	_tmp2_ = application_instance;
	_tmp3_ = g_strdup ("Escape");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action (_tmp2_, PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_CLEAR, _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = application_instance;
	_tmp7_ = g_strdup ("<Control>z");
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 1;
	gtk_application_set_accels_for_action (_tmp6_, PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_UNDO, _tmp9_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = application_instance;
	_tmp11_ = g_strdup ("<Control>c");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	gtk_application_set_accels_for_action (_tmp10_, PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_COPY, _tmp13_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = application_instance;
	_tmp15_ = g_strdup ("<Control>v");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action (_tmp14_, PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PASTE, _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_title ((GtkWindow*) self, _ ("Calculator"));
	_tmp18_ = pantheon_calculator_main_window_settings;
	self->priv->decimal_places = g_settings_get_int (_tmp18_, "decimal-places");
	_tmp19_ = pantheon_calculator_core_evaluation_new ();
	_g_object_unref0 (self->priv->eval);
	self->priv->eval = _tmp19_;
	(self->priv->history == NULL) ? NULL : (self->priv->history = (_g_list_free__pantheon_calculator_main_window_history_free0_ (self->priv->history), NULL));
	self->priv->history = NULL;
	self->priv->position = 0;
	_tmp20_ = g_strdup ("pane-hide-symbolic");
	_tmp21_ = g_strdup (_ ("Show extended functionality"));
	_tmp22_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_button_set_icon_name ((GtkButton*) _tmp22_, _tmp20_);
	_g_free0 (_tmp20_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _tmp21_);
	_g_free0 (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->button_extended);
	self->priv->button_extended = _tmp22_;
	_tmp23_ = self->priv->button_extended;
	g_signal_connect_object (_tmp23_, "toggled", (GCallback) _pantheon_calculator_main_window_toggle_grid_gtk_toggle_button_toggled, self, 0);
	_tmp24_ = g_strdup ("document-open-recent-symbolic");
	_tmp25_ = g_strdup (_ ("History"));
	_tmp26_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_icon_name (_tmp26_, _tmp24_);
	_g_free0 (_tmp24_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp26_, _tmp25_);
	_g_free0 (_tmp25_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, FALSE);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->button_history);
	self->priv->button_history = _tmp26_;
	_tmp27_ = self->priv->button_history;
	g_signal_connect_object (_tmp27_, "clicked", (GCallback) _pantheon_calculator_main_window_show_history_gtk_button_clicked, self, 0);
	_tmp28_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp28_);
	_tmp29_ = (GtkHeaderBar*) gtk_header_bar_new ();
	gtk_header_bar_set_show_title_buttons (_tmp29_, TRUE);
	gtk_header_bar_set_title_widget (_tmp29_, (GtkWidget*) _tmp28_);
	_g_object_unref0 (_tmp28_);
	g_object_ref_sink (_tmp29_);
	headerbar = _tmp29_;
	_tmp30_ = headerbar;
	_tmp31_ = self->priv->button_extended;
	gtk_header_bar_pack_end (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = headerbar;
	_tmp33_ = self->priv->button_history;
	gtk_header_bar_pack_end (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = headerbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp34_, GRANITE_STYLE_CLASS_DEFAULT_DECORATION);
	_tmp35_ = headerbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp35_, GRANITE_STYLE_CLASS_FLAT);
	_tmp36_ = (GtkEntry*) gtk_entry_new ();
	g_object_set ((GtkEditable*) _tmp36_, "xalign", (gfloat) 1, NULL);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp36_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp36_, GTK_ALIGN_FILL);
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp36_;
	_tmp37_ = self->priv->entry;
	gtk_widget_add_css_class ((GtkWidget*) _tmp37_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp38_ = g_strdup (_ ("Calculate Result"));
	_tmp39_ = pantheon_calculator_button_new ("=");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp39_, _tmp38_);
	_g_free0 (_tmp38_);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->button_calc);
	self->priv->button_calc = (GtkButton*) _tmp39_;
	_tmp40_ = self->priv->button_calc;
	gtk_widget_add_css_class ((GtkWidget*) _tmp40_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp41_ = self->priv->button_calc;
	gtk_widget_add_css_class ((GtkWidget*) _tmp41_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp42_ = g_strdup (_ ("Insert last result"));
	_tmp43_ = pantheon_calculator_button_new ("ANS");
	gtk_widget_set_sensitive ((GtkWidget*) _tmp43_, FALSE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp43_, _tmp42_);
	_g_free0 (_tmp42_);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->button_ans);
	self->priv->button_ans = (GtkButton*) _tmp43_;
	_tmp44_ = g_strdup (_ ("Backspace"));
	_tmp45_ = pantheon_calculator_button_new_from_icon_name ("edit-clear-symbolic");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp45_, _tmp44_);
	_g_free0 (_tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->button_del);
	self->priv->button_del = (GtkButton*) _tmp45_;
	_tmp46_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_CLEAR);
	_tmp47_ = pantheon_calculator_button_new ("C");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp47_, _tmp46_);
	_g_free0 (_tmp46_);
	g_object_ref_sink (_tmp47_);
	button_clr = _tmp47_;
	_tmp48_ = button_clr;
	_tmp49_ = application_instance;
	_tmp50_ = button_clr;
	_tmp51_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp54_ = _tmp53_ = gtk_application_get_accels_for_action (_tmp49_, _tmp52_);
	_tmp55_ = _tmp54_;
	_tmp55__length1 = _vala_array_length (_tmp53_);
	_tmp56_ = granite_markup_accel_tooltip (_tmp55_, (gint) _vala_array_length (_tmp53_), _ ("Clear entry"));
	_tmp57_ = _tmp56_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp48_, _tmp57_);
	_g_free0 (_tmp57_);
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
	_tmp58_ = button_clr;
	gtk_widget_add_css_class ((GtkWidget*) _tmp58_, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp59_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp60_ = g_variant_new_string ("+");
	g_variant_ref_sink (_tmp60_);
	_tmp61_ = g_strdup (_ ("Add"));
	_tmp62_ = pantheon_calculator_button_new (" + ");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp62_, _tmp59_);
	_g_free0 (_tmp59_);
	g_object_set ((GtkActionable*) _tmp62_, "action-target", _tmp60_, NULL);
	_g_variant_unref0 (_tmp60_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp62_, _tmp61_);
	_g_free0 (_tmp61_);
	g_object_ref_sink (_tmp62_);
	button_add = _tmp62_;
	_tmp63_ = button_add;
	gtk_widget_add_css_class ((GtkWidget*) _tmp63_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp64_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp65_ = g_variant_new_string ("-");
	g_variant_ref_sink (_tmp65_);
	_tmp66_ = g_strdup (_ ("Subtract"));
	_tmp67_ = pantheon_calculator_button_new (" − ");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp67_, _tmp64_);
	_g_free0 (_tmp64_);
	g_object_set ((GtkActionable*) _tmp67_, "action-target", _tmp65_, NULL);
	_g_variant_unref0 (_tmp65_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp67_, _tmp66_);
	_g_free0 (_tmp66_);
	g_object_ref_sink (_tmp67_);
	button_sub = _tmp67_;
	_tmp68_ = button_sub;
	gtk_widget_add_css_class ((GtkWidget*) _tmp68_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp69_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp70_ = g_variant_new_string ("×");
	g_variant_ref_sink (_tmp70_);
	_tmp71_ = g_strdup (_ ("Multiply"));
	_tmp72_ = pantheon_calculator_button_new (" × ");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp72_, _tmp69_);
	_g_free0 (_tmp69_);
	g_object_set ((GtkActionable*) _tmp72_, "action-target", _tmp70_, NULL);
	_g_variant_unref0 (_tmp70_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp72_, _tmp71_);
	_g_free0 (_tmp71_);
	g_object_ref_sink (_tmp72_);
	button_mult = _tmp72_;
	_tmp73_ = button_mult;
	gtk_widget_add_css_class ((GtkWidget*) _tmp73_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp74_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp75_ = g_variant_new_string ("÷");
	g_variant_ref_sink (_tmp75_);
	_tmp76_ = g_strdup (_ ("Divide"));
	_tmp77_ = pantheon_calculator_button_new (" ÷ ");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp77_, _tmp74_);
	_g_free0 (_tmp74_);
	g_object_set ((GtkActionable*) _tmp77_, "action-target", _tmp75_, NULL);
	_g_variant_unref0 (_tmp75_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp77_, _tmp76_);
	_g_free0 (_tmp76_);
	g_object_ref_sink (_tmp77_);
	button_div = _tmp77_;
	_tmp78_ = button_div;
	gtk_widget_add_css_class ((GtkWidget*) _tmp78_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp79_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp80_ = g_variant_new_string ("0");
	g_variant_ref_sink (_tmp80_);
	_tmp81_ = pantheon_calculator_button_new ("0");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp81_, _tmp79_);
	_g_free0 (_tmp79_);
	g_object_set ((GtkActionable*) _tmp81_, "action-target", _tmp80_, NULL);
	_g_variant_unref0 (_tmp80_);
	g_object_ref_sink (_tmp81_);
	button_0 = _tmp81_;
	_tmp82_ = nl_langinfo (RADIXCHAR);
	_tmp83_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp84_ = nl_langinfo (RADIXCHAR);
	_tmp85_ = g_variant_new_string (_tmp84_);
	g_variant_ref_sink (_tmp85_);
	_tmp86_ = pantheon_calculator_button_new (_tmp82_);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp86_, _tmp83_);
	_g_free0 (_tmp83_);
	g_object_set ((GtkActionable*) _tmp86_, "action-target", _tmp85_, NULL);
	_g_variant_unref0 (_tmp85_);
	g_object_ref_sink (_tmp86_);
	button_point = _tmp86_;
	_tmp87_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp88_ = g_variant_new_string ("%");
	g_variant_ref_sink (_tmp88_);
	_tmp89_ = g_strdup (_ ("Percentage"));
	_tmp90_ = pantheon_calculator_button_new ("%");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp90_, _tmp87_);
	_g_free0 (_tmp87_);
	g_object_set ((GtkActionable*) _tmp90_, "action-target", _tmp88_, NULL);
	_g_variant_unref0 (_tmp88_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp90_, _tmp89_);
	_g_free0 (_tmp89_);
	g_object_ref_sink (_tmp90_);
	button_percent = _tmp90_;
	_tmp91_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp92_ = g_variant_new_string ("1");
	g_variant_ref_sink (_tmp92_);
	_tmp93_ = pantheon_calculator_button_new ("1");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp93_, _tmp91_);
	_g_free0 (_tmp91_);
	g_object_set ((GtkActionable*) _tmp93_, "action-target", _tmp92_, NULL);
	_g_variant_unref0 (_tmp92_);
	g_object_ref_sink (_tmp93_);
	button_1 = _tmp93_;
	_tmp94_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp95_ = g_variant_new_string ("2");
	g_variant_ref_sink (_tmp95_);
	_tmp96_ = pantheon_calculator_button_new ("2");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp96_, _tmp94_);
	_g_free0 (_tmp94_);
	g_object_set ((GtkActionable*) _tmp96_, "action-target", _tmp95_, NULL);
	_g_variant_unref0 (_tmp95_);
	g_object_ref_sink (_tmp96_);
	button_2 = _tmp96_;
	_tmp97_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp98_ = g_variant_new_string ("3");
	g_variant_ref_sink (_tmp98_);
	_tmp99_ = pantheon_calculator_button_new ("3");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp99_, _tmp97_);
	_g_free0 (_tmp97_);
	g_object_set ((GtkActionable*) _tmp99_, "action-target", _tmp98_, NULL);
	_g_variant_unref0 (_tmp98_);
	g_object_ref_sink (_tmp99_);
	button_3 = _tmp99_;
	_tmp100_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp101_ = g_variant_new_string ("4");
	g_variant_ref_sink (_tmp101_);
	_tmp102_ = pantheon_calculator_button_new ("4");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp102_, _tmp100_);
	_g_free0 (_tmp100_);
	g_object_set ((GtkActionable*) _tmp102_, "action-target", _tmp101_, NULL);
	_g_variant_unref0 (_tmp101_);
	g_object_ref_sink (_tmp102_);
	button_4 = _tmp102_;
	_tmp103_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp104_ = g_variant_new_string ("5");
	g_variant_ref_sink (_tmp104_);
	_tmp105_ = pantheon_calculator_button_new ("5");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp105_, _tmp103_);
	_g_free0 (_tmp103_);
	g_object_set ((GtkActionable*) _tmp105_, "action-target", _tmp104_, NULL);
	_g_variant_unref0 (_tmp104_);
	g_object_ref_sink (_tmp105_);
	button_5 = _tmp105_;
	_tmp106_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp107_ = g_variant_new_string ("6");
	g_variant_ref_sink (_tmp107_);
	_tmp108_ = pantheon_calculator_button_new ("6");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp108_, _tmp106_);
	_g_free0 (_tmp106_);
	g_object_set ((GtkActionable*) _tmp108_, "action-target", _tmp107_, NULL);
	_g_variant_unref0 (_tmp107_);
	g_object_ref_sink (_tmp108_);
	button_6 = _tmp108_;
	_tmp109_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp110_ = g_variant_new_string ("7");
	g_variant_ref_sink (_tmp110_);
	_tmp111_ = pantheon_calculator_button_new ("7");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp111_, _tmp109_);
	_g_free0 (_tmp109_);
	g_object_set ((GtkActionable*) _tmp111_, "action-target", _tmp110_, NULL);
	_g_variant_unref0 (_tmp110_);
	g_object_ref_sink (_tmp111_);
	button_7 = _tmp111_;
	_tmp112_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp113_ = g_variant_new_string ("8");
	g_variant_ref_sink (_tmp113_);
	_tmp114_ = pantheon_calculator_button_new ("8");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp114_, _tmp112_);
	_g_free0 (_tmp112_);
	g_object_set ((GtkActionable*) _tmp114_, "action-target", _tmp113_, NULL);
	_g_variant_unref0 (_tmp113_);
	g_object_ref_sink (_tmp114_);
	button_8 = _tmp114_;
	_tmp115_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp116_ = g_variant_new_string ("9");
	g_variant_ref_sink (_tmp116_);
	_tmp117_ = pantheon_calculator_button_new ("9");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp117_, _tmp115_);
	_g_free0 (_tmp115_);
	g_object_set ((GtkActionable*) _tmp117_, "action-target", _tmp116_, NULL);
	_g_variant_unref0 (_tmp116_);
	g_object_ref_sink (_tmp117_);
	button_9 = _tmp117_;
	_tmp118_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp118_, 6);
	gtk_grid_set_row_spacing (_tmp118_, 6);
	gtk_grid_set_row_spacing (_tmp118_, 6);
	gtk_grid_set_row_homogeneous (_tmp118_, TRUE);
	g_object_ref_sink (_tmp118_);
	basic_grid = _tmp118_;
	_tmp119_ = basic_grid;
	_tmp120_ = self->priv->entry;
	gtk_grid_attach (_tmp119_, (GtkWidget*) _tmp120_, 0, 0, 4, 1);
	_tmp121_ = basic_grid;
	_tmp122_ = button_clr;
	gtk_grid_attach (_tmp121_, (GtkWidget*) _tmp122_, 0, 1, 1, 1);
	_tmp123_ = basic_grid;
	_tmp124_ = self->priv->button_del;
	gtk_grid_attach (_tmp123_, (GtkWidget*) _tmp124_, 1, 1, 1, 1);
	_tmp125_ = basic_grid;
	_tmp126_ = button_percent;
	gtk_grid_attach (_tmp125_, (GtkWidget*) _tmp126_, 2, 1, 1, 1);
	_tmp127_ = basic_grid;
	_tmp128_ = button_div;
	gtk_grid_attach (_tmp127_, (GtkWidget*) _tmp128_, 3, 1, 1, 1);
	_tmp129_ = basic_grid;
	_tmp130_ = button_7;
	gtk_grid_attach (_tmp129_, (GtkWidget*) _tmp130_, 0, 2, 1, 1);
	_tmp131_ = basic_grid;
	_tmp132_ = button_8;
	gtk_grid_attach (_tmp131_, (GtkWidget*) _tmp132_, 1, 2, 1, 1);
	_tmp133_ = basic_grid;
	_tmp134_ = button_9;
	gtk_grid_attach (_tmp133_, (GtkWidget*) _tmp134_, 2, 2, 1, 1);
	_tmp135_ = basic_grid;
	_tmp136_ = button_mult;
	gtk_grid_attach (_tmp135_, (GtkWidget*) _tmp136_, 3, 2, 1, 1);
	_tmp137_ = basic_grid;
	_tmp138_ = button_4;
	gtk_grid_attach (_tmp137_, (GtkWidget*) _tmp138_, 0, 3, 1, 1);
	_tmp139_ = basic_grid;
	_tmp140_ = button_5;
	gtk_grid_attach (_tmp139_, (GtkWidget*) _tmp140_, 1, 3, 1, 1);
	_tmp141_ = basic_grid;
	_tmp142_ = button_6;
	gtk_grid_attach (_tmp141_, (GtkWidget*) _tmp142_, 2, 3, 1, 1);
	_tmp143_ = basic_grid;
	_tmp144_ = button_sub;
	gtk_grid_attach (_tmp143_, (GtkWidget*) _tmp144_, 3, 3, 1, 1);
	_tmp145_ = basic_grid;
	_tmp146_ = button_1;
	gtk_grid_attach (_tmp145_, (GtkWidget*) _tmp146_, 0, 4, 1, 1);
	_tmp147_ = basic_grid;
	_tmp148_ = button_2;
	gtk_grid_attach (_tmp147_, (GtkWidget*) _tmp148_, 1, 4, 1, 1);
	_tmp149_ = basic_grid;
	_tmp150_ = button_3;
	gtk_grid_attach (_tmp149_, (GtkWidget*) _tmp150_, 2, 4, 1, 1);
	_tmp151_ = basic_grid;
	_tmp152_ = button_add;
	gtk_grid_attach (_tmp151_, (GtkWidget*) _tmp152_, 3, 4, 1, 1);
	_tmp153_ = basic_grid;
	_tmp154_ = button_0;
	gtk_grid_attach (_tmp153_, (GtkWidget*) _tmp154_, 0, 5, 1, 1);
	_tmp155_ = basic_grid;
	_tmp156_ = button_point;
	gtk_grid_attach (_tmp155_, (GtkWidget*) _tmp156_, 1, 5, 1, 1);
	_tmp157_ = basic_grid;
	_tmp158_ = self->priv->button_ans;
	gtk_grid_attach (_tmp157_, (GtkWidget*) _tmp158_, 2, 5, 1, 1);
	_tmp159_ = basic_grid;
	_tmp160_ = self->priv->button_calc;
	gtk_grid_attach (_tmp159_, (GtkWidget*) _tmp160_, 3, 5, 1, 1);
	_tmp161_ = g_strdup (_ ("Set memory value"));
	_tmp162_ = pantheon_calculator_button_new ("MS");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp162_, _tmp161_);
	_g_free0 (_tmp161_);
	g_object_ref_sink (_tmp162_);
	button_ms = _tmp162_;
	_tmp163_ = g_strdup (_ ("Recall value from memory"));
	_tmp164_ = pantheon_calculator_button_new ("MR");
	gtk_widget_set_sensitive ((GtkWidget*) _tmp164_, FALSE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp164_, _tmp163_);
	_g_free0 (_tmp163_);
	g_object_ref_sink (_tmp164_);
	_g_object_unref0 (self->priv->button_mr);
	self->priv->button_mr = (GtkButton*) _tmp164_;
	_tmp165_ = g_strdup (_ ("Add to stored value"));
	_tmp166_ = pantheon_calculator_button_new ("M+");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp166_, _tmp165_);
	_g_free0 (_tmp165_);
	g_object_ref_sink (_tmp166_);
	button_m_add = _tmp166_;
	_tmp167_ = g_strdup (_ ("Subtract from stored value"));
	_tmp168_ = pantheon_calculator_button_new ("M−");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp168_, _tmp167_);
	_g_free0 (_tmp167_);
	g_object_ref_sink (_tmp168_);
	button_m_sub = _tmp168_;
	_tmp169_ = g_strdup (_ ("Clear memory"));
	_tmp170_ = pantheon_calculator_button_new ("MC");
	gtk_widget_set_sensitive ((GtkWidget*) _tmp170_, FALSE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp170_, _tmp169_);
	_g_free0 (_tmp169_);
	g_object_ref_sink (_tmp170_);
	_g_object_unref0 (self->priv->button_mc);
	self->priv->button_mc = (GtkButton*) _tmp170_;
	_tmp171_ = g_strdup (_ ("Grand Total"));
	_tmp172_ = pantheon_calculator_button_new ("GT");
	gtk_widget_set_sensitive ((GtkWidget*) _tmp172_, FALSE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp172_, _tmp171_);
	_g_free0 (_tmp171_);
	g_object_ref_sink (_tmp172_);
	_g_object_unref0 (self->priv->button_gt);
	self->priv->button_gt = (GtkButton*) _tmp172_;
	_tmp173_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp174_ = g_variant_new_string ("(");
	g_variant_ref_sink (_tmp174_);
	_tmp175_ = g_strdup (_ ("Start Group"));
	_tmp176_ = pantheon_calculator_button_new ("(");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp176_, _tmp173_);
	_g_free0 (_tmp173_);
	g_object_set ((GtkActionable*) _tmp176_, "action-target", _tmp174_, NULL);
	_g_variant_unref0 (_tmp174_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp176_, _tmp175_);
	_g_free0 (_tmp175_);
	g_object_ref_sink (_tmp176_);
	button_par_left = _tmp176_;
	_tmp177_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp178_ = g_variant_new_string (")");
	g_variant_ref_sink (_tmp178_);
	_tmp179_ = g_strdup (_ ("End Group"));
	_tmp180_ = pantheon_calculator_button_new (")");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp180_, _tmp177_);
	_g_free0 (_tmp177_);
	g_object_set ((GtkActionable*) _tmp180_, "action-target", _tmp178_, NULL);
	_g_variant_unref0 (_tmp178_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp180_, _tmp179_);
	_g_free0 (_tmp179_);
	g_object_ref_sink (_tmp180_);
	button_par_right = _tmp180_;
	_tmp181_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp182_ = g_variant_new_string ("^");
	g_variant_ref_sink (_tmp182_);
	_tmp183_ = g_strdup (_ ("Exponent"));
	_tmp184_ = pantheon_calculator_button_new ("x<sup>y</sup>");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp184_, _tmp181_);
	_g_free0 (_tmp181_);
	g_object_set ((GtkActionable*) _tmp184_, "action-target", _tmp182_, NULL);
	_g_variant_unref0 (_tmp182_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp184_, _tmp183_);
	_g_free0 (_tmp183_);
	g_object_ref_sink (_tmp184_);
	button_pow = _tmp184_;
	_tmp185_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp186_ = g_variant_new_string ("√");
	g_variant_ref_sink (_tmp186_);
	_tmp187_ = g_strdup (_ ("Root"));
	_tmp188_ = pantheon_calculator_button_new ("√");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp188_, _tmp185_);
	_g_free0 (_tmp185_);
	g_object_set ((GtkActionable*) _tmp188_, "action-target", _tmp186_, NULL);
	_g_variant_unref0 (_tmp186_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp188_, _tmp187_);
	_g_free0 (_tmp187_);
	g_object_ref_sink (_tmp188_);
	button_sr = _tmp188_;
	_tmp189_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp190_ = g_variant_new_string ("sin");
	g_variant_ref_sink (_tmp190_);
	_tmp191_ = g_strdup (_ ("Sine"));
	_tmp192_ = pantheon_calculator_button_new ("sin");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp192_, _tmp189_);
	_g_free0 (_tmp189_);
	g_object_set ((GtkActionable*) _tmp192_, "action-target", _tmp190_, NULL);
	_g_variant_unref0 (_tmp190_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp192_, _tmp191_);
	_g_free0 (_tmp191_);
	g_object_ref_sink (_tmp192_);
	button_sin = _tmp192_;
	_tmp193_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp194_ = g_variant_new_string ("sinh");
	g_variant_ref_sink (_tmp194_);
	_tmp195_ = g_strdup (_ ("Hyperbolic Sine"));
	_tmp196_ = pantheon_calculator_button_new ("sinh");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp196_, _tmp193_);
	_g_free0 (_tmp193_);
	g_object_set ((GtkActionable*) _tmp196_, "action-target", _tmp194_, NULL);
	_g_variant_unref0 (_tmp194_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp196_, _tmp195_);
	_g_free0 (_tmp195_);
	g_object_ref_sink (_tmp196_);
	button_sinh = _tmp196_;
	_tmp197_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp198_ = g_variant_new_string ("cos");
	g_variant_ref_sink (_tmp198_);
	_tmp199_ = g_strdup (_ ("Cosine"));
	_tmp200_ = pantheon_calculator_button_new ("cos");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp200_, _tmp197_);
	_g_free0 (_tmp197_);
	g_object_set ((GtkActionable*) _tmp200_, "action-target", _tmp198_, NULL);
	_g_variant_unref0 (_tmp198_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp200_, _tmp199_);
	_g_free0 (_tmp199_);
	g_object_ref_sink (_tmp200_);
	button_cos = _tmp200_;
	_tmp201_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp202_ = g_variant_new_string ("cosh");
	g_variant_ref_sink (_tmp202_);
	_tmp203_ = g_strdup (_ ("Hyperbolic Cosine"));
	_tmp204_ = pantheon_calculator_button_new ("cosh");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp204_, _tmp201_);
	_g_free0 (_tmp201_);
	g_object_set ((GtkActionable*) _tmp204_, "action-target", _tmp202_, NULL);
	_g_variant_unref0 (_tmp202_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp204_, _tmp203_);
	_g_free0 (_tmp203_);
	g_object_ref_sink (_tmp204_);
	button_cosh = _tmp204_;
	_tmp205_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp206_ = g_variant_new_string ("tan");
	g_variant_ref_sink (_tmp206_);
	_tmp207_ = g_strdup (_ ("Tangent"));
	_tmp208_ = pantheon_calculator_button_new ("tan");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp208_, _tmp205_);
	_g_free0 (_tmp205_);
	g_object_set ((GtkActionable*) _tmp208_, "action-target", _tmp206_, NULL);
	_g_variant_unref0 (_tmp206_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp208_, _tmp207_);
	_g_free0 (_tmp207_);
	g_object_ref_sink (_tmp208_);
	button_tan = _tmp208_;
	_tmp209_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp210_ = g_variant_new_string ("tanh");
	g_variant_ref_sink (_tmp210_);
	_tmp211_ = g_strdup (_ ("Hyperbolic Tangent"));
	_tmp212_ = pantheon_calculator_button_new ("tanh");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp212_, _tmp209_);
	_g_free0 (_tmp209_);
	g_object_set ((GtkActionable*) _tmp212_, "action-target", _tmp210_, NULL);
	_g_variant_unref0 (_tmp210_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp212_, _tmp211_);
	_g_free0 (_tmp211_);
	g_object_ref_sink (_tmp212_);
	button_tanh = _tmp212_;
	_tmp213_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp214_ = g_variant_new_string ("π");
	g_variant_ref_sink (_tmp214_);
	_tmp215_ = g_strdup (_ ("Pi"));
	_tmp216_ = pantheon_calculator_button_new ("π");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp216_, _tmp213_);
	_g_free0 (_tmp213_);
	g_object_set ((GtkActionable*) _tmp216_, "action-target", _tmp214_, NULL);
	_g_variant_unref0 (_tmp214_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp216_, _tmp215_);
	_g_free0 (_tmp215_);
	g_object_ref_sink (_tmp216_);
	button_pi = _tmp216_;
	_tmp217_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_INSERT);
	_tmp218_ = g_variant_new_string ("e");
	g_variant_ref_sink (_tmp218_);
	_tmp219_ = g_strdup (_ ("Euler's Number"));
	_tmp220_ = pantheon_calculator_button_new ("e");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp220_, _tmp217_);
	_g_free0 (_tmp217_);
	g_object_set ((GtkActionable*) _tmp220_, "action-target", _tmp218_, NULL);
	_g_variant_unref0 (_tmp218_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp220_, _tmp219_);
	_g_free0 (_tmp219_);
	g_object_ref_sink (_tmp220_);
	button_e = _tmp220_;
	_tmp221_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp222_ = g_variant_new_string ("log");
	g_variant_ref_sink (_tmp222_);
	_tmp223_ = g_strdup (_ ("Logarithm Base 10"));
	_tmp224_ = pantheon_calculator_button_new ("log<sub>10</sub>");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp224_, _tmp221_);
	_g_free0 (_tmp221_);
	g_object_set ((GtkActionable*) _tmp224_, "action-target", _tmp222_, NULL);
	_g_variant_unref0 (_tmp222_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp224_, _tmp223_);
	_g_free0 (_tmp223_);
	g_object_ref_sink (_tmp224_);
	button_log = _tmp224_;
	_tmp225_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp226_ = g_variant_new_string ("ln");
	g_variant_ref_sink (_tmp226_);
	_tmp227_ = g_strdup (_ ("Natural Logarithm"));
	_tmp228_ = pantheon_calculator_button_new ("ln");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp228_, _tmp225_);
	_g_free0 (_tmp225_);
	g_object_set ((GtkActionable*) _tmp228_, "action-target", _tmp226_, NULL);
	_g_variant_unref0 (_tmp226_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp228_, _tmp227_);
	_g_free0 (_tmp227_);
	g_object_ref_sink (_tmp228_);
	button_ln = _tmp228_;
	_tmp229_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp230_ = g_variant_new_string ("asin");
	g_variant_ref_sink (_tmp230_);
	_tmp231_ = g_strdup (_ ("Inverse Sine"));
	_tmp232_ = pantheon_calculator_button_new ("sin<sup>-1</sup>");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp232_, _tmp229_);
	_g_free0 (_tmp229_);
	g_object_set ((GtkActionable*) _tmp232_, "action-target", _tmp230_, NULL);
	_g_variant_unref0 (_tmp230_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp232_, _tmp231_);
	_g_free0 (_tmp231_);
	g_object_ref_sink (_tmp232_);
	button_asin = _tmp232_;
	_tmp233_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp234_ = g_variant_new_string ("acos");
	g_variant_ref_sink (_tmp234_);
	_tmp235_ = g_strdup (_ ("Inverse Cosine"));
	_tmp236_ = pantheon_calculator_button_new ("cos<sup>-1</sup>");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp236_, _tmp233_);
	_g_free0 (_tmp233_);
	g_object_set ((GtkActionable*) _tmp236_, "action-target", _tmp234_, NULL);
	_g_variant_unref0 (_tmp234_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp236_, _tmp235_);
	_g_free0 (_tmp235_);
	g_object_ref_sink (_tmp236_);
	button_acos = _tmp236_;
	_tmp237_ = g_strdup (PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_PREFIX PANTHEON_CALCULATOR_MAIN_WINDOW_ACTION_FUNCTION);
	_tmp238_ = g_variant_new_string ("atan");
	g_variant_ref_sink (_tmp238_);
	_tmp239_ = g_strdup (_ ("Inverse Tangent"));
	_tmp240_ = pantheon_calculator_button_new ("tan<sup>-1</sup>");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp240_, _tmp237_);
	_g_free0 (_tmp237_);
	g_object_set ((GtkActionable*) _tmp240_, "action-target", _tmp238_, NULL);
	_g_variant_unref0 (_tmp238_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp240_, _tmp239_);
	_g_free0 (_tmp239_);
	g_object_ref_sink (_tmp240_);
	button_atan = _tmp240_;
	_tmp241_ = g_strdup (_ ("Reciprocal"));
	_tmp242_ = pantheon_calculator_button_new ("x<sup>-1</sup>");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp242_, _tmp241_);
	_g_free0 (_tmp241_);
	g_object_ref_sink (_tmp242_);
	button_reciprocal = _tmp242_;
	_tmp243_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_start ((GtkWidget*) _tmp243_, 6);
	gtk_grid_set_column_spacing (_tmp243_, 6);
	gtk_grid_set_row_spacing (_tmp243_, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp243_, GTK_ALIGN_FILL);
	gtk_grid_set_row_homogeneous (_tmp243_, TRUE);
	g_object_ref_sink (_tmp243_);
	extended_grid = _tmp243_;
	_tmp244_ = extended_grid;
	_tmp245_ = button_ms;
	gtk_grid_attach (_tmp244_, (GtkWidget*) _tmp245_, 0, 0, 1, 1);
	_tmp246_ = extended_grid;
	_tmp247_ = button_par_left;
	gtk_grid_attach (_tmp246_, (GtkWidget*) _tmp247_, 1, 0, 1, 1);
	_tmp248_ = extended_grid;
	_tmp249_ = button_par_right;
	gtk_grid_attach (_tmp248_, (GtkWidget*) _tmp249_, 2, 0, 1, 1);
	_tmp250_ = extended_grid;
	_tmp251_ = button_log;
	gtk_grid_attach (_tmp250_, (GtkWidget*) _tmp251_, 3, 0, 1, 1);
	_tmp252_ = extended_grid;
	_tmp253_ = self->priv->button_mr;
	gtk_grid_attach (_tmp252_, (GtkWidget*) _tmp253_, 0, 1, 1, 1);
	_tmp254_ = extended_grid;
	_tmp255_ = button_pow;
	gtk_grid_attach (_tmp254_, (GtkWidget*) _tmp255_, 1, 1, 1, 1);
	_tmp256_ = extended_grid;
	_tmp257_ = button_sr;
	gtk_grid_attach (_tmp256_, (GtkWidget*) _tmp257_, 2, 1, 1, 1);
	_tmp258_ = extended_grid;
	_tmp259_ = button_ln;
	gtk_grid_attach (_tmp258_, (GtkWidget*) _tmp259_, 3, 1, 1, 1);
	_tmp260_ = extended_grid;
	_tmp261_ = button_m_add;
	gtk_grid_attach (_tmp260_, (GtkWidget*) _tmp261_, 0, 2, 1, 1);
	_tmp262_ = extended_grid;
	_tmp263_ = button_sin;
	gtk_grid_attach (_tmp262_, (GtkWidget*) _tmp263_, 1, 2, 1, 1);
	_tmp264_ = extended_grid;
	_tmp265_ = button_sinh;
	gtk_grid_attach (_tmp264_, (GtkWidget*) _tmp265_, 2, 2, 1, 1);
	_tmp266_ = extended_grid;
	_tmp267_ = button_asin;
	gtk_grid_attach (_tmp266_, (GtkWidget*) _tmp267_, 3, 2, 1, 1);
	_tmp268_ = extended_grid;
	_tmp269_ = button_m_sub;
	gtk_grid_attach (_tmp268_, (GtkWidget*) _tmp269_, 0, 3, 1, 1);
	_tmp270_ = extended_grid;
	_tmp271_ = button_cos;
	gtk_grid_attach (_tmp270_, (GtkWidget*) _tmp271_, 1, 3, 1, 1);
	_tmp272_ = extended_grid;
	_tmp273_ = button_cosh;
	gtk_grid_attach (_tmp272_, (GtkWidget*) _tmp273_, 2, 3, 1, 1);
	_tmp274_ = extended_grid;
	_tmp275_ = button_acos;
	gtk_grid_attach (_tmp274_, (GtkWidget*) _tmp275_, 3, 3, 1, 1);
	_tmp276_ = extended_grid;
	_tmp277_ = self->priv->button_mc;
	gtk_grid_attach (_tmp276_, (GtkWidget*) _tmp277_, 0, 4, 1, 1);
	_tmp278_ = extended_grid;
	_tmp279_ = button_tan;
	gtk_grid_attach (_tmp278_, (GtkWidget*) _tmp279_, 1, 4, 1, 1);
	_tmp280_ = extended_grid;
	_tmp281_ = button_tanh;
	gtk_grid_attach (_tmp280_, (GtkWidget*) _tmp281_, 2, 4, 1, 1);
	_tmp282_ = extended_grid;
	_tmp283_ = button_atan;
	gtk_grid_attach (_tmp282_, (GtkWidget*) _tmp283_, 3, 4, 1, 1);
	_tmp284_ = extended_grid;
	_tmp285_ = self->priv->button_gt;
	gtk_grid_attach (_tmp284_, (GtkWidget*) _tmp285_, 0, 5, 1, 1);
	_tmp286_ = extended_grid;
	_tmp287_ = button_pi;
	gtk_grid_attach (_tmp286_, (GtkWidget*) _tmp287_, 1, 5, 1, 1);
	_tmp288_ = extended_grid;
	_tmp289_ = button_e;
	gtk_grid_attach (_tmp288_, (GtkWidget*) _tmp289_, 2, 5, 1, 1);
	_tmp290_ = extended_grid;
	_tmp291_ = button_reciprocal;
	gtk_grid_attach (_tmp290_, (GtkWidget*) _tmp291_, 3, 5, 1, 1);
	_tmp292_ = extended_grid;
	_tmp293_ = _g_object_ref0 ((GtkWidget*) _tmp292_);
	_tmp294_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_transition_type (_tmp294_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	gtk_revealer_set_child (_tmp294_, _tmp293_);
	_g_object_unref0 (_tmp293_);
	g_object_ref_sink (_tmp294_);
	_g_object_unref0 (self->priv->extended_revealer);
	self->priv->extended_revealer = _tmp294_;
	_tmp295_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp295_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp295_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp295_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp295_, 6);
	g_object_ref_sink (_tmp295_);
	main_grid = _tmp295_;
	_tmp296_ = main_grid;
	_tmp297_ = basic_grid;
	gtk_box_append (_tmp296_, (GtkWidget*) _tmp297_);
	_tmp298_ = main_grid;
	_tmp299_ = self->priv->extended_revealer;
	gtk_box_append (_tmp298_, (GtkWidget*) _tmp299_);
	_tmp300_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp300_);
	_g_object_unref0 (self->priv->infobar_label);
	self->priv->infobar_label = _tmp300_;
	_tmp301_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_info_bar_set_message_type (_tmp301_, GTK_MESSAGE_WARNING);
	gtk_info_bar_set_revealed (_tmp301_, FALSE);
	gtk_info_bar_set_show_close_button (_tmp301_, FALSE);
	g_object_ref_sink (_tmp301_);
	_g_object_unref0 (self->priv->infobar);
	self->priv->infobar = _tmp301_;
	_tmp302_ = self->priv->infobar;
	_tmp303_ = self->priv->infobar_label;
	gtk_info_bar_add_child (_tmp302_, (GtkWidget*) _tmp303_);
	_tmp304_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp304_);
	global_box = _tmp304_;
	_tmp305_ = global_box;
	_tmp306_ = self->priv->infobar;
	gtk_box_append (_tmp305_, (GtkWidget*) _tmp306_);
	_tmp307_ = global_box;
	_tmp308_ = main_grid;
	gtk_box_append (_tmp307_, (GtkWidget*) _tmp308_);
	_tmp309_ = global_box;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp309_);
	_tmp310_ = headerbar;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp310_);
	_tmp311_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp311_);
	_tmp312_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp312_, "changed", (GCallback) _pantheon_calculator_main_window_remove_error_gtk_editable_changed, self, 0);
	_tmp313_ = self->priv->entry;
	g_signal_connect_object (_tmp313_, "activate", (GCallback) _pantheon_calculator_main_window_button_calc_clicked_gtk_entry_activate, self, 0);
	_tmp314_ = self->priv->entry;
	_tmp315_ = gtk_editable_get_delegate ((GtkEditable*) _tmp314_);
	g_signal_connect_object (_tmp315_, "insert-text", (GCallback) _pantheon_calculator_main_window_replace_text_gtk_editable_insert_text, self, 0);
	_tmp316_ = self->priv->button_calc;
	g_signal_connect_object (_tmp316_, "clicked", (GCallback) __pantheon_calculator_main_window___lambda38__gtk_button_clicked, self, 0);
	_tmp317_ = self->priv->button_del;
	g_signal_connect_object (_tmp317_, "clicked", (GCallback) __pantheon_calculator_main_window___lambda39__gtk_button_clicked, self, 0);
	_tmp318_ = self->priv->button_ans;
	g_signal_connect_object (_tmp318_, "clicked", (GCallback) __pantheon_calculator_main_window___lambda40__gtk_button_clicked, self, 0);
	_tmp319_ = self->priv->button_mr;
	g_signal_connect_object (_tmp319_, "clicked", (GCallback) __pantheon_calculator_main_window___lambda41__gtk_button_clicked, self, 0);
	_tmp320_ = button_ms;
	g_signal_connect_object ((GtkButton*) _tmp320_, "clicked", (GCallback) __pantheon_calculator_main_window___lambda42__gtk_button_clicked, self, 0);
	_tmp321_ = button_m_add;
	g_signal_connect_object ((GtkButton*) _tmp321_, "clicked", (GCallback) __pantheon_calculator_main_window___lambda43__gtk_button_clicked, self, 0);
	_tmp322_ = button_m_sub;
	g_signal_connect_object ((GtkButton*) _tmp322_, "clicked", (GCallback) __pantheon_calculator_main_window___lambda44__gtk_button_clicked, self, 0);
	_tmp323_ = self->priv->button_mc;
	g_signal_connect_object (_tmp323_, "clicked", (GCallback) __pantheon_calculator_main_window___lambda45__gtk_button_clicked, self, 0);
	_tmp324_ = self->priv->button_gt;
	g_signal_connect_object (_tmp324_, "clicked", (GCallback) __pantheon_calculator_main_window___lambda46__gtk_button_clicked, self, 0);
	_tmp325_ = button_reciprocal;
	g_signal_connect_object ((GtkButton*) _tmp325_, "clicked", (GCallback) __pantheon_calculator_main_window___lambda47__gtk_button_clicked, self, 0);
	_tmp326_ = pantheon_calculator_main_window_settings;
	_tmp327_ = self->priv->button_extended;
	g_settings_bind (_tmp326_, "extended-shown", (GObject*) _tmp327_, "active", G_SETTINGS_BIND_DEFAULT | G_SETTINGS_BIND_GET_NO_CHANGES);
	_tmp328_ = application_instance;
	_tmp329_ = gtk_application_get_windows (_tmp328_);
	if (g_list_length (_tmp329_) == ((guint) 0)) {
		GSettings* privacy_settings = NULL;
		GSettings* _tmp330_;
		GSettings* _tmp331_;
		_tmp330_ = g_settings_new ("org.gnome.desktop.privacy");
		privacy_settings = _tmp330_;
		_tmp331_ = privacy_settings;
		if (g_settings_get_boolean (_tmp331_, "remember-recent-files")) {
			GSettings* _tmp332_;
			GtkEntry* _tmp333_;
			_tmp332_ = pantheon_calculator_main_window_settings;
			_tmp333_ = self->priv->entry;
			g_settings_bind (_tmp332_, "entry-content", (GObject*) _tmp333_, "text", G_SETTINGS_BIND_DEFAULT);
		}
		_g_object_unref0 (privacy_settings);
	}
	_g_object_unref0 (global_box);
	_g_object_unref0 (main_grid);
	_g_object_unref0 (extended_grid);
	_g_object_unref0 (button_reciprocal);
	_g_object_unref0 (button_atan);
	_g_object_unref0 (button_acos);
	_g_object_unref0 (button_asin);
	_g_object_unref0 (button_ln);
	_g_object_unref0 (button_log);
	_g_object_unref0 (button_e);
	_g_object_unref0 (button_pi);
	_g_object_unref0 (button_tanh);
	_g_object_unref0 (button_tan);
	_g_object_unref0 (button_cosh);
	_g_object_unref0 (button_cos);
	_g_object_unref0 (button_sinh);
	_g_object_unref0 (button_sin);
	_g_object_unref0 (button_sr);
	_g_object_unref0 (button_pow);
	_g_object_unref0 (button_par_right);
	_g_object_unref0 (button_par_left);
	_g_object_unref0 (button_m_sub);
	_g_object_unref0 (button_m_add);
	_g_object_unref0 (button_ms);
	_g_object_unref0 (basic_grid);
	_g_object_unref0 (button_9);
	_g_object_unref0 (button_8);
	_g_object_unref0 (button_7);
	_g_object_unref0 (button_6);
	_g_object_unref0 (button_5);
	_g_object_unref0 (button_4);
	_g_object_unref0 (button_3);
	_g_object_unref0 (button_2);
	_g_object_unref0 (button_1);
	_g_object_unref0 (button_percent);
	_g_object_unref0 (button_point);
	_g_object_unref0 (button_0);
	_g_object_unref0 (button_div);
	_g_object_unref0 (button_mult);
	_g_object_unref0 (button_sub);
	_g_object_unref0 (button_add);
	_g_object_unref0 (button_clr);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (application_instance);
	return obj;
}

static void
pantheon_calculator_main_window_class_init (PantheonCalculatorMainWindowClass * klass,
                                            gpointer klass_data)
{
	GSettings* _tmp0_;
	pantheon_calculator_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonCalculatorMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = pantheon_calculator_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_calculator_main_window_finalize;
	_tmp0_ = g_settings_new ("io.elementary.calculator.saved-state");
	_g_object_unref0 (pantheon_calculator_main_window_settings);
	pantheon_calculator_main_window_settings = _tmp0_;
}

static void
pantheon_calculator_main_window_instance_init (PantheonCalculatorMainWindow * self,
                                               gpointer klass)
{
	self->priv = pantheon_calculator_main_window_get_instance_private (self);
	self->priv->memory_value = (gdouble) 0;
}

static void
pantheon_calculator_main_window_finalize (GObject * obj)
{
	PantheonCalculatorMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_CALCULATOR_TYPE_MAIN_WINDOW, PantheonCalculatorMainWindow);
	_g_object_unref0 (self->priv->extended_revealer);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->button_calc);
	_g_object_unref0 (self->priv->button_history);
	_g_object_unref0 (self->priv->button_ans);
	_g_object_unref0 (self->priv->button_del);
	_g_object_unref0 (self->priv->button_mr);
	_g_object_unref0 (self->priv->button_mc);
	_g_object_unref0 (self->priv->button_gt);
	_g_object_unref0 (self->priv->button_extended);
	_g_object_unref0 (self->priv->history_dialog);
	_g_object_unref0 (self->priv->infobar);
	_g_object_unref0 (self->priv->infobar_label);
	_g_object_unref0 (self->priv->eval);
	(self->priv->history == NULL) ? NULL : (self->priv->history = (_g_list_free__pantheon_calculator_main_window_history_free0_ (self->priv->history), NULL));
	G_OBJECT_CLASS (pantheon_calculator_main_window_parent_class)->finalize (obj);
}

static GType
pantheon_calculator_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonCalculatorMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_calculator_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonCalculatorMainWindow), 0, (GInstanceInitFunc) pantheon_calculator_main_window_instance_init, NULL };
	GType pantheon_calculator_main_window_type_id;
	pantheon_calculator_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "PantheonCalculatorMainWindow", &g_define_type_info, 0);
	PantheonCalculatorMainWindow_private_offset = g_type_add_instance_private (pantheon_calculator_main_window_type_id, sizeof (PantheonCalculatorMainWindowPrivate));
	return pantheon_calculator_main_window_type_id;
}

GType
pantheon_calculator_main_window_get_type (void)
{
	static volatile gsize pantheon_calculator_main_window_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_main_window_type_id__once)) {
		GType pantheon_calculator_main_window_type_id;
		pantheon_calculator_main_window_type_id = pantheon_calculator_main_window_get_type_once ();
		g_once_init_leave (&pantheon_calculator_main_window_type_id__once, pantheon_calculator_main_window_type_id);
	}
	return pantheon_calculator_main_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

