

#include "tcommon.h"

namespace SkeletonLut {

UCHAR FirstPreseedTable[] = {
    8, 0, 1, 0, 2, 2, 1, 0, 3, 3, 3, 3, 2, 2, 3, 3, 4, 4, 1, 0, 2, 2, 1, 0,
    4, 4, 3, 3, 2, 2, 3, 3, 5, 5, 1, 5, 2, 2, 1, 5, 5, 5, 5, 5, 2, 2, 5, 5,
    4, 4, 1, 5, 2, 2, 1, 5, 4, 4, 5, 5, 2, 2, 5, 5, 6, 6, 1, 6, 2, 2, 1, 6,
    6, 6, 6, 6, 2, 2, 6, 6, 4, 4, 1, 0, 2, 2, 1, 0, 4, 4, 8, 8, 2, 2, 8, 8,
    6, 6, 1, 6, 2, 2, 1, 6, 6, 6, 6, 6, 2, 2, 6, 6, 4, 4, 1, 0, 2, 2, 1, 0,
    4, 4, 8, 8, 2, 2, 8, 8, 7, 7, 1, 7, 2, 2, 1, 7, 7, 7, 7, 7, 2, 2, 7, 7,
    4, 4, 1, 0, 2, 2, 1, 0, 4, 4, 3, 3, 2, 2, 3, 3, 7, 7, 1, 7, 2, 2, 1, 7,
    7, 7, 7, 7, 2, 2, 7, 7, 4, 4, 1, 5, 2, 2, 1, 5, 4, 4, 5, 5, 2, 2, 5, 5,
    7, 7, 1, 7, 2, 2, 1, 7, 7, 7, 7, 7, 2, 2, 7, 7, 4, 4, 1, 0, 2, 2, 1, 0,
    4, 4, 8, 8, 2, 2, 8, 8, 7, 7, 1, 7, 2, 2, 1, 7, 7, 7, 7, 7, 2, 2, 7, 7,
    4, 4, 1, 0, 2, 2, 1, 0, 4, 4, 8, 8, 2, 2, 8, 8};

UCHAR FirstPreseedTableRev[] = {
    8, 0, 1, 1, 2, 2, 2, 2, 3, 0, 1, 1, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 1, 5, 2, 2, 2, 5, 3, 0, 1, 1, 2, 2, 2, 2,
    4, 4, 4, 5, 4, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 1, 6, 2, 2, 2, 6,
    3, 0, 1, 1, 2, 2, 2, 2, 6, 6, 6, 6, 6, 6, 6, 6, 3, 0, 8, 8, 3, 0, 8, 8,
    5, 5, 1, 5, 2, 2, 2, 5, 3, 0, 1, 1, 2, 2, 2, 2, 5, 5, 5, 5, 5, 5, 5, 5,
    3, 0, 8, 8, 3, 0, 8, 8, 7, 7, 1, 7, 2, 2, 2, 7, 7, 7, 7, 7, 2, 2, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 1, 7, 2, 2, 2, 7,
    7, 7, 7, 7, 2, 2, 7, 7, 7, 7, 7, 5, 7, 7, 7, 5, 7, 7, 7, 7, 7, 7, 7, 7,
    6, 6, 1, 6, 2, 2, 2, 6, 3, 0, 1, 1, 2, 2, 2, 2, 6, 6, 6, 6, 6, 6, 6, 6,
    3, 0, 8, 8, 3, 0, 8, 8, 5, 5, 1, 5, 2, 2, 2, 5, 3, 0, 1, 1, 2, 2, 2, 2,
    5, 5, 5, 5, 5, 5, 5, 5, 3, 0, 8, 8, 3, 0, 8, 8};

UCHAR NextPointTable[] = {
    8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 2, 2, 2, 2, 2, 2, 2,
    1, 2, 2, 2, 2, 2, 2, 0, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0,
    0, 0, 0, 0, 0, 3, 3, 1, 1, 1, 1, 1, 1, 3, 0, 1, 1, 1, 1, 1, 1, 3, 3, 3, 2,
    2, 2, 2, 2, 3, 0, 0, 2, 2, 2, 2, 2, 3, 3, 1, 2, 2, 2, 2, 2, 3, 0, 1, 2, 2,
    2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 4, 0, 4, 4, 4, 4, 4, 1, 4, 1, 4,
    4, 4, 4, 0, 1, 4, 1, 4, 4, 4, 4, 4, 4, 4, 2, 4, 4, 4, 4, 0, 0, 4, 2, 4, 4,
    4, 4, 4, 1, 4, 2, 4, 4, 4, 4, 0, 1, 4, 2, 4, 4, 4, 3, 3, 3, 4, 3, 4, 4, 4,
    3, 0, 0, 4, 0, 4, 4, 4, 3, 3, 1, 4, 1, 4, 4, 4, 3, 0, 1, 4, 1, 4, 4, 4, 3,
    3, 3, 4, 2, 4, 4, 4, 3, 0, 0, 4, 2, 4, 4, 4, 3, 3, 1, 4, 2, 4, 4, 4, 3, 0,
    1, 4, 2, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 5, 0, 0, 0, 0, 5, 5, 1,
    5, 1, 1, 1, 1, 5, 0, 1, 5, 1, 1, 1, 1, 5, 5, 5, 5, 2, 2, 2, 2, 5, 0, 0, 5,
    2, 2, 2, 2, 5, 5, 1, 5, 2, 2, 2, 2, 5, 0, 1, 5, 2, 2, 2, 2, 3, 3, 3, 5, 3,
    3, 3, 3, 3, 0, 0, 5, 0, 0, 0, 0, 3, 3, 1, 5, 1, 1, 1, 1, 3, 0, 1, 5, 1, 1,
    1, 1, 3, 3, 3, 5, 2, 2, 2, 2, 3, 0, 0, 5, 2, 2, 2, 2, 3, 3, 1, 5, 2, 2, 2,
    2, 3, 0, 1, 5, 2, 2, 2, 2, 5, 5, 5, 5, 5, 4, 4, 4, 5, 0, 0, 5, 0, 4, 4, 4,
    5, 5, 1, 5, 1, 4, 4, 4, 5, 0, 1, 5, 1, 4, 4, 4, 5, 5, 5, 5, 2, 4, 4, 4, 5,
    0, 0, 5, 2, 4, 4, 4, 5, 5, 1, 5, 2, 4, 4, 4, 5, 0, 1, 5, 2, 4, 4, 4, 3, 3,
    3, 5, 3, 4, 4, 4, 3, 0, 0, 5, 0, 4, 4, 4, 3, 3, 1, 5, 1, 4, 4, 4, 3, 0, 1,
    5, 1, 4, 4, 4, 3, 3, 3, 5, 2, 4, 4, 4, 3, 0, 0, 5, 2, 4, 4, 4, 3, 3, 1, 5,
    2, 4, 4, 4, 3, 0, 1, 5, 2, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 6, 0,
    6, 0, 0, 6, 6, 1, 6, 1, 6, 1, 1, 6, 0, 1, 6, 1, 6, 1, 1, 6, 6, 6, 6, 2, 6,
    2, 2, 6, 0, 0, 6, 2, 6, 2, 2, 6, 6, 1, 6, 2, 6, 2, 2, 6, 0, 1, 6, 2, 6, 2,
    2, 3, 3, 3, 6, 3, 6, 3, 3, 3, 0, 0, 6, 0, 6, 0, 0, 3, 3, 1, 6, 1, 6, 1, 1,
    3, 0, 1, 6, 1, 6, 1, 1, 3, 3, 3, 6, 2, 6, 2, 2, 3, 0, 0, 6, 2, 6, 2, 2, 3,
    3, 1, 6, 2, 6, 2, 2, 3, 0, 1, 6, 2, 6, 2, 2, 6, 6, 6, 6, 6, 6, 4, 4, 6, 0,
    0, 6, 0, 6, 4, 4, 6, 6, 1, 6, 1, 6, 4, 4, 6, 0, 1, 6, 1, 6, 4, 4, 6, 6, 6,
    6, 2, 6, 4, 4, 6, 0, 0, 6, 2, 6, 4, 4, 6, 6, 1, 6, 2, 6, 4, 4, 6, 0, 1, 6,
    2, 6, 4, 4, 3, 3, 3, 6, 3, 6, 4, 4, 3, 0, 0, 6, 0, 6, 4, 4, 3, 3, 1, 6, 1,
    6, 4, 4, 3, 0, 1, 6, 1, 6, 4, 4, 3, 3, 3, 6, 2, 6, 4, 4, 3, 0, 0, 6, 2, 6,
    4, 4, 3, 3, 1, 6, 2, 6, 4, 4, 3, 0, 1, 6, 2, 6, 4, 4, 5, 5, 5, 5, 5, 6, 5,
    5, 5, 0, 0, 5, 0, 6, 0, 0, 5, 5, 1, 5, 1, 6, 1, 1, 5, 0, 1, 5, 1, 6, 1, 1,
    5, 5, 5, 5, 2, 6, 2, 2, 5, 0, 0, 5, 2, 6, 2, 2, 5, 5, 1, 5, 2, 6, 2, 2, 5,
    0, 1, 5, 2, 6, 2, 2, 3, 3, 3, 5, 3, 6, 3, 3, 3, 0, 0, 5, 0, 6, 0, 0, 3, 3,
    1, 5, 1, 6, 1, 1, 3, 0, 1, 5, 1, 6, 1, 1, 3, 3, 3, 5, 2, 6, 2, 2, 3, 0, 0,
    5, 2, 6, 2, 2, 3, 3, 1, 5, 2, 6, 2, 2, 3, 0, 1, 5, 2, 6, 2, 2, 5, 5, 5, 5,
    5, 6, 4, 4, 5, 0, 0, 5, 0, 6, 4, 4, 5, 5, 1, 5, 1, 6, 4, 4, 5, 0, 1, 5, 1,
    6, 4, 4, 5, 5, 5, 5, 2, 6, 4, 4, 5, 0, 0, 5, 2, 6, 4, 4, 5, 5, 1, 5, 2, 6,
    4, 4, 5, 0, 1, 5, 2, 6, 4, 4, 3, 3, 3, 5, 3, 6, 4, 4, 3, 0, 0, 5, 0, 6, 4,
    4, 3, 3, 1, 5, 1, 6, 4, 4, 3, 0, 1, 5, 1, 6, 4, 4, 3, 3, 3, 5, 2, 6, 4, 4,
    3, 0, 0, 5, 2, 6, 4, 4, 3, 3, 1, 5, 2, 6, 4, 4, 3, 0, 1, 5, 2, 6, 4, 4, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 0, 0, 7, 0, 7, 7, 0, 7, 7, 1, 7, 1, 7, 7, 1, 7, 0,
    1, 7, 1, 7, 7, 1, 7, 7, 7, 7, 2, 7, 7, 2, 7, 0, 0, 7, 2, 7, 7, 2, 7, 7, 1,
    7, 2, 7, 7, 2, 7, 0, 1, 7, 2, 7, 7, 2, 3, 3, 3, 7, 3, 7, 7, 3, 3, 0, 0, 7,
    0, 7, 7, 0, 3, 3, 1, 7, 1, 7, 7, 1, 3, 0, 1, 7, 1, 7, 7, 1, 3, 3, 3, 7, 2,
    7, 7, 2, 3, 0, 0, 7, 2, 7, 7, 2, 3, 3, 1, 7, 2, 7, 7, 2, 3, 0, 1, 7, 2, 7,
    7, 2, 7, 7, 7, 7, 7, 7, 7, 4, 7, 0, 0, 7, 0, 7, 7, 4, 7, 7, 1, 7, 1, 7, 7,
    4, 7, 0, 1, 7, 1, 7, 7, 4, 7, 7, 7, 7, 2, 7, 7, 4, 7, 0, 0, 7, 2, 7, 7, 4,
    7, 7, 1, 7, 2, 7, 7, 4, 7, 0, 1, 7, 2, 7, 7, 4, 3, 3, 3, 7, 3, 7, 7, 4, 3,
    0, 0, 7, 0, 7, 7, 4, 3, 3, 1, 7, 1, 7, 7, 4, 3, 0, 1, 7, 1, 7, 7, 4, 3, 3,
    3, 7, 2, 7, 7, 4, 3, 0, 0, 7, 2, 7, 7, 4, 3, 3, 1, 7, 2, 7, 7, 4, 3, 0, 1,
    7, 2, 7, 7, 4, 5, 5, 5, 5, 5, 7, 7, 5, 5, 0, 0, 5, 0, 7, 7, 0, 5, 5, 1, 5,
    1, 7, 7, 1, 5, 0, 1, 5, 1, 7, 7, 1, 5, 5, 5, 5, 2, 7, 7, 2, 5, 0, 0, 5, 2,
    7, 7, 2, 5, 5, 1, 5, 2, 7, 7, 2, 5, 0, 1, 5, 2, 7, 7, 2, 3, 3, 3, 5, 3, 7,
    7, 3, 3, 0, 0, 5, 0, 7, 7, 0, 3, 3, 1, 5, 1, 7, 7, 1, 3, 0, 1, 5, 1, 7, 7,
    1, 3, 3, 3, 5, 2, 7, 7, 2, 3, 0, 0, 5, 2, 7, 7, 2, 3, 3, 1, 5, 2, 7, 7, 2,
    3, 0, 1, 5, 2, 7, 7, 2, 5, 5, 5, 5, 5, 7, 7, 4, 5, 0, 0, 5, 0, 7, 7, 4, 5,
    5, 1, 5, 1, 7, 7, 4, 5, 0, 1, 5, 1, 7, 7, 4, 5, 5, 5, 5, 2, 7, 7, 4, 5, 0,
    0, 5, 2, 7, 7, 4, 5, 5, 1, 5, 2, 7, 7, 4, 5, 0, 1, 5, 2, 7, 7, 4, 3, 3, 3,
    5, 3, 7, 7, 4, 3, 0, 0, 5, 0, 7, 7, 4, 3, 3, 1, 5, 1, 7, 7, 4, 3, 0, 1, 5,
    1, 7, 7, 4, 3, 3, 3, 5, 2, 7, 7, 4, 3, 0, 0, 5, 2, 7, 7, 4, 3, 3, 1, 5, 2,
    7, 7, 4, 3, 0, 1, 5, 2, 7, 7, 4, 6, 6, 6, 6, 6, 6, 7, 6, 6, 0, 0, 6, 0, 6,
    7, 0, 6, 6, 1, 6, 1, 6, 7, 1, 6, 0, 1, 6, 1, 6, 7, 1, 6, 6, 6, 6, 2, 6, 7,
    2, 6, 0, 0, 6, 2, 6, 7, 2, 6, 6, 1, 6, 2, 6, 7, 2, 6, 0, 1, 6, 2, 6, 7, 2,
    3, 3, 3, 6, 3, 6, 7, 3, 3, 0, 0, 6, 0, 6, 7, 0, 3, 3, 1, 6, 1, 6, 7, 1, 3,
    0, 1, 6, 1, 6, 7, 1, 3, 3, 3, 6, 2, 6, 7, 2, 3, 0, 0, 6, 2, 6, 7, 2, 3, 3,
    1, 6, 2, 6, 7, 2, 3, 0, 1, 6, 2, 6, 7, 2, 6, 6, 6, 6, 6, 6, 7, 4, 6, 0, 0,
    6, 0, 6, 7, 4, 6, 6, 1, 6, 1, 6, 7, 4, 6, 0, 1, 6, 1, 6, 7, 4, 6, 6, 6, 6,
    2, 6, 7, 4, 6, 0, 0, 6, 2, 6, 7, 4, 6, 6, 1, 6, 2, 6, 7, 4, 6, 0, 1, 6, 2,
    6, 7, 4, 3, 3, 3, 6, 3, 6, 7, 4, 3, 0, 0, 6, 0, 6, 7, 4, 3, 3, 1, 6, 1, 6,
    7, 4, 3, 0, 1, 6, 1, 6, 7, 4, 3, 3, 3, 6, 2, 6, 7, 4, 3, 0, 0, 6, 2, 6, 7,
    4, 3, 3, 1, 6, 2, 6, 7, 4, 3, 0, 1, 6, 2, 6, 7, 4, 5, 5, 5, 5, 5, 6, 7, 5,
    5, 0, 0, 5, 0, 6, 7, 0, 5, 5, 1, 5, 1, 6, 7, 1, 5, 0, 1, 5, 1, 6, 7, 1, 5,
    5, 5, 5, 2, 6, 7, 2, 5, 0, 0, 5, 2, 6, 7, 2, 5, 5, 1, 5, 2, 6, 7, 2, 5, 0,
    1, 5, 2, 6, 7, 2, 3, 3, 3, 5, 3, 6, 7, 3, 3, 0, 0, 5, 0, 6, 7, 0, 3, 3, 1,
    5, 1, 6, 7, 1, 3, 0, 1, 5, 1, 6, 7, 1, 3, 3, 3, 5, 2, 6, 7, 2, 3, 0, 0, 5,
    2, 6, 7, 2, 3, 3, 1, 5, 2, 6, 7, 2, 3, 0, 1, 5, 2, 6, 7, 2, 5, 5, 5, 5, 5,
    6, 7, 4, 5, 0, 0, 5, 0, 6, 7, 4, 5, 5, 1, 5, 1, 6, 7, 4, 5, 0, 1, 5, 1, 6,
    7, 4, 5, 5, 5, 5, 2, 6, 7, 4, 5, 0, 0, 5, 2, 6, 7, 4, 5, 5, 1, 5, 2, 6, 7,
    4, 5, 0, 1, 5, 2, 6, 7, 4, 3, 3, 3, 5, 3, 6, 7, 4, 3, 0, 0, 5, 0, 6, 7, 4,
    3, 3, 1, 5, 1, 6, 7, 4, 3, 0, 1, 5, 1, 6, 7, 4, 3, 3, 3, 5, 2, 6, 7, 4, 3,
    0, 0, 5, 2, 6, 7, 4, 3, 3, 1, 5, 2, 6, 7, 4, 3, 0, 1, 5, 2, 6, 7, 4};

UCHAR NextPointTableRev[] = {
    8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 1, 2,
    1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    0, 3, 3, 3, 3, 1, 3, 3, 1, 3, 3, 3, 3, 1, 3, 3, 0, 3, 3, 3, 3, 2, 2, 3, 2,
    3, 3, 3, 3, 2, 2, 3, 0, 3, 3, 3, 3, 1, 2, 3, 1, 3, 3, 3, 3, 1, 2, 3, 0, 3,
    3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 1, 4, 4, 1, 1, 1,
    1, 1, 1, 4, 4, 0, 0, 0, 0, 0, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 0, 0, 0, 0,
    0, 1, 2, 4, 1, 1, 1, 1, 1, 1, 2, 4, 0, 0, 0, 0, 0, 4, 4, 4, 4, 3, 3, 3, 3,
    4, 4, 4, 0, 3, 3, 3, 3, 1, 4, 4, 1, 3, 3, 3, 3, 1, 4, 4, 0, 3, 3, 3, 3, 2,
    2, 4, 2, 3, 3, 3, 3, 2, 2, 4, 0, 3, 3, 3, 3, 1, 2, 4, 1, 3, 3, 3, 3, 1, 2,
    4, 0, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 0, 5, 5, 1, 5, 5,
    1, 5, 1, 5, 5, 1, 5, 5, 0, 5, 0, 5, 5, 2, 2, 5, 2, 5, 2, 5, 5, 2, 2, 5, 0,
    5, 0, 5, 5, 1, 2, 5, 1, 5, 1, 5, 5, 1, 2, 5, 0, 5, 0, 5, 5, 5, 5, 5, 5, 5,
    3, 5, 5, 5, 5, 5, 0, 5, 3, 5, 5, 1, 5, 5, 1, 5, 3, 5, 5, 1, 5, 5, 0, 5, 3,
    5, 5, 2, 2, 5, 2, 5, 3, 5, 5, 2, 2, 5, 0, 5, 3, 5, 5, 1, 2, 5, 1, 5, 3, 5,
    5, 1, 2, 5, 0, 5, 3, 5, 5, 4, 4, 4, 4, 5, 4, 5, 5, 4, 4, 4, 0, 5, 0, 5, 5,
    1, 4, 4, 1, 5, 1, 5, 5, 1, 4, 4, 0, 5, 0, 5, 5, 2, 2, 4, 2, 5, 2, 5, 5, 2,
    2, 4, 0, 5, 0, 5, 5, 1, 2, 4, 1, 5, 1, 5, 5, 1, 2, 4, 0, 5, 0, 5, 5, 4, 4,
    4, 4, 5, 3, 5, 5, 4, 4, 4, 0, 5, 3, 5, 5, 1, 4, 4, 1, 5, 3, 5, 5, 1, 4, 4,
    0, 5, 3, 5, 5, 2, 2, 4, 2, 5, 3, 5, 5, 2, 2, 4, 0, 5, 3, 5, 5, 1, 2, 4, 1,
    5, 3, 5, 5, 1, 2, 4, 0, 5, 3, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 6,
    0, 0, 6, 1, 6, 6, 1, 6, 1, 1, 6, 1, 6, 6, 0, 6, 0, 0, 6, 2, 2, 6, 2, 6, 2,
    2, 6, 2, 2, 6, 0, 6, 0, 0, 6, 1, 2, 6, 1, 6, 1, 1, 6, 1, 2, 6, 0, 6, 0, 0,
    6, 6, 6, 6, 6, 6, 3, 3, 6, 6, 6, 6, 0, 6, 3, 3, 6, 1, 6, 6, 1, 6, 3, 3, 6,
    1, 6, 6, 0, 6, 3, 3, 6, 2, 2, 6, 2, 6, 3, 3, 6, 2, 2, 6, 0, 6, 3, 3, 6, 1,
    2, 6, 1, 6, 3, 3, 6, 1, 2, 6, 0, 6, 3, 3, 6, 4, 4, 4, 4, 6, 4, 4, 6, 4, 4,
    4, 0, 6, 0, 0, 6, 1, 4, 4, 1, 6, 1, 1, 6, 1, 4, 4, 0, 6, 0, 0, 6, 2, 2, 4,
    2, 6, 2, 2, 6, 2, 2, 4, 0, 6, 0, 0, 6, 1, 2, 4, 1, 6, 1, 1, 6, 1, 2, 4, 0,
    6, 0, 0, 6, 4, 4, 4, 4, 6, 3, 3, 6, 4, 4, 4, 0, 6, 3, 3, 6, 1, 4, 4, 1, 6,
    3, 3, 6, 1, 4, 4, 0, 6, 3, 3, 6, 2, 2, 4, 2, 6, 3, 3, 6, 2, 2, 4, 0, 6, 3,
    3, 6, 1, 2, 4, 1, 6, 3, 3, 6, 1, 2, 4, 0, 6, 3, 3, 6, 6, 6, 6, 6, 6, 6, 5,
    6, 6, 6, 6, 0, 6, 0, 5, 6, 1, 6, 6, 1, 6, 1, 5, 6, 1, 6, 6, 0, 6, 0, 5, 6,
    2, 2, 6, 2, 6, 2, 5, 6, 2, 2, 6, 0, 6, 0, 5, 6, 1, 2, 6, 1, 6, 1, 5, 6, 1,
    2, 6, 0, 6, 0, 5, 6, 6, 6, 6, 6, 6, 3, 5, 6, 6, 6, 6, 0, 6, 3, 5, 6, 1, 6,
    6, 1, 6, 3, 5, 6, 1, 6, 6, 0, 6, 3, 5, 6, 2, 2, 6, 2, 6, 3, 5, 6, 2, 2, 6,
    0, 6, 3, 5, 6, 1, 2, 6, 1, 6, 3, 5, 6, 1, 2, 6, 0, 6, 3, 5, 6, 4, 4, 4, 4,
    6, 4, 5, 6, 4, 4, 4, 0, 6, 0, 5, 6, 1, 4, 4, 1, 6, 1, 5, 6, 1, 4, 4, 0, 6,
    0, 5, 6, 2, 2, 4, 2, 6, 2, 5, 6, 2, 2, 4, 0, 6, 0, 5, 6, 1, 2, 4, 1, 6, 1,
    5, 6, 1, 2, 4, 0, 6, 0, 5, 6, 4, 4, 4, 4, 6, 3, 5, 6, 4, 4, 4, 0, 6, 3, 5,
    6, 1, 4, 4, 1, 6, 3, 5, 6, 1, 4, 4, 0, 6, 3, 5, 6, 2, 2, 4, 2, 6, 3, 5, 6,
    2, 2, 4, 0, 6, 3, 5, 6, 1, 2, 4, 1, 6, 3, 5, 6, 1, 2, 4, 0, 6, 3, 5, 6, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0, 7, 0, 0, 0, 1, 7, 7, 1, 7, 1, 1, 1, 1, 7,
    7, 0, 7, 0, 0, 0, 2, 2, 7, 2, 7, 2, 2, 2, 2, 2, 7, 0, 7, 0, 0, 0, 1, 2, 7,
    1, 7, 1, 1, 1, 1, 2, 7, 0, 7, 0, 0, 0, 7, 7, 7, 7, 7, 3, 3, 3, 7, 7, 7, 0,
    7, 3, 3, 3, 1, 7, 7, 1, 7, 3, 3, 3, 1, 7, 7, 0, 7, 3, 3, 3, 2, 2, 7, 2, 7,
    3, 3, 3, 2, 2, 7, 0, 7, 3, 3, 3, 1, 2, 7, 1, 7, 3, 3, 3, 1, 2, 7, 0, 7, 3,
    3, 3, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 0, 7, 0, 0, 0, 1, 4, 4, 1, 7, 1, 1,
    1, 1, 4, 4, 0, 7, 0, 0, 0, 2, 2, 4, 2, 7, 2, 2, 2, 2, 2, 4, 0, 7, 0, 0, 0,
    1, 2, 4, 1, 7, 1, 1, 1, 1, 2, 4, 0, 7, 0, 0, 0, 4, 4, 4, 4, 7, 3, 3, 3, 4,
    4, 4, 0, 7, 3, 3, 3, 1, 4, 4, 1, 7, 3, 3, 3, 1, 4, 4, 0, 7, 3, 3, 3, 2, 2,
    4, 2, 7, 3, 3, 3, 2, 2, 4, 0, 7, 3, 3, 3, 1, 2, 4, 1, 7, 3, 3, 3, 1, 2, 4,
    0, 7, 3, 3, 3, 7, 7, 7, 7, 7, 7, 5, 5, 7, 7, 7, 0, 7, 0, 5, 5, 1, 7, 7, 1,
    7, 1, 5, 5, 1, 7, 7, 0, 7, 0, 5, 5, 2, 2, 7, 2, 7, 2, 5, 5, 2, 2, 7, 0, 7,
    0, 5, 5, 1, 2, 7, 1, 7, 1, 5, 5, 1, 2, 7, 0, 7, 0, 5, 5, 7, 7, 7, 7, 7, 3,
    5, 5, 7, 7, 7, 0, 7, 3, 5, 5, 1, 7, 7, 1, 7, 3, 5, 5, 1, 7, 7, 0, 7, 3, 5,
    5, 2, 2, 7, 2, 7, 3, 5, 5, 2, 2, 7, 0, 7, 3, 5, 5, 1, 2, 7, 1, 7, 3, 5, 5,
    1, 2, 7, 0, 7, 3, 5, 5, 4, 4, 4, 4, 7, 4, 5, 5, 4, 4, 4, 0, 7, 0, 5, 5, 1,
    4, 4, 1, 7, 1, 5, 5, 1, 4, 4, 0, 7, 0, 5, 5, 2, 2, 4, 2, 7, 2, 5, 5, 2, 2,
    4, 0, 7, 0, 5, 5, 1, 2, 4, 1, 7, 1, 5, 5, 1, 2, 4, 0, 7, 0, 5, 5, 4, 4, 4,
    4, 7, 3, 5, 5, 4, 4, 4, 0, 7, 3, 5, 5, 1, 4, 4, 1, 7, 3, 5, 5, 1, 4, 4, 0,
    7, 3, 5, 5, 2, 2, 4, 2, 7, 3, 5, 5, 2, 2, 4, 0, 7, 3, 5, 5, 1, 2, 4, 1, 7,
    3, 5, 5, 1, 2, 4, 0, 7, 3, 5, 5, 7, 7, 7, 7, 7, 7, 7, 6, 7, 7, 7, 0, 7, 0,
    0, 6, 1, 7, 7, 1, 7, 1, 1, 6, 1, 7, 7, 0, 7, 0, 0, 6, 2, 2, 7, 2, 7, 2, 2,
    6, 2, 2, 7, 0, 7, 0, 0, 6, 1, 2, 7, 1, 7, 1, 1, 6, 1, 2, 7, 0, 7, 0, 0, 6,
    7, 7, 7, 7, 7, 3, 3, 6, 7, 7, 7, 0, 7, 3, 3, 6, 1, 7, 7, 1, 7, 3, 3, 6, 1,
    7, 7, 0, 7, 3, 3, 6, 2, 2, 7, 2, 7, 3, 3, 6, 2, 2, 7, 0, 7, 3, 3, 6, 1, 2,
    7, 1, 7, 3, 3, 6, 1, 2, 7, 0, 7, 3, 3, 6, 4, 4, 4, 4, 7, 4, 4, 6, 4, 4, 4,
    0, 7, 0, 0, 6, 1, 4, 4, 1, 7, 1, 1, 6, 1, 4, 4, 0, 7, 0, 0, 6, 2, 2, 4, 2,
    7, 2, 2, 6, 2, 2, 4, 0, 7, 0, 0, 6, 1, 2, 4, 1, 7, 1, 1, 6, 1, 2, 4, 0, 7,
    0, 0, 6, 4, 4, 4, 4, 7, 3, 3, 6, 4, 4, 4, 0, 7, 3, 3, 6, 1, 4, 4, 1, 7, 3,
    3, 6, 1, 4, 4, 0, 7, 3, 3, 6, 2, 2, 4, 2, 7, 3, 3, 6, 2, 2, 4, 0, 7, 3, 3,
    6, 1, 2, 4, 1, 7, 3, 3, 6, 1, 2, 4, 0, 7, 3, 3, 6, 7, 7, 7, 7, 7, 7, 5, 6,
    7, 7, 7, 0, 7, 0, 5, 6, 1, 7, 7, 1, 7, 1, 5, 6, 1, 7, 7, 0, 7, 0, 5, 6, 2,
    2, 7, 2, 7, 2, 5, 6, 2, 2, 7, 0, 7, 0, 5, 6, 1, 2, 7, 1, 7, 1, 5, 6, 1, 2,
    7, 0, 7, 0, 5, 6, 7, 7, 7, 7, 7, 3, 5, 6, 7, 7, 7, 0, 7, 3, 5, 6, 1, 7, 7,
    1, 7, 3, 5, 6, 1, 7, 7, 0, 7, 3, 5, 6, 2, 2, 7, 2, 7, 3, 5, 6, 2, 2, 7, 0,
    7, 3, 5, 6, 1, 2, 7, 1, 7, 3, 5, 6, 1, 2, 7, 0, 7, 3, 5, 6, 4, 4, 4, 4, 7,
    4, 5, 6, 4, 4, 4, 0, 7, 0, 5, 6, 1, 4, 4, 1, 7, 1, 5, 6, 1, 4, 4, 0, 7, 0,
    5, 6, 2, 2, 4, 2, 7, 2, 5, 6, 2, 2, 4, 0, 7, 0, 5, 6, 1, 2, 4, 1, 7, 1, 5,
    6, 1, 2, 4, 0, 7, 0, 5, 6, 4, 4, 4, 4, 7, 3, 5, 6, 4, 4, 4, 0, 7, 3, 5, 6,
    1, 4, 4, 1, 7, 3, 5, 6, 1, 4, 4, 0, 7, 3, 5, 6, 2, 2, 4, 2, 7, 3, 5, 6, 2,
    2, 4, 0, 7, 3, 5, 6, 1, 2, 4, 1, 7, 3, 5, 6, 1, 2, 4, 0, 7, 3, 5, 6};

UCHAR ConnectionTable[] = {0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0,
                           0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, /* 31*/
                           0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0,
                           0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, /* 63*/
                           0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1,
                           0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, /* 95*/
                           1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1,
                           0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, /*127*/
                           0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
                           0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, /*159*/
                           0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                           0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, /*191*/
                           1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1,
                           0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, /*223*/
                           1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1,
                           0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}; /*255*/

UCHAR NextSeedTable[] = {
    8,  8,  8,  25, 8,  8,  26, 25, 8,  48, 41, 41, 8,  8,  41, 41, 8,  8,  4,
    25, 12, 8,  4,  25, 8,  8,  41, 41, 8,  8,  41, 41, 8,  8,  8,  8,  8,  8,
    8,  8,  51, 51, 41, 41, 8,  8,  41, 41, 8,  8,  8,  8,  8,  8,  8,  8,  8,
    8,  41, 41, 8,  8,  41, 41, 8,  8,  8,  8,  8,  8,  8,  8,  59, 59, 41, 41,
    8,  8,  41, 41, 22, 8,  22, 25, 22, 8,  22, 25, 59, 59, 41, 41, 59, 59, 41,
    41, 37, 8,  8,  8,  8,  8,  8,  8,  59, 59, 41, 41, 8,  8,  41, 41, 22, 8,
    22, 25, 22, 8,  22, 25, 59, 59, 41, 41, 59, 59, 41, 41, 8,  8,  8,  8,  8,
    8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  15, 8,  4,  25, 12, 8,  4,  25,
    8,  8,  41, 41, 8,  8,  41, 41, 8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
    8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  41, 41, 8,  8,
    41, 41, 38, 8,  8,  8,  8,  8,  8,  8,  59, 59, 41, 41, 8,  8,  41, 41, 22,
    8,  22, 25, 22, 8,  22, 25, 59, 59, 41, 41, 59, 59, 41, 41, 38, 8,  8,  8,
    8,  8,  8,  8,  59, 59, 41, 41, 8,  8,  41, 41, 22, 8,  22, 25, 22, 8,  22,
    25, 59, 59, 41, 41, 59, 59, 41, 41};

UCHAR EndpointTable[] = {
    1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

UCHAR ExtremeEndpointTable[] = {
    1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

}  // namespace
