/* ExportFileSystem.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportFileSystem.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_FILE_SYSTEM (export_file_system_get_type ())
#define EXPORT_FILE_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_FILE_SYSTEM, ExportFileSystem))
#define EXPORT_FILE_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_FILE_SYSTEM, ExportFileSystemClass))
#define IS_EXPORT_FILE_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_FILE_SYSTEM))
#define IS_EXPORT_FILE_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_FILE_SYSTEM))
#define EXPORT_FILE_SYSTEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_FILE_SYSTEM, ExportFileSystemClass))

typedef struct _ExportFileSystem ExportFileSystem;
typedef struct _ExportFileSystemClass ExportFileSystemClass;
typedef struct _ExportFileSystemPrivate ExportFileSystemPrivate;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportFileSystem {
	Export parent_instance;
	ExportFileSystemPrivate * priv;
};

struct _ExportFileSystemClass {
	ExportClass parent_class;
};

static gpointer export_file_system_parent_class = NULL;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_file_system_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportFileSystem, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN gboolean export_import (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN void export_add_settings (Export* self,
                          GtkGrid* grid);
VALA_EXTERN void export_save_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN void export_load_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN ExportFileSystem* export_file_system_new (void);
VALA_EXTERN ExportFileSystem* export_file_system_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_file_system_real_export (Export* base,
                                         const gchar* dname,
                                         DrawArea* da);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
static gboolean export_file_system_export_node (ExportFileSystem* self,
                                         const gchar* dname,
                                         Node* node);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN gboolean node_is_leaf (Node* self);
VALA_EXTERN const gchar* node_get_note (Node* self);
VALA_EXTERN GArray* node_children (Node* self);
static gboolean export_file_system_real_import (Export* base,
                                         const gchar* dname,
                                         DrawArea* da);
VALA_EXTERN Node* draw_area_create_root_node (DrawArea* self,
                                  const gchar* name);
static gboolean export_file_system_import_node (ExportFileSystem* self,
                                         const gchar* dname,
                                         Node* parent,
                                         DrawArea* da);
VALA_EXTERN Node* draw_area_create_child_node (DrawArea* self,
                                   Node* parent,
                                   const gchar* name);
static void export_file_system_real_add_settings (Export* base,
                                           GtkGrid* grid);
static void export_file_system_real_save_settings (Export* base,
                                            xmlNode* node);
static void export_file_system_real_load_settings (Export* base,
                                            xmlNode* node);
static GType export_file_system_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportFileSystem*
export_file_system_construct (GType object_type)
{
	ExportFileSystem* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup ("*");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportFileSystem*) export_construct (object_type, "fs", _ ("File System"), _tmp2_, (gint) 1, TRUE, TRUE, TRUE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportFileSystem*
export_file_system_new (void)
{
	return export_file_system_construct (TYPE_EXPORT_FILE_SYSTEM);
}

static gboolean
export_file_system_real_export (Export* base,
                                const gchar* dname,
                                DrawArea* da)
{
	ExportFileSystem * self;
	gboolean result;
	self = (ExportFileSystem*) base;
	g_return_val_if_fail (dname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	if (g_mkdir (dname, 0775) == -1) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				gboolean _tmp4_;
				GArray* _tmp5_;
				GArray* _tmp6_;
				Node* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = draw_area_get_nodes (da);
				_tmp3_ = _tmp2_;
				_tmp4_ = !(((guint) i) < _tmp3_->len);
				_g_array_unref0 (_tmp3_);
				if (_tmp4_) {
					break;
				}
				_tmp5_ = draw_area_get_nodes (da);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_array_index (_tmp6_, Node*, (guint) i);
				_tmp8_ = !export_file_system_export_node (self, dname, _tmp7_);
				_g_array_unref0 (_tmp6_);
				if (_tmp8_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
export_file_system_export_node (ExportFileSystem* self,
                                const gchar* dname,
                                Node* node)
{
	gchar* path = NULL;
	CanvasText* _tmp0_;
	CanvasText* _tmp1_;
	FormattedText* _tmp2_;
	FormattedText* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dname != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node_get_name (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = canvas_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = formatted_text_get_text (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (dname, _tmp5_, NULL);
	path = _tmp6_;
	if (node_is_leaf (node)) {
		{
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = path;
			_tmp8_ = node_get_note (node);
			_tmp9_ = _tmp8_;
			g_file_set_contents (_tmp7_, _tmp9_, (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp10_ = FALSE;
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (path);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp10_;
			}
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			g_clear_error (&_inner_error0_);
			result = FALSE;
			_g_free0 (path);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp11_ = FALSE;
			_g_free0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
	} else {
		const gchar* _tmp12_;
		_tmp12_ = path;
		if (g_mkdir (_tmp12_, 0775) == -1) {
			result = FALSE;
			_g_free0 (path);
			return result;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					GArray* _tmp15_;
					GArray* _tmp16_;
					gboolean _tmp17_;
					const gchar* _tmp18_;
					GArray* _tmp19_;
					GArray* _tmp20_;
					Node* _tmp21_;
					gboolean _tmp22_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = i;
						i = _tmp14_ + 1;
					}
					_tmp13_ = FALSE;
					_tmp15_ = node_children (node);
					_tmp16_ = _tmp15_;
					_tmp17_ = !(((guint) i) < _tmp16_->len);
					_g_array_unref0 (_tmp16_);
					if (_tmp17_) {
						break;
					}
					_tmp18_ = path;
					_tmp19_ = node_children (node);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_array_index (_tmp20_, Node*, (guint) i);
					_tmp22_ = !export_file_system_export_node (self, _tmp18_, _tmp21_);
					_g_array_unref0 (_tmp20_);
					if (_tmp22_) {
						result = FALSE;
						_g_free0 (path);
						return result;
					}
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (path);
	return result;
}

static gboolean
export_file_system_real_import (Export* base,
                                const gchar* dname,
                                DrawArea* da)
{
	ExportFileSystem * self;
	Node* node = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	Node* _tmp2_;
	Node* _tmp3_;
	gboolean result;
	self = (ExportFileSystem*) base;
	g_return_val_if_fail (dname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = g_path_get_basename (dname);
	_tmp1_ = _tmp0_;
	_tmp2_ = draw_area_create_root_node (da, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	node = _tmp3_;
	result = export_file_system_import_node (self, dname, node, da);
	_g_object_unref0 (node);
	return result;
}

static gboolean
export_file_system_import_node (ExportFileSystem* self,
                                const gchar* dname,
                                Node* parent,
                                DrawArea* da)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dname != NULL, FALSE);
	g_return_val_if_fail (parent != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	if (g_file_test (dname, G_FILE_TEST_IS_DIR)) {
		GDir* dir = NULL;
		GDir* _tmp0_;
		gchar* name = NULL;
		_tmp0_ = g_dir_open (dname, (guint) 0, &_inner_error0_);
		dir = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		while (TRUE) {
			GDir* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			Node* node = NULL;
			const gchar* _tmp6_;
			Node* _tmp7_;
			gchar* path = NULL;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			Node* _tmp11_;
			_tmp2_ = dir;
			_tmp3_ = g_dir_read_name (_tmp2_);
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (name);
			name = _tmp4_;
			_tmp5_ = name;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			_tmp6_ = name;
			_tmp7_ = draw_area_create_child_node (da, parent, _tmp6_);
			node = _tmp7_;
			_tmp8_ = name;
			_tmp9_ = g_build_filename (dname, _tmp8_, NULL);
			path = _tmp9_;
			_tmp10_ = path;
			_tmp11_ = node;
			if (!export_file_system_import_node (self, _tmp10_, _tmp11_, da)) {
				result = FALSE;
				_g_free0 (path);
				_g_object_unref0 (node);
				_g_free0 (name);
				_g_dir_close0 (dir);
				return result;
			}
			_g_free0 (path);
			_g_object_unref0 (node);
		}
		_g_free0 (name);
		_g_dir_close0 (dir);
	}
	result = TRUE;
	return result;
}

static void
export_file_system_real_add_settings (Export* base,
                                      GtkGrid* grid)
{
	ExportFileSystem * self;
	self = (ExportFileSystem*) base;
	g_return_if_fail (grid != NULL);
}

static void
export_file_system_real_save_settings (Export* base,
                                       xmlNode* node)
{
	ExportFileSystem * self;
	self = (ExportFileSystem*) base;
}

static void
export_file_system_real_load_settings (Export* base,
                                       xmlNode* node)
{
	ExportFileSystem * self;
	self = (ExportFileSystem*) base;
}

static void
export_file_system_class_init (ExportFileSystemClass * klass,
                               gpointer klass_data)
{
	export_file_system_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_file_system_real_export;
	((ExportClass *) klass)->import = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_file_system_real_import;
	((ExportClass *) klass)->add_settings = (void (*) (Export*, GtkGrid*)) export_file_system_real_add_settings;
	((ExportClass *) klass)->save_settings = (void (*) (Export*, xmlNode*)) export_file_system_real_save_settings;
	((ExportClass *) klass)->load_settings = (void (*) (Export*, xmlNode*)) export_file_system_real_load_settings;
}

static void
export_file_system_instance_init (ExportFileSystem * self,
                                  gpointer klass)
{
}

static GType
export_file_system_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportFileSystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_file_system_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportFileSystem), 0, (GInstanceInitFunc) export_file_system_instance_init, NULL };
	GType export_file_system_type_id;
	export_file_system_type_id = g_type_register_static (TYPE_EXPORT, "ExportFileSystem", &g_define_type_info, 0);
	return export_file_system_type_id;
}

GType
export_file_system_get_type (void)
{
	static volatile gsize export_file_system_type_id__once = 0;
	if (g_once_init_enter (&export_file_system_type_id__once)) {
		GType export_file_system_type_id;
		export_file_system_type_id = export_file_system_get_type_once ();
		g_once_init_leave (&export_file_system_type_id__once, export_file_system_type_id);
	}
	return export_file_system_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

