/* NoteView.c generated by valac 0.56.18, the Vala compiler
 * generated from NoteView.vala, do not modify */

/*
* Copyright (c) 2017 Lains
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <handy.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	COMPLETION_PROVIDER_0_PROPERTY,
	COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* completion_provider_properties[COMPLETION_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTextIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTextIter_free (var), NULL)))

#define TYPE_NOTE_VIEW (note_view_get_type ())
#define NOTE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTE_VIEW, NoteView))
#define NOTE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTE_VIEW, NoteViewClass))
#define IS_NOTE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTE_VIEW))
#define IS_NOTE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTE_VIEW))
#define NOTE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTE_VIEW, NoteViewClass))

typedef struct _NoteView NoteView;
typedef struct _NoteViewClass NoteViewClass;
typedef struct _NoteViewPrivate NoteViewPrivate;

#define NOTE_VIEW_TYPE_URL_POS (note_view_url_pos_get_type ())
#define NOTE_VIEW_URL_POS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTE_VIEW_TYPE_URL_POS, NoteViewUrlPos))
#define NOTE_VIEW_URL_POS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTE_VIEW_TYPE_URL_POS, NoteViewUrlPosClass))
#define NOTE_VIEW_IS_URL_POS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTE_VIEW_TYPE_URL_POS))
#define NOTE_VIEW_IS_URL_POS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTE_VIEW_TYPE_URL_POS))
#define NOTE_VIEW_URL_POS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTE_VIEW_TYPE_URL_POS, NoteViewUrlPosClass))

typedef struct _NoteViewUrlPos NoteViewUrlPos;
typedef struct _NoteViewUrlPosClass NoteViewUrlPosClass;

#define NOTE_VIEW_TYPE_LINK_POS (note_view_link_pos_get_type ())
#define NOTE_VIEW_LINK_POS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTE_VIEW_TYPE_LINK_POS, NoteViewLinkPos))
#define NOTE_VIEW_LINK_POS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTE_VIEW_TYPE_LINK_POS, NoteViewLinkPosClass))
#define NOTE_VIEW_IS_LINK_POS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTE_VIEW_TYPE_LINK_POS))
#define NOTE_VIEW_IS_LINK_POS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTE_VIEW_TYPE_LINK_POS))
#define NOTE_VIEW_LINK_POS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTE_VIEW_TYPE_LINK_POS, NoteViewLinkPosClass))

typedef struct _NoteViewLinkPos NoteViewLinkPos;
typedef struct _NoteViewLinkPosClass NoteViewLinkPosClass;
enum  {
	NOTE_VIEW_0_PROPERTY,
	NOTE_VIEW_TEXT_PROPERTY,
	NOTE_VIEW_MODIFIED_PROPERTY,
	NOTE_VIEW_NUM_PROPERTIES
};
static GParamSpec* note_view_properties[NOTE_VIEW_NUM_PROPERTIES];
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block32Data Block32Data;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _NoteViewUrlPosPrivate NoteViewUrlPosPrivate;
#define _note_view_url_pos_unref0(var) ((var == NULL) ? NULL : (var = (note_view_url_pos_unref (var), NULL)))
typedef struct _NoteViewLinkPosPrivate NoteViewLinkPosPrivate;
#define _note_view_link_pos_unref0(var) ((var == NULL) ? NULL : (var = (note_view_link_pos_unref (var), NULL)))

#define TYPE_UNICODE_INSERT (unicode_insert_get_type ())
#define UNICODE_INSERT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNICODE_INSERT, UnicodeInsert))
#define UNICODE_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNICODE_INSERT, UnicodeInsertClass))
#define IS_UNICODE_INSERT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNICODE_INSERT))
#define IS_UNICODE_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNICODE_INSERT))
#define UNICODE_INSERT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNICODE_INSERT, UnicodeInsertClass))

typedef struct _UnicodeInsert UnicodeInsert;
typedef struct _UnicodeInsertClass UnicodeInsertClass;

#define TYPE_NODE_LINK (node_link_get_type ())
#define NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_LINK, NodeLink))
#define NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_LINK, NodeLinkClass))
#define IS_NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_LINK))
#define IS_NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_LINK))
#define NODE_LINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_LINK, NodeLinkClass))

typedef struct _NodeLink NodeLink;
typedef struct _NodeLinkClass NodeLinkClass;
typedef struct _NoteViewParamSpecUrlPos NoteViewParamSpecUrlPos;
typedef struct _NoteViewParamSpecLinkPos NoteViewParamSpecLinkPos;
enum  {
	NOTE_VIEW_NODE_LINK_ADDED_SIGNAL,
	NOTE_VIEW_NODE_LINK_CLICKED_SIGNAL,
	NOTE_VIEW_NODE_LINK_HOVER_SIGNAL,
	NOTE_VIEW_NUM_SIGNALS
};
static guint note_view_signals[NOTE_VIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
};

struct _CompletionProviderPrivate {
	MainWindow* _win;
	gchar* _name;
	GList* _proposals;
	GtkSourceBuffer* _buffer;
};

struct _NoteView {
	GtkSourceView parent_instance;
	NoteViewPrivate * priv;
	GtkSourceStyle* _srcstyle;
	GtkSourceBuffer* _buffer;
};

struct _NoteViewClass {
	GtkSourceViewClass parent_class;
};

struct _NoteViewPrivate {
	gint _last_lnum;
	gchar* _last_url;
	gint* _last_link;
	GArray* _last_urls;
	GArray* _last_links;
	gint _last_x;
	gint _last_y;
	GRegex* _url_re;
	GRegex* _link_re;
	GtkTooltip* _tooltip;
};

struct _Block32Data {
	int _ref_count_;
	NoteView* self;
	GtkSourceStyleSchemeManager* style_manager;
};

struct _NoteViewUrlPos {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NoteViewUrlPosPrivate * priv;
	gchar* url;
	gint start;
	gint end;
};

struct _NoteViewUrlPosClass {
	GTypeClass parent_class;
	void (*finalize) (NoteViewUrlPos *self);
};

struct _NoteViewLinkPos {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NoteViewLinkPosPrivate * priv;
	gint id;
	gint start;
	gint end;
};

struct _NoteViewLinkPosClass {
	GTypeClass parent_class;
	void (*finalize) (NoteViewLinkPos *self);
};

struct _NoteViewParamSpecUrlPos {
	GParamSpec parent_instance;
};

struct _NoteViewParamSpecLinkPos {
	GParamSpec parent_instance;
};

static gint CompletionProvider_private_offset;
static gpointer completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderIface * completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gint NoteView_private_offset;
static gpointer note_view_parent_class = NULL;
static gboolean note_view__path_init;
static gboolean note_view__path_init = FALSE;
VALA_EXTERN GSettings* minder_settings;
static gpointer note_view_url_pos_parent_class = NULL;
static gpointer note_view_link_pos_parent_class = NULL;

VALA_EXTERN GType completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CompletionProvider, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN CompletionProvider* completion_provider_new (MainWindow* win,
                                             GtkSourceBuffer* buffer,
                                             const gchar* name,
                                             GList* proposals);
VALA_EXTERN CompletionProvider* completion_provider_construct (GType object_type,
                                                   MainWindow* win,
                                                   GtkSourceBuffer* buffer,
                                                   const gchar* name,
                                                   GList* proposals);
static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base);
static gboolean completion_provider_find_start_iter (CompletionProvider* self,
                                              GtkTextIter* iter);
static void _vala_GtkTextIter_free (GtkTextIter* self);
static gboolean __lambda43_ (CompletionProvider* self,
                      gunichar c);
static gboolean ___lambda43__gtk_text_char_predicate (gunichar ch,
                                               gpointer self);
static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base,
                                         GtkSourceCompletionContext* ctx);
VALA_EXTERN GSettings* main_window_get_settings (MainWindow* self);
static void completion_provider_real_populate (GtkSourceCompletionProvider* base,
                                        GtkSourceCompletionContext* context);
static gboolean completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base,
                                                  GtkSourceCompletionContext* ctx,
                                                  GtkSourceCompletionProposal* proposal,
                                                  GtkTextIter* iter);
static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base,
                                                     GtkSourceCompletionProposal* proposal,
                                                     GtkTextIter* iter);
static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base);
static void completion_provider_finalize (GObject * obj);
static GType completion_provider_get_type_once (void);
VALA_EXTERN GType note_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NoteView, g_object_unref)
static gpointer note_view_url_pos_ref (gpointer instance);
static void note_view_url_pos_unref (gpointer instance);
static GParamSpec* note_view_param_spec_url_pos (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags) G_GNUC_UNUSED ;
static void note_view_value_set_url_pos (GValue* value,
                                  gpointer v_object) G_GNUC_UNUSED ;
static void note_view_value_take_url_pos (GValue* value,
                                   gpointer v_object) G_GNUC_UNUSED ;
static gpointer note_view_value_get_url_pos (const GValue* value) G_GNUC_UNUSED ;
static GType note_view_url_pos_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NoteViewUrlPos, note_view_url_pos_unref)
static gpointer note_view_link_pos_ref (gpointer instance);
static void note_view_link_pos_unref (gpointer instance);
static GParamSpec* note_view_param_spec_link_pos (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags) G_GNUC_UNUSED ;
static void note_view_value_set_link_pos (GValue* value,
                                   gpointer v_object) G_GNUC_UNUSED ;
static void note_view_value_take_link_pos (GValue* value,
                                    gpointer v_object) G_GNUC_UNUSED ;
static gpointer note_view_value_get_link_pos (const GValue* value) G_GNUC_UNUSED ;
static GType note_view_link_pos_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NoteViewLinkPos, note_view_link_pos_unref)
VALA_EXTERN NoteView* note_view_new (void);
VALA_EXTERN NoteView* note_view_construct (GType object_type);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar* note_view_get_default_language (NoteView* self);
static gchar* note_view_get_default_scheme (NoteView* self);
VALA_EXTERN void note_view_set_modified (NoteView* self,
                             gboolean value);
static void __lambda40_ (NoteView* self);
static void ___lambda40__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                           gpointer self);
static gboolean note_view_on_focus (NoteView* self,
                             GdkEventFocus* e);
static gboolean _note_view_on_focus_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                        GdkEventFocus* event,
                                                        gpointer self);
static gboolean note_view_on_motion (NoteView* self,
                              GdkEventMotion* e);
static gboolean _note_view_on_motion_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                              GdkEventMotion* event,
                                                              gpointer self);
static gboolean note_view_on_press (NoteView* self,
                             GdkEventButton* e);
static gboolean _note_view_on_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                            GdkEventButton* event,
                                                            gpointer self);
static gboolean note_view_on_keypress (NoteView* self,
                                GdkEventKey* e);
static gboolean _note_view_on_keypress_gtk_widget_key_press_event (GtkWidget* _sender,
                                                            GdkEventKey* event,
                                                            gpointer self);
static gboolean note_view_on_keyrelease (NoteView* self,
                                  GdkEventKey* e);
static gboolean _note_view_on_keyrelease_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                GdkEventKey* event,
                                                                gpointer self);
VALA_EXTERN gchar* utils_url_re (void);
static void _note_view_url_pos_unref0_ (gpointer var);
static void _vala_NoteViewUrlPos_free_function_content_of (gpointer data);
static void _note_view_link_pos_unref0_ (gpointer var);
static void _vala_NoteViewLinkPos_free_function_content_of (gpointer data);
static void __lambda41_ (Block32Data* _data32_);
static void ___lambda41__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void note_view_clear (NoteView* self);
static gchar* note_view_current_line (NoteView* self,
                               GtkTextIter* cursor);
static void note_view_parse_line_for_urls (NoteView* self,
                                    const gchar* line);
static NoteViewUrlPos* note_view_url_pos_new (const gchar* u,
                                       gint s,
                                       gint e);
static NoteViewUrlPos* note_view_url_pos_construct (GType object_type,
                                             const gchar* u,
                                             gint s,
                                             gint e);
static void note_view_parse_line_for_node_links (NoteView* self,
                                          const gchar* line);
static NoteViewLinkPos* note_view_link_pos_new (gint i,
                                         gint s,
                                         gint e);
static NoteViewLinkPos* note_view_link_pos_construct (GType object_type,
                                               gint i,
                                               gint s,
                                               gint e);
static gboolean note_view_cursor_in_url (NoteView* self,
                                  GtkTextIter* cursor);
static gboolean note_view_cursor_in_node_link (NoteView* self,
                                        GtkTextIter* cursor);
static gint* _int_dup (gint* self);
static void note_view_enable_url_checking (NoteView* self,
                                    gint x,
                                    gint y);
static void note_view_disable_url_checking (NoteView* self);
VALA_EXTERN gpointer unicode_insert_ref (gpointer instance);
VALA_EXTERN void unicode_insert_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_unicode_insert (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_unicode_insert (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_unicode_insert (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_unicode_insert (const GValue* value);
VALA_EXTERN GType unicode_insert_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnicodeInsert, unicode_insert_unref)
VALA_EXTERN void note_view_add_unicode_completion (NoteView* self,
                                       MainWindow* win,
                                       UnicodeInsert* unicoder);
VALA_EXTERN GList* unicode_insert_create_proposals (UnicodeInsert* self);
VALA_EXTERN void utils_open_url (const gchar* url);
static void note_view_real_paste_clipboard (GtkTextView* base);
VALA_EXTERN void minder_clipboard_paste_into_note (NoteView* note);
VALA_EXTERN void note_view_paste_text (NoteView* self,
                           const gchar* str);
VALA_EXTERN gpointer node_link_ref (gpointer instance);
VALA_EXTERN void node_link_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_link (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_node_link (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_node_link (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_node_link (const GValue* value);
VALA_EXTERN GType node_link_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeLink, node_link_unref)
VALA_EXTERN void note_view_paste_node_link (NoteView* self,
                                NodeLink* link);
VALA_EXTERN void note_view_show_tooltip (NoteView* self,
                             const gchar* tooltip);
VALA_EXTERN gchar* note_view_get_text (NoteView* self);
VALA_EXTERN void note_view_set_text (NoteView* self,
                         const gchar* value);
VALA_EXTERN gboolean note_view_get_modified (NoteView* self);
static void g_cclosure_user_marshal_INT__NODE_LINK_POINTER (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data);
static void note_view_url_pos_finalize (NoteViewUrlPos * obj);
static GType note_view_url_pos_get_type_once (void);
static void note_view_link_pos_finalize (NoteViewLinkPos * obj);
static GType note_view_link_pos_get_type_once (void);
static void note_view_finalize (GObject * obj);
static GType note_view_get_type_once (void);
static void _vala_note_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_note_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
completion_provider_get_instance_private (CompletionProvider* self)
{
	return G_STRUCT_MEMBER_P (self, CompletionProvider_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

CompletionProvider*
completion_provider_construct (GType object_type,
                               MainWindow* win,
                               GtkSourceBuffer* buffer,
                               const gchar* name,
                               GList* proposals)
{
	CompletionProvider * self = NULL;
	MainWindow* _tmp0_;
	GtkSourceBuffer* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (win != NULL, NULL);
	g_return_val_if_fail (buffer != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (win);
	_g_object_unref0 (self->priv->_win);
	self->priv->_win = _tmp0_;
	_tmp1_ = _g_object_ref0 (buffer);
	_g_object_unref0 (self->priv->_buffer);
	self->priv->_buffer = _tmp1_;
	_tmp2_ = g_strdup (name);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp2_;
	(self->priv->_proposals == NULL) ? NULL : (self->priv->_proposals = (_g_list_free__g_object_unref0_ (self->priv->_proposals), NULL));
	self->priv->_proposals = NULL;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = proposals;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkSourceCompletionItem* _tmp3_;
			GtkSourceCompletionItem* item = NULL;
			_tmp3_ = _g_object_ref0 ((GtkSourceCompletionItem*) item_it->data);
			item = _tmp3_;
			{
				GtkSourceCompletionItem* _tmp4_;
				GtkSourceCompletionItem* _tmp5_;
				_tmp4_ = item;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				self->priv->_proposals = g_list_append (self->priv->_proposals, _tmp5_);
				_g_object_unref0 (item);
			}
		}
	}
	return self;
}

CompletionProvider*
completion_provider_new (MainWindow* win,
                         GtkSourceBuffer* buffer,
                         const gchar* name,
                         GList* proposals)
{
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER, win, buffer, name, proposals);
}

static gchar*
completion_provider_real_get_name (GtkSourceCompletionProvider* base)
{
	CompletionProvider * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (CompletionProvider*) base;
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
_vala_GtkTextIter_free (GtkTextIter* self)
{
	g_boxed_free (gtk_text_iter_get_type (), self);
}

static gboolean
__lambda43_ (CompletionProvider* self,
             gunichar c)
{
	gboolean result;
	result = c == ((gunichar) '\\');
	return result;
}

static gboolean
___lambda43__gtk_text_char_predicate (gunichar ch,
                                      gpointer self)
{
	gboolean result;
	result = __lambda43_ ((CompletionProvider*) self, ch);
	return result;
}

static gboolean
completion_provider_find_start_iter (CompletionProvider* self,
                                     GtkTextIter* iter)
{
	GtkTextIter _vala_iter = {0};
	GtkTextIter cursor = {0};
	GtkTextIter limit = {0};
	GtkSourceBuffer* _tmp0_;
	GtkSourceBuffer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter* _tmp5_;
	GtkTextIter* _tmp6_;
	GtkTextIter* _tmp7_;
	GtkTextIter* _tmp8_;
	GtkTextIter _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_buffer;
	_tmp1_ = self->priv->_buffer;
	g_object_get ((GtkTextBuffer*) _tmp1_, "cursor-position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) _tmp0_, &_tmp4_, _tmp3_);
	cursor = _tmp4_;
	_tmp5_ = gtk_text_iter_copy (&cursor);
	_tmp6_ = _tmp5_;
	limit = *_tmp6_;
	__vala_GtkTextIter_free0 (_tmp6_);
	gtk_text_iter_backward_word_start (&limit);
	gtk_text_iter_backward_char (&limit);
	_tmp7_ = gtk_text_iter_copy (&cursor);
	_tmp8_ = _tmp7_;
	_vala_iter = *_tmp8_;
	__vala_GtkTextIter_free0 (_tmp8_);
	_tmp9_ = limit;
	result = gtk_text_iter_backward_find_char (&_vala_iter, ___lambda43__gtk_text_char_predicate, self, &_tmp9_);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
completion_provider_real_match (GtkSourceCompletionProvider* base,
                                GtkSourceCompletionContext* ctx)
{
	CompletionProvider * self;
	GtkTextIter iter = {0};
	gboolean _tmp0_ = FALSE;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean result;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp2_ = completion_provider_find_start_iter (self, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		MainWindow* _tmp3_;
		GSettings* _tmp4_;
		GSettings* _tmp5_;
		_tmp3_ = self->priv->_win;
		_tmp4_ = main_window_get_settings (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = g_settings_get_boolean (_tmp5_, "enable-unicode-input");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
completion_provider_real_populate (GtkSourceCompletionProvider* base,
                                   GtkSourceCompletionContext* context)
{
	CompletionProvider * self;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp1_;
	self = (CompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp1_ = completion_provider_find_start_iter (self, &_tmp0_);
	start = _tmp0_;
	if (_tmp1_) {
		GtkSourceBuffer* _tmp2_;
		GtkSourceBuffer* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		GtkTextIter _tmp6_ = {0};
		gchar* text = NULL;
		GtkSourceBuffer* _tmp7_;
		GtkTextIter _tmp8_;
		GtkTextIter _tmp9_;
		gchar* _tmp10_;
		GList* proposals = NULL;
		GList* _tmp11_;
		GList* _tmp20_;
		_tmp2_ = self->priv->_buffer;
		_tmp3_ = self->priv->_buffer;
		g_object_get ((GtkTextBuffer*) _tmp3_, "cursor-position", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) _tmp2_, &_tmp6_, _tmp5_);
		end = _tmp6_;
		_tmp7_ = self->priv->_buffer;
		_tmp8_ = start;
		_tmp9_ = end;
		_tmp10_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp7_, &_tmp8_, &_tmp9_, FALSE);
		text = _tmp10_;
		proposals = NULL;
		_tmp11_ = self->priv->_proposals;
		{
			GList* item_collection = NULL;
			GList* item_it = NULL;
			item_collection = _tmp11_;
			for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
				GtkSourceCompletionItem* _tmp12_;
				GtkSourceCompletionItem* item = NULL;
				_tmp12_ = _g_object_ref0 ((GtkSourceCompletionItem*) item_it->data);
				item = _tmp12_;
				{
					GtkSourceCompletionItem* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					const gchar* _tmp16_;
					gboolean _tmp17_;
					_tmp13_ = item;
					_tmp14_ = gtk_source_completion_proposal_get_label ((GtkSourceCompletionProposal*) _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = text;
					_tmp17_ = g_str_has_prefix (_tmp15_, _tmp16_);
					_g_free0 (_tmp15_);
					if (_tmp17_) {
						GtkSourceCompletionItem* _tmp18_;
						GtkSourceCompletionItem* _tmp19_;
						_tmp18_ = item;
						_tmp19_ = _g_object_ref0 (_tmp18_);
						proposals = g_list_append (proposals, _tmp19_);
					}
					_g_object_unref0 (item);
				}
			}
		}
		_tmp20_ = proposals;
		gtk_source_completion_context_add_proposals (context, (GtkSourceCompletionProvider*) self, _tmp20_, TRUE);
		(proposals == NULL) ? NULL : (proposals = (_g_list_free__g_object_unref0_ (proposals), NULL));
		_g_free0 (text);
	}
}

static gboolean
completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base,
                                         GtkSourceCompletionContext* ctx,
                                         GtkSourceCompletionProposal* proposal,
                                         GtkTextIter* iter)
{
	CompletionProvider * self;
	GtkTextIter _vala_iter = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp1_;
	gboolean result;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (ctx != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	_tmp1_ = completion_provider_find_start_iter (self, &_tmp0_);
	_vala_iter = _tmp0_;
	result = _tmp1_;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base,
                                            GtkSourceCompletionProposal* proposal,
                                            GtkTextIter* iter)
{
	CompletionProvider * self;
	gboolean result;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	result = FALSE;
	return result;
}

static GtkSourceCompletionActivation
completion_provider_real_get_activation (GtkSourceCompletionProvider* base)
{
	CompletionProvider * self;
	GtkSourceCompletionActivation result;
	self = (CompletionProvider*) base;
	result = GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE | GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	return result;
}

static void
completion_provider_class_init (CompletionProviderClass * klass,
                                gpointer klass_data)
{
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CompletionProvider_private_offset);
	G_OBJECT_CLASS (klass)->finalize = completion_provider_finalize;
}

static void
completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface,
                                                                   gpointer iface_data)
{
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (GtkSourceCompletionProvider*)) completion_provider_real_get_name;
	iface->match = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_match;
	iface->populate = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_populate;
	iface->get_start_iter = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_get_start_iter;
	iface->activate_proposal = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_activate_proposal;
	iface->get_activation = (GtkSourceCompletionActivation (*) (GtkSourceCompletionProvider*)) completion_provider_real_get_activation;
}

static void
completion_provider_instance_init (CompletionProvider * self,
                                   gpointer klass)
{
	self->priv = completion_provider_get_instance_private (self);
}

static void
completion_provider_finalize (GObject * obj)
{
	CompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_PROVIDER, CompletionProvider);
	_g_object_unref0 (self->priv->_win);
	_g_free0 (self->priv->_name);
	(self->priv->_proposals == NULL) ? NULL : (self->priv->_proposals = (_g_list_free__g_object_unref0_ (self->priv->_proposals), NULL));
	_g_object_unref0 (self->priv->_buffer);
	G_OBJECT_CLASS (completion_provider_parent_class)->finalize (obj);
}

static GType
completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType completion_provider_type_id;
	completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	CompletionProvider_private_offset = g_type_add_instance_private (completion_provider_type_id, sizeof (CompletionProviderPrivate));
	return completion_provider_type_id;
}

GType
completion_provider_get_type (void)
{
	static volatile gsize completion_provider_type_id__once = 0;
	if (g_once_init_enter (&completion_provider_type_id__once)) {
		GType completion_provider_type_id;
		completion_provider_type_id = completion_provider_get_type_once ();
		g_once_init_leave (&completion_provider_type_id__once, completion_provider_type_id);
	}
	return completion_provider_type_id__once;
}

static inline gpointer
note_view_get_instance_private (NoteView* self)
{
	return G_STRUCT_MEMBER_P (self, NoteView_private_offset);
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		NoteView* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->style_manager);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda40_ (NoteView* self)
{
	note_view_set_modified (self, TRUE);
}

static void
___lambda40__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                      gpointer self)
{
	__lambda40_ ((NoteView*) self);
}

static gboolean
_note_view_on_focus_gtk_widget_focus_in_event (GtkWidget* _sender,
                                               GdkEventFocus* event,
                                               gpointer self)
{
	gboolean result;
	result = note_view_on_focus ((NoteView*) self, event);
	return result;
}

static gboolean
_note_view_on_motion_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                     GdkEventMotion* event,
                                                     gpointer self)
{
	gboolean result;
	result = note_view_on_motion ((NoteView*) self, event);
	return result;
}

static gboolean
_note_view_on_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                   GdkEventButton* event,
                                                   gpointer self)
{
	gboolean result;
	result = note_view_on_press ((NoteView*) self, event);
	return result;
}

static gboolean
_note_view_on_keypress_gtk_widget_key_press_event (GtkWidget* _sender,
                                                   GdkEventKey* event,
                                                   gpointer self)
{
	gboolean result;
	result = note_view_on_keypress ((NoteView*) self, event);
	return result;
}

static gboolean
_note_view_on_keyrelease_gtk_widget_key_release_event (GtkWidget* _sender,
                                                       GdkEventKey* event,
                                                       gpointer self)
{
	gboolean result;
	result = note_view_on_keyrelease ((NoteView*) self, event);
	return result;
}

static void
_note_view_url_pos_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (note_view_url_pos_unref (var), NULL));
}

static void
_vala_NoteViewUrlPos_free_function_content_of (gpointer data)
{
	NoteViewUrlPos* self;
	self = *((NoteViewUrlPos**) data);
	_note_view_url_pos_unref0_ (self);
}

static void
_note_view_link_pos_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (note_view_link_pos_unref (var), NULL));
}

static void
_vala_NoteViewLinkPos_free_function_content_of (gpointer data)
{
	NoteViewLinkPos* self;
	self = *((NoteViewLinkPos**) data);
	_note_view_link_pos_unref0_ (self);
}

static void
__lambda41_ (Block32Data* _data32_)
{
	NoteView* self;
	GtkSourceStyleScheme* s = NULL;
	GtkSourceStyleSchemeManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkSourceStyleScheme* _tmp3_;
	GtkSourceStyleScheme* _tmp4_;
	GtkSourceStyleScheme* _tmp5_;
	GtkSourceBuffer* _tmp6_;
	self = _data32_->self;
	_tmp0_ = _data32_->style_manager;
	_tmp1_ = note_view_get_default_scheme (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_source_style_scheme_manager_get_scheme (_tmp0_, _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	s = _tmp5_;
	_tmp6_ = self->_buffer;
	gtk_source_buffer_set_style_scheme (_tmp6_, s);
	_g_object_unref0 (s);
}

static void
___lambda41__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda41_ (self);
}

NoteView*
note_view_construct (GType object_type)
{
	NoteView * self = NULL;
	Block32Data* _data32_;
	gchar* sourceview_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar* lang_path = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* style_path = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** lang_paths = NULL;
	gchar** _tmp12_;
	gint lang_paths_length1;
	gint _lang_paths_size_;
	GtkStyleContext* _tmp13_;
	GtkSourceLanguageManager* manager = NULL;
	GtkSourceLanguageManager* _tmp14_;
	GtkSourceLanguageManager* _tmp15_;
	GtkSourceStyleSchemeManager* _tmp24_;
	GtkSourceStyleSchemeManager* _tmp25_;
	GtkSourceLanguage* language = NULL;
	GtkSourceLanguageManager* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkSourceLanguage* _tmp31_;
	GtkSourceLanguage* _tmp32_;
	GtkSourceLanguage* _tmp33_;
	GtkSourceStyleScheme* style = NULL;
	GtkSourceStyleSchemeManager* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GtkSourceStyleScheme* _tmp37_;
	GtkSourceStyleScheme* _tmp38_;
	GtkSourceStyleScheme* _tmp39_;
	GtkSourceLanguage* _tmp40_;
	GtkSourceBuffer* _tmp41_;
	GtkSourceBuffer* _tmp42_;
	GtkSourceBuffer* _tmp43_;
	GtkSourceBuffer* _tmp44_;
	GtkSourceStyleScheme* _tmp45_;
	GtkSourceBuffer* _tmp46_;
	GtkSourceBuffer* _tmp47_;
	GArray* _tmp57_;
	GArray* _tmp58_;
	GSettings* _tmp59_;
	GError* _inner_error0_ = NULL;
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	self = (NoteView*) g_object_new (object_type, NULL);
	_data32_->self = g_object_ref (self);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "minder", "gtksourceview-4", NULL);
	sourceview_path = _tmp1_;
	_tmp3_ = _tmp2_ = g_get_system_data_dirs ();
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp3_;
		data_dir_collection_length1 = _vala_array_length (_tmp2_);
		for (data_dir_it = 0; data_dir_it < data_dir_collection_length1; data_dir_it = data_dir_it + 1) {
			gchar* _tmp4_;
			gchar* data_dir = NULL;
			_tmp4_ = g_strdup (data_dir_collection[data_dir_it]);
			data_dir = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp5_ = data_dir;
				_tmp6_ = g_build_filename (_tmp5_, "minder", "gtksourceview-4", NULL);
				_g_free0 (sourceview_path);
				sourceview_path = _tmp6_;
				_tmp7_ = sourceview_path;
				if (g_file_test (_tmp7_, G_FILE_TEST_EXISTS)) {
					_g_free0 (data_dir);
					break;
				}
				_g_free0 (data_dir);
			}
		}
	}
	_tmp8_ = sourceview_path;
	_tmp9_ = g_build_filename (_tmp8_, "language-specs", NULL);
	lang_path = _tmp9_;
	_tmp10_ = sourceview_path;
	_tmp11_ = g_build_filename (_tmp10_, "styles", NULL);
	style_path = _tmp11_;
	_tmp12_ = g_new0 (gchar*, 0 + 1);
	lang_paths = _tmp12_;
	lang_paths_length1 = 0;
	_lang_paths_size_ = lang_paths_length1;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp13_, "textfield");
	_tmp14_ = gtk_source_language_manager_get_default ();
	_tmp15_ = _g_object_ref0 (_tmp14_);
	manager = _tmp15_;
	if (!note_view__path_init) {
		GtkSourceLanguageManager* _tmp16_;
		gchar** _tmp17_;
		gchar** _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		GtkSourceLanguageManager* _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		_tmp16_ = manager;
		_tmp18_ = _tmp17_ = gtk_source_language_manager_get_search_path (_tmp16_);
		_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup3 (_tmp18_, _vala_array_length (_tmp17_)) : _tmp18_;
		_tmp19__length1 = _vala_array_length (_tmp17_);
		lang_paths = (_vala_array_free (lang_paths, lang_paths_length1, (GDestroyNotify) g_free), NULL);
		lang_paths = _tmp19_;
		lang_paths_length1 = _tmp19__length1;
		_lang_paths_size_ = lang_paths_length1;
		_tmp20_ = lang_path;
		_tmp21_ = g_strdup (_tmp20_);
		_vala_array_add3 (&lang_paths, &lang_paths_length1, &_lang_paths_size_, _tmp21_);
		_tmp22_ = manager;
		_tmp23_ = lang_paths;
		_tmp23__length1 = lang_paths_length1;
		gtk_source_language_manager_set_search_path (_tmp22_, _tmp23_);
	}
	_tmp24_ = gtk_source_style_scheme_manager_get_default ();
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_data32_->style_manager = _tmp25_;
	if (!note_view__path_init) {
		GtkSourceStyleSchemeManager* _tmp26_;
		const gchar* _tmp27_;
		_tmp26_ = _data32_->style_manager;
		_tmp27_ = style_path;
		gtk_source_style_scheme_manager_prepend_search_path (_tmp26_, _tmp27_);
	}
	note_view__path_init = TRUE;
	_tmp28_ = manager;
	_tmp29_ = note_view_get_default_language (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = gtk_source_language_manager_get_language (_tmp28_, _tmp30_);
	_tmp32_ = _g_object_ref0 (_tmp31_);
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp30_);
	language = _tmp33_;
	_tmp34_ = _data32_->style_manager;
	_tmp35_ = note_view_get_default_scheme (self);
	_tmp36_ = _tmp35_;
	_tmp37_ = gtk_source_style_scheme_manager_get_scheme (_tmp34_, _tmp36_);
	_tmp38_ = _g_object_ref0 (_tmp37_);
	_tmp39_ = _tmp38_;
	_g_free0 (_tmp36_);
	style = _tmp39_;
	_tmp40_ = language;
	_tmp41_ = gtk_source_buffer_new_with_language (_tmp40_);
	_g_object_unref0 (self->_buffer);
	self->_buffer = _tmp41_;
	_tmp42_ = self->_buffer;
	gtk_source_buffer_set_highlight_syntax (_tmp42_, TRUE);
	_tmp43_ = self->_buffer;
	gtk_source_buffer_set_max_undo_levels (_tmp43_, 20);
	_tmp44_ = self->_buffer;
	_tmp45_ = style;
	gtk_source_buffer_set_style_scheme (_tmp44_, _tmp45_);
	_tmp46_ = self->_buffer;
	gtk_text_view_set_buffer ((GtkTextView*) self, (GtkTextBuffer*) _tmp46_);
	note_view_set_modified (self, FALSE);
	_tmp47_ = self->_buffer;
	g_signal_connect_object ((GtkTextBuffer*) _tmp47_, "changed", (GCallback) ___lambda40__gtk_text_buffer_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-in-event", (GCallback) _note_view_on_focus_gtk_widget_focus_in_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _note_view_on_motion_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _note_view_on_press_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _note_view_on_keypress_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _note_view_on_keyrelease_gtk_widget_key_release_event, self, 0);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	g_object_set ((GtkWidget*) self, "has-focus", TRUE, NULL);
	gtk_source_view_set_auto_indent ((GtkSourceView*) self, TRUE);
	gtk_text_view_set_wrap_mode ((GtkTextView*) self, GTK_WRAP_WORD);
	gtk_source_view_set_tab_width ((GtkSourceView*) self, (guint) 4);
	gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) self, TRUE);
	{
		GRegex* _tmp48_ = NULL;
		gchar* _tmp49_;
		gchar* _tmp50_;
		GRegex* _tmp51_;
		GRegex* _tmp52_;
		GRegex* _tmp53_;
		GRegex* _tmp54_ = NULL;
		GRegex* _tmp55_;
		GRegex* _tmp56_;
		_tmp49_ = utils_url_re ();
		_tmp50_ = _tmp49_;
		_tmp51_ = g_regex_new (_tmp50_, 0, 0, &_inner_error0_);
		_tmp52_ = _tmp51_;
		_g_free0 (_tmp50_);
		_tmp48_ = _tmp52_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_object_unref0 (style);
			_g_object_unref0 (language);
			_g_object_unref0 (manager);
			lang_paths = (_vala_array_free (lang_paths, lang_paths_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (style_path);
			_g_free0 (lang_path);
			_g_free0 (sourceview_path);
			block32_data_unref (_data32_);
			_data32_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp53_ = _tmp48_;
		_tmp48_ = NULL;
		_g_regex_unref0 (self->priv->_url_re);
		self->priv->_url_re = _tmp53_;
		_tmp55_ = g_regex_new ("@Node-(\\d+)", 0, 0, &_inner_error0_);
		_tmp54_ = _tmp55_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp48_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_object_unref0 (style);
			_g_object_unref0 (language);
			_g_object_unref0 (manager);
			lang_paths = (_vala_array_free (lang_paths, lang_paths_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (style_path);
			_g_free0 (lang_path);
			_g_free0 (sourceview_path);
			block32_data_unref (_data32_);
			_data32_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp56_ = _tmp54_;
		_tmp54_ = NULL;
		_g_regex_unref0 (self->priv->_link_re);
		self->priv->_link_re = _tmp56_;
		_g_regex_unref0 (_tmp54_);
		_g_regex_unref0 (_tmp48_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		_g_regex_unref0 (self->priv->_url_re);
		self->priv->_url_re = NULL;
		_g_regex_unref0 (self->priv->_link_re);
		self->priv->_link_re = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (style);
		_g_object_unref0 (language);
		_g_object_unref0 (manager);
		lang_paths = (_vala_array_free (lang_paths, lang_paths_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (style_path);
		_g_free0 (lang_path);
		_g_free0 (sourceview_path);
		block32_data_unref (_data32_);
		_data32_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp57_ = g_array_new (TRUE, TRUE, sizeof (NoteViewUrlPos*));
	g_array_set_clear_func (_tmp57_, (GDestroyNotify) _vala_NoteViewUrlPos_free_function_content_of);
	_g_array_unref0 (self->priv->_last_urls);
	self->priv->_last_urls = _tmp57_;
	_tmp58_ = g_array_new (TRUE, TRUE, sizeof (NoteViewLinkPos*));
	g_array_set_clear_func (_tmp58_, (GDestroyNotify) _vala_NoteViewLinkPos_free_function_content_of);
	_g_array_unref0 (self->priv->_last_links);
	self->priv->_last_links = _tmp58_;
	_tmp59_ = minder_settings;
	g_signal_connect_data (_tmp59_, "changed::colorize-notes", (GCallback) ___lambda41__g_settings_changed, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
	_g_object_unref0 (style);
	_g_object_unref0 (language);
	_g_object_unref0 (manager);
	lang_paths = (_vala_array_free (lang_paths, lang_paths_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (style_path);
	_g_free0 (lang_path);
	_g_free0 (sourceview_path);
	block32_data_unref (_data32_);
	_data32_ = NULL;
	return self;
}

NoteView*
note_view_new (void)
{
	return note_view_construct (TYPE_NOTE_VIEW);
}

static gchar*
note_view_get_default_language (NoteView* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("markdown-minder");
	result = _tmp0_;
	return result;
}

static gchar*
note_view_get_default_scheme (NoteView* self)
{
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = minder_settings;
	if (g_settings_get_boolean (_tmp1_, "colorize-notes")) {
		_tmp0_ = "minder.color";
	} else {
		_tmp0_ = "minder.none";
	}
	_tmp2_ = g_strdup (_tmp0_);
	result = _tmp2_;
	return result;
}

static void
note_view_clear (NoteView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_last_lnum = -1;
	_g_free0 (self->priv->_last_url);
	self->priv->_last_url = NULL;
	_g_free0 (self->priv->_last_link);
	self->priv->_last_link = NULL;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gchar*
note_view_current_line (NoteView* self,
                        GtkTextIter* cursor)
{
	GtkTextIter start = {0};
	GtkTextIter _tmp0_;
	GtkTextIter end = {0};
	GtkTextIter _tmp1_;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cursor != NULL, NULL);
	_tmp0_ = *cursor;
	start = _tmp0_;
	_tmp1_ = *cursor;
	end = _tmp1_;
	gtk_text_iter_set_line (&start, gtk_text_iter_get_line (&start));
	gtk_text_iter_forward_line (&end);
	_tmp2_ = end;
	_tmp3_ = gtk_text_iter_get_text (&start, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_chomp (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}

static gpointer*
vala_g_array_remove_range (GArray* self,
                           guint index,
                           guint length,
                           gint* result_length1)
{
	gpointer* ga = NULL;
	gpointer* _tmp0_;
	gint ga_length1;
	gint _ga_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len >= (index + length), "this.length >= index + length");
	_tmp0_ = g_new0 (gpointer, length);
	ga = _tmp0_;
	ga_length1 = length;
	_ga_size_ = ga_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = ga;
				_tmp3__length1 = ga_length1;
				_tmp4_ = self->data;
				_tmp4__length1 = self->len;
				_tmp5_ = _tmp4_[i + index];
				_tmp4_[i + index] = NULL;
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	g_array_remove_range (self, index, length);
	_tmp6_ = ga;
	_tmp6__length1 = ga_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
note_view_parse_line_for_urls (NoteView* self,
                               const gchar* line)
{
	GRegex* _tmp0_;
	GMatchInfo* match_info = NULL;
	gint start = 0;
	GArray* _tmp1_;
	GArray* _tmp2_;
	gint _tmp3_ = 0;
	gpointer* _tmp4_;
	NoteViewUrlPos** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->_url_re;
	if (_tmp0_ == NULL) {
		return;
	}
	start = 0;
	_tmp1_ = self->priv->_last_urls;
	_tmp2_ = self->priv->_last_urls;
	_tmp4_ = vala_g_array_remove_range (_tmp1_, (guint) 0, _tmp2_->len, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) note_view_url_pos_unref), NULL);
	{
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			GRegex* _tmp7_;
			GMatchInfo* _tmp8_ = NULL;
			gboolean _tmp9_;
			gint s = 0;
			gint e = 0;
			GMatchInfo* _tmp10_;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			GArray* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			NoteViewUrlPos* _tmp16_;
			_tmp7_ = self->priv->_url_re;
			_tmp9_ = g_regex_match_all_full (_tmp7_, line, (gssize) -1, start, 0, &_tmp8_, &_inner_error0_);
			_g_match_info_unref0 (match_info);
			match_info = _tmp8_;
			_tmp6_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_match_info_unref0 (match_info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (!_tmp6_) {
				break;
			}
			_tmp10_ = match_info;
			g_match_info_fetch_pos (_tmp10_, 0, &_tmp11_, &_tmp12_);
			s = _tmp11_;
			e = _tmp12_;
			_tmp13_ = self->priv->_last_urls;
			_tmp14_ = string_substring (line, (glong) s, (glong) (e - s));
			_tmp15_ = _tmp14_;
			_tmp16_ = note_view_url_pos_new (_tmp15_, s, e);
			g_array_append_val (_tmp13_, _tmp16_);
			_g_free0 (_tmp15_);
			start = e;
		}
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_match_info_unref0 (match_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_match_info_unref0 (match_info);
}

static void
note_view_parse_line_for_node_links (NoteView* self,
                                     const gchar* line)
{
	GRegex* _tmp0_;
	GMatchInfo* match_info = NULL;
	gint start = 0;
	GArray* _tmp1_;
	GArray* _tmp2_;
	gint _tmp3_ = 0;
	gpointer* _tmp4_;
	NoteViewLinkPos** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->_link_re;
	if (_tmp0_ == NULL) {
		return;
	}
	start = 0;
	_tmp1_ = self->priv->_last_links;
	_tmp2_ = self->priv->_last_links;
	_tmp4_ = vala_g_array_remove_range (_tmp1_, (guint) 0, _tmp2_->len, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) note_view_link_pos_unref), NULL);
	{
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			GRegex* _tmp7_;
			GMatchInfo* _tmp8_ = NULL;
			gboolean _tmp9_;
			gint s = 0;
			gint e = 0;
			GMatchInfo* _tmp10_;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gchar* id = NULL;
			GMatchInfo* _tmp13_;
			gchar* _tmp14_;
			GArray* _tmp15_;
			const gchar* _tmp16_;
			NoteViewLinkPos* _tmp17_;
			_tmp7_ = self->priv->_link_re;
			_tmp9_ = g_regex_match_full (_tmp7_, line, (gssize) -1, start, 0, &_tmp8_, &_inner_error0_);
			_g_match_info_unref0 (match_info);
			match_info = _tmp8_;
			_tmp6_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_match_info_unref0 (match_info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (!_tmp6_) {
				break;
			}
			_tmp10_ = match_info;
			g_match_info_fetch_pos (_tmp10_, 0, &_tmp11_, &_tmp12_);
			s = _tmp11_;
			e = _tmp12_;
			_tmp13_ = match_info;
			_tmp14_ = g_match_info_fetch (_tmp13_, 1);
			id = _tmp14_;
			_tmp15_ = self->priv->_last_links;
			_tmp16_ = id;
			_tmp17_ = note_view_link_pos_new (atoi (_tmp16_), s, e);
			g_array_append_val (_tmp15_, _tmp17_);
			start = e;
			_g_free0 (id);
		}
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_match_info_unref0 (match_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_match_info_unref0 (match_info);
}

static gpointer
_note_view_url_pos_ref0 (gpointer self)
{
	return self ? note_view_url_pos_ref (self) : NULL;
}

static gboolean
note_view_cursor_in_url (NoteView* self,
                         GtkTextIter* cursor)
{
	gint offset = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cursor != NULL, FALSE);
	offset = gtk_text_iter_get_line_offset (cursor);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				NoteViewUrlPos* link = NULL;
				GArray* _tmp3_;
				NoteViewUrlPos* _tmp4_;
				NoteViewUrlPos* _tmp5_;
				gboolean _tmp6_ = FALSE;
				NoteViewUrlPos* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_last_urls;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_last_urls;
				_tmp4_ = g_array_index (_tmp3_, NoteViewUrlPos*, (guint) i);
				_tmp5_ = _note_view_url_pos_ref0 (_tmp4_);
				link = _tmp5_;
				_tmp7_ = link;
				if (_tmp7_->start <= offset) {
					NoteViewUrlPos* _tmp8_;
					_tmp8_ = link;
					_tmp6_ = offset < _tmp8_->end;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					NoteViewUrlPos* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = link;
					_tmp10_ = _tmp9_->url;
					_tmp11_ = g_strdup (_tmp10_);
					_g_free0 (self->priv->_last_url);
					self->priv->_last_url = _tmp11_;
					result = TRUE;
					_note_view_url_pos_unref0 (link);
					return result;
				}
				_note_view_url_pos_unref0 (link);
			}
		}
	}
	_g_free0 (self->priv->_last_url);
	self->priv->_last_url = NULL;
	result = FALSE;
	return result;
}

static gpointer
_note_view_link_pos_ref0 (gpointer self)
{
	return self ? note_view_link_pos_ref (self) : NULL;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static gboolean
note_view_cursor_in_node_link (NoteView* self,
                               GtkTextIter* cursor)
{
	gint offset = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cursor != NULL, FALSE);
	offset = gtk_text_iter_get_line_offset (cursor);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				NoteViewLinkPos* link = NULL;
				GArray* _tmp3_;
				NoteViewLinkPos* _tmp4_;
				NoteViewLinkPos* _tmp5_;
				gboolean _tmp6_ = FALSE;
				NoteViewLinkPos* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_last_links;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_last_links;
				_tmp4_ = g_array_index (_tmp3_, NoteViewLinkPos*, (guint) i);
				_tmp5_ = _note_view_link_pos_ref0 (_tmp4_);
				link = _tmp5_;
				_tmp7_ = link;
				if (_tmp7_->start <= offset) {
					NoteViewLinkPos* _tmp8_;
					_tmp8_ = link;
					_tmp6_ = offset < _tmp8_->end;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					NoteViewLinkPos* _tmp9_;
					gint* _tmp10_;
					_tmp9_ = link;
					_tmp10_ = __int_dup0 (&_tmp9_->id);
					_g_free0 (self->priv->_last_link);
					self->priv->_last_link = _tmp10_;
					result = TRUE;
					_note_view_link_pos_unref0 (link);
					return result;
				}
				_note_view_link_pos_unref0 (link);
			}
		}
	}
	_g_free0 (self->priv->_last_link);
	self->priv->_last_link = NULL;
	result = FALSE;
	return result;
}

static void
note_view_enable_url_checking (NoteView* self,
                               gint x,
                               gint y)
{
	GtkTextIter cursor = {0};
	GdkWindow* win = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	gboolean in_node_link = FALSE;
	GtkTextIter _tmp7_;
	gboolean _tmp9_ = FALSE;
	GtkTextIter _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	win = _tmp1_;
	gtk_text_view_get_iter_at_location ((GtkTextView*) self, &_tmp2_, x, y);
	cursor = _tmp2_;
	if (self->priv->_last_lnum != gtk_text_iter_get_line (&cursor)) {
		gchar* line = NULL;
		GtkTextIter _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = cursor;
		_tmp4_ = note_view_current_line (self, &_tmp3_);
		line = _tmp4_;
		_tmp5_ = line;
		note_view_parse_line_for_urls (self, _tmp5_);
		_tmp6_ = line;
		note_view_parse_line_for_node_links (self, _tmp6_);
		self->priv->_last_lnum = gtk_text_iter_get_line (&cursor);
		_g_free0 (line);
	}
	_tmp7_ = cursor;
	in_node_link = note_view_cursor_in_node_link (self, &_tmp7_);
	if (in_node_link) {
		gint* _tmp8_;
		_tmp8_ = self->priv->_last_link;
		g_signal_emit (self, note_view_signals[NOTE_VIEW_NODE_LINK_HOVER_SIGNAL], 0, *_tmp8_);
	} else {
		gtk_widget_set_tooltip_text ((GtkWidget*) self, "");
	}
	_tmp10_ = cursor;
	if (note_view_cursor_in_url (self, &_tmp10_)) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = in_node_link;
	}
	if (_tmp9_) {
		GdkWindow* _tmp11_;
		GdkDisplay* _tmp12_;
		GdkCursor* _tmp13_;
		GdkCursor* _tmp14_;
		_tmp11_ = win;
		_tmp12_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp13_ = gdk_cursor_new_for_display (_tmp12_, GDK_HAND2);
		_tmp14_ = _tmp13_;
		gdk_window_set_cursor (_tmp11_, _tmp14_);
		_g_object_unref0 (_tmp14_);
	} else {
		GdkWindow* _tmp15_;
		_tmp15_ = win;
		gdk_window_set_cursor (_tmp15_, NULL);
	}
	_g_object_unref0 (win);
}

static void
note_view_disable_url_checking (NoteView* self)
{
	GdkWindow* win = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	win = _tmp1_;
	gdk_window_set_cursor (win, NULL);
	self->priv->_last_lnum = -1;
	gtk_widget_set_tooltip_text ((GtkWidget*) self, "");
	_g_object_unref0 (win);
}

void
note_view_add_unicode_completion (NoteView* self,
                                  MainWindow* win,
                                  UnicodeInsert* unicoder)
{
	CompletionProvider* provider = NULL;
	GtkSourceBuffer* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	CompletionProvider* _tmp3_;
	CompletionProvider* _tmp4_;
	GtkSourceCompletion* _tmp5_;
	GtkSourceCompletion* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	g_return_if_fail (unicoder != NULL);
	_tmp0_ = self->_buffer;
	_tmp1_ = unicode_insert_create_proposals (unicoder);
	_tmp2_ = _tmp1_;
	_tmp3_ = completion_provider_new (win, _tmp0_, "Unicode", _tmp2_);
	_tmp4_ = _tmp3_;
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	provider = _tmp4_;
	_tmp5_ = gtk_source_view_get_completion ((GtkSourceView*) self);
	_tmp6_ = _tmp5_;
	gtk_source_completion_add_provider (_tmp6_, (GtkSourceCompletionProvider*) provider, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (provider);
}

static gboolean
note_view_on_motion (NoteView* self,
                     GdkEventMotion* e)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	self->priv->_last_x = (gint) e->x;
	self->priv->_last_y = (gint) e->y;
	if ((gboolean) (e->state & GDK_CONTROL_MASK)) {
		gint int_x = 0;
		gint int_y = 0;
		int_x = (gint) e->x;
		int_y = (gint) e->y;
		note_view_enable_url_checking (self, int_x, int_y);
		result = TRUE;
		return result;
	}
	note_view_disable_url_checking (self);
	result = FALSE;
	return result;
}

static gboolean
note_view_on_press (NoteView* self,
                    GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if ((gboolean) (e->state & GDK_CONTROL_MASK)) {
		gint int_x = 0;
		gint int_y = 0;
		const gchar* _tmp0_;
		int_x = (gint) e->x;
		int_y = (gint) e->y;
		note_view_enable_url_checking (self, int_x, int_y);
		_tmp0_ = self->priv->_last_url;
		if (_tmp0_ != NULL) {
			FILE* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			_tmp1_ = stdout;
			_tmp2_ = self->priv->_last_url;
			fprintf (_tmp1_, "Opening URL: %s\n", _tmp2_);
			_tmp3_ = self->priv->_last_url;
			utils_open_url (_tmp3_);
		} else {
			gint* _tmp4_;
			_tmp4_ = self->priv->_last_link;
			if (_tmp4_ != NULL) {
				gint* _tmp5_;
				_tmp5_ = self->priv->_last_link;
				g_signal_emit (self, note_view_signals[NOTE_VIEW_NODE_LINK_CLICKED_SIGNAL], 0, *_tmp5_);
			}
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
note_view_on_keypress (NoteView* self,
                       GdkEventKey* e)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->keyval == ((guint) 65507)) {
		note_view_enable_url_checking (self, self->priv->_last_x, self->priv->_last_y);
	}
	result = FALSE;
	return result;
}

static gboolean
note_view_on_keyrelease (NoteView* self,
                         GdkEventKey* e)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->keyval == ((guint) 65507)) {
		note_view_disable_url_checking (self);
	}
	result = FALSE;
	return result;
}

static gboolean
note_view_on_focus (NoteView* self,
                    GdkEventFocus* e)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	note_view_clear (self);
	result = FALSE;
	return result;
}

static void
note_view_real_paste_clipboard (GtkTextView* base)
{
	NoteView * self;
	self = (NoteView*) base;
	minder_clipboard_paste_into_note (self);
}

void
note_view_paste_text (NoteView* self,
                      const gchar* str)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (str);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_insert_at_cursor (_tmp1_, str, _tmp3_);
}

void
note_view_paste_node_link (NoteView* self,
                           NodeLink* link)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	gint id = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* str = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (link != NULL);
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	g_signal_emit (self, note_view_signals[NOTE_VIEW_NODE_LINK_ADDED_SIGNAL], 0, link, &_tmp1_, &_tmp2_);
	_g_free0 (text);
	text = _tmp1_;
	id = _tmp2_;
	_tmp3_ = text;
	_tmp4_ = g_strdup_printf ("[%s](@Node-%d)", _tmp3_, id);
	str = _tmp4_;
	_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = strlen (str);
	_tmp8_ = _tmp7_;
	gtk_text_buffer_insert_at_cursor (_tmp6_, str, _tmp8_);
	_g_free0 (str);
	_g_free0 (text);
}

void
note_view_show_tooltip (NoteView* self,
                        const gchar* tooltip)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tooltip != NULL);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, tooltip);
}

gchar*
note_view_get_text (NoteView* self)
{
	gchar* result;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "text", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

void
note_view_set_text (NoteView* self,
                    const gchar* value)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_set (_tmp1_, "text", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, note_view_properties[NOTE_VIEW_TEXT_PROPERTY]);
}

gboolean
note_view_get_modified (NoteView* self)
{
	gboolean result;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	result = gtk_text_buffer_get_modified (_tmp1_);
	return result;
}

void
note_view_set_modified (NoteView* self,
                        gboolean value)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_set_modified (_tmp1_, value);
	note_view_clear (self);
	g_object_notify_by_pspec ((GObject *) self, note_view_properties[NOTE_VIEW_MODIFIED_PROPERTY]);
}

static void
g_cclosure_user_marshal_INT__NODE_LINK_POINTER (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data)
{
	typedef gint (*GMarshalFunc_INT__NODE_LINK_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_INT__NODE_LINK_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_INT__NODE_LINK_POINTER) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, value_get_node_link (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_int (return_value, v_return);
}

static NoteViewUrlPos*
note_view_url_pos_construct (GType object_type,
                             const gchar* u,
                             gint s,
                             gint e)
{
	NoteViewUrlPos* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (u != NULL, NULL);
	self = (NoteViewUrlPos*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (u);
	_g_free0 (self->url);
	self->url = _tmp0_;
	self->start = s;
	self->end = e;
	return self;
}

static NoteViewUrlPos*
note_view_url_pos_new (const gchar* u,
                       gint s,
                       gint e)
{
	return note_view_url_pos_construct (NOTE_VIEW_TYPE_URL_POS, u, s, e);
}

static void
note_view_value_url_pos_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
note_view_value_url_pos_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		note_view_url_pos_unref (value->data[0].v_pointer);
	}
}

static void
note_view_value_url_pos_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = note_view_url_pos_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
note_view_value_url_pos_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
note_view_value_url_pos_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NoteViewUrlPos * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = note_view_url_pos_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
note_view_value_url_pos_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	NoteViewUrlPos ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = note_view_url_pos_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
note_view_param_spec_url_pos (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	NoteViewParamSpecUrlPos* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NOTE_VIEW_TYPE_URL_POS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
note_view_value_get_url_pos (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NOTE_VIEW_TYPE_URL_POS), NULL);
	return value->data[0].v_pointer;
}

static void
note_view_value_set_url_pos (GValue* value,
                             gpointer v_object)
{
	NoteViewUrlPos * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NOTE_VIEW_TYPE_URL_POS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NOTE_VIEW_TYPE_URL_POS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		note_view_url_pos_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		note_view_url_pos_unref (old);
	}
}

static void
note_view_value_take_url_pos (GValue* value,
                              gpointer v_object)
{
	NoteViewUrlPos * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NOTE_VIEW_TYPE_URL_POS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NOTE_VIEW_TYPE_URL_POS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		note_view_url_pos_unref (old);
	}
}

static void
note_view_url_pos_class_init (NoteViewUrlPosClass * klass,
                              gpointer klass_data)
{
	note_view_url_pos_parent_class = g_type_class_peek_parent (klass);
	((NoteViewUrlPosClass *) klass)->finalize = note_view_url_pos_finalize;
}

static void
note_view_url_pos_instance_init (NoteViewUrlPos * self,
                                 gpointer klass)
{
	self->ref_count = 1;
}

static void
note_view_url_pos_finalize (NoteViewUrlPos * obj)
{
	NoteViewUrlPos * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTE_VIEW_TYPE_URL_POS, NoteViewUrlPos);
	g_signal_handlers_destroy (self);
	_g_free0 (self->url);
}

static GType
note_view_url_pos_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { note_view_value_url_pos_init, note_view_value_url_pos_free_value, note_view_value_url_pos_copy_value, note_view_value_url_pos_peek_pointer, "p", note_view_value_url_pos_collect_value, "p", note_view_value_url_pos_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NoteViewUrlPosClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) note_view_url_pos_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NoteViewUrlPos), 0, (GInstanceInitFunc) note_view_url_pos_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType note_view_url_pos_type_id;
	note_view_url_pos_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NoteViewUrlPos", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return note_view_url_pos_type_id;
}

static GType
note_view_url_pos_get_type (void)
{
	static volatile gsize note_view_url_pos_type_id__once = 0;
	if (g_once_init_enter (&note_view_url_pos_type_id__once)) {
		GType note_view_url_pos_type_id;
		note_view_url_pos_type_id = note_view_url_pos_get_type_once ();
		g_once_init_leave (&note_view_url_pos_type_id__once, note_view_url_pos_type_id);
	}
	return note_view_url_pos_type_id__once;
}

static gpointer
note_view_url_pos_ref (gpointer instance)
{
	NoteViewUrlPos * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
note_view_url_pos_unref (gpointer instance)
{
	NoteViewUrlPos * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NOTE_VIEW_URL_POS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static NoteViewLinkPos*
note_view_link_pos_construct (GType object_type,
                              gint i,
                              gint s,
                              gint e)
{
	NoteViewLinkPos* self = NULL;
	self = (NoteViewLinkPos*) g_type_create_instance (object_type);
	self->id = i;
	self->start = s;
	self->end = e;
	return self;
}

static NoteViewLinkPos*
note_view_link_pos_new (gint i,
                        gint s,
                        gint e)
{
	return note_view_link_pos_construct (NOTE_VIEW_TYPE_LINK_POS, i, s, e);
}

static void
note_view_value_link_pos_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
note_view_value_link_pos_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		note_view_link_pos_unref (value->data[0].v_pointer);
	}
}

static void
note_view_value_link_pos_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = note_view_link_pos_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
note_view_value_link_pos_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
note_view_value_link_pos_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NoteViewLinkPos * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = note_view_link_pos_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
note_view_value_link_pos_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	NoteViewLinkPos ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = note_view_link_pos_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
note_view_param_spec_link_pos (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	NoteViewParamSpecLinkPos* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NOTE_VIEW_TYPE_LINK_POS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
note_view_value_get_link_pos (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NOTE_VIEW_TYPE_LINK_POS), NULL);
	return value->data[0].v_pointer;
}

static void
note_view_value_set_link_pos (GValue* value,
                              gpointer v_object)
{
	NoteViewLinkPos * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NOTE_VIEW_TYPE_LINK_POS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NOTE_VIEW_TYPE_LINK_POS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		note_view_link_pos_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		note_view_link_pos_unref (old);
	}
}

static void
note_view_value_take_link_pos (GValue* value,
                               gpointer v_object)
{
	NoteViewLinkPos * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NOTE_VIEW_TYPE_LINK_POS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NOTE_VIEW_TYPE_LINK_POS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		note_view_link_pos_unref (old);
	}
}

static void
note_view_link_pos_class_init (NoteViewLinkPosClass * klass,
                               gpointer klass_data)
{
	note_view_link_pos_parent_class = g_type_class_peek_parent (klass);
	((NoteViewLinkPosClass *) klass)->finalize = note_view_link_pos_finalize;
}

static void
note_view_link_pos_instance_init (NoteViewLinkPos * self,
                                  gpointer klass)
{
	self->ref_count = 1;
}

static void
note_view_link_pos_finalize (NoteViewLinkPos * obj)
{
	NoteViewLinkPos * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTE_VIEW_TYPE_LINK_POS, NoteViewLinkPos);
	g_signal_handlers_destroy (self);
}

static GType
note_view_link_pos_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { note_view_value_link_pos_init, note_view_value_link_pos_free_value, note_view_value_link_pos_copy_value, note_view_value_link_pos_peek_pointer, "p", note_view_value_link_pos_collect_value, "p", note_view_value_link_pos_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NoteViewLinkPosClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) note_view_link_pos_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NoteViewLinkPos), 0, (GInstanceInitFunc) note_view_link_pos_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType note_view_link_pos_type_id;
	note_view_link_pos_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NoteViewLinkPos", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return note_view_link_pos_type_id;
}

static GType
note_view_link_pos_get_type (void)
{
	static volatile gsize note_view_link_pos_type_id__once = 0;
	if (g_once_init_enter (&note_view_link_pos_type_id__once)) {
		GType note_view_link_pos_type_id;
		note_view_link_pos_type_id = note_view_link_pos_get_type_once ();
		g_once_init_leave (&note_view_link_pos_type_id__once, note_view_link_pos_type_id);
	}
	return note_view_link_pos_type_id__once;
}

static gpointer
note_view_link_pos_ref (gpointer instance)
{
	NoteViewLinkPos * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
note_view_link_pos_unref (gpointer instance)
{
	NoteViewLinkPos * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NOTE_VIEW_LINK_POS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
note_view_class_init (NoteViewClass * klass,
                      gpointer klass_data)
{
	note_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NoteView_private_offset);
	((GtkTextViewClass *) klass)->paste_clipboard = (void (*) (GtkTextView*)) note_view_real_paste_clipboard;
	G_OBJECT_CLASS (klass)->get_property = _vala_note_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_note_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = note_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTE_VIEW_TEXT_PROPERTY, note_view_properties[NOTE_VIEW_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTE_VIEW_MODIFIED_PROPERTY, note_view_properties[NOTE_VIEW_MODIFIED_PROPERTY] = g_param_spec_boolean ("modified", "modified", "modified", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	note_view_signals[NOTE_VIEW_NODE_LINK_ADDED_SIGNAL] = g_signal_new ("node-link-added", TYPE_NOTE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__NODE_LINK_POINTER, G_TYPE_INT, 2, TYPE_NODE_LINK, G_TYPE_POINTER);
	note_view_signals[NOTE_VIEW_NODE_LINK_CLICKED_SIGNAL] = g_signal_new ("node-link-clicked", TYPE_NOTE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	note_view_signals[NOTE_VIEW_NODE_LINK_HOVER_SIGNAL] = g_signal_new ("node-link-hover", TYPE_NOTE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static void
note_view_instance_init (NoteView * self,
                         gpointer klass)
{
	self->priv = note_view_get_instance_private (self);
	self->priv->_last_lnum = -1;
	self->priv->_last_url = NULL;
	self->priv->_last_link = NULL;
	self->_srcstyle = NULL;
}

static void
note_view_finalize (GObject * obj)
{
	NoteView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTE_VIEW, NoteView);
	_g_free0 (self->priv->_last_url);
	_g_free0 (self->priv->_last_link);
	_g_array_unref0 (self->priv->_last_urls);
	_g_array_unref0 (self->priv->_last_links);
	_g_regex_unref0 (self->priv->_url_re);
	_g_regex_unref0 (self->priv->_link_re);
	_g_object_unref0 (self->priv->_tooltip);
	_g_object_unref0 (self->_srcstyle);
	_g_object_unref0 (self->_buffer);
	G_OBJECT_CLASS (note_view_parent_class)->finalize (obj);
}

static GType
note_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NoteViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) note_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NoteView), 0, (GInstanceInitFunc) note_view_instance_init, NULL };
	GType note_view_type_id;
	note_view_type_id = g_type_register_static (gtk_source_view_get_type (), "NoteView", &g_define_type_info, 0);
	NoteView_private_offset = g_type_add_instance_private (note_view_type_id, sizeof (NoteViewPrivate));
	return note_view_type_id;
}

GType
note_view_get_type (void)
{
	static volatile gsize note_view_type_id__once = 0;
	if (g_once_init_enter (&note_view_type_id__once)) {
		GType note_view_type_id;
		note_view_type_id = note_view_get_type_once ();
		g_once_init_leave (&note_view_type_id__once, note_view_type_id);
	}
	return note_view_type_id__once;
}

static void
_vala_note_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	NoteView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NOTE_VIEW, NoteView);
	switch (property_id) {
		case NOTE_VIEW_TEXT_PROPERTY:
		g_value_take_string (value, note_view_get_text (self));
		break;
		case NOTE_VIEW_MODIFIED_PROPERTY:
		g_value_set_boolean (value, note_view_get_modified (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_note_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	NoteView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NOTE_VIEW, NoteView);
	switch (property_id) {
		case NOTE_VIEW_TEXT_PROPERTY:
		note_view_set_text (self, g_value_get_string (value));
		break;
		case NOTE_VIEW_MODIFIED_PROPERTY:
		note_view_set_modified (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

