/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the Mips target                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 44;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(MipsInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(MipsInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static MipsInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static MipsInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s64,
  GILLT_v4s8,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 9;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 8),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasMips2Bit = 7,
  Feature_HasMips3Bit = 17,
  Feature_HasMips4_32Bit = 27,
  Feature_NotMips4_32Bit = 28,
  Feature_HasMips4_32r2Bit = 18,
  Feature_HasMips32Bit = 3,
  Feature_HasMips32r2Bit = 6,
  Feature_HasMips32r6Bit = 29,
  Feature_NotMips32r6Bit = 4,
  Feature_IsGP64bitBit = 22,
  Feature_IsPTR64bitBit = 24,
  Feature_HasMips64Bit = 25,
  Feature_HasMips64r2Bit = 23,
  Feature_HasMips64r6Bit = 30,
  Feature_NotMips64r6Bit = 5,
  Feature_InMips16ModeBit = 31,
  Feature_NotInMips16ModeBit = 0,
  Feature_HasCnMipsBit = 26,
  Feature_NotCnMipsBit = 8,
  Feature_IsSym32Bit = 38,
  Feature_IsSym64Bit = 39,
  Feature_IsN64Bit = 40,
  Feature_RelocNotPICBit = 9,
  Feature_RelocPICBit = 37,
  Feature_NoNaNsFPMathBit = 21,
  Feature_UseAbsBit = 14,
  Feature_HasStdEncBit = 1,
  Feature_NotDSPBit = 11,
  Feature_InMicroMipsBit = 35,
  Feature_NotInMicroMipsBit = 2,
  Feature_IsLEBit = 42,
  Feature_IsBEBit = 43,
  Feature_IsNotNaClBit = 19,
  Feature_HasEVABit = 36,
  Feature_HasMSABit = 34,
  Feature_HasMadd4Bit = 20,
  Feature_UseIndirectJumpsHazardBit = 12,
  Feature_NoIndirectJumpGuardsBit = 10,
  Feature_AllowFPOpFusionBit = 41,
  Feature_IsFP64bitBit = 16,
  Feature_NotFP64bitBit = 15,
  Feature_IsNotSoftFloatBit = 13,
  Feature_HasDSPBit = 32,
  Feature_HasDSPR2Bit = 33,
};

PredicateBitset MipsInstructionSelector::
computeAvailableModuleFeatures(const MipsSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->hasMips2())
    Features.set(Feature_HasMips2Bit);
  if (Subtarget->hasMips3())
    Features.set(Feature_HasMips3Bit);
  if (Subtarget->hasMips4_32())
    Features.set(Feature_HasMips4_32Bit);
  if (!Subtarget->hasMips4_32())
    Features.set(Feature_NotMips4_32Bit);
  if (Subtarget->hasMips4_32r2())
    Features.set(Feature_HasMips4_32r2Bit);
  if (Subtarget->hasMips32())
    Features.set(Feature_HasMips32Bit);
  if (Subtarget->hasMips32r2())
    Features.set(Feature_HasMips32r2Bit);
  if (Subtarget->hasMips32r6())
    Features.set(Feature_HasMips32r6Bit);
  if (!Subtarget->hasMips32r6())
    Features.set(Feature_NotMips32r6Bit);
  if (Subtarget->isGP64bit())
    Features.set(Feature_IsGP64bitBit);
  if (Subtarget->isABI_N64())
    Features.set(Feature_IsPTR64bitBit);
  if (Subtarget->hasMips64())
    Features.set(Feature_HasMips64Bit);
  if (Subtarget->hasMips64r2())
    Features.set(Feature_HasMips64r2Bit);
  if (Subtarget->hasMips64r6())
    Features.set(Feature_HasMips64r6Bit);
  if (!Subtarget->hasMips64r6())
    Features.set(Feature_NotMips64r6Bit);
  if (Subtarget->inMips16Mode())
    Features.set(Feature_InMips16ModeBit);
  if (!Subtarget->inMips16Mode())
    Features.set(Feature_NotInMips16ModeBit);
  if (Subtarget->hasCnMips())
    Features.set(Feature_HasCnMipsBit);
  if (!Subtarget->hasCnMips())
    Features.set(Feature_NotCnMipsBit);
  if (Subtarget->hasSym32())
    Features.set(Feature_IsSym32Bit);
  if (!Subtarget->hasSym32())
    Features.set(Feature_IsSym64Bit);
  if (Subtarget->isABI_N64())
    Features.set(Feature_IsN64Bit);
  if (!TM.isPositionIndependent())
    Features.set(Feature_RelocNotPICBit);
  if (TM.isPositionIndependent())
    Features.set(Feature_RelocPICBit);
  if (TM.Options.NoNaNsFPMath)
    Features.set(Feature_NoNaNsFPMathBit);
  if (Subtarget->inAbs2008Mode() ||TM.Options.NoNaNsFPMath)
    Features.set(Feature_UseAbsBit);
  if (Subtarget->hasStandardEncoding())
    Features.set(Feature_HasStdEncBit);
  if (!Subtarget->hasDSP())
    Features.set(Feature_NotDSPBit);
  if (Subtarget->inMicroMipsMode())
    Features.set(Feature_InMicroMipsBit);
  if (!Subtarget->inMicroMipsMode())
    Features.set(Feature_NotInMicroMipsBit);
  if (Subtarget->isLittle())
    Features.set(Feature_IsLEBit);
  if (!Subtarget->isLittle())
    Features.set(Feature_IsBEBit);
  if (!Subtarget->isTargetNaCl())
    Features.set(Feature_IsNotNaClBit);
  if (Subtarget->hasEVA())
    Features.set(Feature_HasEVABit);
  if (Subtarget->hasMSA())
    Features.set(Feature_HasMSABit);
  if (!Subtarget->disableMadd4())
    Features.set(Feature_HasMadd4Bit);
  if (Subtarget->useIndirectJumpsHazard())
    Features.set(Feature_UseIndirectJumpsHazardBit);
  if (!Subtarget->useIndirectJumpsHazard())
    Features.set(Feature_NoIndirectJumpGuardsBit);
  if (TM.Options.AllowFPOpFusion == FPOpFusion::Fast)
    Features.set(Feature_AllowFPOpFusionBit);
  if (Subtarget->isFP64bit())
    Features.set(Feature_IsFP64bitBit);
  if (!Subtarget->isFP64bit())
    Features.set(Feature_NotFP64bitBit);
  if (!Subtarget->useSoftFloat())
    Features.set(Feature_IsNotSoftFloatBit);
  if (Subtarget->hasDSP())
    Features.set(Feature_HasDSPBit);
  if (Subtarget->hasDSPR2())
    Features.set(Feature_HasDSPR2Bit);
  return Features;
}

void MipsInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const MipsSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset MipsInstructionSelector::
computeAvailableFunctionFeatures(const MipsSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasCnMips,
  GIFBS_HasDSP,
  GIFBS_HasDSPR2,
  GIFBS_HasMSA,
  GIFBS_InMicroMips,
  GIFBS_InMips16Mode,
  GIFBS_IsFP64bit,
  GIFBS_NotFP64bit,
  GIFBS_NotInMips16Mode,
  GIFBS_HasDSP_InMicroMips,
  GIFBS_HasDSP_NotInMicroMips,
  GIFBS_HasDSPR2_InMicroMips,
  GIFBS_HasMSA_HasStdEnc,
  GIFBS_HasMSA_IsBE,
  GIFBS_HasMSA_IsLE,
  GIFBS_HasMips32r6_HasStdEnc,
  GIFBS_HasMips32r6_InMicroMips,
  GIFBS_HasMips64r2_HasStdEnc,
  GIFBS_HasMips64r6_HasStdEnc,
  GIFBS_HasStdEnc_IsNotSoftFloat,
  GIFBS_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_NotMips4_32,
  GIFBS_InMicroMips_IsFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat,
  GIFBS_InMicroMips_NotFP64bit,
  GIFBS_InMicroMips_NotMips32r6,
  GIFBS_IsGP64bit_NotInMips16Mode,
  GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
  GIFBS_HasMSA_HasMips64_HasStdEnc,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit,
  GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r2_HasStdEnc_IsGP64bit,
  GIFBS_HasMips32r2_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
  GIFBS_HasMips64r2_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_NotInMicroMips_RelocNotPIC,
  GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
  GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat_UseAbs,
  GIFBS_InMicroMips_NotFP64bit_NotMips32r6,
  GIFBS_InMicroMips_NotMips32r6_RelocNotPIC,
  GIFBS_InMicroMips_NotMips32r6_RelocPIC,
  GIFBS_IsFP64bit_IsNotSoftFloat_NotInMips16Mode,
  GIFBS_IsNotSoftFloat_NotFP64bit_NotInMips16Mode,
  GIFBS_HasMadd4_InMicroMips_NoNaNsFPMath_NotMips32r6,
  GIFBS_HasMips2_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips32_HasStdEnc_NotMips32r6_NotMips64r6,
  GIFBS_HasMips32r6_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips4_32_HasStdEnc_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64r2_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips_UseAbs,
  GIFBS_HasMadd4_InMicroMips_NoNaNsFPMath_NotFP64bit_NotMips32r6,
  GIFBS_HasMips2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips64r6,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_UseAbs,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_UseAbs,
  GIFBS_HasMips4_32_HasStdEnc_IsFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasCnMipsBit, },
  {Feature_HasDSPBit, },
  {Feature_HasDSPR2Bit, },
  {Feature_HasMSABit, },
  {Feature_InMicroMipsBit, },
  {Feature_InMips16ModeBit, },
  {Feature_IsFP64bitBit, },
  {Feature_NotFP64bitBit, },
  {Feature_NotInMips16ModeBit, },
  {Feature_HasDSPBit, Feature_InMicroMipsBit, },
  {Feature_HasDSPBit, Feature_NotInMicroMipsBit, },
  {Feature_HasDSPR2Bit, Feature_InMicroMipsBit, },
  {Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_IsBEBit, },
  {Feature_HasMSABit, Feature_IsLEBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotMips4_32Bit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, },
  {Feature_IsGP64bitBit, Feature_NotInMips16ModeBit, },
  {Feature_AllowFPOpFusionBit, Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_HasMips64Bit, Feature_HasStdEncBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r2Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, },
  {Feature_HasMips32r2Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_UseAbsBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocPICBit, },
  {Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMips16ModeBit, },
  {Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMips16ModeBit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotMips32r6Bit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32Bit, Feature_HasStdEncBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips64r6Bit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

MipsInstructionSelector::ComplexMatcherMemFn
MipsInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool MipsInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_immLi16 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_immSExt6,
  GICXXPred_I64_Predicate_immSExt10,
  GICXXPred_I64_Predicate_immSExtAddiur2,
  GICXXPred_I64_Predicate_immSExtAddius5,
  GICXXPred_I64_Predicate_immZExt1,
  GICXXPred_I64_Predicate_immZExt1Ptr,
  GICXXPred_I64_Predicate_immZExt2,
  GICXXPred_I64_Predicate_immZExt2Lsa,
  GICXXPred_I64_Predicate_immZExt2Ptr,
  GICXXPred_I64_Predicate_immZExt2Shift,
  GICXXPred_I64_Predicate_immZExt3,
  GICXXPred_I64_Predicate_immZExt3Ptr,
  GICXXPred_I64_Predicate_immZExt4,
  GICXXPred_I64_Predicate_immZExt4Ptr,
  GICXXPred_I64_Predicate_immZExt5,
  GICXXPred_I64_Predicate_immZExt5_64,
  GICXXPred_I64_Predicate_immZExt6,
  GICXXPred_I64_Predicate_immZExt8,
  GICXXPred_I64_Predicate_immZExt10,
  GICXXPred_I64_Predicate_immZExtAndi16,
  GICXXPred_I64_Predicate_immi32Cst7,
  GICXXPred_I64_Predicate_immi32Cst15,
  GICXXPred_I64_Predicate_immi32Cst31,
  GICXXPred_I64_Predicate_timmSExt6,
  GICXXPred_I64_Predicate_timmZExt1,
  GICXXPred_I64_Predicate_timmZExt1Ptr,
  GICXXPred_I64_Predicate_timmZExt2,
  GICXXPred_I64_Predicate_timmZExt2Ptr,
  GICXXPred_I64_Predicate_timmZExt3,
  GICXXPred_I64_Predicate_timmZExt3Ptr,
  GICXXPred_I64_Predicate_timmZExt4,
  GICXXPred_I64_Predicate_timmZExt4Ptr,
  GICXXPred_I64_Predicate_timmZExt5,
  GICXXPred_I64_Predicate_timmZExt6,
  GICXXPred_I64_Predicate_timmZExt8,
  GICXXPred_I64_Predicate_timmZExt10,
};
bool MipsInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_immLi16: {
    return Imm >= -1 && Imm <= 126;
  }
  case GICXXPred_I64_Predicate_immSExt6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_immSExt10: {
    return isInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immSExtAddiur2: {
    return Imm == 1 || Imm == -1 ||
                                               ((Imm % 4 == 0) &&
                                                Imm < 28 && Imm > 0);
  }
  case GICXXPred_I64_Predicate_immSExtAddius5: {
    return Imm >= -8 && Imm <= 7;
  }
  case GICXXPred_I64_Predicate_immZExt1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt1Ptr: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2Lsa: {
    return isUInt<2>(Imm - 1);
  }
  case GICXXPred_I64_Predicate_immZExt2Ptr: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2Shift: {
    return Imm >= 1 && Imm <= 8;
  }
  case GICXXPred_I64_Predicate_immZExt3: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt3Ptr: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt4: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt4Ptr: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt5: {
    return Imm == (Imm & 0x1f);
  }
  case GICXXPred_I64_Predicate_immZExt5_64: {
     return Imm == (Imm & 0x1f); 
  }
  case GICXXPred_I64_Predicate_immZExt6: {
    return Imm == (Imm & 0x3f);
  }
  case GICXXPred_I64_Predicate_immZExt8: {
    return isUInt<8>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExtAndi16: {
    return (Imm == 128 || (Imm >= 1 && Imm <= 4) || Imm == 7 || Imm == 8 ||
                Imm == 15 || Imm == 16 || Imm == 31 || Imm == 32 || Imm == 63 ||
                Imm == 64 || Imm == 255 || Imm == 32768 || Imm == 65535 );
  }
  case GICXXPred_I64_Predicate_immi32Cst7: {
    return isUInt<32>(Imm) && Imm == 7;
  }
  case GICXXPred_I64_Predicate_immi32Cst15: {
    return isUInt<32>(Imm) && Imm == 15;
  }
  case GICXXPred_I64_Predicate_immi32Cst31: {
    return isUInt<32>(Imm) && Imm == 31;
  }
  case GICXXPred_I64_Predicate_timmSExt6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt1Ptr: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt2Ptr: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt3: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt3Ptr: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt4: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt4Ptr: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt5: {
    return Imm == (Imm & 0x1f);
  }
  case GICXXPred_I64_Predicate_timmZExt6: {
    return Imm == (Imm & 0x3f);
  }
  case GICXXPred_I64_Predicate_timmZExt8: {
    return isUInt<8>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt10: {
    return isUInt<10>(Imm);
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool MipsInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_imm32SExt16 = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_imm32ZExt16,
};
bool MipsInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_imm32SExt16: {
     return isInt<16>(Imm.getSExtValue()); 
  }
  case GICXXPred_APInt_Predicate_imm32ZExt16: {
    
      return (uint32_t)Imm.getZExtValue() == (unsigned short)Imm.getZExtValue();
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool MipsInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("MipsInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
MipsInstructionSelector::CustomRendererFn
MipsInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool MipsInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool MipsInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("MipsInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *MipsInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(285), /*)*//*default:*//*Label 77*/ GIMT_Encode4(69617),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(938),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(2236),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(2927),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(3408),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(3677),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(3946),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(4215), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(4484),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(5040),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(5444), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_MERGE_VALUES*//*Label 10*/ GIMT_Encode4(6336),
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 11*/ GIMT_Encode4(6409), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 12*/ GIMT_Encode4(6750), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_LOAD*//*Label 13*/ GIMT_Encode4(11061),
    /*TargetOpcode::G_SEXTLOAD*//*Label 14*/ GIMT_Encode4(11126),
    /*TargetOpcode::G_ZEXTLOAD*//*Label 15*/ GIMT_Encode4(11194), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 16*/ GIMT_Encode4(11262),
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 17*/ GIMT_Encode4(11454),
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 18*/ GIMT_Encode4(11624),
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 19*/ GIMT_Encode4(11794),
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 20*/ GIMT_Encode4(11964),
    /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 21*/ GIMT_Encode4(12134),
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 22*/ GIMT_Encode4(12304),
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 23*/ GIMT_Encode4(12474),
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 24*/ GIMT_Encode4(12644),
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 25*/ GIMT_Encode4(12814),
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 26*/ GIMT_Encode4(12984),
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 27*/ GIMT_Encode4(13154), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BRCOND*//*Label 28*/ GIMT_Encode4(13324), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 29*/ GIMT_Encode4(18045),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 30*/ GIMT_Encode4(32310), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 31*/ GIMT_Encode4(37404),
    /*TargetOpcode::G_TRUNC*//*Label 32*/ GIMT_Encode4(37470),
    /*TargetOpcode::G_CONSTANT*//*Label 33*/ GIMT_Encode4(37534), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 34*/ GIMT_Encode4(37595),
    /*TargetOpcode::G_SEXT_INREG*//*Label 35*/ GIMT_Encode4(39059),
    /*TargetOpcode::G_ZEXT*//*Label 36*/ GIMT_Encode4(39407),
    /*TargetOpcode::G_SHL*//*Label 37*/ GIMT_Encode4(39608),
    /*TargetOpcode::G_LSHR*//*Label 38*/ GIMT_Encode4(41405),
    /*TargetOpcode::G_ASHR*//*Label 39*/ GIMT_Encode4(43202), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTR*//*Label 40*/ GIMT_Encode4(44957), GIMT_Encode4(0),
    /*TargetOpcode::G_ICMP*//*Label 41*/ GIMT_Encode4(45245),
    /*TargetOpcode::G_FCMP*//*Label 42*/ GIMT_Encode4(47776), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 43*/ GIMT_Encode4(49482), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 44*/ GIMT_Encode4(61520),
    /*TargetOpcode::G_SMULH*//*Label 45*/ GIMT_Encode4(61629), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 46*/ GIMT_Encode4(61738),
    /*TargetOpcode::G_FSUB*//*Label 47*/ GIMT_Encode4(62651),
    /*TargetOpcode::G_FMUL*//*Label 48*/ GIMT_Encode4(63263),
    /*TargetOpcode::G_FMA*//*Label 49*/ GIMT_Encode4(63750), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 50*/ GIMT_Encode4(63856), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FEXP2*//*Label 51*/ GIMT_Encode4(64155), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FLOG2*//*Label 52*/ GIMT_Encode4(64233), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 53*/ GIMT_Encode4(64311),
    /*TargetOpcode::G_FPEXT*//*Label 54*/ GIMT_Encode4(65680),
    /*TargetOpcode::G_FPTRUNC*//*Label 55*/ GIMT_Encode4(65858),
    /*TargetOpcode::G_FPTOSI*//*Label 56*/ GIMT_Encode4(66021),
    /*TargetOpcode::G_FPTOUI*//*Label 57*/ GIMT_Encode4(66099),
    /*TargetOpcode::G_SITOFP*//*Label 58*/ GIMT_Encode4(66177),
    /*TargetOpcode::G_UITOFP*//*Label 59*/ GIMT_Encode4(66430), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FABS*//*Label 60*/ GIMT_Encode4(66508), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FCANONICALIZE*//*Label 61*/ GIMT_Encode4(66748), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM_IEEE*//*Label 62*/ GIMT_Encode4(66822),
    /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 63*/ GIMT_Encode4(66894), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 64*/ GIMT_Encode4(66966),
    /*TargetOpcode::G_SMAX*//*Label 65*/ GIMT_Encode4(67134),
    /*TargetOpcode::G_UMIN*//*Label 66*/ GIMT_Encode4(67302),
    /*TargetOpcode::G_UMAX*//*Label 67*/ GIMT_Encode4(67470), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 68*/ GIMT_Encode4(67638), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 69*/ GIMT_Encode4(67762),
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 70*/ GIMT_Encode4(68326), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 71*/ GIMT_Encode4(68378), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 72*/ GIMT_Encode4(68883),
    /*TargetOpcode::G_BSWAP*//*Label 73*/ GIMT_Encode4(69089), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 74*/ GIMT_Encode4(69253), GIMT_Encode4(0),
    /*TargetOpcode::G_FRINT*//*Label 75*/ GIMT_Encode4(69493), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 76*/ GIMT_Encode4(69571),
    // Label 0: @938
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 86*/ GIMT_Encode4(2235),
    /*GILLT_s32*//*Label 78*/ GIMT_Encode4(981),
    /*GILLT_s64*//*Label 79*/ GIMT_Encode4(1389),
    /*GILLT_v2s16*//*Label 80*/ GIMT_Encode4(1555),
    /*GILLT_v2s64*//*Label 81*/ GIMT_Encode4(1587),
    /*GILLT_v4s8*//*Label 82*/ GIMT_Encode4(1741),
    /*GILLT_v4s32*//*Label 83*/ GIMT_Encode4(1773),
    /*GILLT_v8s16*//*Label 84*/ GIMT_Encode4(1927),
    /*GILLT_v16s8*//*Label 85*/ GIMT_Encode4(2081),
    // Label 78: @981
    GIM_Try, /*On fail goto*//*Label 87*/ GIMT_Encode4(1388),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(1059), // Rule ID 2389 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR32Opnd:{ *:[i32] }:$rt)  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LSA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2389,
        GIR_EraseRootFromParent_Done,
      // Label 88: @1059
      GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1126), // Rule ID 834 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LSA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 834,
        GIR_EraseRootFromParent_Done,
      // Label 89: @1126
      GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1168), // Rule ID 40 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm16)  =>  (ADDiu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDiu),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 40,
        GIR_EraseRootFromParent_Done,
      // Label 90: @1168
      GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1210), // Rule ID 2158 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExtAddiur2),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)  =>  (ADDIUR2_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDIUR2_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2158,
        GIR_EraseRootFromParent_Done,
      // Label 91: @1210
      GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1252), // Rule ID 2159 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExtAddius5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)  =>  (ADDIUS5_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDIUS5_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2159,
        GIR_EraseRootFromParent_Done,
      // Label 92: @1252
      GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1279), // Rule ID 1208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU16_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1208,
        GIR_Done,
      // Label 93: @1279
      GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1306), // Rule ID 46 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDu),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46,
        GIR_Done,
      // Label 94: @1306
      GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1333), // Rule ID 1060 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU16_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1060,
        GIR_Done,
      // Label 95: @1333
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1360), // Rule ID 1072 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDu_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1072,
        GIR_Done,
      // Label 96: @1360
      GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1387), // Rule ID 1818 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (add:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AdduRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AdduRxRyRz16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1818,
        GIR_Done,
      // Label 97: @1387
      GIM_Reject,
    // Label 87: @1388
    GIM_Reject,
    // Label 79: @1389
    GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1554),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1467), // Rule ID 2390 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR64Opnd:{ *:[i64] }:$rt)  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DLSA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2390,
        GIR_EraseRootFromParent_Done,
      // Label 99: @1467
      GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1530), // Rule ID 835 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DLSA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 835,
        GIR_EraseRootFromParent_Done,
      // Label 100: @1530
      GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1553), // Rule ID 202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DADDu),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 202,
        GIR_Done,
      // Label 101: @1553
      GIM_Reject,
    // Label 98: @1554
    GIM_Reject,
    // Label 80: @1555
    GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1586), // Rule ID 1917 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (add:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQ_PH),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1917,
      GIR_Done,
    // Label 102: @1586
    GIM_Reject,
    // Label 81: @1587
    GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1740),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1659), // Rule ID 2394 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt), MSA128DOpnd:{ *:[v2i64] }:$wd_in)  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2394,
        GIR_EraseRootFromParent_Done,
      // Label 104: @1659
      GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1716), // Rule ID 843 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 843,
        GIR_EraseRootFromParent_Done,
      // Label 105: @1716
      GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1739), // Rule ID 510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_D),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 510,
        GIR_Done,
      // Label 106: @1739
      GIM_Reject,
    // Label 103: @1740
    GIM_Reject,
    // Label 82: @1741
    GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1772), // Rule ID 1923 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (add:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_QB),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1923,
      GIR_Done,
    // Label 107: @1772
    GIM_Reject,
    // Label 83: @1773
    GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1926),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1845), // Rule ID 2393 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt), MSA128WOpnd:{ *:[v4i32] }:$wd_in)  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2393,
        GIR_EraseRootFromParent_Done,
      // Label 109: @1845
      GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1902), // Rule ID 842 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 842,
        GIR_EraseRootFromParent_Done,
      // Label 110: @1902
      GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1925), // Rule ID 509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_W),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 509,
        GIR_Done,
      // Label 111: @1925
      GIM_Reject,
    // Label 108: @1926
    GIM_Reject,
    // Label 84: @1927
    GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(2080),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1999), // Rule ID 2392 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt), MSA128HOpnd:{ *:[v8i16] }:$wd_in)  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2392,
        GIR_EraseRootFromParent_Done,
      // Label 113: @1999
      GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(2056), // Rule ID 841 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 841,
        GIR_EraseRootFromParent_Done,
      // Label 114: @2056
      GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(2079), // Rule ID 508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_H),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 115: @2079
      GIM_Reject,
    // Label 112: @2080
    GIM_Reject,
    // Label 85: @2081
    GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(2234),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(2153), // Rule ID 2391 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt), MSA128BOpnd:{ *:[v16i8] }:$wd_in)  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2391,
        GIR_EraseRootFromParent_Done,
      // Label 117: @2153
      GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(2210), // Rule ID 840 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 840,
        GIR_EraseRootFromParent_Done,
      // Label 118: @2210
      GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(2233), // Rule ID 507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_B),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 119: @2233
      GIM_Reject,
    // Label 116: @2234
    GIM_Reject,
    // Label 86: @2235
    GIM_Reject,
    // Label 1: @2236
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 128*/ GIMT_Encode4(2926),
    /*GILLT_s32*//*Label 120*/ GIMT_Encode4(2279),
    /*GILLT_s64*//*Label 121*/ GIMT_Encode4(2456),
    /*GILLT_v2s16*//*Label 122*/ GIMT_Encode4(2490),
    /*GILLT_v2s64*//*Label 123*/ GIMT_Encode4(2522),
    /*GILLT_v4s8*//*Label 124*/ GIMT_Encode4(2615),
    /*GILLT_v4s32*//*Label 125*/ GIMT_Encode4(2647),
    /*GILLT_v8s16*//*Label 126*/ GIMT_Encode4(2740),
    /*GILLT_v16s8*//*Label 127*/ GIMT_Encode4(2833),
    // Label 120: @2279
    GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(2455),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(2319), // Rule ID 1817 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (sub:{ *:[i32] } 0:{ *:[i32] }, CPU16Regs:{ *:[i32] }:$r)  =>  (NegRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NegRxRy16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rx]
        GIR_RootToRootCopy, /*OpIdx*/2, // r
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1817,
        GIR_EraseRootFromParent_Done,
      // Label 130: @2319
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(2346), // Rule ID 1210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU16_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1210,
        GIR_Done,
      // Label 131: @2346
      GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(2373), // Rule ID 47 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBu),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47,
        GIR_Done,
      // Label 132: @2373
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(2400), // Rule ID 1064 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU16_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1064,
        GIR_Done,
      // Label 133: @2400
      GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(2427), // Rule ID 1073 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBu_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1073,
        GIR_Done,
      // Label 134: @2427
      GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2454), // Rule ID 1822 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (sub:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (SubuRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SubuRxRyRz16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1822,
        GIR_Done,
      // Label 135: @2454
      GIM_Reject,
    // Label 129: @2455
    GIM_Reject,
    // Label 121: @2456
    GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2489), // Rule ID 203 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (sub:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DSUBu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSUBu),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 203,
      GIR_Done,
    // Label 136: @2489
    GIM_Reject,
    // Label 122: @2490
    GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2521), // Rule ID 1919 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (sub:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQ_PH),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1919,
      GIR_Done,
    // Label 137: @2521
    GIM_Reject,
    // Label 123: @2522
    GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2614),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2594), // Rule ID 899 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MSUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 899,
        GIR_EraseRootFromParent_Done,
      // Label 139: @2594
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(2613), // Rule ID 1028 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_D),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1028,
        GIR_Done,
      // Label 140: @2613
      GIM_Reject,
    // Label 138: @2614
    GIM_Reject,
    // Label 124: @2615
    GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2646), // Rule ID 1925 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (sub:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_QB),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1925,
      GIR_Done,
    // Label 141: @2646
    GIM_Reject,
    // Label 125: @2647
    GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2739),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2719), // Rule ID 898 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MSUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 898,
        GIR_EraseRootFromParent_Done,
      // Label 143: @2719
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2738), // Rule ID 1027 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_W),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1027,
        GIR_Done,
      // Label 144: @2738
      GIM_Reject,
    // Label 142: @2739
    GIM_Reject,
    // Label 126: @2740
    GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2832),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2812), // Rule ID 897 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MSUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 897,
        GIR_EraseRootFromParent_Done,
      // Label 146: @2812
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2831), // Rule ID 1026 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_H),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1026,
        GIR_Done,
      // Label 147: @2831
      GIM_Reject,
    // Label 145: @2832
    GIM_Reject,
    // Label 127: @2833
    GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2925),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2905), // Rule ID 896 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MSUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 896,
        GIR_EraseRootFromParent_Done,
      // Label 149: @2905
      GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2924), // Rule ID 1025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_B),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1025,
        GIR_Done,
      // Label 150: @2924
      GIM_Reject,
    // Label 148: @2925
    GIM_Reject,
    // Label 128: @2926
    GIM_Reject,
    // Label 2: @2927
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 158*/ GIMT_Encode4(3407),
    /*GILLT_s32*//*Label 151*/ GIMT_Encode4(2970),
    /*GILLT_s64*//*Label 152*/ GIMT_Encode4(3154),
    /*GILLT_v2s16*//*Label 153*/ GIMT_Encode4(3239),
    /*GILLT_v2s64*//*Label 154*/ GIMT_Encode4(3271), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 155*/ GIMT_Encode4(3305),
    /*GILLT_v8s16*//*Label 156*/ GIMT_Encode4(3339),
    /*GILLT_v16s8*//*Label 157*/ GIMT_Encode4(3373),
    // Label 151: @2970
    GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(3153),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(3020), // Rule ID 48 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48,
        GIR_Done,
      // Label 160: @3020
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(3047), // Rule ID 332 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_R6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_R6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 332,
        GIR_Done,
      // Label 161: @3047
      GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(3086), // Rule ID 1074 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MM:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_MM),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1074,
        GIR_Done,
      // Label 162: @3086
      GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(3113), // Rule ID 1179 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1179,
        GIR_Done,
      // Label 163: @3113
      GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(3152), // Rule ID 1820 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (mul:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (MultRxRyRz16:{ *:[i32] }:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MultRxRyRz16),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1820,
        GIR_Done,
      // Label 164: @3152
      GIM_Reject,
    // Label 159: @3153
    GIM_Reject,
    // Label 152: @3154
    GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(3238),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(3222), // Rule ID 274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
        // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL:{ *:[i64] }:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMUL),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P1), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P2), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 274,
        GIR_Done,
      // Label 166: @3222
      GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(3237), // Rule ID 347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
        // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL_R6:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMUL_R6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 347,
        GIR_Done,
      // Label 167: @3237
      GIM_Reject,
    // Label 165: @3238
    GIM_Reject,
    // Label 153: @3239
    GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(3270), // Rule ID 1921 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (mul:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_PH),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag21), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1921,
      GIR_Done,
    // Label 168: @3270
    GIM_Reject,
    // Label 154: @3271
    GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(3304), // Rule ID 907 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MULV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 907,
      GIR_Done,
    // Label 169: @3304
    GIM_Reject,
    // Label 155: @3305
    GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(3338), // Rule ID 906 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_W),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 906,
      GIR_Done,
    // Label 170: @3338
    GIM_Reject,
    // Label 156: @3339
    GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(3372), // Rule ID 905 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 905,
      GIR_Done,
    // Label 171: @3372
    GIM_Reject,
    // Label 157: @3373
    GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(3406), // Rule ID 904 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MULV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 904,
      GIR_Done,
    // Label 172: @3406
    GIM_Reject,
    // Label 158: @3407
    GIM_Reject,
    // Label 3: @3408
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 179*/ GIMT_Encode4(3676),
    /*GILLT_s32*//*Label 173*/ GIMT_Encode4(3451),
    /*GILLT_s64*//*Label 174*/ GIMT_Encode4(3506), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 175*/ GIMT_Encode4(3540), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 176*/ GIMT_Encode4(3574),
    /*GILLT_v8s16*//*Label 177*/ GIMT_Encode4(3608),
    /*GILLT_v16s8*//*Label 178*/ GIMT_Encode4(3642),
    // Label 173: @3451
    GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(3505),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(3489), // Rule ID 326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 326,
        GIR_Done,
      // Label 181: @3489
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(3504), // Rule ID 1172 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1172,
        GIR_Done,
      // Label 182: @3504
      GIM_Reject,
    // Label 180: @3505
    GIM_Reject,
    // Label 174: @3506
    GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(3539), // Rule ID 341 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (sdiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DDIV),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 341,
      GIR_Done,
    // Label 183: @3539
    GIM_Reject,
    // Label 175: @3540
    GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(3573), // Rule ID 647 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (sdiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 647,
      GIR_Done,
    // Label 184: @3573
    GIM_Reject,
    // Label 176: @3574
    GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(3607), // Rule ID 646 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (sdiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_W),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 646,
      GIR_Done,
    // Label 185: @3607
    GIM_Reject,
    // Label 177: @3608
    GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(3641), // Rule ID 645 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (sdiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 645,
      GIR_Done,
    // Label 186: @3641
    GIM_Reject,
    // Label 178: @3642
    GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(3675), // Rule ID 644 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (sdiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 644,
      GIR_Done,
    // Label 187: @3675
    GIM_Reject,
    // Label 179: @3676
    GIM_Reject,
    // Label 4: @3677
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 194*/ GIMT_Encode4(3945),
    /*GILLT_s32*//*Label 188*/ GIMT_Encode4(3720),
    /*GILLT_s64*//*Label 189*/ GIMT_Encode4(3775), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 190*/ GIMT_Encode4(3809), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 191*/ GIMT_Encode4(3843),
    /*GILLT_v8s16*//*Label 192*/ GIMT_Encode4(3877),
    /*GILLT_v16s8*//*Label 193*/ GIMT_Encode4(3911),
    // Label 188: @3720
    GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(3774),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(3758), // Rule ID 327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIVU),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 327,
        GIR_Done,
      // Label 196: @3758
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(3773), // Rule ID 1173 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIVU_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1173,
        GIR_Done,
      // Label 197: @3773
      GIM_Reject,
    // Label 195: @3774
    GIM_Reject,
    // Label 189: @3775
    GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(3808), // Rule ID 342 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (udiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIVU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DDIVU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 342,
      GIR_Done,
    // Label 198: @3808
    GIM_Reject,
    // Label 190: @3809
    GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(3842), // Rule ID 651 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (udiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 651,
      GIR_Done,
    // Label 199: @3842
    GIM_Reject,
    // Label 191: @3843
    GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(3876), // Rule ID 650 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (udiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_W),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 650,
      GIR_Done,
    // Label 200: @3876
    GIM_Reject,
    // Label 192: @3877
    GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(3910), // Rule ID 649 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (udiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 649,
      GIR_Done,
    // Label 201: @3910
    GIM_Reject,
    // Label 193: @3911
    GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(3944), // Rule ID 648 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (udiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 648,
      GIR_Done,
    // Label 202: @3944
    GIM_Reject,
    // Label 194: @3945
    GIM_Reject,
    // Label 5: @3946
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 209*/ GIMT_Encode4(4214),
    /*GILLT_s32*//*Label 203*/ GIMT_Encode4(3989),
    /*GILLT_s64*//*Label 204*/ GIMT_Encode4(4044), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 205*/ GIMT_Encode4(4078), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 206*/ GIMT_Encode4(4112),
    /*GILLT_v8s16*//*Label 207*/ GIMT_Encode4(4146),
    /*GILLT_v16s8*//*Label 208*/ GIMT_Encode4(4180),
    // Label 203: @3989
    GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(4043),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(4027), // Rule ID 328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 328,
        GIR_Done,
      // Label 211: @4027
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(4042), // Rule ID 1177 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1177,
        GIR_Done,
      // Label 212: @4042
      GIM_Reject,
    // Label 210: @4043
    GIM_Reject,
    // Label 204: @4044
    GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(4077), // Rule ID 343 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (srem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMOD:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMOD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 343,
      GIR_Done,
    // Label 213: @4077
    GIM_Reject,
    // Label 205: @4078
    GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(4111), // Rule ID 887 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (srem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 887,
      GIR_Done,
    // Label 214: @4111
    GIM_Reject,
    // Label 206: @4112
    GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(4145), // Rule ID 886 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (srem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_W),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 886,
      GIR_Done,
    // Label 215: @4145
    GIM_Reject,
    // Label 207: @4146
    GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(4179), // Rule ID 885 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (srem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 885,
      GIR_Done,
    // Label 216: @4179
    GIM_Reject,
    // Label 208: @4180
    GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(4213), // Rule ID 884 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (srem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 884,
      GIR_Done,
    // Label 217: @4213
    GIM_Reject,
    // Label 209: @4214
    GIM_Reject,
    // Label 6: @4215
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 224*/ GIMT_Encode4(4483),
    /*GILLT_s32*//*Label 218*/ GIMT_Encode4(4258),
    /*GILLT_s64*//*Label 219*/ GIMT_Encode4(4313), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 220*/ GIMT_Encode4(4347), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 221*/ GIMT_Encode4(4381),
    /*GILLT_v8s16*//*Label 222*/ GIMT_Encode4(4415),
    /*GILLT_v16s8*//*Label 223*/ GIMT_Encode4(4449),
    // Label 218: @4258
    GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(4312),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(4296), // Rule ID 329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MODU),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 329,
        GIR_Done,
      // Label 226: @4296
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(4311), // Rule ID 1178 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MODU_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1178,
        GIR_Done,
      // Label 227: @4311
      GIM_Reject,
    // Label 225: @4312
    GIM_Reject,
    // Label 219: @4313
    GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(4346), // Rule ID 344 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (urem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMODU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMODU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 344,
      GIR_Done,
    // Label 228: @4346
    GIM_Reject,
    // Label 220: @4347
    GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(4380), // Rule ID 891 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (urem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 891,
      GIR_Done,
    // Label 229: @4380
    GIM_Reject,
    // Label 221: @4381
    GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(4414), // Rule ID 890 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (urem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_W),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 890,
      GIR_Done,
    // Label 230: @4414
    GIM_Reject,
    // Label 222: @4415
    GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(4448), // Rule ID 889 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (urem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 889,
      GIR_Done,
    // Label 231: @4448
    GIM_Reject,
    // Label 223: @4449
    GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(4482), // Rule ID 888 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (urem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 888,
      GIR_Done,
    // Label 232: @4482
    GIM_Reject,
    // Label 224: @4483
    GIM_Reject,
    // Label 7: @4484
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 239*/ GIMT_Encode4(5039),
    /*GILLT_s32*//*Label 233*/ GIMT_Encode4(4527),
    /*GILLT_s64*//*Label 234*/ GIMT_Encode4(4801), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 235*/ GIMT_Encode4(4903), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 236*/ GIMT_Encode4(4937),
    /*GILLT_v8s16*//*Label 237*/ GIMT_Encode4(4971),
    /*GILLT_v16s8*//*Label 238*/ GIMT_Encode4(5005),
    // Label 233: @4527
    GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(4800),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(4580), // Rule ID 41 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (ANDi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ANDi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 41,
        GIR_EraseRootFromParent_Done,
      // Label 241: @4580
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(4622), // Rule ID 2161 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExtAndi16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ANDI16_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2161,
        GIR_EraseRootFromParent_Done,
      // Label 242: @4622
      GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(4664), // Rule ID 2320 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExtAndi16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ANDI16_MMR6),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2320,
        GIR_EraseRootFromParent_Done,
      // Label 243: @4664
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(4691), // Rule ID 51 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51,
        GIR_Done,
      // Label 244: @4691
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(4718), // Rule ID 1061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (and:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (AND16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND16_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1061,
        GIR_Done,
      // Label 245: @4718
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(4745), // Rule ID 1077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1077,
        GIR_Done,
      // Label 246: @4745
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(4772), // Rule ID 1170 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1170,
        GIR_Done,
      // Label 247: @4772
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(4799), // Rule ID 1819 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (and:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AndRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AndRxRxRy16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1819,
        GIR_Done,
      // Label 248: @4799
      GIM_Reject,
    // Label 240: @4800
    GIM_Reject,
    // Label 234: @4801
    GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(4902),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(4878), // Rule ID 269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), 255:{ *:[i64] })  =>  (BADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BADDu),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 269,
        GIR_EraseRootFromParent_Done,
      // Label 250: @4878
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(4901), // Rule ID 206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (AND64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 206,
        GIR_Done,
      // Label 251: @4901
      GIM_Reject,
    // Label 249: @4902
    GIM_Reject,
    // Label 235: @4903
    GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(4936), // Rule ID 518 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (and:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AND_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_D_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 518,
      GIR_Done,
    // Label 252: @4936
    GIM_Reject,
    // Label 236: @4937
    GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(4970), // Rule ID 517 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (and:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AND_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_W_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 517,
      GIR_Done,
    // Label 253: @4970
    GIM_Reject,
    // Label 237: @4971
    GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(5004), // Rule ID 516 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (and:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AND_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_H_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 516,
      GIR_Done,
    // Label 254: @5004
    GIM_Reject,
    // Label 238: @5005
    GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(5038), // Rule ID 515 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (and:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AND_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 515,
      GIR_Done,
    // Label 255: @5038
    GIM_Reject,
    // Label 239: @5039
    GIM_Reject,
    // Label 8: @5040
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 262*/ GIMT_Encode4(5443),
    /*GILLT_s32*//*Label 256*/ GIMT_Encode4(5083),
    /*GILLT_s64*//*Label 257*/ GIMT_Encode4(5273), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 258*/ GIMT_Encode4(5307), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 259*/ GIMT_Encode4(5341),
    /*GILLT_v8s16*//*Label 260*/ GIMT_Encode4(5375),
    /*GILLT_v16s8*//*Label 261*/ GIMT_Encode4(5409),
    // Label 256: @5083
    GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(5272),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(5136), // Rule ID 42 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (ORi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ORi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 42,
        GIR_EraseRootFromParent_Done,
      // Label 264: @5136
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(5163), // Rule ID 52 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52,
        GIR_Done,
      // Label 265: @5163
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(5190), // Rule ID 1063 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (or:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (OR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR16_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1063,
        GIR_Done,
      // Label 266: @5190
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(5217), // Rule ID 1078 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1078,
        GIR_Done,
      // Label 267: @5217
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(5244), // Rule ID 1183 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1183,
        GIR_Done,
      // Label 268: @5244
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(5271), // Rule ID 1821 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (or:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (OrRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OrRxRxRy16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1821,
        GIR_Done,
      // Label 269: @5271
      GIM_Reject,
    // Label 263: @5272
    GIM_Reject,
    // Label 257: @5273
    GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(5306), // Rule ID 207 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (OR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 207,
      GIR_Done,
    // Label 270: @5306
    GIM_Reject,
    // Label 258: @5307
    GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(5340), // Rule ID 924 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (or:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (OR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_D_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 924,
      GIR_Done,
    // Label 271: @5340
    GIM_Reject,
    // Label 259: @5341
    GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(5374), // Rule ID 923 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (or:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (OR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_W_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 923,
      GIR_Done,
    // Label 272: @5374
    GIM_Reject,
    // Label 260: @5375
    GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(5408), // Rule ID 922 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (or:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (OR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_H_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 922,
      GIR_Done,
    // Label 273: @5408
    GIM_Reject,
    // Label 261: @5409
    GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(5442), // Rule ID 921 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (or:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (OR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 921,
      GIR_Done,
    // Label 274: @5442
    GIM_Reject,
    // Label 262: @5443
    GIM_Reject,
    // Label 9: @5444
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 281*/ GIMT_Encode4(6335),
    /*GILLT_s32*//*Label 275*/ GIMT_Encode4(5487),
    /*GILLT_s64*//*Label 276*/ GIMT_Encode4(6104), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 277*/ GIMT_Encode4(6199), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 278*/ GIMT_Encode4(6233),
    /*GILLT_v8s16*//*Label 279*/ GIMT_Encode4(6267),
    /*GILLT_v16s8*//*Label 280*/ GIMT_Encode4(6301),
    // Label 275: @5487
    GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(6103),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(5557), // Rule ID 54 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54,
        GIR_EraseRootFromParent_Done,
      // Label 283: @5557
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(5616), // Rule ID 1080 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1080,
        GIR_EraseRootFromParent_Done,
      // Label 284: @5616
      GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(5675), // Rule ID 1182 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MMR6),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1182,
        GIR_EraseRootFromParent_Done,
      // Label 285: @5675
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(5704), // Rule ID 1209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MMR6),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1209,
        GIR_EraseRootFromParent_Done,
      // Label 286: @5704
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(5733), // Rule ID 1062 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1062,
        GIR_EraseRootFromParent_Done,
      // Label 287: @5733
      GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(5768), // Rule ID 1397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1397,
        GIR_EraseRootFromParent_Done,
      // Label 288: @5768
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(5797), // Rule ID 1816 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, -1:{ *:[i32] })  =>  (NotRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NotRxRy16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rx]
        GIR_RootToRootCopy, /*OpIdx*/1, // r
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1816,
        GIR_EraseRootFromParent_Done,
      // Label 289: @5797
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(5826), // Rule ID 2156 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2156,
        GIR_EraseRootFromParent_Done,
      // Label 290: @5826
      GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(5861), // Rule ID 2157 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2157,
        GIR_EraseRootFromParent_Done,
      // Label 291: @5861
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(5890), // Rule ID 2323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MMR6),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2323,
        GIR_EraseRootFromParent_Done,
      // Label 292: @5890
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(5925), // Rule ID 2324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MMR6),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2324,
        GIR_EraseRootFromParent_Done,
      // Label 293: @5925
      GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(5967), // Rule ID 43 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (XORi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::XORi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 43,
        GIR_EraseRootFromParent_Done,
      // Label 294: @5967
      GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(5994), // Rule ID 53 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53,
        GIR_Done,
      // Label 295: @5994
      GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(6021), // Rule ID 1065 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (XOR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR16_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1065,
        GIR_Done,
      // Label 296: @6021
      GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(6048), // Rule ID 1079 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1079,
        GIR_Done,
      // Label 297: @6048
      GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(6075), // Rule ID 1186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1186,
        GIR_Done,
      // Label 298: @6075
      GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(6102), // Rule ID 1823 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (XorRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XorRxRxRy16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1823,
        GIR_Done,
      // Label 299: @6102
      GIM_Reject,
    // Label 282: @6103
    GIM_Reject,
    // Label 276: @6104
    GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(6198),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(6174), // Rule ID 209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), -1:{ *:[i64] })  =>  (NOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 209,
        GIR_EraseRootFromParent_Done,
      // Label 301: @6174
      GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(6197), // Rule ID 208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (xor:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (XOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 208,
        GIR_Done,
      // Label 302: @6197
      GIM_Reject,
    // Label 300: @6198
    GIM_Reject,
    // Label 277: @6199
    GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(6232), // Rule ID 1040 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (xor:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (XOR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_D_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1040,
      GIR_Done,
    // Label 303: @6232
    GIM_Reject,
    // Label 278: @6233
    GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(6266), // Rule ID 1039 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (xor:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (XOR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_W_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1039,
      GIR_Done,
    // Label 304: @6266
    GIM_Reject,
    // Label 279: @6267
    GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(6300), // Rule ID 1038 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (xor:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (XOR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_H_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1038,
      GIR_Done,
    // Label 305: @6300
    GIM_Reject,
    // Label 280: @6301
    GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(6334), // Rule ID 1037 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (xor:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (XOR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1037,
      GIR_Done,
    // Label 306: @6334
    GIM_Reject,
    // Label 281: @6335
    GIM_Reject,
    // Label 10: @6336
    GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(6408),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(6380), // Rule ID 180 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotSoftFloat_NotFP64bit_NotInMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::AFGR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (MipsBuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)  =>  (BuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BuildPairF64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 308: @6380
      GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(6407), // Rule ID 181 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsFP64bit_IsNotSoftFloat_NotInMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (MipsBuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)  =>  (BuildPairF64_64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BuildPairF64_64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 181,
        GIR_Done,
      // Label 309: @6407
      GIM_Reject,
    // Label 307: @6408
    GIM_Reject,
    // Label 11: @6409
    GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(6480),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(6453), // Rule ID 719 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v2i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rs)  =>  (FILL_D:{ *:[v2i64] } GPR64Opnd:{ *:[i64] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 719,
        GIR_EraseRootFromParent_Done,
      // Label 311: @6453
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(6479), // Rule ID 721 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v2f64] } FGR64:{ *:[f64] }:$fs, FGR64:{ *:[f64] }:$fs)  =>  (FILL_FD_PSEUDO:{ *:[v2f64] } FGR64:{ *:[f64] }:$fs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_FD_PSEUDO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // fs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 721,
        GIR_EraseRootFromParent_Done,
      // Label 312: @6479
      GIM_Reject,
    // Label 310: @6480
    GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(6571),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(6534), // Rule ID 718 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_W:{ *:[v4i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 718,
        GIR_EraseRootFromParent_Done,
      // Label 314: @6534
      GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(6570), // Rule ID 720 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4f32] } FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs)  =>  (FILL_FW_PSEUDO:{ *:[v4f32] } FGR32:{ *:[f32] }:$fs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_FW_PSEUDO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // fs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 720,
        GIR_EraseRootFromParent_Done,
      // Label 315: @6570
      GIM_Reject,
    // Label 313: @6571
    GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(6640), // Rule ID 717 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/9,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // (build_vector:{ *:[v8i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_H:{ *:[v8i16] } GPR32Opnd:{ *:[i32] }:$rs)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_H),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
      GIR_RootToRootCopy, /*OpIdx*/1, // rs
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 717,
      GIR_EraseRootFromParent_Done,
    // Label 316: @6640
    GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(6749), // Rule ID 716 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/17,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/9, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/10, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/11, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/12, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/13, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/14, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/15, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/16, /*OtherMI*/0, /*OtherOpIdx*/1,
      // (build_vector:{ *:[v16i8] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_B:{ *:[v16i8] } GPR32Opnd:{ *:[i32] }:$rs)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_B),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
      GIR_RootToRootCopy, /*OpIdx*/1, // rs
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 716,
      GIR_EraseRootFromParent_Done,
    // Label 317: @6749
    GIM_Reject,
    // Label 12: @6750
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 326*/ GIMT_Encode4(11060),
    /*GILLT_s32*//*Label 318*/ GIMT_Encode4(6793),
    /*GILLT_s64*//*Label 319*/ GIMT_Encode4(7070),
    /*GILLT_v2s16*//*Label 320*/ GIMT_Encode4(7126),
    /*GILLT_v2s64*//*Label 321*/ GIMT_Encode4(7186),
    /*GILLT_v4s8*//*Label 322*/ GIMT_Encode4(8321),
    /*GILLT_v4s32*//*Label 323*/ GIMT_Encode4(8381),
    /*GILLT_v8s16*//*Label 324*/ GIMT_Encode4(9450),
    /*GILLT_v16s8*//*Label 325*/ GIMT_Encode4(10375),
    // Label 318: @6793
    GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(6819), // Rule ID 135 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 135,
      GIR_Done,
    // Label 327: @6819
    GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(6845), // Rule ID 136 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 136,
      GIR_Done,
    // Label 328: @6845
    GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(6871), // Rule ID 1160 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_IsNotSoftFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MM:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1_MM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1160,
      GIR_Done,
    // Label 329: @6871
    GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(6897), // Rule ID 1161 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_IsNotSoftFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MM:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1_MM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1161,
      GIR_Done,
    // Label 330: @6897
    GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(6923), // Rule ID 1175 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MMR6:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1_MMR6),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1175,
      GIR_Done,
    // Label 331: @6923
    GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(6949), // Rule ID 1176 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MMR6:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1_MMR6),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1176,
      GIR_Done,
    // Label 332: @6949
    GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(6979), // Rule ID 1904 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[i32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v2i16] }:$src, GPR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR32RegClassID),
      // GIR_Coverage, 1904,
      GIR_Done,
    // Label 333: @6979
    GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(7009), // Rule ID 1905 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[i32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v4i8] }:$src, GPR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR32RegClassID),
      // GIR_Coverage, 1905,
      GIR_Done,
    // Label 334: @7009
    GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(7039), // Rule ID 1908 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[f32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v2i16] }:$src, FGR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::FGR32RegClassID),
      // GIR_Coverage, 1908,
      GIR_Done,
    // Label 335: @7039
    GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(7069), // Rule ID 1909 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[f32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v4i8] }:$src, FGR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::FGR32RegClassID),
      // GIR_Coverage, 1909,
      GIR_Done,
    // Label 336: @7069
    GIM_Reject,
    // Label 319: @7070
    GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(7125),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(7101), // Rule ID 137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (bitconvert:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMTC1:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMTC1),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 338: @7101
      GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(7124), // Rule ID 138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        // (bitconvert:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)  =>  (DMFC1:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMFC1),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 138,
        GIR_Done,
      // Label 339: @7124
      GIM_Reject,
    // Label 337: @7125
    GIM_Reject,
    // Label 320: @7126
    GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(7185),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(7161), // Rule ID 1906 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (bitconvert:{ *:[v2i16] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1906,
        GIR_Done,
      // Label 341: @7161
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(7184), // Rule ID 1910 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
        // (bitconvert:{ *:[v2i16] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1910,
        GIR_Done,
      // Label 342: @7184
      GIM_Reject,
    // Label 340: @7185
    GIM_Reject,
    // Label 321: @7186
    GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(7212), // Rule ID 1991 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1991,
      GIR_Done,
    // Label 343: @7212
    GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(7238), // Rule ID 1994 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1994,
      GIR_Done,
    // Label 344: @7238
    GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(7264), // Rule ID 2011 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2011,
      GIR_Done,
    // Label 345: @7264
    GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(7290), // Rule ID 2012 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2012,
      GIR_Done,
    // Label 346: @7290
    GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(7316), // Rule ID 2013 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2013,
      GIR_Done,
    // Label 347: @7316
    GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(7342), // Rule ID 2014 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2014,
      GIR_Done,
    // Label 348: @7342
    GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(7368), // Rule ID 2015 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2015,
      GIR_Done,
    // Label 349: @7368
    GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(7394), // Rule ID 2021 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2021,
      GIR_Done,
    // Label 350: @7394
    GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(7420), // Rule ID 2022 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2022,
      GIR_Done,
    // Label 351: @7420
    GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(7446), // Rule ID 2023 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2023,
      GIR_Done,
    // Label 352: @7446
    GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(7472), // Rule ID 2024 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2024,
      GIR_Done,
    // Label 353: @7472
    GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(7498), // Rule ID 2025 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2025,
      GIR_Done,
    // Label 354: @7498
    GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(7615), // Rule ID 2030 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2030,
      GIR_EraseRootFromParent_Done,
    // Label 355: @7615
    GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(7732), // Rule ID 2031 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2031,
      GIR_EraseRootFromParent_Done,
    // Label 356: @7732
    GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(7802), // Rule ID 2035 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2035,
      GIR_EraseRootFromParent_Done,
    // Label 357: @7802
    GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(7872), // Rule ID 2036 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2036,
      GIR_EraseRootFromParent_Done,
    // Label 358: @7872
    GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(7942), // Rule ID 2040 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2040,
      GIR_EraseRootFromParent_Done,
    // Label 359: @7942
    GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(8012), // Rule ID 2041 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2041,
      GIR_EraseRootFromParent_Done,
    // Label 360: @8012
    GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(8089), // Rule ID 2045 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2045,
      GIR_EraseRootFromParent_Done,
    // Label 361: @8089
    GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(8166), // Rule ID 2046 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2046,
      GIR_EraseRootFromParent_Done,
    // Label 362: @8166
    GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(8243), // Rule ID 2050 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2050,
      GIR_EraseRootFromParent_Done,
    // Label 363: @8243
    GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(8320), // Rule ID 2051 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2051,
      GIR_EraseRootFromParent_Done,
    // Label 364: @8320
    GIM_Reject,
    // Label 322: @8321
    GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(8380),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(8356), // Rule ID 1907 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (bitconvert:{ *:[v4i8] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1907,
        GIR_Done,
      // Label 366: @8356
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(8379), // Rule ID 1911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
        // (bitconvert:{ *:[v4i8] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1911,
        GIR_Done,
      // Label 367: @8379
      GIM_Reject,
    // Label 365: @8380
    GIM_Reject,
    // Label 323: @8381
    GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(8407), // Rule ID 1990 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1990,
      GIR_Done,
    // Label 368: @8407
    GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(8433), // Rule ID 1993 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1993,
      GIR_Done,
    // Label 369: @8433
    GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(8459), // Rule ID 2006 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2006,
      GIR_Done,
    // Label 370: @8459
    GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(8485), // Rule ID 2007 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2007,
      GIR_Done,
    // Label 371: @8485
    GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(8511), // Rule ID 2008 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2008,
      GIR_Done,
    // Label 372: @8511
    GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(8537), // Rule ID 2009 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2009,
      GIR_Done,
    // Label 373: @8537
    GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(8563), // Rule ID 2010 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2010,
      GIR_Done,
    // Label 374: @8563
    GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(8589), // Rule ID 2016 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2016,
      GIR_Done,
    // Label 375: @8589
    GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(8615), // Rule ID 2017 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2017,
      GIR_Done,
    // Label 376: @8615
    GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(8641), // Rule ID 2018 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2018,
      GIR_Done,
    // Label 377: @8641
    GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(8667), // Rule ID 2019 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2019,
      GIR_Done,
    // Label 378: @8667
    GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(8693), // Rule ID 2020 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2020,
      GIR_Done,
    // Label 379: @8693
    GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(8763), // Rule ID 2028 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2028,
      GIR_EraseRootFromParent_Done,
    // Label 380: @8763
    GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(8833), // Rule ID 2029 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2029,
      GIR_EraseRootFromParent_Done,
    // Label 381: @8833
    GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(8910), // Rule ID 2033 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2033,
      GIR_EraseRootFromParent_Done,
    // Label 382: @8910
    GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(8987), // Rule ID 2034 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2034,
      GIR_EraseRootFromParent_Done,
    // Label 383: @8987
    GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(9064), // Rule ID 2038 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2038,
      GIR_EraseRootFromParent_Done,
    // Label 384: @9064
    GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(9141), // Rule ID 2039 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2039,
      GIR_EraseRootFromParent_Done,
    // Label 385: @9141
    GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(9218), // Rule ID 2055 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2055,
      GIR_EraseRootFromParent_Done,
    // Label 386: @9218
    GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(9295), // Rule ID 2056 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2056,
      GIR_EraseRootFromParent_Done,
    // Label 387: @9295
    GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(9372), // Rule ID 2060 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2060,
      GIR_EraseRootFromParent_Done,
    // Label 388: @9372
    GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(9449), // Rule ID 2061 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2061,
      GIR_EraseRootFromParent_Done,
    // Label 389: @9449
    GIM_Reject,
    // Label 324: @9450
    GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(9476), // Rule ID 1989 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1989,
      GIR_Done,
    // Label 390: @9476
    GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(9502), // Rule ID 1992 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1992,
      GIR_Done,
    // Label 391: @9502
    GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(9528), // Rule ID 2001 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2001,
      GIR_Done,
    // Label 392: @9528
    GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(9554), // Rule ID 2002 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2002,
      GIR_Done,
    // Label 393: @9554
    GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(9580), // Rule ID 2003 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2003,
      GIR_Done,
    // Label 394: @9580
    GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(9606), // Rule ID 2004 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2004,
      GIR_Done,
    // Label 395: @9606
    GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(9632), // Rule ID 2005 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2005,
      GIR_Done,
    // Label 396: @9632
    GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(9709), // Rule ID 2026 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2026,
      GIR_EraseRootFromParent_Done,
    // Label 397: @9709
    GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(9786), // Rule ID 2027 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2027,
      GIR_EraseRootFromParent_Done,
    // Label 398: @9786
    GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(9863), // Rule ID 2043 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2043,
      GIR_EraseRootFromParent_Done,
    // Label 399: @9863
    GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(9940), // Rule ID 2044 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2044,
      GIR_EraseRootFromParent_Done,
    // Label 400: @9940
    GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(10017), // Rule ID 2048 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2048,
      GIR_EraseRootFromParent_Done,
    // Label 401: @10017
    GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(10094), // Rule ID 2049 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2049,
      GIR_EraseRootFromParent_Done,
    // Label 402: @10094
    GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(10164), // Rule ID 2053 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2053,
      GIR_EraseRootFromParent_Done,
    // Label 403: @10164
    GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(10234), // Rule ID 2054 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2054,
      GIR_EraseRootFromParent_Done,
    // Label 404: @10234
    GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(10304), // Rule ID 2058 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2058,
      GIR_EraseRootFromParent_Done,
    // Label 405: @10304
    GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(10374), // Rule ID 2059 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2059,
      GIR_EraseRootFromParent_Done,
    // Label 406: @10374
    GIM_Reject,
    // Label 325: @10375
    GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(10401), // Rule ID 1995 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1995,
      GIR_Done,
    // Label 407: @10401
    GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(10427), // Rule ID 1996 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1996,
      GIR_Done,
    // Label 408: @10427
    GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(10453), // Rule ID 1997 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1997,
      GIR_Done,
    // Label 409: @10453
    GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(10479), // Rule ID 1998 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1998,
      GIR_Done,
    // Label 410: @10479
    GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(10505), // Rule ID 1999 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1999,
      GIR_Done,
    // Label 411: @10505
    GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(10531), // Rule ID 2000 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2000,
      GIR_Done,
    // Label 412: @10531
    GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(10608), // Rule ID 2032 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2032,
      GIR_EraseRootFromParent_Done,
    // Label 413: @10608
    GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(10685), // Rule ID 2037 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2037,
      GIR_EraseRootFromParent_Done,
    // Label 414: @10685
    GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(10755), // Rule ID 2042 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2042,
      GIR_EraseRootFromParent_Done,
    // Label 415: @10755
    GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(10825), // Rule ID 2047 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2047,
      GIR_EraseRootFromParent_Done,
    // Label 416: @10825
    GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(10942), // Rule ID 2052 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2052,
      GIR_EraseRootFromParent_Done,
    // Label 417: @10942
    GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(11059), // Rule ID 2057 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2057,
      GIR_EraseRootFromParent_Done,
    // Label 418: @11059
    GIM_Reject,
    // Label 326: @11060
    GIM_Reject,
    // Label 13: @11061
    GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(11125), // Rule ID 1980 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LWX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LWX),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1980,
      GIR_EraseRootFromParent_Done,
    // Label 419: @11125
    GIM_Reject,
    // Label 14: @11126
    GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(11193), // Rule ID 1979 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LHX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LHX),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1979,
      GIR_EraseRootFromParent_Done,
    // Label 420: @11193
    GIM_Reject,
    // Label 15: @11194
    GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(11261), // Rule ID 1978 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi8>>  =>  (LBUX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LBUX),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1978,
      GIR_EraseRootFromParent_Done,
    // Label 421: @11261
    GIM_Reject,
    // Label 16: @11262
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 424*/ GIMT_Encode4(11453),
    /*GILLT_s32*//*Label 422*/ GIMT_Encode4(11281),
    /*GILLT_s64*//*Label 423*/ GIMT_Encode4(11408),
    // Label 422: @11281
    GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(11407),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(11330), // Rule ID 25 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_cmp_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)<<P:Predicate_atomic_cmp_swap_i8>>  =>  (ATOMIC_CMP_SWAP_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_CMP_SWAP_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25,
        GIR_Done,
      // Label 426: @11330
      GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(11368), // Rule ID 26 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_cmp_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)<<P:Predicate_atomic_cmp_swap_i16>>  =>  (ATOMIC_CMP_SWAP_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_CMP_SWAP_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 26,
        GIR_Done,
      // Label 427: @11368
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(11406), // Rule ID 27 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_cmp_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)<<P:Predicate_atomic_cmp_swap_i32>>  =>  (ATOMIC_CMP_SWAP_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_CMP_SWAP_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 27,
        GIR_Done,
      // Label 428: @11406
      GIM_Reject,
    // Label 425: @11407
    GIM_Reject,
    // Label 423: @11408
    GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(11452), // Rule ID 191 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_cmp_swap:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$cmp, GPR64:{ *:[i64] }:$swap)<<P:Predicate_atomic_cmp_swap_i64>>  =>  (ATOMIC_CMP_SWAP_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$cmp, GPR64:{ *:[i64] }:$swap)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_CMP_SWAP_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 191,
      GIR_Done,
    // Label 429: @11452
    GIM_Reject,
    // Label 424: @11453
    GIM_Reject,
    // Label 17: @11454
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 432*/ GIMT_Encode4(11623),
    /*GILLT_s32*//*Label 430*/ GIMT_Encode4(11473),
    /*GILLT_s64*//*Label 431*/ GIMT_Encode4(11585),
    // Label 430: @11473
    GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(11584),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(11515), // Rule ID 22 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_swap_i8>>  =>  (ATOMIC_SWAP_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_SWAP_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22,
        GIR_Done,
      // Label 434: @11515
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(11549), // Rule ID 23 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_swap_i16>>  =>  (ATOMIC_SWAP_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_SWAP_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23,
        GIR_Done,
      // Label 435: @11549
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(11583), // Rule ID 24 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_swap_i32>>  =>  (ATOMIC_SWAP_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_SWAP_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24,
        GIR_Done,
      // Label 436: @11583
      GIM_Reject,
    // Label 433: @11584
    GIM_Reject,
    // Label 431: @11585
    GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(11622), // Rule ID 190 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_swap:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_swap_i64>>  =>  (ATOMIC_SWAP_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_SWAP_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 190,
      GIR_Done,
    // Label 437: @11622
    GIM_Reject,
    // Label 432: @11623
    GIM_Reject,
    // Label 18: @11624
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 440*/ GIMT_Encode4(11793),
    /*GILLT_s32*//*Label 438*/ GIMT_Encode4(11643),
    /*GILLT_s64*//*Label 439*/ GIMT_Encode4(11755),
    // Label 438: @11643
    GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(11754),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(11685), // Rule ID 4 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_add:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_add_i8>>  =>  (ATOMIC_LOAD_ADD_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_ADD_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4,
        GIR_Done,
      // Label 442: @11685
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(11719), // Rule ID 5 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_add:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_add_i16>>  =>  (ATOMIC_LOAD_ADD_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_ADD_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5,
        GIR_Done,
      // Label 443: @11719
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(11753), // Rule ID 6 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_add:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_add_i32>>  =>  (ATOMIC_LOAD_ADD_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_ADD_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 6,
        GIR_Done,
      // Label 444: @11753
      GIM_Reject,
    // Label 441: @11754
    GIM_Reject,
    // Label 439: @11755
    GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(11792), // Rule ID 184 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_load_add:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_add_i64>>  =>  (ATOMIC_LOAD_ADD_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_ADD_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 184,
      GIR_Done,
    // Label 445: @11792
    GIM_Reject,
    // Label 440: @11793
    GIM_Reject,
    // Label 19: @11794
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 448*/ GIMT_Encode4(11963),
    /*GILLT_s32*//*Label 446*/ GIMT_Encode4(11813),
    /*GILLT_s64*//*Label 447*/ GIMT_Encode4(11925),
    // Label 446: @11813
    GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(11924),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(11855), // Rule ID 7 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_sub:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_i8>>  =>  (ATOMIC_LOAD_SUB_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_SUB_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7,
        GIR_Done,
      // Label 450: @11855
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(11889), // Rule ID 8 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_sub:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_i16>>  =>  (ATOMIC_LOAD_SUB_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_SUB_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8,
        GIR_Done,
      // Label 451: @11889
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(11923), // Rule ID 9 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_sub:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_i32>>  =>  (ATOMIC_LOAD_SUB_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_SUB_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9,
        GIR_Done,
      // Label 452: @11923
      GIM_Reject,
    // Label 449: @11924
    GIM_Reject,
    // Label 447: @11925
    GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(11962), // Rule ID 185 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_load_sub:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_i64>>  =>  (ATOMIC_LOAD_SUB_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_SUB_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 185,
      GIR_Done,
    // Label 453: @11962
    GIM_Reject,
    // Label 448: @11963
    GIM_Reject,
    // Label 20: @11964
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 456*/ GIMT_Encode4(12133),
    /*GILLT_s32*//*Label 454*/ GIMT_Encode4(11983),
    /*GILLT_s64*//*Label 455*/ GIMT_Encode4(12095),
    // Label 454: @11983
    GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(12094),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(12025), // Rule ID 10 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_and:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_and_i8>>  =>  (ATOMIC_LOAD_AND_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_AND_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10,
        GIR_Done,
      // Label 458: @12025
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(12059), // Rule ID 11 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_and:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_and_i16>>  =>  (ATOMIC_LOAD_AND_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_AND_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 11,
        GIR_Done,
      // Label 459: @12059
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(12093), // Rule ID 12 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_and:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_and_i32>>  =>  (ATOMIC_LOAD_AND_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_AND_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12,
        GIR_Done,
      // Label 460: @12093
      GIM_Reject,
    // Label 457: @12094
    GIM_Reject,
    // Label 455: @12095
    GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(12132), // Rule ID 186 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_load_and:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_and_i64>>  =>  (ATOMIC_LOAD_AND_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_AND_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 186,
      GIR_Done,
    // Label 461: @12132
    GIM_Reject,
    // Label 456: @12133
    GIM_Reject,
    // Label 21: @12134
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 464*/ GIMT_Encode4(12303),
    /*GILLT_s32*//*Label 462*/ GIMT_Encode4(12153),
    /*GILLT_s64*//*Label 463*/ GIMT_Encode4(12265),
    // Label 462: @12153
    GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(12264),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(12195), // Rule ID 19 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_nand:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_i8>>  =>  (ATOMIC_LOAD_NAND_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_NAND_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 19,
        GIR_Done,
      // Label 466: @12195
      GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(12229), // Rule ID 20 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_nand:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_i16>>  =>  (ATOMIC_LOAD_NAND_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_NAND_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20,
        GIR_Done,
      // Label 467: @12229
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(12263), // Rule ID 21 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_nand:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_i32>>  =>  (ATOMIC_LOAD_NAND_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_NAND_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21,
        GIR_Done,
      // Label 468: @12263
      GIM_Reject,
    // Label 465: @12264
    GIM_Reject,
    // Label 463: @12265
    GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(12302), // Rule ID 189 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_load_nand:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_i64>>  =>  (ATOMIC_LOAD_NAND_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_NAND_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 189,
      GIR_Done,
    // Label 469: @12302
    GIM_Reject,
    // Label 464: @12303
    GIM_Reject,
    // Label 22: @12304
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 472*/ GIMT_Encode4(12473),
    /*GILLT_s32*//*Label 470*/ GIMT_Encode4(12323),
    /*GILLT_s64*//*Label 471*/ GIMT_Encode4(12435),
    // Label 470: @12323
    GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(12434),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(12365), // Rule ID 13 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_or:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_or_i8>>  =>  (ATOMIC_LOAD_OR_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_OR_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13,
        GIR_Done,
      // Label 474: @12365
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(12399), // Rule ID 14 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_or:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_or_i16>>  =>  (ATOMIC_LOAD_OR_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_OR_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14,
        GIR_Done,
      // Label 475: @12399
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(12433), // Rule ID 15 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_or:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_or_i32>>  =>  (ATOMIC_LOAD_OR_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_OR_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15,
        GIR_Done,
      // Label 476: @12433
      GIM_Reject,
    // Label 473: @12434
    GIM_Reject,
    // Label 471: @12435
    GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(12472), // Rule ID 187 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_load_or:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_or_i64>>  =>  (ATOMIC_LOAD_OR_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_OR_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 187,
      GIR_Done,
    // Label 477: @12472
    GIM_Reject,
    // Label 472: @12473
    GIM_Reject,
    // Label 23: @12474
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 480*/ GIMT_Encode4(12643),
    /*GILLT_s32*//*Label 478*/ GIMT_Encode4(12493),
    /*GILLT_s64*//*Label 479*/ GIMT_Encode4(12605),
    // Label 478: @12493
    GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(12604),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(12535), // Rule ID 16 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_xor:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_xor_i8>>  =>  (ATOMIC_LOAD_XOR_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_XOR_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16,
        GIR_Done,
      // Label 482: @12535
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(12569), // Rule ID 17 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_xor:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_xor_i16>>  =>  (ATOMIC_LOAD_XOR_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_XOR_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17,
        GIR_Done,
      // Label 483: @12569
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(12603), // Rule ID 18 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_xor:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_xor_i32>>  =>  (ATOMIC_LOAD_XOR_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_XOR_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18,
        GIR_Done,
      // Label 484: @12603
      GIM_Reject,
    // Label 481: @12604
    GIM_Reject,
    // Label 479: @12605
    GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(12642), // Rule ID 188 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_load_xor:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_xor_i64>>  =>  (ATOMIC_LOAD_XOR_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_XOR_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 188,
      GIR_Done,
    // Label 485: @12642
    GIM_Reject,
    // Label 480: @12643
    GIM_Reject,
    // Label 24: @12644
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 488*/ GIMT_Encode4(12813),
    /*GILLT_s32*//*Label 486*/ GIMT_Encode4(12663),
    /*GILLT_s64*//*Label 487*/ GIMT_Encode4(12775),
    // Label 486: @12663
    GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(12774),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(12705), // Rule ID 31 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_max:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_max_i8>>  =>  (ATOMIC_LOAD_MAX_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MAX_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 31,
        GIR_Done,
      // Label 490: @12705
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(12739), // Rule ID 32 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_max:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_max_i16>>  =>  (ATOMIC_LOAD_MAX_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MAX_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 32,
        GIR_Done,
      // Label 491: @12739
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(12773), // Rule ID 33 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_max:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_max_i32>>  =>  (ATOMIC_LOAD_MAX_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MAX_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 33,
        GIR_Done,
      // Label 492: @12773
      GIM_Reject,
    // Label 489: @12774
    GIM_Reject,
    // Label 487: @12775
    GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(12812), // Rule ID 193 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_load_max:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_max_i64>>  =>  (ATOMIC_LOAD_MAX_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MAX_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 193,
      GIR_Done,
    // Label 493: @12812
    GIM_Reject,
    // Label 488: @12813
    GIM_Reject,
    // Label 25: @12814
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 496*/ GIMT_Encode4(12983),
    /*GILLT_s32*//*Label 494*/ GIMT_Encode4(12833),
    /*GILLT_s64*//*Label 495*/ GIMT_Encode4(12945),
    // Label 494: @12833
    GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(12944),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(12875), // Rule ID 28 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_min:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_min_i8>>  =>  (ATOMIC_LOAD_MIN_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MIN_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 28,
        GIR_Done,
      // Label 498: @12875
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(12909), // Rule ID 29 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_min:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_min_i16>>  =>  (ATOMIC_LOAD_MIN_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MIN_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 29,
        GIR_Done,
      // Label 499: @12909
      GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(12943), // Rule ID 30 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_min:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_min_i32>>  =>  (ATOMIC_LOAD_MIN_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MIN_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 30,
        GIR_Done,
      // Label 500: @12943
      GIM_Reject,
    // Label 497: @12944
    GIM_Reject,
    // Label 495: @12945
    GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(12982), // Rule ID 192 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_load_min:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_min_i64>>  =>  (ATOMIC_LOAD_MIN_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MIN_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 192,
      GIR_Done,
    // Label 501: @12982
    GIM_Reject,
    // Label 496: @12983
    GIM_Reject,
    // Label 26: @12984
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 504*/ GIMT_Encode4(13153),
    /*GILLT_s32*//*Label 502*/ GIMT_Encode4(13003),
    /*GILLT_s64*//*Label 503*/ GIMT_Encode4(13115),
    // Label 502: @13003
    GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(13114),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(13045), // Rule ID 37 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_umax:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umax_i8>>  =>  (ATOMIC_LOAD_UMAX_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMAX_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 37,
        GIR_Done,
      // Label 506: @13045
      GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(13079), // Rule ID 38 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_umax:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umax_i16>>  =>  (ATOMIC_LOAD_UMAX_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMAX_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 38,
        GIR_Done,
      // Label 507: @13079
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(13113), // Rule ID 39 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_umax:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umax_i32>>  =>  (ATOMIC_LOAD_UMAX_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMAX_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 39,
        GIR_Done,
      // Label 508: @13113
      GIM_Reject,
    // Label 505: @13114
    GIM_Reject,
    // Label 503: @13115
    GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(13152), // Rule ID 195 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_load_umax:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_umax_i64>>  =>  (ATOMIC_LOAD_UMAX_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMAX_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 195,
      GIR_Done,
    // Label 509: @13152
    GIM_Reject,
    // Label 504: @13153
    GIM_Reject,
    // Label 27: @13154
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 512*/ GIMT_Encode4(13323),
    /*GILLT_s32*//*Label 510*/ GIMT_Encode4(13173),
    /*GILLT_s64*//*Label 511*/ GIMT_Encode4(13285),
    // Label 510: @13173
    GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(13284),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(13215), // Rule ID 34 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_umin:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umin_i8>>  =>  (ATOMIC_LOAD_UMIN_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMIN_I8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 34,
        GIR_Done,
      // Label 514: @13215
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(13249), // Rule ID 35 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_umin:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umin_i16>>  =>  (ATOMIC_LOAD_UMIN_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMIN_I16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 35,
        GIR_Done,
      // Label 515: @13249
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(13283), // Rule ID 36 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (atomic_load_umin:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umin_i32>>  =>  (ATOMIC_LOAD_UMIN_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMIN_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 36,
        GIR_Done,
      // Label 516: @13283
      GIM_Reject,
    // Label 513: @13284
    GIM_Reject,
    // Label 511: @13285
    GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(13322), // Rule ID 194 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (atomic_load_umin:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_umin_i64>>  =>  (ATOMIC_LOAD_UMIN_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMIN_I64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 194,
      GIR_Done,
    // Label 517: @13322
    GIM_Reject,
    // Label 512: @13323
    GIM_Reject,
    // Label 28: @13324
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 520*/ GIMT_Encode4(18044),
    /*GILLT_s32*//*Label 518*/ GIMT_Encode4(13343),
    /*GILLT_s64*//*Label 519*/ GIMT_Encode4(18010),
    // Label 518: @13343
    GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(13451), // Rule ID 2354 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT0 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT0),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2354,
      GIR_EraseRootFromParent_Done,
    // Label 521: @13451
    GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(13566), // Rule ID 2355 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT032 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT032),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2355,
      GIR_EraseRootFromParent_Done,
    // Label 522: @13566
    GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(13674), // Rule ID 2356 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT1 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT1),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2356,
      GIR_EraseRootFromParent_Done,
    // Label 523: @13674
    GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(13789), // Rule ID 2357 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT132 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT132),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2357,
      GIR_EraseRootFromParent_Done,
    // Label 524: @13789
    GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(13897), // Rule ID 270 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT0 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT0),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 270,
      GIR_EraseRootFromParent_Done,
    // Label 525: @13897
    GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(14012), // Rule ID 271 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT032 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT032),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 271,
      GIR_EraseRootFromParent_Done,
    // Label 526: @14012
    GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(14120), // Rule ID 272 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT1 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT1),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 272,
      GIR_EraseRootFromParent_Done,
    // Label 527: @14120
    GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(14235), // Rule ID 273 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT132 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT132),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 273,
      GIR_EraseRootFromParent_Done,
    // Label 528: @14235
    GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(14292), // Rule ID 94 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGEZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 94,
      GIR_EraseRootFromParent_Done,
    // Label 529: @14292
    GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(14349), // Rule ID 95 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGTZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGTZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 95,
      GIR_EraseRootFromParent_Done,
    // Label 530: @14349
    GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(14406), // Rule ID 96 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLEZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 96,
      GIR_EraseRootFromParent_Done,
    // Label 531: @14406
    GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(14463), // Rule ID 97 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLTZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLTZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 97,
      GIR_EraseRootFromParent_Done,
    // Label 532: @14463
    GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(14520), // Rule ID 245 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGEZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 245,
      GIR_EraseRootFromParent_Done,
    // Label 533: @14520
    GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(14577), // Rule ID 246 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGTZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGTZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 246,
      GIR_EraseRootFromParent_Done,
    // Label 534: @14577
    GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(14634), // Rule ID 247 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLEZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 247,
      GIR_EraseRootFromParent_Done,
    // Label 535: @14634
    GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(14691), // Rule ID 248 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLTZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLTZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 248,
      GIR_EraseRootFromParent_Done,
    // Label 536: @14691
    GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(14748), // Rule ID 1109 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGEZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1109,
      GIR_EraseRootFromParent_Done,
    // Label 537: @14748
    GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(14805), // Rule ID 1110 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGTZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGTZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1110,
      GIR_EraseRootFromParent_Done,
    // Label 538: @14805
    GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(14862), // Rule ID 1111 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLEZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1111,
      GIR_EraseRootFromParent_Done,
    // Label 539: @14862
    GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(14919), // Rule ID 1112 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLTZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLTZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1112,
      GIR_EraseRootFromParent_Done,
    // Label 540: @14919
    GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(14982), // Rule ID 1402 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNE GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1402,
      GIR_EraseRootFromParent_Done,
    // Label 541: @14982
    GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(15045), // Rule ID 1403 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1403,
      GIR_EraseRootFromParent_Done,
    // Label 542: @15045
    GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(15108), // Rule ID 1546 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNE64 GPR64:{ *:[i64] }:$lhs, ZERO_64:{ *:[i64] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO_64), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1546,
      GIR_EraseRootFromParent_Done,
    // Label 543: @15108
    GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(15171), // Rule ID 1547 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ64 GPR64:{ *:[i64] }:$lhs, ZERO_64:{ *:[i64] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO_64), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1547,
      GIR_EraseRootFromParent_Done,
    // Label 544: @15171
    GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(15225), // Rule ID 1847 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] targ16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$targ16)  =>  (BeqzRxImm16 CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BeqzRxImm16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_RootToRootCopy, /*OpIdx*/1, // targ16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1847,
      GIR_EraseRootFromParent_Done,
    // Label 545: @15225
    GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(15279), // Rule ID 1856 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] targ16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$targ16)  =>  (BnezRxImm16 CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BnezRxImm16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_RootToRootCopy, /*OpIdx*/1, // targ16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1856,
      GIR_EraseRootFromParent_Done,
    // Label 546: @15279
    GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(15342), // Rule ID 2184 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNE_MM GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2184,
      GIR_EraseRootFromParent_Done,
    // Label 547: @15342
    GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(15405), // Rule ID 2185 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2185,
      GIR_EraseRootFromParent_Done,
    // Label 548: @15405
    GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(15462), // Rule ID 2331 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNEZC_MMR6 GPR32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNEZC_MMR6),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2331,
      GIR_EraseRootFromParent_Done,
    // Label 549: @15462
    GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(15519), // Rule ID 2332 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 GPR32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2332,
      GIR_EraseRootFromParent_Done,
    // Label 550: @15519
    GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(15571), // Rule ID 1413 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 1,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, 1:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BLEZ i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1413,
      GIR_EraseRootFromParent_Done,
    // Label 551: @15571
    GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(15623), // Rule ID 1414 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, uint8_t(-1),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, -1:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BGEZ i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1414,
      GIR_EraseRootFromParent_Done,
    // Label 552: @15623
    GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(15675), // Rule ID 1557 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 1,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i64:{ *:[i64] }:$lhs, 1:{ *:[i64] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BLEZ64 i64:{ *:[i64] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1557,
      GIR_EraseRootFromParent_Done,
    // Label 553: @15675
    GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(15727), // Rule ID 1558 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, uint8_t(-1),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i64:{ *:[i64] }:$lhs, -1:{ *:[i64] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BGEZ64 i64:{ *:[i64] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1558,
      GIR_EraseRootFromParent_Done,
    // Label 554: @15727
    GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(15779), // Rule ID 2195 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 1,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, 1:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BLEZ_MM i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2195,
      GIR_EraseRootFromParent_Done,
    // Label 555: @15779
    GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(15831), // Rule ID 2196 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, uint8_t(-1),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, -1:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BGEZ_MM i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2196,
      GIR_EraseRootFromParent_Done,
    // Label 556: @15831
    GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(15893), // Rule ID 92 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BEQ GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 92,
      GIR_EraseRootFromParent_Done,
    // Label 557: @15893
    GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(15955), // Rule ID 93 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BNE GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 93,
      GIR_EraseRootFromParent_Done,
    // Label 558: @15955
    GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(16017), // Rule ID 243 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BEQ64 GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 243,
      GIR_EraseRootFromParent_Done,
    // Label 559: @16017
    GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(16079), // Rule ID 244 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BNE64 GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 244,
      GIR_EraseRootFromParent_Done,
    // Label 560: @16079
    GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(16141), // Rule ID 1107 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BEQ_MM GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1107,
      GIR_EraseRootFromParent_Done,
    // Label 561: @16141
    GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(16203), // Rule ID 1108 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BNE_MM GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1108,
      GIR_EraseRootFromParent_Done,
    // Label 562: @16203
    GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(16288), // Rule ID 1404 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1404,
      GIR_EraseRootFromParent_Done,
    // Label 563: @16288
    GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(16373), // Rule ID 1405 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1405,
      GIR_EraseRootFromParent_Done,
    // Label 564: @16373
    GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(16458), // Rule ID 1410 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1410,
      GIR_EraseRootFromParent_Done,
    // Label 565: @16458
    GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(16543), // Rule ID 1411 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1411,
      GIR_EraseRootFromParent_Done,
    // Label 566: @16543
    GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(16628), // Rule ID 1548 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT64:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT64),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1548,
      GIR_EraseRootFromParent_Done,
    // Label 567: @16628
    GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(16713), // Rule ID 1549 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu64:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu64),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1549,
      GIR_EraseRootFromParent_Done,
    // Label 568: @16713
    GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(16798), // Rule ID 1554 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT64:{ *:[i32] } GPR64:{ *:[i64] }:$rhs, GPR64:{ *:[i64] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT64),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1554,
      GIR_EraseRootFromParent_Done,
    // Label 569: @16798
    GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(16883), // Rule ID 1555 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu64:{ *:[i32] } GPR64:{ *:[i64] }:$rhs, GPR64:{ *:[i64] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu64),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1555,
      GIR_EraseRootFromParent_Done,
    // Label 570: @16883
    GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(16942), // Rule ID 1845 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BteqzT8CmpX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BteqzT8CmpX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1845,
      GIR_EraseRootFromParent_Done,
    // Label 571: @16942
    GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(17001), // Rule ID 1848 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BtnezT8SltX16 CPU16Regs:{ *:[i32] }:$ry, CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BtnezT8SltX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1848,
      GIR_EraseRootFromParent_Done,
    // Label 572: @17001
    GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(17060), // Rule ID 1849 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BteqzT8SltX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BteqzT8SltX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1849,
      GIR_EraseRootFromParent_Done,
    // Label 573: @17060
    GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(17119), // Rule ID 1851 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BtnezT8SltX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BtnezT8SltX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1851,
      GIR_EraseRootFromParent_Done,
    // Label 574: @17119
    GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(17178), // Rule ID 1853 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BteqzT8SltX16 CPU16Regs:{ *:[i32] }:$ry, CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BteqzT8SltX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1853,
      GIR_EraseRootFromParent_Done,
    // Label 575: @17178
    GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(17237), // Rule ID 1854 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BtnezT8CmpX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BtnezT8CmpX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1854,
      GIR_EraseRootFromParent_Done,
    // Label 576: @17237
    GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(17322), // Rule ID 2186 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2186,
      GIR_EraseRootFromParent_Done,
    // Label 577: @17322
    GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(17407), // Rule ID 2187 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2187,
      GIR_EraseRootFromParent_Done,
    // Label 578: @17407
    GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(17492), // Rule ID 2192 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2192,
      GIR_EraseRootFromParent_Done,
    // Label 579: @17492
    GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(17577), // Rule ID 2193 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2193,
      GIR_EraseRootFromParent_Done,
    // Label 580: @17577
    GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(17656), // Rule ID 2333 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2333,
      GIR_EraseRootFromParent_Done,
    // Label 581: @17656
    GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(17735), // Rule ID 2334 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2334,
      GIR_EraseRootFromParent_Done,
    // Label 582: @17735
    GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(17814), // Rule ID 2339 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2339,
      GIR_EraseRootFromParent_Done,
    // Label 583: @17814
    GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(17893), // Rule ID 2340 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2340,
      GIR_EraseRootFromParent_Done,
    // Label 584: @17893
    GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(17926), // Rule ID 1412 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      // (brcond GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNE GPR32:{ *:[i32] }:$cond, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE),
      GIR_RootToRootCopy, /*OpIdx*/0, // cond
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1412,
      GIR_EraseRootFromParent_Done,
    // Label 585: @17926
    GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(17948), // Rule ID 1857 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] targ16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      // (brcond CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)  =>  (BnezRxImm16 CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BnezRxImm16),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1857,
      GIR_Done,
    // Label 586: @17948
    GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(17981), // Rule ID 2194 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      // (brcond GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNE_MM GPR32:{ *:[i32] }:$cond, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE_MM),
      GIR_RootToRootCopy, /*OpIdx*/0, // cond
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2194,
      GIR_EraseRootFromParent_Done,
    // Label 587: @17981
    GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(18009), // Rule ID 2341 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      // (brcond GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNEZC_MMR6 GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BNEZC_MMR6),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::AT), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2341,
      GIR_Done,
    // Label 588: @18009
    GIM_Reject,
    // Label 519: @18010
    GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(18043), // Rule ID 1556 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      // (brcond GPR64:{ *:[i64] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNE64 GPR64:{ *:[i64] }:$cond, ZERO_64:{ *:[i64] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE64),
      GIR_RootToRootCopy, /*OpIdx*/0, // cond
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO_64), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1556,
      GIR_EraseRootFromParent_Done,
    // Label 589: @18043
    GIM_Reject,
    // Label 520: @18044
    GIM_Reject,
    // Label 29: @18045
    GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(20042),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(18100), // Rule ID 428 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt8),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7987:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 428,
        GIR_EraseRootFromParent_Done,
      // Label 591: @18100
      GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(18147), // Rule ID 429 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExt10),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7986:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 429,
        GIR_EraseRootFromParent_Done,
      // Label 592: @18147
      GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(18194), // Rule ID 1288 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExt10),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7986:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH_MM:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1288,
        GIR_EraseRootFromParent_Done,
      // Label 593: @18194
      GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(18241), // Rule ID 1289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt8),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7987:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB_MM:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1289,
        GIR_EraseRootFromParent_Done,
      // Label 594: @18241
      GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(18277), // Rule ID 362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_raddu_w_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7984:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::RADDU_W_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 362,
        GIR_EraseRootFromParent_Done,
      // Label 595: @18277
      GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(18313), // Rule ID 369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7966:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 369,
        GIR_EraseRootFromParent_Done,
      // Label 596: @18313
      GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(18349), // Rule ID 370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7967:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 370,
        GIR_EraseRootFromParent_Done,
      // Label 597: @18349
      GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(18385), // Rule ID 371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7968:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 371,
        GIR_EraseRootFromParent_Done,
      // Label 598: @18385
      GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(18421), // Rule ID 372 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7970:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 372,
        GIR_EraseRootFromParent_Done,
      // Label 599: @18421
      GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(18457), // Rule ID 373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbla),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7969:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 373,
        GIR_EraseRootFromParent_Done,
      // Label 600: @18457
      GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(18493), // Rule ID 374 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbra),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7971:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBRA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 374,
        GIR_EraseRootFromParent_Done,
      // Label 601: @18493
      GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(18529), // Rule ID 375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7972:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 375,
        GIR_EraseRootFromParent_Done,
      // Label 602: @18529
      GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(18565), // Rule ID 376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7974:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 376,
        GIR_EraseRootFromParent_Done,
      // Label 603: @18565
      GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(18601), // Rule ID 377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbla),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7973:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 377,
        GIR_EraseRootFromParent_Done,
      // Label 604: @18601
      GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(18637), // Rule ID 378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbra),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7975:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBRA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 378,
        GIR_EraseRootFromParent_Done,
      // Label 605: @18637
      GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(18673), // Rule ID 426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bitrev),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7540:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (BITREV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BITREV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 426,
        GIR_EraseRootFromParent_Done,
      // Label 606: @18673
      GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(18709), // Rule ID 430 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7987:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_QB:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 430,
        GIR_EraseRootFromParent_Done,
      // Label 607: @18709
      GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(18745), // Rule ID 431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7986:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_PH:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 431,
        GIR_EraseRootFromParent_Done,
      // Label 608: @18745
      GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(18781), // Rule ID 680 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fclass_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7692:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FCLASS_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCLASS_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 680,
        GIR_EraseRootFromParent_Done,
      // Label 609: @18781
      GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(18817), // Rule ID 681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fclass_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7691:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FCLASS_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCLASS_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 681,
        GIR_EraseRootFromParent_Done,
      // Label 610: @18817
      GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(18853), // Rule ID 704 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupl_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7718:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPL_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 704,
        GIR_EraseRootFromParent_Done,
      // Label 611: @18853
      GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(18889), // Rule ID 705 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupl_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7717:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPL_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 705,
        GIR_EraseRootFromParent_Done,
      // Label 612: @18889
      GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(18925), // Rule ID 706 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupr_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7720:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 706,
        GIR_EraseRootFromParent_Done,
      // Label 613: @18925
      GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(18961), // Rule ID 707 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupr_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7719:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 707,
        GIR_EraseRootFromParent_Done,
      // Label 614: @18961
      GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(18997), // Rule ID 712 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffql_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7726:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQL_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 712,
        GIR_EraseRootFromParent_Done,
      // Label 615: @18997
      GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(19033), // Rule ID 713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffql_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7725:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQL_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 713,
        GIR_EraseRootFromParent_Done,
      // Label 616: @19033
      GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(19069), // Rule ID 714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffqr_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7728:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 714,
        GIR_EraseRootFromParent_Done,
      // Label 617: @19069
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(19105), // Rule ID 715 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffqr_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7727:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 715,
        GIR_EraseRootFromParent_Done,
      // Label 618: @19105
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(19141), // Rule ID 740 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frcp_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7750:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRCP_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRCP_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 740,
        GIR_EraseRootFromParent_Done,
      // Label 619: @19141
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(19177), // Rule ID 741 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frcp_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7749:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRCP_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRCP_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 741,
        GIR_EraseRootFromParent_Done,
      // Label 620: @19177
      GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(19213), // Rule ID 742 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frsqrt_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7754:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRSQRT_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRSQRT_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 742,
        GIR_EraseRootFromParent_Done,
      // Label 621: @19213
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(19249), // Rule ID 743 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frsqrt_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7753:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRSQRT_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRSQRT_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 743,
        GIR_EraseRootFromParent_Done,
      // Label 622: @19249
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(19285), // Rule ID 770 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7782:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 770,
        GIR_EraseRootFromParent_Done,
      // Label 623: @19285
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(19321), // Rule ID 771 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7781:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 771,
        GIR_EraseRootFromParent_Done,
      // Label 624: @19321
      GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(19357), // Rule ID 772 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7784:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 772,
        GIR_EraseRootFromParent_Done,
      // Label 625: @19357
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(19393), // Rule ID 773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7783:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 773,
        GIR_EraseRootFromParent_Done,
      // Label 626: @19393
      GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(19429), // Rule ID 908 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7939:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws)  =>  (NLOC_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 908,
        GIR_EraseRootFromParent_Done,
      // Label 627: @19429
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(19465), // Rule ID 909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7941:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (NLOC_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 909,
        GIR_EraseRootFromParent_Done,
      // Label 628: @19465
      GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(19501), // Rule ID 910 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7942:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (NLOC_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 910,
        GIR_EraseRootFromParent_Done,
      // Label 629: @19501
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(19537), // Rule ID 911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7940:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws)  =>  (NLOC_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 911,
        GIR_EraseRootFromParent_Done,
      // Label 630: @19537
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(19573), // Rule ID 1251 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7966:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1251,
        GIR_EraseRootFromParent_Done,
      // Label 631: @19573
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(19609), // Rule ID 1252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7967:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1252,
        GIR_EraseRootFromParent_Done,
      // Label 632: @19609
      GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(19645), // Rule ID 1253 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7968:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1253,
        GIR_EraseRootFromParent_Done,
      // Label 633: @19645
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(19681), // Rule ID 1254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbla),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7969:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBLA_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1254,
        GIR_EraseRootFromParent_Done,
      // Label 634: @19681
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(19717), // Rule ID 1255 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7970:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1255,
        GIR_EraseRootFromParent_Done,
      // Label 635: @19717
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(19753), // Rule ID 1256 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbra),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7971:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBRA_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1256,
        GIR_EraseRootFromParent_Done,
      // Label 636: @19753
      GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(19789), // Rule ID 1257 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7972:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1257,
        GIR_EraseRootFromParent_Done,
      // Label 637: @19789
      GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(19825), // Rule ID 1258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbla),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7973:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBLA_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1258,
        GIR_EraseRootFromParent_Done,
      // Label 638: @19825
      GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(19861), // Rule ID 1259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7974:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1259,
        GIR_EraseRootFromParent_Done,
      // Label 639: @19861
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(19897), // Rule ID 1260 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbra),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7975:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBRA_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1260,
        GIR_EraseRootFromParent_Done,
      // Label 640: @19897
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(19933), // Rule ID 1286 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_raddu_w_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7984:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::RADDU_W_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1286,
        GIR_EraseRootFromParent_Done,
      // Label 641: @19933
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(19969), // Rule ID 1290 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7986:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_PH_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1290,
        GIR_EraseRootFromParent_Done,
      // Label 642: @19969
      GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(20005), // Rule ID 1291 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7987:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_QB_MM:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1291,
        GIR_EraseRootFromParent_Done,
      // Label 643: @20005
      GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(20041), // Rule ID 1301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bitrev),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7540:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (BITREV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BITREV_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1301,
        GIR_EraseRootFromParent_Done,
      // Label 644: @20041
      GIM_Reject,
    // Label 590: @20042
    GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(29795),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(20096), // Rule ID 938 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7988:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SAT_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 938,
        GIR_EraseRootFromParent_Done,
      // Label 646: @20096
      GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(20142), // Rule ID 939 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7990:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SAT_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 939,
        GIR_EraseRootFromParent_Done,
      // Label 647: @20142
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(20188), // Rule ID 940 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7991:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SAT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 940,
        GIR_EraseRootFromParent_Done,
      // Label 648: @20188
      GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(20234), // Rule ID 941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7989:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SAT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 941,
        GIR_EraseRootFromParent_Done,
      // Label 649: @20234
      GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(20280), // Rule ID 942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7992:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SAT_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 942,
        GIR_EraseRootFromParent_Done,
      // Label 650: @20280
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(20326), // Rule ID 943 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7994:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SAT_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 943,
        GIR_EraseRootFromParent_Done,
      // Label 651: @20326
      GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(20372), // Rule ID 944 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7995:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SAT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 944,
        GIR_EraseRootFromParent_Done,
      // Label 652: @20372
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(20418), // Rule ID 945 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7993:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SAT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 945,
        GIR_EraseRootFromParent_Done,
      // Label 653: @20418
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(20464), // Rule ID 985 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 8047:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SRARI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 985,
        GIR_EraseRootFromParent_Done,
      // Label 654: @20464
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(20510), // Rule ID 986 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 8049:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SRARI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 986,
        GIR_EraseRootFromParent_Done,
      // Label 655: @20510
      GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(20556), // Rule ID 987 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 8050:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SRARI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 987,
        GIR_EraseRootFromParent_Done,
      // Label 656: @20556
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(20602), // Rule ID 988 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 8048:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SRARI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 988,
        GIR_EraseRootFromParent_Done,
      // Label 657: @20602
      GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(20648), // Rule ID 1001 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 8063:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SRLRI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1001,
        GIR_EraseRootFromParent_Done,
      // Label 658: @20648
      GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(20694), // Rule ID 1002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 8065:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SRLRI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1002,
        GIR_EraseRootFromParent_Done,
      // Label 659: @20694
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(20740), // Rule ID 1003 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 8066:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SRLRI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1003,
        GIR_EraseRootFromParent_Done,
      // Label 660: @20740
      GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(20786), // Rule ID 1004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 8064:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SRLRI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1004,
        GIR_EraseRootFromParent_Done,
      // Label 661: @20786
      GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(20842), // Rule ID 385 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 8006:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHRA_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 385,
        GIR_EraseRootFromParent_Done,
      // Label 662: @20842
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(20898), // Rule ID 389 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 8008:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHRA_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 389,
        GIR_EraseRootFromParent_Done,
      // Label 663: @20898
      GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(20954), // Rule ID 480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 8007:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$rs_sa)  =>  (SHRA_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 480,
        GIR_EraseRootFromParent_Done,
      // Label 664: @20954
      GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(21010), // Rule ID 1245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 8006:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHRA_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1245,
        GIR_EraseRootFromParent_Done,
      // Label 665: @21010
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(21066), // Rule ID 1249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 8008:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHRA_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1249,
        GIR_EraseRootFromParent_Done,
      // Label 666: @21066
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(21122), // Rule ID 1324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 8007:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$sa)  =>  (SHRA_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1324,
        GIR_EraseRootFromParent_Done,
      // Label 667: @21122
      GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(21174), // Rule ID 1934 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 8004:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRA_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1934,
        GIR_EraseRootFromParent_Done,
      // Label 668: @21174
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(21226), // Rule ID 1935 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 8009:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRL_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1935,
        GIR_EraseRootFromParent_Done,
      // Label 669: @21226
      GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(21278), // Rule ID 1940 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 8005:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRA_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1940,
        GIR_EraseRootFromParent_Done,
      // Label 670: @21278
      GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(21330), // Rule ID 1941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 8010:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRL_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1941,
        GIR_EraseRootFromParent_Done,
      // Label 671: @21330
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(21378), // Rule ID 355 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7476:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 355,
        GIR_EraseRootFromParent_Done,
      // Label 672: @21378
      GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(21426), // Rule ID 356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8099:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 356,
        GIR_EraseRootFromParent_Done,
      // Label 673: @21426
      GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(21474), // Rule ID 357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7454:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 357,
        GIR_EraseRootFromParent_Done,
      // Label 674: @21474
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(21522), // Rule ID 358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8074:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 358,
        GIR_EraseRootFromParent_Done,
      // Label 675: @21522
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(21567), // Rule ID 361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_modsub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7904:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MODSUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 361,
        GIR_EraseRootFromParent_Done,
      // Label 676: @21567
      GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(21612), // Rule ID 365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7980:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_QB_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 365,
        GIR_EraseRootFromParent_Done,
      // Label 677: @21612
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(21657), // Rule ID 366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7979:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_PH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 366,
        GIR_EraseRootFromParent_Done,
      // Label 678: @21657
      GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(21702), // Rule ID 380 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8010:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 380,
        GIR_EraseRootFromParent_Done,
      // Label 679: @21702
      GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(21747), // Rule ID 384 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8004:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 384,
        GIR_EraseRootFromParent_Done,
      // Label 680: @21747
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(21792), // Rule ID 386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8006:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 386,
        GIR_EraseRootFromParent_Done,
      // Label 681: @21792
      GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(21837), // Rule ID 390 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 8008:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 390,
        GIR_EraseRootFromParent_Done,
      // Label 682: @21837
      GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(21882), // Rule ID 427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_packrl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7951:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PACKRL_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 427,
        GIR_EraseRootFromParent_Done,
      // Label 683: @21882
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(21927), // Rule ID 451 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7477:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 451,
        GIR_EraseRootFromParent_Done,
      // Label 684: @21927
      GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(21972), // Rule ID 452 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7478:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_R_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 452,
        GIR_EraseRootFromParent_Done,
      // Label 685: @21972
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(22017), // Rule ID 453 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8100:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 453,
        GIR_EraseRootFromParent_Done,
      // Label 686: @22017
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(22062), // Rule ID 454 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8101:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_R_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 454,
        GIR_EraseRootFromParent_Done,
      // Label 687: @22062
      GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(22107), // Rule ID 455 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7456:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 455,
        GIR_EraseRootFromParent_Done,
      // Label 688: @22107
      GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(22152), // Rule ID 456 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7457:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 456,
        GIR_EraseRootFromParent_Done,
      // Label 689: @22152
      GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(22197), // Rule ID 457 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8076:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 457,
        GIR_EraseRootFromParent_Done,
      // Label 690: @22197
      GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(22242), // Rule ID 458 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8077:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 458,
        GIR_EraseRootFromParent_Done,
      // Label 691: @22242
      GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(22287), // Rule ID 459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7459:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 459,
        GIR_EraseRootFromParent_Done,
      // Label 692: @22287
      GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(22332), // Rule ID 460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7458:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 460,
        GIR_EraseRootFromParent_Done,
      // Label 693: @22332
      GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(22377), // Rule ID 461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 8079:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 461,
        GIR_EraseRootFromParent_Done,
      // Label 694: @22377
      GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(22422), // Rule ID 462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 8078:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 462,
        GIR_EraseRootFromParent_Done,
      // Label 695: @22422
      GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(22467), // Rule ID 479 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8005:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 479,
        GIR_EraseRootFromParent_Done,
      // Label 696: @22467
      GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(22512), // Rule ID 481 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8007:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 481,
        GIR_EraseRootFromParent_Done,
      // Label 697: @22512
      GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(22557), // Rule ID 482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8009:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 482,
        GIR_EraseRootFromParent_Done,
      // Label 698: @22557
      GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(22602), // Rule ID 491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7449:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADD_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 491,
        GIR_EraseRootFromParent_Done,
      // Label 699: @22602
      GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(22647), // Rule ID 492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7451:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADD_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 492,
        GIR_EraseRootFromParent_Done,
      // Label 700: @22647
      GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(22692), // Rule ID 493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7452:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADD_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 493,
        GIR_EraseRootFromParent_Done,
      // Label 701: @22692
      GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(22737), // Rule ID 494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7450:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADD_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 494,
        GIR_EraseRootFromParent_Done,
      // Label 702: @22737
      GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(22782), // Rule ID 495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7460:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 495,
        GIR_EraseRootFromParent_Done,
      // Label 703: @22782
      GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(22827), // Rule ID 496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7462:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 496,
        GIR_EraseRootFromParent_Done,
      // Label 704: @22827
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(22872), // Rule ID 497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7463:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 497,
        GIR_EraseRootFromParent_Done,
      // Label 705: @22872
      GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(22917), // Rule ID 498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7461:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 498,
        GIR_EraseRootFromParent_Done,
      // Label 706: @22917
      GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(22962), // Rule ID 499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7464:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 499,
        GIR_EraseRootFromParent_Done,
      // Label 707: @22962
      GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(23007), // Rule ID 500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7466:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 500,
        GIR_EraseRootFromParent_Done,
      // Label 708: @23007
      GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(23052), // Rule ID 501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7467:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 501,
        GIR_EraseRootFromParent_Done,
      // Label 709: @23052
      GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(23097), // Rule ID 502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7465:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 502,
        GIR_EraseRootFromParent_Done,
      // Label 710: @23097
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(23142), // Rule ID 503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7468:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 503,
        GIR_EraseRootFromParent_Done,
      // Label 711: @23142
      GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(23187), // Rule ID 504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7470:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 504,
        GIR_EraseRootFromParent_Done,
      // Label 712: @23187
      GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(23232), // Rule ID 505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7471:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 505,
        GIR_EraseRootFromParent_Done,
      // Label 713: @23232
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(23277), // Rule ID 506 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7469:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 506,
        GIR_EraseRootFromParent_Done,
      // Label 714: @23277
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(23322), // Rule ID 520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7491:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 520,
        GIR_EraseRootFromParent_Done,
      // Label 715: @23322
      GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(23367), // Rule ID 521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7493:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 521,
        GIR_EraseRootFromParent_Done,
      // Label 716: @23367
      GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(23412), // Rule ID 522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7494:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 522,
        GIR_EraseRootFromParent_Done,
      // Label 717: @23412
      GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(23457), // Rule ID 523 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7492:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 523,
        GIR_EraseRootFromParent_Done,
      // Label 718: @23457
      GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(23502), // Rule ID 524 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7495:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 524,
        GIR_EraseRootFromParent_Done,
      // Label 719: @23502
      GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(23547), // Rule ID 525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7497:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 525,
        GIR_EraseRootFromParent_Done,
      // Label 720: @23547
      GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(23592), // Rule ID 526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7498:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 526,
        GIR_EraseRootFromParent_Done,
      // Label 721: @23592
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(23637), // Rule ID 527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7496:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 527,
        GIR_EraseRootFromParent_Done,
      // Label 722: @23637
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(23682), // Rule ID 528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7499:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 528,
        GIR_EraseRootFromParent_Done,
      // Label 723: @23682
      GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(23727), // Rule ID 529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7501:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 529,
        GIR_EraseRootFromParent_Done,
      // Label 724: @23727
      GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(23772), // Rule ID 530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7502:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 530,
        GIR_EraseRootFromParent_Done,
      // Label 725: @23772
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(23817), // Rule ID 531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7500:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 531,
        GIR_EraseRootFromParent_Done,
      // Label 726: @23817
      GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(23862), // Rule ID 532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7503:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 532,
        GIR_EraseRootFromParent_Done,
      // Label 727: @23862
      GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(23907), // Rule ID 533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7505:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 533,
        GIR_EraseRootFromParent_Done,
      // Label 728: @23907
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(23952), // Rule ID 534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7506:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 534,
        GIR_EraseRootFromParent_Done,
      // Label 729: @23952
      GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(23997), // Rule ID 535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7504:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 535,
        GIR_EraseRootFromParent_Done,
      // Label 730: @23997
      GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(24042), // Rule ID 536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7507:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 536,
        GIR_EraseRootFromParent_Done,
      // Label 731: @24042
      GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(24087), // Rule ID 537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7509:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 537,
        GIR_EraseRootFromParent_Done,
      // Label 732: @24087
      GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(24132), // Rule ID 538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7510:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 538,
        GIR_EraseRootFromParent_Done,
      // Label 733: @24132
      GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(24177), // Rule ID 539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7508:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 539,
        GIR_EraseRootFromParent_Done,
      // Label 734: @24177
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(24222), // Rule ID 540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7511:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 540,
        GIR_EraseRootFromParent_Done,
      // Label 735: @24222
      GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(24267), // Rule ID 541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7513:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 541,
        GIR_EraseRootFromParent_Done,
      // Label 736: @24267
      GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(24312), // Rule ID 542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7514:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 542,
        GIR_EraseRootFromParent_Done,
      // Label 737: @24312
      GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(24357), // Rule ID 543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7512:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 543,
        GIR_EraseRootFromParent_Done,
      // Label 738: @24357
      GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(24402), // Rule ID 652 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7646:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 652,
        GIR_EraseRootFromParent_Done,
      // Label 739: @24402
      GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(24447), // Rule ID 653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7647:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 653,
        GIR_EraseRootFromParent_Done,
      // Label 740: @24447
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(24492), // Rule ID 654 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7645:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 654,
        GIR_EraseRootFromParent_Done,
      // Label 741: @24492
      GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(24537), // Rule ID 655 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7649:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 655,
        GIR_EraseRootFromParent_Done,
      // Label 742: @24537
      GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(24582), // Rule ID 656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7650:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 656,
        GIR_EraseRootFromParent_Done,
      // Label 743: @24582
      GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(24627), // Rule ID 657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7648:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 657,
        GIR_EraseRootFromParent_Done,
      // Label 744: @24627
      GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(24672), // Rule ID 672 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fcaf_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7688:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FCAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCAF_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 672,
        GIR_EraseRootFromParent_Done,
      // Label 745: @24672
      GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(24717), // Rule ID 673 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fcaf_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7687:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FCAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCAF_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 673,
        GIR_EraseRootFromParent_Done,
      // Label 746: @24717
      GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(24762), // Rule ID 698 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexdo_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 7713:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FEXDO_H:{ *:[v8f16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXDO_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 698,
        GIR_EraseRootFromParent_Done,
      // Label 747: @24762
      GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(24807), // Rule ID 699 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexdo_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7714:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FEXDO_W:{ *:[v4f32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXDO_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 699,
        GIR_EraseRootFromParent_Done,
      // Label 748: @24807
      GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(24852), // Rule ID 726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7740:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 726,
        GIR_EraseRootFromParent_Done,
      // Label 749: @24852
      GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(24897), // Rule ID 727 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7739:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 727,
        GIR_EraseRootFromParent_Done,
      // Label 750: @24897
      GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(24942), // Rule ID 728 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7738:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 728,
        GIR_EraseRootFromParent_Done,
      // Label 751: @24942
      GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(24987), // Rule ID 729 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7737:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 729,
        GIR_EraseRootFromParent_Done,
      // Label 752: @24987
      GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(25032), // Rule ID 730 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7744:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 730,
        GIR_EraseRootFromParent_Done,
      // Label 753: @25032
      GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(25077), // Rule ID 731 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7743:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 731,
        GIR_EraseRootFromParent_Done,
      // Label 754: @25077
      GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(25122), // Rule ID 732 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7742:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 732,
        GIR_EraseRootFromParent_Done,
      // Label 755: @25122
      GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(25167), // Rule ID 733 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7741:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 733,
        GIR_EraseRootFromParent_Done,
      // Label 756: @25167
      GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(25212), // Rule ID 744 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsaf_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7756:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSAF_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 744,
        GIR_EraseRootFromParent_Done,
      // Label 757: @25212
      GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(25257), // Rule ID 745 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsaf_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7755:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSAF_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 745,
        GIR_EraseRootFromParent_Done,
      // Label 758: @25257
      GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(25302), // Rule ID 746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fseq_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7758:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSEQ_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 746,
        GIR_EraseRootFromParent_Done,
      // Label 759: @25302
      GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(25347), // Rule ID 747 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fseq_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7757:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSEQ_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 747,
        GIR_EraseRootFromParent_Done,
      // Label 760: @25347
      GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(25392), // Rule ID 748 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsle_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7760:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLE_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 748,
        GIR_EraseRootFromParent_Done,
      // Label 761: @25392
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(25437), // Rule ID 749 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsle_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7759:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLE_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 749,
        GIR_EraseRootFromParent_Done,
      // Label 762: @25437
      GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(25482), // Rule ID 750 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fslt_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7762:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLT_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 750,
        GIR_EraseRootFromParent_Done,
      // Label 763: @25482
      GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(25527), // Rule ID 751 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fslt_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7761:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLT_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 751,
        GIR_EraseRootFromParent_Done,
      // Label 764: @25527
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(25572), // Rule ID 752 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsne_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7764:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSNE_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 752,
        GIR_EraseRootFromParent_Done,
      // Label 765: @25572
      GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(25617), // Rule ID 753 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsne_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7763:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSNE_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 753,
        GIR_EraseRootFromParent_Done,
      // Label 766: @25617
      GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(25662), // Rule ID 754 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsor_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7766:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSOR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSOR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 754,
        GIR_EraseRootFromParent_Done,
      // Label 767: @25662
      GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(25707), // Rule ID 755 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsor_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7765:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSOR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSOR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 755,
        GIR_EraseRootFromParent_Done,
      // Label 768: @25707
      GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(25752), // Rule ID 760 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsueq_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7772:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUEQ_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 760,
        GIR_EraseRootFromParent_Done,
      // Label 769: @25752
      GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(25797), // Rule ID 761 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsueq_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7771:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUEQ_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 761,
        GIR_EraseRootFromParent_Done,
      // Label 770: @25797
      GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(25842), // Rule ID 762 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsule_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7774:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULE_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 762,
        GIR_EraseRootFromParent_Done,
      // Label 771: @25842
      GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(25887), // Rule ID 763 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsule_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7773:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULE_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 763,
        GIR_EraseRootFromParent_Done,
      // Label 772: @25887
      GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(25932), // Rule ID 764 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsult_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7776:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULT_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 764,
        GIR_EraseRootFromParent_Done,
      // Label 773: @25932
      GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(25977), // Rule ID 765 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsult_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7775:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULT_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 765,
        GIR_EraseRootFromParent_Done,
      // Label 774: @25977
      GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(26022), // Rule ID 766 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsun_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7778:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUN_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUN_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 766,
        GIR_EraseRootFromParent_Done,
      // Label 775: @26022
      GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(26067), // Rule ID 767 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsun_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7777:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUN_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUN_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 767,
        GIR_EraseRootFromParent_Done,
      // Label 776: @26067
      GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(26112), // Rule ID 768 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsune_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7780:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUNE_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 768,
        GIR_EraseRootFromParent_Done,
      // Label 777: @26112
      GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(26157), // Rule ID 769 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsune_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7779:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUNE_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 769,
        GIR_EraseRootFromParent_Done,
      // Label 778: @26157
      GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(26202), // Rule ID 774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftq_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7785:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FTQ_H:{ *:[v8i16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTQ_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 774,
        GIR_EraseRootFromParent_Done,
      // Label 779: @26202
      GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(26247), // Rule ID 775 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftq_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7786:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FTQ_W:{ *:[v4i32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTQ_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 775,
        GIR_EraseRootFromParent_Done,
      // Label 780: @26247
      GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(26292), // Rule ID 780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7792:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 780,
        GIR_EraseRootFromParent_Done,
      // Label 781: @26292
      GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(26337), // Rule ID 781 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7793:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 781,
        GIR_EraseRootFromParent_Done,
      // Label 782: @26337
      GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(26382), // Rule ID 782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7791:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 782,
        GIR_EraseRootFromParent_Done,
      // Label 783: @26382
      GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(26427), // Rule ID 783 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7795:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 783,
        GIR_EraseRootFromParent_Done,
      // Label 784: @26427
      GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(26472), // Rule ID 784 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7796:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 784,
        GIR_EraseRootFromParent_Done,
      // Label 785: @26472
      GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(26517), // Rule ID 785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7794:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 785,
        GIR_EraseRootFromParent_Done,
      // Label 786: @26517
      GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(26562), // Rule ID 786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7798:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 786,
        GIR_EraseRootFromParent_Done,
      // Label 787: @26562
      GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(26607), // Rule ID 787 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7799:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 787,
        GIR_EraseRootFromParent_Done,
      // Label 788: @26607
      GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(26652), // Rule ID 788 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7797:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 788,
        GIR_EraseRootFromParent_Done,
      // Label 789: @26652
      GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(26697), // Rule ID 789 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7801:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 789,
        GIR_EraseRootFromParent_Done,
      // Label 790: @26697
      GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(26742), // Rule ID 790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7802:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 790,
        GIR_EraseRootFromParent_Done,
      // Label 791: @26742
      GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(26787), // Rule ID 791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7800:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 791,
        GIR_EraseRootFromParent_Done,
      // Label 792: @26787
      GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(26832), // Rule ID 844 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7856:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MAX_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 844,
        GIR_EraseRootFromParent_Done,
      // Label 793: @26832
      GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(26877), // Rule ID 845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7858:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MAX_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 845,
        GIR_EraseRootFromParent_Done,
      // Label 794: @26877
      GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(26922), // Rule ID 846 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7859:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MAX_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 846,
        GIR_EraseRootFromParent_Done,
      // Label 795: @26922
      GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(26967), // Rule ID 847 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7857:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MAX_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 847,
        GIR_EraseRootFromParent_Done,
      // Label 796: @26967
      GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(27012), // Rule ID 864 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7876:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MIN_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 864,
        GIR_EraseRootFromParent_Done,
      // Label 797: @27012
      GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(27057), // Rule ID 865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7878:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MIN_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 865,
        GIR_EraseRootFromParent_Done,
      // Label 798: @27057
      GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(27102), // Rule ID 866 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7879:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MIN_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 866,
        GIR_EraseRootFromParent_Done,
      // Label 799: @27102
      GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(27147), // Rule ID 867 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7877:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MIN_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 867,
        GIR_EraseRootFromParent_Done,
      // Label 800: @27147
      GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(27192), // Rule ID 900 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7918:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MUL_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 900,
        GIR_EraseRootFromParent_Done,
      // Label 801: @27192
      GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(27237), // Rule ID 901 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7919:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MUL_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 901,
        GIR_EraseRootFromParent_Done,
      // Label 802: @27237
      GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(27282), // Rule ID 902 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulr_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7929:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULR_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 902,
        GIR_EraseRootFromParent_Done,
      // Label 803: @27282
      GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(27327), // Rule ID 903 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulr_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7930:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULR_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 903,
        GIR_EraseRootFromParent_Done,
      // Label 804: @27327
      GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(27372), // Rule ID 981 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 8043:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRAR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 981,
        GIR_EraseRootFromParent_Done,
      // Label 805: @27372
      GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(27417), // Rule ID 982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 8045:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRAR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 982,
        GIR_EraseRootFromParent_Done,
      // Label 806: @27417
      GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(27462), // Rule ID 983 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 8046:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRAR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 983,
        GIR_EraseRootFromParent_Done,
      // Label 807: @27462
      GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(27507), // Rule ID 984 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 8044:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRAR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 984,
        GIR_EraseRootFromParent_Done,
      // Label 808: @27507
      GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(27552), // Rule ID 997 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 8059:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRLR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 997,
        GIR_EraseRootFromParent_Done,
      // Label 809: @27552
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(27597), // Rule ID 998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 8061:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRLR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 998,
        GIR_EraseRootFromParent_Done,
      // Label 810: @27597
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(27642), // Rule ID 999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 8062:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRLR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 999,
        GIR_EraseRootFromParent_Done,
      // Label 811: @27642
      GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(27687), // Rule ID 1000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 8060:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRLR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1000,
        GIR_EraseRootFromParent_Done,
      // Label 812: @27687
      GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(27732), // Rule ID 1009 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 8080:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1009,
        GIR_EraseRootFromParent_Done,
      // Label 813: @27732
      GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(27777), // Rule ID 1010 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 8082:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1010,
        GIR_EraseRootFromParent_Done,
      // Label 814: @27777
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(27822), // Rule ID 1011 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 8083:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1011,
        GIR_EraseRootFromParent_Done,
      // Label 815: @27822
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(27867), // Rule ID 1012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 8081:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1012,
        GIR_EraseRootFromParent_Done,
      // Label 816: @27867
      GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(27912), // Rule ID 1013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 8084:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1013,
        GIR_EraseRootFromParent_Done,
      // Label 817: @27912
      GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(27957), // Rule ID 1014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 8086:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1014,
        GIR_EraseRootFromParent_Done,
      // Label 818: @27957
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(28002), // Rule ID 1015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 8087:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1015,
        GIR_EraseRootFromParent_Done,
      // Label 819: @28002
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(28047), // Rule ID 1016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 8085:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1016,
        GIR_EraseRootFromParent_Done,
      // Label 820: @28047
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(28092), // Rule ID 1017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 8088:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1017,
        GIR_EraseRootFromParent_Done,
      // Label 821: @28092
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(28137), // Rule ID 1018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 8090:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1018,
        GIR_EraseRootFromParent_Done,
      // Label 822: @28137
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(28182), // Rule ID 1019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 8091:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1019,
        GIR_EraseRootFromParent_Done,
      // Label 823: @28182
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(28227), // Rule ID 1020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 8089:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1020,
        GIR_EraseRootFromParent_Done,
      // Label 824: @28227
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(28272), // Rule ID 1021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 8092:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUU_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1021,
        GIR_EraseRootFromParent_Done,
      // Label 825: @28272
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(28317), // Rule ID 1022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 8094:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUU_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1022,
        GIR_EraseRootFromParent_Done,
      // Label 826: @28317
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(28362), // Rule ID 1023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 8095:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUU_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1023,
        GIR_EraseRootFromParent_Done,
      // Label 827: @28362
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(28407), // Rule ID 1024 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 8093:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUU_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1024,
        GIR_EraseRootFromParent_Done,
      // Label 828: @28407
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(28455), // Rule ID 1223 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7454:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1223,
        GIR_EraseRootFromParent_Done,
      // Label 829: @28455
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(28503), // Rule ID 1225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7476:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1225,
        GIR_EraseRootFromParent_Done,
      // Label 830: @28503
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(28548), // Rule ID 1246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8004:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1246,
        GIR_EraseRootFromParent_Done,
      // Label 831: @28548
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(28593), // Rule ID 1247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8006:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1247,
        GIR_EraseRootFromParent_Done,
      // Label 832: @28593
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(28638), // Rule ID 1248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 8008:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1248,
        GIR_EraseRootFromParent_Done,
      // Label 833: @28638
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(28683), // Rule ID 1250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8010:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1250,
        GIR_EraseRootFromParent_Done,
      // Label 834: @28683
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(28731), // Rule ID 1261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8074:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1261,
        GIR_EraseRootFromParent_Done,
      // Label 835: @28731
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(28779), // Rule ID 1263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8099:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1263,
        GIR_EraseRootFromParent_Done,
      // Label 836: @28779
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(28824), // Rule ID 1273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7979:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_PH_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1273,
        GIR_EraseRootFromParent_Done,
      // Label 837: @28824
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(28869), // Rule ID 1274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7980:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_QB_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1274,
        GIR_EraseRootFromParent_Done,
      // Label 838: @28869
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(28914), // Rule ID 1293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_packrl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7951:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PACKRL_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1293,
        GIR_EraseRootFromParent_Done,
      // Label 839: @28914
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(28959), // Rule ID 1299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_modsub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7904:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MODSUB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1299,
        GIR_EraseRootFromParent_Done,
      // Label 840: @28959
      GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(29004), // Rule ID 1312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7456:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1312,
        GIR_EraseRootFromParent_Done,
      // Label 841: @29004
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(29049), // Rule ID 1313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7457:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1313,
        GIR_EraseRootFromParent_Done,
      // Label 842: @29049
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(29094), // Rule ID 1314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7459:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1314,
        GIR_EraseRootFromParent_Done,
      // Label 843: @29094
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(29139), // Rule ID 1315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7458:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1315,
        GIR_EraseRootFromParent_Done,
      // Label 844: @29139
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(29184), // Rule ID 1318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7477:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1318,
        GIR_EraseRootFromParent_Done,
      // Label 845: @29184
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(29229), // Rule ID 1319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7478:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_R_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1319,
        GIR_EraseRootFromParent_Done,
      // Label 846: @29229
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(29274), // Rule ID 1325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8005:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1325,
        GIR_EraseRootFromParent_Done,
      // Label 847: @29274
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(29319), // Rule ID 1326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8007:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1326,
        GIR_EraseRootFromParent_Done,
      // Label 848: @29319
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(29364), // Rule ID 1331 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8009:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1331,
        GIR_EraseRootFromParent_Done,
      // Label 849: @29364
      GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(29409), // Rule ID 1332 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8076:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1332,
        GIR_EraseRootFromParent_Done,
      // Label 850: @29409
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(29454), // Rule ID 1333 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8077:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1333,
        GIR_EraseRootFromParent_Done,
      // Label 851: @29454
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(29499), // Rule ID 1334 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 8079:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1334,
        GIR_EraseRootFromParent_Done,
      // Label 852: @29499
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(29544), // Rule ID 1335 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 8078:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1335,
        GIR_EraseRootFromParent_Done,
      // Label 853: @29544
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(29589), // Rule ID 1338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8100:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1338,
        GIR_EraseRootFromParent_Done,
      // Label 854: @29589
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(29634), // Rule ID 1339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8101:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_R_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1339,
        GIR_EraseRootFromParent_Done,
      // Label 855: @29634
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(29674), // Rule ID 1916 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7453:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1916,
        GIR_EraseRootFromParent_Done,
      // Label 856: @29674
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(29714), // Rule ID 1918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 8073:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1918,
        GIR_EraseRootFromParent_Done,
      // Label 857: @29714
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(29754), // Rule ID 1922 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7474:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1922,
        GIR_EraseRootFromParent_Done,
      // Label 858: @29754
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(29794), // Rule ID 1924 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 8097:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1924,
        GIR_EraseRootFromParent_Done,
      // Label 859: @29794
      GIM_Reject,
    // Label 645: @29795
    GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(32309),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(29858), // Rule ID 477 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7977:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_PH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 477,
        GIR_EraseRootFromParent_Done,
      // Label 861: @29858
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(29913), // Rule ID 478 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_r_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7978:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_R_PH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 478,
        GIR_EraseRootFromParent_Done,
      // Label 862: @29913
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(29968), // Rule ID 483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_append),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 7490:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (APPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::APPEND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 483,
        GIR_EraseRootFromParent_Done,
      // Label 863: @29968
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(30023), // Rule ID 484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_balign),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt2),
        // (intrinsic_wo_chain:{ *:[i32] } 7515:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt2>>:$sa)  =>  (BALIGN:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BALIGN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 484,
        GIR_EraseRootFromParent_Done,
      // Label 864: @30023
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(30078), // Rule ID 485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_prepend),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 7983:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PREPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PREPEND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 485,
        GIR_EraseRootFromParent_Done,
      // Label 865: @30078
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(30133), // Rule ID 953 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v16i8] } 8015:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$n)  =>  (SLDI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // n
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 953,
        GIR_EraseRootFromParent_Done,
      // Label 866: @30133
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(30188), // Rule ID 954 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v8i16] } 8017:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$n)  =>  (SLDI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // n
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 954,
        GIR_EraseRootFromParent_Done,
      // Label 867: @30188
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(30243), // Rule ID 955 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt2),
        // (intrinsic_wo_chain:{ *:[v4i32] } 8018:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt2>>:$n)  =>  (SLDI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // n
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 955,
        GIR_EraseRootFromParent_Done,
      // Label 868: @30243
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(30298), // Rule ID 956 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt1),
        // (intrinsic_wo_chain:{ *:[v2i64] } 8016:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt1>>:$n)  =>  (SLDI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // n
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 956,
        GIR_EraseRootFromParent_Done,
      // Label 869: @30298
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(30353), // Rule ID 1349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7977:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_PH_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1349,
        GIR_EraseRootFromParent_Done,
      // Label 870: @30353
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(30408), // Rule ID 1350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_r_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7978:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_R_PH_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1350,
        GIR_EraseRootFromParent_Done,
      // Label 871: @30408
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(30463), // Rule ID 1351 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_prepend),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 7983:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PREPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PREPEND_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1351,
        GIR_EraseRootFromParent_Done,
      // Label 872: @30463
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(30518), // Rule ID 1352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_append),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 7490:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (APPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::APPEND_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1352,
        GIR_EraseRootFromParent_Done,
      // Label 873: @30518
      GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(30580), // Rule ID 1327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_balign),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] bp
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 7515:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2>>:$bp)  =>  (BALIGN_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$bp, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BALIGN_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // bp
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1327,
        GIR_EraseRootFromParent_Done,
      // Label 874: @30580
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(30634), // Rule ID 552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7524:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 552,
        GIR_EraseRootFromParent_Done,
      // Label 875: @30634
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(30688), // Rule ID 553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7526:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 553,
        GIR_EraseRootFromParent_Done,
      // Label 876: @30688
      GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(30742), // Rule ID 554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7527:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 554,
        GIR_EraseRootFromParent_Done,
      // Label 877: @30742
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(30796), // Rule ID 555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7525:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 555,
        GIR_EraseRootFromParent_Done,
      // Label 878: @30796
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(30850), // Rule ID 560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7532:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 560,
        GIR_EraseRootFromParent_Done,
      // Label 879: @30850
      GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(30904), // Rule ID 561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7534:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 561,
        GIR_EraseRootFromParent_Done,
      // Label 880: @30904
      GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(30958), // Rule ID 562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7535:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 562,
        GIR_EraseRootFromParent_Done,
      // Label 881: @30958
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(31012), // Rule ID 563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7533:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 563,
        GIR_EraseRootFromParent_Done,
      // Label 882: @31012
      GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(31066), // Rule ID 658 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7653:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 658,
        GIR_EraseRootFromParent_Done,
      // Label 883: @31066
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(31120), // Rule ID 659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7654:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 659,
        GIR_EraseRootFromParent_Done,
      // Label 884: @31120
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(31174), // Rule ID 660 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7652:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 660,
        GIR_EraseRootFromParent_Done,
      // Label 885: @31174
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(31228), // Rule ID 661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7656:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 661,
        GIR_EraseRootFromParent_Done,
      // Label 886: @31228
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(31282), // Rule ID 662 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7657:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 662,
        GIR_EraseRootFromParent_Done,
      // Label 887: @31282
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(31336), // Rule ID 663 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7655:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 663,
        GIR_EraseRootFromParent_Done,
      // Label 888: @31336
      GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(31390), // Rule ID 664 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7673:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 664,
        GIR_EraseRootFromParent_Done,
      // Label 889: @31390
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(31444), // Rule ID 665 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7674:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 665,
        GIR_EraseRootFromParent_Done,
      // Label 890: @31444
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(31498), // Rule ID 666 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7672:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 666,
        GIR_EraseRootFromParent_Done,
      // Label 891: @31498
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(31552), // Rule ID 667 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7676:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 667,
        GIR_EraseRootFromParent_Done,
      // Label 892: @31552
      GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(31606), // Rule ID 668 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7677:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 668,
        GIR_EraseRootFromParent_Done,
      // Label 893: @31606
      GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(31660), // Rule ID 669 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7675:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 669,
        GIR_EraseRootFromParent_Done,
      // Label 894: @31660
      GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(31714), // Rule ID 836 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_madd_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7843:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADD_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADD_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 836,
        GIR_EraseRootFromParent_Done,
      // Label 895: @31714
      GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(31768), // Rule ID 837 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_madd_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7844:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADD_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADD_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 837,
        GIR_EraseRootFromParent_Done,
      // Label 896: @31768
      GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(31822), // Rule ID 838 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_maddr_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7845:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADDR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDR_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 838,
        GIR_EraseRootFromParent_Done,
      // Label 897: @31822
      GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(31876), // Rule ID 839 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_maddr_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7846:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADDR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDR_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 839,
        GIR_EraseRootFromParent_Done,
      // Label 898: @31876
      GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(31930), // Rule ID 892 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msub_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7907:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUB_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUB_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 892,
        GIR_EraseRootFromParent_Done,
      // Label 899: @31930
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(31984), // Rule ID 893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msub_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7908:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUB_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUB_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 893,
        GIR_EraseRootFromParent_Done,
      // Label 900: @31984
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(32038), // Rule ID 894 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msubr_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7909:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUBR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBR_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 894,
        GIR_EraseRootFromParent_Done,
      // Label 901: @32038
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(32092), // Rule ID 895 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msubr_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7910:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUBR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBR_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 895,
        GIR_EraseRootFromParent_Done,
      // Label 902: @32092
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(32146), // Rule ID 949 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 8011:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLD_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 949,
        GIR_EraseRootFromParent_Done,
      // Label 903: @32146
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(32200), // Rule ID 950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 8013:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLD_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 950,
        GIR_EraseRootFromParent_Done,
      // Label 904: @32200
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(32254), // Rule ID 951 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 8014:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLD_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 951,
        GIR_EraseRootFromParent_Done,
      // Label 905: @32254
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(32308), // Rule ID 952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 8012:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLD_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 952,
        GIR_EraseRootFromParent_Done,
      // Label 906: @32308
      GIM_Reject,
    // Label 860: @32309
    GIM_Reject,
    // Label 30: @32310
    GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(32341), // Rule ID 354 //
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bposge32),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (intrinsic_w_chain:{ *:[i32] } 7558:{ *:[iPTR] })  =>  (BPOSGE32_PSEUDO:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BPOSGE32_PSEUDO),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 354,
      GIR_EraseRootFromParent_Done,
    // Label 907: @32341
    GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(33278),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(32390), // Rule ID 441 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_rddsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt10),
        // (intrinsic_w_chain:{ *:[i32] } 7985:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_timmZExt10>>:$mask)  =>  (RDDSP:{ *:[i32] } (timm:{ *:[i32] }):$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::RDDSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 441,
        GIR_EraseRootFromParent_Done,
      // Label 909: @32390
      GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(32426), // Rule ID 1287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_rddsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_w_chain:{ *:[i32] } 7985:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_timmZExt7>>:$mask)  =>  (RDDSP_MM:{ *:[i32] } (timm:{ *:[i32] }):$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::RDDSP_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1287,
        GIR_EraseRootFromParent_Done,
      // Label 910: @32426
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(32467), // Rule ID 442 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_NotInMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_wrdsp),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt10),
        // (intrinsic_void 8114:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt10>>:$mask)  =>  (WRDSP GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::WRDSP),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 442,
        GIR_EraseRootFromParent_Done,
      // Label 911: @32467
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(32503), // Rule ID 1298 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_wrdsp),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 8114:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (timm:{ *:[i32] })<<P:Predicate_timmZExt7>>:$mask)  =>  (WRDSP_MM GPR32Opnd:{ *:[i32] }:$rt, (timm:{ *:[i32] }):$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::WRDSP_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rt
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1298,
        GIR_EraseRootFromParent_Done,
      // Label 912: @32503
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(32546), // Rule ID 363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7446:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ABSQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 363,
        GIR_EraseRootFromParent_Done,
      // Label 913: @32546
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(32589), // Rule ID 364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7448:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ABSQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 364,
        GIR_EraseRootFromParent_Done,
      // Label 914: @32589
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(32632), // Rule ID 450 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7447:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ABSQ_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 450,
        GIR_EraseRootFromParent_Done,
      // Label 915: @32632
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(32675), // Rule ID 1230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7446:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (ABSQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1230,
        GIR_EraseRootFromParent_Done,
      // Label 916: @32675
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(32718), // Rule ID 1231 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7448:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (ABSQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1231,
        GIR_EraseRootFromParent_Done,
      // Label 917: @32718
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(32761), // Rule ID 1311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7447:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (ABSQ_S_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1311,
        GIR_EraseRootFromParent_Done,
      // Label 918: @32761
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(32804), // Rule ID 417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_eq_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7624:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_EQ_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_EQ_QB),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 417,
        GIR_EraseRootFromParent_Done,
      // Label 919: @32804
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(32847), // Rule ID 418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_lt_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7626:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LT_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_LT_QB),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 418,
        GIR_EraseRootFromParent_Done,
      // Label 920: @32847
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(32890), // Rule ID 419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_le_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7625:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LE_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_LE_QB),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 419,
        GIR_EraseRootFromParent_Done,
      // Label 921: @32890
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(32933), // Rule ID 423 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_eq_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7615:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_EQ_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_EQ_PH),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 423,
        GIR_EraseRootFromParent_Done,
      // Label 922: @32933
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(32976), // Rule ID 424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_lt_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7617:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LT_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_LT_PH),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 424,
        GIR_EraseRootFromParent_Done,
      // Label 923: @32976
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(33019), // Rule ID 425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_le_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7616:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LE_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_LE_PH),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 425,
        GIR_EraseRootFromParent_Done,
      // Label 924: @33019
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(33062), // Rule ID 1302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_eq_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7615:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_EQ_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_EQ_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1302,
        GIR_EraseRootFromParent_Done,
      // Label 925: @33062
      GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(33105), // Rule ID 1303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_lt_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7617:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LT_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_LT_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1303,
        GIR_EraseRootFromParent_Done,
      // Label 926: @33105
      GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(33148), // Rule ID 1304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_le_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7616:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LE_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_LE_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1304,
        GIR_EraseRootFromParent_Done,
      // Label 927: @33148
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(33191), // Rule ID 1308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_eq_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7624:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_EQ_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_EQ_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1308,
        GIR_EraseRootFromParent_Done,
      // Label 928: @33191
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(33234), // Rule ID 1309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_lt_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7626:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LT_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_LT_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1309,
        GIR_EraseRootFromParent_Done,
      // Label 929: @33234
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(33277), // Rule ID 1310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_le_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7625:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LE_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_LE_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1310,
        GIR_EraseRootFromParent_Done,
      // Label 930: @33277
      GIM_Reject,
    // Label 908: @33278
    GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(37403),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(33350), // Rule ID 382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 8002:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHLL_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 382,
        GIR_EraseRootFromParent_Done,
      // Label 932: @33350
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(33414), // Rule ID 387 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[i32] } 8003:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHLL_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 387,
        GIR_EraseRootFromParent_Done,
      // Label 933: @33414
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(33478), // Rule ID 1239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 8002:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHLL_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1239,
        GIR_EraseRootFromParent_Done,
      // Label 934: @33478
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(33542), // Rule ID 1244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[i32] } 8003:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHLL_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1244,
        GIR_EraseRootFromParent_Done,
      // Label 935: @33542
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(33597), // Rule ID 1933 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 8000:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHLL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1933,
        GIR_EraseRootFromParent_Done,
      // Label 936: @33597
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(33652), // Rule ID 1939 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v4i8] } 8001:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHLL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1939,
        GIR_EraseRootFromParent_Done,
      // Label 937: @33652
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(33704), // Rule ID 359 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7455:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 359,
        GIR_EraseRootFromParent_Done,
      // Label 938: @33704
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(33756), // Rule ID 360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 8075:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 360,
        GIR_EraseRootFromParent_Done,
      // Label 939: @33756
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(33808), // Rule ID 367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_rs_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7981:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_RS_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_RS_PH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 367,
        GIR_EraseRootFromParent_Done,
      // Label 940: @33808
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(33860), // Rule ID 368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrqu_s_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7982:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQU_S_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQU_S_QB_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 368,
        GIR_EraseRootFromParent_Done,
      // Label 941: @33860
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(33912), // Rule ID 379 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 8001:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 379,
        GIR_EraseRootFromParent_Done,
      // Label 942: @33912
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(33964), // Rule ID 381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 8000:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 381,
        GIR_EraseRootFromParent_Done,
      // Label 943: @33964
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(34016), // Rule ID 383 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 8002:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 383,
        GIR_EraseRootFromParent_Done,
      // Label 944: @34016
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(34068), // Rule ID 388 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 8003:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 388,
        GIR_EraseRootFromParent_Done,
      // Label 945: @34068
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(34120), // Rule ID 391 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7923:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 391,
        GIR_EraseRootFromParent_Done,
      // Label 946: @34120
      GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(34172), // Rule ID 392 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7924:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 392,
        GIR_EraseRootFromParent_Done,
      // Label 947: @34172
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(34224), // Rule ID 393 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7921:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 393,
        GIR_EraseRootFromParent_Done,
      // Label 948: @34224
      GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(34276), // Rule ID 394 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7922:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 394,
        GIR_EraseRootFromParent_Done,
      // Label 949: @34276
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(34328), // Rule ID 395 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7925:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_RS_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 395,
        GIR_EraseRootFromParent_Done,
      // Label 950: @34328
      GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(34377), // Rule ID 420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_eq_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7621:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_EQ_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_EQ_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 420,
        GIR_EraseRootFromParent_Done,
      // Label 951: @34377
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(34426), // Rule ID 421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_lt_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7623:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LT_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LT_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 421,
        GIR_EraseRootFromParent_Done,
      // Label 952: @34426
      GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(34475), // Rule ID 422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_le_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7622:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LE_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LE_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 422,
        GIR_EraseRootFromParent_Done,
      // Label 953: @34475
      GIM_Try, /*On fail goto*//*Label 954*/ GIMT_Encode4(34524), // Rule ID 432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7965:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PICK_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PICK_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 432,
        GIR_EraseRootFromParent_Done,
      // Label 954: @34524
      GIM_Try, /*On fail goto*//*Label 955*/ GIMT_Encode4(34573), // Rule ID 433 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7964:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PICK_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PICK_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 433,
        GIR_EraseRootFromParent_Done,
      // Label 955: @34573
      GIM_Try, /*On fail goto*//*Label 956*/ GIMT_Encode4(34622), // Rule ID 437 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_insv),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7823:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)  =>  (INSV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::INSV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 437,
        GIR_EraseRootFromParent_Done,
      // Label 956: @34622
      GIM_Try, /*On fail goto*//*Label 957*/ GIMT_Encode4(34674), // Rule ID 443 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7473:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 443,
        GIR_EraseRootFromParent_Done,
      // Label 957: @34674
      GIM_Try, /*On fail goto*//*Label 958*/ GIMT_Encode4(34726), // Rule ID 444 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7475:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 444,
        GIR_EraseRootFromParent_Done,
      // Label 958: @34726
      GIM_Try, /*On fail goto*//*Label 959*/ GIMT_Encode4(34778), // Rule ID 445 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 8096:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 445,
        GIR_EraseRootFromParent_Done,
      // Label 959: @34778
      GIM_Try, /*On fail goto*//*Label 960*/ GIMT_Encode4(34830), // Rule ID 446 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 8098:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 446,
        GIR_EraseRootFromParent_Done,
      // Label 960: @34830
      GIM_Try, /*On fail goto*//*Label 961*/ GIMT_Encode4(34882), // Rule ID 447 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_eq_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7618:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_EQ_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_EQ_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 447,
        GIR_EraseRootFromParent_Done,
      // Label 961: @34882
      GIM_Try, /*On fail goto*//*Label 962*/ GIMT_Encode4(34934), // Rule ID 448 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_lt_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7620:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LT_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LT_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 448,
        GIR_EraseRootFromParent_Done,
      // Label 962: @34934
      GIM_Try, /*On fail goto*//*Label 963*/ GIMT_Encode4(34986), // Rule ID 449 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_le_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7619:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LE_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LE_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 449,
        GIR_EraseRootFromParent_Done,
      // Label 963: @34986
      GIM_Try, /*On fail goto*//*Label 964*/ GIMT_Encode4(35038), // Rule ID 463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7920:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MUL_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 463,
        GIR_EraseRootFromParent_Done,
      // Label 964: @35038
      GIM_Try, /*On fail goto*//*Label 965*/ GIMT_Encode4(35090), // Rule ID 464 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7928:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 464,
        GIR_EraseRootFromParent_Done,
      // Label 965: @35090
      GIM_Try, /*On fail goto*//*Label 966*/ GIMT_Encode4(35142), // Rule ID 465 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7926:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_RS_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 465,
        GIR_EraseRootFromParent_Done,
      // Label 966: @35142
      GIM_Try, /*On fail goto*//*Label 967*/ GIMT_Encode4(35194), // Rule ID 466 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7927:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 466,
        GIR_EraseRootFromParent_Done,
      // Label 967: @35194
      GIM_Try, /*On fail goto*//*Label 968*/ GIMT_Encode4(35243), // Rule ID 476 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7976:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECR_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_QB_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 476,
        GIR_EraseRootFromParent_Done,
      // Label 968: @35243
      GIM_Try, /*On fail goto*//*Label 969*/ GIMT_Encode4(35295), // Rule ID 1224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7455:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1224,
        GIR_EraseRootFromParent_Done,
      // Label 969: @35295
      GIM_Try, /*On fail goto*//*Label 970*/ GIMT_Encode4(35344), // Rule ID 1232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_insv),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7823:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)  =>  (INSV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::INSV_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1232,
        GIR_EraseRootFromParent_Done,
      // Label 970: @35344
      GIM_Try, /*On fail goto*//*Label 971*/ GIMT_Encode4(35396), // Rule ID 1240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 8000:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1240,
        GIR_EraseRootFromParent_Done,
      // Label 971: @35396
      GIM_Try, /*On fail goto*//*Label 972*/ GIMT_Encode4(35448), // Rule ID 1241 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 8002:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1241,
        GIR_EraseRootFromParent_Done,
      // Label 972: @35448
      GIM_Try, /*On fail goto*//*Label 973*/ GIMT_Encode4(35500), // Rule ID 1242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 8001:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1242,
        GIR_EraseRootFromParent_Done,
      // Label 973: @35500
      GIM_Try, /*On fail goto*//*Label 974*/ GIMT_Encode4(35552), // Rule ID 1243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 8003:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1243,
        GIR_EraseRootFromParent_Done,
      // Label 974: @35552
      GIM_Try, /*On fail goto*//*Label 975*/ GIMT_Encode4(35604), // Rule ID 1262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 8075:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1262,
        GIR_EraseRootFromParent_Done,
      // Label 975: @35604
      GIM_Try, /*On fail goto*//*Label 976*/ GIMT_Encode4(35656), // Rule ID 1268 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7921:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1268,
        GIR_EraseRootFromParent_Done,
      // Label 976: @35656
      GIM_Try, /*On fail goto*//*Label 977*/ GIMT_Encode4(35708), // Rule ID 1269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7922:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1269,
        GIR_EraseRootFromParent_Done,
      // Label 977: @35708
      GIM_Try, /*On fail goto*//*Label 978*/ GIMT_Encode4(35760), // Rule ID 1270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7923:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1270,
        GIR_EraseRootFromParent_Done,
      // Label 978: @35760
      GIM_Try, /*On fail goto*//*Label 979*/ GIMT_Encode4(35812), // Rule ID 1271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7924:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1271,
        GIR_EraseRootFromParent_Done,
      // Label 979: @35812
      GIM_Try, /*On fail goto*//*Label 980*/ GIMT_Encode4(35864), // Rule ID 1272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7925:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_RS_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1272,
        GIR_EraseRootFromParent_Done,
      // Label 980: @35864
      GIM_Try, /*On fail goto*//*Label 981*/ GIMT_Encode4(35916), // Rule ID 1275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrqu_s_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7982:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQU_S_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQU_S_QB_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1275,
        GIR_EraseRootFromParent_Done,
      // Label 981: @35916
      GIM_Try, /*On fail goto*//*Label 982*/ GIMT_Encode4(35968), // Rule ID 1276 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_rs_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7981:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_RS_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_RS_PH_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1276,
        GIR_EraseRootFromParent_Done,
      // Label 982: @35968
      GIM_Try, /*On fail goto*//*Label 983*/ GIMT_Encode4(36017), // Rule ID 1294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7964:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PICK_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PICK_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1294,
        GIR_EraseRootFromParent_Done,
      // Label 983: @36017
      GIM_Try, /*On fail goto*//*Label 984*/ GIMT_Encode4(36066), // Rule ID 1295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7965:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PICK_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PICK_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1295,
        GIR_EraseRootFromParent_Done,
      // Label 984: @36066
      GIM_Try, /*On fail goto*//*Label 985*/ GIMT_Encode4(36115), // Rule ID 1305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_eq_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7621:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_EQ_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_EQ_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1305,
        GIR_EraseRootFromParent_Done,
      // Label 985: @36115
      GIM_Try, /*On fail goto*//*Label 986*/ GIMT_Encode4(36164), // Rule ID 1306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_lt_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7623:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LT_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LT_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1306,
        GIR_EraseRootFromParent_Done,
      // Label 986: @36164
      GIM_Try, /*On fail goto*//*Label 987*/ GIMT_Encode4(36213), // Rule ID 1307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_le_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7622:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LE_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LE_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1307,
        GIR_EraseRootFromParent_Done,
      // Label 987: @36213
      GIM_Try, /*On fail goto*//*Label 988*/ GIMT_Encode4(36265), // Rule ID 1316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7473:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1316,
        GIR_EraseRootFromParent_Done,
      // Label 988: @36265
      GIM_Try, /*On fail goto*//*Label 989*/ GIMT_Encode4(36317), // Rule ID 1317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7475:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1317,
        GIR_EraseRootFromParent_Done,
      // Label 989: @36317
      GIM_Try, /*On fail goto*//*Label 990*/ GIMT_Encode4(36369), // Rule ID 1328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_eq_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7618:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_EQ_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_EQ_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1328,
        GIR_EraseRootFromParent_Done,
      // Label 990: @36369
      GIM_Try, /*On fail goto*//*Label 991*/ GIMT_Encode4(36421), // Rule ID 1329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_lt_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7620:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LT_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LT_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1329,
        GIR_EraseRootFromParent_Done,
      // Label 991: @36421
      GIM_Try, /*On fail goto*//*Label 992*/ GIMT_Encode4(36473), // Rule ID 1330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_le_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7619:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LE_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LE_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1330,
        GIR_EraseRootFromParent_Done,
      // Label 992: @36473
      GIM_Try, /*On fail goto*//*Label 993*/ GIMT_Encode4(36525), // Rule ID 1336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 8096:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1336,
        GIR_EraseRootFromParent_Done,
      // Label 993: @36525
      GIM_Try, /*On fail goto*//*Label 994*/ GIMT_Encode4(36577), // Rule ID 1337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 8098:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1337,
        GIR_EraseRootFromParent_Done,
      // Label 994: @36577
      GIM_Try, /*On fail goto*//*Label 995*/ GIMT_Encode4(36629), // Rule ID 1344 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7920:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MUL_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_S_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1344,
        GIR_EraseRootFromParent_Done,
      // Label 995: @36629
      GIM_Try, /*On fail goto*//*Label 996*/ GIMT_Encode4(36681), // Rule ID 1345 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7926:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_RS_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1345,
        GIR_EraseRootFromParent_Done,
      // Label 996: @36681
      GIM_Try, /*On fail goto*//*Label 997*/ GIMT_Encode4(36733), // Rule ID 1346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7927:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1346,
        GIR_EraseRootFromParent_Done,
      // Label 997: @36733
      GIM_Try, /*On fail goto*//*Label 998*/ GIMT_Encode4(36785), // Rule ID 1347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7928:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_S_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1347,
        GIR_EraseRootFromParent_Done,
      // Label 998: @36785
      GIM_Try, /*On fail goto*//*Label 999*/ GIMT_Encode4(36834), // Rule ID 1348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7976:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECR_QB_PH_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_QB_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1348,
        GIR_EraseRootFromParent_Done,
      // Label 999: @36834
      GIM_Try, /*On fail goto*//*Label 1000*/ GIMT_Encode4(36878), // Rule ID 1920 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7917:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1920,
        GIR_EraseRootFromParent_Done,
      // Label 1000: @36878
      GIM_Try, /*On fail goto*//*Label 1001*/ GIMT_Encode4(36922), // Rule ID 1926 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addsc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7472:{ *:[iPTR] }, i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)  =>  (ADDSC:{ *:[i32] } i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDSC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCarry*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1926,
        GIR_EraseRootFromParent_Done,
      // Label 1001: @36922
      GIM_Try, /*On fail goto*//*Label 1002*/ GIMT_Encode4(36966), // Rule ID 1928 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addwc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7487:{ *:[iPTR] }, i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)  =>  (ADDWC:{ *:[i32] } i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDWC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1928,
        GIR_EraseRootFromParent_Done,
      // Label 1002: @36966
      GIM_Try, /*On fail goto*//*Label 1003*/ GIMT_Encode4(37012), // Rule ID 487 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ldr_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i64] } 7837:{ *:[iPTR] }, iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$imm)  =>  (LDR_D:{ *:[v2i64] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LDR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // ptr
        GIR_RootToRootCopy, /*OpIdx*/3, // imm
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 487,
        GIR_EraseRootFromParent_Done,
      // Label 1003: @37012
      GIM_Try, /*On fail goto*//*Label 1004*/ GIMT_Encode4(37058), // Rule ID 488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ldr_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v4i32] } 7838:{ *:[iPTR] }, iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$imm)  =>  (LDR_W:{ *:[v4i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LDR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // ptr
        GIR_RootToRootCopy, /*OpIdx*/3, // imm
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 488,
        GIR_EraseRootFromParent_Done,
      // Label 1004: @37058
      GIM_Try, /*On fail goto*//*Label 1005*/ GIMT_Encode4(37100), // Rule ID 434 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_lwx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] base
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/0,
        // (intrinsic_w_chain:{ *:[i32] } 7841:{ *:[iPTR] }, iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)  =>  (LWX:{ *:[i32] } iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LWX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // base
        GIR_RootToRootCopy, /*OpIdx*/3, // index
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 434,
        GIR_EraseRootFromParent_Done,
      // Label 1005: @37100
      GIM_Try, /*On fail goto*//*Label 1006*/ GIMT_Encode4(37142), // Rule ID 435 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_lhx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] base
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/0,
        // (intrinsic_w_chain:{ *:[i32] } 7839:{ *:[iPTR] }, iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)  =>  (LHX:{ *:[i32] } iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LHX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // base
        GIR_RootToRootCopy, /*OpIdx*/3, // index
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 435,
        GIR_EraseRootFromParent_Done,
      // Label 1006: @37142
      GIM_Try, /*On fail goto*//*Label 1007*/ GIMT_Encode4(37184), // Rule ID 436 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_lbux),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] base
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/0,
        // (intrinsic_w_chain:{ *:[i32] } 7828:{ *:[iPTR] }, iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)  =>  (LBUX:{ *:[i32] } iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LBUX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // base
        GIR_RootToRootCopy, /*OpIdx*/3, // index
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 436,
        GIR_EraseRootFromParent_Done,
      // Label 1007: @37184
      GIM_Try, /*On fail goto*//*Label 1008*/ GIMT_Encode4(37226), // Rule ID 1277 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_lbux),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] base
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/0,
        // (intrinsic_w_chain:{ *:[i32] } 7828:{ *:[iPTR] }, iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)  =>  (LBUX_MM:{ *:[i32] } iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LBUX_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // base
        GIR_RootToRootCopy, /*OpIdx*/3, // index
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1277,
        GIR_EraseRootFromParent_Done,
      // Label 1008: @37226
      GIM_Try, /*On fail goto*//*Label 1009*/ GIMT_Encode4(37268), // Rule ID 1278 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_lhx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] base
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/0,
        // (intrinsic_w_chain:{ *:[i32] } 7839:{ *:[iPTR] }, iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)  =>  (LHX_MM:{ *:[i32] } iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LHX_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // base
        GIR_RootToRootCopy, /*OpIdx*/3, // index
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1278,
        GIR_EraseRootFromParent_Done,
      // Label 1009: @37268
      GIM_Try, /*On fail goto*//*Label 1010*/ GIMT_Encode4(37310), // Rule ID 1279 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_lwx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] base
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/0,
        // (intrinsic_w_chain:{ *:[i32] } 7841:{ *:[iPTR] }, iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)  =>  (LWX_MM:{ *:[i32] } iPTR:{ *:[iPTR] }:$base, iPTR:{ *:[i32] }:$index)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LWX_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // base
        GIR_RootToRootCopy, /*OpIdx*/3, // index
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1279,
        GIR_EraseRootFromParent_Done,
      // Label 1010: @37310
      GIM_Try, /*On fail goto*//*Label 1011*/ GIMT_Encode4(37356), // Rule ID 489 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_str_d),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_void 8071:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$dst, iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$imm)  =>  (STR_D MSA128DOpnd:{ *:[v2i64] }:$dst, iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::STR_D),
        GIR_RootToRootCopy, /*OpIdx*/1, // dst
        GIR_RootToRootCopy, /*OpIdx*/2, // ptr
        GIR_RootToRootCopy, /*OpIdx*/3, // imm
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 489,
        GIR_EraseRootFromParent_Done,
      // Label 1011: @37356
      GIM_Try, /*On fail goto*//*Label 1012*/ GIMT_Encode4(37402), // Rule ID 490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_str_w),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] ptr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_void 8072:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$dst, iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$imm)  =>  (STR_W MSA128WOpnd:{ *:[v4i32] }:$dst, iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::STR_W),
        GIR_RootToRootCopy, /*OpIdx*/1, // dst
        GIR_RootToRootCopy, /*OpIdx*/2, // ptr
        GIR_RootToRootCopy, /*OpIdx*/3, // imm
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 490,
        GIR_EraseRootFromParent_Done,
      // Label 1012: @37402
      GIM_Reject,
    // Label 931: @37403
    GIM_Reject,
    // Label 31: @37404
    GIM_Try, /*On fail goto*//*Label 1013*/ GIMT_Encode4(37469), // Rule ID 1580 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (anyext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$src, sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
      // GIR_Coverage, 1580,
      GIR_EraseRootFromParent_Done,
    // Label 1013: @37469
    GIM_Reject,
    // Label 32: @37470
    GIM_Try, /*On fail goto*//*Label 1014*/ GIMT_Encode4(37533), // Rule ID 1573 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$src)  =>  (SLL:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$src, sub_32:{ *:[i32] }), 0:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLL),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1573,
      GIR_EraseRootFromParent_Done,
    // Label 1014: @37533
    GIM_Reject,
    // Label 33: @37534
    GIM_Try, /*On fail goto*//*Label 1015*/ GIMT_Encode4(37594),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1016*/ GIMT_Encode4(37568), // Rule ID 2151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immLi16),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // MIs[0] Operand 1
        // No operand predicates
        // (imm:{ *:[i32] })<<P:Predicate_immLi16>>:$imm  =>  (LI16_MM:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_immLi16>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LI16_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2151,
        GIR_EraseRootFromParent_Done,
      // Label 1016: @37568
      GIM_Try, /*On fail goto*//*Label 1017*/ GIMT_Encode4(37593), // Rule ID 1844 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // MIs[0] Operand 1
        // No operand predicates
        // (imm:{ *:[i32] }):$imm  =>  (LwConstant32:{ *:[i32] } (imm:{ *:[i32] }):$imm, -1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LwConstant32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rx]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1844,
        GIR_EraseRootFromParent_Done,
      // Label 1017: @37593
      GIM_Reject,
    // Label 1015: @37594
    GIM_Reject,
    // Label 34: @37595
    GIM_Try, /*On fail goto*//*Label 1018*/ GIMT_Encode4(39058),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 1019*/ GIMT_Encode4(37715), // Rule ID 1626 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sext:{ *:[i64] } (sra:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRA:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SRA),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1626,
        GIR_EraseRootFromParent_Done,
      // Label 1019: @37715
      GIM_Try, /*On fail goto*//*Label 1020*/ GIMT_Encode4(37820), // Rule ID 1622 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sext:{ *:[i64] } (srl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRL:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SRL),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1622,
        GIR_EraseRootFromParent_Done,
      // Label 1020: @37820
      GIM_Try, /*On fail goto*//*Label 1021*/ GIMT_Encode4(37925), // Rule ID 1618 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sext:{ *:[i64] } (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SLL:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SLL),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegI