/* user-dict.c generated by valac 0.56.17, the Vala compiler
 * generated from user-dict.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libskk/libskk.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
enum  {
	SKK_USER_DICT_0_PROPERTY,
	SKK_USER_DICT_READ_ONLY_PROPERTY,
	SKK_USER_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_user_dict_properties[SKK_USER_DICT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SKK_TYPE_SKK_DICT_ERROR (skk_skk_dict_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _SkkUserDictPrivate {
	GFile* file;
	gchar* etag;
	SkkEncodingConverter* converter;
	GeeMap* okuri_ari_entries;
	GeeMap* okuri_nasi_entries;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gint SkkUserDict_private_offset;
static gpointer skk_user_dict_parent_class = NULL;

VALA_EXTERN GType skk_encoding_converter_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GQuark skk_skk_dict_error_quark (void);
VALA_EXTERN GType skk_skk_dict_error_get_type (void) G_GNUC_CONST ;
static void skk_user_dict_load (SkkUserDict* self,
                         GError** error);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
VALA_EXTERN gchar* skk_encoding_converter_extract_coding_system (const gchar* line);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_new_from_coding_system (const gchar* coding,
                                                                     GError** error);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_construct_from_coding_system (GType object_type,
                                                                           const gchar* coding,
                                                                           GError** error);
VALA_EXTERN gchar* skk_encoding_converter_decode (SkkEncodingConverter* self,
                                      const gchar* external_str,
                                      GError** error);
static void skk_user_dict_real_reload (SkkDict* base,
                                GError** error);
static gint skk_user_dict_compare_entry_asc (GeeMapEntry* a,
                                      GeeMapEntry* b);
static gint skk_user_dict_compare_entry_dsc (GeeMapEntry* a,
                                      GeeMapEntry* b);
static void skk_user_dict_write_entries (SkkUserDict* self,
                                  GString* builder,
                                  GeeList* entries);
static void skk_user_dict_real_save (SkkDict* base,
                              GError** error);
VALA_EXTERN gchar* skk_encoding_converter_get_coding_system (SkkEncodingConverter* self);
VALA_EXTERN gchar* skk_encoding_converter_encode (SkkEncodingConverter* self,
                                      const gchar* internal_str,
                                      GError** error);
static GeeMap* skk_user_dict_get_entries (SkkUserDict* self,
                                   gboolean okuri);
static SkkCandidate** skk_user_dict_real_lookup (SkkDict* base,
                                          const gchar* midasi,
                                          gboolean okuri,
                                          gint* result_length1);
static gchar** skk_user_dict_real_complete (SkkDict* base,
                                     const gchar* midasi,
                                     gint* result_length1);
static gboolean skk_user_dict_real_select_candidate (SkkDict* base,
                                              SkkCandidate* candidate);
static gboolean skk_user_dict_real_purge_candidate (SkkDict* base,
                                             SkkCandidate* candidate);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding,
                                                  GError** error);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_construct (GType object_type,
                                                        const gchar* encoding,
                                                        GError** error);
static void skk_user_dict_finalize (GObject * obj);
static GType skk_user_dict_get_type_once (void);
static void _vala_skk_user_dict_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
skk_user_dict_get_instance_private (SkkUserDict* self)
{
	return G_STRUCT_MEMBER_P (self, SkkUserDict_private_offset);
}

static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
skk_user_dict_load (SkkUserDict* self,
                    GError** error)
{
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	GMemoryInputStream* memory = NULL;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	GDestroyNotify _tmp7_;
	GMemoryInputStream* _tmp8_;
	GDataInputStream* data = NULL;
	GMemoryInputStream* _tmp9_;
	GDataInputStream* _tmp10_;
	gchar* line = NULL;
	gsize length = 0UL;
	gchar* _tmp11_ = NULL;
	GDataInputStream* _tmp12_;
	gsize _tmp13_ = 0UL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* coding = NULL;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	GeeMap* entries = NULL;
	GeeMap* _tmp44_;
	gboolean okuri = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* _tmp0_;
		guint8* _tmp1_ = NULL;
		gsize _tmp2_ = 0;
		gchar* _tmp3_ = NULL;
		_tmp0_ = self->priv->file;
		g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error0_);
		contents = (g_free (contents), NULL);
		contents = _tmp1_;
		contents_length1 = _tmp2_;
		_contents_size_ = contents_length1;
		_g_free0 (self->priv->etag);
		self->priv->etag = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _tmp4_;
		g_clear_error (&_inner_error0_);
		_tmp4_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_NOT_READABLE, "can't load contents");
		_inner_error0_ = _tmp4_;
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == SKK_SKK_DICT_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			contents = (g_free (contents), NULL);
			return;
		} else {
			contents = (g_free (contents), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = contents;
	_tmp5__length1 = contents_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = g_free;
	_tmp8_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp6_, _tmp6__length1, _tmp7_);
	memory = _tmp8_;
	_tmp9_ = memory;
	_tmp10_ = g_data_input_stream_new ((GInputStream*) _tmp9_);
	data = _tmp10_;
	line = NULL;
	_tmp12_ = data;
	_tmp14_ = g_data_input_stream_read_line (_tmp12_, &_tmp13_, NULL, &_inner_error0_);
	length = _tmp13_;
	_tmp11_ = _tmp14_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == SKK_SKK_DICT_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		} else {
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp15_ = _tmp11_;
	_tmp11_ = NULL;
	_g_free0 (line);
	line = _tmp15_;
	_tmp16_ = line;
	if (_tmp16_ == NULL) {
		_g_free0 (_tmp11_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	_tmp17_ = line;
	_tmp18_ = skk_encoding_converter_extract_coding_system (_tmp17_);
	coding = _tmp18_;
	_tmp19_ = coding;
	if (_tmp19_ != NULL) {
		gchar* _tmp28_ = NULL;
		GDataInputStream* _tmp29_;
		gsize _tmp30_ = 0UL;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		{
			SkkEncodingConverter* _converter = NULL;
			const gchar* _tmp20_;
			SkkEncodingConverter* _tmp21_;
			SkkEncodingConverter* _tmp22_;
			_tmp20_ = coding;
			_tmp21_ = skk_encoding_converter_new_from_coding_system (_tmp20_, &_inner_error0_);
			_converter = _tmp21_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp22_ = _converter;
			if (_tmp22_ != NULL) {
				SkkEncodingConverter* _tmp23_;
				SkkEncodingConverter* _tmp24_;
				_tmp23_ = _converter;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				_g_object_unref0 (self->priv->converter);
				self->priv->converter = _tmp24_;
			}
			_g_object_unref0 (_converter);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp25_;
			GError* _tmp26_;
			const gchar* _tmp27_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp25_ = coding;
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			g_warning ("user-dict.vala:51: can't create converter from coding system %s: %s", _tmp25_, _tmp27_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == SKK_SKK_DICT_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp29_ = data;
		_tmp31_ = g_data_input_stream_read_line (_tmp29_, &_tmp30_, NULL, &_inner_error0_);
		length = _tmp30_;
		_tmp28_ = _tmp31_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == SKK_SKK_DICT_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp32_ = _tmp28_;
		_tmp28_ = NULL;
		_g_free0 (line);
		line = _tmp32_;
		_tmp33_ = line;
		if (_tmp33_ == NULL) {
			_g_free0 (_tmp28_);
			_g_free0 (coding);
			_g_free0 (_tmp11_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_g_free0 (_tmp28_);
	}
	entries = NULL;
	while (TRUE) {
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp38_ = NULL;
		GDataInputStream* _tmp39_;
		gsize _tmp40_ = 0UL;
		gchar* _tmp41_;
		gchar* _tmp42_;
		const gchar* _tmp43_;
		_tmp34_ = line;
		if (!(_tmp34_ != NULL)) {
			break;
		}
		_tmp35_ = line;
		if (g_str_has_prefix (_tmp35_, ";; okuri-ari entries.")) {
			GeeMap* _tmp36_;
			GeeMap* _tmp37_;
			_tmp36_ = self->priv->okuri_ari_entries;
			_tmp37_ = _g_object_ref0 (_tmp36_);
			_g_object_unref0 (entries);
			entries = _tmp37_;
			break;
		}
		_tmp39_ = data;
		_tmp41_ = g_data_input_stream_read_line (_tmp39_, &_tmp40_, NULL, &_inner_error0_);
		length = _tmp40_;
		_tmp38_ = _tmp41_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == SKK_SKK_DICT_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp42_ = _tmp38_;
		_tmp38_ = NULL;
		_g_free0 (line);
		line = _tmp42_;
		_tmp43_ = line;
		if (_tmp43_ == NULL) {
			_g_free0 (_tmp38_);
			break;
		}
		_g_free0 (_tmp38_);
	}
	_tmp44_ = entries;
	if (_tmp44_ == NULL) {
		GError* _tmp45_;
		_tmp45_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
		_inner_error0_ = _tmp45_;
		if ((_inner_error0_->domain == SKK_SKK_DICT_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (entries);
			_g_free0 (coding);
			_g_free0 (_tmp11_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		} else {
			_g_object_unref0 (entries);
			_g_free0 (coding);
			_g_free0 (_tmp11_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	okuri = TRUE;
	while (TRUE) {
		const gchar* _tmp46_;
		gchar* _tmp47_ = NULL;
		GDataInputStream* _tmp48_;
		gsize _tmp49_ = 0UL;
		gchar* _tmp50_;
		gchar* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		gint index = 0;
		const gchar* _tmp65_;
		gchar* midasi = NULL;
		const gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* candidates_str = NULL;
		const gchar* _tmp70_;
		const gchar* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gchar* _tmp74_;
		gboolean _tmp75_ = FALSE;
		const gchar* _tmp76_;
		SkkCandidate** candidates = NULL;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		gint _tmp82_ = 0;
		SkkCandidate** _tmp83_;
		gint candidates_length1;
		gint _candidates_size_;
		GeeArrayList* list = NULL;
		GeeArrayList* _tmp84_;
		SkkCandidate** _tmp85_;
		gint _tmp85__length1;
		GeeMap* _tmp89_;
		const gchar* _tmp90_;
		GeeArrayList* _tmp91_;
		_tmp46_ = line;
		if (!(_tmp46_ != NULL)) {
			break;
		}
		_tmp48_ = data;
		_tmp50_ = g_data_input_stream_read_line (_tmp48_, &_tmp49_, NULL, &_inner_error0_);
		length = _tmp49_;
		_tmp47_ = _tmp50_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == SKK_SKK_DICT_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp51_ = _tmp47_;
		_tmp47_ = NULL;
		_g_free0 (line);
		line = _tmp51_;
		_tmp52_ = line;
		if (_tmp52_ == NULL) {
			_g_free0 (_tmp47_);
			break;
		}
		_tmp53_ = line;
		if (g_str_has_prefix (_tmp53_, ";; okuri-nasi entries.")) {
			GeeMap* _tmp54_;
			GeeMap* _tmp55_;
			_tmp54_ = self->priv->okuri_nasi_entries;
			_tmp55_ = _g_object_ref0 (_tmp54_);
			_g_object_unref0 (entries);
			entries = _tmp55_;
			okuri = FALSE;
			_g_free0 (_tmp47_);
			continue;
		}
		{
			gchar* _tmp56_ = NULL;
			SkkEncodingConverter* _tmp57_;
			const gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp57_ = self->priv->converter;
			_tmp58_ = line;
			_tmp59_ = skk_encoding_converter_decode (_tmp57_, _tmp58_, &_inner_error0_);
			_tmp56_ = _tmp59_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp60_ = _tmp56_;
			_tmp56_ = NULL;
			_g_free0 (line);
			line = _tmp60_;
			_g_free0 (_tmp56_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp61_;
			GError* _tmp62_;
			const gchar* _tmp63_;
			GError* _tmp64_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp61_ = line;
			_tmp62_ = e;
			_tmp63_ = _tmp62_->message;
			_tmp64_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't decode line %s: %s", _tmp61_, _tmp63_);
			_inner_error0_ = _tmp64_;
			_g_error_free0 (e);
			goto __finally2;
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == SKK_SKK_DICT_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp47_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (_tmp47_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp65_ = line;
		index = string_index_of (_tmp65_, " ", 0);
		if (index < 1) {
			const gchar* _tmp66_;
			GError* _tmp67_;
			_tmp66_ = line;
			_tmp67_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't extract midasi from line %s", _tmp66_);
			_inner_error0_ = _tmp67_;
			if ((_inner_error0_->domain == SKK_SKK_DICT_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp47_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (_tmp47_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp68_ = line;
		_tmp69_ = string_slice (_tmp68_, (glong) 0, (glong) index);
		midasi = _tmp69_;
		_tmp70_ = line;
		_tmp71_ = line;
		_tmp72_ = strlen (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = string_slice (_tmp70_, (glong) (index + 1), (glong) _tmp73_);
		candidates_str = _tmp74_;
		_tmp76_ = candidates_str;
		if (!g_str_has_prefix (_tmp76_, "/")) {
			_tmp75_ = TRUE;
		} else {
			const gchar* _tmp77_;
			_tmp77_ = candidates_str;
			_tmp75_ = !g_str_has_suffix (_tmp77_, "/");
		}
		if (_tmp75_) {
			const gchar* _tmp78_;
			GError* _tmp79_;
			_tmp78_ = candidates_str;
			_tmp79_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't parse candidates list %s", _tmp78_);
			_inner_error0_ = _tmp79_;
			if ((_inner_error0_->domain == SKK_SKK_DICT_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (candidates_str);
				_g_free0 (midasi);
				_g_free0 (_tmp47_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (candidates_str);
				_g_free0 (midasi);
				_g_free0 (_tmp47_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp80_ = midasi;
		_tmp81_ = candidates_str;
		_tmp83_ = skk_dict_split_candidates ((SkkDict*) self, _tmp80_, okuri, _tmp81_, &_tmp82_);
		candidates = _tmp83_;
		candidates_length1 = _tmp82_;
		_candidates_size_ = candidates_length1;
		_tmp84_ = gee_array_list_new (SKK_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		list = _tmp84_;
		_tmp85_ = candidates;
		_tmp85__length1 = candidates_length1;
		{
			SkkCandidate** c_collection = NULL;
			gint c_collection_length1 = 0;
			gint _c_collection_size_ = 0;
			gint c_it = 0;
			c_collection = _tmp85_;
			c_collection_length1 = _tmp85__length1;
			for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
				SkkCandidate* _tmp86_;
				SkkCandidate* c = NULL;
				_tmp86_ = _g_object_ref0 (c_collection[c_it]);
				c = _tmp86_;
				{
					GeeArrayList* _tmp87_;
					SkkCandidate* _tmp88_;
					_tmp87_ = list;
					_tmp88_ = c;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp87_, _tmp88_);
					_g_object_unref0 (c);
				}
			}
		}
		_tmp89_ = entries;
		_tmp90_ = midasi;
		_tmp91_ = list;
		gee_map_set (_tmp89_, _tmp90_, (GeeList*) _tmp91_);
		_g_object_unref0 (list);
		candidates = (_vala_array_free (candidates, candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (candidates_str);
		_g_free0 (midasi);
		_g_free0 (_tmp47_);
	}
	_g_object_unref0 (entries);
	_g_free0 (coding);
	_g_free0 (_tmp11_);
	_g_free0 (line);
	_g_object_unref0 (data);
	_g_object_unref0 (memory);
	contents = (g_free (contents), NULL);
}

/**
         * {@inheritDoc}
         */
static void
skk_user_dict_real_reload (SkkDict* base,
                           GError** error)
{
	SkkUserDict * self;
	gchar* attributes = NULL;
	gchar* _tmp0_;
	GFileInfo* info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (SkkUserDict*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_query_info (_tmp1_, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	info = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (attributes);
		return;
	}
	_tmp3_ = g_file_info_get_etag (info);
	_tmp4_ = self->priv->etag;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		GeeMap* _tmp5_;
		GeeMap* _tmp6_;
		_tmp5_ = self->priv->okuri_ari_entries;
		gee_map_clear (_tmp5_);
		_tmp6_ = self->priv->okuri_nasi_entries;
		gee_map_clear (_tmp6_);
		{
			skk_user_dict_load (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
					goto __catch0_skk_skk_dict_error;
				}
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				_g_object_unref0 (info);
				_g_free0 (attributes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_skk_skk_dict_error:
		{
			GError* e = NULL;
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = self->priv->file;
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("user-dict.vala:138: error parsing user dictionary %s: %s", _tmp9_, _tmp11_);
			_g_free0 (_tmp9_);
			_g_error_free0 (e);
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			GError* e = NULL;
			GFile* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = self->priv->file;
			_tmp13_ = g_file_get_path (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_warning ("user-dict.vala:141: error reading user dictionary %s: %s", _tmp14_, _tmp16_);
			_g_free0 (_tmp14_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}

static gint
skk_user_dict_compare_entry_asc (GeeMapEntry* a,
                                 GeeMapEntry* b)
{
	GCompareFunc _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	gconstpointer _tmp4_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = gee_map_entry_get_key (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_map_entry_get_key (b);
	_tmp4_ = _tmp3_;
	result = _tmp0_ ((const gchar*) _tmp2_, (const gchar*) _tmp4_);
	return result;
}

static gint
skk_user_dict_compare_entry_dsc (GeeMapEntry* a,
                                 GeeMapEntry* b)
{
	GCompareFunc _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	gconstpointer _tmp4_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = gee_map_entry_get_key (b);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_map_entry_get_key (a);
	_tmp4_ = _tmp3_;
	result = _tmp0_ ((const gchar*) _tmp2_, (const gchar*) _tmp4_);
	return result;
}

static void
skk_user_dict_write_entries (SkkUserDict* self,
                             GString* builder,
                             GeeList* entries)
{
	GeeIterator* iter = NULL;
	GeeIterator* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (entries != NULL);
	_tmp0_ = gee_iterable_iterator ((GeeIterable*) entries);
	iter = _tmp0_;
	while (TRUE) {
		GeeIterator* _tmp1_;
		GeeMapEntry* entry = NULL;
		GeeIterator* _tmp2_;
		gpointer _tmp3_;
		gchar* line = NULL;
		GeeMapEntry* _tmp4_;
		gconstpointer _tmp5_;
		gconstpointer _tmp6_;
		GeeMapEntry* _tmp7_;
		gconstpointer _tmp8_;
		gconstpointer _tmp9_;
		gint _tmp10_ = 0;
		gpointer* _tmp11_;
		SkkCandidate** _tmp12_;
		gint _tmp12__length1;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp1_ = iter;
		if (!gee_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = iter;
		_tmp3_ = gee_iterator_get (_tmp2_);
		entry = (GeeMapEntry*) _tmp3_;
		_tmp4_ = entry;
		_tmp5_ = gee_map_entry_get_key (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = entry;
		_tmp8_ = gee_map_entry_get_value (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp11_ = gee_collection_to_array ((GeeCollection*) ((GeeList*) _tmp9_), &_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = _tmp10_;
		_tmp13_ = skk_dict_join_candidates ((SkkDict*) self, _tmp12_, (gint) _tmp10_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf ("%s %s\n", (const gchar*) _tmp6_, _tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_object_unref), NULL);
		line = _tmp16_;
		_tmp17_ = line;
		g_string_append (builder, _tmp17_);
		_g_free0 (line);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (iter);
}

/**
         * {@inheritDoc}
         */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
skk_user_dict_real_save (SkkDict* base,
                         GError** error)
{
	SkkUserDict * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gchar* coding = NULL;
	SkkEncodingConverter* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp8_;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeMap* _tmp11_;
	GeeSet* _tmp12_;
	GeeSet* _tmp13_;
	GeeSet* _tmp14_;
	GeeArrayList* _tmp15_;
	GString* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GString* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeMap* _tmp21_;
	GeeSet* _tmp22_;
	GeeSet* _tmp23_;
	GeeSet* _tmp24_;
	GeeArrayList* _tmp25_;
	GString* _tmp26_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	gchar* contents = NULL;
	SkkEncodingConverter* _tmp29_;
	GString* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GFile* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GFile* _tmp38_;
	const gchar* _tmp39_;
	guint8* _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_ = 0;
	guint8* _tmp42_;
	gint _tmp42__length1;
	const gchar* _tmp43_;
	gchar* _tmp44_ = NULL;
	GError* _inner_error0_ = NULL;
	self = (SkkUserDict*) base;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->priv->converter;
	_tmp2_ = skk_encoding_converter_get_coding_system (_tmp1_);
	coding = _tmp2_;
	_tmp3_ = coding;
	if (_tmp3_ != NULL) {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = builder;
		_tmp5_ = coding;
		_tmp6_ = g_strdup_printf (";;; -*- coding: %s -*-\n", _tmp5_);
		_tmp7_ = _tmp6_;
		g_string_append (_tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = builder;
	g_string_append (_tmp8_, ";; okuri-ari entries.\n");
	_tmp9_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	entries = _tmp9_;
	_tmp10_ = entries;
	_tmp11_ = self->priv->okuri_ari_entries;
	_tmp12_ = gee_map_get_entries (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	gee_array_list_add_all (_tmp10_, (GeeCollection*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = entries;
	gee_list_sort ((GeeList*) _tmp15_, (GCompareDataFunc) skk_user_dict_compare_entry_dsc, NULL, NULL);
	_tmp16_ = builder;
	_tmp17_ = entries;
	skk_user_dict_write_entries (self, _tmp16_, (GeeList*) _tmp17_);
	_tmp18_ = entries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp18_);
	_tmp19_ = builder;
	g_string_append (_tmp19_, ";; okuri-nasi entries.\n");
	_tmp20_ = entries;
	_tmp21_ = self->priv->okuri_nasi_entries;
	_tmp22_ = gee_map_get_entries (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	gee_array_list_add_all (_tmp20_, (GeeCollection*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = entries;
	gee_list_sort ((GeeList*) _tmp25_, (GCompareDataFunc) skk_user_dict_compare_entry_asc, NULL, NULL);
	_tmp26_ = builder;
	_tmp27_ = entries;
	skk_user_dict_write_entries (self, _tmp26_, (GeeList*) _tmp27_);
	_tmp28_ = entries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp28_);
	_tmp29_ = self->priv->converter;
	_tmp30_ = builder;
	_tmp31_ = _tmp30_->str;
	_tmp32_ = skk_encoding_converter_encode (_tmp29_, _tmp31_, &_inner_error0_);
	contents = _tmp32_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (entries);
		_g_free0 (coding);
		_g_string_free0 (builder);
		return;
	}
	_tmp33_ = self->priv->file;
	_tmp34_ = g_file_get_path (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_path_get_dirname (_tmp35_);
	_tmp37_ = _tmp36_;
	g_mkdir_with_parents (_tmp37_, 448);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp38_ = self->priv->file;
	_tmp39_ = contents;
	_tmp40_ = string_get_data (_tmp39_, &_tmp41_);
	_tmp40__length1 = _tmp41_;
	_tmp42_ = _tmp40_;
	_tmp42__length1 = _tmp40__length1;
	_tmp43_ = self->priv->etag;
	g_file_replace_contents (_tmp38_, (const char*) _tmp42_, (gsize) _tmp42__length1, _tmp43_, FALSE, G_FILE_CREATE_PRIVATE, &_tmp44_, NULL, &_inner_error0_);
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp44_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (contents);
		_g_object_unref0 (entries);
		_g_free0 (coding);
		_g_string_free0 (builder);
		return;
	}
	_g_free0 (contents);
	_g_object_unref0 (entries);
	_g_free0 (coding);
	_g_string_free0 (builder);
}

static GeeMap*
skk_user_dict_get_entries (SkkUserDict* self,
                           gboolean okuri)
{
	GeeMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (okuri) {
		GeeMap* _tmp0_;
		GeeMap* _tmp1_;
		_tmp0_ = self->priv->okuri_ari_entries;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		result = _tmp1_;
		return result;
	} else {
		GeeMap* _tmp2_;
		GeeMap* _tmp3_;
		_tmp2_ = self->priv->okuri_nasi_entries;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
}

/**
         * {@inheritDoc}
         */
static SkkCandidate**
skk_user_dict_real_lookup (SkkDict* base,
                           const gchar* midasi,
                           gboolean okuri,
                           gint* result_length1)
{
	SkkUserDict * self;
	GeeMap* entries = NULL;
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	SkkCandidate** result;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = skk_user_dict_get_entries (self, okuri);
	entries = _tmp0_;
	_tmp1_ = entries;
	if (gee_map_has_key (_tmp1_, midasi)) {
		GeeMap* _tmp2_;
		gpointer _tmp3_;
		GeeList* _tmp4_;
		gint _tmp5_ = 0;
		gpointer* _tmp6_;
		SkkCandidate** _tmp7_;
		gint _tmp7__length1;
		SkkCandidate** _tmp8_;
		gint _tmp8__length1;
		_tmp2_ = entries;
		_tmp3_ = gee_map_get (_tmp2_, midasi);
		_tmp4_ = (GeeList*) _tmp3_;
		_tmp6_ = gee_collection_to_array ((GeeCollection*) _tmp4_, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _tmp7__length1;
		if (result_length1) {
			*result_length1 = _tmp8__length1;
		}
		result = _tmp8_;
		_g_object_unref0 (entries);
		return result;
	} else {
		SkkCandidate** _tmp9_;
		SkkCandidate** _tmp10_;
		gint _tmp10__length1;
		_tmp9_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp10__length1;
		}
		result = _tmp10_;
		_g_object_unref0 (entries);
		return result;
	}
}

/**
         * {@inheritDoc}
         */
static gchar**
skk_user_dict_real_complete (SkkDict* base,
                             const gchar* midasi,
                             gint* result_length1)
{
	SkkUserDict * self;
	GeeList* completion = NULL;
	GeeArrayList* _tmp0_;
	GeeList* keys = NULL;
	GeeArrayList* _tmp1_;
	GeeList* _tmp2_;
	GeeMap* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeList* _tmp7_;
	GeeIterator* iter = NULL;
	GeeList* _tmp8_;
	GeeIterator* _tmp9_;
	GeeList* _tmp24_;
	gint _tmp25_ = 0;
	gpointer* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gchar** result;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	completion = (GeeList*) _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	keys = (GeeList*) _tmp1_;
	_tmp2_ = keys;
	_tmp3_ = self->priv->okuri_nasi_entries;
	_tmp4_ = gee_map_get_keys (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gee_collection_add_all ((GeeCollection*) _tmp2_, (GeeCollection*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = keys;
	gee_list_sort (_tmp7_, NULL, NULL, NULL);
	_tmp8_ = keys;
	_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
	iter = _tmp9_;
	while (TRUE) {
		GeeIterator* _tmp10_;
		gchar* key = NULL;
		GeeIterator* _tmp11_;
		gpointer _tmp12_;
		const gchar* _tmp13_;
		_tmp10_ = iter;
		if (!gee_iterator_next (_tmp10_)) {
			break;
		}
		_tmp11_ = iter;
		_tmp12_ = gee_iterator_get (_tmp11_);
		key = (gchar*) _tmp12_;
		_tmp13_ = key;
		if (g_str_has_prefix (_tmp13_, midasi)) {
			const gchar* _tmp14_;
			_tmp14_ = key;
			if (g_strcmp0 (_tmp14_, midasi) != 0) {
				GeeList* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = completion;
				_tmp16_ = key;
				gee_collection_add ((GeeCollection*) _tmp15_, _tmp16_);
			}
			_g_free0 (key);
			break;
		}
		_g_free0 (key);
	}
	while (TRUE) {
		GeeIterator* _tmp17_;
		gchar* key = NULL;
		GeeIterator* _tmp18_;
		gpointer _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp17_ = iter;
		if (!gee_iterator_next (_tmp17_)) {
			break;
		}
		_tmp18_ = iter;
		_tmp19_ = gee_iterator_get (_tmp18_);
		key = (gchar*) _tmp19_;
		_tmp20_ = key;
		if (!g_str_has_prefix (_tmp20_, midasi)) {
			_g_free0 (key);
			break;
		}
		_tmp21_ = key;
		if (g_strcmp0 (_tmp21_, midasi) != 0) {
			GeeList* _tmp22_;
			const gchar* _tmp23_;
			_tmp22_ = completion;
			_tmp23_ = key;
			gee_collection_add ((GeeCollection*) _tmp22_, _tmp23_);
		}
		_g_free0 (key);
	}
	_tmp24_ = completion;
	_tmp26_ = gee_collection_to_array ((GeeCollection*) _tmp24_, &_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp27__length1 = _tmp25_;
	if (result_length1) {
		*result_length1 = _tmp27__length1;
	}
	result = _tmp27_;
	_g_object_unref0 (iter);
	_g_object_unref0 (keys);
	_g_object_unref0 (completion);
	return result;
}

/**
         * {@inheritDoc}
         */
static gboolean
skk_user_dict_real_select_candidate (SkkDict* base,
                                     SkkCandidate* candidate)
{
	SkkUserDict * self;
	GeeMap* entries = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint index = 0;
	GeeList* candidates = NULL;
	GeeMap* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gpointer _tmp14_;
	GeeList* _tmp37_;
	gboolean result;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (candidate != NULL, FALSE);
	_tmp0_ = skk_candidate_get_okuri (candidate);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_user_dict_get_entries (self, _tmp1_);
	entries = _tmp2_;
	_tmp3_ = entries;
	_tmp4_ = skk_candidate_get_midasi (candidate);
	_tmp5_ = _tmp4_;
	if (!gee_map_has_key (_tmp3_, _tmp5_)) {
		GeeMap* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		_tmp6_ = entries;
		_tmp7_ = skk_candidate_get_midasi (candidate);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_array_list_new (SKK_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_tmp10_ = _tmp9_;
		gee_map_set (_tmp6_, _tmp8_, (GeeList*) _tmp10_);
		_g_object_unref0 (_tmp10_);
	}
	index = 0;
	_tmp11_ = entries;
	_tmp12_ = skk_candidate_get_midasi (candidate);
	_tmp13_ = _tmp12_;
	_tmp14_ = gee_map_get (_tmp11_, _tmp13_);
	candidates = (GeeList*) _tmp14_;
	{
		GeeList* _c_list = NULL;
		GeeList* _tmp15_;
		gint _c_size = 0;
		GeeList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _c_index = 0;
		_tmp15_ = candidates;
		_c_list = _tmp15_;
		_tmp16_ = _c_list;
		_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_c_size = _tmp18_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			SkkCandidate* c = NULL;
			GeeList* _tmp21_;
			gpointer _tmp22_;
			SkkCandidate* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gint _tmp36_;
			_c_index = _c_index + 1;
			_tmp19_ = _c_index;
			_tmp20_ = _c_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _c_list;
			_tmp22_ = gee_list_get (_tmp21_, _c_index);
			c = (SkkCandidate*) _tmp22_;
			_tmp23_ = c;
			_tmp24_ = skk_candidate_get_text (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = skk_candidate_get_text (candidate);
			_tmp27_ = _tmp26_;
			if (g_strcmp0 (_tmp25_, _tmp27_) == 0) {
				if (index > 0) {
					SkkCandidate* first = NULL;
					GeeList* _tmp28_;
					gpointer _tmp29_;
					GeeList* _tmp30_;
					GeeList* _tmp31_;
					gpointer _tmp32_;
					SkkCandidate* _tmp33_;
					GeeList* _tmp34_;
					SkkCandidate* _tmp35_;
					_tmp28_ = candidates;
					_tmp29_ = gee_list_get (_tmp28_, 0);
					first = (SkkCandidate*) _tmp29_;
					_tmp30_ = candidates;
					_tmp31_ = candidates;
					_tmp32_ = gee_list_get (_tmp31_, index);
					_tmp33_ = (SkkCandidate*) _tmp32_;
					gee_list_set (_tmp30_, 0, _tmp33_);
					_g_object_unref0 (_tmp33_);
					_tmp34_ = candidates;
					_tmp35_ = first;
					gee_list_set (_tmp34_, index, _tmp35_);
					result = TRUE;
					_g_object_unref0 (first);
					_g_object_unref0 (c);
					_g_object_unref0 (candidates);
					_g_object_unref0 (entries);
					return result;
				}
				result = FALSE;
				_g_object_unref0 (c);
				_g_object_unref0 (candidates);
				_g_object_unref0 (entries);
				return result;
			}
			_tmp36_ = index;
			index = _tmp36_ + 1;
			_g_object_unref0 (c);
		}
	}
	_tmp37_ = candidates;
	gee_list_insert (_tmp37_, 0, candidate);
	result = TRUE;
	_g_object_unref0 (candidates);
	_g_object_unref0 (entries);
	return result;
}

/**
         * {@inheritDoc}
         */
static gboolean
skk_user_dict_real_purge_candidate (SkkDict* base,
                                    SkkCandidate* candidate)
{
	SkkUserDict * self;
	gboolean modified = FALSE;
	GeeMap* entries = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean result;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (candidate != NULL, FALSE);
	modified = FALSE;
	_tmp0_ = skk_candidate_get_okuri (candidate);
	_tmp1_ = _tmp0_;
	_tmp2_ = skk_user_dict_get_entries (self, _tmp1_);
	entries = _tmp2_;
	_tmp3_ = entries;
	_tmp4_ = skk_candidate_get_midasi (candidate);
	_tmp5_ = _tmp4_;
	if (gee_map_has_key (_tmp3_, _tmp5_)) {
		GeeList* candidates = NULL;
		GeeMap* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gpointer _tmp9_;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp6_ = entries;
		_tmp7_ = skk_candidate_get_midasi (candidate);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_map_get (_tmp6_, _tmp8_);
		candidates = (GeeList*) _tmp9_;
		_tmp10_ = candidates;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			GeeIterator* iter = NULL;
			GeeList* _tmp13_;
			GeeIterator* _tmp14_;
			GeeList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			_tmp13_ = candidates;
			_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
			iter = _tmp14_;
			while (TRUE) {
				GeeIterator* _tmp15_;
				SkkCandidate* c = NULL;
				GeeIterator* _tmp16_;
				gpointer _tmp17_;
				SkkCandidate* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				_tmp15_ = iter;
				if (!gee_iterator_next (_tmp15_)) {
					break;
				}
				_tmp16_ = iter;
				_tmp17_ = gee_iterator_get (_tmp16_);
				c = (SkkCandidate*) _tmp17_;
				_tmp18_ = c;
				_tmp19_ = skk_candidate_get_text (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = skk_candidate_get_text (candidate);
				_tmp22_ = _tmp21_;
				if (g_strcmp0 (_tmp20_, _tmp22_) == 0) {
					GeeIterator* _tmp23_;
					_tmp23_ = iter;
					gee_iterator_remove (_tmp23_);
					modified = TRUE;
				}
				_g_object_unref0 (c);
			}
			_tmp24_ = candidates;
			_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			if (_tmp26_ == 0) {
				GeeMap* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				_tmp27_ = entries;
				_tmp28_ = skk_candidate_get_midasi (candidate);
				_tmp29_ = _tmp28_;
				gee_map_unset (_tmp27_, _tmp29_, NULL);
			}
			_g_object_unref0 (iter);
		}
		_g_object_unref0 (candidates);
	}
	result = modified;
	_g_object_unref0 (entries);
	return result;
}

/**
         * Create a new UserDict.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default UTF-8)
         *
         * @return a new UserDict
         * @throws GLib.Error if opening the file is failed
         */
SkkUserDict*
skk_user_dict_construct (GType object_type,
                         const gchar* path,
                         const gchar* encoding,
                         GError** error)
{
	SkkUserDict * self = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	SkkEncodingConverter* _tmp2_ = NULL;
	SkkEncodingConverter* _tmp3_;
	SkkEncodingConverter* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkUserDict*) skk_dict_construct (object_type);
	_tmp0_ = g_file_new_for_path (path);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp1_;
	_tmp3_ = skk_encoding_converter_new (encoding, &_inner_error0_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp4_ = _tmp2_;
	_tmp2_ = NULL;
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp4_;
	if (g_file_test (path, G_FILE_TEST_EXISTS)) {
		skk_dict_reload ((SkkDict*) self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (self);
			return NULL;
		}
	}
	_g_object_unref0 (_tmp2_);
	return self;
}

SkkUserDict*
skk_user_dict_new (const gchar* path,
                   const gchar* encoding,
                   GError** error)
{
	return skk_user_dict_construct (SKK_TYPE_USER_DICT, path, encoding, error);
}

static gboolean
skk_user_dict_real_get_read_only (SkkDict* base)
{
	gboolean result;
	SkkUserDict* self;
	self = (SkkUserDict*) base;
	result = FALSE;
	return result;
}

static void
skk_user_dict_class_init (SkkUserDictClass * klass,
                          gpointer klass_data)
{
	skk_user_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkUserDict_private_offset);
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict*, GError**)) skk_user_dict_real_reload;
	((SkkDictClass *) klass)->save = (void (*) (SkkDict*, GError**)) skk_user_dict_real_save;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict*, const gchar*, gboolean, gint*)) skk_user_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict*, const gchar*, gint*)) skk_user_dict_real_complete;
	((SkkDictClass *) klass)->select_candidate = (gboolean (*) (SkkDict*, SkkCandidate*)) skk_user_dict_real_select_candidate;
	((SkkDictClass *) klass)->purge_candidate = (gboolean (*) (SkkDict*, SkkCandidate*)) skk_user_dict_real_purge_candidate;
	SKK_DICT_CLASS (klass)->get_read_only = (gboolean (*) (SkkDict*)) skk_user_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_user_dict_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_user_dict_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_USER_DICT_READ_ONLY_PROPERTY, skk_user_dict_properties[SKK_USER_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
skk_user_dict_instance_init (SkkUserDict * self,
                             gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = skk_user_dict_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->okuri_ari_entries = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->okuri_nasi_entries = (GeeMap*) _tmp1_;
}

static void
skk_user_dict_finalize (GObject * obj)
{
	SkkUserDict * self;
	GeeMapIterator* okuri_ari_iter = NULL;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	GeeMap* _tmp6_;
	GeeMapIterator* okuri_nasi_iter = NULL;
	GeeMap* _tmp7_;
	GeeMapIterator* _tmp8_;
	GeeMap* _tmp13_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_USER_DICT, SkkUserDict);
	_tmp0_ = self->priv->okuri_ari_entries;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	okuri_ari_iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		GeeList* _tmp5_;
		_tmp2_ = okuri_ari_iter;
		if (!gee_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = okuri_ari_iter;
		_tmp4_ = gee_map_iterator_get_value (_tmp3_);
		_tmp5_ = (GeeList*) _tmp4_;
		gee_collection_clear ((GeeCollection*) _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = self->priv->okuri_ari_entries;
	gee_map_clear (_tmp6_);
	_tmp7_ = self->priv->okuri_nasi_entries;
	_tmp8_ = gee_map_map_iterator (_tmp7_);
	okuri_nasi_iter = _tmp8_;
	while (TRUE) {
		GeeMapIterator* _tmp9_;
		GeeMapIterator* _tmp10_;
		gpointer _tmp11_;
		GeeList* _tmp12_;
		_tmp9_ = okuri_nasi_iter;
		if (!gee_map_iterator_next (_tmp9_)) {
			break;
		}
		_tmp10_ = okuri_nasi_iter;
		_tmp11_ = gee_map_iterator_get_value (_tmp10_);
		_tmp12_ = (GeeList*) _tmp11_;
		gee_collection_clear ((GeeCollection*) _tmp12_);
		_g_object_unref0 (_tmp12_);
	}
	_tmp13_ = self->priv->okuri_nasi_entries;
	gee_map_clear (_tmp13_);
	_g_object_unref0 (okuri_nasi_iter);
	_g_object_unref0 (okuri_ari_iter);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	_g_object_unref0 (self->priv->okuri_ari_entries);
	_g_object_unref0 (self->priv->okuri_nasi_entries);
	G_OBJECT_CLASS (skk_user_dict_parent_class)->finalize (obj);
}

/**
     * File based implementation of Dict with write access.
     */
static GType
skk_user_dict_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkUserDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_user_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkUserDict), 0, (GInstanceInitFunc) skk_user_dict_instance_init, NULL };
	GType skk_user_dict_type_id;
	skk_user_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkUserDict", &g_define_type_info, 0);
	SkkUserDict_private_offset = g_type_add_instance_private (skk_user_dict_type_id, sizeof (SkkUserDictPrivate));
	return skk_user_dict_type_id;
}

GType
skk_user_dict_get_type (void)
{
	static volatile gsize skk_user_dict_type_id__once = 0;
	if (g_once_init_enter (&skk_user_dict_type_id__once)) {
		GType skk_user_dict_type_id;
		skk_user_dict_type_id = skk_user_dict_get_type_once ();
		g_once_init_leave (&skk_user_dict_type_id__once, skk_user_dict_type_id);
	}
	return skk_user_dict_type_id__once;
}

static void
_vala_skk_user_dict_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SkkUserDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_USER_DICT, SkkUserDict);
	switch (property_id) {
		case SKK_USER_DICT_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

