#ifndef __BICUBIC_INCLUDE_H__
#define __BICUBIC_INCLUDE_H__
static const char fblitbicubic_img[] =
 "float weight(float x)\n"
 "{\n"
 "	float ax = abs(x);\n"
 "	// Sharper version.\n"
 "	// May look better in some cases.\n"
 "	const float B = 0.0;\n"
 "	const float C = 0.75;\n"
 "\n"
 "	if (ax < 1.0)\n"
 "	{\n"
 "		return\n"
 "			(\n"
 "			 pow(x, 2.0) * ((12.0 - 9.0 * B - 6.0 * C) * ax + (-18.0 + 12.0 * B + 6.0 * C)) +\n"
 "			 (6.0 - 2.0 * B)\n"
 "			) / 6.0;\n"
 "	}\n"
 "	else if ((ax >= 1.0) && (ax < 2.0))\n"
 "	{\n"
 "		return\n"
 "			(\n"
 "			 pow(x, 2.0) * ((-B - 6.0 * C) * ax + (6.0 * B + 30.0 * C)) +\n"
 "			 (-12.0 * B - 48.0 * C) * ax + (8.0 * B + 24.0 * C)\n"
 "			) / 6.0;\n"
 "	}\n"
 "	else\n"
 "	{\n"
 "		return 0.0;\n"
 "	}\n"
 "}\n"
 "	\n"
 "vec4 weight4(float x)\n"
 "{\n"
 "	return vec4(\n"
 "			weight(x - 2.0),\n"
 "			weight(x - 1.0),\n"
 "			weight(x),\n"
 "			weight(x + 1.0));\n"
 "}\n"
 "\n"
 "vec3 pixel(float xpos, float ypos, sampler2D tex)\n"
 "{\n"
 "	return texture(tex, vec2(xpos, ypos)).rgb;\n"
 "}\n"
 "\n"
 "vec3 line_run(float ypos, vec4 xpos, vec4 linetaps, sampler2D tex)\n"
 "{\n"
 "	return\n"
 "		pixel(xpos.r, ypos, tex) * linetaps.r +\n"
 "		pixel(xpos.g, ypos, tex) * linetaps.g +\n"
 "		pixel(xpos.b, ypos, tex) * linetaps.b +\n"
 "		pixel(xpos.a, ypos, tex) * linetaps.a;\n"
 "}\n"
 "\n"
 "vec4 Filter(sampler2D tex, vec2 texCoord) //Bicubic Sharper\n"
 "{	\n"
 "  vec2 stepxy = vec2(1.0/fWidth, 1.0/fHeight);\n"
 "  vec2 pos = texCoord.xy + stepxy * 0.5;\n"
 "  vec2 f = fract(pos / stepxy);\n"
 "		\n"
 "	vec4 linetaps   = weight4(1.0 - f.x);\n"
 "	vec4 columntaps = weight4(1.0 - f.y);\n"
 "\n"
 "	//make sure all taps added together is exactly 1.0, otherwise some (very small) distortion can occur\n"
 "	linetaps /= linetaps.r + linetaps.g + linetaps.b + linetaps.a;\n"
 "	columntaps /= columntaps.r + columntaps.g + columntaps.b + columntaps.a;\n"
 "\n"
 "	vec2 xystart = (-1.5 - f) * stepxy + pos;\n"
 "	vec4 xpos = vec4(xystart.x, xystart.x + stepxy.x, xystart.x + stepxy.x * 2.0, xystart.x + stepxy.x * 3.0);\n"
 "\n"
 "\n"
 "// final sum and weight normalization\n"
 "   vec4 final = vec4(line_run(xystart.y              , xpos, linetaps, tex) * columntaps.r +\n"
 "                      line_run(xystart.y + stepxy.y      , xpos, linetaps, tex) * columntaps.g +\n"
 "                      line_run(xystart.y + stepxy.y * 2.0, xpos, linetaps, tex) * columntaps.b +\n"
 "                      line_run(xystart.y + stepxy.y * 3.0, xpos, linetaps, tex) * columntaps.a,1);\n"
 "   return final;\n"
 "}\n";
 #endif
