/*
 *  Created on: apr 11, 2019

	Copyright 2018 barbudreadmon

	This file is part of reicast.

    reicast is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    reicast is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with reicast.  If not, see <https://www.gnu.org/licenses/>.
 */
#pragma once

// calibration done
static u8 alienfnt_eeprom_dump[] = {
	0xe1, 0xa2, 0x10, 0x42, 0x43, 0x51, 0x30, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xe1, 0xa2, 0x10, 0x42, 0x43, 0x51, 0x30, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x2d, 0x89, 0x18, 0x18, 0x2d, 0x89, 0x18, 0x18, 0x78, 0x56, 0x34, 0x12, 0x01, 0x01, 0x01, 0x03, 0x00, 0xff,
	0xfe, 0xfe, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x14, 0x01, 0x00, 0x00, 0x00, 0x00, 0x78, 0x56, 0x34, 0x12,
	0x01, 0x01, 0x01, 0x03, 0x00, 0xff, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x14, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

static u8 kick4csh_eeprom_dump[] = {
	0x3A, 0x6E, 0x10, 0x42, 0x4A, 0x47, 0x30, 0x18, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x3A, 0x6E, 0x10, 0x42, 0x4A, 0x47, 0x30, 0x18, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xC7, 0x83, 0x28, 0x28, 0xC7, 0x83, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00
};

static u8 hmgeo_eeprom_dump[] = {
	0x6d, 0x46, 0x10, 0x42, 0x43, 0x57, 0x30, 0x18, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x6d, 0x46, 0x10, 0x42, 0x43, 0x57, 0x30, 0x18, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x69, 0x61, 0x20, 0x20, 0x69, 0x61, 0x20, 0x20, 0x06, 0x06, 0x01, 0x20, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01,
	0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x01, 0x20, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x03, 0x03, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00
};

// VMU enabled, network disabled (USA region)
static u8 spawn_eeprom_dump[] = {
	0x37, 0x99, 0x10, 0x42, 0x41, 0x56, 0x35, 0x18, 0x10, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x37, 0x99, 0x10, 0x42, 0x41, 0x56, 0x35, 0x18, 0x10, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x41, 0x7b, 0x20, 0x20, 0x41, 0x7b, 0x20, 0x20, 0x17, 0x12, 0x99, 0x19, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x03, 0x06, 0x05, 0x00, 0x01, 0x01, 0x06, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x17, 0x12, 0x99, 0x19, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x03, 0x03, 0x06, 0x05, 0x00, 0x01, 0x01, 0x06, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00
};

static u8 _18wheelr_eeprom_dump[] {
	0xd3, 0x69, 0x10, 0x42, 0x42, 0x4b, 0x30, 0x18, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xd3, 0x69, 0x10, 0x42, 0x42, 0x4b, 0x30, 0x18, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

static u8 crzytaxi_eeprom_dump[] {
	0x5a, 0x3a, 0x10, 0x42, 0x41, 0x43, 0x30, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x21, 0x11, 0x11, 0x11,
	0x5a, 0x3a, 0x10, 0x42, 0x41, 0x43, 0x30, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x21, 0x11, 0x11, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

// 2-player cab
static u8 doa2_eeprom_dump[] {
	0xdf, 0xd1, 0x10, 0x42, 0x41, 0x4c, 0x31, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xdf, 0xd1, 0x10, 0x42, 0x41, 0x4c, 0x31, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

// 2-player cab, and select digital DPad
static u8 zombrvn_eeprom_dump[] {
	0x94, 0xfc, 0x10, 0x42, 0x41, 0x44, 0x30, 0x09, 0x10, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x94, 0xfc, 0x10, 0x42, 0x41, 0x44, 0x30, 0x09, 0x10, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x4c, 0x0a, 0x14, 0x14, 0x4c, 0x0a, 0x14, 0x14, 0xd0, 0xba, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00, 0x7f,
	0xff, 0x00, 0x7f, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x7f, 0xff, 0xd0, 0xba, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00,
	0x00, 0x7f, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00
};

// 2-player cab, and select digital DPad
static u8 zombrvne_eeprom_dump[] = {
	0xa0, 0x03, 0x10, 0x42, 0x41, 0x44, 0x30, 0x18, 0x10, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xa0, 0x03, 0x10, 0x42, 0x41, 0x44, 0x30, 0x18, 0x10, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x04, 0x88, 0x14, 0x14, 0x04, 0x88, 0x14, 0x14, 0xd0, 0xba, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00, 0x80,
	0xff, 0x00, 0x80, 0xff, 0x00, 0x80, 0xff, 0x00, 0x80, 0xff, 0xd0, 0xba, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00,
	0x00, 0x80, 0xff, 0x00, 0x80, 0xff, 0x00, 0x80, 0xff, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00
};

static u8 confmiss_eeprom_dump[] {
	0x82, 0x4b, 0x10, 0x42, 0x43, 0x52, 0x30, 0x18, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x21, 0x11, 0x11, 0x11,
	0x82, 0x4b, 0x10, 0x42, 0x43, 0x52, 0x30, 0x18, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x21, 0x11, 0x11, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

// gun calibrated
static u8 lupinsho_eeprom_dump[] {
	0x56, 0xb5, 0x10, 0x42, 0x45, 0x43, 0x30, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x56, 0xb5, 0x10, 0x42, 0x45, 0x43, 0x30, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

// 2-player cab
static u8 luptype_eeprom_dump[] {
	0x0a, 0xa2, 0x10, 0x42, 0x45, 0x4e, 0x30, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x0a, 0xa2, 0x10, 0x42, 0x45, 0x4e, 0x30, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

static u8 mok_eeprom_dump[] {
	0x7f, 0x8e, 0x10, 0x42, 0x45, 0x50, 0x30, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x21, 0x11, 0x11, 0x11,
	0x7f, 0x8e, 0x10, 0x42, 0x45, 0x50, 0x30, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x21, 0x11, 0x11, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

// touchscreen calibrated
static u8 tduno_eeprom_dump[] {
	0x5f, 0xdc, 0x10, 0x42, 0x41, 0x50, 0x31, 0x09, 0x00, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x5f, 0xdc, 0x10, 0x42, 0x41, 0x50, 0x31, 0x09, 0x00, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xe4, 0x28, 0x18, 0x18, 0xe4, 0x28, 0x18, 0x18, 0x14, 0x00, 0x14, 0x00, 0x16, 0x00, 0x16, 0x00, 0x97, 0x6d,
	0x80, 0x3f, 0xa4, 0x4a, 0x80, 0x3f, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x97, 0x6d, 0x80, 0x3f, 0xa4, 0x4a, 0x80, 0x3f, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

// touchscreen calibrated
static u8 tduno2_eeprom_dump[] {
	0x8a, 0xd3, 0x10, 0x42, 0x42, 0x48, 0x32, 0x09, 0x00, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x8a, 0xd3, 0x10, 0x42, 0x42, 0x48, 0x32, 0x09, 0x00, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xb2, 0x67, 0x18, 0x18, 0xb2, 0x67, 0x18, 0x18, 0x28, 0x00, 0x28, 0x00, 0x2a, 0x00, 0x29, 0x00, 0xbe, 0xeb,
	0x80, 0x3f, 0xaa, 0xa4, 0x80, 0x3f, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x28, 0x00, 0x28, 0x00,
	0x2a, 0x00, 0x29, 0x00, 0xbe, 0xeb, 0x80, 0x3f, 0xaa, 0xa4, 0x80, 0x3f, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x4c, 0x27, 0xab, 0x37, 0x7e, 0x03, 0x49, 0x54, 0x78, 0x45, 0x61, 0x7a, 0xa3, 0x52, 0xfc, 0xca,
	0xcb, 0x64, 0xbc, 0xe5, 0xa5, 0x68, 0x16, 0x42, 0x69, 0x4e, 0x4c, 0xe8, 0xfc, 0x82, 0x81, 0x78, 0xa6, 0x25,
	0x63, 0x46,
};

// card reader disabled
static u8 clubk2k3_eeprom_dump[] {
	0x73, 0x25, 0x10, 0x42, 0x48, 0x4C, 0x30, 0x09, 0x00, 0x1A, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x73, 0x25, 0x10, 0x42, 0x48, 0x4C, 0x30, 0x09, 0x00, 0x1A, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x13, 0x67, 0x20, 0x20, 0x13, 0x67, 0x20, 0x20, 0x25, 0x52, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x30, 0xC0, 0x30, 0xC0, 0xC8, 0x40, 0x00, 0x92, 0x01, 0x1E, 0x0A, 0xD0, 0x07, 0x00, 0x00, 0x00, 0x00,
	0xC0, 0xA8, 0x01, 0x01, 0x25, 0x52, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xC0, 0x30,
	0xC0, 0xC8, 0x40, 0x00, 0x92, 0x01, 0x1E, 0x0A, 0xD0, 0x07, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xA8, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

// avoids Call Staff error on first boot
unsigned char clubkprz_eeprom_dump[] = {
	0xbd, 0x5d, 0x10, 0x42, 0x47, 0x52, 0x30, 0x09, 0x30, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xbd, 0x5d, 0x10, 0x42, 0x47, 0x52, 0x30, 0x09, 0x30, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xab, 0xab, 0x20, 0x20, 0xab, 0xab, 0x20, 0x20, 0x25, 0x52, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x30, 0xc0, 0x30, 0xc0, 0x48, 0x40, 0x00, 0x92, 0x01, 0x32, 0x00, 0xd0, 0x07, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0xa8, 0x01, 0x01, 0x25, 0x52, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xc0, 0x30,
	0xc0, 0x48, 0x40, 0x00, 0x92, 0x01, 0x32, 0x00, 0xd0, 0x07, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xa8, 0x01, 0x01,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0b, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x07, 0x00,
	0x08, 0x00
};

// cb-mic disabled
static u8 kingrt66_eeprom_dump[] {
	0x15, 0xF8, 0x10, 0x42, 0x45, 0x45, 0x30, 0x09, 0x00, 0x1A, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x15, 0xF8, 0x10, 0x42, 0x45, 0x45, 0x30, 0x09, 0x00, 0x1A, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x38, 0xA2, 0x24, 0x24, 0x38, 0xA2, 0x24, 0x24, 0x17, 0x05, 0x01, 0x00, 0x4B, 0x4F, 0x52, 0x36, 0x36, 0x00,
	0x76, 0x98, 0x32, 0x54, 0x98, 0x10, 0x12, 0x45, 0x01, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x17, 0x05, 0x01, 0x00, 0x4B, 0x4F, 0x52, 0x36, 0x36, 0x00,
	0x76, 0x98, 0x32, 0x54, 0x98, 0x10, 0x12, 0x45, 0x01, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};

#ifdef NAOMI_MULTIBOARD
// network: alone
static u8 sgdrvsim_eeprom_dump[] {
	0x47, 0xDA, 0x10, 0x42, 0x41, 0x41, 0x30, 0x09, 0x00, 0x1A, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x47, 0xDA, 0x10, 0x42, 0x41, 0x41, 0x30, 0x09, 0x00, 0x1A, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xB2, 0x69, 0x20, 0x20, 0xB2, 0x69, 0x20, 0x20, 0x44, 0x72, 0x76, 0x53, 0x69, 0x6D, 0x6D, 0x00, 0x05, 0x00,
	0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF,
	0x00, 0x00, 0xFF, 0xFF, 0x44, 0x72, 0x76, 0x53, 0x69, 0x6D, 0x6D, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x1E,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,
};
#endif

// 2-player cabinet
static u8 vf4_eeprom_dump[] = {
	0xb7, 0x15, 0x10, 0x42, 0x44, 0x4d, 0x00, 0x18, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0xb7, 0x15, 0x10, 0x42, 0x44, 0x4d, 0x00, 0x18, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x88, 0xd9, 0x78, 0x92, 0x5b, 0x81, 0x92, 0x25, 0x2e, 0x4f, 0x83, 0x55, 0xe9, 0xe1, 0xe3, 0xcf, 0x3f, 0xfb,
	0x81, 0xcf, 0x3e, 0xc8, 0xf1, 0x04, 0x43, 0x15, 0x3c, 0xa6, 0x2a, 0x1e, 0x5e, 0x01, 0x20, 0x23, 0xd2, 0xc1,
	0x0d, 0xcd, 0xc9, 0x7d, 0x92, 0x09, 0x50, 0xf9, 0xa0, 0x86, 0x9b, 0x68, 0xb2, 0x0f, 0x68, 0xe8, 0x96, 0x74,
	0x88, 0xb0, 0xb7, 0x37, 0x7d, 0x76, 0xe3, 0x47, 0x27, 0xf7, 0xf9, 0x9d, 0x07, 0x0d, 0x49, 0x6e, 0x1c, 0xb8,
	0x7c, 0x22, 0xa8, 0xa1, 0x9b, 0x9a, 0x0f, 0x0f, 0xec, 0x53, 0x09, 0x12, 0x61, 0xf6, 0xf9, 0x04, 0x3b, 0x33,
	0xd3, 0xf5
};

// 2-player cabinet
static u8 vf4evo_eeprom_dump[] = {
	0x77, 0x7c, 0x10, 0x42, 0x46, 0x42, 0x00, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x77, 0x7c, 0x10, 0x42, 0x46, 0x42, 0x00, 0x09, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00
};

// 2-player cabinet
static u8 vf4tuned_eeprom_dump[] = {
	0x1f, 0x33, 0x10, 0x42, 0x48, 0x58, 0x00, 0x18, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x1f, 0x33, 0x10, 0x42, 0x48, 0x58, 0x00, 0x18, 0x10, 0x1a, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x1d, 0xd1, 0xe2, 0xd1, 0x88, 0x16, 0x8f, 0x46, 0xb4, 0x78, 0x34, 0xa2, 0xc5, 0xa3, 0xe8, 0x39, 0x68, 0x31,
	0x39, 0xa2, 0xc5, 0xa3, 0x6c, 0x8b, 0x4f, 0x1d, 0x47, 0xbe, 0x08, 0x50, 0xb7, 0x56, 0x4f, 0x34, 0x1d, 0x67,
	0x67, 0xa2, 0xed, 0xa6, 0xe3, 0x26, 0x27, 0x65, 0x5d, 0x10, 0x69, 0xc9, 0x66, 0xd9, 0x3f, 0x7e, 0xaa, 0xfc,
	0x23, 0xb9, 0x0f, 0xe9, 0x40, 0xfc, 0x94, 0xdf, 0xe4, 0xaf, 0x03, 0x6f, 0x80, 0x33, 0x2d, 0x0c, 0xe2, 0x4c,
	0x51, 0x8d, 0x91, 0xd9, 0x21, 0x7c, 0x9c, 0xc8, 0xc3, 0xae, 0xe8, 0x4d, 0xeb, 0x10, 0x67, 0x9a, 0xd7, 0x02,
	0x67, 0xd6
};

// correct coin assignment
static u8 manicpnc_eeprom_dump[128] = {
	0x22, 0x11, 0x10, 0x42, 0x4d, 0x4b, 0x30, 0x09, 0x10, 0x00, 0x01, 0x01, 0x01, 0x00, 0x12, 0x12, 0x11, 0x11,
	0x22, 0x11, 0x10, 0x42, 0x4d, 0x4b, 0x30, 0x09, 0x10, 0x00, 0x01, 0x01, 0x01, 0x00, 0x12, 0x12, 0x11, 0x11,
};

// calibration done
static u8 crackndj_eeprom_dump[] = {
	0x4e, 0x8b, 0x10, 0x42, 0x43, 0x47, 0x30, 0x09, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x4e, 0x8b, 0x10, 0x42, 0x43, 0x47, 0x30, 0x09, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
	0x5d, 0x2c, 0x24, 0x24, 0x5d, 0x2c, 0x24, 0x24, 0x00, 0x47, 0x43, 0x42, 0x43, 0x52, 0x41, 0x43, 0x4b, 0x49,
	0x4e, 0x44, 0x4a, 0x20, 0x41, 0x4d, 0x33, 0x03, 0x00, 0x00, 0xfe, 0x00, 0x07, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x41, 0x00, 0x00, 0x20, 0x41, 0x00, 0x47, 0x43, 0x42, 0x43, 0x52, 0x41, 0x43, 0x4b, 0x49,
	0x4e, 0x44, 0x4a, 0x20, 0x41, 0x4d, 0x33, 0x03, 0x00, 0x00, 0xfe, 0x00, 0x07, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x41, 0x00, 0x00, 0x20, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00
};

// calibration done
static u8 crakndj2_eeprom_dump[] = {
  0xa1, 0xab, 0x10, 0x42, 0x44, 0x4b, 0x30, 0x09, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
  0xa1, 0xab, 0x10, 0x42, 0x44, 0x4b, 0x30, 0x09, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11,
  0xb4, 0xdd, 0x24, 0x24, 0xb4, 0xdd, 0x24, 0x24, 0x00, 0x4b, 0x44, 0x42, 0x43, 0x52, 0x41, 0x43, 0x4b, 0x49,
  0x4e, 0x44, 0x4a, 0x20, 0x41, 0x4d, 0x33, 0x03, 0x00, 0x00, 0xfe, 0x00, 0x07, 0x0e, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x41, 0x00, 0x00, 0x20, 0x41, 0x00, 0x4b, 0x44, 0x42, 0x43, 0x52, 0x41, 0x43, 0x4b, 0x49,
  0x4e, 0x44, 0x4a, 0x20, 0x41, 0x4d, 0x33, 0x03, 0x00, 0x00, 0xfe, 0x00, 0x07, 0x0e, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x41, 0x00, 0x00, 0x20, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00
};

