/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef OOX_TOKEN_TOKENS_HXX
#define OOX_TOKEN_TOKENS_HXX

#include <com/sun/star/xml/sax/FastToken.hpp>

namespace oox {
const sal_Int32 XML_1D = 0;
const sal_Int32 XML_1pic = 1;
const sal_Int32 XML_1picTitle = 2;
const sal_Int32 XML_2D = 3;
const sal_Int32 XML_2pic = 4;
const sal_Int32 XML_2picTitle = 5;
const sal_Int32 XML_35mm = 6;
const sal_Int32 XML_3Arrows = 7;
const sal_Int32 XML_3ArrowsGray = 8;
const sal_Int32 XML_3Flags = 9;
const sal_Int32 XML_3Signs = 10;
const sal_Int32 XML_3Symbols = 11;
const sal_Int32 XML_3Symbols2 = 12;
const sal_Int32 XML_3TrafficLights1 = 13;
const sal_Int32 XML_3TrafficLights2 = 14;
const sal_Int32 XML_3cd4 = 15;
const sal_Int32 XML_3cd8 = 16;
const sal_Int32 XML_3dDkShadow = 17;
const sal_Int32 XML_3dLight = 18;
const sal_Int32 XML_4Arrows = 19;
const sal_Int32 XML_4ArrowsGray = 20;
const sal_Int32 XML_4Rating = 21;
const sal_Int32 XML_4RedToBlack = 22;
const sal_Int32 XML_4TrafficLights = 23;
const sal_Int32 XML_4pic = 24;
const sal_Int32 XML_4picTitle = 25;
const sal_Int32 XML_5Arrows = 26;
const sal_Int32 XML_5ArrowsGray = 27;
const sal_Int32 XML_5Quarters = 28;
const sal_Int32 XML_5Rating = 29;
const sal_Int32 XML_5cd8 = 30;
const sal_Int32 XML_7cd8 = 31;
const sal_Int32 XML_A1 = 32;
const sal_Int32 XML_A3 = 33;
const sal_Int32 XML_A4 = 34;
const sal_Int32 XML_AbbreviatedCaseNumber = 35;
const sal_Int32 XML_Accel = 36;
const sal_Int32 XML_Accel2 = 37;
const sal_Int32 XML_AlbumTitle = 38;
const sal_Int32 XML_AlternateContent = 39;
const sal_Int32 XML_Always = 40;
const sal_Int32 XML_Anchor = 41;
const sal_Int32 XML_AppVersion = 42;
const sal_Int32 XML_Append = 43;
const sal_Int32 XML_Application = 44;
const sal_Int32 XML_Art = 45;
const sal_Int32 XML_ArticleInAPeriodical = 46;
const sal_Int32 XML_Artist = 47;
const sal_Int32 XML_Author = 48;
const sal_Int32 XML_AutoFill = 49;
const sal_Int32 XML_AutoFit = 50;
const sal_Int32 XML_AutoLine = 51;
const sal_Int32 XML_AutoPict = 52;
const sal_Int32 XML_AutoScale = 53;
const sal_Int32 XML_B4ISO = 54;
const sal_Int32 XML_B4JIS = 55;
const sal_Int32 XML_B5ISO = 56;
const sal_Int32 XML_B5JIS = 57;
const sal_Int32 XML_BackColor = 58;
const sal_Int32 XML_Bitmap = 59;
const sal_Int32 XML_Book = 60;
const sal_Int32 XML_BookAuthor = 61;
const sal_Int32 XML_BookSection = 62;
const sal_Int32 XML_BookTitle = 63;
const sal_Int32 XML_BorderColor = 64;
const sal_Int32 XML_BorderStyle = 65;
const sal_Int32 XML_Bottom = 66;
const sal_Int32 XML_BroadcastTitle = 67;
const sal_Int32 XML_Broadcaster = 68;
const sal_Int32 XML_Button = 69;
const sal_Int32 XML_CF = 70;
const sal_Int32 XML_CalcA1 = 71;
const sal_Int32 XML_CalcA1ExcelA1 = 72;
const sal_Int32 XML_Camera = 73;
const sal_Int32 XML_Cancel = 74;
const sal_Int32 XML_Caption = 75;
const sal_Int32 XML_Case = 76;
const sal_Int32 XML_CaseNumber = 77;
const sal_Int32 XML_Center = 78;
const sal_Int32 XML_ChapterNumber = 79;
const sal_Int32 XML_Characters = 80;
const sal_Int32 XML_CharactersWithSpaces = 81;
const sal_Int32 XML_Checkbox = 82;
const sal_Int32 XML_Checked = 83;
const sal_Int32 XML_Choice = 84;
const sal_Int32 XML_City = 85;
const sal_Int32 XML_ClientData = 86;
const sal_Int32 XML_ColHidden = 87;
const sal_Int32 XML_Colored = 88;
const sal_Int32 XML_Column = 89;
const sal_Int32 XML_Combo = 90;
const sal_Int32 XML_ComboEdit = 91;
const sal_Int32 XML_Comments = 92;
const sal_Int32 XML_Company = 93;
const sal_Int32 XML_Compiler = 94;
const sal_Int32 XML_Composer = 95;
const sal_Int32 XML_Conductor = 96;
const sal_Int32 XML_ConferenceName = 97;
const sal_Int32 XML_ConferenceProceedings = 98;
const sal_Int32 XML_ConnectionID = 99;
const sal_Int32 XML_Content = 100;
const sal_Int32 XML_ContentType = 101;
const sal_Int32 XML_Corporate = 102;
const sal_Int32 XML_Counsel = 103;
const sal_Int32 XML_CountryRegion = 104;
const sal_Int32 XML_Court = 105;
const sal_Int32 XML_DDE = 106;
const sal_Int32 XML_DMY = 107;
const sal_Int32 XML_DVASPECT_CONTENT = 108;
const sal_Int32 XML_DVASPECT_ICON = 109;
const sal_Int32 XML_DYM = 110;
const sal_Int32 XML_DataBinding = 111;
const sal_Int32 XML_DataBindingLoadMode = 112;
const sal_Int32 XML_DataBindingName = 113;
const sal_Int32 XML_Day = 114;
const sal_Int32 XML_DayAccessed = 115;
const sal_Int32 XML_Default = 116;
const sal_Int32 XML_DefaultSize = 117;
const sal_Int32 XML_Delay = 118;
const sal_Int32 XML_Department = 119;
const sal_Int32 XML_Dialog = 120;
const sal_Int32 XML_DigSig = 121;
const sal_Int32 XML_Director = 122;
const sal_Int32 XML_Disabled = 123;
const sal_Int32 XML_Dismiss = 124;
const sal_Int32 XML_DisplayStyle = 125;
const sal_Int32 XML_Distributed = 126;
const sal_Int32 XML_Distributor = 127;
const sal_Int32 XML_DocSecurity = 128;
const sal_Int32 XML_DocumentFromInternetSite = 129;
const sal_Int32 XML_DrawAspect = 130;
const sal_Int32 XML_Drop = 131;
const sal_Int32 XML_DropButtonStyle = 132;
const sal_Int32 XML_DropLines = 133;
const sal_Int32 XML_DropStyle = 134;
const sal_Int32 XML_Dx = 135;
const sal_Int32 XML_EMD = 136;
const sal_Int32 XML_ENTITIES = 137;
const sal_Int32 XML_ENTITY = 138;
const sal_Int32 XML_Edit = 139;
const sal_Int32 XML_Edition = 140;
const sal_Int32 XML_Editor = 141;
const sal_Int32 XML_ElectronicSource = 142;
const sal_Int32 XML_Embed = 143;
const sal_Int32 XML_EnhancedMetaFile = 144;
const sal_Int32 XML_ExcelA1 = 145;
const sal_Int32 XML_ExcelR1C1 = 146;
const sal_Int32 XML_Extend = 147;
const sal_Int32 XML_Extension = 148;
const sal_Int32 XML_External = 149;
const sal_Int32 XML_Fallback = 150;
const sal_Int32 XML_False = 151;
const sal_Int32 XML_FieldCodes = 152;
const sal_Int32 XML_FileBinding = 153;
const sal_Int32 XML_FileBindingName = 154;
const sal_Int32 XML_Film = 155;
const sal_Int32 XML_First = 156;
const sal_Int32 XML_FirstButton = 157;
const sal_Int32 XML_FmlaGroup = 158;
const sal_Int32 XML_FmlaLink = 159;
const sal_Int32 XML_FmlaMacro = 160;
const sal_Int32 XML_FmlaPict = 161;
const sal_Int32 XML_FmlaRange = 162;
const sal_Int32 XML_FmlaTxbx = 163;
const sal_Int32 XML_FontCharSet = 164;
const sal_Int32 XML_FontEffects = 165;
const sal_Int32 XML_FontHeight = 166;
const sal_Int32 XML_FontName = 167;
const sal_Int32 XML_FontPitchAndFamily = 168;
const sal_Int32 XML_FontWeight = 169;
const sal_Int32 XML_ForeColor = 170;
const sal_Int32 XML_Format = 171;
const sal_Int32 XML_Formula = 172;
const sal_Int32 XML_GBox = 173;
const sal_Int32 XML_Group = 174;
const sal_Int32 XML_GroupName = 175;
const sal_Int32 XML_Guid = 176;
const sal_Int32 XML_HLinks = 177;
const sal_Int32 XML_HTMLInset = 178;
const sal_Int32 XML_HTMLOutset = 179;
const sal_Int32 XML_HeadingPairs = 180;
const sal_Int32 XML_Help = 181;
const sal_Int32 XML_HiddenSlides = 182;
const sal_Int32 XML_Hiragana = 183;
const sal_Int32 XML_Horiz = 184;
const sal_Int32 XML_HyperlinkBase = 185;
const sal_Int32 XML_HyperlinksChanged = 186;
const sal_Int32 XML_ID = 187;
const sal_Int32 XML_IDREF = 188;
const sal_Int32 XML_IDREFS = 189;
const sal_Int32 XML_Icon = 190;
const sal_Int32 XML_Id = 191;
const sal_Int32 XML_Ignorable = 192;
const sal_Int32 XML_Inc = 193;
const sal_Int32 XML_Institution = 194;
const sal_Int32 XML_Internal = 195;
const sal_Int32 XML_InternetSite = 196;
const sal_Int32 XML_InternetSiteTitle = 197;
const sal_Int32 XML_Interview = 198;
const sal_Int32 XML_Interviewee = 199;
const sal_Int32 XML_Interviewer = 200;
const sal_Int32 XML_Inventor = 201;
const sal_Int32 XML_Issue = 202;
const sal_Int32 XML_JournalArticle = 203;
const sal_Int32 XML_JournalName = 204;
const sal_Int32 XML_JustLastX = 205;
const sal_Int32 XML_Justify = 206;
const sal_Int32 XML_LCID = 207;
const sal_Int32 XML_LCT = 208;
const sal_Int32 XML_Label = 209;
const sal_Int32 XML_LargeChange = 210;
const sal_Int32 XML_Last = 211;
const sal_Int32 XML_Left = 212;
const sal_Int32 XML_LineA = 213;
const sal_Int32 XML_Lines = 214;
const sal_Int32 XML_Link = 215;
const sal_Int32 XML_LinkType = 216;
const sal_Int32 XML_LinksUpToDate = 217;
const sal_Int32 XML_List = 218;
const sal_Int32 XML_ListItem = 219;
const sal_Int32 XML_ListRows = 220;
const sal_Int32 XML_ListStyle = 221;
const sal_Int32 XML_LockText = 222;
const sal_Int32 XML_Locked = 223;
const sal_Int32 XML_LockedField = 224;
const sal_Int32 XML_M1 = 225;
const sal_Int32 XML_M10 = 226;
const sal_Int32 XML_M11 = 227;
const sal_Int32 XML_M12 = 228;
const sal_Int32 XML_M2 = 229;
const sal_Int32 XML_M3 = 230;
const sal_Int32 XML_M4 = 231;
const sal_Int32 XML_M5 = 232;
const sal_Int32 XML_M6 = 233;
const sal_Int32 XML_M7 = 234;
const sal_Int32 XML_M8 = 235;
const sal_Int32 XML_M9 = 236;
const sal_Int32 XML_MDY = 237;
const sal_Int32 XML_MMClips = 238;
const sal_Int32 XML_MYD = 239;
const sal_Int32 XML_Manager = 240;
const sal_Int32 XML_Map = 241;
const sal_Int32 XML_MapInfo = 242;
const sal_Int32 XML_MapOCX = 243;
const sal_Int32 XML_MatchEntry = 244;
const sal_Int32 XML_Max = 245;
const sal_Int32 XML_MaxLength = 246;
const sal_Int32 XML_Medium = 247;
const sal_Int32 XML_Middle = 248;
const sal_Int32 XML_Min = 249;
const sal_Int32 XML_Misc = 250;
const sal_Int32 XML_Month = 251;
const sal_Int32 XML_MonthAccessed = 252;
const sal_Int32 XML_MouseIcon = 253;
const sal_Int32 XML_MousePointer = 254;
const sal_Int32 XML_MoveWithCells = 255;
const sal_Int32 XML_Movie = 256;
const sal_Int32 XML_Multi = 257;
const sal_Int32 XML_MultiLine = 258;
const sal_Int32 XML_MultiSel = 259;
const sal_Int32 XML_MultiSelect = 260;
const sal_Int32 XML_NA = 261;
const sal_Int32 XML_NCName = 262;
const sal_Int32 XML_NMTOKEN = 263;
const sal_Int32 XML_NMTOKENS = 264;
const sal_Int32 XML_NOTATION = 265;
const sal_Int32 XML_Name = 266;
const sal_Int32 XML_NameList = 267;
const sal_Int32 XML_Namespace = 268;
const sal_Int32 XML_NextEnabled = 269;
const sal_Int32 XML_NoThreeD = 270;
const sal_Int32 XML_NoThreeD2 = 271;
const sal_Int32 XML_Note = 272;
const sal_Int32 XML_Notes = 273;
const sal_Int32 XML_NumberVolumes = 274;
const sal_Int32 XML_OLEObject = 275;
const sal_Int32 XML_OLEUPDATE_ALWAYS = 276;
const sal_Int32 XML_OLEUPDATE_ONCALL = 277;
const sal_Int32 XML_ObjectID = 278;
const sal_Int32 XML_ObjectType = 279;
const sal_Int32 XML_OnCall = 280;
const sal_Int32 XML_Orientation = 281;
const sal_Int32 XML_Override = 282;
const sal_Int32 XML_Page = 283;
const sal_Int32 XML_Pages = 284;
const sal_Int32 XML_ParagraphAlign = 285;
const sal_Int32 XML_ParagraphFormat = 286;
const sal_Int32 XML_Paragraphs = 287;
const sal_Int32 XML_PartName = 288;
const sal_Int32 XML_PasswordChar = 289;
const sal_Int32 XML_Patent = 290;
const sal_Int32 XML_PatentNumber = 291;
const sal_Int32 XML_Performance = 292;
const sal_Int32 XML_Performer = 293;
const sal_Int32 XML_PeriodicalTitle = 294;
const sal_Int32 XML_Person = 295;
const sal_Int32 XML_Pict = 296;
const sal_Int32 XML_PictOld = 297;
const sal_Int32 XML_PictPrint = 298;
const sal_Int32 XML_PictScreen = 299;
const sal_Int32 XML_Picture = 300;
const sal_Int32 XML_PictureAlignment = 301;
const sal_Int32 XML_PicturePosition = 302;
const sal_Int32 XML_PictureTiling = 303;
const sal_Int32 XML_Position = 304;
const sal_Int32 XML_PresentationFormat = 305;
const sal_Int32 XML_PreserveFormat = 306;
const sal_Int32 XML_PreserveSortAFLayout = 307;
const sal_Int32 XML_PrevEnabled = 308;
const sal_Int32 XML_PrintObject = 309;
const sal_Int32 XML_ProducerName = 310;
const sal_Int32 XML_ProductionCompany = 311;
const sal_Int32 XML_ProgID = 312;
const sal_Int32 XML_Properties = 313;
const sal_Int32 XML_ProportionalThumb = 314;
const sal_Int32 XML_PublicationTitle = 315;
const sal_Int32 XML_Publisher = 316;
const sal_Int32 XML_Q1 = 317;
const sal_Int32 XML_Q2 = 318;
const sal_Int32 XML_Q3 = 319;
const sal_Int32 XML_Q4 = 320;
const sal_Int32 XML_QName = 321;
const sal_Int32 XML_R1C1 = 322;
const sal_Int32 XML_Radio = 323;
const sal_Int32 XML_RecalcAlways = 324;
const sal_Int32 XML_RecordingNumber = 325;
const sal_Int32 XML_Rect = 326;
const sal_Int32 XML_RectA = 327;
const sal_Int32 XML_RefOrder = 328;
const sal_Int32 XML_Relationship = 329;
const sal_Int32 XML_RelationshipReference = 330;
const sal_Int32 XML_Relationships = 331;
const sal_Int32 XML_RelationshipsGroupReference = 332;
const sal_Int32 XML_Report = 333;
const sal_Int32 XML_Reporter = 334;
const sal_Int32 XML_Requires = 335;
const sal_Int32 XML_Right = 336;
const sal_Int32 XML_RootElement = 337;
const sal_Int32 XML_Row = 338;
const sal_Int32 XML_RowHidden = 339;
const sal_Int32 XML_ScaleCrop = 340;
const sal_Int32 XML_Schema = 341;
const sal_Int32 XML_SchemaID = 342;
const sal_Int32 XML_SchemaRef = 343;
const sal_Int32 XML_ScriptExtended = 344;
const sal_Int32 XML_ScriptLanguage = 345;
const sal_Int32 XML_ScriptLocation = 346;
const sal_Int32 XML_ScriptText = 347;
const sal_Int32 XML_Scroll = 348;
const sal_Int32 XML_ScrollBars = 349;
const sal_Int32 XML_SecretEdit = 350;
const sal_Int32 XML_Sel = 351;
const sal_Int32 XML_SelType = 352;
const sal_Int32 XML_SelectedStyle = 353;
const sal_Int32 XML_SelectionNamespaces = 354;
const sal_Int32 XML_Shape = 355;
const sal_Int32 XML_ShapeID = 356;
const sal_Int32 XML_SharedDoc = 357;
const sal_Int32 XML_ShortTitle = 358;
const sal_Int32 XML_ShowDropButtonWhen = 359;
const sal_Int32 XML_ShowImportExportValidationErrors = 360;
const sal_Int32 XML_SignatureTime = 361;
const sal_Int32 XML_Simple = 362;
const sal_Int32 XML_Single = 363;
const sal_Int32 XML_Size = 364;
const sal_Int32 XML_SizeMode = 365;
const sal_Int32 XML_SizeWithCells = 366;
const sal_Int32 XML_Slides = 367;
const sal_Int32 XML_SmallChange = 368;
const sal_Int32 XML_SoundRecording = 369;
const sal_Int32 XML_Source = 370;
const sal_Int32 XML_SourceId = 371;
const sal_Int32 XML_SourceType = 372;
const sal_Int32 XML_Sources = 373;
const sal_Int32 XML_SpecialEffect = 374;
const sal_Int32 XML_Spin = 375;
const sal_Int32 XML_StandardNumber = 376;
const sal_Int32 XML_StateProvince = 377;
const sal_Int32 XML_Station = 378;
const sal_Int32 XML_StyleName = 379;
const sal_Int32 XML_Tag = 380;
const sal_Int32 XML_TakeFocusOnClick = 381;
const sal_Int32 XML_Target = 382;
const sal_Int32 XML_TargetMode = 383;
const sal_Int32 XML_Template = 384;
const sal_Int32 XML_TextHAlign = 385;
const sal_Int32 XML_TextVAlign = 386;
const sal_Int32 XML_Theater = 387;
const sal_Int32 XML_ThesisType = 388;
const sal_Int32 XML_Title = 389;
const sal_Int32 XML_TitlesOfParts = 390;
const sal_Int32 XML_Top = 391;
const sal_Int32 XML_TotalTime = 392;
const sal_Int32 XML_Translator = 393;
const sal_Int32 XML_True = 394;
const sal_Int32 XML_Type = 395;
const sal_Int32 XML_Types = 396;
const sal_Int32 XML_UIObj = 397;
const sal_Int32 XML_Unspecified = 398;
const sal_Int32 XML_URI = 399;
const sal_Int32 XML_URL = 400;
const sal_Int32 XML_UpdateMode = 401;
const sal_Int32 XML_VScroll = 402;
const sal_Int32 XML_VTEdit = 403;
const sal_Int32 XML_Val = 404;
const sal_Int32 XML_ValidIds = 405;
const sal_Int32 XML_Value = 406;
const sal_Int32 XML_VariousPropertyBits = 407;
const sal_Int32 XML_Version = 408;
const sal_Int32 XML_Visible = 409;
const sal_Int32 XML_Volume = 410;
const sal_Int32 XML_WidthMin = 411;
const sal_Int32 XML_Words = 412;
const sal_Int32 XML_Writer = 413;
const sal_Int32 XML_XY = 414;
const sal_Int32 XML_YDM = 415;
const sal_Int32 XML_YMD = 416;
const sal_Int32 XML_YZ = 417;
const sal_Int32 XML_Year = 418;
const sal_Int32 XML_YearAccessed = 419;
const sal_Int32 XML_ZX = 420;
const sal_Int32 XML_a = 421;
const sal_Int32 XML_a14 = 422;
const sal_Int32 XML_aa = 423;
const sal_Int32 XML_above = 424;
const sal_Int32 XML_aboveAverage = 425;
const sal_Int32 XML_absSizeAnchor = 426;
const sal_Int32 XML_absolute = 427;
const sal_Int32 XML_absoluteAnchor = 428;
const sal_Int32 XML_abstractNum = 429;
const sal_Int32 XML_abstractNumId = 430;
const sal_Int32 XML_aca = 431;
const sal_Int32 XML_acc = 432;
const sal_Int32 XML_accPr = 433;
const sal_Int32 XML_accel = 434;
const sal_Int32 XML_accent1 = 435;
const sal_Int32 XML_accent2 = 436;
const sal_Int32 XML_accent3 = 437;
const sal_Int32 XML_accent4 = 438;
const sal_Int32 XML_accent5 = 439;
const sal_Int32 XML_accent6 = 440;
const sal_Int32 XML_accentBorderCallout1 = 441;
const sal_Int32 XML_accentBorderCallout2 = 442;
const sal_Int32 XML_accentBorderCallout3 = 443;
const sal_Int32 XML_accentCallout1 = 444;
const sal_Int32 XML_accentCallout2 = 445;
const sal_Int32 XML_accentCallout3 = 446;
const sal_Int32 XML_accentbar = 447;
const sal_Int32 XML_accumulate = 448;
const sal_Int32 XML_action = 449;
const sal_Int32 XML_actionButtonBackPrevious = 450;
const sal_Int32 XML_actionButtonBeginning = 451;
const sal_Int32 XML_actionButtonBlank = 452;
const sal_Int32 XML_actionButtonDocument = 453;
const sal_Int32 XML_actionButtonEnd = 454;
const sal_Int32 XML_actionButtonForwardNext = 455;
const sal_Int32 XML_actionButtonHelp = 456;
const sal_Int32 XML_actionButtonHome = 457;
const sal_Int32 XML_actionButtonInformation = 458;
const sal_Int32 XML_actionButtonMovie = 459;
const sal_Int32 XML_actionButtonReturn = 460;
const sal_Int32 XML_actionButtonSound = 461;
const sal_Int32 XML_active = 462;
const sal_Int32 XML_activeBorder = 463;
const sal_Int32 XML_activeCaption = 464;
const sal_Int32 XML_activeCell = 465;
const sal_Int32 XML_activeCellId = 466;
const sal_Int32 XML_activeCol = 467;
const sal_Int32 XML_activePane = 468;
const sal_Int32 XML_activeRecord = 469;
const sal_Int32 XML_activeRow = 470;
const sal_Int32 XML_activeSheetId = 471;
const sal_Int32 XML_activeTab = 472;
const sal_Int32 XML_activeWritingStyle = 473;
const sal_Int32 XML_actualPg = 474;
const sal_Int32 XML_ad = 475;
const sal_Int32 XML_add = 476;
const sal_Int32 XML_additionalCharacteristics = 477;
const sal_Int32 XML_additive = 478;
const sal_Int32 XML_addlxml = 479;
const sal_Int32 XML_addressBook = 480;
const sal_Int32 XML_addressFieldName = 481;
const sal_Int32 XML_adec = 482;
const sal_Int32 XML_adj = 483;
const sal_Int32 XML_adjLst = 484;
const sal_Int32 XML_adjust = 485;
const sal_Int32 XML_adjustColumnWidth = 486;
const sal_Int32 XML_adjustLineHeightInTable = 487;
const sal_Int32 XML_adjustRightInd = 488;
const sal_Int32 XML_adjusthandles = 489;
const sal_Int32 XML_administrators = 490;
const sal_Int32 XML_advAuto = 491;
const sal_Int32 XML_advClick = 492;
const sal_Int32 XML_advTm = 493;
const sal_Int32 XML_advise = 494;
const sal_Int32 XML_aft = 495;
const sal_Int32 XML_after = 496;
const sal_Int32 XML_afterAutospacing = 497;
const sal_Int32 XML_afterEffect = 498;
const sal_Int32 XML_afterGroup = 499;
const sal_Int32 XML_afterLines = 500;
const sal_Int32 XML_ahLst = 501;
const sal_Int32 XML_ahPolar = 502;
const sal_Int32 XML_ahXY = 503;
const sal_Int32 XML_aiueo = 504;
const sal_Int32 XML_aiueoFullWidth = 505;
const sal_Int32 XML_alg = 506;
const sal_Int32 XML_algIdExt = 507;
const sal_Int32 XML_algIdExtSource = 508;
const sal_Int32 XML_algn = 509;
const sal_Int32 XML_algorithmName = 510;
const sal_Int32 XML_alias = 511;
const sal_Int32 XML_aliases = 512;
const sal_Int32 XML_aliceBlue = 513;
const sal_Int32 XML_align = 514;
const sal_Int32 XML_alignBordersAndEdges = 515;
const sal_Int32 XML_alignOff = 516;
const sal_Int32 XML_alignTablesRowByRow = 517;
const sal_Int32 XML_alignTx = 518;
const sal_Int32 XML_alignWithMargins = 519;
const sal_Int32 XML_alignment = 520;
const sal_Int32 XML_alignshape = 521;
const sal_Int32 XML_all = 522;
const sal_Int32 XML_allAtOnce = 523;
const sal_Int32 XML_allCaption = 524;
const sal_Int32 XML_allDrilled = 525;
const sal_Int32 XML_allLines = 526;
const sal_Int32 XML_allPages = 527;
const sal_Int32 XML_allPts = 528;
const sal_Int32 XML_allUniqueName = 529;
const sal_Int32 XML_allowBlank = 530;
const sal_Int32 XML_allowOverlap = 531;
const sal_Int32 XML_allowPNG = 532;
const sal_Int32 XML_allowPng = 533;
const sal_Int32 XML_allowRefreshQuery = 534;
const sal_Int32 XML_allowSpaceOfSameStyleInTable = 535;
const sal_Int32 XML_allowcomments = 536;
const sal_Int32 XML_allowincell = 537;
const sal_Int32 XML_allowoverlap = 538;
const sal_Int32 XML_aln = 539;
const sal_Int32 XML_alnAt = 540;
const sal_Int32 XML_alnScr = 541;
const sal_Int32 XML_alongPath = 542;
const sal_Int32 XML_alpha = 543;
const sal_Int32 XML_alphaBiLevel = 544;
const sal_Int32 XML_alphaCeiling = 545;
const sal_Int32 XML_alphaFloor = 546;
const sal_Int32 XML_alphaInv = 547;
const sal_Int32 XML_alphaLcParenBoth = 548;
const sal_Int32 XML_alphaLcParenR = 549;
const sal_Int32 XML_alphaLcPeriod = 550;
const sal_Int32 XML_alphaMod = 551;
const sal_Int32 XML_alphaModFix = 552;
const sal_Int32 XML_alphaOff = 553;
const sal_Int32 XML_alphaOutset = 554;
const sal_Int32 XML_alphaRepl = 555;
const sal_Int32 XML_alphaUcParenBoth = 556;
const sal_Int32 XML_alphaUcParenR = 557;
const sal_Int32 XML_alphaUcPeriod = 558;
const sal_Int32 XML_alt = 559;
const sal_Int32 XML_altChunk = 560;
const sal_Int32 XML_altChunkPr = 561;
const sal_Int32 XML_altLang = 562;
const sal_Int32 XML_altName = 563;
const sal_Int32 XML_althref = 564;
const sal_Int32 XML_always = 565;
const sal_Int32 XML_alwaysMergeEmptyNamespace = 566;
const sal_Int32 XML_alwaysShow = 567;
const sal_Int32 XML_alwaysShowPlaceholderText = 568;
const sal_Int32 XML_amount = 569;
const sal_Int32 XML_amt = 570;
const sal_Int32 XML_anchor = 571;
const sal_Int32 XML_anchorCtr = 572;
const sal_Int32 XML_anchorId = 573;
const sal_Int32 XML_anchorLock = 574;
const sal_Int32 XML_anchorlock = 575;
const sal_Int32 XML_anchorx = 576;
const sal_Int32 XML_anchory = 577;
const sal_Int32 XML_ancst = 578;
const sal_Int32 XML_ancstOrSelf = 579;
const sal_Int32 XML_and = 580;
const sal_Int32 XML_ang = 581;
const sal_Int32 XML_angle = 582;
const sal_Int32 XML_anim = 583;
const sal_Int32 XML_animBg = 584;
const sal_Int32 XML_animClr = 585;
const sal_Int32 XML_animEffect = 586;
const sal_Int32 XML_animLvl = 587;
const sal_Int32 XML_animMotion = 588;
const sal_Int32 XML_animOne = 589;
const sal_Int32 XML_animRot = 590;
const sal_Int32 XML_animScale = 591;
const sal_Int32 XML_annotation = 592;
const sal_Int32 XML_annotationRef = 593;
const sal_Int32 XML_antiqueWhite = 594;
const sal_Int32 XML_antsBlack = 595;
const sal_Int32 XML_antsRed = 596;
const sal_Int32 XML_any = 597;
const sal_Int32 XML_anyType = 598;
const sal_Int32 XML_anyURI = 599;
const sal_Int32 XML_appName = 600;
const sal_Int32 XML_appWorkspace = 601;
const sal_Int32 XML_appearance = 602;
const sal_Int32 XML_apples = 603;
const sal_Int32 XML_applyAlignment = 604;
const sal_Int32 XML_applyAlignmentFormats = 605;
const sal_Int32 XML_applyBorder = 606;
const sal_Int32 XML_applyBorderFormats = 607;
const sal_Int32 XML_applyBreakingRules = 608;
const sal_Int32 XML_applyFill = 609;
const sal_Int32 XML_applyFont = 610;
const sal_Int32 XML_applyFontFormats = 611;
const sal_Int32 XML_applyNumberFormat = 612;
const sal_Int32 XML_applyNumberFormats = 613;
const sal_Int32 XML_applyPatternFormats = 614;
const sal_Int32 XML_applyProtection = 615;
const sal_Int32 XML_applyStyles = 616;
const sal_Int32 XML_applyToEnd = 617;
const sal_Int32 XML_applyToFront = 618;
const sal_Int32 XML_applyToSides = 619;
const sal_Int32 XML_applyWidthHeightFormats = 620;
const sal_Int32 XML_aqua = 621;
const sal_Int32 XML_aquamarine = 622;
const sal_Int32 XML_ar = 623;
const sal_Int32 XML_arabic1Minus = 624;
const sal_Int32 XML_arabic2Minus = 625;
const sal_Int32 XML_arabicAbjad = 626;
const sal_Int32 XML_arabicAlpha = 627;
const sal_Int32 XML_arabicDbPeriod = 628;
const sal_Int32 XML_arabicDbPlain = 629;
const sal_Int32 XML_arabicParenBoth = 630;
const sal_Int32 XML_arabicParenR = 631;
const sal_Int32 XML_arabicPeriod = 632;
const sal_Int32 XML_arabicPlain = 633;
const sal_Int32 XML_arc = 634;
const sal_Int32 XML_arcTo = 635;
const sal_Int32 XML_archedScallops = 636;
const sal_Int32 XML_arcsize = 637;
const sal_Int32 XML_area = 638;
const sal_Int32 XML_area3DChart = 639;
const sal_Int32 XML_areaChart = 640;
const sal_Int32 XML_areaError = 641;
const sal_Int32 XML_arg = 642;
const sal_Int32 XML_argPr = 643;
const sal_Int32 XML_argSz = 644;
const sal_Int32 XML_around = 645;
const sal_Int32 XML_arr = 646;
const sal_Int32 XML_array = 647;
const sal_Int32 XML_arrow = 648;
const sal_Int32 XML_arrowok = 649;
const sal_Int32 XML_artDeco = 650;
const sal_Int32 XML_artisticBlur = 651;
const sal_Int32 XML_artisticCement = 652;
const sal_Int32 XML_artisticChalkSketch = 653;
const sal_Int32 XML_artisticCrisscrossEtching = 654;
const sal_Int32 XML_artisticCutout = 655;
const sal_Int32 XML_artisticFilmGrain = 656;
const sal_Int32 XML_artisticGlass = 657;
const sal_Int32 XML_artisticGlowDiffused = 658;
const sal_Int32 XML_artisticGlowEdges = 659;
const sal_Int32 XML_artisticLightScreen = 660;
const sal_Int32 XML_artisticLineDrawing = 661;
const sal_Int32 XML_artisticMarker = 662;
const sal_Int32 XML_artisticMosiaicBubbles = 663;
const sal_Int32 XML_artisticPaintBrush = 664;
const sal_Int32 XML_artisticPaintStrokes = 665;
const sal_Int32 XML_artisticPastelsSmooth = 666;
const sal_Int32 XML_artisticPencilGrayscale = 667;
const sal_Int32 XML_artisticPencilSketch = 668;
const sal_Int32 XML_artisticPhotocopy = 669;
const sal_Int32 XML_artisticPlasticWrap = 670;
const sal_Int32 XML_artisticTexturizer = 671;
const sal_Int32 XML_artisticWatercolorSponge = 672;
const sal_Int32 XML_asDisplayed = 673;
const sal_Int32 XML_ascending = 674;
const sal_Int32 XML_ascendingAlpha = 675;
const sal_Int32 XML_ascendingNatural = 676;
const sal_Int32 XML_ascii = 677;
const sal_Int32 XML_asciiTheme = 678;
const sal_Int32 XML_aspect = 679;
const sal_Int32 XML_aspectratio = 680;
const sal_Int32 XML_assign = 681;
const sal_Int32 XML_asst = 682;
const sal_Int32 XML_asteriskTotals = 683;
const sal_Int32 XML_asvg = 684;
const sal_Int32 XML_atEnd = 685;
const sal_Int32 XML_atLeast = 686;
const sal_Int32 XML_atMost = 687;
const sal_Int32 XML_attachedSchema = 688;
const sal_Int32 XML_attachedTemplate = 689;
const sal_Int32 XML_attr = 690;
const sal_Int32 XML_attrName = 691;
const sal_Int32 XML_attrNameLst = 692;
const sal_Int32 XML_attribute = 693;
const sal_Int32 XML_audio = 694;
const sal_Int32 XML_audioCd = 695;
const sal_Int32 XML_audioFile = 696;
const sal_Int32 XML_author = 697;
const sal_Int32 XML_authorId = 698;
const sal_Int32 XML_authors = 699;
const sal_Int32 XML_auto = 700;
const sal_Int32 XML_autoAdjust = 701;
const sal_Int32 XML_autoCaption = 702;
const sal_Int32 XML_autoCaptions = 703;
const sal_Int32 XML_autoCompressPictures = 704;
const sal_Int32 XML_autoEnd = 705;
const sal_Int32 XML_autoExp = 706;
const sal_Int32 XML_autoFill = 707;
const sal_Int32 XML_autoFilter = 708;
const sal_Int32 XML_autoFilterDateGrouping = 709;
const sal_Int32 XML_autoFormatId = 710;
const sal_Int32 XML_autoFormatOverride = 711;
const sal_Int32 XML_autoHyphenation = 712;
const sal_Int32 XML_autoLine = 713;
const sal_Int32 XML_autoLoad = 714;
const sal_Int32 XML_autoNoTable = 715;
const sal_Int32 XML_autoPage = 716;
const sal_Int32 XML_autoPageBreaks = 717;
const sal_Int32 XML_autoPict = 718;
const sal_Int32 XML_autoRecover = 719;
const sal_Int32 XML_autoRedefine = 720;
const sal_Int32 XML_autoRepublish = 721;
const sal_Int32 XML_autoRev = 722;
const sal_Int32 XML_autoScale = 723;
const sal_Int32 XML_autoShow = 724;
const sal_Int32 XML_autoSortScope = 725;
const sal_Int32 XML_autoSpaceDE = 726;
const sal_Int32 XML_autoSpaceDN = 727;
const sal_Int32 XML_autoSpaceLikeWord95 = 728;
const sal_Int32 XML_autoStart = 729;
const sal_Int32 XML_autoText = 730;
const sal_Int32 XML_autoTitleDeleted = 731;
const sal_Int32 XML_autoTxRot = 732;
const sal_Int32 XML_autoTxt = 733;
const sal_Int32 XML_autoUpdate = 734;
const sal_Int32 XML_autoUpdateAnimBg = 735;
const sal_Int32 XML_autoZero = 736;
const sal_Int32 XML_autofit = 737;
const sal_Int32 XML_autofitToFirstFixedWidthCell = 738;
const sal_Int32 XML_autoformat = 739;
const sal_Int32 XML_autolayout = 740;
const sal_Int32 XML_autorotationcenter = 741;
const sal_Int32 XML_avLst = 742;
const sal_Int32 XML_average = 743;
const sal_Int32 XML_avg = 744;
const sal_Int32 XML_avgSubtotal = 745;
const sal_Int32 XML_ax = 746;
const sal_Int32 XML_axId = 747;
const sal_Int32 XML_axPos = 748;
const sal_Int32 XML_axis = 749;
const sal_Int32 XML_axisCol = 750;
const sal_Int32 XML_axisColor = 751;
const sal_Int32 XML_axisPage = 752;
const sal_Int32 XML_axisPosition = 753;
const sal_Int32 XML_axisRow = 754;
const sal_Int32 XML_axisValues = 755;
const sal_Int32 XML_azure = 756;
const sal_Int32 XML_b = 757;
const sal_Int32 XML_bCs = 758;
const sal_Int32 XML_bCtr = 759;
const sal_Int32 XML_bCtrCh = 760;
const sal_Int32 XML_bCtrDes = 761;
const sal_Int32 XML_bIns = 762;
const sal_Int32 XML_bL = 763;
const sal_Int32 XML_bMarg = 764;
const sal_Int32 XML_bOff = 765;
const sal_Int32 XML_bR = 766;
const sal_Int32 XML_babyPacifier = 767;
const sal_Int32 XML_babyRattle = 768;
const sal_Int32 XML_back = 769;
const sal_Int32 XML_backWall = 770;
const sal_Int32 XML_backdepth = 771;
const sal_Int32 XML_backdrop = 772;
const sal_Int32 XML_background = 773;
const sal_Int32 XML_background1 = 774;
const sal_Int32 XML_background2 = 775;
const sal_Int32 XML_backgroundQuery = 776;
const sal_Int32 XML_backgroundRefresh = 777;
const sal_Int32 XML_backgroundRemoval = 778;
const sal_Int32 XML_backupFile = 779;
const sal_Int32 XML_backward = 780;
const sal_Int32 XML_backwardCompatible = 781;
const sal_Int32 XML_backwards = 782;
const sal_Int32 XML_bal = 783;
const sal_Int32 XML_balanceSingleByteDoubleByteWidth = 784;
const sal_Int32 XML_balanced = 785;
const sal_Int32 XML_balloons3Colors = 786;
const sal_Int32 XML_balloonsHotAir = 787;
const sal_Int32 XML_band1H = 788;
const sal_Int32 XML_band1Horz = 789;
const sal_Int32 XML_band1V = 790;
const sal_Int32 XML_band1Vert = 791;
const sal_Int32 XML_band2H = 792;
const sal_Int32 XML_band2Horz = 793;
const sal_Int32 XML_band2V = 794;
const sal_Int32 XML_band2Vert = 795;
const sal_Int32 XML_bandCol = 796;
const sal_Int32 XML_bandFmt = 797;
const sal_Int32 XML_bandFmts = 798;
const sal_Int32 XML_bandRow = 799;
const sal_Int32 XML_banner = 800;
const sal_Int32 XML_bar = 801;
const sal_Int32 XML_bar3DChart = 802;
const sal_Int32 XML_barChart = 803;
const sal_Int32 XML_barDir = 804;
const sal_Int32 XML_barPr = 805;
const sal_Int32 XML_base = 806;
const sal_Int32 XML_base64Binary = 807;
const sal_Int32 XML_baseColWidth = 808;
const sal_Int32 XML_baseField = 809;
const sal_Int32 XML_baseItem = 810;
const sal_Int32 XML_baseJc = 811;
const sal_Int32 XML_baseTimeUnit = 812;
const sal_Int32 XML_baseType = 813;
const sal_Int32 XML_basedOn = 814;
const sal_Int32 XML_baseline = 815;
const sal_Int32 XML_basicBlackDashes = 816;
const sal_Int32 XML_basicBlackDots = 817;
const sal_Int32 XML_basicBlackSquares = 818;
const sal_Int32 XML_basicThinLines = 819;
const sal_Int32 XML_basicWhiteDashes = 820;
const sal_Int32 XML_basicWhiteDots = 821;
const sal_Int32 XML_basicWhiteSquares = 822;
const sal_Int32 XML_basicWideInline = 823;
const sal_Int32 XML_basicWideMidline = 824;
const sal_Int32 XML_basicWideOutline = 825;
const sal_Int32 XML_bats = 826;
const sal_Int32 XML_bbPlcHdr = 827;
const sal_Int32 XML_bc = 828;
const sal_Int32 XML_bdr = 829;
const sal_Int32 XML_bef = 830;
const sal_Int32 XML_before = 831;
const sal_Int32 XML_beforeAutospacing = 832;
const sal_Int32 XML_beforeLines = 833;
const sal_Int32 XML_beg = 834;
const sal_Int32 XML_begChr = 835;
const sal_Int32 XML_begMarg = 836;
const sal_Int32 XML_begPad = 837;
const sal_Int32 XML_begPts = 838;
const sal_Int32 XML_begSty = 839;
const sal_Int32 XML_begin = 840;
const sal_Int32 XML_beginsWith = 841;
const sal_Int32 XML_behavior = 842;
const sal_Int32 XML_behaviors = 843;
const sal_Int32 XML_behindDoc = 844;
const sal_Int32 XML_beige = 845;
const sal_Int32 XML_below = 846;
const sal_Int32 XML_belowAverage = 847;
const sal_Int32 XML_bend = 848;
const sal_Int32 XML_bendDist = 849;
const sal_Int32 XML_bendPt = 850;
const sal_Int32 XML_beneathText = 851;
const sal_Int32 XML_bentArrow = 852;
const sal_Int32 XML_bentConnector2 = 853;
const sal_Int32 XML_bentConnector3 = 854;
const sal_Int32 XML_bentConnector4 = 855;
const sal_Int32 XML_bentConnector5 = 856;
const sal_Int32 XML_bentUpArrow = 857;
const sal_Int32 XML_bestFit = 858;
const sal_Int32 XML_between = 859;
const sal_Int32 XML_bevel = 860;
const sal_Int32 XML_bevelB = 861;
const sal_Int32 XML_bevelT = 862;
const sal_Int32 XML_bg = 863;
const sal_Int32 XML_bg1 = 864;
const sal_Int32 XML_bg2 = 865;
const sal_Int32 XML_bgClr = 866;
const sal_Int32 XML_bgColor = 867;
const sal_Int32 XML_bgFillStyleLst = 868;
const sal_Int32 XML_bgPr = 869;
const sal_Int32 XML_bgRef = 870;
const sal_Int32 XML_bi = 871;
const sal_Int32 XML_biLevel = 872;
const sal_Int32 XML_bib = 873;
const sal_Int32 XML_bibliography = 874;
const sal_Int32 XML_bidi = 875;
const sal_Int32 XML_bidiVisual = 876;
const sal_Int32 XML_bilevel = 877;
const sal_Int32 XML_billions = 878;
const sal_Int32 XML_birds = 879;
const sal_Int32 XML_birdsFlight = 880;
const sal_Int32 XML_bisque = 881;
const sal_Int32 XML_bk = 882;
const sal_Int32 XML_bkPtFixedVal = 883;
const sal_Int32 XML_bkpt = 884;
const sal_Int32 XML_bl = 885;
const sal_Int32 XML_black = 886;
const sal_Int32 XML_blackAndWhite = 887;
const sal_Int32 XML_blackGray = 888;
const sal_Int32 XML_blackTextAndLines = 889;
const sal_Int32 XML_blackTextOnWhite = 890;
const sal_Int32 XML_blackWhite = 891;
const sal_Int32 XML_blacklevel = 892;
const sal_Int32 XML_blanchedAlmond = 893;
const sal_Int32 XML_blank = 894;
const sal_Int32 XML_blankRow = 895;
const sal_Int32 XML_bld = 896;
const sal_Int32 XML_bldAsOne = 897;
const sal_Int32 XML_bldChart = 898;
const sal_Int32 XML_bldDgm = 899;
const sal_Int32 XML_bldGraphic = 900;
const sal_Int32 XML_bldLst = 901;
const sal_Int32 XML_bldLvl = 902;
const sal_Int32 XML_bldOleChart = 903;
const sal_Int32 XML_bldP = 904;
const sal_Int32 XML_bldStep = 905;
const sal_Int32 XML_bldSub = 906;
const sal_Int32 XML_blend = 907;
const sal_Int32 XML_blinds = 908;
const sal_Int32 XML_blinkBackground = 909;
const sal_Int32 XML_blip = 910;
const sal_Int32 XML_blipFill = 911;
const sal_Int32 XML_blipPhldr = 912;
const sal_Int32 XML_blob = 913;
const sal_Int32 XML_block = 914;
const sal_Int32 XML_blockArc = 915;
const sal_Int32 XML_blockQuote = 916;
const sal_Int32 XML_blue = 917;
const sal_Int32 XML_blueMod = 918;
const sal_Int32 XML_blueOff = 919;
const sal_Int32 XML_blueViolet = 920;
const sal_Int32 XML_blur = 921;
const sal_Int32 XML_blurRad = 922;
const sal_Int32 XML_bmk = 923;
const sal_Int32 XML_body = 924;
const sal_Int32 XML_bodyDiv = 925;
const sal_Int32 XML_bodyPr = 926;
const sal_Int32 XML_bodyStyle = 927;
const sal_Int32 XML_bold = 928;
const sal_Int32 XML_boldItalic = 929;
const sal_Int32 XML_bookFoldPrinting = 930;
const sal_Int32 XML_bookFoldPrintingSheets = 931;
const sal_Int32 XML_bookFoldRevPrinting = 932;
const sal_Int32 XML_bookViews = 933;
const sal_Int32 XML_bookmarkEnd = 934;
const sal_Int32 XML_bookmarkIdSeed = 935;
const sal_Int32 XML_bookmarkStart = 936;
const sal_Int32 XML_bool = 937;
const sal_Int32 XML_boolVal = 938;
const sal_Int32 XML_boolean = 939;
const sal_Int32 XML_border = 940;
const sal_Int32 XML_borderBox = 941;
const sal_Int32 XML_borderBoxPr = 942;
const sal_Int32 XML_borderCallout1 = 943;
const sal_Int32 XML_borderCallout2 = 944;
const sal_Int32 XML_borderCallout3 = 945;
const sal_Int32 XML_borderId = 946;
const sal_Int32 XML_borderbottom = 947;
const sal_Int32 XML_borderbottomcolor = 948;
const sal_Int32 XML_borderleft = 949;
const sal_Int32 XML_borderleftcolor = 950;
const sal_Int32 XML_borderright = 951;
const sal_Int32 XML_borderrightcolor = 952;
const sal_Int32 XML_borders = 953;
const sal_Int32 XML_bordersDoNotSurroundFooter = 954;
const sal_Int32 XML_bordersDoNotSurroundHeader = 955;
const sal_Int32 XML_bordertop = 956;
const sal_Int32 XML_bordertopcolor = 957;
const sal_Int32 XML_bot = 958;
const sal_Int32 XML_both = 959;
const sal_Int32 XML_bothSides = 960;
const sal_Int32 XML_bottom = 961;
const sal_Int32 XML_bottomFromText = 962;
const sal_Int32 XML_bottomLeft = 963;
const sal_Int32 XML_bottomMargin = 964;
const sal_Int32 XML_bottomRight = 965;
const sal_Int32 XML_boundingCube = 966;
const sal_Int32 XML_box = 967;
const sal_Int32 XML_boxPr = 968;
const sal_Int32 XML_br = 969;
const sal_Int32 XML_bracePair = 970;
const sal_Int32 XML_bracketPair = 971;
const sal_Int32 XML_branch = 972;
const sal_Int32 XML_breadthByLvl = 973;
const sal_Int32 XML_breadthByNode = 974;
const sal_Int32 XML_bright = 975;
const sal_Int32 XML_brightRoom = 976;
const sal_Int32 XML_brightness = 977;
const sal_Int32 XML_brightnessContrast = 978;
const sal_Int32 XML_brk = 979;
const sal_Int32 XML_brkBin = 980;
const sal_Int32 XML_brkBinSub = 981;
const sal_Int32 XML_brown = 982;
const sal_Int32 XML_browse = 983;
const sal_Int32 XML_browser = 984;
const sal_Int32 XML_brushSize = 985;
const sal_Int32 XML_bstr = 986;
const sal_Int32 XML_btLr = 987;
const sal_Int32 XML_btnFace = 988;
const sal_Int32 XML_btnHighlight = 989;
const sal_Int32 XML_btnShadow = 990;
const sal_Int32 XML_btnText = 991;
const sal_Int32 XML_buAutoNum = 992;
const sal_Int32 XML_buBlip = 993;
const sal_Int32 XML_buChar = 994;
const sal_Int32 XML_buClr = 995;
const sal_Int32 XML_buClrTx = 996;
const sal_Int32 XML_buFont = 997;
const sal_Int32 XML_buFontTx = 998;
const sal_Int32 XML_buNone = 999;
const sal_Int32 XML_buSzPct = 1000;
const sal_Int32 XML_buSzPts = 1001;
const sal_Int32 XML_buSzTx = 1002;
const sal_Int32 XML_bubble3D = 1003;
const sal_Int32 XML_bubbleChart = 1004;
const sal_Int32 XML_bubbleScale = 1005;
const sal_Int32 XML_bubbleSize = 1006;
const sal_Int32 XML_build = 1007;
const sal_Int32 XML_builtIn = 1008;
const sal_Int32 XML_builtInGroupCount = 1009;
const sal_Int32 XML_builtInUnit = 1010;
const sal_Int32 XML_builtinId = 1011;
const sal_Int32 XML_bulEnabled = 1012;
const sal_Int32 XML_bullet = 1013;
const sal_Int32 XML_bulletEnabled = 1014;
const sal_Int32 XML_bullseye = 1015;
const sal_Int32 XML_burlyWood = 1016;
const sal_Int32 XML_button = 1017;
const sal_Int32 XML_bw = 1018;
const sal_Int32 XML_bwMode = 1019;
const sal_Int32 XML_bwmode = 1020;
const sal_Int32 XML_bwnormal = 1021;
const sal_Int32 XML_bwpure = 1022;
const sal_Int32 XML_bx = 1023;
const sal_Int32 XML_by = 1024;
const sal_Int32 XML_byPosition = 1025;
const sal_Int32 XML_byte = 1026;
const sal_Int32 XML_c = 1027;
const sal_Int32 XML_c15 = 1028;
const sal_Int32 XML_cBhvr = 1029;
const sal_Int32 XML_cdr = 1030;
const sal_Int32 XML_cGp = 1031;
const sal_Int32 XML_cGpRule = 1032;
const sal_Int32 XML_cMediaNode = 1033;
const sal_Int32 XML_cNvCnPr = 1034;
const sal_Int32 XML_cNvCxnSpPr = 1035;
const sal_Int32 XML_cNvGraphicFramePr = 1036;
const sal_Int32 XML_cNvGrpSpPr = 1037;
const sal_Int32 XML_cNvPicPr = 1038;
const sal_Int32 XML_cNvPr = 1039;
const sal_Int32 XML_cNvSpPr = 1040;
const sal_Int32 XML_cSld = 1041;
const sal_Int32 XML_cSldViewPr = 1042;
const sal_Int32 XML_cSp = 1043;
const sal_Int32 XML_cTn = 1044;
const sal_Int32 XML_cViewPr = 1045;
const sal_Int32 XML_ca = 1046;
const sal_Int32 XML_cabins = 1047;
const sal_Int32 XML_cacheField = 1048;
const sal_Int32 XML_cacheFields = 1049;
const sal_Int32 XML_cacheHierarchies = 1050;
const sal_Int32 XML_cacheHierarchy = 1051;
const sal_Int32 XML_cacheId = 1052;
const sal_Int32 XML_cacheIndex = 1053;
const sal_Int32 XML_cacheSource = 1054;
const sal_Int32 XML_cachedColBalance = 1055;
const sal_Int32 XML_cadetBlue = 1056;
const sal_Int32 XML_cakeSlice = 1057;
const sal_Int32 XML_calcChain = 1058;
const sal_Int32 XML_calcCompleted = 1059;
const sal_Int32 XML_calcId = 1060;
const sal_Int32 XML_calcMode = 1061;
const sal_Int32 XML_calcOnExit = 1062;
const sal_Int32 XML_calcOnSave = 1063;
const sal_Int32 XML_calcPr = 1064;
const sal_Int32 XML_calcmode = 1065;
const sal_Int32 XML_calculated = 1066;
const sal_Int32 XML_calculatedColumn = 1067;
const sal_Int32 XML_calculatedColumnFormula = 1068;
const sal_Int32 XML_calculatedItem = 1069;
const sal_Int32 XML_calculatedItems = 1070;
const sal_Int32 XML_calculatedMember = 1071;
const sal_Int32 XML_calculatedMembers = 1072;
const sal_Int32 XML_calendar = 1073;
const sal_Int32 XML_calendarType = 1074;
const sal_Int32 XML_call = 1075;
const sal_Int32 XML_callout = 1076;
const sal_Int32 XML_callout1 = 1077;
const sal_Int32 XML_callout2 = 1078;
const sal_Int32 XML_callout3 = 1079;
const sal_Int32 XML_camera = 1080;
const sal_Int32 XML_can = 1081;
const sal_Int32 XML_canSlip = 1082;
const sal_Int32 XML_candyCorn = 1083;
const sal_Int32 XML_cantSplit = 1084;
const sal_Int32 XML_canvas = 1085;
const sal_Int32 XML_cap = 1086;
const sal_Int32 XML_caps = 1087;
const sal_Int32 XML_caption = 1088;
const sal_Int32 XML_captionBeginsWith = 1089;
const sal_Int32 XML_captionBetween = 1090;
const sal_Int32 XML_captionContains = 1091;
const sal_Int32 XML_captionEndsWith = 1092;
const sal_Int32 XML_captionEqual = 1093;
const sal_Int32 XML_captionGreaterThan = 1094;
const sal_Int32 XML_captionGreaterThanOrEqual = 1095;
const sal_Int32 XML_captionLessThan = 1096;
const sal_Int32 XML_captionLessThanOrEqual = 1097;
const sal_Int32 XML_captionNotBeginsWith = 1098;
const sal_Int32 XML_captionNotBetween = 1099;
const sal_Int32 XML_captionNotContains = 1100;
const sal_Int32 XML_captionNotEndsWith = 1101;
const sal_Int32 XML_captionNotEqual = 1102;
const sal_Int32 XML_captionText = 1103;
const sal_Int32 XML_captions = 1104;
const sal_Int32 XML_cardinalText = 1105;
const sal_Int32 XML_caseSensitive = 1106;
const sal_Int32 XML_cat = 1107;
const sal_Int32 XML_catAx = 1108;
const sal_Int32 XML_catLst = 1109;
const sal_Int32 XML_catalog = 1110;
const sal_Int32 XML_category = 1111;
const sal_Int32 XML_categoryEl = 1112;
const sal_Int32 XML_categoryIdx = 1113;
const sal_Int32 XML_ccw = 1114;
const sal_Int32 XML_ccwIn = 1115;
const sal_Int32 XML_ccwOut = 1116;
const sal_Int32 XML_cd2 = 1117;
const sal_Int32 XML_cd3 = 1118;
const sal_Int32 XML_cd4 = 1119;
const sal_Int32 XML_cd8 = 1120;
const sal_Int32 XML_cell = 1121;
const sal_Int32 XML_cell3D = 1122;
const sal_Int32 XML_cellColor = 1123;
const sal_Int32 XML_cellComments = 1124;
const sal_Int32 XML_cellDel = 1125;
const sal_Int32 XML_cellIns = 1126;
const sal_Int32 XML_cellIs = 1127;
const sal_Int32 XML_cellMerge = 1128;
const sal_Int32 XML_cellMeta = 1129;
const sal_Int32 XML_cellMetadata = 1130;
const sal_Int32 XML_cellSmartTag = 1131;
const sal_Int32 XML_cellSmartTagPr = 1132;
const sal_Int32 XML_cellSmartTags = 1133;
const sal_Int32 XML_cellStyle = 1134;
const sal_Int32 XML_cellStyleXfs = 1135;
const sal_Int32 XML_cellStyles = 1136;
const sal_Int32 XML_cellWatch = 1137;
const sal_Int32 XML_cellWatches = 1138;
const sal_Int32 XML_cellXfs = 1139;
const sal_Int32 XML_celticKnotwork = 1140;
const sal_Int32 XML_center = 1141;
const sal_Int32 XML_centerContinuous = 1142;
const sal_Int32 XML_centerGroup = 1143;
const sal_Int32 XML_centered = 1144;
const sal_Int32 XML_certificateBanner = 1145;
const sal_Int32 XML_cf = 1146;
const sal_Int32 XML_cfIcon = 1147;
const sal_Int32 XML_cfRule = 1148;
const sal_Int32 XML_cfvo = 1149;
const sal_Int32 XML_ch = 1150;
const sal_Int32 XML_chAlign = 1151;
const sal_Int32 XML_chDir = 1152;
const sal_Int32 XML_chExt = 1153;
const sal_Int32 XML_chMax = 1154;
const sal_Int32 XML_chOff = 1155;
const sal_Int32 XML_chOrder = 1156;
const sal_Int32 XML_chPref = 1157;
const sal_Int32 XML_chainLink = 1158;
const sal_Int32 XML_champagneBottle = 1159;
const sal_Int32 XML_changesSavedWin = 1160;
const sal_Int32 XML_chapNum = 1161;
const sal_Int32 XML_chapSep = 1162;
const sal_Int32 XML_chapStyle = 1163;
const sal_Int32 XML_char = 1164;
const sal_Int32 XML_charRg = 1165;
const sal_Int32 XML_charSpace = 1166;
const sal_Int32 XML_character = 1167;
const sal_Int32 XML_characterSet = 1168;
const sal_Int32 XML_characterSpacingControl = 1169;
const sal_Int32 XML_characteristic = 1170;
const sal_Int32 XML_charset = 1171;
const sal_Int32 XML_chart = 1172;
const sal_Int32 XML_chartAndTx = 1173;
const sal_Int32 XML_chartFormat = 1174;
const sal_Int32 XML_chartFormats = 1175;
const sal_Int32 XML_chartObject = 1176;
const sal_Int32 XML_chartPlus = 1177;
const sal_Int32 XML_chartSpace = 1178;
const sal_Int32 XML_chartStar = 1179;
const sal_Int32 XML_chartX = 1180;
const sal_Int32 XML_chartreuse = 1181;
const sal_Int32 XML_chartsheet = 1182;
const sal_Int32 XML_checkBox = 1183;
const sal_Int32 XML_checkCompatibility = 1184;
const sal_Int32 XML_checkErrors = 1185;
const sal_Int32 XML_checkStyle = 1186;
const sal_Int32 XML_checkbox = 1187;
const sal_Int32 XML_checked = 1188;
const sal_Int32 XML_checkedBarBlack = 1189;
const sal_Int32 XML_checkedBarColor = 1190;
const sal_Int32 XML_checkedState = 1191;
const sal_Int32 XML_checker = 1192;
const sal_Int32 XML_checkered = 1193;
const sal_Int32 XML_chevron = 1194;
const sal_Int32 XML_chicago = 1195;
const sal_Int32 XML_childStyle = 1196;
const sal_Int32 XML_childTnLst = 1197;
const sal_Int32 XML_chilly = 1198;
const sal_Int32 XML_chineseCounting = 1199;
const sal_Int32 XML_chineseCountingThousand = 1200;
const sal_Int32 XML_chineseLegalSimplified = 1201;
const sal_Int32 XML_chocolate = 1202;
const sal_Int32 XML_choose = 1203;
const sal_Int32 XML_chord = 1204;
const sal_Int32 XML_chosung = 1205;
const sal_Int32 XML_chr = 1206;
const sal_Int32 XML_christmasTree = 1207;
const sal_Int32 XML_chromakey = 1208;
const sal_Int32 XML_circle = 1209;
const sal_Int32 XML_circleNumDbPlain = 1210;
const sal_Int32 XML_circleNumWdBlackPlain = 1211;
const sal_Int32 XML_circleNumWdWhitePlain = 1212;
const sal_Int32 XML_circlesLines = 1213;
const sal_Int32 XML_circlesRectangles = 1214;
const sal_Int32 XML_circularArrow = 1215;
const sal_Int32 XML_citation = 1216;
const sal_Int32 XML_class = 1217;
const sal_Int32 XML_classic = 1218;
const sal_Int32 XML_classicalWave = 1219;
const sal_Int32 XML_classid = 1220;
const sal_Int32 XML_clean = 1221;
const sal_Int32 XML_clear = 1222;
const sal_Int32 XML_clearAll = 1223;
const sal_Int32 XML_clearComments = 1224;
const sal_Int32 XML_clearContents = 1225;
const sal_Int32 XML_clearFormats = 1226;
const sal_Int32 XML_click = 1227;
const sal_Int32 XML_clickAndTypeStyle = 1228;
const sal_Int32 XML_clickEffect = 1229;
const sal_Int32 XML_clickPar = 1230;
const sal_Int32 XML_clientData = 1231;
const sal_Int32 XML_clientInsertedTime = 1232;
const sal_Int32 XML_clip = 1233;
const sal_Int32 XML_clipArt = 1234;
const sal_Int32 XML_clipArtAndTx = 1235;
const sal_Int32 XML_clipArtAndVertTx = 1236;
const sal_Int32 XML_clippath = 1237;
const sal_Int32 XML_clipped = 1238;
const sal_Int32 XML_cliptowrap = 1239;
const sal_Int32 XML_clocks = 1240;
const sal_Int32 XML_close = 1241;
const sal_Int32 XML_cloud = 1242;
const sal_Int32 XML_cloudCallout = 1243;
const sal_Int32 XML_clr = 1244;
const sal_Int32 XML_clrChange = 1245;
const sal_Int32 XML_clrData = 1246;
const sal_Int32 XML_clrFrom = 1247;
const sal_Int32 XML_clrIdx = 1248;
const sal_Int32 XML_clrMap = 1249;
const sal_Int32 XML_clrMapOvr = 1250;
const sal_Int32 XML_clrMode = 1251;
const sal_Int32 XML_clrMru = 1252;
const sal_Int32 XML_clrRepl = 1253;
const sal_Int32 XML_clrScheme = 1254;
const sal_Int32 XML_clrSchemeMapping = 1255;
const sal_Int32 XML_clrSpc = 1256;
const sal_Int32 XML_clrTo = 1257;
const sal_Int32 XML_clrVal = 1258;
const sal_Int32 XML_clsid = 1259;
const sal_Int32 XML_clustered = 1260;
const sal_Int32 XML_cm = 1261;
const sal_Int32 XML_cmAuthor = 1262;
const sal_Int32 XML_cmAuthorLst = 1263;
const sal_Int32 XML_cmLst = 1264;
const sal_Int32 XML_cmd = 1265;
const sal_Int32 XML_cmpd = 1266;
const sal_Int32 XML_cnfStyle = 1267;
const sal_Int32 XML_cnt = 1268;
const sal_Int32 XML_cntxtAlts = 1269;
const sal_Int32 XML_code = 1270;
const sal_Int32 XML_codeName = 1271;
const sal_Int32 XML_codePage = 1272;
const sal_Int32 XML_coerce = 1273;
const sal_Int32 XML_coherent3DOff = 1274;
const sal_Int32 XML_col = 1275;
const sal_Int32 XML_colBreaks = 1276;
const sal_Int32 XML_colDelim = 1277;
const sal_Int32 XML_colFields = 1278;
const sal_Int32 XML_colFirst = 1279;
const sal_Int32 XML_colGrandTotals = 1280;
const sal_Int32 XML_colHeaderCaption = 1281;
const sal_Int32 XML_colHidden = 1282;
const sal_Int32 XML_colHierarchiesUsage = 1283;
const sal_Int32 XML_colHierarchyUsage = 1284;
const sal_Int32 XML_colId = 1285;
const sal_Int32 XML_colItems = 1286;
const sal_Int32 XML_colLast = 1287;
const sal_Int32 XML_colOff = 1288;
const sal_Int32 XML_colPageCount = 1289;
const sal_Int32 XML_collapse = 1290;
const sal_Int32 XML_collapsed = 1291;
const sal_Int32 XML_collapsedLevelsAreSubtotals = 1292;
const sal_Int32 XML_colon = 1293;
const sal_Int32 XML_color = 1294;
const sal_Int32 XML_color2 = 1295;
const sal_Int32 XML_colorAxis = 1296;
const sal_Int32 XML_colorFilter = 1297;
const sal_Int32 XML_colorFirst = 1298;
const sal_Int32 XML_colorHigh = 1299;
const sal_Int32 XML_colorId = 1300;
const sal_Int32 XML_colorLast = 1301;
const sal_Int32 XML_colorLow = 1302;
const sal_Int32 XML_colorMarkers = 1303;
const sal_Int32 XML_colorNegative = 1304;
const sal_Int32 XML_colorScale = 1305;
const sal_Int32 XML_colorSeries = 1306;
const sal_Int32 XML_colorTemp = 1307;
const sal_Int32 XML_colorTemperature = 1308;
const sal_Int32 XML_colormenu = 1309;
const sal_Int32 XML_colormode = 1310;
const sal_Int32 XML_colormru = 1311;
const sal_Int32 XML_colors = 1312;
const sal_Int32 XML_colorsDef = 1313;
const sal_Int32 XML_colorsDefHdr = 1314;
const sal_Int32 XML_colorsDefHdrLst = 1315;
const sal_Int32 XML_cols = 1316;
const sal_Int32 XML_column = 1317;
const sal_Int32 XML_columnSort = 1318;
const sal_Int32 XML_comb = 1319;
const sal_Int32 XML_combine = 1320;
const sal_Int32 XML_combineBrackets = 1321;
const sal_Int32 XML_comboBox = 1322;
const sal_Int32 XML_commIndAndComment = 1323;
const sal_Int32 XML_commIndicator = 1324;
const sal_Int32 XML_commNone = 1325;
const sal_Int32 XML_comma = 1326;
const sal_Int32 XML_command = 1327;
const sal_Int32 XML_commandType = 1328;
const sal_Int32 XML_comment = 1329;
const sal_Int32 XML_commentEx = 1330;
const sal_Int32 XML_commentList = 1331;
const sal_Int32 XML_commentPr = 1332;
const sal_Int32 XML_commentRangeEnd = 1333;
const sal_Int32 XML_commentRangeStart = 1334;
const sal_Int32 XML_commentReference = 1335;
const sal_Int32 XML_comments = 1336;
const sal_Int32 XML_commentsEx = 1337;
const sal_Int32 XML_comp = 1338;
const sal_Int32 XML_compact = 1339;
const sal_Int32 XML_compactData = 1340;
const sal_Int32 XML_compass = 1341;
const sal_Int32 XML_compat = 1342;
const sal_Int32 XML_compatLnSpc = 1343;
const sal_Int32 XML_compatMode = 1344;
const sal_Int32 XML_compatSetting = 1345;
const sal_Int32 XML_complex = 1346;
const sal_Int32 XML_composite = 1347;
const sal_Int32 XML_compressPunctuation = 1348;
const sal_Int32 XML_compressPunctuationAndJapaneseKana = 1349;
const sal_Int32 XML_computedArea = 1350;
const sal_Int32 XML_concurrent = 1351;
const sal_Int32 XML_concurrentCalc = 1352;
const sal_Int32 XML_concurrentManualCount = 1353;
const sal_Int32 XML_cond = 1354;
const sal_Int32 XML_condense = 1355;
const sal_Int32 XML_conditionalFormat = 1356;
const sal_Int32 XML_conditionalFormats = 1357;
const sal_Int32 XML_conditionalFormatting = 1358;
const sal_Int32 XML_conditionalFormattings = 1359;
const sal_Int32 XML_cone = 1360;
const sal_Int32 XML_coneToMax = 1361;
const sal_Int32 XML_confetti = 1362;
const sal_Int32 XML_confettiGrays = 1363;
const sal_Int32 XML_confettiOutline = 1364;
const sal_Int32 XML_confettiStreamers = 1365;
const sal_Int32 XML_confettiWhite = 1366;
const sal_Int32 XML_conformance = 1367;
const sal_Int32 XML_conn = 1368;
const sal_Int32 XML_connDist = 1369;
const sal_Int32 XML_connRout = 1370;
const sal_Int32 XML_connectString = 1371;
const sal_Int32 XML_connectangles = 1372;
const sal_Int32 XML_connection = 1373;
const sal_Int32 XML_connectionId = 1374;
const sal_Int32 XML_connections = 1375;
const sal_Int32 XML_connectloc = 1376;
const sal_Int32 XML_connectlocs = 1377;
const sal_Int32 XML_connector = 1378;
const sal_Int32 XML_connectortype = 1379;
const sal_Int32 XML_connecttype = 1380;
const sal_Int32 XML_consecutive = 1381;
const sal_Int32 XML_consecutiveHyphenLimit = 1382;
const sal_Int32 XML_consolidation = 1383;
const sal_Int32 XML_constr = 1384;
const sal_Int32 XML_constrLst = 1385;
const sal_Int32 XML_constrainbounds = 1386;
const sal_Int32 XML_cont = 1387;
const sal_Int32 XML_contDir = 1388;
const sal_Int32 XML_containsBlank = 1389;
const sal_Int32 XML_containsBlanks = 1390;
const sal_Int32 XML_containsDate = 1391;
const sal_Int32 XML_containsErrors = 1392;
const sal_Int32 XML_containsInteger = 1393;
const sal_Int32 XML_containsMixedTypes = 1394;
const sal_Int32 XML_containsNonDate = 1395;
const sal_Int32 XML_containsNumber = 1396;
const sal_Int32 XML_containsSemiMixedTypes = 1397;
const sal_Int32 XML_containsString = 1398;
const sal_Int32 XML_containsText = 1399;
const sal_Int32 XML_content = 1400;
const sal_Int32 XML_contentLocked = 1401;
const sal_Int32 XML_contentStatus = 1402;
const sal_Int32 XML_contentType = 1403;
const sal_Int32 XML_contextualSpacing = 1404;
const sal_Int32 XML_continuationNotice = 1405;
const sal_Int32 XML_continuationSeparator = 1406;
const sal_Int32 XML_continue = 1407;
const sal_Int32 XML_continuous = 1408;
const sal_Int32 XML_contourClr = 1409;
const sal_Int32 XML_contourW = 1410;
const sal_Int32 XML_contrast = 1411;
const sal_Int32 XML_contrasting = 1412;
const sal_Int32 XML_contributors = 1413;
const sal_Int32 XML_control = 1414;
const sal_Int32 XML_control1 = 1415;
const sal_Int32 XML_control2 = 1416;
const sal_Int32 XML_controlPr = 1417;
const sal_Int32 XML_controls = 1418;
const sal_Int32 XML_convMailMergeEsc = 1419;
const sal_Int32 XML_convex = 1420;
const sal_Int32 XML_conveyor = 1421;
const sal_Int32 XML_coolSlant = 1422;
const sal_Int32 XML_coordorigin = 1423;
const sal_Int32 XML_coordsize = 1424;
const sal_Int32 XML_copies = 1425;
const sal_Int32 XML_copy = 1426;
const sal_Int32 XML_coral = 1427;
const sal_Int32 XML_coreProperties = 1428;
const sal_Int32 XML_corner = 1429;
const sal_Int32 XML_cornerTabs = 1430;
const sal_Int32 XML_cornerTriangles = 1431;
const sal_Int32 XML_cornflowerBlue = 1432;
const sal_Int32 XML_cornsilk = 1433;
const sal_Int32 XML_count = 1434;
const sal_Int32 XML_countA = 1435;
const sal_Int32 XML_countASubtotal = 1436;
const sal_Int32 XML_countBy = 1437;
const sal_Int32 XML_countNums = 1438;
const sal_Int32 XML_countSubtotal = 1439;
const sal_Int32 XML_couponCutoutDashes = 1440;
const sal_Int32 XML_couponCutoutDots = 1441;
const sal_Int32 XML_cover = 1442;
const sal_Int32 XML_coverPg = 1443;
const sal_Int32 XML_cp = 1444;
const sal_Int32 XML_cr = 1445;
const sal_Int32 XML_crackSpacing = 1446;
const sal_Int32 XML_crashSave = 1447;
const sal_Int32 XML_crazyMaze = 1448;
const sal_Int32 XML_created = 1449;
const sal_Int32 XML_createdVersion = 1450;
const sal_Int32 XML_creator = 1451;
const sal_Int32 XML_creaturesButterfly = 1452;
const sal_Int32 XML_creaturesFish = 1453;
const sal_Int32 XML_creaturesInsects = 1454;
const sal_Int32 XML_creaturesLadyBug = 1455;
const sal_Int32 XML_credentials = 1456;
const sal_Int32 XML_crimson = 1457;
const sal_Int32 XML_cropbottom = 1458;
const sal_Int32 XML_cropleft = 1459;
const sal_Int32 XML_cropping = 1460;
const sal_Int32 XML_cropright = 1461;
const sal_Int32 XML_croptop = 1462;
const sal_Int32 XML_cross = 1463;
const sal_Int32 XML_crossAx = 1464;
const sal_Int32 XML_crossBetween = 1465;
const sal_Int32 XML_crossStitch = 1466;
const sal_Int32 XML_crosses = 1467;
const sal_Int32 XML_crossesAt = 1468;
const sal_Int32 XML_cryptAlgorithmClass = 1469;
const sal_Int32 XML_cryptAlgorithmSid = 1470;
const sal_Int32 XML_cryptAlgorithmType = 1471;
const sal_Int32 XML_cryptProvider = 1472;
const sal_Int32 XML_cryptProviderType = 1473;
const sal_Int32 XML_cryptProviderTypeExt = 1474;
const sal_Int32 XML_cryptProviderTypeExtSource = 1475;
const sal_Int32 XML_cryptSpinCount = 1476;
const sal_Int32 XML_cs = 1477;
const sal_Int32 XML_csCatId = 1478;
const sal_Int32 XML_csTypeId = 1479;
const sal_Int32 XML_csb0 = 1480;
const sal_Int32 XML_csb1 = 1481;
const sal_Int32 XML_css = 1482;
const sal_Int32 XML_cstate = 1483;
const sal_Int32 XML_cstheme = 1484;
const sal_Int32 XML_ct = 1485;
const sal_Int32 XML_ctr = 1486;
const sal_Int32 XML_ctrShpMap = 1487;
const sal_Int32 XML_ctrTitle = 1488;
const sal_Int32 XML_ctrX = 1489;
const sal_Int32 XML_ctrXOff = 1490;
const sal_Int32 XML_ctrY = 1491;
const sal_Int32 XML_ctrYOff = 1492;
const sal_Int32 XML_ctrlPr = 1493;
const sal_Int32 XML_cube = 1494;
const sal_Int32 XML_cubicBezTo = 1495;
const sal_Int32 XML_culture = 1496;
const sal_Int32 XML_cup = 1497;
const sal_Int32 XML_curly = 1498;
const sal_Int32 XML_current = 1499;
const sal_Int32 XML_currentDate = 1500;
const sal_Int32 XML_currentTime = 1501;
const sal_Int32 XML_curve = 1502;
const sal_Int32 XML_curved = 1503;
const sal_Int32 XML_curvedConnector2 = 1504;
const sal_Int32 XML_curvedConnector3 = 1505;
const sal_Int32 XML_curvedConnector4 = 1506;
const sal_Int32 XML_curvedConnector5 = 1507;
const sal_Int32 XML_curvedDownArrow = 1508;
const sal_Int32 XML_curvedLeftArrow = 1509;
const sal_Int32 XML_curvedRightArrow = 1510;
const sal_Int32 XML_curvedUpArrow = 1511;
const sal_Int32 XML_cust = 1512;
const sal_Int32 XML_custAng = 1513;
const sal_Int32 XML_custAutoTxt = 1514;
const sal_Int32 XML_custBib = 1515;
const sal_Int32 XML_custClr = 1516;
const sal_Int32 XML_custClrLst = 1517;
const sal_Int32 XML_custCoverPg = 1518;
const sal_Int32 XML_custDash = 1519;
const sal_Int32 XML_custData = 1520;
const sal_Int32 XML_custDataLst = 1521;
const sal_Int32 XML_custEq = 1522;
const sal_Int32 XML_custFlipHor = 1523;
const sal_Int32 XML_custFlipVert = 1524;
const sal_Int32 XML_custFtrs = 1525;
const sal_Int32 XML_custGeom = 1526;
const sal_Int32 XML_custHdrs = 1527;
const sal_Int32 XML_custLinFactNeighborX = 1528;
const sal_Int32 XML_custLinFactNeighborY = 1529;
const sal_Int32 XML_custLinFactX = 1530;
const sal_Int32 XML_custLinFactY = 1531;
const sal_Int32 XML_custPgNum = 1532;
const sal_Int32 XML_custPgNumB = 1533;
const sal_Int32 XML_custPgNumMargins = 1534;
const sal_Int32 XML_custPgNumT = 1535;
const sal_Int32 XML_custQuickParts = 1536;
const sal_Int32 XML_custRadScaleInc = 1537;
const sal_Int32 XML_custRadScaleRad = 1538;
const sal_Int32 XML_custScaleX = 1539;
const sal_Int32 XML_custScaleY = 1540;
const sal_Int32 XML_custShow = 1541;
const sal_Int32 XML_custShowLst = 1542;
const sal_Int32 XML_custSplit = 1543;
const sal_Int32 XML_custSzX = 1544;
const sal_Int32 XML_custSzY = 1545;
const sal_Int32 XML_custT = 1546;
const sal_Int32 XML_custTblOfContents = 1547;
const sal_Int32 XML_custTbls = 1548;
const sal_Int32 XML_custTxtBox = 1549;
const sal_Int32 XML_custUnit = 1550;
const sal_Int32 XML_custWatermarks = 1551;
const sal_Int32 XML_custom = 1552;
const sal_Int32 XML_custom1 = 1553;
const sal_Int32 XML_custom2 = 1554;
const sal_Int32 XML_custom3 = 1555;
const sal_Int32 XML_custom4 = 1556;
const sal_Int32 XML_custom5 = 1557;
const sal_Int32 XML_customBuiltin = 1558;
const sal_Int32 XML_customFilter = 1559;
const sal_Int32 XML_customFilters = 1560;
const sal_Int32 XML_customFormat = 1561;
const sal_Int32 XML_customHeight = 1562;
const sal_Int32 XML_customList = 1563;
const sal_Int32 XML_customListSort = 1564;
const sal_Int32 XML_customMarkFollows = 1565;
const sal_Int32 XML_customMenu = 1566;
const sal_Int32 XML_customPr = 1567;
const sal_Int32 XML_customProperties = 1568;
const sal_Int32 XML_customRollUp = 1569;
const sal_Int32 XML_customSheetView = 1570;
const sal_Int32 XML_customSheetViews = 1571;
const sal_Int32 XML_customStyle = 1572;
const sal_Int32 XML_customView = 1573;
const sal_Int32 XML_customWidth = 1574;
const sal_Int32 XML_customWorkbookView = 1575;
const sal_Int32 XML_customWorkbookViews = 1576;
const sal_Int32 XML_customXml = 1577;
const sal_Int32 XML_customXmlDelRangeEnd = 1578;
const sal_Int32 XML_customXmlDelRangeStart = 1579;
const sal_Int32 XML_customXmlInsRangeEnd = 1580;
const sal_Int32 XML_customXmlInsRangeStart = 1581;
const sal_Int32 XML_customXmlMoveFromRangeEnd = 1582;
const sal_Int32 XML_customXmlMoveFromRangeStart = 1583;
const sal_Int32 XML_customXmlMoveToRangeEnd = 1584;
const sal_Int32 XML_customXmlMoveToRangeStart = 1585;
const sal_Int32 XML_customXmlPr = 1586;
const sal_Int32 XML_cut = 1587;
const sal_Int32 XML_cw = 1588;
const sal_Int32 XML_cwIn = 1589;
const sal_Int32 XML_cwOut = 1590;
const sal_Int32 XML_cx = 1591;
const sal_Int32 XML_cxn = 1592;
const sal_Int32 XML_cxnId = 1593;
const sal_Int32 XML_cxnLst = 1594;
const sal_Int32 XML_cxnSp = 1595;
const sal_Int32 XML_cxnSpLocks = 1596;
const sal_Int32 XML_cy = 1597;
const sal_Int32 XML_cyan = 1598;
const sal_Int32 XML_cycle = 1599;
const sal_Int32 XML_cylinder = 1600;
const sal_Int32 XML_d = 1601;
const sal_Int32 XML_dLbl = 1602;
const sal_Int32 XML_dLblPos = 1603;
const sal_Int32 XML_dLbls = 1604;
const sal_Int32 XML_dPr = 1605;
const sal_Int32 XML_dPt = 1606;
const sal_Int32 XML_dTable = 1607;
const sal_Int32 XML_dark1 = 1608;
const sal_Int32 XML_dark2 = 1609;
const sal_Int32 XML_darkBlue = 1610;
const sal_Int32 XML_darkCyan = 1611;
const sal_Int32 XML_darkDown = 1612;
const sal_Int32 XML_darkGray = 1613;
const sal_Int32 XML_darkGreen = 1614;
const sal_Int32 XML_darkGrid = 1615;
const sal_Int32 XML_darkHorizontal = 1616;
const sal_Int32 XML_darkMagenta = 1617;
const sal_Int32 XML_darkRed = 1618;
const sal_Int32 XML_darkTrellis = 1619;
const sal_Int32 XML_darkUp = 1620;
const sal_Int32 XML_darkVertical = 1621;
const sal_Int32 XML_darkYellow = 1622;
const sal_Int32 XML_darken = 1623;
const sal_Int32 XML_darkenLess = 1624;
const sal_Int32 XML_dash = 1625;
const sal_Int32 XML_dashDnDiag = 1626;
const sal_Int32 XML_dashDot = 1627;
const sal_Int32 XML_dashDotDot = 1628;
const sal_Int32 XML_dashDotDotHeavy = 1629;
const sal_Int32 XML_dashDotHeavy = 1630;
const sal_Int32 XML_dashDotStroked = 1631;
const sal_Int32 XML_dashHeavy = 1632;
const sal_Int32 XML_dashHorz = 1633;
const sal_Int32 XML_dashLong = 1634;
const sal_Int32 XML_dashLongHeavy = 1635;
const sal_Int32 XML_dashSmallGap = 1636;
const sal_Int32 XML_dashUpDiag = 1637;
const sal_Int32 XML_dashVert = 1638;
const sal_Int32 XML_dashdot = 1639;
const sal_Int32 XML_dashed = 1640;
const sal_Int32 XML_dashedHeavy = 1641;
const sal_Int32 XML_dashedSmall = 1642;
const sal_Int32 XML_dashstyle = 1643;
const sal_Int32 XML_data = 1644;
const sal_Int32 XML_dataBar = 1645;
const sal_Int32 XML_dataBinding = 1646;
const sal_Int32 XML_dataBound = 1647;
const sal_Int32 XML_dataCaption = 1648;
const sal_Int32 XML_dataCellStyle = 1649;
const sal_Int32 XML_dataConsolidate = 1650;
const sal_Int32 XML_dataDxfId = 1651;
const sal_Int32 XML_dataExtractLoad = 1652;
const sal_Int32 XML_dataField = 1653;
const sal_Int32 XML_dataFields = 1654;
const sal_Int32 XML_dataModel = 1655;
const sal_Int32 XML_dataModelExt = 1656;
const sal_Int32 XML_dataOnRows = 1657;
const sal_Int32 XML_dataOnly = 1658;
const sal_Int32 XML_dataPosition = 1659;
const sal_Int32 XML_dataRef = 1660;
const sal_Int32 XML_dataRefs = 1661;
const sal_Int32 XML_dataSource = 1662;
const sal_Int32 XML_dataSourceSort = 1663;
const sal_Int32 XML_dataTable = 1664;
const sal_Int32 XML_dataType = 1665;
const sal_Int32 XML_dataValidation = 1666;
const sal_Int32 XML_dataValidations = 1667;
const sal_Int32 XML_database = 1668;
const sal_Int32 XML_databaseField = 1669;
const sal_Int32 XML_datalabelsRange = 1670;
const sal_Int32 XML_datastoreItem = 1671;
const sal_Int32 XML_date = 1672;
const sal_Int32 XML_date1904 = 1673;
const sal_Int32 XML_dateAx = 1674;
const sal_Int32 XML_dateAxis = 1675;
const sal_Int32 XML_dateBetween = 1676;
const sal_Int32 XML_dateCompatibility = 1677;
const sal_Int32 XML_dateEqual = 1678;
const sal_Int32 XML_dateFormat = 1679;
const sal_Int32 XML_dateGroupItem = 1680;
const sal_Int32 XML_dateNewerThan = 1681;
const sal_Int32 XML_dateNewerThanOrEqual = 1682;
const sal_Int32 XML_dateNotBetween = 1683;
const sal_Int32 XML_dateNotEqual = 1684;
const sal_Int32 XML_dateOlderThan = 1685;
const sal_Int32 XML_dateOlderThanOrEqual = 1686;
const sal_Int32 XML_dateTime = 1687;
const sal_Int32 XML_dateTimeGrouping = 1688;
const sal_Int32 XML_day = 1689;
const sal_Int32 XML_dayLong = 1690;
const sal_Int32 XML_dayShort = 1691;
const sal_Int32 XML_days = 1692;
const sal_Int32 XML_dbColumn = 1693;
const sal_Int32 XML_dbPr = 1694;
const sal_Int32 XML_dbl = 1695;
const sal_Int32 XML_dblStrike = 1696;
const sal_Int32 XML_dc = 1697;
const sal_Int32 XML_dcmitype = 1698;
const sal_Int32 XML_dcterms = 1699;
const sal_Int32 XML_ddList = 1700;
const sal_Int32 XML_ddeItem = 1701;
const sal_Int32 XML_ddeItems = 1702;
const sal_Int32 XML_ddeLink = 1703;
const sal_Int32 XML_ddeService = 1704;
const sal_Int32 XML_ddeTopic = 1705;
const sal_Int32 XML_dec = 1706;
const sal_Int32 XML_decagon = 1707;
const sal_Int32 XML_decel = 1708;
const sal_Int32 XML_decimal = 1709;
const sal_Int32 XML_decimalEnclosedCircle = 1710;
const sal_Int32 XML_decimalEnclosedCircleChinese = 1711;
const sal_Int32 XML_decimalEnclosedFullstop = 1712;
const sal_Int32 XML_decimalEnclosedParen = 1713;
const sal_Int32 XML_decimalFullWidth = 1714;
const sal_Int32 XML_decimalFullWidth2 = 1715;
const sal_Int32 XML_decimalHalfWidth = 1716;
const sal_Int32 XML_decimalSymbol = 1717;
const sal_Int32 XML_decimalZero = 1718;
const sal_Int32 XML_decoArch = 1719;
const sal_Int32 XML_decoArchColor = 1720;
const sal_Int32 XML_decoBlocks = 1721;
const sal_Int32 XML_decorated = 1722;
const sal_Int32 XML_decorative = 1723;
const sal_Int32 XML_deepPink = 1724;
const sal_Int32 XML_deepSkyBlue = 1725;
const sal_Int32 XML_def = 1726;
const sal_Int32 XML_defJc = 1727;
const sal_Int32 XML_defLockedState = 1728;
const sal_Int32 XML_defPPr = 1729;
const sal_Int32 XML_defQFormat = 1730;
const sal_Int32 XML_defRPr = 1731;
const sal_Int32 XML_defSemiHidden = 1732;
const sal_Int32 XML_defStyle = 1733;
const sal_Int32 XML_defTabSz = 1734;
const sal_Int32 XML_defUIPriority = 1735;
const sal_Int32 XML_defUnhideWhenUsed = 1736;
const sal_Int32 XML_default = 1737;
const sal_Int32 XML_defaultAttributeDrillState = 1738;
const sal_Int32 XML_defaultColWidth = 1739;
const sal_Int32 XML_defaultGridColor = 1740;
const sal_Int32 XML_defaultMemberUniqueName = 1741;
const sal_Int32 XML_defaultPivotStyle = 1742;
const sal_Int32 XML_defaultRowHeight = 1743;
const sal_Int32 XML_defaultSize = 1744;
const sal_Int32 XML_defaultSubtotal = 1745;
const sal_Int32 XML_defaultTabStop = 1746;
const sal_Int32 XML_defaultTableStyle = 1747;
const sal_Int32 XML_defaultTextStyle = 1748;
const sal_Int32 XML_defaultThemeVersion = 1749;
const sal_Int32 XML_definedName = 1750;
const sal_Int32 XML_definedNames = 1751;
const sal_Int32 XML_deg = 1752;
const sal_Int32 XML_degHide = 1753;
const sal_Int32 XML_degree = 1754;
const sal_Int32 XML_del = 1755;
const sal_Int32 XML_del1 = 1756;
const sal_Int32 XML_del2 = 1757;
const sal_Int32 XML_delInstrText = 1758;
const sal_Int32 XML_delText = 1759;
const sal_Int32 XML_delay = 1760;
const sal_Int32 XML_delete = 1761;
const sal_Int32 XML_deleteCol = 1762;
const sal_Int32 XML_deleteColumns = 1763;
const sal_Int32 XML_deleteRow = 1764;
const sal_Int32 XML_deleteRows = 1765;
const sal_Int32 XML_deleted = 1766;
const sal_Int32 XML_deletedField = 1767;
const sal_Int32 XML_delimited = 1768;
const sal_Int32 XML_delimiter = 1769;
const sal_Int32 XML_den = 1770;
const sal_Int32 XML_denormalized = 1771;
const sal_Int32 XML_depth = 1772;
const sal_Int32 XML_depthByBranch = 1773;
const sal_Int32 XML_depthByNode = 1774;
const sal_Int32 XML_depthPercent = 1775;
const sal_Int32 XML_des = 1776;
const sal_Int32 XML_desOrSelf = 1777;
const sal_Int32 XML_desc = 1778;
const sal_Int32 XML_descending = 1779;
const sal_Int32 XML_descendingAlpha = 1780;
const sal_Int32 XML_descendingNatural = 1781;
const sal_Int32 XML_descr = 1782;
const sal_Int32 XML_description = 1783;
const sal_Int32 XML_destId = 1784;
const sal_Int32 XML_destOrd = 1785;
const sal_Int32 XML_destination = 1786;
const sal_Int32 XML_destinationFile = 1787;
const sal_Int32 XML_detail = 1788;
const sal_Int32 XML_detectmouseclick = 1789;
const sal_Int32 XML_dgm = 1790;
const sal_Int32 XML_dgmbasetextscale = 1791;
const sal_Int32 XML_dgmfontsize = 1792;
const sal_Int32 XML_dgmlayout = 1793;
const sal_Int32 XML_dgmlayoutmru = 1794;
const sal_Int32 XML_dgmnodekind = 1795;
const sal_Int32 XML_dgmscalex = 1796;
const sal_Int32 XML_dgmscaley = 1797;
const sal_Int32 XML_dgmstyle = 1798;
const sal_Int32 XML_diagBrick = 1799;
const sal_Int32 XML_diagCross = 1800;
const sal_Int32 XML_diagStripe = 1801;
const sal_Int32 XML_diagonal = 1802;
const sal_Int32 XML_diagonalDown = 1803;
const sal_Int32 XML_diagonalUp = 1804;
const sal_Int32 XML_diagram = 1805;
const sal_Int32 XML_dialogsheet = 1806;
const sal_Int32 XML_diam = 1807;
const sal_Int32 XML_diamond = 1808;
const sal_Int32 XML_diamondsGray = 1809;
const sal_Int32 XML_diff = 1810;
const sal_Int32 XML_difference = 1811;
const sal_Int32 XML_differentFirst = 1812;
const sal_Int32 XML_differentOddEven = 1813;
const sal_Int32 XML_diffusity = 1814;
const sal_Int32 XML_dim = 1815;
const sal_Int32 XML_dimGray = 1816;
const sal_Int32 XML_dimension = 1817;
const sal_Int32 XML_dimensionUniqueName = 1818;
const sal_Int32 XML_dimensions = 1819;
const sal_Int32 XML_dir = 1820;
const sal_Int32 XML_dirty = 1821;
const sal_Int32 XML_disableEdit = 1822;
const sal_Int32 XML_disableFieldList = 1823;
const sal_Int32 XML_disablePrompts = 1824;
const sal_Int32 XML_disableRefresh = 1825;
const sal_Int32 XML_disabled = 1826;
const sal_Int32 XML_discrete = 1827;
const sal_Int32 XML_discretePr = 1828;
const sal_Int32 XML_diskRevisions = 1829;
const sal_Int32 XML_dispBlanksAs = 1830;
const sal_Int32 XML_dispDef = 1831;
const sal_Int32 XML_dispEq = 1832;
const sal_Int32 XML_dispRSqr = 1833;
const sal_Int32 XML_dispUnits = 1834;
const sal_Int32 XML_dispUnitsLbl = 1835;
const sal_Int32 XML_displacedByCustomXml = 1836;
const sal_Int32 XML_display = 1837;
const sal_Int32 XML_displayBackgroundShape = 1838;
const sal_Int32 XML_displayEmptyCellsAs = 1839;
const sal_Int32 XML_displayFolder = 1840;
const sal_Int32 XML_displayHangulFixedWidth = 1841;
const sal_Int32 XML_displayHidden = 1842;
const sal_Int32 XML_displayHorizontalDrawingGridEvery = 1843;
const sal_Int32 XML_displayName = 1844;
const sal_Int32 XML_displayText = 1845;
const sal_Int32 XML_displayVerticalDrawingGridEvery = 1846;
const sal_Int32 XML_displayXAxis = 1847;
const sal_Int32 XML_displayed = 1848;
const sal_Int32 XML_dissolve = 1849;
const sal_Int32 XML_dist = 1850;
const sal_Int32 XML_distB = 1851;
const sal_Int32 XML_distL = 1852;
const sal_Int32 XML_distR = 1853;
const sal_Int32 XML_distT = 1854;
const sal_Int32 XML_distance = 1855;
const sal_Int32 XML_distribute = 1856;
const sal_Int32 XML_distributeLetter = 1857;
const sal_Int32 XML_distributeSpace = 1858;
const sal_Int32 XML_distributed = 1859;
const sal_Int32 XML_div = 1860;
const sal_Int32 XML_divBdr = 1861;
const sal_Int32 XML_divId = 1862;
const sal_Int32 XML_divot = 1863;
const sal_Int32 XML_divs = 1864;
const sal_Int32 XML_divsChild = 1865;
const sal_Int32 XML_dk1 = 1866;
const sal_Int32 XML_dk2 = 1867;
const sal_Int32 XML_dkBlue = 1868;
const sal_Int32 XML_dkCyan = 1869;
const sal_Int32 XML_dkDnDiag = 1870;
const sal_Int32 XML_dkEdge = 1871;
const sal_Int32 XML_dkGoldenrod = 1872;
const sal_Int32 XML_dkGray = 1873;
const sal_Int32 XML_dkGreen = 1874;
const sal_Int32 XML_dkHorz = 1875;
const sal_Int32 XML_dkKhaki = 1876;
const sal_Int32 XML_dkMagenta = 1877;
const sal_Int32 XML_dkOliveGreen = 1878;
const sal_Int32 XML_dkOrange = 1879;
const sal_Int32 XML_dkOrchid = 1880;
const sal_Int32 XML_dkRed = 1881;
const sal_Int32 XML_dkSalmon = 1882;
const sal_Int32 XML_dkSeaGreen = 1883;
const sal_Int32 XML_dkSlateBlue = 1884;
const sal_Int32 XML_dkSlateGray = 1885;
const sal_Int32 XML_dkTurquoise = 1886;
const sal_Int32 XML_dkUpDiag = 1887;
const sal_Int32 XML_dkVert = 1888;
const sal_Int32 XML_dkViolet = 1889;
const sal_Int32 XML_dlblRangeCache = 1890;
const sal_Int32 XML_dllVersion = 1891;
const sal_Int32 XML_dm = 1892;
const sal_Int32 XML_dn = 1893;
const sal_Int32 XML_dnDiag = 1894;
const sal_Int32 XML_doNotAutoCompressPictures = 1895;
const sal_Int32 XML_doNotAutofitConstrainedTables = 1896;
const sal_Int32 XML_doNotBreakConstrainedForcedTable = 1897;
const sal_Int32 XML_doNotBreakWrappedTables = 1898;
const sal_Int32 XML_doNotCompress = 1899;
const sal_Int32 XML_doNotDemarcateInvalidXml = 1900;
const sal_Int32 XML_doNotDisplayPageBoundaries = 1901;
const sal_Int32 XML_doNotEmbedSmartTags = 1902;
const sal_Int32 XML_doNotExpandShiftReturn = 1903;
const sal_Int32 XML_doNotHyphenateCaps = 1904;
const sal_Int32 XML_doNotIncludeSubdocsInStats = 1905;
const sal_Int32 XML_doNotLeaveBackslashAlone = 1906;
const sal_Int32 XML_doNotOrganizeInFolder = 1907;
const sal_Int32 XML_doNotRelyOnCSS = 1908;
const sal_Int32 XML_doNotSaveAsSingleFile = 1909;
const sal_Int32 XML_doNotShadeFormData = 1910;
const sal_Int32 XML_doNotSnapToGridInCell = 1911;
const sal_Int32 XML_doNotSuppressBlankLines = 1912;
const sal_Int32 XML_doNotSuppressIndentation = 1913;
const sal_Int32 XML_doNotSuppressParagraphBorders = 1914;
const sal_Int32 XML_doNotTrackFormatting = 1915;
const sal_Int32 XML_doNotTrackMoves = 1916;
const sal_Int32 XML_doNotUseEastAsianBreakRules = 1917;
const sal_Int32 XML_doNotUseHTMLParagraphAutoSpacing = 1918;
const sal_Int32 XML_doNotUseIndentAsNumberingTabStop = 1919;
const sal_Int32 XML_doNotUseLongFileNames = 1920;
const sal_Int32 XML_doNotUseMarginsForDrawingGridOrigin = 1921;
const sal_Int32 XML_doNotValidateAgainstSchema = 1922;
const sal_Int32 XML_doNotVertAlignCellWithSp = 1923;
const sal_Int32 XML_doNotVertAlignInTxbx = 1924;
const sal_Int32 XML_doNotWrapTextWithPunct = 1925;
const sal_Int32 XML_done = 1926;
const sal_Int32 XML_doc = 1927;
const sal_Int32 XML_docDefaults = 1928;
const sal_Int32 XML_docEnd = 1929;
const sal_Int32 XML_docGrid = 1930;
const sal_Int32 XML_docLocation = 1931;
const sal_Int32 XML_docPart = 1932;
const sal_Int32 XML_docPartBody = 1933;
const sal_Int32 XML_docPartCategory = 1934;
const sal_Int32 XML_docPartGallery = 1935;
const sal_Int32 XML_docPartList = 1936;
const sal_Int32 XML_docPartObj = 1937;
const sal_Int32 XML_docPartPr = 1938;
const sal_Int32 XML_docPartUnique = 1939;
const sal_Int32 XML_docParts = 1940;
const sal_Int32 XML_docPr = 1941;
const sal_Int32 XML_docVar = 1942;
const sal_Int32 XML_docVars = 1943;
const sal_Int32 XML_document = 1944;
const sal_Int32 XML_document1 = 1945;
const sal_Int32 XML_document2 = 1946;
const sal_Int32 XML_documentProtection = 1947;
const sal_Int32 XML_documentType = 1948;
const sal_Int32 XML_dodecagon = 1949;
const sal_Int32 XML_dodgerBlue = 1950;
const sal_Int32 XML_donut = 1951;
const sal_Int32 XML_doors = 1952;
const sal_Int32 XML_dos = 1953;
const sal_Int32 XML_dot = 1954;
const sal_Int32 XML_dotDash = 1955;
const sal_Int32 XML_dotDashHeavy = 1956;
const sal_Int32 XML_dotDmnd = 1957;
const sal_Int32 XML_dotDotDash = 1958;
const sal_Int32 XML_dotDotDashHeavy = 1959;
const sal_Int32 XML_dotGrid = 1960;
const sal_Int32 XML_dotted = 1961;
const sal_Int32 XML_dottedHeavy = 1962;
const sal_Int32 XML_double = 1963;
const sal_Int32 XML_double_struck = 1964;
const sal_Int32 XML_doubleAccounting = 1965;
const sal_Int32 XML_doubleD = 1966;
const sal_Int32 XML_doubleDiamonds = 1967;
const sal_Int32 XML_doubleQuote = 1968;
const sal_Int32 XML_doubleWave = 1969;
const sal_Int32 XML_doubleclicknotify = 1970;
const sal_Int32 XML_doughnutChart = 1971;
const sal_Int32 XML_down = 1972;
const sal_Int32 XML_downArrow = 1973;
const sal_Int32 XML_downArrowCallout = 1974;
const sal_Int32 XML_downBars = 1975;
const sal_Int32 XML_downThenOver = 1976;
const sal_Int32 XML_dpi = 1977;
const sal_Int32 XML_dr = 1978;
const sal_Int32 XML_draft = 1979;
const sal_Int32 XML_dragOff = 1980;
const sal_Int32 XML_dragToCol = 1981;
const sal_Int32 XML_dragToData = 1982;
const sal_Int32 XML_dragToPage = 1983;
const sal_Int32 XML_dragToRow = 1984;
const sal_Int32 XML_drawing = 1985;
const sal_Int32 XML_drawingGridHorizontalOrigin = 1986;
const sal_Int32 XML_drawingGridHorizontalSpacing = 1987;
const sal_Int32 XML_drawingGridVerticalOrigin = 1988;
const sal_Int32 XML_drawingGridVerticalSpacing = 1989;
const sal_Int32 XML_drill = 1990;
const sal_Int32 XML_drop = 1991;
const sal_Int32 XML_dropCap = 1992;
const sal_Int32 XML_dropDownList = 1993;
const sal_Int32 XML_dropLines = 1994;
const sal_Int32 XML_dropauto = 1995;
const sal_Int32 XML_ds = 1996;
const sal_Int32 XML_dstNode = 1997;
const sal_Int32 XML_dstrike = 1998;
const sal_Int32 XML_dt = 1999;
const sal_Int32 XML_dt2D = 2000;
const sal_Int32 XML_dtr = 2001;
const sal_Int32 XML_duotone = 2002;
const sal_Int32 XML_duplicateValues = 2003;
const sal_Int32 XML_dur = 2004;
const sal_Int32 XML_duration = 2005;
const sal_Int32 XML_dvAspect = 2006;
const sal_Int32 XML_dx = 2007;
const sal_Int32 XML_dxa = 2008;
const sal_Int32 XML_dxaOrig = 2009;
const sal_Int32 XML_dxf = 2010;
const sal_Int32 XML_dxfId = 2011;
const sal_Int32 XML_dxfs = 2012;
const sal_Int32 XML_dy = 2013;
const sal_Int32 XML_dyaOrig = 2014;
const sal_Int32 XML_dynamicAddress = 2015;
const sal_Int32 XML_dynamicFilter = 2016;
const sal_Int32 XML_dz = 2017;
const sal_Int32 XML_e = 2018;
const sal_Int32 XML_eMail = 2019;
const sal_Int32 XML_ea = 2020;
const sal_Int32 XML_ea1ChsPeriod = 2021;
const sal_Int32 XML_ea1ChsPlain = 2022;
const sal_Int32 XML_ea1ChtPeriod = 2023;
const sal_Int32 XML_ea1ChtPlain = 2024;
const sal_Int32 XML_ea1JpnChsDbPeriod = 2025;
const sal_Int32 XML_ea1JpnKorPeriod = 2026;
const sal_Int32 XML_ea1JpnKorPlain = 2027;
const sal_Int32 XML_eaLnBrk = 2028;
const sal_Int32 XML_eaVert = 2029;
const sal_Int32 XML_eachPage = 2030;
const sal_Int32 XML_eachSect = 2031;
const sal_Int32 XML_earth1 = 2032;
const sal_Int32 XML_earth2 = 2033;
const sal_Int32 XML_eastAsia = 2034;
const sal_Int32 XML_eastAsiaTheme = 2035;
const sal_Int32 XML_eastAsianLayout = 2036;
const sal_Int32 XML_eb = 2037;
const sal_Int32 XML_eclipsingSquares1 = 2038;
const sal_Int32 XML_eclipsingSquares2 = 2039;
const sal_Int32 XML_ed = 2040;
const sal_Int32 XML_edGrp = 2041;
const sal_Int32 XML_edge = 2042;
const sal_Int32 XML_edit = 2043;
const sal_Int32 XML_editAs = 2044;
const sal_Int32 XML_editData = 2045;
const sal_Int32 XML_editPage = 2046;
const sal_Int32 XML_editas = 2047;
const sal_Int32 XML_edited = 2048;
const sal_Int32 XML_editors = 2049;
const sal_Int32 XML_effect = 2050;
const sal_Int32 XML_effectClrLst = 2051;
const sal_Int32 XML_effectDag = 2052;
const sal_Int32 XML_effectExtent = 2053;
const sal_Int32 XML_effectLst = 2054;
const sal_Int32 XML_effectRef = 2055;
const sal_Int32 XML_effectStyle = 2056;
const sal_Int32 XML_effectStyleLst = 2057;
const sal_Int32 XML_eggsBlack = 2058;
const sal_Int32 XML_el = 2059;
const sal_Int32 XML_elbow = 2060;
const sal_Int32 XML_element = 2061;
const sal_Int32 XML_ellipse = 2062;
const sal_Int32 XML_ellipseRibbon = 2063;
const sal_Int32 XML_ellipseRibbon2 = 2064;
const sal_Int32 XML_ellipsis = 2065;
const sal_Int32 XML_else = 2066;
const sal_Int32 XML_em = 2067;
const sal_Int32 XML_emDash = 2068;
const sal_Int32 XML_email = 2069;
const sal_Int32 XML_embed = 2070;
const sal_Int32 XML_embedBold = 2071;
const sal_Int32 XML_embedBoldItalic = 2072;
const sal_Int32 XML_embedItalic = 2073;
const sal_Int32 XML_embedRegular = 2074;
const sal_Int32 XML_embedSystemFonts = 2075;
const sal_Int32 XML_embedTrueTypeFonts = 2076;
const sal_Int32 XML_embeddedFont = 2077;
const sal_Int32 XML_embeddedFontLst = 2078;
const sal_Int32 XML_emboss = 2079;
const sal_Int32 XML_embosscolor = 2080;
const sal_Int32 XML_emph = 2081;
const sal_Int32 XML_empty = 2082;
const sal_Int32 XML_emptyCellReference = 2083;
const sal_Int32 XML_enDash = 2084;
const sal_Int32 XML_enableDrill = 2085;
const sal_Int32 XML_enableFieldProperties = 2086;
const sal_Int32 XML_enableFormatConditionsCalculation = 2087;
const sal_Int32 XML_enableRefresh = 2088;
const sal_Int32 XML_enableWizard = 2089;
const sal_Int32 XML_enabled = 2090;
const sal_Int32 XML_encoding = 2091;
const sal_Int32 XML_end = 2092;
const sal_Int32 XML_endA = 2093;
const sal_Int32 XML_endAngle = 2094;
const sal_Int32 XML_endChars = 2095;
const sal_Int32 XML_endChr = 2096;
const sal_Int32 XML_endCnv = 2097;
const sal_Int32 XML_endCondLst = 2098;
const sal_Int32 XML_endCxn = 2099;
const sal_Int32 XML_endDate = 2100;
const sal_Int32 XML_endMarg = 2101;
const sal_Int32 XML_endNum = 2102;
const sal_Int32 XML_endOfListFormulaUpdate = 2103;
const sal_Int32 XML_endPad = 2104;
const sal_Int32 XML_endParaRPr = 2105;
const sal_Int32 XML_endPos = 2106;
const sal_Int32 XML_endPts = 2107;
const sal_Int32 XML_endSnd = 2108;
const sal_Int32 XML_endSty = 2109;
const sal_Int32 XML_endSync = 2110;
const sal_Int32 XML_endarrow = 2111;
const sal_Int32 XML_endarrowlength = 2112;
const sal_Int32 XML_endarrowwidth = 2113;
const sal_Int32 XML_endcap = 2114;
const sal_Int32 XML_endnote = 2115;
const sal_Int32 XML_endnotePr = 2116;
const sal_Int32 XML_endnoteRef = 2117;
const sal_Int32 XML_endnoteReference = 2118;
const sal_Int32 XML_endnotes = 2119;
const sal_Int32 XML_endsWith = 2120;
const sal_Int32 XML_enforcement = 2121;
const sal_Int32 XML_entr = 2122;
const sal_Int32 XML_entries = 2123;
const sal_Int32 XML_entry = 2124;
const sal_Int32 XML_entryMacro = 2125;
const sal_Int32 XML_envelopes = 2126;
const sal_Int32 XML_eol = 2127;
const sal_Int32 XML_eq = 2128;
const sal_Int32 XML_eqArr = 2129;
const sal_Int32 XML_eqArrPr = 2130;
const sal_Int32 XML_eqn = 2131;
const sal_Int32 XML_equ = 2132;
const sal_Int32 XML_equal = 2133;
const sal_Int32 XML_equalAverage = 2134;
const sal_Int32 XML_equalWidth = 2135;
const sal_Int32 XML_equation = 2136;
const sal_Int32 XML_equationxml = 2137;
const sal_Int32 XML_err = 2138;
const sal_Int32 XML_errBarType = 2139;
const sal_Int32 XML_errBars = 2140;
const sal_Int32 XML_errDir = 2141;
const sal_Int32 XML_errValType = 2142;
const sal_Int32 XML_error = 2143;
const sal_Int32 XML_errorCaption = 2144;
const sal_Int32 XML_errorStyle = 2145;
const sal_Int32 XML_errorTitle = 2146;
const sal_Int32 XML_errors = 2147;
const sal_Int32 XML_evalError = 2148;
const sal_Int32 XML_evalOrder = 2149;
const sal_Int32 XML_even = 2150;
const sal_Int32 XML_evenAndOddHeaders = 2151;
const sal_Int32 XML_evenFooter = 2152;
const sal_Int32 XML_evenHBand = 2153;
const sal_Int32 XML_evenHeader = 2154;
const sal_Int32 XML_evenPage = 2155;
const sal_Int32 XML_evenVBand = 2156;
const sal_Int32 XML_everyone = 2157;
const sal_Int32 XML_evt = 2158;
const sal_Int32 XML_evtFilter = 2159;
const sal_Int32 XML_exact = 2160;
const sal_Int32 XML_excl = 2161;
const sal_Int32 XML_exclusive = 2162;
const sal_Int32 XML_exit = 2163;
const sal_Int32 XML_exitMacro = 2164;
const sal_Int32 XML_exp = 2165;
const sal_Int32 XML_explosion = 2166;
const sal_Int32 XML_expression = 2167;
const sal_Int32 XML_ext = 2168;
const sal_Int32 XML_extCalcPr = 2169;
const sal_Int32 XML_extLst = 2170;
const sal_Int32 XML_extend = 2171;
const sal_Int32 XML_extendable = 2172;
const sal_Int32 XML_extent = 2173;
const sal_Int32 XML_external = 2174;
const sal_Int32 XML_externalBook = 2175;
const sal_Int32 XML_externalData = 2176;
const sal_Int32 XML_externalLink = 2177;
const sal_Int32 XML_externalReference = 2178;
const sal_Int32 XML_externalReferences = 2179;
const sal_Int32 XML_extraClrScheme = 2180;
const sal_Int32 XML_extraClrSchemeLst = 2181;
const sal_Int32 XML_extrusion = 2182;
const sal_Int32 XML_extrusionClr = 2183;
const sal_Int32 XML_extrusionH = 2184;
const sal_Int32 XML_extrusionOk = 2185;
const sal_Int32 XML_extrusioncolor = 2186;
const sal_Int32 XML_extrusionok = 2187;
const sal_Int32 XML_f = 2188;
const sal_Int32 XML_fHdr = 2189;
const sal_Int32 XML_fLocksText = 2190;
const sal_Int32 XML_fLocksWithSheet = 2191;
const sal_Int32 XML_fName = 2192;
const sal_Int32 XML_fNode = 2193;
const sal_Int32 XML_fPr = 2194;
const sal_Int32 XML_fPrintsWithSheet = 2195;
const sal_Int32 XML_fPublished = 2196;
const sal_Int32 XML_face = 2197;
const sal_Int32 XML_facet = 2198;
const sal_Int32 XML_fact = 2199;
const sal_Int32 XML_factor = 2200;
const sal_Int32 XML_fade = 2201;
const sal_Int32 XML_fadeDir = 2202;
const sal_Int32 XML_fallback = 2203;
const sal_Int32 XML_false = 2204;
const sal_Int32 XML_family = 2205;
const sal_Int32 XML_fans = 2206;
const sal_Int32 XML_fast = 2207;
const sal_Int32 XML_fax = 2208;
const sal_Int32 XML_fc = 2209;
const sal_Int32 XML_ferris = 2210;
const sal_Int32 XML_ffData = 2211;
const sal_Int32 XML_fgClr = 2212;
const sal_Int32 XML_fgColor = 2213;
const sal_Int32 XML_fi = 2214;
const sal_Int32 XML_field = 2215;
const sal_Int32 XML_fieldGroup = 2216;
const sal_Int32 XML_fieldId = 2217;
const sal_Int32 XML_fieldIdWrapped = 2218;
const sal_Int32 XML_fieldListSortAscending = 2219;
const sal_Int32 XML_fieldMapData = 2220;
const sal_Int32 XML_fieldPosition = 2221;
const sal_Int32 XML_fieldPrintTitles = 2222;
const sal_Int32 XML_fieldUsage = 2223;
const sal_Int32 XML_fieldsUsage = 2224;
const sal_Int32 XML_fileRecoveryPr = 2225;
const sal_Int32 XML_fileSharing = 2226;
const sal_Int32 XML_fileType = 2227;
const sal_Int32 XML_fileVersion = 2228;
const sal_Int32 XML_filetime = 2229;
const sal_Int32 XML_fill = 2230;
const sal_Int32 XML_fillColor = 2231;
const sal_Int32 XML_fillClrLst = 2232;
const sal_Int32 XML_fillFormulas = 2233;
const sal_Int32 XML_fillId = 2234;
const sal_Int32 XML_fillOverlay = 2235;
const sal_Int32 XML_fillRect = 2236;
const sal_Int32 XML_fillRef = 2237;
const sal_Int32 XML_fillStyleLst = 2238;
const sal_Int32 XML_fillToRect = 2239;
const sal_Int32 XML_fillcolor = 2240;
const sal_Int32 XML_filled = 2241;
const sal_Int32 XML_fillok = 2242;
const sal_Int32 XML_fills = 2243;
const sal_Int32 XML_filltype = 2244;
const sal_Int32 XML_film = 2245;
const sal_Int32 XML_filter = 2246;
const sal_Int32 XML_filterColumn = 2247;
const sal_Int32 XML_filterMode = 2248;
const sal_Int32 XML_filterPrivacy = 2249;
const sal_Int32 XML_filterUnique = 2250;
const sal_Int32 XML_filterVal = 2251;
const sal_Int32 XML_filters = 2252;
const sal_Int32 XML_firebrick = 2253;
const sal_Int32 XML_firecrackers = 2254;
const sal_Int32 XML_first = 2255;
const sal_Int32 XML_firstAndLastLine = 2256;
const sal_Int32 XML_firstBackgroundRefresh = 2257;
const sal_Int32 XML_firstCol = 2258;
const sal_Int32 XML_firstColumn = 2259;
const sal_Int32 XML_firstColumnStripe = 2260;
const sal_Int32 XML_firstColumnSubheading = 2261;
const sal_Int32 XML_firstDataCol = 2262;
const sal_Int32 XML_firstDataRow = 2263;
const sal_Int32 XML_firstFooter = 2264;
const sal_Int32 XML_firstHeader = 2265;
const sal_Int32 XML_firstHeaderCell = 2266;
const sal_Int32 XML_firstHeaderRow = 2267;
const sal_Int32 XML_firstLine = 2268;
const sal_Int32 XML_firstLineChars = 2269;
const sal_Int32 XML_firstLineOnly = 2270;
const sal_Int32 XML_firstPage = 2271;
const sal_Int32 XML_firstPageNumber = 2272;
const sal_Int32 XML_firstRow = 2273;
const sal_Int32 XML_firstRowFirstColumn = 2274;
const sal_Int32 XML_firstRowLastColumn = 2275;
const sal_Int32 XML_firstRowStripe = 2276;
const sal_Int32 XML_firstRowSubheading = 2277;
const sal_Int32 XML_firstSheet = 2278;
const sal_Int32 XML_firstSliceAng = 2279;
const sal_Int32 XML_firstSlideNum = 2280;
const sal_Int32 XML_firstSubtotalColumn = 2281;
const sal_Int32 XML_firstSubtotalRow = 2282;
const sal_Int32 XML_firstTotalCell = 2283;
const sal_Int32 XML_fitText = 2284;
const sal_Int32 XML_fitToHeight = 2285;
const sal_Int32 XML_fitToPage = 2286;
const sal_Int32 XML_fitToSlide = 2287;
const sal_Int32 XML_fitToWidth = 2288;
const sal_Int32 XML_fitpath = 2289;
const sal_Int32 XML_fitshape = 2290;
const sal_Int32 XML_fixed = 2291;
const sal_Int32 XML_fixedVal = 2292;
const sal_Int32 XML_flash = 2293;
const sal_Int32 XML_flat = 2294;
const sal_Int32 XML_flatBorders = 2295;
const sal_Int32 XML_flatTx = 2296;
const sal_Int32 XML_fld = 2297;
const sal_Int32 XML_fldChar = 2298;
const sal_Int32 XML_fldCharType = 2299;
const sal_Int32 XML_fldData = 2300;
const sal_Int32 XML_fldLock = 2301;
const sal_Int32 XML_fldSimple = 2302;
const sal_Int32 XML_flip = 2303;
const sal_Int32 XML_flipH = 2304;
const sal_Int32 XML_flipV = 2305;
const sal_Int32 XML_float = 2306;
const sal_Int32 XML_flood = 2307;
const sal_Int32 XML_floor = 2308;
const sal_Int32 XML_floralWhite = 2309;
const sal_Int32 XML_flowChartAlternateProcess = 2310;
const sal_Int32 XML_flowChartCollate = 2311;
const sal_Int32 XML_flowChartConnector = 2312;
const sal_Int32 XML_flowChartDecision = 2313;
const sal_Int32 XML_flowChartDelay = 2314;
const sal_Int32 XML_flowChartDisplay = 2315;
const sal_Int32 XML_flowChartDocument = 2316;
const sal_Int32 XML_flowChartExtract = 2317;
const sal_Int32 XML_flowChartInputOutput = 2318;
const sal_Int32 XML_flowChartInternalStorage = 2319;
const sal_Int32 XML_flowChartMagneticDisk = 2320;
const sal_Int32 XML_flowChartMagneticDrum = 2321;
const sal_Int32 XML_flowChartMagneticTape = 2322;
const sal_Int32 XML_flowChartManualInput = 2323;
const sal_Int32 XML_flowChartManualOperation = 2324;
const sal_Int32 XML_flowChartMerge = 2325;
const sal_Int32 XML_flowChartMultidocument = 2326;
const sal_Int32 XML_flowChartOfflineStorage = 2327;
const sal_Int32 XML_flowChartOffpageConnector = 2328;
const sal_Int32 XML_flowChartOnlineStorage = 2329;
const sal_Int32 XML_flowChartOr = 2330;
const sal_Int32 XML_flowChartPredefinedProcess = 2331;
const sal_Int32 XML_flowChartPreparation = 2332;
const sal_Int32 XML_flowChartProcess = 2333;
const sal_Int32 XML_flowChartPunchedCard = 2334;
const sal_Int32 XML_flowChartPunchedTape = 2335;
const sal_Int32 XML_flowChartSort = 2336;
const sal_Int32 XML_flowChartSummingJunction = 2337;
const sal_Int32 XML_flowChartTerminator = 2338;
const sal_Int32 XML_flowDir = 2339;
const sal_Int32 XML_flowersBlockPrint = 2340;
const sal_Int32 XML_flowersDaisies = 2341;
const sal_Int32 XML_flowersModern1 = 2342;
const sal_Int32 XML_flowersModern2 = 2343;
const sal_Int32 XML_flowersPansy = 2344;
const sal_Int32 XML_flowersRedRose = 2345;
const sal_Int32 XML_flowersRoses = 2346;
const sal_Int32 XML_flowersTeacup = 2347;
const sal_Int32 XML_flowersTiny = 2348;
const sal_Int32 XML_fltVal = 2349;
const sal_Int32 XML_flythrough = 2350;
const sal_Int32 XML_fmla = 2351;
const sal_Int32 XML_fmt = 2352;
const sal_Int32 XML_fmtId = 2353;
const sal_Int32 XML_fmtScheme = 2354;
const sal_Int32 XML_fmtid = 2355;
const sal_Int32 XML_focus = 2356;
const sal_Int32 XML_focusposition = 2357;
const sal_Int32 XML_focussize = 2358;
const sal_Int32 XML_folHlink = 2359;
const sal_Int32 XML_foldedCorner = 2360;
const sal_Int32 XML_follow = 2361;
const sal_Int32 XML_followColorScheme = 2362;
const sal_Int32 XML_followSib = 2363;
const sal_Int32 XML_followedHyperlink = 2364;
const sal_Int32 XML_font = 2365;
const sal_Int32 XML_font4 = 2366;
const sal_Int32 XML_fontAlgn = 2367;
const sal_Int32 XML_fontColor = 2368;
const sal_Int32 XML_fontId = 2369;
const sal_Int32 XML_fontKey = 2370;
const sal_Int32 XML_fontRef = 2371;
const sal_Int32 XML_fontScale = 2372;
const sal_Int32 XML_fontScheme = 2373;
const sal_Int32 XML_fontSz = 2374;
const sal_Int32 XML_fonts = 2375;
const sal_Int32 XML_footer = 2376;
const sal_Int32 XML_footerReference = 2377;
const sal_Int32 XML_footnote = 2378;
const sal_Int32 XML_footnoteLayoutLikeWW8 = 2379;
const sal_Int32 XML_footnotePr = 2380;
const sal_Int32 XML_footnoteRef = 2381;
const sal_Int32 XML_footnoteReference = 2382;
const sal_Int32 XML_footnotes = 2383;
const sal_Int32 XML_for = 2384;
const sal_Int32 XML_forEach = 2385;
const sal_Int32 XML_forName = 2386;
const sal_Int32 XML_forceAA = 2387;
const sal_Int32 XML_forceFullCalc = 2388;
const sal_Int32 XML_forceUpgrade = 2389;
const sal_Int32 XML_forcedash = 2390;
const sal_Int32 XML_foredepth = 2391;
const sal_Int32 XML_forestGreen = 2392;
const sal_Int32 XML_forgetLastTabAlignment = 2393;
const sal_Int32 XML_formControlPr = 2394;
const sal_Int32 XML_formFld = 2395;
const sal_Int32 XML_formLetters = 2396;
const sal_Int32 XML_formProt = 2397;
const sal_Int32 XML_format = 2398;
const sal_Int32 XML_formatCells = 2399;
const sal_Int32 XML_formatCode = 2400;
const sal_Int32 XML_formatColumns = 2401;
const sal_Int32 XML_formatRows = 2402;
const sal_Int32 XML_formats = 2403;
const sal_Int32 XML_formatting = 2404;
const sal_Int32 XML_forms = 2405;
const sal_Int32 XML_formsDesign = 2406;
const sal_Int32 XML_formula = 2407;
const sal_Int32 XML_formula1 = 2408;
const sal_Int32 XML_formula2 = 2409;
const sal_Int32 XML_formulaRange = 2410;
const sal_Int32 XML_formulas = 2411;
const sal_Int32 XML_forward = 2412;
const sal_Int32 XML_fourObj = 2413;
const sal_Int32 XML_fov = 2414;
const sal_Int32 XML_fraktur = 2415;
const sal_Int32 XML_frame = 2416;
const sal_Int32 XML_frameLayout = 2417;
const sal_Int32 XML_framePr = 2418;
const sal_Int32 XML_frameSlides = 2419;
const sal_Int32 XML_frameStyle1 = 2420;
const sal_Int32 XML_frameStyle2 = 2421;
const sal_Int32 XML_frameStyle3 = 2422;
const sal_Int32 XML_frameStyle4 = 2423;
const sal_Int32 XML_frameStyle5 = 2424;
const sal_Int32 XML_frameStyle6 = 2425;
const sal_Int32 XML_frameStyle7 = 2426;
const sal_Int32 XML_frameset = 2427;
const sal_Int32 XML_framesetSplitbar = 2428;
const sal_Int32 XML_freeze = 2429;
const sal_Int32 XML_freezing = 2430;
const sal_Int32 XML_from = 2431;
const sal_Int32 XML_fromB = 2432;
const sal_Int32 XML_fromL = 2433;
const sal_Int32 XML_fromR = 2434;
const sal_Int32 XML_fromT = 2435;
const sal_Int32 XML_fromWordArt = 2436;
const sal_Int32 XML_front = 2437;
const sal_Int32 XML_frozen = 2438;
const sal_Int32 XML_frozenSplit = 2439;
const sal_Int32 XML_ftr = 2440;
const sal_Int32 XML_ftrs = 2441;
const sal_Int32 XML_fuchsia = 2442;
const sal_Int32 XML_full = 2443;
const sal_Int32 XML_fullAlpha = 2444;
const sal_Int32 XML_fullCalcOnLoad = 2445;
const sal_Int32 XML_fullDate = 2446;
const sal_Int32 XML_fullHangul = 2447;
const sal_Int32 XML_fullKatakana = 2448;
const sal_Int32 XML_fullPage = 2449;
const sal_Int32 XML_fullPrecision = 2450;
const sal_Int32 XML_fullScrn = 2451;
const sal_Int32 XML_fullwidthKatakana = 2452;
const sal_Int32 XML_func = 2453;
const sal_Int32 XML_funcPr = 2454;
const sal_Int32 XML_function = 2455;
const sal_Int32 XML_functionGroup = 2456;
const sal_Int32 XML_functionGroupId = 2457;
const sal_Int32 XML_functionGroups = 2458;
const sal_Int32 XML_funnel = 2459;
const sal_Int32 XML_futureMetadata = 2460;
const sal_Int32 XML_g = 2461;
const sal_Int32 XML_gDay = 2462;
const sal_Int32 XML_gMonth = 2463;
const sal_Int32 XML_gMonthDay = 2464;
const sal_Int32 XML_gYear = 2465;
const sal_Int32 XML_gYearMonth = 2466;
const sal_Int32 XML_gain = 2467;
const sal_Int32 XML_gainsboro = 2468;
const sal_Int32 XML_gallery = 2469;
const sal_Int32 XML_gamma = 2470;
const sal_Int32 XML_ganada = 2471;
const sal_Int32 XML_gap = 2472;
const sal_Int32 XML_gapDepth = 2473;
const sal_Int32 XML_gapWidth = 2474;
const sal_Int32 XML_gd = 2475;
const sal_Int32 XML_gdLst = 2476;
const sal_Int32 XML_gdRefAng = 2477;
const sal_Int32 XML_gdRefR = 2478;
const sal_Int32 XML_gdRefX = 2479;
const sal_Int32 XML_gdRefY = 2480;
const sal_Int32 XML_ge = 2481;
const sal_Int32 XML_gear6 = 2482;
const sal_Int32 XML_gear9 = 2483;
const sal_Int32 XML_gems = 2484;
const sal_Int32 XML_general = 2485;
const sal_Int32 XML_gfxdata = 2486;
const sal_Int32 XML_ghostCol = 2487;
const sal_Int32 XML_ghostRow = 2488;
const sal_Int32 XML_ghostWhite = 2489;
const sal_Int32 XML_gingerbreadMan = 2490;
const sal_Int32 XML_glitter = 2491;
const sal_Int32 XML_glossaryDocument = 2492;
const sal_Int32 XML_glow = 2493;
const sal_Int32 XML_goal = 2494;
const sal_Int32 XML_gold = 2495;
const sal_Int32 XML_goldenrod = 2496;
const sal_Int32 XML_grDir = 2497;
const sal_Int32 XML_gradFill = 2498;
const sal_Int32 XML_gradient = 2499;
const sal_Int32 XML_gradientActiveCaption = 2500;
const sal_Int32 XML_gradientCenter = 2501;
const sal_Int32 XML_gradientFill = 2502;
const sal_Int32 XML_gradientInactiveCaption = 2503;
const sal_Int32 XML_gradientRadial = 2504;
const sal_Int32 XML_gradientUnscaled = 2505;
const sal_Int32 XML_gradientshapeok = 2506;
const sal_Int32 XML_grainSize = 2507;
const sal_Int32 XML_gramEnd = 2508;
const sal_Int32 XML_gramStart = 2509;
const sal_Int32 XML_grammar = 2510;
const sal_Int32 XML_grand = 2511;
const sal_Int32 XML_grandCol = 2512;
const sal_Int32 XML_grandRow = 2513;
const sal_Int32 XML_grandTotalCaption = 2514;
const sal_Int32 XML_graphic = 2515;
const sal_Int32 XML_graphicData = 2516;
const sal_Int32 XML_graphicEl = 2517;
const sal_Int32 XML_graphicFrame = 2518;
const sal_Int32 XML_graphicFrameLocks = 2519;
const sal_Int32 XML_grav = 2520;
const sal_Int32 XML_gray = 2521;
const sal_Int32 XML_gray0625 = 2522;
const sal_Int32 XML_gray125 = 2523;
const sal_Int32 XML_grayOutline = 2524;
const sal_Int32 XML_grayScale = 2525;
const sal_Int32 XML_grayText = 2526;
const sal_Int32 XML_grayWhite = 2527;
const sal_Int32 XML_grayscale = 2528;
const sal_Int32 XML_grayscl = 2529;
const sal_Int32 XML_greaterThan = 2530;
const sal_Int32 XML_greaterThanOrEqual = 2531;
const sal_Int32 XML_green = 2532;
const sal_Int32 XML_greenMod = 2533;
const sal_Int32 XML_greenOff = 2534;
const sal_Int32 XML_greenYellow = 2535;
const sal_Int32 XML_gregorian = 2536;
const sal_Int32 XML_gregorianArabic = 2537;
const sal_Int32 XML_gregorianMeFrench = 2538;
const sal_Int32 XML_gregorianUs = 2539;
const sal_Int32 XML_gregorianXlitEnglish = 2540;
const sal_Int32 XML_gregorianXlitFrench = 2541;
const sal_Int32 XML_gridAfter = 2542;
const sal_Int32 XML_gridBefore = 2543;
const sal_Int32 XML_gridCol = 2544;
const sal_Int32 XML_gridDropZones = 2545;
const sal_Int32 XML_gridLegend = 2546;
const sal_Int32 XML_gridLines = 2547;
const sal_Int32 XML_gridLinesSet = 2548;
const sal_Int32 XML_gridSize = 2549;
const sal_Int32 XML_gridSpacing = 2550;
const sal_Int32 XML_gridSpan = 2551;
const sal_Int32 XML_group = 2552;
const sal_Int32 XML_groupBy = 2553;
const sal_Int32 XML_groupChr = 2554;
const sal_Int32 XML_groupChrPr = 2555;
const sal_Int32 XML_groupInterval = 2556;
const sal_Int32 XML_groupItems = 2557;
const sal_Int32 XML_groupLevel = 2558;
const sal_Int32 XML_groupLevels = 2559;
const sal_Int32 XML_groupMember = 2560;
const sal_Int32 XML_groupMembers = 2561;
const sal_Int32 XML_grouping = 2562;
const sal_Int32 XML_groups = 2563;
const sal_Int32 XML_grow = 2564;
const sal_Int32 XML_growAutofit = 2565;
const sal_Int32 XML_growShrinkType = 2566;
const sal_Int32 XML_grpFill = 2567;
const sal_Int32 XML_grpId = 2568;
const sal_Int32 XML_grpSp = 2569;
const sal_Int32 XML_grpSpLocks = 2570;
const sal_Int32 XML_grpSpPr = 2571;
const sal_Int32 XML_gs = 2572;
const sal_Int32 XML_gsLst = 2573;
const sal_Int32 XML_gt = 2574;
const sal_Int32 XML_gte = 2575;
const sal_Int32 XML_guid = 2576;
const sal_Int32 XML_guide = 2577;
const sal_Int32 XML_guideLst = 2578;
const sal_Int32 XML_gutter = 2579;
const sal_Int32 XML_gutterAtTop = 2580;
const sal_Int32 XML_h = 2581;
const sal_Int32 XML_hAnchor = 2582;
const sal_Int32 XML_hAnsi = 2583;
const sal_Int32 XML_hAnsiTheme = 2584;
const sal_Int32 XML_hArH = 2585;
const sal_Int32 XML_hMerge = 2586;
const sal_Int32 XML_hMode = 2587;
const sal_Int32 XML_hOff = 2588;
const sal_Int32 XML_hPercent = 2589;
const sal_Int32 XML_hR = 2590;
const sal_Int32 XML_hRule = 2591;
const sal_Int32 XML_hSpace = 2592;
const sal_Int32 XML_hagakiCard = 2593;
const sal_Int32 XML_hair = 2594;
const sal_Int32 XML_hairline = 2595;
const sal_Int32 XML_half = 2596;
const sal_Int32 XML_halfAlpha = 2597;
const sal_Int32 XML_halfFrame = 2598;
const sal_Int32 XML_halfHangul = 2599;
const sal_Int32 XML_halfKatakana = 2600;
const sal_Int32 XML_halfwidthKatakana = 2601;
const sal_Int32 XML_handles = 2602;
const sal_Int32 XML_handmade1 = 2603;
const sal_Int32 XML_handmade2 = 2604;
const sal_Int32 XML_handoutMaster = 2605;
const sal_Int32 XML_handoutMasterId = 2606;
const sal_Int32 XML_handoutMasterIdLst = 2607;
const sal_Int32 XML_handoutView = 2608;
const sal_Int32 XML_handouts1 = 2609;
const sal_Int32 XML_handouts2 = 2610;
const sal_Int32 XML_handouts3 = 2611;
const sal_Int32 XML_handouts4 = 2612;
const sal_Int32 XML_handouts6 = 2613;
const sal_Int32 XML_handouts9 = 2614;
const sal_Int32 XML_hang = 2615;
const sal_Int32 XML_hanging = 2616;
const sal_Int32 XML_hangingChars = 2617;
const sal_Int32 XML_hangingPunct = 2618;
const sal_Int32 XML_hardEdge = 2619;
const sal_Int32 XML_harsh = 2620;
const sal_Int32 XML_hasCustomPrompt = 2621;
const sal_Int32 XML_hash = 2622;
const sal_Int32 XML_hashData = 2623;
const sal_Int32 XML_hashValue = 2624;
const sal_Int32 XML_hc = 2625;
const sal_Int32 XML_hd10 = 2626;
const sal_Int32 XML_hd2 = 2627;
const sal_Int32 XML_hd3 = 2628;
const sal_Int32 XML_hd4 = 2629;
const sal_Int32 XML_hd5 = 2630;
const sal_Int32 XML_hd6 = 2631;
const sal_Int32 XML_hd8 = 2632;
const sal_Int32 XML_hdr = 2633;
const sal_Int32 XML_hdrShapeDefaults = 2634;
const sal_Int32 XML_hdrs = 2635;
const sal_Int32 XML_headEnd = 2636;
const sal_Int32 XML_header = 2637;
const sal_Int32 XML_headerFooter = 2638;
const sal_Int32 XML_headerReference = 2639;
const sal_Int32 XML_headerRow = 2640;
const sal_Int32 XML_headerRowBorderDxfId = 2641;
const sal_Int32 XML_headerRowCellStyle = 2642;
const sal_Int32 XML_headerRowCount = 2643;
const sal_Int32 XML_headerRowDxfId = 2644;
const sal_Int32 XML_headerSource = 2645;
const sal_Int32 XML_headers = 2646;
const sal_Int32 XML_headersInLastRefresh = 2647;
const sal_Int32 XML_heading = 2648;
const sal_Int32 XML_headings = 2649;
const sal_Int32 XML_heart = 2650;
const sal_Int32 XML_heartBalloon = 2651;
const sal_Int32 XML_heartGray = 2652;
const sal_Int32 XML_hearts = 2653;
const sal_Int32 XML_heavy = 2654;
const sal_Int32 XML_hebrew = 2655;
const sal_Int32 XML_hebrew1 = 2656;
const sal_Int32 XML_hebrew2 = 2657;
const sal_Int32 XML_hebrew2Minus = 2658;
const sal_Int32 XML_heebieJeebies = 2659;
const sal_Int32 XML_help = 2660;
const sal_Int32 XML_helpText = 2661;
const sal_Int32 XML_heptagon = 2662;
const sal_Int32 XML_hex = 2663;
const sal_Int32 XML_hexBinary = 2664;
const sal_Int32 XML_hexagon = 2665;
const sal_Int32 XML_hf = 2666;
const sal_Int32 XML_hiLowLines = 2667;
const sal_Int32 XML_hidden = 2668;
const sal_Int32 XML_hiddenButton = 2669;
const sal_Int32 XML_hiddenColumn = 2670;
const sal_Int32 XML_hiddenColumns = 2671;
const sal_Int32 XML_hiddenLevel = 2672;
const sal_Int32 XML_hiddenRow = 2673;
const sal_Int32 XML_hiddenRows = 2674;
const sal_Int32 XML_hiddenSlides = 2675;
const sal_Int32 XML_hide = 2676;
const sal_Int32 XML_hideBot = 2677;
const sal_Int32 XML_hideGeom = 2678;
const sal_Int32 XML_hideGrammaticalErrors = 2679;
const sal_Int32 XML_hideLastTrans = 2680;
const sal_Int32 XML_hideLeft = 2681;
const sal_Int32 XML_hideMark = 2682;
const sal_Int32 XML_hideNewItems = 2683;
const sal_Int32 XML_hidePivotFieldList = 2684;
const sal_Int32 XML_hideRight = 2685;
const sal_Int32 XML_hideSpellingErrors = 2686;
const sal_Int32 XML_hideTop = 2687;
const sal_Int32 XML_hier = 2688;
const sal_Int32 XML_hierAlign = 2689;
const sal_Int32 XML_hierBranch = 2690;
const sal_Int32 XML_hierChild = 2691;
const sal_Int32 XML_hierRoot = 2692;
const sal_Int32 XML_hierarchy = 2693;
const sal_Int32 XML_hierarchyUsage = 2694;
const sal_Int32 XML_high = 2695;
const sal_Int32 XML_highContrast = 2696;
const sal_Int32 XML_highKashida = 2697;
const sal_Int32 XML_highlight = 2698;
const sal_Int32 XML_highlightClick = 2699;
const sal_Int32 XML_highlightText = 2700;
const sal_Int32 XML_hijri = 2701;
const sal_Int32 XML_hindiAlpha1Period = 2702;
const sal_Int32 XML_hindiAlphaPeriod = 2703;
const sal_Int32 XML_hindiConsonants = 2704;
const sal_Int32 XML_hindiCounting = 2705;
const sal_Int32 XML_hindiNumParenR = 2706;
const sal_Int32 XML_hindiNumPeriod = 2707;
const sal_Int32 XML_hindiNumbers = 2708;
const sal_Int32 XML_hindiVowels = 2709;
const sal_Int32 XML_hint = 2710;
const sal_Int32 XML_hiragana = 2711;
const sal_Int32 XML_history = 2712;
const sal_Int32 XML_hlink = 2713;
const sal_Int32 XML_hlinkClick = 2714;
const sal_Int32 XML_hlinkHover = 2715;
const sal_Int32 XML_hlinkMouseOver = 2716;
const sal_Int32 XML_hold = 2717;
const sal_Int32 XML_holeSize = 2718;
const sal_Int32 XML_holly = 2719;
const sal_Int32 XML_honeycomb = 2720;
const sal_Int32 XML_homePlate = 2721;
const sal_Int32 XML_honeydew = 2722;
const sal_Int32 XML_horizontal = 2723;
const sal_Int32 XML_horizontalCentered = 2724;
const sal_Int32 XML_horizontalDpi = 2725;
const sal_Int32 XML_horizontalScroll = 2726;
const sal_Int32 XML_horz = 2727;
const sal_Int32 XML_horzAlign = 2728;
const sal_Int32 XML_horzAnchor = 2729;
const sal_Int32 XML_horzBarState = 2730;
const sal_Int32 XML_horzBrick = 2731;
const sal_Int32 XML_horzCross = 2732;
const sal_Int32 XML_horzOverflow = 2733;
const sal_Int32 XML_horzStripe = 2734;
const sal_Int32 XML_hotLight = 2735;
const sal_Int32 XML_hotPink = 2736;
const sal_Int32 XML_hour = 2737;
const sal_Int32 XML_hours = 2738;
const sal_Int32 XML_houseFunky = 2739;
const sal_Int32 XML_how = 2740;
const sal_Int32 XML_hps = 2741;
const sal_Int32 XML_hpsBaseText = 2742;
const sal_Int32 XML_hpsRaise = 2743;
const sal_Int32 XML_hqprint = 2744;
const sal_Int32 XML_hr = 2745;
const sal_Int32 XML_hralign = 2746;
const sal_Int32 XML_href = 2747;
const sal_Int32 XML_hrnoshade = 2748;
const sal_Int32 XML_hrpct = 2749;
const sal_Int32 XML_hrstd = 2750;
const sal_Int32 XML_hsl = 2751;
const sal_Int32 XML_hslClr = 2752;
const sal_Int32 XML_ht = 2753;
const sal_Int32 XML_htmlFormat = 2754;
const sal_Int32 XML_htmlPubPr = 2755;
const sal_Int32 XML_htmlTables = 2756;
const sal_Int32 XML_hue = 2757;
const sal_Int32 XML_hueDir = 2758;
const sal_Int32 XML_hueMod = 2759;
const sal_Int32 XML_hueOff = 2760;
const sal_Int32 XML_hundredMillions = 2761;
const sal_Int32 XML_hundredThousands = 2762;
const sal_Int32 XML_hundreds = 2763;
const sal_Int32 XML_hybridMultilevel = 2764;
const sal_Int32 XML_hyperlink = 2765;
const sal_Int32 XML_hyperlinks = 2766;
const sal_Int32 XML_hyphen = 2767;
const sal_Int32 XML_hyphenationZone = 2768;
const sal_Int32 XML_hypnotic = 2769;
const sal_Int32 XML_i = 2770;
const sal_Int32 XML_i1 = 2771;
const sal_Int32 XML_i2 = 2772;
const sal_Int32 XML_i3 = 2773;
const sal_Int32 XML_i4 = 2774;
const sal_Int32 XML_i8 = 2775;
const sal_Int32 XML_iCs = 2776;
const sal_Int32 XML_iLevel = 2777;
const sal_Int32 XML_iMeasureFld = 2778;
const sal_Int32 XML_iMeasureHier = 2779;
const sal_Int32 XML_iceCreamCones = 2780;
const sal_Int32 XML_icon = 2781;
const sal_Int32 XML_iconFilter = 2782;
const sal_Int32 XML_iconId = 2783;
const sal_Int32 XML_iconSet = 2784;
const sal_Int32 XML_id = 2785;
const sal_Int32 XML_idcntr = 2786;
const sal_Int32 XML_iddest = 2787;
const sal_Int32 XML_identifier = 2788;
const sal_Int32 XML_ideographDigital = 2789;
const sal_Int32 XML_ideographEnclosedCircle = 2790;
const sal_Int32 XML_ideographLegalTraditional = 2791;
const sal_Int32 XML_ideographTraditional = 2792;
const sal_Int32 XML_ideographZodiac = 2793;
const sal_Int32 XML_ideographZodiacTraditional = 2794;
const sal_Int32 XML_idmap = 2795;
const sal_Int32 XML_idref = 2796;
const sal_Int32 XML_idsrc = 2797;
const sal_Int32 XML_idx = 2798;
const sal_Int32 XML_if = 2799;
const sal_Int32 XML_ignore = 2800;
const sal_Int32 XML_ignoreMixedContent = 2801;
const sal_Int32 XML_ignoredError = 2802;
const sal_Int32 XML_ignoredErrors = 2803;
const sal_Int32 XML_ilvl = 2804;
const sal_Int32 XML_image = 2805;
const sal_Int32 XML_imagealignshape = 2806;
const sal_Int32 XML_imageaspect = 2807;
const sal_Int32 XML_imagedata = 2808;
const sal_Int32 XML_imagesize = 2809;
const sal_Int32 XML_imeMode = 2810;
const sal_Int32 XML_img = 2811;
const sal_Int32 XML_imgEffect = 2812;
const sal_Int32 XML_imgH = 2813;
const sal_Int32 XML_imgLayer = 2814;
const sal_Int32 XML_imgProps = 2815;
const sal_Int32 XML_imgSz = 2816;
const sal_Int32 XML_imgW = 2817;
const sal_Int32 XML_immersive = 2818;
const sal_Int32 XML_imprint = 2819;
const sal_Int32 XML_in = 2820;
const sal_Int32 XML_inBase = 2821;
const sal_Int32 XML_inByRing = 2822;
const sal_Int32 XML_inEnd = 2823;
const sal_Int32 XML_inactiveBorder = 2824;
const sal_Int32 XML_inactiveCaption = 2825;
const sal_Int32 XML_inactiveCaptionText = 2826;
const sal_Int32 XML_includeHiddenRowCol = 2827;
const sal_Int32 XML_includeNewItemsInFilter = 2828;
const sal_Int32 XML_includePrintSettings = 2829;
const sal_Int32 XML_ind = 2830;
const sal_Int32 XML_indefinite = 2831;
const sal_Int32 XML_indent = 2832;
const sal_Int32 XML_index = 2833;
const sal_Int32 XML_indexed = 2834;
const sal_Int32 XML_indexedColors = 2835;
const sal_Int32 XML_indianRed = 2836;
const sal_Int32 XML_indigo = 2837;
const sal_Int32 XML_infoBk = 2838;
const sal_Int32 XML_infoText = 2839;
const sal_Int32 XML_information = 2840;
const sal_Int32 XML_init = 2841;
const sal_Int32 XML_initials = 2842;
const sal_Int32 XML_ink = 2843;
const sal_Int32 XML_inkAnnotations = 2844;
const sal_Int32 XML_inkTgt = 2845;
const sal_Int32 XML_inline = 2846;
const sal_Int32 XML_inlineStr = 2847;
const sal_Int32 XML_inner = 2848;
const sal_Int32 XML_innerShdw = 2849;
const sal_Int32 XML_inputCells = 2850;
const sal_Int32 XML_ins = 2851;
const sal_Int32 XML_insDel = 2852;
const sal_Int32 XML_insertBlankRow = 2853;
const sal_Int32 XML_insertClear = 2854;
const sal_Int32 XML_insertCol = 2855;
const sal_Int32 XML_insertColumns = 2856;
const sal_Int32 XML_insertDelete = 2857;
const sal_Int32 XML_insertHyperlinks = 2858;
const sal_Int32 XML_insertPageBreak = 2859;
const sal_Int32 XML_insertRow = 2860;
const sal_Int32 XML_insertRowShift = 2861;
const sal_Int32 XML_insertRows = 2862;
const sal_Int32 XML_inset = 2863;
const sal_Int32 XML_insetmode = 2864;
const sal_Int32 XML_insetpen = 2865;
const sal_Int32 XML_insetpenok = 2866;
const sal_Int32 XML_inside = 2867;
const sal_Int32 XML_insideH = 2868;
const sal_Int32 XML_insideMargin = 2869;
const sal_Int32 XML_insideV = 2870;
const sal_Int32 XML_instr = 2871;
const sal_Int32 XML_instrText = 2872;
const sal_Int32 XML_int = 2873;
const sal_Int32 XML_intLim = 2874;
const sal_Int32 XML_intVal = 2875;
const sal_Int32 XML_integer = 2876;
const sal_Int32 XML_integrated = 2877;
const sal_Int32 XML_intensity = 2878;
const sal_Int32 XML_interSp = 2879;
const sal_Int32 XML_interactiveSeq = 2880;
const sal_Int32 XML_intercept = 2881;
const sal_Int32 XML_intermediate = 2882;
const sal_Int32 XML_interval = 2883;
const sal_Int32 XML_intraSp = 2884;
const sal_Int32 XML_inv = 2885;
const sal_Int32 XML_invGamma = 2886;
const sal_Int32 XML_invGray = 2887;
const sal_Int32 XML_invalEndChars = 2888;
const sal_Int32 XML_invalStChars = 2889;
const sal_Int32 XML_invalid = 2890;
const sal_Int32 XML_invalidUrl = 2891;
const sal_Int32 XML_inverseGray = 2892;
const sal_Int32 XML_invertIfNegative = 2893;
const sal_Int32 XML_invx = 2894;
const sal_Int32 XML_invy = 2895;
const sal_Int32 XML_iroha = 2896;
const sal_Int32 XML_irohaFullWidth = 2897;
const sal_Int32 XML_irregularSeal1 = 2898;
const sal_Int32 XML_irregularSeal2 = 2899;
const sal_Int32 XML_is = 2900;
const sal_Int32 XML_isInverted = 2901;
const sal_Int32 XML_isLgl = 2902;
const sal_Int32 XML_isNarration = 2903;
const sal_Int32 XML_isPhoto = 2904;
const sal_Int32 XML_iscomment = 2905;
const sal_Int32 XML_isometricBottomDown = 2906;
const sal_Int32 XML_isometricBottomUp = 2907;
const sal_Int32 XML_isometricLeftDown = 2908;
const sal_Int32 XML_isometricLeftUp = 2909;
const sal_Int32 XML_isometricOffAxis1Left = 2910;
const sal_Int32 XML_isometricOffAxis1Right = 2911;
const sal_Int32 XML_isometricOffAxis1Top = 2912;
const sal_Int32 XML_isometricOffAxis2Left = 2913;
const sal_Int32 XML_isometricOffAxis2Right = 2914;
const sal_Int32 XML_isometricOffAxis2Top = 2915;
const sal_Int32 XML_isometricOffAxis3Bottom = 2916;
const sal_Int32 XML_isometricOffAxis3Left = 2917;
const sal_Int32 XML_isometricOffAxis3Right = 2918;
const sal_Int32 XML_isometricOffAxis4Bottom = 2919;
const sal_Int32 XML_isometricOffAxis4Left = 2920;
const sal_Int32 XML_isometricOffAxis4Right = 2921;
const sal_Int32 XML_isometricRightDown = 2922;
const sal_Int32 XML_isometricRightUp = 2923;
const sal_Int32 XML_isometricTopDown = 2924;
const sal_Int32 XML_isometricTopUp = 2925;
const sal_Int32 XML_issignatureline = 2926;
const sal_Int32 XML_italic = 2927;
const sal_Int32 XML_item = 2928;
const sal_Int32 XML_itemID = 2929;
const sal_Int32 XML_itemPageCount = 2930;
const sal_Int32 XML_itemPrintTitles = 2931;
const sal_Int32 XML_items = 2932;
const sal_Int32 XML_iterate = 2933;
const sal_Int32 XML_iterateCount = 2934;
const sal_Int32 XML_iterateDelta = 2935;
const sal_Int32 XML_ivory = 2936;
const sal_Int32 XML_japan = 2937;
const sal_Int32 XML_japaneseCounting = 2938;
const sal_Int32 XML_japaneseDigitalTenThousand = 2939;
const sal_Int32 XML_japaneseLegal = 2940;
const sal_Int32 XML_jc = 2941;
const sal_Int32 XML_joinstyle = 2942;
const sal_Int32 XML_just = 2943;
const sal_Int32 XML_justLow = 2944;
const sal_Int32 XML_justify = 2945;
const sal_Int32 XML_justifyLastLine = 2946;
const sal_Int32 XML_k = 2947;
const sal_Int32 XML_keepAlive = 2948;
const sal_Int32 XML_keepChangeHistory = 2949;
const sal_Int32 XML_keepLines = 2950;
const sal_Int32 XML_keepNext = 2951;
const sal_Int32 XML_kern = 2952;
const sal_Int32 XML_key = 2953;
const sal_Int32 XML_keyAttribute = 2954;
const sal_Int32 XML_keywords = 2955;
const sal_Int32 XML_khaki = 2956;
const sal_Int32 XML_kinsoku = 2957;
const sal_Int32 XML_kiosk = 2958;
const sal_Int32 XML_korea = 2959;
const sal_Int32 XML_koreanCounting = 2960;
const sal_Int32 XML_koreanDigital = 2961;
const sal_Int32 XML_koreanDigital2 = 2962;
const sal_Int32 XML_koreanLegal = 2963;
const sal_Int32 XML_kpi = 2964;
const sal_Int32 XML_kpis = 2965;
const sal_Int32 XML_kumimoji = 2966;
const sal_Int32 XML_kx = 2967;
const sal_Int32 XML_ky = 2968;
const sal_Int32 XML_l = 2969;
const sal_Int32 XML_lB = 2970;
const sal_Int32 XML_lBounds = 2971;
const sal_Int32 XML_lCtrCh = 2972;
const sal_Int32 XML_lCtrDes = 2973;
const sal_Int32 XML_lIns = 2974;
const sal_Int32 XML_lMarg = 2975;
const sal_Int32 XML_lMargin = 2976;
const sal_Int32 XML_lOff = 2977;
const sal_Int32 XML_lT = 2978;
const sal_Int32 XML_label = 2979;
const sal_Int32 XML_labelOnly = 2980;
const sal_Int32 XML_landscape = 2981;
const sal_Int32 XML_lang = 2982;
const sal_Int32 XML_language = 2983;
const sal_Int32 XML_largest = 2984;
const sal_Int32 XML_last = 2985;
const sal_Int32 XML_last7Days = 2986;
const sal_Int32 XML_lastClick = 2987;
const sal_Int32 XML_lastClr = 2988;
const sal_Int32 XML_lastCol = 2989;
const sal_Int32 XML_lastColumn = 2990;
const sal_Int32 XML_lastEdited = 2991;
const sal_Int32 XML_lastGuid = 2992;
const sal_Int32 XML_lastHeaderCell = 2993;
const sal_Int32 XML_lastIdx = 2994;
const sal_Int32 XML_lastLineOnly = 2995;
const sal_Int32 XML_lastModifiedBy = 2996;
const sal_Int32 XML_lastMonth = 2997;
const sal_Int32 XML_lastPrinted = 2998;
const sal_Int32 XML_lastQuarter = 2999;
const sal_Int32 XML_lastRenderedPageBreak = 3000;
const sal_Int32 XML_lastRow = 3001;
const sal_Int32 XML_lastRowFirstColumn = 3002;
const sal_Int32 XML_lastRowLastColumn = 3003;
const sal_Int32 XML_lastTotalCell = 3004;
const sal_Int32 XML_lastValue = 3005;
const sal_Int32 XML_lastView = 3006;
const sal_Int32 XML_lastWeek = 3007;
const sal_Int32 XML_lastYear = 3008;
const sal_Int32 XML_lat = 3009;
const sal_Int32 XML_latentStyles = 3010;
const sal_Int32 XML_latin = 3011;
const sal_Int32 XML_latinLnBrk = 3012;
const sal_Int32 XML_lavender = 3013;
const sal_Int32 XML_lavenderBlush = 3014;
const sal_Int32 XML_lawnGreen = 3015;
const sal_Int32 XML_layout = 3016;
const sal_Int32 XML_layoutDef = 3017;
const sal_Int32 XML_layoutDefHdr = 3018;
const sal_Int32 XML_layoutDefHdrLst = 3019;
const sal_Int32 XML_layoutInCell = 3020;
const sal_Int32 XML_layoutNode = 3021;
const sal_Int32 XML_layoutRawTableWidth = 3022;
const sal_Int32 XML_layoutTableRowsApart = 3023;
const sal_Int32 XML_layoutTarget = 3024;
const sal_Int32 XML_lblAlgn = 3025;
const sal_Int32 XML_lblOffset = 3026;
const sal_Int32 XML_lc = 3027;
const sal_Int32 XML_ld = 3028;
const sal_Int32 XML_le = 3029;
const sal_Int32 XML_leader = 3030;
const sal_Int32 XML_leaderLines = 3031;
const sal_Int32 XML_ledger = 3032;
const sal_Int32 XML_left = 3033;
const sal_Int32 XML_leftArrow = 3034;
const sal_Int32 XML_leftArrowCallout = 3035;
const sal_Int32 XML_leftBrace = 3036;
const sal_Int32 XML_leftBracket = 3037;
const sal_Int32 XML_leftChars = 3038;
const sal_Int32 XML_leftCircularArrow = 3039;
const sal_Int32 XML_leftFromText = 3040;
const sal_Int32 XML_leftLabels = 3041;
const sal_Int32 XML_leftMargin = 3042;
const sal_Int32 XML_leftRightArrow = 3043;
const sal_Int32 XML_leftRightArrowCallout = 3044;
const sal_Int32 XML_leftRightCircularArrow = 3045;
const sal_Int32 XML_leftRightRibbon = 3046;
const sal_Int32 XML_leftRightUpArrow = 3047;
const sal_Int32 XML_leftUpArrow = 3048;
const sal_Int32 XML_legacy = 3049;
const sal_Int32 XML_legacyDrawing = 3050;
const sal_Int32 XML_legacyDrawingHF = 3051;
const sal_Int32 XML_legacyFlat1 = 3052;
const sal_Int32 XML_legacyFlat2 = 3053;
const sal_Int32 XML_legacyFlat3 = 3054;
const sal_Int32 XML_legacyFlat4 = 3055;
const sal_Int32 XML_legacyHarsh1 = 3056;
const sal_Int32 XML_legacyHarsh2 = 3057;
const sal_Int32 XML_legacyHarsh3 = 3058;
const sal_Int32 XML_legacyHarsh4 = 3059;
const sal_Int32 XML_legacyIndent = 3060;
const sal_Int32 XML_legacyMatte = 3061;
const sal_Int32 XML_legacyMetal = 3062;
const sal_Int32 XML_legacyNormal1 = 3063;
const sal_Int32 XML_legacyNormal2 = 3064;
const sal_Int32 XML_legacyNormal3 = 3065;
const sal_Int32 XML_legacyNormal4 = 3066;
const sal_Int32 XML_legacyObliqueBottom = 3067;
const sal_Int32 XML_legacyObliqueBottomLeft = 3068;
const sal_Int32 XML_legacyObliqueBottomRight = 3069;
const sal_Int32 XML_legacyObliqueFront = 3070;
const sal_Int32 XML_legacyObliqueLeft = 3071;
const sal_Int32 XML_legacyObliqueRight = 3072;
const sal_Int32 XML_legacyObliqueTop = 3073;
const sal_Int32 XML_legacyObliqueTopLeft = 3074;
const sal_Int32 XML_legacyObliqueTopRight = 3075;
const sal_Int32 XML_legacyPerspectiveBottom = 3076;
const sal_Int32 XML_legacyPerspectiveBottomLeft = 3077;
const sal_Int32 XML_legacyPerspectiveBottomRight = 3078;
const sal_Int32 XML_legacyPerspectiveFront = 3079;
const sal_Int32 XML_legacyPerspectiveLeft = 3080;
const sal_Int32 XML_legacyPerspectiveRight = 3081;
const sal_Int32 XML_legacyPerspectiveTop = 3082;
const sal_Int32 XML_legacyPerspectiveTopLeft = 3083;
const sal_Int32 XML_legacyPerspectiveTopRight = 3084;
const sal_Int32 XML_legacyPlastic = 3085;
const sal_Int32 XML_legacySpace = 3086;
const sal_Int32 XML_legacyWireframe = 3087;
const sal_Int32 XML_legend = 3088;
const sal_Int32 XML_legendEntry = 3089;
const sal_Int32 XML_legendPos = 3090;
const sal_Int32 XML_lemonChiffon = 3091;
const sal_Int32 XML_len = 3092;
const sal_Int32 XML_length = 3093;
const sal_Int32 XML_lengthspecified = 3094;
const sal_Int32 XML_lessThan = 3095;
const sal_Int32 XML_lessThanOrEqual = 3096;
const sal_Int32 XML_letter = 3097;
const sal_Int32 XML_level = 3098;
const sal_Int32 XML_lg = 3099;
const sal_Int32 XML_lgCheck = 3100;
const sal_Int32 XML_lgConfetti = 3101;
const sal_Int32 XML_lgDash = 3102;
const sal_Int32 XML_lgDashDot = 3103;
const sal_Int32 XML_lgDashDotDot = 3104;
const sal_Int32 XML_lgGrid = 3105;
const sal_Int32 XML_license = 3106;
const sal_Int32 XML_lid = 3107;
const sal_Int32 XML_ligatures = 3108;
const sal_Int32 XML_light1 = 3109;
const sal_Int32 XML_light2 = 3110;
const sal_Int32 XML_lightBulb = 3111;
const sal_Int32 XML_lightDown = 3112;
const sal_Int32 XML_lightGray = 3113;
const sal_Int32 XML_lightGrayscale = 3114;
const sal_Int32 XML_lightGrid = 3115;
const sal_Int32 XML_lightHorizontal = 3116;
const sal_Int32 XML_lightRig = 3117;
const sal_Int32 XML_lightTrellis = 3118;
const sal_Int32 XML_lightUp = 3119;
const sal_Int32 XML_lightVertical = 3120;
const sal_Int32 XML_lighten = 3121;
const sal_Int32 XML_lightenLess = 3122;
const sal_Int32 XML_lightface = 3123;
const sal_Int32 XML_lightharsh = 3124;
const sal_Int32 XML_lightharsh2 = 3125;
const sal_Int32 XML_lightlevel = 3126;
const sal_Int32 XML_lightlevel2 = 3127;
const sal_Int32 XML_lightning1 = 3128;
const sal_Int32 XML_lightning2 = 3129;
const sal_Int32 XML_lightningBolt = 3130;
const sal_Int32 XML_lightposition = 3131;
const sal_Int32 XML_lightposition2 = 3132;
const sal_Int32 XML_lights = 3133;
const sal_Int32 XML_lim = 3134;
const sal_Int32 XML_limLoc = 3135;
const sal_Int32 XML_limLow = 3136;
const sal_Int32 XML_limLowPr = 3137;
const sal_Int32 XML_limUpp = 3138;
const sal_Int32 XML_limUppPr = 3139;
const sal_Int32 XML_lime = 3140;
const sal_Int32 XML_limeGreen = 3141;
const sal_Int32 XML_limo = 3142;
const sal_Int32 XML_lin = 3143;
const sal_Int32 XML_linClrLst = 3144;
const sal_Int32 XML_linDir = 3145;
const sal_Int32 XML_line = 3146;
const sal_Int32 XML_line3DChart = 3147;
const sal_Int32 XML_lineChart = 3148;
const sal_Int32 XML_lineInv = 3149;
const sal_Int32 XML_lineMarker = 3150;
const sal_Int32 XML_linePitch = 3151;
const sal_Int32 XML_lineRule = 3152;
const sal_Int32 XML_lineTo = 3153;
const sal_Int32 XML_lineWeight = 3154;
const sal_Int32 XML_lineWrapLikeWord6 = 3155;
const sal_Int32 XML_linear = 3156;
const sal_Int32 XML_linen = 3157;
const sal_Int32 XML_lines = 3158;
const sal_Int32 XML_linesAndChars = 3159;
const sal_Int32 XML_linestyle = 3160;
const sal_Int32 XML_link = 3161;
const sal_Int32 XML_linkStyles = 3162;
const sal_Int32 XML_linkTarget = 3163;
const sal_Int32 XML_linkToQuery = 3164;
const sal_Int32 XML_linkedToFile = 3165;
const sal_Int32 XML_linkedTxbx = 3166;
const sal_Int32 XML_list = 3167;
const sal_Int32 XML_listDataValidation = 3168;
const sal_Int32 XML_listEntry = 3169;
const sal_Int32 XML_listItem = 3170;
const sal_Int32 XML_listSeparator = 3171;
const sal_Int32 XML_lit = 3172;
const sal_Int32 XML_lkTxEntry = 3173;
const sal_Int32 XML_ln = 3174;
const sal_Int32 XML_lnB = 3175;
const sal_Int32 XML_lnBlToTr = 3176;
const sal_Int32 XML_lnDef = 3177;
const sal_Int32 XML_lnL = 3178;
const sal_Int32 XML_lnNumType = 3179;
const sal_Int32 XML_lnR = 3180;
const sal_Int32 XML_lnRef = 3181;
const sal_Int32 XML_lnSpAfChP = 3182;
const sal_Int32 XML_lnSpAfParP = 3183;
const sal_Int32 XML_lnSpCh = 3184;
const sal_Int32 XML_lnSpPar = 3185;
const sal_Int32 XML_lnSpc = 3186;
const sal_Int32 XML_lnSpcReduction = 3187;
const sal_Int32 XML_lnStyleLst = 3188;
const sal_Int32 XML_lnT = 3189;
const sal_Int32 XML_lnTlToBr = 3190;
const sal_Int32 XML_lnTo = 3191;
const sal_Int32 XML_lo = 3192;
const sal_Int32 XML_loCatId = 3193;
const sal_Int32 XML_loTypeId = 3194;
const sal_Int32 XML_local = 3195;
const sal_Int32 XML_localConnection = 3196;
const sal_Int32 XML_localRefresh = 3197;
const sal_Int32 XML_localSheetId = 3198;
const sal_Int32 XML_location = 3199;
const sal_Int32 XML_lock = 3200;
const sal_Int32 XML_lockRevision = 3201;
const sal_Int32 XML_lockStructure = 3202;
const sal_Int32 XML_lockText = 3203;
const sal_Int32 XML_lockWindows = 3204;
const sal_Int32 XML_locked = 3205;
const sal_Int32 XML_lockedCanvas = 3206;
const sal_Int32 XML_lockrotationcenter = 3207;
const sal_Int32 XML_loext = 3208;
const sal_Int32 XML_log = 3209;
const sal_Int32 XML_logBase = 3210;
const sal_Int32 XML_lon = 3211;
const sal_Int32 XML_long = 3212;
const sal_Int32 XML_longCurve = 3213;
const sal_Int32 XML_longFileNames = 3214;
const sal_Int32 XML_longText = 3215;
const sal_Int32 XML_longdash = 3216;
const sal_Int32 XML_longdashdot = 3217;
const sal_Int32 XML_longdashdotdot = 3218;
const sal_Int32 XML_loop = 3219;
const sal_Int32 XML_low = 3220;
const sal_Int32 XML_lowKashida = 3221;
const sal_Int32 XML_lowerLetter = 3222;
const sal_Int32 XML_lowerRoman = 3223;
const sal_Int32 XML_lowestEdited = 3224;
const sal_Int32 XML_lpstr = 3225;
const sal_Int32 XML_lpwstr = 3226;
const sal_Int32 XML_lrTb = 3227;
const sal_Int32 XML_lrTbV = 3228;
const sal_Int32 XML_ls = 3229;
const sal_Int32 XML_lsdException = 3230;
const sal_Int32 XML_lstStyle = 3231;
const sal_Int32 XML_lt = 3232;
const sal_Int32 XML_lt1 = 3233;
const sal_Int32 XML_lt2 = 3234;
const sal_Int32 XML_ltBlue = 3235;
const sal_Int32 XML_ltCoral = 3236;
const sal_Int32 XML_ltCyan = 3237;
const sal_Int32 XML_ltDnDiag = 3238;
const sal_Int32 XML_ltGoldenrodYellow = 3239;
const sal_Int32 XML_ltGray = 3240;
const sal_Int32 XML_ltGreen = 3241;
const sal_Int32 XML_ltHorz = 3242;
const sal_Int32 XML_ltPink = 3243;
const sal_Int32 XML_ltSalmon = 3244;
const sal_Int32 XML_ltSeaGreen = 3245;
const sal_Int32 XML_ltSkyBlue = 3246;
const sal_Int32 XML_ltSlateGray = 3247;
const sal_Int32 XML_ltSteelBlue = 3248;
const sal_Int32 XML_ltUpDiag = 3249;
const sal_Int32 XML_ltVert = 3250;
const sal_Int32 XML_ltYellow = 3251;
const sal_Int32 XML_lte = 3252;
const sal_Int32 XML_lu = 3253;
const sal_Int32 XML_lum = 3254;
const sal_Int32 XML_lumMod = 3255;
const sal_Int32 XML_lumOff = 3256;
const sal_Int32 XML_lvl = 3257;
const sal_Int32 XML_lvl1pPr = 3258;
const sal_Int32 XML_lvl2pPr = 3259;
const sal_Int32 XML_lvl3pPr = 3260;
const sal_Int32 XML_lvl4pPr = 3261;
const sal_Int32 XML_lvl5pPr = 3262;
const sal_Int32 XML_lvl6pPr = 3263;
const sal_Int32 XML_lvl7pPr = 3264;
const sal_Int32 XML_lvl8pPr = 3265;
const sal_Int32 XML_lvl9pPr = 3266;
const sal_Int32 XML_lvlAtOnce = 3267;
const sal_Int32 XML_lvlJc = 3268;
const sal_Int32 XML_lvlOne = 3269;
const sal_Int32 XML_lvlOverride = 3270;
const sal_Int32 XML_lvlPicBulletId = 3271;
const sal_Int32 XML_lvlRestart = 3272;
const sal_Int32 XML_lvlText = 3273;
const sal_Int32 XML_m = 3274;
const sal_Int32 XML_mPr = 3275;
const sal_Int32 XML_mac = 3276;
const sal_Int32 XML_macro = 3277;
const sal_Int32 XML_macrosheet = 3278;
const sal_Int32 XML_magenta = 3279;
const sal_Int32 XML_mailAsAttachment = 3280;
const sal_Int32 XML_mailMerge = 3281;
const sal_Int32 XML_mailSubject = 3282;
const sal_Int32 XML_mailingLabels = 3283;
const sal_Int32 XML_main = 3284;
const sal_Int32 XML_mainDocumentType = 3285;
const sal_Int32 XML_mainSeq = 3286;
const sal_Int32 XML_major = 3287;
const sal_Int32 XML_majorAscii = 3288;
const sal_Int32 XML_majorBidi = 3289;
const sal_Int32 XML_majorEastAsia = 3290;
const sal_Int32 XML_majorFont = 3291;
const sal_Int32 XML_majorGridlines = 3292;
const sal_Int32 XML_majorHAnsi = 3293;
const sal_Int32 XML_majorTickMark = 3294;
const sal_Int32 XML_majorTimeUnit = 3295;
const sal_Int32 XML_majorUnit = 3296;
const sal_Int32 XML_man = 3297;
const sal_Int32 XML_manifestLocation = 3298;
const sal_Int32 XML_manual = 3299;
const sal_Int32 XML_manualBreakCount = 3300;
const sal_Int32 XML_manualLayout = 3301;
const sal_Int32 XML_manualMax = 3302;
const sal_Int32 XML_manualMin = 3303;
const sal_Int32 XML_map = 3304;
const sal_Int32 XML_mapId = 3305;
const sal_Int32 XML_mapPins = 3306;
const sal_Int32 XML_mapleLeaf = 3307;
const sal_Int32 XML_mapleMuffins = 3308;
const sal_Int32 XML_mappedName = 3309;
const sal_Int32 XML_mappingCount = 3310;
const sal_Int32 XML_maps = 3311;
const sal_Int32 XML_marB = 3312;
const sal_Int32 XML_marBottom = 3313;
const sal_Int32 XML_marH = 3314;
const sal_Int32 XML_marL = 3315;
const sal_Int32 XML_marLeft = 3316;
const sal_Int32 XML_marR = 3317;
const sal_Int32 XML_marRight = 3318;
const sal_Int32 XML_marT = 3319;
const sal_Int32 XML_marTop = 3320;
const sal_Int32 XML_marW = 3321;
const sal_Int32 XML_margin = 3322;
const sal_Int32 XML_marker = 3323;
const sal_Int32 XML_markers = 3324;
const sal_Int32 XML_markup = 3325;
const sal_Int32 XML_maroon = 3326;
const sal_Int32 XML_marquee = 3327;
const sal_Int32 XML_marqueeToothed = 3328;
const sal_Int32 XML_master = 3329;
const sal_Int32 XML_masterClrMapping = 3330;
const sal_Int32 XML_masterPages = 3331;
const sal_Int32 XML_masterRel = 3332;
const sal_Int32 XML_match = 3333;
const sal_Int32 XML_matchSrc = 3334;
const sal_Int32 XML_matchingName = 3335;
const sal_Int32 XML_mathDivide = 3336;
const sal_Int32 XML_mathEqual = 3337;
const sal_Int32 XML_mathFont = 3338;
const sal_Int32 XML_mathMinus = 3339;
const sal_Int32 XML_mathMultiply = 3340;
const sal_Int32 XML_mathNotEqual = 3341;
const sal_Int32 XML_mathPlus = 3342;
const sal_Int32 XML_mathPr = 3343;
const sal_Int32 XML_matrix = 3344;
const sal_Int32 XML_matte = 3345;
const sal_Int32 XML_max = 3346;
const sal_Int32 XML_maxAxisType = 3347;
const sal_Int32 XML_maxAng = 3348;
const sal_Int32 XML_maxDate = 3349;
const sal_Int32 XML_maxDepth = 3350;
const sal_Int32 XML_maxDist = 3351;
const sal_Int32 XML_maxLength = 3352;
const sal_Int32 XML_maxMin = 3353;
const sal_Int32 XML_maxR = 3354;
const sal_Int32 XML_maxRId = 3355;
const sal_Int32 XML_maxRank = 3356;
const sal_Int32 XML_maxSheetId = 3357;
const sal_Int32 XML_maxSubtotal = 3358;
const sal_Int32 XML_maxVal = 3359;
const sal_Int32 XML_maxValue = 3360;
const sal_Int32 XML_maxX = 3361;
const sal_Int32 XML_maxY = 3362;
const sal_Int32 XML_maximized = 3363;
const sal_Int32 XML_mc = 3364;
const sal_Int32 XML_mcJc = 3365;
const sal_Int32 XML_mcPr = 3366;
const sal_Int32 XML_mcs = 3367;
const sal_Int32 XML_mdx = 3368;
const sal_Int32 XML_mdxMetadata = 3369;
const sal_Int32 XML_mdxSubqueries = 3370;
const sal_Int32 XML_measure = 3371;
const sal_Int32 XML_measureFilter = 3372;
const sal_Int32 XML_measureGroup = 3373;
const sal_Int32 XML_measureGroups = 3374;
const sal_Int32 XML_measures = 3375;
const sal_Int32 XML_med = 3376;
const sal_Int32 XML_medAquamarine = 3377;
const sal_Int32 XML_medBlue = 3378;
const sal_Int32 XML_medOrchid = 3379;
const sal_Int32 XML_medPurple = 3380;
const sal_Int32 XML_medSeaGreen = 3381;
const sal_Int32 XML_medSlateBlue = 3382;
const sal_Int32 XML_medSpringGreen = 3383;
const sal_Int32 XML_medTurquoise = 3384;
const sal_Int32 XML_medVioletRed = 3385;
const sal_Int32 XML_media = 3386;
const sal_Int32 XML_mediaAndTx = 3387;
const sal_Int32 XML_mediacall = 3388;
const sal_Int32 XML_medium = 3389;
const sal_Int32 XML_mediumDashDot = 3390;
const sal_Int32 XML_mediumDashDotDot = 3391;
const sal_Int32 XML_mediumDashed = 3392;
const sal_Int32 XML_mediumGray = 3393;
const sal_Int32 XML_mediumKashida = 3394;
const sal_Int32 XML_member = 3395;
const sal_Int32 XML_memberName = 3396;
const sal_Int32 XML_memberPropertyField = 3397;
const sal_Int32 XML_memberValueDatatype = 3398;
const sal_Int32 XML_members = 3399;
const sal_Int32 XML_menu = 3400;
const sal_Int32 XML_menuBar = 3401;
const sal_Int32 XML_menuHighlight = 3402;
const sal_Int32 XML_menuText = 3403;
const sal_Int32 XML_merge = 3404;
const sal_Int32 XML_mergeCell = 3405;
const sal_Int32 XML_mergeCells = 3406;
const sal_Int32 XML_mergeInterval = 3407;
const sal_Int32 XML_mergeItem = 3408;
const sal_Int32 XML_metadata = 3409;
const sal_Int32 XML_metadataStrings = 3410;
const sal_Int32 XML_metadataType = 3411;
const sal_Int32 XML_metadataTypes = 3412;
const sal_Int32 XML_metal = 3413;
const sal_Int32 XML_meth = 3414;
const sal_Int32 XML_method = 3415;
const sal_Int32 XML_mid = 3416;
const sal_Int32 XML_midCat = 3417;
const sal_Int32 XML_midL = 3418;
const sal_Int32 XML_midR = 3419;
const sal_Int32 XML_middle = 3420;
const sal_Int32 XML_middleDot = 3421;
const sal_Int32 XML_midnightBlue = 3422;
const sal_Int32 XML_millions = 3423;
const sal_Int32 XML_min = 3424;
const sal_Int32 XML_minAxisType = 3425;
const sal_Int32 XML_minAng = 3426;
const sal_Int32 XML_minDate = 3427;
const sal_Int32 XML_minLength = 3428;
const sal_Int32 XML_minMax = 3429;
const sal_Int32 XML_minR = 3430;
const sal_Int32 XML_minRId = 3431;
const sal_Int32 XML_minRefreshableVersion = 3432;
const sal_Int32 XML_minSubtotal = 3433;
const sal_Int32 XML_minSupportedVersion = 3434;
const sal_Int32 XML_minValue = 3435;
const sal_Int32 XML_minVer = 3436;
const sal_Int32 XML_minX = 3437;
const sal_Int32 XML_minY = 3438;
const sal_Int32 XML_minimized = 3439;
const sal_Int32 XML_minimumVersion = 3440;
const sal_Int32 XML_minor = 3441;
const sal_Int32 XML_minorAscii = 3442;
const sal_Int32 XML_minorBidi = 3443;
const sal_Int32 XML_minorEastAsia = 3444;
const sal_Int32 XML_minorFont = 3445;
const sal_Int32 XML_minorGridlines = 3446;
const sal_Int32 XML_minorHAnsi = 3447;
const sal_Int32 XML_minorTickMark = 3448;
const sal_Int32 XML_minorTimeUnit = 3449;
const sal_Int32 XML_minorUnit = 3450;
const sal_Int32 XML_mintCream = 3451;
const sal_Int32 XML_minus = 3452;
const sal_Int32 XML_minusx = 3453;
const sal_Int32 XML_minusy = 3454;
const sal_Int32 XML_minute = 3455;
const sal_Int32 XML_minutes = 3456;
const sal_Int32 XML_mirrorIndents = 3457;
const sal_Int32 XML_mirrorMargins = 3458;
const sal_Int32 XML_missingCaption = 3459;
const sal_Int32 XML_missingItemsLimit = 3460;
const sal_Int32 XML_mistyRose = 3461;
const sal_Int32 XML_miter = 3462;
const sal_Int32 XML_miterlimit = 3463;
const sal_Int32 XML_moccasin = 3464;
const sal_Int32 XML_mod = 3465;
const sal_Int32 XML_modId = 3466;
const sal_Int32 XML_modelId = 3467;
const sal_Int32 XML_modern = 3468;
const sal_Int32 XML_modified = 3469;
const sal_Int32 XML_modifyVerifier = 3470;
const sal_Int32 XML_mongolianVert = 3471;
const sal_Int32 XML_monospace = 3472;
const sal_Int32 XML_month = 3473;
const sal_Int32 XML_monthLong = 3474;
const sal_Int32 XML_monthShort = 3475;
const sal_Int32 XML_months = 3476;
const sal_Int32 XML_moon = 3477;
const sal_Int32 XML_moons = 3478;
const sal_Int32 XML_morning = 3479;
const sal_Int32 XML_morph = 3480;
const sal_Int32 XML_mosaic = 3481;
const sal_Int32 XML_moveFrom = 3482;
const sal_Int32 XML_moveFromRangeEnd = 3483;
const sal_Int32 XML_moveFromRangeStart = 3484;
const sal_Int32 XML_moveTo = 3485;
const sal_Int32 XML_moveToRangeEnd = 3486;
const sal_Int32 XML_moveToRangeStart = 3487;
const sal_Int32 XML_moveWith = 3488;
const sal_Int32 XML_moveWithCells = 3489;
const sal_Int32 XML_movie = 3490;
const sal_Int32 XML_movingAvg = 3491;
const sal_Int32 XML_mp = 3492;
const sal_Int32 XML_mpFld = 3493;
const sal_Int32 XML_mpMap = 3494;
const sal_Int32 XML_mps = 3495;
const sal_Int32 XML_mr = 3496;
const sal_Int32 XML_mruColors = 3497;
const sal_Int32 XML_ms = 3498;
const sal_Int32 XML_mult = 3499;
const sal_Int32 XML_multiLevelType = 3500;
const sal_Int32 XML_multiLine = 3501;
const sal_Int32 XML_multiLvlStrCache = 3502;
const sal_Int32 XML_multiLvlStrRef = 3503;
const sal_Int32 XML_multilevel = 3504;
const sal_Int32 XML_multipleFieldFilters = 3505;
const sal_Int32 XML_multipleItemSelectionAllowed = 3506;
const sal_Int32 XML_musicNotes = 3507;
const sal_Int32 XML_mute = 3508;
const sal_Int32 XML_mwSmallCaps = 3509;
const sal_Int32 XML_n = 3510;
const sal_Int32 XML_na = 3511;
const sal_Int32 XML_name = 3512;
const sal_Int32 XML_nameLen = 3513;
const sal_Int32 XML_namespaceUri = 3514;
const sal_Int32 XML_namespaceuri = 3515;
const sal_Int32 XML_narHorz = 3516;
const sal_Int32 XML_narVert = 3517;
const sal_Int32 XML_narrow = 3518;
const sal_Int32 XML_nary = 3519;
const sal_Int32 XML_naryLim = 3520;
const sal_Int32 XML_naryPr = 3521;
const sal_Int32 XML_native = 3522;
const sal_Int32 XML_navajoWhite = 3523;
const sal_Int32 XML_navy = 3524;
const sal_Int32 XML_nc = 3525;
const sal_Int32 XML_nd = 3526;
const sal_Int32 XML_ndxf = 3527;
const sal_Int32 XML_neCell = 3528;
const sal_Int32 XML_negative = 3529;
const sal_Int32 XML_negativeBarColorSameAsPositive = 3530;
const sal_Int32 XML_negativeFillColor = 3531;
const sal_Int32 XML_negativeInteger = 3532;
const sal_Int32 XML_neq = 3533;
const sal_Int32 XML_never = 3534;
const sal_Int32 XML_new = 3535;
const sal_Int32 XML_newDocument = 3536;
const sal_Int32 XML_newLength = 3537;
const sal_Int32 XML_newName = 3538;
const sal_Int32 XML_newPage = 3539;
const sal_Int32 XML_newSection = 3540;
const sal_Int32 XML_newsflash = 3541;
const sal_Int32 XML_next = 3542;
const sal_Int32 XML_nextAc = 3543;
const sal_Int32 XML_nextClick = 3544;
const sal_Int32 XML_nextColumn = 3545;
const sal_Int32 XML_nextCondLst = 3546;
const sal_Int32 XML_nextId = 3547;
const sal_Int32 XML_nextMonth = 3548;
const sal_Int32 XML_nextPage = 3549;
const sal_Int32 XML_nextQuarter = 3550;
const sal_Int32 XML_nextTo = 3551;
const sal_Int32 XML_nextWeek = 3552;
const sal_Int32 XML_nextYear = 3553;
const sal_Int32 XML_nf = 3554;
const sal_Int32 XML_nil = 3555;
const sal_Int32 XML_nlCheck = 3556;
const sal_Int32 XML_noAdjustHandles = 3557;
const sal_Int32 XML_noArr = 3558;
const sal_Int32 XML_noAutofit = 3559;
const sal_Int32 XML_noBar = 3560;
const sal_Int32 XML_noBorder = 3561;
const sal_Int32 XML_noBreak = 3562;
const sal_Int32 XML_noBreakHyphen = 3563;
const sal_Int32 XML_noChangeArrowheads = 3564;
const sal_Int32 XML_noChangeAspect = 3565;
const sal_Int32 XML_noChangeShapeType = 3566;
const sal_Int32 XML_noColumnBalance = 3567;
const sal_Int32 XML_noControl = 3568;
const sal_Int32 XML_noConversion = 3569;
const sal_Int32 XML_noCrop = 3570;
const sal_Int32 XML_noDrilldown = 3571;
const sal_Int32 XML_noEditPoints = 3572;
const sal_Int32 XML_noEndCap = 3573;
const sal_Int32 XML_noEndnote = 3574;
const sal_Int32 XML_noExtraLineSpacing = 3575;
const sal_Int32 XML_noFill = 3576;
const sal_Int32 XML_noGrp = 3577;
const sal_Int32 XML_noHBand = 3578;
const sal_Int32 XML_noIndicator = 3579;
const sal_Int32 XML_noLabel = 3580;
const sal_Int32 XML_noLeading = 3581;
const sal_Int32 XML_noLineBreaksAfter = 3582;
const sal_Int32 XML_noLineBreaksBefore = 3583;
const sal_Int32 XML_noMove = 3584;
const sal_Int32 XML_noMultiLvlLbl = 3585;
const sal_Int32 XML_noProof = 3586;
const sal_Int32 XML_noPunctuationKerning = 3587;
const sal_Int32 XML_noResize = 3588;
const sal_Int32 XML_noResizeAllowed = 3589;
const sal_Int32 XML_noRot = 3590;
const sal_Int32 XML_noSelect = 3591;
const sal_Int32 XML_noSmoking = 3592;
const sal_Int32 XML_noSpaceRaiseLower = 3593;
const sal_Int32 XML_noStrike = 3594;
const sal_Int32 XML_noTabHangInd = 3595;
const sal_Int32 XML_noTextEdit = 3596;
const sal_Int32 XML_noUngrp = 3597;
const sal_Int32 XML_noVBand = 3598;
const sal_Int32 XML_noWrap = 3599;
const sal_Int32 XML_node = 3600;
const sal_Int32 XML_nodeHorzAlign = 3601;
const sal_Int32 XML_nodePh = 3602;
const sal_Int32 XML_nodeType = 3603;
const sal_Int32 XML_nodeVertAlign = 3604;
const sal_Int32 XML_nonAsst = 3605;
const sal_Int32 XML_nonAutoSortDefault = 3606;
const sal_Int32 XML_nonIsoscelesTrapezoid = 3607;
const sal_Int32 XML_nonNegativeInteger = 3608;
const sal_Int32 XML_nonNorm = 3609;
const sal_Int32 XML_nonPositiveInteger = 3610;
const sal_Int32 XML_none = 3611;
const sal_Int32 XML_nor = 3612;
const sal_Int32 XML_norm = 3613;
const sal_Int32 XML_normAutofit = 3614;
const sal_Int32 XML_normal = 3615;
const sal_Int32 XML_normalViewPr = 3616;
const sal_Int32 XML_normalizeH = 3617;
const sal_Int32 XML_normalizedString = 3618;
const sal_Int32 XML_northwest = 3619;
const sal_Int32 XML_notBeside = 3620;
const sal_Int32 XML_notBetween = 3621;
const sal_Int32 XML_notContains = 3622;
const sal_Int32 XML_notContainsBlanks = 3623;
const sal_Int32 XML_notContainsErrors = 3624;
const sal_Int32 XML_notContainsText = 3625;
const sal_Int32 XML_notEqual = 3626;
const sal_Int32 XML_notFirstPage = 3627;
const sal_Int32 XML_notSpecified = 3628;
const sal_Int32 XML_notTrueType = 3629;
const sal_Int32 XML_notchedRightArrow = 3630;
const sal_Int32 XML_notes = 3631;
const sal_Int32 XML_notesMaster = 3632;
const sal_Int32 XML_notesMasterId = 3633;
const sal_Int32 XML_notesMasterIdLst = 3634;
const sal_Int32 XML_notesMasterView = 3635;
const sal_Int32 XML_notesStyle = 3636;
const sal_Int32 XML_notesSz = 3637;
const sal_Int32 XML_notesTextViewPr = 3638;
const sal_Int32 XML_notesView = 3639;
const sal_Int32 XML_notesViewPr = 3640;
const sal_Int32 XML_nothing = 3641;
const sal_Int32 XML_np = 3642;
const sal_Int32 XML_ns = 3643;
const sal_Int32 XML_nsid = 3644;
const sal_Int32 XML_null = 3645;
const sal_Int32 XML_num = 3646;
const sal_Int32 XML_numCache = 3647;
const sal_Int32 XML_numCol = 3648;
const sal_Int32 XML_numFmt = 3649;
const sal_Int32 XML_numFmtId = 3650;
const sal_Int32 XML_numFmts = 3651;
const sal_Int32 XML_numForm = 3652;
const sal_Int32 XML_numId = 3653;
const sal_Int32 XML_numIdMacAtCleanup = 3654;
const sal_Int32 XML_numLit = 3655;
const sal_Int32 XML_numPicBullet = 3656;
const sal_Int32 XML_numPicBulletId = 3657;
const sal_Int32 XML_numPr = 3658;
const sal_Int32 XML_numRef = 3659;
const sal_Int32 XML_numRestart = 3660;
const sal_Int32 XML_numSld = 3661;
const sal_Int32 XML_numSpacing = 3662;
const sal_Int32 XML_numStart = 3663;
const sal_Int32 XML_numStyleLink = 3664;
const sal_Int32 XML_numTab = 3665;
const sal_Int32 XML_number = 3666;
const sal_Int32 XML_numberInDash = 3667;
const sal_Int32 XML_numberOfShades = 3668;
const sal_Int32 XML_numberStoredAsText = 3669;
const sal_Int32 XML_numbering = 3670;
const sal_Int32 XML_numberingChange = 3671;
const sal_Int32 XML_nvCxnSpPr = 3672;
const sal_Int32 XML_nvGraphicFramePr = 3673;
const sal_Int32 XML_nvGrpSpPr = 3674;
const sal_Int32 XML_nvPicPr = 3675;
const sal_Int32 XML_nvPr = 3676;
const sal_Int32 XML_nvSpPr = 3677;
const sal_Int32 XML_nwCell = 3678;
const sal_Int32 XML_o = 3679;
const sal_Int32 XML_oMath = 3680;
const sal_Int32 XML_oMathPara = 3681;
const sal_Int32 XML_oMathParaPr = 3682;
const sal_Int32 XML_obj = 3683;
const sal_Int32 XML_objAndTwoObj = 3684;
const sal_Int32 XML_objAndTx = 3685;
const sal_Int32 XML_objDist = 3686;
const sal_Int32 XML_objOnly = 3687;
const sal_Int32 XML_objOverTx = 3688;
const sal_Int32 XML_objTx = 3689;
const sal_Int32 XML_object = 3690;
const sal_Int32 XML_objectDefaults = 3691;
const sal_Int32 XML_objectType = 3692;
const sal_Int32 XML_objects = 3693;
const sal_Int32 XML_obliqueBottom = 3694;
const sal_Int32 XML_obliqueBottomLeft = 3695;
const sal_Int32 XML_obliqueBottomRight = 3696;
const sal_Int32 XML_obliqueLeft = 3697;
const sal_Int32 XML_obliqueRight = 3698;
const sal_Int32 XML_obliqueTop = 3699;
const sal_Int32 XML_obliqueTopLeft = 3700;
const sal_Int32 XML_obliqueTopRight = 3701;
const sal_Int32 XML_oblob = 3702;
const sal_Int32 XML_obscured = 3703;
const sal_Int32 XML_oc = 3704;
const sal_Int32 XML_octagon = 3705;
const sal_Int32 XML_ocx = 3706;
const sal_Int32 XML_ocxPr = 3707;
const sal_Int32 XML_odbc = 3708;
const sal_Int32 XML_odcFile = 3709;
const sal_Int32 XML_oddFooter = 3710;
const sal_Int32 XML_oddHBand = 3711;
const sal_Int32 XML_oddHeader = 3712;
const sal_Int32 XML_oddPage = 3713;
const sal_Int32 XML_oddVBand = 3714;
const sal_Int32 XML_odso = 3715;
const sal_Int32 XML_odxf = 3716;
const sal_Int32 XML_ofPieChart = 3717;
const sal_Int32 XML_ofPieType = 3718;
const sal_Int32 XML_off = 3719;
const sal_Int32 XML_offset = 3720;
const sal_Int32 XML_offset2 = 3721;
const sal_Int32 XML_offsetFrom = 3722;
const sal_Int32 XML_olapFunctions = 3723;
const sal_Int32 XML_olapPr = 3724;
const sal_Int32 XML_old = 3725;
const sal_Int32 XML_oldComment = 3726;
const sal_Int32 XML_oldCustomMenu = 3727;
const sal_Int32 XML_oldDescription = 3728;
const sal_Int32 XML_oldFormula = 3729;
const sal_Int32 XML_oldFunction = 3730;
const sal_Int32 XML_oldFunctionGroupId = 3731;
const sal_Int32 XML_oldHelp = 3732;
const sal_Int32 XML_oldHidden = 3733;
const sal_Int32 XML_oldLace = 3734;
const sal_Int32 XML_oldLength = 3735;
const sal_Int32 XML_oldName = 3736;
const sal_Int32 XML_oldPh = 3737;
const sal_Int32 XML_oldQuotePrefix = 3738;
const sal_Int32 XML_oldShortcutKey = 3739;
const sal_Int32 XML_oldStatusBar = 3740;
const sal_Int32 XML_ole = 3741;
const sal_Int32 XML_oleChartEl = 3742;
const sal_Int32 XML_oleItem = 3743;
const sal_Int32 XML_oleItems = 3744;
const sal_Int32 XML_oleLink = 3745;
const sal_Int32 XML_oleObj = 3746;
const sal_Int32 XML_oleObject = 3747;
const sal_Int32 XML_oleObjects = 3748;
const sal_Int32 XML_oleSize = 3749;
const sal_Int32 XML_oleUpdate = 3750;
const sal_Int32 XML_oleicon = 3751;
const sal_Int32 XML_oleid = 3752;
const sal_Int32 XML_olive = 3753;
const sal_Int32 XML_oliveDrab = 3754;
const sal_Int32 XML_on = 3755;
const sal_Int32 XML_onBegin = 3756;
const sal_Int32 XML_onClick = 3757;
const sal_Int32 XML_onDblClick = 3758;
const sal_Int32 XML_onEnd = 3759;
const sal_Int32 XML_onMouseOut = 3760;
const sal_Int32 XML_onMouseOver = 3761;
const sal_Int32 XML_onNext = 3762;
const sal_Int32 XML_onPrev = 3763;
const sal_Int32 XML_onStopAudio = 3764;
const sal_Int32 XML_one = 3765;
const sal_Int32 XML_oneCell = 3766;
const sal_Int32 XML_oneCellAnchor = 3767;
const sal_Int32 XML_oneField = 3768;
const sal_Int32 XML_oned = 3769;
const sal_Int32 XML_onlySync = 3770;
const sal_Int32 XML_onlyUseConnectionFile = 3771;
const sal_Int32 XML_op = 3772;
const sal_Int32 XML_opEmu = 3773;
const sal_Int32 XML_opacity = 3774;
const sal_Int32 XML_opacity2 = 3775;
const sal_Int32 XML_open = 3776;
const sal_Int32 XML_openDmnd = 3777;
const sal_Int32 XML_operator = 3778;
const sal_Int32 XML_optimizeForBrowser = 3779;
const sal_Int32 XML_optimizeMemory = 3780;
const sal_Int32 XML_orange = 3781;
const sal_Int32 XML_orangeRed = 3782;
const sal_Int32 XML_orchid = 3783;
const sal_Int32 XML_order = 3784;
const sal_Int32 XML_ordinal = 3785;
const sal_Int32 XML_ordinalText = 3786;
const sal_Int32 XML_orgChart = 3787;
const sal_Int32 XML_organizeInFolders = 3788;
const sal_Int32 XML_orgchart = 3789;
const sal_Int32 XML_orient = 3790;
const sal_Int32 XML_orientation = 3791;
const sal_Int32 XML_orientationangle = 3792;
const sal_Int32 XML_origin = 3793;
const sal_Int32 XML_original = 3794;
const sal_Int32 XML_orthographicFront = 3795;
const sal_Int32 XML_ostorage = 3796;
const sal_Int32 XML_ostream = 3797;
const sal_Int32 XML_other = 3798;
const sal_Int32 XML_otherStyle = 3799;
const sal_Int32 XML_out = 3800;
const sal_Int32 XML_outByRing = 3801;
const sal_Int32 XML_outEnd = 3802;
const sal_Int32 XML_outer = 3803;
const sal_Int32 XML_outerShdw = 3804;
const sal_Int32 XML_outline = 3805;
const sal_Int32 XML_outline1pPr = 3806;
const sal_Int32 XML_outline2pPr = 3807;
const sal_Int32 XML_outlineData = 3808;
const sal_Int32 XML_outlineLevel = 3809;
const sal_Int32 XML_outlineLevelCol = 3810;
const sal_Int32 XML_outlineLevelRow = 3811;
const sal_Int32 XML_outlineLvl = 3812;
const sal_Int32 XML_outlinePr = 3813;
const sal_Int32 XML_outlineSymbols = 3814;
const sal_Int32 XML_outlineView = 3815;
const sal_Int32 XML_outlineViewPr = 3816;
const sal_Int32 XML_outset = 3817;
const sal_Int32 XML_outside = 3818;
const sal_Int32 XML_outsideMargin = 3819;
const sal_Int32 XML_oval = 3820;
const sal_Int32 XML_ovals = 3821;
const sal_Int32 XML_over = 3822;
const sal_Int32 XML_overThenDown = 3823;
const sal_Int32 XML_overflow = 3824;
const sal_Int32 XML_overflowPunct = 3825;
const sal_Int32 XML_overhead = 3826;
const sal_Int32 XML_overlap = 3827;
const sal_Int32 XML_overlay = 3828;
const sal_Int32 XML_override = 3829;
const sal_Int32 XML_overrideClrMapping = 3830;
const sal_Int32 XML_overwriteClear = 3831;
const sal_Int32 XML_owners = 3832;
const sal_Int32 XML_p = 3833;
const sal_Int32 XML_p14 = 3834;
const sal_Int32 XML_p15 = 3835;
const sal_Int32 XML_pBdr = 3836;
const sal_Int32 XML_pLen = 3837;
const sal_Int32 XML_pPos = 3838;
const sal_Int32 XML_pPr = 3839;
const sal_Int32 XML_pPrChange = 3840;
const sal_Int32 XML_pPrDefault = 3841;
const sal_Int32 XML_pRg = 3842;
const sal_Int32 XML_pStyle = 3843;
const sal_Int32 XML_packages = 3844;
const sal_Int32 XML_page = 3845;
const sal_Int32 XML_pageBottom = 3846;
const sal_Int32 XML_pageBreakBefore = 3847;
const sal_Int32 XML_pageBreakPreview = 3848;
const sal_Int32 XML_pageField = 3849;
const sal_Int32 XML_pageFieldLabels = 3850;
const sal_Int32 XML_pageFieldValues = 3851;
const sal_Int32 XML_pageFields = 3852;
const sal_Int32 XML_pageItem = 3853;
const sal_Int32 XML_pageLayout = 3854;
const sal_Int32 XML_pageMargins = 3855;
const sal_Int32 XML_pageOrder = 3856;
const sal_Int32 XML_pageOverThenDown = 3857;
const sal_Int32 XML_pageSetUpPr = 3858;
const sal_Int32 XML_pageSetup = 3859;
const sal_Int32 XML_pageStyle = 3860;
const sal_Int32 XML_pageWrap = 3861;
const sal_Int32 XML_pages = 3862;
const sal_Int32 XML_paleGoldenrod = 3863;
const sal_Int32 XML_paleGreen = 3864;
const sal_Int32 XML_paleTurquoise = 3865;
const sal_Int32 XML_paleVioletRed = 3866;
const sal_Int32 XML_palmsBlack = 3867;
const sal_Int32 XML_palmsColor = 3868;
const sal_Int32 XML_pan = 3869;
const sal_Int32 XML_pane = 3870;
const sal_Int32 XML_panose = 3871;
const sal_Int32 XML_panose1 = 3872;
const sal_Int32 XML_papayaWhip = 3873;
const sal_Int32 XML_paperClips = 3874;
const sal_Int32 XML_paperHeight = 3875;
const sal_Int32 XML_paperSize = 3876;
const sal_Int32 XML_paperSrc = 3877;
const sal_Int32 XML_paperUnits = 3878;
const sal_Int32 XML_paperWidth = 3879;
const sal_Int32 XML_papyrus = 3880;
const sal_Int32 XML_par = 3881;
const sal_Int32 XML_parOf = 3882;
const sal_Int32 XML_parTrans = 3883;
const sal_Int32 XML_parTransId = 3884;
const sal_Int32 XML_parTxLTRAlign = 3885;
const sal_Int32 XML_parTxRTLAlign = 3886;
const sal_Int32 XML_paraId = 3887;
const sal_Int32 XML_paraIdParent = 3888;
const sal_Int32 XML_paragraph = 3889;
const sal_Int32 XML_parallel = 3890;
const sal_Int32 XML_parallelogram = 3891;
const sal_Int32 XML_param = 3892;
const sal_Int32 XML_parameter = 3893;
const sal_Int32 XML_parameterType = 3894;
const sal_Int32 XML_parameters = 3895;
const sal_Int32 XML_parent = 3896;
const sal_Int32 XML_parentSet = 3897;
const sal_Int32 XML_parsePre = 3898;
const sal_Int32 XML_partyFavor = 3899;
const sal_Int32 XML_partyGlass = 3900;
const sal_Int32 XML_password = 3901;
const sal_Int32 XML_pasteAll = 3902;
const sal_Int32 XML_pasteBorders = 3903;
const sal_Int32 XML_pasteColWidths = 3904;
const sal_Int32 XML_pasteComments = 3905;
const sal_Int32 XML_pasteDataValidation = 3906;
const sal_Int32 XML_pasteFormats = 3907;
const sal_Int32 XML_pasteFormulas = 3908;
const sal_Int32 XML_pasteNumberFormats = 3909;
const sal_Int32 XML_pasteValues = 3910;
const sal_Int32 XML_path = 3911;
const sal_Int32 XML_pathEditMode = 3912;
const sal_Int32 XML_pathLst = 3913;
const sal_Int32 XML_pattFill = 3914;
const sal_Int32 XML_pattern = 3915;
const sal_Int32 XML_patternFill = 3916;
const sal_Int32 XML_patternType = 3917;
const sal_Int32 XML_pct = 3918;
const sal_Int32 XML_pct10 = 3919;
const sal_Int32 XML_pct12 = 3920;
const sal_Int32 XML_pct15 = 3921;
const sal_Int32 XML_pct20 = 3922;
const sal_Int32 XML_pct25 = 3923;
const sal_Int32 XML_pct30 = 3924;
const sal_Int32 XML_pct35 = 3925;
const sal_Int32 XML_pct37 = 3926;
const sal_Int32 XML_pct40 = 3927;
const sal_Int32 XML_pct45 = 3928;
const sal_Int32 XML_pct5 = 3929;
const sal_Int32 XML_pct50 = 3930;
const sal_Int32 XML_pct55 = 3931;
const sal_Int32 XML_pct60 = 3932;
const sal_Int32 XML_pct62 = 3933;
const sal_Int32 XML_pct65 = 3934;
const sal_Int32 XML_pct70 = 3935;
const sal_Int32 XML_pct75 = 3936;
const sal_Int32 XML_pct80 = 3937;
const sal_Int32 XML_pct85 = 3938;
const sal_Int32 XML_pct87 = 3939;
const sal_Int32 XML_pct90 = 3940;
const sal_Int32 XML_pct95 = 3941;
const sal_Int32 XML_pctHeight = 3942;
const sal_Int32 XML_pctPosHOffset = 3943;
const sal_Int32 XML_pctPosVOffset = 3944;
const sal_Int32 XML_pctWidth = 3945;
const sal_Int32 XML_peachPuff = 3946;
const sal_Int32 XML_penClr = 3947;
const sal_Int32 XML_pencilSize = 3948;
const sal_Int32 XML_pencils = 3949;
const sal_Int32 XML_pentagon = 3950;
const sal_Int32 XML_people = 3951;
const sal_Int32 XML_peopleHats = 3952;
const sal_Int32 XML_peopleWaving = 3953;
const sal_Int32 XML_percent = 3954;
const sal_Int32 XML_percentDiff = 3955;
const sal_Int32 XML_percentOfCol = 3956;
const sal_Int32 XML_percentOfRow = 3957;
const sal_Int32 XML_percentOfTotal = 3958;
const sal_Int32 XML_percentStacked = 3959;
const sal_Int32 XML_percentage = 3960;
const sal_Int32 XML_percentile = 3961;
const sal_Int32 XML_period = 3962;
const sal_Int32 XML_permEnd = 3963;
const sal_Int32 XML_permStart = 3964;
const sal_Int32 XML_persistPropertyBag = 3965;
const sal_Int32 XML_persistStorage = 3966;
const sal_Int32 XML_persistStream = 3967;
const sal_Int32 XML_persistStreamInit = 3968;
const sal_Int32 XML_persistence = 3969;
const sal_Int32 XML_personal = 3970;
const sal_Int32 XML_personalCompose = 3971;
const sal_Int32 XML_personalReply = 3972;
const sal_Int32 XML_personalView = 3973;
const sal_Int32 XML_perspective = 3974;
const sal_Int32 XML_perspectiveAbove = 3975;
const sal_Int32 XML_perspectiveAboveLeftFacing = 3976;
const sal_Int32 XML_perspectiveAboveRightFacing = 3977;
const sal_Int32 XML_perspectiveBelow = 3978;
const sal_Int32 XML_perspectiveContrastingLeftFacing = 3979;
const sal_Int32 XML_perspectiveContrastingRightFacing = 3980;
const sal_Int32 XML_perspectiveFront = 3981;
const sal_Int32 XML_perspectiveHeroicExtremeLeftFacing = 3982;
const sal_Int32 XML_perspectiveHeroicExtremeRightFacing = 3983;
const sal_Int32 XML_perspectiveHeroicLeftFacing = 3984;
const sal_Int32 XML_perspectiveHeroicRightFacing = 3985;
const sal_Int32 XML_perspectiveLeft = 3986;
const sal_Int32 XML_perspectiveRelaxed = 3987;
const sal_Int32 XML_perspectiveRelaxedModerately = 3988;
const sal_Int32 XML_perspectiveRight = 3989;
const sal_Int32 XML_peru = 3990;
const sal_Int32 XML_pg = 3991;
const sal_Int32 XML_pgBorders = 3992;
const sal_Int32 XML_pgMar = 3993;
const sal_Int32 XML_pgNum = 3994;
const sal_Int32 XML_pgNumB = 3995;
const sal_Int32 XML_pgNumMargins = 3996;
const sal_Int32 XML_pgNumT = 3997;
const sal_Int32 XML_pgNumType = 3998;
const sal_Int32 XML_pgSz = 3999;
const sal_Int32 XML_ph = 4000;
const sal_Int32 XML_phClr = 4001;
const sal_Int32 XML_phant = 4002;
const sal_Int32 XML_phantPr = 4003;
const sal_Int32 XML_phldr = 4004;
const sal_Int32 XML_phldrT = 4005;
const sal_Int32 XML_phonetic = 4006;
const sal_Int32 XML_phoneticPr = 4007;
const sal_Int32 XML_photoAlbum = 4008;
const sal_Int32 XML_pic = 4009;
const sal_Int32 XML_picLocks = 4010;
const sal_Int32 XML_picTx = 4011;
const sal_Int32 XML_pict = 4012;
const sal_Int32 XML_picture = 4013;
const sal_Int32 XML_pictureFormat = 4014;
const sal_Int32 XML_pictureOptions = 4015;
const sal_Int32 XML_pictureStackUnit = 4016;
const sal_Int32 XML_pid = 4017;
const sal_Int32 XML_pie = 4018;
const sal_Int32 XML_pie3DChart = 4019;
const sal_Int32 XML_pieChart = 4020;
const sal_Int32 XML_pieWedge = 4021;
const sal_Int32 XML_pinYin = 4022;
const sal_Int32 XML_pink = 4023;
const sal_Int32 XML_pitch = 4024;
const sal_Int32 XML_pitchFamily = 4025;
const sal_Int32 XML_pivot = 4026;
const sal_Int32 XML_pivotArea = 4027;
const sal_Int32 XML_pivotAreas = 4028;
const sal_Int32 XML_pivotButton = 4029;
const sal_Int32 XML_pivotCache = 4030;
const sal_Int32 XML_pivotCacheDefinition = 4031;
const sal_Int32 XML_pivotCacheRecords = 4032;
const sal_Int32 XML_pivotCaches = 4033;
const sal_Int32 XML_pivotField = 4034;
const sal_Int32 XML_pivotFields = 4035;
const sal_Int32 XML_pivotFmt = 4036;
const sal_Int32 XML_pivotFmts = 4037;
const sal_Int32 XML_pivotHierarchies = 4038;
const sal_Int32 XML_pivotHierarchy = 4039;
const sal_Int32 XML_pivotSelection = 4040;
const sal_Int32 XML_pivotSource = 4041;
const sal_Int32 XML_pivotTable = 4042;
const sal_Int32 XML_pivotTableDefinition = 4043;
const sal_Int32 XML_pivotTableStyle = 4044;
const sal_Int32 XML_pivotTableStyleInfo = 4045;
const sal_Int32 XML_pivotTables = 4046;
const sal_Int32 XML_pixelsPerInch = 4047;
const sal_Int32 XML_placeholder = 4048;
const sal_Int32 XML_placeholders = 4049;
const sal_Int32 XML_plaid = 4050;
const sal_Int32 XML_plane = 4051;
const sal_Int32 XML_plaque = 4052;
const sal_Int32 XML_plaqueTabs = 4053;
const sal_Int32 XML_plastic = 4054;
const sal_Int32 XML_plcHide = 4055;
const sal_Int32 XML_plotArea = 4056;
const sal_Int32 XML_plotVisOnly = 4057;
const sal_Int32 XML_plum = 4058;
const sal_Int32 XML_plus = 4059;
const sal_Int32 XML_poinsettias = 4060;
const sal_Int32 XML_points = 4061;
const sal_Int32 XML_polar = 4062;
const sal_Int32 XML_poly = 4063;
const sal_Int32 XML_polyline = 4064;
const sal_Int32 XML_portrait = 4065;
const sal_Int32 XML_pos = 4066;
const sal_Int32 XML_posEven = 4067;
const sal_Int32 XML_posOdd = 4068;
const sal_Int32 XML_posOffset = 4069;
const sal_Int32 XML_position = 4070;
const sal_Int32 XML_positionH = 4071;
const sal_Int32 XML_positionV = 4072;
const sal_Int32 XML_positiveInteger = 4073;
const sal_Int32 XML_post = 4074;
const sal_Int32 XML_postSp = 4075;
const sal_Int32 XML_postageStamp = 4076;
const sal_Int32 XML_powder = 4077;
const sal_Int32 XML_powderBlue = 4078;
const sal_Int32 XML_power = 4079;
const sal_Int32 XML_prLst = 4080;
const sal_Int32 XML_prSet = 4081;
const sal_Int32 XML_preSp = 4082;
const sal_Int32 XML_preced = 4083;
const sal_Int32 XML_precedSib = 4084;
const sal_Int32 XML_preferPic = 4085;
const sal_Int32 XML_preferRelativeResize = 4086;
const sal_Int32 XML_preferSingleView = 4087;
const sal_Int32 XML_preferrelative = 4088;
const sal_Int32 XML_prefixMappings = 4089;
const sal_Int32 XML_pres = 4090;
const sal_Int32 XML_presAssocID = 4091;
const sal_Int32 XML_presId = 4092;
const sal_Int32 XML_presLayoutVars = 4093;
const sal_Int32 XML_presName = 4094;
const sal_Int32 XML_presOf = 4095;
const sal_Int32 XML_presParOf = 4096;
const sal_Int32 XML_presStyleCnt = 4097;
const sal_Int32 XML_presStyleIdx = 4098;
const sal_Int32 XML_presStyleLbl = 4099;
const sal_Int32 XML_present = 4100;
const sal_Int32 XML_presentation = 4101;
const sal_Int32 XML_presentationAccent = 4102;
const sal_Int32 XML_presentationPr = 4103;
const sal_Int32 XML_presentationText = 4104;
const sal_Int32 XML_preserve = 4105;
const sal_Int32 XML_preserveFormatting = 4106;
const sal_Int32 XML_preserveHistory = 4107;
const sal_Int32 XML_preserveSortFilterLayout = 4108;
const sal_Int32 XML_presetClass = 4109;
const sal_Int32 XML_presetID = 4110;
const sal_Int32 XML_presetSubtype = 4111;
const sal_Int32 XML_pressure = 4112;
const sal_Int32 XML_prev = 4113;
const sal_Int32 XML_prevAc = 4114;
const sal_Int32 XML_prevCondLst = 4115;
const sal_Int32 XML_previousCol = 4116;
const sal_Int32 XML_previousRow = 4117;
const sal_Int32 XML_pri = 4118;
const sal_Int32 XML_primFontSz = 4119;
const sal_Int32 XML_print = 4120;
const sal_Int32 XML_printArea = 4121;
const sal_Int32 XML_printBodyTextBeforeHeader = 4122;
const sal_Int32 XML_printColBlack = 4123;
const sal_Int32 XML_printDrill = 4124;
const sal_Int32 XML_printFormsData = 4125;
const sal_Int32 XML_printFractionalCharacterWidth = 4126;
const sal_Int32 XML_printOptions = 4127;
const sal_Int32 XML_printPostScriptOverText = 4128;
const sal_Int32 XML_printSettings = 4129;
const sal_Int32 XML_printTwoOnOne = 4130;
const sal_Int32 XML_printer = 4131;
const sal_Int32 XML_printerSettings = 4132;
const sal_Int32 XML_priority = 4133;
const sal_Int32 XML_prism = 4134;
const sal_Int32 XML_prnPr = 4135;
const sal_Int32 XML_prnWhat = 4136;
const sal_Int32 XML_product = 4137;
const sal_Int32 XML_productSubtotal = 4138;
const sal_Int32 XML_progId = 4139;
const sal_Int32 XML_progress = 4140;
const sal_Int32 XML_prompt = 4141;
const sal_Int32 XML_promptTitle = 4142;
const sal_Int32 XML_promptedSolutions = 4143;
const sal_Int32 XML_proofErr = 4144;
const sal_Int32 XML_proofState = 4145;
const sal_Int32 XML_property = 4146;
const sal_Int32 XML_propertyName = 4147;
const sal_Int32 XML_props3d = 4148;
const sal_Int32 XML_prot = 4149;
const sal_Int32 XML_protected = 4150;
const sal_Int32 XML_protectedRange = 4151;
const sal_Int32 XML_protectedRanges = 4152;
const sal_Int32 XML_protection = 4153;
const sal_Int32 XML_provid = 4154;
const sal_Int32 XML_proxy = 4155;
const sal_Int32 XML_prst = 4156;
const sal_Int32 XML_prstClr = 4157;
const sal_Int32 XML_prstDash = 4158;
const sal_Int32 XML_prstGeom = 4159;
const sal_Int32 XML_prstMaterial = 4160;
const sal_Int32 XML_prstShdw = 4161;
const sal_Int32 XML_prstTrans = 4162;
const sal_Int32 XML_prstTxWarp = 4163;
const sal_Int32 XML_pt = 4164;
const sal_Int32 XML_ptCount = 4165;
const sal_Int32 XML_ptInCategory = 4166;
const sal_Int32 XML_ptInSeries = 4167;
const sal_Int32 XML_ptLst = 4168;
const sal_Int32 XML_ptType = 4169;
const sal_Int32 XML_ptab = 4170;
const sal_Int32 XML_ptsTypes = 4171;
const sal_Int32 XML_pubBrowser = 4172;
const sal_Int32 XML_publishItems = 4173;
const sal_Int32 XML_publishToServer = 4174;
const sal_Int32 XML_published = 4175;
const sal_Int32 XML_pull = 4176;
const sal_Int32 XML_pumpkin1 = 4177;
const sal_Int32 XML_purple = 4178;
const sal_Int32 XML_push = 4179;
const sal_Int32 XML_pushPinNote1 = 4180;
const sal_Int32 XML_pushPinNote2 = 4181;
const sal_Int32 XML_pyra = 4182;
const sal_Int32 XML_pyraAcctBkgdNode = 4183;
const sal_Int32 XML_pyraAcctPos = 4184;
const sal_Int32 XML_pyraAcctRatio = 4185;
const sal_Int32 XML_pyraAcctTxMar = 4186;
const sal_Int32 XML_pyraAcctTxNode = 4187;
const sal_Int32 XML_pyraLvlNode = 4188;
const sal_Int32 XML_pyramid = 4189;
const sal_Int32 XML_pyramidToMax = 4190;
const sal_Int32 XML_pyramids = 4191;
const sal_Int32 XML_pyramidsAbove = 4192;
const sal_Int32 XML_qFormat = 4193;
const sal_Int32 XML_qs = 4194;
const sal_Int32 XML_qsCatId = 4195;
const sal_Int32 XML_qsTypeId = 4196;
const sal_Int32 XML_quadArrow = 4197;
const sal_Int32 XML_quadArrowCallout = 4198;
const sal_Int32 XML_quadBezTo = 4199;
const sal_Int32 XML_quadrants = 4200;
const sal_Int32 XML_qualifier = 4201;
const sal_Int32 XML_quarter = 4202;
const sal_Int32 XML_quarters = 4203;
const sal_Int32 XML_query = 4204;
const sal_Int32 XML_queryCache = 4205;
const sal_Int32 XML_queryFailed = 4206;
const sal_Int32 XML_queryTable = 4207;
const sal_Int32 XML_queryTableDeletedFields = 4208;
const sal_Int32 XML_queryTableField = 4209;
const sal_Int32 XML_queryTableFieldId = 4210;
const sal_Int32 XML_queryTableFields = 4211;
const sal_Int32 XML_queryTableRefresh = 4212;
const sal_Int32 XML_quickTimeFile = 4213;
const sal_Int32 XML_quotePrefix = 4214;
const sal_Int32 XML_r = 4215;
const sal_Int32 XML_r1 = 4216;
const sal_Int32 XML_r2 = 4217;
const sal_Int32 XML_r4 = 4218;
const sal_Int32 XML_r8 = 4219;
const sal_Int32 XML_rAng = 4220;
const sal_Int32 XML_rAngAx = 4221;
const sal_Int32 XML_rB = 4222;
const sal_Int32 XML_rCtr = 4223;
const sal_Int32 XML_rCtrCh = 4224;
const sal_Int32 XML_rCtrDes = 4225;
const sal_Int32 XML_rFont = 4226;
const sal_Int32 XML_rFonts = 4227;
const sal_Int32 XML_rId = 4228;
const sal_Int32 XML_rIns = 4229;
const sal_Int32 XML_rMarg = 4230;
const sal_Int32 XML_rMargin = 4231;
const sal_Int32 XML_rOff = 4232;
const sal_Int32 XML_rPh = 4233;
const sal_Int32 XML_rPr = 4234;
const sal_Int32 XML_rPrChange = 4235;
const sal_Int32 XML_rPrDefault = 4236;
const sal_Int32 XML_rSp = 4237;
const sal_Int32 XML_rSpRule = 4238;
const sal_Int32 XML_rStyle = 4239;
const sal_Int32 XML_rT = 4240;
const sal_Int32 XML_ra = 4241;
const sal_Int32 XML_rad = 4242;
const sal_Int32 XML_radPr = 4243;
const sal_Int32 XML_radarChart = 4244;
const sal_Int32 XML_radarStyle = 4245;
const sal_Int32 XML_radial = 4246;
const sal_Int32 XML_radiusrange = 4247;
const sal_Int32 XML_raf = 4248;
const sal_Int32 XML_random = 4249;
const sal_Int32 XML_randomBar = 4250;
const sal_Int32 XML_range = 4251;
const sal_Int32 XML_rangePr = 4252;
const sal_Int32 XML_rangeSet = 4253;
const sal_Int32 XML_rangeSets = 4254;
const sal_Int32 XML_rank = 4255;
const sal_Int32 XML_rankBy = 4256;
const sal_Int32 XML_rc = 4257;
const sal_Int32 XML_rcc = 4258;
const sal_Int32 XML_rcft = 4259;
const sal_Int32 XML_rcmt = 4260;
const sal_Int32 XML_rctx = 4261;
const sal_Int32 XML_rcv = 4262;
const sal_Int32 XML_rd = 4263;
const sal_Int32 XML_rdn = 4264;
const sal_Int32 XML_readModeInkLockDown = 4265;
const sal_Int32 XML_readOnly = 4266;
const sal_Int32 XML_readOnlyRecommended = 4267;
const sal_Int32 XML_readingOrder = 4268;
const sal_Int32 XML_realTimeData = 4269;
const sal_Int32 XML_recipientData = 4270;
const sal_Int32 XML_recipients = 4271;
const sal_Int32 XML_recolor = 4272;
const sal_Int32 XML_recolortarget = 4273;
const sal_Int32 XML_recommended = 4274;
const sal_Int32 XML_reconnectionMethod = 4275;
const sal_Int32 XML_recordCount = 4276;
const sal_Int32 XML_rect = 4277;
const sal_Int32 XML_red = 4278;
const sal_Int32 XML_redMod = 4279;
const sal_Int32 XML_redOff = 4280;
const sal_Int32 XML_ref = 4281;
const sal_Int32 XML_ref3D = 4282;
const sal_Int32 XML_refError = 4283;
const sal_Int32 XML_refFor = 4284;
const sal_Int32 XML_refForName = 4285;
const sal_Int32 XML_refMode = 4286;
const sal_Int32 XML_refPtType = 4287;
const sal_Int32 XML_refType = 4288;
const sal_Int32 XML_reference = 4289;
const sal_Int32 XML_references = 4290;
const sal_Int32 XML_refersTo = 4291;
const sal_Int32 XML_reflection = 4292;
const sal_Int32 XML_refreshAllConnections = 4293;
const sal_Int32 XML_refreshError = 4294;
const sal_Int32 XML_refreshOnChange = 4295;
const sal_Int32 XML_refreshOnLoad = 4296;
const sal_Int32 XML_refreshedBy = 4297;
const sal_Int32 XML_refreshedDate = 4298;
const sal_Int32 XML_refreshedVersion = 4299;
const sal_Int32 XML_regroupid = 4300;
const sal_Int32 XML_regrouptable = 4301;
const sal_Int32 XML_regular = 4302;
const sal_Int32 XML_rel = 4303;
const sal_Int32 XML_relId = 4304;
const sal_Int32 XML_relIds = 4305;
const sal_Int32 XML_relOff = 4306;
const sal_Int32 XML_relSizeAnchor = 4307;
const sal_Int32 XML_relation = 4308;
const sal_Int32 XML_relationtable = 4309;
const sal_Int32 XML_relative = 4310;
const sal_Int32 XML_relativeFrom = 4311;
const sal_Int32 XML_relativeHeight = 4312;
const sal_Int32 XML_relativeIndent = 4313;
const sal_Int32 XML_relativeTo = 4314;
const sal_Int32 XML_relaxedInset = 4315;
const sal_Int32 XML_relid = 4316;
const sal_Int32 XML_relyOnVML = 4317;
const sal_Int32 XML_relyOnVml = 4318;
const sal_Int32 XML_remove = 4319;
const sal_Int32 XML_removeDataOnSave = 4320;
const sal_Int32 XML_removeDateAndTime = 4321;
const sal_Int32 XML_removePersonalInfoOnSave = 4322;
const sal_Int32 XML_removePersonalInformation = 4323;
const sal_Int32 XML_render = 4324;
const sal_Int32 XML_repairLoad = 4325;
const sal_Int32 XML_repeat = 4326;
const sal_Int32 XML_repeatCount = 4327;
const sal_Int32 XML_repeatDur = 4328;
const sal_Int32 XML_repl = 4329;
const sal_Int32 XML_resId = 4330;
const sal_Int32 XML_reservationPassword = 4331;
const sal_Int32 XML_resizeGraphics = 4332;
const sal_Int32 XML_resizeHandles = 4333;
const sal_Int32 XML_rest = 4334;
const sal_Int32 XML_restart = 4335;
const sal_Int32 XML_restored = 4336;
const sal_Int32 XML_restoredLeft = 4337;
const sal_Int32 XML_restoredTop = 4338;
const sal_Int32 XML_result = 4339;
const sal_Int32 XML_rev = 4340;
const sal_Int32 XML_revDir = 4341;
const sal_Int32 XML_revPos = 4342;
const sal_Int32 XML_reveal = 4343;
const sal_Int32 XML_reverse = 4344;
const sal_Int32 XML_reverseDiagStripe = 4345;
const sal_Int32 XML_reviewed = 4346;
const sal_Int32 XML_reviewedList = 4347;
const sal_Int32 XML_revision = 4348;
const sal_Int32 XML_revisionId = 4349;
const sal_Int32 XML_revisionView = 4350;
const sal_Int32 XML_revisions = 4351;
const sal_Int32 XML_revisionsPassword = 4352;
const sal_Int32 XML_rfmt = 4353;
const sal_Int32 XML_rgb = 4354;
const sal_Int32 XML_rgbColor = 4355;
const sal_Int32 XML_ribbon = 4356;
const sal_Int32 XML_ribbon2 = 4357;
const sal_Int32 XML_riblet = 4358;
const sal_Int32 XML_rich = 4359;
const sal_Int32 XML_richText = 4360;
const sal_Int32 XML_rig = 4361;
const sal_Int32 XML_right = 4362;
const sal_Int32 XML_rightArrow = 4363;
const sal_Int32 XML_rightArrowCallout = 4364;
const sal_Int32 XML_rightBrace = 4365;
const sal_Int32 XML_rightBracket = 4366;
const sal_Int32 XML_rightChars = 4367;
const sal_Int32 XML_rightFromText = 4368;
const sal_Int32 XML_rightMargin = 4369;
const sal_Int32 XML_rightToLeft = 4370;
const sal_Int32 XML_rightVertical = 4371;
const sal_Int32 XML_rings = 4372;
const sal_Int32 XML_ripple = 4373;
const sal_Int32 XML_ris = 4374;
const sal_Int32 XML_rm = 4375;
const sal_Int32 XML_rnd = 4376;
const sal_Int32 XML_roman = 4377;
const sal_Int32 XML_romanLcParenBoth = 4378;
const sal_Int32 XML_romanLcParenR = 4379;
const sal_Int32 XML_romanLcPeriod = 4380;
const sal_Int32 XML_romanUcParenBoth = 4381;
const sal_Int32 XML_romanUcParenR = 4382;
const sal_Int32 XML_romanUcPeriod = 4383;
const sal_Int32 XML_root = 4384;
const sal_Int32 XML_rosyBrown = 4385;
const sal_Int32 XML_rot = 4386;
const sal_Int32 XML_rotPath = 4387;
const sal_Int32 XML_rotWithShape = 4388;
const sal_Int32 XML_rotX = 4389;
const sal_Int32 XML_rotY = 4390;
const sal_Int32 XML_rotate = 4391;
const sal_Int32 XML_rotation = 4392;
const sal_Int32 XML_rotationangle = 4393;
const sal_Int32 XML_rotationcenter = 4394;
const sal_Int32 XML_round = 4395;
const sal_Int32 XML_round1Rect = 4396;
const sal_Int32 XML_round2DiagRect = 4397;
const sal_Int32 XML_round2SameRect = 4398;
const sal_Int32 XML_roundRect = 4399;
const sal_Int32 XML_roundedCorners = 4400;
const sal_Int32 XML_roundrect = 4401;
const sal_Int32 XML_row = 4402;
const sal_Int32 XML_rowBreaks = 4403;
const sal_Int32 XML_rowColShift = 4404;
const sal_Int32 XML_rowDrillCount = 4405;
const sal_Int32 XML_rowFields = 4406;
const sal_Int32 XML_rowGrandTotals = 4407;
const sal_Int32 XML_rowHeaderCaption = 4408;
const sal_Int32 XML_rowHidden = 4409;
const sal_Int32 XML_rowHierarchiesUsage = 4410;
const sal_Int32 XML_rowHierarchyUsage = 4411;
const sal_Int32 XML_rowItems = 4412;
const sal_Int32 XML_rowNumbers = 4413;
const sal_Int32 XML_rowOff = 4414;
const sal_Int32 XML_rowPageCount = 4415;
const sal_Int32 XML_rowSpan = 4416;
const sal_Int32 XML_rows = 4417;
const sal_Int32 XML_royalBlue = 4418;
const sal_Int32 XML_rqt = 4419;
const sal_Int32 XML_rrc = 4420;
const sal_Int32 XML_rsaAES = 4421;
const sal_Int32 XML_rsaFull = 4422;
const sal_Int32 XML_rsid = 4423;
const sal_Int32 XML_rsidDel = 4424;
const sal_Int32 XML_rsidP = 4425;
const sal_Int32 XML_rsidR = 4426;
const sal_Int32 XML_rsidRDefault = 4427;
const sal_Int32 XML_rsidRPr = 4428;
const sal_Int32 XML_rsidRoot = 4429;
const sal_Int32 XML_rsidSect = 4430;
const sal_Int32 XML_rsidTr = 4431;
const sal_Int32 XML_rsids = 4432;
const sal_Int32 XML_rsnm = 4433;
const sal_Int32 XML_rt = 4434;
const sal_Int32 XML_rtShortDist = 4435;
const sal_Int32 XML_rtTriangle = 4436;
const sal_Int32 XML_rtf = 4437;
const sal_Int32 XML_rtl = 4438;
const sal_Int32 XML_rtlCol = 4439;
const sal_Int32 XML_rtlGutter = 4440;
const sal_Int32 XML_rtn = 4441;
const sal_Int32 XML_ru = 4442;
const sal_Int32 XML_ruby = 4443;
const sal_Int32 XML_rubyAlign = 4444;
const sal_Int32 XML_rubyBase = 4445;
const sal_Int32 XML_rubyPr = 4446;
const sal_Int32 XML_rule = 4447;
const sal_Int32 XML_ruleLst = 4448;
const sal_Int32 XML_rules = 4449;
const sal_Int32 XML_runTotal = 4450;
const sal_Int32 XML_rupBuild = 4451;
const sal_Int32 XML_russianLower = 4452;
const sal_Int32 XML_russianUpper = 4453;
const sal_Int32 XML_s = 4454;
const sal_Int32 XML_sId = 4455;
const sal_Int32 XML_sPre = 4456;
const sal_Int32 XML_sPrePr = 4457;
const sal_Int32 XML_sSub = 4458;
const sal_Int32 XML_sSubPr = 4459;
const sal_Int32 XML_sSubSup = 4460;
const sal_Int32 XML_sSubSupPr = 4461;
const sal_Int32 XML_sSup = 4462;
const sal_Int32 XML_sSupPr = 4463;
const sal_Int32 XML_saddleBrown = 4464;
const sal_Int32 XML_safari = 4465;
const sal_Int32 XML_saka = 4466;
const sal_Int32 XML_salmon = 4467;
const sal_Int32 XML_salt = 4468;
const sal_Int32 XML_saltData = 4469;
const sal_Int32 XML_saltValue = 4470;
const sal_Int32 XML_sameClick = 4471;
const sal_Int32 XML_sameDir = 4472;
const sal_Int32 XML_sampData = 4473;
const sal_Int32 XML_sandyBrown = 4474;
const sal_Int32 XML_sans_serif = 4475;
const sal_Int32 XML_sat = 4476;
const sal_Int32 XML_satMod = 4477;
const sal_Int32 XML_satOff = 4478;
const sal_Int32 XML_saturation = 4479;
const sal_Int32 XML_saveData = 4480;
const sal_Int32 XML_saveExternalLinkValues = 4481;
const sal_Int32 XML_saveFormsData = 4482;
const sal_Int32 XML_saveInvalidXml = 4483;
const sal_Int32 XML_savePassword = 4484;
const sal_Int32 XML_savePreviewPicture = 4485;
const sal_Int32 XML_saveSmartTagsAsXml = 4486;
const sal_Int32 XML_saveSubsetFonts = 4487;
const sal_Int32 XML_saveThroughXslt = 4488;
const sal_Int32 XML_saveXmlDataOnly = 4489;
const sal_Int32 XML_sawtooth = 4490;
const sal_Int32 XML_sawtoothGray = 4491;
const sal_Int32 XML_sb = 4492;
const sal_Int32 XML_scale = 4493;
const sal_Int32 XML_scaleToFitPaper = 4494;
const sal_Int32 XML_scaleWithDoc = 4495;
const sal_Int32 XML_scaled = 4496;
const sal_Int32 XML_scaling = 4497;
const sal_Int32 XML_scaredCat = 4498;
const sal_Int32 XML_scatterChart = 4499;
const sal_Int32 XML_scatterStyle = 4500;
const sal_Int32 XML_scenario = 4501;
const sal_Int32 XML_scenarios = 4502;
const sal_Int32 XML_scene3d = 4503;
const sal_Int32 XML_schema = 4504;
const sal_Int32 XML_schemaLibrary = 4505;
const sal_Int32 XML_schemaLocation = 4506;
const sal_Int32 XML_schemaRef = 4507;
const sal_Int32 XML_schemaRefs = 4508;
const sal_Int32 XML_scheme = 4509;
const sal_Int32 XML_schemeClr = 4510;
const sal_Int32 XML_scope = 4511;
const sal_Int32 XML_scr = 4512;
const sal_Int32 XML_screen = 4513;
const sal_Int32 XML_screen16x10 = 4514;
const sal_Int32 XML_screen16x9 = 4515;
const sal_Int32 XML_screen4x3 = 4516;
const sal_Int32 XML_scrgbClr = 4517;
const sal_Int32 XML_script = 4518;
const sal_Int32 XML_scrollBar = 4519;
const sal_Int32 XML_scrollbar = 4520;
const sal_Int32 XML_sd = 4521;
const sal_Int32 XML_sdt = 4522;
const sal_Int32 XML_sdtContent = 4523;
const sal_Int32 XML_sdtContentLocked = 4524;
const sal_Int32 XML_sdtEndContent = 4525;
const sal_Int32 XML_sdtEndPr = 4526;
const sal_Int32 XML_sdtLocked = 4527;
const sal_Int32 XML_sdtPr = 4528;
const sal_Int32 XML_seCell = 4529;
const sal_Int32 XML_seaGreen = 4530;
const sal_Int32 XML_seaShell = 4531;
const sal_Int32 XML_seattle = 4532;
const sal_Int32 XML_secChAlign = 4533;
const sal_Int32 XML_secFontSz = 4534;
const sal_Int32 XML_secHead = 4535;
const sal_Int32 XML_secLinDir = 4536;
const sal_Int32 XML_secSibSp = 4537;
const sal_Int32 XML_second = 4538;
const sal_Int32 XML_secondColumnStripe = 4539;
const sal_Int32 XML_secondColumnSubheading = 4540;
const sal_Int32 XML_secondPiePt = 4541;
const sal_Int32 XML_secondPieSize = 4542;
const sal_Int32 XML_secondRowStripe = 4543;
const sal_Int32 XML_secondRowSubheading = 4544;
const sal_Int32 XML_secondSubtotalColumn = 4545;
const sal_Int32 XML_secondSubtotalRow = 4546;
const sal_Int32 XML_seconds = 4547;
const sal_Int32 XML_sectEnd = 4548;
const sal_Int32 XML_sectPr = 4549;
const sal_Int32 XML_sectPrChange = 4550;
const sal_Int32 XML_securityDescriptor = 4551;
const sal_Int32 XML_seek = 4552;
const sal_Int32 XML_segments = 4553;
const sal_Int32 XML_selectFldWithFirstOrLastChar = 4554;
const sal_Int32 XML_selectLockedCells = 4555;
const sal_Int32 XML_selectUnlockedCells = 4556;
const sal_Int32 XML_selected = 4557;
const sal_Int32 XML_selection = 4558;
const sal_Int32 XML_self = 4559;
const sal_Int32 XML_semiHidden = 4560;
const sal_Int32 XML_semicolon = 4561;
const sal_Int32 XML_sendLocale = 4562;
const sal_Int32 XML_sep = 4563;
const sal_Int32 XML_sepChr = 4564;
const sal_Int32 XML_separate = 4565;
const sal_Int32 XML_separator = 4566;
const sal_Int32 XML_seq = 4567;
const sal_Int32 XML_ser = 4568;
const sal_Int32 XML_serAx = 4569;
const sal_Int32 XML_serLines = 4570;
const sal_Int32 XML_series = 4571;
const sal_Int32 XML_seriesEl = 4572;
const sal_Int32 XML_seriesIdx = 4573;
const sal_Int32 XML_serverCommand = 4574;
const sal_Int32 XML_serverField = 4575;
const sal_Int32 XML_serverFill = 4576;
const sal_Int32 XML_serverFont = 4577;
const sal_Int32 XML_serverFontColor = 4578;
const sal_Int32 XML_serverFormat = 4579;
const sal_Int32 XML_serverFormats = 4580;
const sal_Int32 XML_serverNumberFormat = 4581;
const sal_Int32 XML_serverSldId = 4582;
const sal_Int32 XML_serverSldModifiedTime = 4583;
const sal_Int32 XML_serverZoom = 4584;
const sal_Int32 XML_set = 4585;
const sal_Int32 XML_setDefinition = 4586;
const sal_Int32 XML_sets = 4587;
const sal_Int32 XML_settings = 4588;
const sal_Int32 XML_shade = 4589;
const sal_Int32 XML_shadeToTitle = 4590;
const sal_Int32 XML_shadow = 4591;
const sal_Int32 XML_shadowcolor = 4592;
const sal_Int32 XML_shadowedSquares = 4593;
const sal_Int32 XML_shadowok = 4594;
const sal_Int32 XML_shape = 4595;
const sal_Int32 XML_shapeDefaults = 4596;
const sal_Int32 XML_shapeId = 4597;
const sal_Int32 XML_shapeLayoutLikeWW8 = 4598;
const sal_Int32 XML_shapedefaults = 4599;
const sal_Int32 XML_shapeid = 4600;
const sal_Int32 XML_shapelayout = 4601;
const sal_Int32 XML_shapetype = 4602;
const sal_Int32 XML_shared = 4603;
const sal_Int32 XML_sharedItems = 4604;
const sal_Int32 XML_sharksTeeth = 4605;
const sal_Int32 XML_sharpenSoften = 4606;
const sal_Int32 XML_shd = 4607;
const sal_Int32 XML_shdw1 = 4608;
const sal_Int32 XML_shdw10 = 4609;
const sal_Int32 XML_shdw11 = 4610;
const sal_Int32 XML_shdw12 = 4611;
const sal_Int32 XML_shdw13 = 4612;
const sal_Int32 XML_shdw14 = 4613;
const sal_Int32 XML_shdw15 = 4614;
const sal_Int32 XML_shdw16 = 4615;
const sal_Int32 XML_shdw17 = 4616;
const sal_Int32 XML_shdw18 = 4617;
const sal_Int32 XML_shdw19 = 4618;
const sal_Int32 XML_shdw2 = 4619;
const sal_Int32 XML_shdw20 = 4620;
const sal_Int32 XML_shdw3 = 4621;
const sal_Int32 XML_shdw4 = 4622;
const sal_Int32 XML_shdw5 = 4623;
const sal_Int32 XML_shdw6 = 4624;
const sal_Int32 XML_shdw7 = 4625;
const sal_Int32 XML_shdw8 = 4626;
const sal_Int32 XML_shdw9 = 4627;
const sal_Int32 XML_sheet = 4628;
const sal_Int32 XML_sheetCalcPr = 4629;
const sal_Int32 XML_sheetData = 4630;
const sal_Int32 XML_sheetDataSet = 4631;
const sal_Int32 XML_sheetFormatPr = 4632;
const sal_Int32 XML_sheetId = 4633;
const sal_Int32 XML_sheetIdMap = 4634;
const sal_Int32 XML_sheetName = 4635;
const sal_Int32 XML_sheetNames = 4636;
const sal_Int32 XML_sheetPosition = 4637;
const sal_Int32 XML_sheetPr = 4638;
const sal_Int32 XML_sheetProtection = 4639;
const sal_Int32 XML_sheetView = 4640;
const sal_Int32 XML_sheetViews = 4641;
const sal_Int32 XML_sheets = 4642;
const sal_Int32 XML_shimmer = 4643;
const sal_Int32 XML_shingle = 4644;
const sal_Int32 XML_shininess = 4645;
const sal_Int32 XML_shorebirdTracks = 4646;
const sal_Int32 XML_short = 4647;
const sal_Int32 XML_shortcutKey = 4648;
const sal_Int32 XML_shortdash = 4649;
const sal_Int32 XML_shortdashdot = 4650;
const sal_Int32 XML_shortdashdotdot = 4651;
const sal_Int32 XML_shortdot = 4652;
const sal_Int32 XML_show = 4653;
const sal_Int32 XML_showAll = 4654;
const sal_Int32 XML_showAnimation = 4655;
const sal_Int32 XML_showAsCaption = 4656;
const sal_Int32 XML_showAsIcon = 4657;
const sal_Int32 XML_showAutoFilter = 4658;
const sal_Int32 XML_showBorderUnselectedTables = 4659;
const sal_Int32 XML_showBreaksInFrames = 4660;
const sal_Int32 XML_showBubbleSize = 4661;
const sal_Int32 XML_showButton = 4662;
const sal_Int32 XML_showCalcMbrs = 4663;
const sal_Int32 XML_showCaptions = 4664;
const sal_Int32 XML_showCatName = 4665;
const sal_Int32 XML_showCell = 4666;
const sal_Int32 XML_showColHeaders = 4667;
const sal_Int32 XML_showColStripes = 4668;
const sal_Int32 XML_showColumnStripes = 4669;
const sal_Int32 XML_showComments = 4670;
const sal_Int32 XML_showDLblsOverMax = 4671;
const sal_Int32 XML_showDataAs = 4672;
const sal_Int32 XML_showDataDropDown = 4673;
const sal_Int32 XML_showDataLabelsRange = 4674;
const sal_Int32 XML_showDataTips = 4675;
const sal_Int32 XML_showDrill = 4676;
const sal_Int32 XML_showDropDown = 4677;
const sal_Int32 XML_showDropDowns = 4678;
const sal_Int32 XML_showDropZones = 4679;
const sal_Int32 XML_showEmptyCol = 4680;
const sal_Int32 XML_showEmptyRow = 4681;
const sal_Int32 XML_showEnvelope = 4682;
const sal_Int32 XML_showError = 4683;
const sal_Int32 XML_showErrorMessage = 4684;
const sal_Int32 XML_showFirstColumn = 4685;
const sal_Int32 XML_showFormatting = 4686;
const sal_Int32 XML_showFormulaBar = 4687;
const sal_Int32 XML_showFormulas = 4688;
const sal_Int32 XML_showGridLines = 4689;
const sal_Int32 XML_showGuides = 4690;
const sal_Int32 XML_showHeader = 4691;
const sal_Int32 XML_showHeaders = 4692;
const sal_Int32 XML_showHorizontalScroll = 4693;
const sal_Int32 XML_showHorzBorder = 4694;
const sal_Int32 XML_showInFieldList = 4695;
const sal_Int32 XML_showInkAnnotation = 4696;
const sal_Int32 XML_showInputMessage = 4697;
const sal_Int32 XML_showItems = 4698;
const sal_Int32 XML_showKeys = 4699;
const sal_Int32 XML_showLastColumn = 4700;
const sal_Int32 XML_showLeaderLines = 4701;
const sal_Int32 XML_showLegendKey = 4702;
const sal_Int32 XML_showMasterPhAnim = 4703;
const sal_Int32 XML_showMasterSp = 4704;
const sal_Int32 XML_showMemberPropertyTips = 4705;
const sal_Int32 XML_showMissing = 4706;
const sal_Int32 XML_showMultipleLabel = 4707;
const sal_Int32 XML_showNarration = 4708;
const sal_Int32 XML_showNegBubbles = 4709;
const sal_Int32 XML_showObjects = 4710;
const sal_Int32 XML_showOutline = 4711;
const sal_Int32 XML_showOutlineIcons = 4712;
const sal_Int32 XML_showOutlineSymbols = 4713;
const sal_Int32 XML_showPageBreaks = 4714;
const sal_Int32 XML_showPercent = 4715;
const sal_Int32 XML_showPivotChartFilter = 4716;
const sal_Int32 XML_showPr = 4717;
const sal_Int32 XML_showPropAsCaption = 4718;
const sal_Int32 XML_showPropCell = 4719;
const sal_Int32 XML_showPropTip = 4720;
const sal_Int32 XML_showRowCol = 4721;
const sal_Int32 XML_showRowColHeaders = 4722;
const sal_Int32 XML_showRowHeaders = 4723;
const sal_Int32 XML_showRowStripes = 4724;
const sal_Int32 XML_showRuler = 4725;
const sal_Int32 XML_showScrollbar = 4726;
const sal_Int32 XML_showSerName = 4727;
const sal_Int32 XML_showSheetTabs = 4728;
const sal_Int32 XML_showSpeakerNotes = 4729;
const sal_Int32 XML_showSpecialPlsOnTitleSld = 4730;
const sal_Int32 XML_showStatusbar = 4731;
const sal_Int32 XML_showTip = 4732;
const sal_Int32 XML_showVal = 4733;
const sal_Int32 XML_showValue = 4734;
const sal_Int32 XML_showVertBorder = 4735;
const sal_Int32 XML_showVerticalScroll = 4736;
const sal_Int32 XML_showWhenStopped = 4737;
const sal_Int32 XML_showWhiteSpace = 4738;
const sal_Int32 XML_showXMLTags = 4739;
const sal_Int32 XML_showZeros = 4740;
const sal_Int32 XML_showingPlcHdr = 4741;
const sal_Int32 XML_showsigndate = 4742;
const sal_Int32 XML_shp = 4743;
const sal_Int32 XML_shpTxLTRAlignCh = 4744;
const sal_Int32 XML_shpTxRTLAlignCh = 4745;
const sal_Int32 XML_shred = 4746;
const sal_Int32 XML_shrinkToFit = 4747;
const sal_Int32 XML_si = 4748;
const sal_Int32 XML_sib = 4749;
const sal_Int32 XML_sibSp = 4750;
const sal_Int32 XML_sibTrans = 4751;
const sal_Int32 XML_sibTransId = 4752;
const sal_Int32 XML_side = 4753;
const sal_Int32 XML_sideWall = 4754;
const sal_Int32 XML_sienna = 4755;
const sal_Int32 XML_sig = 4756;
const sal_Int32 XML_sigma = 4757;
const sal_Int32 XML_signatureline = 4758;
const sal_Int32 XML_signinginstructions = 4759;
const sal_Int32 XML_signinginstructionsset = 4760;
const sal_Int32 XML_sigprovurl = 4761;
const sal_Int32 XML_silver = 4762;
const sal_Int32 XML_simplePos = 4763;
const sal_Int32 XML_single = 4764;
const sal_Int32 XML_singleAccounting = 4765;
const sal_Int32 XML_singleLevel = 4766;
const sal_Int32 XML_singleQuote = 4767;
const sal_Int32 XML_singleSignOnId = 4768;
const sal_Int32 XML_singleXmlCell = 4769;
const sal_Int32 XML_singleXmlCells = 4770;
const sal_Int32 XML_singleclick = 4771;
const sal_Int32 XML_size = 4772;
const sal_Int32 XML_sizeAuto = 4773;
const sal_Int32 XML_sizeRelH = 4774;
const sal_Int32 XML_sizeRelV = 4775;
const sal_Int32 XML_sizeRepresents = 4776;
const sal_Int32 XML_sizeWithCells = 4777;
const sal_Int32 XML_skew = 4778;
const sal_Int32 XML_skewamt = 4779;
const sal_Int32 XML_skewangle = 4780;
const sal_Int32 XML_skip = 4781;
const sal_Int32 XML_skipTimed = 4782;
const sal_Int32 XML_skw = 4783;
const sal_Int32 XML_skyBlue = 4784;
const sal_Int32 XML_skyrocket = 4785;
const sal_Int32 XML_slantDashDot = 4786;
const sal_Int32 XML_slateBlue = 4787;
const sal_Int32 XML_slateGray = 4788;
const sal_Int32 XML_sld = 4789;
const sal_Int32 XML_sldAll = 4790;
const sal_Int32 XML_sldId = 4791;
const sal_Int32 XML_sldIdLst = 4792;
const sal_Int32 XML_sldImg = 4793;
const sal_Int32 XML_sldLayout = 4794;
const sal_Int32 XML_sldLayoutId = 4795;
const sal_Int32 XML_sldLayoutIdLst = 4796;
const sal_Int32 XML_sldLst = 4797;
const sal_Int32 XML_sldMaster = 4798;
const sal_Int32 XML_sldMasterId = 4799;
const sal_Int32 XML_sldMasterIdLst = 4800;
const sal_Int32 XML_sldMasterView = 4801;
const sal_Int32 XML_sldNum = 4802;
const sal_Int32 XML_sldRg = 4803;
const sal_Int32 XML_sldSorterView = 4804;
const sal_Int32 XML_sldSyncPr = 4805;
const sal_Int32 XML_sldSz = 4806;
const sal_Int32 XML_sldTgt = 4807;
const sal_Int32 XML_sldThumbnailView = 4808;
const sal_Int32 XML_sldView = 4809;
const sal_Int32 XML_slideViewPr = 4810;
const sal_Int32 XML_slides = 4811;
const sal_Int32 XML_slope = 4812;
const sal_Int32 XML_slow = 4813;
const sal_Int32 XML_sm = 4814;
const sal_Int32 XML_smCheck = 4815;
const sal_Int32 XML_smConfetti = 4816;
const sal_Int32 XML_smGrid = 4817;
const sal_Int32 XML_small = 4818;
const sal_Int32 XML_smallCaps = 4819;
const sal_Int32 XML_smallFrac = 4820;
const sal_Int32 XML_smartTag = 4821;
const sal_Int32 XML_smartTagPr = 4822;
const sal_Int32 XML_smartTagType = 4823;
const sal_Int32 XML_smartTagTypes = 4824;
const sal_Int32 XML_smartTags = 4825;
const sal_Int32 XML_smileyFace = 4826;
const sal_Int32 XML_smooth = 4827;
const sal_Int32 XML_smoothMarker = 4828;
const sal_Int32 XML_smoothness = 4829;
const sal_Int32 XML_smtClean = 4830;
const sal_Int32 XML_smtId = 4831;
const sal_Int32 XML_snake = 4832;
const sal_Int32 XML_snapToChars = 4833;
const sal_Int32 XML_snapToGrid = 4834;
const sal_Int32 XML_snapToObjects = 4835;
const sal_Int32 XML_snapVertSplitter = 4836;
const sal_Int32 XML_snd = 4837;
const sal_Int32 XML_sndAc = 4838;
const sal_Int32 XML_sndTgt = 4839;
const sal_Int32 XML_sng = 4840;
const sal_Int32 XML_sngStrike = 4841;
const sal_Int32 XML_snip1Rect = 4842;
const sal_Int32 XML_snip2DiagRect = 4843;
const sal_Int32 XML_snip2SameRect = 4844;
const sal_Int32 XML_snipRoundRect = 4845;
const sal_Int32 XML_snow = 4846;
const sal_Int32 XML_snowflakeFancy = 4847;
const sal_Int32 XML_snowflakes = 4848;
const sal_Int32 XML_soft = 4849;
const sal_Int32 XML_softEdge = 4850;
const sal_Int32 XML_softHyphen = 4851;
const sal_Int32 XML_softRound = 4852;
const sal_Int32 XML_softmetal = 4853;
const sal_Int32 XML_solid = 4854;
const sal_Int32 XML_solidDmnd = 4855;
const sal_Int32 XML_solidFill = 4856;
const sal_Int32 XML_solutionID = 4857;
const sal_Int32 XML_solveOrder = 4858;
const sal_Int32 XML_sombrero = 4859;
const sal_Int32 XML_sort = 4860;
const sal_Int32 XML_sortBy = 4861;
const sal_Int32 XML_sortByTuple = 4862;
const sal_Int32 XML_sortCondition = 4863;
const sal_Int32 XML_sortMethod = 4864;
const sal_Int32 XML_sortState = 4865;
const sal_Int32 XML_sortType = 4866;
const sal_Int32 XML_sorterViewPr = 4867;
const sal_Int32 XML_source = 4868;
const sal_Int32 XML_sourceData = 4869;
const sal_Int32 XML_sourceFile = 4870;
const sal_Int32 XML_sourceFileName = 4871;
const sal_Int32 XML_sourceLinked = 4872;
const sal_Int32 XML_sourceObject = 4873;
const sal_Int32 XML_sourceRef = 4874;
const sal_Int32 XML_sourceSheetId = 4875;
const sal_Int32 XML_sourceType = 4876;
const sal_Int32 XML_southwest = 4877;
const sal_Int32 XML_sp = 4878;
const sal_Int32 XML_sp3d = 4879;
const sal_Int32 XML_spAutoFit = 4880;
const sal_Int32 XML_spDef = 4881;
const sal_Int32 XML_spLocks = 4882;
const sal_Int32 XML_spPr = 4883;
const sal_Int32 XML_spTgt = 4884;
const sal_Int32 XML_spTree = 4885;
const sal_Int32 XML_space = 4886;
const sal_Int32 XML_spaceForUL = 4887;
const sal_Int32 XML_spacing = 4888;
const sal_Int32 XML_spacingInWholePoints = 4889;
const sal_Int32 XML_span = 4890;
const sal_Int32 XML_spanAng = 4891;
const sal_Int32 XML_spans = 4892;
const sal_Int32 XML_sparkle = 4893;
const sal_Int32 XML_sparklineGroups = 4894;
const sal_Int32 XML_sparklineGroup = 4895;
const sal_Int32 XML_sparklines = 4896;
const sal_Int32 XML_sparkline = 4897;
const sal_Int32 XML_spc = 4898;
const sal_Int32 XML_spcAft = 4899;
const sal_Int32 XML_spcBef = 4900;
const sal_Int32 XML_spcCol = 4901;
const sal_Int32 XML_spcFirstLastPara = 4902;
const sal_Int32 XML_spcPct = 4903;
const sal_Int32 XML_spcPts = 4904;
const sal_Int32 XML_spd = 4905;
const sal_Int32 XML_specVanish = 4906;
const sal_Int32 XML_specularity = 4907;
const sal_Int32 XML_spellEnd = 4908;
const sal_Int32 XML_spellStart = 4909;
const sal_Int32 XML_speller = 4910;
const sal_Int32 XML_spelling = 4911;
const sal_Int32 XML_sphere = 4912;
const sal_Int32 XML_spid = 4913;
const sal_Int32 XML_spidmax = 4914;
const sal_Int32 XML_spinCount = 4915;
const sal_Int32 XML_split = 4916;
const sal_Int32 XML_splitAll = 4917;
const sal_Int32 XML_splitFirst = 4918;
const sal_Int32 XML_splitPgBreakAndParaMark = 4919;
const sal_Int32 XML_splitPos = 4920;
const sal_Int32 XML_splitType = 4921;
const sal_Int32 XML_spokes = 4922;
const sal_Int32 XML_spreadsheet = 4923;
const sal_Int32 XML_springGreen = 4924;
const sal_Int32 XML_spt = 4925;
const sal_Int32 XML_sq = 4926;
const sal_Int32 XML_sqlType = 4927;
const sal_Int32 XML_sqref = 4928;
const sal_Int32 XML_square = 4929;
const sal_Int32 XML_squareTabs = 4930;
const sal_Int32 XML_src = 4931;
const sal_Int32 XML_srcId = 4932;
const sal_Int32 XML_srcNode = 4933;
const sal_Int32 XML_srcOrd = 4934;
const sal_Int32 XML_srcRect = 4935;
const sal_Int32 XML_srgbClr = 4936;
const sal_Int32 XML_ss = 4937;
const sal_Int32 XML_ssd16 = 4938;
const sal_Int32 XML_ssd2 = 4939;
const sal_Int32 XML_ssd32 = 4940;
const sal_Int32 XML_ssd4 = 4941;
const sal_Int32 XML_ssd6 = 4942;
const sal_Int32 XML_ssd8 = 4943;
const sal_Int32 XML_sst = 4944;
const sal_Int32 XML_st = 4945;
const sal_Int32 XML_stA = 4946;
const sal_Int32 XML_stAng = 4947;
const sal_Int32 XML_stBulletLvl = 4948;
const sal_Int32 XML_stCondLst = 4949;
const sal_Int32 XML_stCxn = 4950;
const sal_Int32 XML_stElem = 4951;
const sal_Int32 XML_stPos = 4952;
const sal_Int32 XML_stSnd = 4953;
const sal_Int32 XML_stack = 4954;
const sal_Int32 XML_stackScale = 4955;
const sal_Int32 XML_stacked = 4956;
const sal_Int32 XML_standard = 4957;
const sal_Int32 XML_star = 4958;
const sal_Int32 XML_star10 = 4959;
const sal_Int32 XML_star12 = 4960;
const sal_Int32 XML_star16 = 4961;
const sal_Int32 XML_star24 = 4962;
const sal_Int32 XML_star32 = 4963;
const sal_Int32 XML_star4 = 4964;
const sal_Int32 XML_star5 = 4965;
const sal_Int32 XML_star6 = 4966;
const sal_Int32 XML_star7 = 4967;
const sal_Int32 XML_star8 = 4968;
const sal_Int32 XML_stars = 4969;
const sal_Int32 XML_stars3d = 4970;
const sal_Int32 XML_starsBlack = 4971;
const sal_Int32 XML_starsShadowed = 4972;
const sal_Int32 XML_starsTop = 4973;
const sal_Int32 XML_start = 4974;
const sal_Int32 XML_startAngle = 4975;
const sal_Int32 XML_startAt = 4976;
const sal_Int32 XML_startChars = 4977;
const sal_Int32 XML_startDate = 4978;
const sal_Int32 XML_startNum = 4979;
const sal_Int32 XML_startOverride = 4980;
const sal_Int32 XML_startarrow = 4981;
const sal_Int32 XML_startarrowlength = 4982;
const sal_Int32 XML_startarrowwidth = 4983;
const sal_Int32 XML_state = 4984;
const sal_Int32 XML_status = 4985;
const sal_Int32 XML_statusBar = 4986;
const sal_Int32 XML_statusText = 4987;
const sal_Int32 XML_std = 4988;
const sal_Int32 XML_stdDev = 4989;
const sal_Int32 XML_stdDevP = 4990;
const sal_Int32 XML_stdDevPSubtotal = 4991;
const sal_Int32 XML_stdDevSubtotal = 4992;
const sal_Int32 XML_stdDevp = 4993;
const sal_Int32 XML_stdErr = 4994;
const sal_Int32 XML_stealth = 4995;
const sal_Int32 XML_steelBlue = 4996;
const sal_Int32 XML_stemThick = 4997;
const sal_Int32 XML_step = 4998;
const sal_Int32 XML_stockChart = 4999;
const sal_Int32 XML_stop = 5000;
const sal_Int32 XML_stopIfTrue = 5001;
const sal_Int32 XML_storage = 5002;
const sal_Int32 XML_storeItemID = 5003;
const sal_Int32 XML_storeMappedDataAs = 5004;
const sal_Int32 XML_stored = 5005;
const sal_Int32 XML_stp = 5006;
const sal_Int32 XML_str = 5007;
const sal_Int32 XML_strCache = 5008;
const sal_Int32 XML_strLit = 5009;
const sal_Int32 XML_strRef = 5010;
const sal_Int32 XML_strVal = 5011;
const sal_Int32 XML_stra = 5012;
const sal_Int32 XML_straight = 5013;
const sal_Int32 XML_straightConnector1 = 5014;
const sal_Int32 XML_stream = 5015;
const sal_Int32 XML_stretch = 5016;
const sal_Int32 XML_strictFirstAndLastChars = 5017;
const sal_Int32 XML_strike = 5018;
const sal_Int32 XML_strikeBLTR = 5019;
const sal_Int32 XML_strikeH = 5020;
const sal_Int32 XML_strikeTLBR = 5021;
const sal_Int32 XML_strikeV = 5022;
const sal_Int32 XML_string = 5023;
const sal_Int32 XML_stringRefSyntax = 5024;
const sal_Int32 XML_stringValue1 = 5025;
const sal_Int32 XML_stringValue2 = 5026;
const sal_Int32 XML_stripedRightArrow = 5027;
const sal_Int32 XML_strips = 5028;
const sal_Int32 XML_stroke = 5029;
const sal_Int32 XML_strokecolor = 5030;
const sal_Int32 XML_stroked = 5031;
const sal_Int32 XML_strokeok = 5032;
const sal_Int32 XML_strokeweight = 5033;
const sal_Int32 XML_sty = 5034;
const sal_Int32 XML_style = 5035;
const sal_Int32 XML_styleData = 5036;
const sal_Int32 XML_styleDef = 5037;
const sal_Int32 XML_styleDefHdr = 5038;
const sal_Int32 XML_styleDefHdrLst = 5039;
const sal_Int32 XML_styleId = 5040;
const sal_Int32 XML_styleLbl = 5041;
const sal_Int32 XML_styleLink = 5042;
const sal_Int32 XML_styleLockQFSet = 5043;
const sal_Int32 XML_styleLockTheme = 5044;
const sal_Int32 XML_styleName = 5045;
const sal_Int32 XML_stylePaneFormatFilter = 5046;
const sal_Int32 XML_stylePaneSortMethod = 5047;
const sal_Int32 XML_styleSet = 5048;
const sal_Int32 XML_styleSheet = 5049;
const sal_Int32 XML_styles = 5050;
const sal_Int32 XML_stylisticSets = 5051;
const sal_Int32 XML_sub = 5052;
const sal_Int32 XML_subDoc = 5053;
const sal_Int32 XML_subFontBySize = 5054;
const sal_Int32 XML_subHide = 5055;
const sal_Int32 XML_subSp = 5056;
const sal_Int32 XML_subSup = 5057;
const sal_Int32 XML_subTitle = 5058;
const sal_Int32 XML_subTnLst = 5059;
const sal_Int32 XML_subject = 5060;
const sal_Int32 XML_subscript = 5061;
const sal_Int32 XML_subsetted = 5062;
const sal_Int32 XML_subtotal = 5063;
const sal_Int32 XML_subtotalCaption = 5064;
const sal_Int32 XML_subtotalHiddenItems = 5065;
const sal_Int32 XML_subtotalTop = 5066;
const sal_Int32 XML_suff = 5067;
const sal_Int32 XML_suggestedsigner = 5068;
const sal_Int32 XML_suggestedsigner2 = 5069;
const sal_Int32 XML_suggestedsigneremail = 5070;
const sal_Int32 XML_sum = 5071;
const sal_Int32 XML_sumSubtotal = 5072;
const sal_Int32 XML_summaryBelow = 5073;
const sal_Int32 XML_summaryLength = 5074;
const sal_Int32 XML_summaryRight = 5075;
const sal_Int32 XML_sun = 5076;
const sal_Int32 XML_sunrise = 5077;
const sal_Int32 XML_sunset = 5078;
const sal_Int32 XML_sup = 5079;
const sal_Int32 XML_supHide = 5080;
const sal_Int32 XML_superscript = 5081;
const sal_Int32 XML_supportAdvancedDrill = 5082;
const sal_Int32 XML_supportSubquery = 5083;
const sal_Int32 XML_suppressAutoHyphens = 5084;
const sal_Int32 XML_suppressBottomSpacing = 5085;
const sal_Int32 XML_suppressLineNumbers = 5086;
const sal_Int32 XML_suppressOverlap = 5087;
const sal_Int32 XML_suppressSpBfAfterPgBrk = 5088;
const sal_Int32 XML_suppressSpacingAtTopOfPage = 5089;
const sal_Int32 XML_suppressTopSpacing = 5090;
const sal_Int32 XML_suppressTopSpacingWP = 5091;
const sal_Int32 XML_surface3DChart = 5092;
const sal_Int32 XML_surfaceChart = 5093;
const sal_Int32 XML_svgBlip = 5094;
const sal_Int32 XML_swAng = 5095;
const sal_Int32 XML_swCell = 5096;
const sal_Int32 XML_swapBordersFacingPages = 5097;
const sal_Int32 XML_swirligig = 5098;
const sal_Int32 XML_swiss = 5099;
const sal_Int32 XML_switch = 5100;
const sal_Int32 XML_swooshArrow = 5101;
const sal_Int32 XML_sx = 5102;
const sal_Int32 XML_sy = 5103;
const sal_Int32 XML_sym = 5104;
const sal_Int32 XML_symbol = 5105;
const sal_Int32 XML_syncBehavior = 5106;
const sal_Int32 XML_syncHorizontal = 5107;
const sal_Int32 XML_syncRef = 5108;
const sal_Int32 XML_syncVertical = 5109;
const sal_Int32 XML_sysClr = 5110;
const sal_Int32 XML_sysDash = 5111;
const sal_Int32 XML_sysDashDot = 5112;
const sal_Int32 XML_sysDashDotDot = 5113;
const sal_Int32 XML_sysDot = 5114;
const sal_Int32 XML_sz = 5115;
const sal_Int32 XML_szCs = 5116;
const sal_Int32 XML_t = 5117;
const sal_Int32 XML_t1 = 5118;
const sal_Int32 XML_t2 = 5119;
const sal_Int32 XML_tCtr = 5120;
const sal_Int32 XML_tCtrCh = 5121;
const sal_Int32 XML_tCtrDes = 5122;
const sal_Int32 XML_tIns = 5123;
const sal_Int32 XML_tL = 5124;
const sal_Int32 XML_tMarg = 5125;
const sal_Int32 XML_tOff = 5126;
const sal_Int32 XML_tR = 5127;
const sal_Int32 XML_tab = 5128;
const sal_Int32 XML_tabColor = 5129;
const sal_Int32 XML_tabIndex = 5130;
const sal_Int32 XML_tabLst = 5131;
const sal_Int32 XML_tabRatio = 5132;
const sal_Int32 XML_tabSelected = 5133;
const sal_Int32 XML_table = 5134;
const sal_Int32 XML_tableBorderDxfId = 5135;
const sal_Int32 XML_tableCellDelete = 5136;
const sal_Int32 XML_tableCellInsert = 5137;
const sal_Int32 XML_tableColumn = 5138;
const sal_Int32 XML_tableColumnId = 5139;
const sal_Int32 XML_tableColumns = 5140;
const sal_Int32 XML_tablePart = 5141;
const sal_Int32 XML_tableParts = 5142;
const sal_Int32 XML_tableRowDelete = 5143;
const sal_Int32 XML_tableRowInsert = 5144;
const sal_Int32 XML_tableStyle = 5145;
const sal_Int32 XML_tableStyleElement = 5146;
const sal_Int32 XML_tableStyleId = 5147;
const sal_Int32 XML_tableStyleInfo = 5148;
const sal_Int32 XML_tableStyles = 5149;
const sal_Int32 XML_tableType = 5150;
const sal_Int32 XML_tablelimits = 5151;
const sal_Int32 XML_tableproperties = 5152;
const sal_Int32 XML_tables = 5153;
const sal_Int32 XML_tabs = 5154;
const sal_Int32 XML_tag = 5155;
const sal_Int32 XML_tagLst = 5156;
const sal_Int32 XML_tags = 5157;
const sal_Int32 XML_tailEnd = 5158;
const sal_Int32 XML_taiwan = 5159;
const sal_Int32 XML_taiwaneseCounting = 5160;
const sal_Int32 XML_taiwaneseCountingThousand = 5161;
const sal_Int32 XML_taiwaneseDigital = 5162;
const sal_Int32 XML_tan = 5163;
const sal_Int32 XML_target = 5164;
const sal_Int32 XML_targetScreenSize = 5165;
const sal_Int32 XML_targetScreenSz = 5166;
const sal_Int32 XML_targetscreensize = 5167;
const sal_Int32 XML_tav = 5168;
const sal_Int32 XML_tavLst = 5169;
const sal_Int32 XML_tbLrV = 5170;
const sal_Int32 XML_tbRl = 5171;
const sal_Int32 XML_tbRlV = 5172;
const sal_Int32 XML_tbl = 5173;
const sal_Int32 XML_tblBg = 5174;
const sal_Int32 XML_tblBorders = 5175;
const sal_Int32 XML_tblCaption = 5176;
const sal_Int32 XML_tblCellMar = 5177;
const sal_Int32 XML_tblCellSpacing = 5178;
const sal_Int32 XML_tblDescription = 5179;
const sal_Int32 XML_tblGrid = 5180;
const sal_Int32 XML_tblGridChange = 5181;
const sal_Int32 XML_tblHeader = 5182;
const sal_Int32 XML_tblInd = 5183;
const sal_Int32 XML_tblLayout = 5184;
const sal_Int32 XML_tblLook = 5185;
const sal_Int32 XML_tblOfContents = 5186;
const sal_Int32 XML_tblOverlap = 5187;
const sal_Int32 XML_tblPr = 5188;
const sal_Int32 XML_tblPrChange = 5189;
const sal_Int32 XML_tblPrEx = 5190;
const sal_Int32 XML_tblPrExChange = 5191;
const sal_Int32 XML_tblStyle = 5192;
const sal_Int32 XML_tblStyleColBandSize = 5193;
const sal_Int32 XML_tblStyleLst = 5194;
const sal_Int32 XML_tblStylePr = 5195;
const sal_Int32 XML_tblStyleRowBandSize = 5196;
const sal_Int32 XML_tblW = 5197;
const sal_Int32 XML_tblpPr = 5198;
const sal_Int32 XML_tblpX = 5199;
const sal_Int32 XML_tblpXSpec = 5200;
const sal_Int32 XML_tblpY = 5201;
const sal_Int32 XML_tblpYSpec = 5202;
const sal_Int32 XML_tbls = 5203;
const sal_Int32 XML_tc = 5204;
const sal_Int32 XML_tcBdr = 5205;
const sal_Int32 XML_tcBorders = 5206;
const sal_Int32 XML_tcFitText = 5207;
const sal_Int32 XML_tcMar = 5208;
const sal_Int32 XML_tcPr = 5209;
const sal_Int32 XML_tcPrChange = 5210;
const sal_Int32 XML_tcStyle = 5211;
const sal_Int32 XML_tcTxStyle = 5212;
const sal_Int32 XML_tcW = 5213;
const sal_Int32 XML_teal = 5214;
const sal_Int32 XML_teardrop = 5215;
const sal_Int32 XML_temporary = 5216;
const sal_Int32 XML_tenMillions = 5217;
const sal_Int32 XML_tenThousands = 5218;
const sal_Int32 XML_tentative = 5219;
const sal_Int32 XML_text = 5220;
const sal_Int32 XML_text1 = 5221;
const sal_Int32 XML_text2 = 5222;
const sal_Int32 XML_textAlignment = 5223;
const sal_Int32 XML_textAndBackground = 5224;
const sal_Int32 XML_textArchDown = 5225;
const sal_Int32 XML_textArchDownPour = 5226;
const sal_Int32 XML_textArchUp = 5227;
const sal_Int32 XML_textArchUpPour = 5228;
const sal_Int32 XML_textButton = 5229;
const sal_Int32 XML_textButtonPour = 5230;
const sal_Int32 XML_textCanDown = 5231;
const sal_Int32 XML_textCanUp = 5232;
const sal_Int32 XML_textCascadeDown = 5233;
const sal_Int32 XML_textCascadeUp = 5234;
const sal_Int32 XML_textChevron = 5235;
const sal_Int32 XML_textChevronInverted = 5236;
const sal_Int32 XML_textCircle = 5237;
const sal_Int32 XML_textCirclePour = 5238;
const sal_Int32 XML_textCurveDown = 5239;
const sal_Int32 XML_textCurveUp = 5240;
const sal_Int32 XML_textDates = 5241;
const sal_Int32 XML_textDeflate = 5242;
const sal_Int32 XML_textDeflateBottom = 5243;
const sal_Int32 XML_textDeflateInflate = 5244;
const sal_Int32 XML_textDeflateInflateDeflate = 5245;
const sal_Int32 XML_textDeflateTop = 5246;
const sal_Int32 XML_textDirection = 5247;
const sal_Int32 XML_textDoubleWave1 = 5248;
const sal_Int32 XML_textFadeDown = 5249;
const sal_Int32 XML_textFadeLeft = 5250;
const sal_Int32 XML_textFadeRight = 5251;
const sal_Int32 XML_textFadeUp = 5252;
const sal_Int32 XML_textField = 5253;
const sal_Int32 XML_textFields = 5254;
const sal_Int32 XML_textFile = 5255;
const sal_Int32 XML_textFill = 5256;
const sal_Int32 XML_textFit = 5257;
const sal_Int32 XML_textHAlign = 5258;
const sal_Int32 XML_textInflate = 5259;
const sal_Int32 XML_textInflateBottom = 5260;
const sal_Int32 XML_textInflateTop = 5261;
const sal_Int32 XML_textInput = 5262;
const sal_Int32 XML_textLength = 5263;
const sal_Int32 XML_textNoShape = 5264;
const sal_Int32 XML_textOutline = 5265;
const sal_Int32 XML_textPlain = 5266;
const sal_Int32 XML_textPr = 5267;
const sal_Int32 XML_textRingInside = 5268;
const sal_Int32 XML_textRingOutside = 5269;
const sal_Int32 XML_textRotation = 5270;
const sal_Int32 XML_textSlantDown = 5271;
const sal_Int32 XML_textSlantUp = 5272;
const sal_Int32 XML_textStop = 5273;
const sal_Int32 XML_textTriangle = 5274;
const sal_Int32 XML_textTriangleInverted = 5275;
const sal_Int32 XML_textVAlign = 5276;
const sal_Int32 XML_textWave1 = 5277;
const sal_Int32 XML_textWave2 = 5278;
const sal_Int32 XML_textWave4 = 5279;
const sal_Int32 XML_textWrapping = 5280;
const sal_Int32 XML_textborder = 5281;
const sal_Int32 XML_textbox = 5282;
const sal_Int32 XML_textboxTightWrap = 5283;
const sal_Int32 XML_textboxrect = 5284;
const sal_Int32 XML_textdata = 5285;
const sal_Int32 XML_textlink = 5286;
const sal_Int32 XML_textpath = 5287;
const sal_Int32 XML_textpathok = 5288;
const sal_Int32 XML_tgtEl = 5289;
const sal_Int32 XML_tgtFrame = 5290;
const sal_Int32 XML_thai = 5291;
const sal_Int32 XML_thaiAlphaParenBoth = 5292;
const sal_Int32 XML_thaiAlphaParenR = 5293;
const sal_Int32 XML_thaiAlphaPeriod = 5294;
const sal_Int32 XML_thaiCounting = 5295;
const sal_Int32 XML_thaiDist = 5296;
const sal_Int32 XML_thaiDistribute = 5297;
const sal_Int32 XML_thaiLetters = 5298;
const sal_Int32 XML_thaiNumParenBoth = 5299;
const sal_Int32 XML_thaiNumParenR = 5300;
const sal_Int32 XML_thaiNumPeriod = 5301;
const sal_Int32 XML_thaiNumbers = 5302;
const sal_Int32 XML_theme = 5303;
const sal_Int32 XML_themeColor = 5304;
const sal_Int32 XML_themeElements = 5305;
const sal_Int32 XML_themeFill = 5306;
const sal_Int32 XML_themeFillShade = 5307;
const sal_Int32 XML_themeFillTint = 5308;
const sal_Int32 XML_themeFontLang = 5309;
const sal_Int32 XML_themeManager = 5310;
const sal_Int32 XML_themeOverride = 5311;
const sal_Int32 XML_themeShade = 5312;
const sal_Int32 XML_themeTint = 5313;
const sal_Int32 XML_thick = 5314;
const sal_Int32 XML_thickBetweenThin = 5315;
const sal_Int32 XML_thickBetweenThinLarge = 5316;
const sal_Int32 XML_thickBetweenThinSmall = 5317;
const sal_Int32 XML_thickBot = 5318;
const sal_Int32 XML_thickBottom = 5319;
const sal_Int32 XML_thickThin = 5320;
const sal_Int32 XML_thickThinLarge = 5321;
const sal_Int32 XML_thickThinLargeGap = 5322;
const sal_Int32 XML_thickThinMediumGap = 5323;
const sal_Int32 XML_thickThinSmall = 5324;
const sal_Int32 XML_thickThinSmallGap = 5325;
const sal_Int32 XML_thickTop = 5326;
const sal_Int32 XML_thicket = 5327;
const sal_Int32 XML_thickness = 5328;
const sal_Int32 XML_thin = 5329;
const sal_Int32 XML_thinDiagCross = 5330;
const sal_Int32 XML_thinDiagStripe = 5331;
const sal_Int32 XML_thinHorzCross = 5332;
const sal_Int32 XML_thinHorzStripe = 5333;
const sal_Int32 XML_thinReverseDiagStripe = 5334;
const sal_Int32 XML_thinThick = 5335;
const sal_Int32 XML_thinThickLarge = 5336;
const sal_Int32 XML_thinThickLargeGap = 5337;
const sal_Int32 XML_thinThickMediumGap = 5338;
const sal_Int32 XML_thinThickSmall = 5339;
const sal_Int32 XML_thinThickSmallGap = 5340;
const sal_Int32 XML_thinThickThinLargeGap = 5341;
const sal_Int32 XML_thinThickThinMediumGap = 5342;
const sal_Int32 XML_thinThickThinSmallGap = 5343;
const sal_Int32 XML_thinThin = 5344;
const sal_Int32 XML_thinVertStripe = 5345;
const sal_Int32 XML_thirdColumnSubheading = 5346;
const sal_Int32 XML_thirdRowSubheading = 5347;
const sal_Int32 XML_thirdSubtotalColumn = 5348;
const sal_Int32 XML_thirdSubtotalRow = 5349;
const sal_Int32 XML_thisMonth = 5350;
const sal_Int32 XML_thisQuarter = 5351;
const sal_Int32 XML_thisWeek = 5352;
const sal_Int32 XML_thisYear = 5353;
const sal_Int32 XML_thistle = 5354;
const sal_Int32 XML_thousands = 5355;
const sal_Int32 XML_threeDEmboss = 5356;
const sal_Int32 XML_threeDEngrave = 5357;
const sal_Int32 XML_threePt = 5358;
const sal_Int32 XML_thresh = 5359;
const sal_Int32 XML_through = 5360;
const sal_Int32 XML_thruBlk = 5361;
const sal_Int32 XML_tickLblPos = 5362;
const sal_Int32 XML_tickLblSkip = 5363;
const sal_Int32 XML_tickMarkSkip = 5364;
const sal_Int32 XML_tight = 5365;
const sal_Int32 XML_tile = 5366;
const sal_Int32 XML_tileRect = 5367;
const sal_Int32 XML_time = 5368;
const sal_Int32 XML_timePeriod = 5369;
const sal_Int32 XML_timing = 5370;
const sal_Int32 XML_tint = 5371;
const sal_Int32 XML_title = 5372;
const sal_Int32 XML_titleOnly = 5373;
const sal_Int32 XML_titlePg = 5374;
const sal_Int32 XML_titleStyle = 5375;
const sal_Int32 XML_tl = 5376;
const sal_Int32 XML_tl2br = 5377;
const sal_Int32 XML_tm = 5378;
const sal_Int32 XML_tmAbs = 5379;
const sal_Int32 XML_tmFilter = 5380;
const sal_Int32 XML_tmPct = 5381;
const sal_Int32 XML_tmRoot = 5382;
const sal_Int32 XML_tmpl = 5383;
const sal_Int32 XML_tmplLst = 5384;
const sal_Int32 XML_tn = 5385;
const sal_Int32 XML_tnLst = 5386;
const sal_Int32 XML_to = 5387;
const sal_Int32 XML_today = 5388;
const sal_Int32 XML_token = 5389;
const sal_Int32 XML_tomato = 5390;
const sal_Int32 XML_tomorrow = 5391;
const sal_Int32 XML_toolbar = 5392;
const sal_Int32 XML_tooltip = 5393;
const sal_Int32 XML_top = 5394;
const sal_Int32 XML_top10 = 5395;
const sal_Int32 XML_topAndBottom = 5396;
const sal_Int32 XML_topAutoShow = 5397;
const sal_Int32 XML_topFromText = 5398;
const sal_Int32 XML_topLabels = 5399;
const sal_Int32 XML_topLeft = 5400;
const sal_Int32 XML_topLeftCell = 5401;
const sal_Int32 XML_topLinePunct = 5402;
const sal_Int32 XML_topMargin = 5403;
const sal_Int32 XML_topRight = 5404;
const sal_Int32 XML_tornPaper = 5405;
const sal_Int32 XML_tornPaperBlack = 5406;
const sal_Int32 XML_totalRow = 5407;
const sal_Int32 XML_totalsRowBorderDxfId = 5408;
const sal_Int32 XML_totalsRowCellStyle = 5409;
const sal_Int32 XML_totalsRowCount = 5410;
const sal_Int32 XML_totalsRowDxfId = 5411;
const sal_Int32 XML_totalsRowFormula = 5412;
const sal_Int32 XML_totalsRowFunction = 5413;
const sal_Int32 XML_totalsRowLabel = 5414;
const sal_Int32 XML_totalsRowShown = 5415;
const sal_Int32 XML_tp = 5416;
const sal_Int32 XML_tpl = 5417;
const sal_Int32 XML_tplc = 5418;
const sal_Int32 XML_tpls = 5419;
const sal_Int32 XML_tr = 5420;
const sal_Int32 XML_tr2bl = 5421;
const sal_Int32 XML_trHeight = 5422;
const sal_Int32 XML_trPr = 5423;
const sal_Int32 XML_trPrChange = 5424;
const sal_Int32 XML_track = 5425;
const sal_Int32 XML_trackRevisions = 5426;
const sal_Int32 XML_trackedChanges = 5427;
const sal_Int32 XML_trans = 5428;
const sal_Int32 XML_transition = 5429;
const sal_Int32 XML_transitionEntry = 5430;
const sal_Int32 XML_transitionEvaluation = 5431;
const sal_Int32 XML_translucentPowder = 5432;
const sal_Int32 XML_transp = 5433;
const sal_Int32 XML_trapezoid = 5434;
const sal_Int32 XML_tree = 5435;
const sal_Int32 XML_trees = 5436;
const sal_Int32 XML_trellis = 5437;
const sal_Int32 XML_trend = 5438;
const sal_Int32 XML_trendline = 5439;
const sal_Int32 XML_trendlineLbl = 5440;
const sal_Int32 XML_trendlineType = 5441;
const sal_Int32 XML_tri = 5442;
const sal_Int32 XML_triangle = 5443;
const sal_Int32 XML_triangleParty = 5444;
const sal_Int32 XML_triangles = 5445;
const sal_Int32 XML_tribal1 = 5446;
const sal_Int32 XML_tribal2 = 5447;
const sal_Int32 XML_tribal3 = 5448;
const sal_Int32 XML_tribal4 = 5449;
const sal_Int32 XML_tribal5 = 5450;
const sal_Int32 XML_tribal6 = 5451;
const sal_Int32 XML_trillions = 5452;
const sal_Int32 XML_trim = 5453;
const sal_Int32 XML_triple = 5454;
const sal_Int32 XML_true = 5455;
const sal_Int32 XML_truncateFontHeightsLikeWP6 = 5456;
const sal_Int32 XML_tupleCache = 5457;
const sal_Int32 XML_turquoise = 5458;
const sal_Int32 XML_twistedLines1 = 5459;
const sal_Int32 XML_twistedLines2 = 5460;
const sal_Int32 XML_twoCell = 5461;
const sal_Int32 XML_twoCellAnchor = 5462;
const sal_Int32 XML_twoColTx = 5463;
const sal_Int32 XML_twoDigitTextYear = 5464;
const sal_Int32 XML_twoObj = 5465;
const sal_Int32 XML_twoObjAndObj = 5466;
const sal_Int32 XML_twoObjAndTx = 5467;
const sal_Int32 XML_twoObjOverTx = 5468;
const sal_Int32 XML_twoPt = 5469;
const sal_Int32 XML_twoTxTwoObj = 5470;
const sal_Int32 XML_tx = 5471;
const sal_Int32 XML_tx1 = 5472;
const sal_Int32 XML_tx2 = 5473;
const sal_Int32 XML_txAnchorHorz = 5474;
const sal_Int32 XML_txAnchorHorzCh = 5475;
const sal_Int32 XML_txAnchorVert = 5476;
const sal_Int32 XML_txAnchorVertCh = 5477;
const sal_Int32 XML_txAndChart = 5478;
const sal_Int32 XML_txAndClipArt = 5479;
const sal_Int32 XML_txAndMedia = 5480;
const sal_Int32 XML_txAndObj = 5481;
const sal_Int32 XML_txAndTwoObj = 5482;
const sal_Int32 XML_txBlDir = 5483;
const sal_Int32 XML_txBody = 5484;
const sal_Int32 XML_txBox = 5485;
const sal_Int32 XML_txDef = 5486;
const sal_Int32 XML_txDir = 5487;
const sal_Int32 XML_txEffectClrLst = 5488;
const sal_Int32 XML_txEl = 5489;
const sal_Int32 XML_txFillClrLst = 5490;
const sal_Int32 XML_txLinClrLst = 5491;
const sal_Int32 XML_txOverObj = 5492;
const sal_Int32 XML_txPr = 5493;
const sal_Int32 XML_txSp = 5494;
const sal_Int32 XML_txStyles = 5495;
const sal_Int32 XML_txXfrm = 5496;
const sal_Int32 XML_txbx = 5497;
const sal_Int32 XML_txbxContent = 5498;
const sal_Int32 XML_txtBox = 5499;
const sal_Int32 XML_ty = 5500;
const sal_Int32 XML_type = 5501;
const sal_Int32 XML_typeAny = 5502;
const sal_Int32 XML_typeface = 5503;
const sal_Int32 XML_types = 5504;
const sal_Int32 XML_u = 5505;
const sal_Int32 XML_uBounds = 5506;
const sal_Int32 XML_uFill = 5507;
const sal_Int32 XML_uFillTx = 5508;
const sal_Int32 XML_uLn = 5509;
const sal_Int32 XML_uLnTx = 5510;
const sal_Int32 XML_ua = 5511;
const sal_Int32 XML_udl = 5512;
const sal_Int32 XML_ui1 = 5513;
const sal_Int32 XML_ui2 = 5514;
const sal_Int32 XML_ui4 = 5515;
const sal_Int32 XML_ui8 = 5516;
const sal_Int32 XML_uiCompat97To2003 = 5517;
const sal_Int32 XML_uiExpand = 5518;
const sal_Int32 XML_uiPriority = 5519;
const sal_Int32 XML_uid = 5520;
const sal_Int32 XML_uint = 5521;
const sal_Int32 XML_ulTrailSpace = 5522;
const sal_Int32 XML_un = 5523;
const sal_Int32 XML_unbalanced = 5524;
const sal_Int32 XML_unbalancedGroup = 5525;
const sal_Int32 XML_unboundColumnsLeft = 5526;
const sal_Int32 XML_unboundColumnsRight = 5527;
const sal_Int32 XML_uncheckedState = 5528;
const sal_Int32 XML_undOvr = 5529;
const sal_Int32 XML_underDot = 5530;
const sal_Int32 XML_underlineTabInNumList = 5531;
const sal_Int32 XML_underscore = 5532;
const sal_Int32 XML_undo = 5533;
const sal_Int32 XML_undone = 5534;
const sal_Int32 XML_undrawn = 5535;
const sal_Int32 XML_ungrouping = 5536;
const sal_Int32 XML_unhideWhenUsed = 5537;
const sal_Int32 XML_uniqueCount = 5538;
const sal_Int32 XML_uniqueId = 5539;
const sal_Int32 XML_uniqueList = 5540;
const sal_Int32 XML_uniqueMemberProperty = 5541;
const sal_Int32 XML_uniqueName = 5542;
const sal_Int32 XML_uniqueParent = 5543;
const sal_Int32 XML_uniqueTag = 5544;
const sal_Int32 XML_uniqueValues = 5545;
const sal_Int32 XML_unknown = 5546;
const sal_Int32 XML_unknownRelationship = 5547;
const sal_Int32 XML_unlocked = 5548;
const sal_Int32 XML_unlockedFormula = 5549;
const sal_Int32 XML_unsignedByte = 5550;
const sal_Int32 XML_unsignedInt = 5551;
const sal_Int32 XML_unsignedLong = 5552;
const sal_Int32 XML_unsignedShort = 5553;
const sal_Int32 XML_up = 5554;
const sal_Int32 XML_upArrow = 5555;
const sal_Int32 XML_upArrowCallout = 5556;
const sal_Int32 XML_upBars = 5557;
const sal_Int32 XML_upDiag = 5558;
const sal_Int32 XML_upDownArrow = 5559;
const sal_Int32 XML_upDownArrowCallout = 5560;
const sal_Int32 XML_upDownBars = 5561;
const sal_Int32 XML_updateAutomatic = 5562;
const sal_Int32 XML_updateFields = 5563;
const sal_Int32 XML_updateLinks = 5564;
const sal_Int32 XML_updatedVersion = 5565;
const sal_Int32 XML_upgradeOnRefresh = 5566;
const sal_Int32 XML_upperLetter = 5567;
const sal_Int32 XML_upperRoman = 5568;
const sal_Int32 XML_upr = 5569;
const sal_Int32 XML_upright = 5570;
const sal_Int32 XML_uri = 5571;
const sal_Int32 XML_url = 5572;
const sal_Int32 XML_usb0 = 5573;
const sal_Int32 XML_usb1 = 5574;
const sal_Int32 XML_usb2 = 5575;
const sal_Int32 XML_usb3 = 5576;
const sal_Int32 XML_useA = 5577;
const sal_Int32 XML_useAltKinsokuLineBreakRules = 5578;
const sal_Int32 XML_useAnsiKerningPairs = 5579;
const sal_Int32 XML_useAutoFormatting = 5580;
const sal_Int32 XML_useBgFill = 5581;
const sal_Int32 XML_useDef = 5582;
const sal_Int32 XML_useFELayout = 5583;
const sal_Int32 XML_useFirstPageNumber = 5584;
const sal_Int32 XML_useLongFilenames = 5585;
const sal_Int32 XML_useNormalStyleForList = 5586;
const sal_Int32 XML_usePrinterDefaults = 5587;
const sal_Int32 XML_usePrinterMetrics = 5588;
const sal_Int32 XML_useSingleBorderforContiguousCells = 5589;
const sal_Int32 XML_useSpRect = 5590;
const sal_Int32 XML_useTimings = 5591;
const sal_Int32 XML_useWord2002TableStyleRules = 5592;
const sal_Int32 XML_useWord97LineBreakRules = 5593;
const sal_Int32 XML_useXSLTWhenSaving = 5594;
const sal_Int32 XML_user = 5595;
const sal_Int32 XML_userA = 5596;
const sal_Int32 XML_userB = 5597;
const sal_Int32 XML_userC = 5598;
const sal_Int32 XML_userD = 5599;
const sal_Int32 XML_userDrawn = 5600;
const sal_Int32 XML_userE = 5601;
const sal_Int32 XML_userF = 5602;
const sal_Int32 XML_userG = 5603;
const sal_Int32 XML_userH = 5604;
const sal_Int32 XML_userI = 5605;
const sal_Int32 XML_userInfo = 5606;
const sal_Int32 XML_userInterface = 5607;
const sal_Int32 XML_userJ = 5608;
const sal_Int32 XML_userK = 5609;
const sal_Int32 XML_userL = 5610;
const sal_Int32 XML_userM = 5611;
const sal_Int32 XML_userN = 5612;
const sal_Int32 XML_userName = 5613;
const sal_Int32 XML_userO = 5614;
const sal_Int32 XML_userP = 5615;
const sal_Int32 XML_userQ = 5616;
const sal_Int32 XML_userR = 5617;
const sal_Int32 XML_userS = 5618;
const sal_Int32 XML_userSet = 5619;
const sal_Int32 XML_userShapes = 5620;
const sal_Int32 XML_userT = 5621;
const sal_Int32 XML_userU = 5622;
const sal_Int32 XML_userV = 5623;
const sal_Int32 XML_userW = 5624;
const sal_Int32 XML_userX = 5625;
const sal_Int32 XML_userY = 5626;
const sal_Int32 XML_userZ = 5627;
const sal_Int32 XML_userdrawn = 5628;
const sal_Int32 XML_userhidden = 5629;
const sal_Int32 XML_users = 5630;
const sal_Int32 XML_uturnArrow = 5631;
const sal_Int32 XML_v = 5632;
const sal_Int32 XML_v2 = 5633;
const sal_Int32 XML_v3 = 5634;
const sal_Int32 XML_v3v4 = 5635;
const sal_Int32 XML_v4 = 5636;
const sal_Int32 XML_vAlign = 5637;
const sal_Int32 XML_vAnchor = 5638;
const sal_Int32 XML_vMerge = 5639;
const sal_Int32 XML_vMergeOrig = 5640;
const sal_Int32 XML_vSpace = 5641;
const sal_Int32 XML_vacatedStyle = 5642;
const sal_Int32 XML_val = 5643;
const sal_Int32 XML_valAx = 5644;
const sal_Int32 XML_value = 5645;
const sal_Int32 XML_valueBetween = 5646;
const sal_Int32 XML_valueEqual = 5647;
const sal_Int32 XML_valueGreaterThan = 5648;
const sal_Int32 XML_valueGreaterThanOrEqual = 5649;
const sal_Int32 XML_valueLessThan = 5650;
const sal_Int32 XML_valueLessThanOrEqual = 5651;
const sal_Int32 XML_valueMetadata = 5652;
const sal_Int32 XML_valueNotBetween = 5653;
const sal_Int32 XML_valueNotEqual = 5654;
const sal_Int32 XML_valueType = 5655;
const sal_Int32 XML_values = 5656;
const sal_Int32 XML_vanish = 5657;
const sal_Int32 XML_var = 5658;
const sal_Int32 XML_varLst = 5659;
const sal_Int32 XML_varP = 5660;
const sal_Int32 XML_varPSubtotal = 5661;
const sal_Int32 XML_varScale = 5662;
const sal_Int32 XML_varSubtotal = 5663;
const sal_Int32 XML_variable = 5664;
const sal_Int32 XML_variant = 5665;
const sal_Int32 XML_varp = 5666;
const sal_Int32 XML_varyColors = 5667;
const sal_Int32 XML_vbProcedure = 5668;
const sal_Int32 XML_vc = 5669;
const sal_Int32 XML_vector = 5670;
const sal_Int32 XML_vendorID = 5671;
const sal_Int32 XML_venn = 5672;
const sal_Int32 XML_verb = 5673;
const sal_Int32 XML_version = 5674;
const sal_Int32 XML_vert = 5675;
const sal_Int32 XML_vert270 = 5676;
const sal_Int32 XML_vertAlign = 5677;
const sal_Int32 XML_vertAnchor = 5678;
const sal_Int32 XML_vertBarState = 5679;
const sal_Int32 XML_vertCompress = 5680;
const sal_Int32 XML_vertJc = 5681;
const sal_Int32 XML_vertOverflow = 5682;
const sal_Int32 XML_vertStripe = 5683;
const sal_Int32 XML_vertTitleAndTx = 5684;
const sal_Int32 XML_vertTitleAndTxOverChart = 5685;
const sal_Int32 XML_vertTx = 5686;
const sal_Int32 XML_vertical = 5687;
const sal_Int32 XML_verticalCentered = 5688;
const sal_Int32 XML_verticalDpi = 5689;
const sal_Int32 XML_verticalScroll = 5690;
const sal_Int32 XML_verticies = 5691;
const sal_Int32 XML_veryHidden = 5692;
const sal_Int32 XML_video = 5693;
const sal_Int32 XML_videoFile = 5694;
const sal_Int32 XML_vietnameseCounting = 5695;
const sal_Int32 XML_view = 5696;
const sal_Int32 XML_view3D = 5697;
const sal_Int32 XML_viewMergedData = 5698;
const sal_Int32 XML_viewPr = 5699;
const sal_Int32 XML_viewpoint = 5700;
const sal_Int32 XML_viewpointorigin = 5701;
const sal_Int32 XML_vine = 5702;
const sal_Int32 XML_violet = 5703;
const sal_Int32 XML_visibility = 5704;
const sal_Int32 XML_visible = 5705;
const sal_Int32 XML_visualTotals = 5706;
const sal_Int32 XML_vm = 5707;
const sal_Int32 XML_vml = 5708;
const sal_Int32 XML_vocabulary = 5709;
const sal_Int32 XML_vol = 5710;
const sal_Int32 XML_volType = 5711;
const sal_Int32 XML_volTypes = 5712;
const sal_Int32 XML_vortex = 5713;
const sal_Int32 XML_vstream = 5714;
const sal_Int32 XML_vt = 5715;
const sal_Int32 XML_w = 5716;
const sal_Int32 XML_w10 = 5717;
const sal_Int32 XML_w14 = 5718;
const sal_Int32 XML_w15 = 5719;
const sal_Int32 XML_wAfter = 5720;
const sal_Int32 XML_wArH = 5721;
const sal_Int32 XML_wBefore = 5722;
const sal_Int32 XML_wMode = 5723;
const sal_Int32 XML_wOff = 5724;
const sal_Int32 XML_wR = 5725;
const sal_Int32 XML_warmMatte = 5726;
const sal_Int32 XML_warning = 5727;
const sal_Int32 XML_warp = 5728;
const sal_Int32 XML_watermarks = 5729;
const sal_Int32 XML_wavAudioFile = 5730;
const sal_Int32 XML_wave = 5731;
const sal_Int32 XML_waveline = 5732;
const sal_Int32 XML_wavy = 5733;
const sal_Int32 XML_wavyDbl = 5734;
const sal_Int32 XML_wavyDouble = 5735;
const sal_Int32 XML_wavyHeavy = 5736;
const sal_Int32 XML_wd = 5737;
const sal_Int32 XML_wd10 = 5738;
const sal_Int32 XML_wd12 = 5739;
const sal_Int32 XML_wd2 = 5740;
const sal_Int32 XML_wd3 = 5741;
const sal_Int32 XML_wd32 = 5742;
const sal_Int32 XML_wd4 = 5743;
const sal_Int32 XML_wd5 = 5744;
const sal_Int32 XML_wd6 = 5745;
const sal_Int32 XML_wd8 = 5746;
const sal_Int32 XML_wdDnDiag = 5747;
const sal_Int32 XML_wdUpDiag = 5748;
const sal_Int32 XML_weave = 5749;
const sal_Int32 XML_weavingAngles = 5750;
const sal_Int32 XML_weavingBraid = 5751;
const sal_Int32 XML_weavingRibbon = 5752;
const sal_Int32 XML_weavingStrips = 5753;
const sal_Int32 XML_web = 5754;
const sal_Int32 XML_webHidden = 5755;
const sal_Int32 XML_webPr = 5756;
const sal_Int32 XML_webPublishItem = 5757;
const sal_Int32 XML_webPublishItems = 5758;
const sal_Int32 XML_webPublishObject = 5759;
const sal_Int32 XML_webPublishObjects = 5760;
const sal_Int32 XML_webPublishing = 5761;
const sal_Int32 XML_webSettings = 5762;
const sal_Int32 XML_wedge = 5763;
const sal_Int32 XML_wedgeEllipseCallout = 5764;
const sal_Int32 XML_wedgeRectCallout = 5765;
const sal_Int32 XML_wedgeRoundRectCallout = 5766;
const sal_Int32 XML_weight = 5767;
const sal_Int32 XML_wgp = 5768;
const sal_Int32 XML_wheat = 5769;
const sal_Int32 XML_wheel = 5770;
const sal_Int32 XML_wheelReverse = 5771;
const sal_Int32 XML_whenNotActive = 5772;
const sal_Int32 XML_white = 5773;
const sal_Int32 XML_whiteFlowers = 5774;
const sal_Int32 XML_whiteSmoke = 5775;
const sal_Int32 XML_whiteTextOnBlack = 5776;
const sal_Int32 XML_whole = 5777;
const sal_Int32 XML_wholeTable = 5778;
const sal_Int32 XML_wholeTbl = 5779;
const sal_Int32 XML_wide = 5780;
const sal_Int32 XML_widowControl = 5781;
const sal_Int32 XML_width = 5782;
const sal_Int32 XML_win = 5783;
const sal_Int32 XML_window = 5784;
const sal_Int32 XML_windowFrame = 5785;
const sal_Int32 XML_windowHeight = 5786;
const sal_Int32 XML_windowProtection = 5787;
const sal_Int32 XML_windowText = 5788;
const sal_Int32 XML_windowWidth = 5789;
const sal_Int32 XML_wipe = 5790;
const sal_Int32 XML_wireFrame = 5791;
const sal_Int32 XML_wireframe = 5792;
const sal_Int32 XML_withEffect = 5793;
const sal_Int32 XML_withGroup = 5794;
const sal_Int32 XML_woodwork = 5795;
const sal_Int32 XML_wordArtVert = 5796;
const sal_Int32 XML_wordArtVertRtl = 5797;
const sal_Int32 XML_wordWrap = 5798;
const sal_Int32 XML_words = 5799;
const sal_Int32 XML_workbook = 5800;
const sal_Int32 XML_workbookParameter = 5801;
const sal_Int32 XML_workbookPassword = 5802;
const sal_Int32 XML_workbookPr = 5803;
const sal_Int32 XML_workbookProtection = 5804;
const sal_Int32 XML_workbookView = 5805;
const sal_Int32 XML_workbookViewId = 5806;
const sal_Int32 XML_worksheet = 5807;
const sal_Int32 XML_worksheetSource = 5808;
const sal_Int32 XML_wp = 5809;
const sal_Int32 XML_wp14 = 5810;
const sal_Int32 XML_wpJustification = 5811;
const sal_Int32 XML_wpSpaceWidth = 5812;
const sal_Int32 XML_wpc = 5813;
const sal_Int32 XML_wpg = 5814;
const sal_Int32 XML_wps = 5815;
const sal_Int32 XML_wrap = 5816;
const sal_Int32 XML_wrapIndent = 5817;
const sal_Int32 XML_wrapNone = 5818;
const sal_Int32 XML_wrapPolygon = 5819;
const sal_Int32 XML_wrapRight = 5820;
const sal_Int32 XML_wrapSquare = 5821;
const sal_Int32 XML_wrapText = 5822;
const sal_Int32 XML_wrapThrough = 5823;
const sal_Int32 XML_wrapTight = 5824;
const sal_Int32 XML_wrapTopAndBottom = 5825;
const sal_Int32 XML_wrapTrailSpaces = 5826;
const sal_Int32 XML_wrapcoords = 5827;
const sal_Int32 XML_writeProtection = 5828;
const sal_Int32 XML_wsDr = 5829;
const sal_Int32 XML_wsp = 5830;
const sal_Int32 XML_x = 5831;
const sal_Int32 XML_x12ac = 5832;
const sal_Int32 XML_x14 = 5833;
const sal_Int32 XML_xAlign = 5834;
const sal_Int32 XML_xIllusions = 5835;
const sal_Int32 XML_xMode = 5836;
const sal_Int32 XML_xSplit = 5837;
const sal_Int32 XML_xVal = 5838;
const sal_Int32 XML_xWindow = 5839;
const sal_Int32 XML_xdr = 5840;
const sal_Int32 XML_xf = 5841;
const sal_Int32 XML_xfDxf = 5842;
const sal_Int32 XML_xfId = 5843;
const sal_Int32 XML_xfrm = 5844;
const sal_Int32 XML_xfrmType = 5845;
const sal_Int32 XML_xl2000 = 5846;
const sal_Int32 XML_xl97 = 5847;
const sal_Int32 XML_xlm = 5848;
const sal_Int32 XML_xm = 5849;
const sal_Int32 XML_xml = 5850;
const sal_Int32 XML_xmlBased = 5851;
const sal_Int32 XML_xmlCellPr = 5852;
const sal_Int32 XML_xmlColumnPr = 5853;
const sal_Int32 XML_xmlDataType = 5854;
const sal_Int32 XML_xmlPr = 5855;
const sal_Int32 XML_xmlns = 5856;
const sal_Int32 XML_xpath = 5857;
const sal_Int32 XML_xr2 = 5858;
const sal_Int32 XML_xr16 = 5859;
const sal_Int32 XML_xrange = 5860;
const sal_Int32 XML_xsc = 5861;
const sal_Int32 XML_xscale = 5862;
const sal_Int32 XML_xsi = 5863;
const sal_Int32 XML_xy = 5864;
const sal_Int32 XML_y = 5865;
const sal_Int32 XML_yAlign = 5866;
const sal_Int32 XML_yMode = 5867;
const sal_Int32 XML_ySplit = 5868;
const sal_Int32 XML_yVal = 5869;
const sal_Int32 XML_yWindow = 5870;
const sal_Int32 XML_year = 5871;
const sal_Int32 XML_yearLong = 5872;
const sal_Int32 XML_yearShort = 5873;
const sal_Int32 XML_yearToDate = 5874;
const sal_Int32 XML_years = 5875;
const sal_Int32 XML_yellow = 5876;
const sal_Int32 XML_yellowGreen = 5877;
const sal_Int32 XML_yesterday = 5878;
const sal_Int32 XML_yrange = 5879;
const sal_Int32 XML_z = 5880;
const sal_Int32 XML_zOrder = 5881;
const sal_Int32 XML_zOrderOff = 5882;
const sal_Int32 XML_zanyTriangles = 5883;
const sal_Int32 XML_zero = 5884;
const sal_Int32 XML_zeroAsc = 5885;
const sal_Int32 XML_zeroDesc = 5886;
const sal_Int32 XML_zeroHeight = 5887;
const sal_Int32 XML_zeroValues = 5888;
const sal_Int32 XML_zeroWid = 5889;
const sal_Int32 XML_zigZag = 5890;
const sal_Int32 XML_zigZagStitch = 5891;
const sal_Int32 XML_zoom = 5892;
const sal_Int32 XML_zoomContents = 5893;
const sal_Int32 XML_zoomScale = 5894;
const sal_Int32 XML_zoomScaleNormal = 5895;
const sal_Int32 XML_zoomScalePageLayoutView = 5896;
const sal_Int32 XML_zoomScaleSheetLayoutView = 5897;
const sal_Int32 XML_zoomToFit = 5898;
const sal_Int32 XML_TOKEN_COUNT = 5899;

const sal_Int32 XML_TOKEN_INVALID = ::com::sun::star::xml::sax::FastToken::DONTKNOW;



} // namespace oox

#endif
