/* Generated by wayland-scanner 1.24.0 */

#ifndef REMOTE_ACCESS_CLIENT_PROTOCOL_H
#define REMOTE_ACCESS_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_remote_access The remote_access protocol
 * @section page_ifaces_remote_access Interfaces
 * - @subpage page_iface_org_kde_kwin_remote_access_manager - Protocol for managing rendered GBM buffers passing
 * - @subpage page_iface_org_kde_kwin_remote_buffer - This interface allows finer control of remote buffer lifecycle
 * @section page_copyright_remote_access Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2016 Oleg Chernovskiy
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_remote_access_manager;
struct org_kde_kwin_remote_buffer;
struct wl_output;

#ifndef ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_INTERFACE
#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_remote_access_manager org_kde_kwin_remote_access_manager
 * @section page_iface_org_kde_kwin_remote_access_manager_desc Description
 * @section page_iface_org_kde_kwin_remote_access_manager_api API
 * See @ref iface_org_kde_kwin_remote_access_manager.
 */
/**
 * @defgroup iface_org_kde_kwin_remote_access_manager The org_kde_kwin_remote_access_manager interface
 */
extern const struct wl_interface org_kde_kwin_remote_access_manager_interface;
#endif
#ifndef ORG_KDE_KWIN_REMOTE_BUFFER_INTERFACE
#define ORG_KDE_KWIN_REMOTE_BUFFER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_remote_buffer org_kde_kwin_remote_buffer
 * @section page_iface_org_kde_kwin_remote_buffer_desc Description
 * @section page_iface_org_kde_kwin_remote_buffer_api API
 * See @ref iface_org_kde_kwin_remote_buffer.
 */
/**
 * @defgroup iface_org_kde_kwin_remote_buffer The org_kde_kwin_remote_buffer interface
 */
extern const struct wl_interface org_kde_kwin_remote_buffer_interface;
#endif

/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 * @struct org_kde_kwin_remote_access_manager_listener
 */
struct org_kde_kwin_remote_access_manager_listener {
	/**
	 * Signals about buffer ready to be consumed by clients
	 *
	 * 
	 * @param id unique id of created buffer (you can use server-side fd number)
	 * @param output screen that this buffer belongs to
	 */
	void (*buffer_ready)(void *data,
			     struct org_kde_kwin_remote_access_manager *org_kde_kwin_remote_access_manager,
			     int32_t id,
			     struct wl_output *output);
};

/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 */
static inline int
org_kde_kwin_remote_access_manager_add_listener(struct org_kde_kwin_remote_access_manager *org_kde_kwin_remote_access_manager,
						const struct org_kde_kwin_remote_access_manager_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_kde_kwin_remote_access_manager,
				     (void (**)(void)) listener, data);
}

#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_GET_BUFFER 0
#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_RELEASE 1

/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 */
#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_BUFFER_READY_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 */
#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_GET_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 */
#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_RELEASE_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_remote_access_manager */
static inline void
org_kde_kwin_remote_access_manager_set_user_data(struct org_kde_kwin_remote_access_manager *org_kde_kwin_remote_access_manager, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_remote_access_manager, user_data);
}

/** @ingroup iface_org_kde_kwin_remote_access_manager */
static inline void *
org_kde_kwin_remote_access_manager_get_user_data(struct org_kde_kwin_remote_access_manager *org_kde_kwin_remote_access_manager)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_remote_access_manager);
}

static inline uint32_t
org_kde_kwin_remote_access_manager_get_version(struct org_kde_kwin_remote_access_manager *org_kde_kwin_remote_access_manager)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_remote_access_manager);
}

/** @ingroup iface_org_kde_kwin_remote_access_manager */
static inline void
org_kde_kwin_remote_access_manager_destroy(struct org_kde_kwin_remote_access_manager *org_kde_kwin_remote_access_manager)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_remote_access_manager);
}

/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 */
static inline struct org_kde_kwin_remote_buffer *
org_kde_kwin_remote_access_manager_get_buffer(struct org_kde_kwin_remote_access_manager *org_kde_kwin_remote_access_manager, int32_t internal_buffer_id)
{
	struct wl_proxy *buffer;

	buffer = wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_remote_access_manager,
			 ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_GET_BUFFER, &org_kde_kwin_remote_buffer_interface, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_remote_access_manager), 0, NULL, internal_buffer_id);

	return (struct org_kde_kwin_remote_buffer *) buffer;
}

/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 */
static inline void
org_kde_kwin_remote_access_manager_release(struct org_kde_kwin_remote_access_manager *org_kde_kwin_remote_access_manager)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_remote_access_manager,
			 ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_remote_access_manager), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_org_kde_kwin_remote_buffer
 * @struct org_kde_kwin_remote_buffer_listener
 */
struct org_kde_kwin_remote_buffer_listener {
	/**
	 * This is sent after binding to remote access manager
	 *
	 * 
	 */
	void (*gbm_handle)(void *data,
			   struct org_kde_kwin_remote_buffer *org_kde_kwin_remote_buffer,
			   int32_t fd,
			   uint32_t width,
			   uint32_t height,
			   uint32_t stride,
			   uint32_t format);
};

/**
 * @ingroup iface_org_kde_kwin_remote_buffer
 */
static inline int
org_kde_kwin_remote_buffer_add_listener(struct org_kde_kwin_remote_buffer *org_kde_kwin_remote_buffer,
					const struct org_kde_kwin_remote_buffer_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_kde_kwin_remote_buffer,
				     (void (**)(void)) listener, data);
}

#define ORG_KDE_KWIN_REMOTE_BUFFER_RELEASE 0

/**
 * @ingroup iface_org_kde_kwin_remote_buffer
 */
#define ORG_KDE_KWIN_REMOTE_BUFFER_GBM_HANDLE_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_remote_buffer
 */
#define ORG_KDE_KWIN_REMOTE_BUFFER_RELEASE_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_remote_buffer */
static inline void
org_kde_kwin_remote_buffer_set_user_data(struct org_kde_kwin_remote_buffer *org_kde_kwin_remote_buffer, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_remote_buffer, user_data);
}

/** @ingroup iface_org_kde_kwin_remote_buffer */
static inline void *
org_kde_kwin_remote_buffer_get_user_data(struct org_kde_kwin_remote_buffer *org_kde_kwin_remote_buffer)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_remote_buffer);
}

static inline uint32_t
org_kde_kwin_remote_buffer_get_version(struct org_kde_kwin_remote_buffer *org_kde_kwin_remote_buffer)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_remote_buffer);
}

/** @ingroup iface_org_kde_kwin_remote_buffer */
static inline void
org_kde_kwin_remote_buffer_destroy(struct org_kde_kwin_remote_buffer *org_kde_kwin_remote_buffer)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_remote_buffer);
}

/**
 * @ingroup iface_org_kde_kwin_remote_buffer
 */
static inline void
org_kde_kwin_remote_buffer_release(struct org_kde_kwin_remote_buffer *org_kde_kwin_remote_buffer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_remote_buffer,
			 ORG_KDE_KWIN_REMOTE_BUFFER_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_remote_buffer), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
