#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1225
#define LARGE_STATE_COUNT 9
#define SYMBOL_COUNT 169
#define ALIAS_COUNT 0
#define TOKEN_COUNT 81
#define EXTERNAL_TOKEN_COUNT 8
#define FIELD_COUNT 37
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 68

enum ts_symbol_identifiers {
  sym_keyword = 1,
  sym_num_literal = 2,
  sym_signed_num_literal = 3,
  sym_ident = 4,
  sym_raw_enum_tag = 5,
  anon_sym_PIPE = 6,
  anon_sym_default = 7,
  anon_sym_force = 8,
  anon_sym_optional = 9,
  anon_sym_priority = 10,
  anon_sym_doc = 11,
  anon_sym_rec = 12,
  anon_sym_not_exported = 13,
  anon_sym_COLON = 14,
  anon_sym_EQ = 15,
  anon_sym_let = 16,
  anon_sym_COMMA = 17,
  anon_sym_in = 18,
  anon_sym_fun = 19,
  anon_sym_EQ_GT = 20,
  anon_sym_match = 21,
  anon_sym_LBRACE = 22,
  anon_sym_RBRACE = 23,
  anon_sym_if = 24,
  anon_sym_then = 25,
  anon_sym_else = 26,
  anon_sym_forall = 27,
  anon_sym_DOT = 28,
  anon_sym_import = 29,
  anon_sym_Array = 30,
  anon_sym_Dyn = 31,
  anon_sym_SEMI = 32,
  anon_sym_LPAREN = 33,
  anon_sym_RPAREN = 34,
  anon_sym_null = 35,
  anon_sym_LBRACK = 36,
  anon_sym_RBRACK = 37,
  anon_sym_DOT_DOT = 38,
  anon_sym_AT = 39,
  anon_sym__ = 40,
  anon_sym_or = 41,
  anon_sym_QMARK = 42,
  anon_sym_true = 43,
  anon_sym_false = 44,
  anon_sym_PERCENT = 45,
  sym_double_quote = 46,
  sym_str_literal = 47,
  sym_mult_str_literal = 48,
  sym_str_esc_char = 49,
  aux_sym_builtin_token1 = 50,
  anon_sym_PLUS_PLUS = 51,
  anon_sym_STAR = 52,
  anon_sym_SLASH = 53,
  anon_sym_PLUS = 54,
  anon_sym_DASH = 55,
  anon_sym_BANG = 56,
  anon_sym_AMP = 57,
  anon_sym_PIPE_GT = 58,
  anon_sym_LT = 59,
  anon_sym_LT_EQ = 60,
  anon_sym_GT = 61,
  anon_sym_GT_EQ = 62,
  anon_sym_EQ_EQ = 63,
  anon_sym_BANG_EQ = 64,
  anon_sym_AMP_AMP = 65,
  anon_sym_PIPE_PIPE = 66,
  anon_sym_DASH_GT = 67,
  anon_sym_Number = 68,
  anon_sym_Bool = 69,
  anon_sym_String = 70,
  anon_sym_LBRACK_PIPE = 71,
  anon_sym_PIPE_RBRACK = 72,
  sym_multstr_start = 73,
  sym_multstr_end = 74,
  sym__str_start = 75,
  sym__str_end = 76,
  sym_interpolation_start = 77,
  sym_interpolation_end = 78,
  sym_quoted_enum_tag_start = 79,
  sym_comment = 80,
  sym_term = 81,
  sym_annot_atom = 82,
  sym_annot = 83,
  sym_types = 84,
  sym_uni_term = 85,
  sym_let_expr = 86,
  sym_let_binding = 87,
  sym_let_in_block = 88,
  sym_fun_expr = 89,
  sym_match_expr = 90,
  sym_ite_expr = 91,
  sym_annotated_infix_expr = 92,
  sym_forall = 93,
  sym_applicative = 94,
  sym_type_array = 95,
  sym_record_operand = 96,
  sym_record_operation_chain = 97,
  sym_row_tail = 98,
  sym_uni_record = 99,
  sym_atom = 100,
  sym_record_field = 101,
  sym_record_last_field = 102,
  sym_field_path = 103,
  sym_field_path_elem = 104,
  sym_last_field_pat = 105,
  sym_last_elem_pat = 106,
  sym_pattern = 107,
  sym_pattern_fun = 108,
  sym_pattern_or_branch = 109,
  sym_constant_pattern = 110,
  sym_record_pattern = 111,
  sym_array_pattern = 112,
  sym_field_pattern = 113,
  sym_enum_variant_pattern = 114,
  sym_enum_pattern_parens = 115,
  sym_enum_pattern = 116,
  sym_or_pattern_unparens = 117,
  sym_or_pattern_parens = 118,
  sym_or_pattern = 119,
  sym_default_annot = 120,
  sym_bool = 121,
  sym_str_chunks = 122,
  sym_str_chunks_single = 123,
  sym_str_chunks_multi = 124,
  sym_chunk_expr = 125,
  sym_static_string = 126,
  sym_quoted_enum_tag = 127,
  sym_enum_tag = 128,
  sym_enum_variant = 129,
  sym_enum = 130,
  sym_chunk_literal_single = 131,
  sym_chunk_literal_multi = 132,
  sym_percent = 133,
  sym_builtin = 134,
  sym_pattern_guard = 135,
  sym_match_branch = 136,
  sym_infix_b_op_2 = 137,
  sym_infix_b_op_3 = 138,
  sym_infix_b_op_4 = 139,
  sym_infix_u_op_5 = 140,
  sym_infix_b_op_6 = 141,
  sym_infix_b_op_7 = 142,
  sym_infix_b_op_8 = 143,
  sym_infix_lazy_b_op_9 = 144,
  sym_infix_lazy_b_op_10 = 145,
  sym_infix_b_op = 146,
  sym_infix_u_op_or_lazy_b_op = 147,
  sym_infix_op = 148,
  sym_curried_op = 149,
  sym_infix_expr = 150,
  sym_type_builtin = 151,
  sym_type_atom = 152,
  aux_sym_annot_repeat1 = 153,
  aux_sym_let_in_block_repeat1 = 154,
  aux_sym_fun_expr_repeat1 = 155,
  aux_sym_match_expr_repeat1 = 156,
  aux_sym_forall_repeat1 = 157,
  aux_sym_uni_record_repeat1 = 158,
  aux_sym_atom_repeat1 = 159,
  aux_sym_field_path_repeat1 = 160,
  aux_sym_record_pattern_repeat1 = 161,
  aux_sym_array_pattern_repeat1 = 162,
  aux_sym_or_pattern_unparens_repeat1 = 163,
  aux_sym_str_chunks_single_repeat1 = 164,
  aux_sym_str_chunks_multi_repeat1 = 165,
  aux_sym_static_string_repeat1 = 166,
  aux_sym_static_string_repeat2 = 167,
  aux_sym_type_atom_repeat1 = 168,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_keyword] = "keyword",
  [sym_num_literal] = "num_literal",
  [sym_signed_num_literal] = "signed_num_literal",
  [sym_ident] = "ident",
  [sym_raw_enum_tag] = "raw_enum_tag",
  [anon_sym_PIPE] = "|",
  [anon_sym_default] = "default",
  [anon_sym_force] = "force",
  [anon_sym_optional] = "optional",
  [anon_sym_priority] = "priority",
  [anon_sym_doc] = "doc",
  [anon_sym_rec] = "rec",
  [anon_sym_not_exported] = "not_exported",
  [anon_sym_COLON] = ":",
  [anon_sym_EQ] = "=",
  [anon_sym_let] = "let",
  [anon_sym_COMMA] = ",",
  [anon_sym_in] = "in",
  [anon_sym_fun] = "fun",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_match] = "match",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_forall] = "forall",
  [anon_sym_DOT] = ".",
  [anon_sym_import] = "import",
  [anon_sym_Array] = "Array",
  [anon_sym_Dyn] = "Dyn",
  [anon_sym_SEMI] = ";",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_null] = "null",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_AT] = "@",
  [anon_sym__] = "_",
  [anon_sym_or] = "or",
  [anon_sym_QMARK] = "\?",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_PERCENT] = "%",
  [sym_double_quote] = "double_quote",
  [sym_str_literal] = "str_literal",
  [sym_mult_str_literal] = "mult_str_literal",
  [sym_str_esc_char] = "str_esc_char",
  [aux_sym_builtin_token1] = "builtin_token1",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_Number] = "Number",
  [anon_sym_Bool] = "Bool",
  [anon_sym_String] = "String",
  [anon_sym_LBRACK_PIPE] = "[|",
  [anon_sym_PIPE_RBRACK] = "|]",
  [sym_multstr_start] = "multstr_start",
  [sym_multstr_end] = "multstr_end",
  [sym__str_start] = "_str_start",
  [sym__str_end] = "_str_end",
  [sym_interpolation_start] = "interpolation_start",
  [sym_interpolation_end] = "interpolation_end",
  [sym_quoted_enum_tag_start] = "quoted_enum_tag_start",
  [sym_comment] = "comment",
  [sym_term] = "term",
  [sym_annot_atom] = "annot_atom",
  [sym_annot] = "annot",
  [sym_types] = "types",
  [sym_uni_term] = "uni_term",
  [sym_let_expr] = "let_expr",
  [sym_let_binding] = "let_binding",
  [sym_let_in_block] = "let_in_block",
  [sym_fun_expr] = "fun_expr",
  [sym_match_expr] = "match_expr",
  [sym_ite_expr] = "ite_expr",
  [sym_annotated_infix_expr] = "annotated_infix_expr",
  [sym_forall] = "forall",
  [sym_applicative] = "applicative",
  [sym_type_array] = "type_array",
  [sym_record_operand] = "record_operand",
  [sym_record_operation_chain] = "record_operation_chain",
  [sym_row_tail] = "row_tail",
  [sym_uni_record] = "uni_record",
  [sym_atom] = "atom",
  [sym_record_field] = "record_field",
  [sym_record_last_field] = "record_last_field",
  [sym_field_path] = "field_path",
  [sym_field_path_elem] = "field_path_elem",
  [sym_last_field_pat] = "last_field_pat",
  [sym_last_elem_pat] = "last_elem_pat",
  [sym_pattern] = "pattern",
  [sym_pattern_fun] = "pattern_fun",
  [sym_pattern_or_branch] = "pattern_or_branch",
  [sym_constant_pattern] = "constant_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_array_pattern] = "array_pattern",
  [sym_field_pattern] = "field_pattern",
  [sym_enum_variant_pattern] = "enum_variant_pattern",
  [sym_enum_pattern_parens] = "enum_pattern_parens",
  [sym_enum_pattern] = "enum_pattern",
  [sym_or_pattern_unparens] = "or_pattern_unparens",
  [sym_or_pattern_parens] = "or_pattern_parens",
  [sym_or_pattern] = "or_pattern",
  [sym_default_annot] = "default_annot",
  [sym_bool] = "bool",
  [sym_str_chunks] = "str_chunks",
  [sym_str_chunks_single] = "str_chunks_single",
  [sym_str_chunks_multi] = "str_chunks_multi",
  [sym_chunk_expr] = "chunk_expr",
  [sym_static_string] = "static_string",
  [sym_quoted_enum_tag] = "quoted_enum_tag",
  [sym_enum_tag] = "enum_tag",
  [sym_enum_variant] = "enum_variant",
  [sym_enum] = "enum",
  [sym_chunk_literal_single] = "chunk_literal_single",
  [sym_chunk_literal_multi] = "chunk_literal_multi",
  [sym_percent] = "percent",
  [sym_builtin] = "builtin",
  [sym_pattern_guard] = "pattern_guard",
  [sym_match_branch] = "match_branch",
  [sym_infix_b_op_2] = "infix_b_op_2",
  [sym_infix_b_op_3] = "infix_b_op_3",
  [sym_infix_b_op_4] = "infix_b_op_4",
  [sym_infix_u_op_5] = "infix_u_op_5",
  [sym_infix_b_op_6] = "infix_b_op_6",
  [sym_infix_b_op_7] = "infix_b_op_7",
  [sym_infix_b_op_8] = "infix_b_op_8",
  [sym_infix_lazy_b_op_9] = "infix_lazy_b_op_9",
  [sym_infix_lazy_b_op_10] = "infix_lazy_b_op_10",
  [sym_infix_b_op] = "infix_b_op",
  [sym_infix_u_op_or_lazy_b_op] = "infix_u_op_or_lazy_b_op",
  [sym_infix_op] = "infix_op",
  [sym_curried_op] = "curried_op",
  [sym_infix_expr] = "infix_expr",
  [sym_type_builtin] = "type_builtin",
  [sym_type_atom] = "type_atom",
  [aux_sym_annot_repeat1] = "annot_repeat1",
  [aux_sym_let_in_block_repeat1] = "let_in_block_repeat1",
  [aux_sym_fun_expr_repeat1] = "fun_expr_repeat1",
  [aux_sym_match_expr_repeat1] = "match_expr_repeat1",
  [aux_sym_forall_repeat1] = "forall_repeat1",
  [aux_sym_uni_record_repeat1] = "uni_record_repeat1",
  [aux_sym_atom_repeat1] = "atom_repeat1",
  [aux_sym_field_path_repeat1] = "field_path_repeat1",
  [aux_sym_record_pattern_repeat1] = "record_pattern_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_or_pattern_unparens_repeat1] = "or_pattern_unparens_repeat1",
  [aux_sym_str_chunks_single_repeat1] = "str_chunks_single_repeat1",
  [aux_sym_str_chunks_multi_repeat1] = "str_chunks_multi_repeat1",
  [aux_sym_static_string_repeat1] = "static_string_repeat1",
  [aux_sym_static_string_repeat2] = "static_string_repeat2",
  [aux_sym_type_atom_repeat1] = "type_atom_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_keyword] = sym_keyword,
  [sym_num_literal] = sym_num_literal,
  [sym_signed_num_literal] = sym_signed_num_literal,
  [sym_ident] = sym_ident,
  [sym_raw_enum_tag] = sym_raw_enum_tag,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_force] = anon_sym_force,
  [anon_sym_optional] = anon_sym_optional,
  [anon_sym_priority] = anon_sym_priority,
  [anon_sym_doc] = anon_sym_doc,
  [anon_sym_rec] = anon_sym_rec,
  [anon_sym_not_exported] = anon_sym_not_exported,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_fun] = anon_sym_fun,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_forall] = anon_sym_forall,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_Array] = anon_sym_Array,
  [anon_sym_Dyn] = anon_sym_Dyn,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_null] = anon_sym_null,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym__] = anon_sym__,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [sym_double_quote] = sym_double_quote,
  [sym_str_literal] = sym_str_literal,
  [sym_mult_str_literal] = sym_mult_str_literal,
  [sym_str_esc_char] = sym_str_esc_char,
  [aux_sym_builtin_token1] = aux_sym_builtin_token1,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_Number] = anon_sym_Number,
  [anon_sym_Bool] = anon_sym_Bool,
  [anon_sym_String] = anon_sym_String,
  [anon_sym_LBRACK_PIPE] = anon_sym_LBRACK_PIPE,
  [anon_sym_PIPE_RBRACK] = anon_sym_PIPE_RBRACK,
  [sym_multstr_start] = sym_multstr_start,
  [sym_multstr_end] = sym_multstr_end,
  [sym__str_start] = sym__str_start,
  [sym__str_end] = sym__str_end,
  [sym_interpolation_start] = sym_interpolation_start,
  [sym_interpolation_end] = sym_interpolation_end,
  [sym_quoted_enum_tag_start] = sym_quoted_enum_tag_start,
  [sym_comment] = sym_comment,
  [sym_term] = sym_term,
  [sym_annot_atom] = sym_annot_atom,
  [sym_annot] = sym_annot,
  [sym_types] = sym_types,
  [sym_uni_term] = sym_uni_term,
  [sym_let_expr] = sym_let_expr,
  [sym_let_binding] = sym_let_binding,
  [sym_let_in_block] = sym_let_in_block,
  [sym_fun_expr] = sym_fun_expr,
  [sym_match_expr] = sym_match_expr,
  [sym_ite_expr] = sym_ite_expr,
  [sym_annotated_infix_expr] = sym_annotated_infix_expr,
  [sym_forall] = sym_forall,
  [sym_applicative] = sym_applicative,
  [sym_type_array] = sym_type_array,
  [sym_record_operand] = sym_record_operand,
  [sym_record_operation_chain] = sym_record_operation_chain,
  [sym_row_tail] = sym_row_tail,
  [sym_uni_record] = sym_uni_record,
  [sym_atom] = sym_atom,
  [sym_record_field] = sym_record_field,
  [sym_record_last_field] = sym_record_last_field,
  [sym_field_path] = sym_field_path,
  [sym_field_path_elem] = sym_field_path_elem,
  [sym_last_field_pat] = sym_last_field_pat,
  [sym_last_elem_pat] = sym_last_elem_pat,
  [sym_pattern] = sym_pattern,
  [sym_pattern_fun] = sym_pattern_fun,
  [sym_pattern_or_branch] = sym_pattern_or_branch,
  [sym_constant_pattern] = sym_constant_pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_array_pattern] = sym_array_pattern,
  [sym_field_pattern] = sym_field_pattern,
  [sym_enum_variant_pattern] = sym_enum_variant_pattern,
  [sym_enum_pattern_parens] = sym_enum_pattern_parens,
  [sym_enum_pattern] = sym_enum_pattern,
  [sym_or_pattern_unparens] = sym_or_pattern_unparens,
  [sym_or_pattern_parens] = sym_or_pattern_parens,
  [sym_or_pattern] = sym_or_pattern,
  [sym_default_annot] = sym_default_annot,
  [sym_bool] = sym_bool,
  [sym_str_chunks] = sym_str_chunks,
  [sym_str_chunks_single] = sym_str_chunks_single,
  [sym_str_chunks_multi] = sym_str_chunks_multi,
  [sym_chunk_expr] = sym_chunk_expr,
  [sym_static_string] = sym_static_string,
  [sym_quoted_enum_tag] = sym_quoted_enum_tag,
  [sym_enum_tag] = sym_enum_tag,
  [sym_enum_variant] = sym_enum_variant,
  [sym_enum] = sym_enum,
  [sym_chunk_literal_single] = sym_chunk_literal_single,
  [sym_chunk_literal_multi] = sym_chunk_literal_multi,
  [sym_percent] = sym_percent,
  [sym_builtin] = sym_builtin,
  [sym_pattern_guard] = sym_pattern_guard,
  [sym_match_branch] = sym_match_branch,
  [sym_infix_b_op_2] = sym_infix_b_op_2,
  [sym_infix_b_op_3] = sym_infix_b_op_3,
  [sym_infix_b_op_4] = sym_infix_b_op_4,
  [sym_infix_u_op_5] = sym_infix_u_op_5,
  [sym_infix_b_op_6] = sym_infix_b_op_6,
  [sym_infix_b_op_7] = sym_infix_b_op_7,
  [sym_infix_b_op_8] = sym_infix_b_op_8,
  [sym_infix_lazy_b_op_9] = sym_infix_lazy_b_op_9,
  [sym_infix_lazy_b_op_10] = sym_infix_lazy_b_op_10,
  [sym_infix_b_op] = sym_infix_b_op,
  [sym_infix_u_op_or_lazy_b_op] = sym_infix_u_op_or_lazy_b_op,
  [sym_infix_op] = sym_infix_op,
  [sym_curried_op] = sym_curried_op,
  [sym_infix_expr] = sym_infix_expr,
  [sym_type_builtin] = sym_type_builtin,
  [sym_type_atom] = sym_type_atom,
  [aux_sym_annot_repeat1] = aux_sym_annot_repeat1,
  [aux_sym_let_in_block_repeat1] = aux_sym_let_in_block_repeat1,
  [aux_sym_fun_expr_repeat1] = aux_sym_fun_expr_repeat1,
  [aux_sym_match_expr_repeat1] = aux_sym_match_expr_repeat1,
  [aux_sym_forall_repeat1] = aux_sym_forall_repeat1,
  [aux_sym_uni_record_repeat1] = aux_sym_uni_record_repeat1,
  [aux_sym_atom_repeat1] = aux_sym_atom_repeat1,
  [aux_sym_field_path_repeat1] = aux_sym_field_path_repeat1,
  [aux_sym_record_pattern_repeat1] = aux_sym_record_pattern_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_or_pattern_unparens_repeat1] = aux_sym_or_pattern_unparens_repeat1,
  [aux_sym_str_chunks_single_repeat1] = aux_sym_str_chunks_single_repeat1,
  [aux_sym_str_chunks_multi_repeat1] = aux_sym_str_chunks_multi_repeat1,
  [aux_sym_static_string_repeat1] = aux_sym_static_string_repeat1,
  [aux_sym_static_string_repeat2] = aux_sym_static_string_repeat2,
  [aux_sym_type_atom_repeat1] = aux_sym_type_atom_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_num_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_signed_num_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_enum_tag] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_force] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_optional] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_priority] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_doc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not_exported] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Dyn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [sym_double_quote] = {
    .visible = true,
    .named = true,
  },
  [sym_str_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_mult_str_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_str_esc_char] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_builtin_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_String] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_multstr_start] = {
    .visible = true,
    .named = true,
  },
  [sym_multstr_end] = {
    .visible = true,
    .named = true,
  },
  [sym__str_start] = {
    .visible = false,
    .named = true,
  },
  [sym__str_end] = {
    .visible = false,
    .named = true,
  },
  [sym_interpolation_start] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation_end] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_enum_tag_start] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_annot_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_annot] = {
    .visible = true,
    .named = true,
  },
  [sym_types] = {
    .visible = true,
    .named = true,
  },
  [sym_uni_term] = {
    .visible = true,
    .named = true,
  },
  [sym_let_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_let_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in_block] = {
    .visible = true,
    .named = true,
  },
  [sym_fun_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_ite_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_annotated_infix_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_applicative] = {
    .visible = true,
    .named = true,
  },
  [sym_type_array] = {
    .visible = true,
    .named = true,
  },
  [sym_record_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_record_operation_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_row_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_uni_record] = {
    .visible = true,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_record_field] = {
    .visible = true,
    .named = true,
  },
  [sym_record_last_field] = {
    .visible = true,
    .named = true,
  },
  [sym_field_path] = {
    .visible = true,
    .named = true,
  },
  [sym_field_path_elem] = {
    .visible = true,
    .named = true,
  },
  [sym_last_field_pat] = {
    .visible = true,
    .named = true,
  },
  [sym_last_elem_pat] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_fun] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_or_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_field_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_variant_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_pattern_parens] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_or_pattern_unparens] = {
    .visible = true,
    .named = true,
  },
  [sym_or_pattern_parens] = {
    .visible = true,
    .named = true,
  },
  [sym_or_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_annot] = {
    .visible = true,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_str_chunks] = {
    .visible = true,
    .named = true,
  },
  [sym_str_chunks_single] = {
    .visible = true,
    .named = true,
  },
  [sym_str_chunks_multi] = {
    .visible = true,
    .named = true,
  },
  [sym_chunk_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_static_string] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_enum_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_variant] = {
    .visible = true,
    .named = true,
  },
  [sym_enum] = {
    .visible = true,
    .named = true,
  },
  [sym_chunk_literal_single] = {
    .visible = true,
    .named = true,
  },
  [sym_chunk_literal_multi] = {
    .visible = true,
    .named = true,
  },
  [sym_percent] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_guard] = {
    .visible = true,
    .named = true,
  },
  [sym_match_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_2] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_3] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_4] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_u_op_5] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_6] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_7] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_8] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_lazy_b_op_9] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_lazy_b_op_10] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_u_op_or_lazy_b_op] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_curried_op] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_type_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_type_atom] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_annot_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_in_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fun_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_forall_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_uni_record_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_atom_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_or_pattern_unparens_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_str_chunks_single_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_str_chunks_multi_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_static_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_static_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_atom_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_ann = 2,
  field_anns = 3,
  field_arg = 4,
  field_binding = 5,
  field_bindings = 6,
  field_body = 7,
  field_cases = 8,
  field_chunks = 9,
  field_cond = 10,
  field_default = 11,
  field_doc = 12,
  field_end = 13,
  field_fields = 14,
  field_guard = 15,
  field_id = 16,
  field_ids = 17,
  field_last = 18,
  field_meta = 19,
  field_op = 20,
  field_pat = 21,
  field_path = 22,
  field_pats = 23,
  field_patterns = 24,
  field_priority = 25,
  field_rows = 26,
  field_s = 27,
  field_start = 28,
  field_t = 29,
  field_t1 = 30,
  field_t2 = 31,
  field_t_id = 32,
  field_tag = 33,
  field_tail = 34,
  field_terms = 35,
  field_ty = 36,
  field_types = 37,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_ann] = "ann",
  [field_anns] = "anns",
  [field_arg] = "arg",
  [field_binding] = "binding",
  [field_bindings] = "bindings",
  [field_body] = "body",
  [field_cases] = "cases",
  [field_chunks] = "chunks",
  [field_cond] = "cond",
  [field_default] = "default",
  [field_doc] = "doc",
  [field_end] = "end",
  [field_fields] = "fields",
  [field_guard] = "guard",
  [field_id] = "id",
  [field_ids] = "ids",
  [field_last] = "last",
  [field_meta] = "meta",
  [field_op] = "op",
  [field_pat] = "pat",
  [field_path] = "path",
  [field_pats] = "pats",
  [field_patterns] = "patterns",
  [field_priority] = "priority",
  [field_rows] = "rows",
  [field_s] = "s",
  [field_start] = "start",
  [field_t] = "t",
  [field_t1] = "t1",
  [field_t2] = "t2",
  [field_t_id] = "t_id",
  [field_tag] = "tag",
  [field_tail] = "tail",
  [field_terms] = "terms",
  [field_ty] = "ty",
  [field_types] = "types",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 2},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 2},
  [9] = {.index = 13, .length = 2},
  [10] = {.index = 15, .length = 1},
  [11] = {.index = 16, .length = 3},
  [12] = {.index = 19, .length = 1},
  [13] = {.index = 20, .length = 1},
  [14] = {.index = 21, .length = 1},
  [15] = {.index = 22, .length = 2},
  [16] = {.index = 24, .length = 2},
  [17] = {.index = 26, .length = 1},
  [18] = {.index = 27, .length = 2},
  [19] = {.index = 29, .length = 1},
  [20] = {.index = 30, .length = 1},
  [21] = {.index = 31, .length = 1},
  [22] = {.index = 32, .length = 2},
  [23] = {.index = 34, .length = 2},
  [24] = {.index = 36, .length = 1},
  [25] = {.index = 37, .length = 3},
  [26] = {.index = 40, .length = 3},
  [27] = {.index = 43, .length = 3},
  [28] = {.index = 46, .length = 1},
  [29] = {.index = 47, .length = 2},
  [30] = {.index = 49, .length = 2},
  [31] = {.index = 51, .length = 1},
  [32] = {.index = 52, .length = 2},
  [33] = {.index = 54, .length = 2},
  [34] = {.index = 56, .length = 2},
  [35] = {.index = 58, .length = 1},
  [36] = {.index = 59, .length = 2},
  [37] = {.index = 61, .length = 3},
  [38] = {.index = 64, .length = 2},
  [39] = {.index = 66, .length = 2},
  [40] = {.index = 68, .length = 2},
  [41] = {.index = 70, .length = 2},
  [42] = {.index = 72, .length = 1},
  [43] = {.index = 73, .length = 1},
  [44] = {.index = 74, .length = 2},
  [45] = {.index = 76, .length = 3},
  [46] = {.index = 79, .length = 1},
  [47] = {.index = 80, .length = 3},
  [48] = {.index = 83, .length = 2},
  [49] = {.index = 85, .length = 3},
  [50] = {.index = 88, .length = 3},
  [51] = {.index = 91, .length = 2},
  [52] = {.index = 93, .length = 2},
  [53] = {.index = 95, .length = 1},
  [54] = {.index = 96, .length = 3},
  [55] = {.index = 99, .length = 4},
  [56] = {.index = 103, .length = 3},
  [57] = {.index = 106, .length = 3},
  [58] = {.index = 109, .length = 3},
  [59] = {.index = 112, .length = 3},
  [60] = {.index = 115, .length = 4},
  [61] = {.index = 119, .length = 4},
  [62] = {.index = 123, .length = 3},
  [63] = {.index = 126, .length = 3},
  [64] = {.index = 129, .length = 4},
  [65] = {.index = 133, .length = 3},
  [66] = {.index = 136, .length = 4},
  [67] = {.index = 140, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_end, 1},
    {field_start, 0},
  [2] =
    {field_pat, 0},
  [3] =
    {field_path, 0},
  [4] =
    {field_s, 1},
  [5] =
    {field_op, 0},
    {field_t, 1},
  [7] =
    {field_binding, 0},
    {field_t2, 1},
  [9] =
    {field_t1, 0},
    {field_t2, 1},
  [11] =
    {field_arg, 1},
    {field_tag, 0},
  [13] =
    {field_meta, 1},
    {field_t, 0},
  [15] =
    {field_anns, 0},
  [16] =
    {field_chunks, 1},
    {field_end, 2},
    {field_start, 0},
  [19] =
    {field_chunks, 1},
  [20] =
    {field_bindings, 1},
  [21] =
    {field_id, 0},
  [22] =
    {field_pat, 1},
    {field_tag, 0},
  [24] =
    {field_last, 1},
    {field_patterns, 0},
  [26] =
    {field_last, 1},
  [27] =
    {field_ann, 1},
    {field_path, 0},
  [29] =
    {field_fields, 1},
  [30] =
    {field_terms, 1},
  [31] =
    {field_rows, 1},
  [32] =
    {field_id, 2},
    {field_t, 0},
  [34] =
    {field_t, 0},
    {field_t_id, 2},
  [36] =
    {field_ty, 1},
  [37] =
    {field_op, 1},
    {field_t1, 0},
    {field_t2, 2},
  [40] =
    {field_end, 2},
    {field_start, 0},
    {field_t, 1},
  [43] =
    {field_alias, 0},
    {field_alias, 1},
    {field_pat, 2},
  [46] =
    {field_bindings, 2},
  [47] =
    {field_anns, 1},
    {field_id, 0},
  [49] =
    {field_default, 1},
    {field_id, 0},
  [51] =
    {field_patterns, 1},
  [52] =
    {field_bindings, 1},
    {field_bindings, 2},
  [54] =
    {field_pat, 0},
    {field_t1, 2},
  [56] =
    {field_pats, 1},
    {field_t, 3},
  [58] =
    {field_cases, 2},
  [59] =
    {field_tail, 1},
    {field_tail, 2},
  [61] =
    {field_path, 0},
    {field_t, 1},
    {field_t, 2},
  [64] =
    {field_fields, 1},
    {field_last, 2},
  [66] =
    {field_ids, 1},
    {field_ty, 3},
  [68] =
    {field_terms, 1},
    {field_terms, 2},
  [70] =
    {field_rows, 1},
    {field_rows, 2},
  [72] =
    {field_priority, 2},
  [73] =
    {field_doc, 2},
  [74] =
    {field_bindings, 2},
    {field_bindings, 3},
  [76] =
    {field_id, 0},
    {field_pat, 1},
    {field_pat, 2},
  [79] =
    {field_t, 1},
  [80] =
    {field_anns, 1},
    {field_default, 2},
    {field_id, 0},
  [83] =
    {field_last, 2},
    {field_patterns, 1},
  [85] =
    {field_bindings, 1},
    {field_bindings, 2},
    {field_bindings, 3},
  [88] =
    {field_meta, 1},
    {field_pat, 0},
    {field_t1, 3},
  [91] =
    {field_body, 2},
    {field_pat, 0},
  [93] =
    {field_cases, 2},
    {field_cases, 3},
  [95] =
    {field_types, 3},
  [96] =
    {field_last, 1},
    {field_tail, 2},
    {field_tail, 3},
  [99] =
    {field_ann, 1},
    {field_path, 0},
    {field_t, 2},
    {field_t, 3},
  [103] =
    {field_fields, 1},
    {field_tail, 2},
    {field_tail, 3},
  [106] =
    {field_terms, 1},
    {field_terms, 2},
    {field_terms, 3},
  [109] =
    {field_rows, 1},
    {field_tail, 2},
    {field_tail, 3},
  [112] =
    {field_bindings, 2},
    {field_bindings, 3},
    {field_bindings, 4},
  [115] =
    {field_anns, 1},
    {field_id, 0},
    {field_pat, 2},
    {field_pat, 3},
  [119] =
    {field_default, 1},
    {field_id, 0},
    {field_pat, 2},
    {field_pat, 3},
  [123] =
    {field_body, 3},
    {field_guard, 1},
    {field_pat, 0},
  [126] =
    {field_cases, 2},
    {field_cases, 3},
    {field_cases, 4},
  [129] =
    {field_fields, 1},
    {field_last, 2},
    {field_tail, 3},
    {field_tail, 4},
  [133] =
    {field_cond, 1},
    {field_t1, 3},
    {field_t2, 5},
  [136] =
    {field_rows, 1},
    {field_rows, 2},
    {field_tail, 3},
    {field_tail, 4},
  [140] =
    {field_anns, 1},
    {field_default, 2},
    {field_id, 0},
    {field_pat, 3},
    {field_pat, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 2,
  [7] = 2,
  [8] = 2,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 11,
  [13] = 11,
  [14] = 11,
  [15] = 11,
  [16] = 11,
  [17] = 11,
  [18] = 18,
  [19] = 19,
  [20] = 18,
  [21] = 19,
  [22] = 19,
  [23] = 18,
  [24] = 18,
  [25] = 19,
  [26] = 19,
  [27] = 19,
  [28] = 18,
  [29] = 18,
  [30] = 19,
  [31] = 18,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 35,
  [38] = 38,
  [39] = 38,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 38,
  [44] = 40,
  [45] = 45,
  [46] = 46,
  [47] = 41,
  [48] = 35,
  [49] = 49,
  [50] = 32,
  [51] = 51,
  [52] = 41,
  [53] = 41,
  [54] = 32,
  [55] = 45,
  [56] = 41,
  [57] = 57,
  [58] = 45,
  [59] = 32,
  [60] = 38,
  [61] = 61,
  [62] = 45,
  [63] = 32,
  [64] = 38,
  [65] = 38,
  [66] = 45,
  [67] = 35,
  [68] = 32,
  [69] = 35,
  [70] = 35,
  [71] = 45,
  [72] = 41,
  [73] = 9,
  [74] = 74,
  [75] = 74,
  [76] = 74,
  [77] = 10,
  [78] = 74,
  [79] = 74,
  [80] = 74,
  [81] = 9,
  [82] = 9,
  [83] = 9,
  [84] = 9,
  [85] = 10,
  [86] = 10,
  [87] = 10,
  [88] = 10,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 129,
  [131] = 131,
  [132] = 131,
  [133] = 131,
  [134] = 131,
  [135] = 131,
  [136] = 129,
  [137] = 129,
  [138] = 138,
  [139] = 129,
  [140] = 138,
  [141] = 131,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 138,
  [147] = 147,
  [148] = 138,
  [149] = 131,
  [150] = 150,
  [151] = 151,
  [152] = 138,
  [153] = 138,
  [154] = 154,
  [155] = 129,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 159,
  [170] = 161,
  [171] = 162,
  [172] = 163,
  [173] = 164,
  [174] = 165,
  [175] = 168,
  [176] = 158,
  [177] = 159,
  [178] = 161,
  [179] = 160,
  [180] = 162,
  [181] = 163,
  [182] = 160,
  [183] = 160,
  [184] = 158,
  [185] = 164,
  [186] = 165,
  [187] = 158,
  [188] = 166,
  [189] = 165,
  [190] = 164,
  [191] = 163,
  [192] = 162,
  [193] = 161,
  [194] = 159,
  [195] = 168,
  [196] = 167,
  [197] = 166,
  [198] = 167,
  [199] = 158,
  [200] = 168,
  [201] = 159,
  [202] = 161,
  [203] = 167,
  [204] = 162,
  [205] = 160,
  [206] = 168,
  [207] = 163,
  [208] = 166,
  [209] = 167,
  [210] = 168,
  [211] = 159,
  [212] = 161,
  [213] = 162,
  [214] = 163,
  [215] = 164,
  [216] = 165,
  [217] = 166,
  [218] = 164,
  [219] = 165,
  [220] = 166,
  [221] = 160,
  [222] = 158,
  [223] = 167,
  [224] = 110,
  [225] = 99,
  [226] = 124,
  [227] = 90,
  [228] = 103,
  [229] = 102,
  [230] = 101,
  [231] = 100,
  [232] = 92,
  [233] = 97,
  [234] = 96,
  [235] = 95,
  [236] = 94,
  [237] = 93,
  [238] = 109,
  [239] = 104,
  [240] = 105,
  [241] = 106,
  [242] = 91,
  [243] = 108,
  [244] = 119,
  [245] = 113,
  [246] = 114,
  [247] = 115,
  [248] = 116,
  [249] = 89,
  [250] = 123,
  [251] = 117,
  [252] = 118,
  [253] = 120,
  [254] = 121,
  [255] = 122,
  [256] = 125,
  [257] = 112,
  [258] = 111,
  [259] = 107,
  [260] = 126,
  [261] = 127,
  [262] = 128,
  [263] = 98,
  [264] = 107,
  [265] = 121,
  [266] = 98,
  [267] = 89,
  [268] = 124,
  [269] = 112,
  [270] = 111,
  [271] = 107,
  [272] = 104,
  [273] = 127,
  [274] = 128,
  [275] = 127,
  [276] = 126,
  [277] = 99,
  [278] = 127,
  [279] = 124,
  [280] = 93,
  [281] = 128,
  [282] = 98,
  [283] = 128,
  [284] = 94,
  [285] = 125,
  [286] = 89,
  [287] = 122,
  [288] = 98,
  [289] = 123,
  [290] = 116,
  [291] = 121,
  [292] = 115,
  [293] = 118,
  [294] = 114,
  [295] = 113,
  [296] = 117,
  [297] = 92,
  [298] = 119,
  [299] = 126,
  [300] = 150,
  [301] = 110,
  [302] = 116,
  [303] = 107,
  [304] = 115,
  [305] = 114,
  [306] = 92,
  [307] = 113,
  [308] = 109,
  [309] = 111,
  [310] = 95,
  [311] = 96,
  [312] = 108,
  [313] = 97,
  [314] = 106,
  [315] = 126,
  [316] = 100,
  [317] = 91,
  [318] = 101,
  [319] = 125,
  [320] = 90,
  [321] = 110,
  [322] = 109,
  [323] = 119,
  [324] = 108,
  [325] = 117,
  [326] = 123,
  [327] = 102,
  [328] = 120,
  [329] = 103,
  [330] = 106,
  [331] = 98,
  [332] = 144,
  [333] = 122,
  [334] = 128,
  [335] = 127,
  [336] = 123,
  [337] = 121,
  [338] = 122,
  [339] = 91,
  [340] = 120,
  [341] = 90,
  [342] = 105,
  [343] = 92,
  [344] = 126,
  [345] = 104,
  [346] = 99,
  [347] = 95,
  [348] = 116,
  [349] = 115,
  [350] = 112,
  [351] = 114,
  [352] = 92,
  [353] = 113,
  [354] = 112,
  [355] = 124,
  [356] = 93,
  [357] = 94,
  [358] = 89,
  [359] = 95,
  [360] = 125,
  [361] = 110,
  [362] = 123,
  [363] = 96,
  [364] = 151,
  [365] = 97,
  [366] = 100,
  [367] = 120,
  [368] = 101,
  [369] = 102,
  [370] = 103,
  [371] = 122,
  [372] = 147,
  [373] = 121,
  [374] = 124,
  [375] = 120,
  [376] = 118,
  [377] = 111,
  [378] = 154,
  [379] = 109,
  [380] = 107,
  [381] = 108,
  [382] = 125,
  [383] = 89,
  [384] = 106,
  [385] = 91,
  [386] = 90,
  [387] = 118,
  [388] = 103,
  [389] = 102,
  [390] = 145,
  [391] = 119,
  [392] = 101,
  [393] = 117,
  [394] = 100,
  [395] = 117,
  [396] = 119,
  [397] = 90,
  [398] = 97,
  [399] = 96,
  [400] = 116,
  [401] = 115,
  [402] = 118,
  [403] = 114,
  [404] = 113,
  [405] = 110,
  [406] = 109,
  [407] = 108,
  [408] = 106,
  [409] = 143,
  [410] = 105,
  [411] = 112,
  [412] = 111,
  [413] = 142,
  [414] = 103,
  [415] = 102,
  [416] = 101,
  [417] = 100,
  [418] = 97,
  [419] = 96,
  [420] = 95,
  [421] = 94,
  [422] = 93,
  [423] = 99,
  [424] = 104,
  [425] = 91,
  [426] = 105,
  [427] = 104,
  [428] = 99,
  [429] = 93,
  [430] = 94,
  [431] = 105,
  [432] = 145,
  [433] = 144,
  [434] = 142,
  [435] = 147,
  [436] = 151,
  [437] = 151,
  [438] = 150,
  [439] = 147,
  [440] = 143,
  [441] = 142,
  [442] = 145,
  [443] = 154,
  [444] = 154,
  [445] = 147,
  [446] = 143,
  [447] = 154,
  [448] = 143,
  [449] = 142,
  [450] = 143,
  [451] = 150,
  [452] = 151,
  [453] = 144,
  [454] = 142,
  [455] = 151,
  [456] = 144,
  [457] = 150,
  [458] = 154,
  [459] = 145,
  [460] = 147,
  [461] = 144,
  [462] = 150,
  [463] = 145,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 464,
  [482] = 478,
  [483] = 479,
  [484] = 484,
  [485] = 485,
  [486] = 484,
  [487] = 484,
  [488] = 464,
  [489] = 484,
  [490] = 464,
  [491] = 491,
  [492] = 484,
  [493] = 464,
  [494] = 491,
  [495] = 491,
  [496] = 491,
  [497] = 491,
  [498] = 464,
  [499] = 491,
  [500] = 484,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 502,
  [505] = 502,
  [506] = 502,
  [507] = 507,
  [508] = 507,
  [509] = 509,
  [510] = 507,
  [511] = 511,
  [512] = 502,
  [513] = 502,
  [514] = 507,
  [515] = 507,
  [516] = 516,
  [517] = 507,
  [518] = 473,
  [519] = 468,
  [520] = 467,
  [521] = 465,
  [522] = 469,
  [523] = 523,
  [524] = 470,
  [525] = 466,
  [526] = 526,
  [527] = 471,
  [528] = 472,
  [529] = 474,
  [530] = 476,
  [531] = 475,
  [532] = 532,
  [533] = 470,
  [534] = 466,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 475,
  [539] = 465,
  [540] = 476,
  [541] = 468,
  [542] = 475,
  [543] = 469,
  [544] = 474,
  [545] = 467,
  [546] = 470,
  [547] = 471,
  [548] = 476,
  [549] = 472,
  [550] = 473,
  [551] = 474,
  [552] = 475,
  [553] = 476,
  [554] = 474,
  [555] = 475,
  [556] = 474,
  [557] = 467,
  [558] = 467,
  [559] = 473,
  [560] = 473,
  [561] = 472,
  [562] = 471,
  [563] = 472,
  [564] = 471,
  [565] = 470,
  [566] = 469,
  [567] = 473,
  [568] = 468,
  [569] = 465,
  [570] = 472,
  [571] = 466,
  [572] = 470,
  [573] = 471,
  [574] = 469,
  [575] = 468,
  [576] = 465,
  [577] = 469,
  [578] = 466,
  [579] = 468,
  [580] = 580,
  [581] = 476,
  [582] = 467,
  [583] = 465,
  [584] = 466,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 592,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 532,
  [598] = 595,
  [599] = 599,
  [600] = 599,
  [601] = 599,
  [602] = 599,
  [603] = 599,
  [604] = 604,
  [605] = 599,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 609,
  [611] = 609,
  [612] = 612,
  [613] = 613,
  [614] = 609,
  [615] = 615,
  [616] = 609,
  [617] = 617,
  [618] = 609,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 624,
  [626] = 90,
  [627] = 89,
  [628] = 91,
  [629] = 144,
  [630] = 89,
  [631] = 91,
  [632] = 90,
  [633] = 150,
  [634] = 634,
  [635] = 635,
  [636] = 635,
  [637] = 635,
  [638] = 635,
  [639] = 635,
  [640] = 635,
  [641] = 635,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 644,
  [646] = 646,
  [647] = 644,
  [648] = 648,
  [649] = 644,
  [650] = 644,
  [651] = 90,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 644,
  [657] = 657,
  [658] = 150,
  [659] = 91,
  [660] = 89,
  [661] = 124,
  [662] = 662,
  [663] = 663,
  [664] = 144,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 644,
  [676] = 676,
  [677] = 677,
  [678] = 124,
  [679] = 91,
  [680] = 89,
  [681] = 681,
  [682] = 90,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 674,
  [693] = 693,
  [694] = 693,
  [695] = 671,
  [696] = 691,
  [697] = 693,
  [698] = 693,
  [699] = 670,
  [700] = 693,
  [701] = 654,
  [702] = 676,
  [703] = 634,
  [704] = 666,
  [705] = 691,
  [706] = 669,
  [707] = 707,
  [708] = 668,
  [709] = 691,
  [710] = 710,
  [711] = 711,
  [712] = 673,
  [713] = 713,
  [714] = 665,
  [715] = 691,
  [716] = 663,
  [717] = 691,
  [718] = 691,
  [719] = 652,
  [720] = 693,
  [721] = 693,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 723,
  [727] = 727,
  [728] = 723,
  [729] = 722,
  [730] = 730,
  [731] = 731,
  [732] = 722,
  [733] = 722,
  [734] = 723,
  [735] = 723,
  [736] = 722,
  [737] = 722,
  [738] = 672,
  [739] = 739,
  [740] = 723,
  [741] = 653,
  [742] = 722,
  [743] = 743,
  [744] = 723,
  [745] = 745,
  [746] = 745,
  [747] = 747,
  [748] = 112,
  [749] = 111,
  [750] = 750,
  [751] = 107,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 750,
  [756] = 745,
  [757] = 745,
  [758] = 750,
  [759] = 759,
  [760] = 760,
  [761] = 745,
  [762] = 745,
  [763] = 763,
  [764] = 753,
  [765] = 750,
  [766] = 753,
  [767] = 117,
  [768] = 768,
  [769] = 750,
  [770] = 750,
  [771] = 750,
  [772] = 772,
  [773] = 753,
  [774] = 774,
  [775] = 750,
  [776] = 753,
  [777] = 753,
  [778] = 119,
  [779] = 750,
  [780] = 745,
  [781] = 745,
  [782] = 745,
  [783] = 753,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 788,
  [791] = 788,
  [792] = 784,
  [793] = 784,
  [794] = 784,
  [795] = 785,
  [796] = 786,
  [797] = 786,
  [798] = 785,
  [799] = 786,
  [800] = 800,
  [801] = 785,
  [802] = 785,
  [803] = 786,
  [804] = 804,
  [805] = 788,
  [806] = 786,
  [807] = 788,
  [808] = 784,
  [809] = 785,
  [810] = 788,
  [811] = 785,
  [812] = 784,
  [813] = 788,
  [814] = 788,
  [815] = 784,
  [816] = 786,
  [817] = 784,
  [818] = 785,
  [819] = 786,
  [820] = 785,
  [821] = 788,
  [822] = 784,
  [823] = 786,
  [824] = 784,
  [825] = 786,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 829,
  [831] = 829,
  [832] = 832,
  [833] = 833,
  [834] = 829,
  [835] = 835,
  [836] = 836,
  [837] = 829,
  [838] = 829,
  [839] = 839,
  [840] = 683,
  [841] = 833,
  [842] = 829,
  [843] = 827,
  [844] = 684,
  [845] = 684,
  [846] = 683,
  [847] = 847,
  [848] = 684,
  [849] = 683,
  [850] = 683,
  [851] = 684,
  [852] = 852,
  [853] = 828,
  [854] = 854,
  [855] = 832,
  [856] = 683,
  [857] = 684,
  [858] = 828,
  [859] = 826,
  [860] = 828,
  [861] = 861,
  [862] = 101,
  [863] = 122,
  [864] = 864,
  [865] = 118,
  [866] = 121,
  [867] = 100,
  [868] = 868,
  [869] = 103,
  [870] = 97,
  [871] = 96,
  [872] = 864,
  [873] = 95,
  [874] = 94,
  [875] = 93,
  [876] = 864,
  [877] = 99,
  [878] = 104,
  [879] = 864,
  [880] = 105,
  [881] = 861,
  [882] = 98,
  [883] = 102,
  [884] = 128,
  [885] = 106,
  [886] = 864,
  [887] = 127,
  [888] = 888,
  [889] = 768,
  [890] = 116,
  [891] = 126,
  [892] = 847,
  [893] = 115,
  [894] = 864,
  [895] = 114,
  [896] = 108,
  [897] = 861,
  [898] = 861,
  [899] = 113,
  [900] = 109,
  [901] = 861,
  [902] = 110,
  [903] = 861,
  [904] = 861,
  [905] = 125,
  [906] = 864,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 911,
  [913] = 910,
  [914] = 914,
  [915] = 914,
  [916] = 916,
  [917] = 657,
  [918] = 908,
  [919] = 910,
  [920] = 920,
  [921] = 921,
  [922] = 914,
  [923] = 923,
  [924] = 924,
  [925] = 144,
  [926] = 926,
  [927] = 908,
  [928] = 150,
  [929] = 929,
  [930] = 923,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 933,
  [935] = 916,
  [936] = 923,
  [937] = 926,
  [938] = 933,
  [939] = 923,
  [940] = 933,
  [941] = 941,
  [942] = 914,
  [943] = 923,
  [944] = 932,
  [945] = 908,
  [946] = 929,
  [947] = 916,
  [948] = 948,
  [949] = 926,
  [950] = 950,
  [951] = 910,
  [952] = 914,
  [953] = 932,
  [954] = 911,
  [955] = 955,
  [956] = 910,
  [957] = 957,
  [958] = 958,
  [959] = 911,
  [960] = 960,
  [961] = 932,
  [962] = 962,
  [963] = 923,
  [964] = 926,
  [965] = 965,
  [966] = 932,
  [967] = 916,
  [968] = 911,
  [969] = 969,
  [970] = 911,
  [971] = 929,
  [972] = 921,
  [973] = 655,
  [974] = 929,
  [975] = 643,
  [976] = 976,
  [977] = 926,
  [978] = 662,
  [979] = 910,
  [980] = 908,
  [981] = 932,
  [982] = 926,
  [983] = 908,
  [984] = 916,
  [985] = 916,
  [986] = 646,
  [987] = 648,
  [988] = 929,
  [989] = 932,
  [990] = 926,
  [991] = 916,
  [992] = 667,
  [993] = 929,
  [994] = 933,
  [995] = 923,
  [996] = 933,
  [997] = 910,
  [998] = 998,
  [999] = 999,
  [1000] = 929,
  [1001] = 914,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1005,
  [1007] = 1005,
  [1008] = 1003,
  [1009] = 1005,
  [1010] = 1010,
  [1011] = 1005,
  [1012] = 1005,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1014,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1014,
  [1019] = 1019,
  [1020] = 1003,
  [1021] = 1014,
  [1022] = 1014,
  [1023] = 1023,
  [1024] = 1010,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1014,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1010,
  [1034] = 1003,
  [1035] = 1010,
  [1036] = 1003,
  [1037] = 1003,
  [1038] = 1025,
  [1039] = 1010,
  [1040] = 1010,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1003,
  [1044] = 1005,
  [1045] = 1010,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 689,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 690,
  [1057] = 688,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1062,
  [1064] = 1061,
  [1065] = 1060,
  [1066] = 1066,
  [1067] = 1050,
  [1068] = 1061,
  [1069] = 1059,
  [1070] = 1070,
  [1071] = 1058,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1055,
  [1075] = 1075,
  [1076] = 1049,
  [1077] = 1077,
  [1078] = 1049,
  [1079] = 1075,
  [1080] = 1073,
  [1081] = 1077,
  [1082] = 1070,
  [1083] = 1050,
  [1084] = 1048,
  [1085] = 1050,
  [1086] = 1055,
  [1087] = 1055,
  [1088] = 1048,
  [1089] = 1089,
  [1090] = 1058,
  [1091] = 1059,
  [1092] = 1060,
  [1093] = 1061,
  [1094] = 1062,
  [1095] = 1062,
  [1096] = 1061,
  [1097] = 1060,
  [1098] = 1058,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1058,
  [1103] = 1077,
  [1104] = 1104,
  [1105] = 1055,
  [1106] = 1077,
  [1107] = 1049,
  [1108] = 1075,
  [1109] = 1109,
  [1110] = 1070,
  [1111] = 1048,
  [1112] = 1050,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1050,
  [1117] = 1048,
  [1118] = 1070,
  [1119] = 1073,
  [1120] = 1075,
  [1121] = 1049,
  [1122] = 1077,
  [1123] = 1123,
  [1124] = 1052,
  [1125] = 1077,
  [1126] = 1070,
  [1127] = 1127,
  [1128] = 1049,
  [1129] = 1073,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1075,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1048,
  [1138] = 1066,
  [1139] = 1055,
  [1140] = 1072,
  [1141] = 1077,
  [1142] = 1142,
  [1143] = 1075,
  [1144] = 1127,
  [1145] = 1073,
  [1146] = 1058,
  [1147] = 1130,
  [1148] = 1059,
  [1149] = 1135,
  [1150] = 1150,
  [1151] = 1101,
  [1152] = 1113,
  [1153] = 1115,
  [1154] = 1072,
  [1155] = 1132,
  [1156] = 1142,
  [1157] = 1142,
  [1158] = 1127,
  [1159] = 1070,
  [1160] = 1070,
  [1161] = 1130,
  [1162] = 1162,
  [1163] = 1135,
  [1164] = 1130,
  [1165] = 1060,
  [1166] = 1061,
  [1167] = 1062,
  [1168] = 1072,
  [1169] = 1048,
  [1170] = 1142,
  [1171] = 1162,
  [1172] = 1127,
  [1173] = 685,
  [1174] = 1050,
  [1175] = 1130,
  [1176] = 1135,
  [1177] = 1135,
  [1178] = 1073,
  [1179] = 1060,
  [1180] = 1061,
  [1181] = 1181,
  [1182] = 1072,
  [1183] = 1183,
  [1184] = 1142,
  [1185] = 1185,
  [1186] = 1127,
  [1187] = 686,
  [1188] = 1188,
  [1189] = 1130,
  [1190] = 1062,
  [1191] = 1135,
  [1192] = 1123,
  [1193] = 613,
  [1194] = 615,
  [1195] = 1075,
  [1196] = 1072,
  [1197] = 608,
  [1198] = 1142,
  [1199] = 1127,
  [1200] = 1130,
  [1201] = 619,
  [1202] = 1135,
  [1203] = 607,
  [1204] = 620,
  [1205] = 622,
  [1206] = 1072,
  [1207] = 687,
  [1208] = 1142,
  [1209] = 1055,
  [1210] = 1210,
  [1211] = 1059,
  [1212] = 1210,
  [1213] = 1062,
  [1214] = 1210,
  [1215] = 1058,
  [1216] = 1210,
  [1217] = 1059,
  [1218] = 1210,
  [1219] = 1060,
  [1220] = 621,
  [1221] = 1221,
  [1222] = 1049,
  [1223] = 1210,
  [1224] = 1224,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(96);
      ADVANCE_MAP(
        '!', 232,
        '"', 219,
        '%', 218,
        '&', 233,
        '\'', 21,
        '(', 207,
        ')', 208,
        '*', 228,
        '+', 230,
        ',', 198,
        '-', 231,
        '.', 203,
        '/', 229,
        '0', 99,
        ':', 194,
        ';', 206,
        '<', 235,
        '=', 196,
        '>', 237,
        '?', 217,
        '@', 213,
        'A', 170,
        'B', 152,
        'D', 185,
        'N', 181,
        'S', 178,
        '[', 210,
        '\\', 92,
        ']', 211,
        '_', 214,
        'd', 124,
        'e', 141,
        'f', 114,
        'i', 146,
        'l', 129,
        'm', 118,
        'n', 154,
        'o', 160,
        'p', 163,
        'r', 125,
        't', 136,
        '{', 200,
        '|', 191,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(100);
      if (('C' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 17,
        '%', 218,
        '&', 233,
        '\'', 21,
        '(', 207,
        ')', 208,
        '*', 228,
        '+', 230,
        ',', 198,
        '-', 231,
        '.', 203,
        '/', 229,
        '0', 99,
        ':', 194,
        ';', 206,
        '<', 235,
        '=', 196,
        '>', 237,
        '?', 217,
        '@', 213,
        'B', 152,
        'D', 185,
        'N', 181,
        'S', 178,
        '[', 210,
        ']', 211,
        '_', 214,
        'd', 124,
        'e', 141,
        'f', 114,
        'i', 146,
        'l', 129,
        'm', 118,
        'n', 154,
        'o', 161,
        'p', 163,
        'r', 125,
        't', 136,
        '{', 200,
        '|', 191,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(100);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(219);
      if (lookahead == '%') ADVANCE(218);
      if (lookahead == '\\') ADVANCE(222);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(223);
      if (lookahead != 0) ADVANCE(224);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '%', 218,
        '\'', 21,
        '(', 207,
        ',', 198,
        '.', 86,
        '0', 99,
        ';', 206,
        '=', 195,
        '?', 217,
        'B', 152,
        'D', 185,
        'N', 181,
        'S', 178,
        '[', 210,
        '_', 214,
        'd', 124,
        'e', 141,
        'f', 114,
        'i', 146,
        'l', 129,
        'm', 118,
        'n', 154,
        'o', 161,
        'p', 163,
        'r', 125,
        't', 136,
        '{', 200,
        '|', 20,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(100);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 4:
      if (lookahead == '%') ADVANCE(218);
      if (lookahead == '\\') ADVANCE(92);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(220);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(221);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '\'', 21,
        '(', 207,
        ',', 198,
        '-', 16,
        '.', 14,
        '0', 106,
        '=', 18,
        '@', 213,
        '[', 209,
        ']', 211,
        '_', 214,
        'd', 124,
        'e', 141,
        'f', 114,
        'i', 146,
        'l', 129,
        'm', 118,
        'n', 154,
        'o', 161,
        'p', 163,
        'r', 125,
        't', 136,
        '{', 200,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(107);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '\'', 21,
        '(', 207,
        ',', 198,
        '-', 16,
        '.', 88,
        '0', 106,
        ':', 194,
        ';', 206,
        '=', 195,
        '?', 217,
        '[', 209,
        ']', 211,
        '_', 214,
        'd', 124,
        'e', 141,
        'f', 114,
        'i', 146,
        'l', 129,
        'm', 118,
        'n', 154,
        'o', 160,
        'p', 163,
        'r', 125,
        't', 136,
        '{', 200,
        '|', 190,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(107);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '\'', 21,
        '(', 207,
        '-', 16,
        '.', 88,
        '0', 106,
        '=', 18,
        '[', 209,
        '_', 214,
        'd', 124,
        'e', 141,
        'f', 114,
        'i', 146,
        'l', 129,
        'm', 118,
        'n', 154,
        'o', 160,
        'p', 163,
        'r', 125,
        't', 136,
        '{', 200,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(107);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        ')', 208,
        ',', 198,
        '.', 202,
        ':', 194,
        ';', 206,
        '=', 197,
        ']', 211,
        'd', 33,
        'e', 47,
        'f', 25,
        'i', 51,
        'l', 37,
        'm', 27,
        'n', 55,
        'o', 60,
        'p', 64,
        'r', 34,
        't', 43,
        '|', 193,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      END_STATE();
    case 9:
      if (lookahead == ')') ADVANCE(208);
      if (lookahead == '_') ADVANCE(23);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(226);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        ',', 198,
        '.', 202,
        ':', 194,
        ';', 206,
        '=', 195,
        '@', 213,
        ']', 211,
        'o', 63,
        '|', 190,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        ',', 198,
        '.', 202,
        ':', 194,
        ';', 206,
        '=', 195,
        '_', 22,
        '|', 193,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        ',', 198,
        '.', 202,
        ';', 206,
        '=', 18,
        '@', 213,
        'd', 33,
        'e', 47,
        'f', 25,
        'i', 51,
        'l', 37,
        'm', 27,
        'n', 55,
        'o', 60,
        'p', 64,
        'r', 34,
        't', 43,
        '|', 20,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(212);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(108);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(13);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == ']') ADVANCE(211);
      if (lookahead == '_') ADVANCE(214);
      if (lookahead == '}') ADVANCE(201);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(88);
      if (lookahead == '0') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 17:
      if (lookahead == '=') ADVANCE(240);
      END_STATE();
    case 18:
      if (lookahead == '>') ADVANCE(199);
      END_STATE();
    case 19:
      if (lookahead == 'D') ADVANCE(185);
      if (lookahead == '_') ADVANCE(22);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 20:
      if (lookahead == ']') ADVANCE(248);
      END_STATE();
    case 21:
      if (lookahead == '_') ADVANCE(21);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(189);
      END_STATE();
    case 22:
      if (lookahead == '_') ADVANCE(22);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(23);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(226);
      END_STATE();
    case 24:
      if (lookahead == '_') ADVANCE(38);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(65);
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'c') ADVANCE(36);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(73);
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(48);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(97);
      END_STATE();
    case 31:
      if (lookahead == 'c') ADVANCE(42);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(97);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(40);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 40:
      if (lookahead == 'f') ADVANCE(28);
      END_STATE();
    case 41:
      if (lookahead == 'g') ADVANCE(36);
      END_STATE();
    case 42:
      if (lookahead == 'h') ADVANCE(97);
      END_STATE();
    case 43:
      if (lookahead == 'h') ADVANCE(35);
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 44:
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 45:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(72);
      END_STATE();
    case 47:
      if (lookahead == 'l') ADVANCE(69);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(97);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 50:
      if (lookahead == 'l') ADVANCE(48);
      END_STATE();
    case 51:
      if (lookahead == 'm') ADVANCE(59);
      if (lookahead == 'f' ||
          lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 52:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 53:
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 54:
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 55:
      if (lookahead == 'o') ADVANCE(71);
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 56:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 57:
      if (lookahead == 'o') ADVANCE(68);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(67);
      END_STATE();
    case 59:
      if (lookahead == 'p') ADVANCE(56);
      END_STATE();
    case 60:
      if (lookahead == 'p') ADVANCE(75);
      if (lookahead == 'r') ADVANCE(215);
      END_STATE();
    case 61:
      if (lookahead == 'p') ADVANCE(57);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 63:
      if (lookahead == 'r') ADVANCE(215);
      END_STATE();
    case 64:
      if (lookahead == 'r') ADVANCE(44);
      END_STATE();
    case 65:
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 68:
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 69:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 70:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(24);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 74:
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 76:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 77:
      if (lookahead == 'u') ADVANCE(36);
      END_STATE();
    case 78:
      if (lookahead == 'x') ADVANCE(61);
      END_STATE();
    case 79:
      if (lookahead == 'y') ADVANCE(97);
      END_STATE();
    case 80:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(104);
      END_STATE();
    case 81:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      END_STATE();
    case 82:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(102);
      END_STATE();
    case 83:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(109);
      END_STATE();
    case 84:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      END_STATE();
    case 85:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(110);
      END_STATE();
    case 86:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      END_STATE();
    case 87:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(104);
      END_STATE();
    case 88:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(108);
      END_STATE();
    case 89:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      END_STATE();
    case 90:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(105);
      END_STATE();
    case 91:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(112);
      END_STATE();
    case 92:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(225);
      END_STATE();
    case 93:
      if (eof) ADVANCE(96);
      ADVANCE_MAP(
        '!', 232,
        '%', 218,
        '&', 233,
        '\'', 21,
        '(', 207,
        ')', 208,
        '*', 228,
        '+', 230,
        ',', 198,
        '-', 231,
        '.', 203,
        '/', 229,
        '0', 99,
        ':', 194,
        ';', 206,
        '<', 235,
        '=', 196,
        '>', 237,
        '?', 217,
        '@', 213,
        'A', 170,
        'B', 152,
        'D', 185,
        'N', 181,
        'S', 178,
        '[', 210,
        ']', 211,
        '_', 214,
        'd', 124,
        'e', 141,
        'f', 114,
        'i', 146,
        'l', 129,
        'm', 118,
        'n', 154,
        'o', 161,
        'p', 163,
        'r', 125,
        't', 136,
        '{', 200,
        '|', 192,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(93);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(100);
      if (('C' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 94:
      if (eof) ADVANCE(96);
      ADVANCE_MAP(
        '!', 17,
        '%', 218,
        '&', 233,
        '\'', 21,
        '(', 207,
        ')', 208,
        '*', 228,
        '+', 230,
        ',', 198,
        '-', 231,
        '.', 203,
        '/', 229,
        '0', 99,
        ':', 194,
        ';', 206,
        '<', 235,
        '=', 196,
        '>', 237,
        '?', 217,
        '@', 213,
        'B', 152,
        'D', 185,
        'N', 181,
        'S', 178,
        '[', 210,
        ']', 211,
        '_', 214,
        'd', 124,
        'e', 141,
        'f', 114,
        'i', 146,
        'l', 129,
        'm', 118,
        'n', 154,
        'o', 161,
        'p', 163,
        'r', 125,
        't', 136,
        '{', 200,
        '|', 192,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(94);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(100);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 95:
      if (eof) ADVANCE(96);
      ADVANCE_MAP(
        '!', 17,
        '%', 218,
        '&', 233,
        ')', 208,
        '*', 228,
        '+', 230,
        ',', 198,
        '-', 231,
        '/', 229,
        ':', 194,
        ';', 206,
        '<', 235,
        '=', 196,
        '>', 237,
        '?', 217,
        '@', 213,
        ']', 211,
        'd', 33,
        'e', 47,
        'f', 25,
        'i', 51,
        'l', 37,
        'm', 27,
        'n', 55,
        'o', 60,
        'p', 64,
        'r', 34,
        't', 43,
        '|', 192,
        '}', 201,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_keyword);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_num_literal);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == 'b') ADVANCE(82);
      if (lookahead == 'o') ADVANCE(84);
      if (lookahead == 'x') ADVANCE(90);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(100);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_num_literal);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(100);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_num_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_num_literal);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(102);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_num_literal);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_num_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(104);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_num_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(105);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_signed_num_literal);
      if (lookahead == '.') ADVANCE(88);
      if (lookahead == 'b') ADVANCE(83);
      if (lookahead == 'o') ADVANCE(85);
      if (lookahead == 'x') ADVANCE(91);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_signed_num_literal);
      if (lookahead == '.') ADVANCE(88);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_signed_num_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(108);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_signed_num_literal);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(109);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_signed_num_literal);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_signed_num_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_signed_num_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(112);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '_') ADVANCE(127);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(141);
      if (lookahead == 'o') ADVANCE(165);
      if (lookahead == 'u') ADVANCE(148);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(145);
      if (lookahead == 'c') ADVANCE(126);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(183);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(176);
      if (lookahead == 'e') ADVANCE(166);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(142);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'b') ADVANCE(131);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(135);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'd') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'o') ADVANCE(121);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(121);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(184);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(123);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'f') ADVANCE(117);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'g') ADVANCE(246);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'g') ADVANCE(126);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'h') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'h') ADVANCE(130);
      if (lookahead == 'r') ADVANCE(182);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(150);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(177);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(157);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(173);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(245);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(142);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(159);
      if (lookahead == 'f' ||
          lookahead == 'n') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(120);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(205);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(133);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(119);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(153);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(143);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(175);
      if (lookahead == 'u') ADVANCE(145);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(151);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(168);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(171);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(172);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'p') ADVANCE(156);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'p') ADVANCE(180);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'p') ADVANCE(180);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'p') ADVANCE(158);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(140);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(115);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(116);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(134);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(244);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(137);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(164);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(139);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(179);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(126);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(113);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(122);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(186);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(169);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(128);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(138);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(147);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(126);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(144);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'x') ADVANCE(162);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(149);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(204);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_raw_enum_tag);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(189);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(234);
      if (lookahead == ']') ADVANCE(248);
      if (lookahead == '|') ADVANCE(242);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(234);
      if (lookahead == '|') ADVANCE(242);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == ']') ADVANCE(248);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(239);
      if (lookahead == '>') ADVANCE(199);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(199);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_Array);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_Dyn);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '|') ADVANCE(247);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '_') ADVANCE(22);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_double_quote);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_str_literal);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(220);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(221);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_str_literal);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(221);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_mult_str_literal);
      if (lookahead == '\n') ADVANCE(224);
      if (lookahead == '"' ||
          lookahead == '%') ADVANCE(225);
      if (lookahead != 0) ADVANCE(224);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_mult_str_literal);
      if (lookahead == '\\') ADVANCE(222);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(223);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%') ADVANCE(224);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_mult_str_literal);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%') ADVANCE(224);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_str_esc_char);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(aux_sym_builtin_token1);
      if (lookahead == '\'' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(226);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(227);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(243);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(240);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(241);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(236);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(238);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_Number);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_Bool);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_String);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(188);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_LBRACK_PIPE);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACK);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'd', 1,
        'e', 2,
        'f', 3,
        'i', 4,
        'l', 5,
        'm', 6,
        'n', 7,
        'o', 8,
        'p', 9,
        'r', 10,
        't', 11,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'e') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(13);
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(14);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'u') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'f') ADVANCE(18);
      if (lookahead == 'm') ADVANCE(19);
      if (lookahead == 'n') ADVANCE(20);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'u') ADVANCE(24);
      END_STATE();
    case 8:
      if (lookahead == 'p') ADVANCE(25);
      END_STATE();
    case 9:
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(27);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(30);
      END_STATE();
    case 13:
      if (lookahead == 'c') ADVANCE(31);
      END_STATE();
    case 14:
      if (lookahead == 's') ADVANCE(32);
      END_STATE();
    case 15:
      if (lookahead == 'l') ADVANCE(33);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(34);
      END_STATE();
    case 17:
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 19:
      if (lookahead == 'p') ADVANCE(36);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 21:
      if (lookahead == 't') ADVANCE(37);
      END_STATE();
    case 22:
      if (lookahead == 't') ADVANCE(38);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 24:
      if (lookahead == 'l') ADVANCE(40);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(42);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(43);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 29:
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(46);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_doc);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(48);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'c') ADVANCE(50);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_fun);
      END_STATE();
    case 36:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 38:
      if (lookahead == 'c') ADVANCE(52);
      END_STATE();
    case 39:
      if (lookahead == '_') ADVANCE(53);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(54);
      END_STATE();
    case 41:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_rec);
      END_STATE();
    case 44:
      if (lookahead == 'n') ADVANCE(57);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 46:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(61);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(63);
      END_STATE();
    case 52:
      if (lookahead == 'h') ADVANCE(64);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_null);
      END_STATE();
    case 55:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 59:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 61:
      if (lookahead == 'l') ADVANCE(69);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_force);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 65:
      if (lookahead == 'x') ADVANCE(71);
      END_STATE();
    case 66:
      if (lookahead == 'n') ADVANCE(72);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(73);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(74);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_forall);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 71:
      if (lookahead == 'p') ADVANCE(75);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 75:
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 76:
      if (lookahead == 'l') ADVANCE(79);
      END_STATE();
    case 77:
      if (lookahead == 'y') ADVANCE(80);
      END_STATE();
    case 78:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_optional);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_priority);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 83:
      if (lookahead == 'd') ADVANCE(84);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_not_exported);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 93, .external_lex_state = 2},
  [2] = {.lex_state = 93, .external_lex_state = 2},
  [3] = {.lex_state = 93, .external_lex_state = 2},
  [4] = {.lex_state = 93, .external_lex_state = 2},
  [5] = {.lex_state = 93, .external_lex_state = 2},
  [6] = {.lex_state = 93, .external_lex_state = 2},
  [7] = {.lex_state = 93, .external_lex_state = 2},
  [8] = {.lex_state = 93, .external_lex_state = 2},
  [9] = {.lex_state = 94, .external_lex_state = 2},
  [10] = {.lex_state = 94, .external_lex_state = 2},
  [11] = {.lex_state = 93, .external_lex_state = 2},
  [12] = {.lex_state = 93, .external_lex_state = 2},
  [13] = {.lex_state = 93, .external_lex_state = 2},
  [14] = {.lex_state = 93, .external_lex_state = 2},
  [15] = {.lex_state = 93, .external_lex_state = 2},
  [16] = {.lex_state = 93, .external_lex_state = 2},
  [17] = {.lex_state = 93, .external_lex_state = 2},
  [18] = {.lex_state = 93, .external_lex_state = 2},
  [19] = {.lex_state = 93, .external_lex_state = 2},
  [20] = {.lex_state = 93, .external_lex_state = 2},
  [21] = {.lex_state = 93, .external_lex_state = 2},
  [22] = {.lex_state = 93, .external_lex_state = 2},
  [23] = {.lex_state = 93, .external_lex_state = 2},
  [24] = {.lex_state = 93, .external_lex_state = 2},
  [25] = {.lex_state = 93, .external_lex_state = 2},
  [26] = {.lex_state = 93, .external_lex_state = 2},
  [27] = {.lex_state = 93, .external_lex_state = 2},
  [28] = {.lex_state = 93, .external_lex_state = 2},
  [29] = {.lex_state = 93, .external_lex_state = 2},
  [30] = {.lex_state = 93, .external_lex_state = 2},
  [31] = {.lex_state = 93, .external_lex_state = 2},
  [32] = {.lex_state = 93, .external_lex_state = 2},
  [33] = {.lex_state = 93, .external_lex_state = 2},
  [34] = {.lex_state = 93, .external_lex_state = 2},
  [35] = {.lex_state = 93, .external_lex_state = 2},
  [36] = {.lex_state = 93, .external_lex_state = 2},
  [37] = {.lex_state = 93, .external_lex_state = 2},
  [38] = {.lex_state = 93, .external_lex_state = 2},
  [39] = {.lex_state = 93, .external_lex_state = 2},
  [40] = {.lex_state = 93, .external_lex_state = 2},
  [41] = {.lex_state = 93, .external_lex_state = 2},
  [42] = {.lex_state = 93, .external_lex_state = 2},
  [43] = {.lex_state = 93, .external_lex_state = 2},
  [44] = {.lex_state = 93, .external_lex_state = 2},
  [45] = {.lex_state = 93, .external_lex_state = 2},
  [46] = {.lex_state = 93, .external_lex_state = 2},
  [47] = {.lex_state = 93, .external_lex_state = 2},
  [48] = {.lex_state = 93, .external_lex_state = 2},
  [49] = {.lex_state = 93, .external_lex_state = 2},
  [50] = {.lex_state = 93, .external_lex_state = 2},
  [51] = {.lex_state = 93, .external_lex_state = 2},
  [52] = {.lex_state = 93, .external_lex_state = 2},
  [53] = {.lex_state = 93, .external_lex_state = 2},
  [54] = {.lex_state = 93, .external_lex_state = 2},
  [55] = {.lex_state = 93, .external_lex_state = 2},
  [56] = {.lex_state = 93, .external_lex_state = 2},
  [57] = {.lex_state = 93, .external_lex_state = 2},
  [58] = {.lex_state = 93, .external_lex_state = 2},
  [59] = {.lex_state = 93, .external_lex_state = 2},
  [60] = {.lex_state = 93, .external_lex_state = 2},
  [61] = {.lex_state = 93, .external_lex_state = 2},
  [62] = {.lex_state = 93, .external_lex_state = 2},
  [63] = {.lex_state = 93, .external_lex_state = 2},
  [64] = {.lex_state = 93, .external_lex_state = 2},
  [65] = {.lex_state = 93, .external_lex_state = 2},
  [66] = {.lex_state = 93, .external_lex_state = 2},
  [67] = {.lex_state = 93, .external_lex_state = 2},
  [68] = {.lex_state = 93, .external_lex_state = 2},
  [69] = {.lex_state = 93, .external_lex_state = 2},
  [70] = {.lex_state = 93, .external_lex_state = 2},
  [71] = {.lex_state = 93, .external_lex_state = 2},
  [72] = {.lex_state = 93, .external_lex_state = 2},
  [73] = {.lex_state = 94, .external_lex_state = 2},
  [74] = {.lex_state = 93, .external_lex_state = 2},
  [75] = {.lex_state = 93, .external_lex_state = 2},
  [76] = {.lex_state = 93, .external_lex_state = 2},
  [77] = {.lex_state = 94, .external_lex_state = 2},
  [78] = {.lex_state = 93, .external_lex_state = 2},
  [79] = {.lex_state = 93, .external_lex_state = 2},
  [80] = {.lex_state = 93, .external_lex_state = 2},
  [81] = {.lex_state = 94, .external_lex_state = 3},
  [82] = {.lex_state = 94, .external_lex_state = 2},
  [83] = {.lex_state = 94, .external_lex_state = 2},
  [84] = {.lex_state = 94, .external_lex_state = 2},
  [85] = {.lex_state = 94, .external_lex_state = 2},
  [86] = {.lex_state = 94, .external_lex_state = 3},
  [87] = {.lex_state = 94, .external_lex_state = 2},
  [88] = {.lex_state = 94, .external_lex_state = 2},
  [89] = {.lex_state = 1, .external_lex_state = 2},
  [90] = {.lex_state = 1, .external_lex_state = 2},
  [91] = {.lex_state = 1, .external_lex_state = 2},
  [92] = {.lex_state = 94, .external_lex_state = 2},
  [93] = {.lex_state = 94, .external_lex_state = 2},
  [94] = {.lex_state = 94, .external_lex_state = 2},
  [95] = {.lex_state = 94, .external_lex_state = 2},
  [96] = {.lex_state = 94, .external_lex_state = 2},
  [97] = {.lex_state = 94, .external_lex_state = 2},
  [98] = {.lex_state = 94, .external_lex_state = 2},
  [99] = {.lex_state = 94, .external_lex_state = 2},
  [100] = {.lex_state = 94, .external_lex_state = 2},
  [101] = {.lex_state = 94, .external_lex_state = 2},
  [102] = {.lex_state = 94, .external_lex_state = 2},
  [103] = {.lex_state = 94, .external_lex_state = 2},
  [104] = {.lex_state = 94, .external_lex_state = 2},
  [105] = {.lex_state = 94, .external_lex_state = 2},
  [106] = {.lex_state = 94, .external_lex_state = 2},
  [107] = {.lex_state = 94, .external_lex_state = 2},
  [108] = {.lex_state = 94, .external_lex_state = 2},
  [109] = {.lex_state = 94, .external_lex_state = 2},
  [110] = {.lex_state = 94, .external_lex_state = 2},
  [111] = {.lex_state = 94, .external_lex_state = 2},
  [112] = {.lex_state = 94, .external_lex_state = 2},
  [113] = {.lex_state = 94, .external_lex_state = 2},
  [114] = {.lex_state = 94, .external_lex_state = 2},
  [115] = {.lex_state = 94, .external_lex_state = 2},
  [116] = {.lex_state = 94, .external_lex_state = 2},
  [117] = {.lex_state = 94, .external_lex_state = 2},
  [118] = {.lex_state = 94, .external_lex_state = 2},
  [119] = {.lex_state = 94, .external_lex_state = 2},
  [120] = {.lex_state = 94, .external_lex_state = 2},
  [121] = {.lex_state = 94, .external_lex_state = 2},
  [122] = {.lex_state = 94, .external_lex_state = 2},
  [123] = {.lex_state = 94, .external_lex_state = 2},
  [124] = {.lex_state = 94, .external_lex_state = 2},
  [125] = {.lex_state = 94, .external_lex_state = 2},
  [126] = {.lex_state = 94, .external_lex_state = 2},
  [127] = {.lex_state = 94, .external_lex_state = 2},
  [128] = {.lex_state = 94, .external_lex_state = 2},
  [129] = {.lex_state = 93, .external_lex_state = 2},
  [130] = {.lex_state = 93, .external_lex_state = 2},
  [131] = {.lex_state = 93, .external_lex_state = 2},
  [132] = {.lex_state = 93, .external_lex_state = 2},
  [133] = {.lex_state = 93, .external_lex_state = 2},
  [134] = {.lex_state = 93, .external_lex_state = 2},
  [135] = {.lex_state = 93, .external_lex_state = 2},
  [136] = {.lex_state = 93, .external_lex_state = 2},
  [137] = {.lex_state = 93, .external_lex_state = 2},
  [138] = {.lex_state = 93, .external_lex_state = 2},
  [139] = {.lex_state = 93, .external_lex_state = 2},
  [140] = {.lex_state = 93, .external_lex_state = 2},
  [141] = {.lex_state = 93, .external_lex_state = 2},
  [142] = {.lex_state = 94, .external_lex_state = 2},
  [143] = {.lex_state = 94, .external_lex_state = 2},
  [144] = {.lex_state = 94, .external_lex_state = 2},
  [145] = {.lex_state = 94, .external_lex_state = 2},
  [146] = {.lex_state = 93, .external_lex_state = 2},
  [147] = {.lex_state = 94, .external_lex_state = 2},
  [148] = {.lex_state = 93, .external_lex_state = 2},
  [149] = {.lex_state = 93, .external_lex_state = 2},
  [150] = {.lex_state = 94, .external_lex_state = 2},
  [151] = {.lex_state = 94, .external_lex_state = 2},
  [152] = {.lex_state = 93, .external_lex_state = 2},
  [153] = {.lex_state = 93, .external_lex_state = 2},
  [154] = {.lex_state = 94, .external_lex_state = 2},
  [155] = {.lex_state = 93, .external_lex_state = 2},
  [156] = {.lex_state = 93, .external_lex_state = 2},
  [157] = {.lex_state = 93, .external_lex_state = 2},
  [158] = {.lex_state = 93, .external_lex_state = 2},
  [159] = {.lex_state = 93, .external_lex_state = 2},
  [160] = {.lex_state = 93, .external_lex_state = 2},
  [161] = {.lex_state = 93, .external_lex_state = 2},
  [162] = {.lex_state = 93, .external_lex_state = 2},
  [163] = {.lex_state = 93, .external_lex_state = 2},
  [164] = {.lex_state = 93, .external_lex_state = 2},
  [165] = {.lex_state = 93, .external_lex_state = 2},
  [166] = {.lex_state = 93, .external_lex_state = 2},
  [167] = {.lex_state = 93, .external_lex_state = 2},
  [168] = {.lex_state = 93, .external_lex_state = 2},
  [169] = {.lex_state = 93, .external_lex_state = 2},
  [170] = {.lex_state = 93, .external_lex_state = 2},
  [171] = {.lex_state = 93, .external_lex_state = 2},
  [172] = {.lex_state = 93, .external_lex_state = 2},
  [173] = {.lex_state = 93, .external_lex_state = 2},
  [174] = {.lex_state = 93, .external_lex_state = 2},
  [175] = {.lex_state = 93, .external_lex_state = 2},
  [176] = {.lex_state = 93, .external_lex_state = 2},
  [177] = {.lex_state = 93, .external_lex_state = 2},
  [178] = {.lex_state = 93, .external_lex_state = 2},
  [179] = {.lex_state = 93, .external_lex_state = 2},
  [180] = {.lex_state = 93, .external_lex_state = 2},
  [181] = {.lex_state = 93, .external_lex_state = 2},
  [182] = {.lex_state = 93, .external_lex_state = 2},
  [183] = {.lex_state = 93, .external_lex_state = 2},
  [184] = {.lex_state = 93, .external_lex_state = 2},
  [185] = {.lex_state = 93, .external_lex_state = 2},
  [186] = {.lex_state = 93, .external_lex_state = 2},
  [187] = {.lex_state = 93, .external_lex_state = 2},
  [188] = {.lex_state = 93, .external_lex_state = 2},
  [189] = {.lex_state = 93, .external_lex_state = 2},
  [190] = {.lex_state = 93, .external_lex_state = 2},
  [191] = {.lex_state = 93, .external_lex_state = 2},
  [192] = {.lex_state = 93, .external_lex_state = 2},
  [193] = {.lex_state = 93, .external_lex_state = 2},
  [194] = {.lex_state = 93, .external_lex_state = 2},
  [195] = {.lex_state = 93, .external_lex_state = 2},
  [196] = {.lex_state = 93, .external_lex_state = 2},
  [197] = {.lex_state = 93, .external_lex_state = 2},
  [198] = {.lex_state = 93, .external_lex_state = 2},
  [199] = {.lex_state = 93, .external_lex_state = 2},
  [200] = {.lex_state = 93, .external_lex_state = 2},
  [201] = {.lex_state = 93, .external_lex_state = 2},
  [202] = {.lex_state = 93, .external_lex_state = 2},
  [203] = {.lex_state = 93, .external_lex_state = 2},
  [204] = {.lex_state = 93, .external_lex_state = 2},
  [205] = {.lex_state = 93, .external_lex_state = 2},
  [206] = {.lex_state = 93, .external_lex_state = 2},
  [207] = {.lex_state = 93, .external_lex_state = 2},
  [208] = {.lex_state = 93, .external_lex_state = 2},
  [209] = {.lex_state = 93, .external_lex_state = 2},
  [210] = {.lex_state = 93, .external_lex_state = 2},
  [211] = {.lex_state = 93, .external_lex_state = 2},
  [212] = {.lex_state = 93, .external_lex_state = 2},
  [213] = {.lex_state = 93, .external_lex_state = 2},
  [214] = {.lex_state = 93, .external_lex_state = 2},
  [215] = {.lex_state = 93, .external_lex_state = 2},
  [216] = {.lex_state = 93, .external_lex_state = 2},
  [217] = {.lex_state = 93, .external_lex_state = 2},
  [218] = {.lex_state = 93, .external_lex_state = 2},
  [219] = {.lex_state = 93, .external_lex_state = 2},
  [220] = {.lex_state = 93, .external_lex_state = 2},
  [221] = {.lex_state = 93, .external_lex_state = 2},
  [222] = {.lex_state = 93, .external_lex_state = 2},
  [223] = {.lex_state = 93, .external_lex_state = 2},
  [224] = {.lex_state = 94, .external_lex_state = 2},
  [225] = {.lex_state = 94, .external_lex_state = 2},
  [226] = {.lex_state = 94, .external_lex_state = 2},
  [227] = {.lex_state = 94, .external_lex_state = 2},
  [228] = {.lex_state = 94, .external_lex_state = 2},
  [229] = {.lex_state = 94, .external_lex_state = 2},
  [230] = {.lex_state = 94, .external_lex_state = 2},
  [231] = {.lex_state = 94, .external_lex_state = 2},
  [232] = {.lex_state = 94, .external_lex_state = 2},
  [233] = {.lex_state = 94, .external_lex_state = 2},
  [234] = {.lex_state = 94, .external_lex_state = 2},
  [235] = {.lex_state = 94, .external_lex_state = 2},
  [236] = {.lex_state = 94, .external_lex_state = 2},
  [237] = {.lex_state = 94, .external_lex_state = 2},
  [238] = {.lex_state = 94, .external_lex_state = 2},
  [239] = {.lex_state = 94, .external_lex_state = 2},
  [240] = {.lex_state = 94, .external_lex_state = 2},
  [241] = {.lex_state = 94, .external_lex_state = 2},
  [242] = {.lex_state = 94, .external_lex_state = 2},
  [243] = {.lex_state = 94, .external_lex_state = 2},
  [244] = {.lex_state = 94, .external_lex_state = 2},
  [245] = {.lex_state = 94, .external_lex_state = 2},
  [246] = {.lex_state = 94, .external_lex_state = 2},
  [247] = {.lex_state = 94, .external_lex_state = 2},
  [248] = {.lex_state = 94, .external_lex_state = 2},
  [249] = {.lex_state = 94, .external_lex_state = 2},
  [250] = {.lex_state = 94, .external_lex_state = 2},
  [251] = {.lex_state = 94, .external_lex_state = 2},
  [252] = {.lex_state = 94, .external_lex_state = 2},
  [253] = {.lex_state = 94, .external_lex_state = 2},
  [254] = {.lex_state = 94, .external_lex_state = 2},
  [255] = {.lex_state = 94, .external_lex_state = 2},
  [256] = {.lex_state = 94, .external_lex_state = 2},
  [257] = {.lex_state = 94, .external_lex_state = 2},
  [258] = {.lex_state = 94, .external_lex_state = 2},
  [259] = {.lex_state = 94, .external_lex_state = 2},
  [260] = {.lex_state = 94, .external_lex_state = 2},
  [261] = {.lex_state = 94, .external_lex_state = 2},
  [262] = {.lex_state = 94, .external_lex_state = 2},
  [263] = {.lex_state = 94, .external_lex_state = 2},
  [264] = {.lex_state = 94, .external_lex_state = 3},
  [265] = {.lex_state = 94, .external_lex_state = 2},
  [266] = {.lex_state = 94, .external_lex_state = 2},
  [267] = {.lex_state = 94, .external_lex_state = 2},
  [268] = {.lex_state = 94, .external_lex_state = 2},
  [269] = {.lex_state = 94, .external_lex_state = 2},
  [270] = {.lex_state = 94, .external_lex_state = 2},
  [271] = {.lex_state = 94, .external_lex_state = 2},
  [272] = {.lex_state = 94, .external_lex_state = 2},
  [273] = {.lex_state = 94, .external_lex_state = 3},
  [274] = {.lex_state = 94, .external_lex_state = 2},
  [275] = {.lex_state = 94, .external_lex_state = 2},
  [276] = {.lex_state = 94, .external_lex_state = 2},
  [277] = {.lex_state = 94, .external_lex_state = 2},
  [278] = {.lex_state = 94, .external_lex_state = 2},
  [279] = {.lex_state = 94, .external_lex_state = 2},
  [280] = {.lex_state = 94, .external_lex_state = 2},
  [281] = {.lex_state = 94, .external_lex_state = 2},
  [282] = {.lex_state = 94, .external_lex_state = 2},
  [283] = {.lex_state = 94, .external_lex_state = 3},
  [284] = {.lex_state = 94, .external_lex_state = 2},
  [285] = {.lex_state = 94, .external_lex_state = 2},
  [286] = {.lex_state = 94, .external_lex_state = 2},
  [287] = {.lex_state = 94, .external_lex_state = 2},
  [288] = {.lex_state = 94, .external_lex_state = 3},
  [289] = {.lex_state = 94, .external_lex_state = 2},
  [290] = {.lex_state = 94, .external_lex_state = 2},
  [291] = {.lex_state = 94, .external_lex_state = 2},
  [292] = {.lex_state = 94, .external_lex_state = 2},
  [293] = {.lex_state = 94, .external_lex_state = 2},
  [294] = {.lex_state = 94, .external_lex_state = 2},
  [295] = {.lex_state = 94, .external_lex_state = 2},
  [296] = {.lex_state = 94, .external_lex_state = 2},
  [297] = {.lex_state = 94, .external_lex_state = 2},
  [298] = {.lex_state = 94, .external_lex_state = 2},
  [299] = {.lex_state = 94, .external_lex_state = 2},
  [300] = {.lex_state = 94, .external_lex_state = 2},
  [301] = {.lex_state = 94, .external_lex_state = 2},
  [302] = {.lex_state = 94, .external_lex_state = 2},
  [303] = {.lex_state = 94, .external_lex_state = 2},
  [304] = {.lex_state = 94, .external_lex_state = 2},
  [305] = {.lex_state = 94, .external_lex_state = 2},
  [306] = {.lex_state = 94, .external_lex_state = 3},
  [307] = {.lex_state = 94, .external_lex_state = 2},
  [308] = {.lex_state = 94, .external_lex_state = 2},
  [309] = {.lex_state = 94, .external_lex_state = 2},
  [310] = {.lex_state = 94, .external_lex_state = 2},
  [311] = {.lex_state = 94, .external_lex_state = 2},
  [312] = {.lex_state = 94, .external_lex_state = 2},
  [313] = {.lex_state = 94, .external_lex_state = 2},
  [314] = {.lex_state = 94, .external_lex_state = 2},
  [315] = {.lex_state = 94, .external_lex_state = 3},
  [316] = {.lex_state = 94, .external_lex_state = 2},
  [317] = {.lex_state = 94, .external_lex_state = 2},
  [318] = {.lex_state = 94, .external_lex_state = 2},
  [319] = {.lex_state = 94, .external_lex_state = 3},
  [320] = {.lex_state = 94, .external_lex_state = 3},
  [321] = {.lex_state = 94, .external_lex_state = 2},
  [322] = {.lex_state = 94, .external_lex_state = 2},
  [323] = {.lex_state = 94, .external_lex_state = 2},
  [324] = {.lex_state = 94, .external_lex_state = 2},
  [325] = {.lex_state = 94, .external_lex_state = 2},
  [326] = {.lex_state = 94, .external_lex_state = 3},
  [327] = {.lex_state = 94, .external_lex_state = 2},
  [328] = {.lex_state = 94, .external_lex_state = 2},
  [329] = {.lex_state = 94, .external_lex_state = 2},
  [330] = {.lex_state = 94, .external_lex_state = 2},
  [331] = {.lex_state = 94, .external_lex_state = 2},
  [332] = {.lex_state = 94, .external_lex_state = 2},
  [333] = {.lex_state = 94, .external_lex_state = 3},
  [334] = {.lex_state = 94, .external_lex_state = 2},
  [335] = {.lex_state = 94, .external_lex_state = 2},
  [336] = {.lex_state = 94, .external_lex_state = 2},
  [337] = {.lex_state = 94, .external_lex_state = 3},
  [338] = {.lex_state = 94, .external_lex_state = 2},
  [339] = {.lex_state = 94, .external_lex_state = 3},
  [340] = {.lex_state = 94, .external_lex_state = 3},
  [341] = {.lex_state = 94, .external_lex_state = 2},
  [342] = {.lex_state = 94, .external_lex_state = 2},
  [343] = {.lex_state = 94, .external_lex_state = 2},
  [344] = {.lex_state = 94, .external_lex_state = 2},
  [345] = {.lex_state = 94, .external_lex_state = 2},
  [346] = {.lex_state = 94, .external_lex_state = 2},
  [347] = {.lex_state = 94, .external_lex_state = 2},
  [348] = {.lex_state = 94, .external_lex_state = 3},
  [349] = {.lex_state = 94, .external_lex_state = 3},
  [350] = {.lex_state = 94, .external_lex_state = 2},
  [351] = {.lex_state = 94, .external_lex_state = 3},
  [352] = {.lex_state = 94, .external_lex_state = 2},
  [353] = {.lex_state = 94, .external_lex_state = 3},
  [354] = {.lex_state = 94, .external_lex_state = 2},
  [355] = {.lex_state = 94, .external_lex_state = 3},
  [356] = {.lex_state = 94, .external_lex_state = 2},
  [357] = {.lex_state = 94, .external_lex_state = 2},
  [358] = {.lex_state = 94, .external_lex_state = 3},
  [359] = {.lex_state = 94, .external_lex_state = 2},
  [360] = {.lex_state = 94, .external_lex_state = 2},
  [361] = {.lex_state = 94, .external_lex_state = 3},
  [362] = {.lex_state = 94, .external_lex_state = 2},
  [363] = {.lex_state = 94, .external_lex_state = 2},
  [364] = {.lex_state = 94, .external_lex_state = 2},
  [365] = {.lex_state = 94, .external_lex_state = 2},
  [366] = {.lex_state = 94, .external_lex_state = 2},
  [367] = {.lex_state = 94, .external_lex_state = 2},
  [368] = {.lex_state = 94, .external_lex_state = 2},
  [369] = {.lex_state = 94, .external_lex_state = 2},
  [370] = {.lex_state = 94, .external_lex_state = 2},
  [371] = {.lex_state = 94, .external_lex_state = 2},
  [372] = {.lex_state = 94, .external_lex_state = 2},
  [373] = {.lex_state = 94, .external_lex_state = 2},
  [374] = {.lex_state = 94, .external_lex_state = 2},
  [375] = {.lex_state = 94, .external_lex_state = 2},
  [376] = {.lex_state = 94, .external_lex_state = 2},
  [377] = {.lex_state = 94, .external_lex_state = 2},
  [378] = {.lex_state = 94, .external_lex_state = 2},
  [379] = {.lex_state = 94, .external_lex_state = 3},
  [380] = {.lex_state = 94, .external_lex_state = 2},
  [381] = {.lex_state = 94, .external_lex_state = 3},
  [382] = {.lex_state = 94, .external_lex_state = 2},
  [383] = {.lex_state = 94, .external_lex_state = 2},
  [384] = {.lex_state = 94, .external_lex_state = 3},
  [385] = {.lex_state = 94, .external_lex_state = 2},
  [386] = {.lex_state = 94, .external_lex_state = 2},
  [387] = {.lex_state = 94, .external_lex_state = 2},
  [388] = {.lex_state = 94, .external_lex_state = 2},
  [389] = {.lex_state = 94, .external_lex_state = 2},
  [390] = {.lex_state = 94, .external_lex_state = 2},
  [391] = {.lex_state = 94, .external_lex_state = 3},
  [392] = {.lex_state = 94, .external_lex_state = 2},
  [393] = {.lex_state = 94, .external_lex_state = 3},
  [394] = {.lex_state = 94, .external_lex_state = 2},
  [395] = {.lex_state = 94, .external_lex_state = 2},
  [396] = {.lex_state = 94, .external_lex_state = 2},
  [397] = {.lex_state = 94, .external_lex_state = 2},
  [398] = {.lex_state = 94, .external_lex_state = 2},
  [399] = {.lex_state = 94, .external_lex_state = 2},
  [400] = {.lex_state = 94, .external_lex_state = 2},
  [401] = {.lex_state = 94, .external_lex_state = 2},
  [402] = {.lex_state = 94, .external_lex_state = 3},
  [403] = {.lex_state = 94, .external_lex_state = 2},
  [404] = {.lex_state = 94, .external_lex_state = 2},
  [405] = {.lex_state = 94, .external_lex_state = 2},
  [406] = {.lex_state = 94, .external_lex_state = 2},
  [407] = {.lex_state = 94, .external_lex_state = 2},
  [408] = {.lex_state = 94, .external_lex_state = 2},
  [409] = {.lex_state = 94, .external_lex_state = 2},
  [410] = {.lex_state = 94, .external_lex_state = 2},
  [411] = {.lex_state = 94, .external_lex_state = 3},
  [412] = {.lex_state = 94, .external_lex_state = 3},
  [413] = {.lex_state = 94, .external_lex_state = 2},
  [414] = {.lex_state = 94, .external_lex_state = 3},
  [415] = {.lex_state = 94, .external_lex_state = 3},
  [416] = {.lex_state = 94, .external_lex_state = 3},
  [417] = {.lex_state = 94, .external_lex_state = 3},
  [418] = {.lex_state = 94, .external_lex_state = 3},
  [419] = {.lex_state = 94, .external_lex_state = 3},
  [420] = {.lex_state = 94, .external_lex_state = 3},
  [421] = {.lex_state = 94, .external_lex_state = 3},
  [422] = {.lex_state = 94, .external_lex_state = 3},
  [423] = {.lex_state = 94, .external_lex_state = 3},
  [424] = {.lex_state = 94, .external_lex_state = 3},
  [425] = {.lex_state = 94, .external_lex_state = 2},
  [426] = {.lex_state = 94, .external_lex_state = 2},
  [427] = {.lex_state = 94, .external_lex_state = 2},
  [428] = {.lex_state = 94, .external_lex_state = 2},
  [429] = {.lex_state = 94, .external_lex_state = 2},
  [430] = {.lex_state = 94, .external_lex_state = 2},
  [431] = {.lex_state = 94, .external_lex_state = 3},
  [432] = {.lex_state = 94, .external_lex_state = 2},
  [433] = {.lex_state = 94, .external_lex_state = 2},
  [434] = {.lex_state = 94, .external_lex_state = 2},
  [435] = {.lex_state = 94, .external_lex_state = 3},
  [436] = {.lex_state = 94, .external_lex_state = 2},
  [437] = {.lex_state = 94, .external_lex_state = 3},
  [438] = {.lex_state = 94, .external_lex_state = 2},
  [439] = {.lex_state = 94, .external_lex_state = 2},
  [440] = {.lex_state = 94, .external_lex_state = 2},
  [441] = {.lex_state = 94, .external_lex_state = 2},
  [442] = {.lex_state = 94, .external_lex_state = 3},
  [443] = {.lex_state = 94, .external_lex_state = 2},
  [444] = {.lex_state = 94, .external_lex_state = 3},
  [445] = {.lex_state = 94, .external_lex_state = 2},
  [446] = {.lex_state = 94, .external_lex_state = 2},
  [447] = {.lex_state = 94, .external_lex_state = 2},
  [448] = {.lex_state = 94, .external_lex_state = 3},
  [449] = {.lex_state = 94, .external_lex_state = 2},
  [450] = {.lex_state = 94, .external_lex_state = 2},
  [451] = {.lex_state = 94, .external_lex_state = 2},
  [452] = {.lex_state = 94, .external_lex_state = 2},
  [453] = {.lex_state = 94, .external_lex_state = 2},
  [454] = {.lex_state = 94, .external_lex_state = 3},
  [455] = {.lex_state = 94, .external_lex_state = 2},
  [456] = {.lex_state = 94, .external_lex_state = 3},
  [457] = {.lex_state = 94, .external_lex_state = 2},
  [458] = {.lex_state = 94, .external_lex_state = 2},
  [459] = {.lex_state = 94, .external_lex_state = 2},
  [460] = {.lex_state = 94, .external_lex_state = 2},
  [461] = {.lex_state = 94, .external_lex_state = 2},
  [462] = {.lex_state = 94, .external_lex_state = 3},
  [463] = {.lex_state = 94, .external_lex_state = 2},
  [464] = {.lex_state = 93, .external_lex_state = 4},
  [465] = {.lex_state = 93, .external_lex_state = 4},
  [466] = {.lex_state = 93, .external_lex_state = 4},
  [467] = {.lex_state = 93, .external_lex_state = 4},
  [468] = {.lex_state = 93, .external_lex_state = 4},
  [469] = {.lex_state = 93, .external_lex_state = 4},
  [470] = {.lex_state = 93, .external_lex_state = 4},
  [471] = {.lex_state = 93, .external_lex_state = 4},
  [472] = {.lex_state = 93, .external_lex_state = 4},
  [473] = {.lex_state = 93, .external_lex_state = 4},
  [474] = {.lex_state = 93, .external_lex_state = 4},
  [475] = {.lex_state = 93, .external_lex_state = 4},
  [476] = {.lex_state = 93, .external_lex_state = 4},
  [477] = {.lex_state = 3, .external_lex_state = 2},
  [478] = {.lex_state = 5, .external_lex_state = 2},
  [479] = {.lex_state = 5, .external_lex_state = 2},
  [480] = {.lex_state = 5, .external_lex_state = 2},
  [481] = {.lex_state = 95, .external_lex_state = 4},
  [482] = {.lex_state = 5, .external_lex_state = 2},
  [483] = {.lex_state = 5, .external_lex_state = 2},
  [484] = {.lex_state = 94, .external_lex_state = 2},
  [485] = {.lex_state = 5, .external_lex_state = 2},
  [486] = {.lex_state = 94, .external_lex_state = 2},
  [487] = {.lex_state = 94, .external_lex_state = 2},
  [488] = {.lex_state = 93, .external_lex_state = 4},
  [489] = {.lex_state = 94, .external_lex_state = 2},
  [490] = {.lex_state = 93, .external_lex_state = 5},
  [491] = {.lex_state = 5, .external_lex_state = 2},
  [492] = {.lex_state = 94, .external_lex_state = 2},
  [493] = {.lex_state = 95, .external_lex_state = 4},
  [494] = {.lex_state = 5, .external_lex_state = 2},
  [495] = {.lex_state = 5, .external_lex_state = 2},
  [496] = {.lex_state = 5, .external_lex_state = 2},
  [497] = {.lex_state = 5, .external_lex_state = 2},
  [498] = {.lex_state = 95, .external_lex_state = 4},
  [499] = {.lex_state = 5, .external_lex_state = 2},
  [500] = {.lex_state = 94, .external_lex_state = 2},
  [501] = {.lex_state = 5, .external_lex_state = 2},
  [502] = {.lex_state = 5, .external_lex_state = 2},
  [503] = {.lex_state = 5, .external_lex_state = 2},
  [504] = {.lex_state = 5, .external_lex_state = 2},
  [505] = {.lex_state = 5, .external_lex_state = 2},
  [506] = {.lex_state = 5, .external_lex_state = 2},
  [507] = {.lex_state = 5, .external_lex_state = 2},
  [508] = {.lex_state = 5, .external_lex_state = 2},
  [509] = {.lex_state = 5, .external_lex_state = 2},
  [510] = {.lex_state = 5, .external_lex_state = 2},
  [511] = {.lex_state = 5, .external_lex_state = 2},
  [512] = {.lex_state = 5, .external_lex_state = 2},
  [513] = {.lex_state = 5, .external_lex_state = 2},
  [514] = {.lex_state = 5, .external_lex_state = 2},
  [515] = {.lex_state = 5, .external_lex_state = 2},
  [516] = {.lex_state = 5, .external_lex_state = 2},
  [517] = {.lex_state = 5, .external_lex_state = 2},
  [518] = {.lex_state = 95, .external_lex_state = 4},
  [519] = {.lex_state = 95, .external_lex_state = 4},
  [520] = {.lex_state = 95, .external_lex_state = 4},
  [521] = {.lex_state = 95, .external_lex_state = 4},
  [522] = {.lex_state = 95, .external_lex_state = 4},
  [523] = {.lex_state = 5, .external_lex_state = 2},
  [524] = {.lex_state = 95, .external_lex_state = 4},
  [525] = {.lex_state = 95, .external_lex_state = 4},
  [526] = {.lex_state = 5, .external_lex_state = 2},
  [527] = {.lex_state = 95, .external_lex_state = 4},
  [528] = {.lex_state = 95, .external_lex_state = 4},
  [529] = {.lex_state = 95, .external_lex_state = 4},
  [530] = {.lex_state = 95, .external_lex_state = 4},
  [531] = {.lex_state = 95, .external_lex_state = 4},
  [532] = {.lex_state = 6, .external_lex_state = 2},
  [533] = {.lex_state = 95, .external_lex_state = 4},
  [534] = {.lex_state = 95, .external_lex_state = 4},
  [535] = {.lex_state = 5, .external_lex_state = 2},
  [536] = {.lex_state = 5, .external_lex_state = 2},
  [537] = {.lex_state = 5, .external_lex_state = 2},
  [538] = {.lex_state = 93, .external_lex_state = 4},
  [539] = {.lex_state = 95, .external_lex_state = 4},
  [540] = {.lex_state = 95, .external_lex_state = 4},
  [541] = {.lex_state = 95, .external_lex_state = 4},
  [542] = {.lex_state = 93, .external_lex_state = 5},
  [543] = {.lex_state = 95, .external_lex_state = 4},
  [544] = {.lex_state = 93, .external_lex_state = 5},
  [545] = {.lex_state = 95, .external_lex_state = 4},
  [546] = {.lex_state = 95, .external_lex_state = 4},
  [547] = {.lex_state = 95, .external_lex_state = 4},
  [548] = {.lex_state = 95, .external_lex_state = 4},
  [549] = {.lex_state = 95, .external_lex_state = 4},
  [550] = {.lex_state = 95, .external_lex_state = 4},
  [551] = {.lex_state = 95, .external_lex_state = 4},
  [552] = {.lex_state = 95, .external_lex_state = 4},
  [553] = {.lex_state = 93, .external_lex_state = 4},
  [554] = {.lex_state = 93, .external_lex_state = 4},
  [555] = {.lex_state = 95, .external_lex_state = 4},
  [556] = {.lex_state = 95, .external_lex_state = 4},
  [557] = {.lex_state = 93, .external_lex_state = 4},
  [558] = {.lex_state = 95, .external_lex_state = 4},
  [559] = {.lex_state = 93, .external_lex_state = 5},
  [560] = {.lex_state = 93, .external_lex_state = 4},
  [561] = {.lex_state = 93, .external_lex_state = 4},
  [562] = {.lex_state = 93, .external_lex_state = 4},
  [563] = {.lex_state = 93, .external_lex_state = 5},
  [564] = {.lex_state = 93, .external_lex_state = 5},
  [565] = {.lex_state = 93, .external_lex_state = 4},
  [566] = {.lex_state = 93, .external_lex_state = 4},
  [567] = {.lex_state = 95, .external_lex_state = 4},
  [568] = {.lex_state = 93, .external_lex_state = 4},
  [569] = {.lex_state = 93, .external_lex_state = 4},
  [570] = {.lex_state = 95, .external_lex_state = 4},
  [571] = {.lex_state = 93, .external_lex_state = 4},
  [572] = {.lex_state = 93, .external_lex_state = 5},
  [573] = {.lex_state = 95, .external_lex_state = 4},
  [574] = {.lex_state = 95, .external_lex_state = 4},
  [575] = {.lex_state = 95, .external_lex_state = 4},
  [576] = {.lex_state = 95, .external_lex_state = 4},
  [577] = {.lex_state = 93, .external_lex_state = 5},
  [578] = {.lex_state = 95, .external_lex_state = 4},
  [579] = {.lex_state = 93, .external_lex_state = 5},
  [580] = {.lex_state = 5, .external_lex_state = 2},
  [581] = {.lex_state = 93, .external_lex_state = 5},
  [582] = {.lex_state = 93, .external_lex_state = 5},
  [583] = {.lex_state = 93, .external_lex_state = 5},
  [584] = {.lex_state = 93, .external_lex_state = 5},
  [585] = {.lex_state = 93, .external_lex_state = 2},
  [586] = {.lex_state = 93, .external_lex_state = 2},
  [587] = {.lex_state = 93, .external_lex_state = 2},
  [588] = {.lex_state = 93, .external_lex_state = 2},
  [589] = {.lex_state = 93, .external_lex_state = 2},
  [590] = {.lex_state = 93, .external_lex_state = 2},
  [591] = {.lex_state = 93, .external_lex_state = 2},
  [592] = {.lex_state = 5, .external_lex_state = 2},
  [593] = {.lex_state = 5, .external_lex_state = 2},
  [594] = {.lex_state = 93, .external_lex_state = 2},
  [595] = {.lex_state = 5, .external_lex_state = 2},
  [596] = {.lex_state = 5, .external_lex_state = 2},
  [597] = {.lex_state = 7, .external_lex_state = 2},
  [598] = {.lex_state = 5, .external_lex_state = 2},
  [599] = {.lex_state = 5, .external_lex_state = 2},
  [600] = {.lex_state = 5, .external_lex_state = 2},
  [601] = {.lex_state = 5, .external_lex_state = 2},
  [602] = {.lex_state = 5, .external_lex_state = 2},
  [603] = {.lex_state = 5, .external_lex_state = 2},
  [604] = {.lex_state = 5, .external_lex_state = 2},
  [605] = {.lex_state = 5, .external_lex_state = 2},
  [606] = {.lex_state = 93, .external_lex_state = 2},
  [607] = {.lex_state = 93, .external_lex_state = 2},
  [608] = {.lex_state = 93, .external_lex_state = 2},
  [609] = {.lex_state = 5, .external_lex_state = 2},
  [610] = {.lex_state = 5, .external_lex_state = 2},
  [611] = {.lex_state = 5, .external_lex_state = 2},
  [612] = {.lex_state = 6, .external_lex_state = 2},
  [613] = {.lex_state = 93, .external_lex_state = 2},
  [614] = {.lex_state = 5, .external_lex_state = 2},
  [615] = {.lex_state = 93, .external_lex_state = 2},
  [616] = {.lex_state = 5, .external_lex_state = 2},
  [617] = {.lex_state = 5, .external_lex_state = 2},
  [618] = {.lex_state = 5, .external_lex_state = 2},
  [619] = {.lex_state = 93, .external_lex_state = 2},
  [620] = {.lex_state = 93, .external_lex_state = 2},
  [621] = {.lex_state = 93, .external_lex_state = 2},
  [622] = {.lex_state = 93, .external_lex_state = 2},
  [623] = {.lex_state = 5, .external_lex_state = 2},
  [624] = {.lex_state = 5, .external_lex_state = 2},
  [625] = {.lex_state = 5, .external_lex_state = 2},
  [626] = {.lex_state = 6, .external_lex_state = 2},
  [627] = {.lex_state = 6, .external_lex_state = 2},
  [628] = {.lex_state = 6, .external_lex_state = 2},
  [629] = {.lex_state = 95, .external_lex_state = 4},
  [630] = {.lex_state = 7, .external_lex_state = 2},
  [631] = {.lex_state = 7, .external_lex_state = 2},
  [632] = {.lex_state = 7, .external_lex_state = 2},
  [633] = {.lex_state = 95, .external_lex_state = 4},
  [634] = {.lex_state = 5, .external_lex_state = 2},
  [635] = {.lex_state = 15, .external_lex_state = 6},
  [636] = {.lex_state = 15, .external_lex_state = 6},
  [637] = {.lex_state = 15, .external_lex_state = 6},
  [638] = {.lex_state = 15, .external_lex_state = 6},
  [639] = {.lex_state = 15, .external_lex_state = 6},
  [640] = {.lex_state = 15, .external_lex_state = 6},
  [641] = {.lex_state = 15, .external_lex_state = 6},
  [642] = {.lex_state = 5, .external_lex_state = 2},
  [643] = {.lex_state = 95, .external_lex_state = 4},
  [644] = {.lex_state = 15, .external_lex_state = 6},
  [645] = {.lex_state = 15, .external_lex_state = 6},
  [646] = {.lex_state = 95, .external_lex_state = 4},
  [647] = {.lex_state = 15, .external_lex_state = 6},
  [648] = {.lex_state = 95, .external_lex_state = 4},
  [649] = {.lex_state = 15, .external_lex_state = 6},
  [650] = {.lex_state = 15, .external_lex_state = 6},
  [651] = {.lex_state = 5, .external_lex_state = 2},
  [652] = {.lex_state = 5, .external_lex_state = 2},
  [653] = {.lex_state = 5, .external_lex_state = 2},
  [654] = {.lex_state = 5, .external_lex_state = 2},
  [655] = {.lex_state = 95, .external_lex_state = 4},
  [656] = {.lex_state = 15, .external_lex_state = 6},
  [657] = {.lex_state = 95, .external_lex_state = 4},
  [658] = {.lex_state = 5, .external_lex_state = 2},
  [659] = {.lex_state = 5, .external_lex_state = 2},
  [660] = {.lex_state = 5, .external_lex_state = 2},
  [661] = {.lex_state = 5, .external_lex_state = 2},
  [662] = {.lex_state = 95, .external_lex_state = 4},
  [663] = {.lex_state = 5, .external_lex_state = 2},
  [664] = {.lex_state = 5, .external_lex_state = 2},
  [665] = {.lex_state = 5, .external_lex_state = 2},
  [666] = {.lex_state = 5, .external_lex_state = 2},
  [667] = {.lex_state = 95, .external_lex_state = 4},
  [668] = {.lex_state = 5, .external_lex_state = 2},
  [669] = {.lex_state = 5, .external_lex_state = 2},
  [670] = {.lex_state = 5, .external_lex_state = 2},
  [671] = {.lex_state = 5, .external_lex_state = 2},
  [672] = {.lex_state = 5, .external_lex_state = 2},
  [673] = {.lex_state = 5, .external_lex_state = 2},
  [674] = {.lex_state = 5, .external_lex_state = 2},
  [675] = {.lex_state = 15, .external_lex_state = 6},
  [676] = {.lex_state = 5, .external_lex_state = 2},
  [677] = {.lex_state = 5, .external_lex_state = 2},
  [678] = {.lex_state = 8, .external_lex_state = 4},
  [679] = {.lex_state = 8, .external_lex_state = 4},
  [680] = {.lex_state = 8, .external_lex_state = 4},
  [681] = {.lex_state = 15, .external_lex_state = 6},
  [682] = {.lex_state = 8, .external_lex_state = 4},
  [683] = {.lex_state = 93, .external_lex_state = 4},
  [684] = {.lex_state = 93, .external_lex_state = 4},
  [685] = {.lex_state = 95, .external_lex_state = 4},
  [686] = {.lex_state = 95, .external_lex_state = 4},
  [687] = {.lex_state = 95, .external_lex_state = 4},
  [688] = {.lex_state = 95, .external_lex_state = 4},
  [689] = {.lex_state = 95, .external_lex_state = 4},
  [690] = {.lex_state = 95, .external_lex_state = 4},
  [691] = {.lex_state = 2, .external_lex_state = 7},
  [692] = {.lex_state = 95, .external_lex_state = 4},
  [693] = {.lex_state = 2, .external_lex_state = 7},
  [694] = {.lex_state = 2, .external_lex_state = 7},
  [695] = {.lex_state = 95, .external_lex_state = 4},
  [696] = {.lex_state = 2, .external_lex_state = 7},
  [697] = {.lex_state = 2, .external_lex_state = 7},
  [698] = {.lex_state = 2, .external_lex_state = 7},
  [699] = {.lex_state = 95, .external_lex_state = 4},
  [700] = {.lex_state = 2, .external_lex_state = 7},
  [701] = {.lex_state = 95, .external_lex_state = 4},
  [702] = {.lex_state = 95, .external_lex_state = 4},
  [703] = {.lex_state = 95, .external_lex_state = 4},
  [704] = {.lex_state = 95, .external_lex_state = 4},
  [705] = {.lex_state = 2, .external_lex_state = 7},
  [706] = {.lex_state = 95, .external_lex_state = 4},
  [707] = {.lex_state = 2, .external_lex_state = 7},
  [708] = {.lex_state = 95, .external_lex_state = 4},
  [709] = {.lex_state = 2, .external_lex_state = 7},
  [710] = {.lex_state = 95, .external_lex_state = 4},
  [711] = {.lex_state = 95, .external_lex_state = 4},
  [712] = {.lex_state = 95, .external_lex_state = 4},
  [713] = {.lex_state = 6, .external_lex_state = 4},
  [714] = {.lex_state = 95, .external_lex_state = 4},
  [715] = {.lex_state = 2, .external_lex_state = 7},
  [716] = {.lex_state = 95, .external_lex_state = 4},
  [717] = {.lex_state = 2, .external_lex_state = 7},
  [718] = {.lex_state = 2, .external_lex_state = 7},
  [719] = {.lex_state = 95, .external_lex_state = 4},
  [720] = {.lex_state = 2, .external_lex_state = 7},
  [721] = {.lex_state = 2, .external_lex_state = 7},
  [722] = {.lex_state = 4, .external_lex_state = 8},
  [723] = {.lex_state = 4, .external_lex_state = 8},
  [724] = {.lex_state = 95, .external_lex_state = 4},
  [725] = {.lex_state = 95, .external_lex_state = 4},
  [726] = {.lex_state = 4, .external_lex_state = 8},
  [727] = {.lex_state = 95, .external_lex_state = 4},
  [728] = {.lex_state = 4, .external_lex_state = 8},
  [729] = {.lex_state = 4, .external_lex_state = 8},
  [730] = {.lex_state = 4, .external_lex_state = 8},
  [731] = {.lex_state = 6, .external_lex_state = 4},
  [732] = {.lex_state = 4, .external_lex_state = 8},
  [733] = {.lex_state = 4, .external_lex_state = 8},
  [734] = {.lex_state = 4, .external_lex_state = 8},
  [735] = {.lex_state = 4, .external_lex_state = 8},
  [736] = {.lex_state = 4, .external_lex_state = 8},
  [737] = {.lex_state = 4, .external_lex_state = 8},
  [738] = {.lex_state = 95, .external_lex_state = 4},
  [739] = {.lex_state = 95, .external_lex_state = 4},
  [740] = {.lex_state = 4, .external_lex_state = 8},
  [741] = {.lex_state = 95, .external_lex_state = 4},
  [742] = {.lex_state = 4, .external_lex_state = 8},
  [743] = {.lex_state = 95, .external_lex_state = 4},
  [744] = {.lex_state = 4, .external_lex_state = 8},
  [745] = {.lex_state = 2, .external_lex_state = 9},
  [746] = {.lex_state = 2, .external_lex_state = 9},
  [747] = {.lex_state = 10, .external_lex_state = 4},
  [748] = {.lex_state = 11, .external_lex_state = 4},
  [749] = {.lex_state = 11, .external_lex_state = 4},
  [750] = {.lex_state = 2, .external_lex_state = 9},
  [751] = {.lex_state = 11, .external_lex_state = 4},
  [752] = {.lex_state = 95, .external_lex_state = 4},
  [753] = {.lex_state = 3, .external_lex_state = 10},
  [754] = {.lex_state = 95, .external_lex_state = 4},
  [755] = {.lex_state = 2, .external_lex_state = 9},
  [756] = {.lex_state = 2, .external_lex_state = 9},
  [757] = {.lex_state = 2, .external_lex_state = 9},
  [758] = {.lex_state = 2, .external_lex_state = 9},
  [759] = {.lex_state = 95, .external_lex_state = 4},
  [760] = {.lex_state = 2, .external_lex_state = 9},
  [761] = {.lex_state = 2, .external_lex_state = 9},
  [762] = {.lex_state = 2, .external_lex_state = 9},
  [763] = {.lex_state = 95, .external_lex_state = 4},
  [764] = {.lex_state = 3, .external_lex_state = 10},
  [765] = {.lex_state = 2, .external_lex_state = 9},
  [766] = {.lex_state = 3, .external_lex_state = 10},
  [767] = {.lex_state = 11, .external_lex_state = 4},
  [768] = {.lex_state = 10, .external_lex_state = 4},
  [769] = {.lex_state = 2, .external_lex_state = 9},
  [770] = {.lex_state = 2, .external_lex_state = 9},
  [771] = {.lex_state = 2, .external_lex_state = 9},
  [772] = {.lex_state = 10, .external_lex_state = 4},
  [773] = {.lex_state = 3, .external_lex_state = 10},
  [774] = {.lex_state = 10, .external_lex_state = 4},
  [775] = {.lex_state = 2, .external_lex_state = 9},
  [776] = {.lex_state = 3, .external_lex_state = 10},
  [777] = {.lex_state = 3, .external_lex_state = 10},
  [778] = {.lex_state = 11, .external_lex_state = 4},
  [779] = {.lex_state = 2, .external_lex_state = 9},
  [780] = {.lex_state = 2, .external_lex_state = 9},
  [781] = {.lex_state = 2, .external_lex_state = 9},
  [782] = {.lex_state = 2, .external_lex_state = 9},
  [783] = {.lex_state = 3, .external_lex_state = 10},
  [784] = {.lex_state = 4, .external_lex_state = 11},
  [785] = {.lex_state = 4, .external_lex_state = 11},
  [786] = {.lex_state = 4, .external_lex_state = 11},
  [787] = {.lex_state = 10, .external_lex_state = 4},
  [788] = {.lex_state = 4, .external_lex_state = 11},
  [789] = {.lex_state = 4, .external_lex_state = 11},
  [790] = {.lex_state = 4, .external_lex_state = 11},
  [791] = {.lex_state = 4, .external_lex_state = 11},
  [792] = {.lex_state = 4, .external_lex_state = 11},
  [793] = {.lex_state = 4, .external_lex_state = 11},
  [794] = {.lex_state = 4, .external_lex_state = 11},
  [795] = {.lex_state = 4, .external_lex_state = 11},
  [796] = {.lex_state = 4, .external_lex_state = 11},
  [797] = {.lex_state = 4, .external_lex_state = 11},
  [798] = {.lex_state = 4, .external_lex_state = 11},
  [799] = {.lex_state = 4, .external_lex_state = 11},
  [800] = {.lex_state = 15, .external_lex_state = 6},
  [801] = {.lex_state = 4, .external_lex_state = 11},
  [802] = {.lex_state = 4, .external_lex_state = 11},
  [803] = {.lex_state = 4, .external_lex_state = 11},
  [804] = {.lex_state = 10, .external_lex_state = 4},
  [805] = {.lex_state = 4, .external_lex_state = 11},
  [806] = {.lex_state = 4, .external_lex_state = 11},
  [807] = {.lex_state = 4, .external_lex_state = 11},
  [808] = {.lex_state = 4, .external_lex_state = 11},
  [809] = {.lex_state = 4, .external_lex_state = 11},
  [810] = {.lex_state = 4, .external_lex_state = 11},
  [811] = {.lex_state = 4, .external_lex_state = 11},
  [812] = {.lex_state = 4, .external_lex_state = 11},
  [813] = {.lex_state = 4, .external_lex_state = 11},
  [814] = {.lex_state = 4, .external_lex_state = 11},
  [815] = {.lex_state = 4, .external_lex_state = 11},
  [816] = {.lex_state = 4, .external_lex_state = 11},
  [817] = {.lex_state = 4, .external_lex_state = 11},
  [818] = {.lex_state = 4, .external_lex_state = 11},
  [819] = {.lex_state = 4, .external_lex_state = 11},
  [820] = {.lex_state = 4, .external_lex_state = 11},
  [821] = {.lex_state = 4, .external_lex_state = 11},
  [822] = {.lex_state = 4, .external_lex_state = 11},
  [823] = {.lex_state = 4, .external_lex_state = 11},
  [824] = {.lex_state = 4, .external_lex_state = 11},
  [825] = {.lex_state = 4, .external_lex_state = 11},
  [826] = {.lex_state = 2, .external_lex_state = 7},
  [827] = {.lex_state = 15, .external_lex_state = 4},
  [828] = {.lex_state = 2, .external_lex_state = 7},
  [829] = {.lex_state = 15, .external_lex_state = 6},
  [830] = {.lex_state = 15, .external_lex_state = 6},
  [831] = {.lex_state = 15, .external_lex_state = 6},
  [832] = {.lex_state = 2, .external_lex_state = 7},
  [833] = {.lex_state = 15, .external_lex_state = 4},
  [834] = {.lex_state = 15, .external_lex_state = 6},
  [835] = {.lex_state = 6, .external_lex_state = 4},
  [836] = {.lex_state = 0, .external_lex_state = 10},
  [837] = {.lex_state = 15, .external_lex_state = 6},
  [838] = {.lex_state = 15, .external_lex_state = 6},
  [839] = {.lex_state = 15, .external_lex_state = 6},
  [840] = {.lex_state = 95, .external_lex_state = 4},
  [841] = {.lex_state = 15, .external_lex_state = 4},
  [842] = {.lex_state = 15, .external_lex_state = 6},
  [843] = {.lex_state = 15, .external_lex_state = 4},
  [844] = {.lex_state = 95, .external_lex_state = 4},
  [845] = {.lex_state = 95, .external_lex_state = 4},
  [846] = {.lex_state = 93, .external_lex_state = 4},
  [847] = {.lex_state = 4, .external_lex_state = 8},
  [848] = {.lex_state = 93, .external_lex_state = 4},
  [849] = {.lex_state = 95, .external_lex_state = 4},
  [850] = {.lex_state = 93, .external_lex_state = 5},
  [851] = {.lex_state = 93, .external_lex_state = 5},
  [852] = {.lex_state = 3, .external_lex_state = 4},
  [853] = {.lex_state = 4, .external_lex_state = 8},
  [854] = {.lex_state = 15, .external_lex_state = 4},
  [855] = {.lex_state = 2, .external_lex_state = 9},
  [856] = {.lex_state = 95, .external_lex_state = 4},
  [857] = {.lex_state = 95, .external_lex_state = 4},
  [858] = {.lex_state = 2, .external_lex_state = 9},
  [859] = {.lex_state = 4, .external_lex_state = 8},
  [860] = {.lex_state = 4, .external_lex_state = 11},
  [861] = {.lex_state = 3, .external_lex_state = 4},
  [862] = {.lex_state = 12, .external_lex_state = 4},
  [863] = {.lex_state = 12, .external_lex_state = 4},
  [864] = {.lex_state = 3, .external_lex_state = 4},
  [865] = {.lex_state = 12, .external_lex_state = 4},
  [866] = {.lex_state = 12, .external_lex_state = 4},
  [867] = {.lex_state = 12, .external_lex_state = 4},
  [868] = {.lex_state = 3, .external_lex_state = 4},
  [869] = {.lex_state = 12, .external_lex_state = 4},
  [870] = {.lex_state = 12, .external_lex_state = 4},
  [871] = {.lex_state = 12, .external_lex_state = 4},
  [872] = {.lex_state = 3, .external_lex_state = 4},
  [873] = {.lex_state = 12, .external_lex_state = 4},
  [874] = {.lex_state = 12, .external_lex_state = 4},
  [875] = {.lex_state = 12, .external_lex_state = 4},
  [876] = {.lex_state = 3, .external_lex_state = 4},
  [877] = {.lex_state = 12, .external_lex_state = 4},
  [878] = {.lex_state = 12, .external_lex_state = 4},
  [879] = {.lex_state = 3, .external_lex_state = 4},
  [880] = {.lex_state = 12, .external_lex_state = 4},
  [881] = {.lex_state = 3, .external_lex_state = 4},
  [882] = {.lex_state = 12, .external_lex_state = 4},
  [883] = {.lex_state = 12, .external_lex_state = 4},
  [884] = {.lex_state = 12, .external_lex_state = 4},
  [885] = {.lex_state = 12, .external_lex_state = 4},
  [886] = {.lex_state = 3, .external_lex_state = 4},
  [887] = {.lex_state = 12, .external_lex_state = 4},
  [888] = {.lex_state = 3, .external_lex_state = 4},
  [889] = {.lex_state = 12, .external_lex_state = 4},
  [890] = {.lex_state = 12, .external_lex_state = 4},
  [891] = {.lex_state = 12, .external_lex_state = 4},
  [892] = {.lex_state = 4, .external_lex_state = 11},
  [893] = {.lex_state = 12, .external_lex_state = 4},
  [894] = {.lex_state = 3, .external_lex_state = 4},
  [895] = {.lex_state = 12, .external_lex_state = 4},
  [896] = {.lex_state = 12, .external_lex_state = 4},
  [897] = {.lex_state = 3, .external_lex_state = 4},
  [898] = {.lex_state = 3, .external_lex_state = 4},
  [899] = {.lex_state = 12, .external_lex_state = 4},
  [900] = {.lex_state = 12, .external_lex_state = 4},
  [901] = {.lex_state = 3, .external_lex_state = 4},
  [902] = {.lex_state = 12, .external_lex_state = 4},
  [903] = {.lex_state = 3, .external_lex_state = 4},
  [904] = {.lex_state = 3, .external_lex_state = 4},
  [905] = {.lex_state = 12, .external_lex_state = 4},
  [906] = {.lex_state = 3, .external_lex_state = 4},
  [907] = {.lex_state = 12, .external_lex_state = 4},
  [908] = {.lex_state = 0, .external_lex_state = 6},
  [909] = {.lex_state = 11, .external_lex_state = 4},
  [910] = {.lex_state = 0, .external_lex_state = 4},
  [911] = {.lex_state = 0, .external_lex_state = 4},
  [912] = {.lex_state = 0, .external_lex_state = 4},
  [913] = {.lex_state = 0, .external_lex_state = 4},
  [914] = {.lex_state = 0, .external_lex_state = 4},
  [915] = {.lex_state = 0, .external_lex_state = 4},
  [916] = {.lex_state = 19, .external_lex_state = 4},
  [917] = {.lex_state = 93, .external_lex_state = 5},
  [918] = {.lex_state = 0, .external_lex_state = 6},
  [919] = {.lex_state = 0, .external_lex_state = 4},
  [920] = {.lex_state = 0, .external_lex_state = 4},
  [921] = {.lex_state = 0, .external_lex_state = 6},
  [922] = {.lex_state = 0, .external_lex_state = 4},
  [923] = {.lex_state = 0, .external_lex_state = 4},
  [924] = {.lex_state = 0, .external_lex_state = 4},
  [925] = {.lex_state = 93, .external_lex_state = 5},
  [926] = {.lex_state = 19, .external_lex_state = 4},
  [927] = {.lex_state = 0, .external_lex_state = 6},
  [928] = {.lex_state = 93, .external_lex_state = 5},
  [929] = {.lex_state = 19, .external_lex_state = 4},
  [930] = {.lex_state = 0, .external_lex_state = 4},
  [931] = {.lex_state = 3, .external_lex_state = 4},
  [932] = {.lex_state = 19, .external_lex_state = 4},
  [933] = {.lex_state = 11, .external_lex_state = 4},
  [934] = {.lex_state = 11, .external_lex_state = 4},
  [935] = {.lex_state = 19, .external_lex_state = 4},
  [936] = {.lex_state = 0, .external_lex_state = 4},
  [937] = {.lex_state = 19, .external_lex_state = 4},
  [938] = {.lex_state = 11, .external_lex_state = 4},
  [939] = {.lex_state = 0, .external_lex_state = 4},
  [940] = {.lex_state = 11, .external_lex_state = 4},
  [941] = {.lex_state = 0, .external_lex_state = 4},
  [942] = {.lex_state = 0, .external_lex_state = 4},
  [943] = {.lex_state = 0, .external_lex_state = 4},
  [944] = {.lex_state = 19, .external_lex_state = 4},
  [945] = {.lex_state = 0, .external_lex_state = 6},
  [946] = {.lex_state = 19, .external_lex_state = 4},
  [947] = {.lex_state = 19, .external_lex_state = 4},
  [948] = {.lex_state = 95, .external_lex_state = 4},
  [949] = {.lex_state = 19, .external_lex_state = 4},
  [950] = {.lex_state = 95, .external_lex_state = 4},
  [951] = {.lex_state = 0, .external_lex_state = 4},
  [952] = {.lex_state = 0, .external_lex_state = 4},
  [953] = {.lex_state = 19, .external_lex_state = 4},
  [954] = {.lex_state = 0, .external_lex_state = 4},
  [955] = {.lex_state = 3, .external_lex_state = 4},
  [956] = {.lex_state = 0, .external_lex_state = 4},
  [957] = {.lex_state = 0, .external_lex_state = 4},
  [958] = {.lex_state = 95, .external_lex_state = 4},
  [959] = {.lex_state = 0, .external_lex_state = 4},
  [960] = {.lex_state = 3, .external_lex_state = 4},
  [961] = {.lex_state = 19, .external_lex_state = 4},
  [962] = {.lex_state = 15, .external_lex_state = 4},
  [963] = {.lex_state = 0, .external_lex_state = 4},
  [964] = {.lex_state = 19, .external_lex_state = 4},
  [965] = {.lex_state = 95, .external_lex_state = 4},
  [966] = {.lex_state = 19, .external_lex_state = 4},
  [967] = {.lex_state = 19, .external_lex_state = 4},
  [968] = {.lex_state = 0, .external_lex_state = 4},
  [969] = {.lex_state = 3, .external_lex_state = 4},
  [970] = {.lex_state = 0, .external_lex_state = 4},
  [971] = {.lex_state = 19, .external_lex_state = 4},
  [972] = {.lex_state = 0, .external_lex_state = 6},
  [973] = {.lex_state = 93, .external_lex_state = 5},
  [974] = {.lex_state = 19, .external_lex_state = 4},
  [975] = {.lex_state = 93, .external_lex_state = 5},
  [976] = {.lex_state = 95, .external_lex_state = 4},
  [977] = {.lex_state = 19, .external_lex_state = 4},
  [978] = {.lex_state = 93, .external_lex_state = 5},
  [979] = {.lex_state = 0, .external_lex_state = 4},
  [980] = {.lex_state = 0, .external_lex_state = 6},
  [981] = {.lex_state = 19, .external_lex_state = 4},
  [982] = {.lex_state = 19, .external_lex_state = 4},
  [983] = {.lex_state = 0, .external_lex_state = 6},
  [984] = {.lex_state = 19, .external_lex_state = 4},
  [985] = {.lex_state = 19, .external_lex_state = 4},
  [986] = {.lex_state = 93, .external_lex_state = 5},
  [987] = {.lex_state = 93, .external_lex_state = 5},
  [988] = {.lex_state = 19, .external_lex_state = 4},
  [989] = {.lex_state = 19, .external_lex_state = 4},
  [990] = {.lex_state = 19, .external_lex_state = 4},
  [991] = {.lex_state = 19, .external_lex_state = 4},
  [992] = {.lex_state = 93, .external_lex_state = 5},
  [993] = {.lex_state = 19, .external_lex_state = 4},
  [994] = {.lex_state = 11, .external_lex_state = 4},
  [995] = {.lex_state = 0, .external_lex_state = 4},
  [996] = {.lex_state = 11, .external_lex_state = 4},
  [997] = {.lex_state = 0, .external_lex_state = 4},
  [998] = {.lex_state = 3, .external_lex_state = 4},
  [999] = {.lex_state = 0, .external_lex_state = 4},
  [1000] = {.lex_state = 19, .external_lex_state = 4},
  [1001] = {.lex_state = 0, .external_lex_state = 4},
  [1002] = {.lex_state = 0, .external_lex_state = 4},
  [1003] = {.lex_state = 0, .external_lex_state = 4},
  [1004] = {.lex_state = 0, .external_lex_state = 4},
  [1005] = {.lex_state = 93, .external_lex_state = 4},
  [1006] = {.lex_state = 93, .external_lex_state = 4},
  [1007] = {.lex_state = 93, .external_lex_state = 4},
  [1008] = {.lex_state = 0, .external_lex_state = 4},
  [1009] = {.lex_state = 93, .external_lex_state = 4},
  [1010] = {.lex_state = 0, .external_lex_state = 4},
  [1011] = {.lex_state = 93, .external_lex_state = 4},
  [1012] = {.lex_state = 93, .external_lex_state = 4},
  [1013] = {.lex_state = 9, .external_lex_state = 4},
  [1014] = {.lex_state = 15, .external_lex_state = 4},
  [1015] = {.lex_state = 15, .external_lex_state = 4},
  [1016] = {.lex_state = 95, .external_lex_state = 4},
  [1017] = {.lex_state = 0, .external_lex_state = 4},
  [1018] = {.lex_state = 15, .external_lex_state = 4},
  [1019] = {.lex_state = 95, .external_lex_state = 4},
  [1020] = {.lex_state = 0, .external_lex_state = 4},
  [1021] = {.lex_state = 15, .external_lex_state = 4},
  [1022] = {.lex_state = 15, .external_lex_state = 4},
  [1023] = {.lex_state = 0, .external_lex_state = 4},
  [1024] = {.lex_state = 0, .external_lex_state = 4},
  [1025] = {.lex_state = 95, .external_lex_state = 4},
  [1026] = {.lex_state = 15, .external_lex_state = 4},
  [1027] = {.lex_state = 95, .external_lex_state = 4},
  [1028] = {.lex_state = 15, .external_lex_state = 4},
  [1029] = {.lex_state = 0, .external_lex_state = 4},
  [1030] = {.lex_state = 0, .external_lex_state = 4},
  [1031] = {.lex_state = 15, .external_lex_state = 4},
  [1032] = {.lex_state = 0, .external_lex_state = 4},
  [1033] = {.lex_state = 0, .external_lex_state = 4},
  [1034] = {.lex_state = 0, .external_lex_state = 4},
  [1035] = {.lex_state = 0, .external_lex_state = 4},
  [1036] = {.lex_state = 0, .external_lex_state = 4},
  [1037] = {.lex_state = 0, .external_lex_state = 4},
  [1038] = {.lex_state = 95, .external_lex_state = 4},
  [1039] = {.lex_state = 0, .external_lex_state = 4},
  [1040] = {.lex_state = 0, .external_lex_state = 4},
  [1041] = {.lex_state = 0, .external_lex_state = 4},
  [1042] = {.lex_state = 0, .external_lex_state = 4},
  [1043] = {.lex_state = 0, .external_lex_state = 4},
  [1044] = {.lex_state = 93, .external_lex_state = 4},
  [1045] = {.lex_state = 0, .external_lex_state = 4},
  [1046] = {.lex_state = 0, .external_lex_state = 4},
  [1047] = {.lex_state = 0, .external_lex_state = 4},
  [1048] = {.lex_state = 0, .external_lex_state = 4},
  [1049] = {.lex_state = 0, .external_lex_state = 4},
  [1050] = {.lex_state = 3, .external_lex_state = 4},
  [1051] = {.lex_state = 0, .external_lex_state = 5},
  [1052] = {.lex_state = 0, .external_lex_state = 4},
  [1053] = {.lex_state = 0, .external_lex_state = 4},
  [1054] = {.lex_state = 0, .external_lex_state = 4},
  [1055] = {.lex_state = 3, .external_lex_state = 4},
  [1056] = {.lex_state = 0, .external_lex_state = 5},
  [1057] = {.lex_state = 0, .external_lex_state = 5},
  [1058] = {.lex_state = 0, .external_lex_state = 4},
  [1059] = {.lex_state = 0, .external_lex_state = 4},
  [1060] = {.lex_state = 0, .external_lex_state = 4},
  [1061] = {.lex_state = 0, .external_lex_state = 4},
  [1062] = {.lex_state = 0, .external_lex_state = 4},
  [1063] = {.lex_state = 0, .external_lex_state = 4},
  [1064] = {.lex_state = 0, .external_lex_state = 4},
  [1065] = {.lex_state = 0, .external_lex_state = 4},
  [1066] = {.lex_state = 5, .external_lex_state = 4},
  [1067] = {.lex_state = 3, .external_lex_state = 4},
  [1068] = {.lex_state = 0, .external_lex_state = 4},
  [1069] = {.lex_state = 0, .external_lex_state = 4},
  [1070] = {.lex_state = 3, .external_lex_state = 4},
  [1071] = {.lex_state = 0, .external_lex_state = 4},
  [1072] = {.lex_state = 15, .external_lex_state = 4},
  [1073] = {.lex_state = 95, .external_lex_state = 4},
  [1074] = {.lex_state = 3, .external_lex_state = 4},
  [1075] = {.lex_state = 0, .external_lex_state = 4},
  [1076] = {.lex_state = 0, .external_lex_state = 4},
  [1077] = {.lex_state = 0, .external_lex_state = 4},
  [1078] = {.lex_state = 0, .external_lex_state = 4},
  [1079] = {.lex_state = 0, .external_lex_state = 4},
  [1080] = {.lex_state = 95, .external_lex_state = 4},
  [1081] = {.lex_state = 0, .external_lex_state = 4},
  [1082] = {.lex_state = 3, .external_lex_state = 4},
  [1083] = {.lex_state = 3, .external_lex_state = 4},
  [1084] = {.lex_state = 0, .external_lex_state = 4},
  [1085] = {.lex_state = 3, .external_lex_state = 4},
  [1086] = {.lex_state = 3, .external_lex_state = 4},
  [1087] = {.lex_state = 3, .external_lex_state = 4},
  [1088] = {.lex_state = 0, .external_lex_state = 4},
  [1089] = {.lex_state = 95, .external_lex_state = 4},
  [1090] = {.lex_state = 0, .external_lex_state = 4},
  [1091] = {.lex_state = 0, .external_lex_state = 4},
  [1092] = {.lex_state = 0, .external_lex_state = 4},
  [1093] = {.lex_state = 0, .external_lex_state = 4},
  [1094] = {.lex_state = 0, .external_lex_state = 4},
  [1095] = {.lex_state = 0, .external_lex_state = 4},
  [1096] = {.lex_state = 0, .external_lex_state = 4},
  [1097] = {.lex_state = 0, .external_lex_state = 4},
  [1098] = {.lex_state = 0, .external_lex_state = 4},
  [1099] = {.lex_state = 0, .external_lex_state = 4},
  [1100] = {.lex_state = 95, .external_lex_state = 4},
  [1101] = {.lex_state = 0, .external_lex_state = 4},
  [1102] = {.lex_state = 0, .external_lex_state = 4},
  [1103] = {.lex_state = 0, .external_lex_state = 4},
  [1104] = {.lex_state = 3, .external_lex_state = 4},
  [1105] = {.lex_state = 3, .external_lex_state = 4},
  [1106] = {.lex_state = 0, .external_lex_state = 4},
  [1107] = {.lex_state = 0, .external_lex_state = 4},
  [1108] = {.lex_state = 0, .external_lex_state = 4},
  [1109] = {.lex_state = 5, .external_lex_state = 4},
  [1110] = {.lex_state = 3, .external_lex_state = 4},
  [1111] = {.lex_state = 0, .external_lex_state = 4},
  [1112] = {.lex_state = 3, .external_lex_state = 4},
  [1113] = {.lex_state = 0, .external_lex_state = 4},
  [1114] = {.lex_state = 0, .external_lex_state = 4},
  [1115] = {.lex_state = 0, .external_lex_state = 4},
  [1116] = {.lex_state = 3, .external_lex_state = 4},
  [1117] = {.lex_state = 0, .external_lex_state = 4},
  [1118] = {.lex_state = 3, .external_lex_state = 4},
  [1119] = {.lex_state = 95, .external_lex_state = 4},
  [1120] = {.lex_state = 0, .external_lex_state = 4},
  [1121] = {.lex_state = 0, .external_lex_state = 4},
  [1122] = {.lex_state = 0, .external_lex_state = 4},
  [1123] = {.lex_state = 0, .external_lex_state = 4},
  [1124] = {.lex_state = 0, .external_lex_state = 4},
  [1125] = {.lex_state = 0, .external_lex_state = 4},
  [1126] = {.lex_state = 3, .external_lex_state = 4},
  [1127] = {.lex_state = 0, .external_lex_state = 4},
  [1128] = {.lex_state = 0, .external_lex_state = 4},
  [1129] = {.lex_state = 95, .external_lex_state = 4},
  [1130] = {.lex_state = 9, .external_lex_state = 4},
  [1131] = {.lex_state = 0, .external_lex_state = 4},
  [1132] = {.lex_state = 0, .external_lex_state = 4},
  [1133] = {.lex_state = 0, .external_lex_state = 4},
  [1134] = {.lex_state = 0, .external_lex_state = 4},
  [1135] = {.lex_state = 15, .external_lex_state = 4},
  [1136] = {.lex_state = 95, .external_lex_state = 4},
  [1137] = {.lex_state = 0, .external_lex_state = 4},
  [1138] = {.lex_state = 5, .external_lex_state = 4},
  [1139] = {.lex_state = 3, .external_lex_state = 4},
  [1140] = {.lex_state = 15, .external_lex_state = 4},
  [1141] = {.lex_state = 0, .external_lex_state = 4},
  [1142] = {.lex_state = 15, .external_lex_state = 4},
  [1143] = {.lex_state = 0, .external_lex_state = 4},
  [1144] = {.lex_state = 0, .external_lex_state = 4},
  [1145] = {.lex_state = 95, .external_lex_state = 4},
  [1146] = {.lex_state = 0, .external_lex_state = 4},
  [1147] = {.lex_state = 9, .external_lex_state = 4},
  [1148] = {.lex_state = 0, .external_lex_state = 4},
  [1149] = {.lex_state = 15, .external_lex_state = 4},
  [1150] = {.lex_state = 0, .external_lex_state = 4},
  [1151] = {.lex_state = 0, .external_lex_state = 4},
  [1152] = {.lex_state = 0, .external_lex_state = 4},
  [1153] = {.lex_state = 0, .external_lex_state = 4},
  [1154] = {.lex_state = 15, .external_lex_state = 4},
  [1155] = {.lex_state = 0, .external_lex_state = 4},
  [1156] = {.lex_state = 15, .external_lex_state = 4},
  [1157] = {.lex_state = 15, .external_lex_state = 4},
  [1158] = {.lex_state = 0, .external_lex_state = 4},
  [1159] = {.lex_state = 3, .external_lex_state = 4},
  [1160] = {.lex_state = 3, .external_lex_state = 4},
  [1161] = {.lex_state = 9, .external_lex_state = 4},
  [1162] = {.lex_state = 0, .external_lex_state = 5},
  [1163] = {.lex_state = 15, .external_lex_state = 4},
  [1164] = {.lex_state = 9, .external_lex_state = 4},
  [1165] = {.lex_state = 0, .external_lex_state = 4},
  [1166] = {.lex_state = 0, .external_lex_state = 4},
  [1167] = {.lex_state = 0, .external_lex_state = 4},
  [1168] = {.lex_state = 15, .external_lex_state = 4},
  [1169] = {.lex_state = 0, .external_lex_state = 4},
  [1170] = {.lex_state = 15, .external_lex_state = 4},
  [1171] = {.lex_state = 0, .external_lex_state = 5},
  [1172] = {.lex_state = 0, .external_lex_state = 4},
  [1173] = {.lex_state = 0, .external_lex_state = 5},
  [1174] = {.lex_state = 3, .external_lex_state = 4},
  [1175] = {.lex_state = 9, .external_lex_state = 4},
  [1176] = {.lex_state = 15, .external_lex_state = 4},
  [1177] = {.lex_state = 15, .external_lex_state = 4},
  [1178] = {.lex_state = 95, .external_lex_state = 4},
  [1179] = {.lex_state = 0, .external_lex_state = 4},
  [1180] = {.lex_state = 0, .external_lex_state = 4},
  [1181] = {.lex_state = 0, .external_lex_state = 4},
  [1182] = {.lex_state = 15, .external_lex_state = 4},
  [1183] = {.lex_state = 0, .external_lex_state = 4},
  [1184] = {.lex_state = 15, .external_lex_state = 4},
  [1185] = {.lex_state = 0, .external_lex_state = 4},
  [1186] = {.lex_state = 0, .external_lex_state = 4},
  [1187] = {.lex_state = 0, .external_lex_state = 5},
  [1188] = {.lex_state = 0, .external_lex_state = 4},
  [1189] = {.lex_state = 9, .external_lex_state = 4},
  [1190] = {.lex_state = 0, .external_lex_state = 4},
  [1191] = {.lex_state = 15, .external_lex_state = 4},
  [1192] = {.lex_state = 0, .external_lex_state = 4},
  [1193] = {.lex_state = 0, .external_lex_state = 4},
  [1194] = {.lex_state = 0, .external_lex_state = 4},
  [1195] = {.lex_state = 0, .external_lex_state = 4},
  [1196] = {.lex_state = 15, .external_lex_state = 4},
  [1197] = {.lex_state = 0, .external_lex_state = 4},
  [1198] = {.lex_state = 15, .external_lex_state = 4},
  [1199] = {.lex_state = 0, .external_lex_state = 4},
  [1200] = {.lex_state = 9, .external_lex_state = 4},
  [1201] = {.lex_state = 0, .external_lex_state = 4},
  [1202] = {.lex_state = 15, .external_lex_state = 4},
  [1203] = {.lex_state = 0, .external_lex_state = 4},
  [1204] = {.lex_state = 0, .external_lex_state = 4},
  [1205] = {.lex_state = 0, .external_lex_state = 4},
  [1206] = {.lex_state = 15, .external_lex_state = 4},
  [1207] = {.lex_state = 0, .external_lex_state = 5},
  [1208] = {.lex_state = 15, .external_lex_state = 4},
  [1209] = {.lex_state = 3, .external_lex_state = 4},
  [1210] = {.lex_state = 95, .external_lex_state = 4},
  [1211] = {.lex_state = 0, .external_lex_state = 4},
  [1212] = {.lex_state = 95, .external_lex_state = 4},
  [1213] = {.lex_state = 0, .external_lex_state = 4},
  [1214] = {.lex_state = 95, .external_lex_state = 4},
  [1215] = {.lex_state = 0, .external_lex_state = 4},
  [1216] = {.lex_state = 95, .external_lex_state = 4},
  [1217] = {.lex_state = 0, .external_lex_state = 4},
  [1218] = {.lex_state = 95, .external_lex_state = 4},
  [1219] = {.lex_state = 0, .external_lex_state = 4},
  [1220] = {.lex_state = 0, .external_lex_state = 4},
  [1221] = {.lex_state = 0, .external_lex_state = 4},
  [1222] = {.lex_state = 0, .external_lex_state = 4},
  [1223] = {.lex_state = 95, .external_lex_state = 4},
  [1224] = {.lex_state = 5, .external_lex_state = 4},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_keyword] = ACTIONS(1),
    [sym_num_literal] = ACTIONS(1),
    [sym_ident] = ACTIONS(1),
    [sym_raw_enum_tag] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_force] = ACTIONS(1),
    [anon_sym_optional] = ACTIONS(1),
    [anon_sym_priority] = ACTIONS(1),
    [anon_sym_doc] = ACTIONS(1),
    [anon_sym_rec] = ACTIONS(1),
    [anon_sym_not_exported] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_fun] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_forall] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_Array] = ACTIONS(1),
    [anon_sym_Dyn] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_double_quote] = ACTIONS(1),
    [sym_str_esc_char] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_Number] = ACTIONS(1),
    [anon_sym_Bool] = ACTIONS(1),
    [anon_sym_String] = ACTIONS(1),
    [anon_sym_LBRACK_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACK] = ACTIONS(1),
    [sym_multstr_start] = ACTIONS(1),
    [sym_multstr_end] = ACTIONS(1),
    [sym__str_start] = ACTIONS(1),
    [sym__str_end] = ACTIONS(1),
    [sym_interpolation_start] = ACTIONS(1),
    [sym_interpolation_end] = ACTIONS(1),
    [sym_quoted_enum_tag_start] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_term] = STATE(1150),
    [sym_uni_term] = STATE(688),
    [sym_let_expr] = STATE(690),
    [sym_let_in_block] = STATE(39),
    [sym_fun_expr] = STATE(690),
    [sym_match_expr] = STATE(441),
    [sym_ite_expr] = STATE(690),
    [sym_annotated_infix_expr] = STATE(690),
    [sym_forall] = STATE(690),
    [sym_applicative] = STATE(88),
    [sym_type_array] = STATE(441),
    [sym_record_operand] = STATE(297),
    [sym_record_operation_chain] = STATE(299),
    [sym_uni_record] = STATE(266),
    [sym_atom] = STATE(299),
    [sym_bool] = STATE(266),
    [sym_str_chunks] = STATE(266),
    [sym_str_chunks_single] = STATE(303),
    [sym_str_chunks_multi] = STATE(303),
    [sym_quoted_enum_tag] = STATE(267),
    [sym_enum_tag] = STATE(84),
    [sym_enum_variant] = STATE(441),
    [sym_builtin] = STATE(266),
    [sym_infix_u_op_5] = STATE(184),
    [sym_infix_expr] = STATE(488),
    [sym_type_builtin] = STATE(275),
    [sym_type_atom] = STATE(266),
    [sym_num_literal] = ACTIONS(5),
    [sym_ident] = ACTIONS(7),
    [sym_raw_enum_tag] = ACTIONS(9),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(13),
    [anon_sym_match] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_Array] = ACTIONS(25),
    [anon_sym_Dyn] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(29),
    [anon_sym_null] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym__] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_PERCENT] = ACTIONS(37),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_Number] = ACTIONS(27),
    [anon_sym_Bool] = ACTIONS(27),
    [anon_sym_String] = ACTIONS(27),
    [anon_sym_LBRACK_PIPE] = ACTIONS(43),
    [sym_multstr_start] = ACTIONS(45),
    [sym__str_start] = ACTIONS(47),
    [sym_quoted_enum_tag_start] = ACTIONS(49),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_uni_term] = STATE(1095),
    [sym_let_expr] = STATE(690),
    [sym_let_in_block] = STATE(60),
    [sym_fun_expr] = STATE(690),
    [sym_match_expr] = STATE(142),
    [sym_ite_expr] = STATE(690),
    [sym_annotated_infix_expr] = STATE(690),
    [sym_forall] = STATE(690),
    [sym_applicative] = STATE(10),
    [sym_type_array] = STATE(142),
    [sym_record_operand] = STATE(92),
    [sym_record_operation_chain] = STATE(126),
    [sym_uni_record] = STATE(98),
    [sym_atom] = STATE(126),
    [sym_bool] = STATE(98),
    [sym_str_chunks] = STATE(98),
    [sym_str_chunks_single] = STATE(107),
    [sym_str_chunks_multi] = STATE(107),
    [sym_quoted_enum_tag] = STATE(89),
    [sym_enum_tag] = STATE(9),
    [sym_enum_variant] = STATE(142),
    [sym_builtin] = STATE(98),
    [sym_infix_b_op_2] = STATE(1188),
    [sym_infix_b_op_3] = STATE(1188),
    [sym_infix_b_op_4] = STATE(1188),
    [sym_infix_u_op_5] = STATE(157),
    [sym_infix_b_op_6] = STATE(1188),
    [sym_infix_b_op_7] = STATE(1188),
    [sym_infix_b_op_8] = STATE(1188),
    [sym_infix_lazy_b_op_9] = STATE(1185),
    [sym_infix_lazy_b_op_10] = STATE(1185),
    [sym_infix_b_op] = STATE(1183),
    [sym_infix_u_op_or_lazy_b_op] = STATE(1183),
    [sym_infix_op] = STATE(1221),
    [sym_curried_op] = STATE(1095),
    [sym_infix_expr] = STATE(464),
    [sym_type_builtin] = STATE(127),
    [sym_type_atom] = STATE(98),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_Array] = ACTIONS(71),
    [anon_sym_Dyn] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_AT] = ACTIONS(79),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_true] = ACTIONS(83),
    [anon_sym_false] = ACTIONS(83),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(87),
    [anon_sym_SLASH] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_AMP] = ACTIONS(95),
    [anon_sym_PIPE_GT] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(99),
    [anon_sym_LT_EQ] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(99),
    [anon_sym_GT_EQ] = ACTIONS(101),
    [anon_sym_EQ_EQ] = ACTIONS(103),
    [anon_sym_BANG_EQ] = ACTIONS(103),
    [anon_sym_AMP_AMP] = ACTIONS(105),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_Number] = ACTIONS(73),
    [anon_sym_Bool] = ACTIONS(73),
    [anon_sym_String] = ACTIONS(73),
    [anon_sym_LBRACK_PIPE] = ACTIONS(109),
    [sym_multstr_start] = ACTIONS(111),
    [sym__str_start] = ACTIONS(113),
    [sym_quoted_enum_tag_start] = ACTIONS(115),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_uni_term] = STATE(1167),
    [sym_let_expr] = STATE(690),
    [sym_let_in_block] = STATE(60),
    [sym_fun_expr] = STATE(690),
    [sym_match_expr] = STATE(142),
    [sym_ite_expr] = STATE(690),
    [sym_annotated_infix_expr] = STATE(690),
    [sym_forall] = STATE(690),
    [sym_applicative] = STATE(10),
    [sym_type_array] = STATE(142),
    [sym_record_operand] = STATE(92),
    [sym_record_operation_chain] = STATE(126),
    [sym_uni_record] = STATE(98),
    [sym_atom] = STATE(126),
    [sym_bool] = STATE(98),
    [sym_str_chunks] = STATE(98),
    [sym_str_chunks_single] = STATE(107),
    [sym_str_chunks_multi] = STATE(107),
    [sym_quoted_enum_tag] = STATE(89),
    [sym_enum_tag] = STATE(9),
    [sym_enum_variant] = STATE(142),
    [sym_builtin] = STATE(98),
    [sym_infix_b_op_2] = STATE(1188),
    [sym_infix_b_op_3] = STATE(1188),
    [sym_infix_b_op_4] = STATE(1188),
    [sym_infix_u_op_5] = STATE(157),
    [sym_infix_b_op_6] = STATE(1188),
    [sym_infix_b_op_7] = STATE(1188),
    [sym_infix_b_op_8] = STATE(1188),
    [sym_infix_lazy_b_op_9] = STATE(1185),
    [sym_infix_lazy_b_op_10] = STATE(1185),
    [sym_infix_b_op] = STATE(1183),
    [sym_infix_u_op_or_lazy_b_op] = STATE(1183),
    [sym_infix_op] = STATE(1221),
    [sym_curried_op] = STATE(1167),
    [sym_infix_expr] = STATE(464),
    [sym_type_builtin] = STATE(127),
    [sym_type_atom] = STATE(98),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_Array] = ACTIONS(71),
    [anon_sym_Dyn] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_AT] = ACTIONS(79),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_true] = ACTIONS(83),
    [anon_sym_false] = ACTIONS(83),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(87),
    [anon_sym_SLASH] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_AMP] = ACTIONS(95),
    [anon_sym_PIPE_GT] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(99),
    [anon_sym_LT_EQ] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(99),
    [anon_sym_GT_EQ] = ACTIONS(101),
    [anon_sym_EQ_EQ] = ACTIONS(103),
    [anon_sym_BANG_EQ] = ACTIONS(103),
    [anon_sym_AMP_AMP] = ACTIONS(105),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_Number] = ACTIONS(73),
    [anon_sym_Bool] = ACTIONS(73),
    [anon_sym_String] = ACTIONS(73),
    [anon_sym_LBRACK_PIPE] = ACTIONS(109),
    [sym_multstr_start] = ACTIONS(111),
    [sym__str_start] = ACTIONS(113),
    [sym_quoted_enum_tag_start] = ACTIONS(115),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_uni_term] = STATE(1063),
    [sym_let_expr] = STATE(690),
    [sym_let_in_block] = STATE(60),
    [sym_fun_expr] = STATE(690),
    [sym_match_expr] = STATE(142),
    [sym_ite_expr] = STATE(690),
    [sym_annotated_infix_expr] = STATE(690),
    [sym_forall] = STATE(690),
    [sym_applicative] = STATE(10),
    [sym_type_array] = STATE(142),
    [sym_record_operand] = STATE(92),
    [sym_record_operation_chain] = STATE(126),
    [sym_uni_record] = STATE(98),
    [sym_atom] = STATE(126),
    [sym_bool] = STATE(98),
    [sym_str_chunks] = STATE(98),
    [sym_str_chunks_single] = STATE(107),
    [sym_str_chunks_multi] = STATE(107),
    [sym_quoted_enum_tag] = STATE(89),
    [sym_enum_tag] = STATE(9),
    [sym_enum_variant] = STATE(142),
    [sym_builtin] = STATE(98),
    [sym_infix_b_op_2] = STATE(1188),
    [sym_infix_b_op_3] = STATE(1188),
    [sym_infix_b_op_4] = STATE(1188),
    [sym_infix_u_op_5] = STATE(157),
    [sym_infix_b_op_6] = STATE(1188),
    [sym_infix_b_op_7] = STATE(1188),
    [sym_infix_b_op_8] = STATE(1188),
    [sym_infix_lazy_b_op_9] = STATE(1185),
    [sym_infix_lazy_b_op_10] = STATE(1185),
    [sym_infix_b_op] = STATE(1183),
    [sym_infix_u_op_or_lazy_b_op] = STATE(1183),
    [sym_infix_op] = STATE(1221),
    [sym_curried_op] = STATE(1063),
    [sym_infix_expr] = STATE(464),
    [sym_type_builtin] = STATE(127),
    [sym_type_atom] = STATE(98),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_Array] = ACTIONS(71),
    [anon_sym_Dyn] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_AT] = ACTIONS(79),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_true] = ACTIONS(83),
    [anon_sym_false] = ACTIONS(83),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(87),
    [anon_sym_SLASH] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_AMP] = ACTIONS(95),
    [anon_sym_PIPE_GT] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(99),
    [anon_sym_LT_EQ] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(99),
    [anon_sym_GT_EQ] = ACTIONS(101),
    [anon_sym_EQ_EQ] = ACTIONS(103),
    [anon_sym_BANG_EQ] = ACTIONS(103),
    [anon_sym_AMP_AMP] = ACTIONS(105),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_Number] = ACTIONS(73),
    [anon_sym_Bool] = ACTIONS(73),
    [anon_sym_String] = ACTIONS(73),
    [anon_sym_LBRACK_PIPE] = ACTIONS(109),
    [sym_multstr_start] = ACTIONS(111),
    [sym__str_start] = ACTIONS(113),
    [sym_quoted_enum_tag_start] = ACTIONS(115),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_uni_term] = STATE(1062),
    [sym_let_expr] = STATE(690),
    [sym_let_in_block] = STATE(60),
    [sym_fun_expr] = STATE(690),
    [sym_match_expr] = STATE(142),
    [sym_ite_expr] = STATE(690),
    [sym_annotated_infix_expr] = STATE(690),
    [sym_forall] = STATE(690),
    [sym_applicative] = STATE(10),
    [sym_type_array] = STATE(142),
    [sym_record_operand] = STATE(92),
    [sym_record_operation_chain] = STATE(126),
    [sym_uni_record] = STATE(98),
    [sym_atom] = STATE(126),
    [sym_bool] = STATE(98),
    [sym_str_chunks] = STATE(98),
    [sym_str_chunks_single] = STATE(107),
    [sym_str_chunks_multi] = STATE(107),
    [sym_quoted_enum_tag] = STATE(89),
    [sym_enum_tag] = STATE(9),
    [sym_enum_variant] = STATE(142),
    [sym_builtin] = STATE(98),
    [sym_infix_b_op_2] = STATE(1188),
    [sym_infix_b_op_3] = STATE(1188),
    [sym_infix_b_op_4] = STATE(1188),
    [sym_infix_u_op_5] = STATE(157),
    [sym_infix_b_op_6] = STATE(1188),
    [sym_infix_b_op_7] = STATE(1188),
    [sym_infix_b_op_8] = STATE(1188),
    [sym_infix_lazy_b_op_9] = STATE(1185),
    [sym_infix_lazy_b_op_10] = STATE(1185),
    [sym_infix_b_op] = STATE(1183),
    [sym_infix_u_op_or_lazy_b_op] = STATE(1183),
    [sym_infix_op] = STATE(1221),
    [sym_curried_op] = STATE(1062),
    [sym_infix_expr] = STATE(464),
    [sym_type_builtin] = STATE(127),
    [sym_type_atom] = STATE(98),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_Array] = ACTIONS(71),
    [anon_sym_Dyn] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_AT] = ACTIONS(79),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_true] = ACTIONS(83),
    [anon_sym_false] = ACTIONS(83),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(87),
    [anon_sym_SLASH] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_AMP] = ACTIONS(95),
    [anon_sym_PIPE_GT] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(99),
    [anon_sym_LT_EQ] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(99),
    [anon_sym_GT_EQ] = ACTIONS(101),
    [anon_sym_EQ_EQ] = ACTIONS(103),
    [anon_sym_BANG_EQ] = ACTIONS(103),
    [anon_sym_AMP_AMP] = ACTIONS(105),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_Number] = ACTIONS(73),
    [anon_sym_Bool] = ACTIONS(73),
    [anon_sym_String] = ACTIONS(73),
    [anon_sym_LBRACK_PIPE] = ACTIONS(109),
    [sym_multstr_start] = ACTIONS(111),
    [sym__str_start] = ACTIONS(113),
    [sym_quoted_enum_tag_start] = ACTIONS(115),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_uni_term] = STATE(1094),
    [sym_let_expr] = STATE(690),
    [sym_let_in_block] = STATE(60),
    [sym_fun_expr] = STATE(690),
    [sym_match_expr] = STATE(142),
    [sym_ite_expr] = STATE(690),
    [sym_annotated_infix_expr] = STATE(690),
    [sym_forall] = STATE(690),
    [sym_applicative] = STATE(10),
    [sym_type_array] = STATE(142),
    [sym_record_operand] = STATE(92),
    [sym_record_operation_chain] = STATE(126),
    [sym_uni_record] = STATE(98),
    [sym_atom] = STATE(126),
    [sym_bool] = STATE(98),
    [sym_str_chunks] = STATE(98),
    [sym_str_chunks_single] = STATE(107),
    [sym_str_chunks_multi] = STATE(107),
    [sym_quoted_enum_tag] = STATE(89),
    [sym_enum_tag] = STATE(9),
    [sym_enum_variant] = STATE(142),
    [sym_builtin] = STATE(98),
    [sym_infix_b_op_2] = STATE(1188),
    [sym_infix_b_op_3] = STATE(1188),
    [sym_infix_b_op_4] = STATE(1188),
    [sym_infix_u_op_5] = STATE(157),
    [sym_infix_b_op_6] = STATE(1188),
    [sym_infix_b_op_7] = STATE(1188),
    [sym_infix_b_op_8] = STATE(1188),
    [sym_infix_lazy_b_op_9] = STATE(1185),
    [sym_infix_lazy_b_op_10] = STATE(1185),
    [sym_infix_b_op] = STATE(1183),
    [sym_infix_u_op_or_lazy_b_op] = STATE(1183),
    [sym_infix_op] = STATE(1221),
    [sym_curried_op] = STATE(1094),
    [sym_infix_expr] = STATE(464),
    [sym_type_builtin] = STATE(127),
    [sym_type_atom] = STATE(98),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_Array] = ACTIONS(71),
    [anon_sym_Dyn] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_AT] = ACTIONS(79),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_true] = ACTIONS(83),
    [anon_sym_false] = ACTIONS(83),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(87),
    [anon_sym_SLASH] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_AMP] = ACTIONS(95),
    [anon_sym_PIPE_GT] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(99),
    [anon_sym_LT_EQ] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(99),
    [anon_sym_GT_EQ] = ACTIONS(101),
    [anon_sym_EQ_EQ] = ACTIONS(103),
    [anon_sym_BANG_EQ] = ACTIONS(103),
    [anon_sym_AMP_AMP] = ACTIONS(105),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_Number] = ACTIONS(73),
    [anon_sym_Bool] = ACTIONS(73),
    [anon_sym_String] = ACTIONS(73),
    [anon_sym_LBRACK_PIPE] = ACTIONS(109),
    [sym_multstr_start] = ACTIONS(111),
    [sym__str_start] = ACTIONS(113),
    [sym_quoted_enum_tag_start] = ACTIONS(115),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_uni_term] = STATE(1213),
    [sym_let_expr] = STATE(690),
    [sym_let_in_block] = STATE(60),
    [sym_fun_expr] = STATE(690),
    [sym_match_expr] = STATE(142),
    [sym_ite_expr] = STATE(690),
    [sym_annotated_infix_expr] = STATE(690),
    [sym_forall] = STATE(690),
    [sym_applicative] = STATE(10),
    [sym_type_array] = STATE(142),
    [sym_record_operand] = STATE(92),
    [sym_record_operation_chain] = STATE(126),
    [sym_uni_record] = STATE(98),
    [sym_atom] = STATE(126),
    [sym_bool] = STATE(98),
    [sym_str_chunks] = STATE(98),
    [sym_str_chunks_single] = STATE(107),
    [sym_str_chunks_multi] = STATE(107),
    [sym_quoted_enum_tag] = STATE(89),
    [sym_enum_tag] = STATE(9),
    [sym_enum_variant] = STATE(142),
    [sym_builtin] = STATE(98),
    [sym_infix_b_op_2] = STATE(1188),
    [sym_infix_b_op_3] = STATE(1188),
    [sym_infix_b_op_4] = STATE(1188),
    [sym_infix_u_op_5] = STATE(157),
    [sym_infix_b_op_6] = STATE(1188),
    [sym_infix_b_op_7] = STATE(1188),
    [sym_infix_b_op_8] = STATE(1188),
    [sym_infix_lazy_b_op_9] = STATE(1185),
    [sym_infix_lazy_b_op_10] = STATE(1185),
    [sym_infix_b_op] = STATE(1183),
    [sym_infix_u_op_or_lazy_b_op] = STATE(1183),
    [sym_infix_op] = STATE(1221),
    [sym_curried_op] = STATE(1213),
    [sym_infix_expr] = STATE(464),
    [sym_type_builtin] = STATE(127),
    [sym_type_atom] = STATE(98),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_Array] = ACTIONS(71),
    [anon_sym_Dyn] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_AT] = ACTIONS(79),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_true] = ACTIONS(83),
    [anon_sym_false] = ACTIONS(83),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(87),
    [anon_sym_SLASH] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_AMP] = ACTIONS(95),
    [anon_sym_PIPE_GT] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(99),
    [anon_sym_LT_EQ] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(99),
    [anon_sym_GT_EQ] = ACTIONS(101),
    [anon_sym_EQ_EQ] = ACTIONS(103),
    [anon_sym_BANG_EQ] = ACTIONS(103),
    [anon_sym_AMP_AMP] = ACTIONS(105),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_Number] = ACTIONS(73),
    [anon_sym_Bool] = ACTIONS(73),
    [anon_sym_String] = ACTIONS(73),
    [anon_sym_LBRACK_PIPE] = ACTIONS(109),
    [sym_multstr_start] = ACTIONS(111),
    [sym__str_start] = ACTIONS(113),
    [sym_quoted_enum_tag_start] = ACTIONS(115),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_uni_term] = STATE(1190),
    [sym_let_expr] = STATE(690),
    [sym_let_in_block] = STATE(60),
    [sym_fun_expr] = STATE(690),
    [sym_match_expr] = STATE(142),
    [sym_ite_expr] = STATE(690),
    [sym_annotated_infix_expr] = STATE(690),
    [sym_forall] = STATE(690),
    [sym_applicative] = STATE(10),
    [sym_type_array] = STATE(142),
    [sym_record_operand] = STATE(92),
    [sym_record_operation_chain] = STATE(126),
    [sym_uni_record] = STATE(98),
    [sym_atom] = STATE(126),
    [sym_bool] = STATE(98),
    [sym_str_chunks] = STATE(98),
    [sym_str_chunks_single] = STATE(107),
    [sym_str_chunks_multi] = STATE(107),
    [sym_quoted_enum_tag] = STATE(89),
    [sym_enum_tag] = STATE(9),
    [sym_enum_variant] = STATE(142),
    [sym_builtin] = STATE(98),
    [sym_infix_b_op_2] = STATE(1188),
    [sym_infix_b_op_3] = STATE(1188),
    [sym_infix_b_op_4] = STATE(1188),
    [sym_infix_u_op_5] = STATE(157),
    [sym_infix_b_op_6] = STATE(1188),
    [sym_infix_b_op_7] = STATE(1188),
    [sym_infix_b_op_8] = STATE(1188),
    [sym_infix_lazy_b_op_9] = STATE(1185),
    [sym_infix_lazy_b_op_10] = STATE(1185),
    [sym_infix_b_op] = STATE(1183),
    [sym_infix_u_op_or_lazy_b_op] = STATE(1183),
    [sym_infix_op] = STATE(1221),
    [sym_curried_op] = STATE(1190),
    [sym_infix_expr] = STATE(464),
    [sym_type_builtin] = STATE(127),
    [sym_type_atom] = STATE(98),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_Array] = ACTIONS(71),
    [anon_sym_Dyn] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_AT] = ACTIONS(79),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_true] = ACTIONS(83),
    [anon_sym_false] = ACTIONS(83),
    [anon_sym_PERCENT] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(87),
    [anon_sym_SLASH] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_AMP] = ACTIONS(95),
    [anon_sym_PIPE_GT] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(99),
    [anon_sym_LT_EQ] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(99),
    [anon_sym_GT_EQ] = ACTIONS(101),
    [anon_sym_EQ_EQ] = ACTIONS(103),
    [anon_sym_BANG_EQ] = ACTIONS(103),
    [anon_sym_AMP_AMP] = ACTIONS(105),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_Number] = ACTIONS(73),
    [anon_sym_Bool] = ACTIONS(73),
    [anon_sym_String] = ACTIONS(73),
    [anon_sym_LBRACK_PIPE] = ACTIONS(109),
    [sym_multstr_start] = ACTIONS(111),
    [sym__str_start] = ACTIONS(113),
    [sym_quoted_enum_tag_start] = ACTIONS(115),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(118), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(117), 8,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(119), 20,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [108] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(120), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(123), 7,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(125), 21,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [213] = 41,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(129), 1,
      anon_sym_RBRACK,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(936), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [354] = 41,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(133), 1,
      anon_sym_COMMA,
    ACTIONS(135), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(939), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [495] = 41,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(137), 1,
      anon_sym_COMMA,
    ACTIONS(139), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(930), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [636] = 41,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(141), 1,
      anon_sym_COMMA,
    ACTIONS(143), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(943), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [777] = 41,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(145), 1,
      anon_sym_COMMA,
    ACTIONS(147), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(995), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [918] = 41,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_COMMA,
    ACTIONS(151), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(923), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [1059] = 41,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(153), 1,
      anon_sym_COMMA,
    ACTIONS(155), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(963), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [1200] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [1338] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(159), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [1476] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(161), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [1614] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(163), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [1752] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(165), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [1890] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(167), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [2028] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(169), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [2166] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(171), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [2304] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(173), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [2442] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [2580] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(177), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [2718] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(179), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [2856] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(181), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [2994] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_RBRACK,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [3132] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(191), 1,
      anon_sym_fun,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      anon_sym_if,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(498), 1,
      sym_infix_expr,
    STATE(687), 1,
      sym_term,
    STATE(688), 1,
      sym_uni_term,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [3267] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(998), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [3402] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1109), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [3537] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(233), 1,
      anon_sym_fun,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(239), 1,
      anon_sym_if,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(493), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1073), 1,
      sym_term,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [3672] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1029), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [3807] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(233), 1,
      anon_sym_fun,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(239), 1,
      anon_sym_if,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(493), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1119), 1,
      sym_term,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [3942] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(191), 1,
      anon_sym_fun,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      anon_sym_if,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(498), 1,
      sym_infix_expr,
    STATE(685), 1,
      sym_term,
    STATE(688), 1,
      sym_uni_term,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [4077] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_fun,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(39), 1,
      sym_let_in_block,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(488), 1,
      sym_infix_expr,
    STATE(685), 1,
      sym_term,
    STATE(688), 1,
      sym_uni_term,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [4212] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(275), 1,
      anon_sym_fun,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(281), 1,
      anon_sym_if,
    ACTIONS(283), 1,
      anon_sym_forall,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(43), 1,
      sym_let_in_block,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(490), 1,
      sym_infix_expr,
    STATE(1057), 1,
      sym_uni_term,
    STATE(1162), 1,
      sym_term,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(1056), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [4347] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(689), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [4482] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(999), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [4617] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(275), 1,
      anon_sym_fun,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(281), 1,
      anon_sym_if,
    ACTIONS(283), 1,
      anon_sym_forall,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(43), 1,
      sym_let_in_block,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(490), 1,
      sym_infix_expr,
    STATE(1057), 1,
      sym_uni_term,
    STATE(1173), 1,
      sym_term,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(1056), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [4752] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(275), 1,
      anon_sym_fun,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(281), 1,
      anon_sym_if,
    ACTIONS(283), 1,
      anon_sym_forall,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(43), 1,
      sym_let_in_block,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(490), 1,
      sym_infix_expr,
    STATE(1057), 1,
      sym_uni_term,
    STATE(1171), 1,
      sym_term,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(1056), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [4887] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(191), 1,
      anon_sym_fun,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      anon_sym_if,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(498), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1218), 1,
      sym_term,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [5022] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1047), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [5157] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_fun,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(39), 1,
      sym_let_in_block,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(488), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(689), 1,
      sym_term,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [5292] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(233), 1,
      anon_sym_fun,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(239), 1,
      anon_sym_if,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(493), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1080), 1,
      sym_term,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [5427] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(317), 1,
      anon_sym_fun,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(323), 1,
      anon_sym_if,
    ACTIONS(325), 1,
      anon_sym_forall,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(64), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(481), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1027), 1,
      sym_term,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [5562] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_fun,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(39), 1,
      sym_let_in_block,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(488), 1,
      sym_infix_expr,
    STATE(687), 1,
      sym_term,
    STATE(688), 1,
      sym_uni_term,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [5697] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(920), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [5832] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(233), 1,
      anon_sym_fun,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(239), 1,
      anon_sym_if,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(493), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(689), 1,
      sym_term,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [5967] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(317), 1,
      anon_sym_fun,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(323), 1,
      anon_sym_if,
    ACTIONS(325), 1,
      anon_sym_forall,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(64), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(481), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(689), 1,
      sym_term,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [6102] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(233), 1,
      anon_sym_fun,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(239), 1,
      anon_sym_if,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(493), 1,
      sym_infix_expr,
    STATE(687), 1,
      sym_term,
    STATE(688), 1,
      sym_uni_term,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [6237] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(191), 1,
      anon_sym_fun,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      anon_sym_if,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(498), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1223), 1,
      sym_term,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [6372] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(191), 1,
      anon_sym_fun,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      anon_sym_if,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(498), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(689), 1,
      sym_term,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [6507] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(317), 1,
      anon_sym_fun,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(323), 1,
      anon_sym_if,
    ACTIONS(325), 1,
      anon_sym_forall,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(64), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(481), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1019), 1,
      sym_term,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [6642] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(191), 1,
      anon_sym_fun,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      anon_sym_if,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(498), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1210), 1,
      sym_term,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [6777] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(687), 1,
      sym_term,
    STATE(688), 1,
      sym_uni_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [6912] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(685), 1,
      sym_term,
    STATE(688), 1,
      sym_uni_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [7047] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(60), 1,
      sym_let_in_block,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(464), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1017), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [7182] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(191), 1,
      anon_sym_fun,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      anon_sym_if,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(498), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1212), 1,
      sym_term,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [7317] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(317), 1,
      anon_sym_fun,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(323), 1,
      anon_sym_if,
    ACTIONS(325), 1,
      anon_sym_forall,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(64), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(481), 1,
      sym_infix_expr,
    STATE(687), 1,
      sym_term,
    STATE(688), 1,
      sym_uni_term,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [7452] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(317), 1,
      anon_sym_fun,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(323), 1,
      anon_sym_if,
    ACTIONS(325), 1,
      anon_sym_forall,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(64), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(481), 1,
      sym_infix_expr,
    STATE(685), 1,
      sym_term,
    STATE(688), 1,
      sym_uni_term,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [7587] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(233), 1,
      anon_sym_fun,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(239), 1,
      anon_sym_if,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(493), 1,
      sym_infix_expr,
    STATE(685), 1,
      sym_term,
    STATE(688), 1,
      sym_uni_term,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [7722] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(191), 1,
      anon_sym_fun,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      anon_sym_if,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(498), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1214), 1,
      sym_term,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [7857] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(233), 1,
      anon_sym_fun,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(239), 1,
      anon_sym_if,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(493), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1129), 1,
      sym_term,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [7992] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(275), 1,
      anon_sym_fun,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(281), 1,
      anon_sym_if,
    ACTIONS(283), 1,
      anon_sym_forall,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(43), 1,
      sym_let_in_block,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(490), 1,
      sym_infix_expr,
    STATE(1057), 1,
      sym_uni_term,
    STATE(1207), 1,
      sym_term,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(1056), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [8127] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(233), 1,
      anon_sym_fun,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(239), 1,
      anon_sym_if,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(493), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1145), 1,
      sym_term,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [8262] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(233), 1,
      anon_sym_fun,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(239), 1,
      anon_sym_if,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(493), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1178), 1,
      sym_term,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [8397] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(191), 1,
      anon_sym_fun,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      anon_sym_if,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(498), 1,
      sym_infix_expr,
    STATE(688), 1,
      sym_uni_term,
    STATE(1216), 1,
      sym_term,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(690), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [8532] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(275), 1,
      anon_sym_fun,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(281), 1,
      anon_sym_if,
    ACTIONS(283), 1,
      anon_sym_forall,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(43), 1,
      sym_let_in_block,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(490), 1,
      sym_infix_expr,
    STATE(1051), 1,
      sym_term,
    STATE(1057), 1,
      sym_uni_term,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
    STATE(1056), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
  [8667] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(252), 1,
      sym_record_operand,
    STATE(261), 1,
      sym_type_builtin,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(117), 8,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(119), 14,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [8769] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_forall,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(355), 1,
      anon_sym_priority,
    ACTIONS(357), 1,
      anon_sym_doc,
    ACTIONS(359), 1,
      anon_sym_rec,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(530), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(648), 1,
      sym_types,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(353), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [8900] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(355), 1,
      anon_sym_priority,
    ACTIONS(357), 1,
      anon_sym_doc,
    ACTIONS(359), 1,
      anon_sym_rec,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(553), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(648), 1,
      sym_types,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(353), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [9031] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(355), 1,
      anon_sym_priority,
    ACTIONS(357), 1,
      anon_sym_doc,
    ACTIONS(359), 1,
      anon_sym_rec,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(540), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(648), 1,
      sym_types,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(353), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [9162] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(253), 1,
      sym_record_operand,
    STATE(261), 1,
      sym_type_builtin,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(123), 7,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(125), 15,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [9261] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(283), 1,
      anon_sym_forall,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(363), 1,
      anon_sym_priority,
    ACTIONS(365), 1,
      anon_sym_doc,
    ACTIONS(367), 1,
      anon_sym_rec,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(581), 1,
      sym_infix_expr,
    STATE(986), 1,
      sym_forall,
    STATE(987), 1,
      sym_types,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(361), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [9392] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(355), 1,
      anon_sym_priority,
    ACTIONS(357), 1,
      anon_sym_doc,
    ACTIONS(359), 1,
      anon_sym_rec,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(476), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(648), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(353), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [9523] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(355), 1,
      anon_sym_priority,
    ACTIONS(357), 1,
      anon_sym_doc,
    ACTIONS(359), 1,
      anon_sym_rec,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(548), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(648), 1,
      sym_types,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(353), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [9654] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(273), 1,
      sym_type_builtin,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(402), 1,
      sym_record_operand,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(117), 7,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(119), 14,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [9755] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(278), 1,
      sym_type_builtin,
    STATE(293), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(117), 8,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(119), 13,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [9856] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(376), 1,
      sym_record_operand,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(117), 8,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(119), 13,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [9957] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(387), 1,
      sym_record_operand,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(117), 7,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(119), 14,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [10058] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(278), 1,
      sym_type_builtin,
    STATE(328), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(123), 7,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(125), 14,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [10156] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(273), 1,
      sym_type_builtin,
    STATE(340), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(123), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    STATE(288), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(125), 15,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [10254] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(375), 1,
      sym_record_operand,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(123), 7,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(125), 14,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [10352] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(367), 1,
      sym_record_operand,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(123), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    STATE(266), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(125), 15,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [10450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(369), 30,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
      anon_sym_PIPE_RBRACK,
  [10506] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(373), 30,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
      anon_sym_PIPE_RBRACK,
  [10562] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(377), 30,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
      anon_sym_PIPE_RBRACK,
  [10618] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 1,
      anon_sym_DOT,
    ACTIONS(383), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10675] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10730] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10895] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(403), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(119), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11005] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(407), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(411), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11115] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(415), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(419), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(423), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(427), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(431), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11390] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(435), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(439), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(443), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11555] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(447), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(451), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(455), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(459), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11775] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(463), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11830] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(467), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(471), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(475), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(479), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12050] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 1,
      anon_sym_DOT,
    ACTIONS(485), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(483), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(487), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12162] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 1,
      anon_sym_DOT,
    ACTIONS(493), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(491), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(495), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12274] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(499), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12329] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 1,
      anon_sym_DOT,
    ACTIONS(505), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(503), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12386] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(507), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12441] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(511), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12496] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(515), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(519), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12606] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(523), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12661] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(283), 1,
      anon_sym_forall,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(581), 1,
      sym_infix_expr,
    STATE(986), 1,
      sym_forall,
    STATE(987), 1,
      sym_types,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [12777] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(540), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(648), 1,
      sym_types,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [12893] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(476), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(1077), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [13009] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(476), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(1141), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [13125] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(476), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(1125), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [13241] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(476), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(1081), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [13357] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(476), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(1122), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [13473] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(548), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(648), 1,
      sym_types,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [13589] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_forall,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(530), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(648), 1,
      sym_types,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [13705] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(241), 1,
      anon_sym_forall,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(548), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(662), 1,
      sym_types,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [13821] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(476), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(648), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [13937] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_forall,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(540), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(662), 1,
      sym_types,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [14053] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(476), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(1106), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [14169] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [14223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(527), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [14277] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(531), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [14331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(535), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [14385] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(476), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(662), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [14501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(539), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [14555] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(553), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(662), 1,
      sym_types,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [14671] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(476), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(1103), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [14787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(543), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [14841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(547), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [14895] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(283), 1,
      anon_sym_forall,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(581), 1,
      sym_infix_expr,
    STATE(978), 1,
      sym_types,
    STATE(986), 1,
      sym_forall,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [15011] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_forall,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(530), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(662), 1,
      sym_types,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [15127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(551), 29,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [15181] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(553), 1,
      sym_infix_expr,
    STATE(646), 1,
      sym_forall,
    STATE(648), 1,
      sym_types,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [15297] = 32,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(555), 1,
      anon_sym_RPAREN,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(475), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [15407] = 32,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    ACTIONS(557), 1,
      anon_sym_RPAREN,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(474), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [15517] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(551), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [15624] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(543), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [15731] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(531), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [15838] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(565), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [15945] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(562), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [16052] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(561), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [16159] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(560), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [16266] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(557), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [16373] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(584), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [16480] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(583), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [16587] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(579), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [16694] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(577), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [16801] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(572), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [16908] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(564), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [17015] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(563), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [17122] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(559), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [17229] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(582), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [17336] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(519), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [17443] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(544), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [17550] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(522), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [17657] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(524), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [17764] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(538), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [17871] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(527), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [17978] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(528), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [18085] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(277), 1,
      anon_sym_match,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_import,
    ACTIONS(287), 1,
      anon_sym_Array,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(301), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(81), 1,
      sym_enum_tag,
    STATE(86), 1,
      sym_applicative,
    STATE(176), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_type_builtin,
    STATE(306), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    STATE(542), 1,
      sym_infix_expr,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(454), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [18192] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(555), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [18299] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(554), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [18406] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(518), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [18513] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(520), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [18620] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(556), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [18727] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(534), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [18834] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(558), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [18941] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(567), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [19048] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(570), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [19155] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(573), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [19262] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(533), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [19369] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(574), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [19476] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(575), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [19583] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(576), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [19690] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(193), 1,
      anon_sym_match,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_import,
    ACTIONS(203), 1,
      anon_sym_Array,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(83), 1,
      sym_enum_tag,
    STATE(87), 1,
      sym_applicative,
    STATE(187), 1,
      sym_infix_u_op_5,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    STATE(578), 1,
      sym_infix_expr,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(434), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [19797] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(539), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [19904] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(529), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [20011] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(541), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [20118] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(566), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [20225] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(546), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [20332] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(521), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [20439] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(547), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [20546] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(475), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [20653] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(568), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [20760] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(549), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [20867] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(466), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [20974] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(465), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [21081] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(468), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [21188] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(469), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [21295] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(470), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [21402] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(471), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [21509] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(472), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [21616] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(473), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [21723] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(467), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [21830] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(571), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [21937] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(550), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [22044] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(545), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [22151] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(319), 1,
      anon_sym_match,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 1,
      anon_sym_import,
    ACTIONS(329), 1,
      anon_sym_Array,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_enum_tag,
    STATE(77), 1,
      sym_applicative,
    STATE(199), 1,
      sym_infix_u_op_5,
    STATE(232), 1,
      sym_record_operand,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(261), 1,
      sym_type_builtin,
    STATE(525), 1,
      sym_infix_expr,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(413), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [22258] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(235), 1,
      anon_sym_match,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_import,
    ACTIONS(245), 1,
      anon_sym_Array,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(259), 1,
      anon_sym_DASH,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_enum_tag,
    STATE(85), 1,
      sym_applicative,
    STATE(158), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_type_builtin,
    STATE(352), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    STATE(552), 1,
      sym_infix_expr,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(449), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [22365] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      anon_sym_import,
    ACTIONS(71), 1,
      anon_sym_Array,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(131), 1,
      anon_sym_DASH,
    STATE(9), 1,
      sym_enum_tag,
    STATE(10), 1,
      sym_applicative,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(92), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    STATE(222), 1,
      sym_infix_u_op_5,
    STATE(474), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(142), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [22472] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(84), 1,
      sym_enum_tag,
    STATE(88), 1,
      sym_applicative,
    STATE(184), 1,
      sym_infix_u_op_5,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    STATE(569), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(441), 3,
      sym_match_expr,
      sym_type_array,
      sym_enum_variant,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 5,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_builtin,
      sym_type_atom,
  [22579] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(451), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(407), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22677] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(507), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22726] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(373), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22775] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(423), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22824] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(419), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(415), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22922] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(411), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22971] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(559), 1,
      anon_sym_DOT,
    ACTIONS(383), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23022] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(403), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23071] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23120] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23169] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23218] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23267] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(447), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23316] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(427), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23365] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(431), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23414] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(435), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23463] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(377), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23512] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(443), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23561] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(487), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(463), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23659] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(467), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23708] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(471), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(475), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23806] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(369), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23855] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(559), 1,
      anon_sym_DOT,
    ACTIONS(505), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(503), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(479), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23955] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(559), 1,
      anon_sym_DOT,
    ACTIONS(485), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(483), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24006] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(559), 1,
      anon_sym_DOT,
    ACTIONS(493), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(491), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(495), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24106] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(499), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(511), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(459), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24253] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(455), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24302] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(439), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24351] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(515), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24400] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(519), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24449] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(523), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24498] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(119), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24547] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(439), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24595] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(495), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24643] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(119), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(369), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(507), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(459), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24835] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(455), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24883] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(439), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(427), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24979] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(519), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25027] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(523), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25075] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(519), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25123] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(515), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(407), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(519), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25267] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(507), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(523), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(119), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(523), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25507] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25555] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(511), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25603] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(369), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25651] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(499), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25699] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(119), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25747] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 1,
      anon_sym_DOT,
    ACTIONS(505), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(503), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25797] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(475), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25845] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(495), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25893] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(471), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25941] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(485), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(483), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25991] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(467), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(463), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(479), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26135] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 1,
      anon_sym_DOT,
    ACTIONS(383), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26185] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(487), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26233] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(515), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26281] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(543), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(451), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(475), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(439), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(471), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(467), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26569] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(383), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26619] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(463), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(447), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26715] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(455), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26763] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26811] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26859] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(443), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(403), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(435), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27003] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(515), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27051] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(411), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(377), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27147] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(415), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(511), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27243] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(373), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27291] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(451), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(447), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27387] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(487), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27435] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(443), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(479), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27531] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(505), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(503), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27581] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(419), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27629] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(493), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(491), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27679] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(423), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27727] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(435), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27775] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(119), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(531), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27871] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(499), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(523), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(519), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28015] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(505), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(503), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28065] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(495), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28113] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(499), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28161] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(377), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28209] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(493), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(491), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(373), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28307] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(431), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28355] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(567), 1,
      anon_sym_DOT,
    ACTIONS(383), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(515), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(427), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(407), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28549] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28597] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(475), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(471), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28693] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(459), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28741] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(467), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28789] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(563), 1,
      anon_sym_DOT,
    ACTIONS(383), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(463), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(459), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28935] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(507), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28983] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29031] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(369), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29175] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(511), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(451), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29271] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(567), 1,
      anon_sym_DOT,
    ACTIONS(505), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(503), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29321] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29369] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(547), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29417] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(403), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29465] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(411), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29513] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 1,
      anon_sym_DOT,
    ACTIONS(493), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(491), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29563] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(415), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(419), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29659] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(423), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29707] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(499), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29755] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(539), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29803] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(495), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29851] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(507), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29899] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(567), 1,
      anon_sym_DOT,
    ACTIONS(493), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(491), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29949] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(567), 1,
      anon_sym_DOT,
    ACTIONS(485), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(483), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(455), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30047] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(551), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30095] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(447), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30143] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(439), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(443), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(511), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30287] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(369), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(435), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30383] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(377), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30431] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(373), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30479] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 1,
      anon_sym_DOT,
    ACTIONS(485), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(483), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30529] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(423), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30577] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(419), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30625] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(535), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30673] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(487), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30721] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(415), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(479), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(411), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(479), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(487), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(373), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31009] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(403), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31105] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(475), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31153] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(471), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31201] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 1,
      anon_sym_DOT,
    ACTIONS(485), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(483), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31251] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(467), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31299] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(463), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31347] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(451), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(447), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31443] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(443), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31491] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(435), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(527), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(431), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(459), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31683] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(455), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31731] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31779] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(423), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(419), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31875] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(415), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(411), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(403), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32019] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32067] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32115] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(407), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(427), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32307] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(377), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32355] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(431), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32403] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(427), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32451] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(407), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32499] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32547] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32595] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(431), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32643] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(535), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(531), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32737] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(539), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32831] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(547), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32878] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(547), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(543), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32972] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(539), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33019] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(527), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33066] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33113] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(535), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33160] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(551), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33207] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(551), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33254] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(539), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33301] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(527), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33348] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(551), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(527), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33442] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33489] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(527), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33536] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(543), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33583] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(547), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33630] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(531), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33677] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(381), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33724] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(547), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33771] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(531), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(543), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(551), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33912] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(535), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [33959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(539), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [34006] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(531), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [34053] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(543), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [34100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(535), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [34147] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_PIPE,
    ACTIONS(571), 1,
      anon_sym_COLON,
    ACTIONS(573), 1,
      anon_sym_EQ,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(597), 1,
      anon_sym_DASH_GT,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    STATE(686), 1,
      sym_annot,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(684), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(575), 6,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [34239] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(599), 2,
      anon_sym_PIPE,
      anon_sym_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 11,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34315] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(599), 2,
      anon_sym_PIPE,
      anon_sym_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 10,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34393] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(597), 1,
      anon_sym_DASH_GT,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(599), 2,
      anon_sym_PIPE,
      anon_sym_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 8,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [34475] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(599), 2,
      anon_sym_PIPE,
      anon_sym_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 13,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34549] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 15,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34619] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 5,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 16,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34685] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 7,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 16,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34749] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(599), 7,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 19,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34811] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(599), 7,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 21,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34871] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(603), 5,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 16,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34937] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(603), 7,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 21,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34997] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(597), 1,
      anon_sym_DASH_GT,
    STATE(208), 1,
      sym_infix_lazy_b_op_10,
    STATE(209), 1,
      sym_infix_lazy_b_op_9,
    STATE(210), 1,
      sym_infix_b_op_8,
    STATE(211), 1,
      sym_infix_b_op_7,
    STATE(212), 1,
      sym_infix_b_op_6,
    STATE(213), 1,
      sym_infix_b_op_4,
    STATE(214), 1,
      sym_infix_b_op_3,
    STATE(215), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(607), 2,
      anon_sym_PIPE,
      anon_sym_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(609), 8,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [35079] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 1,
      sym_num_literal,
    ACTIONS(615), 1,
      sym_raw_enum_tag,
    ACTIONS(619), 1,
      anon_sym_LBRACE,
    ACTIONS(623), 1,
      anon_sym_LPAREN,
    ACTIONS(625), 1,
      anon_sym_LBRACK,
    ACTIONS(627), 1,
      anon_sym__,
    ACTIONS(631), 1,
      anon_sym_PERCENT,
    ACTIONS(633), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(635), 1,
      sym_multstr_start,
    ACTIONS(637), 1,
      sym__str_start,
    ACTIONS(639), 1,
      sym_quoted_enum_tag_start,
    STATE(680), 1,
      sym_quoted_enum_tag,
    STATE(865), 1,
      sym_record_operand,
    STATE(887), 1,
      sym_type_builtin,
    ACTIONS(613), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(751), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(891), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(617), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_PIPE_RBRACK,
    ACTIONS(621), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(882), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [35160] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(655), 1,
      anon_sym_RBRACK,
    ACTIONS(657), 1,
      anon_sym_DOT_DOT,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    STATE(501), 1,
      aux_sym_array_pattern_repeat1,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1002), 1,
      sym_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    STATE(1192), 1,
      sym_last_elem_pat,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [35253] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_DOT_DOT,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(667), 1,
      anon_sym_RBRACK,
    STATE(482), 1,
      aux_sym_array_pattern_repeat1,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1002), 1,
      sym_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    STATE(1152), 1,
      sym_last_elem_pat,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [35346] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(669), 1,
      anon_sym_rec,
    ACTIONS(671), 1,
      anon_sym_COMMA,
    ACTIONS(673), 1,
      anon_sym_in,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(835), 1,
      sym_pattern,
    STATE(950), 1,
      sym_let_binding,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [35439] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(675), 1,
      anon_sym_PIPE,
    ACTIONS(677), 1,
      anon_sym_COLON,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    STATE(686), 1,
      sym_annot,
    ACTIONS(575), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(844), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [35524] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_DOT_DOT,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(681), 1,
      anon_sym_RBRACK,
    STATE(501), 1,
      aux_sym_array_pattern_repeat1,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1002), 1,
      sym_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    STATE(1123), 1,
      sym_last_elem_pat,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [35617] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_DOT_DOT,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(683), 1,
      anon_sym_RBRACK,
    STATE(478), 1,
      aux_sym_array_pattern_repeat1,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1002), 1,
      sym_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    STATE(1113), 1,
      sym_last_elem_pat,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [35710] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym__,
    ACTIONS(109), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(111), 1,
      sym_multstr_start,
    ACTIONS(113), 1,
      sym__str_start,
    ACTIONS(115), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    STATE(89), 1,
      sym_quoted_enum_tag,
    STATE(123), 1,
      sym_record_operand,
    STATE(127), 1,
      sym_type_builtin,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(83), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(107), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(126), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(73), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(98), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [35786] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(685), 1,
      anon_sym_COMMA,
    ACTIONS(687), 1,
      anon_sym_in,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(835), 1,
      sym_pattern,
    STATE(965), 1,
      sym_let_binding,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [35876] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym__,
    ACTIONS(37), 1,
      anon_sym_PERCENT,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(267), 1,
      sym_quoted_enum_tag,
    STATE(275), 1,
      sym_type_builtin,
    STATE(289), 1,
      sym_record_operand,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(303), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(266), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [35952] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 1,
      sym_num_literal,
    ACTIONS(315), 1,
      sym_raw_enum_tag,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(333), 1,
      anon_sym_LPAREN,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(337), 1,
      anon_sym__,
    ACTIONS(341), 1,
      anon_sym_PERCENT,
    ACTIONS(345), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(347), 1,
      sym_multstr_start,
    ACTIONS(349), 1,
      sym__str_start,
    ACTIONS(351), 1,
      sym_quoted_enum_tag_start,
    STATE(249), 1,
      sym_quoted_enum_tag,
    STATE(250), 1,
      sym_record_operand,
    STATE(261), 1,
      sym_type_builtin,
    ACTIONS(313), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(339), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(331), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(263), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [36028] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      ts_builtin_sym_end,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(689), 1,
      anon_sym_PIPE,
    ACTIONS(691), 1,
      anon_sym_COLON,
    ACTIONS(693), 1,
      anon_sym_DASH_GT,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    STATE(686), 1,
      sym_annot,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(848), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [36112] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      sym_num_literal,
    ACTIONS(273), 1,
      sym_raw_enum_tag,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      anon_sym__,
    ACTIONS(299), 1,
      anon_sym_PERCENT,
    ACTIONS(303), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(305), 1,
      sym_multstr_start,
    ACTIONS(307), 1,
      sym__str_start,
    ACTIONS(309), 1,
      sym_quoted_enum_tag_start,
    STATE(273), 1,
      sym_type_builtin,
    STATE(326), 1,
      sym_record_operand,
    STATE(358), 1,
      sym_quoted_enum_tag,
    ACTIONS(271), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(297), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(264), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(315), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(289), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(288), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [36188] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      sym_interpolation_end,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(695), 1,
      anon_sym_PIPE,
    ACTIONS(697), 1,
      anon_sym_COLON,
    ACTIONS(699), 1,
      anon_sym_DASH_GT,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    STATE(1187), 1,
      sym_annot,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(851), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [36272] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(705), 1,
      anon_sym_COMMA,
    ACTIONS(707), 1,
      anon_sym_RBRACE,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(922), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [36362] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(185), 1,
      sym_num_literal,
    ACTIONS(189), 1,
      sym_raw_enum_tag,
    ACTIONS(195), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_LBRACK,
    ACTIONS(211), 1,
      anon_sym__,
    ACTIONS(215), 1,
      anon_sym_PERCENT,
    ACTIONS(219), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(221), 1,
      sym_multstr_start,
    ACTIONS(223), 1,
      sym__str_start,
    ACTIONS(225), 1,
      sym_quoted_enum_tag_start,
    STATE(286), 1,
      sym_quoted_enum_tag,
    STATE(335), 1,
      sym_type_builtin,
    STATE(362), 1,
      sym_record_operand,
    ACTIONS(187), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(213), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(344), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(380), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(205), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(331), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [36438] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      anon_sym_else,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(711), 1,
      anon_sym_PIPE,
    ACTIONS(713), 1,
      anon_sym_COLON,
    ACTIONS(715), 1,
      anon_sym_DASH_GT,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    STATE(686), 1,
      sym_annot,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(857), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [36522] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(717), 1,
      anon_sym_COMMA,
    ACTIONS(719), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(915), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [36612] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(721), 1,
      anon_sym_COMMA,
    ACTIONS(723), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(952), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [36702] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(725), 1,
      anon_sym_COMMA,
    ACTIONS(727), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(914), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [36792] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(729), 1,
      anon_sym_COMMA,
    ACTIONS(731), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1001), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [36882] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      anon_sym_then,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(733), 1,
      anon_sym_PIPE,
    ACTIONS(735), 1,
      anon_sym_COLON,
    ACTIONS(737), 1,
      anon_sym_DASH_GT,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    STATE(686), 1,
      sym_annot,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(845), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [36966] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(739), 1,
      anon_sym_COMMA,
    ACTIONS(741), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(942), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [37056] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      sym_num_literal,
    ACTIONS(231), 1,
      sym_raw_enum_tag,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(249), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym__,
    ACTIONS(257), 1,
      anon_sym_PERCENT,
    ACTIONS(261), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(263), 1,
      sym_multstr_start,
    ACTIONS(265), 1,
      sym__str_start,
    ACTIONS(267), 1,
      sym_quoted_enum_tag_start,
    STATE(278), 1,
      sym_type_builtin,
    STATE(336), 1,
      sym_record_operand,
    STATE(383), 1,
      sym_quoted_enum_tag,
    ACTIONS(229), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(255), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(271), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(276), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(247), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(282), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [37132] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(743), 1,
      sym_signed_num_literal,
    ACTIONS(746), 1,
      sym_ident,
    ACTIONS(749), 1,
      sym_raw_enum_tag,
    ACTIONS(752), 1,
      anon_sym_LBRACE,
    ACTIONS(755), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_null,
    ACTIONS(761), 1,
      anon_sym_LBRACK,
    ACTIONS(766), 1,
      anon_sym__,
    ACTIONS(772), 1,
      sym_multstr_start,
    ACTIONS(775), 1,
      sym__str_start,
    ACTIONS(778), 1,
      sym_quoted_enum_tag_start,
    STATE(501), 1,
      aux_sym_array_pattern_repeat1,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    STATE(1131), 1,
      sym_pattern,
    ACTIONS(764), 2,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
    ACTIONS(769), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [37220] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(781), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [37307] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(783), 1,
      anon_sym_in,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(835), 1,
      sym_pattern,
    STATE(1016), 1,
      sym_let_binding,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [37394] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(785), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [37481] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(787), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [37568] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(789), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [37655] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(791), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [37742] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(793), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [37829] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(795), 1,
      anon_sym_in,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(835), 1,
      sym_pattern,
    STATE(1016), 1,
      sym_let_binding,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [37916] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(797), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [38003] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(799), 1,
      anon_sym_in,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(835), 1,
      sym_pattern,
    STATE(1016), 1,
      sym_let_binding,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [38090] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(801), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [38177] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(803), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [38264] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(805), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [38351] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(807), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [38438] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(809), 1,
      anon_sym_in,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(835), 1,
      sym_pattern,
    STATE(1016), 1,
      sym_let_binding,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [38525] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(811), 1,
      anon_sym_RBRACE,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [38612] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 16,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [38666] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 8,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [38734] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 3,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
  [38810] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 6,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [38880] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 10,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [38944] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(701), 1,
      sym_ident,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(907), 1,
      sym_pattern,
    STATE(1042), 1,
      sym_match_branch,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [39028] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 11,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [39088] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 5,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [39160] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(835), 1,
      sym_pattern,
    STATE(1016), 1,
      sym_let_binding,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [39244] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 11,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [39302] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 14,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [39358] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(603), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 11,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [39418] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(607), 1,
      anon_sym_PIPE,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(609), 3,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
  [39494] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(177), 1,
      sym_infix_b_op_7,
    STATE(178), 1,
      sym_infix_b_op_6,
    STATE(180), 1,
      sym_infix_b_op_4,
    STATE(181), 1,
      sym_infix_b_op_3,
    STATE(185), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_lazy_b_op_9,
    STATE(220), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(603), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 16,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [39548] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 1,
      sym_raw_enum_tag,
    ACTIONS(639), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(813), 1,
      sym_ident,
    ACTIONS(817), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym__,
    ACTIONS(821), 1,
      anon_sym_or,
    STATE(680), 1,
      sym_quoted_enum_tag,
    STATE(714), 1,
      sym_enum_tag,
    STATE(727), 1,
      sym_pattern_fun,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(741), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
    ACTIONS(815), 6,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
  [39620] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 10,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [39679] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 4,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [39750] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1041), 1,
      sym_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [39831] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1032), 1,
      sym_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [39912] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1046), 1,
      sym_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [39993] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(603), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 15,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40046] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 5,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40115] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(607), 1,
      anon_sym_PIPE,
    ACTIONS(737), 1,
      anon_sym_DASH_GT,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(609), 2,
      anon_sym_COLON,
      anon_sym_then,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [40190] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 7,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40257] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(603), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 15,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40310] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 9,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40373] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(603), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 10,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40432] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    ACTIONS(715), 1,
      anon_sym_DASH_GT,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(601), 2,
      anon_sym_COLON,
      anon_sym_else,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [40507] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 10,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40566] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 10,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40623] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(607), 1,
      anon_sym_PIPE,
    ACTIONS(715), 1,
      anon_sym_DASH_GT,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(609), 2,
      anon_sym_COLON,
      anon_sym_else,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [40698] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 13,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40753] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 15,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40806] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(603), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 10,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40865] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(188), 1,
      sym_infix_lazy_b_op_10,
    STATE(198), 1,
      sym_infix_lazy_b_op_9,
    STATE(200), 1,
      sym_infix_b_op_8,
    STATE(202), 1,
      sym_infix_b_op_6,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(207), 1,
      sym_infix_b_op_3,
    STATE(218), 1,
      sym_infix_b_op_2,
    ACTIONS(603), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 15,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [40918] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(607), 1,
      anon_sym_PIPE,
    ACTIONS(693), 1,
      anon_sym_DASH_GT,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(609), 2,
      ts_builtin_sym_end,
      anon_sym_COLON,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [40993] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(603), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 10,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41052] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(603), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 15,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41105] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(603), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 10,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41164] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    ACTIONS(693), 1,
      anon_sym_DASH_GT,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(601), 2,
      ts_builtin_sym_end,
      anon_sym_COLON,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [41239] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    ACTIONS(737), 1,
      anon_sym_DASH_GT,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(601), 2,
      anon_sym_COLON,
      anon_sym_then,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [41314] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 15,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41367] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 15,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41420] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 13,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41475] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 10,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41532] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 13,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41587] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 10,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41644] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 10,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41703] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 9,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41766] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 15,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41819] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 7,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41886] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 5,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [41955] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 13,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42010] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(161), 1,
      sym_infix_b_op_6,
    STATE(162), 1,
      sym_infix_b_op_4,
    STATE(163), 1,
      sym_infix_b_op_3,
    STATE(164), 1,
      sym_infix_b_op_2,
    STATE(201), 1,
      sym_infix_b_op_7,
    STATE(206), 1,
      sym_infix_b_op_8,
    STATE(217), 1,
      sym_infix_lazy_b_op_10,
    STATE(223), 1,
      sym_infix_lazy_b_op_9,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 4,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42081] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 10,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42140] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 10,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42197] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 9,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42260] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 7,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42327] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 5,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42396] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(599), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 9,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42459] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(190), 1,
      sym_infix_b_op_2,
    STATE(191), 1,
      sym_infix_b_op_3,
    STATE(192), 1,
      sym_infix_b_op_4,
    STATE(193), 1,
      sym_infix_b_op_6,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_8,
    STATE(196), 1,
      sym_infix_lazy_b_op_9,
    STATE(197), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 4,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42530] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 7,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42597] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(643), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym__,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1023), 1,
      sym_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(752), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(725), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [42678] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(607), 1,
      anon_sym_PIPE,
    ACTIONS(699), 1,
      anon_sym_DASH_GT,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(609), 2,
      sym_interpolation_end,
      anon_sym_COLON,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [42753] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(595), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    ACTIONS(699), 1,
      anon_sym_DASH_GT,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(601), 2,
      sym_interpolation_end,
      anon_sym_COLON,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [42828] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 5,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42897] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE_GT,
    ACTIONS(593), 1,
      anon_sym_AMP_AMP,
    ACTIONS(599), 1,
      anon_sym_PIPE,
    STATE(166), 1,
      sym_infix_lazy_b_op_10,
    STATE(167), 1,
      sym_infix_lazy_b_op_9,
    STATE(168), 1,
      sym_infix_b_op_8,
    STATE(169), 1,
      sym_infix_b_op_7,
    STATE(170), 1,
      sym_infix_b_op_6,
    STATE(171), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_3,
    STATE(173), 1,
      sym_infix_b_op_2,
    ACTIONS(577), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(581), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(587), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(591), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(579), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(601), 4,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [42968] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(825), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [43004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(829), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [43040] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(831), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(833), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [43076] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(837), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [43112] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(841), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [43148] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(845), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [43184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(849), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [43220] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(703), 1,
      sym_raw_enum_tag,
    ACTIONS(709), 1,
      sym_quoted_enum_tag_start,
    STATE(597), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(630), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(851), 2,
      sym_ident,
      anon_sym__,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(759), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(739), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [43296] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(649), 1,
      anon_sym_LPAREN,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    STATE(532), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(711), 1,
      sym_enum_pattern_parens,
    STATE(724), 1,
      sym_or_pattern_parens,
    STATE(754), 1,
      sym_or_pattern_unparens,
    STATE(763), 1,
      sym_enum_variant_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(851), 2,
      sym_ident,
      anon_sym__,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(759), 2,
      sym_enum_pattern,
      sym_or_pattern,
    STATE(739), 3,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
  [43372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(853), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(855), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [43408] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(817), 1,
      anon_sym_LPAREN,
    STATE(612), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(1100), 1,
      sym_pattern_or_branch,
    STATE(1115), 1,
      sym_or_pattern_unparens,
    STATE(1151), 1,
      sym_enum_variant_pattern,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(857), 2,
      sym_ident,
      anon_sym__,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(711), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [43476] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(817), 1,
      anon_sym_LPAREN,
    STATE(612), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(1053), 1,
      sym_enum_variant_pattern,
    STATE(1100), 1,
      sym_pattern_or_branch,
    STATE(1115), 1,
      sym_or_pattern_unparens,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(857), 2,
      sym_ident,
      anon_sym__,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(711), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [43544] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 1,
      sym_raw_enum_tag,
    ACTIONS(639), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(813), 1,
      sym_ident,
    ACTIONS(815), 1,
      anon_sym_EQ_GT,
    ACTIONS(817), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym__,
    ACTIONS(821), 1,
      anon_sym_or,
    ACTIONS(859), 1,
      anon_sym_if,
    STATE(680), 1,
      sym_quoted_enum_tag,
    STATE(714), 1,
      sym_enum_tag,
    STATE(727), 1,
      sym_pattern_fun,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(741), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [43614] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(645), 1,
      sym_raw_enum_tag,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(665), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(817), 1,
      anon_sym_LPAREN,
    STATE(612), 1,
      sym_enum_tag,
    STATE(617), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(627), 1,
      sym_quoted_enum_tag,
    STATE(1100), 1,
      sym_pattern_or_branch,
    STATE(1101), 1,
      sym_enum_variant_pattern,
    STATE(1153), 1,
      sym_or_pattern_unparens,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(857), 2,
      sym_ident,
      anon_sym__,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(711), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [43682] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(867), 1,
      anon_sym_EQ_GT,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(604), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [43747] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(887), 1,
      anon_sym_EQ_GT,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(604), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [43812] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(889), 1,
      anon_sym_EQ_GT,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(604), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [43877] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(891), 1,
      anon_sym_EQ_GT,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(604), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [43942] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(893), 1,
      anon_sym_EQ_GT,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(604), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44007] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(895), 1,
      sym_signed_num_literal,
    ACTIONS(898), 1,
      sym_ident,
    ACTIONS(901), 1,
      sym_raw_enum_tag,
    ACTIONS(904), 1,
      anon_sym_EQ_GT,
    ACTIONS(906), 1,
      anon_sym_LBRACE,
    ACTIONS(909), 1,
      anon_sym_LPAREN,
    ACTIONS(912), 1,
      anon_sym_null,
    ACTIONS(915), 1,
      anon_sym_LBRACK,
    ACTIONS(918), 1,
      anon_sym__,
    ACTIONS(924), 1,
      sym_multstr_start,
    ACTIONS(927), 1,
      sym__str_start,
    ACTIONS(930), 1,
      sym_quoted_enum_tag_start,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(921), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(604), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44072] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(933), 1,
      anon_sym_EQ_GT,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(604), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 12,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(937), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [44170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(941), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [44202] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(945), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [44234] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(601), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44296] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(603), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44358] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(599), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44420] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 1,
      sym_raw_enum_tag,
    ACTIONS(639), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(813), 1,
      sym_ident,
    ACTIONS(817), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym__,
    ACTIONS(821), 1,
      anon_sym_or,
    STATE(680), 1,
      sym_quoted_enum_tag,
    STATE(714), 1,
      sym_enum_tag,
    STATE(727), 1,
      sym_pattern_fun,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(741), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44484] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(949), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [44516] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(600), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(951), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(953), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [44610] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(602), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44672] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 1,
      sym_raw_enum_tag,
    ACTIONS(639), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(817), 1,
      anon_sym_LPAREN,
    STATE(623), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(680), 1,
      sym_quoted_enum_tag,
    STATE(710), 1,
      sym_pattern_or_branch,
    STATE(714), 1,
      sym_enum_tag,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(857), 2,
      sym_ident,
      anon_sym__,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(711), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44734] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(863), 1,
      sym_ident,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(877), 1,
      anon_sym__,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(605), 2,
      sym_pattern_fun,
      aux_sym_fun_expr_repeat1,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(653), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(955), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(957), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [44828] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(555), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(959), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [44860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(963), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [44892] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(967), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [44924] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 1,
      sym_signed_num_literal,
    ACTIONS(975), 1,
      sym_raw_enum_tag,
    ACTIONS(978), 1,
      anon_sym_LBRACE,
    ACTIONS(981), 1,
      anon_sym_LPAREN,
    ACTIONS(984), 1,
      anon_sym_null,
    ACTIONS(987), 1,
      anon_sym_LBRACK,
    ACTIONS(993), 1,
      sym_multstr_start,
    ACTIONS(996), 1,
      sym__str_start,
    ACTIONS(999), 1,
      sym_quoted_enum_tag_start,
    STATE(623), 1,
      aux_sym_or_pattern_unparens_repeat1,
    STATE(680), 1,
      sym_quoted_enum_tag,
    STATE(714), 1,
      sym_enum_tag,
    STATE(1100), 1,
      sym_pattern_or_branch,
    ACTIONS(972), 2,
      sym_ident,
      anon_sym__,
    ACTIONS(990), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(711), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [44986] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 1,
      sym_raw_enum_tag,
    ACTIONS(639), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(641), 1,
      sym_signed_num_literal,
    ACTIONS(647), 1,
      anon_sym_LBRACE,
    ACTIONS(651), 1,
      anon_sym_null,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(661), 1,
      sym_multstr_start,
    ACTIONS(663), 1,
      sym__str_start,
    ACTIONS(817), 1,
      anon_sym_LPAREN,
    STATE(680), 1,
      sym_quoted_enum_tag,
    STATE(714), 1,
      sym_enum_tag,
    ACTIONS(629), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(1002), 2,
      sym_ident,
      anon_sym__,
    STATE(706), 2,
      sym_bool,
      sym_static_string,
    STATE(738), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [45042] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      sym_signed_num_literal,
    ACTIONS(865), 1,
      sym_raw_enum_tag,
    ACTIONS(869), 1,
      anon_sym_LBRACE,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      anon_sym_null,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(881), 1,
      sym_multstr_start,
    ACTIONS(883), 1,
      sym__str_start,
    ACTIONS(885), 1,
      sym_quoted_enum_tag_start,
    STATE(660), 1,
      sym_quoted_enum_tag,
    STATE(665), 1,
      sym_enum_tag,
    ACTIONS(879), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(1004), 2,
      sym_ident,
      anon_sym__,
    STATE(669), 2,
      sym_bool,
      sym_static_string,
    STATE(672), 5,
      sym_constant_pattern,
      sym_record_pattern,
      sym_array_pattern,
      sym_enum_pattern_parens,
      sym_or_pattern_parens,
  [45098] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 6,
      sym_ident,
      anon_sym_null,
      anon_sym__,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(373), 14,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_signed_num_literal,
      sym_raw_enum_tag,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [45126] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 6,
      sym_ident,
      anon_sym_null,
      anon_sym__,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(369), 14,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_signed_num_literal,
      sym_raw_enum_tag,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [45154] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 6,
      sym_ident,
      anon_sym_null,
      anon_sym__,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(377), 14,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_signed_num_literal,
      sym_raw_enum_tag,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [45182] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 1,
      anon_sym_EQ,
    ACTIONS(531), 15,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_or,
      anon_sym_QMARK,
  [45206] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 7,
      sym_ident,
      anon_sym_if,
      anon_sym_null,
      anon_sym__,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(369), 9,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_signed_num_literal,
      sym_raw_enum_tag,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
  [45230] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 7,
      sym_ident,
      anon_sym_if,
      anon_sym_null,
      anon_sym__,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(377), 9,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_signed_num_literal,
      sym_raw_enum_tag,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
  [45254] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 7,
      sym_ident,
      anon_sym_if,
      anon_sym_null,
      anon_sym__,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(373), 9,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_signed_num_literal,
      sym_raw_enum_tag,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
  [45278] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_EQ,
    ACTIONS(543), 15,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_or,
      anon_sym_QMARK,
  [45302] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_AT,
    ACTIONS(1008), 5,
      sym_ident,
      anon_sym_null,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(1006), 9,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_signed_num_literal,
      sym_raw_enum_tag,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
  [45327] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 1,
      sym_multstr_start,
    ACTIONS(637), 1,
      sym__str_start,
    ACTIONS(1012), 1,
      sym_ident,
    ACTIONS(1014), 1,
      anon_sym_RBRACE,
    ACTIONS(1016), 1,
      anon_sym_SEMI,
    ACTIONS(1018), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1020), 1,
      anon_sym__,
    STATE(650), 1,
      aux_sym_uni_record_repeat1,
    STATE(731), 1,
      sym_field_path,
    STATE(772), 1,
      sym_field_path_elem,
    STATE(804), 1,
      sym_str_chunks,
    STATE(941), 1,
      sym_record_field,
    STATE(1003), 1,
      sym_record_last_field,
    STATE(751), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [45374] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 1,
      sym_multstr_start,
    ACTIONS(637), 1,
      sym__str_start,
    ACTIONS(1012), 1,
      sym_ident,
    ACTIONS(1018), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1022), 1,
      anon_sym_RBRACE,
    ACTIONS(1024), 1,
      anon_sym_SEMI,
    ACTIONS(1026), 1,
      anon_sym__,
    STATE(649), 1,
      aux_sym_uni_record_repeat1,
    STATE(731), 1,
      sym_field_path,
    STATE(772), 1,
      sym_field_path_elem,
    STATE(804), 1,
      sym_str_chunks,
    STATE(941), 1,
      sym_record_field,
    STATE(1043), 1,
      sym_record_last_field,
    STATE(751), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [45421] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 1,
      sym_multstr_start,
    ACTIONS(637), 1,
      sym__str_start,
    ACTIONS(1012), 1,
      sym_ident,
    ACTIONS(1018), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1028), 1,
      anon_sym_RBRACE,
    ACTIONS(1030), 1,
      anon_sym_SEMI,
    ACTIONS(1032), 1,
      anon_sym__,
    STATE(645), 1,
      aux_sym_uni_record_repeat1,
    STATE(731), 1,
      sym_field_path,
    STATE(772), 1,
      sym_field_path_elem,
    STATE(804), 1,
      sym_str_chunks,
    STATE(941), 1,
      sym_record_field,
    STATE(1008), 1,
      sym_record_last_field,
    STATE(751), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [45468] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 1,
      sym_multstr_start,
    ACTIONS(637), 1,
      sym__str_start,
    ACTIONS(1012), 1,
      sym_ident,
    ACTIONS(1018), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1034), 1,
      anon_sym_RBRACE,
    ACTIONS(1036), 1,
      anon_sym_SEMI,
    ACTIONS(1038), 1,
      anon_sym__,
    STATE(656), 1,
      aux_sym_uni_record_repeat1,
    STATE(731), 1,
      sym_field_path,
    STATE(772), 1,
      sym_field_path_elem,
    STATE(804), 1,
      sym_str_chunks,
    STATE(941), 1,
      sym_record_field,
    STATE(1034), 1,
      sym_record_last_field,
    STATE(751), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [45515] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 1,
      sym_multstr_start,
    ACTIONS(637), 1,
      sym__str_start,
    ACTIONS(1012), 1,
      sym_ident,
    ACTIONS(1018), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1040), 1,
      anon_sym_RBRACE,
    ACTIONS(1042), 1,
      anon_sym_SEMI,
    ACTIONS(1044), 1,
      anon_sym__,
    STATE(644), 1,
      aux_sym_uni_record_repeat1,
    STATE(731), 1,
      sym_field_path,
    STATE(772), 1,
      sym_field_path_elem,
    STATE(804), 1,
      sym_str_chunks,
    STATE(941), 1,
      sym_record_field,
    STATE(1036), 1,
      sym_record_last_field,
    STATE(751), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [45562] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 1,
      sym_multstr_start,
    ACTIONS(637), 1,
      sym__str_start,
    ACTIONS(1012), 1,
      sym_ident,
    ACTIONS(1018), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1046), 1,
      anon_sym_RBRACE,
    ACTIONS(1048), 1,
      anon_sym_SEMI,
    ACTIONS(1050), 1,
      anon_sym__,
    STATE(675), 1,
      aux_sym_uni_record_repeat1,
    STATE(731), 1,
      sym_field_path,
    STATE(772), 1,
      sym_field_path_elem,
    STATE(804), 1,
      sym_str_chunks,
    STATE(941), 1,
      sym_record_field,
    STATE(1020), 1,
      sym_record_last_field,
    STATE(751), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [45609] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 1,
      sym_multstr_start,
    ACTIONS(637), 1,
      sym__str_start,
    ACTIONS(1012), 1,
      sym_ident,
    ACTIONS(1018), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1052), 1,
      anon_sym_RBRACE,
    ACTIONS(1054), 1,
      anon_sym_SEMI,
    ACTIONS(1056), 1,
      anon_sym__,
    STATE(647), 1,
      aux_sym_uni_record_repeat1,
    STATE(731), 1,
      sym_field_path,
    STATE(772), 1,
      sym_field_path_elem,
    STATE(804), 1,
      sym_str_chunks,
    STATE(941), 1,
      sym_record_field,
    STATE(1037), 1,
      sym_record_last_field,
    STATE(751), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [45656] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 5,
      sym_ident,
      anon_sym_null,
      anon_sym__,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(764), 10,
      sym_multstr_start,
      sym_