{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Converter output stream implements t'GI.Gio.Objects.OutputStream.OutputStream' and allows
-- conversion of data of various types during reading.
-- 
-- As of GLib 2.34, @GConverterOutputStream@ implements
-- t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.ConverterOutputStream
    ( 

-- * Exported types
    ConverterOutputStream(..)               ,
    IsConverterOutputStream                 ,
    toConverterOutputStream                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canPoll]("GI.Gio.Interfaces.PollableOutputStream#g:method:canPoll"), [clearPending]("GI.Gio.Objects.OutputStream#g:method:clearPending"), [close]("GI.Gio.Objects.OutputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.OutputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.OutputStream#g:method:closeFinish"), [createSource]("GI.Gio.Interfaces.PollableOutputStream#g:method:createSource"), [flush]("GI.Gio.Objects.OutputStream#g:method:flush"), [flushAsync]("GI.Gio.Objects.OutputStream#g:method:flushAsync"), [flushFinish]("GI.Gio.Objects.OutputStream#g:method:flushFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.OutputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.OutputStream#g:method:isClosed"), [isClosing]("GI.Gio.Objects.OutputStream#g:method:isClosing"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isWritable]("GI.Gio.Interfaces.PollableOutputStream#g:method:isWritable"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [splice]("GI.Gio.Objects.OutputStream#g:method:splice"), [spliceAsync]("GI.Gio.Objects.OutputStream#g:method:spliceAsync"), [spliceFinish]("GI.Gio.Objects.OutputStream#g:method:spliceFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [write]("GI.Gio.Objects.OutputStream#g:method:write"), [writeAll]("GI.Gio.Objects.OutputStream#g:method:writeAll"), [writeAllAsync]("GI.Gio.Objects.OutputStream#g:method:writeAllAsync"), [writeAllFinish]("GI.Gio.Objects.OutputStream#g:method:writeAllFinish"), [writeAsync]("GI.Gio.Objects.OutputStream#g:method:writeAsync"), [writeBytes]("GI.Gio.Objects.OutputStream#g:method:writeBytes"), [writeBytesAsync]("GI.Gio.Objects.OutputStream#g:method:writeBytesAsync"), [writeBytesFinish]("GI.Gio.Objects.OutputStream#g:method:writeBytesFinish"), [writeFinish]("GI.Gio.Objects.OutputStream#g:method:writeFinish"), [writeNonblocking]("GI.Gio.Interfaces.PollableOutputStream#g:method:writeNonblocking"), [writev]("GI.Gio.Objects.OutputStream#g:method:writev"), [writevAll]("GI.Gio.Objects.OutputStream#g:method:writevAll"), [writevAllAsync]("GI.Gio.Objects.OutputStream#g:method:writevAllAsync"), [writevAllFinish]("GI.Gio.Objects.OutputStream#g:method:writevAllFinish"), [writevAsync]("GI.Gio.Objects.OutputStream#g:method:writevAsync"), [writevFinish]("GI.Gio.Objects.OutputStream#g:method:writevFinish"), [writevNonblocking]("GI.Gio.Interfaces.PollableOutputStream#g:method:writevNonblocking").
-- 
-- ==== Getters
-- [getBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:getBaseStream"), [getCloseBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:getCloseBaseStream"), [getConverter]("GI.Gio.Objects.ConverterOutputStream#g:method:getConverter"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setCloseBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:setCloseBaseStream"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.OutputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveConverterOutputStreamMethod      ,
#endif

-- ** getConverter #method:getConverter#

#if defined(ENABLE_OVERLOADING)
    ConverterOutputStreamGetConverterMethodInfo,
#endif
    converterOutputStreamGetConverter       ,


-- ** new #method:new#

    converterOutputStreamNew                ,




 -- * Properties


-- ** converter #attr:converter#
-- | The converter object.

#if defined(ENABLE_OVERLOADING)
    ConverterOutputStreamConverterPropertyInfo,
#endif
    constructConverterOutputStreamConverter ,
#if defined(ENABLE_OVERLOADING)
    converterOutputStreamConverter          ,
#endif
    getConverterOutputStreamConverter       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Converter as Gio.Converter
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableOutputStream as Gio.PollableOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FilterOutputStream as Gio.FilterOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Converter as Gio.Converter
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableOutputStream as Gio.PollableOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FilterOutputStream as Gio.FilterOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#endif

-- | Memory-managed wrapper type.
newtype ConverterOutputStream = ConverterOutputStream (SP.ManagedPtr ConverterOutputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype ConverterOutputStream where
    toManagedPtr (ConverterOutputStream p) = p

foreign import ccall "g_converter_output_stream_get_type"
    c_g_converter_output_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject ConverterOutputStream where
    glibType = c_g_converter_output_stream_get_type

instance B.Types.GObject ConverterOutputStream

-- | Type class for types which can be safely cast to t'ConverterOutputStream', for instance with `toConverterOutputStream`.
class (SP.GObject o, O.IsDescendantOf ConverterOutputStream o) => IsConverterOutputStream o
instance (SP.GObject o, O.IsDescendantOf ConverterOutputStream o) => IsConverterOutputStream o

instance O.HasParentTypes ConverterOutputStream
type instance O.ParentTypes ConverterOutputStream = '[Gio.FilterOutputStream.FilterOutputStream, Gio.OutputStream.OutputStream, GObject.Object.Object, Gio.PollableOutputStream.PollableOutputStream]

-- | Cast to t'ConverterOutputStream', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toConverterOutputStream :: (MIO.MonadIO m, IsConverterOutputStream o) => o -> m ConverterOutputStream
toConverterOutputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo ConverterOutputStream

-- | Convert t'ConverterOutputStream' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ConverterOutputStream) where
    gvalueGType_ = c_g_converter_output_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ConverterOutputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ConverterOutputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ConverterOutputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveConverterOutputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveConverterOutputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveConverterOutputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveConverterOutputStreamMethod "canPoll" o = Gio.PollableOutputStream.PollableOutputStreamCanPollMethodInfo
    ResolveConverterOutputStreamMethod "clearPending" o = Gio.OutputStream.OutputStreamClearPendingMethodInfo
    ResolveConverterOutputStreamMethod "close" o = Gio.OutputStream.OutputStreamCloseMethodInfo
    ResolveConverterOutputStreamMethod "closeAsync" o = Gio.OutputStream.OutputStreamCloseAsyncMethodInfo
    ResolveConverterOutputStreamMethod "closeFinish" o = Gio.OutputStream.OutputStreamCloseFinishMethodInfo
    ResolveConverterOutputStreamMethod "createSource" o = Gio.PollableOutputStream.PollableOutputStreamCreateSourceMethodInfo
    ResolveConverterOutputStreamMethod "flush" o = Gio.OutputStream.OutputStreamFlushMethodInfo
    ResolveConverterOutputStreamMethod "flushAsync" o = Gio.OutputStream.OutputStreamFlushAsyncMethodInfo
    ResolveConverterOutputStreamMethod "flushFinish" o = Gio.OutputStream.OutputStreamFlushFinishMethodInfo
    ResolveConverterOutputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveConverterOutputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveConverterOutputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveConverterOutputStreamMethod "hasPending" o = Gio.OutputStream.OutputStreamHasPendingMethodInfo
    ResolveConverterOutputStreamMethod "isClosed" o = Gio.OutputStream.OutputStreamIsClosedMethodInfo
    ResolveConverterOutputStreamMethod "isClosing" o = Gio.OutputStream.OutputStreamIsClosingMethodInfo
    ResolveConverterOutputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveConverterOutputStreamMethod "isWritable" o = Gio.PollableOutputStream.PollableOutputStreamIsWritableMethodInfo
    ResolveConverterOutputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveConverterOutputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveConverterOutputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveConverterOutputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveConverterOutputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveConverterOutputStreamMethod "splice" o = Gio.OutputStream.OutputStreamSpliceMethodInfo
    ResolveConverterOutputStreamMethod "spliceAsync" o = Gio.OutputStream.OutputStreamSpliceAsyncMethodInfo
    ResolveConverterOutputStreamMethod "spliceFinish" o = Gio.OutputStream.OutputStreamSpliceFinishMethodInfo
    ResolveConverterOutputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveConverterOutputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveConverterOutputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveConverterOutputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveConverterOutputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveConverterOutputStreamMethod "write" o = Gio.OutputStream.OutputStreamWriteMethodInfo
    ResolveConverterOutputStreamMethod "writeAll" o = Gio.OutputStream.OutputStreamWriteAllMethodInfo
    ResolveConverterOutputStreamMethod "writeAllAsync" o = Gio.OutputStream.OutputStreamWriteAllAsyncMethodInfo
    ResolveConverterOutputStreamMethod "writeAllFinish" o = Gio.OutputStream.OutputStreamWriteAllFinishMethodInfo
    ResolveConverterOutputStreamMethod "writeAsync" o = Gio.OutputStream.OutputStreamWriteAsyncMethodInfo
    ResolveConverterOutputStreamMethod "writeBytes" o = Gio.OutputStream.OutputStreamWriteBytesMethodInfo
    ResolveConverterOutputStreamMethod "writeBytesAsync" o = Gio.OutputStream.OutputStreamWriteBytesAsyncMethodInfo
    ResolveConverterOutputStreamMethod "writeBytesFinish" o = Gio.OutputStream.OutputStreamWriteBytesFinishMethodInfo
    ResolveConverterOutputStreamMethod "writeFinish" o = Gio.OutputStream.OutputStreamWriteFinishMethodInfo
    ResolveConverterOutputStreamMethod "writeNonblocking" o = Gio.PollableOutputStream.PollableOutputStreamWriteNonblockingMethodInfo
    ResolveConverterOutputStreamMethod "writev" o = Gio.OutputStream.OutputStreamWritevMethodInfo
    ResolveConverterOutputStreamMethod "writevAll" o = Gio.OutputStream.OutputStreamWritevAllMethodInfo
    ResolveConverterOutputStreamMethod "writevAllAsync" o = Gio.OutputStream.OutputStreamWritevAllAsyncMethodInfo
    ResolveConverterOutputStreamMethod "writevAllFinish" o = Gio.OutputStream.OutputStreamWritevAllFinishMethodInfo
    ResolveConverterOutputStreamMethod "writevAsync" o = Gio.OutputStream.OutputStreamWritevAsyncMethodInfo
    ResolveConverterOutputStreamMethod "writevFinish" o = Gio.OutputStream.OutputStreamWritevFinishMethodInfo
    ResolveConverterOutputStreamMethod "writevNonblocking" o = Gio.PollableOutputStream.PollableOutputStreamWritevNonblockingMethodInfo
    ResolveConverterOutputStreamMethod "getBaseStream" o = Gio.FilterOutputStream.FilterOutputStreamGetBaseStreamMethodInfo
    ResolveConverterOutputStreamMethod "getCloseBaseStream" o = Gio.FilterOutputStream.FilterOutputStreamGetCloseBaseStreamMethodInfo
    ResolveConverterOutputStreamMethod "getConverter" o = ConverterOutputStreamGetConverterMethodInfo
    ResolveConverterOutputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveConverterOutputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveConverterOutputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveConverterOutputStreamMethod "setCloseBaseStream" o = Gio.FilterOutputStream.FilterOutputStreamSetCloseBaseStreamMethodInfo
    ResolveConverterOutputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveConverterOutputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveConverterOutputStreamMethod "setPending" o = Gio.OutputStream.OutputStreamSetPendingMethodInfo
    ResolveConverterOutputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveConverterOutputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveConverterOutputStreamMethod t ConverterOutputStream, O.OverloadedMethod info ConverterOutputStream p) => OL.IsLabel t (ConverterOutputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveConverterOutputStreamMethod t ConverterOutputStream, O.OverloadedMethod info ConverterOutputStream p, R.HasField t ConverterOutputStream p) => R.HasField t ConverterOutputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveConverterOutputStreamMethod t ConverterOutputStream, O.OverloadedMethodInfo info ConverterOutputStream) => OL.IsLabel t (O.MethodProxy info ConverterOutputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "converter"
   -- Type: TInterface (Name {namespace = "Gio", name = "Converter"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@converter@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' converterOutputStream #converter
-- @
getConverterOutputStreamConverter :: (MonadIO m, IsConverterOutputStream o) => o -> m Gio.Converter.Converter
getConverterOutputStreamConverter obj = MIO.liftIO $ checkUnexpectedNothing "getConverterOutputStreamConverter" $ B.Properties.getObjectPropertyObject obj "converter" Gio.Converter.Converter

-- | Construct a t'GValueConstruct' with valid value for the “@converter@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructConverterOutputStreamConverter :: (IsConverterOutputStream o, MIO.MonadIO m, Gio.Converter.IsConverter a) => a -> m (GValueConstruct o)
constructConverterOutputStreamConverter val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "converter" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ConverterOutputStreamConverterPropertyInfo
instance AttrInfo ConverterOutputStreamConverterPropertyInfo where
    type AttrAllowedOps ConverterOutputStreamConverterPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ConverterOutputStreamConverterPropertyInfo = IsConverterOutputStream
    type AttrSetTypeConstraint ConverterOutputStreamConverterPropertyInfo = Gio.Converter.IsConverter
    type AttrTransferTypeConstraint ConverterOutputStreamConverterPropertyInfo = Gio.Converter.IsConverter
    type AttrTransferType ConverterOutputStreamConverterPropertyInfo = Gio.Converter.Converter
    type AttrGetType ConverterOutputStreamConverterPropertyInfo = Gio.Converter.Converter
    type AttrLabel ConverterOutputStreamConverterPropertyInfo = "converter"
    type AttrOrigin ConverterOutputStreamConverterPropertyInfo = ConverterOutputStream
    attrGet = getConverterOutputStreamConverter
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.Converter.Converter v
    attrConstruct = constructConverterOutputStreamConverter
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ConverterOutputStream.converter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ConverterOutputStream.html#g:attr:converter"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ConverterOutputStream
type instance O.AttributeList ConverterOutputStream = ConverterOutputStreamAttributeList
type ConverterOutputStreamAttributeList = ('[ '("baseStream", Gio.FilterOutputStream.FilterOutputStreamBaseStreamPropertyInfo), '("closeBaseStream", Gio.FilterOutputStream.FilterOutputStreamCloseBaseStreamPropertyInfo), '("converter", ConverterOutputStreamConverterPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
converterOutputStreamConverter :: AttrLabelProxy "converter"
converterOutputStreamConverter = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ConverterOutputStream = ConverterOutputStreamSignalList
type ConverterOutputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ConverterOutputStream::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "base_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "OutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOutputStream" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "converter"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Converter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GConverter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "ConverterOutputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_converter_output_stream_new" g_converter_output_stream_new :: 
    Ptr Gio.OutputStream.OutputStream ->    -- base_stream : TInterface (Name {namespace = "Gio", name = "OutputStream"})
    Ptr Gio.Converter.Converter ->          -- converter : TInterface (Name {namespace = "Gio", name = "Converter"})
    IO (Ptr ConverterOutputStream)

-- | Creates a new converter output stream for the /@baseStream@/.
converterOutputStreamNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.OutputStream.IsOutputStream a, Gio.Converter.IsConverter b) =>
    a
    -- ^ /@baseStream@/: a t'GI.Gio.Objects.OutputStream.OutputStream'
    -> b
    -- ^ /@converter@/: a t'GI.Gio.Interfaces.Converter.Converter'
    -> m ConverterOutputStream
    -- ^ __Returns:__ a new t'GI.Gio.Objects.OutputStream.OutputStream'.
converterOutputStreamNew baseStream converter = liftIO $ do
    baseStream' <- unsafeManagedPtrCastPtr baseStream
    converter' <- unsafeManagedPtrCastPtr converter
    result <- g_converter_output_stream_new baseStream' converter'
    checkUnexpectedReturnNULL "converterOutputStreamNew" result
    result' <- (wrapObject ConverterOutputStream) result
    touchManagedPtr baseStream
    touchManagedPtr converter
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ConverterOutputStream::get_converter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "converter_stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "ConverterOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GConverterOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Converter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_converter_output_stream_get_converter" g_converter_output_stream_get_converter :: 
    Ptr ConverterOutputStream ->            -- converter_stream : TInterface (Name {namespace = "Gio", name = "ConverterOutputStream"})
    IO (Ptr Gio.Converter.Converter)

-- | Gets the t'GI.Gio.Interfaces.Converter.Converter' that is used by /@converterStream@/.
-- 
-- /Since: 2.24/
converterOutputStreamGetConverter ::
    (B.CallStack.HasCallStack, MonadIO m, IsConverterOutputStream a) =>
    a
    -- ^ /@converterStream@/: a t'GI.Gio.Objects.ConverterOutputStream.ConverterOutputStream'
    -> m Gio.Converter.Converter
    -- ^ __Returns:__ the converter of the converter output stream
converterOutputStreamGetConverter converterStream = liftIO $ do
    converterStream' <- unsafeManagedPtrCastPtr converterStream
    result <- g_converter_output_stream_get_converter converterStream'
    checkUnexpectedReturnNULL "converterOutputStreamGetConverter" result
    result' <- (newObject Gio.Converter.Converter) result
    touchManagedPtr converterStream
    return result'

#if defined(ENABLE_OVERLOADING)
data ConverterOutputStreamGetConverterMethodInfo
instance (signature ~ (m Gio.Converter.Converter), MonadIO m, IsConverterOutputStream a) => O.OverloadedMethod ConverterOutputStreamGetConverterMethodInfo a signature where
    overloadedMethod = converterOutputStreamGetConverter

instance O.OverloadedMethodInfo ConverterOutputStreamGetConverterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ConverterOutputStream.converterOutputStreamGetConverter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ConverterOutputStream.html#v:converterOutputStreamGetConverter"
        })


#endif


