{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Represents the source of an ongoing DND operation.
-- 
-- A @GdkDrag@ is created when a drag is started, and stays alive for duration of
-- the DND operation. After a drag has been started with 'GI.Gdk.Objects.Drag.dragBegin',
-- the caller gets informed about the status of the ongoing drag operation
-- with signals on the @GdkDrag@ object.
-- 
-- GTK provides a higher level abstraction based on top of these functions,
-- and so they are not normally needed in GTK applications. See the
-- \"Drag and Drop\" section of the GTK documentation for more information.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Drag
    ( 

-- * Exported types
    Drag(..)                                ,
    IsDrag                                  ,
    toDrag                                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [dropDone]("GI.Gdk.Objects.Drag#g:method:dropDone"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActions]("GI.Gdk.Objects.Drag#g:method:getActions"), [getContent]("GI.Gdk.Objects.Drag#g:method:getContent"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDevice]("GI.Gdk.Objects.Drag#g:method:getDevice"), [getDisplay]("GI.Gdk.Objects.Drag#g:method:getDisplay"), [getDragSurface]("GI.Gdk.Objects.Drag#g:method:getDragSurface"), [getFormats]("GI.Gdk.Objects.Drag#g:method:getFormats"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSelectedAction]("GI.Gdk.Objects.Drag#g:method:getSelectedAction"), [getSurface]("GI.Gdk.Objects.Drag#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setHotspot]("GI.Gdk.Objects.Drag#g:method:setHotspot"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDragMethod                       ,
#endif

-- ** begin #method:begin#

    dragBegin                               ,


-- ** dropDone #method:dropDone#

#if defined(ENABLE_OVERLOADING)
    DragDropDoneMethodInfo                  ,
#endif
    dragDropDone                            ,


-- ** getActions #method:getActions#

#if defined(ENABLE_OVERLOADING)
    DragGetActionsMethodInfo                ,
#endif
    dragGetActions                          ,


-- ** getContent #method:getContent#

#if defined(ENABLE_OVERLOADING)
    DragGetContentMethodInfo                ,
#endif
    dragGetContent                          ,


-- ** getDevice #method:getDevice#

#if defined(ENABLE_OVERLOADING)
    DragGetDeviceMethodInfo                 ,
#endif
    dragGetDevice                           ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    DragGetDisplayMethodInfo                ,
#endif
    dragGetDisplay                          ,


-- ** getDragSurface #method:getDragSurface#

#if defined(ENABLE_OVERLOADING)
    DragGetDragSurfaceMethodInfo            ,
#endif
    dragGetDragSurface                      ,


-- ** getFormats #method:getFormats#

#if defined(ENABLE_OVERLOADING)
    DragGetFormatsMethodInfo                ,
#endif
    dragGetFormats                          ,


-- ** getSelectedAction #method:getSelectedAction#

#if defined(ENABLE_OVERLOADING)
    DragGetSelectedActionMethodInfo         ,
#endif
    dragGetSelectedAction                   ,


-- ** getSurface #method:getSurface#

#if defined(ENABLE_OVERLOADING)
    DragGetSurfaceMethodInfo                ,
#endif
    dragGetSurface                          ,


-- ** setHotspot #method:setHotspot#

#if defined(ENABLE_OVERLOADING)
    DragSetHotspotMethodInfo                ,
#endif
    dragSetHotspot                          ,




 -- * Properties


-- ** actions #attr:actions#
-- | The possible actions of this drag.

#if defined(ENABLE_OVERLOADING)
    DragActionsPropertyInfo                 ,
#endif
    constructDragActions                    ,
#if defined(ENABLE_OVERLOADING)
    dragActions                             ,
#endif
    getDragActions                          ,
    setDragActions                          ,


-- ** content #attr:content#
-- | The @GdkContentProvider@.

#if defined(ENABLE_OVERLOADING)
    DragContentPropertyInfo                 ,
#endif
    constructDragContent                    ,
#if defined(ENABLE_OVERLOADING)
    dragContent                             ,
#endif
    getDragContent                          ,


-- ** device #attr:device#
-- | The @GdkDevice@ that is performing the drag.

#if defined(ENABLE_OVERLOADING)
    DragDevicePropertyInfo                  ,
#endif
    constructDragDevice                     ,
#if defined(ENABLE_OVERLOADING)
    dragDevice                              ,
#endif
    getDragDevice                           ,


-- ** display #attr:display#
-- | The @GdkDisplay@ that the drag belongs to.

#if defined(ENABLE_OVERLOADING)
    DragDisplayPropertyInfo                 ,
#endif
#if defined(ENABLE_OVERLOADING)
    dragDisplay                             ,
#endif
    getDragDisplay                          ,


-- ** formats #attr:formats#
-- | The possible formats that the drag can provide its data in.

#if defined(ENABLE_OVERLOADING)
    DragFormatsPropertyInfo                 ,
#endif
    constructDragFormats                    ,
#if defined(ENABLE_OVERLOADING)
    dragFormats                             ,
#endif
    getDragFormats                          ,


-- ** selectedAction #attr:selectedAction#
-- | The currently selected action of the drag.

#if defined(ENABLE_OVERLOADING)
    DragSelectedActionPropertyInfo          ,
#endif
    constructDragSelectedAction             ,
#if defined(ENABLE_OVERLOADING)
    dragSelectedAction                      ,
#endif
    getDragSelectedAction                   ,
    setDragSelectedAction                   ,


-- ** surface #attr:surface#
-- | The surface where the drag originates.

#if defined(ENABLE_OVERLOADING)
    DragSurfacePropertyInfo                 ,
#endif
    constructDragSurface                    ,
#if defined(ENABLE_OVERLOADING)
    dragSurface                             ,
#endif
    getDragSurface                          ,




 -- * Signals


-- ** cancel #signal:cancel#

    DragCancelCallback                      ,
#if defined(ENABLE_OVERLOADING)
    DragCancelSignalInfo                    ,
#endif
    afterDragCancel                         ,
    onDragCancel                            ,


-- ** dndFinished #signal:dndFinished#

    DragDndFinishedCallback                 ,
#if defined(ENABLE_OVERLOADING)
    DragDndFinishedSignalInfo               ,
#endif
    afterDragDndFinished                    ,
    onDragDndFinished                       ,


-- ** dropPerformed #signal:dropPerformed#

    DragDropPerformedCallback               ,
#if defined(ENABLE_OVERLOADING)
    DragDropPerformedSignalInfo             ,
#endif
    afterDragDropPerformed                  ,
    onDragDropPerformed                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats

#endif

-- | Memory-managed wrapper type.
newtype Drag = Drag (SP.ManagedPtr Drag)
    deriving (Eq)

instance SP.ManagedPtrNewtype Drag where
    toManagedPtr (Drag p) = p

foreign import ccall "gdk_drag_get_type"
    c_gdk_drag_get_type :: IO B.Types.GType

instance B.Types.TypedObject Drag where
    glibType = c_gdk_drag_get_type

instance B.Types.GObject Drag

-- | Type class for types which can be safely cast to t'Drag', for instance with `toDrag`.
class (SP.GObject o, O.IsDescendantOf Drag o) => IsDrag o
instance (SP.GObject o, O.IsDescendantOf Drag o) => IsDrag o

instance O.HasParentTypes Drag
type instance O.ParentTypes Drag = '[GObject.Object.Object]

-- | Cast to t'Drag', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDrag :: (MIO.MonadIO m, IsDrag o) => o -> m Drag
toDrag = MIO.liftIO . B.ManagedPtr.unsafeCastTo Drag

-- | Convert t'Drag' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Drag) where
    gvalueGType_ = c_gdk_drag_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Drag)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Drag)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Drag ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDragMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDragMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDragMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDragMethod "dropDone" o = DragDropDoneMethodInfo
    ResolveDragMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDragMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDragMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDragMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDragMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDragMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDragMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDragMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDragMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDragMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDragMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDragMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDragMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDragMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDragMethod "getActions" o = DragGetActionsMethodInfo
    ResolveDragMethod "getContent" o = DragGetContentMethodInfo
    ResolveDragMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDragMethod "getDevice" o = DragGetDeviceMethodInfo
    ResolveDragMethod "getDisplay" o = DragGetDisplayMethodInfo
    ResolveDragMethod "getDragSurface" o = DragGetDragSurfaceMethodInfo
    ResolveDragMethod "getFormats" o = DragGetFormatsMethodInfo
    ResolveDragMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDragMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDragMethod "getSelectedAction" o = DragGetSelectedActionMethodInfo
    ResolveDragMethod "getSurface" o = DragGetSurfaceMethodInfo
    ResolveDragMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDragMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDragMethod "setHotspot" o = DragSetHotspotMethodInfo
    ResolveDragMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDragMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDragMethod t Drag, O.OverloadedMethod info Drag p) => OL.IsLabel t (Drag -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDragMethod t Drag, O.OverloadedMethod info Drag p, R.HasField t Drag p) => R.HasField t Drag p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDragMethod t Drag, O.OverloadedMethodInfo info Drag) => OL.IsLabel t (O.MethodProxy info Drag) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Drag::cancel
-- | Emitted when the drag operation is cancelled.
type DragCancelCallback =
    Gdk.Enums.DragCancelReason
    -- ^ /@reason@/: The reason the drag was cancelled
    -> IO ()

type C_DragCancelCallback =
    Ptr Drag ->                             -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DragCancelCallback`.
foreign import ccall "wrapper"
    mk_DragCancelCallback :: C_DragCancelCallback -> IO (FunPtr C_DragCancelCallback)

wrap_DragCancelCallback :: 
    GObject a => (a -> DragCancelCallback) ->
    C_DragCancelCallback
wrap_DragCancelCallback gi'cb gi'selfPtr reason _ = do
    let reason' = (toEnum . fromIntegral) reason
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  reason'


-- | Connect a signal handler for the [cancel](#signal:cancel) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' drag #cancel callback
-- @
-- 
-- 
onDragCancel :: (IsDrag a, MonadIO m) => a -> ((?self :: a) => DragCancelCallback) -> m SignalHandlerId
onDragCancel obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragCancelCallback wrapped
    wrapped'' <- mk_DragCancelCallback wrapped'
    connectSignalFunPtr obj "cancel" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [cancel](#signal:cancel) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' drag #cancel callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDragCancel :: (IsDrag a, MonadIO m) => a -> ((?self :: a) => DragCancelCallback) -> m SignalHandlerId
afterDragCancel obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragCancelCallback wrapped
    wrapped'' <- mk_DragCancelCallback wrapped'
    connectSignalFunPtr obj "cancel" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DragCancelSignalInfo
instance SignalInfo DragCancelSignalInfo where
    type HaskellCallbackType DragCancelSignalInfo = DragCancelCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DragCancelCallback cb
        cb'' <- mk_DragCancelCallback cb'
        connectSignalFunPtr obj "cancel" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag::cancel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#g:signal:cancel"})

#endif

-- signal Drag::dnd-finished
-- | Emitted when the destination side has finished reading all data.
-- 
-- The drag object can now free all miscellaneous data.
type DragDndFinishedCallback =
    IO ()

type C_DragDndFinishedCallback =
    Ptr Drag ->                             -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DragDndFinishedCallback`.
foreign import ccall "wrapper"
    mk_DragDndFinishedCallback :: C_DragDndFinishedCallback -> IO (FunPtr C_DragDndFinishedCallback)

wrap_DragDndFinishedCallback :: 
    GObject a => (a -> DragDndFinishedCallback) ->
    C_DragDndFinishedCallback
wrap_DragDndFinishedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [dndFinished](#signal:dndFinished) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' drag #dndFinished callback
-- @
-- 
-- 
onDragDndFinished :: (IsDrag a, MonadIO m) => a -> ((?self :: a) => DragDndFinishedCallback) -> m SignalHandlerId
onDragDndFinished obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragDndFinishedCallback wrapped
    wrapped'' <- mk_DragDndFinishedCallback wrapped'
    connectSignalFunPtr obj "dnd-finished" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [dndFinished](#signal:dndFinished) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' drag #dndFinished callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDragDndFinished :: (IsDrag a, MonadIO m) => a -> ((?self :: a) => DragDndFinishedCallback) -> m SignalHandlerId
afterDragDndFinished obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragDndFinishedCallback wrapped
    wrapped'' <- mk_DragDndFinishedCallback wrapped'
    connectSignalFunPtr obj "dnd-finished" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DragDndFinishedSignalInfo
instance SignalInfo DragDndFinishedSignalInfo where
    type HaskellCallbackType DragDndFinishedSignalInfo = DragDndFinishedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DragDndFinishedCallback cb
        cb'' <- mk_DragDndFinishedCallback cb'
        connectSignalFunPtr obj "dnd-finished" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag::dnd-finished"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#g:signal:dndFinished"})

#endif

-- signal Drag::drop-performed
-- | Emitted when the drop operation is performed on an accepting client.
type DragDropPerformedCallback =
    IO ()

type C_DragDropPerformedCallback =
    Ptr Drag ->                             -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DragDropPerformedCallback`.
foreign import ccall "wrapper"
    mk_DragDropPerformedCallback :: C_DragDropPerformedCallback -> IO (FunPtr C_DragDropPerformedCallback)

wrap_DragDropPerformedCallback :: 
    GObject a => (a -> DragDropPerformedCallback) ->
    C_DragDropPerformedCallback
wrap_DragDropPerformedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [dropPerformed](#signal:dropPerformed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' drag #dropPerformed callback
-- @
-- 
-- 
onDragDropPerformed :: (IsDrag a, MonadIO m) => a -> ((?self :: a) => DragDropPerformedCallback) -> m SignalHandlerId
onDragDropPerformed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragDropPerformedCallback wrapped
    wrapped'' <- mk_DragDropPerformedCallback wrapped'
    connectSignalFunPtr obj "drop-performed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [dropPerformed](#signal:dropPerformed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' drag #dropPerformed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDragDropPerformed :: (IsDrag a, MonadIO m) => a -> ((?self :: a) => DragDropPerformedCallback) -> m SignalHandlerId
afterDragDropPerformed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragDropPerformedCallback wrapped
    wrapped'' <- mk_DragDropPerformedCallback wrapped'
    connectSignalFunPtr obj "drop-performed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DragDropPerformedSignalInfo
instance SignalInfo DragDropPerformedSignalInfo where
    type HaskellCallbackType DragDropPerformedSignalInfo = DragDropPerformedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DragDropPerformedCallback cb
        cb'' <- mk_DragDropPerformedCallback cb'
        connectSignalFunPtr obj "drop-performed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag::drop-performed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#g:signal:dropPerformed"})

#endif

-- VVV Prop "actions"
   -- Type: TInterface (Name {namespace = "Gdk", name = "DragAction"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@actions@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drag #actions
-- @
getDragActions :: (MonadIO m, IsDrag o) => o -> m [Gdk.Flags.DragAction]
getDragActions obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "actions"

-- | Set the value of the “@actions@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' drag [ #actions 'Data.GI.Base.Attributes.:=' value ]
-- @
setDragActions :: (MonadIO m, IsDrag o) => o -> [Gdk.Flags.DragAction] -> m ()
setDragActions obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "actions" val

-- | Construct a t'GValueConstruct' with valid value for the “@actions@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDragActions :: (IsDrag o, MIO.MonadIO m) => [Gdk.Flags.DragAction] -> m (GValueConstruct o)
constructDragActions val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "actions" val

#if defined(ENABLE_OVERLOADING)
data DragActionsPropertyInfo
instance AttrInfo DragActionsPropertyInfo where
    type AttrAllowedOps DragActionsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint DragActionsPropertyInfo = IsDrag
    type AttrSetTypeConstraint DragActionsPropertyInfo = (~) [Gdk.Flags.DragAction]
    type AttrTransferTypeConstraint DragActionsPropertyInfo = (~) [Gdk.Flags.DragAction]
    type AttrTransferType DragActionsPropertyInfo = [Gdk.Flags.DragAction]
    type AttrGetType DragActionsPropertyInfo = [Gdk.Flags.DragAction]
    type AttrLabel DragActionsPropertyInfo = "actions"
    type AttrOrigin DragActionsPropertyInfo = Drag
    attrGet = getDragActions
    attrSet = setDragActions
    attrPut = setDragActions
    attrTransfer _ v = do
        return v
    attrConstruct = constructDragActions
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.actions"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#g:attr:actions"
        })
#endif

-- VVV Prop "content"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ContentProvider"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@content@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drag #content
-- @
getDragContent :: (MonadIO m, IsDrag o) => o -> m Gdk.ContentProvider.ContentProvider
getDragContent obj = MIO.liftIO $ checkUnexpectedNothing "getDragContent" $ B.Properties.getObjectPropertyObject obj "content" Gdk.ContentProvider.ContentProvider

-- | Construct a t'GValueConstruct' with valid value for the “@content@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDragContent :: (IsDrag o, MIO.MonadIO m, Gdk.ContentProvider.IsContentProvider a) => a -> m (GValueConstruct o)
constructDragContent val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "content" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DragContentPropertyInfo
instance AttrInfo DragContentPropertyInfo where
    type AttrAllowedOps DragContentPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DragContentPropertyInfo = IsDrag
    type AttrSetTypeConstraint DragContentPropertyInfo = Gdk.ContentProvider.IsContentProvider
    type AttrTransferTypeConstraint DragContentPropertyInfo = Gdk.ContentProvider.IsContentProvider
    type AttrTransferType DragContentPropertyInfo = Gdk.ContentProvider.ContentProvider
    type AttrGetType DragContentPropertyInfo = Gdk.ContentProvider.ContentProvider
    type AttrLabel DragContentPropertyInfo = "content"
    type AttrOrigin DragContentPropertyInfo = Drag
    attrGet = getDragContent
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.ContentProvider.ContentProvider v
    attrConstruct = constructDragContent
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.content"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#g:attr:content"
        })
#endif

-- VVV Prop "device"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Device"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@device@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drag #device
-- @
getDragDevice :: (MonadIO m, IsDrag o) => o -> m Gdk.Device.Device
getDragDevice obj = MIO.liftIO $ checkUnexpectedNothing "getDragDevice" $ B.Properties.getObjectPropertyObject obj "device" Gdk.Device.Device

-- | Construct a t'GValueConstruct' with valid value for the “@device@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDragDevice :: (IsDrag o, MIO.MonadIO m, Gdk.Device.IsDevice a) => a -> m (GValueConstruct o)
constructDragDevice val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "device" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DragDevicePropertyInfo
instance AttrInfo DragDevicePropertyInfo where
    type AttrAllowedOps DragDevicePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DragDevicePropertyInfo = IsDrag
    type AttrSetTypeConstraint DragDevicePropertyInfo = Gdk.Device.IsDevice
    type AttrTransferTypeConstraint DragDevicePropertyInfo = Gdk.Device.IsDevice
    type AttrTransferType DragDevicePropertyInfo = Gdk.Device.Device
    type AttrGetType DragDevicePropertyInfo = Gdk.Device.Device
    type AttrLabel DragDevicePropertyInfo = "device"
    type AttrOrigin DragDevicePropertyInfo = Drag
    attrGet = getDragDevice
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Device.Device v
    attrConstruct = constructDragDevice
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.device"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#g:attr:device"
        })
#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drag #display
-- @
getDragDisplay :: (MonadIO m, IsDrag o) => o -> m Gdk.Display.Display
getDragDisplay obj = MIO.liftIO $ checkUnexpectedNothing "getDragDisplay" $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

#if defined(ENABLE_OVERLOADING)
data DragDisplayPropertyInfo
instance AttrInfo DragDisplayPropertyInfo where
    type AttrAllowedOps DragDisplayPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DragDisplayPropertyInfo = IsDrag
    type AttrSetTypeConstraint DragDisplayPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DragDisplayPropertyInfo = (~) ()
    type AttrTransferType DragDisplayPropertyInfo = ()
    type AttrGetType DragDisplayPropertyInfo = Gdk.Display.Display
    type AttrLabel DragDisplayPropertyInfo = "display"
    type AttrOrigin DragDisplayPropertyInfo = Drag
    attrGet = getDragDisplay
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#g:attr:display"
        })
#endif

-- VVV Prop "formats"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ContentFormats"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@formats@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drag #formats
-- @
getDragFormats :: (MonadIO m, IsDrag o) => o -> m Gdk.ContentFormats.ContentFormats
getDragFormats obj = MIO.liftIO $ checkUnexpectedNothing "getDragFormats" $ B.Properties.getObjectPropertyBoxed obj "formats" Gdk.ContentFormats.ContentFormats

-- | Construct a t'GValueConstruct' with valid value for the “@formats@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDragFormats :: (IsDrag o, MIO.MonadIO m) => Gdk.ContentFormats.ContentFormats -> m (GValueConstruct o)
constructDragFormats val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "formats" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DragFormatsPropertyInfo
instance AttrInfo DragFormatsPropertyInfo where
    type AttrAllowedOps DragFormatsPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DragFormatsPropertyInfo = IsDrag
    type AttrSetTypeConstraint DragFormatsPropertyInfo = (~) Gdk.ContentFormats.ContentFormats
    type AttrTransferTypeConstraint DragFormatsPropertyInfo = (~) Gdk.ContentFormats.ContentFormats
    type AttrTransferType DragFormatsPropertyInfo = Gdk.ContentFormats.ContentFormats
    type AttrGetType DragFormatsPropertyInfo = Gdk.ContentFormats.ContentFormats
    type AttrLabel DragFormatsPropertyInfo = "formats"
    type AttrOrigin DragFormatsPropertyInfo = Drag
    attrGet = getDragFormats
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDragFormats
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.formats"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#g:attr:formats"
        })
#endif

-- VVV Prop "selected-action"
   -- Type: TInterface (Name {namespace = "Gdk", name = "DragAction"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@selected-action@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drag #selectedAction
-- @
getDragSelectedAction :: (MonadIO m, IsDrag o) => o -> m [Gdk.Flags.DragAction]
getDragSelectedAction obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "selected-action"

-- | Set the value of the “@selected-action@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' drag [ #selectedAction 'Data.GI.Base.Attributes.:=' value ]
-- @
setDragSelectedAction :: (MonadIO m, IsDrag o) => o -> [Gdk.Flags.DragAction] -> m ()
setDragSelectedAction obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "selected-action" val

-- | Construct a t'GValueConstruct' with valid value for the “@selected-action@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDragSelectedAction :: (IsDrag o, MIO.MonadIO m) => [Gdk.Flags.DragAction] -> m (GValueConstruct o)
constructDragSelectedAction val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "selected-action" val

#if defined(ENABLE_OVERLOADING)
data DragSelectedActionPropertyInfo
instance AttrInfo DragSelectedActionPropertyInfo where
    type AttrAllowedOps DragSelectedActionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint DragSelectedActionPropertyInfo = IsDrag
    type AttrSetTypeConstraint DragSelectedActionPropertyInfo = (~) [Gdk.Flags.DragAction]
    type AttrTransferTypeConstraint DragSelectedActionPropertyInfo = (~) [Gdk.Flags.DragAction]
    type AttrTransferType DragSelectedActionPropertyInfo = [Gdk.Flags.DragAction]
    type AttrGetType DragSelectedActionPropertyInfo = [Gdk.Flags.DragAction]
    type AttrLabel DragSelectedActionPropertyInfo = "selected-action"
    type AttrOrigin DragSelectedActionPropertyInfo = Drag
    attrGet = getDragSelectedAction
    attrSet = setDragSelectedAction
    attrPut = setDragSelectedAction
    attrTransfer _ v = do
        return v
    attrConstruct = constructDragSelectedAction
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.selectedAction"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#g:attr:selectedAction"
        })
#endif

-- VVV Prop "surface"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Surface"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@surface@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drag #surface
-- @
getDragSurface :: (MonadIO m, IsDrag o) => o -> m Gdk.Surface.Surface
getDragSurface obj = MIO.liftIO $ checkUnexpectedNothing "getDragSurface" $ B.Properties.getObjectPropertyObject obj "surface" Gdk.Surface.Surface

-- | Construct a t'GValueConstruct' with valid value for the “@surface@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDragSurface :: (IsDrag o, MIO.MonadIO m, Gdk.Surface.IsSurface a) => a -> m (GValueConstruct o)
constructDragSurface val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "surface" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DragSurfacePropertyInfo
instance AttrInfo DragSurfacePropertyInfo where
    type AttrAllowedOps DragSurfacePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DragSurfacePropertyInfo = IsDrag
    type AttrSetTypeConstraint DragSurfacePropertyInfo = Gdk.Surface.IsSurface
    type AttrTransferTypeConstraint DragSurfacePropertyInfo = Gdk.Surface.IsSurface
    type AttrTransferType DragSurfacePropertyInfo = Gdk.Surface.Surface
    type AttrGetType DragSurfacePropertyInfo = Gdk.Surface.Surface
    type AttrLabel DragSurfacePropertyInfo = "surface"
    type AttrOrigin DragSurfacePropertyInfo = Drag
    attrGet = getDragSurface
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Surface.Surface v
    attrConstruct = constructDragSurface
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.surface"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#g:attr:surface"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Drag
type instance O.AttributeList Drag = DragAttributeList
type DragAttributeList = ('[ '("actions", DragActionsPropertyInfo), '("content", DragContentPropertyInfo), '("device", DragDevicePropertyInfo), '("display", DragDisplayPropertyInfo), '("formats", DragFormatsPropertyInfo), '("selectedAction", DragSelectedActionPropertyInfo), '("surface", DragSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
dragActions :: AttrLabelProxy "actions"
dragActions = AttrLabelProxy

dragContent :: AttrLabelProxy "content"
dragContent = AttrLabelProxy

dragDevice :: AttrLabelProxy "device"
dragDevice = AttrLabelProxy

dragDisplay :: AttrLabelProxy "display"
dragDisplay = AttrLabelProxy

dragFormats :: AttrLabelProxy "formats"
dragFormats = AttrLabelProxy

dragSelectedAction :: AttrLabelProxy "selectedAction"
dragSelectedAction = AttrLabelProxy

dragSurface :: AttrLabelProxy "surface"
dragSurface = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Drag = DragSignalList
type DragSignalList = ('[ '("cancel", DragCancelSignalInfo), '("dndFinished", DragDndFinishedSignalInfo), '("dropPerformed", DragDropPerformedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Drag::drop_done
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "success"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the drag was ultimatively successful"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_drop_done" gdk_drag_drop_done :: 
    Ptr Drag ->                             -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    CInt ->                                 -- success : TBasicType TBoolean
    IO ()

-- | Informs GDK that the drop ended.
-- 
-- Passing 'P.False' for /@success@/ may trigger a drag cancellation
-- animation.
-- 
-- This function is called by the drag source, and should be the
-- last call before dropping the reference to the /@drag@/.
-- 
-- The @GdkDrag@ will only take the first 'GI.Gdk.Objects.Drag.dragDropDone'
-- call as effective, if this function is called multiple times,
-- all subsequent calls will be ignored.
dragDropDone ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> Bool
    -- ^ /@success@/: whether the drag was ultimatively successful
    -> m ()
dragDropDone drag success = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    let success' = (P.fromIntegral . P.fromEnum) success
    gdk_drag_drop_done drag' success'
    touchManagedPtr drag
    return ()

#if defined(ENABLE_OVERLOADING)
data DragDropDoneMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsDrag a) => O.OverloadedMethod DragDropDoneMethodInfo a signature where
    overloadedMethod = dragDropDone

instance O.OverloadedMethodInfo DragDropDoneMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.dragDropDone",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#v:dragDropDone"
        })


#endif

-- method Drag::get_actions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DragAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_get_actions" gdk_drag_get_actions :: 
    Ptr Drag ->                             -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    IO CUInt

-- | Determines the bitmask of possible actions proposed by the source.
dragGetActions ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> m [Gdk.Flags.DragAction]
    -- ^ __Returns:__ the @GdkDragAction@ flags
dragGetActions drag = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    result <- gdk_drag_get_actions drag'
    let result' = wordToGFlags result
    touchManagedPtr drag
    return result'

#if defined(ENABLE_OVERLOADING)
data DragGetActionsMethodInfo
instance (signature ~ (m [Gdk.Flags.DragAction]), MonadIO m, IsDrag a) => O.OverloadedMethod DragGetActionsMethodInfo a signature where
    overloadedMethod = dragGetActions

instance O.OverloadedMethodInfo DragGetActionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.dragGetActions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#v:dragGetActions"
        })


#endif

-- method Drag::get_content
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentProvider" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_get_content" gdk_drag_get_content :: 
    Ptr Drag ->                             -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    IO (Ptr Gdk.ContentProvider.ContentProvider)

-- | Returns the @GdkContentProvider@ associated to the @GdkDrag@ object.
dragGetContent ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> m Gdk.ContentProvider.ContentProvider
    -- ^ __Returns:__ The @GdkContentProvider@ associated to /@drag@/.
dragGetContent drag = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    result <- gdk_drag_get_content drag'
    checkUnexpectedReturnNULL "dragGetContent" result
    result' <- (newObject Gdk.ContentProvider.ContentProvider) result
    touchManagedPtr drag
    return result'

#if defined(ENABLE_OVERLOADING)
data DragGetContentMethodInfo
instance (signature ~ (m Gdk.ContentProvider.ContentProvider), MonadIO m, IsDrag a) => O.OverloadedMethod DragGetContentMethodInfo a signature where
    overloadedMethod = dragGetContent

instance O.OverloadedMethodInfo DragGetContentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.dragGetContent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#v:dragGetContent"
        })


#endif

-- method Drag::get_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Device" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_get_device" gdk_drag_get_device :: 
    Ptr Drag ->                             -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    IO (Ptr Gdk.Device.Device)

-- | Returns the @GdkDevice@ associated to the @GdkDrag@ object.
dragGetDevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> m Gdk.Device.Device
    -- ^ __Returns:__ The @GdkDevice@ associated to /@drag@/.
dragGetDevice drag = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    result <- gdk_drag_get_device drag'
    checkUnexpectedReturnNULL "dragGetDevice" result
    result' <- (newObject Gdk.Device.Device) result
    touchManagedPtr drag
    return result'

#if defined(ENABLE_OVERLOADING)
data DragGetDeviceMethodInfo
instance (signature ~ (m Gdk.Device.Device), MonadIO m, IsDrag a) => O.OverloadedMethod DragGetDeviceMethodInfo a signature where
    overloadedMethod = dragGetDevice

instance O.OverloadedMethodInfo DragGetDeviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.dragGetDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#v:dragGetDevice"
        })


#endif

-- method Drag::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_get_display" gdk_drag_get_display :: 
    Ptr Drag ->                             -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    IO (Ptr Gdk.Display.Display)

-- | Gets the @GdkDisplay@ that the drag object was created for.
dragGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> m Gdk.Display.Display
    -- ^ __Returns:__ a @GdkDisplay@
dragGetDisplay drag = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    result <- gdk_drag_get_display drag'
    checkUnexpectedReturnNULL "dragGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr drag
    return result'

#if defined(ENABLE_OVERLOADING)
data DragGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsDrag a) => O.OverloadedMethod DragGetDisplayMethodInfo a signature where
    overloadedMethod = dragGetDisplay

instance O.OverloadedMethodInfo DragGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.dragGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#v:dragGetDisplay"
        })


#endif

-- method Drag::get_drag_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_get_drag_surface" gdk_drag_get_drag_surface :: 
    Ptr Drag ->                             -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    IO (Ptr Gdk.Surface.Surface)

-- | Returns the surface on which the drag icon should be rendered
-- during the drag operation.
-- 
-- Note that the surface may not be available until the drag operation
-- has begun. GDK will move the surface in accordance with the ongoing
-- drag operation. The surface is owned by /@drag@/ and will be destroyed
-- when the drag operation is over.
dragGetDragSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> m (Maybe Gdk.Surface.Surface)
    -- ^ __Returns:__ the drag surface
dragGetDragSurface drag = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    result <- gdk_drag_get_drag_surface drag'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Surface.Surface) result'
        return result''
    touchManagedPtr drag
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DragGetDragSurfaceMethodInfo
instance (signature ~ (m (Maybe Gdk.Surface.Surface)), MonadIO m, IsDrag a) => O.OverloadedMethod DragGetDragSurfaceMethodInfo a signature where
    overloadedMethod = dragGetDragSurface

instance O.OverloadedMethodInfo DragGetDragSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.dragGetDragSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#v:dragGetDragSurface"
        })


#endif

-- method Drag::get_formats
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentFormats" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_get_formats" gdk_drag_get_formats :: 
    Ptr Drag ->                             -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    IO (Ptr Gdk.ContentFormats.ContentFormats)

-- | Retrieves the formats supported by this @GdkDrag@ object.
dragGetFormats ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> m Gdk.ContentFormats.ContentFormats
    -- ^ __Returns:__ a @GdkContentFormats@
dragGetFormats drag = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    result <- gdk_drag_get_formats drag'
    checkUnexpectedReturnNULL "dragGetFormats" result
    result' <- (newBoxed Gdk.ContentFormats.ContentFormats) result
    touchManagedPtr drag
    return result'

#if defined(ENABLE_OVERLOADING)
data DragGetFormatsMethodInfo
instance (signature ~ (m Gdk.ContentFormats.ContentFormats), MonadIO m, IsDrag a) => O.OverloadedMethod DragGetFormatsMethodInfo a signature where
    overloadedMethod = dragGetFormats

instance O.OverloadedMethodInfo DragGetFormatsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.dragGetFormats",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#v:dragGetFormats"
        })


#endif

-- method Drag::get_selected_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DragAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_get_selected_action" gdk_drag_get_selected_action :: 
    Ptr Drag ->                             -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    IO CUInt

-- | Determines the action chosen by the drag destination.
dragGetSelectedAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> m [Gdk.Flags.DragAction]
    -- ^ __Returns:__ a @GdkDragAction@ value
dragGetSelectedAction drag = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    result <- gdk_drag_get_selected_action drag'
    let result' = wordToGFlags result
    touchManagedPtr drag
    return result'

#if defined(ENABLE_OVERLOADING)
data DragGetSelectedActionMethodInfo
instance (signature ~ (m [Gdk.Flags.DragAction]), MonadIO m, IsDrag a) => O.OverloadedMethod DragGetSelectedActionMethodInfo a signature where
    overloadedMethod = dragGetSelectedAction

instance O.OverloadedMethodInfo DragGetSelectedActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.dragGetSelectedAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#v:dragGetSelectedAction"
        })


#endif

-- method Drag::get_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_get_surface" gdk_drag_get_surface :: 
    Ptr Drag ->                             -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    IO (Ptr Gdk.Surface.Surface)

-- | Returns the @GdkSurface@ where the drag originates.
dragGetSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> m Gdk.Surface.Surface
    -- ^ __Returns:__ The @GdkSurface@ where the drag originates
dragGetSurface drag = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    result <- gdk_drag_get_surface drag'
    checkUnexpectedReturnNULL "dragGetSurface" result
    result' <- (newObject Gdk.Surface.Surface) result
    touchManagedPtr drag
    return result'

#if defined(ENABLE_OVERLOADING)
data DragGetSurfaceMethodInfo
instance (signature ~ (m Gdk.Surface.Surface), MonadIO m, IsDrag a) => O.OverloadedMethod DragGetSurfaceMethodInfo a signature where
    overloadedMethod = dragGetSurface

instance O.OverloadedMethodInfo DragGetSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.dragGetSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#v:dragGetSurface"
        })


#endif

-- method Drag::set_hotspot
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hot_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "x coordinate of the drag surface hotspot"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hot_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "y coordinate of the drag surface hotspot"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_set_hotspot" gdk_drag_set_hotspot :: 
    Ptr Drag ->                             -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    Int32 ->                                -- hot_x : TBasicType TInt
    Int32 ->                                -- hot_y : TBasicType TInt
    IO ()

-- | Sets the position of the drag surface that will be kept
-- under the cursor hotspot.
-- 
-- Initially, the hotspot is at the top left corner of the drag surface.
dragSetHotspot ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> Int32
    -- ^ /@hotX@/: x coordinate of the drag surface hotspot
    -> Int32
    -- ^ /@hotY@/: y coordinate of the drag surface hotspot
    -> m ()
dragSetHotspot drag hotX hotY = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    gdk_drag_set_hotspot drag' hotX hotY
    touchManagedPtr drag
    return ()

#if defined(ENABLE_OVERLOADING)
data DragSetHotspotMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m, IsDrag a) => O.OverloadedMethod DragSetHotspotMethodInfo a signature where
    overloadedMethod = dragSetHotspot

instance O.OverloadedMethodInfo DragSetHotspotMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drag.dragSetHotspot",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drag.html#v:dragSetHotspot"
        })


#endif

-- method Drag::begin
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the source surface for this drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the device that controls this drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "content"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the offered content"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "actions"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the actions supported by this drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dx"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the x offset to @device's position where the drag nominally started"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dy"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the y offset to @device's position where the drag nominally started"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Drag" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_begin" gdk_drag_begin :: 
    Ptr Gdk.Surface.Surface ->              -- surface : TInterface (Name {namespace = "Gdk", name = "Surface"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr Gdk.ContentProvider.ContentProvider -> -- content : TInterface (Name {namespace = "Gdk", name = "ContentProvider"})
    CUInt ->                                -- actions : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    CDouble ->                              -- dx : TBasicType TDouble
    CDouble ->                              -- dy : TBasicType TDouble
    IO (Ptr Drag)

-- | Starts a drag and creates a new drag context for it.
-- 
-- This function is called by the drag source. After this call, you
-- probably want to set up the drag icon using the surface returned
-- by 'GI.Gdk.Objects.Drag.dragGetDragSurface'.
-- 
-- This function returns a reference to the t'GI.Gdk.Objects.Drag.Drag' object,
-- but GTK keeps its own reference as well, as long as the DND operation
-- is going on.
-- 
-- Note: if /@actions@/ include 'GI.Gdk.Flags.DragActionMove', you need to listen for
-- the [Drag::dndFinished]("GI.Gdk.Objects.Drag#g:signal:dndFinished") signal and delete the data at
-- the source if 'GI.Gdk.Objects.Drag.dragGetSelectedAction' returns
-- 'GI.Gdk.Flags.DragActionMove'.
dragBegin ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Surface.IsSurface a, Gdk.Device.IsDevice b, Gdk.ContentProvider.IsContentProvider c) =>
    a
    -- ^ /@surface@/: the source surface for this drag
    -> b
    -- ^ /@device@/: the device that controls this drag
    -> c
    -- ^ /@content@/: the offered content
    -> [Gdk.Flags.DragAction]
    -- ^ /@actions@/: the actions supported by this drag
    -> Double
    -- ^ /@dx@/: the x offset to /@device@/\'s position where the drag nominally started
    -> Double
    -- ^ /@dy@/: the y offset to /@device@/\'s position where the drag nominally started
    -> m (Maybe Drag)
    -- ^ __Returns:__ a newly created @GdkDrag@
dragBegin surface device content actions dx dy = liftIO $ do
    surface' <- unsafeManagedPtrCastPtr surface
    device' <- unsafeManagedPtrCastPtr device
    content' <- unsafeManagedPtrCastPtr content
    let actions' = gflagsToWord actions
    let dx' = realToFrac dx
    let dy' = realToFrac dy
    result <- gdk_drag_begin surface' device' content' actions' dx' dy'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Drag) result'
        return result''
    touchManagedPtr surface
    touchManagedPtr device
    touchManagedPtr content
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif


