/* SourceList.c generated by valac 0.56.17, the Vala compiler
 * generated from SourceList.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2012-2014 Victor Martinez <victoreduardm@gmail.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */
/**
     * = WORKING INTERNALS =
     *
     * In order to offer a transparent Item-based API, and avoid the need of providing methods
     * to deal with items directly on the SourceList widget, it was decided to follow a monitor-like
     * implementation, where the source list permanently monitors its root item and any other
     * child item added to it. The task of monitoring the properties of the items has been
     * divided among different objects, as shown below:
     *
     * Monitored by: Object::method that receives the signals indicating the property change.
     * Applied by: Object::method that actually updates the tree to reflect the property changes
     *             (directly or indirectly, as in the case of the tree data model).
     *
     * ---------------------------------------------------------------------------------------------
     *   PROPERTY        |  MONITORED BY                     |  APPLIED BY
     * ---------------------------------------------------------------------------------------------
     * + Item            |                                   |
     *   - parent        | Not monitored                     | N/A
     *   - name          | DataModel::on_item_prop_changed   | Tree::name_cell_data_func
     *   - editable      | DataModel::on_item_prop_changed   | Queried when needed (See Tree::start_editing_item)
     *   - visible       | DataModel::on_item_prop_changed   | DataModel::filter_visible_func
     *   - icon          | DataModel::on_item_prop_changed   | Tree::icon_cell_data_func
     *   - activatable   | Same as @icon                     | Same as @icon
     * + ExpandableItem  |                                   |
     *   - collapsible   | DataModel::on_item_prop_changed   | Tree::update_expansion
     *                   |                                   | Tree::expander_cell_data_func
     *   - expanded      | Same as @collapsible              | Same as @collapsible
     * ---------------------------------------------------------------------------------------------
     * * Only automatic properties are monitored. ExpandableItem's additions/removals are handled by
     *   DataModel::add_item() and DataModel::remove_item()
     *
     * Other features:
     * - Sorting: this happens on the tree-model level (DataModel).
     */

#include "granite.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <cairo-gobject.h>

#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE "item-parent-needs-update"
#define GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_ICON_SIZE GTK_ICON_SIZE_MENU
#define GRANITE_WIDGETS_SOURCE_LIST_TREE_DEFAULT_STYLESHEET "\n" \
"            .sidebar.badge {\n" \
"                border-radius: 10px;\n" \
"                border-width: 0;\n" \
"                padding: 1px 2px 1px 2px;\n" \
"                font-weight: bold;\n" \
"            }\n" \
"        "
#define GRANITE_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEVEL_INDENTATION "level-indentation"
#define GRANITE_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEFT_PADDING "left-padding"
#define GRANITE_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_EXPANDER_SPACING "expander-spacing"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_WIDGETS_SOURCE_LIST_SORTABLE_USER_MOVED_ITEM_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_SORTABLE_NUM_SIGNALS
};
static guint granite_widgets_source_list_sortable_signals[GRANITE_WIDGETS_SOURCE_LIST_SORTABLE_NUM_SIGNALS] = {0};

#define GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE (granite_widgets_source_list_tree_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_TREE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE, GraniteWidgetsSourceListTree))
#define GRANITE_WIDGETS_SOURCE_LIST_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE, GraniteWidgetsSourceListTreeClass))
#define GRANITE_WIDGETS_SOURCE_LIST_IS_TREE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE))
#define GRANITE_WIDGETS_SOURCE_LIST_IS_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE))
#define GRANITE_WIDGETS_SOURCE_LIST_TREE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE, GraniteWidgetsSourceListTreeClass))

typedef struct _GraniteWidgetsSourceListTree GraniteWidgetsSourceListTree;
typedef struct _GraniteWidgetsSourceListTreeClass GraniteWidgetsSourceListTreeClass;

#define GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL (granite_widgets_source_list_data_model_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, GraniteWidgetsSourceListDataModel))
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, GraniteWidgetsSourceListDataModelClass))
#define GRANITE_WIDGETS_SOURCE_LIST_IS_DATA_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL))
#define GRANITE_WIDGETS_SOURCE_LIST_IS_DATA_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL))
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, GraniteWidgetsSourceListDataModelClass))

typedef struct _GraniteWidgetsSourceListDataModel GraniteWidgetsSourceListDataModel;
typedef struct _GraniteWidgetsSourceListDataModelClass GraniteWidgetsSourceListDataModelClass;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ROOT_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_EDITING_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_properties[GRANITE_WIDGETS_SOURCE_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_TOOLTIP_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_MARKUP_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_TOOLTIP_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_EDITED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTION_ACTIVATED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_NUM_SIGNALS
};
static guint granite_widgets_source_list_item_signals[GRANITE_WIDGETS_SOURCE_LIST_ITEM_NUM_SIGNALS] = {0};
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILDREN_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_NUM_PROPERTIES];
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_ADDED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_REMOVED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_TOGGLED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_NUM_SIGNALS
};
static guint granite_widgets_source_list_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_NUM_SIGNALS] = {0};
typedef struct _GraniteWidgetsSourceListDataModelPrivate GraniteWidgetsSourceListDataModelPrivate;

#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER (granite_widgets_source_list_data_model_node_wrapper_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_NODE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, GraniteWidgetsSourceListDataModelNodeWrapper))
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_NODE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, GraniteWidgetsSourceListDataModelNodeWrapperClass))
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_IS_NODE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER))
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_IS_NODE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER))
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_NODE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, GraniteWidgetsSourceListDataModelNodeWrapperClass))

typedef struct _GraniteWidgetsSourceListDataModelNodeWrapper GraniteWidgetsSourceListDataModelNodeWrapper;
typedef struct _GraniteWidgetsSourceListDataModelNodeWrapperClass GraniteWidgetsSourceListDataModelNodeWrapperClass;

#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR (granite_widgets_source_list_data_model_item_monitor_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, GraniteWidgetsSourceListDataModelItemMonitor))
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, GraniteWidgetsSourceListDataModelItemMonitorClass))
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_IS_ITEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR))
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_IS_ITEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR))
#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, GraniteWidgetsSourceListDataModelItemMonitorClass))

typedef struct _GraniteWidgetsSourceListDataModelItemMonitor GraniteWidgetsSourceListDataModelItemMonitor;
typedef struct _GraniteWidgetsSourceListDataModelItemMonitorClass GraniteWidgetsSourceListDataModelItemMonitorClass;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_data_model_properties[GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_NUM_PROPERTIES];
typedef enum  {
	GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM,
	GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_N_COLUMNS
} GraniteWidgetsSourceListDataModelColumn;

#define GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_COLUMN (granite_widgets_source_list_data_model_column_get_type ())
#define _granite_widgets_source_list_data_model_node_wrapper_unref0(var) ((var == NULL) ? NULL : (var = (granite_widgets_source_list_data_model_node_wrapper_unref (var), NULL)))
#define _granite_widgets_source_list_data_model_item_monitor_unref0(var) ((var == NULL) ? NULL : (var = (granite_widgets_source_list_data_model_item_monitor_unref (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _GraniteWidgetsSourceListDataModelNodeWrapperPrivate GraniteWidgetsSourceListDataModelNodeWrapperPrivate;
#define __vala_GtkTreeRowReference_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeRowReference_free (var), NULL)))
typedef struct _GraniteWidgetsSourceListDataModelParamSpecNodeWrapper GraniteWidgetsSourceListDataModelParamSpecNodeWrapper;
typedef struct _GraniteWidgetsSourceListDataModelItemMonitorPrivate GraniteWidgetsSourceListDataModelItemMonitorPrivate;
typedef struct _GraniteWidgetsSourceListDataModelParamSpecItemMonitor GraniteWidgetsSourceListDataModelParamSpecItemMonitor;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_CHANGED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_NUM_SIGNALS
};
static guint granite_widgets_source_list_data_model_item_monitor_signals[GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_NUM_SIGNALS] = {0};
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_UPDATED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_NUM_SIGNALS
};
static guint granite_widgets_source_list_data_model_signals[GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_NUM_SIGNALS] = {0};

#define GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON (granite_widgets_source_list_cell_renderer_icon_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON, GraniteWidgetsSourceListCellRendererIcon))
#define GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON, GraniteWidgetsSourceListCellRendererIconClass))
#define GRANITE_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON))
#define GRANITE_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON))
#define GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON, GraniteWidgetsSourceListCellRendererIconClass))

typedef struct _GraniteWidgetsSourceListCellRendererIcon GraniteWidgetsSourceListCellRendererIcon;
typedef struct _GraniteWidgetsSourceListCellRendererIconClass GraniteWidgetsSourceListCellRendererIconClass;
typedef struct _GraniteWidgetsSourceListCellRendererIconPrivate GraniteWidgetsSourceListCellRendererIconPrivate;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_cell_renderer_icon_properties[GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_NUM_PROPERTIES];
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_ACTIVATED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_NUM_SIGNALS
};
static guint granite_widgets_source_list_cell_renderer_icon_signals[GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_NUM_SIGNALS] = {0};

#define GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER (granite_widgets_source_list_cell_renderer_spacer_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListCellRendererSpacer))
#define GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListCellRendererSpacerClass))
#define GRANITE_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_SPACER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER))
#define GRANITE_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_SPACER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER))
#define GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListCellRendererSpacerClass))

typedef struct _GraniteWidgetsSourceListCellRendererSpacer GraniteWidgetsSourceListCellRendererSpacer;
typedef struct _GraniteWidgetsSourceListCellRendererSpacerClass GraniteWidgetsSourceListCellRendererSpacerClass;
typedef struct _GraniteWidgetsSourceListCellRendererSpacerPrivate GraniteWidgetsSourceListCellRendererSpacerPrivate;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_cell_renderer_spacer_properties[GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_NUM_PROPERTIES];
typedef struct _GraniteWidgetsSourceListTreePrivate GraniteWidgetsSourceListTreePrivate;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_TREE_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_TREE_EDITING_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_TREE_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_TREE_NUM_PROPERTIES];
typedef enum  {
	GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM,
	GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_N_COLS
} GraniteWidgetsSourceListTreeColumn;

#define GRANITE_WIDGETS_SOURCE_LIST_TREE_TYPE_COLUMN (granite_widgets_source_list_tree_column_get_type ())
#define _gtk_target_list_unref0(var) ((var == NULL) ? NULL : (var = (gtk_target_list_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_TREE_ITEM_SELECTED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_TREE_NUM_SIGNALS
};
static guint granite_widgets_source_list_tree_signals[GRANITE_WIDGETS_SOURCE_LIST_TREE_NUM_SIGNALS] = {0};
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_ITEM_SELECTED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_NUM_SIGNALS
};
static guint granite_widgets_source_list_signals[GRANITE_WIDGETS_SOURCE_LIST_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GraniteWidgetsSourceListPrivate {
	GraniteWidgetsSourceListTree* tree;
	GraniteWidgetsSourceListDataModel* data_model;
};

struct _GraniteWidgetsSourceListItemPrivate {
	GraniteWidgetsSourceListExpandableItem* _parent;
	gchar* _name;
	gchar* _tooltip;
	gchar* _markup;
	gchar* _badge;
	gboolean _editable;
	gboolean _visible;
	gboolean _selectable;
	GIcon* _icon;
	GIcon* _activatable;
	gchar* _activatable_tooltip;
};

struct _GraniteWidgetsSourceListExpandableItemPrivate {
	gboolean _collapsible;
	gboolean _expanded;
	GeeCollection* children_list;
};

struct _GraniteWidgetsSourceListDataModel {
	GtkTreeModelFilter parent_instance;
	GraniteWidgetsSourceListDataModelPrivate * priv;
};

struct _GraniteWidgetsSourceListDataModelClass {
	GtkTreeModelFilterClass parent_class;
};

struct _GraniteWidgetsSourceListDataModelPrivate {
	GraniteWidgetsSourceListExpandableItem* _root;
	GeeHashMap* items;
	GeeHashMap* monitors;
	GtkTreeStore* child_tree;
	GraniteWidgetsSourceListVisibleFunc filter_func;
	gpointer filter_func_target;
};

struct _Block12Data {
	int _ref_count_;
	GraniteWidgetsSourceListDataModel* self;
	GraniteWidgetsSourceListExpandableItem* parent;
};

struct _GraniteWidgetsSourceListDataModelNodeWrapper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GraniteWidgetsSourceListDataModelNodeWrapperPrivate * priv;
};

struct _GraniteWidgetsSourceListDataModelNodeWrapperClass {
	GTypeClass parent_class;
	void (*finalize) (GraniteWidgetsSourceListDataModelNodeWrapper *self);
};

struct _GraniteWidgetsSourceListDataModelNodeWrapperPrivate {
	GtkTreeRowReference* row_reference;
};

struct _GraniteWidgetsSourceListDataModelParamSpecNodeWrapper {
	GParamSpec parent_instance;
};

struct _GraniteWidgetsSourceListDataModelItemMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GraniteWidgetsSourceListDataModelItemMonitorPrivate * priv;
};

struct _GraniteWidgetsSourceListDataModelItemMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (GraniteWidgetsSourceListDataModelItemMonitor *self);
};

struct _GraniteWidgetsSourceListDataModelItemMonitorPrivate {
	GraniteWidgetsSourceListItem* item;
};

struct _GraniteWidgetsSourceListDataModelParamSpecItemMonitor {
	GParamSpec parent_instance;
};

struct _GraniteWidgetsSourceListCellRendererIcon {
	GtkCellRendererPixbuf parent_instance;
	GraniteWidgetsSourceListCellRendererIconPrivate * priv;
};

struct _GraniteWidgetsSourceListCellRendererIconClass {
	GtkCellRendererPixbufClass parent_class;
};

struct _GraniteWidgetsSourceListCellRendererSpacer {
	GtkCellRenderer parent_instance;
	GraniteWidgetsSourceListCellRendererSpacerPrivate * priv;
};

struct _GraniteWidgetsSourceListCellRendererSpacerClass {
	GtkCellRendererClass parent_class;
};

struct _GraniteWidgetsSourceListCellRendererSpacerPrivate {
	gint _level;
};

struct _GraniteWidgetsSourceListTree {
	GtkTreeView parent_instance;
	GraniteWidgetsSourceListTreePrivate * priv;
};

struct _GraniteWidgetsSourceListTreeClass {
	GtkTreeViewClass parent_class;
};

struct _GraniteWidgetsSourceListTreePrivate {
	GraniteWidgetsSourceListDataModel* _data_model;
	GraniteWidgetsSourceListItem* selected;
	GraniteWidgetsSourceListItem* edited;
	GtkEntry* editable_entry;
	GtkCellRendererText* text_cell;
	GraniteWidgetsSourceListCellRendererIcon* icon_cell;
	GraniteWidgetsSourceListCellRendererIcon* activatable_cell;
	GraniteWidgetsCellRendererBadge* badge_cell;
	GraniteWidgetsCellRendererExpander* primary_expander_cell;
	GraniteWidgetsCellRendererExpander* secondary_expander_cell;
	GeeHashMap* spacer_cells;
	gboolean unselectable_item_clicked;
};

static gint GraniteWidgetsSourceList_private_offset;
static gpointer granite_widgets_source_list_parent_class = NULL;
static gint GraniteWidgetsSourceListItem_private_offset;
static gpointer granite_widgets_source_list_item_parent_class = NULL;
static gint GraniteWidgetsSourceListExpandableItem_private_offset;
static gpointer granite_widgets_source_list_expandable_item_parent_class = NULL;
static gint GraniteWidgetsSourceListDataModel_private_offset;
static gpointer granite_widgets_source_list_data_model_parent_class = NULL;
static gint GraniteWidgetsSourceListDataModelNodeWrapper_private_offset;
static gpointer granite_widgets_source_list_data_model_node_wrapper_parent_class = NULL;
static gint GraniteWidgetsSourceListDataModelItemMonitor_private_offset;
static gpointer granite_widgets_source_list_data_model_item_monitor_parent_class = NULL;
static GtkTreeDragSourceIface * granite_widgets_source_list_data_model_gtk_tree_drag_source_parent_iface = NULL;
static GtkTreeDragDestIface * granite_widgets_source_list_data_model_gtk_tree_drag_dest_parent_iface = NULL;
static gpointer granite_widgets_source_list_cell_renderer_icon_parent_class = NULL;
static gint GraniteWidgetsSourceListCellRendererSpacer_private_offset;
static gpointer granite_widgets_source_list_cell_renderer_spacer_parent_class = NULL;
static gint GraniteWidgetsSourceListTree_private_offset;
static gpointer granite_widgets_source_list_tree_parent_class = NULL;

static GType granite_widgets_source_list_sortable_get_type_once (void);
static GType granite_widgets_source_list_drag_source_get_type_once (void);
static GType granite_widgets_source_list_drag_dest_get_type_once (void);
static GType granite_widgets_source_list_tree_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType granite_widgets_source_list_data_model_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void granite_widgets_source_list_real_item_selected (GraniteWidgetsSourceList* self,
                                                     GraniteWidgetsSourceListItem* item);
static GraniteWidgetsSourceListExpandableItem* granite_widgets_source_list_data_model_get_root (GraniteWidgetsSourceListDataModel* self);
static void granite_widgets_source_list_data_model_set_root (GraniteWidgetsSourceListDataModel* self,
                                                      GraniteWidgetsSourceListExpandableItem* value);
static GraniteWidgetsSourceListItem* granite_widgets_source_list_tree_get_selected_item (GraniteWidgetsSourceListTree* self);
static void granite_widgets_source_list_tree_set_selected_item (GraniteWidgetsSourceListTree* self,
                                                         GraniteWidgetsSourceListItem* value);
static PangoEllipsizeMode granite_widgets_source_list_tree_get_ellipsize_mode (GraniteWidgetsSourceListTree* self);
static void granite_widgets_source_list_tree_set_ellipsize_mode (GraniteWidgetsSourceListTree* self,
                                                          PangoEllipsizeMode value);
static gboolean granite_widgets_source_list_tree_get_editing (GraniteWidgetsSourceListTree* self);
static GraniteWidgetsSourceListDataModel* granite_widgets_source_list_data_model_new (void);
static GraniteWidgetsSourceListDataModel* granite_widgets_source_list_data_model_construct (GType object_type);
static gboolean granite_widgets_source_list_data_model_has_item (GraniteWidgetsSourceListDataModel* self,
                                                          GraniteWidgetsSourceListItem* item);
static void granite_widgets_source_list_data_model_set_filter_func (GraniteWidgetsSourceListDataModel* self,
                                                             GraniteWidgetsSourceListVisibleFunc visible_func,
                                                             gpointer visible_func_target);
static GtkTreePath* granite_widgets_source_list_data_model_get_item_path (GraniteWidgetsSourceListDataModel* self,
                                                                   GraniteWidgetsSourceListItem* item);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static gboolean granite_widgets_source_list_tree_start_editing_item (GraniteWidgetsSourceListTree* self,
                                                              GraniteWidgetsSourceListItem* item);
static void granite_widgets_source_list_tree_stop_editing (GraniteWidgetsSourceListTree* self);
static void granite_widgets_source_list_tree_configure_drag_source (GraniteWidgetsSourceListTree* self,
                                                             GtkTargetEntry* src_entries,
                                                             gint src_entries_length1);
static void granite_widgets_source_list_tree_configure_drag_dest (GraniteWidgetsSourceListTree* self,
                                                           GtkTargetEntry* dest_entries,
                                                           gint dest_entries_length1,
                                                           GdkDragAction actions);
static gboolean granite_widgets_source_list_tree_scroll_to_item (GraniteWidgetsSourceListTree* self,
                                                          GraniteWidgetsSourceListItem* item,
                                                          gboolean use_align,
                                                          gfloat row_align);
static GtkTreeIter* granite_widgets_source_list_data_model_get_item_iter (GraniteWidgetsSourceListDataModel* self,
                                                                   GraniteWidgetsSourceListItem* item);
static GraniteWidgetsSourceListItem* granite_widgets_source_list_data_model_get_item (GraniteWidgetsSourceListDataModel* self,
                                                                               GtkTreeIter* iter);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GraniteWidgetsSourceListItem* granite_widgets_source_list_get_nth_child (GraniteWidgetsSourceList* self,
                                                                         GraniteWidgetsSourceListExpandableItem* parent,
                                                                         gint index);
static void granite_widgets_source_list_item_real_edited (GraniteWidgetsSourceListItem* self,
                                                   const gchar* new_name);
static void granite_widgets_source_list_item_real_action_activated (GraniteWidgetsSourceListItem* self);
static void granite_widgets_source_list_item_real_activated (GraniteWidgetsSourceListItem* self);
 G_GNUC_INTERNAL void granite_widgets_source_list_item_set_parent (GraniteWidgetsSourceListItem* self,
                                                  GraniteWidgetsSourceListExpandableItem* value);
static GtkMenu* granite_widgets_source_list_item_real_get_context_menu (GraniteWidgetsSourceListItem* self);
static void granite_widgets_source_list_item_finalize (GObject * obj);
static GType granite_widgets_source_list_item_get_type_once (void);
static void _vala_granite_widgets_source_list_item_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_granite_widgets_source_list_item_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void granite_widgets_source_list_expandable_item_real_toggled (GraniteWidgetsSourceListExpandableItem* self);
static void granite_widgets_source_list_expandable_item_set_expansion (GraniteWidgetsSourceListExpandableItem* item,
                                                                gboolean inclusive,
                                                                gboolean recursive,
                                                                gboolean expanded);
static GObject * granite_widgets_source_list_expandable_item_constructor (GType type,
                                                                   guint n_construct_properties,
                                                                   GObjectConstructParam * construct_properties);
static void granite_widgets_source_list_expandable_item_finalize (GObject * obj);
static GType granite_widgets_source_list_expandable_item_get_type_once (void);
static void _vala_granite_widgets_source_list_expandable_item_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec);
static void _vala_granite_widgets_source_list_expandable_item_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec);
static gpointer granite_widgets_source_list_data_model_node_wrapper_ref (gpointer instance);
static void granite_widgets_source_list_data_model_node_wrapper_unref (gpointer instance);
static GParamSpec* granite_widgets_source_list_data_model_param_spec_node_wrapper (const gchar* name,
                                                                            const gchar* nick,
                                                                            const gchar* blurb,
                                                                            GType object_type,
                                                                            GParamFlags flags) G_GNUC_UNUSED ;
static void granite_widgets_source_list_data_model_value_set_node_wrapper (GValue* value,
                                                                    gpointer v_object) G_GNUC_UNUSED ;
static void granite_widgets_source_list_data_model_value_take_node_wrapper (GValue* value,
                                                                     gpointer v_object) G_GNUC_UNUSED ;
static gpointer granite_widgets_source_list_data_model_value_get_node_wrapper (const GValue* value) G_GNUC_UNUSED ;
static GType granite_widgets_source_list_data_model_node_wrapper_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gpointer granite_widgets_source_list_data_model_item_monitor_ref (gpointer instance);
static void granite_widgets_source_list_data_model_item_monitor_unref (gpointer instance);
static GParamSpec* granite_widgets_source_list_data_model_param_spec_item_monitor (const gchar* name,
                                                                            const gchar* nick,
                                                                            const gchar* blurb,
                                                                            GType object_type,
                                                                            GParamFlags flags) G_GNUC_UNUSED ;
static void granite_widgets_source_list_data_model_value_set_item_monitor (GValue* value,
                                                                    gpointer v_object) G_GNUC_UNUSED ;
static void granite_widgets_source_list_data_model_value_take_item_monitor (GValue* value,
                                                                     gpointer v_object) G_GNUC_UNUSED ;
static gpointer granite_widgets_source_list_data_model_value_get_item_monitor (const GValue* value) G_GNUC_UNUSED ;
static GType granite_widgets_source_list_data_model_item_monitor_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType granite_widgets_source_list_data_model_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType granite_widgets_source_list_data_model_column_type (GraniteWidgetsSourceListDataModelColumn self);
static void granite_widgets_source_list_data_model_remove_children_monitor (GraniteWidgetsSourceListDataModel* self,
                                                                     GraniteWidgetsSourceListExpandableItem* item);
static void granite_widgets_source_list_data_model_remove_item (GraniteWidgetsSourceListDataModel* self,
                                                         GraniteWidgetsSourceListItem* item);
static void granite_widgets_source_list_data_model_add_children_monitor (GraniteWidgetsSourceListDataModel* self,
                                                                  GraniteWidgetsSourceListExpandableItem* item);
static void granite_widgets_source_list_data_model_add_item (GraniteWidgetsSourceListDataModel* self,
                                                      GraniteWidgetsSourceListItem* item);
static void granite_widgets_source_list_data_model_update_item (GraniteWidgetsSourceListDataModel* self,
                                                         GraniteWidgetsSourceListItem* item);
static GtkTreePath* granite_widgets_source_list_data_model_node_wrapper_get_path (GraniteWidgetsSourceListDataModelNodeWrapper* self);
static GtkTreeIter* granite_widgets_source_list_data_model_node_wrapper_get_iter (GraniteWidgetsSourceListDataModelNodeWrapper* self);
static GtkTreeIter* granite_widgets_source_list_data_model_get_item_child_iter (GraniteWidgetsSourceListDataModel* self,
                                                                         GraniteWidgetsSourceListItem* item);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static GraniteWidgetsSourceListDataModelNodeWrapper* granite_widgets_source_list_data_model_node_wrapper_new (GtkTreeModel* model,
                                                                                                       GtkTreeIter* iter);
static GraniteWidgetsSourceListDataModelNodeWrapper* granite_widgets_source_list_data_model_node_wrapper_construct (GType object_type,
                                                                                                             GtkTreeModel* model,
                                                                                                             GtkTreeIter* iter);
static void granite_widgets_source_list_data_model_add_property_monitor (GraniteWidgetsSourceListDataModel* self,
                                                                  GraniteWidgetsSourceListItem* item);
static void granite_widgets_source_list_data_model_push_parent_update (GraniteWidgetsSourceListDataModel* self,
                                                                GraniteWidgetsSourceListExpandableItem* parent);
static void granite_widgets_source_list_data_model_remove_property_monitor (GraniteWidgetsSourceListDataModel* self,
                                                                     GraniteWidgetsSourceListItem* item);
static GraniteWidgetsSourceListDataModelItemMonitor* granite_widgets_source_list_data_model_item_monitor_new (GraniteWidgetsSourceListItem* item);
static GraniteWidgetsSourceListDataModelItemMonitor* granite_widgets_source_list_data_model_item_monitor_construct (GType object_type,
                                                                                                             GraniteWidgetsSourceListItem* item);
static void granite_widgets_source_list_data_model_on_item_prop_changed (GraniteWidgetsSourceListDataModel* self,
                                                                  GraniteWidgetsSourceListItem* item,
                                                                  const gchar* prop_name);
static void _granite_widgets_source_list_data_model_on_item_prop_changed_granite_widgets_source_list_data_model_item_monitor_changed (GraniteWidgetsSourceListDataModelItemMonitor* _sender,
                                                                                                                               GraniteWidgetsSourceListItem* _self_,
                                                                                                                               const gchar* prop_name,
                                                                                                                               gpointer self);
static void granite_widgets_source_list_data_model_on_item_child_added (GraniteWidgetsSourceListDataModel* self,
                                                                 GraniteWidgetsSourceListItem* item);
static void _granite_widgets_source_list_data_model_on_item_child_added_granite_widgets_source_list_expandable_item_child_added (GraniteWidgetsSourceListExpandableItem* _sender,
                                                                                                                          GraniteWidgetsSourceListItem* item,
                                                                                                                          gpointer self);
static void granite_widgets_source_list_data_model_on_item_child_removed (GraniteWidgetsSourceListDataModel* self,
                                                                   GraniteWidgetsSourceListItem* item);
static void _granite_widgets_source_list_data_model_on_item_child_removed_granite_widgets_source_list_expandable_item_child_removed (GraniteWidgetsSourceListExpandableItem* _sender,
                                                                                                                              GraniteWidgetsSourceListItem* item,
                                                                                                                              gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean ___lambda80_ (Block12Data* _data12_);
static gboolean ____lambda80__gsource_func (gpointer self);
static GraniteWidgetsSourceListItem* granite_widgets_source_list_data_model_get_item_from_path (GraniteWidgetsSourceListDataModel* self,
                                                                                         GtkTreePath* path);
static GtkTreePath* granite_widgets_source_list_data_model_get_item_child_path (GraniteWidgetsSourceListDataModel* self,
                                                                         GraniteWidgetsSourceListItem* item);
static gboolean granite_widgets_source_list_data_model_is_category (GraniteWidgetsSourceListDataModel* self,
                                                             GraniteWidgetsSourceListItem* item,
                                                             GtkTreeIter* iter,
                                                             GtkTreePath* path);
static gboolean granite_widgets_source_list_data_model_is_iter_at_root_level (GraniteWidgetsSourceListDataModel* self,
                                                                       GtkTreeIter* iter);
static gboolean granite_widgets_source_list_data_model_is_path_at_root_level (GraniteWidgetsSourceListDataModel* self,
                                                                       GtkTreePath* path);
static void granite_widgets_source_list_data_model_resort (GraniteWidgetsSourceListDataModel* self);
static gint granite_widgets_source_list_data_model_child_model_sort_func (GraniteWidgetsSourceListDataModel* self,
                                                                   GtkTreeModel* model,
                                                                   GtkTreeIter* a,
                                                                   GtkTreeIter* b);
static gboolean granite_widgets_source_list_data_model_filter_visible_func (GraniteWidgetsSourceListDataModel* self,
                                                                     GtkTreeModel* child_model,
                                                                     GtkTreeIter* iter);
static gboolean granite_widgets_source_list_data_model_real_drag_data_received (GtkTreeDragDest* base,
                                                                         GtkTreePath* dest,
                                                                         GtkSelectionData* selection_data);
static gboolean granite_widgets_source_list_data_model_child_tree_drag_data_received (GraniteWidgetsSourceListDataModel* self,
                                                                               GtkTreePath* dest,
                                                                               GtkTreePath* src_path);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void granite_widgets_source_list_data_model_recursive_node_copy (GraniteWidgetsSourceListDataModel* self,
                                                                 GtkTreeIter* src_iter,
                                                                 GtkTreeIter* dest_iter);
static void granite_widgets_source_list_data_model_move_item (GraniteWidgetsSourceListDataModel* self,
                                                       GtkTreeIter* src_iter,
                                                       GtkTreeIter* dest_iter);
static gboolean granite_widgets_source_list_data_model_real_row_drop_possible (GtkTreeDragDest* base,
                                                                        GtkTreePath* dest,
                                                                        GtkSelectionData* selection_data);
static gint* _vala_array_dup1 (gint* self,
                        gssize length);
static gint* _vala_array_dup2 (gint* self,
                        gssize length);
static gboolean granite_widgets_source_list_data_model_real_drag_data_get (GtkTreeDragSource* base,
                                                                    GtkTreePath* path,
                                                                    GtkSelectionData* selection_data);
static gboolean granite_widgets_source_list_data_model_real_row_draggable (GtkTreeDragSource* base,
                                                                    GtkTreePath* path);
static void _vala_GtkTreeRowReference_free (GtkTreeRowReference* self);
static gboolean granite_widgets_source_list_data_model_node_wrapper_get_valid (GraniteWidgetsSourceListDataModelNodeWrapper* self);
static void granite_widgets_source_list_data_model_node_wrapper_finalize (GraniteWidgetsSourceListDataModelNodeWrapper * obj);
static GType granite_widgets_source_list_data_model_node_wrapper_get_type_once (void);
static void granite_widgets_source_list_data_model_item_monitor_on_notify (GraniteWidgetsSourceListDataModelItemMonitor* self,
                                                                    GParamSpec* prop);
static void _granite_widgets_source_list_data_model_item_monitor_on_notify_g_object_notify (GObject* _sender,
                                                                                     GParamSpec* pspec,
                                                                                     gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void granite_widgets_source_list_data_model_item_monitor_finalize (GraniteWidgetsSourceListDataModelItemMonitor * obj);
static GType granite_widgets_source_list_data_model_item_monitor_get_type_once (void);
static GObject * granite_widgets_source_list_data_model_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
static gint _granite_widgets_source_list_data_model_child_model_sort_func_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                                               GtkTreeIter* a,
                                                                                               GtkTreeIter* b,
                                                                                               gpointer self);
static gboolean _granite_widgets_source_list_data_model_filter_visible_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                                         GtkTreeIter* iter,
                                                                                                         gpointer self);
static void granite_widgets_source_list_data_model_finalize (GObject * obj);
static GType granite_widgets_source_list_data_model_get_type_once (void);
static void _vala_granite_widgets_source_list_data_model_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_granite_widgets_source_list_data_model_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static GType granite_widgets_source_list_cell_renderer_icon_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GraniteWidgetsSourceListCellRendererIcon* granite_widgets_source_list_cell_renderer_icon_new (void);
static GraniteWidgetsSourceListCellRendererIcon* granite_widgets_source_list_cell_renderer_icon_construct (GType object_type);
static gboolean granite_widgets_source_list_cell_renderer_icon_real_activate (GtkCellRenderer* base,
                                                                       GdkEvent* event,
                                                                       GtkWidget* widget,
                                                                       const gchar* path,
                                                                       GdkRectangle* background_area,
                                                                       GdkRectangle* cell_area,
                                                                       GtkCellRendererState flags);
static GObject * granite_widgets_source_list_cell_renderer_icon_constructor (GType type,
                                                                      guint n_construct_properties,
                                                                      GObjectConstructParam * construct_properties);
static GType granite_widgets_source_list_cell_renderer_icon_get_type_once (void);
static GType granite_widgets_source_list_cell_renderer_spacer_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gint granite_widgets_source_list_cell_renderer_spacer_get_level (GraniteWidgetsSourceListCellRendererSpacer* self);
static void granite_widgets_source_list_cell_renderer_spacer_set_level (GraniteWidgetsSourceListCellRendererSpacer* self,
                                                                 gint value);
static GtkSizeRequestMode granite_widgets_source_list_cell_renderer_spacer_real_get_request_mode (GtkCellRenderer* base);
static void granite_widgets_source_list_cell_renderer_spacer_real_get_preferred_width (GtkCellRenderer* base,
                                                                                GtkWidget* widget,
                                                                                gint* min_size,
                                                                                gint* natural_size);
static void granite_widgets_source_list_cell_renderer_spacer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                                           GtkWidget* widget,
                                                                                           gint width,
                                                                                           gint* min_height,
                                                                                           gint* natural_height);
static void granite_widgets_source_list_cell_renderer_spacer_real_render (GtkCellRenderer* base,
                                                                   cairo_t* context,
                                                                   GtkWidget* widget,
                                                                   GdkRectangle* bg_area,
                                                                   GdkRectangle* cell_area,
                                                                   GtkCellRendererState flags);
static GraniteWidgetsSourceListCellRendererSpacer* granite_widgets_source_list_cell_renderer_spacer_new (void);
static GraniteWidgetsSourceListCellRendererSpacer* granite_widgets_source_list_cell_renderer_spacer_construct (GType object_type);
static void granite_widgets_source_list_cell_renderer_spacer_finalize (GObject * obj);
static GType granite_widgets_source_list_cell_renderer_spacer_get_type_once (void);
static void _vala_granite_widgets_source_list_cell_renderer_spacer_get_property (GObject * object,
                                                                          guint property_id,
                                                                          GValue * value,
                                                                          GParamSpec * pspec);
static void _vala_granite_widgets_source_list_cell_renderer_spacer_set_property (GObject * object,
                                                                          guint property_id,
                                                                          const GValue * value,
                                                                          GParamSpec * pspec);
static void granite_widgets_source_list_tree_disable_item_property_monitor (GraniteWidgetsSourceListTree* self);
static GType granite_widgets_source_list_tree_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GraniteWidgetsSourceListDataModel* granite_widgets_source_list_tree_get_data_model (GraniteWidgetsSourceListTree* self);
static void granite_widgets_source_list_tree_set_data_model (GraniteWidgetsSourceListTree* self,
                                                      GraniteWidgetsSourceListDataModel* value);
static void granite_widgets_source_list_tree_set_selected (GraniteWidgetsSourceListTree* self,
                                                    GraniteWidgetsSourceListItem* item,
                                                    gboolean scroll_to_item);
static GraniteWidgetsSourceListTree* granite_widgets_source_list_tree_new (GraniteWidgetsSourceListDataModel* data_model);
static GraniteWidgetsSourceListTree* granite_widgets_source_list_tree_construct (GType object_type,
                                                                          GraniteWidgetsSourceListDataModel* data_model);
static gboolean granite_widgets_source_list_tree_real_drag_motion (GtkWidget* base,
                                                            GdkDragContext* context,
                                                            gint x,
                                                            gint y,
                                                            guint time);
static void granite_widgets_source_list_tree_real_drag_data_received (GtkWidget* base,
                                                               GdkDragContext* context,
                                                               gint x,
                                                               gint y,
                                                               GtkSelectionData* selection_data,
                                                               guint info,
                                                               guint time);
static GtkTargetEntry* granite_widgets_source_list_tree_append_row_target_entry (GtkTargetEntry* orig,
                                                                          gint orig_length1,
                                                                          gint* result_length1);
static gboolean granite_widgets_source_list_tree_on_query_tooltip (GraniteWidgetsSourceListTree* self,
                                                            gint x,
                                                            gint y,
                                                            gboolean keyboard_tooltip,
                                                            GtkTooltip* tooltip);
static gboolean granite_widgets_source_list_tree_over_cell (GraniteWidgetsSourceListTree* self,
                                                     GtkTreeViewColumn* col,
                                                     GtkTreePath* path,
                                                     GtkCellRenderer* cell,
                                                     gint x);
static void _vala_array_add2 (GtkTargetEntry* * array,
                       gint* length,
                       gint* size,
                       const GtkTargetEntry* value);
static void _vala_array_add3 (GtkTargetEntry* * array,
                       gint* length,
                       gint* size,
                       const GtkTargetEntry* value);
static void granite_widgets_source_list_tree_enable_item_property_monitor (GraniteWidgetsSourceListTree* self);
static void granite_widgets_source_list_tree_on_model_item_updated (GraniteWidgetsSourceListTree* self,
                                                             GraniteWidgetsSourceListItem* item);
static void _granite_widgets_source_list_tree_on_model_item_updated_granite_widgets_source_list_data_model_item_updated (GraniteWidgetsSourceListDataModel* _sender,
                                                                                                                  GraniteWidgetsSourceListItem* item,
                                                                                                                  gpointer self);
static void granite_widgets_source_list_tree_update_expansion (GraniteWidgetsSourceListTree* self,
                                                        GraniteWidgetsSourceListExpandableItem* expandable_item);
static void granite_widgets_source_list_tree_add_spacer_cell_for_level (GraniteWidgetsSourceListTree* self,
                                                                 gint level,
                                                                 gboolean check_previous);
static void granite_widgets_source_list_tree_spacer_cell_data_func (GtkCellLayout* layout,
                                                             GtkCellRenderer* renderer,
                                                             GtkTreeModel* model,
                                                             GtkTreeIter* iter);
static void _granite_widgets_source_list_tree_spacer_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                        GtkCellRenderer* cell,
                                                                                        GtkTreeModel* tree_model,
                                                                                        GtkTreeIter* iter,
                                                                                        gpointer self);
static gboolean granite_widgets_source_list_tree_select_func (GraniteWidgetsSourceListTree* self,
                                                       GtkTreeSelection* selection,
                                                       GtkTreeModel* model,
                                                       GtkTreePath* path,
                                                       gboolean path_currently_selected);
static GtkTreePath* granite_widgets_source_list_tree_get_selected_path (GraniteWidgetsSourceListTree* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static void granite_widgets_source_list_tree_real_cursor_changed (GtkTreeView* base);
static void granite_widgets_source_list_tree_on_editing_started (GraniteWidgetsSourceListTree* self,
                                                          GtkCellEditable* editable,
                                                          const gchar* path);
static void granite_widgets_source_list_tree_on_editing_done (GraniteWidgetsSourceListTree* self);
static void _granite_widgets_source_list_tree_on_editing_done_gtk_cell_editable_editing_done (GtkCellEditable* _sender,
                                                                                       gpointer self);
static void granite_widgets_source_list_tree_on_editing_canceled (GraniteWidgetsSourceListTree* self);
static void granite_widgets_source_list_tree_on_activatable_activated (GraniteWidgetsSourceListTree* self,
                                                                const gchar* item_path_str);
static GraniteWidgetsSourceListItem* granite_widgets_source_list_tree_get_item_from_path_string (GraniteWidgetsSourceListTree* self,
                                                                                          const gchar* item_path_str);
static gboolean granite_widgets_source_list_tree_toggle_expansion (GraniteWidgetsSourceListTree* self,
                                                            GraniteWidgetsSourceListExpandableItem* item);
static void granite_widgets_source_list_tree_real_row_expanded (GtkTreeView* base,
                                                         GtkTreeIter* iter,
                                                         GtkTreePath* path);
static void granite_widgets_source_list_tree_real_row_collapsed (GtkTreeView* base,
                                                          GtkTreeIter* iter,
                                                          GtkTreePath* path);
static void granite_widgets_source_list_tree_real_row_activated (GtkTreeView* base,
                                                          GtkTreePath* path,
                                                          GtkTreeViewColumn* column);
static gboolean granite_widgets_source_list_tree_real_key_release_event (GtkWidget* base,
                                                                  GdkEventKey* event);
static gboolean granite_widgets_source_list_tree_real_button_release_event (GtkWidget* base,
                                                                     GdkEventButton* event);
static gboolean granite_widgets_source_list_tree_real_button_press_event (GtkWidget* base,
                                                                   GdkEventButton* event);
static gboolean granite_widgets_source_list_tree_popup_context_menu (GraniteWidgetsSourceListTree* self,
                                                              GraniteWidgetsSourceListItem* item,
                                                              GdkEventButton* event);
static gboolean granite_widgets_source_list_tree_over_primary_expander (GraniteWidgetsSourceListTree* self,
                                                                 GtkTreeViewColumn* col,
                                                                 GtkTreePath* path,
                                                                 gint x);
static void granite_widgets_source_list_tree_expander_cell_data_func (GraniteWidgetsSourceListTree* self,
                                                               GtkCellLayout* layout,
                                                               GtkCellRenderer* renderer,
                                                               GtkTreeModel* model,
                                                               GtkTreeIter* iter);
static gint granite_widgets_source_list_tree_get_cell_width (GraniteWidgetsSourceListTree* self,
                                                      GtkCellRenderer* cell_renderer);
static gboolean granite_widgets_source_list_tree_real_popup_menu (GtkWidget* base);
static GraniteWidgetsSourceListItem* granite_widgets_source_list_tree_get_item_from_model (GtkTreeModel* model,
                                                                                    GtkTreeIter* iter);
static void granite_widgets_source_list_tree_name_cell_data_func (GraniteWidgetsSourceListTree* self,
                                                           GtkCellLayout* layout,
                                                           GtkCellRenderer* renderer,
                                                           GtkTreeModel* model,
                                                           GtkTreeIter* iter);
static void granite_widgets_source_list_tree_badge_cell_data_func (GraniteWidgetsSourceListTree* self,
                                                            GtkCellLayout* layout,
                                                            GtkCellRenderer* renderer,
                                                            GtkTreeModel* model,
                                                            GtkTreeIter* iter);
static void granite_widgets_source_list_tree_icon_cell_data_func (GraniteWidgetsSourceListTree* self,
                                                           GtkCellLayout* layout,
                                                           GtkCellRenderer* renderer,
                                                           GtkTreeModel* model,
                                                           GtkTreeIter* iter);
static GObject * granite_widgets_source_list_tree_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties);
static void _granite_widgets_source_list_tree_expander_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                          GtkCellRenderer* cell,
                                                                                          GtkTreeModel* tree_model,
                                                                                          GtkTreeIter* iter,
                                                                                          gpointer self);
static void _granite_widgets_source_list_tree_on_activatable_activated_granite_widgets_source_list_cell_renderer_icon_activated (GraniteWidgetsSourceListCellRendererIcon* _sender,
                                                                                                                          const gchar* path,
                                                                                                                          gpointer self);
static void _granite_widgets_source_list_tree_icon_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                      GtkCellRenderer* cell,
                                                                                      GtkTreeModel* tree_model,
                                                                                      GtkTreeIter* iter,
                                                                                      gpointer self);
static void _granite_widgets_source_list_tree_badge_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                       GtkCellRenderer* cell,
                                                                                       GtkTreeModel* tree_model,
                                                                                       GtkTreeIter* iter,
                                                                                       gpointer self);
static void _granite_widgets_source_list_tree_on_editing_started_gtk_cell_renderer_editing_started (GtkCellRenderer* _sender,
                                                                                             GtkCellEditable* editable,
                                                                                             const gchar* path,
                                                                                             gpointer self);
static void _granite_widgets_source_list_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled (GtkCellRenderer* _sender,
                                                                                               gpointer self);
static void _granite_widgets_source_list_tree_name_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                      GtkCellRenderer* cell,
                                                                                      GtkTreeModel* tree_model,
                                                                                      GtkTreeIter* iter,
                                                                                      gpointer self);
static gboolean _granite_widgets_source_list_tree_select_func_gtk_tree_selection_func (GtkTreeSelection* selection,
                                                                                GtkTreeModel* model,
                                                                                GtkTreePath* path,
                                                                                gboolean path_currently_selected,
                                                                                gpointer self);
static gboolean _granite_widgets_source_list_tree_on_query_tooltip_gtk_widget_query_tooltip (GtkWidget* _sender,
                                                                                      gint x,
                                                                                      gint y,
                                                                                      gboolean keyboard_tooltip,
                                                                                      GtkTooltip* tooltip,
                                                                                      gpointer self);
static void granite_widgets_source_list_tree_finalize (GObject * obj);
static GType granite_widgets_source_list_tree_get_type_once (void);
static void _vala_granite_widgets_source_list_tree_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_granite_widgets_source_list_tree_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static GObject * granite_widgets_source_list_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _granite_widgets_source_list___lambda81_ (GraniteWidgetsSourceList* self,
                                               GraniteWidgetsSourceListItem* item);
static void __granite_widgets_source_list___lambda81__granite_widgets_source_list_tree_item_selected (GraniteWidgetsSourceListTree* _sender,
                                                                                               GraniteWidgetsSourceListItem* item,
                                                                                               gpointer self);
static void granite_widgets_source_list_finalize (GObject * obj);
static GType granite_widgets_source_list_get_type_once (void);
static void _vala_granite_widgets_source_list_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_granite_widgets_source_list_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
     * Whether this item will allow users to re-arrange its children via DnD.
     *
     * This feature can co-exist with a sort algorithm (implemented
     * by {@link Granite.Widgets.SourceListSortable.compare}), but
     * the actual order of the items in the list will always
     * honor that method. The sort function has to be compatible with
     * the kind of DnD reordering the item wants to allow, since the user can
     * only reorder those items for which //compare// returns 0.
     *
     * @return Whether the item's children can be re-arranged by users.
     * @since 0.3
     */
gboolean
granite_widgets_source_list_sortable_allow_dnd_sorting (GraniteWidgetsSourceListSortable* self)
{
	GraniteWidgetsSourceListSortableIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_SORTABLE_GET_INTERFACE (self);
	if (_iface_->allow_dnd_sorting) {
		return _iface_->allow_dnd_sorting (self);
	}
	return FALSE;
}

/**
     * Should return a negative integer, zero, or a positive integer if ''a''
     * sorts //before// ''b'', ''a'' sorts //with// ''b'', or ''a'' sorts
     * //after// ''b'' respectively. If two items compare as equal, their
     * order in the sorted source list is undefined.
     *
     * In order to ensure that the source list behaves as expected, this
     * method must define a partial order on the source list tree; i.e. it
     * must be reflexive, antisymmetric and transitive. Not complying with
     * those requirements could make the program fall into an infinite loop
     * and freeze the user interface.
     *
     * Should return //0// to allow any pair of items to be sortable via DnD.
     *
     * @param a First item.
     * @param b Second item.
     * @return A //negative// integer if //a// sorts before //b//,
     *         //zero// if //a// equals //b//, or a //positive//
     *         integer if //a// sorts after //b//.
     * @since 0.3
     */
gint
granite_widgets_source_list_sortable_compare (GraniteWidgetsSourceListSortable* self,
                                              GraniteWidgetsSourceListItem* a,
                                              GraniteWidgetsSourceListItem* b)
{
	GraniteWidgetsSourceListSortableIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_SORTABLE_GET_INTERFACE (self);
	if (_iface_->compare) {
		return _iface_->compare (self, a, b);
	}
	return -1;
}

static void
granite_widgets_source_list_sortable_default_init (GraniteWidgetsSourceListSortableIface * iface,
                                                   gpointer iface_data)
{
	/**
	     * Emitted after a user has re-ordered an item via DnD.
	     *
	     * @param moved The item that was moved to a different position by the user.
	     * @since 0.3
	     */
	granite_widgets_source_list_sortable_signals[GRANITE_WIDGETS_SOURCE_LIST_SORTABLE_USER_MOVED_ITEM_SIGNAL] = g_signal_new ("user-moved-item", GRANITE_WIDGETS_TYPE_SOURCE_LIST_SORTABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM);
}

/**
 * An interface for sorting items.
 *
 * @since 0.3
 */
static GType
granite_widgets_source_list_sortable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListSortableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_sortable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_widgets_source_list_sortable_type_id;
	granite_widgets_source_list_sortable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GraniteWidgetsSourceListSortable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_widgets_source_list_sortable_type_id, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM);
	return granite_widgets_source_list_sortable_type_id;
}

GType
granite_widgets_source_list_sortable_get_type (void)
{
	static volatile gsize granite_widgets_source_list_sortable_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_sortable_type_id__once)) {
		GType granite_widgets_source_list_sortable_type_id;
		granite_widgets_source_list_sortable_type_id = granite_widgets_source_list_sortable_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_sortable_type_id__once, granite_widgets_source_list_sortable_type_id);
	}
	return granite_widgets_source_list_sortable_type_id__once;
}

/**
     * Determines whether this item can be dragged outside the source list widget.
     *
     * Even if this method returns //false//, the item could still be dragged around
     * within the source list if its parent allows DnD reordering. This only happens
     * when the parent implements {@link Granite.Widgets.SourceListSortable}.
     *
     * @return //true// if the item can be dragged; //false// otherwise.
     * @since 0.3
     * @see Granite.Widgets.SourceListSortable
     */
gboolean
granite_widgets_source_list_drag_source_draggable (GraniteWidgetsSourceListDragSource* self)
{
	GraniteWidgetsSourceListDragSourceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_DRAG_SOURCE_GET_INTERFACE (self);
	if (_iface_->draggable) {
		return _iface_->draggable (self);
	}
	return FALSE;
}

/**
     * This method is called when the drop site requests the data which is dragged.
     *
     * It is the responsibility of this method to fill //selection_data// with the
     * data in the format which is indicated by {@link Gtk.SelectionData.get_target}.
     *
     * @param selection_data {@link Gtk.SelectionData} containing source data.
     * @since 0.3
     * @see Gtk.SelectionData.set
     * @see Gtk.SelectionData.set_uris
     * @see Gtk.SelectionData.set_text
     */
void
granite_widgets_source_list_drag_source_prepare_selection_data (GraniteWidgetsSourceListDragSource* self,
                                                                GtkSelectionData* selection_data)
{
	GraniteWidgetsSourceListDragSourceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_DRAG_SOURCE_GET_INTERFACE (self);
	if (_iface_->prepare_selection_data) {
		_iface_->prepare_selection_data (self, selection_data);
	}
}

static void
granite_widgets_source_list_drag_source_default_init (GraniteWidgetsSourceListDragSourceIface * iface,
                                                      gpointer iface_data)
{
}

/**
 * An interface for dragging items out of the source list widget.
 *
 * @since 0.3
 */
static GType
granite_widgets_source_list_drag_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListDragSourceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_drag_source_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_widgets_source_list_drag_source_type_id;
	granite_widgets_source_list_drag_source_type_id = g_type_register_static (G_TYPE_INTERFACE, "GraniteWidgetsSourceListDragSource", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_widgets_source_list_drag_source_type_id, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM);
	return granite_widgets_source_list_drag_source_type_id;
}

GType
granite_widgets_source_list_drag_source_get_type (void)
{
	static volatile gsize granite_widgets_source_list_drag_source_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_drag_source_type_id__once)) {
		GType granite_widgets_source_list_drag_source_type_id;
		granite_widgets_source_list_drag_source_type_id = granite_widgets_source_list_drag_source_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_drag_source_type_id__once, granite_widgets_source_list_drag_source_type_id);
	}
	return granite_widgets_source_list_drag_source_type_id__once;
}

/**
     * Determines whether //data// can be dropped into this item.
     *
     * @param context The drag context.
     * @param data {@link Gtk.SelectionData} containing source data.
     * @return //true// if the drop is possible; //false// otherwise.
     * @since 0.3
     */
gboolean
granite_widgets_source_list_drag_dest_data_drop_possible (GraniteWidgetsSourceListDragDest* self,
                                                          GdkDragContext* context,
                                                          GtkSelectionData* data)
{
	GraniteWidgetsSourceListDragDestIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_DRAG_DEST_GET_INTERFACE (self);
	if (_iface_->data_drop_possible) {
		return _iface_->data_drop_possible (self, context, data);
	}
	return FALSE;
}

/**
     * If a data drop is deemed possible, then this method is called
     * when the data is actually dropped into this item. Any actions
     * consequence of the data received should be handled here.
     *
     * @param context The drag context.
     * @param data {@link Gtk.SelectionData} containing source data.
     * @return The action taken, or //0// to indicate that the dropped data was not accepted.
     * @since 0.3
     */
GdkDragAction
granite_widgets_source_list_drag_dest_data_received (GraniteWidgetsSourceListDragDest* self,
                                                     GdkDragContext* context,
                                                     GtkSelectionData* data)
{
	GraniteWidgetsSourceListDragDestIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_DRAG_DEST_GET_INTERFACE (self);
	if (_iface_->data_received) {
		return _iface_->data_received (self, context, data);
	}
	return 0U;
}

static void
granite_widgets_source_list_drag_dest_default_init (GraniteWidgetsSourceListDragDestIface * iface,
                                                    gpointer iface_data)
{
}

/**
 * An interface for receiving data from other widgets via drag-and-drop.
 *
 * @since 0.3
 */
static GType
granite_widgets_source_list_drag_dest_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListDragDestIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_drag_dest_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_widgets_source_list_drag_dest_type_id;
	granite_widgets_source_list_drag_dest_type_id = g_type_register_static (G_TYPE_INTERFACE, "GraniteWidgetsSourceListDragDest", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_widgets_source_list_drag_dest_type_id, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM);
	return granite_widgets_source_list_drag_dest_type_id;
}

GType
granite_widgets_source_list_drag_dest_get_type (void)
{
	static volatile gsize granite_widgets_source_list_drag_dest_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_drag_dest_type_id__once)) {
		GType granite_widgets_source_list_drag_dest_type_id;
		granite_widgets_source_list_drag_dest_type_id = granite_widgets_source_list_drag_dest_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_drag_dest_type_id__once, granite_widgets_source_list_drag_dest_type_id);
	}
	return granite_widgets_source_list_drag_dest_type_id__once;
}

static inline gpointer
granite_widgets_source_list_get_instance_private (GraniteWidgetsSourceList* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceList_private_offset);
}

static void
granite_widgets_source_list_real_item_selected (GraniteWidgetsSourceList* self,
                                                GraniteWidgetsSourceListItem* item)
{
}

GraniteWidgetsSourceListExpandableItem*
granite_widgets_source_list_get_root (GraniteWidgetsSourceList* self)
{
	GraniteWidgetsSourceListExpandableItem* result;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	GraniteWidgetsSourceListExpandableItem* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = granite_widgets_source_list_data_model_get_root (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_source_list_set_root (GraniteWidgetsSourceList* self,
                                      GraniteWidgetsSourceListExpandableItem* value)
{
	GraniteWidgetsSourceListDataModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->data_model;
	granite_widgets_source_list_data_model_set_root (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_properties[GRANITE_WIDGETS_SOURCE_LIST_ROOT_PROPERTY]);
}

GraniteWidgetsSourceListItem*
granite_widgets_source_list_get_selected (GraniteWidgetsSourceList* self)
{
	GraniteWidgetsSourceListItem* result;
	GraniteWidgetsSourceListTree* _tmp0_;
	GraniteWidgetsSourceListItem* _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tree;
	_tmp1_ = granite_widgets_source_list_tree_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_source_list_set_selected (GraniteWidgetsSourceList* self,
                                          GraniteWidgetsSourceListItem* value)
{
	gboolean _tmp0_ = FALSE;
	GraniteWidgetsSourceListTree* _tmp5_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		GraniteWidgetsSourceListExpandableItem* _tmp2_;
		_tmp1_ = granite_widgets_source_list_item_get_parent (value);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GraniteWidgetsSourceListExpandableItem* _tmp3_;
		GraniteWidgetsSourceListExpandableItem* _tmp4_;
		_tmp3_ = granite_widgets_source_list_item_get_parent (value);
		_tmp4_ = _tmp3_;
		granite_widgets_source_list_expandable_item_expand_with_parents (_tmp4_);
	}
	_tmp5_ = self->priv->tree;
	granite_widgets_source_list_tree_set_selected_item (_tmp5_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_properties[GRANITE_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY]);
}

PangoEllipsizeMode
granite_widgets_source_list_get_ellipsize_mode (GraniteWidgetsSourceList* self)
{
	PangoEllipsizeMode result;
	GraniteWidgetsSourceListTree* _tmp0_;
	PangoEllipsizeMode _tmp1_;
	PangoEllipsizeMode _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tree;
	_tmp1_ = granite_widgets_source_list_tree_get_ellipsize_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_source_list_set_ellipsize_mode (GraniteWidgetsSourceList* self,
                                                PangoEllipsizeMode value)
{
	GraniteWidgetsSourceListTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	granite_widgets_source_list_tree_set_ellipsize_mode (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_properties[GRANITE_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY]);
}

gboolean
granite_widgets_source_list_get_editing (GraniteWidgetsSourceList* self)
{
	gboolean result;
	GraniteWidgetsSourceListTree* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->tree;
	_tmp1_ = granite_widgets_source_list_tree_get_editing (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
     * Creates a new {@link Granite.Widgets.SourceList}.
     *
     * @return A new {@link Granite.Widgets.SourceList}.
     * @since 0.2
     */
GraniteWidgetsSourceList*
granite_widgets_source_list_construct (GType object_type,
                                       GraniteWidgetsSourceListExpandableItem* root)
{
	GraniteWidgetsSourceList * self = NULL;
	g_return_val_if_fail (root != NULL, NULL);
	self = (GraniteWidgetsSourceList*) g_object_new (object_type, NULL);
	granite_widgets_source_list_set_root (self, root);
	return self;
}

GraniteWidgetsSourceList*
granite_widgets_source_list_new (GraniteWidgetsSourceListExpandableItem* root)
{
	return granite_widgets_source_list_construct (GRANITE_WIDGETS_TYPE_SOURCE_LIST, root);
}

/**
     * Checks whether //item// is part of the source list.
     *
     * @param item The item to query.
     * @return //true// if the item belongs to the source list; //false// otherwise.
     * @since 0.2
     */
gboolean
granite_widgets_source_list_has_item (GraniteWidgetsSourceList* self,
                                      GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListDataModel* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->data_model;
	result = granite_widgets_source_list_data_model_has_item (_tmp0_, item);
	return result;
}

/**
     * Sets the method used for filtering out items.
     *
     * @param visible_func The method to use for filtering items.
     * @param refilter Whether to call {@link Granite.Widgets.SourceList.refilter} using the new function.
     * @see Granite.Widgets.SourceList.VisibleFunc
     * @see Granite.Widgets.SourceList.refilter
     * @since 0.2
     */
void
granite_widgets_source_list_set_filter_func (GraniteWidgetsSourceList* self,
                                             GraniteWidgetsSourceListVisibleFunc visible_func,
                                             gpointer visible_func_target,
                                             gboolean refilter)
{
	GraniteWidgetsSourceListDataModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->data_model;
	granite_widgets_source_list_data_model_set_filter_func (_tmp0_, visible_func, visible_func_target);
	if (refilter) {
		granite_widgets_source_list_refilter (self);
	}
}

/**
     * Applies the filter method set by {@link Granite.Widgets.SourceList.set_filter_func}
     * to all the items that are part of the current tree.
     *
     * @see Granite.Widgets.SourceList.VisibleFunc
     * @see Granite.Widgets.SourceList.set_filter_func
     * @since 0.2
     */
void
granite_widgets_source_list_refilter (GraniteWidgetsSourceList* self)
{
	GraniteWidgetsSourceListDataModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->data_model;
	gtk_tree_model_filter_refilter ((GtkTreeModelFilter*) _tmp0_);
}

/**
     * Queries the actual expansion state of //item//.
     *
     * @see Granite.Widgets.SourceList.ExpandableItem.expanded
     * @return Whether //item// is expanded or not.
     * @since 0.2
     */
static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

gboolean
granite_widgets_source_list_is_item_expanded (GraniteWidgetsSourceList* self,
                                              GraniteWidgetsSourceListItem* item)
{
	GtkTreePath* path = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GtkTreePath* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkTreePath* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_vala_return_val_if_fail (granite_widgets_source_list_has_item (self, item), "has_item (item)", FALSE);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = granite_widgets_source_list_data_model_get_item_path (_tmp0_, item);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ != NULL) {
		GraniteWidgetsSourceListTree* _tmp4_;
		GtkTreePath* _tmp5_;
		_tmp4_ = self->priv->tree;
		_tmp5_ = path;
		_tmp2_ = gtk_tree_view_row_expanded ((GtkTreeView*) _tmp4_, _tmp5_);
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	__vala_GtkTreePath_free0 (path);
	return result;
}

/**
     * If //item// is editable, this activates the editor; otherwise, it does nothing.
     * If an item was already being edited, this will fail.
     *
     * @param item Item to edit.
     * @see Granite.Widgets.SourceList.Item.editable
     * @see Granite.Widgets.SourceList.editing
     * @see Granite.Widgets.SourceList.stop_editing
     * @return true if the editing started successfully; false otherwise.
     * @since 0.2
     */
gboolean
granite_widgets_source_list_start_editing_item (GraniteWidgetsSourceList* self,
                                                GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListTree* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_vala_return_val_if_fail (granite_widgets_source_list_has_item (self, item), "has_item (item)", FALSE);
	_tmp0_ = self->priv->tree;
	result = granite_widgets_source_list_tree_start_editing_item (_tmp0_, item);
	return result;
}

/**
     * Cancels any editing operation going on.
     *
     * @see Granite.Widgets.SourceList.editing
     * @see Granite.Widgets.SourceList.start_editing_item
     * @since 0.2
     */
void
granite_widgets_source_list_stop_editing (GraniteWidgetsSourceList* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = granite_widgets_source_list_get_editing (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GraniteWidgetsSourceListTree* _tmp2_;
		_tmp2_ = self->priv->tree;
		granite_widgets_source_list_tree_stop_editing (_tmp2_);
	}
}

/**
     * Turns Source List into a //drag source//.
     *
     * This enables items that implement {@link Granite.Widgets.SourceListDragSource}
     * to be dragged outside the Source List and drop data into external widgets.
     *
     * @param src_entries an array of {@link Gtk.TargetEntry}s indicating the targets
     * that the drag will support.
     * @see Granite.Widgets.SourceListDragSource
     * @see Granite.Widgets.SourceList.disable_drag_source
     * @since 0.3
     */
void
granite_widgets_source_list_enable_drag_source (GraniteWidgetsSourceList* self,
                                                GtkTargetEntry* src_entries,
                                                gint src_entries_length1)
{
	GraniteWidgetsSourceListTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	granite_widgets_source_list_tree_configure_drag_source (_tmp0_, src_entries, (gint) src_entries_length1);
}

/**
     * Undoes the effect of {@link Granite.Widgets.SourceList.enable_drag_source}
     *
     * @see Granite.Widgets.SourceList.enable_drag_source
     * @since 0.3
     */
void
granite_widgets_source_list_disable_drag_source (GraniteWidgetsSourceList* self)
{
	GraniteWidgetsSourceListTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	granite_widgets_source_list_tree_configure_drag_source (_tmp0_, NULL, (gint) 0);
}

/**
     * Turns Source List into a //drop destination//.
     *
     * This enables items that implement {@link Granite.Widgets.SourceListDragDest}
     * to receive data from external widgets via drag-and-drop.
     *
     * @param dest_entries an array of {@link Gtk.TargetEntry}s indicating the drop
     * types that Source List items will accept.
     * @param actions a bitmask of possible actions for a drop onto Source List items.
     * @see Granite.Widgets.SourceListDragDest
     * @see Granite.Widgets.SourceList.disable_drag_dest
     * @since 0.3
     */
void
granite_widgets_source_list_enable_drag_dest (GraniteWidgetsSourceList* self,
                                              GtkTargetEntry* dest_entries,
                                              gint dest_entries_length1,
                                              GdkDragAction actions)
{
	GraniteWidgetsSourceListTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	granite_widgets_source_list_tree_configure_drag_dest (_tmp0_, dest_entries, (gint) dest_entries_length1, actions);
}

/**
     * Undoes the effect of {@link Granite.Widgets.SourceList.enable_drag_dest}
     *
     * @see Granite.Widgets.SourceList.enable_drag_dest
     * @since 0.3
     */
void
granite_widgets_source_list_disable_drag_dest (GraniteWidgetsSourceList* self)
{
	GraniteWidgetsSourceListTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree;
	granite_widgets_source_list_tree_configure_drag_dest (_tmp0_, NULL, (gint) 0, 0);
}

/**
     * Scrolls the source list tree to make //item// visible.
     *
     * {@link Granite.Widgets.SourceList.ExpandableItem.expand_with_parents} is called
     * for the item's parent if //expand_parents// is //true//, to make sure it's not
     * hidden behind a collapsed row.
     *
     * If use_align is //false//, then the row_align argument is ignored, and the tree
     * does the minimum amount of work to scroll the item onto the screen. This means that
     * the item will be scrolled to the edge closest to its current position. If the item
     * is currently visible on the screen, nothing is done.
     *
     * @param item Item to scroll to.
     * @param expand_parents Whether to recursively expand item's parent in case they are collapsed.
     * @param use_align Whether to use the //row_align// argument.
     * @param row_align The vertical alignment of //item//. 0.0 means top, 0.5 center, and 1.0 bottom.
     * @return //true// if successful; //false// otherwise.
     * @since 0.2
     */
gboolean
granite_widgets_source_list_scroll_to_item (GraniteWidgetsSourceList* self,
                                            GraniteWidgetsSourceListItem* item,
                                            gboolean expand_parents,
                                            gboolean use_align,
                                            gfloat row_align)
{
	gboolean _tmp0_ = FALSE;
	GraniteWidgetsSourceListTree* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_vala_return_val_if_fail (granite_widgets_source_list_has_item (self, item), "has_item (item)", FALSE);
	if (expand_parents) {
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		GraniteWidgetsSourceListExpandableItem* _tmp2_;
		_tmp1_ = granite_widgets_source_list_item_get_parent (item);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GraniteWidgetsSourceListExpandableItem* _tmp3_;
		GraniteWidgetsSourceListExpandableItem* _tmp4_;
		_tmp3_ = granite_widgets_source_list_item_get_parent (item);
		_tmp4_ = _tmp3_;
		granite_widgets_source_list_expandable_item_expand_with_parents (_tmp4_);
	}
	_tmp5_ = self->priv->tree;
	result = granite_widgets_source_list_tree_scroll_to_item (_tmp5_, item, use_align, row_align);
	return result;
}

/**
     * Gets the previous item with respect to //reference//.
     *
     * @param reference Item to use as reference.
     * @return The item that appears before //reference//, or //null// if there's none.
     * @since 0.2
     */
static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

GraniteWidgetsSourceListItem*
granite_widgets_source_list_get_previous_item (GraniteWidgetsSourceList* self,
                                               GraniteWidgetsSourceListItem* reference)
{
	GtkTreeIter* iter = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter* _tmp2_;
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	_vala_return_val_if_fail (granite_widgets_source_list_has_item (self, reference), "has_item (reference)", NULL);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = granite_widgets_source_list_data_model_get_item_iter (_tmp0_, reference);
	iter = _tmp1_;
	_tmp2_ = iter;
	if (_tmp2_ != NULL) {
		GtkTreeIter new_iter = {0};
		GtkTreeIter* _tmp3_;
		GraniteWidgetsSourceListDataModel* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = iter;
		new_iter = *_tmp3_;
		_tmp4_ = self->priv->data_model;
		_tmp5_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp4_, &new_iter);
		if (_tmp5_) {
			GraniteWidgetsSourceListDataModel* _tmp6_;
			GtkTreeIter _tmp7_;
			GraniteWidgetsSourceListItem* _tmp8_;
			_tmp6_ = self->priv->data_model;
			_tmp7_ = new_iter;
			_tmp8_ = granite_widgets_source_list_data_model_get_item (_tmp6_, &_tmp7_);
			result = _tmp8_;
			__vala_GtkTreeIter_free0 (iter);
			return result;
		}
	}
	result = NULL;
	__vala_GtkTreeIter_free0 (iter);
	return result;
}

/**
     * Gets the next item with respect to //reference//.
     *
     * @param reference Item to use as reference.
     * @return The item that appears after //reference//, or //null// if there's none.
     * @since 0.2
     */
GraniteWidgetsSourceListItem*
granite_widgets_source_list_get_next_item (GraniteWidgetsSourceList* self,
                                           GraniteWidgetsSourceListItem* reference)
{
	GtkTreeIter* iter = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter* _tmp2_;
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	_vala_return_val_if_fail (granite_widgets_source_list_has_item (self, reference), "has_item (reference)", NULL);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = granite_widgets_source_list_data_model_get_item_iter (_tmp0_, reference);
	iter = _tmp1_;
	_tmp2_ = iter;
	if (_tmp2_ != NULL) {
		GtkTreeIter new_iter = {0};
		GtkTreeIter* _tmp3_;
		GraniteWidgetsSourceListDataModel* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = iter;
		new_iter = *_tmp3_;
		_tmp4_ = self->priv->data_model;
		_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &new_iter);
		if (_tmp5_) {
			GraniteWidgetsSourceListDataModel* _tmp6_;
			GtkTreeIter _tmp7_;
			GraniteWidgetsSourceListItem* _tmp8_;
			_tmp6_ = self->priv->data_model;
			_tmp7_ = new_iter;
			_tmp8_ = granite_widgets_source_list_data_model_get_item (_tmp6_, &_tmp7_);
			result = _tmp8_;
			__vala_GtkTreeIter_free0 (iter);
			return result;
		}
	}
	result = NULL;
	__vala_GtkTreeIter_free0 (iter);
	return result;
}

/**
     * Gets the first visible child of an expandable item.
     *
     * @param parent Parent of the child to look up.
     * @return The first visible child of //parent//, or null if it was not found.
     * @since 0.2
     */
GraniteWidgetsSourceListItem*
granite_widgets_source_list_get_first_child (GraniteWidgetsSourceList* self,
                                             GraniteWidgetsSourceListExpandableItem* parent)
{
	GraniteWidgetsSourceListItem* _tmp0_;
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = granite_widgets_source_list_get_nth_child (self, parent, 0);
	result = _tmp0_;
	return result;
}

/**
     * Gets the last visible child of an expandable item.
     *
     * @param parent Parent of the child to look up.
     * @return The last visible child of //parent//, or null if it was not found.
     * @since 0.2
     */
GraniteWidgetsSourceListItem*
granite_widgets_source_list_get_last_child (GraniteWidgetsSourceList* self,
                                            GraniteWidgetsSourceListExpandableItem* parent)
{
	GraniteWidgetsSourceListItem* _tmp0_;
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = granite_widgets_source_list_get_nth_child (self, parent, ((gint) granite_widgets_source_list_get_n_visible_children (self, parent)) - 1);
	result = _tmp0_;
	return result;
}

/**
     * Gets the number of visible children of an expandable item.
     *
     * @param parent Item to query.
     * @return Number of visible children of //parent//.
     * @since 0.2
     */
guint
granite_widgets_source_list_get_n_visible_children (GraniteWidgetsSourceList* self,
                                                    GraniteWidgetsSourceListExpandableItem* parent)
{
	GtkTreeIter* parent_iter = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GraniteWidgetsSourceListDataModel* _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (parent != NULL, 0U);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = granite_widgets_source_list_data_model_get_item_iter (_tmp0_, (GraniteWidgetsSourceListItem*) parent);
	parent_iter = _tmp1_;
	_tmp2_ = self->priv->data_model;
	result = (guint) gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp2_, parent_iter);
	__vala_GtkTreeIter_free0 (parent_iter);
	return result;
}

static GraniteWidgetsSourceListItem*
granite_widgets_source_list_get_nth_child (GraniteWidgetsSourceList* self,
                                           GraniteWidgetsSourceListExpandableItem* parent,
                                           gint index)
{
	GtkTreeIter* parent_iter = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter child_iter = {0};
	GraniteWidgetsSourceListDataModel* _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	if (index < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->data_model;
	_tmp1_ = granite_widgets_source_list_data_model_get_item_iter (_tmp0_, (GraniteWidgetsSourceListItem*) parent);
	parent_iter = _tmp1_;
	_tmp2_ = self->priv->data_model;
	_tmp3_ = parent_iter;
	_tmp5_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp2_, &_tmp4_, _tmp3_, index);
	child_iter = _tmp4_;
	if (_tmp5_) {
		GraniteWidgetsSourceListDataModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GraniteWidgetsSourceListItem* _tmp8_;
		_tmp6_ = self->priv->data_model;
		_tmp7_ = child_iter;
		_tmp8_ = granite_widgets_source_list_data_model_get_item (_tmp6_, &_tmp7_);
		result = _tmp8_;
		__vala_GtkTreeIter_free0 (parent_iter);
		return result;
	}
	result = NULL;
	__vala_GtkTreeIter_free0 (parent_iter);
	return result;
}

static inline gpointer
granite_widgets_source_list_item_get_instance_private (GraniteWidgetsSourceListItem* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListItem_private_offset);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
granite_widgets_source_list_item_real_edited (GraniteWidgetsSourceListItem* self,
                                              const gchar* new_name)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (new_name != NULL);
	_tmp1_ = self->priv->_editable;
	if (_tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = string_strip (new_name);
		_tmp3_ = _tmp2_;
		_tmp0_ = g_strcmp0 (_tmp3_, "") != 0;
		_g_free0 (_tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		granite_widgets_source_list_item_set_name (self, new_name);
	}
}

static void
granite_widgets_source_list_item_real_action_activated (GraniteWidgetsSourceListItem* self)
{
}

static void
granite_widgets_source_list_item_real_activated (GraniteWidgetsSourceListItem* self)
{
}

GraniteWidgetsSourceListExpandableItem*
granite_widgets_source_list_item_get_parent (GraniteWidgetsSourceListItem* self)
{
	GraniteWidgetsSourceListExpandableItem* result;
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

 G_GNUC_INTERNAL void
granite_widgets_source_list_item_set_parent (GraniteWidgetsSourceListItem* self,
                                             GraniteWidgetsSourceListExpandableItem* value)
{
	GraniteWidgetsSourceListExpandableItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_parent (self);
	if (old_value != value) {
		GraniteWidgetsSourceListExpandableItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_parent);
		self->priv->_parent = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY]);
	}
}

const gchar*
granite_widgets_source_list_item_get_name (GraniteWidgetsSourceListItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
granite_widgets_source_list_item_set_name (GraniteWidgetsSourceListItem* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY]);
	}
}

const gchar*
granite_widgets_source_list_item_get_tooltip (GraniteWidgetsSourceListItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tooltip;
	result = _tmp0_;
	return result;
}

void
granite_widgets_source_list_item_set_tooltip (GraniteWidgetsSourceListItem* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_tooltip (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_tooltip);
		self->priv->_tooltip = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_TOOLTIP_PROPERTY]);
	}
}

const gchar*
granite_widgets_source_list_item_get_markup (GraniteWidgetsSourceListItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_markup;
	result = _tmp0_;
	return result;
}

void
granite_widgets_source_list_item_set_markup (GraniteWidgetsSourceListItem* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_markup (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_markup);
		self->priv->_markup = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_MARKUP_PROPERTY]);
	}
}

const gchar*
granite_widgets_source_list_item_get_badge (GraniteWidgetsSourceListItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_badge;
	result = _tmp0_;
	return result;
}

void
granite_widgets_source_list_item_set_badge (GraniteWidgetsSourceListItem* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_badge (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_badge);
		self->priv->_badge = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY]);
	}
}

gboolean
granite_widgets_source_list_item_get_editable (GraniteWidgetsSourceListItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_editable;
	return result;
}

void
granite_widgets_source_list_item_set_editable (GraniteWidgetsSourceListItem* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_editable (self);
	if (old_value != value) {
		self->priv->_editable = value;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY]);
	}
}

gboolean
granite_widgets_source_list_item_get_visible (GraniteWidgetsSourceListItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_visible;
	return result;
}

void
granite_widgets_source_list_item_set_visible (GraniteWidgetsSourceListItem* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_visible (self);
	if (old_value != value) {
		self->priv->_visible = value;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY]);
	}
}

gboolean
granite_widgets_source_list_item_get_selectable (GraniteWidgetsSourceListItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selectable;
	return result;
}

void
granite_widgets_source_list_item_set_selectable (GraniteWidgetsSourceListItem* self,
                                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_selectable (self);
	if (old_value != value) {
		self->priv->_selectable = value;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY]);
	}
}

GIcon*
granite_widgets_source_list_item_get_icon (GraniteWidgetsSourceListItem* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

void
granite_widgets_source_list_item_set_icon (GraniteWidgetsSourceListItem* self,
                                           GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY]);
	}
}

GIcon*
granite_widgets_source_list_item_get_activatable (GraniteWidgetsSourceListItem* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_activatable;
	result = _tmp0_;
	return result;
}

void
granite_widgets_source_list_item_set_activatable (GraniteWidgetsSourceListItem* self,
                                                  GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_activatable (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_activatable);
		self->priv->_activatable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY]);
	}
}

const gchar*
granite_widgets_source_list_item_get_activatable_tooltip (GraniteWidgetsSourceListItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_activatable_tooltip;
	result = _tmp0_;
	return result;
}

void
granite_widgets_source_list_item_set_activatable_tooltip (GraniteWidgetsSourceListItem* self,
                                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_item_get_activatable_tooltip (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_activatable_tooltip);
		self->priv->_activatable_tooltip = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_TOOLTIP_PROPERTY]);
	}
}

/**
         * Creates a new {@link Granite.Widgets.SourceList.Item}.
         *
         * @param name Name of the item.
         * @return (transfer full) A new {@link Granite.Widgets.SourceList.Item}.
         * @since 0.2
         */
GraniteWidgetsSourceListItem*
granite_widgets_source_list_item_construct (GType object_type,
                                            const gchar* name)
{
	GraniteWidgetsSourceListItem * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GraniteWidgetsSourceListItem*) g_object_new (object_type, NULL);
	granite_widgets_source_list_item_set_name (self, name);
	return self;
}

GraniteWidgetsSourceListItem*
granite_widgets_source_list_item_new (const gchar* name)
{
	return granite_widgets_source_list_item_construct (GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, name);
}

/**
         * Invoked when the item is secondary-clicked or when the usual menu keys are pressed.
         *
         * Note that since Granite 5.0, right clicking on an item no longer selects/activates it, so
         * any context menu items should be actioned on the item instance rather than the selected item
         * in the SourceList
         *
         * @return A {@link Gtk.Menu} or //null// if nothing should be displayed.
         * @since 0.2
         */
static GtkMenu*
granite_widgets_source_list_item_real_get_context_menu (GraniteWidgetsSourceListItem* self)
{
	GtkMenu* result;
	result = NULL;
	return result;
}

GtkMenu*
granite_widgets_source_list_item_get_context_menu (GraniteWidgetsSourceListItem* self)
{
	GraniteWidgetsSourceListItemClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = GRANITE_WIDGETS_SOURCE_LIST_ITEM_GET_CLASS (self);
	if (_klass_->get_context_menu) {
		return _klass_->get_context_menu (self);
	}
	return NULL;
}

static void
granite_widgets_source_list_item_class_init (GraniteWidgetsSourceListItemClass * klass,
                                             gpointer klass_data)
{
	granite_widgets_source_list_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListItem_private_offset);
	((GraniteWidgetsSourceListItemClass *) klass)->get_context_menu = (GtkMenu* (*) (GraniteWidgetsSourceListItem*)) granite_widgets_source_list_item_real_get_context_menu;
	((GraniteWidgetsSourceListItemClass *) klass)->edited = granite_widgets_source_list_item_real_edited;
	((GraniteWidgetsSourceListItemClass *) klass)->action_activated = granite_widgets_source_list_item_real_action_activated;
	((GraniteWidgetsSourceListItemClass *) klass)->activated = granite_widgets_source_list_item_real_activated;
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_item_finalize;
	/**
	         * Parent {@link Granite.Widgets.SourceList.ExpandableItem} of the item.
	         * ''Must not'' be modified.
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The item's name. Primary and most important information.
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The item's tooltip. If set to null (default), the tooltip for the item will be the
	         * contents of the {@link Granite.Widgets.SourceList.Item.name} property.
	         *
	         * @since 5.3
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_TOOLTIP_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_TOOLTIP_PROPERTY] = g_param_spec_string ("tooltip", "tooltip", "tooltip", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Markup to be used instead of {@link Granite.Widgets.SourceList.ExpandableItem.name}
	         * This would mean that &, <, etc have to be escaped in the text, but basic formatting
	         * can be done on the item with HTML style tags.
	         *
	         * Note: Only the {@link Granite.Widgets.SourceList.ExpandableItem.name} property
	         * is modified for editable items. So this property will be need to updated and
	         * reformatted with editable items.
	         *
	         * @since 5.0
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_MARKUP_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_MARKUP_PROPERTY] = g_param_spec_string ("markup", "markup", "markup", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * A badge shown next to the item's name.
	         *
	         * It can be used for displaying the number of unread messages in the "Inbox" item,
	         * for instance.
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY] = g_param_spec_string ("badge", "badge", "badge", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Whether the item's name can be edited from within the source list.
	         *
	         * When this property is set to //true//, users can edit the item by pressing
	         * the F2 key, or by double-clicking its name.
	         *
	         * ''This property only works for selectable items''.
	         *
	         * @see Granite.Widgets.SourceList.Item.selectable
	         * @see Granite.Widgets.SourceList.start_editing_item
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY] = g_param_spec_boolean ("editable", "editable", "editable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Whether the item should appear in the source list's tree or not.
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY] = g_param_spec_boolean ("visible", "visible", "visible", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Whether the item can be selected or not.
	         *
	         * Setting this property to true doesn't guarantee that the item will actually be
	         * selectable, since there are other external factors to take into account, like the
	         * item's {@link Granite.Widgets.SourceList.Item.visible} property; whether the item is
	         * a category; the parent item is collapsed, etc.
	         *
	         * @see Granite.Widgets.SourceList.Item.visible
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY] = g_param_spec_boolean ("selectable", "selectable", "selectable", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Primary icon.
	         *
	         * This property should be used to give the user an idea of what the item represents
	         * (i.e. content type.)
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * An activatable icon that works like a button.
	         *
	         * It can be used for e.g. showing an //"eject"// icon on a device's item.
	         *
	         * @see Granite.Widgets.SourceList.Item.action_activated
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY] = g_param_spec_object ("activatable", "activatable", "activatable", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The tooltip for the activatable icon.
	         *
	         * @since 5.0
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_TOOLTIP_PROPERTY, granite_widgets_source_list_item_properties[GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_TOOLTIP_PROPERTY] = g_param_spec_string ("activatable-tooltip", "activatable-tooltip", "activatable-tooltip", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Emitted when the user has finished editing the item's name.
	         *
	         * By default, if the name doesn't consist of white space, it is automatically assigned
	         * to the {@link Granite.Widgets.SourceList.Item.name} property. The default behavior can
	         * be changed by overriding this signal.
	         * @param new_name The item's new name (result of editing.)
	         * @since 0.2
	         */
	granite_widgets_source_list_item_signals[GRANITE_WIDGETS_SOURCE_LIST_ITEM_EDITED_SIGNAL] = g_signal_new ("edited", GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GraniteWidgetsSourceListItemClass, edited), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	/**
	         * The {@link Granite.Widgets.SourceList.Item.activatable} icon was activated.
	         *
	         * @see Granite.Widgets.SourceList.Item.activatable
	         * @since 0.2
	         */
	granite_widgets_source_list_item_signals[GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTION_ACTIVATED_SIGNAL] = g_signal_new ("action-activated", GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GraniteWidgetsSourceListItemClass, action_activated), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	         * Emitted when the item is double-clicked or when it is selected and one of the keys:
	         * Space, Shift+Space, Return or Enter is pressed. This signal is //also// for
	         * editable items.
	         *
	         * @since 0.2
	         */
	granite_widgets_source_list_item_signals[GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATED_SIGNAL] = g_signal_new ("activated", GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GraniteWidgetsSourceListItemClass, activated), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
granite_widgets_source_list_item_instance_init (GraniteWidgetsSourceListItem * self,
                                                gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = granite_widgets_source_list_item_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_name = _tmp0_;
	self->priv->_tooltip = NULL;
	self->priv->_markup = NULL;
	_tmp1_ = g_strdup ("");
	self->priv->_badge = _tmp1_;
	self->priv->_editable = FALSE;
	self->priv->_visible = TRUE;
	self->priv->_selectable = TRUE;
	_tmp2_ = g_strdup ("");
	self->priv->_activatable_tooltip = _tmp2_;
}

static void
granite_widgets_source_list_item_finalize (GObject * obj)
{
	GraniteWidgetsSourceListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, GraniteWidgetsSourceListItem);
	_g_object_unref0 (self->priv->_parent);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_tooltip);
	_g_free0 (self->priv->_markup);
	_g_free0 (self->priv->_badge);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_activatable);
	_g_free0 (self->priv->_activatable_tooltip);
	G_OBJECT_CLASS (granite_widgets_source_list_item_parent_class)->finalize (obj);
}

/**
     * A source list entry.
     *
     * Any change made to any of its properties will be ''automatically'' reflected
     * by the {@link Granite.Widgets.SourceList} widget.
     *
     * @since 0.2
     */
static GType
granite_widgets_source_list_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListItem), 0, (GInstanceInitFunc) granite_widgets_source_list_item_instance_init, NULL };
	GType granite_widgets_source_list_item_type_id;
	granite_widgets_source_list_item_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteWidgetsSourceListItem", &g_define_type_info, 0);
	GraniteWidgetsSourceListItem_private_offset = g_type_add_instance_private (granite_widgets_source_list_item_type_id, sizeof (GraniteWidgetsSourceListItemPrivate));
	return granite_widgets_source_list_item_type_id;
}

GType
granite_widgets_source_list_item_get_type (void)
{
	static volatile gsize granite_widgets_source_list_item_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_item_type_id__once)) {
		GType granite_widgets_source_list_item_type_id;
		granite_widgets_source_list_item_type_id = granite_widgets_source_list_item_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_item_type_id__once, granite_widgets_source_list_item_type_id);
	}
	return granite_widgets_source_list_item_type_id__once;
}

static void
_vala_granite_widgets_source_list_item_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	GraniteWidgetsSourceListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, GraniteWidgetsSourceListItem);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY:
		g_value_set_object (value, granite_widgets_source_list_item_get_parent (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY:
		g_value_set_string (value, granite_widgets_source_list_item_get_name (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_TOOLTIP_PROPERTY:
		g_value_set_string (value, granite_widgets_source_list_item_get_tooltip (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_MARKUP_PROPERTY:
		g_value_set_string (value, granite_widgets_source_list_item_get_markup (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY:
		g_value_set_string (value, granite_widgets_source_list_item_get_badge (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY:
		g_value_set_boolean (value, granite_widgets_source_list_item_get_editable (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY:
		g_value_set_boolean (value, granite_widgets_source_list_item_get_visible (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY:
		g_value_set_boolean (value, granite_widgets_source_list_item_get_selectable (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY:
		g_value_set_object (value, granite_widgets_source_list_item_get_icon (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY:
		g_value_set_object (value, granite_widgets_source_list_item_get_activatable (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_TOOLTIP_PROPERTY:
		g_value_set_string (value, granite_widgets_source_list_item_get_activatable_tooltip (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_source_list_item_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	GraniteWidgetsSourceListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, GraniteWidgetsSourceListItem);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_PARENT_PROPERTY:
		granite_widgets_source_list_item_set_parent (self, g_value_get_object (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_NAME_PROPERTY:
		granite_widgets_source_list_item_set_name (self, g_value_get_string (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_TOOLTIP_PROPERTY:
		granite_widgets_source_list_item_set_tooltip (self, g_value_get_string (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_MARKUP_PROPERTY:
		granite_widgets_source_list_item_set_markup (self, g_value_get_string (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_BADGE_PROPERTY:
		granite_widgets_source_list_item_set_badge (self, g_value_get_string (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_EDITABLE_PROPERTY:
		granite_widgets_source_list_item_set_editable (self, g_value_get_boolean (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_VISIBLE_PROPERTY:
		granite_widgets_source_list_item_set_visible (self, g_value_get_boolean (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_SELECTABLE_PROPERTY:
		granite_widgets_source_list_item_set_selectable (self, g_value_get_boolean (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_ICON_PROPERTY:
		granite_widgets_source_list_item_set_icon (self, g_value_get_object (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_PROPERTY:
		granite_widgets_source_list_item_set_activatable (self, g_value_get_object (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATABLE_TOOLTIP_PROPERTY:
		granite_widgets_source_list_item_set_activatable_tooltip (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
granite_widgets_source_list_expandable_item_get_instance_private (GraniteWidgetsSourceListExpandableItem* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListExpandableItem_private_offset);
}

static void
granite_widgets_source_list_expandable_item_real_toggled (GraniteWidgetsSourceListExpandableItem* self)
{
}

gboolean
granite_widgets_source_list_expandable_item_get_collapsible (GraniteWidgetsSourceListExpandableItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_collapsible;
	return result;
}

void
granite_widgets_source_list_expandable_item_set_collapsible (GraniteWidgetsSourceListExpandableItem* self,
                                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_expandable_item_get_collapsible (self);
	if (old_value != value) {
		self->priv->_collapsible = value;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY]);
	}
}

gboolean
granite_widgets_source_list_expandable_item_get_expanded (GraniteWidgetsSourceListExpandableItem* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_expanded) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_collapsible;
		_tmp0_ = !_tmp1_;
	}
	result = _tmp0_;
	return result;
}

void
granite_widgets_source_list_expandable_item_set_expanded (GraniteWidgetsSourceListExpandableItem* self,
                                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_expanded) {
		self->priv->_expanded = value;
		g_signal_emit (self, granite_widgets_source_list_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_TOGGLED_SIGNAL], 0);
	}
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY]);
}

guint
granite_widgets_source_list_expandable_item_get_n_children (GraniteWidgetsSourceListExpandableItem* self)
{
	guint result;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->children_list;
	_tmp1_ = gee_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

GeeCollection*
granite_widgets_source_list_expandable_item_get_children (GraniteWidgetsSourceListExpandableItem* self)
{
	GeeCollection* result;
	GeeArrayList* children_list_copy = NULL;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	children_list_copy = _tmp0_;
	_tmp1_ = self->priv->children_list;
	gee_array_list_add_all (children_list_copy, _tmp1_);
	result = (GeeCollection*) children_list_copy;
	return result;
}

/**
         * Creates a new {@link Granite.Widgets.SourceList.ExpandableItem}
         *
         * @param name Title of the item.
         * @return (transfer full) A new {@link Granite.Widgets.SourceList.ExpandableItem}.
         * @since 0.2
         */
GraniteWidgetsSourceListExpandableItem*
granite_widgets_source_list_expandable_item_construct (GType object_type,
                                                       const gchar* name)
{
	GraniteWidgetsSourceListExpandableItem * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GraniteWidgetsSourceListExpandableItem*) granite_widgets_source_list_item_construct (object_type, name);
	return self;
}

GraniteWidgetsSourceListExpandableItem*
granite_widgets_source_list_expandable_item_new (const gchar* name)
{
	return granite_widgets_source_list_expandable_item_construct (GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, name);
}

/**
         * Checks whether the item contains the specified child.
         *
         * This method only considers the item's immediate children.
         *
         * @param item Item to search.
         * @return Whether the item was found or not.
         * @since 0.2
         */
gboolean
granite_widgets_source_list_expandable_item_contains (GraniteWidgetsSourceListExpandableItem* self,
                                                      GraniteWidgetsSourceListItem* item)
{
	GeeCollection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->children_list;
	result = gee_collection_contains (_tmp0_, item);
	return result;
}

/**
         * Adds an item.
         *
         * {@link Granite.Widgets.SourceList.ExpandableItem.child_added} is fired after the item is added.
         *
         * While adding a child item, //the item it's being added to will set itself as the parent//.
         * Please note that items are required to have their //parent// property set to //null// before
         * being added, so make sure the item is removed from its previous parent before attempting
         * to add it to another item. For instance:
         * {{{
         * if (item.parent != null)
         *     item.parent.remove (item); // this will set item's parent to null
         * new_parent.add (item);
         * }}}
         *
         * @param item The item to add. Its parent __must__ be //null//.
         * @see Granite.Widgets.SourceList.ExpandableItem.child_added
         * @see Granite.Widgets.SourceList.ExpandableItem.remove
         * @since 0.2
         */
void
granite_widgets_source_list_expandable_item_add (GraniteWidgetsSourceListExpandableItem* self,
                                                 GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = granite_widgets_source_list_item_get_parent (item);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (_tmp1_ == NULL, "item.parent == null");
	granite_widgets_source_list_item_set_parent (item, self);
	_tmp2_ = self->priv->children_list;
	gee_collection_add (_tmp2_, item);
	g_signal_emit (self, granite_widgets_source_list_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_ADDED_SIGNAL], 0, item);
}

/**
         * Removes an item.
         *
         * The {@link Granite.Widgets.SourceList.ExpandableItem.child_removed} signal is fired
         * //after removing the item//. Finally (i.e. after all the handlers have been invoked),
         * the item's {@link Granite.Widgets.SourceList.Item.parent} property is set to //null//.
         * This has the advantage of letting signal handlers know the parent from which //item//
         * is being removed.
         *
         * @param item The item to remove. This will fail if item has a different parent.
         * @see Granite.Widgets.SourceList.ExpandableItem.child_removed
         * @see Granite.Widgets.SourceList.ExpandableItem.clear
         * @since 0.2
         */
void
granite_widgets_source_list_expandable_item_remove (GraniteWidgetsSourceListExpandableItem* self,
                                                    GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = granite_widgets_source_list_item_get_parent (item);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (_tmp1_ == self, "item.parent == this");
	_tmp2_ = self->priv->children_list;
	gee_collection_remove (_tmp2_, item);
	g_signal_emit (self, granite_widgets_source_list_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_REMOVED_SIGNAL], 0, item);
	granite_widgets_source_list_item_set_parent (item, NULL);
}

/**
         * Removes all the items contained by the item. It works similarly to
         * {@link Granite.Widgets.SourceList.ExpandableItem.remove}.
         *
         * @see Granite.Widgets.SourceList.ExpandableItem.remove
         * @see Granite.Widgets.SourceList.ExpandableItem.child_removed
         * @since 0.2
         */
void
granite_widgets_source_list_expandable_item_clear (GraniteWidgetsSourceListExpandableItem* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _item_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = granite_widgets_source_list_expandable_item_get_children (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_item_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GraniteWidgetsSourceListItem* item = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GraniteWidgetsSourceListItem* _tmp8_;
			_tmp5_ = _item_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _item_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			item = (GraniteWidgetsSourceListItem*) _tmp7_;
			_tmp8_ = item;
			granite_widgets_source_list_expandable_item_remove (self, _tmp8_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
}

/**
         * Expands the item and/or its children.
         *
         * @param inclusive Whether to also expand this item (true), or only its children (false).
         * @param recursive Whether to recursively expand all the children (true), or only
         * immediate children (false).
         * @see Granite.Widgets.SourceList.ExpandableItem.expanded
         * @since 0.2
         */
void
granite_widgets_source_list_expandable_item_expand_all (GraniteWidgetsSourceListExpandableItem* self,
                                                        gboolean inclusive,
                                                        gboolean recursive)
{
	g_return_if_fail (self != NULL);
	granite_widgets_source_list_expandable_item_set_expansion (self, inclusive, recursive, TRUE);
}

/**
         * Collapses the item and/or its children.
         *
         * @param inclusive Whether to also collapse this item (true), or only its children (false).
         * @param recursive Whether to recursively collapse all the children (true), or only
         * immediate children (false).
         * @see Granite.Widgets.SourceList.ExpandableItem.expanded
         * @since 0.2
         */
void
granite_widgets_source_list_expandable_item_collapse_all (GraniteWidgetsSourceListExpandableItem* self,
                                                          gboolean inclusive,
                                                          gboolean recursive)
{
	g_return_if_fail (self != NULL);
	granite_widgets_source_list_expandable_item_set_expansion (self, inclusive, recursive, FALSE);
}

static void
granite_widgets_source_list_expandable_item_set_expansion (GraniteWidgetsSourceListExpandableItem* item,
                                                           gboolean inclusive,
                                                           gboolean recursive,
                                                           gboolean expanded)
{
	g_return_if_fail (item != NULL);
	if (inclusive) {
		granite_widgets_source_list_expandable_item_set_expanded (item, expanded);
	}
	{
		GeeIterator* _child_item_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = granite_widgets_source_list_expandable_item_get_children (item);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_child_item_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GraniteWidgetsSourceListItem* child_item = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GraniteWidgetsSourceListExpandableItem* child_expandable_item = NULL;
			GraniteWidgetsSourceListItem* _tmp8_;
			GraniteWidgetsSourceListExpandableItem* _tmp9_;
			GraniteWidgetsSourceListExpandableItem* _tmp10_;
			_tmp5_ = _child_item_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _child_item_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			child_item = (GraniteWidgetsSourceListItem*) _tmp7_;
			_tmp8_ = child_item;
			_tmp9_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp8_) ? ((GraniteWidgetsSourceListExpandableItem*) _tmp8_) : NULL);
			child_expandable_item = _tmp9_;
			_tmp10_ = child_expandable_item;
			if (_tmp10_ != NULL) {
				if (recursive) {
					GraniteWidgetsSourceListExpandableItem* _tmp11_;
					_tmp11_ = child_expandable_item;
					granite_widgets_source_list_expandable_item_set_expansion (_tmp11_, TRUE, TRUE, expanded);
				} else {
					GraniteWidgetsSourceListExpandableItem* _tmp12_;
					_tmp12_ = child_expandable_item;
					granite_widgets_source_list_expandable_item_set_expanded (_tmp12_, expanded);
				}
			}
			_g_object_unref0 (child_expandable_item);
			_g_object_unref0 (child_item);
		}
		_g_object_unref0 (_child_item_it);
	}
}

/**
         * Recursively expands the item along with its parent(s).
         *
         * @see Granite.Widgets.SourceList.ExpandableItem.expanded
         * @since 0.2
         */
void
granite_widgets_source_list_expandable_item_expand_with_parents (GraniteWidgetsSourceListExpandableItem* self)
{
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = granite_widgets_source_list_item_get_parent ((GraniteWidgetsSourceListItem*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GraniteWidgetsSourceListExpandableItem* _tmp2_;
		GraniteWidgetsSourceListExpandableItem* _tmp3_;
		_tmp2_ = granite_widgets_source_list_item_get_parent ((GraniteWidgetsSourceListItem*) self);
		_tmp3_ = _tmp2_;
		granite_widgets_source_list_expandable_item_expand_with_parents (_tmp3_);
	}
	granite_widgets_source_list_expandable_item_set_expanded (self, TRUE);
}

/**
         * Recursively collapses the item along with its parent(s).
         *
         * @see Granite.Widgets.SourceList.ExpandableItem.expanded
         * @since 0.2
         */
void
granite_widgets_source_list_expandable_item_collapse_with_parents (GraniteWidgetsSourceListExpandableItem* self)
{
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = granite_widgets_source_list_item_get_parent ((GraniteWidgetsSourceListItem*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GraniteWidgetsSourceListExpandableItem* _tmp2_;
		GraniteWidgetsSourceListExpandableItem* _tmp3_;
		_tmp2_ = granite_widgets_source_list_item_get_parent ((GraniteWidgetsSourceListItem*) self);
		_tmp3_ = _tmp2_;
		granite_widgets_source_list_expandable_item_collapse_with_parents (_tmp3_);
	}
	granite_widgets_source_list_expandable_item_set_expanded (self, FALSE);
}

static GObject *
granite_widgets_source_list_expandable_item_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsSourceListExpandableItem * self;
	parent_class = G_OBJECT_CLASS (granite_widgets_source_list_expandable_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem);
	granite_widgets_source_list_item_set_editable ((GraniteWidgetsSourceListItem*) self, FALSE);
	return obj;
}

static void
granite_widgets_source_list_expandable_item_class_init (GraniteWidgetsSourceListExpandableItemClass * klass,
                                                        gpointer klass_data)
{
	granite_widgets_source_list_expandable_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListExpandableItem_private_offset);
	((GraniteWidgetsSourceListExpandableItemClass *) klass)->toggled = granite_widgets_source_list_expandable_item_real_toggled;
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_expandable_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_expandable_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_source_list_expandable_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_expandable_item_finalize;
	/**
	         * Whether the item is collapsible or not.
	         *
	         * When set to //false//, the item is //always// expanded and the expander is
	         * not shown. Please note that this will also affect the value returned by the
	         * {@link Granite.Widgets.SourceList.ExpandableItem.expanded} property.
	         *
	         * @see Granite.Widgets.SourceList.ExpandableItem.expanded
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY, granite_widgets_source_list_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY] = g_param_spec_boolean ("collapsible", "collapsible", "collapsible", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY, granite_widgets_source_list_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Number of children contained by the item.
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY, granite_widgets_source_list_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY] = g_param_spec_uint ("n-children", "n-children", "n-children", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * The item's children.
	         *
	         * This returns a newly-created list containing the children.
	         * It's safe to iterate it while removing items with
	         * {@link Granite.Widgets.SourceList.ExpandableItem.remove}
	         *
	         * @since 0.2
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILDREN_PROPERTY, granite_widgets_source_list_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILDREN_PROPERTY] = g_param_spec_object ("children", "children", "children", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Emitted when an item is added.
	         *
	         * @param item Item added.
	         * @see Granite.Widgets.SourceList.ExpandableItem.add
	         * @since 0.2
	         */
	granite_widgets_source_list_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_ADDED_SIGNAL] = g_signal_new ("child-added", GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM);
	/**
	         * Emitted when an item is removed.
	         *
	         * @param item Item removed.
	         * @see Granite.Widgets.SourceList.ExpandableItem.remove
	         * @since 0.2
	         */
	granite_widgets_source_list_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILD_REMOVED_SIGNAL] = g_signal_new ("child-removed", GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM);
	/**
	         * Emitted when the item is expanded or collapsed.
	         *
	         * @since 0.2
	         */
	granite_widgets_source_list_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_TOGGLED_SIGNAL] = g_signal_new ("toggled", GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GraniteWidgetsSourceListExpandableItemClass, toggled), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
granite_widgets_source_list_expandable_item_instance_init (GraniteWidgetsSourceListExpandableItem * self,
                                                           gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = granite_widgets_source_list_expandable_item_get_instance_private (self);
	self->priv->_collapsible = TRUE;
	self->priv->_expanded = FALSE;
	_tmp0_ = gee_array_list_new (GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->children_list = (GeeCollection*) _tmp0_;
}

static void
granite_widgets_source_list_expandable_item_finalize (GObject * obj)
{
	GraniteWidgetsSourceListExpandableItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem);
	_g_object_unref0 (self->priv->children_list);
	G_OBJECT_CLASS (granite_widgets_source_list_expandable_item_parent_class)->finalize (obj);
}

/**
     * An item that can contain more items.
     *
     * It supports all the properties inherited from {@link Granite.Widgets.SourceList.Item},
     * and behaves like a normal item, except when it is located at the root level; in that case,
     * the following properties are ignored by the widget:
     *
     * * {@link Granite.Widgets.SourceList.Item.selectable}
     * * {@link Granite.Widgets.SourceList.Item.editable}
     * * {@link Granite.Widgets.SourceList.Item.icon}
     * * {@link Granite.Widgets.SourceList.Item.activatable}
     * * {@link Granite.Widgets.SourceList.Item.badge}
     *
     * Root-level expandable items (i.e. Main Categories) are ''not'' displayed when they contain
     * zero visible children.
     *
     * @since 0.2
     */
static GType
granite_widgets_source_list_expandable_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListExpandableItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_expandable_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListExpandableItem), 0, (GInstanceInitFunc) granite_widgets_source_list_expandable_item_instance_init, NULL };
	GType granite_widgets_source_list_expandable_item_type_id;
	granite_widgets_source_list_expandable_item_type_id = g_type_register_static (GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, "GraniteWidgetsSourceListExpandableItem", &g_define_type_info, 0);
	GraniteWidgetsSourceListExpandableItem_private_offset = g_type_add_instance_private (granite_widgets_source_list_expandable_item_type_id, sizeof (GraniteWidgetsSourceListExpandableItemPrivate));
	return granite_widgets_source_list_expandable_item_type_id;
}

GType
granite_widgets_source_list_expandable_item_get_type (void)
{
	static volatile gsize granite_widgets_source_list_expandable_item_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_expandable_item_type_id__once)) {
		GType granite_widgets_source_list_expandable_item_type_id;
		granite_widgets_source_list_expandable_item_type_id = granite_widgets_source_list_expandable_item_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_expandable_item_type_id__once, granite_widgets_source_list_expandable_item_type_id);
	}
	return granite_widgets_source_list_expandable_item_type_id__once;
}

static void
_vala_granite_widgets_source_list_expandable_item_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec)
{
	GraniteWidgetsSourceListExpandableItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY:
		g_value_set_boolean (value, granite_widgets_source_list_expandable_item_get_collapsible (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY:
		g_value_set_boolean (value, granite_widgets_source_list_expandable_item_get_expanded (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY:
		g_value_set_uint (value, granite_widgets_source_list_expandable_item_get_n_children (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CHILDREN_PROPERTY:
		g_value_take_object (value, granite_widgets_source_list_expandable_item_get_children (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_source_list_expandable_item_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec)
{
	GraniteWidgetsSourceListExpandableItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY:
		granite_widgets_source_list_expandable_item_set_collapsible (self, g_value_get_boolean (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_EXPANDED_PROPERTY:
		granite_widgets_source_list_expandable_item_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
granite_widgets_source_list_data_model_get_instance_private (GraniteWidgetsSourceListDataModel* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListDataModel_private_offset);
}

static GType
granite_widgets_source_list_data_model_column_type (GraniteWidgetsSourceListDataModelColumn self)
{
	GType result;
	switch (self) {
		case GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM:
		{
			result = GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
granite_widgets_source_list_data_model_column_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, "GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM", "item"}, {GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_N_COLUMNS, "GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType granite_widgets_source_list_data_model_column_type_id;
	granite_widgets_source_list_data_model_column_type_id = g_enum_register_static ("GraniteWidgetsSourceListDataModelColumn", values);
	return granite_widgets_source_list_data_model_column_type_id;
}

static GType
granite_widgets_source_list_data_model_column_get_type (void)
{
	static volatile gsize granite_widgets_source_list_data_model_column_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_data_model_column_type_id__once)) {
		GType granite_widgets_source_list_data_model_column_type_id;
		granite_widgets_source_list_data_model_column_type_id = granite_widgets_source_list_data_model_column_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_data_model_column_type_id__once, granite_widgets_source_list_data_model_column_type_id);
	}
	return granite_widgets_source_list_data_model_column_type_id__once;
}

static GraniteWidgetsSourceListExpandableItem*
granite_widgets_source_list_data_model_get_root (GraniteWidgetsSourceListDataModel* self)
{
	GraniteWidgetsSourceListExpandableItem* result;
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root;
	result = _tmp0_;
	return result;
}

static void
granite_widgets_source_list_data_model_set_root (GraniteWidgetsSourceListDataModel* self,
                                                 GraniteWidgetsSourceListExpandableItem* value)
{
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp12_;
	GraniteWidgetsSourceListExpandableItem* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_root;
	if (_tmp0_ != NULL) {
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		_tmp1_ = self->priv->_root;
		granite_widgets_source_list_data_model_remove_children_monitor (self, _tmp1_);
		{
			GeeIterator* _item_it = NULL;
			GraniteWidgetsSourceListExpandableItem* _tmp2_;
			GeeCollection* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
			GeeIterator* _tmp7_;
			_tmp2_ = self->priv->_root;
			_tmp3_ = granite_widgets_source_list_expandable_item_get_children (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_item_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				GraniteWidgetsSourceListItem* item = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				GraniteWidgetsSourceListItem* _tmp11_;
				_tmp8_ = _item_it;
				if (!gee_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _item_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				item = (GraniteWidgetsSourceListItem*) _tmp10_;
				_tmp11_ = item;
				granite_widgets_source_list_data_model_remove_item (self, _tmp11_);
				_g_object_unref0 (item);
			}
			_g_object_unref0 (_item_it);
		}
	}
	_tmp12_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_root);
	self->priv->_root = _tmp12_;
	_tmp13_ = self->priv->_root;
	granite_widgets_source_list_data_model_add_children_monitor (self, _tmp13_);
	{
		GeeIterator* _item_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeCollection* _tmp17_;
		GeeIterator* _tmp18_;
		GeeIterator* _tmp19_;
		_tmp14_ = self->priv->_root;
		_tmp15_ = granite_widgets_source_list_expandable_item_get_children (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_item_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_;
			GraniteWidgetsSourceListItem* item = NULL;
			GeeIterator* _tmp21_;
			gpointer _tmp22_;
			GraniteWidgetsSourceListItem* _tmp23_;
			_tmp20_ = _item_it;
			if (!gee_iterator_next (_tmp20_)) {
				break;
			}
			_tmp21_ = _item_it;
			_tmp22_ = gee_iterator_get (_tmp21_);
			item = (GraniteWidgetsSourceListItem*) _tmp22_;
			_tmp23_ = item;
			granite_widgets_source_list_data_model_add_item (self, _tmp23_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_data_model_properties[GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY]);
}

static GraniteWidgetsSourceListDataModel*
granite_widgets_source_list_data_model_construct (GType object_type)
{
	GraniteWidgetsSourceListDataModel * self = NULL;
	self = (GraniteWidgetsSourceListDataModel*) g_object_new (object_type, NULL);
	return self;
}

static GraniteWidgetsSourceListDataModel*
granite_widgets_source_list_data_model_new (void)
{
	return granite_widgets_source_list_data_model_construct (GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL);
}

static gboolean
granite_widgets_source_list_data_model_has_item (GraniteWidgetsSourceListDataModel* self,
                                                 GraniteWidgetsSourceListItem* item)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->items;
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, item);
	return result;
}

static void
granite_widgets_source_list_data_model_update_item (GraniteWidgetsSourceListDataModel* self,
                                                    GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	GraniteWidgetsSourceListDataModelNodeWrapper* node_reference = NULL;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	GraniteWidgetsSourceListDataModelNodeWrapper* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_vala_return_if_fail (granite_widgets_source_list_data_model_has_item (self, item), "has_item (item)");
	_tmp0_ = granite_widgets_source_list_data_model_get_root (self);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "root != null");
	_tmp2_ = self->priv->items;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, item);
	node_reference = (GraniteWidgetsSourceListDataModelNodeWrapper*) _tmp3_;
	_tmp4_ = node_reference;
	if (_tmp4_ != NULL) {
		GtkTreePath* path = NULL;
		GraniteWidgetsSourceListDataModelNodeWrapper* _tmp5_;
		GtkTreePath* _tmp6_;
		GtkTreePath* _tmp7_;
		GtkTreeIter* iter = NULL;
		GraniteWidgetsSourceListDataModelNodeWrapper* _tmp8_;
		GtkTreeIter* _tmp9_;
		GtkTreeIter* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GtkTreePath* _tmp12_;
		_tmp5_ = node_reference;
		_tmp6_ = granite_widgets_source_list_data_model_node_wrapper_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		path = _tmp7_;
		_tmp8_ = node_reference;
		_tmp9_ = granite_widgets_source_list_data_model_node_wrapper_get_iter (_tmp8_);
		_tmp10_ = _tmp9_;
		iter = _tmp10_;
		_tmp12_ = path;
		if (_tmp12_ != NULL) {
			GtkTreeIter* _tmp13_;
			_tmp13_ = iter;
			_tmp11_ = _tmp13_ != NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			GtkTreeStore* _tmp14_;
			GtkTreePath* _tmp15_;
			GtkTreeIter* _tmp16_;
			GtkTreeIter _tmp17_;
			_tmp14_ = self->priv->child_tree;
			_tmp15_ = path;
			_tmp16_ = iter;
			_tmp17_ = *_tmp16_;
			gtk_tree_model_row_changed ((GtkTreeModel*) _tmp14_, _tmp15_, &_tmp17_);
			g_signal_emit (self, granite_widgets_source_list_data_model_signals[GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_UPDATED_SIGNAL], 0, item);
		}
		__vala_GtkTreeIter_free0 (iter);
		__vala_GtkTreePath_free0 (path);
	}
	_granite_widgets_source_list_data_model_node_wrapper_unref0 (node_reference);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static void
granite_widgets_source_list_data_model_add_item (GraniteWidgetsSourceListDataModel* self,
                                                 GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	GtkTreeIter* parent_child_iter = NULL;
	GtkTreeIter* child_iter = NULL;
	GraniteWidgetsSourceListExpandableItem* parent = NULL;
	GraniteWidgetsSourceListExpandableItem* _tmp2_;
	GraniteWidgetsSourceListExpandableItem* _tmp3_;
	GraniteWidgetsSourceListExpandableItem* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GraniteWidgetsSourceListExpandableItem* _tmp6_;
	GtkTreeStore* _tmp15_;
	GtkTreeIter* _tmp16_;
	GtkTreeIter _tmp17_ = {0};
	GtkTreeIter _tmp18_;
	GtkTreeIter* _tmp19_;
	GtkTreeStore* _tmp20_;
	GtkTreeIter* _tmp21_;
	GtkTreeIter _tmp22_;
	GeeHashMap* _tmp23_;
	GtkTreeStore* _tmp24_;
	GtkTreeIter* _tmp25_;
	GtkTreeIter _tmp26_;
	GraniteWidgetsSourceListDataModelNodeWrapper* _tmp27_;
	GraniteWidgetsSourceListDataModelNodeWrapper* _tmp28_;
	GraniteWidgetsSourceListExpandableItem* _tmp29_;
	GraniteWidgetsSourceListExpandableItem* expandable = NULL;
	GraniteWidgetsSourceListExpandableItem* _tmp30_;
	GraniteWidgetsSourceListExpandableItem* _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_vala_return_if_fail (!granite_widgets_source_list_data_model_has_item (self, item), "!has_item (item)");
	_tmp0_ = granite_widgets_source_list_data_model_get_root (self);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "root != null");
	parent_child_iter = NULL;
	_tmp2_ = granite_widgets_source_list_item_get_parent (item);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	parent = _tmp4_;
	_tmp6_ = parent;
	if (_tmp6_ != NULL) {
		GraniteWidgetsSourceListExpandableItem* _tmp7_;
		GraniteWidgetsSourceListExpandableItem* _tmp8_;
		GraniteWidgetsSourceListExpandableItem* _tmp9_;
		_tmp7_ = parent;
		_tmp8_ = granite_widgets_source_list_data_model_get_root (self);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp7_ != _tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GraniteWidgetsSourceListExpandableItem* _tmp10_;
		GraniteWidgetsSourceListExpandableItem* _tmp12_;
		GtkTreeIter* _tmp13_;
		GtkTreeIter* _tmp14_;
		_tmp10_ = parent;
		if (!granite_widgets_source_list_data_model_has_item (self, (GraniteWidgetsSourceListItem*) _tmp10_)) {
			GraniteWidgetsSourceListExpandableItem* _tmp11_;
			_tmp11_ = parent;
			granite_widgets_source_list_data_model_add_item (self, (GraniteWidgetsSourceListItem*) _tmp11_);
		}
		_tmp12_ = parent;
		_tmp13_ = granite_widgets_source_list_data_model_get_item_child_iter (self, (GraniteWidgetsSourceListItem*) _tmp12_);
		__vala_GtkTreeIter_free0 (parent_child_iter);
		parent_child_iter = _tmp13_;
		_tmp14_ = parent_child_iter;
		_vala_assert (_tmp14_ != NULL, "parent_child_iter != null");
	}
	_tmp15_ = self->priv->child_tree;
	_tmp16_ = parent_child_iter;
	gtk_tree_store_append (_tmp15_, &_tmp17_, _tmp16_);
	__vala_GtkTreeIter_free0 (child_iter);
	_tmp18_ = _tmp17_;
	_tmp19_ = __vala_GtkTreeIter_copy0 (&_tmp18_);
	child_iter = _tmp19_;
	_tmp20_ = self->priv->child_tree;
	_tmp21_ = child_iter;
	_tmp22_ = *_tmp21_;
	gtk_tree_store_set (_tmp20_, &_tmp22_, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, item, -1, -1);
	_tmp23_ = self->priv->items;
	_tmp24_ = self->priv->child_tree;
	_tmp25_ = child_iter;
	_tmp26_ = *_tmp25_;
	_tmp27_ = granite_widgets_source_list_data_model_node_wrapper_new ((GtkTreeModel*) _tmp24_, &_tmp26_);
	_tmp28_ = _tmp27_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, item, _tmp28_);
	_granite_widgets_source_list_data_model_node_wrapper_unref0 (_tmp28_);
	g_signal_emit (self, granite_widgets_source_list_data_model_signals[GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_UPDATED_SIGNAL], 0, item);
	granite_widgets_source_list_data_model_add_property_monitor (self, item);
	_tmp29_ = parent;
	granite_widgets_source_list_data_model_push_parent_update (self, _tmp29_);
	_tmp30_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (item) ? ((GraniteWidgetsSourceListExpandableItem*) item) : NULL);
	expandable = _tmp30_;
	_tmp31_ = expandable;
	if (_tmp31_ != NULL) {
		GraniteWidgetsSourceListExpandableItem* _tmp42_;
		{
			GeeIterator* _child_item_it = NULL;
			GraniteWidgetsSourceListExpandableItem* _tmp32_;
			GeeCollection* _tmp33_;
			GeeCollection* _tmp34_;
			GeeCollection* _tmp35_;
			GeeIterator* _tmp36_;
			GeeIterator* _tmp37_;
			_tmp32_ = expandable;
			_tmp33_ = granite_widgets_source_list_expandable_item_get_children (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_;
			_tmp36_ = gee_iterable_iterator ((GeeIterable*) _tmp35_);
			_tmp37_ = _tmp36_;
			_g_object_unref0 (_tmp35_);
			_child_item_it = _tmp37_;
			while (TRUE) {
				GeeIterator* _tmp38_;
				GraniteWidgetsSourceListItem* child_item = NULL;
				GeeIterator* _tmp39_;
				gpointer _tmp40_;
				GraniteWidgetsSourceListItem* _tmp41_;
				_tmp38_ = _child_item_it;
				if (!gee_iterator_next (_tmp38_)) {
					break;
				}
				_tmp39_ = _child_item_it;
				_tmp40_ = gee_iterator_get (_tmp39_);
				child_item = (GraniteWidgetsSourceListItem*) _tmp40_;
				_tmp41_ = child_item;
				granite_widgets_source_list_data_model_add_item (self, _tmp41_);
				_g_object_unref0 (child_item);
			}
			_g_object_unref0 (_child_item_it);
		}
		_tmp42_ = expandable;
		granite_widgets_source_list_data_model_add_children_monitor (self, _tmp42_);
	}
	_g_object_unref0 (expandable);
	_g_object_unref0 (parent);
	__vala_GtkTreeIter_free0 (child_iter);
	__vala_GtkTreeIter_free0 (parent_child_iter);
}

static void
granite_widgets_source_list_data_model_remove_item (GraniteWidgetsSourceListDataModel* self,
                                                    GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	GtkTreeIter* child_iter = NULL;
	GtkTreeIter* _tmp2_;
	GeeHashMap* _tmp3_;
	GtkTreeIter* _tmp4_;
	GraniteWidgetsSourceListExpandableItem* _tmp6_;
	GraniteWidgetsSourceListExpandableItem* _tmp7_;
	GraniteWidgetsSourceListExpandableItem* expandable = NULL;
	GraniteWidgetsSourceListExpandableItem* _tmp8_;
	GraniteWidgetsSourceListExpandableItem* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_vala_return_if_fail (granite_widgets_source_list_data_model_has_item (self, item), "has_item (item)");
	_tmp0_ = granite_widgets_source_list_data_model_get_root (self);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "root != null");
	granite_widgets_source_list_data_model_remove_property_monitor (self, item);
	_tmp2_ = granite_widgets_source_list_data_model_get_item_child_iter (self, item);
	child_iter = _tmp2_;
	_tmp3_ = self->priv->items;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, item, NULL);
	_tmp4_ = child_iter;
	if (_tmp4_ != NULL) {
		GtkTreeStore* _tmp5_;
		_tmp5_ = self->priv->child_tree;
		gtk_tree_store_remove (_tmp5_, child_iter);
	}
	_tmp6_ = granite_widgets_source_list_item_get_parent (item);
	_tmp7_ = _tmp6_;
	granite_widgets_source_list_data_model_push_parent_update (self, _tmp7_);
	_tmp8_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (item) ? ((GraniteWidgetsSourceListExpandableItem*) item) : NULL);
	expandable = _tmp8_;
	_tmp9_ = expandable;
	if (_tmp9_ != NULL) {
		GraniteWidgetsSourceListExpandableItem* _tmp10_;
		_tmp10_ = expandable;
		granite_widgets_source_list_data_model_remove_children_monitor (self, _tmp10_);
		{
			GeeIterator* _child_item_it = NULL;
			GraniteWidgetsSourceListExpandableItem* _tmp11_;
			GeeCollection* _tmp12_;
			GeeCollection* _tmp13_;
			GeeCollection* _tmp14_;
			GeeIterator* _tmp15_;
			GeeIterator* _tmp16_;
			_tmp11_ = expandable;
			_tmp12_ = granite_widgets_source_list_expandable_item_get_children (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
			_tmp16_ = _tmp15_;
			_g_object_unref0 (_tmp14_);
			_child_item_it = _tmp16_;
			while (TRUE) {
				GeeIterator* _tmp17_;
				GraniteWidgetsSourceListItem* child_item = NULL;
				GeeIterator* _tmp18_;
				gpointer _tmp19_;
				GraniteWidgetsSourceListItem* _tmp20_;
				_tmp17_ = _child_item_it;
				if (!gee_iterator_next (_tmp17_)) {
					break;
				}
				_tmp18_ = _child_item_it;
				_tmp19_ = gee_iterator_get (_tmp18_);
				child_item = (GraniteWidgetsSourceListItem*) _tmp19_;
				_tmp20_ = child_item;
				granite_widgets_source_list_data_model_remove_item (self, _tmp20_);
				_g_object_unref0 (child_item);
			}
			_g_object_unref0 (_child_item_it);
		}
	}
	_g_object_unref0 (expandable);
	__vala_GtkTreeIter_free0 (child_iter);
}

static void
_granite_widgets_source_list_data_model_on_item_prop_changed_granite_widgets_source_list_data_model_item_monitor_changed (GraniteWidgetsSourceListDataModelItemMonitor* _sender,
                                                                                                                          GraniteWidgetsSourceListItem* _self_,
                                                                                                                          const gchar* prop_name,
                                                                                                                          gpointer self)
{
	granite_widgets_source_list_data_model_on_item_prop_changed ((GraniteWidgetsSourceListDataModel*) self, _self_, prop_name);
}

static void
granite_widgets_source_list_data_model_add_property_monitor (GraniteWidgetsSourceListDataModel* self,
                                                             GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListDataModelItemMonitor* wrapper = NULL;
	GraniteWidgetsSourceListDataModelItemMonitor* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = granite_widgets_source_list_data_model_item_monitor_new (item);
	wrapper = _tmp0_;
	_tmp1_ = self->priv->monitors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, item, wrapper);
	g_signal_connect_object (wrapper, "changed", (GCallback) _granite_widgets_source_list_data_model_on_item_prop_changed_granite_widgets_source_list_data_model_item_monitor_changed, self, 0);
	_granite_widgets_source_list_data_model_item_monitor_unref0 (wrapper);
}

static void
granite_widgets_source_list_data_model_remove_property_monitor (GraniteWidgetsSourceListDataModel* self,
                                                                GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListDataModelItemMonitor* wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GraniteWidgetsSourceListDataModelItemMonitor* _tmp2_;
	GeeHashMap* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->monitors;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, item);
	wrapper = (GraniteWidgetsSourceListDataModelItemMonitor*) _tmp1_;
	_tmp2_ = wrapper;
	if (_tmp2_ != NULL) {
		GraniteWidgetsSourceListDataModelItemMonitor* _tmp3_;
		guint _tmp4_;
		_tmp3_ = wrapper;
		g_signal_parse_name ("changed", GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _granite_widgets_source_list_data_model_on_item_prop_changed_granite_widgets_source_list_data_model_item_monitor_changed, self);
	}
	_tmp5_ = self->priv->monitors;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, item, NULL);
	_granite_widgets_source_list_data_model_item_monitor_unref0 (wrapper);
}

static void
_granite_widgets_source_list_data_model_on_item_child_added_granite_widgets_source_list_expandable_item_child_added (GraniteWidgetsSourceListExpandableItem* _sender,
                                                                                                                     GraniteWidgetsSourceListItem* item,
                                                                                                                     gpointer self)
{
	granite_widgets_source_list_data_model_on_item_child_added ((GraniteWidgetsSourceListDataModel*) self, item);
}

static void
_granite_widgets_source_list_data_model_on_item_child_removed_granite_widgets_source_list_expandable_item_child_removed (GraniteWidgetsSourceListExpandableItem* _sender,
                                                                                                                         GraniteWidgetsSourceListItem* item,
                                                                                                                         gpointer self)
{
	granite_widgets_source_list_data_model_on_item_child_removed ((GraniteWidgetsSourceListDataModel*) self, item);
}

static void
granite_widgets_source_list_data_model_add_children_monitor (GraniteWidgetsSourceListDataModel* self,
                                                             GraniteWidgetsSourceListExpandableItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_signal_connect_object (item, "child-added", (GCallback) _granite_widgets_source_list_data_model_on_item_child_added_granite_widgets_source_list_expandable_item_child_added, self, G_CONNECT_AFTER);
	g_signal_connect_object (item, "child-removed", (GCallback) _granite_widgets_source_list_data_model_on_item_child_removed_granite_widgets_source_list_expandable_item_child_removed, self, G_CONNECT_AFTER);
}

static void
granite_widgets_source_list_data_model_remove_children_monitor (GraniteWidgetsSourceListDataModel* self,
                                                                GraniteWidgetsSourceListExpandableItem* item)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_signal_parse_name ("child-added", GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (item, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _granite_widgets_source_list_data_model_on_item_child_added_granite_widgets_source_list_expandable_item_child_added, self);
	g_signal_parse_name ("child-removed", GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (item, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _granite_widgets_source_list_data_model_on_item_child_removed_granite_widgets_source_list_expandable_item_child_removed, self);
}

static void
granite_widgets_source_list_data_model_on_item_child_added (GraniteWidgetsSourceListDataModel* self,
                                                            GraniteWidgetsSourceListItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	granite_widgets_source_list_data_model_add_item (self, item);
}

static void
granite_widgets_source_list_data_model_on_item_child_removed (GraniteWidgetsSourceListDataModel* self,
                                                              GraniteWidgetsSourceListItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	granite_widgets_source_list_data_model_remove_item (self, item);
}

static void
granite_widgets_source_list_data_model_on_item_prop_changed (GraniteWidgetsSourceListDataModel* self,
                                                             GraniteWidgetsSourceListItem* item,
                                                             const gchar* prop_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (prop_name != NULL);
	if (g_strcmp0 (prop_name, "parent") != 0) {
		granite_widgets_source_list_data_model_update_item (self, item);
	}
}

/**
         * Pushes a call to update_item() if //parent// is not //null//.
         *
         * This is needed because the visibility of categories depends on their n_children property,
         * and also because item expansion should be updated after adding or removing items.
         * If many updates are pushed, and the item has still not been updated, only one is processed.
         * This guarantees efficiency as updating a category item could trigger expensive actions.
         */
static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		GraniteWidgetsSourceListDataModel* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
___lambda80_ (Block12Data* _data12_)
{
	GraniteWidgetsSourceListDataModel* self;
	gboolean result;
	self = _data12_->self;
	if (_data12_->parent != NULL) {
		granite_widgets_source_list_data_model_update_item (self, (GraniteWidgetsSourceListItem*) _data12_->parent);
		g_object_set_data_full ((GObject*) _data12_->parent, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE, (gpointer) ((gintptr) FALSE), NULL);
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda80__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda80_ (self);
	return result;
}

static void
granite_widgets_source_list_data_model_push_parent_update (GraniteWidgetsSourceListDataModel* self,
                                                           GraniteWidgetsSourceListExpandableItem* parent)
{
	Block12Data* _data12_;
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	gboolean needs_update = FALSE;
	gconstpointer _tmp1_;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp2_;
	GtkTreePath* _tmp3_;
	g_return_if_fail (self != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data12_->parent);
	_data12_->parent = _tmp0_;
	if (_data12_->parent == NULL) {
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	_tmp1_ = g_object_get_data ((GObject*) _data12_->parent, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE);
	needs_update = (gboolean) ((gintptr) _tmp1_);
	if (needs_update) {
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	_tmp2_ = granite_widgets_source_list_data_model_get_item_path (self, (GraniteWidgetsSourceListItem*) _data12_->parent);
	path = _tmp2_;
	_tmp3_ = path;
	if (_tmp3_ != NULL) {
		g_object_set_data_full ((GObject*) _data12_->parent, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE, (gpointer) ((gintptr) TRUE), NULL);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda80__gsource_func, block12_data_ref (_data12_), block12_data_unref);
	}
	__vala_GtkTreePath_free0 (path);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

/**
         * Returns the Item pointed by iter, or null if the iter doesn't refer to a valid item.
         */
static GraniteWidgetsSourceListItem*
granite_widgets_source_list_data_model_get_item (GraniteWidgetsSourceListDataModel* self,
                                                 GtkTreeIter* iter)
{
	GraniteWidgetsSourceListItem* item = NULL;
	GtkTreeIter _tmp0_;
	GraniteWidgetsSourceListItem* _tmp1_ = NULL;
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp0_, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp1_, -1, -1);
	_g_object_unref0 (item);
	item = _tmp1_;
	result = item;
	return result;
}

/**
         * Returns the Item pointed by path, or null if the path doesn't refer to a valid item.
         */
static GraniteWidgetsSourceListItem*
granite_widgets_source_list_data_model_get_item_from_path (GraniteWidgetsSourceListDataModel* self,
                                                           GtkTreePath* path)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
	iter = _tmp0_;
	if (_tmp1_) {
		GtkTreeIter _tmp2_;
		GraniteWidgetsSourceListItem* _tmp3_;
		_tmp2_ = iter;
		_tmp3_ = granite_widgets_source_list_data_model_get_item (self, &_tmp2_);
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

/**
         * Returns a newly-created path pointing to the item, or null in case a valid path
         * is not found.
         */
static GtkTreePath*
granite_widgets_source_list_data_model_get_item_path (GraniteWidgetsSourceListDataModel* self,
                                                      GraniteWidgetsSourceListItem* item)
{
	GtkTreePath* path = NULL;
	GtkTreePath* child_path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	path = NULL;
	_tmp0_ = granite_widgets_source_list_data_model_get_item_child_path (self, item);
	child_path = _tmp0_;
	_tmp1_ = child_path;
	if (_tmp1_ != NULL) {
		GtkTreePath* _tmp2_;
		GtkTreePath* _tmp3_;
		_tmp2_ = child_path;
		_tmp3_ = gtk_tree_model_filter_convert_child_path_to_path ((GtkTreeModelFilter*) self, _tmp2_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp3_;
	}
	result = path;
	__vala_GtkTreePath_free0 (child_path);
	return result;
}

/**
         * Returns a newly-created iterator pointing to the item, or null in case a valid iter
         * was not found.
         */
static GtkTreeIter*
granite_widgets_source_list_data_model_get_item_iter (GraniteWidgetsSourceListDataModel* self,
                                                      GraniteWidgetsSourceListItem* item)
{
	GtkTreeIter* child_iter = NULL;
	GtkTreeIter* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = granite_widgets_source_list_data_model_get_item_child_iter (self, item);
	child_iter = _tmp0_;
	_tmp1_ = child_iter;
	if (_tmp1_ != NULL) {
		GtkTreeIter iter = {0};
		GtkTreeIter* _tmp2_;
		GtkTreeIter _tmp3_ = {0};
		GtkTreeIter _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = child_iter;
		_tmp4_ = *_tmp2_;
		_tmp5_ = gtk_tree_model_filter_convert_child_iter_to_iter ((GtkTreeModelFilter*) self, &_tmp3_, &_tmp4_);
		iter = _tmp3_;
		if (_tmp5_) {
			GtkTreeIter* _tmp6_;
			_tmp6_ = __vala_GtkTreeIter_copy0 (&iter);
			result = _tmp6_;
			__vala_GtkTreeIter_free0 (child_iter);
			return result;
		}
	}
	result = NULL;
	__vala_GtkTreeIter_free0 (child_iter);
	return result;
}

/**
         * External "extra" filter method.
         */
static void
granite_widgets_source_list_data_model_set_filter_func (GraniteWidgetsSourceListDataModel* self,
                                                        GraniteWidgetsSourceListVisibleFunc visible_func,
                                                        gpointer visible_func_target)
{
	g_return_if_fail (self != NULL);
	self->priv->filter_func = visible_func;
	self->priv->filter_func_target = visible_func_target;
}

/**
         * Checks whether an item is a category (i.e. a root-level expandable item).
         * The caller must pass an iter or path pointing to the item, but not both
         * (one of them must be null.)
         *
         * TODO: instead of checking the position of the iter or path, we should simply
         * check whether the item's parent is the root item and whether the item is
         * expandable. We don't do so right now because vala still allows client code
         * to access the Item.parent property, even though its setter is defined as internal.
         */
static gboolean
granite_widgets_source_list_data_model_is_category (GraniteWidgetsSourceListDataModel* self,
                                                    GraniteWidgetsSourceListItem* item,
                                                    GtkTreeIter* iter,
                                                    GtkTreePath* path)
{
	gboolean is_category = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	is_category = FALSE;
	if (GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (item)) {
		if (iter != NULL) {
			GtkTreeIter _tmp0_;
			_vala_assert (path == NULL, "path == null");
			_tmp0_ = *iter;
			is_category = granite_widgets_source_list_data_model_is_iter_at_root_level (self, &_tmp0_);
		} else {
			_vala_assert (iter == NULL, "iter == null");
			is_category = granite_widgets_source_list_data_model_is_path_at_root_level (self, path);
		}
	}
	result = is_category;
	return result;
}

static gboolean
granite_widgets_source_list_data_model_is_iter_at_root_level (GraniteWidgetsSourceListDataModel* self,
                                                              GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = granite_widgets_source_list_data_model_is_path_at_root_level (self, _tmp2_);
	__vala_GtkTreePath_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
granite_widgets_source_list_data_model_is_path_at_root_level (GraniteWidgetsSourceListDataModel* self,
                                                              GtkTreePath* path)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	result = gtk_tree_path_get_depth (path) == 1;
	return result;
}

static void
granite_widgets_source_list_data_model_resort (GraniteWidgetsSourceListDataModel* self)
{
	GtkTreeStore* _tmp0_;
	GtkTreeStore* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->child_tree;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp0_, GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID, GTK_SORT_ASCENDING);
	_tmp1_ = self->priv->child_tree;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp1_, GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, GTK_SORT_ASCENDING);
}

static gint
granite_widgets_source_list_data_model_child_model_sort_func (GraniteWidgetsSourceListDataModel* self,
                                                              GtkTreeModel* model,
                                                              GtkTreeIter* a,
                                                              GtkTreeIter* b)
{
	gint order = 0;
	GraniteWidgetsSourceListItem* item_a = NULL;
	GraniteWidgetsSourceListItem* item_b = NULL;
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_ = NULL;
	GtkTreeStore* _tmp3_;
	GtkTreeIter _tmp4_;
	GraniteWidgetsSourceListItem* _tmp5_ = NULL;
	GraniteWidgetsSourceListItem* _tmp6_;
	GraniteWidgetsSourceListExpandableItem* _tmp7_;
	GraniteWidgetsSourceListExpandableItem* _tmp8_;
	GraniteWidgetsSourceListItem* _tmp9_;
	GraniteWidgetsSourceListExpandableItem* _tmp10_;
	GraniteWidgetsSourceListExpandableItem* _tmp11_;
	GraniteWidgetsSourceListSortable* parent = NULL;
	GraniteWidgetsSourceListItem* _tmp12_;
	GraniteWidgetsSourceListExpandableItem* _tmp13_;
	GraniteWidgetsSourceListExpandableItem* _tmp14_;
	GraniteWidgetsSourceListSortable* _tmp15_;
	GraniteWidgetsSourceListSortable* _tmp16_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	order = 0;
	_tmp0_ = self->priv->child_tree;
	_tmp1_ = *a;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp2_, -1, -1);
	_g_object_unref0 (item_a);
	item_a = _tmp2_;
	_tmp3_ = self->priv->child_tree;
	_tmp4_ = *b;
	gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp5_, -1, -1);
	_g_object_unref0 (item_b);
	item_b = _tmp5_;
	_tmp6_ = item_a;
	_tmp7_ = granite_widgets_source_list_item_get_parent (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = item_b;
	_tmp10_ = granite_widgets_source_list_item_get_parent (_tmp9_);
	_tmp11_ = _tmp10_;
	_vala_assert (_tmp8_ == _tmp11_, "item_a.parent == item_b.parent");
	_tmp12_ = item_a;
	_tmp13_ = granite_widgets_source_list_item_get_parent (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (GRANITE_WIDGETS_IS_SOURCE_LIST_SORTABLE (_tmp14_) ? ((GraniteWidgetsSourceListSortable*) _tmp14_) : NULL);
	parent = _tmp15_;
	_tmp16_ = parent;
	if (_tmp16_ != NULL) {
		GraniteWidgetsSourceListSortable* _tmp17_;
		GraniteWidgetsSourceListItem* _tmp18_;
		GraniteWidgetsSourceListItem* _tmp19_;
		_tmp17_ = parent;
		_tmp18_ = item_a;
		_tmp19_ = item_b;
		order = granite_widgets_source_list_sortable_compare (_tmp17_, _tmp18_, _tmp19_);
	}
	result = order;
	_g_object_unref0 (parent);
	_g_object_unref0 (item_b);
	_g_object_unref0 (item_a);
	return result;
}

static GtkTreeIter*
granite_widgets_source_list_data_model_get_item_child_iter (GraniteWidgetsSourceListDataModel* self,
                                                            GraniteWidgetsSourceListItem* item)
{
	GtkTreeIter* child_iter = NULL;
	GraniteWidgetsSourceListDataModelNodeWrapper* child_node_wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GraniteWidgetsSourceListDataModelNodeWrapper* _tmp2_;
	GtkTreeIter* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	child_iter = NULL;
	_tmp0_ = self->priv->items;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, item);
	child_node_wrapper = (GraniteWidgetsSourceListDataModelNodeWrapper*) _tmp1_;
	_tmp2_ = child_node_wrapper;
	if (_tmp2_ != NULL) {
		GraniteWidgetsSourceListDataModelNodeWrapper* _tmp3_;
		GtkTreeIter* _tmp4_;
		GtkTreeIter* _tmp5_;
		_tmp3_ = child_node_wrapper;
		_tmp4_ = granite_widgets_source_list_data_model_node_wrapper_get_iter (_tmp3_);
		_tmp5_ = _tmp4_;
		__vala_GtkTreeIter_free0 (child_iter);
		child_iter = _tmp5_;
	}
	result = child_iter;
	_granite_widgets_source_list_data_model_node_wrapper_unref0 (child_node_wrapper);
	return result;
}

static GtkTreePath*
granite_widgets_source_list_data_model_get_item_child_path (GraniteWidgetsSourceListDataModel* self,
                                                            GraniteWidgetsSourceListItem* item)
{
	GtkTreePath* child_path = NULL;
	GraniteWidgetsSourceListDataModelNodeWrapper* child_node_wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GraniteWidgetsSourceListDataModelNodeWrapper* _tmp2_;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	child_path = NULL;
	_tmp0_ = self->priv->items;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, item);
	child_node_wrapper = (GraniteWidgetsSourceListDataModelNodeWrapper*) _tmp1_;
	_tmp2_ = child_node_wrapper;
	if (_tmp2_ != NULL) {
		GraniteWidgetsSourceListDataModelNodeWrapper* _tmp3_;
		GtkTreePath* _tmp4_;
		GtkTreePath* _tmp5_;
		_tmp3_ = child_node_wrapper;
		_tmp4_ = granite_widgets_source_list_data_model_node_wrapper_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		__vala_GtkTreePath_free0 (child_path);
		child_path = _tmp5_;
	}
	result = child_path;
	_granite_widgets_source_list_data_model_node_wrapper_unref0 (child_node_wrapper);
	return result;
}

/**
         * Filters the child-tree items based on their "visible" property.
         */
static gboolean
granite_widgets_source_list_data_model_filter_visible_func (GraniteWidgetsSourceListDataModel* self,
                                                            GtkTreeModel* child_model,
                                                            GtkTreeIter* iter)
{
	gboolean item_visible = FALSE;
	GraniteWidgetsSourceListItem* item = NULL;
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_ = NULL;
	GraniteWidgetsSourceListItem* _tmp3_;
	GraniteWidgetsSourceListVisibleFunc _tmp27_;
	gpointer _tmp27__target;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (child_model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	item_visible = FALSE;
	_tmp0_ = self->priv->child_tree;
	_tmp1_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp2_, -1, -1);
	_g_object_unref0 (item);
	item = _tmp2_;
	_tmp3_ = item;
	if (_tmp3_ != NULL) {
		GraniteWidgetsSourceListItem* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		GraniteWidgetsSourceListExpandableItem* expandable = NULL;
		GraniteWidgetsSourceListItem* _tmp7_;
		GraniteWidgetsSourceListExpandableItem* _tmp8_;
		gboolean _tmp9_ = FALSE;
		GraniteWidgetsSourceListExpandableItem* _tmp10_;
		_tmp4_ = item;
		_tmp5_ = granite_widgets_source_list_item_get_visible (_tmp4_);
		_tmp6_ = _tmp5_;
		item_visible = _tmp6_;
		_tmp7_ = item;
		_tmp8_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp7_) ? ((GraniteWidgetsSourceListExpandableItem*) _tmp7_) : NULL);
		expandable = _tmp8_;
		_tmp10_ = expandable;
		if (_tmp10_ != NULL) {
			GtkTreeStore* _tmp11_;
			GtkTreeIter _tmp12_;
			_tmp11_ = self->priv->child_tree;
			_tmp12_ = *iter;
			_tmp9_ = gtk_tree_store_iter_depth (_tmp11_, &_tmp12_) == 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			guint n_visible_children = 0U;
			gboolean _tmp26_ = FALSE;
			n_visible_children = (guint) 0;
			{
				GeeIterator* _child_item_it = NULL;
				GraniteWidgetsSourceListExpandableItem* _tmp13_;
				GeeCollection* _tmp14_;
				GeeCollection* _tmp15_;
				GeeCollection* _tmp16_;
				GeeIterator* _tmp17_;
				GeeIterator* _tmp18_;
				_tmp13_ = expandable;
				_tmp14_ = granite_widgets_source_list_expandable_item_get_children (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
				_tmp18_ = _tmp17_;
				_g_object_unref0 (_tmp16_);
				_child_item_it = _tmp18_;
				while (TRUE) {
					GeeIterator* _tmp19_;
					GraniteWidgetsSourceListItem* child_item = NULL;
					GeeIterator* _tmp20_;
					gpointer _tmp21_;
					GraniteWidgetsSourceListItem* _tmp22_;
					gboolean _tmp23_;
					gboolean _tmp24_;
					_tmp19_ = _child_item_it;
					if (!gee_iterator_next (_tmp19_)) {
						break;
					}
					_tmp20_ = _child_item_it;
					_tmp21_ = gee_iterator_get (_tmp20_);
					child_item = (GraniteWidgetsSourceListItem*) _tmp21_;
					_tmp22_ = child_item;
					_tmp23_ = granite_widgets_source_list_item_get_visible (_tmp22_);
					_tmp24_ = _tmp23_;
					if (_tmp24_) {
						guint _tmp25_;
						_tmp25_ = n_visible_children;
						n_visible_children = _tmp25_ + 1;
					}
					_g_object_unref0 (child_item);
				}
				_g_object_unref0 (_child_item_it);
			}
			if (item_visible) {
				_tmp26_ = n_visible_children > ((guint) 0);
			} else {
				_tmp26_ = FALSE;
			}
			item_visible = _tmp26_;
		}
		_g_object_unref0 (expandable);
	}
	_tmp27_ = self->priv->filter_func;
	_tmp27__target = self->priv->filter_func_target;
	if (_tmp27_ != NULL) {
		gboolean _tmp28_ = FALSE;
		if (item_visible) {
			GraniteWidgetsSourceListVisibleFunc _tmp29_;
			gpointer _tmp29__target;
			GraniteWidgetsSourceListItem* _tmp30_;
			_tmp29_ = self->priv->filter_func;
			_tmp29__target = self->priv->filter_func_target;
			_tmp30_ = item;
			_tmp28_ = _tmp29_ (_tmp30_, _tmp29__target);
		} else {
			_tmp28_ = FALSE;
		}
		item_visible = _tmp28_;
	}
	result = item_visible;
	_g_object_unref0 (item);
	return result;
}

/**
         * TreeDragDest implementation
         */
static gboolean
granite_widgets_source_list_data_model_real_drag_data_received (GtkTreeDragDest* base,
                                                                GtkTreePath* dest,
                                                                GtkSelectionData* selection_data)
{
	GraniteWidgetsSourceListDataModel * self;
	GtkTreeModel* model = NULL;
	GtkTreePath* src_path = NULL;
	gboolean _tmp0_ = FALSE;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	gboolean _tmp3_;
	GtkTreeModel* _tmp4_;
	gboolean result;
	self = (GraniteWidgetsSourceListDataModel*) base;
	g_return_val_if_fail (dest != NULL, FALSE);
	g_return_val_if_fail (selection_data != NULL, FALSE);
	_tmp3_ = gtk_tree_get_row_drag_data (selection_data, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	__vala_GtkTreePath_free0 (src_path);
	src_path = _tmp2_;
	if (_tmp3_) {
		GtkTreeModel* _tmp5_;
		GtkTreeStore* _tmp6_;
		_tmp5_ = model;
		_tmp6_ = self->priv->child_tree;
		_tmp0_ = _tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_model_get_type (), GtkTreeModel);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTreePath* child_dest = NULL;
		GtkTreePath* _tmp7_;
		GtkTreePath* _tmp8_;
		_tmp7_ = gtk_tree_model_filter_convert_path_to_child_path ((GtkTreeModelFilter*) self, dest);
		child_dest = _tmp7_;
		_tmp8_ = child_dest;
		if (_tmp8_ != NULL) {
			GtkTreePath* _tmp9_;
			GtkTreePath* _tmp10_;
			_tmp9_ = child_dest;
			_tmp10_ = src_path;
			if (granite_widgets_source_list_data_model_child_tree_drag_data_received (self, _tmp9_, _tmp10_)) {
				result = TRUE;
				__vala_GtkTreePath_free0 (child_dest);
				__vala_GtkTreePath_free0 (src_path);
				_g_object_unref0 (model);
				return result;
			}
		}
		__vala_GtkTreePath_free0 (child_dest);
	}
	result = FALSE;
	__vala_GtkTreePath_free0 (src_path);
	_g_object_unref0 (model);
	return result;
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static gboolean
granite_widgets_source_list_data_model_child_tree_drag_data_received (GraniteWidgetsSourceListDataModel* self,
                                                                      GtkTreePath* dest,
                                                                      GtkTreePath* src_path)
{
	gboolean retval = FALSE;
	GtkTreeIter src_iter = {0};
	GtkTreeIter dest_iter = {0};
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTreePath* prev = NULL;
	GtkTreePath* _tmp3_;
	GtkTreePath* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	g_return_val_if_fail (src_path != NULL, FALSE);
	retval = FALSE;
	_tmp0_ = self->priv->child_tree;
	_tmp2_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp0_, &_tmp1_, src_path);
	src_iter = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = __vala_GtkTreePath_copy0 (dest);
	prev = _tmp3_;
	_tmp4_ = prev;
	if (!gtk_tree_path_prev (_tmp4_)) {
		GtkTreePath* parent = NULL;
		GtkTreePath* _tmp5_;
		GtkTreeIter* dest_parent = NULL;
		gboolean _tmp6_ = FALSE;
		GtkTreePath* _tmp7_;
		GtkTreeStore* _tmp14_;
		GtkTreeIter* _tmp15_;
		GtkTreeIter _tmp16_ = {0};
		_tmp5_ = __vala_GtkTreePath_copy0 (dest);
		parent = _tmp5_;
		dest_parent = NULL;
		_tmp7_ = parent;
		if (gtk_tree_path_up (_tmp7_)) {
			GtkTreePath* _tmp8_;
			_tmp8_ = parent;
			_tmp6_ = gtk_tree_path_get_depth (_tmp8_) > 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GtkTreeStore* _tmp9_;
			GtkTreePath* _tmp10_;
			GtkTreeIter _tmp11_ = {0};
			GtkTreeIter _tmp12_;
			GtkTreeIter* _tmp13_;
			_tmp9_ = self->priv->child_tree;
			_tmp10_ = parent;
			gtk_tree_model_get_iter ((GtkTreeModel*) _tmp9_, &_tmp11_, _tmp10_);
			__vala_GtkTreeIter_free0 (dest_parent);
			_tmp12_ = _tmp11_;
			_tmp13_ = __vala_GtkTreeIter_copy0 (&_tmp12_);
			dest_parent = _tmp13_;
		}
		_tmp14_ = self->priv->child_tree;
		_tmp15_ = dest_parent;
		gtk_tree_store_prepend (_tmp14_, &_tmp16_, _tmp15_);
		dest_iter = _tmp16_;
		retval = TRUE;
		__vala_GtkTreeIter_free0 (dest_parent);
		__vala_GtkTreePath_free0 (parent);
	} else {
		GtkTreeStore* _tmp17_;
		GtkTreePath* _tmp18_;
		GtkTreeIter _tmp19_ = {0};
		gboolean _tmp20_;
		_tmp17_ = self->priv->child_tree;
		_tmp18_ = prev;
		_tmp20_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp17_, &_tmp19_, _tmp18_);
		dest_iter = _tmp19_;
		if (_tmp20_) {
			GtkTreeIter tmp_iter = {0};
			GtkTreeIter _tmp21_;
			GtkTreeStore* _tmp22_;
			GtkTreeIter _tmp23_;
			GtkTreeIter _tmp24_ = {0};
			_tmp21_ = dest_iter;
			tmp_iter = _tmp21_;
			_tmp22_ = self->priv->child_tree;
			_tmp23_ = tmp_iter;
			gtk_tree_store_insert_after (_tmp22_, &_tmp24_, NULL, &_tmp23_);
			dest_iter = _tmp24_;
			retval = TRUE;
		}
	}
	if (retval) {
		GtkTreeIter _tmp25_;
		GtkTreeIter _tmp26_;
		GraniteWidgetsSourceListItem* item = NULL;
		GtkTreeStore* _tmp27_;
		GtkTreeIter _tmp28_;
		GraniteWidgetsSourceListItem* _tmp29_ = NULL;
		GraniteWidgetsSourceListItem* _tmp30_;
		GraniteWidgetsSourceListItem* _tmp31_;
		GraniteWidgetsSourceListSortable* parent = NULL;
		GraniteWidgetsSourceListItem* _tmp32_;
		GraniteWidgetsSourceListExpandableItem* _tmp33_;
		GraniteWidgetsSourceListExpandableItem* _tmp34_;
		GraniteWidgetsSourceListSortable* _tmp35_;
		GraniteWidgetsSourceListSortable* _tmp36_;
		GraniteWidgetsSourceListSortable* _tmp37_;
		GraniteWidgetsSourceListItem* _tmp38_;
		_tmp25_ = src_iter;
		_tmp26_ = dest_iter;
		granite_widgets_source_list_data_model_recursive_node_copy (self, &_tmp25_, &_tmp26_);
		_tmp27_ = self->priv->child_tree;
		_tmp28_ = src_iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp27_, &_tmp28_, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp29_, -1, -1);
		_g_object_unref0 (item);
		item = _tmp29_;
		_tmp30_ = item;
		g_return_val_if_fail (_tmp30_ != NULL, retval);
		_tmp31_ = item;
		granite_widgets_source_list_data_model_update_item (self, _tmp31_);
		_tmp32_ = item;
		_tmp33_ = granite_widgets_source_list_item_get_parent (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = _g_object_ref0 (GRANITE_WIDGETS_IS_SOURCE_LIST_SORTABLE (_tmp34_) ? ((GraniteWidgetsSourceListSortable*) _tmp34_) : NULL);
		parent = _tmp35_;
		_tmp36_ = parent;
		g_return_val_if_fail (_tmp36_ != NULL, retval);
		_tmp37_ = parent;
		_tmp38_ = item;
		g_signal_emit (_tmp37_, granite_widgets_source_list_sortable_signals[GRANITE_WIDGETS_SOURCE_LIST_SORTABLE_USER_MOVED_ITEM_SIGNAL], 0, _tmp38_);
		_g_object_unref0 (parent);
		_g_object_unref0 (item);
	}
	result = retval;
	__vala_GtkTreePath_free0 (prev);
	return result;
}

static void
granite_widgets_source_list_data_model_recursive_node_copy (GraniteWidgetsSourceListDataModel* self,
                                                            GtkTreeIter* src_iter,
                                                            GtkTreeIter* dest_iter)
{
	GtkTreeIter _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeIter child = {0};
	GtkTreeStore* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src_iter != NULL);
	g_return_if_fail (dest_iter != NULL);
	_tmp0_ = *src_iter;
	_tmp1_ = *dest_iter;
	granite_widgets_source_list_data_model_move_item (self, &_tmp0_, &_tmp1_);
	_tmp2_ = self->priv->child_tree;
	_tmp3_ = *src_iter;
	_tmp5_ = gtk_tree_model_iter_children ((GtkTreeModel*) _tmp2_, &_tmp4_, &_tmp3_);
	child = _tmp4_;
	if (_tmp5_) {
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GtkTreeIter copy = {0};
				GtkTreeStore* _tmp9_;
				GtkTreeIter _tmp10_;
				GtkTreeIter _tmp11_ = {0};
				GtkTreeIter _tmp12_;
				GtkTreeIter _tmp13_;
				if (!_tmp6_) {
					GtkTreeStore* _tmp7_;
					gboolean _tmp8_;
					_tmp7_ = self->priv->child_tree;
					_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &child);
					if (!_tmp8_) {
						break;
					}
				}
				_tmp6_ = FALSE;
				_tmp9_ = self->priv->child_tree;
				_tmp10_ = *dest_iter;
				gtk_tree_store_append (_tmp9_, &_tmp11_, &_tmp10_);
				copy = _tmp11_;
				_tmp12_ = child;
				_tmp13_ = copy;
				granite_widgets_source_list_data_model_recursive_node_copy (self, &_tmp12_, &_tmp13_);
			}
		}
	}
}

static void
granite_widgets_source_list_data_model_move_item (GraniteWidgetsSourceListDataModel* self,
                                                  GtkTreeIter* src_iter,
                                                  GtkTreeIter* dest_iter)
{
	GraniteWidgetsSourceListItem* item = NULL;
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_ = NULL;
	GtkTreeStore* _tmp3_;
	GtkTreeIter _tmp4_;
	GeeHashMap* _tmp5_;
	GtkTreeStore* _tmp6_;
	GtkTreeIter _tmp7_;
	GraniteWidgetsSourceListDataModelNodeWrapper* _tmp8_;
	GraniteWidgetsSourceListDataModelNodeWrapper* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src_iter != NULL);
	g_return_if_fail (dest_iter != NULL);
	_tmp0_ = self->priv->child_tree;
	_tmp1_ = *src_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, &_tmp2_, -1, -1);
	_g_object_unref0 (item);
	item = _tmp2_;
	g_return_if_fail (item != NULL);
	_tmp3_ = self->priv->child_tree;
	_tmp4_ = *dest_iter;
	gtk_tree_store_set (_tmp3_, &_tmp4_, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM, item, -1, -1);
	_tmp5_ = self->priv->items;
	_tmp6_ = self->priv->child_tree;
	_tmp7_ = *dest_iter;
	_tmp8_ = granite_widgets_source_list_data_model_node_wrapper_new ((GtkTreeModel*) _tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, item, _tmp9_);
	_granite_widgets_source_list_data_model_node_wrapper_unref0 (_tmp9_);
	_g_object_unref0 (item);
}

static gint*
_vala_array_dup1 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gint*
_vala_array_dup2 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gboolean
granite_widgets_source_list_data_model_real_row_drop_possible (GtkTreeDragDest* base,
                                                               GtkTreePath* dest,
                                                               GtkSelectionData* selection_data)
{
	GraniteWidgetsSourceListDataModel * self;
	GtkTreeModel* model = NULL;
	GtkTreePath* src_path = NULL;
	gboolean _tmp0_ = FALSE;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	gboolean _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreePath* child_dest = NULL;
	GtkTreePath* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GtkTreePath* _tmp9_;
	gint src_depth = 0;
	GtkTreePath* _tmp12_;
	gint dest_depth = 0;
	GtkTreePath* _tmp13_;
	GraniteWidgetsSourceListItem* parent = NULL;
	GraniteWidgetsSourceListSortable* sortable = NULL;
	GraniteWidgetsSourceListItem* _tmp35_;
	GraniteWidgetsSourceListSortable* _tmp36_;
	gboolean _tmp37_ = FALSE;
	GraniteWidgetsSourceListSortable* _tmp38_;
	GraniteWidgetsSourceListItem* dest_item = NULL;
	GraniteWidgetsSourceListItem* _tmp40_;
	GraniteWidgetsSourceListItem* _tmp41_;
	GraniteWidgetsSourceListItem* source_item = NULL;
	GtkTreePath* filter_src_path = NULL;
	GtkTreePath* _tmp42_;
	GtkTreePath* _tmp43_;
	GtkTreePath* _tmp44_;
	GraniteWidgetsSourceListItem* _tmp47_;
	GraniteWidgetsSourceListSortable* _tmp48_;
	GraniteWidgetsSourceListItem* _tmp49_;
	GraniteWidgetsSourceListItem* _tmp50_;
	gboolean result;
	self = (GraniteWidgetsSourceListDataModel*) base;
	g_return_val_if_fail (dest != NULL, FALSE);
	g_return_val_if_fail (selection_data != NULL, FALSE);
	_tmp3_ = gtk_tree_get_row_drag_data (selection_data, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	__vala_GtkTreePath_free0 (src_path);
	src_path = _tmp2_;
	if (!_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GtkTreeModel* _tmp5_;
		GtkTreeStore* _tmp6_;
		_tmp5_ = model;
		_tmp6_ = self->priv->child_tree;
		_tmp0_ = _tmp5_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_model_get_type (), GtkTreeModel);
	}
	if (_tmp0_) {
		result = FALSE;
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	_tmp7_ = gtk_tree_model_filter_convert_path_to_child_path ((GtkTreeModelFilter*) self, dest);
	child_dest = _tmp7_;
	_tmp9_ = child_dest;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		GtkTreePath* _tmp10_;
		GtkTreePath* _tmp11_;
		_tmp10_ = src_path;
		_tmp11_ = child_dest;
		_tmp8_ = gtk_tree_path_compare (_tmp10_, _tmp11_) == 0;
	}
	if (_tmp8_) {
		result = FALSE;
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	_tmp12_ = src_path;
	src_depth = gtk_tree_path_get_depth (_tmp12_);
	_tmp13_ = child_dest;
	dest_depth = gtk_tree_path_get_depth (_tmp13_);
	if (src_depth != dest_depth) {
		result = FALSE;
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	if (src_depth < 1) {
		result = FALSE;
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	parent = NULL;
	if (src_depth == 1) {
		GraniteWidgetsSourceListExpandableItem* _tmp14_;
		GraniteWidgetsSourceListExpandableItem* _tmp15_;
		GraniteWidgetsSourceListItem* _tmp16_;
		_tmp14_ = granite_widgets_source_list_data_model_get_root (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 ((GraniteWidgetsSourceListItem*) _tmp15_);
		_g_object_unref0 (parent);
		parent = _tmp16_;
	} else {
		gint* src_indices = NULL;
		GtkTreePath* _tmp17_;
		gint _tmp18_ = 0;
		gint* _tmp19_;
		gint* _tmp20_;
		gint _tmp20__length1;
		gint src_indices_length1;
		gint _src_indices_size_;
		gint* dest_indices = NULL;
		GtkTreePath* _tmp21_;
		gint _tmp22_ = 0;
		gint* _tmp23_;
		gint* _tmp24_;
		gint _tmp24__length1;
		gint dest_indices_length1;
		gint _dest_indices_size_;
		gint src_parent_index = 0;
		gint* _tmp25_;
		gint _tmp25__length1;
		gint _tmp26_;
		gint dest_parent_index = 0;
		gint* _tmp27_;
		gint _tmp27__length1;
		gint _tmp28_;
		GtkTreePath* dest_parent = NULL;
		GtkTreePath* _tmp29_;
		gboolean _tmp30_ = FALSE;
		GtkTreePath* _tmp31_;
		GtkTreePath* _tmp33_;
		GraniteWidgetsSourceListItem* _tmp34_;
		_vala_assert (dest_depth > 1, "dest_depth > 1");
		_tmp17_ = src_path;
		_tmp19_ = gtk_tree_path_get_indices_with_depth (_tmp17_, &_tmp18_);
		_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup1 (_tmp19_, _tmp18_) : _tmp19_;
		_tmp20__length1 = _tmp18_;
		src_indices = _tmp20_;
		src_indices_length1 = _tmp20__length1;
		_src_indices_size_ = src_indices_length1;
		_tmp21_ = child_dest;
		_tmp23_ = gtk_tree_path_get_indices_with_depth (_tmp21_, &_tmp22_);
		_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup2 (_tmp23_, _tmp22_) : _tmp23_;
		_tmp24__length1 = _tmp22_;
		dest_indices = _tmp24_;
		dest_indices_length1 = _tmp24__length1;
		_dest_indices_size_ = dest_indices_length1;
		_tmp25_ = src_indices;
		_tmp25__length1 = src_indices_length1;
		_tmp26_ = _tmp25_[src_depth - 2];
		src_parent_index = _tmp26_;
		_tmp27_ = dest_indices;
		_tmp27__length1 = dest_indices_length1;
		_tmp28_ = _tmp27_[dest_depth - 2];
		dest_parent_index = _tmp28_;
		if (src_parent_index != dest_parent_index) {
			result = FALSE;
			dest_indices = (g_free (dest_indices), NULL);
			src_indices = (g_free (src_indices), NULL);
			_g_object_unref0 (parent);
			__vala_GtkTreePath_free0 (child_dest);
			__vala_GtkTreePath_free0 (src_path);
			_g_object_unref0 (model);
			return result;
		}
		_tmp29_ = __vala_GtkTreePath_copy0 (dest);
		dest_parent = _tmp29_;
		_tmp31_ = dest_parent;
		if (!gtk_tree_path_up (_tmp31_)) {
			_tmp30_ = TRUE;
		} else {
			GtkTreePath* _tmp32_;
			_tmp32_ = dest_parent;
			_tmp30_ = gtk_tree_path_get_depth (_tmp32_) < 1;
		}
		if (_tmp30_) {
			result = FALSE;
			__vala_GtkTreePath_free0 (dest_parent);
			dest_indices = (g_free (dest_indices), NULL);
			src_indices = (g_free (src_indices), NULL);
			_g_object_unref0 (parent);
			__vala_GtkTreePath_free0 (child_dest);
			__vala_GtkTreePath_free0 (src_path);
			_g_object_unref0 (model);
			return result;
		}
		_tmp33_ = dest_parent;
		_tmp34_ = granite_widgets_source_list_data_model_get_item_from_path (self, _tmp33_);
		_g_object_unref0 (parent);
		parent = _tmp34_;
		__vala_GtkTreePath_free0 (dest_parent);
		dest_indices = (g_free (dest_indices), NULL);
		src_indices = (g_free (src_indices), NULL);
	}
	_tmp35_ = parent;
	_tmp36_ = _g_object_ref0 (GRANITE_WIDGETS_IS_SOURCE_LIST_SORTABLE (_tmp35_) ? ((GraniteWidgetsSourceListSortable*) _tmp35_) : NULL);
	sortable = _tmp36_;
	_tmp38_ = sortable;
	if (_tmp38_ == NULL) {
		_tmp37_ = TRUE;
	} else {
		GraniteWidgetsSourceListSortable* _tmp39_;
		_tmp39_ = sortable;
		_tmp37_ = !granite_widgets_source_list_sortable_allow_dnd_sorting (_tmp39_);
	}
	if (_tmp37_) {
		result = FALSE;
		_g_object_unref0 (sortable);
		_g_object_unref0 (parent);
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	_tmp40_ = granite_widgets_source_list_data_model_get_item_from_path (self, dest);
	dest_item = _tmp40_;
	_tmp41_ = dest_item;
	if (_tmp41_ == NULL) {
		result = TRUE;
		_g_object_unref0 (dest_item);
		_g_object_unref0 (sortable);
		_g_object_unref0 (parent);
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	source_item = NULL;
	_tmp42_ = src_path;
	_tmp43_ = gtk_tree_model_filter_convert_child_path_to_path ((GtkTreeModelFilter*) self, _tmp42_);
	filter_src_path = _tmp43_;
	_tmp44_ = filter_src_path;
	if (_tmp44_ != NULL) {
		GtkTreePath* _tmp45_;
		GraniteWidgetsSourceListItem* _tmp46_;
		_tmp45_ = filter_src_path;
		_tmp46_ = granite_widgets_source_list_data_model_get_item_from_path (self, _tmp45_);
		_g_object_unref0 (source_item);
		source_item = _tmp46_;
	}
	_tmp47_ = source_item;
	if (_tmp47_ == NULL) {
		result = FALSE;
		__vala_GtkTreePath_free0 (filter_src_path);
		_g_object_unref0 (source_item);
		_g_object_unref0 (dest_item);
		_g_object_unref0 (sortable);
		_g_object_unref0 (parent);
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	_tmp48_ = sortable;
	_tmp49_ = dest_item;
	_tmp50_ = source_item;
	if (granite_widgets_source_list_sortable_compare (_tmp48_, _tmp49_, _tmp50_) >= 0) {
		GraniteWidgetsSourceListItem* dest_item_prev = NULL;
		GraniteWidgetsSourceListItem* _tmp51_;
		gboolean _tmp52_ = FALSE;
		gboolean _tmp53_ = FALSE;
		GraniteWidgetsSourceListItem* _tmp54_;
		if (!gtk_tree_path_prev (dest)) {
			result = TRUE;
			__vala_GtkTreePath_free0 (filter_src_path);
			_g_object_unref0 (source_item);
			_g_object_unref0 (dest_item);
			_g_object_unref0 (sortable);
			_g_object_unref0 (parent);
			__vala_GtkTreePath_free0 (child_dest);
			__vala_GtkTreePath_free0 (src_path);
			_g_object_unref0 (model);
			return result;
		}
		_tmp51_ = granite_widgets_source_list_data_model_get_item_from_path (self, dest);
		dest_item_prev = _tmp51_;
		_tmp54_ = dest_item_prev;
		if (_tmp54_ != NULL) {
			GraniteWidgetsSourceListItem* _tmp55_;
			GraniteWidgetsSourceListItem* _tmp56_;
			_tmp55_ = dest_item_prev;
			_tmp56_ = source_item;
			_tmp53_ = _tmp55_ != _tmp56_;
		} else {
			_tmp53_ = FALSE;
		}
		if (_tmp53_) {
			GraniteWidgetsSourceListSortable* _tmp57_;
			GraniteWidgetsSourceListItem* _tmp58_;
			GraniteWidgetsSourceListItem* _tmp59_;
			_tmp57_ = sortable;
			_tmp58_ = dest_item_prev;
			_tmp59_ = source_item;
			_tmp52_ = granite_widgets_source_list_sortable_compare (_tmp57_, _tmp58_, _tmp59_) <= 0;
		} else {
			_tmp52_ = FALSE;
		}
		result = _tmp52_;
		_g_object_unref0 (dest_item_prev);
		__vala_GtkTreePath_free0 (filter_src_path);
		_g_object_unref0 (source_item);
		_g_object_unref0 (dest_item);
		_g_object_unref0 (sortable);
		_g_object_unref0 (parent);
		__vala_GtkTreePath_free0 (child_dest);
		__vala_GtkTreePath_free0 (src_path);
		_g_object_unref0 (model);
		return result;
	}
	result = FALSE;
	__vala_GtkTreePath_free0 (filter_src_path);
	_g_object_unref0 (source_item);
	_g_object_unref0 (dest_item);
	_g_object_unref0 (sortable);
	_g_object_unref0 (parent);
	__vala_GtkTreePath_free0 (child_dest);
	__vala_GtkTreePath_free0 (src_path);
	_g_object_unref0 (model);
	return result;
}

/**
         * Override default implementation of TreeDragSource
         *
         * drag_data_delete is not overriden because the default implementation
         * does exactly what we need.
         */
static gboolean
granite_widgets_source_list_data_model_real_drag_data_get (GtkTreeDragSource* base,
                                                           GtkTreePath* path,
                                                           GtkSelectionData* selection_data)
{
	GraniteWidgetsSourceListDataModel * self;
	GraniteWidgetsSourceListDragSource* drag_source_item = NULL;
	GraniteWidgetsSourceListItem* _tmp0_;
	GraniteWidgetsSourceListDragSource* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GraniteWidgetsSourceListDragSource* _tmp3_;
	gboolean result;
	self = (GraniteWidgetsSourceListDataModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (selection_data != NULL, FALSE);
	if (gtk_selection_data_get_target (selection_data) == gdk_atom_intern_static_string ("GTK_TREE_MODEL_ROW")) {
		result = granite_widgets_source_list_data_model_gtk_tree_drag_source_parent_iface->drag_data_get ((GtkTreeDragSource*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_filter_get_type (), GtkTreeModelFilter), path, selection_data);
		return result;
	}
	_tmp0_ = granite_widgets_source_list_data_model_get_item_from_path (self, path);
	_tmp1_ = GRANITE_WIDGETS_IS_SOURCE_LIST_DRAG_SOURCE (_tmp0_) ? ((GraniteWidgetsSourceListDragSource*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	drag_source_item = _tmp1_;
	_tmp3_ = drag_source_item;
	if (_tmp3_ != NULL) {
		GraniteWidgetsSourceListDragSource* _tmp4_;
		_tmp4_ = drag_source_item;
		_tmp2_ = granite_widgets_source_list_drag_source_draggable (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GraniteWidgetsSourceListDragSource* _tmp5_;
		_tmp5_ = drag_source_item;
		granite_widgets_source_list_drag_source_prepare_selection_data (_tmp5_, selection_data);
		result = TRUE;
		_g_object_unref0 (drag_source_item);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (drag_source_item);
	return result;
}

static gboolean
granite_widgets_source_list_data_model_real_row_draggable (GtkTreeDragSource* base,
                                                           GtkTreePath* path)
{
	GraniteWidgetsSourceListDataModel * self;
	GraniteWidgetsSourceListItem* item = NULL;
	GraniteWidgetsSourceListItem* _tmp0_;
	GraniteWidgetsSourceListItem* _tmp1_;
	gboolean result;
	self = (GraniteWidgetsSourceListDataModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	if (!granite_widgets_source_list_data_model_gtk_tree_drag_source_parent_iface->row_draggable ((GtkTreeDragSource*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_filter_get_type (), GtkTreeModelFilter), path)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = granite_widgets_source_list_data_model_get_item_from_path (self, path);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ != NULL) {
		GraniteWidgetsSourceListSortable* sortable_item = NULL;
		GraniteWidgetsSourceListItem* _tmp2_;
		GraniteWidgetsSourceListExpandableItem* _tmp3_;
		GraniteWidgetsSourceListExpandableItem* _tmp4_;
		GraniteWidgetsSourceListSortable* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GraniteWidgetsSourceListSortable* _tmp7_;
		GraniteWidgetsSourceListDragSource* drag_source_item = NULL;
		GraniteWidgetsSourceListItem* _tmp9_;
		GraniteWidgetsSourceListDragSource* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GraniteWidgetsSourceListDragSource* _tmp12_;
		_tmp2_ = item;
		_tmp3_ = granite_widgets_source_list_item_get_parent (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (GRANITE_WIDGETS_IS_SOURCE_LIST_SORTABLE (_tmp4_) ? ((GraniteWidgetsSourceListSortable*) _tmp4_) : NULL);
		sortable_item = _tmp5_;
		_tmp7_ = sortable_item;
		if (_tmp7_ != NULL) {
			GraniteWidgetsSourceListSortable* _tmp8_;
			_tmp8_ = sortable_item;
			_tmp6_ = granite_widgets_source_list_sortable_allow_dnd_sorting (_tmp8_);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = TRUE;
			_g_object_unref0 (sortable_item);
			_g_object_unref0 (item);
			return result;
		}
		_tmp9_ = item;
		_tmp10_ = _g_object_ref0 (GRANITE_WIDGETS_IS_SOURCE_LIST_DRAG_SOURCE (_tmp9_) ? ((GraniteWidgetsSourceListDragSource*) _tmp9_) : NULL);
		drag_source_item = _tmp10_;
		_tmp12_ = drag_source_item;
		if (_tmp12_ != NULL) {
			GraniteWidgetsSourceListDragSource* _tmp13_;
			_tmp13_ = drag_source_item;
			_tmp11_ = granite_widgets_source_list_drag_source_draggable (_tmp13_);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			result = TRUE;
			_g_object_unref0 (drag_source_item);
			_g_object_unref0 (sortable_item);
			_g_object_unref0 (item);
			return result;
		}
		_g_object_unref0 (drag_source_item);
		_g_object_unref0 (sortable_item);
	}
	result = FALSE;
	_g_object_unref0 (item);
	return result;
}

static inline gpointer
granite_widgets_source_list_data_model_node_wrapper_get_instance_private (GraniteWidgetsSourceListDataModelNodeWrapper* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListDataModelNodeWrapper_private_offset);
}

static void
_vala_GtkTreeRowReference_free (GtkTreeRowReference* self)
{
	g_boxed_free (gtk_tree_row_reference_get_type (), self);
}

static GtkTreeIter*
granite_widgets_source_list_data_model_node_wrapper_get_iter (GraniteWidgetsSourceListDataModelNodeWrapper* self)
{
	GtkTreeIter* result;
	GtkTreeIter* rv = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	rv = NULL;
	_tmp0_ = granite_widgets_source_list_data_model_node_wrapper_get_valid (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkTreePath* _path = NULL;
		GtkTreePath* _tmp2_;
		GtkTreePath* _tmp3_;
		GtkTreePath* _tmp4_;
		_tmp2_ = granite_widgets_source_list_data_model_node_wrapper_get_path (self);
		_tmp3_ = _tmp2_;
		_path = _tmp3_;
		_tmp4_ = _path;
		if (_tmp4_ != NULL) {
			GtkTreeIter _iter = {0};
			GtkTreeRowReference* _tmp5_;
			GtkTreeModel* _tmp6_;
			GtkTreePath* _tmp7_;
			GtkTreeIter _tmp8_ = {0};
			gboolean _tmp9_;
			_tmp5_ = self->priv->row_reference;
			_tmp6_ = gtk_tree_row_reference_get_model (_tmp5_);
			_tmp7_ = _path;
			_tmp9_ = gtk_tree_model_get_iter (_tmp6_, &_tmp8_, _tmp7_);
			_iter = _tmp8_;
			if (_tmp9_) {
				GtkTreeIter _tmp10_;
				GtkTreeIter* _tmp11_;
				_tmp10_ = _iter;
				_tmp11_ = __vala_GtkTreeIter_copy0 (&_tmp10_);
				__vala_GtkTreeIter_free0 (rv);
				rv = _tmp11_;
			}
		}
		__vala_GtkTreePath_free0 (_path);
	}
	result = rv;
	return result;
}

static GtkTreePath*
granite_widgets_source_list_data_model_node_wrapper_get_path (GraniteWidgetsSourceListDataModelNodeWrapper* self)
{
	GtkTreePath* result;
	GtkTreePath* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = granite_widgets_source_list_data_model_node_wrapper_get_valid (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkTreeRowReference* _tmp3_;
		GtkTreePath* _tmp4_;
		_tmp3_ = self->priv->row_reference;
		_tmp4_ = gtk_tree_row_reference_get_path (_tmp3_);
		__vala_GtkTreePath_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		__vala_GtkTreePath_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static gboolean
granite_widgets_source_list_data_model_node_wrapper_get_valid (GraniteWidgetsSourceListDataModelNodeWrapper* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GtkTreeRowReference* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->row_reference;
	if (_tmp1_ != NULL) {
		GtkTreeRowReference* _tmp2_;
		_tmp2_ = self->priv->row_reference;
		_tmp0_ = gtk_tree_row_reference_valid (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static GraniteWidgetsSourceListDataModelNodeWrapper*
granite_widgets_source_list_data_model_node_wrapper_construct (GType object_type,
                                                               GtkTreeModel* model,
                                                               GtkTreeIter* iter)
{
	GraniteWidgetsSourceListDataModelNodeWrapper* self = NULL;
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreeRowReference* _tmp3_;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	self = (GraniteWidgetsSourceListDataModelNodeWrapper*) g_type_create_instance (object_type);
	_tmp0_ = *iter;
	_tmp1_ = gtk_tree_model_get_path (model, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_tree_row_reference_new (model, _tmp2_);
	__vala_GtkTreeRowReference_free0 (self->priv->row_reference);
	self->priv->row_reference = _tmp3_;
	__vala_GtkTreePath_free0 (_tmp2_);
	return self;
}

static GraniteWidgetsSourceListDataModelNodeWrapper*
granite_widgets_source_list_data_model_node_wrapper_new (GtkTreeModel* model,
                                                         GtkTreeIter* iter)
{
	return granite_widgets_source_list_data_model_node_wrapper_construct (GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, model, iter);
}

static void
granite_widgets_source_list_data_model_value_node_wrapper_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
granite_widgets_source_list_data_model_value_node_wrapper_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		granite_widgets_source_list_data_model_node_wrapper_unref (value->data[0].v_pointer);
	}
}

static void
granite_widgets_source_list_data_model_value_node_wrapper_copy_value (const GValue* src_value,
                                                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = granite_widgets_source_list_data_model_node_wrapper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
granite_widgets_source_list_data_model_value_node_wrapper_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
granite_widgets_source_list_data_model_value_node_wrapper_collect_value (GValue* value,
                                                                         guint n_collect_values,
                                                                         GTypeCValue* collect_values,
                                                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GraniteWidgetsSourceListDataModelNodeWrapper * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = granite_widgets_source_list_data_model_node_wrapper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
granite_widgets_source_list_data_model_value_node_wrapper_lcopy_value (const GValue* value,
                                                                       guint n_collect_values,
                                                                       GTypeCValue* collect_values,
                                                                       guint collect_flags)
{
	GraniteWidgetsSourceListDataModelNodeWrapper ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = granite_widgets_source_list_data_model_node_wrapper_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
granite_widgets_source_list_data_model_param_spec_node_wrapper (const gchar* name,
                                                                const gchar* nick,
                                                                const gchar* blurb,
                                                                GType object_type,
                                                                GParamFlags flags)
{
	GraniteWidgetsSourceListDataModelParamSpecNodeWrapper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
granite_widgets_source_list_data_model_value_get_node_wrapper (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER), NULL);
	return value->data[0].v_pointer;
}

static void
granite_widgets_source_list_data_model_value_set_node_wrapper (GValue* value,
                                                               gpointer v_object)
{
	GraniteWidgetsSourceListDataModelNodeWrapper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		granite_widgets_source_list_data_model_node_wrapper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		granite_widgets_source_list_data_model_node_wrapper_unref (old);
	}
}

static void
granite_widgets_source_list_data_model_value_take_node_wrapper (GValue* value,
                                                                gpointer v_object)
{
	GraniteWidgetsSourceListDataModelNodeWrapper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		granite_widgets_source_list_data_model_node_wrapper_unref (old);
	}
}

static void
granite_widgets_source_list_data_model_node_wrapper_class_init (GraniteWidgetsSourceListDataModelNodeWrapperClass * klass,
                                                                gpointer klass_data)
{
	granite_widgets_source_list_data_model_node_wrapper_parent_class = g_type_class_peek_parent (klass);
	((GraniteWidgetsSourceListDataModelNodeWrapperClass *) klass)->finalize = granite_widgets_source_list_data_model_node_wrapper_finalize;
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListDataModelNodeWrapper_private_offset);
}

static void
granite_widgets_source_list_data_model_node_wrapper_instance_init (GraniteWidgetsSourceListDataModelNodeWrapper * self,
                                                                   gpointer klass)
{
	self->priv = granite_widgets_source_list_data_model_node_wrapper_get_instance_private (self);
	self->ref_count = 1;
}

static void
granite_widgets_source_list_data_model_node_wrapper_finalize (GraniteWidgetsSourceListDataModelNodeWrapper * obj)
{
	GraniteWidgetsSourceListDataModelNodeWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, GraniteWidgetsSourceListDataModelNodeWrapper);
	g_signal_handlers_destroy (self);
	__vala_GtkTreeRowReference_free0 (self->priv->row_reference);
}

/**
         * An object that references a particular row in a model. This class is a wrapper built around
         * Gtk.TreeRowReference, and exists with the purpose of ensuring we never use invalid tree paths
         * or iters in the model, since most of these errors provoke failures due to GTK+ assertions
         * or, even worse, unexpected behavior.
         */
static GType
granite_widgets_source_list_data_model_node_wrapper_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { granite_widgets_source_list_data_model_value_node_wrapper_init, granite_widgets_source_list_data_model_value_node_wrapper_free_value, granite_widgets_source_list_data_model_value_node_wrapper_copy_value, granite_widgets_source_list_data_model_value_node_wrapper_peek_pointer, "p", granite_widgets_source_list_data_model_value_node_wrapper_collect_value, "p", granite_widgets_source_list_data_model_value_node_wrapper_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListDataModelNodeWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_data_model_node_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListDataModelNodeWrapper), 0, (GInstanceInitFunc) granite_widgets_source_list_data_model_node_wrapper_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType granite_widgets_source_list_data_model_node_wrapper_type_id;
	granite_widgets_source_list_data_model_node_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GraniteWidgetsSourceListDataModelNodeWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GraniteWidgetsSourceListDataModelNodeWrapper_private_offset = g_type_add_instance_private (granite_widgets_source_list_data_model_node_wrapper_type_id, sizeof (GraniteWidgetsSourceListDataModelNodeWrapperPrivate));
	return granite_widgets_source_list_data_model_node_wrapper_type_id;
}

static GType
granite_widgets_source_list_data_model_node_wrapper_get_type (void)
{
	static volatile gsize granite_widgets_source_list_data_model_node_wrapper_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_data_model_node_wrapper_type_id__once)) {
		GType granite_widgets_source_list_data_model_node_wrapper_type_id;
		granite_widgets_source_list_data_model_node_wrapper_type_id = granite_widgets_source_list_data_model_node_wrapper_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_data_model_node_wrapper_type_id__once, granite_widgets_source_list_data_model_node_wrapper_type_id);
	}
	return granite_widgets_source_list_data_model_node_wrapper_type_id__once;
}

static gpointer
granite_widgets_source_list_data_model_node_wrapper_ref (gpointer instance)
{
	GraniteWidgetsSourceListDataModelNodeWrapper * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
granite_widgets_source_list_data_model_node_wrapper_unref (gpointer instance)
{
	GraniteWidgetsSourceListDataModelNodeWrapper * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_NODE_WRAPPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
granite_widgets_source_list_data_model_item_monitor_get_instance_private (GraniteWidgetsSourceListDataModelItemMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListDataModelItemMonitor_private_offset);
}

static void
_granite_widgets_source_list_data_model_item_monitor_on_notify_g_object_notify (GObject* _sender,
                                                                                GParamSpec* pspec,
                                                                                gpointer self)
{
	granite_widgets_source_list_data_model_item_monitor_on_notify ((GraniteWidgetsSourceListDataModelItemMonitor*) self, pspec);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static GraniteWidgetsSourceListDataModelItemMonitor*
granite_widgets_source_list_data_model_item_monitor_construct (GType object_type,
                                                               GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListDataModelItemMonitor* self = NULL;
	GraniteWidgetsSourceListItem* _tmp0_;
	g_return_val_if_fail (item != NULL, NULL);
	self = (GraniteWidgetsSourceListDataModelItemMonitor*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (self->priv->item);
	self->priv->item = _tmp0_;
	g_signal_connect_after ((GObject*) item, "notify", (GCallback) _granite_widgets_source_list_data_model_item_monitor_on_notify_g_object_notify, self);
	return self;
}

static GraniteWidgetsSourceListDataModelItemMonitor*
granite_widgets_source_list_data_model_item_monitor_new (GraniteWidgetsSourceListItem* item)
{
	return granite_widgets_source_list_data_model_item_monitor_construct (GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, item);
}

static void
granite_widgets_source_list_data_model_item_monitor_on_notify (GraniteWidgetsSourceListDataModelItemMonitor* self,
                                                               GParamSpec* prop)
{
	GraniteWidgetsSourceListItem* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->item;
	_tmp1_ = prop->name;
	g_signal_emit (self, granite_widgets_source_list_data_model_item_monitor_signals[GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_CHANGED_SIGNAL], 0, _tmp0_, _tmp1_);
}

static void
granite_widgets_source_list_data_model_value_item_monitor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
granite_widgets_source_list_data_model_value_item_monitor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		granite_widgets_source_list_data_model_item_monitor_unref (value->data[0].v_pointer);
	}
}

static void
granite_widgets_source_list_data_model_value_item_monitor_copy_value (const GValue* src_value,
                                                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = granite_widgets_source_list_data_model_item_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
granite_widgets_source_list_data_model_value_item_monitor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
granite_widgets_source_list_data_model_value_item_monitor_collect_value (GValue* value,
                                                                         guint n_collect_values,
                                                                         GTypeCValue* collect_values,
                                                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GraniteWidgetsSourceListDataModelItemMonitor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = granite_widgets_source_list_data_model_item_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
granite_widgets_source_list_data_model_value_item_monitor_lcopy_value (const GValue* value,
                                                                       guint n_collect_values,
                                                                       GTypeCValue* collect_values,
                                                                       guint collect_flags)
{
	GraniteWidgetsSourceListDataModelItemMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = granite_widgets_source_list_data_model_item_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
granite_widgets_source_list_data_model_param_spec_item_monitor (const gchar* name,
                                                                const gchar* nick,
                                                                const gchar* blurb,
                                                                GType object_type,
                                                                GParamFlags flags)
{
	GraniteWidgetsSourceListDataModelParamSpecItemMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
granite_widgets_source_list_data_model_value_get_item_monitor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR), NULL);
	return value->data[0].v_pointer;
}

static void
granite_widgets_source_list_data_model_value_set_item_monitor (GValue* value,
                                                               gpointer v_object)
{
	GraniteWidgetsSourceListDataModelItemMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		granite_widgets_source_list_data_model_item_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		granite_widgets_source_list_data_model_item_monitor_unref (old);
	}
}

static void
granite_widgets_source_list_data_model_value_take_item_monitor (GValue* value,
                                                                gpointer v_object)
{
	GraniteWidgetsSourceListDataModelItemMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		granite_widgets_source_list_data_model_item_monitor_unref (old);
	}
}

static void
granite_widgets_source_list_data_model_item_monitor_class_init (GraniteWidgetsSourceListDataModelItemMonitorClass * klass,
                                                                gpointer klass_data)
{
	granite_widgets_source_list_data_model_item_monitor_parent_class = g_type_class_peek_parent (klass);
	((GraniteWidgetsSourceListDataModelItemMonitorClass *) klass)->finalize = granite_widgets_source_list_data_model_item_monitor_finalize;
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListDataModelItemMonitor_private_offset);
	granite_widgets_source_list_data_model_item_monitor_signals[GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_CHANGED_SIGNAL] = g_signal_new ("changed", GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_TYPE_STRING);
}

static void
granite_widgets_source_list_data_model_item_monitor_instance_init (GraniteWidgetsSourceListDataModelItemMonitor * self,
                                                                   gpointer klass)
{
	self->priv = granite_widgets_source_list_data_model_item_monitor_get_instance_private (self);
	self->ref_count = 1;
}

static void
granite_widgets_source_list_data_model_item_monitor_finalize (GraniteWidgetsSourceListDataModelItemMonitor * obj)
{
	GraniteWidgetsSourceListDataModelItemMonitor * self;
	GraniteWidgetsSourceListItem* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, GraniteWidgetsSourceListDataModelItemMonitor);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->item;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _granite_widgets_source_list_data_model_item_monitor_on_notify_g_object_notify, self);
	_g_object_unref0 (self->priv->item);
}

/**
         * Helper object used to monitor item property changes.
         */
static GType
granite_widgets_source_list_data_model_item_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { granite_widgets_source_list_data_model_value_item_monitor_init, granite_widgets_source_list_data_model_value_item_monitor_free_value, granite_widgets_source_list_data_model_value_item_monitor_copy_value, granite_widgets_source_list_data_model_value_item_monitor_peek_pointer, "p", granite_widgets_source_list_data_model_value_item_monitor_collect_value, "p", granite_widgets_source_list_data_model_value_item_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListDataModelItemMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_data_model_item_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListDataModelItemMonitor), 0, (GInstanceInitFunc) granite_widgets_source_list_data_model_item_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType granite_widgets_source_list_data_model_item_monitor_type_id;
	granite_widgets_source_list_data_model_item_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GraniteWidgetsSourceListDataModelItemMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GraniteWidgetsSourceListDataModelItemMonitor_private_offset = g_type_add_instance_private (granite_widgets_source_list_data_model_item_monitor_type_id, sizeof (GraniteWidgetsSourceListDataModelItemMonitorPrivate));
	return granite_widgets_source_list_data_model_item_monitor_type_id;
}

static GType
granite_widgets_source_list_data_model_item_monitor_get_type (void)
{
	static volatile gsize granite_widgets_source_list_data_model_item_monitor_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_data_model_item_monitor_type_id__once)) {
		GType granite_widgets_source_list_data_model_item_monitor_type_id;
		granite_widgets_source_list_data_model_item_monitor_type_id = granite_widgets_source_list_data_model_item_monitor_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_data_model_item_monitor_type_id__once, granite_widgets_source_list_data_model_item_monitor_type_id);
	}
	return granite_widgets_source_list_data_model_item_monitor_type_id__once;
}

static gpointer
granite_widgets_source_list_data_model_item_monitor_ref (gpointer instance)
{
	GraniteWidgetsSourceListDataModelItemMonitor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
granite_widgets_source_list_data_model_item_monitor_unref (gpointer instance)
{
	GraniteWidgetsSourceListDataModelItemMonitor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gint
_granite_widgets_source_list_data_model_child_model_sort_func_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                                          GtkTreeIter* a,
                                                                                          GtkTreeIter* b,
                                                                                          gpointer self)
{
	gint result;
	result = granite_widgets_source_list_data_model_child_model_sort_func ((GraniteWidgetsSourceListDataModel*) self, model, a, b);
	return result;
}

static gboolean
_granite_widgets_source_list_data_model_filter_visible_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                                GtkTreeIter* iter,
                                                                                                gpointer self)
{
	gboolean result;
	result = granite_widgets_source_list_data_model_filter_visible_func ((GraniteWidgetsSourceListDataModel*) self, model, iter);
	return result;
}

static GObject *
granite_widgets_source_list_data_model_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsSourceListDataModel * self;
	GtkTreeStore* _tmp0_;
	GtkTreeStore* _tmp1_;
	GtkTreeStore* _tmp2_;
	parent_class = G_OBJECT_CLASS (granite_widgets_source_list_data_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, GraniteWidgetsSourceListDataModel);
	_tmp0_ = gtk_tree_store_new ((gint) GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_N_COLUMNS, granite_widgets_source_list_data_model_column_type (GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_COLUMN_ITEM));
	_g_object_unref0 (self->priv->child_tree);
	self->priv->child_tree = _tmp0_;
	_tmp1_ = self->priv->child_tree;
	g_object_set ((GtkTreeModelFilter*) self, "child-model", (GtkTreeModel*) _tmp1_, NULL);
	g_object_set ((GtkTreeModelFilter*) self, "virtual-root", NULL, NULL);
	_tmp2_ = self->priv->child_tree;
	gtk_tree_sortable_set_default_sort_func ((GtkTreeSortable*) _tmp2_, _granite_widgets_source_list_data_model_child_model_sort_func_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	granite_widgets_source_list_data_model_resort (self);
	gtk_tree_model_filter_set_visible_func ((GtkTreeModelFilter*) self, _granite_widgets_source_list_data_model_filter_visible_func_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
granite_widgets_source_list_data_model_class_init (GraniteWidgetsSourceListDataModelClass * klass,
                                                   gpointer klass_data)
{
	granite_widgets_source_list_data_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListDataModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_data_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_data_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_source_list_data_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_data_model_finalize;
	/**
	         * Root item.
	         *
	         * This item is not actually part of the model. It's only used as a proxy
	         * for adding and removing items.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY, granite_widgets_source_list_data_model_properties[GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY] = g_param_spec_object ("root", "root", "root", GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	granite_widgets_source_list_data_model_signals[GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ITEM_UPDATED_SIGNAL] = g_signal_new ("item-updated", GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM);
}

static void
granite_widgets_source_list_data_model_gtk_tree_drag_source_interface_init (GtkTreeDragSourceIface * iface,
                                                                            gpointer iface_data)
{
	granite_widgets_source_list_data_model_gtk_tree_drag_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->drag_data_get = (gboolean (*) (GtkTreeDragSource*, GtkTreePath*, GtkSelectionData*)) granite_widgets_source_list_data_model_real_drag_data_get;
	iface->row_draggable = (gboolean (*) (GtkTreeDragSource*, GtkTreePath*)) granite_widgets_source_list_data_model_real_row_draggable;
}

static void
granite_widgets_source_list_data_model_gtk_tree_drag_dest_interface_init (GtkTreeDragDestIface * iface,
                                                                          gpointer iface_data)
{
	granite_widgets_source_list_data_model_gtk_tree_drag_dest_parent_iface = g_type_interface_peek_parent (iface);
	iface->drag_data_received = (gboolean (*) (GtkTreeDragDest*, GtkTreePath*, GtkSelectionData*)) granite_widgets_source_list_data_model_real_drag_data_received;
	iface->row_drop_possible = (gboolean (*) (GtkTreeDragDest*, GtkTreePath*, GtkSelectionData*)) granite_widgets_source_list_data_model_real_row_drop_possible;
}

static void
granite_widgets_source_list_data_model_instance_init (GraniteWidgetsSourceListDataModel * self,
                                                      gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = granite_widgets_source_list_data_model_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_NODE_WRAPPER, (GBoxedCopyFunc) granite_widgets_source_list_data_model_node_wrapper_ref, (GDestroyNotify) granite_widgets_source_list_data_model_node_wrapper_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->items = _tmp0_;
	_tmp1_ = gee_hash_map_new (GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_TYPE_ITEM_MONITOR, (GBoxedCopyFunc) granite_widgets_source_list_data_model_item_monitor_ref, (GDestroyNotify) granite_widgets_source_list_data_model_item_monitor_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->monitors = _tmp1_;
}

static void
granite_widgets_source_list_data_model_finalize (GObject * obj)
{
	GraniteWidgetsSourceListDataModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, GraniteWidgetsSourceListDataModel);
	_g_object_unref0 (self->priv->_root);
	_g_object_unref0 (self->priv->items);
	_g_object_unref0 (self->priv->monitors);
	_g_object_unref0 (self->priv->child_tree);
	G_OBJECT_CLASS (granite_widgets_source_list_data_model_parent_class)->finalize (obj);
}

/**
     * The model backing the SourceList tree.
     *
     * It monitors item property changes, and handles children additions and removals. It also controls
     * the visibility of the items based on their "visible" property, and on their number of children,
     * if they happen to be categories. Its main purpose is to provide an easy and practical interface
     * for sorting, adding, removing and updating items, eliminating the need of repeatedly dealing with
     * the Gtk.TreeModel API directly.
     */
static GType
granite_widgets_source_list_data_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListDataModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_data_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListDataModel), 0, (GInstanceInitFunc) granite_widgets_source_list_data_model_instance_init, NULL };
	static const GInterfaceInfo gtk_tree_drag_source_info = { (GInterfaceInitFunc) granite_widgets_source_list_data_model_gtk_tree_drag_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gtk_tree_drag_dest_info = { (GInterfaceInitFunc) granite_widgets_source_list_data_model_gtk_tree_drag_dest_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType granite_widgets_source_list_data_model_type_id;
	granite_widgets_source_list_data_model_type_id = g_type_register_static (gtk_tree_model_filter_get_type (), "GraniteWidgetsSourceListDataModel", &g_define_type_info, 0);
	g_type_add_interface_static (granite_widgets_source_list_data_model_type_id, gtk_tree_drag_source_get_type (), &gtk_tree_drag_source_info);
	g_type_add_interface_static (granite_widgets_source_list_data_model_type_id, gtk_tree_drag_dest_get_type (), &gtk_tree_drag_dest_info);
	GraniteWidgetsSourceListDataModel_private_offset = g_type_add_instance_private (granite_widgets_source_list_data_model_type_id, sizeof (GraniteWidgetsSourceListDataModelPrivate));
	return granite_widgets_source_list_data_model_type_id;
}

static GType
granite_widgets_source_list_data_model_get_type (void)
{
	static volatile gsize granite_widgets_source_list_data_model_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_data_model_type_id__once)) {
		GType granite_widgets_source_list_data_model_type_id;
		granite_widgets_source_list_data_model_type_id = granite_widgets_source_list_data_model_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_data_model_type_id__once, granite_widgets_source_list_data_model_type_id);
	}
	return granite_widgets_source_list_data_model_type_id__once;
}

static void
_vala_granite_widgets_source_list_data_model_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	GraniteWidgetsSourceListDataModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, GraniteWidgetsSourceListDataModel);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY:
		g_value_set_object (value, granite_widgets_source_list_data_model_get_root (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_source_list_data_model_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	GraniteWidgetsSourceListDataModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, GraniteWidgetsSourceListDataModel);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_DATA_MODEL_ROOT_PROPERTY:
		granite_widgets_source_list_data_model_set_root (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GraniteWidgetsSourceListCellRendererIcon*
granite_widgets_source_list_cell_renderer_icon_construct (GType object_type)
{
	GraniteWidgetsSourceListCellRendererIcon * self = NULL;
	self = (GraniteWidgetsSourceListCellRendererIcon*) g_object_new (object_type, NULL);
	return self;
}

static GraniteWidgetsSourceListCellRendererIcon*
granite_widgets_source_list_cell_renderer_icon_new (void)
{
	return granite_widgets_source_list_cell_renderer_icon_construct (GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON);
}

static gboolean
granite_widgets_source_list_cell_renderer_icon_real_activate (GtkCellRenderer* base,
                                                              GdkEvent* event,
                                                              GtkWidget* widget,
                                                              const gchar* path,
                                                              GdkRectangle* background_area,
                                                              GdkRectangle* cell_area,
                                                              GtkCellRendererState flags)
{
	GraniteWidgetsSourceListCellRendererIcon * self;
	gboolean result;
	self = (GraniteWidgetsSourceListCellRendererIcon*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (background_area != NULL, FALSE);
	g_return_val_if_fail (cell_area != NULL, FALSE);
	g_signal_emit (self, granite_widgets_source_list_cell_renderer_icon_signals[GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_ACTIVATED_SIGNAL], 0, path);
	result = TRUE;
	return result;
}

static GObject *
granite_widgets_source_list_cell_renderer_icon_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsSourceListCellRendererIcon * self;
	parent_class = G_OBJECT_CLASS (granite_widgets_source_list_cell_renderer_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON, GraniteWidgetsSourceListCellRendererIcon);
	g_object_set ((GtkCellRenderer*) self, "mode", GTK_CELL_RENDERER_MODE_ACTIVATABLE, NULL);
	g_object_set ((GtkCellRendererPixbuf*) self, "stock-size", (guint) GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_ICON_SIZE, NULL);
	return obj;
}

static void
granite_widgets_source_list_cell_renderer_icon_class_init (GraniteWidgetsSourceListCellRendererIconClass * klass,
                                                           gpointer klass_data)
{
	granite_widgets_source_list_cell_renderer_icon_parent_class = g_type_class_peek_parent (klass);
	((GtkCellRendererClass *) klass)->activate = (gboolean (*) (GtkCellRenderer*, GdkEvent*, GtkWidget*, const gchar*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) granite_widgets_source_list_cell_renderer_icon_real_activate;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_source_list_cell_renderer_icon_constructor;
	granite_widgets_source_list_cell_renderer_icon_signals[GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_ICON_ACTIVATED_SIGNAL] = g_signal_new ("activated", GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
granite_widgets_source_list_cell_renderer_icon_instance_init (GraniteWidgetsSourceListCellRendererIcon * self,
                                                              gpointer klass)
{
}

/**
     * Class responsible for rendering Item.icon and Item.activatable. It also
     * notifies about clicks through the activated() signal.
     */
static GType
granite_widgets_source_list_cell_renderer_icon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListCellRendererIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_cell_renderer_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListCellRendererIcon), 0, (GInstanceInitFunc) granite_widgets_source_list_cell_renderer_icon_instance_init, NULL };
	GType granite_widgets_source_list_cell_renderer_icon_type_id;
	granite_widgets_source_list_cell_renderer_icon_type_id = g_type_register_static (gtk_cell_renderer_pixbuf_get_type (), "GraniteWidgetsSourceListCellRendererIcon", &g_define_type_info, 0);
	return granite_widgets_source_list_cell_renderer_icon_type_id;
}

static GType
granite_widgets_source_list_cell_renderer_icon_get_type (void)
{
	static volatile gsize granite_widgets_source_list_cell_renderer_icon_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_cell_renderer_icon_type_id__once)) {
		GType granite_widgets_source_list_cell_renderer_icon_type_id;
		granite_widgets_source_list_cell_renderer_icon_type_id = granite_widgets_source_list_cell_renderer_icon_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_cell_renderer_icon_type_id__once, granite_widgets_source_list_cell_renderer_icon_type_id);
	}
	return granite_widgets_source_list_cell_renderer_icon_type_id__once;
}

static inline gpointer
granite_widgets_source_list_cell_renderer_spacer_get_instance_private (GraniteWidgetsSourceListCellRendererSpacer* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListCellRendererSpacer_private_offset);
}

static gint
granite_widgets_source_list_cell_renderer_spacer_get_level (GraniteWidgetsSourceListCellRendererSpacer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_level;
	return result;
}

static void
granite_widgets_source_list_cell_renderer_spacer_set_level (GraniteWidgetsSourceListCellRendererSpacer* self,
                                                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_cell_renderer_spacer_get_level (self);
	if (old_value != value) {
		self->priv->_level = value;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_cell_renderer_spacer_properties[GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY]);
	}
}

static GtkSizeRequestMode
granite_widgets_source_list_cell_renderer_spacer_real_get_request_mode (GtkCellRenderer* base)
{
	GraniteWidgetsSourceListCellRendererSpacer * self;
	GtkSizeRequestMode result;
	self = (GraniteWidgetsSourceListCellRendererSpacer*) base;
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}

static void
granite_widgets_source_list_cell_renderer_spacer_real_get_preferred_width (GtkCellRenderer* base,
                                                                           GtkWidget* widget,
                                                                           gint* min_size,
                                                                           gint* natural_size)
{
	GraniteWidgetsSourceListCellRendererSpacer * self;
	gint _vala_min_size = 0;
	gint _vala_natural_size = 0;
	guint _tmp0_;
	guint _tmp1_;
	self = (GraniteWidgetsSourceListCellRendererSpacer*) base;
	g_return_if_fail (widget != NULL);
	g_object_get ((GtkCellRenderer*) self, "xpad", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_vala_natural_size = 2 * ((gint) _tmp1_);
	_vala_min_size = _vala_natural_size;
	if (min_size) {
		*min_size = _vala_min_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

static void
granite_widgets_source_list_cell_renderer_spacer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                                      GtkWidget* widget,
                                                                                      gint width,
                                                                                      gint* min_height,
                                                                                      gint* natural_height)
{
	GraniteWidgetsSourceListCellRendererSpacer * self;
	gint _vala_min_height = 0;
	gint _vala_natural_height = 0;
	guint _tmp0_;
	guint _tmp1_;
	self = (GraniteWidgetsSourceListCellRendererSpacer*) base;
	g_return_if_fail (widget != NULL);
	g_object_get ((GtkCellRenderer*) self, "ypad", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_vala_natural_height = 2 * ((gint) _tmp1_);
	_vala_min_height = _vala_natural_height;
	if (min_height) {
		*min_height = _vala_min_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static void
granite_widgets_source_list_cell_renderer_spacer_real_render (GtkCellRenderer* base,
                                                              cairo_t* context,
                                                              GtkWidget* widget,
                                                              GdkRectangle* bg_area,
                                                              GdkRectangle* cell_area,
                                                              GtkCellRendererState flags)
{
	GraniteWidgetsSourceListCellRendererSpacer * self;
	self = (GraniteWidgetsSourceListCellRendererSpacer*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (bg_area != NULL);
	g_return_if_fail (cell_area != NULL);
}

static GraniteWidgetsSourceListCellRendererSpacer*
granite_widgets_source_list_cell_renderer_spacer_construct (GType object_type)
{
	GraniteWidgetsSourceListCellRendererSpacer * self = NULL;
	self = (GraniteWidgetsSourceListCellRendererSpacer*) g_object_new (object_type, NULL);
	return self;
}

static GraniteWidgetsSourceListCellRendererSpacer*
granite_widgets_source_list_cell_renderer_spacer_new (void)
{
	return granite_widgets_source_list_cell_renderer_spacer_construct (GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER);
}

static void
granite_widgets_source_list_cell_renderer_spacer_class_init (GraniteWidgetsSourceListCellRendererSpacerClass * klass,
                                                             gpointer klass_data)
{
	granite_widgets_source_list_cell_renderer_spacer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListCellRendererSpacer_private_offset);
	((GtkCellRendererClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkCellRenderer*)) granite_widgets_source_list_cell_renderer_spacer_real_get_request_mode;
	((GtkCellRendererClass *) klass)->get_preferred_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) granite_widgets_source_list_cell_renderer_spacer_real_get_preferred_width;
	((GtkCellRendererClass *) klass)->get_preferred_height_for_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint, gint*, gint*)) granite_widgets_source_list_cell_renderer_spacer_real_get_preferred_height_for_width;
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) granite_widgets_source_list_cell_renderer_spacer_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_cell_renderer_spacer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_cell_renderer_spacer_set_property;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_cell_renderer_spacer_finalize;
	/**
	         * Indentation level represented by this cell renderer
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY, granite_widgets_source_list_cell_renderer_spacer_properties[GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY] = g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
granite_widgets_source_list_cell_renderer_spacer_instance_init (GraniteWidgetsSourceListCellRendererSpacer * self,
                                                                gpointer klass)
{
	self->priv = granite_widgets_source_list_cell_renderer_spacer_get_instance_private (self);
	self->priv->_level = -1;
}

static void
granite_widgets_source_list_cell_renderer_spacer_finalize (GObject * obj)
{
	GraniteWidgetsSourceListCellRendererSpacer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListCellRendererSpacer);
	G_OBJECT_CLASS (granite_widgets_source_list_cell_renderer_spacer_parent_class)->finalize (obj);
}

/**
     * A cell renderer that only adds space.
     */
static GType
granite_widgets_source_list_cell_renderer_spacer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListCellRendererSpacerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_cell_renderer_spacer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListCellRendererSpacer), 0, (GInstanceInitFunc) granite_widgets_source_list_cell_renderer_spacer_instance_init, NULL };
	GType granite_widgets_source_list_cell_renderer_spacer_type_id;
	granite_widgets_source_list_cell_renderer_spacer_type_id = g_type_register_static (gtk_cell_renderer_get_type (), "GraniteWidgetsSourceListCellRendererSpacer", &g_define_type_info, 0);
	GraniteWidgetsSourceListCellRendererSpacer_private_offset = g_type_add_instance_private (granite_widgets_source_list_cell_renderer_spacer_type_id, sizeof (GraniteWidgetsSourceListCellRendererSpacerPrivate));
	return granite_widgets_source_list_cell_renderer_spacer_type_id;
}

static GType
granite_widgets_source_list_cell_renderer_spacer_get_type (void)
{
	static volatile gsize granite_widgets_source_list_cell_renderer_spacer_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_cell_renderer_spacer_type_id__once)) {
		GType granite_widgets_source_list_cell_renderer_spacer_type_id;
		granite_widgets_source_list_cell_renderer_spacer_type_id = granite_widgets_source_list_cell_renderer_spacer_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_cell_renderer_spacer_type_id__once, granite_widgets_source_list_cell_renderer_spacer_type_id);
	}
	return granite_widgets_source_list_cell_renderer_spacer_type_id__once;
}

static void
_vala_granite_widgets_source_list_cell_renderer_spacer_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec)
{
	GraniteWidgetsSourceListCellRendererSpacer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListCellRendererSpacer);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY:
		g_value_set_int (value, granite_widgets_source_list_cell_renderer_spacer_get_level (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_source_list_cell_renderer_spacer_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec)
{
	GraniteWidgetsSourceListCellRendererSpacer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListCellRendererSpacer);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_CELL_RENDERER_SPACER_LEVEL_PROPERTY:
		granite_widgets_source_list_cell_renderer_spacer_set_level (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
granite_widgets_source_list_tree_get_instance_private (GraniteWidgetsSourceListTree* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListTree_private_offset);
}

static GType
granite_widgets_source_list_tree_column_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM, "GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM", "item"}, {GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_N_COLS, "GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_N_COLS", "n-cols"}, {0, NULL, NULL}};
	GType granite_widgets_source_list_tree_column_type_id;
	granite_widgets_source_list_tree_column_type_id = g_enum_register_static ("GraniteWidgetsSourceListTreeColumn", values);
	return granite_widgets_source_list_tree_column_type_id;
}

static GType
granite_widgets_source_list_tree_column_get_type (void)
{
	static volatile gsize granite_widgets_source_list_tree_column_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_tree_column_type_id__once)) {
		GType granite_widgets_source_list_tree_column_type_id;
		granite_widgets_source_list_tree_column_type_id = granite_widgets_source_list_tree_column_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_tree_column_type_id__once, granite_widgets_source_list_tree_column_type_id);
	}
	return granite_widgets_source_list_tree_column_type_id__once;
}

static GraniteWidgetsSourceListDataModel*
granite_widgets_source_list_tree_get_data_model (GraniteWidgetsSourceListTree* self)
{
	GraniteWidgetsSourceListDataModel* result;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_model;
	result = _tmp0_;
	return result;
}

static void
granite_widgets_source_list_tree_set_data_model (GraniteWidgetsSourceListTree* self,
                                                 GraniteWidgetsSourceListDataModel* value)
{
	GraniteWidgetsSourceListDataModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_source_list_tree_get_data_model (self);
	if (old_value != value) {
		GraniteWidgetsSourceListDataModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_data_model);
		self->priv->_data_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY]);
	}
}

static GraniteWidgetsSourceListItem*
granite_widgets_source_list_tree_get_selected_item (GraniteWidgetsSourceListTree* self)
{
	GraniteWidgetsSourceListItem* result;
	GraniteWidgetsSourceListItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selected;
	result = _tmp0_;
	return result;
}

static void
granite_widgets_source_list_tree_set_selected_item (GraniteWidgetsSourceListTree* self,
                                                    GraniteWidgetsSourceListItem* value)
{
	g_return_if_fail (self != NULL);
	granite_widgets_source_list_tree_set_selected (self, value, TRUE);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY]);
}

static gboolean
granite_widgets_source_list_tree_get_editing (GraniteWidgetsSourceListTree* self)
{
	gboolean result;
	GtkCellRendererText* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->text_cell;
	g_object_get ((GtkCellRenderer*) _tmp0_, "editing", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static PangoEllipsizeMode
granite_widgets_source_list_tree_get_ellipsize_mode (GraniteWidgetsSourceListTree* self)
{
	PangoEllipsizeMode result;
	GtkCellRendererText* _tmp0_;
	PangoEllipsizeMode _tmp1_;
	PangoEllipsizeMode _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->text_cell;
	g_object_get (_tmp0_, "ellipsize", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
granite_widgets_source_list_tree_set_ellipsize_mode (GraniteWidgetsSourceListTree* self,
                                                     PangoEllipsizeMode value)
{
	GtkCellRendererText* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->text_cell;
	g_object_set (_tmp0_, "ellipsize", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY]);
}

static GraniteWidgetsSourceListTree*
granite_widgets_source_list_tree_construct (GType object_type,
                                            GraniteWidgetsSourceListDataModel* data_model)
{
	GraniteWidgetsSourceListTree * self = NULL;
	g_return_val_if_fail (data_model != NULL, NULL);
	self = (GraniteWidgetsSourceListTree*) g_object_new (object_type, "data-model", data_model, NULL);
	return self;
}

static GraniteWidgetsSourceListTree*
granite_widgets_source_list_tree_new (GraniteWidgetsSourceListDataModel* data_model)
{
	return granite_widgets_source_list_tree_construct (GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE, data_model);
}

static gpointer
_gtk_target_list_ref0 (gpointer self)
{
	return self ? gtk_target_list_ref (self) : NULL;
}

static gboolean
granite_widgets_source_list_tree_real_drag_motion (GtkWidget* base,
                                                   GdkDragContext* context,
                                                   gint x,
                                                   gint y,
                                                   guint time)
{
	GraniteWidgetsSourceListTree * self;
	GtkTreePath* suggested_path = NULL;
	GtkTreePath* current_path = NULL;
	GtkTreeViewDropPosition suggested_pos = 0;
	GtkTreeViewDropPosition current_pos = 0;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeViewDropPosition _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean result;
	self = (GraniteWidgetsSourceListTree*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	if (!GTK_WIDGET_CLASS (granite_widgets_source_list_tree_parent_class)->drag_motion ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), context, x, y, time)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = gtk_tree_view_get_dest_row_at_pos ((GtkTreeView*) self, x, y, &_tmp0_, &_tmp1_);
	__vala_GtkTreePath_free0 (suggested_path);
	suggested_path = _tmp0_;
	suggested_pos = _tmp1_;
	if (_tmp2_) {
		GtkTreePath* _tmp3_ = NULL;
		GtkTreeViewDropPosition _tmp4_ = 0;
		gboolean _tmp5_ = FALSE;
		GtkTreePath* _tmp6_;
		gtk_tree_view_get_drag_dest_row ((GtkTreeView*) self, &_tmp3_, &_tmp4_);
		__vala_GtkTreePath_free0 (current_path);
		current_path = _tmp3_;
		current_pos = _tmp4_;
		_tmp6_ = current_path;
		if (_tmp6_ != NULL) {
			GtkTreePath* _tmp7_;
			GtkTreePath* _tmp8_;
			_tmp7_ = suggested_path;
			_tmp8_ = current_path;
			_tmp5_ = gtk_tree_path_compare (_tmp7_, _tmp8_) == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GtkWidget* source_widget = NULL;
			GtkWidget* _tmp9_;
			GtkWidget* _tmp10_;
			gboolean dragging_treemodel_row = FALSE;
			GtkWidget* _tmp11_;
			_tmp9_ = gtk_drag_get_source_widget (context);
			_tmp10_ = _g_object_ref0 (_tmp9_);
			source_widget = _tmp10_;
			_tmp11_ = source_widget;
			dragging_treemodel_row = _tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget);
			if (dragging_treemodel_row) {
				if (current_pos != GTK_TREE_VIEW_DROP_BEFORE) {
					if (current_pos == GTK_TREE_VIEW_DROP_INTO_OR_BEFORE) {
						GtkTreePath* _tmp12_;
						_tmp12_ = current_path;
						gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, _tmp12_, GTK_TREE_VIEW_DROP_BEFORE);
					} else {
						gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_AFTER);
					}
				}
			} else {
				GraniteWidgetsSourceListDragDest* dest = NULL;
				GraniteWidgetsSourceListDataModel* _tmp15_;
				GtkTreePath* _tmp16_;
				GraniteWidgetsSourceListItem* _tmp17_;
				GraniteWidgetsSourceListDragDest* _tmp18_;
				GraniteWidgetsSourceListDragDest* _tmp19_;
				if (current_pos == GTK_TREE_VIEW_DROP_BEFORE) {
					GtkTreePath* _tmp13_;
					_tmp13_ = current_path;
					gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, _tmp13_, GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);
				} else {
					if (current_pos == GTK_TREE_VIEW_DROP_AFTER) {
						GtkTreePath* _tmp14_;
						_tmp14_ = current_path;
						gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, _tmp14_, GTK_TREE_VIEW_DROP_INTO_OR_AFTER);
					}
				}
				_tmp15_ = self->priv->_data_model;
				_tmp16_ = current_path;
				_tmp17_ = granite_widgets_source_list_data_model_get_item_from_path (_tmp15_, _tmp16_);
				_tmp18_ = GRANITE_WIDGETS_IS_SOURCE_LIST_DRAG_DEST (_tmp17_) ? ((GraniteWidgetsSourceListDragDest*) _tmp17_) : NULL;
				if (_tmp18_ == NULL) {
					_g_object_unref0 (_tmp17_);
				}
				dest = _tmp18_;
				_tmp19_ = dest;
				if (_tmp19_ != NULL) {
					GtkTargetList* target_list = NULL;
					GtkTargetList* _tmp20_;
					GtkTargetList* _tmp21_;
					GdkAtom target = (GdkAtom) 0U;
					GtkTargetList* _tmp22_;
					_tmp20_ = gtk_drag_dest_get_target_list ((GtkWidget*) self);
					_tmp21_ = _gtk_target_list_ref0 (_tmp20_);
					target_list = _tmp21_;
					_tmp22_ = target_list;
					target = gtk_drag_dest_find_target ((GtkWidget*) self, context, _tmp22_);
					g_object_set_data_full ((GObject*) context, "suggested-dnd-action", (gpointer) ((gintptr) gdk_drag_context_get_suggested_action (context)), NULL);
					gtk_drag_get_data ((GtkWidget*) self, context, target, (guint32) time);
					_gtk_target_list_unref0 (target_list);
				} else {
					gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_BEFORE);
				}
				_g_object_unref0 (dest);
			}
			_g_object_unref0 (source_widget);
		}
	} else {
		gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_AFTER);
		result = FALSE;
		__vala_GtkTreePath_free0 (current_path);
		__vala_GtkTreePath_free0 (suggested_path);
		return result;
	}
	result = TRUE;
	__vala_GtkTreePath_free0 (current_path);
	__vala_GtkTreePath_free0 (suggested_path);
	return result;
}

static void
granite_widgets_source_list_tree_real_drag_data_received (GtkWidget* base,
                                                          GdkDragContext* context,
                                                          gint x,
                                                          gint y,
                                                          GtkSelectionData* selection_data,
                                                          guint info,
                                                          guint time)
{
	GraniteWidgetsSourceListTree * self;
	GtkTargetList* target_list = NULL;
	GtkTargetList* _tmp0_;
	GtkTargetList* _tmp1_;
	GdkAtom target = (GdkAtom) 0U;
	GtkTargetList* _tmp2_;
	GtkTreePath* path = NULL;
	GtkTreeViewDropPosition pos = 0;
	gconstpointer _tmp3_;
	self = (GraniteWidgetsSourceListTree*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = gtk_drag_dest_get_target_list ((GtkWidget*) self);
	_tmp1_ = _gtk_target_list_ref0 (_tmp0_);
	target_list = _tmp1_;
	_tmp2_ = target_list;
	target = gtk_drag_dest_find_target ((GtkWidget*) self, context, _tmp2_);
	if (target == gdk_atom_intern_static_string ("GTK_TREE_MODEL_ROW")) {
		GTK_WIDGET_CLASS (granite_widgets_source_list_tree_parent_class)->drag_data_received ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), context, x, y, selection_data, info, time);
		_gtk_target_list_unref0 (target_list);
		return;
	}
	_tmp3_ = g_object_get_data ((GObject*) context, "suggested-dnd-action");
	if (((gint) ((gintptr) _tmp3_)) != 0) {
		GtkTreePath* _tmp4_ = NULL;
		GtkTreeViewDropPosition _tmp5_ = 0;
		GtkTreePath* _tmp6_;
		g_object_set_data_full ((GObject*) context, "suggested-dnd-action", (gpointer) ((gintptr) 0), NULL);
		gtk_tree_view_get_drag_dest_row ((GtkTreeView*) self, &_tmp4_, &_tmp5_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp4_;
		pos = _tmp5_;
		_tmp6_ = path;
		if (_tmp6_ != NULL) {
			GraniteWidgetsSourceListDragDest* dest = NULL;
			GraniteWidgetsSourceListDataModel* _tmp7_;
			GtkTreePath* _tmp8_;
			GraniteWidgetsSourceListItem* _tmp9_;
			GraniteWidgetsSourceListDragDest* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GraniteWidgetsSourceListDragDest* _tmp12_;
			_tmp7_ = self->priv->_data_model;
			_tmp8_ = path;
			_tmp9_ = granite_widgets_source_list_data_model_get_item_from_path (_tmp7_, _tmp8_);
			_tmp10_ = GRANITE_WIDGETS_IS_SOURCE_LIST_DRAG_DEST (_tmp9_) ? ((GraniteWidgetsSourceListDragDest*) _tmp9_) : NULL;
			if (_tmp10_ == NULL) {
				_g_object_unref0 (_tmp9_);
			}
			dest = _tmp10_;
			_tmp12_ = dest;
			if (_tmp12_ == NULL) {
				_tmp11_ = TRUE;
			} else {
				GraniteWidgetsSourceListDragDest* _tmp13_;
				_tmp13_ = dest;
				_tmp11_ = !granite_widgets_source_list_drag_dest_data_drop_possible (_tmp13_, context, selection_data);
			}
			if (_tmp11_) {
				gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_BEFORE);
				gdk_drag_status (context, 0, (guint32) time);
				_g_object_unref0 (dest);
				__vala_GtkTreePath_free0 (path);
				_gtk_target_list_unref0 (target_list);
				return;
			}
			_g_object_unref0 (dest);
		}
		gdk_drag_status (context, gdk_drag_context_get_suggested_action (context), (guint32) time);
	} else {
		GtkTreePath* _tmp14_ = NULL;
		GtkTreeViewDropPosition _tmp15_ = 0;
		gboolean _tmp16_;
		_tmp16_ = gtk_tree_view_get_dest_row_at_pos ((GtkTreeView*) self, x, y, &_tmp14_, &_tmp15_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp14_;
		pos = _tmp15_;
		if (_tmp16_) {
			GraniteWidgetsSourceListDragDest* drag_dest = NULL;
			GraniteWidgetsSourceListDataModel* _tmp17_;
			GtkTreePath* _tmp18_;
			GraniteWidgetsSourceListItem* _tmp19_;
			GraniteWidgetsSourceListDragDest* _tmp20_;
			GraniteWidgetsSourceListDragDest* _tmp21_;
			_tmp17_ = self->priv->_data_model;
			_tmp18_ = path;
			_tmp19_ = granite_widgets_source_list_data_model_get_item_from_path (_tmp17_, _tmp18_);
			_tmp20_ = GRANITE_WIDGETS_IS_SOURCE_LIST_DRAG_DEST (_tmp19_) ? ((GraniteWidgetsSourceListDragDest*) _tmp19_) : NULL;
			if (_tmp20_ == NULL) {
				_g_object_unref0 (_tmp19_);
			}
			drag_dest = _tmp20_;
			_tmp21_ = drag_dest;
			if (_tmp21_ != NULL) {
				GdkDragAction action = 0U;
				GraniteWidgetsSourceListDragDest* _tmp22_;
				_tmp22_ = drag_dest;
				action = granite_widgets_source_list_drag_dest_data_received (_tmp22_, context, selection_data);
				gtk_drag_finish (context, action != 0, action == GDK_ACTION_MOVE, (guint32) time);
				_g_object_unref0 (drag_dest);
				__vala_GtkTreePath_free0 (path);
				_gtk_target_list_unref0 (target_list);
				return;
			}
			_g_object_unref0 (drag_dest);
		}
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
	}
	__vala_GtkTreePath_free0 (path);
	_gtk_target_list_unref0 (target_list);
}

static void
granite_widgets_source_list_tree_configure_drag_source (GraniteWidgetsSourceListTree* self,
                                                        GtkTargetEntry* src_entries,
                                                        gint src_entries_length1)
{
	GtkTargetEntry* entries = NULL;
	gint _tmp0_ = 0;
	GtkTargetEntry* _tmp1_;
	gint entries_length1;
	gint _entries_size_;
	g_return_if_fail (self != NULL);
	_tmp1_ = granite_widgets_source_list_tree_append_row_target_entry (src_entries, (gint) src_entries_length1, &_tmp0_);
	entries = _tmp1_;
	entries_length1 = _tmp0_;
	_entries_size_ = entries_length1;
	gtk_tree_view_unset_rows_drag_source ((GtkTreeView*) self);
	gtk_tree_view_enable_model_drag_source ((GtkTreeView*) self, GDK_BUTTON1_MASK, entries, (gint) entries_length1, GDK_ACTION_MOVE);
	entries = (g_free (entries), NULL);
}

static void
granite_widgets_source_list_tree_configure_drag_dest (GraniteWidgetsSourceListTree* self,
                                                      GtkTargetEntry* dest_entries,
                                                      gint dest_entries_length1,
                                                      GdkDragAction actions)
{
	GtkTargetEntry* entries = NULL;
	gint _tmp0_ = 0;
	GtkTargetEntry* _tmp1_;
	gint entries_length1;
	gint _entries_size_;
	g_return_if_fail (self != NULL);
	_tmp1_ = granite_widgets_source_list_tree_append_row_target_entry (dest_entries, (gint) dest_entries_length1, &_tmp0_);
	entries = _tmp1_;
	entries_length1 = _tmp0_;
	_entries_size_ = entries_length1;
	gtk_tree_view_unset_rows_drag_dest ((GtkTreeView*) self);
	gtk_tree_view_enable_model_drag_dest ((GtkTreeView*) self, entries, (gint) entries_length1, GDK_ACTION_MOVE | actions);
	entries = (g_free (entries), NULL);
}

static gboolean
granite_widgets_source_list_tree_on_query_tooltip (GraniteWidgetsSourceListTree* self,
                                                   gint x,
                                                   gint y,
                                                   gboolean keyboard_tooltip,
                                                   GtkTooltip* tooltip)
{
	GtkTreePath* path = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp0_;
	GtkTreeViewColumn* _tmp1_;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreePath* _tmp3_;
	GraniteWidgetsSourceListItem* item = NULL;
	GraniteWidgetsSourceListDataModel* _tmp4_;
	GtkTreePath* _tmp5_;
	GraniteWidgetsSourceListItem* _tmp6_;
	GraniteWidgetsSourceListItem* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp0_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	column = _tmp1_;
	gtk_tree_view_get_tooltip_context ((GtkTreeView*) self, &x, &y, keyboard_tooltip, NULL, &_tmp2_, NULL);
	__vala_GtkTreePath_free0 (path);
	path = _tmp2_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (column);
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	_tmp4_ = self->priv->_data_model;
	_tmp5_ = path;
	_tmp6_ = granite_widgets_source_list_data_model_get_item_from_path (_tmp4_, _tmp5_);
	item = _tmp6_;
	_tmp7_ = item;
	if (_tmp7_ != NULL) {
		gboolean should_show = FALSE;
		GdkRectangle start_cell_area = {0};
		GtkTreePath* _tmp8_;
		GtkTreeViewColumn* _tmp9_;
		GdkRectangle _tmp10_ = {0};
		GtkTreePath* _tmp11_;
		GraniteWidgetsSourceListItem* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp24_ = FALSE;
		GtkTreeViewColumn* _tmp25_;
		GtkTreePath* _tmp26_;
		GtkCellRendererText* _tmp27_;
		GdkRectangle _tmp28_;
		should_show = FALSE;
		_tmp8_ = path;
		_tmp9_ = column;
		gtk_tree_view_get_cell_area ((GtkTreeView*) self, _tmp8_, _tmp9_, &_tmp10_);
		start_cell_area = _tmp10_;
		_tmp11_ = path;
		gtk_tree_view_set_tooltip_row ((GtkTreeView*) self, tooltip, _tmp11_);
		_tmp12_ = item;
		_tmp13_ = granite_widgets_source_list_item_get_tooltip (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == NULL) {
			GraniteWidgetsSourceListItem* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = item;
			_tmp16_ = granite_widgets_source_list_item_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			gtk_tooltip_set_markup (tooltip, _tmp17_);
			should_show = TRUE;
		} else {
			GraniteWidgetsSourceListItem* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = item;
			_tmp19_ = granite_widgets_source_list_item_get_tooltip (_tmp18_);
			_tmp20_ = _tmp19_;
			if (g_strcmp0 (_tmp20_, "") != 0) {
				GraniteWidgetsSourceListItem* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = item;
				_tmp22_ = granite_widgets_source_list_item_get_tooltip (_tmp21_);
				_tmp23_ = _tmp22_;
				gtk_tooltip_set_markup (tooltip, _tmp23_);
				should_show = TRUE;
			}
		}
		if (keyboard_tooltip) {
			result = should_show;
			_g_object_unref0 (item);
			_g_object_unref0 (column);
			__vala_GtkTreePath_free0 (path);
			return result;
		}
		_tmp25_ = column;
		_tmp26_ = path;
		_tmp27_ = self->priv->text_cell;
		_tmp28_ = start_cell_area;
		if (granite_widgets_source_list_tree_over_cell (self, _tmp25_, _tmp26_, (GtkCellRenderer*) _tmp27_, x - _tmp28_.x)) {
			_tmp24_ = TRUE;
		} else {
			GtkTreeViewColumn* _tmp29_;
			GtkTreePath* _tmp30_;
			GraniteWidgetsSourceListCellRendererIcon* _tmp31_;
			GdkRectangle _tmp32_;
			_tmp29_ = column;
			_tmp30_ = path;
			_tmp31_ = self->priv->icon_cell;
			_tmp32_ = start_cell_area;
			_tmp24_ = granite_widgets_source_list_tree_over_cell (self, _tmp29_, _tmp30_, (GtkCellRenderer*) _tmp31_, x - _tmp32_.x);
		}
		if (_tmp24_) {
			result = should_show;
			_g_object_unref0 (item);
			_g_object_unref0 (column);
			__vala_GtkTreePath_free0 (path);
			return result;
		} else {
			GtkTreeViewColumn* _tmp33_;
			GtkTreePath* _tmp34_;
			GraniteWidgetsSourceListCellRendererIcon* _tmp35_;
			GdkRectangle _tmp36_;
			_tmp33_ = column;
			_tmp34_ = path;
			_tmp35_ = self->priv->activatable_cell;
			_tmp36_ = start_cell_area;
			if (granite_widgets_source_list_tree_over_cell (self, _tmp33_, _tmp34_, (GtkCellRenderer*) _tmp35_, x - _tmp36_.x)) {
				GraniteWidgetsSourceListItem* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				_tmp37_ = item;
				_tmp38_ = granite_widgets_source_list_item_get_activatable_tooltip (_tmp37_);
				_tmp39_ = _tmp38_;
				if (g_strcmp0 (_tmp39_, "") == 0) {
					result = FALSE;
					_g_object_unref0 (item);
					_g_object_unref0 (column);
					__vala_GtkTreePath_free0 (path);
					return result;
				} else {
					GraniteWidgetsSourceListItem* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					_tmp40_ = item;
					_tmp41_ = granite_widgets_source_list_item_get_activatable_tooltip (_tmp40_);
					_tmp42_ = _tmp41_;
					gtk_tooltip_set_markup (tooltip, _tmp42_);
					result = TRUE;
					_g_object_unref0 (item);
					_g_object_unref0 (column);
					__vala_GtkTreePath_free0 (path);
					return result;
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (item);
	_g_object_unref0 (column);
	__vala_GtkTreePath_free0 (path);
	return result;
}

static void
_vala_array_add2 (GtkTargetEntry* * array,
                  gint* length,
                  gint* size,
                  const GtkTargetEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTargetEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add3 (GtkTargetEntry* * array,
                  gint* length,
                  gint* size,
                  const GtkTargetEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTargetEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static GtkTargetEntry*
granite_widgets_source_list_tree_append_row_target_entry (GtkTargetEntry* orig,
                                                          gint orig_length1,
                                                          gint* result_length1)
{
	static const GtkTargetEntry row_target_entry = {"GTK_TREE_MODEL_ROW", (guint) GTK_TARGET_SAME_WIDGET, (guint) 0};
	GtkTargetEntry* entries = NULL;
	GtkTargetEntry* _tmp0_;
	gint entries_length1;
	gint _entries_size_;
	GtkTargetEntry* _tmp2_;
	gint _tmp2__length1;
	GtkTargetEntry* result;
	_tmp0_ = g_new0 (GtkTargetEntry, 0);
	entries = _tmp0_;
	entries_length1 = 0;
	_entries_size_ = entries_length1;
	_vala_array_add2 (&entries, &entries_length1, &_entries_size_, &row_target_entry);
	if (orig != NULL) {
		{
			GtkTargetEntry* target_entry_collection = NULL;
			gint target_entry_collection_length1 = 0;
			gint _target_entry_collection_size_ = 0;
			gint target_entry_it = 0;
			target_entry_collection = orig;
			target_entry_collection_length1 = orig_length1;
			for (target_entry_it = 0; target_entry_it < target_entry_collection_length1; target_entry_it = target_entry_it + 1) {
				GtkTargetEntry target_entry = {0};
				target_entry = target_entry_collection[target_entry_it];
				{
					GtkTargetEntry _tmp1_;
					_tmp1_ = target_entry;
					_vala_array_add3 (&entries, &entries_length1, &_entries_size_, &_tmp1_);
				}
			}
		}
	}
	_tmp2_ = entries;
	_tmp2__length1 = entries_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_granite_widgets_source_list_tree_on_model_item_updated_granite_widgets_source_list_data_model_item_updated (GraniteWidgetsSourceListDataModel* _sender,
                                                                                                             GraniteWidgetsSourceListItem* item,
                                                                                                             gpointer self)
{
	granite_widgets_source_list_tree_on_model_item_updated ((GraniteWidgetsSourceListTree*) self, item);
}

static void
granite_widgets_source_list_tree_enable_item_property_monitor (GraniteWidgetsSourceListTree* self)
{
	GraniteWidgetsSourceListDataModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_data_model;
	g_signal_connect_object (_tmp0_, "item-updated", (GCallback) _granite_widgets_source_list_tree_on_model_item_updated_granite_widgets_source_list_data_model_item_updated, self, G_CONNECT_AFTER);
}

static void
granite_widgets_source_list_tree_disable_item_property_monitor (GraniteWidgetsSourceListTree* self)
{
	GraniteWidgetsSourceListDataModel* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_data_model;
	g_signal_parse_name ("item-updated", GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _granite_widgets_source_list_tree_on_model_item_updated_granite_widgets_source_list_data_model_item_updated, self);
}

static void
granite_widgets_source_list_tree_on_model_item_updated (GraniteWidgetsSourceListTree* self,
                                                        GraniteWidgetsSourceListItem* item)
{
	GraniteWidgetsSourceListExpandableItem* expandable_item = NULL;
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (item) ? ((GraniteWidgetsSourceListExpandableItem*) item) : NULL);
	expandable_item = _tmp0_;
	_tmp1_ = expandable_item;
	if (_tmp1_ != NULL) {
		GraniteWidgetsSourceListExpandableItem* _tmp2_;
		_tmp2_ = expandable_item;
		granite_widgets_source_list_tree_update_expansion (self, _tmp2_);
	}
	_g_object_unref0 (expandable_item);
}

static void
_granite_widgets_source_list_tree_spacer_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                   GtkCellRenderer* cell,
                                                                                   GtkTreeModel* tree_model,
                                                                                   GtkTreeIter* iter,
                                                                                   gpointer self)
{
	granite_widgets_source_list_tree_spacer_cell_data_func (cell_layout, cell, tree_model, iter);
}

static void
granite_widgets_source_list_tree_add_spacer_cell_for_level (GraniteWidgetsSourceListTree* self,
                                                            gint level,
                                                            gboolean check_previous)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (level > 0, "level > 0");
	_tmp0_ = self->priv->spacer_cells;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, GRANITE_WIDGETS_SOURCE_LIST_TYPE_CELL_RENDERER_SPACER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->spacer_cells);
		self->priv->spacer_cells = _tmp1_;
	}
	_tmp2_ = self->priv->spacer_cells;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) level))) {
		GraniteWidgetsSourceListCellRendererSpacer* spacer_cell = NULL;
		GraniteWidgetsSourceListCellRendererSpacer* _tmp3_;
		GraniteWidgetsSourceListCellRendererSpacer* _tmp4_;
		GeeHashMap* _tmp5_;
		GraniteWidgetsSourceListCellRendererSpacer* _tmp6_;
		guint cell_xpadding = 0U;
		GraniteWidgetsSourceListCellRendererSpacer* _tmp9_;
		GtkTreeViewColumn* item_column = NULL;
		GtkTreeViewColumn* _tmp10_;
		GtkTreeViewColumn* _tmp11_;
		GtkTreeViewColumn* _tmp12_;
		GraniteWidgetsSourceListCellRendererSpacer* _tmp13_;
		GtkTreeViewColumn* _tmp14_;
		GraniteWidgetsSourceListCellRendererSpacer* _tmp15_;
		_tmp3_ = granite_widgets_source_list_cell_renderer_spacer_new ();
		g_object_ref_sink (_tmp3_);
		spacer_cell = _tmp3_;
		_tmp4_ = spacer_cell;
		granite_widgets_source_list_cell_renderer_spacer_set_level (_tmp4_, level);
		_tmp5_ = self->priv->spacer_cells;
		_tmp6_ = spacer_cell;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, (gpointer) ((gintptr) level), _tmp6_);
		switch (level) {
			case 1:
			{
				gint left_padding = 0;
				gint _tmp7_ = 0;
				gtk_widget_style_get ((GtkWidget*) self, GRANITE_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEFT_PADDING, &_tmp7_, NULL);
				left_padding = _tmp7_;
				cell_xpadding = (guint) (left_padding / 2);
				break;
			}
			case 2:
			{
				cell_xpadding = (guint) 0;
				break;
			}
			default:
			{
				gint level_indentation = 0;
				gint _tmp8_ = 0;
				gtk_widget_style_get ((GtkWidget*) self, GRANITE_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEVEL_INDENTATION, &_tmp8_, NULL);
				level_indentation = _tmp8_;
				cell_xpadding = (guint) (level_indentation / 2);
				break;
			}
		}
		_tmp9_ = spacer_cell;
		g_object_set ((GtkCellRenderer*) _tmp9_, "xpad", cell_xpadding, NULL);
		_tmp10_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		item_column = _tmp11_;
		_tmp12_ = item_column;
		_tmp13_ = spacer_cell;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) _tmp13_, FALSE);
		_tmp14_ = item_column;
		_tmp15_ = spacer_cell;
		gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp14_, (GtkCellRenderer*) _tmp15_, _granite_widgets_source_list_tree_spacer_cell_data_func_gtk_cell_layout_data_func, NULL, NULL);
		if (check_previous) {
			{
				gint i = 0;
				i = level - 1;
				{
					gboolean _tmp16_ = FALSE;
					_tmp16_ = TRUE;
					while (TRUE) {
						if (!_tmp16_) {
							gint _tmp17_;
							_tmp17_ = i;
							i = _tmp17_ - 1;
						}
						_tmp16_ = FALSE;
						if (!(i > 0)) {
							break;
						}
						granite_widgets_source_list_tree_add_spacer_cell_for_level (self, i, FALSE);
					}
				}
			}
		}
		_g_object_unref0 (item_column);
		_g_object_unref0 (spacer_cell);
	}
}

/**
         * Evaluates whether the item at the specified path can be selected or not.
         */
static gboolean
granite_widgets_source_list_tree_select_func (GraniteWidgetsSourceListTree* self,
                                              GtkTreeSelection* selection,
                                              GtkTreeModel* model,
                                              GtkTreePath* path,
                                              gboolean path_currently_selected)
{
	gboolean selectable = FALSE;
	GraniteWidgetsSourceListItem* item = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GraniteWidgetsSourceListItem* _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (selection != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	selectable = FALSE;
	_tmp0_ = self->priv->_data_model;
	_tmp1_ = granite_widgets_source_list_data_model_get_item_from_path (_tmp0_, path);
	item = _tmp1_;
	_tmp2_ = item;
	if (_tmp2_ != NULL) {
		GraniteWidgetsSourceListDataModel* _tmp3_;
		GraniteWidgetsSourceListItem* _tmp4_;
		_tmp3_ = self->priv->_data_model;
		_tmp4_ = item;
		if (!granite_widgets_source_list_data_model_is_category (_tmp3_, _tmp4_, NULL, path)) {
			GraniteWidgetsSourceListItem* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp5_ = item;
			_tmp6_ = granite_widgets_source_list_item_get_selectable (_tmp5_);
			_tmp7_ = _tmp6_;
			selectable = _tmp7_;
		}
	}
	result = selectable;
	_g_object_unref0 (item);
	return result;
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static GtkTreePath*
granite_widgets_source_list_tree_get_selected_path (GraniteWidgetsSourceListTree* self)
{
	GtkTreePath* selected_path = NULL;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	selected_path = NULL;
	_tmp0_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selection = _tmp1_;
	_tmp2_ = selection;
	if (_tmp2_ != NULL) {
		GtkTreeModel* model = NULL;
		GList* selected_rows = NULL;
		GtkTreeSelection* _tmp3_;
		GtkTreeModel* _tmp4_ = NULL;
		GList* _tmp5_;
		GtkTreeModel* _tmp6_;
		GList* _tmp7_;
		_tmp3_ = selection;
		_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
		_g_object_unref0 (model);
		_tmp6_ = _g_object_ref0 (_tmp4_);
		model = _tmp6_;
		selected_rows = _tmp5_;
		_tmp7_ = selected_rows;
		if (g_list_length (_tmp7_) == ((guint) 1)) {
			GList* _tmp8_;
			gconstpointer _tmp9_;
			GtkTreePath* _tmp10_;
			_tmp8_ = selected_rows;
			_tmp9_ = g_list_nth_data (_tmp8_, (guint) 0);
			_tmp10_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp9_);
			__vala_GtkTreePath_free0 (selected_path);
			selected_path = _tmp10_;
		}
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
		_g_object_unref0 (model);
	}
	result = selected_path;
	_g_object_unref0 (selection);
	return result;
}

static void
granite_widgets_source_list_tree_set_selected (GraniteWidgetsSourceListTree* self,
                                               GraniteWidgetsSourceListItem* item,
                                               gboolean scroll_to_item)
{
	g_return_if_fail (self != NULL);
	if (item == NULL) {
		GtkTreeSelection* selection = NULL;
		GtkTreeSelection* _tmp0_;
		GtkTreeSelection* _tmp1_;
		GtkTreeSelection* _tmp2_;
		_tmp0_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		selection = _tmp1_;
		_tmp2_ = selection;
		if (_tmp2_ != NULL) {
			GtkTreeSelection* _tmp3_;
			_tmp3_ = selection;
			gtk_tree_selection_unselect_all (_tmp3_);
		}
		_g_object_unref0 (self->priv->selected);
		self->priv->selected = NULL;
		g_signal_emit (self, granite_widgets_source_list_tree_signals[GRANITE_WIDGETS_SOURCE_LIST_TREE_ITEM_SELECTED_SIGNAL], 0, NULL);
		_g_object_unref0 (selection);
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = granite_widgets_source_list_item_get_selectable (item);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			GtkTreePath* to_select = NULL;
			GraniteWidgetsSourceListDataModel* _tmp6_;
			GtkTreePath* _tmp7_;
			GtkTreePath* _tmp8_;
			if (scroll_to_item) {
				granite_widgets_source_list_tree_scroll_to_item (self, item, FALSE, (gfloat) 0);
			}
			_tmp6_ = self->priv->_data_model;
			_tmp7_ = granite_widgets_source_list_data_model_get_item_path (_tmp6_, item);
			to_select = _tmp7_;
			_tmp8_ = to_select;
			if (_tmp8_ != NULL) {
				GtkTreePath* _tmp9_;
				GtkTreeViewColumn* _tmp10_;
				GtkCellRendererText* _tmp11_;
				_tmp9_ = to_select;
				_tmp10_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
				_tmp11_ = self->priv->text_cell;
				gtk_tree_view_set_cursor_on_cell ((GtkTreeView*) self, _tmp9_, _tmp10_, (GtkCellRenderer*) _tmp11_, FALSE);
			}
			__vala_GtkTreePath_free0 (to_select);
		}
	}
}

static void
granite_widgets_source_list_tree_real_cursor_changed (GtkTreeView* base)
{
	GraniteWidgetsSourceListTree * self;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GraniteWidgetsSourceListItem* _tmp1_ = NULL;
	GtkTreePath* _tmp2_;
	GraniteWidgetsSourceListItem* new_item = NULL;
	GraniteWidgetsSourceListItem* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GraniteWidgetsSourceListItem* _tmp8_;
	self = (GraniteWidgetsSourceListTree*) base;
	_tmp0_ = granite_widgets_source_list_tree_get_selected_path (self);
	path = _tmp0_;
	_tmp2_ = path;
	if (_tmp2_ != NULL) {
		GraniteWidgetsSourceListDataModel* _tmp3_;
		GtkTreePath* _tmp4_;
		GraniteWidgetsSourceListItem* _tmp5_;
		_tmp3_ = self->priv->_data_model;
		_tmp4_ = path;
		_tmp5_ = granite_widgets_source_list_data_model_get_item_from_path (_tmp3_, _tmp4_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp5_;
	} else {
		_g_object_unref0 (_tmp1_);
		_tmp1_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp1_);
	new_item = _tmp6_;
	_tmp8_ = new_item;
	if (_tmp8_ != NULL) {
		GraniteWidgetsSourceListItem* _tmp9_;
		GraniteWidgetsSourceListItem* _tmp10_;
		_tmp9_ = new_item;
		_tmp10_ = self->priv->selected;
		_tmp7_ = _tmp9_ != _tmp10_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GraniteWidgetsSourceListItem* _tmp11_;
		GraniteWidgetsSourceListItem* _tmp12_;
		GraniteWidgetsSourceListItem* _tmp13_;
		_tmp11_ = new_item;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (self->priv->selected);
		self->priv->selected = _tmp12_;
		_tmp13_ = new_item;
		g_signal_emit (self, granite_widgets_source_list_tree_signals[GRANITE_WIDGETS_SOURCE_LIST_TREE_ITEM_SELECTED_SIGNAL], 0, _tmp13_);
	}
	_g_object_unref0 (new_item);
	_g_object_unref0 (_tmp1_);
	__vala_GtkTreePath_free0 (path);
}

static gboolean
granite_widgets_source_list_tree_scroll_to_item (GraniteWidgetsSourceListTree* self,
                                                 GraniteWidgetsSourceListItem* item,
                                                 gboolean use_align,
                                                 gfloat row_align)
{
	gboolean scrolled = FALSE;
	GtkTreePath* path = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	scrolled = FALSE;
	_tmp0_ = self->priv->_data_model;
	_tmp1_ = granite_widgets_source_list_data_model_get_item_path (_tmp0_, item);
	path = _tmp1_;
	_tmp2_ = path;
	if (_tmp2_ != NULL) {
		GtkTreePath* _tmp3_;
		_tmp3_ = path;
		gtk_tree_view_scroll_to_cell ((GtkTreeView*) self, _tmp3_, NULL, use_align, row_align, (gfloat) 0);
		scrolled = TRUE;
	}
	result = scrolled;
	__vala_GtkTreePath_free0 (path);
	return result;
}

static gboolean
granite_widgets_source_list_tree_start_editing_item (GraniteWidgetsSourceListTree* self,
                                                     GraniteWidgetsSourceListItem* item)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkTreePath* path = NULL;
	GraniteWidgetsSourceListDataModel* _tmp8_;
	GtkTreePath* _tmp9_;
	GtkTreePath* _tmp10_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = granite_widgets_source_list_item_get_editable (item);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_, "item.editable", FALSE);
	_tmp2_ = granite_widgets_source_list_item_get_selectable (item);
	_tmp3_ = _tmp2_;
	_vala_return_val_if_fail (_tmp3_, "item.selectable", FALSE);
	_tmp5_ = granite_widgets_source_list_tree_get_editing (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		GraniteWidgetsSourceListItem* _tmp7_;
		_tmp7_ = self->priv->edited;
		_tmp4_ = item == _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->priv->_data_model;
	_tmp9_ = granite_widgets_source_list_data_model_get_item_path (_tmp8_, item);
	path = _tmp9_;
	_tmp10_ = path;
	if (_tmp10_ != NULL) {
		GtkCellRendererText* _tmp11_;
		GtkTreePath* _tmp12_;
		GtkTreeViewColumn* _tmp13_;
		GtkCellRendererText* _tmp14_;
		self->priv->edited = item;
		_tmp11_ = self->priv->text_cell;
		g_object_set (_tmp11_, "editable", TRUE, NULL);
		_tmp12_ = path;
		_tmp13_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
		_tmp14_ = self->priv->text_cell;
		gtk_tree_view_set_cursor_on_cell ((GtkTreeView*) self, _tmp12_, _tmp13_, (GtkCellRenderer*) _tmp14_, TRUE);
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = granite_widgets_source_list_item_get_name (item);
		_tmp16_ = _tmp15_;
		g_warning ("SourceList.vala:2109: Could not edit \"%s\": path not found", _tmp16_);
	}
	_tmp17_ = granite_widgets_source_list_tree_get_editing (self);
	_tmp18_ = _tmp17_;
	result = _tmp18_;
	__vala_GtkTreePath_free0 (path);
	return result;
}

static void
granite_widgets_source_list_tree_stop_editing (GraniteWidgetsSourceListTree* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = granite_widgets_source_list_tree_get_editing (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GraniteWidgetsSourceListItem* _tmp3_;
		_tmp3_ = self->priv->edited;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTreePath* path = NULL;
		GraniteWidgetsSourceListDataModel* _tmp4_;
		GraniteWidgetsSourceListItem* _tmp5_;
		GtkTreePath* _tmp6_;
		GtkTreePath* _tmp7_;
		_tmp4_ = self->priv->_data_model;
		_tmp5_ = self->priv->edited;
		_tmp6_ = granite_widgets_source_list_data_model_get_item_path (_tmp4_, _tmp5_);
		path = _tmp6_;
		_tmp7_ = path;
		if (_tmp7_ != NULL) {
			GtkTreePath* _tmp8_;
			GtkTreeViewColumn* _tmp9_;
			GtkCellRendererText* _tmp10_;
			_tmp8_ = path;
			_tmp9_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
			_tmp10_ = self->priv->text_cell;
			gtk_tree_view_set_cursor_on_cell ((GtkTreeView*) self, _tmp8_, _tmp9_, (GtkCellRenderer*) _tmp10_, FALSE);
		}
		__vala_GtkTreePath_free0 (path);
	}
}

static void
_granite_widgets_source_list_tree_on_editing_done_gtk_cell_editable_editing_done (GtkCellEditable* _sender,
                                                                                  gpointer self)
{
	granite_widgets_source_list_tree_on_editing_done ((GraniteWidgetsSourceListTree*) self);
}

static void
granite_widgets_source_list_tree_on_editing_started (GraniteWidgetsSourceListTree* self,
                                                     GtkCellEditable* editable,
                                                     const gchar* path)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (editable, gtk_entry_get_type ()) ? ((GtkEntry*) editable) : NULL);
	_g_object_unref0 (self->priv->editable_entry);
	self->priv->editable_entry = _tmp0_;
	_tmp1_ = self->priv->editable_entry;
	if (_tmp1_ != NULL) {
		GtkEntry* _tmp2_;
		GtkEntry* _tmp3_;
		_tmp2_ = self->priv->editable_entry;
		g_signal_connect_object ((GtkCellEditable*) _tmp2_, "editing-done", (GCallback) _granite_widgets_source_list_tree_on_editing_done_gtk_cell_editable_editing_done, self, 0);
		_tmp3_ = self->priv->editable_entry;
		g_object_set (_tmp3_, "editable", TRUE, NULL);
	}
}

static void
granite_widgets_source_list_tree_on_editing_canceled (GraniteWidgetsSourceListTree* self)
{
	GtkEntry* _tmp0_;
	GtkCellRendererText* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->editable_entry;
	if (_tmp0_ != NULL) {
		GtkEntry* _tmp1_;
		GtkEntry* _tmp2_;
		guint _tmp3_;
		_tmp1_ = self->priv->editable_entry;
		g_object_set (_tmp1_, "editable", FALSE, NULL);
		_tmp2_ = self->priv->editable_entry;
		g_signal_parse_name ("editing-done", gtk_cell_editable_get_type (), &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkCellEditable*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _granite_widgets_source_list_tree_on_editing_done_gtk_cell_editable_editing_done, self);
	}
	_tmp4_ = self->priv->text_cell;
	g_object_set (_tmp4_, "editable", FALSE, NULL);
	self->priv->edited = NULL;
}

static void
granite_widgets_source_list_tree_on_editing_done (GraniteWidgetsSourceListTree* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GraniteWidgetsSourceListItem* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->edited;
	if (_tmp2_ != NULL) {
		GraniteWidgetsSourceListItem* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->edited;
		_tmp4_ = granite_widgets_source_list_item_get_editable (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkEntry* _tmp6_;
		_tmp6_ = self->priv->editable_entry;
		_tmp0_ = _tmp6_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GraniteWidgetsSourceListItem* _tmp7_;
		GtkEntry* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = self->priv->edited;
		_tmp8_ = self->priv->editable_entry;
		_tmp9_ = gtk_entry_get_text (_tmp8_);
		g_signal_emit (_tmp7_, granite_widgets_source_list_item_signals[GRANITE_WIDGETS_SOURCE_LIST_ITEM_EDITED_SIGNAL], 0, _tmp9_);
	}
	granite_widgets_source_list_tree_on_editing_canceled (self);
}

static void
granite_widgets_source_list_tree_on_activatable_activated (GraniteWidgetsSourceListTree* self,
                                                           const gchar* item_path_str)
{
	GraniteWidgetsSourceListItem* item = NULL;
	GraniteWidgetsSourceListItem* _tmp0_;
	GraniteWidgetsSourceListItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item_path_str != NULL);
	_tmp0_ = granite_widgets_source_list_tree_get_item_from_path_string (self, item_path_str);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ != NULL) {
		GraniteWidgetsSourceListItem* _tmp2_;
		_tmp2_ = item;
		g_signal_emit (_tmp2_, granite_widgets_source_list_item_signals[GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTION_ACTIVATED_SIGNAL], 0);
	}
	_g_object_unref0 (item);
}

static GraniteWidgetsSourceListItem*
granite_widgets_source_list_tree_get_item_from_path_string (GraniteWidgetsSourceListTree* self,
                                                            const gchar* item_path_str)
{
	GtkTreePath* item_path = NULL;
	GtkTreePath* _tmp0_;
	GraniteWidgetsSourceListDataModel* _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_;
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_path_str != NULL, NULL);
	_tmp0_ = gtk_tree_path_new_from_string (item_path_str);
	item_path = _tmp0_;
	_tmp1_ = self->priv->_data_model;
	_tmp2_ = granite_widgets_source_list_data_model_get_item_from_path (_tmp1_, item_path);
	result = _tmp2_;
	__vala_GtkTreePath_free0 (item_path);
	return result;
}

static gboolean
granite_widgets_source_list_tree_toggle_expansion (GraniteWidgetsSourceListTree* self,
                                                   GraniteWidgetsSourceListExpandableItem* item)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = granite_widgets_source_list_expandable_item_get_collapsible (item);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = granite_widgets_source_list_expandable_item_get_expanded (item);
		_tmp3_ = _tmp2_;
		granite_widgets_source_list_expandable_item_set_expanded (item, !_tmp3_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

/**
         * Updates the tree to reflect the ''expanded'' property of expandable_item.
         */
static void
granite_widgets_source_list_tree_update_expansion (GraniteWidgetsSourceListTree* self,
                                                   GraniteWidgetsSourceListExpandableItem* expandable_item)
{
	GtkTreePath* path = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expandable_item != NULL);
	_tmp0_ = self->priv->_data_model;
	_tmp1_ = granite_widgets_source_list_data_model_get_item_path (_tmp0_, (GraniteWidgetsSourceListItem*) expandable_item);
	path = _tmp1_;
	_tmp2_ = path;
	if (_tmp2_ != NULL) {
		GtkTreePath* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = path;
		granite_widgets_source_list_tree_add_spacer_cell_for_level (self, gtk_tree_path_get_depth (_tmp3_) + 1, TRUE);
		_tmp4_ = granite_widgets_source_list_expandable_item_get_expanded (expandable_item);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			GtkTreePath* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GraniteWidgetsSourceListItem* _tmp8_;
			_tmp6_ = path;
			gtk_tree_view_expand_row ((GtkTreeView*) self, _tmp6_, FALSE);
			_tmp8_ = self->priv->selected;
			if (_tmp8_ != NULL) {
				GraniteWidgetsSourceListItem* _tmp9_;
				GraniteWidgetsSourceListExpandableItem* _tmp10_;
				GraniteWidgetsSourceListExpandableItem* _tmp11_;
				_tmp9_ = self->priv->selected;
				_tmp10_ = granite_widgets_source_list_item_get_parent (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp7_ = _tmp11_ == expandable_item;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				GraniteWidgetsSourceListItem* _tmp12_;
				_tmp12_ = self->priv->selected;
				granite_widgets_source_list_tree_set_selected (self, _tmp12_, TRUE);
			}
			{
				GeeIterator* _child_item_it = NULL;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GeeCollection* _tmp15_;
				GeeIterator* _tmp16_;
				GeeIterator* _tmp17_;
				_tmp13_ = granite_widgets_source_list_expandable_item_get_children (expandable_item);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_;
				_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
				_tmp17_ = _tmp16_;
				_g_object_unref0 (_tmp15_);
				_child_item_it = _tmp17_;
				while (TRUE) {
					GeeIterator* _tmp18_;
					GraniteWidgetsSourceListItem* child_item = NULL;
					GeeIterator* _tmp19_;
					gpointer _tmp20_;
					GraniteWidgetsSourceListExpandableItem* child_expandable_item = NULL;
					GraniteWidgetsSourceListItem* _tmp21_;
					GraniteWidgetsSourceListExpandableItem* _tmp22_;
					GraniteWidgetsSourceListExpandableItem* _tmp23_;
					_tmp18_ = _child_item_it;
					if (!gee_iterator_next (_tmp18_)) {
						break;
					}
					_tmp19_ = _child_item_it;
					_tmp20_ = gee_iterator_get (_tmp19_);
					child_item = (GraniteWidgetsSourceListItem*) _tmp20_;
					_tmp21_ = child_item;
					_tmp22_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp21_) ? ((GraniteWidgetsSourceListExpandableItem*) _tmp21_) : NULL);
					child_expandable_item = _tmp22_;
					_tmp23_ = child_expandable_item;
					if (_tmp23_ != NULL) {
						GraniteWidgetsSourceListExpandableItem* _tmp24_;
						_tmp24_ = child_expandable_item;
						granite_widgets_source_list_tree_update_expansion (self, _tmp24_);
					}
					_g_object_unref0 (child_expandable_item);
					_g_object_unref0 (child_item);
				}
				_g_object_unref0 (_child_item_it);
			}
		} else {
			GtkTreePath* _tmp25_;
			_tmp25_ = path;
			gtk_tree_view_collapse_row ((GtkTreeView*) self, _tmp25_);
		}
	}
	__vala_GtkTreePath_free0 (path);
}

static void
granite_widgets_source_list_tree_real_row_expanded (GtkTreeView* base,
                                                    GtkTreeIter* iter,
                                                    GtkTreePath* path)
{
	GraniteWidgetsSourceListTree * self;
	GraniteWidgetsSourceListExpandableItem* item = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_;
	GraniteWidgetsSourceListExpandableItem* _tmp3_;
	self = (GraniteWidgetsSourceListTree*) base;
	g_return_if_fail (iter != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_data_model;
	_tmp1_ = *iter;
	_tmp2_ = granite_widgets_source_list_data_model_get_item (_tmp0_, &_tmp1_);
	_tmp3_ = GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp2_) ? ((GraniteWidgetsSourceListExpandableItem*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	item = _tmp3_;
	g_return_if_fail (item != NULL);
	granite_widgets_source_list_tree_disable_item_property_monitor (self);
	granite_widgets_source_list_expandable_item_set_expanded (item, TRUE);
	granite_widgets_source_list_tree_enable_item_property_monitor (self);
	_g_object_unref0 (item);
}

static void
granite_widgets_source_list_tree_real_row_collapsed (GtkTreeView* base,
                                                     GtkTreeIter* iter,
                                                     GtkTreePath* path)
{
	GraniteWidgetsSourceListTree * self;
	GraniteWidgetsSourceListExpandableItem* item = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_;
	GraniteWidgetsSourceListExpandableItem* _tmp3_;
	self = (GraniteWidgetsSourceListTree*) base;
	g_return_if_fail (iter != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_data_model;
	_tmp1_ = *iter;
	_tmp2_ = granite_widgets_source_list_data_model_get_item (_tmp0_, &_tmp1_);
	_tmp3_ = GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp2_) ? ((GraniteWidgetsSourceListExpandableItem*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	item = _tmp3_;
	g_return_if_fail (item != NULL);
	granite_widgets_source_list_tree_disable_item_property_monitor (self);
	granite_widgets_source_list_expandable_item_set_expanded (item, FALSE);
	granite_widgets_source_list_tree_enable_item_property_monitor (self);
	_g_object_unref0 (item);
}

static void
granite_widgets_source_list_tree_real_row_activated (GtkTreeView* base,
                                                     GtkTreePath* path,
                                                     GtkTreeViewColumn* column)
{
	GraniteWidgetsSourceListTree * self;
	GtkTreeViewColumn* _tmp0_;
	self = (GraniteWidgetsSourceListTree*) base;
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
	if (column == _tmp0_) {
		GraniteWidgetsSourceListItem* item = NULL;
		GraniteWidgetsSourceListDataModel* _tmp1_;
		GraniteWidgetsSourceListItem* _tmp2_;
		GraniteWidgetsSourceListItem* _tmp3_;
		_tmp1_ = self->priv->_data_model;
		_tmp2_ = granite_widgets_source_list_data_model_get_item_from_path (_tmp1_, path);
		item = _tmp2_;
		_tmp3_ = item;
		if (_tmp3_ != NULL) {
			GraniteWidgetsSourceListItem* _tmp4_;
			_tmp4_ = item;
			g_signal_emit (_tmp4_, granite_widgets_source_list_item_signals[GRANITE_WIDGETS_SOURCE_LIST_ITEM_ACTIVATED_SIGNAL], 0);
		}
		_g_object_unref0 (item);
	}
}

static gboolean
granite_widgets_source_list_tree_real_key_release_event (GtkWidget* base,
                                                         GdkEventKey* event)
{
	GraniteWidgetsSourceListTree * self;
	GraniteWidgetsSourceListItem* _tmp0_;
	GraniteWidgetsSourceListItem* _tmp1_;
	gboolean result;
	self = (GraniteWidgetsSourceListTree*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = granite_widgets_source_list_tree_get_selected_item (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		switch (event->keyval) {
			case GDK_KEY_F2:
			{
				GdkModifierType modifiers = 0U;
				gboolean _tmp2_ = FALSE;
				modifiers = gtk_accelerator_get_default_mod_mask ();
				if ((event->state & modifiers) == 0) {
					GraniteWidgetsSourceListItem* _tmp3_;
					GraniteWidgetsSourceListItem* _tmp4_;
					gboolean _tmp5_;
					gboolean _tmp6_;
					_tmp3_ = granite_widgets_source_list_tree_get_selected_item (self);
					_tmp4_ = _tmp3_;
					_tmp5_ = granite_widgets_source_list_item_get_editable (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp2_ = _tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					GraniteWidgetsSourceListItem* _tmp7_;
					GraniteWidgetsSourceListItem* _tmp8_;
					_tmp7_ = granite_widgets_source_list_tree_get_selected_item (self);
					_tmp8_ = _tmp7_;
					granite_widgets_source_list_tree_start_editing_item (self, _tmp8_);
				}
				break;
			}
			default:
			break;
		}
	}
	result = GTK_WIDGET_CLASS (granite_widgets_source_list_tree_parent_class)->key_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
	return result;
}

static gboolean
granite_widgets_source_list_tree_real_button_release_event (GtkWidget* base,
                                                            GdkEventButton* event)
{
	GraniteWidgetsSourceListTree * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (GraniteWidgetsSourceListTree*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->unselectable_item_clicked) {
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
		_tmp1_ = event->window;
		_tmp2_ = gtk_tree_view_get_bin_window ((GtkTreeView*) self);
		_tmp0_ = _tmp1_ == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTreePath* path = NULL;
		GtkTreeViewColumn* column = NULL;
		gint x = 0;
		gint y = 0;
		gint cell_x = 0;
		gint cell_y = 0;
		GtkTreePath* _tmp3_ = NULL;
		GtkTreeViewColumn* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gboolean _tmp7_;
		GtkTreeViewColumn* _tmp8_;
		self->priv->unselectable_item_clicked = FALSE;
		x = (gint) event->x;
		y = (gint) event->y;
		_tmp7_ = gtk_tree_view_get_path_at_pos ((GtkTreeView*) self, x, y, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp3_;
		_g_object_unref0 (column);
		_tmp8_ = _g_object_ref0 (_tmp4_);
		column = _tmp8_;
		cell_x = _tmp5_;
		cell_y = _tmp6_;
		if (_tmp7_) {
			GraniteWidgetsSourceListExpandableItem* item = NULL;
			GraniteWidgetsSourceListDataModel* _tmp9_;
			GtkTreePath* _tmp10_;
			GraniteWidgetsSourceListItem* _tmp11_;
			GraniteWidgetsSourceListExpandableItem* _tmp12_;
			GraniteWidgetsSourceListExpandableItem* _tmp13_;
			_tmp9_ = self->priv->_data_model;
			_tmp10_ = path;
			_tmp11_ = granite_widgets_source_list_data_model_get_item_from_path (_tmp9_, _tmp10_);
			_tmp12_ = GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp11_) ? ((GraniteWidgetsSourceListExpandableItem*) _tmp11_) : NULL;
			if (_tmp12_ == NULL) {
				_g_object_unref0 (_tmp11_);
			}
			item = _tmp12_;
			_tmp13_ = item;
			if (_tmp13_ != NULL) {
				gboolean _tmp14_ = FALSE;
				GraniteWidgetsSourceListExpandableItem* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp15_ = item;
				_tmp16_ = granite_widgets_source_list_item_get_selectable ((GraniteWidgetsSourceListItem*) _tmp15_);
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					_tmp14_ = TRUE;
				} else {
					GraniteWidgetsSourceListDataModel* _tmp18_;
					GraniteWidgetsSourceListExpandableItem* _tmp19_;
					GtkTreePath* _tmp20_;
					_tmp18_ = self->priv->_data_model;
					_tmp19_ = item;
					_tmp20_ = path;
					_tmp14_ = granite_widgets_source_list_data_model_is_category (_tmp18_, (GraniteWidgetsSourceListItem*) _tmp19_, NULL, _tmp20_);
				}
				if (_tmp14_) {
					GraniteWidgetsSourceListExpandableItem* _tmp21_;
					_tmp21_ = item;
					granite_widgets_source_list_tree_toggle_expansion (self, _tmp21_);
				}
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (column);
		__vala_GtkTreePath_free0 (path);
	}
	result = GTK_WIDGET_CLASS (granite_widgets_source_list_tree_parent_class)->button_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
	return result;
}

static gboolean
granite_widgets_source_list_tree_real_button_press_event (GtkWidget* base,
                                                          GdkEventButton* event)
{
	GraniteWidgetsSourceListTree * self;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GtkTreePath* path = NULL;
	GtkTreeViewColumn* column = NULL;
	gint x = 0;
	gint y = 0;
	gint cell_x = 0;
	gint cell_y = 0;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreeViewColumn* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	GtkTreeViewColumn* _tmp7_;
	gboolean result;
	self = (GraniteWidgetsSourceListTree*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->window;
	_tmp1_ = gtk_tree_view_get_bin_window ((GtkTreeView*) self);
	if (_tmp0_ != _tmp1_) {
		result = GTK_WIDGET_CLASS (granite_widgets_source_list_tree_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
		return result;
	}
	x = (gint) event->x;
	y = (gint) event->y;
	_tmp6_ = gtk_tree_view_get_path_at_pos ((GtkTreeView*) self, x, y, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	__vala_GtkTreePath_free0 (path);
	path = _tmp2_;
	_g_object_unref0 (column);
	_tmp7_ = _g_object_ref0 (_tmp3_);
	column = _tmp7_;
	cell_x = _tmp4_;
	cell_y = _tmp5_;
	if (_tmp6_) {
		GraniteWidgetsSourceListItem* item = NULL;
		GraniteWidgetsSourceListDataModel* _tmp8_;
		GtkTreePath* _tmp9_;
		GraniteWidgetsSourceListItem* _tmp10_;
		GdkRectangle start_cell_area = {0};
		GtkTreePath* _tmp11_;
		GtkTreeViewColumn* _tmp12_;
		GdkRectangle _tmp13_ = {0};
		GdkRectangle _tmp14_;
		gboolean _tmp15_ = FALSE;
		GraniteWidgetsSourceListItem* _tmp16_;
		_tmp8_ = self->priv->_data_model;
		_tmp9_ = path;
		_tmp10_ = granite_widgets_source_list_data_model_get_item_from_path (_tmp8_, _tmp9_);
		item = _tmp10_;
		_tmp11_ = path;
		_tmp12_ = gtk_tree_view_get_column ((GtkTreeView*) self, 0);
		gtk_tree_view_get_cell_area ((GtkTreeView*) self, _tmp11_, _tmp12_, &_tmp13_);
		start_cell_area = _tmp13_;
		_tmp14_ = start_cell_area;
		cell_x -= _tmp14_.x;
		_tmp16_ = item;
		if (_tmp16_ != NULL) {
			GtkTreeViewColumn* _tmp17_;
			GtkTreeViewColumn* _tmp18_;
			_tmp17_ = column;
			_tmp18_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
			_tmp15_ = _tmp17_ == _tmp18_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			granite_widgets_source_list_tree_stop_editing (self);
			if (event->button == ((guint) GDK_BUTTON_SECONDARY)) {
				GraniteWidgetsSourceListItem* _tmp19_;
				_tmp19_ = item;
				granite_widgets_source_list_tree_popup_context_menu (self, _tmp19_, event);
				result = TRUE;
				_g_object_unref0 (item);
				_g_object_unref0 (column);
				__vala_GtkTreePath_free0 (path);
				return result;
			} else {
				if (event->button == ((guint) GDK_BUTTON_PRIMARY)) {
					gboolean is_expandable = FALSE;
					GraniteWidgetsSourceListItem* _tmp20_;
					gboolean _tmp21_ = FALSE;
					gboolean is_category = FALSE;
					_tmp20_ = item;
					is_expandable = GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp20_);
					if (is_expandable) {
						GraniteWidgetsSourceListDataModel* _tmp22_;
						GraniteWidgetsSourceListItem* _tmp23_;
						GtkTreePath* _tmp24_;
						_tmp22_ = self->priv->_data_model;
						_tmp23_ = item;
						_tmp24_ = path;
						_tmp21_ = granite_widgets_source_list_data_model_is_category (_tmp22_, _tmp23_, NULL, _tmp24_);
					} else {
						_tmp21_ = FALSE;
					}
					is_category = _tmp21_;
					if (event->type == GDK_BUTTON_PRESS) {
						if (is_expandable) {
							gboolean _tmp25_ = FALSE;
							gboolean _tmp33_ = FALSE;
							gboolean _tmp34_ = FALSE;
							if (is_category) {
								_tmp25_ = TRUE;
							} else {
								gboolean _tmp26_ = FALSE;
								GraniteWidgetsSourceListItem* _tmp27_;
								gboolean _tmp28_;
								gboolean _tmp29_;
								_tmp27_ = item;
								_tmp28_ = granite_widgets_source_list_item_get_selectable (_tmp27_);
								_tmp29_ = _tmp28_;
								if (!_tmp29_) {
									GtkTreeViewColumn* _tmp30_;
									GtkTreePath* _tmp31_;
									GraniteWidgetsSourceListCellRendererIcon* _tmp32_;
									_tmp30_ = column;
									_tmp31_ = path;
									_tmp32_ = self->priv->activatable_cell;
									_tmp26_ = !granite_widgets_source_list_tree_over_cell (self, _tmp30_, _tmp31_, (GtkCellRenderer*) _tmp32_, cell_x);
								} else {
									_tmp26_ = FALSE;
								}
								_tmp25_ = _tmp26_;
							}
							self->priv->unselectable_item_clicked = _tmp25_;
							if (!self->priv->unselectable_item_clicked) {
								GtkTreeViewColumn* _tmp35_;
								GtkTreePath* _tmp36_;
								_tmp35_ = column;
								_tmp36_ = path;
								_tmp34_ = granite_widgets_source_list_tree_over_primary_expander (self, _tmp35_, _tmp36_, cell_x);
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								GraniteWidgetsSourceListItem* _tmp37_;
								_tmp37_ = item;
								_tmp33_ = granite_widgets_source_list_tree_toggle_expansion (self, GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp37_) ? ((GraniteWidgetsSourceListExpandableItem*) _tmp37_) : NULL);
							} else {
								_tmp33_ = FALSE;
							}
							if (_tmp33_) {
								result = TRUE;
								_g_object_unref0 (item);
								_g_object_unref0 (column);
								__vala_GtkTreePath_free0 (path);
								return result;
							}
						}
					} else {
						gboolean _tmp38_ = FALSE;
						gboolean _tmp39_ = FALSE;
						gboolean _tmp40_ = FALSE;
						gboolean _tmp41_ = FALSE;
						gboolean _tmp42_ = FALSE;
						if (event->type == GDK_2BUTTON_PRESS) {
							_tmp42_ = !is_category;
						} else {
							_tmp42_ = FALSE;
						}
						if (_tmp42_) {
							GraniteWidgetsSourceListItem* _tmp43_;
							gboolean _tmp44_;
							gboolean _tmp45_;
							_tmp43_ = item;
							_tmp44_ = granite_widgets_source_list_item_get_editable (_tmp43_);
							_tmp45_ = _tmp44_;
							_tmp41_ = _tmp45_;
						} else {
							_tmp41_ = FALSE;
						}
						if (_tmp41_) {
							GraniteWidgetsSourceListItem* _tmp46_;
							gboolean _tmp47_;
							gboolean _tmp48_;
							_tmp46_ = item;
							_tmp47_ = granite_widgets_source_list_item_get_selectable (_tmp46_);
							_tmp48_ = _tmp47_;
							_tmp40_ = _tmp48_;
						} else {
							_tmp40_ = FALSE;
						}
						if (_tmp40_) {
							GtkTreeViewColumn* _tmp49_;
							GtkTreePath* _tmp50_;
							GtkCellRendererText* _tmp51_;
							_tmp49_ = column;
							_tmp50_ = path;
							_tmp51_ = self->priv->text_cell;
							_tmp39_ = granite_widgets_source_list_tree_over_cell (self, _tmp49_, _tmp50_, (GtkCellRenderer*) _tmp51_, cell_x);
						} else {
							_tmp39_ = FALSE;
						}
						if (_tmp39_) {
							GraniteWidgetsSourceListItem* _tmp52_;
							_tmp52_ = item;
							_tmp38_ = granite_widgets_source_list_tree_start_editing_item (self, _tmp52_);
						} else {
							_tmp38_ = FALSE;
						}
						if (_tmp38_) {
							result = TRUE;
							_g_object_unref0 (item);
							_g_object_unref0 (column);
							__vala_GtkTreePath_free0 (path);
							return result;
						}
					}
				}
			}
		}
		_g_object_unref0 (item);
	}
	result = GTK_WIDGET_CLASS (granite_widgets_source_list_tree_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
	_g_object_unref0 (column);
	__vala_GtkTreePath_free0 (path);
	return result;
}

static gboolean
granite_widgets_source_list_tree_over_primary_expander (GraniteWidgetsSourceListTree* self,
                                                        GtkTreeViewColumn* col,
                                                        GtkTreePath* path,
                                                        gint x)
{
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GraniteWidgetsCellRendererExpander* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeIter _tmp7_;
	GraniteWidgetsCellRendererExpander* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GtkTreeModel* _tmp11_;
	GtkTreeModel* _tmp12_;
	GtkTreeIter _tmp13_;
	gint indentation_level = 0;
	GraniteWidgetsSourceListCellRendererSpacer* last_spacer_cell = NULL;
	GeeHashMap* _tmp14_;
	gpointer _tmp15_;
	GraniteWidgetsSourceListCellRendererSpacer* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (col != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = gtk_tree_view_get_model ((GtkTreeView*) self);
	_tmp1_ = _tmp0_;
	_tmp3_ = gtk_tree_model_get_iter (_tmp1_, &_tmp2_, path);
	iter = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->primary_expander_cell;
	_tmp5_ = gtk_tree_view_get_model ((GtkTreeView*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = iter;
	granite_widgets_source_list_tree_expander_cell_data_func (self, (GtkCellLayout*) col, (GtkCellRenderer*) _tmp4_, _tmp6_, &_tmp7_);
	_tmp8_ = self->priv->primary_expander_cell;
	_tmp9_ = gtk_cell_renderer_get_visible ((GtkCellRenderer*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (!_tmp10_) {
		result = FALSE;
		return result;
	}
	_tmp11_ = gtk_tree_view_get_model ((GtkTreeView*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = iter;
	if (gtk_tree_model_iter_n_children (_tmp12_, &_tmp13_) < 1) {
		result = FALSE;
		return result;
	}
	indentation_level = gtk_tree_path_get_depth (path);
	_tmp14_ = self->priv->spacer_cells;
	_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, (gpointer) ((gintptr) indentation_level));
	last_spacer_cell = (GraniteWidgetsSourceListCellRendererSpacer*) _tmp15_;
	_tmp16_ = last_spacer_cell;
	if (_tmp16_ != NULL) {
		gint cell_x = 0;
		gint cell_width = 0;
		GraniteWidgetsSourceListCellRendererSpacer* _tmp17_;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gboolean _tmp20_;
		_tmp17_ = last_spacer_cell;
		_tmp20_ = gtk_tree_view_column_cell_get_position (col, (GtkCellRenderer*) _tmp17_, &_tmp18_, &_tmp19_);
		cell_x = _tmp18_;
		cell_width = _tmp19_;
		if (_tmp20_) {
			gint expander_width = 0;
			GraniteWidgetsCellRendererExpander* _tmp21_;
			GtkTextDirection dir = 0;
			gboolean _tmp23_ = FALSE;
			_tmp21_ = self->priv->primary_expander_cell;
			expander_width = granite_widgets_source_list_tree_get_cell_width (self, (GtkCellRenderer*) _tmp21_) + 1;
			dir = gtk_widget_get_direction ((GtkWidget*) self);
			if (dir == GTK_TEXT_DIR_NONE) {
				dir = gtk_widget_get_default_direction ();
			}
			if (dir == GTK_TEXT_DIR_LTR) {
				gint indentation_offset = 0;
				gboolean _tmp22_ = FALSE;
				indentation_offset = cell_x + cell_width;
				if (x >= indentation_offset) {
					_tmp22_ = x <= (indentation_offset + expander_width);
				} else {
					_tmp22_ = FALSE;
				}
				result = _tmp22_;
				_g_object_unref0 (last_spacer_cell);
				return result;
			}
			if (x <= cell_x) {
				_tmp23_ = x >= (cell_x - expander_width);
			} else {
				_tmp23_ = FALSE;
			}
			result = _tmp23_;
			_g_object_unref0 (last_spacer_cell);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (last_spacer_cell);
	return result;
}

static gboolean
granite_widgets_source_list_tree_over_cell (GraniteWidgetsSourceListTree* self,
                                            GtkTreeViewColumn* col,
                                            GtkTreePath* path,
                                            GtkCellRenderer* cell,
                                            gint x)
{
	gint cell_x = 0;
	gint cell_width = 0;
	gboolean found = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (col != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (cell != NULL, FALSE);
	_tmp2_ = gtk_tree_view_column_cell_get_position (col, cell, &_tmp0_, &_tmp1_);
	cell_x = _tmp0_;
	cell_width = _tmp1_;
	found = _tmp2_;
	if (found) {
		_tmp4_ = x > cell_x;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = x < (cell_x + cell_width);
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

static gint
granite_widgets_source_list_tree_get_cell_width (GraniteWidgetsSourceListTree* self,
                                                 GtkCellRenderer* cell_renderer)
{
	GtkRequisition min_req = {0};
	GtkRequisition _tmp0_ = {0};
	GtkRequisition _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (cell_renderer != NULL, 0);
	gtk_cell_renderer_get_preferred_size (cell_renderer, (GtkWidget*) self, &_tmp0_, NULL);
	min_req = _tmp0_;
	_tmp1_ = min_req;
	result = _tmp1_.width;
	return result;
}

static gboolean
granite_widgets_source_list_tree_real_popup_menu (GtkWidget* base)
{
	GraniteWidgetsSourceListTree * self;
	gboolean result;
	self = (GraniteWidgetsSourceListTree*) base;
	result = granite_widgets_source_list_tree_popup_context_menu (self, NULL, NULL);
	return result;
}

static gboolean
granite_widgets_source_list_tree_popup_context_menu (GraniteWidgetsSourceListTree* self,
                                                     GraniteWidgetsSourceListItem* item,
                                                     GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (item == NULL) {
		GraniteWidgetsSourceListItem* _tmp0_;
		GraniteWidgetsSourceListItem* _tmp1_;
		_tmp0_ = granite_widgets_source_list_tree_get_selected_item (self);
		_tmp1_ = _tmp0_;
		item = _tmp1_;
	}
	if (item != NULL) {
		GtkMenu* menu = NULL;
		GtkMenu* _tmp2_;
		GtkMenu* _tmp3_;
		_tmp2_ = granite_widgets_source_list_item_get_context_menu (item);
		menu = _tmp2_;
		_tmp3_ = menu;
		if (_tmp3_ != NULL) {
			GtkMenu* _tmp4_;
			GtkMenu* _tmp5_;
			_tmp4_ = menu;
			g_object_set (_tmp4_, "attach-widget", (GtkWidget*) self, NULL);
			_tmp5_ = menu;
			gtk_menu_popup_at_pointer (_tmp5_, (GdkEvent*) event);
			if (event == NULL) {
				GtkMenu* _tmp6_;
				_tmp6_ = menu;
				gtk_menu_shell_select_first ((GtkMenuShell*) _tmp6_, FALSE);
			}
			result = TRUE;
			_g_object_unref0 (menu);
			return result;
		}
		_g_object_unref0 (menu);
	}
	result = FALSE;
	return result;
}

static GraniteWidgetsSourceListItem*
granite_widgets_source_list_tree_get_item_from_model (GtkTreeModel* model,
                                                      GtkTreeIter* iter)
{
	GraniteWidgetsSourceListDataModel* data_model = NULL;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_;
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_IS_DATA_MODEL (model) ? ((GraniteWidgetsSourceListDataModel*) model) : NULL);
	data_model = _tmp0_;
	_vala_assert (data_model != NULL, "data_model != null");
	_tmp1_ = *iter;
	_tmp2_ = granite_widgets_source_list_data_model_get_item (data_model, &_tmp1_);
	result = _tmp2_;
	_g_object_unref0 (data_model);
	return result;
}

static void
granite_widgets_source_list_tree_spacer_cell_data_func (GtkCellLayout* layout,
                                                        GtkCellRenderer* renderer,
                                                        GtkTreeModel* model,
                                                        GtkTreeIter* iter)
{
	GraniteWidgetsSourceListCellRendererSpacer* spacer = NULL;
	GraniteWidgetsSourceListCellRendererSpacer* _tmp0_;
	GraniteWidgetsSourceListCellRendererSpacer* _tmp1_;
	GraniteWidgetsSourceListCellRendererSpacer* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp5_;
	GtkTreePath* _tmp6_;
	gint level = 0;
	GtkTreePath* _tmp7_;
	GraniteWidgetsSourceListCellRendererSpacer* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_SPACER (renderer) ? ((GraniteWidgetsSourceListCellRendererSpacer*) renderer) : NULL);
	spacer = _tmp0_;
	_tmp1_ = spacer;
	_vala_assert (_tmp1_ != NULL, "spacer != null");
	_tmp2_ = spacer;
	_tmp3_ = granite_widgets_source_list_cell_renderer_spacer_get_level (_tmp2_);
	_tmp4_ = _tmp3_;
	_vala_assert (_tmp4_ > 0, "spacer.level > 0");
	_tmp5_ = *iter;
	_tmp6_ = gtk_tree_model_get_path (model, &_tmp5_);
	path = _tmp6_;
	level = -1;
	_tmp7_ = path;
	if (_tmp7_ != NULL) {
		GtkTreePath* _tmp8_;
		_tmp8_ = path;
		level = gtk_tree_path_get_depth (_tmp8_);
	}
	_tmp9_ = spacer;
	_tmp10_ = granite_widgets_source_list_cell_renderer_spacer_get_level (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_cell_renderer_set_visible (renderer, _tmp11_ <= level);
	__vala_GtkTreePath_free0 (path);
	_g_object_unref0 (spacer);
}

static void
granite_widgets_source_list_tree_name_cell_data_func (GraniteWidgetsSourceListTree* self,
                                                      GtkCellLayout* layout,
                                                      GtkCellRenderer* renderer,
                                                      GtkTreeModel* model,
                                                      GtkTreeIter* iter)
{
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp0_;
	GtkCellRendererText* _tmp1_;
	GString* text = NULL;
	GString* _tmp2_;
	PangoWeight weight = 0;
	gboolean use_markup = FALSE;
	GraniteWidgetsSourceListItem* item = NULL;
	GtkTreeIter _tmp3_;
	GraniteWidgetsSourceListItem* _tmp4_;
	GraniteWidgetsSourceListItem* _tmp5_;
	GtkCellRendererText* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (renderer, gtk_cell_renderer_text_get_type ()) ? ((GtkCellRendererText*) renderer) : NULL);
	text_renderer = _tmp0_;
	_tmp1_ = text_renderer;
	_vala_assert (_tmp1_ != NULL, "text_renderer != null");
	_tmp2_ = g_string_new ("");
	text = _tmp2_;
	weight = PANGO_WEIGHT_NORMAL;
	use_markup = FALSE;
	_tmp3_ = *iter;
	_tmp4_ = granite_widgets_source_list_tree_get_item_from_model (model, &_tmp3_);
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != NULL) {
		GraniteWidgetsSourceListItem* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GraniteWidgetsSourceListDataModel* _tmp17_;
		GraniteWidgetsSourceListItem* _tmp18_;
		GtkTreeIter _tmp19_;
		_tmp6_ = item;
		_tmp7_ = granite_widgets_source_list_item_get_markup (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != NULL) {
			GString* _tmp9_;
			GraniteWidgetsSourceListItem* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp9_ = text;
			_tmp10_ = item;
			_tmp11_ = granite_widgets_source_list_item_get_markup (_tmp10_);
			_tmp12_ = _tmp11_;
			g_string_append (_tmp9_, _tmp12_);
			use_markup = TRUE;
		} else {
			GString* _tmp13_;
			GraniteWidgetsSourceListItem* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp13_ = text;
			_tmp14_ = item;
			_tmp15_ = granite_widgets_source_list_item_get_name (_tmp14_);
			_tmp16_ = _tmp15_;
			g_string_append (_tmp13_, _tmp16_);
		}
		_tmp17_ = self->priv->_data_model;
		_tmp18_ = item;
		_tmp19_ = *iter;
		if (granite_widgets_source_list_data_model_is_category (_tmp17_, _tmp18_, &_tmp19_, NULL)) {
			weight = PANGO_WEIGHT_BOLD;
		}
	}
	_tmp20_ = text_renderer;
	g_object_set (_tmp20_, "weight", (gint) weight, NULL);
	if (use_markup) {
		GtkCellRendererText* _tmp21_;
		GString* _tmp22_;
		const gchar* _tmp23_;
		_tmp21_ = text_renderer;
		_tmp22_ = text;
		_tmp23_ = _tmp22_->str;
		g_object_set (_tmp21_, "markup", _tmp23_, NULL);
	} else {
		GtkCellRendererText* _tmp24_;
		GString* _tmp25_;
		const gchar* _tmp26_;
		_tmp24_ = text_renderer;
		_tmp25_ = text;
		_tmp26_ = _tmp25_->str;
		g_object_set (_tmp24_, "text", _tmp26_, NULL);
	}
	_g_object_unref0 (item);
	_g_string_free0 (text);
	_g_object_unref0 (text_renderer);
}

static void
granite_widgets_source_list_tree_badge_cell_data_func (GraniteWidgetsSourceListTree* self,
                                                       GtkCellLayout* layout,
                                                       GtkCellRenderer* renderer,
                                                       GtkTreeModel* model,
                                                       GtkTreeIter* iter)
{
	GraniteWidgetsCellRendererBadge* badge_renderer = NULL;
	GraniteWidgetsCellRendererBadge* _tmp0_;
	GraniteWidgetsCellRendererBadge* _tmp1_;
	gchar* text = NULL;
	gchar* _tmp2_;
	gboolean visible = FALSE;
	GraniteWidgetsSourceListItem* item = NULL;
	GtkTreeIter _tmp3_;
	GraniteWidgetsSourceListItem* _tmp4_;
	GraniteWidgetsSourceListItem* _tmp5_;
	GraniteWidgetsCellRendererBadge* _tmp23_;
	GraniteWidgetsCellRendererBadge* _tmp24_;
	const gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _g_object_ref0 (GRANITE_WIDGETS_IS_CELL_RENDERER_BADGE (renderer) ? ((GraniteWidgetsCellRendererBadge*) renderer) : NULL);
	badge_renderer = _tmp0_;
	_tmp1_ = badge_renderer;
	_vala_assert (_tmp1_ != NULL, "badge_renderer != null");
	_tmp2_ = g_strdup ("");
	text = _tmp2_;
	visible = FALSE;
	_tmp3_ = *iter;
	_tmp4_ = granite_widgets_source_list_tree_get_item_from_model (model, &_tmp3_);
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != NULL) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		GraniteWidgetsSourceListDataModel* _tmp8_;
		GraniteWidgetsSourceListItem* _tmp9_;
		GtkTreeIter _tmp10_;
		_tmp8_ = self->priv->_data_model;
		_tmp9_ = item;
		_tmp10_ = *iter;
		if (!granite_widgets_source_list_data_model_is_category (_tmp8_, _tmp9_, &_tmp10_, NULL)) {
			GraniteWidgetsSourceListItem* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = item;
			_tmp12_ = granite_widgets_source_list_item_get_badge (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = _tmp13_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GraniteWidgetsSourceListItem* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp14_ = item;
			_tmp15_ = granite_widgets_source_list_item_get_badge (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_strip (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp6_ = g_strcmp0 (_tmp18_, "") != 0;
			_g_free0 (_tmp18_);
		} else {
			_tmp6_ = FALSE;
		}
		visible = _tmp6_;
		if (visible) {
			GraniteWidgetsSourceListItem* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp19_ = item;
			_tmp20_ = granite_widgets_source_list_item_get_badge (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (text);
			text = _tmp22_;
		}
	}
	_tmp23_ = badge_renderer;
	gtk_cell_renderer_set_visible ((GtkCellRenderer*) _tmp23_, visible);
	_tmp24_ = badge_renderer;
	_tmp25_ = text;
	granite_widgets_cell_renderer_badge_set_text (_tmp24_, _tmp25_);
	_g_object_unref0 (item);
	_g_free0 (text);
	_g_object_unref0 (badge_renderer);
}

static void
granite_widgets_source_list_tree_icon_cell_data_func (GraniteWidgetsSourceListTree* self,
                                                      GtkCellLayout* layout,
                                                      GtkCellRenderer* renderer,
                                                      GtkTreeModel* model,
                                                      GtkTreeIter* iter)
{
	GraniteWidgetsSourceListCellRendererIcon* icon_renderer = NULL;
	GraniteWidgetsSourceListCellRendererIcon* _tmp0_;
	GraniteWidgetsSourceListCellRendererIcon* _tmp1_;
	gboolean visible = FALSE;
	GIcon* icon = NULL;
	GraniteWidgetsSourceListItem* item = NULL;
	GtkTreeIter _tmp2_;
	GraniteWidgetsSourceListItem* _tmp3_;
	GraniteWidgetsSourceListItem* _tmp4_;
	gboolean _tmp20_ = FALSE;
	GraniteWidgetsSourceListCellRendererIcon* _tmp22_;
	GIcon* _tmp23_ = NULL;
	GraniteWidgetsSourceListCellRendererIcon* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_IS_CELL_RENDERER_ICON (renderer) ? ((GraniteWidgetsSourceListCellRendererIcon*) renderer) : NULL);
	icon_renderer = _tmp0_;
	_tmp1_ = icon_renderer;
	_vala_assert (_tmp1_ != NULL, "icon_renderer != null");
	visible = FALSE;
	icon = NULL;
	_tmp2_ = *iter;
	_tmp3_ = granite_widgets_source_list_tree_get_item_from_model (model, &_tmp2_);
	item = _tmp3_;
	_tmp4_ = item;
	if (_tmp4_ != NULL) {
		GraniteWidgetsSourceListDataModel* _tmp5_;
		GraniteWidgetsSourceListItem* _tmp6_;
		GtkTreeIter _tmp7_;
		_tmp5_ = self->priv->_data_model;
		_tmp6_ = item;
		_tmp7_ = *iter;
		visible = !granite_widgets_source_list_data_model_is_category (_tmp5_, _tmp6_, &_tmp7_, NULL);
		if (visible) {
			GraniteWidgetsSourceListCellRendererIcon* _tmp8_;
			GraniteWidgetsSourceListCellRendererIcon* _tmp9_;
			_tmp8_ = icon_renderer;
			_tmp9_ = self->priv->icon_cell;
			if (_tmp8_ == _tmp9_) {
				GraniteWidgetsSourceListItem* _tmp10_;
				GIcon* _tmp11_;
				GIcon* _tmp12_;
				GIcon* _tmp13_;
				_tmp10_ = item;
				_tmp11_ = granite_widgets_source_list_item_get_icon (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_g_object_unref0 (icon);
				icon = _tmp13_;
			} else {
				GraniteWidgetsSourceListCellRendererIcon* _tmp14_;
				GraniteWidgetsSourceListCellRendererIcon* _tmp15_;
				_tmp14_ = icon_renderer;
				_tmp15_ = self->priv->activatable_cell;
				if (_tmp14_ == _tmp15_) {
					GraniteWidgetsSourceListItem* _tmp16_;
					GIcon* _tmp17_;
					GIcon* _tmp18_;
					GIcon* _tmp19_;
					_tmp16_ = item;
					_tmp17_ = granite_widgets_source_list_item_get_activatable (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = _g_object_ref0 (_tmp18_);
					_g_object_unref0 (icon);
					icon = _tmp19_;
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
	if (visible) {
		GIcon* _tmp21_;
		_tmp21_ = icon;
		_tmp20_ = _tmp21_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	visible = _tmp20_;
	_tmp22_ = icon_renderer;
	gtk_cell_renderer_set_visible ((GtkCellRenderer*) _tmp22_, visible);
	if (visible) {
		GIcon* _tmp24_;
		_tmp24_ = icon;
		_tmp23_ = _tmp24_;
	} else {
		_tmp23_ = NULL;
	}
	_tmp25_ = icon_renderer;
	g_object_set ((GtkCellRendererPixbuf*) _tmp25_, "gicon", _tmp23_, NULL);
	_g_object_unref0 (item);
	_g_object_unref0 (icon);
	_g_object_unref0 (icon_renderer);
}

/**
         * Controls expander visibility.
         */
static void
granite_widgets_source_list_tree_expander_cell_data_func (GraniteWidgetsSourceListTree* self,
                                                          GtkCellLayout* layout,
                                                          GtkCellRenderer* renderer,
                                                          GtkTreeModel* model,
                                                          GtkTreeIter* iter)
{
	GraniteWidgetsSourceListItem* item = NULL;
	GtkTreeIter _tmp0_;
	GraniteWidgetsSourceListItem* _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_;
	GraniteWidgetsCellRendererExpander* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	_tmp1_ = granite_widgets_source_list_tree_get_item_from_model (model, &_tmp0_);
	item = _tmp1_;
	_tmp2_ = item;
	if (_tmp2_ != NULL) {
		GraniteWidgetsSourceListExpandableItem* expandable_item = NULL;
		GraniteWidgetsSourceListItem* _tmp3_;
		GraniteWidgetsSourceListExpandableItem* _tmp4_;
		GraniteWidgetsSourceListExpandableItem* _tmp5_;
		_tmp3_ = item;
		_tmp4_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp3_) ? ((GraniteWidgetsSourceListExpandableItem*) _tmp3_) : NULL);
		expandable_item = _tmp4_;
		_tmp5_ = expandable_item;
		if (_tmp5_ != NULL) {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			gboolean _tmp8_;
			g_object_get (renderer, "is-expander", &_tmp7_, NULL);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				GraniteWidgetsSourceListExpandableItem* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = expandable_item;
				_tmp10_ = granite_widgets_source_list_expandable_item_get_collapsible (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp6_ = _tmp11_;
			} else {
				_tmp6_ = FALSE;
			}
			g_object_set (renderer, "is-expander", _tmp6_, NULL);
		}
		_g_object_unref0 (expandable_item);
	}
	_tmp12_ = self->priv->primary_expander_cell;
	if (renderer == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_cell_renderer_get_type (), GtkCellRenderer)) {
		GraniteWidgetsSourceListDataModel* _tmp13_;
		GtkTreeIter _tmp14_;
		_tmp13_ = self->priv->_data_model;
		_tmp14_ = *iter;
		gtk_cell_renderer_set_visible (renderer, !granite_widgets_source_list_data_model_is_iter_at_root_level (_tmp13_, &_tmp14_));
	} else {
		GraniteWidgetsCellRendererExpander* _tmp15_;
		_tmp15_ = self->priv->secondary_expander_cell;
		if (renderer == G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_cell_renderer_get_type (), GtkCellRenderer)) {
			GraniteWidgetsSourceListDataModel* _tmp16_;
			GraniteWidgetsSourceListItem* _tmp17_;
			GtkTreeIter _tmp18_;
			_tmp16_ = self->priv->_data_model;
			_tmp17_ = item;
			_tmp18_ = *iter;
			gtk_cell_renderer_set_visible (renderer, granite_widgets_source_list_data_model_is_category (_tmp16_, _tmp17_, &_tmp18_, NULL));
		} else {
			g_assert_not_reached ();
		}
	}
	_g_object_unref0 (item);
}

static void
_granite_widgets_source_list_tree_expander_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                     GtkCellRenderer* cell,
                                                                                     GtkTreeModel* tree_model,
                                                                                     GtkTreeIter* iter,
                                                                                     gpointer self)
{
	granite_widgets_source_list_tree_expander_cell_data_func ((GraniteWidgetsSourceListTree*) self, cell_layout, cell, tree_model, iter);
}

static void
_granite_widgets_source_list_tree_on_activatable_activated_granite_widgets_source_list_cell_renderer_icon_activated (GraniteWidgetsSourceListCellRendererIcon* _sender,
                                                                                                                     const gchar* path,
                                                                                                                     gpointer self)
{
	granite_widgets_source_list_tree_on_activatable_activated ((GraniteWidgetsSourceListTree*) self, path);
}

static void
_granite_widgets_source_list_tree_icon_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                 GtkCellRenderer* cell,
                                                                                 GtkTreeModel* tree_model,
                                                                                 GtkTreeIter* iter,
                                                                                 gpointer self)
{
	granite_widgets_source_list_tree_icon_cell_data_func ((GraniteWidgetsSourceListTree*) self, cell_layout, cell, tree_model, iter);
}

static void
_granite_widgets_source_list_tree_badge_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                  GtkCellRenderer* cell,
                                                                                  GtkTreeModel* tree_model,
                                                                                  GtkTreeIter* iter,
                                                                                  gpointer self)
{
	granite_widgets_source_list_tree_badge_cell_data_func ((GraniteWidgetsSourceListTree*) self, cell_layout, cell, tree_model, iter);
}

static void
_granite_widgets_source_list_tree_on_editing_started_gtk_cell_renderer_editing_started (GtkCellRenderer* _sender,
                                                                                        GtkCellEditable* editable,
                                                                                        const gchar* path,
                                                                                        gpointer self)
{
	granite_widgets_source_list_tree_on_editing_started ((GraniteWidgetsSourceListTree*) self, editable, path);
}

static void
_granite_widgets_source_list_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled (GtkCellRenderer* _sender,
                                                                                          gpointer self)
{
	granite_widgets_source_list_tree_on_editing_canceled ((GraniteWidgetsSourceListTree*) self);
}

static void
_granite_widgets_source_list_tree_name_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                 GtkCellRenderer* cell,
                                                                                 GtkTreeModel* tree_model,
                                                                                 GtkTreeIter* iter,
                                                                                 gpointer self)
{
	granite_widgets_source_list_tree_name_cell_data_func ((GraniteWidgetsSourceListTree*) self, cell_layout, cell, tree_model, iter);
}

static gboolean
_granite_widgets_source_list_tree_select_func_gtk_tree_selection_func (GtkTreeSelection* selection,
                                                                       GtkTreeModel* model,
                                                                       GtkTreePath* path,
                                                                       gboolean path_currently_selected,
                                                                       gpointer self)
{
	gboolean result;
	result = granite_widgets_source_list_tree_select_func ((GraniteWidgetsSourceListTree*) self, selection, model, path, path_currently_selected);
	return result;
}

static gboolean
_granite_widgets_source_list_tree_on_query_tooltip_gtk_widget_query_tooltip (GtkWidget* _sender,
                                                                             gint x,
                                                                             gint y,
                                                                             gboolean keyboard_tooltip,
                                                                             GtkTooltip* tooltip,
                                                                             gpointer self)
{
	gboolean result;
	result = granite_widgets_source_list_tree_on_query_tooltip ((GraniteWidgetsSourceListTree*) self, x, y, keyboard_tooltip, tooltip);
	return result;
}

static GObject *
granite_widgets_source_list_tree_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsSourceListTree * self;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp3_;
	GraniteWidgetsSourceListDataModel* _tmp9_;
	GtkTreeViewColumn* item_column = NULL;
	GtkTreeViewColumn* _tmp10_;
	GtkTreeViewColumn* _tmp11_;
	GtkTreeViewColumn* _tmp12_;
	GraniteWidgetsCellRendererExpander* _tmp13_;
	GraniteWidgetsCellRendererExpander* _tmp14_;
	GraniteWidgetsCellRendererExpander* _tmp15_;
	GtkTreeViewColumn* _tmp16_;
	GraniteWidgetsCellRendererExpander* _tmp17_;
	GtkTreeViewColumn* _tmp18_;
	GraniteWidgetsCellRendererExpander* _tmp19_;
	GraniteWidgetsSourceListCellRendererIcon* _tmp20_;
	GraniteWidgetsSourceListCellRendererIcon* _tmp21_;
	GraniteWidgetsSourceListCellRendererIcon* _tmp22_;
	GtkTreeViewColumn* _tmp23_;
	GraniteWidgetsSourceListCellRendererIcon* _tmp24_;
	GtkTreeViewColumn* _tmp25_;
	GraniteWidgetsSourceListCellRendererIcon* _tmp26_;
	GraniteWidgetsCellRendererBadge* _tmp27_;
	GraniteWidgetsCellRendererBadge* _tmp28_;
	GraniteWidgetsCellRendererBadge* _tmp29_;
	GtkTreeViewColumn* _tmp30_;
	GraniteWidgetsCellRendererBadge* _tmp31_;
	GtkTreeViewColumn* _tmp32_;
	GraniteWidgetsCellRendererBadge* _tmp33_;
	GtkCellRendererText* _tmp34_;
	GtkCellRendererText* _tmp35_;
	GtkCellRendererText* _tmp36_;
	GtkCellRendererText* _tmp37_;
	GtkCellRendererText* _tmp38_;
	GtkCellRendererText* _tmp39_;
	GtkCellRendererText* _tmp40_;
	GtkTreeViewColumn* _tmp41_;
	GtkCellRendererText* _tmp42_;
	GtkTreeViewColumn* _tmp43_;
	GtkCellRendererText* _tmp44_;
	GraniteWidgetsSourceListCellRendererIcon* _tmp45_;
	GraniteWidgetsSourceListCellRendererIcon* _tmp46_;
	GtkTreeViewColumn* _tmp47_;
	GraniteWidgetsSourceListCellRendererIcon* _tmp48_;
	GtkTreeViewColumn* _tmp49_;
	GraniteWidgetsSourceListCellRendererIcon* _tmp50_;
	GraniteWidgetsCellRendererExpander* _tmp51_;
	gint expander_spacing = 0;
	gint _tmp52_ = 0;
	GraniteWidgetsCellRendererExpander* _tmp53_;
	GtkTreeViewColumn* _tmp54_;
	GraniteWidgetsCellRendererExpander* _tmp55_;
	GtkTreeViewColumn* _tmp56_;
	GraniteWidgetsCellRendererExpander* _tmp57_;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp58_;
	GtkTreeSelection* _tmp59_;
	GtkTreeSelection* _tmp60_;
	GtkTreeSelection* _tmp61_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (granite_widgets_source_list_tree_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE, GraniteWidgetsSourceListTree);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	style_context = _tmp0_;
	_tmp1_ = style_context;
	gtk_style_context_add_class (_tmp1_, GTK_STYLE_CLASS_SIDEBAR);
	_tmp2_ = style_context;
	gtk_style_context_add_class (_tmp2_, GRANITE_STYLE_CLASS_SOURCE_LIST);
	_tmp3_ = gtk_css_provider_new ();
	css_provider = _tmp3_;
	{
		GtkCssProvider* _tmp4_;
		GtkStyleContext* _tmp5_;
		GtkCssProvider* _tmp6_;
		_tmp4_ = css_provider;
		gtk_css_provider_load_from_data (_tmp4_, GRANITE_WIDGETS_SOURCE_LIST_TREE_DEFAULT_STYLESHEET, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = style_context;
		_tmp6_ = css_provider;
		gtk_style_context_add_provider (_tmp5_, (GtkStyleProvider*) _tmp6_, (guint) GTK_STYLE_PROVIDER_PRIORITY_FALLBACK);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("SourceList.vala:1637: Could not create CSS Provider: %s\n" \
"Stylesheet:\n" \
"%s", _tmp8_, GRANITE_WIDGETS_SOURCE_LIST_TREE_DEFAULT_STYLESHEET);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp9_ = self->priv->_data_model;
	gtk_tree_view_set_model ((GtkTreeView*) self, (GtkTreeModel*) _tmp9_);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	gtk_tree_view_set_enable_search ((GtkTreeView*) self, FALSE);
	gtk_tree_view_set_headers_visible ((GtkTreeView*) self, FALSE);
	g_object_set ((GtkTreeView*) self, "enable-grid-lines", GTK_TREE_VIEW_GRID_LINES_NONE, NULL);
	gtk_tree_view_set_expander_column ((GtkTreeView*) self, NULL);
	gtk_tree_view_set_show_expanders ((GtkTreeView*) self, FALSE);
	_tmp10_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp10_);
	item_column = _tmp10_;
	_tmp11_ = item_column;
	gtk_tree_view_column_set_expand (_tmp11_, TRUE);
	_tmp12_ = item_column;
	gtk_tree_view_insert_column ((GtkTreeView*) self, _tmp12_, (gint) GRANITE_WIDGETS_SOURCE_LIST_TREE_COLUMN_ITEM);
	_tmp13_ = granite_widgets_cell_renderer_expander_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->secondary_expander_cell);
	self->priv->secondary_expander_cell = _tmp13_;
	_tmp14_ = self->priv->secondary_expander_cell;
	granite_widgets_cell_renderer_expander_set_is_category_expander (_tmp14_, TRUE);
	_tmp15_ = self->priv->secondary_expander_cell;
	g_object_set ((GtkCellRenderer*) _tmp15_, "xpad", (guint) 10, NULL);
	_tmp16_ = item_column;
	_tmp17_ = self->priv->secondary_expander_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp16_, (GtkCellRenderer*) _tmp17_, FALSE);
	_tmp18_ = item_column;
	_tmp19_ = self->priv->secondary_expander_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp18_, (GtkCellRenderer*) _tmp19_, _granite_widgets_source_list_tree_expander_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp20_ = granite_widgets_source_list_cell_renderer_icon_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->activatable_cell);
	self->priv->activatable_cell = _tmp20_;
	_tmp21_ = self->priv->activatable_cell;
	g_object_set ((GtkCellRenderer*) _tmp21_, "xpad", (guint) 6, NULL);
	_tmp22_ = self->priv->activatable_cell;
	g_signal_connect_object (_tmp22_, "activated", (GCallback) _granite_widgets_source_list_tree_on_activatable_activated_granite_widgets_source_list_cell_renderer_icon_activated, self, 0);
	_tmp23_ = item_column;
	_tmp24_ = self->priv->activatable_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp23_, (GtkCellRenderer*) _tmp24_, FALSE);
	_tmp25_ = item_column;
	_tmp26_ = self->priv->activatable_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp25_, (GtkCellRenderer*) _tmp26_, _granite_widgets_source_list_tree_icon_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp27_ = granite_widgets_cell_renderer_badge_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->badge_cell);
	self->priv->badge_cell = _tmp27_;
	_tmp28_ = self->priv->badge_cell;
	g_object_set ((GtkCellRenderer*) _tmp28_, "xpad", (guint) 1, NULL);
	_tmp29_ = self->priv->badge_cell;
	g_object_set ((GtkCellRenderer*) _tmp29_, "xalign", (gfloat) 1, NULL);
	_tmp30_ = item_column;
	_tmp31_ = self->priv->badge_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp30_, (GtkCellRenderer*) _tmp31_, FALSE);
	_tmp32_ = item_column;
	_tmp33_ = self->priv->badge_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp32_, (GtkCellRenderer*) _tmp33_, _granite_widgets_source_list_tree_badge_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp34_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->text_cell);
	self->priv->text_cell = _tmp34_;
	_tmp35_ = self->priv->text_cell;
	g_object_set (_tmp35_, "editable-set", TRUE, NULL);
	_tmp36_ = self->priv->text_cell;
	g_object_set (_tmp36_, "editable", FALSE, NULL);
	_tmp37_ = self->priv->text_cell;
	g_signal_connect_object ((GtkCellRenderer*) _tmp37_, "editing-started", (GCallback) _granite_widgets_source_list_tree_on_editing_started_gtk_cell_renderer_editing_started, self, 0);
	_tmp38_ = self->priv->text_cell;
	g_signal_connect_object ((GtkCellRenderer*) _tmp38_, "editing-canceled", (GCallback) _granite_widgets_source_list_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled, self, 0);
	_tmp39_ = self->priv->text_cell;
	g_object_set (_tmp39_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp40_ = self->priv->text_cell;
	g_object_set ((GtkCellRenderer*) _tmp40_, "xalign", (gfloat) 0, NULL);
	_tmp41_ = item_column;
	_tmp42_ = self->priv->text_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp41_, (GtkCellRenderer*) _tmp42_, TRUE);
	_tmp43_ = item_column;
	_tmp44_ = self->priv->text_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp43_, (GtkCellRenderer*) _tmp44_, _granite_widgets_source_list_tree_name_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp45_ = granite_widgets_source_list_cell_renderer_icon_new ();
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->icon_cell);
	self->priv->icon_cell = _tmp45_;
	_tmp46_ = self->priv->icon_cell;
	g_object_set ((GtkCellRenderer*) _tmp46_, "xpad", (guint) 2, NULL);
	_tmp47_ = item_column;
	_tmp48_ = self->priv->icon_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp47_, (GtkCellRenderer*) _tmp48_, FALSE);
	_tmp49_ = item_column;
	_tmp50_ = self->priv->icon_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp49_, (GtkCellRenderer*) _tmp50_, _granite_widgets_source_list_tree_icon_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp51_ = granite_widgets_cell_renderer_expander_new ();
	g_object_ref_sink (_tmp51_);
	_g_object_unref0 (self->priv->primary_expander_cell);
	self->priv->primary_expander_cell = _tmp51_;
	gtk_widget_style_get ((GtkWidget*) self, GRANITE_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_EXPANDER_SPACING, &_tmp52_, NULL);
	expander_spacing = _tmp52_;
	_tmp53_ = self->priv->primary_expander_cell;
	g_object_set ((GtkCellRenderer*) _tmp53_, "xpad", (guint) (expander_spacing / 2), NULL);
	_tmp54_ = item_column;
	_tmp55_ = self->priv->primary_expander_cell;
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp54_, (GtkCellRenderer*) _tmp55_, FALSE);
	_tmp56_ = item_column;
	_tmp57_ = self->priv->primary_expander_cell;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp56_, (GtkCellRenderer*) _tmp57_, _granite_widgets_source_list_tree_expander_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp58_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
	_tmp59_ = _g_object_ref0 (_tmp58_);
	selection = _tmp59_;
	_tmp60_ = selection;
	gtk_tree_selection_set_mode (_tmp60_, GTK_SELECTION_BROWSE);
	_tmp61_ = selection;
	gtk_tree_selection_set_select_function (_tmp61_, _granite_widgets_source_list_tree_select_func_gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	granite_widgets_source_list_tree_enable_item_property_monitor (self);
	granite_widgets_source_list_tree_add_spacer_cell_for_level (self, 1, TRUE);
	granite_widgets_source_list_tree_configure_drag_source (self, NULL, (gint) 0);
	granite_widgets_source_list_tree_configure_drag_dest (self, NULL, (gint) 0, 0);
	g_signal_connect_object ((GtkWidget*) self, "query-tooltip", (GCallback) _granite_widgets_source_list_tree_on_query_tooltip_gtk_widget_query_tooltip, self, G_CONNECT_AFTER);
	gtk_widget_set_has_tooltip ((GtkWidget*) self, TRUE);
	_g_object_unref0 (selection);
	_g_object_unref0 (item_column);
	_g_object_unref0 (css_provider);
	return obj;
}

static void
granite_widgets_source_list_tree_class_init (GraniteWidgetsSourceListTreeClass * klass,
                                             gpointer klass_data)
{
	GParamSpecInt* _tmp0_;
	GParamSpecInt* _tmp1_;
	GParamSpecInt* _tmp2_;
	GParamSpecInt* _tmp3_;
	GParamSpecInt* _tmp4_;
	GParamSpecInt* _tmp5_;
	granite_widgets_source_list_tree_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListTree_private_offset);
	((GtkWidgetClass *) klass)->drag_motion = (gboolean (*) (GtkWidget*, GdkDragContext*, gint, gint, guint)) granite_widgets_source_list_tree_real_drag_motion;
	((GtkWidgetClass *) klass)->drag_data_received = (void (*) (GtkWidget*, GdkDragContext*, gint, gint, GtkSelectionData*, guint, guint)) granite_widgets_source_list_tree_real_drag_data_received;
	((GtkTreeViewClass *) klass)->cursor_changed = (void (*) (GtkTreeView*)) granite_widgets_source_list_tree_real_cursor_changed;
	((GtkTreeViewClass *) klass)->row_expanded = (void (*) (GtkTreeView*, GtkTreeIter*, GtkTreePath*)) granite_widgets_source_list_tree_real_row_expanded;
	((GtkTreeViewClass *) klass)->row_collapsed = (void (*) (GtkTreeView*, GtkTreeIter*, GtkTreePath*)) granite_widgets_source_list_tree_real_row_collapsed;
	((GtkTreeViewClass *) klass)->row_activated = (void (*) (GtkTreeView*, GtkTreePath*, GtkTreeViewColumn*)) granite_widgets_source_list_tree_real_row_activated;
	((GtkWidgetClass *) klass)->key_release_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) granite_widgets_source_list_tree_real_key_release_event;
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) granite_widgets_source_list_tree_real_button_release_event;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) granite_widgets_source_list_tree_real_button_press_event;
	((GtkWidgetClass *) klass)->popup_menu = (gboolean (*) (GtkWidget*)) granite_widgets_source_list_tree_real_popup_menu;
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_tree_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_tree_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_source_list_tree_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_tree_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY, granite_widgets_source_list_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY] = g_param_spec_object ("data-model", "data-model", "data-model", GRANITE_WIDGETS_SOURCE_LIST_TYPE_DATA_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY, granite_widgets_source_list_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY] = g_param_spec_object ("selected-item", "selected-item", "selected-item", GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_TREE_EDITING_PROPERTY, granite_widgets_source_list_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_TREE_EDITING_PROPERTY] = g_param_spec_boolean ("editing", "editing", "editing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY, granite_widgets_source_list_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY] = g_param_spec_enum ("ellipsize-mode", "ellipsize-mode", "ellipsize-mode", pango_ellipsize_mode_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	granite_widgets_source_list_tree_signals[GRANITE_WIDGETS_SOURCE_LIST_TREE_ITEM_SELECTED_SIGNAL] = g_signal_new ("item-selected", GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM);
	_tmp0_ = (GParamSpecInt*) g_param_spec_int (GRANITE_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEVEL_INDENTATION, "Level Indentation", "Space to add at the beginning of every indentation level. Must be an e" \
"ven number.", 1, 50, 6, G_PARAM_READABLE);
	_tmp1_ = _tmp0_;
	gtk_widget_class_install_style_property (GTK_WIDGET_CLASS (klass), (GParamSpec*) _tmp1_);
	_g_param_spec_unref0 (_tmp1_);
	_tmp2_ = (GParamSpecInt*) g_param_spec_int (GRANITE_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_LEFT_PADDING, "Left Padding", "Padding added to the left side of the tree. Must be an even number.", 1, 50, 4, G_PARAM_READABLE);
	_tmp3_ = _tmp2_;
	gtk_widget_class_install_style_property (GTK_WIDGET_CLASS (klass), (GParamSpec*) _tmp3_);
	_g_param_spec_unref0 (_tmp3_);
	_tmp4_ = (GParamSpecInt*) g_param_spec_int (GRANITE_WIDGETS_SOURCE_LIST_TREE_STYLE_PROP_EXPANDER_SPACING, "Expander Spacing", "Space added between an item and its expander. Must be an even number.", 1, 50, 4, G_PARAM_READABLE);
	_tmp5_ = _tmp4_;
	gtk_widget_class_install_style_property (GTK_WIDGET_CLASS (klass), (GParamSpec*) _tmp5_);
	_g_param_spec_unref0 (_tmp5_);
}

static void
granite_widgets_source_list_tree_instance_init (GraniteWidgetsSourceListTree * self,
                                                gpointer klass)
{
	self->priv = granite_widgets_source_list_tree_get_instance_private (self);
	self->priv->unselectable_item_clicked = FALSE;
}

static void
granite_widgets_source_list_tree_finalize (GObject * obj)
{
	GraniteWidgetsSourceListTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE, GraniteWidgetsSourceListTree);
	granite_widgets_source_list_tree_disable_item_property_monitor (self);
	_g_object_unref0 (self->priv->_data_model);
	_g_object_unref0 (self->priv->selected);
	_g_object_unref0 (self->priv->editable_entry);
	_g_object_unref0 (self->priv->text_cell);
	_g_object_unref0 (self->priv->icon_cell);
	_g_object_unref0 (self->priv->activatable_cell);
	_g_object_unref0 (self->priv->badge_cell);
	_g_object_unref0 (self->priv->primary_expander_cell);
	_g_object_unref0 (self->priv->secondary_expander_cell);
	_g_object_unref0 (self->priv->spacer_cells);
	G_OBJECT_CLASS (granite_widgets_source_list_tree_parent_class)->finalize (obj);
}

/**
     * The tree that actually displays the items.
     *
     * All the user interaction happens here.
     */
static GType
granite_widgets_source_list_tree_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListTree), 0, (GInstanceInitFunc) granite_widgets_source_list_tree_instance_init, NULL };
	GType granite_widgets_source_list_tree_type_id;
	granite_widgets_source_list_tree_type_id = g_type_register_static (gtk_tree_view_get_type (), "GraniteWidgetsSourceListTree", &g_define_type_info, 0);
	GraniteWidgetsSourceListTree_private_offset = g_type_add_instance_private (granite_widgets_source_list_tree_type_id, sizeof (GraniteWidgetsSourceListTreePrivate));
	return granite_widgets_source_list_tree_type_id;
}

static GType
granite_widgets_source_list_tree_get_type (void)
{
	static volatile gsize granite_widgets_source_list_tree_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_tree_type_id__once)) {
		GType granite_widgets_source_list_tree_type_id;
		granite_widgets_source_list_tree_type_id = granite_widgets_source_list_tree_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_tree_type_id__once, granite_widgets_source_list_tree_type_id);
	}
	return granite_widgets_source_list_tree_type_id__once;
}

static void
_vala_granite_widgets_source_list_tree_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	GraniteWidgetsSourceListTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE, GraniteWidgetsSourceListTree);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY:
		g_value_set_object (value, granite_widgets_source_list_tree_get_data_model (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY:
		g_value_set_object (value, granite_widgets_source_list_tree_get_selected_item (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_TREE_EDITING_PROPERTY:
		g_value_set_boolean (value, granite_widgets_source_list_tree_get_editing (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY:
		g_value_set_enum (value, granite_widgets_source_list_tree_get_ellipsize_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_source_list_tree_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	GraniteWidgetsSourceListTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_TYPE_TREE, GraniteWidgetsSourceListTree);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_TREE_DATA_MODEL_PROPERTY:
		granite_widgets_source_list_tree_set_data_model (self, g_value_get_object (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_TREE_SELECTED_ITEM_PROPERTY:
		granite_widgets_source_list_tree_set_selected_item (self, g_value_get_object (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_TREE_ELLIPSIZE_MODE_PROPERTY:
		granite_widgets_source_list_tree_set_ellipsize_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_granite_widgets_source_list___lambda81_ (GraniteWidgetsSourceList* self,
                                          GraniteWidgetsSourceListItem* item)
{
	g_signal_emit (self, granite_widgets_source_list_signals[GRANITE_WIDGETS_SOURCE_LIST_ITEM_SELECTED_SIGNAL], 0, item);
}

static void
__granite_widgets_source_list___lambda81__granite_widgets_source_list_tree_item_selected (GraniteWidgetsSourceListTree* _sender,
                                                                                          GraniteWidgetsSourceListItem* item,
                                                                                          gpointer self)
{
	_granite_widgets_source_list___lambda81_ ((GraniteWidgetsSourceList*) self, item);
}

static GObject *
granite_widgets_source_list_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsSourceList * self;
	GraniteWidgetsSourceListDataModel* _tmp0_;
	GraniteWidgetsSourceListTree* _tmp1_;
	GraniteWidgetsSourceListTree* _tmp2_;
	GraniteWidgetsSourceListTree* _tmp3_;
	parent_class = G_OBJECT_CLASS (granite_widgets_source_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_SOURCE_LIST, GraniteWidgetsSourceList);
	_tmp0_ = self->priv->data_model;
	_tmp1_ = granite_widgets_source_list_tree_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->tree);
	self->priv->tree = _tmp1_;
	gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp2_ = self->priv->tree;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp3_ = self->priv->tree;
	g_signal_connect_object (_tmp3_, "item-selected", (GCallback) __granite_widgets_source_list___lambda81__granite_widgets_source_list_tree_item_selected, self, 0);
	return obj;
}

static void
granite_widgets_source_list_class_init (GraniteWidgetsSourceListClass * klass,
                                        gpointer klass_data)
{
	granite_widgets_source_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceList_private_offset);
	((GraniteWidgetsSourceListClass *) klass)->item_selected = granite_widgets_source_list_real_item_selected;
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_source_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_finalize;
	/**
	     * Root-level expandable item.
	     *
	     * This item contains the first-level source list items. It //only serves as an item container//.
	     * It is used to add and remove items to/from the widget.
	     *
	     * Internally, it allows the source list to connect to its {@link Granite.Widgets.SourceList.ExpandableItem.child_added}
	     * and {@link Granite.Widgets.SourceList.ExpandableItem.child_removed} signals in order to monitor
	     * new children additions/removals.
	     *
	     * @since 0.2
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ROOT_PROPERTY, granite_widgets_source_list_properties[GRANITE_WIDGETS_SOURCE_LIST_ROOT_PROPERTY] = g_param_spec_object ("root", "root", "root", GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The current selected item.
	     *
	     * Setting it to //null// un-selects the previously selected item, if there was any.
	     * {@link Granite.Widgets.SourceList.ExpandableItem.expand_with_parents} is called on the
	     * item's parent to make sure it's possible to select it.
	     *
	     * @since 0.2
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY, granite_widgets_source_list_properties[GRANITE_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY] = g_param_spec_object ("selected", "selected", "selected", GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Text ellipsize mode.
	     *
	     * @since 0.2
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY, granite_widgets_source_list_properties[GRANITE_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY] = g_param_spec_enum ("ellipsize-mode", "ellipsize-mode", "ellipsize-mode", pango_ellipsize_mode_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether an item is being edited.
	     *
	     * @see Granite.Widgets.SourceList.start_editing_item
	     * @since 0.2
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_EDITING_PROPERTY, granite_widgets_source_list_properties[GRANITE_WIDGETS_SOURCE_LIST_EDITING_PROPERTY] = g_param_spec_boolean ("editing", "editing", "editing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Emitted when the source list selection changes.
	     *
	     * @param item Selected item; //null// if nothing is selected.
	     * @since 0.2
	     */
	granite_widgets_source_list_signals[GRANITE_WIDGETS_SOURCE_LIST_ITEM_SELECTED_SIGNAL] = g_signal_new ("item-selected", GRANITE_WIDGETS_TYPE_SOURCE_LIST, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GraniteWidgetsSourceListClass, item_selected), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM);
}

static void
granite_widgets_source_list_instance_init (GraniteWidgetsSourceList * self,
                                           gpointer klass)
{
	GraniteWidgetsSourceListDataModel* _tmp0_;
	self->priv = granite_widgets_source_list_get_instance_private (self);
	_tmp0_ = granite_widgets_source_list_data_model_new ();
	self->priv->data_model = _tmp0_;
}

static void
granite_widgets_source_list_finalize (GObject * obj)
{
	GraniteWidgetsSourceList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_SOURCE_LIST, GraniteWidgetsSourceList);
	_g_object_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->data_model);
	G_OBJECT_CLASS (granite_widgets_source_list_parent_class)->finalize (obj);
}

/**
 * A widget that can display a list of items organized in categories.
 *
 * The source list widget consists of a collection of items, some of which are also expandable (and
 * thus can contain more items). All the items displayed in the source list are children of the widget's
 * root item. The API is meant to be used as follows:
 *
 * 1. Create the items you want to display in the source list, setting the appropriate values for their
 * properties. The desired hierarchy is achieved by creating expandable items and adding items to them.
 * These will be displayed as descendants in the widget's tree structure. The expandable items that are
 * not nested inside any other item are considered to be at root level, and should be added to
 * the widget's root item.<<BR>>
 *
 * Expandable items located at the root level are treated as categories, and only support text.
 *
 * ''Example''<<BR>>
 * The final tree will have the following structure:
 * {{{
 * Libraries
 *   Music
 * Stores
 *   My Store
 *      Music
 *      Podcasts
 * Devices
 *   Player 1
 *   Player 2
 * }}}
 *
 * {{{
 * var library_category = new Granite.Widgets.SourceList.ExpandableItem ("Libraries");
 * var store_category = new Granite.Widgets.SourceList.ExpandableItem ("Stores");
 * var device_category = new Granite.Widgets.SourceList.ExpandableItem ("Devices");
 *
 * var music_item = new Granite.Widgets.SourceList.Item ("Music");
 *
 * // "Libraries" will be the parent category of "Music"
 * library_category.add (music_item);
 *
 * // We plan to add sub-items to the store, so let's use an expandable item
 * var my_store_item = new Granite.Widgets.SourceList.ExpandableItem ("My Store");
 * store_category.add (my_store_item);
 *
 * var my_store_podcast_item = new Granite.Widgets.SourceList.Item ("Podcasts");
 * var my_store_music_item = new Granite.Widgets.SourceList.Item ("Music");
 *
 * my_store_item.add (my_store_music_item);
 * my_store_item.add (my_store_podcast_item);
 *
 * var player1_item = new Granite.Widgets.SourceList.Item ("Player 1");
 * var player2_item = new Granite.Widgets.SourceList.Item ("Player 2");
 *
 * device_category.add (player1_item);
 * device_category.add (player2_item);
 * }}}
 *
 * 2. Create a source list widget.<<BR>>
 * {{{
 * var source_list = new Granite.Widgets.SourceList ();
 * }}}
 *
 * 3. Add root-level items to the {@link Granite.Widgets.SourceList.root} item.
 * This item only serves as a container, and all its properties are ignored by the widget.
 *
 * {{{
 * // This will add the main categories (including their children) to the source list. After
 * // having being added to be widget, any other item added to any of these items
 * // (or any other child item in a deeper level) will be automatically added too.
 * // There's no need to deal with the source list widget directly.
 *
 * var root = source_list.root;
 *
 * root.add (library_category);
 * root.add (store_category);
 * root.add (device_category);
 * }}}
 *
 * The steps mentioned above are enough for initializing the source list. Future changes to the items'
 * properties are ''automatically'' reflected by the widget.
 *
 * Final steps would involve connecting handlers to the source list events, being
 * {@link Granite.Widgets.SourceList.item_selected} the most important, as it indicates that
 * the selection was modified.
 *
 * Pack the source list into the GUI using the {@link Gtk.Paned} widget.
 * This is usually done as follows:
 * {{{
 * var pane = new Gtk.Paned (Gtk.Orientation.HORIZONTAL);
 * pane.pack1 (source_list, false, false);
 * pane.pack2 (content_area, true, false);
 * }}}
 *
 * @since 0.2
 * @see Gtk.Paned
 */
static GType
granite_widgets_source_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceList), 0, (GInstanceInitFunc) granite_widgets_source_list_instance_init, NULL };
	GType granite_widgets_source_list_type_id;
	granite_widgets_source_list_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "GraniteWidgetsSourceList", &g_define_type_info, 0);
	GraniteWidgetsSourceList_private_offset = g_type_add_instance_private (granite_widgets_source_list_type_id, sizeof (GraniteWidgetsSourceListPrivate));
	return granite_widgets_source_list_type_id;
}

GType
granite_widgets_source_list_get_type (void)
{
	static volatile gsize granite_widgets_source_list_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_type_id__once)) {
		GType granite_widgets_source_list_type_id;
		granite_widgets_source_list_type_id = granite_widgets_source_list_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_type_id__once, granite_widgets_source_list_type_id);
	}
	return granite_widgets_source_list_type_id__once;
}

static void
_vala_granite_widgets_source_list_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GraniteWidgetsSourceList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_SOURCE_LIST, GraniteWidgetsSourceList);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_ROOT_PROPERTY:
		g_value_set_object (value, granite_widgets_source_list_get_root (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY:
		g_value_set_object (value, granite_widgets_source_list_get_selected (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY:
		g_value_set_enum (value, granite_widgets_source_list_get_ellipsize_mode (self));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_EDITING_PROPERTY:
		g_value_set_boolean (value, granite_widgets_source_list_get_editing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_source_list_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GraniteWidgetsSourceList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_SOURCE_LIST, GraniteWidgetsSourceList);
	switch (property_id) {
		case GRANITE_WIDGETS_SOURCE_LIST_ROOT_PROPERTY:
		granite_widgets_source_list_set_root (self, g_value_get_object (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_SELECTED_PROPERTY:
		granite_widgets_source_list_set_selected (self, g_value_get_object (value));
		break;
		case GRANITE_WIDGETS_SOURCE_LIST_ELLIPSIZE_MODE_PROPERTY:
		granite_widgets_source_list_set_ellipsize_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

