/* System.c generated by valac 0.56.17, the Vala compiler
 * generated from System.vala, do not modify */

/*
 * Copyright 2011-2013 Robert Dyer
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_SERVICES_SYSTEM_0_PROPERTY,
	GRANITE_SERVICES_SYSTEM_NUM_PROPERTIES
};
static GParamSpec* granite_services_system_properties[GRANITE_SERVICES_SYSTEM_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GRANITE_PORTAL_TYPE_SETTINGS (granite_portal_settings_get_type ())
#define GRANITE_PORTAL_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_PORTAL_TYPE_SETTINGS, GranitePortalSettings))
#define GRANITE_PORTAL_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_PORTAL_TYPE_SETTINGS))
#define GRANITE_PORTAL_SETTINGS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GRANITE_PORTAL_TYPE_SETTINGS, GranitePortalSettingsIface))

typedef struct _GranitePortalSettings GranitePortalSettings;
typedef struct _GranitePortalSettingsIface GranitePortalSettingsIface;

#define GRANITE_PORTAL_TYPE_SETTINGS_PROXY (granite_portal_settings_proxy_get_type ())
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _GranitePortalSettingsIface {
	GTypeInterface parent_iface;
	GHashTable* (*read_all) (GranitePortalSettings* self, gchar** namespaces, gint namespaces_length1, GError** error);
	GVariant* (*read) (GranitePortalSettings* self, const gchar* namespace, const gchar* key, GError** error);
};

static gpointer granite_services_system_parent_class = NULL;
static GSettingsSchema* granite_services_system_privacy_settings_schema;
static GSettingsSchema* granite_services_system_privacy_settings_schema = NULL;
static GSettings* granite_services_system_privacy_settings;
static GSettings* granite_services_system_privacy_settings = NULL;
static GranitePortalSettings* granite_services_system_portal;
static GranitePortalSettings* granite_services_system_portal = NULL;

static gboolean granite_services_system_path_is_mounted (const gchar* path);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void granite_services_system_internal_launch (GFile* app,
                                              GList* files);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN GType granite_portal_settings_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint granite_portal_settings_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
 G_GNUC_INTERNAL GType granite_portal_settings_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GranitePortalSettings* granite_portal_settings_get (GError** error);
 G_GNUC_INTERNAL GHashTable* granite_portal_settings_read_all (GranitePortalSettings* self,
                                              gchar** namespaces,
                                              gint namespaces_length1,
                                              GError** error);
static void granite_services_system_finalize (GObject * obj);
static GType granite_services_system_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
         * Opens the specified URI with the default application.  This can be used for opening websites
         * with the default browser, etc.
         *
         * @param uri the URI to open
         */
void
granite_services_system_open_uri (const gchar* uri)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	{
		g_app_info_launch_default_for_uri (uri, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_critical ("System.vala:24: Failed to open uri: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
         * Opens the specified file with the default application.
         *
         * @param file the {@link GLib.File} to open
         */
void
granite_services_system_open (GFile* file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_file_get_uri (file);
		_tmp1_ = _tmp0_;
		g_app_info_launch_default_for_uri (_tmp1_, NULL, &_inner_error0_);
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("System.vala:38: Failed to open file: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
         * Opens the specified files with the default application.
         *
         * @param files an array of {@link GLib.File} to open
         */
void
granite_services_system_open_files (GFile** files,
                                    gint files_length1)
{
	GError* _inner_error0_ = NULL;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* file = NULL;
			file = file_collection[file_it];
			{
				{
					GFile* _tmp0_;
					gchar* _tmp1_;
					gchar* _tmp2_;
					_tmp0_ = file;
					_tmp1_ = g_file_get_uri (_tmp0_);
					_tmp2_ = _tmp1_;
					g_app_info_launch_default_for_uri (_tmp2_, NULL, &_inner_error0_);
					_g_free0 (_tmp2_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp3_;
					const gchar* _tmp4_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp3_ = e;
					_tmp4_ = _tmp3_->message;
					g_critical ("System.vala:53: Failed to open file: %s", _tmp4_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
}

/**
         * Launches the specified application.
         *
         * @param app the {@link GLib.File} representing the application to launch
         */
void
granite_services_system_launch (GFile* app)
{
	GFile** _tmp0_;
	GFile** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (app != NULL);
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	granite_services_system_launch_with_files (app, _tmp1_, (gint) 0);
	_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_object_unref), NULL);
}

/**
         * Executes the specified command.
         *
         * @param command the command to execute
         */
gboolean
granite_services_system_execute_command (const gchar* command)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (command != NULL, FALSE);
	{
		GAppInfo* info = NULL;
		GAppInfo* _tmp0_;
		gboolean _tmp1_ = FALSE;
		GAppInfo* _tmp2_;
		_tmp0_ = g_app_info_create_from_commandline (command, "", 0, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = info;
		_tmp1_ = g_app_info_launch (_tmp2_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			goto __catch0_g_error;
		}
		if (_tmp1_) {
			result = TRUE;
			_g_object_unref0 (info);
			return result;
		}
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("System.vala:80: Failed to execute external '%s' command", command);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = TRUE;
	return result;
}

/**
         * Launches the supplied files with the specified application.
         *
         * @param app the {@link GLib.File} representing the application to launch
         * @param files an array of {@link GLib.File} to open
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
granite_services_system_launch_with_files (GFile* app,
                                           GFile** files,
                                           gint files_length1)
{
	gboolean _tmp0_ = FALSE;
	GList* mounted_files = NULL;
	gboolean _tmp26_ = FALSE;
	GList* _tmp27_;
	GError* _inner_error0_ = NULL;
	if (app != NULL) {
		_tmp0_ = !g_file_query_exists (app, NULL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_file_get_path (app);
		_tmp2_ = _tmp1_;
		g_warning ("System.vala:95: Application '%s' doesn't exist", _tmp2_);
		_g_free0 (_tmp2_);
		return;
	}
	mounted_files = NULL;
	{
		GFile** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
		f_collection = files;
		f_collection_length1 = files_length1;
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
			GFile* _tmp3_;
			GFile* f = NULL;
			_tmp3_ = _g_object_ref0 (f_collection[f_it]);
			f = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				GFile* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_;
				_tmp6_ = f;
				_tmp7_ = g_file_get_path (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = _tmp8_ != NULL;
				_g_free0 (_tmp8_);
				if (_tmp9_) {
					GFile* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp10_ = f;
					_tmp11_ = g_file_get_path (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp5_ = g_strcmp0 (_tmp12_, "") != 0;
					_g_free0 (_tmp12_);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gboolean _tmp13_ = FALSE;
					GFile* _tmp14_;
					_tmp14_ = f;
					if (g_file_is_native (_tmp14_)) {
						_tmp13_ = TRUE;
					} else {
						GFile* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						_tmp15_ = f;
						_tmp16_ = g_file_get_path (_tmp15_);
						_tmp17_ = _tmp16_;
						_tmp13_ = granite_services_system_path_is_mounted (_tmp17_);
						_g_free0 (_tmp17_);
					}
					_tmp4_ = _tmp13_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GFile* _tmp18_;
					GFile* _tmp19_;
					_tmp18_ = f;
					_tmp19_ = _g_object_ref0 (_tmp18_);
					mounted_files = g_list_append (mounted_files, _tmp19_);
					_g_object_unref0 (f);
					continue;
				}
				{
					GFile* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp20_ = f;
					_tmp21_ = g_file_get_uri (_tmp20_);
					_tmp22_ = _tmp21_;
					g_app_info_launch_default_for_uri (_tmp22_, NULL, &_inner_error0_);
					_g_free0 (_tmp22_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GFile* _tmp23_;
					GFile* _tmp24_;
					GFile* _tmp25_;
					g_clear_error (&_inner_error0_);
					_tmp23_ = f;
					g_file_mount_enclosing_volume (_tmp23_, 0, NULL, NULL, NULL, NULL);
					_tmp24_ = f;
					_tmp25_ = _g_object_ref0 (_tmp24_);
					mounted_files = g_list_append (mounted_files, _tmp25_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (f);
					(mounted_files == NULL) ? NULL : (mounted_files = (_g_list_free__g_object_unref0_ (mounted_files), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_object_unref0 (f);
			}
		}
	}
	_tmp27_ = mounted_files;
	if (g_list_length (_tmp27_) > ((guint) 0)) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = files_length1 == 0;
	}
	if (_tmp26_) {
		GList* _tmp28_;
		_tmp28_ = mounted_files;
		granite_services_system_internal_launch (app, _tmp28_);
	}
	(mounted_files == NULL) ? NULL : (mounted_files = (_g_list_free__g_object_unref0_ (mounted_files), NULL));
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
granite_services_system_path_is_mounted (const gchar* path)
{
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_volume_monitor_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_volume_monitor_get_mounts (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
		m_collection = _tmp3_;
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
			GMount* _tmp4_;
			GMount* m = NULL;
			_tmp4_ = _g_object_ref0 ((GMount*) m_it->data);
			m = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				GMount* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				gboolean _tmp10_;
				_tmp7_ = m;
				_tmp8_ = g_mount_get_root (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_ != NULL;
				_g_object_unref0 (_tmp9_);
				if (_tmp10_) {
					GMount* _tmp11_;
					GFile* _tmp12_;
					GFile* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = m;
					_tmp12_ = g_mount_get_root (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_file_get_path (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp6_ = _tmp15_ != NULL;
					_g_free0 (_tmp15_);
					_g_object_unref0 (_tmp13_);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					GMount* _tmp16_;
					GFile* _tmp17_;
					GFile* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp16_ = m;
					_tmp17_ = g_mount_get_root (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_file_get_path (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp5_ = string_contains (path, _tmp20_);
					_g_free0 (_tmp20_);
					_g_object_unref0 (_tmp18_);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					result = TRUE;
					_g_object_unref0 (m);
					(m_collection == NULL) ? NULL : (m_collection = (_g_list_free__g_object_unref0_ (m_collection), NULL));
					return result;
				}
				_g_object_unref0 (m);
			}
		}
		(m_collection == NULL) ? NULL : (m_collection = (_g_list_free__g_object_unref0_ (m_collection), NULL));
	}
	result = FALSE;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
granite_services_system_internal_launch (GFile* app,
                                         GList* files)
{
	gboolean _tmp0_ = FALSE;
	GAppInfo* info = NULL;
	GError* _inner_error0_ = NULL;
	if (app == NULL) {
		_tmp0_ = g_list_length (files) == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (app != NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GDesktopAppInfo* _tmp3_;
		_tmp1_ = g_file_get_path (app);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_desktop_app_info_new_from_filename (_tmp2_);
		_g_object_unref0 (info);
		info = (GAppInfo*) _tmp3_;
		_g_free0 (_tmp2_);
	} else {
		{
			GAppInfo* _tmp4_ = NULL;
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GAppInfo* _tmp7_;
			GAppInfo* _tmp8_;
			_tmp5_ = g_list_first (files);
			_tmp6_ = _tmp5_->data;
			_tmp7_ = g_file_query_default_handler ((GFile*) _tmp6_, NULL, &_inner_error0_);
			_tmp4_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (info);
			info = _tmp8_;
			_g_object_unref0 (_tmp4_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			_g_object_unref0 (info);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GAppInfo* _tmp10_;
		GAppInfo* _tmp12_;
		if (g_list_length (files) == ((guint) 0)) {
			GAppInfo* _tmp9_;
			_tmp9_ = info;
			g_app_info_launch (_tmp9_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_g_object_unref0 (info);
			return;
		}
		_tmp10_ = info;
		if (g_app_info_supports_files (_tmp10_)) {
			GAppInfo* _tmp11_;
			_tmp11_ = info;
			g_app_info_launch (_tmp11_, files, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_g_object_unref0 (info);
			return;
		}
		_tmp12_ = info;
		if (g_app_info_supports_uris (_tmp12_)) {
			GList* uris = NULL;
			GAppInfo* _tmp16_;
			GList* _tmp17_;
			GAppLaunchContext* _tmp18_;
			GAppLaunchContext* _tmp19_;
			uris = NULL;
			{
				GList* f_collection = NULL;
				GList* f_it = NULL;
				f_collection = files;
				for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
					GFile* _tmp13_;
					GFile* f = NULL;
					_tmp13_ = _g_object_ref0 ((GFile*) f_it->data);
					f = _tmp13_;
					{
						GFile* _tmp14_;
						gchar* _tmp15_;
						_tmp14_ = f;
						_tmp15_ = g_file_get_uri (_tmp14_);
						uris = g_list_append (uris, _tmp15_);
						_g_object_unref0 (f);
					}
				}
			}
			_tmp16_ = info;
			_tmp17_ = uris;
			_tmp18_ = g_app_launch_context_new ();
			_tmp19_ = _tmp18_;
			g_app_info_launch_uris (_tmp16_, _tmp17_, _tmp19_, &_inner_error0_);
			_g_object_unref0 (_tmp19_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				(uris == NULL) ? NULL : (uris = (_g_list_free__g_free0_ (uris), NULL));
				goto __catch1_g_error;
			}
			(uris == NULL) ? NULL : (uris = (_g_list_free__g_free0_ (uris), NULL));
			_g_object_unref0 (info);
			return;
		}
		g_error ("System.vala:164: Error opening files. The application doesn't support " \
"files/URIs or wasn't found.");
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = g_quark_to_string (e->domain);
		_tmp21_ = g_strconcat ("Error: ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		g_debug ("System.vala:166: %s", _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = e->message;
		g_error ("System.vala:167: %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally1:
	_g_object_unref0 (info);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return;
}

/**
         * Returns whether history is enabled within the Security and Privacy system settings or not. A value of true
         * means that you should store information such as the last opened file or a history within the app.
         *
         * Checks the "remember_recent_files" key in "org.gnome.desktop.privacy", returning true if the schema does not exist.
         */
gboolean
granite_services_system_history_is_enabled (void)
{
	GSettingsSchema* _tmp22_;
	gboolean _tmp25_ = FALSE;
	GSettingsSchema* _tmp26_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		GranitePortalSettings* _tmp0_;
		GHashTable* schemes = NULL;
		GranitePortalSettings* _tmp4_;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		GHashTable* _tmp8_;
		GHashTable* _tmp9_;
		gboolean _tmp10_ = FALSE;
		GHashTable* _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
		_tmp0_ = granite_services_system_portal;
		if (_tmp0_ == NULL) {
			GranitePortalSettings* _tmp1_ = NULL;
			GranitePortalSettings* _tmp2_;
			GranitePortalSettings* _tmp3_;
			_tmp2_ = granite_portal_settings_get (&_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (granite_services_system_portal);
			granite_services_system_portal = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		_tmp4_ = granite_services_system_portal;
		_tmp5_ = g_strdup ("org.gnome.desktop.privacy");
		_tmp6_ = g_new0 (gchar*, 1 + 1);
		_tmp6_[0] = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp7__length1 = 1;
		_tmp8_ = granite_portal_settings_read_all (_tmp4_, _tmp7_, (gint) 1, &_inner_error0_);
		_tmp9_ = _tmp8_;
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
		schemes = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = schemes;
		_tmp12_ = g_hash_table_size (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ > ((guint) 0)) {
			GHashTable* _tmp14_;
			gconstpointer _tmp15_;
			_tmp14_ = schemes;
			_tmp15_ = g_hash_table_lookup (_tmp14_, "org.gnome.desktop.privacy");
			_tmp10_ = g_hash_table_contains ((GHashTable*) _tmp15_, "remember-recent-files");
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			GHashTable* _tmp16_;
			gconstpointer _tmp17_;
			gconstpointer _tmp18_;
			_tmp16_ = schemes;
			_tmp17_ = g_hash_table_lookup (_tmp16_, "org.gnome.desktop.privacy");
			_tmp18_ = g_hash_table_lookup ((GHashTable*) _tmp17_, "remember-recent-files");
			result = g_variant_get_boolean ((GVariant*) _tmp18_);
			_g_hash_table_unref0 (schemes);
			return result;
		}
		_g_hash_table_unref0 (schemes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_debug ("System.vala:192: cannot use portal, using GSettings: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp21_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	_tmp22_ = granite_services_system_privacy_settings_schema;
	if (_tmp22_ == NULL) {
		GSettingsSchemaSource* _tmp23_;
		GSettingsSchema* _tmp24_;
		_tmp23_ = g_settings_schema_source_get_default ();
		_tmp24_ = g_settings_schema_source_lookup (_tmp23_, "org.gnome.desktop.privacy", TRUE);
		_g_settings_schema_unref0 (granite_services_system_privacy_settings_schema);
		granite_services_system_privacy_settings_schema = _tmp24_;
	}
	_tmp26_ = granite_services_system_privacy_settings_schema;
	if (_tmp26_ != NULL) {
		GSettingsSchema* _tmp27_;
		_tmp27_ = granite_services_system_privacy_settings_schema;
		_tmp25_ = g_settings_schema_has_key (_tmp27_, "remember-recent-files");
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		GSettings* _tmp28_;
		GSettings* _tmp30_;
		_tmp28_ = granite_services_system_privacy_settings;
		if (_tmp28_ == NULL) {
			GSettings* _tmp29_;
			_tmp29_ = g_settings_new ("org.gnome.desktop.privacy");
			_g_object_unref0 (granite_services_system_privacy_settings);
			granite_services_system_privacy_settings = _tmp29_;
		}
		_tmp30_ = granite_services_system_privacy_settings;
		result = g_settings_get_boolean (_tmp30_, "remember-recent-files");
		return result;
	}
	result = TRUE;
	return result;
}

GraniteServicesSystem*
granite_services_system_construct (GType object_type)
{
	GraniteServicesSystem * self = NULL;
	self = (GraniteServicesSystem*) g_object_new (object_type, NULL);
	return self;
}

GraniteServicesSystem*
granite_services_system_new (void)
{
	return granite_services_system_construct (GRANITE_SERVICES_TYPE_SYSTEM);
}

static void
granite_services_system_class_init (GraniteServicesSystemClass * klass,
                                    gpointer klass_data)
{
	granite_services_system_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = granite_services_system_finalize;
}

static void
granite_services_system_instance_init (GraniteServicesSystem * self,
                                       gpointer klass)
{
}

static void
granite_services_system_finalize (GObject * obj)
{
	GraniteServicesSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_SERVICES_TYPE_SYSTEM, GraniteServicesSystem);
	G_OBJECT_CLASS (granite_services_system_parent_class)->finalize (obj);
}

/**
     * Utility class for frequently-used system-related functions, such as opening files, launching
     * applications, or executing terminal commands.
     */
static GType
granite_services_system_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesSystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_system_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteServicesSystem), 0, (GInstanceInitFunc) granite_services_system_instance_init, NULL };
	GType granite_services_system_type_id;
	granite_services_system_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteServicesSystem", &g_define_type_info, 0);
	return granite_services_system_type_id;
}

GType
granite_services_system_get_type (void)
{
	static volatile gsize granite_services_system_type_id__once = 0;
	if (g_once_init_enter (&granite_services_system_type_id__once)) {
		GType granite_services_system_type_id;
		granite_services_system_type_id = granite_services_system_get_type_once ();
		g_once_init_leave (&granite_services_system_type_id__once, granite_services_system_type_id);
	}
	return granite_services_system_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

