/* SeekBarView.c generated by valac 0.56.17, the Vala compiler
 * generated from SeekBarView.vala, do not modify */

/*
 * Copyright 2017 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include "granite.h"
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SEEK_BAR_VIEW (seek_bar_view_get_type ())
#define SEEK_BAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEEK_BAR_VIEW, SeekBarView))
#define SEEK_BAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEEK_BAR_VIEW, SeekBarViewClass))
#define IS_SEEK_BAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEEK_BAR_VIEW))
#define IS_SEEK_BAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEEK_BAR_VIEW))
#define SEEK_BAR_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEEK_BAR_VIEW, SeekBarViewClass))

typedef struct _SeekBarView SeekBarView;
typedef struct _SeekBarViewClass SeekBarViewClass;
typedef struct _SeekBarViewPrivate SeekBarViewPrivate;
enum  {
	SEEK_BAR_VIEW_0_PROPERTY,
	SEEK_BAR_VIEW_NUM_PROPERTIES
};
static GParamSpec* seek_bar_view_properties[SEEK_BAR_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GdkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRectangle_free (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SeekBarView {
	GtkGrid parent_instance;
	SeekBarViewPrivate * priv;
};

struct _SeekBarViewClass {
	GtkGridClass parent_class;
};

struct _SeekBarViewPrivate {
	GtkPopover* preview_popover;
	GtkLabel* preview_label;
};

struct _Block11Data {
	int _ref_count_;
	SeekBarView* self;
	GraniteSeekBar* seek_bar;
	gint progress;
};

static gint SeekBarView_private_offset;
static gpointer seek_bar_view_parent_class = NULL;

VALA_EXTERN GType seek_bar_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeekBarView, g_object_unref)
VALA_EXTERN SeekBarView* seek_bar_view_new (void);
VALA_EXTERN SeekBarView* seek_bar_view_construct (GType object_type);
static void seek_bar_view_update_pointing (SeekBarView* self,
                                    gint x);
static void _vala_GdkRectangle_free (GdkRectangle* self);
static GObject * seek_bar_view_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gboolean _seek_bar_view___lambda13_ (Block11Data* _data11_,
                                     GdkEventMotion* event);
static gboolean __seek_bar_view___lambda13__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                     GdkEventMotion* event,
                                                                     gpointer self);
static gboolean _seek_bar_view___lambda14_ (SeekBarView* self);
static gboolean __seek_bar_view___lambda14__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                    GdkEventCrossing* event,
                                                                    gpointer self);
static gboolean _seek_bar_view___lambda15_ (SeekBarView* self);
static gboolean __seek_bar_view___lambda15__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                    GdkEventCrossing* event,
                                                                    gpointer self);
static gboolean _seek_bar_view___lambda16_ (SeekBarView* self);
static gboolean __seek_bar_view___lambda16__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                    GdkEventButton* event,
                                                                    gpointer self);
static gboolean _seek_bar_view___lambda17_ (SeekBarView* self);
static gboolean __seek_bar_view___lambda17__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                      GdkEventButton* event,
                                                                      gpointer self);
static gboolean _seek_bar_view___lambda18_ (Block11Data* _data11_,
                                     GtkScrollType scroll,
                                     gdouble new_value);
static gboolean __seek_bar_view___lambda18__gtk_range_change_value (GtkRange* _sender,
                                                             GtkScrollType scroll,
                                                             gdouble new_value,
                                                             gpointer self);
static gboolean _seek_bar_view___lambda19_ (Block11Data* _data11_);
static gboolean __seek_bar_view___lambda19__gsource_func (gpointer self);
static void seek_bar_view_finalize (GObject * obj);
static GType seek_bar_view_get_type_once (void);

static inline gpointer
seek_bar_view_get_instance_private (SeekBarView* self)
{
	return G_STRUCT_MEMBER_P (self, SeekBarView_private_offset);
}

SeekBarView*
seek_bar_view_construct (GType object_type)
{
	SeekBarView * self = NULL;
	self = (SeekBarView*) g_object_new (object_type, "valign", GTK_ALIGN_CENTER, "margin", 24, NULL);
	return self;
}

SeekBarView*
seek_bar_view_new (void)
{
	return seek_bar_view_construct (TYPE_SEEK_BAR_VIEW);
}

static void
_vala_GdkRectangle_free (GdkRectangle* self)
{
	g_boxed_free (gdk_rectangle_get_type (), self);
}

static void
seek_bar_view_update_pointing (SeekBarView* self,
                               gint x)
{
	GdkRectangle pointing = {0};
	GtkPopover* _tmp0_;
	GdkRectangle* _tmp1_;
	GdkRectangle* _tmp2_;
	GdkRectangle* _tmp3_;
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	GtkPopover* _tmp6_;
	GdkRectangle _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preview_popover;
	g_object_get (_tmp0_, "pointing-to", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = *_tmp3_;
	__vala_GdkRectangle_free0 (_tmp3_);
	pointing = _tmp4_;
	pointing.x = x;
	_tmp5_ = pointing;
	if (_tmp5_.width == 0) {
		pointing.width = 2;
		pointing.x = pointing.x - 1;
	} else {
		pointing.width = 0;
	}
	_tmp6_ = self->priv->preview_popover;
	_tmp7_ = pointing;
	gtk_popover_set_pointing_to (_tmp6_, &_tmp7_);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		SeekBarView* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->seek_bar);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
_seek_bar_view___lambda13_ (Block11Data* _data11_,
                            GdkEventMotion* event)
{
	SeekBarView* self;
	GraniteSeekBar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = _data11_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	seek_bar_view_update_pointing (self, (gint) event->x);
	_tmp0_ = _data11_->seek_bar;
	_tmp1_ = granite_seek_bar_get_is_grabbing (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gdouble duration_decimal = 0.0;
		GdkWindow* _tmp3_;
		gchar* duration_mins = NULL;
		GraniteSeekBar* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		gchar* _tmp7_;
		GtkLabel* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp3_ = event->window;
		duration_decimal = event->x / ((gdouble) gdk_window_get_width (_tmp3_));
		_tmp4_ = _data11_->seek_bar;
		_tmp5_ = granite_seek_bar_get_playback_duration (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = granite_date_time_seconds_to_time ((gint) (duration_decimal * _tmp6_));
		duration_mins = _tmp7_;
		_tmp8_ = self->priv->preview_label;
		_tmp9_ = duration_mins;
		_tmp10_ = string_to_string (_tmp9_);
		gtk_label_set_label (_tmp8_, _tmp10_);
		_g_free0 (duration_mins);
	}
	result = FALSE;
	return result;
}

static gboolean
__seek_bar_view___lambda13__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                            GdkEventMotion* event,
                                                            gpointer self)
{
	gboolean result;
	result = _seek_bar_view___lambda13_ (self, event);
	return result;
}

static gboolean
_seek_bar_view___lambda14_ (SeekBarView* self)
{
	GtkPopover* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->preview_popover;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	result = FALSE;
	return result;
}

static gboolean
__seek_bar_view___lambda14__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                           GdkEventCrossing* event,
                                                           gpointer self)
{
	gboolean result;
	result = _seek_bar_view___lambda14_ ((SeekBarView*) self);
	return result;
}

static gboolean
_seek_bar_view___lambda15_ (SeekBarView* self)
{
	GtkPopover* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->preview_popover;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
	result = FALSE;
	return result;
}

static gboolean
__seek_bar_view___lambda15__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                           GdkEventCrossing* event,
                                                           gpointer self)
{
	gboolean result;
	result = _seek_bar_view___lambda15_ ((SeekBarView*) self);
	return result;
}

static gboolean
_seek_bar_view___lambda16_ (SeekBarView* self)
{
	GtkLabel* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->preview_label;
	g_object_set ((GtkWidget*) _tmp0_, "margin", 10, NULL);
	result = FALSE;
	return result;
}

static gboolean
__seek_bar_view___lambda16__gtk_widget_button_press_event (GtkWidget* _sender,
                                                           GdkEventButton* event,
                                                           gpointer self)
{
	gboolean result;
	result = _seek_bar_view___lambda16_ ((SeekBarView*) self);
	return result;
}

static gboolean
_seek_bar_view___lambda17_ (SeekBarView* self)
{
	GtkLabel* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->preview_label;
	g_object_set ((GtkWidget*) _tmp0_, "margin", 5, NULL);
	result = FALSE;
	return result;
}

static gboolean
__seek_bar_view___lambda17__gtk_widget_button_release_event (GtkWidget* _sender,
                                                             GdkEventButton* event,
                                                             gpointer self)
{
	gboolean result;
	result = _seek_bar_view___lambda17_ ((SeekBarView*) self);
	return result;
}

static gboolean
_seek_bar_view___lambda18_ (Block11Data* _data11_,
                            GtkScrollType scroll,
                            gdouble new_value)
{
	SeekBarView* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data11_->self;
	if (new_value >= 0.0) {
		_tmp0_ = new_value <= 1.0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* duration_mins = NULL;
		GraniteSeekBar* _tmp1_;
		gdouble _tmp2_;
		gdouble _tmp3_;
		gchar* _tmp4_;
		GtkLabel* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp1_ = _data11_->seek_bar;
		_tmp2_ = granite_seek_bar_get_playback_duration (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = granite_date_time_seconds_to_time ((gint) (new_value * _tmp3_));
		duration_mins = _tmp4_;
		_tmp5_ = self->priv->preview_label;
		_tmp6_ = duration_mins;
		_tmp7_ = string_to_string (_tmp6_);
		gtk_label_set_label (_tmp5_, _tmp7_);
		_g_free0 (duration_mins);
	}
	result = FALSE;
	return result;
}

static gboolean
__seek_bar_view___lambda18__gtk_range_change_value (GtkRange* _sender,
                                                    GtkScrollType scroll,
                                                    gdouble new_value,
                                                    gpointer self)
{
	gboolean result;
	result = _seek_bar_view___lambda18_ (self, scroll, new_value);
	return result;
}

static gboolean
_seek_bar_view___lambda19_ (Block11Data* _data11_)
{
	SeekBarView* self;
	GraniteSeekBar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = _data11_->self;
	_tmp0_ = _data11_->seek_bar;
	_tmp1_ = granite_seek_bar_get_is_grabbing (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	if (_data11_->progress >= 10) {
		GraniteSeekBar* _tmp3_;
		_data11_->progress = 0;
		_tmp3_ = _data11_->seek_bar;
		granite_seek_bar_set_playback_progress (_tmp3_, 0.0);
	} else {
		GraniteSeekBar* _tmp4_;
		_data11_->progress += 1;
		_tmp4_ = _data11_->seek_bar;
		granite_seek_bar_set_playback_progress (_tmp4_, _data11_->progress / 10.0);
	}
	result = TRUE;
	return result;
}

static gboolean
__seek_bar_view___lambda19__gsource_func (gpointer self)
{
	gboolean result;
	result = _seek_bar_view___lambda19_ (self);
	return result;
}

static GObject *
seek_bar_view_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeekBarView * self;
	Block11Data* _data11_;
	GtkPopover* _tmp0_;
	GtkPopover* _tmp1_;
	GtkPopover* _tmp2_;
	GtkPopover* _tmp3_;
	GtkPopover* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkPopover* _tmp7_;
	GtkLabel* _tmp8_;
	GtkPopover* _tmp9_;
	GtkPopover* _tmp10_;
	GraniteSeekBar* _tmp11_;
	GtkPopover* _tmp12_;
	GraniteSeekBar* _tmp13_;
	GtkScale* _tmp14_;
	GtkScale* _tmp15_;
	GraniteSeekBar* _tmp16_;
	GtkScale* _tmp17_;
	GtkScale* _tmp18_;
	GraniteSeekBar* _tmp19_;
	GtkScale* _tmp20_;
	GtkScale* _tmp21_;
	GraniteSeekBar* _tmp22_;
	GtkScale* _tmp23_;
	GtkScale* _tmp24_;
	GraniteSeekBar* _tmp25_;
	GtkScale* _tmp26_;
	GtkScale* _tmp27_;
	GraniteSeekBar* _tmp28_;
	GtkScale* _tmp29_;
	GtkScale* _tmp30_;
	GraniteSeekBar* _tmp31_;
	GtkScale* _tmp32_;
	GtkScale* _tmp33_;
	GraniteSeekBar* _tmp34_;
	parent_class = G_OBJECT_CLASS (seek_bar_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEEK_BAR_VIEW, SeekBarView);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->preview_popover);
	self->priv->preview_popover = _tmp0_;
	_tmp1_ = self->priv->preview_popover;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->preview_popover;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = self->priv->preview_popover;
	gtk_popover_set_modal (_tmp3_, FALSE);
	_tmp4_ = self->priv->preview_popover;
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
	_tmp5_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->preview_label);
	self->priv->preview_label = _tmp5_;
	_tmp6_ = self->priv->preview_label;
	g_object_set ((GtkWidget*) _tmp6_, "margin", 5, NULL);
	_tmp7_ = self->priv->preview_popover;
	_tmp8_ = self->priv->preview_label;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->preview_popover;
	gtk_widget_show_all ((GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->preview_popover;
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
	_tmp11_ = granite_seek_bar_new ((gdouble) 100);
	g_object_ref_sink (_tmp11_);
	_data11_->seek_bar = _tmp11_;
	_tmp12_ = self->priv->preview_popover;
	_tmp13_ = _data11_->seek_bar;
	_tmp14_ = granite_seek_bar_get_scale (_tmp13_);
	_tmp15_ = _tmp14_;
	gtk_popover_set_relative_to (_tmp12_, (GtkWidget*) _tmp15_);
	_tmp16_ = _data11_->seek_bar;
	_tmp17_ = granite_seek_bar_get_scale (_tmp16_);
	_tmp18_ = _tmp17_;
	g_signal_connect_data ((GtkWidget*) _tmp18_, "motion-notify-event", (GCallback) __seek_bar_view___lambda13__gtk_widget_motion_notify_event, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp19_ = _data11_->seek_bar;
	_tmp20_ = granite_seek_bar_get_scale (_tmp19_);
	_tmp21_ = _tmp20_;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "enter-notify-event", (GCallback) __seek_bar_view___lambda14__gtk_widget_enter_notify_event, self, 0);
	_tmp22_ = _data11_->seek_bar;
	_tmp23_ = granite_seek_bar_get_scale (_tmp22_);
	_tmp24_ = _tmp23_;
	g_signal_connect_object ((GtkWidget*) _tmp24_, "leave-notify-event", (GCallback) __seek_bar_view___lambda15__gtk_widget_leave_notify_event, self, 0);
	_tmp25_ = _data11_->seek_bar;
	_tmp26_ = granite_seek_bar_get_scale (_tmp25_);
	_tmp27_ = _tmp26_;
	g_signal_connect_object ((GtkWidget*) _tmp27_, "button-press-event", (GCallback) __seek_bar_view___lambda16__gtk_widget_button_press_event, self, 0);
	_tmp28_ = _data11_->seek_bar;
	_tmp29_ = granite_seek_bar_get_scale (_tmp28_);
	_tmp30_ = _tmp29_;
	g_signal_connect_object ((GtkWidget*) _tmp30_, "button-release-event", (GCallback) __seek_bar_view___lambda17__gtk_widget_button_release_event, self, 0);
	_tmp31_ = _data11_->seek_bar;
	_tmp32_ = granite_seek_bar_get_scale (_tmp31_);
	_tmp33_ = _tmp32_;
	g_signal_connect_data ((GtkRange*) _tmp33_, "change-value", (GCallback) __seek_bar_view___lambda18__gtk_range_change_value, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	_tmp34_ = _data11_->seek_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp34_);
	_data11_->progress = 0;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, __seek_bar_view___lambda19__gsource_func, block11_data_ref (_data11_), block11_data_unref);
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return obj;
}

static void
seek_bar_view_class_init (SeekBarViewClass * klass,
                          gpointer klass_data)
{
	seek_bar_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeekBarView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = seek_bar_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = seek_bar_view_finalize;
}

static void
seek_bar_view_instance_init (SeekBarView * self,
                             gpointer klass)
{
	self->priv = seek_bar_view_get_instance_private (self);
}

static void
seek_bar_view_finalize (GObject * obj)
{
	SeekBarView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEEK_BAR_VIEW, SeekBarView);
	_g_object_unref0 (self->priv->preview_popover);
	_g_object_unref0 (self->priv->preview_label);
	G_OBJECT_CLASS (seek_bar_view_parent_class)->finalize (obj);
}

static GType
seek_bar_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeekBarViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seek_bar_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeekBarView), 0, (GInstanceInitFunc) seek_bar_view_instance_init, NULL };
	GType seek_bar_view_type_id;
	seek_bar_view_type_id = g_type_register_static (gtk_grid_get_type (), "SeekBarView", &g_define_type_info, 0);
	SeekBarView_private_offset = g_type_add_instance_private (seek_bar_view_type_id, sizeof (SeekBarViewPrivate));
	return seek_bar_view_type_id;
}

GType
seek_bar_view_get_type (void)
{
	static volatile gsize seek_bar_view_type_id__once = 0;
	if (g_once_init_enter (&seek_bar_view_type_id__once)) {
		GType seek_bar_view_type_id;
		seek_bar_view_type_id = seek_bar_view_get_type_once ();
		g_once_init_leave (&seek_bar_view_type_id__once, seek_bar_view_type_id);
	}
	return seek_bar_view_type_id__once;
}

