/* dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "libgnome-games-support.h"
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
typedef struct _GamesScoresDialogPrivate GamesScoresDialogPrivate;
enum  {
	GAMES_SCORES_DIALOG_0_PROPERTY,
	GAMES_SCORES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* games_scores_dialog_properties[GAMES_SCORES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;

struct _GamesScoresDialog {
	AdwDialog parent_instance;
	GamesScoresDialogPrivate * priv;
};

struct _GamesScoresDialogClass {
	AdwDialogClass parent_class;
};

struct _GamesScoresDialogPrivate {
	GamesScoresContext* context;
	GamesScoresCategory* active_category;
	GList* categories;
	GListStore* score_model;
	AdwToolbarView* toolbar;
	GtkButton* done_button;
	GtkDropDown* drop_down;
	GtkColumnView* score_view;
	GtkColumnViewColumn* rank_column;
	GtkColumnViewColumn* score_column;
	GtkColumnViewColumn* player_column;
	GamesScoresStyle scores_style;
	GamesScoresScore* new_high_score;
	gchar* score_or_time;
};

struct _Block5Data {
	int _ref_count_;
	GamesScoresDialog* self;
	gchar** categories_array;
	gint categories_array_length1;
	gint _categories_array_size_;
};

struct _Block6Data {
	int _ref_count_;
	GamesScoresDialog* self;
	GamesScoresScore* score;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	GtkEntry* entry;
};

struct _Block8Data {
	int _ref_count_;
	GamesScoresDialog* self;
	GamesScoresContextNewGameFunc new_game_func;
	gpointer new_game_func_target;
	GamesScoresContextQuitAppFunc quit_app_func;
	gpointer quit_app_func_target;
};

static gint GamesScoresDialog_private_offset;
static gpointer games_scores_dialog_parent_class = NULL;

VALA_EXTERN GType games_scores_dialog_get_type (void) G_GNUC_CONST ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            const gchar* icon_name);
VALA_EXTERN GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  const gchar* icon_name);
VALA_EXTERN GList* games_scores_context_get_categories (GamesScoresContext* self);
static void ___lambda11_ (GamesScoresDialog* self);
static void ____lambda11__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static gchar** games_scores_dialog_load_categories (GamesScoresDialog* self,
                                             gint* result_length1);
static void ____lambda13_ (GamesScoresDialog* self);
static void games_scores_dialog_load_scores_for_category (GamesScoresDialog* self,
                                                   GamesScoresCategory* category);
static void _____lambda13__g_object_notify (GObject* _sender,
                                     GParamSpec* pspec,
                                     gpointer self);
static void games_scores_dialog_setup_columns (GamesScoresDialog* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda12_ (Block5Data* _data5_,
                  GamesScoresCategory* x);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda12__gfunc (gconstpointer data,
                         gpointer self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void games_scores_dialog_set_up_rank_column (GamesScoresDialog* self);
static void games_scores_dialog_set_up_score_column (GamesScoresDialog* self);
static void games_scores_dialog_set_up_player_column (GamesScoresDialog* self);
static void __lambda22_ (GamesScoresDialog* self);
static void ___lambda22__gtk_sorter_changed (GtkSorter* _sender,
                                      GtkSorterChange change,
                                      gpointer self);
static gint games_scores_dialog_rank_sorter_cb (GamesScoresScore* entry1,
                                         GamesScoresScore* entry2);
static void __lambda14_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static void ___lambda14__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void __lambda15_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static void ___lambda15__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
static void __lambda16_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static void ___lambda16__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void ___lambda17_ (GamesScoresDialog* self,
                   GtkSignalListItemFactory* factory,
                   GObject* object);
static void ____lambda17__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void ___lambda18_ (GamesScoresDialog* self,
                   GtkSignalListItemFactory* factory,
                   GObject* object);
static void ____lambda18__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void __lambda19_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda20_ (Block7Data* _data7_);
VALA_EXTERN void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
static void ____lambda20__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void ___lambda21_ (GamesScoresDialog* self);
static void ____lambda21__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
static void ___lambda19__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
VALA_EXTERN void games_scores_dialog_add_bottom_buttons (GamesScoresDialog* self,
                                             GamesScoresContextNewGameFunc new_game_func,
                                             gpointer new_game_func_target,
                                             GamesScoresContextQuitAppFunc quit_app_func,
                                             gpointer quit_app_func_target);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda23_ (Block8Data* _data8_);
static void ___lambda23__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda24_ (Block8Data* _data8_);
static void ___lambda24__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void games_scores_dialog_finalize (GObject * obj);
static GType games_scores_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
games_scores_dialog_get_instance_private (GamesScoresDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresDialog_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
___lambda11_ (GamesScoresDialog* self)
{
	adw_dialog_close ((AdwDialog*) self);
}

static void
____lambda11__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda11_ ((GamesScoresDialog*) self);
}

static void
____lambda13_ (GamesScoresDialog* self)
{
	guint selected_index = 0U;
	GtkDropDown* _tmp0_;
	_tmp0_ = self->priv->drop_down;
	selected_index = gtk_drop_down_get_selected (_tmp0_);
	if (selected_index != ((guint) -1)) {
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = self->priv->categories;
		_tmp2_ = g_list_nth_data (_tmp1_, selected_index);
		games_scores_dialog_load_scores_for_category (self, (GamesScoresCategory*) _tmp2_);
	}
}

static void
_____lambda13__g_object_notify (GObject* _sender,
                                GParamSpec* pspec,
                                gpointer self)
{
	____lambda13_ ((GamesScoresDialog*) self);
}

GamesScoresDialog*
games_scores_dialog_construct (GType object_type,
                               GamesScoresContext* context,
                               const gchar* category_type,
                               GamesScoresStyle style,
                               GamesScoresScore* new_high_score,
                               GamesScoresCategory* current_cat,
                               const gchar* icon_name)
{
	GamesScoresDialog * self = NULL;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp2_;
	AdwToolbarView* _tmp3_;
	AdwHeaderBar* headerbar = NULL;
	AdwHeaderBar* _tmp4_;
	AdwHeaderBar* _tmp5_;
	AdwToolbarView* _tmp6_;
	AdwToolbarView* _tmp7_;
	GtkBuilder* _tmp8_;
	AdwHeaderBar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GList* _tmp20_;
	GamesScoresCategory* _tmp21_;
	GamesScoresCategory* _tmp22_;
	gchar* _tmp32_;
	gchar* new_score_or_time = NULL;
	gchar* _tmp33_;
	gboolean _tmp34_ = FALSE;
	GList* _tmp39_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp82_;
	GtkColumnView* _tmp83_;
	GtkColumnView* _tmp84_;
	GtkColumnView* _tmp85_;
	GamesScoresCategory* _tmp86_;
	GtkScrolledWindow* _tmp87_;
	GtkColumnView* _tmp88_;
	AdwToolbarView* _tmp89_;
	GtkBuilder* _tmp90_;
	GtkScrolledWindow* _tmp91_;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (GamesScoresDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = _g_object_ref0 (new_high_score);
	_g_object_unref0 (self->priv->new_high_score);
	self->priv->new_high_score = _tmp1_;
	_tmp2_ = gtk_builder_new ();
	builder = _tmp2_;
	_tmp3_ = (AdwToolbarView*) adw_toolbar_view_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp3_;
	_tmp4_ = (AdwHeaderBar*) adw_header_bar_new ();
	g_object_ref_sink (_tmp4_);
	headerbar = _tmp4_;
	_tmp5_ = headerbar;
	adw_header_bar_set_show_end_title_buttons (_tmp5_, new_high_score == NULL);
	_tmp6_ = self->priv->toolbar;
	adw_dialog_set_child ((AdwDialog*) self, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->toolbar;
	_tmp8_ = builder;
	_tmp9_ = headerbar;
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) _tmp7_, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) _tmp7_, _tmp8_, (GObject*) _tmp9_, "top");
	adw_dialog_set_content_width ((AdwDialog*) self, 400);
	adw_dialog_set_content_height ((AdwDialog*) self, 500);
	if (!games_scores_context_has_scores (context)) {
		_tmp10_ = new_high_score == NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		AdwStatusPage* status_page = NULL;
		AdwStatusPage* _tmp11_;
		AdwToolbarView* _tmp12_;
		GtkBuilder* _tmp13_;
		AdwStatusPage* _tmp14_;
		AdwStatusPage* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		AdwStatusPage* _tmp18_;
		AdwStatusPage* _tmp19_;
		adw_dialog_set_title ((AdwDialog*) self, _ ("No scores yet"));
		_tmp11_ = (AdwStatusPage*) adw_status_page_new ();
		g_object_ref_sink (_tmp11_);
		status_page = _tmp11_;
		_tmp12_ = self->priv->toolbar;
		_tmp13_ = builder;
		_tmp14_ = status_page;
		G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) _tmp12_, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) _tmp12_, _tmp13_, (GObject*) _tmp14_, NULL);
		_tmp15_ = status_page;
		_tmp16_ = g_strconcat (icon_name, "-symbolic", NULL);
		_tmp17_ = _tmp16_;
		adw_status_page_set_icon_name (_tmp15_, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = status_page;
		adw_status_page_set_description (_tmp18_, _ ("Play some games and your scores will show up here."));
		_tmp19_ = status_page;
		gtk_widget_add_css_class ((GtkWidget*) _tmp19_, "dim-label");
		_g_object_unref0 (status_page);
		_g_object_unref0 (headerbar);
		_g_object_unref0 (builder);
		return self;
	}
	self->priv->scores_style = style;
	_tmp20_ = games_scores_context_get_categories (context);
	(self->priv->categories == NULL) ? NULL : (self->priv->categories = (_g_list_free__g_object_unref0_ (self->priv->categories), NULL));
	self->priv->categories = _tmp20_;
	_tmp21_ = _g_object_ref0 (current_cat);
	_g_object_unref0 (self->priv->active_category);
	self->priv->active_category = _tmp21_;
	_tmp22_ = self->priv->active_category;
	if (_tmp22_ == NULL) {
		GList* _tmp23_;
		gconstpointer _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		GList* _tmp27_;
		gconstpointer _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		GamesScoresCategory* _tmp31_;
		_tmp23_ = self->priv->categories;
		_tmp24_ = g_list_nth_data (_tmp23_, (guint) 0);
		_tmp25_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->categories;
		_tmp28_ = g_list_nth_data (_tmp27_, (guint) 0);
		_tmp29_ = games_scores_category_get_name ((GamesScoresCategory*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = games_scores_category_new (_tmp26_, _tmp30_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp31_;
	}
	_tmp32_ = g_strdup ("");
	_g_free0 (self->priv->score_or_time);
	self->priv->score_or_time = _tmp32_;
	_tmp33_ = g_strdup ("");
	new_score_or_time = _tmp33_;
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp34_ = TRUE;
	} else {
		_tmp34_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp34_) {
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp35_ = g_strdup (_ ("Score"));
		_g_free0 (self->priv->score_or_time);
		self->priv->score_or_time = _tmp35_;
		_tmp36_ = g_strdup (_ ("New Score in"));
		_g_free0 (new_score_or_time);
		new_score_or_time = _tmp36_;
	} else {
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp37_ = g_strdup (_ ("Time"));
		_g_free0 (self->priv->score_or_time);
		self->priv->score_or_time = _tmp37_;
		_tmp38_ = g_strdup (_ ("New Time in"));
		_g_free0 (new_score_or_time);
		new_score_or_time = _tmp38_;
	}
	_tmp39_ = games_scores_context_get_categories (context);
	(self->priv->categories == NULL) ? NULL : (self->priv->categories = (_g_list_free__g_object_unref0_ (self->priv->categories), NULL));
	self->priv->categories = _tmp39_;
	if (new_high_score != NULL) {
		AdwWindowTitle* title_widget = NULL;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		GamesScoresCategory* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		AdwWindowTitle* _tmp49_;
		AdwWindowTitle* _tmp50_;
		AdwHeaderBar* _tmp51_;
		AdwWindowTitle* _tmp52_;
		GtkButton* _tmp53_;
		GtkButton* _tmp54_;
		GtkButton* _tmp55_;
		AdwHeaderBar* _tmp56_;
		GtkButton* _tmp57_;
		_tmp40_ = new_score_or_time;
		_tmp41_ = string_to_string (_tmp40_);
		_tmp42_ = string_to_string (category_type);
		_tmp43_ = self->priv->active_category;
		_tmp44_ = games_scores_category_get_name (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = string_to_string (_tmp45_);
		_tmp47_ = g_strconcat (_tmp41_, " ", _tmp42_, " ", _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = (AdwWindowTitle*) adw_window_title_new (_ ("Congratulations!"), _tmp48_);
		g_object_ref_sink (_tmp49_);
		_tmp50_ = _tmp49_;
		_g_free0 (_tmp48_);
		title_widget = _tmp50_;
		_tmp51_ = headerbar;
		_tmp52_ = title_widget;
		adw_header_bar_set_title_widget (_tmp51_, (GtkWidget*) _tmp52_);
		_tmp53_ = (GtkButton*) gtk_button_new_with_label (_ ("Done"));
		g_object_ref_sink (_tmp53_);
		_g_object_unref0 (self->priv->done_button);
		self->priv->done_button = _tmp53_;
		_tmp54_ = self->priv->done_button;
		gtk_widget_add_css_class ((GtkWidget*) _tmp54_, "suggested-action");
		_tmp55_ = self->priv->done_button;
		g_signal_connect_object (_tmp55_, "clicked", (GCallback) ____lambda11__gtk_button_clicked, self, 0);
		_tmp56_ = headerbar;
		_tmp57_ = self->priv->done_button;
		adw_header_bar_pack_end (_tmp56_, (GtkWidget*) _tmp57_);
		_g_object_unref0 (title_widget);
	} else {
		GList* _tmp58_;
		_tmp58_ = self->priv->categories;
		if (g_list_length (_tmp58_) == ((guint) 1)) {
			GList* _tmp59_;
			GList* _tmp60_;
			gconstpointer _tmp61_;
			GamesScoresCategory* _tmp62_;
			GamesScoresCategory* _tmp63_;
			const gchar* _tmp64_;
			const gchar* _tmp65_;
			_tmp59_ = self->priv->categories;
			_tmp60_ = g_list_first (_tmp59_);
			_tmp61_ = ((GList*) _tmp60_)->data;
			_tmp62_ = _g_object_ref0 ((GamesScoresCategory*) _tmp61_);
			_g_object_unref0 (self->priv->active_category);
			self->priv->active_category = _tmp62_;
			_tmp63_ = self->priv->active_category;
			_tmp64_ = games_scores_category_get_name (_tmp63_);
			_tmp65_ = _tmp64_;
			adw_dialog_set_title ((AdwDialog*) self, _tmp65_);
		} else {
			gint _tmp66_ = 0;
			gchar** _tmp67_;
			gchar** _tmp68_;
			gint _tmp68__length1;
			GtkDropDown* _tmp69_;
			GtkDropDown* _tmp70_;
			AdwHeaderBar* _tmp80_;
			GtkDropDown* _tmp81_;
			_tmp67_ = games_scores_dialog_load_categories (self, &_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp68__length1 = _tmp66_;
			_tmp69_ = (GtkDropDown*) gtk_drop_down_new_from_strings (_tmp68_);
			g_object_ref_sink (_tmp69_);
			_g_object_unref0 (self->priv->drop_down);
			self->priv->drop_down = _tmp69_;
			_tmp68_ = (_vala_array_free (_tmp68_, _tmp68__length1, (GDestroyNotify) g_free), NULL);
			_tmp70_ = self->priv->drop_down;
			g_signal_connect_object ((GObject*) _tmp70_, "notify::selected", (GCallback) _____lambda13__g_object_notify, self, 0);
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp71_ = FALSE;
					_tmp71_ = TRUE;
					while (TRUE) {
						GList* _tmp73_;
						GamesScoresCategory* category = NULL;
						GList* _tmp74_;
						gconstpointer _tmp75_;
						GamesScoresCategory* _tmp76_;
						GamesScoresCategory* _tmp77_;
						GamesScoresCategory* _tmp78_;
						if (!_tmp71_) {
							gint _tmp72_;
							_tmp72_ = i;
							i = _tmp72_ + 1;
						}
						_tmp71_ = FALSE;
						_tmp73_ = self->priv->categories;
						if (!(((guint) i) != g_list_length (_tmp73_))) {
							break;
						}
						_tmp74_ = self->priv->categories;
						_tmp75_ = g_list_nth_data (_tmp74_, (guint) i);
						_tmp76_ = _g_object_ref0 ((GamesScoresCategory*) _tmp75_);
						category = _tmp76_;
						_tmp77_ = category;
						_tmp78_ = self->priv->active_category;
						if (_tmp77_ == _tmp78_) {
							GtkDropDown* _tmp79_;
							_tmp79_ = self->priv->drop_down;
							gtk_drop_down_set_selected (_tmp79_, (guint) i);
						}
						_g_object_unref0 (category);
					}
				}
			}
			_tmp80_ = headerbar;
			_tmp81_ = self->priv->drop_down;
			adw_header_bar_set_title_widget (_tmp80_, (GtkWidget*) _tmp81_);
		}
	}
	_tmp82_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp82_);
	scroll = _tmp82_;
	_tmp83_ = (GtkColumnView*) gtk_column_view_new (NULL);
	g_object_ref_sink (_tmp83_);
	_g_object_unref0 (self->priv->score_view);
	self->priv->score_view = _tmp83_;
	_tmp84_ = self->priv->score_view;
	gtk_column_view_set_reorderable (_tmp84_, FALSE);
	_tmp85_ = self->priv->score_view;
	gtk_column_view_set_tab_behavior (_tmp85_, GTK_LIST_TAB_ITEM);
	games_scores_dialog_setup_columns (self);
	_tmp86_ = self->priv->active_category;
	games_scores_dialog_load_scores_for_category (self, _tmp86_);
	_tmp87_ = scroll;
	_tmp88_ = self->priv->score_view;
	gtk_scrolled_window_set_child (_tmp87_, (GtkWidget*) _tmp88_);
	_tmp89_ = self->priv->toolbar;
	_tmp90_ = builder;
	_tmp91_ = scroll;
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) _tmp89_, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) _tmp89_, _tmp90_, (GObject*) _tmp91_, NULL);
	_g_object_unref0 (scroll);
	_g_free0 (new_score_or_time);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (builder);
	return self;
}

GamesScoresDialog*
games_scores_dialog_new (GamesScoresContext* context,
                         const gchar* category_type,
                         GamesScoresStyle style,
                         GamesScoresScore* new_high_score,
                         GamesScoresCategory* current_cat,
                         const gchar* icon_name)
{
	return games_scores_dialog_construct (GAMES_SCORES_TYPE_DIALOG, context, category_type, style, new_high_score, current_cat, icon_name);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data5_->self;
		_data5_->categories_array = (_vala_array_free (_data5_->categories_array, _data5_->categories_array_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda12_ (Block5Data* _data5_,
             GamesScoresCategory* x)
{
	GamesScoresDialog* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = _data5_->self;
	_tmp0_ = games_scores_category_get_name (x);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_vala_array_add1 (&_data5_->categories_array, &_data5_->categories_array_length1, &_data5_->_categories_array_size_, _tmp2_);
}

static void
___lambda12__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda12_ (self, (GamesScoresCategory*) data);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
games_scores_dialog_load_categories (GamesScoresDialog* self,
                                     gint* result_length1)
{
	Block5Data* _data5_;
	gchar** _tmp0_;
	GList* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data5_->categories_array = _tmp0_;
	_data5_->categories_array_length1 = 0;
	_data5_->_categories_array_size_ = _data5_->categories_array_length1;
	_tmp1_ = self->priv->categories;
	g_list_foreach (_tmp1_, ___lambda12__gfunc, _data5_);
	_tmp2_ = (_data5_->categories_array != NULL) ? _vala_array_dup1 (_data5_->categories_array, _data5_->categories_array_length1) : _data5_->categories_array;
	_tmp2__length1 = _data5_->categories_array_length1;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

static void
games_scores_dialog_load_scores_for_category (GamesScoresDialog* self,
                                              GamesScoresCategory* category)
{
	GListStore* _tmp0_;
	GeeList* best_n_scores = NULL;
	GamesScoresContext* _tmp1_;
	GeeList* _tmp2_;
	GtkColumnView* _tmp13_;
	GamesScoresCategory* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	_tmp0_ = self->priv->score_model;
	g_list_store_remove_all (_tmp0_);
	_tmp1_ = self->priv->context;
	_tmp2_ = games_scores_context_get_high_scores (_tmp1_, category, 10);
	best_n_scores = _tmp2_;
	{
		GeeList* _score_list = NULL;
		GeeList* _tmp3_;
		gint _score_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _score_index = 0;
		_tmp3_ = best_n_scores;
		_score_list = _tmp3_;
		_tmp4_ = _score_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_score_size = _tmp6_;
		_score_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			GamesScoresScore* score = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			GListStore* _tmp11_;
			GamesScoresScore* _tmp12_;
			_score_index = _score_index + 1;
			_tmp7_ = _score_index;
			_tmp8_ = _score_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _score_list;
			_tmp10_ = gee_list_get (_tmp9_, _score_index);
			score = (GamesScoresScore*) _tmp10_;
			_tmp11_ = self->priv->score_model;
			_tmp12_ = score;
			g_list_store_append (_tmp11_, (GObject*) _tmp12_);
			_g_object_unref0 (score);
		}
	}
	_tmp13_ = self->priv->score_view;
	gtk_column_view_scroll_to (_tmp13_, (guint) 0, NULL, GTK_LIST_SCROLL_NONE, NULL);
	_tmp14_ = _g_object_ref0 (category);
	_g_object_unref0 (self->priv->active_category);
	self->priv->active_category = _tmp14_;
	_g_object_unref0 (best_n_scores);
}

static void
__lambda22_ (GamesScoresDialog* self)
{
	GtkColumnView* _tmp0_;
	_tmp0_ = self->priv->score_view;
	gtk_column_view_scroll_to (_tmp0_, (guint) 0, NULL, GTK_LIST_SCROLL_FOCUS, NULL);
}

static void
___lambda22__gtk_sorter_changed (GtkSorter* _sender,
                                 GtkSorterChange change,
                                 gpointer self)
{
	__lambda22_ ((GamesScoresDialog*) self);
}

static void
games_scores_dialog_setup_columns (GamesScoresDialog* self)
{
	GtkColumnView* _tmp0_;
	GtkColumnViewColumn* _tmp1_;
	GtkColumnView* _tmp2_;
	GtkColumnViewColumn* _tmp3_;
	GtkColumnView* _tmp4_;
	GtkColumnViewColumn* _tmp5_;
	GtkColumnViewColumn* _tmp6_;
	GtkColumnViewColumn* _tmp7_;
	GtkColumnViewColumn* _tmp8_;
	GtkColumnViewColumn* _tmp9_;
	GListStore* _tmp10_;
	GtkSortListModel* sort_model = NULL;
	GListStore* _tmp11_;
	GListModel* _tmp12_;
	GtkColumnView* _tmp13_;
	GtkSorter* _tmp14_;
	GtkSorter* _tmp15_;
	GtkSorter* _tmp16_;
	GtkSortListModel* _tmp17_;
	GtkColumnView* _tmp18_;
	GtkSortListModel* _tmp19_;
	GListModel* _tmp20_;
	GtkNoSelection* _tmp21_;
	GtkNoSelection* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GtkColumnView* _tmp28_;
	GtkSorter* _tmp29_;
	GtkSorter* _tmp30_;
	g_return_if_fail (self != NULL);
	games_scores_dialog_set_up_rank_column (self);
	games_scores_dialog_set_up_score_column (self);
	games_scores_dialog_set_up_player_column (self);
	_tmp0_ = self->priv->score_view;
	_tmp1_ = self->priv->rank_column;
	gtk_column_view_append_column (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->score_view;
	_tmp3_ = self->priv->score_column;
	gtk_column_view_append_column (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->score_view;
	_tmp5_ = self->priv->player_column;
	gtk_column_view_append_column (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->score_column;
	gtk_column_view_column_set_expand (_tmp6_, TRUE);
	_tmp7_ = self->priv->score_column;
	gtk_column_view_column_set_fixed_width (_tmp7_, 0);
	_tmp8_ = self->priv->player_column;
	gtk_column_view_column_set_expand (_tmp8_, TRUE);
	_tmp9_ = self->priv->player_column;
	gtk_column_view_column_set_fixed_width (_tmp9_, 0);
	_tmp10_ = g_list_store_new (GAMES_SCORES_TYPE_SCORE);
	_g_object_unref0 (self->priv->score_model);
	self->priv->score_model = _tmp10_;
	_tmp11_ = self->priv->score_model;
	_tmp12_ = _g_object_ref0 ((GListModel*) _tmp11_);
	_tmp13_ = self->priv->score_view;
	_tmp14_ = gtk_column_view_get_sorter (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_tmp17_ = gtk_sort_list_model_new (_tmp12_, _tmp16_);
	sort_model = _tmp17_;
	_tmp18_ = self->priv->score_view;
	_tmp19_ = sort_model;
	_tmp20_ = _g_object_ref0 ((GListModel*) _tmp19_);
	_tmp21_ = gtk_no_selection_new (_tmp20_);
	_tmp22_ = _tmp21_;
	gtk_column_view_set_model (_tmp18_, (GtkSelectionModel*) _tmp22_);
	_g_object_unref0 (_tmp22_);
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = self->priv->scores_style == GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER;
	}
	if (_tmp23_) {
		GtkColumnView* _tmp24_;
		GtkColumnViewColumn* _tmp25_;
		_tmp24_ = self->priv->score_view;
		_tmp25_ = self->priv->rank_column;
		gtk_column_view_sort_by_column (_tmp24_, _tmp25_, GTK_SORT_ASCENDING);
	} else {
		GtkColumnView* _tmp26_;
		GtkColumnViewColumn* _tmp27_;
		_tmp26_ = self->priv->score_view;
		_tmp27_ = self->priv->rank_column;
		gtk_column_view_sort_by_column (_tmp26_, _tmp27_, GTK_SORT_DESCENDING);
	}
	_tmp28_ = self->priv->score_view;
	_tmp29_ = gtk_column_view_get_sorter (_tmp28_);
	_tmp30_ = _tmp29_;
	g_signal_connect_object (_tmp30_, "changed", (GCallback) ___lambda22__gtk_sorter_changed, self, 0);
	_g_object_unref0 (sort_model);
}

static gint
games_scores_dialog_rank_sorter_cb (GamesScoresScore* entry1,
                                    GamesScoresScore* entry2)
{
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	glong _tmp3_;
	glong _tmp4_;
	glong _tmp5_;
	glong _tmp6_;
	glong _tmp7_;
	gint result;
	g_return_val_if_fail (entry1 != NULL, 0);
	g_return_val_if_fail (entry2 != NULL, 0);
	_tmp0_ = games_scores_score_get_score (entry1);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_scores_score_get_score (entry2);
	_tmp3_ = _tmp2_;
	_tmp4_ = games_scores_score_get_score (entry1);
	_tmp5_ = _tmp4_;
	_tmp6_ = games_scores_score_get_score (entry2);
	_tmp7_ = _tmp6_;
	result = ((gint) (_tmp1_ > _tmp3_)) - ((gint) (_tmp5_ < _tmp7_));
	return result;
}

static void
__lambda14_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_ = NULL;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_width_chars (_tmp0_, 3);
	gtk_label_set_xalign (_tmp0_, (gfloat) 0);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) label, "caption");
	gtk_widget_add_css_class ((GtkWidget*) label, "numeric");
	gtk_list_item_set_child (list_item, (GtkWidget*) label);
	_g_object_unref0 (label);
}

static void
___lambda14__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	__lambda14_ ((GamesScoresDialog*) self, _sender, object);
}

static void
__lambda15_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkLabel* label = NULL;
	GtkListItem* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GamesScoresScore* score = NULL;
	GtkListItem* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	guint position = 0U;
	GListStore* _tmp6_;
	GamesScoresScore* _tmp7_;
	guint _tmp8_ = 0U;
	GamesScoresScore* _tmp9_;
	GamesScoresScore* _tmp10_;
	GtkLabel* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp2_) : NULL;
	_tmp3_ = list_item;
	_tmp4_ = gtk_list_item_get_item (_tmp3_);
	_tmp5_ = _tmp4_;
	score = GAMES_SCORES_IS_SCORE (_tmp5_) ? ((GamesScoresScore*) _tmp5_) : NULL;
	_tmp6_ = self->priv->score_model;
	_tmp7_ = score;
	g_list_store_find (_tmp6_, (GObject*) _tmp7_, &_tmp8_);
	position = _tmp8_;
	_tmp9_ = score;
	_tmp10_ = self->priv->new_high_score;
	if (_tmp9_ == _tmp10_) {
		GtkLabel* _tmp11_;
		_tmp11_ = label;
		gtk_widget_add_css_class ((GtkWidget*) _tmp11_, "heading");
	}
	_tmp12_ = label;
	_tmp13_ = g_strdup_printf ("%u", position + 1);
	_tmp14_ = _tmp13_;
	gtk_label_set_label (_tmp12_, _tmp14_);
	_g_free0 (_tmp14_);
}

static void
___lambda15__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda15_ ((GamesScoresDialog*) self, _sender, object);
}

static void
games_scores_dialog_set_up_rank_column (GamesScoresDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkMultiSorter* sorter = NULL;
	GtkMultiSorter* _tmp1_;
	GtkCustomSorter* _tmp2_;
	GtkListItemFactory* _tmp3_;
	GtkColumnViewColumn* _tmp4_;
	GtkColumnViewColumn* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	_tmp1_ = gtk_multi_sorter_new ();
	sorter = _tmp1_;
	g_signal_connect_object (factory, "setup", (GCallback) ___lambda14__gtk_signal_list_item_factory_setup, self, 0);
	g_signal_connect_object (factory, "bind", (GCallback) ___lambda15__gtk_signal_list_item_factory_bind, self, 0);
	_tmp2_ = gtk_custom_sorter_new ((GCompareDataFunc) games_scores_dialog_rank_sorter_cb, NULL, NULL);
	gtk_multi_sorter_append (sorter, (GtkSorter*) _tmp2_);
	_tmp3_ = _g_object_ref0 ((GtkListItemFactory*) factory);
	_tmp4_ = gtk_column_view_column_new ("Rank", _tmp3_);
	_g_object_unref0 (self->priv->rank_column);
	self->priv->rank_column = _tmp4_;
	_tmp5_ = self->priv->rank_column;
	gtk_column_view_column_set_sorter (_tmp5_, (GtkSorter*) sorter);
	_g_object_unref0 (sorter);
	_g_object_unref0 (factory);
}

static void
__lambda16_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkInscription* _tmp0_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkInscription*) gtk_inscription_new (NULL);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) label, "numeric");
	gtk_list_item_set_child (list_item, (GtkWidget*) label);
	_g_object_unref0 (label);
}

static void
___lambda16__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	__lambda16_ ((GamesScoresDialog*) self, _sender, object);
}

static void
___lambda17_ (GamesScoresDialog* self,
              GtkSignalListItemFactory* factory,
              GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkListItem* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GamesScoresScore* score = NULL;
	GtkListItem* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	GamesScoresScore* _tmp6_;
	GamesScoresScore* _tmp7_;
	GtkInscription* _tmp9_;
	GamesScoresScore* _tmp10_;
	glong _tmp11_;
	glong _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_inscription_get_type ()) ? ((GtkInscription*) _tmp2_) : NULL;
	_tmp3_ = list_item;
	_tmp4_ = gtk_list_item_get_item (_tmp3_);
	_tmp5_ = _tmp4_;
	score = GAMES_SCORES_IS_SCORE (_tmp5_) ? ((GamesScoresScore*) _tmp5_) : NULL;
	_tmp6_ = score;
	_tmp7_ = self->priv->new_high_score;
	if (_tmp6_ == _tmp7_) {
		GtkInscription* _tmp8_;
		_tmp8_ = label;
		gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "heading");
	}
	_tmp9_ = label;
	_tmp10_ = score;
	_tmp11_ = games_scores_score_get_score (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%li", _tmp12_);
	_tmp14_ = _tmp13_;
	gtk_inscription_set_text (_tmp9_, _tmp14_);
	_g_free0 (_tmp14_);
}

static void
____lambda17__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	___lambda17_ ((GamesScoresDialog*) self, _sender, object);
}

static void
___lambda18_ (GamesScoresDialog* self,
              GtkSignalListItemFactory* factory,
              GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkListItem* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GamesScoresScore* score = NULL;
	GtkListItem* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	gchar* time_label = NULL;
	GamesScoresScore* _tmp6_;
	glong _tmp7_;
	glong _tmp8_;
	gchar* _tmp9_;
	GamesScoresScore* _tmp10_;
	glong _tmp11_;
	glong _tmp12_;
	GamesScoresScore* _tmp20_;
	GamesScoresScore* _tmp21_;
	GtkInscription* _tmp23_;
	const gchar* _tmp24_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_inscription_get_type ()) ? ((GtkInscription*) _tmp2_) : NULL;
	_tmp3_ = list_item;
	_tmp4_ = gtk_list_item_get_item (_tmp3_);
	_tmp5_ = _tmp4_;
	score = GAMES_SCORES_IS_SCORE (_tmp5_) ? ((GamesScoresScore*) _tmp5_) : NULL;
	_tmp6_ = score;
	_tmp7_ = games_scores_score_get_score (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%lds", _tmp8_);
	time_label = _tmp9_;
	_tmp10_ = score;
	_tmp11_ = games_scores_score_get_score (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ >= ((glong) 60)) {
		GamesScoresScore* _tmp13_;
		glong _tmp14_;
		glong _tmp15_;
		GamesScoresScore* _tmp16_;
		glong _tmp17_;
		glong _tmp18_;
		gchar* _tmp19_;
		_tmp13_ = score;
		_tmp14_ = games_scores_score_get_score (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = score;
		_tmp17_ = games_scores_score_get_score (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("%ldm %lds", _tmp15_ / 60, _tmp18_ % 60);
		_g_free0 (time_label);
		time_label = _tmp19_;
	}
	_tmp20_ = score;
	_tmp21_ = self->priv->new_high_score;
	if (_tmp20_ == _tmp21_) {
		GtkInscription* _tmp22_;
		_tmp22_ = label;
		gtk_widget_add_css_class ((GtkWidget*) _tmp22_, "heading");
	}
	_tmp23_ = label;
	_tmp24_ = time_label;
	gtk_inscription_set_text (_tmp23_, _tmp24_);
	_g_free0 (time_label);
}

static void
____lambda18__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	___lambda18_ ((GamesScoresDialog*) self, _sender, object);
}

static void
games_scores_dialog_set_up_score_column (GamesScoresDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkSignalListItemFactory* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp5_;
	GtkSignalListItemFactory* _tmp6_;
	GtkListItemFactory* _tmp7_;
	GtkColumnViewColumn* _tmp8_;
	GtkColumnViewColumn* _tmp9_;
	GtkColumnViewColumn* _tmp10_;
	GtkSorter* _tmp11_;
	GtkSorter* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	_tmp1_ = factory;
	g_signal_connect_object (_tmp1_, "setup", (GCallback) ___lambda16__gtk_signal_list_item_factory_setup, self, 0);
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp2_) {
		GtkSignalListItemFactory* _tmp3_;
		_tmp3_ = factory;
		g_signal_connect_object (_tmp3_, "bind", (GCallback) ____lambda17__gtk_signal_list_item_factory_bind, self, 0);
	} else {
		GtkSignalListItemFactory* _tmp4_;
		_tmp4_ = factory;
		g_signal_connect_object (_tmp4_, "bind", (GCallback) ____lambda18__gtk_signal_list_item_factory_bind, self, 0);
	}
	_tmp5_ = self->priv->score_or_time;
	_tmp6_ = factory;
	_tmp7_ = _g_object_ref0 ((GtkListItemFactory*) _tmp6_);
	_tmp8_ = gtk_column_view_column_new (_tmp5_, _tmp7_);
	_g_object_unref0 (self->priv->score_column);
	self->priv->score_column = _tmp8_;
	_tmp9_ = self->priv->score_column;
	_tmp10_ = self->priv->rank_column;
	_tmp11_ = gtk_column_view_column_get_sorter (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_column_view_column_set_sorter (_tmp9_, _tmp12_);
	_g_object_unref0 (factory);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data7_->_data6_->self;
		_g_object_unref0 (_data7_->entry);
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
___lambda20_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	GamesScoresDialog* self;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GtkEntry* _tmp3_;
	const gchar* _tmp4_;
	GamesScoresScore* _tmp5_;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = self->priv->context;
	_tmp1_ = _data6_->score;
	_tmp2_ = self->priv->active_category;
	_tmp3_ = _data7_->entry;
	_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
	games_scores_context_update_score_name (_tmp0_, _tmp1_, _tmp2_, _tmp4_);
	_tmp5_ = _data6_->score;
	_tmp6_ = _data7_->entry;
	_tmp7_ = gtk_editable_get_text ((GtkEditable*) _tmp6_);
	games_scores_score_set_user (_tmp5_, _tmp7_);
}

static void
____lambda20__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda20_ (self);
}

static void
___lambda21_ (GamesScoresDialog* self)
{
	adw_dialog_close ((AdwDialog*) self);
}

static void
____lambda21__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	___lambda21_ ((GamesScoresDialog*) self);
}

static void
__lambda19_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	Block6Data* _data6_;
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GamesScoresScore* _tmp3_;
	GamesScoresScore* _tmp4_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_data6_->score = GAMES_SCORES_IS_SCORE (_tmp2_) ? ((GamesScoresScore*) _tmp2_) : NULL;
	_tmp3_ = _data6_->score;
	_tmp4_ = self->priv->new_high_score;
	if (_tmp3_ == _tmp4_) {
		Block7Data* _data7_;
		GtkEntry* _tmp5_;
		GtkEntry* _tmp6_;
		GamesScoresScore* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GtkEntry* _tmp10_;
		GtkEntry* _tmp11_;
		GtkEntry* _tmp12_;
		GtkEntry* _tmp13_;
		GtkListItem* _tmp14_;
		GtkEntry* _tmp15_;
		GtkColumnView* _tmp16_;
		GtkEntry* _tmp17_;
		GtkColumnView* _tmp18_;
		GtkListItem* _tmp19_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->_data6_ = block6_data_ref (_data6_);
		_tmp5_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp5_);
		_data7_->entry = _tmp5_;
		_tmp6_ = _data7_->entry;
		_tmp7_ = _data6_->score;
		_tmp8_ = games_scores_score_get_user (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_editable_set_text ((GtkEditable*) _tmp6_, _tmp9_);
		_tmp10_ = _data7_->entry;
		gtk_entry_set_has_frame (_tmp10_, FALSE);
		_tmp11_ = _data7_->entry;
		gtk_widget_add_css_class ((GtkWidget*) _tmp11_, "heading");
		_tmp12_ = _data7_->entry;
		g_signal_connect_data ((GObject*) _tmp12_, "notify::text", (GCallback) ____lambda20__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_tmp13_ = _data7_->entry;
		g_signal_connect_object (_tmp13_, "activate", (GCallback) ____lambda21__gtk_entry_activate, self, 0);
		_tmp14_ = list_item;
		_tmp15_ = _data7_->entry;
		gtk_list_item_set_child (_tmp14_, (GtkWidget*) _tmp15_);
		_tmp16_ = self->priv->score_view;
		adw_dialog_set_focus ((AdwDialog*) self, (GtkWidget*) _tmp16_);
		_tmp17_ = _data7_->entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp17_);
		_tmp18_ = self->priv->score_view;
		_tmp19_ = list_item;
		gtk_column_view_scroll_to (_tmp18_, gtk_list_item_get_position (_tmp19_), NULL, GTK_LIST_SCROLL_NONE, NULL);
		block7_data_unref (_data7_);
		_data7_ = NULL;
	} else {
		GtkListItem* _tmp20_;
		GamesScoresScore* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		GtkInscription* _tmp24_;
		GtkInscription* _tmp25_;
		_tmp20_ = list_item;
		_tmp21_ = _data6_->score;
		_tmp22_ = games_scores_score_get_user (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = (GtkInscription*) gtk_inscription_new (_tmp23_);
		g_object_ref_sink (_tmp24_);
		_tmp25_ = _tmp24_;
		gtk_list_item_set_child (_tmp20_, (GtkWidget*) _tmp25_);
		_g_object_unref0 (_tmp25_);
	}
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
___lambda19__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda19_ ((GamesScoresDialog*) self, _sender, object);
}

static void
games_scores_dialog_set_up_player_column (GamesScoresDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkListItemFactory* _tmp1_;
	GtkColumnViewColumn* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	g_signal_connect_object (factory, "bind", (GCallback) ___lambda19__gtk_signal_list_item_factory_bind, self, 0);
	_tmp1_ = _g_object_ref0 ((GtkListItemFactory*) factory);
	_tmp2_ = gtk_column_view_column_new (_ ("Player"), _tmp1_);
	_g_object_unref0 (self->priv->player_column);
	self->priv->player_column = _tmp2_;
	_g_object_unref0 (factory);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data8_->self;
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda23_ (Block8Data* _data8_)
{
	GamesScoresDialog* self;
	self = _data8_->self;
	adw_dialog_close ((AdwDialog*) self);
	_data8_->new_game_func (_data8_->new_game_func_target);
}

static void
___lambda23__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda23_ (self);
}

static void
__lambda24_ (Block8Data* _data8_)
{
	GamesScoresDialog* self;
	self = _data8_->self;
	adw_dialog_close ((AdwDialog*) self);
	_data8_->quit_app_func (_data8_->quit_app_func_target);
}

static void
___lambda24__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda24_ (self);
}

void
games_scores_dialog_add_bottom_buttons (GamesScoresDialog* self,
                                        GamesScoresContextNewGameFunc new_game_func,
                                        gpointer new_game_func_target,
                                        GamesScoresContextQuitAppFunc quit_app_func,
                                        gpointer quit_app_func_target)
{
	Block8Data* _data8_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkCenterBox* bottom_bar = NULL;
	GtkCenterBox* _tmp1_;
	GtkButton* new_game_button = NULL;
	GtkButton* _tmp2_;
	GtkButton* quit_button = NULL;
	GtkButton* _tmp3_;
	AdwButtonContent* content = NULL;
	AdwButtonContent* _tmp4_;
	AdwToolbarView* _tmp5_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->new_game_func = new_game_func;
	_data8_->new_game_func_target = new_game_func_target;
	_data8_->quit_app_func = quit_app_func;
	_data8_->quit_app_func_target = quit_app_func_target;
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	_tmp1_ = (GtkCenterBox*) gtk_center_box_new ();
	g_object_ref_sink (_tmp1_);
	bottom_bar = _tmp1_;
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_ ("_New Game"));
	g_object_ref_sink (_tmp2_);
	new_game_button = _tmp2_;
	gtk_button_set_use_underline (new_game_button, TRUE);
	gtk_button_set_can_shrink (new_game_button, TRUE);
	g_signal_connect_data (new_game_button, "clicked", (GCallback) ___lambda23__gtk_button_clicked, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp3_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp3_);
	quit_button = _tmp3_;
	gtk_button_set_can_shrink (quit_button, TRUE);
	_tmp4_ = (AdwButtonContent*) adw_button_content_new ();
	g_object_ref_sink (_tmp4_);
	content = _tmp4_;
	adw_button_content_set_icon_name (content, "application-exit-symbolic");
	adw_button_content_set_label (content, _ ("_Quit"));
	adw_button_content_set_use_underline (content, TRUE);
	adw_button_content_set_can_shrink (content, TRUE);
	gtk_button_set_child (quit_button, (GtkWidget*) content);
	g_signal_connect_data (quit_button, "clicked", (GCallback) ___lambda24__gtk_button_clicked, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	gtk_widget_add_css_class ((GtkWidget*) new_game_button, "pill");
	gtk_widget_add_css_class ((GtkWidget*) quit_button, "toolbar");
	gtk_widget_add_css_class ((GtkWidget*) bottom_bar, "toolbar");
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) bottom_bar, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) bottom_bar, builder, (GObject*) new_game_button, "center");
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) bottom_bar, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) bottom_bar, builder, (GObject*) quit_button, "end");
	_tmp5_ = self->priv->toolbar;
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) _tmp5_, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) _tmp5_, builder, (GObject*) bottom_bar, "bottom");
	_g_object_unref0 (content);
	_g_object_unref0 (quit_button);
	_g_object_unref0 (new_game_button);
	_g_object_unref0 (bottom_bar);
	_g_object_unref0 (builder);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
games_scores_dialog_class_init (GamesScoresDialogClass * klass,
                                gpointer klass_data)
{
	games_scores_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_scores_dialog_finalize;
}

static void
games_scores_dialog_instance_init (GamesScoresDialog * self,
                                   gpointer klass)
{
	self->priv = games_scores_dialog_get_instance_private (self);
	self->priv->active_category = NULL;
	self->priv->categories = NULL;
	self->priv->score_model = NULL;
	self->priv->done_button = NULL;
	self->priv->drop_down = NULL;
}

static void
games_scores_dialog_finalize (GObject * obj)
{
	GamesScoresDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->active_category);
	(self->priv->categories == NULL) ? NULL : (self->priv->categories = (_g_list_free__g_object_unref0_ (self->priv->categories), NULL));
	_g_object_unref0 (self->priv->score_model);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->done_button);
	_g_object_unref0 (self->priv->drop_down);
	_g_object_unref0 (self->priv->score_view);
	_g_object_unref0 (self->priv->rank_column);
	_g_object_unref0 (self->priv->score_column);
	_g_object_unref0 (self->priv->player_column);
	_g_object_unref0 (self->priv->new_high_score);
	_g_free0 (self->priv->score_or_time);
	G_OBJECT_CLASS (games_scores_dialog_parent_class)->finalize (obj);
}

static GType
games_scores_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesScoresDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresDialog), 0, (GInstanceInitFunc) games_scores_dialog_instance_init, NULL };
	GType games_scores_dialog_type_id;
	games_scores_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "GamesScoresDialog", &g_define_type_info, 0);
	GamesScoresDialog_private_offset = g_type_add_instance_private (games_scores_dialog_type_id, sizeof (GamesScoresDialogPrivate));
	return games_scores_dialog_type_id;
}

GType
games_scores_dialog_get_type (void)
{
	static volatile gsize games_scores_dialog_type_id__once = 0;
	if (g_once_init_enter (&games_scores_dialog_type_id__once)) {
		GType games_scores_dialog_type_id;
		games_scores_dialog_type_id = games_scores_dialog_get_type_once ();
		g_once_init_leave (&games_scores_dialog_type_id__once, games_scores_dialog_type_id);
	}
	return games_scores_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

