/* math-function-popover.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from math-function-popover.vala, do not modify */

/*
 * Copyright (C) 2013 Garima Joshi
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "calculator.h"
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MATH_POPOVER (math_popover_get_type ())
#define MATH_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_POPOVER, MathPopover))
#define MATH_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_POPOVER, MathPopoverClass))
#define IS_MATH_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_POPOVER))
#define IS_MATH_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_POPOVER))
#define MATH_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_POPOVER, MathPopoverClass))

typedef struct _MathPopover MathPopover;
typedef struct _MathPopoverClass MathPopoverClass;
typedef struct _MathPopoverPrivate MathPopoverPrivate;

#define TYPE_MATH_FUNCTION_POPOVER (math_function_popover_get_type ())
#define MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopover))
#define MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))
#define IS_MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION_POPOVER))
#define IS_MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION_POPOVER))
#define MATH_FUNCTION_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))

typedef struct _MathFunctionPopover MathFunctionPopover;
typedef struct _MathFunctionPopoverClass MathFunctionPopoverClass;
typedef struct _MathFunctionPopoverPrivate MathFunctionPopoverPrivate;
enum  {
	MATH_FUNCTION_POPOVER_0_PROPERTY,
	MATH_FUNCTION_POPOVER_NUM_PROPERTIES
};
static GParamSpec* math_function_popover_properties[MATH_FUNCTION_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MathPopover {
	GtkPopover parent_instance;
	MathPopoverPrivate * priv;
	MathEquation* equation;
	GListStore* model;
};

struct _MathPopoverClass {
	GtkPopoverClass parent_class;
	gboolean (*is_deletable) (MathPopover* self, gconstpointer item);
	gboolean (*is_editable) (MathPopover* self, gconstpointer item);
	gchar* (*get_item_text) (MathPopover* self, gconstpointer item);
	gint (*get_item_index) (MathPopover* self, gconstpointer item);
	gchar* (*validate_name) (MathPopover* self, const gchar* name);
	GtkEntry* (*get_name_entry) (MathPopover* self);
	GtkButton* (*get_add_button) (MathPopover* self);
	GtkLabel* (*get_error_label) (MathPopover* self);
};

struct _MathFunctionPopover {
	MathPopover parent_instance;
	MathFunctionPopoverPrivate * priv;
};

struct _MathFunctionPopoverClass {
	MathPopoverClass parent_class;
};

struct _MathFunctionPopoverPrivate {
	GtkStack* stack;
	GtkListBox* built_in_list;
	GtkSeparator* separator;
	GtkListBox* custom_list;
	GtkSpinButton* add_arguments_button;
	GtkEntry* _name_entry;
	GtkButton* _add_button;
	GtkLabel* _error_label;
};

static gint MathFunctionPopover_private_offset;
static gpointer math_function_popover_parent_class = NULL;
static gchar** math_function_popover_FUNCTION_ARGS;
static gint math_function_popover_FUNCTION_ARGS_length1;
static gchar** math_function_popover_FUNCTION_ARGS = NULL;
static gint math_function_popover_FUNCTION_ARGS_length1 = 0;
static gint _math_function_popover_FUNCTION_ARGS_size_ = 0;
VALA_EXTERN gchar** math_popover_RESERVED_VARIABLE_NAMES;
VALA_EXTERN gint math_popover_RESERVED_VARIABLE_NAMES_length1;
VALA_EXTERN gchar** math_popover_OPERATORS;
VALA_EXTERN gint math_popover_OPERATORS_length1;

VALA_EXTERN GType math_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathPopover, g_object_unref)
VALA_EXTERN GType math_function_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathFunctionPopover, g_object_unref)
VALA_EXTERN gboolean math_popover_is_deletable (MathPopover* self,
                                    gconstpointer item);
VALA_EXTERN gboolean math_popover_is_editable (MathPopover* self,
                                   gconstpointer item);
VALA_EXTERN gchar* math_popover_get_item_text (MathPopover* self,
                                   gconstpointer item);
VALA_EXTERN gint math_popover_get_item_index (MathPopover* self,
                                  gconstpointer item);
VALA_EXTERN gchar* math_popover_validate_name (MathPopover* self,
                                   const gchar* name);
VALA_EXTERN GtkEntry* math_popover_get_name_entry (MathPopover* self);
VALA_EXTERN GtkButton* math_popover_get_add_button (MathPopover* self);
VALA_EXTERN GtkLabel* math_popover_get_error_label (MathPopover* self);
VALA_EXTERN MathFunctionPopover* math_function_popover_new (MathEquation* equation);
VALA_EXTERN MathFunctionPopover* math_function_popover_construct (GType object_type,
                                                      MathEquation* equation);
VALA_EXTERN MathPopover* math_popover_construct (GType object_type,
                                     GType t_type,
                                     GBoxedCopyFunc t_dup_func,
                                     GDestroyNotify t_destroy_func,
                                     MathEquation* equation,
                                     GListStore* model,
                                     GCompareDataFunc compare_func,
                                     gpointer compare_func_target);
static GtkWidget* __lambda26_ (MathFunctionPopover* self,
                        GObject* item);
VALA_EXTERN GtkWidget* math_popover_make_item_row (MathPopover* self,
                                       gconstpointer item);
static GtkWidget* ___lambda26__gtk_list_box_create_widget_func (GObject* item,
                                                         gpointer self);
static void __lambda27_ (MathFunctionPopover* self);
static void ___lambda27__gtk_popover_closed (GtkPopover* _sender,
                                      gpointer self);
static void math_function_popover_function_edited_cb (MathFunctionPopover* self,
                                               MathFunction* function);
static void _math_function_popover_function_edited_cb_math_popover_item_edited (MathPopover* _sender,
                                                                         gconstpointer item,
                                                                         gpointer self);
static void math_function_popover_function_deleted_cb (MathFunctionPopover* self,
                                                MathFunction* function);
static void _math_function_popover_function_deleted_cb_math_popover_item_deleted (MathPopover* _sender,
                                                                           gconstpointer item,
                                                                           gpointer self);
static void math_function_popover_load_built_in_functions (MathFunctionPopover* self);
static void math_function_popover_load_custom_functions (MathFunctionPopover* self);
VALA_EXTERN GtkWidget* math_popover_make_category_row (MathPopover* self,
                                           const gchar* name,
                                           GtkListBox** submenu);
static void math_function_popover_insert_function_cb (MathFunctionPopover* self,
                                               GtkListBoxRow* row);
static void _math_function_popover_insert_function_cb_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                           GtkListBoxRow* row,
                                                                           gpointer self);
VALA_EXTERN void math_popover_item_added_cb (MathPopover* self,
                                 gconstpointer item);
static void __lambda28_ (MathFunctionPopover* self,
                  MathFunction* f);
static void ___lambda28__function_manager_function_added (FunctionManager* _sender,
                                                   MathFunction* function,
                                                   gpointer self);
static void __lambda29_ (MathFunctionPopover* self,
                  MathFunction* f);
VALA_EXTERN void math_popover_item_edited_cb (MathPopover* self,
                                  gconstpointer item);
static void ___lambda29__function_manager_function_edited (FunctionManager* _sender,
                                                    MathFunction* new_function,
                                                    gpointer self);
static void __lambda30_ (MathFunctionPopover* self,
                  MathFunction* f);
VALA_EXTERN void math_popover_item_deleted_cb (MathPopover* self,
                                   gconstpointer item);
static void ___lambda30__function_manager_function_deleted (FunctionManager* _sender,
                                                     MathFunction* function,
                                                     gpointer self);
static void __lambda31_ (MathFunctionPopover* self);
static void ___lambda31__g_list_model_items_changed (GListModel* _sender,
                                              guint position,
                                              guint removed,
                                              guint added,
                                              gpointer self);
VALA_EXTERN void math_popover_close_popover (MathPopover* self);
static void math_function_popover_open_submenu_cb (MathFunctionPopover* self,
                                            GtkListBoxRow* row);
static void _math_function_popover_open_submenu_cb_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                        GtkListBoxRow* row,
                                                                        gpointer self);
static void math_function_popover_add_function_cb (MathFunctionPopover* self,
                                            GtkWidget* widget);
static void _math_function_popover_add_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static gboolean math_function_popover_real_is_deletable (MathPopover* base,
                                                  MathFunction* function);
static gboolean math_function_popover_real_is_editable (MathPopover* base,
                                                 MathFunction* function);
static gchar* math_function_popover_real_get_item_text (MathPopover* base,
                                                 MathFunction* function);
static gint math_function_popover_real_get_item_index (MathPopover* base,
                                                MathFunction* item);
static gboolean __lambda32_ (GObject* a,
                      GObject* b);
static gboolean ___lambda32__gequal_func (gconstpointer a,
                                   gconstpointer b);
static gchar* math_function_popover_real_validate_name (MathPopover* base,
                                                 const gchar* name);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void math_function_popover_finalize (GObject * obj);
static GType math_function_popover_get_type_once (void);
static void _vala_math_function_popover_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
math_function_popover_get_instance_private (MathFunctionPopover* self)
{
	return G_STRUCT_MEMBER_P (self, MathFunctionPopover_private_offset);
}

static GtkWidget*
__lambda26_ (MathFunctionPopover* self,
             GObject* item)
{
	GtkWidget* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = math_popover_make_item_row ((MathPopover*) self, G_TYPE_CHECK_INSTANCE_TYPE (item, TYPE_MATH_FUNCTION) ? ((MathFunction*) item) : NULL);
	result = _tmp0_;
	return result;
}

static GtkWidget*
___lambda26__gtk_list_box_create_widget_func (GObject* item,
                                              gpointer self)
{
	GtkWidget* result;
	result = __lambda26_ ((MathFunctionPopover*) self, item);
	return result;
}

static void
__lambda27_ (MathFunctionPopover* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkSpinButton* _tmp2_;
	GtkStack* _tmp3_;
	GtkSelectionModel* _tmp4_;
	GtkSelectionModel* _tmp5_;
	GtkSelectionModel* _tmp6_;
	_tmp0_ = math_popover_get_name_entry ((MathPopover*) self);
	_tmp1_ = _tmp0_;
	gtk_editable_set_text ((GtkEditable*) _tmp1_, "");
	_tmp2_ = self->priv->add_arguments_button;
	gtk_spin_button_set_value (_tmp2_, (gdouble) 1);
	_tmp3_ = self->priv->stack;
	_tmp4_ = gtk_stack_get_pages (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gtk_selection_model_select_item (_tmp6_, (guint) 0, TRUE);
	_g_object_unref0 (_tmp6_);
}

static void
___lambda27__gtk_popover_closed (GtkPopover* _sender,
                                 gpointer self)
{
	__lambda27_ ((MathFunctionPopover*) self);
}

static void
_math_function_popover_function_edited_cb_math_popover_item_edited (MathPopover* _sender,
                                                                    gconstpointer item,
                                                                    gpointer self)
{
	math_function_popover_function_edited_cb ((MathFunctionPopover*) self, (MathFunction*) item);
}

static void
_math_function_popover_function_deleted_cb_math_popover_item_deleted (MathPopover* _sender,
                                                                      gconstpointer item,
                                                                      gpointer self)
{
	math_function_popover_function_deleted_cb ((MathFunctionPopover*) self, (MathFunction*) item);
}

MathFunctionPopover*
math_function_popover_construct (GType object_type,
                                 MathEquation* equation)
{
	MathFunctionPopover * self = NULL;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	GtkListBox* _tmp2_;
	GListStore* _tmp3_;
	GtkSpinButton* _tmp4_;
	GtkSpinButton* _tmp5_;
	g_return_val_if_fail (equation != NULL, NULL);
	_tmp0_ = g_list_store_new (TYPE_MATH_FUNCTION);
	_tmp1_ = _tmp0_;
	self = (MathFunctionPopover*) math_popover_construct (object_type, TYPE_MATH_FUNCTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, equation, _tmp1_, (GCompareDataFunc) math_function_name_compare_func, NULL);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->custom_list;
	_tmp3_ = ((MathPopover*) self)->model;
	gtk_list_box_bind_model (_tmp2_, (GListModel*) _tmp3_, ___lambda26__gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp4_ = self->priv->add_arguments_button;
	gtk_spin_button_set_range (_tmp4_, (gdouble) 1, (gdouble) 10);
	_tmp5_ = self->priv->add_arguments_button;
	gtk_spin_button_set_increments (_tmp5_, (gdouble) 1, (gdouble) 1);
	g_signal_connect_object ((GtkPopover*) self, "closed", (GCallback) ___lambda27__gtk_popover_closed, self, 0);
	g_signal_connect_object ((MathPopover*) self, "item-edited", (GCallback) _math_function_popover_function_edited_cb_math_popover_item_edited, self, 0);
	g_signal_connect_object ((MathPopover*) self, "item-deleted", (GCallback) _math_function_popover_function_deleted_cb_math_popover_item_deleted, self, 0);
	math_function_popover_load_built_in_functions (self);
	math_function_popover_load_custom_functions (self);
	return self;
}

MathFunctionPopover*
math_function_popover_new (MathEquation* equation)
{
	return math_function_popover_construct (TYPE_MATH_FUNCTION_POPOVER, equation);
}

static void
_math_function_popover_insert_function_cb_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                      GtkListBoxRow* row,
                                                                      gpointer self)
{
	math_function_popover_insert_function_cb ((MathFunctionPopover*) self, row);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
math_function_popover_load_built_in_functions (MathFunctionPopover* self)
{
	FunctionCategory* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = function_manager_FUNCTION_CATEGORIES;
	_tmp0__length1 = function_manager_FUNCTION_CATEGORIES_length1;
	{
		FunctionCategory* category_collection = NULL;
		gint category_collection_length1 = 0;
		gint _category_collection_size_ = 0;
		gint category_it = 0;
		category_collection = _tmp0_;
		category_collection_length1 = _tmp0__length1;
		for (category_it = 0; category_it < category_collection_length1; category_it = category_it + 1) {
			FunctionCategory _tmp1_;
			FunctionCategory _tmp2_ = {0};
			FunctionCategory category = {0};
			_tmp1_ = category_collection[category_it];
			function_category_copy (&_tmp1_, &_tmp2_);
			category = _tmp2_;
			{
				GtkListBox* submenu = NULL;
				GtkWidget* category_row = NULL;
				FunctionCategory _tmp3_;
				const gchar* _tmp4_;
				GtkListBox* _tmp5_ = NULL;
				GtkWidget* _tmp6_;
				GtkListBox* _tmp7_;
				GtkWidget* _tmp8_;
				GtkListBox* _tmp9_;
				GtkScrolledWindow* submenu_scrolled = NULL;
				GtkScrolledWindow* _tmp10_;
				GtkScrolledWindow* _tmp11_;
				GtkScrolledWindow* _tmp12_;
				GtkScrolledWindow* _tmp13_;
				GtkScrolledWindow* _tmp14_;
				GtkListBox* _tmp15_;
				GtkStack* _tmp16_;
				GtkScrolledWindow* _tmp17_;
				FunctionCategory _tmp18_;
				MathFunction** _tmp19_;
				gint _tmp19__length1;
				_tmp3_ = category;
				_tmp4_ = _tmp3_.name;
				_tmp6_ = math_popover_make_category_row ((MathPopover*) self, _tmp4_, &_tmp5_);
				_g_object_unref0 (submenu);
				submenu = _tmp5_;
				category_row = _tmp6_;
				_tmp7_ = self->priv->built_in_list;
				_tmp8_ = category_row;
				gtk_list_box_append (_tmp7_, _tmp8_);
				_tmp9_ = submenu;
				g_signal_connect_object (_tmp9_, "row-activated", (GCallback) _math_function_popover_insert_function_cb_gtk_list_box_row_activated, self, 0);
				_tmp10_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
				g_object_ref_sink (_tmp10_);
				submenu_scrolled = _tmp10_;
				_tmp11_ = submenu_scrolled;
				gtk_scrolled_window_set_propagate_natural_height (_tmp11_, TRUE);
				_tmp12_ = submenu_scrolled;
				gtk_scrolled_window_set_max_content_height (_tmp12_, 336);
				_tmp13_ = submenu_scrolled;
				g_object_set (_tmp13_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
				_tmp14_ = submenu_scrolled;
				_tmp15_ = submenu;
				gtk_scrolled_window_set_child (_tmp14_, (GtkWidget*) _tmp15_);
				_tmp16_ = self->priv->stack;
				_tmp17_ = submenu_scrolled;
				gtk_stack_add_child (_tmp16_, (GtkWidget*) _tmp17_);
				_tmp18_ = category;
				_tmp19_ = _tmp18_.functions;
				_tmp19__length1 = _tmp18_.functions_length1;
				{
					MathFunction** function_collection = NULL;
					gint function_collection_length1 = 0;
					gint _function_collection_size_ = 0;
					gint function_it = 0;
					function_collection = _tmp19_;
					function_collection_length1 = _tmp19__length1;
					for (function_it = 0; function_it < function_collection_length1; function_it = function_it + 1) {
						MathFunction* _tmp20_;
						MathFunction* function = NULL;
						_tmp20_ = _g_object_ref0 (function_collection[function_it]);
						function = _tmp20_;
						{
							GtkWidget* function_row = NULL;
							MathFunction* _tmp21_;
							GtkWidget* _tmp22_;
							GtkWidget* _tmp23_;
							MathFunction* _tmp24_;
							const gchar* _tmp25_;
							const gchar* _tmp26_;
							gchar* _tmp27_;
							GtkListBox* _tmp28_;
							GtkWidget* _tmp29_;
							_tmp21_ = function;
							_tmp22_ = math_popover_make_item_row ((MathPopover*) self, _tmp21_);
							function_row = _tmp22_;
							_tmp23_ = function_row;
							_tmp24_ = function;
							_tmp25_ = math_function_get_name (_tmp24_);
							_tmp26_ = _tmp25_;
							_tmp27_ = g_strdup (_tmp26_);
							g_object_set_data_full ((GObject*) _tmp23_, "name", _tmp27_, g_free);
							_tmp28_ = submenu;
							_tmp29_ = function_row;
							gtk_list_box_append (_tmp28_, _tmp29_);
							_g_object_unref0 (function_row);
							_g_object_unref0 (function);
						}
					}
				}
				_g_object_unref0 (submenu_scrolled);
				_g_object_unref0 (category_row);
				_g_object_unref0 (submenu);
				function_category_destroy (&category);
			}
		}
	}
}

static void
__lambda28_ (MathFunctionPopover* self,
             MathFunction* f)
{
	g_return_if_fail (f != NULL);
	math_popover_item_added_cb ((MathPopover*) self, G_TYPE_CHECK_INSTANCE_TYPE (f, TYPE_MATH_FUNCTION) ? ((MathFunction*) f) : NULL);
}

static void
___lambda28__function_manager_function_added (FunctionManager* _sender,
                                              MathFunction* function,
                                              gpointer self)
{
	__lambda28_ ((MathFunctionPopover*) self, function);
}

static void
__lambda29_ (MathFunctionPopover* self,
             MathFunction* f)
{
	g_return_if_fail (f != NULL);
	math_popover_item_edited_cb ((MathPopover*) self, G_TYPE_CHECK_INSTANCE_TYPE (f, TYPE_MATH_FUNCTION) ? ((MathFunction*) f) : NULL);
}

static void
___lambda29__function_manager_function_edited (FunctionManager* _sender,
                                               MathFunction* new_function,
                                               gpointer self)
{
	__lambda29_ ((MathFunctionPopover*) self, new_function);
}

static void
__lambda30_ (MathFunctionPopover* self,
             MathFunction* f)
{
	g_return_if_fail (f != NULL);
	math_popover_item_deleted_cb ((MathPopover*) self, G_TYPE_CHECK_INSTANCE_TYPE (f, TYPE_MATH_FUNCTION) ? ((MathFunction*) f) : NULL);
}

static void
___lambda30__function_manager_function_deleted (FunctionManager* _sender,
                                                MathFunction* function,
                                                gpointer self)
{
	__lambda30_ ((MathFunctionPopover*) self, function);
}

static void
__lambda31_ (MathFunctionPopover* self)
{
	GtkSeparator* _tmp0_;
	GtkListBox* _tmp1_;
	GListStore* _tmp2_;
	_tmp0_ = self->priv->separator;
	_tmp1_ = self->priv->custom_list;
	_tmp2_ = ((MathPopover*) self)->model;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, g_list_model_get_n_items ((GListModel*) _tmp2_) != ((guint) 0));
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, g_list_model_get_n_items ((GListModel*) _tmp2_) != ((guint) 0));
}

static void
___lambda31__g_list_model_items_changed (GListModel* _sender,
                                         guint position,
                                         guint removed,
                                         guint added,
                                         gpointer self)
{
	__lambda31_ ((MathFunctionPopover*) self);
}

static void
math_function_popover_load_custom_functions (MathFunctionPopover* self)
{
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp0_;
	gchar** names = NULL;
	FunctionManager* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint names_length1;
	gint _names_size_;
	FunctionManager* _tmp14_;
	FunctionManager* _tmp15_;
	FunctionManager* _tmp16_;
	GListStore* _tmp17_;
	GtkSeparator* _tmp18_;
	GtkListBox* _tmp19_;
	GListStore* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = function_manager_get_default_function_manager ();
	function_manager = _tmp0_;
	_tmp1_ = function_manager;
	_tmp3_ = function_manager_get_names (_tmp1_, &_tmp2_);
	names = _tmp3_;
	names_length1 = _tmp2_;
	_names_size_ = names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar** _tmp6_;
				gint _tmp6__length1;
				const gchar* _tmp7_;
				MathFunction* function = NULL;
				FunctionManager* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				MathFunction* _tmp11_;
				MathFunction* _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = names;
				_tmp6__length1 = names_length1;
				_tmp7_ = _tmp6_[i];
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = function_manager;
				_tmp9_ = names;
				_tmp9__length1 = names_length1;
				_tmp10_ = _tmp9_[i];
				_tmp11_ = function_manager_get (_tmp8_, _tmp10_);
				function = _tmp11_;
				_tmp12_ = function;
				if (math_function_is_custom_function (_tmp12_)) {
					MathFunction* _tmp13_;
					_tmp13_ = function;
					math_popover_item_added_cb ((MathPopover*) self, _tmp13_);
				}
				_g_object_unref0 (function);
			}
		}
	}
	_tmp14_ = function_manager;
	g_signal_connect_object (_tmp14_, "function-added", (GCallback) ___lambda28__function_manager_function_added, self, 0);
	_tmp15_ = function_manager;
	g_signal_connect_object (_tmp15_, "function-edited", (GCallback) ___lambda29__function_manager_function_edited, self, 0);
	_tmp16_ = function_manager;
	g_signal_connect_object (_tmp16_, "function-deleted", (GCallback) ___lambda30__function_manager_function_deleted, self, 0);
	_tmp17_ = ((MathPopover*) self)->model;
	g_signal_connect_object ((GListModel*) _tmp17_, "items-changed", (GCallback) ___lambda31__g_list_model_items_changed, self, 0);
	_tmp18_ = self->priv->separator;
	_tmp19_ = self->priv->custom_list;
	_tmp20_ = ((MathPopover*) self)->model;
	gtk_widget_set_visible ((GtkWidget*) _tmp19_, g_list_model_get_n_items ((GListModel*) _tmp20_) != ((guint) 0));
	gtk_widget_set_visible ((GtkWidget*) _tmp18_, g_list_model_get_n_items ((GListModel*) _tmp20_) != ((guint) 0));
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (function_manager);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
math_function_popover_function_edited_cb (MathFunctionPopover* self,
                                          MathFunction* function)
{
	gchar* function_to_edit = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	MathEquation* _tmp13_;
	MathEquation* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (function != NULL);
	_tmp0_ = math_function_get_name (function);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_function_get_arguments (function, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	_tmp5_ = _vala_g_strjoinv (";", _tmp4_, (gint) _tmp4__length1);
	_tmp6_ = _tmp5_;
	_tmp7_ = math_function_get_expression (function);
	_tmp8_ = _tmp7_;
	_tmp9_ = math_function_get_description (function);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%s(%s)=%s@%s", _tmp1_, _tmp6_, _tmp8_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp6_);
	function_to_edit = _tmp12_;
	_tmp13_ = ((MathPopover*) self)->equation;
	math_equation_clear (_tmp13_);
	_tmp14_ = ((MathPopover*) self)->equation;
	math_equation_insert (_tmp14_, function_to_edit);
	math_popover_close_popover ((MathPopover*) self);
	_g_free0 (function_to_edit);
}

static void
math_function_popover_function_deleted_cb (MathFunctionPopover* self,
                                           MathFunction* function)
{
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (function != NULL);
	_tmp0_ = function_manager_get_default_function_manager ();
	function_manager = _tmp0_;
	_tmp1_ = math_function_get_name (function);
	_tmp2_ = _tmp1_;
	function_manager_delete (function_manager, _tmp2_);
	_g_object_unref0 (function_manager);
}

static void
math_function_popover_open_submenu_cb (MathFunctionPopover* self,
                                       GtkListBoxRow* row)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkStack* _tmp2_;
	GtkSelectionModel* _tmp3_;
	GtkSelectionModel* _tmp4_;
	GtkSelectionModel* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = math_popover_get_name_entry ((MathPopover*) self);
	_tmp1_ = _tmp0_;
	gtk_editable_set_text ((GtkEditable*) _tmp1_, "");
	_tmp2_ = self->priv->stack;
	_tmp3_ = gtk_stack_get_pages (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_selection_model_select_item (_tmp5_, (guint) (gtk_list_box_row_get_index (row) + 1), TRUE);
	_g_object_unref0 (_tmp5_);
}

static void
_math_function_popover_open_submenu_cb_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self)
{
	math_function_popover_open_submenu_cb ((MathFunctionPopover*) self, row);
}

static void
math_function_popover_insert_function_cb (MathFunctionPopover* self,
                                          GtkListBoxRow* row)
{
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkStack* _tmp3_;
	GtkWidget* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->stack;
	_tmp4_ = gtk_widget_get_first_child ((GtkWidget*) _tmp3_);
	if (_tmp2_ == _tmp4_) {
		MathFunction* function = NULL;
		GListStore* _tmp5_;
		GObject* _tmp6_;
		MathFunction* _tmp7_;
		MathEquation* _tmp8_;
		MathFunction* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp5_ = ((MathPopover*) self)->model;
		_tmp6_ = g_list_model_get_item ((GListModel*) _tmp5_, (guint) gtk_list_box_row_get_index (row));
		_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_MATH_FUNCTION) ? ((MathFunction*) _tmp6_) : NULL;
		if (_tmp7_ == NULL) {
			_g_object_unref0 (_tmp6_);
		}
		function = _tmp7_;
		_tmp8_ = ((MathPopover*) self)->equation;
		_tmp9_ = function;
		_tmp10_ = math_function_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		math_equation_insert_function (_tmp8_, _tmp11_, TRUE);
		math_popover_close_popover ((MathPopover*) self);
		_g_object_unref0 (function);
	} else {
		if (gtk_list_box_row_get_index (row) == 0) {
			GtkStack* _tmp12_;
			GtkSelectionModel* _tmp13_;
			GtkSelectionModel* _tmp14_;
			GtkSelectionModel* _tmp15_;
			_tmp12_ = self->priv->stack;
			_tmp13_ = gtk_stack_get_pages (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_;
			gtk_selection_model_select_item (_tmp15_, (guint) 0, TRUE);
			_g_object_unref0 (_tmp15_);
		} else {
			MathEquation* _tmp16_;
			GtkWidget* _tmp17_;
			GtkWidget* _tmp18_;
			gconstpointer _tmp19_;
			_tmp16_ = ((MathPopover*) self)->equation;
			_tmp17_ = gtk_list_box_row_get_child (row);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_object_get_data ((GObject*) _tmp18_, "name");
			math_equation_insert_function (_tmp16_, (const gchar*) _tmp19_, TRUE);
			math_popover_close_popover ((MathPopover*) self);
		}
	}
}

static void
math_function_popover_add_function_cb (MathFunctionPopover* self,
                                       GtkWidget* widget)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* name = NULL;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gint arguments = 0;
	GtkSpinButton* _tmp9_;
	gchar* formatted_args = NULL;
	gchar* _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	MathEquation* _tmp18_;
	MathEquation* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = math_popover_get_add_button ((MathPopover*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = math_popover_get_name_entry ((MathPopover*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_editable_get_text ((GtkEditable*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	name = _tmp8_;
	_tmp9_ = self->priv->add_arguments_button;
	arguments = gtk_spin_button_get_value_as_int (_tmp9_);
	_tmp10_ = g_strdup ("");
	formatted_args = _tmp10_;
	if (arguments > 0) {
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		_tmp11_ = math_function_popover_FUNCTION_ARGS;
		_tmp11__length1 = math_function_popover_FUNCTION_ARGS_length1;
		_tmp12_ = _vala_g_strjoinv ("; ", _tmp11_ + 0, (gint) (arguments - 0));
		_g_free0 (formatted_args);
		formatted_args = _tmp12_;
	}
	_tmp13_ = name;
	_tmp14_ = formatted_args;
	_tmp15_ = g_strdup_printf ("(%s)=", _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
	_g_free0 (name);
	name = _tmp17_;
	_g_free0 (_tmp16_);
	_tmp18_ = ((MathPopover*) self)->equation;
	math_equation_clear (_tmp18_);
	_tmp19_ = ((MathPopover*) self)->equation;
	_tmp20_ = name;
	math_equation_insert (_tmp19_, _tmp20_);
	math_popover_close_popover ((MathPopover*) self);
	_g_free0 (formatted_args);
	_g_free0 (name);
}

static void
_math_function_popover_add_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	math_function_popover_add_function_cb ((MathFunctionPopover*) self, _sender);
}

static gboolean
math_function_popover_real_is_deletable (MathPopover* base,
                                         MathFunction* function)
{
	MathFunctionPopover * self;
	gboolean result;
	self = (MathFunctionPopover*) base;
	g_return_val_if_fail (function != NULL, FALSE);
	result = math_function_is_custom_function (function);
	return result;
}

static gboolean
math_function_popover_real_is_editable (MathPopover* base,
                                        MathFunction* function)
{
	MathFunctionPopover * self;
	gboolean result;
	self = (MathFunctionPopover*) base;
	g_return_val_if_fail (function != NULL, FALSE);
	result = math_function_is_custom_function (function);
	return result;
}

static gchar*
math_function_popover_real_get_item_text (MathPopover* base,
                                          MathFunction* function)
{
	MathFunctionPopover * self;
	gchar* expression = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	self = (MathFunctionPopover*) base;
	g_return_val_if_fail (function != NULL, NULL);
	_tmp0_ = math_function_get_arguments (function, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	_tmp3_ = _vala_g_strjoinv (";", _tmp2_, (gint) _tmp2__length1);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("(%s)", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	expression = _tmp6_;
	_tmp7_ = math_function_get_name (function);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("<b>%s</b>%s", _tmp8_, expression);
	result = _tmp9_;
	_g_free0 (expression);
	return result;
}

static gboolean
__lambda32_ (GObject* a,
             GObject* b)
{
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = math_function_name_equal_func (G_TYPE_CHECK_INSTANCE_TYPE (a, TYPE_MATH_FUNCTION) ? ((MathFunction*) a) : NULL, G_TYPE_CHECK_INSTANCE_TYPE (b, TYPE_MATH_FUNCTION) ? ((MathFunction*) b) : NULL);
	return result;
}

static gboolean
___lambda32__gequal_func (gconstpointer a,
                          gconstpointer b)
{
	gboolean result;
	result = __lambda32_ ((GObject*) a, (GObject*) b);
	return result;
}

static gint
math_function_popover_real_get_item_index (MathPopover* base,
                                           MathFunction* item)
{
	MathFunctionPopover * self;
	guint position = 0U;
	GListStore* _tmp0_;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	gint result;
	self = (MathFunctionPopover*) base;
	g_return_val_if_fail (item != NULL, 0);
	_tmp0_ = ((MathPopover*) self)->model;
	_tmp2_ = g_list_store_find_with_equal_func (_tmp0_, G_TYPE_CHECK_INSTANCE_TYPE (item, G_TYPE_OBJECT) ? ((GObject*) item) : NULL, ___lambda32__gequal_func, &_tmp1_);
	position = _tmp1_;
	if (_tmp2_) {
		result = (gint) position;
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gchar*
math_function_popover_real_validate_name (MathPopover* base,
                                          const gchar* name)
{
	MathFunctionPopover * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp5_;
	MathFunction* function = NULL;
	FunctionManager* _tmp13_;
	FunctionManager* _tmp14_;
	MathFunction* _tmp15_;
	MathFunction* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	MathFunction* _tmp19_;
	gchar* result;
	self = (MathFunctionPopover*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp2_ = g_utf8_strdown (name, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_popover_RESERVED_VARIABLE_NAMES;
	_tmp4__length1 = math_popover_RESERVED_VARIABLE_NAMES_length1;
	_tmp5_ = _vala_string_array_contains (_tmp4_, _tmp4__length1, _tmp3_);
	_g_free0 (_tmp3_);
	if (_tmp5_) {
		_tmp1_ = TRUE;
	} else {
		GHashTable* _tmp6_;
		_tmp6_ = parser_CONSTANTS;
		_tmp1_ = g_hash_table_contains (_tmp6_, name);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		MathEquation* _tmp7_;
		MathVariables* _tmp8_;
		MathVariables* _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp7_ = ((MathPopover*) self)->equation;
		_tmp8_ = math_equation_get_variables (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = math_variables_get (_tmp9_, name);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_ != NULL;
		_g_object_unref0 (_tmp11_);
	}
	if (_tmp0_) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup (_ ("Can not use defined variable or constant names"));
		result = _tmp12_;
		return result;
	}
	_tmp13_ = function_manager_get_default_function_manager ();
	_tmp14_ = _tmp13_;
	_tmp15_ = function_manager_get (_tmp14_, name);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp14_);
	function = _tmp16_;
	_tmp19_ = function;
	if (_tmp19_ != NULL) {
		MathFunction* _tmp20_;
		_tmp20_ = function;
		_tmp18_ = !math_function_is_custom_function (_tmp20_);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		_tmp21_ = g_utf8_strdown (name, (gssize) -1);
		_tmp22_ = _tmp21_;
		_tmp23_ = math_popover_OPERATORS;
		_tmp23__length1 = math_popover_OPERATORS_length1;
		_tmp17_ = _vala_string_array_contains (_tmp23_, _tmp23__length1, _tmp22_);
		_g_free0 (_tmp22_);
	}
	if (_tmp17_) {
		gchar* _tmp24_;
		_tmp24_ = g_strdup (_ ("Can not use built-in function or operator names"));
		result = _tmp24_;
		_g_object_unref0 (function);
		return result;
	}
	if (!g_regex_match_simple ("^\\D", name, 0, 0)) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup (_ ("Function name can not start with a digit"));
		result = _tmp25_;
		_g_object_unref0 (function);
		return result;
	}
	if (!g_regex_match_simple ("^\\w*$", name, 0, 0)) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup (_ ("Function name can only contain digits, letters and underscores"));
		result = _tmp26_;
		_g_object_unref0 (function);
		return result;
	}
	result = NULL;
	_g_object_unref0 (function);
	return result;
}

static GtkEntry*
math_function_popover_real_get_name_entry (MathPopover* base)
{
	GtkEntry* result;
	MathFunctionPopover* self;
	GtkEntry* _tmp0_;
	self = (MathFunctionPopover*) base;
	_tmp0_ = self->priv->_name_entry;
	result = _tmp0_;
	return result;
}

static GtkButton*
math_function_popover_real_get_add_button (MathPopover* base)
{
	GtkButton* result;
	MathFunctionPopover* self;
	GtkButton* _tmp0_;
	self = (MathFunctionPopover*) base;
	_tmp0_ = self->priv->_add_button;
	result = _tmp0_;
	return result;
}

static GtkLabel*
math_function_popover_real_get_error_label (MathPopover* base)
{
	GtkLabel* result;
	MathFunctionPopover* self;
	GtkLabel* _tmp0_;
	self = (MathFunctionPopover*) base;
	_tmp0_ = self->priv->_error_label;
	result = _tmp0_;
	return result;
}

static void
math_function_popover_class_init (MathFunctionPopoverClass * klass,
                                  gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	math_function_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathFunctionPopover_private_offset);
	((MathPopoverClass *) klass)->is_deletable = (gboolean (*) (MathPopover*, gconstpointer)) math_function_popover_real_is_deletable;
	((MathPopoverClass *) klass)->is_editable = (gboolean (*) (MathPopover*, gconstpointer)) math_function_popover_real_is_editable;
	((MathPopoverClass *) klass)->get_item_text = (gchar* (*) (MathPopover*, gconstpointer)) math_function_popover_real_get_item_text;
	((MathPopoverClass *) klass)->get_item_index = (gint (*) (MathPopover*, gconstpointer)) math_function_popover_real_get_item_index;
	((MathPopoverClass *) klass)->validate_name = (gchar* (*) (MathPopover*, const gchar*)) math_function_popover_real_validate_name;
	MATH_POPOVER_CLASS (klass)->get_name_entry = (GtkEntry* (*) (MathPopover*)) math_function_popover_real_get_name_entry;
	MATH_POPOVER_CLASS (klass)->get_add_button = (GtkButton* (*) (MathPopover*)) math_function_popover_real_get_add_button;
	MATH_POPOVER_CLASS (klass)->get_error_label = (GtkLabel* (*) (MathPopover*)) math_function_popover_real_get_error_label;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_function_popover_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_function_popover_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-function-popover.ui");
	_tmp0_ = g_strdup ("x");
	_tmp1_ = g_strdup ("y");
	_tmp2_ = g_strdup ("z");
	_tmp3_ = g_strdup ("u");
	_tmp4_ = g_strdup ("v");
	_tmp5_ = g_strdup ("w");
	_tmp6_ = g_strdup ("a");
	_tmp7_ = g_strdup ("b");
	_tmp8_ = g_strdup ("c");
	_tmp9_ = g_strdup ("d");
	_tmp10_ = g_new0 (gchar*, 10 + 1);
	_tmp10_[0] = _tmp0_;
	_tmp10_[1] = _tmp1_;
	_tmp10_[2] = _tmp2_;
	_tmp10_[3] = _tmp3_;
	_tmp10_[4] = _tmp4_;
	_tmp10_[5] = _tmp5_;
	_tmp10_[6] = _tmp6_;
	_tmp10_[7] = _tmp7_;
	_tmp10_[8] = _tmp8_;
	_tmp10_[9] = _tmp9_;
	math_function_popover_FUNCTION_ARGS = _tmp10_;
	math_function_popover_FUNCTION_ARGS_length1 = 10;
	_math_function_popover_FUNCTION_ARGS_size_ = math_function_popover_FUNCTION_ARGS_length1;
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "built_in_list", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, built_in_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "separator", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, separator));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_list", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, custom_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_arguments_button", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, add_arguments_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_entry", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, _name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_button", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, _add_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, MathFunctionPopover_private_offset + G_STRUCT_OFFSET (MathFunctionPopoverPrivate, _error_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "open_submenu_cb", G_CALLBACK(_math_function_popover_open_submenu_cb_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "insert_function_cb", G_CALLBACK(_math_function_popover_insert_function_cb_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "add_function_cb", G_CALLBACK(_math_function_popover_add_function_cb_gtk_button_clicked));
}

static void
math_function_popover_instance_init (MathFunctionPopover * self,
                                     gpointer klass)
{
	self->priv = math_function_popover_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
math_function_popover_finalize (GObject * obj)
{
	MathFunctionPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopover);
	G_OBJECT_CLASS (math_function_popover_parent_class)->finalize (obj);
}

static GType
math_function_popover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathFunctionPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_function_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathFunctionPopover), 0, (GInstanceInitFunc) math_function_popover_instance_init, NULL };
	GType math_function_popover_type_id;
	math_function_popover_type_id = g_type_register_static (TYPE_MATH_POPOVER, "MathFunctionPopover", &g_define_type_info, 0);
	MathFunctionPopover_private_offset = g_type_add_instance_private (math_function_popover_type_id, sizeof (MathFunctionPopoverPrivate));
	return math_function_popover_type_id;
}

GType
math_function_popover_get_type (void)
{
	static volatile gsize math_function_popover_type_id__once = 0;
	if (g_once_init_enter (&math_function_popover_type_id__once)) {
		GType math_function_popover_type_id;
		math_function_popover_type_id = math_function_popover_get_type_once ();
		g_once_init_leave (&math_function_popover_type_id__once, math_function_popover_type_id);
	}
	return math_function_popover_type_id__once;
}

static void
_vala_math_function_popover_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	MathFunctionPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopover);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

