// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_transform
//
// (impl) generated by codegen/vulkan/vulkan-docs/scripts/genvk.py -registry
// codegen/vulkan/vulkan-docs/xml/vk.xml -registryGfxstream
// codegen/vulkan/vulkan-docs/xml/vk_gfxstream.xml cereal -o host/vulkan/cereal
//
// Please do not modify directly;
// re-run gfxstream-protocols/scripts/generate-vulkan-sources.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o
// $CEREAL_OUTPUT_DIR
//

#include "goldfish_vk_transform.h"

#include "VkDecoderGlobalState.h"

namespace gfxstream {
namespace vk {

void transform_tohost_extension_struct(VkDecoderGlobalState* resourceTracker,
                                       void* structExtension_out);

void transform_fromhost_extension_struct(VkDecoderGlobalState* resourceTracker,
                                         void* structExtension_out);

#ifdef VK_VERSION_1_0
void transform_tohost_VkExtent2D(VkDecoderGlobalState* resourceTracker, VkExtent2D* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkExtent2D(VkDecoderGlobalState* resourceTracker, VkExtent2D* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkExtent3D(VkDecoderGlobalState* resourceTracker, VkExtent3D* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkExtent3D(VkDecoderGlobalState* resourceTracker, VkExtent3D* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkOffset2D(VkDecoderGlobalState* resourceTracker, VkOffset2D* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkOffset2D(VkDecoderGlobalState* resourceTracker, VkOffset2D* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkOffset3D(VkDecoderGlobalState* resourceTracker, VkOffset3D* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkOffset3D(VkDecoderGlobalState* resourceTracker, VkOffset3D* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkRect2D(VkDecoderGlobalState* resourceTracker, VkRect2D* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkOffset2D(resourceTracker, (VkOffset2D*)(&toTransform->offset));
    transform_tohost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->extent));
}

void transform_fromhost_VkRect2D(VkDecoderGlobalState* resourceTracker, VkRect2D* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkOffset2D(resourceTracker, (VkOffset2D*)(&toTransform->offset));
    transform_fromhost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->extent));
}

void transform_tohost_VkBaseInStructure(VkDecoderGlobalState* resourceTracker,
                                        VkBaseInStructure* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBaseInStructure(VkDecoderGlobalState* resourceTracker,
                                          VkBaseInStructure* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBaseOutStructure(VkDecoderGlobalState* resourceTracker,
                                         VkBaseOutStructure* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBaseOutStructure(VkDecoderGlobalState* resourceTracker,
                                           VkBaseOutStructure* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferMemoryBarrier(VkDecoderGlobalState* resourceTracker,
                                            VkBufferMemoryBarrier* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferMemoryBarrier(VkDecoderGlobalState* resourceTracker,
                                              VkBufferMemoryBarrier* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDispatchIndirectCommand(VkDecoderGlobalState* resourceTracker,
                                                VkDispatchIndirectCommand* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDispatchIndirectCommand(VkDecoderGlobalState* resourceTracker,
                                                  VkDispatchIndirectCommand* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDrawIndexedIndirectCommand(VkDecoderGlobalState* resourceTracker,
                                                   VkDrawIndexedIndirectCommand* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDrawIndexedIndirectCommand(VkDecoderGlobalState* resourceTracker,
                                                     VkDrawIndexedIndirectCommand* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDrawIndirectCommand(VkDecoderGlobalState* resourceTracker,
                                            VkDrawIndirectCommand* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDrawIndirectCommand(VkDecoderGlobalState* resourceTracker,
                                              VkDrawIndirectCommand* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkImageSubresourceRange(VkDecoderGlobalState* resourceTracker,
                                              VkImageSubresourceRange* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkImageSubresourceRange(VkDecoderGlobalState* resourceTracker,
                                                VkImageSubresourceRange* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkImageMemoryBarrier(VkDecoderGlobalState* resourceTracker,
                                           VkImageMemoryBarrier* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceRange(
        resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_fromhost_VkImageMemoryBarrier(VkDecoderGlobalState* resourceTracker,
                                             VkImageMemoryBarrier* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceRange(
        resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_tohost_VkMemoryBarrier(VkDecoderGlobalState* resourceTracker,
                                      VkMemoryBarrier* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryBarrier(VkDecoderGlobalState* resourceTracker,
                                        VkMemoryBarrier* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineCacheHeaderVersionOne(
    VkDecoderGlobalState* resourceTracker, VkPipelineCacheHeaderVersionOne* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPipelineCacheHeaderVersionOne(
    VkDecoderGlobalState* resourceTracker, VkPipelineCacheHeaderVersionOne* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkAllocationCallbacks(VkDecoderGlobalState* resourceTracker,
                                            VkAllocationCallbacks* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkAllocationCallbacks(VkDecoderGlobalState* resourceTracker,
                                              VkAllocationCallbacks* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkApplicationInfo(VkDecoderGlobalState* resourceTracker,
                                        VkApplicationInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkApplicationInfo(VkDecoderGlobalState* resourceTracker,
                                          VkApplicationInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkFormatProperties(VkDecoderGlobalState* resourceTracker,
                                         VkFormatProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkFormatProperties(VkDecoderGlobalState* resourceTracker,
                                           VkFormatProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkImageFormatProperties(VkDecoderGlobalState* resourceTracker,
                                              VkImageFormatProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->maxExtent));
}

void transform_fromhost_VkImageFormatProperties(VkDecoderGlobalState* resourceTracker,
                                                VkImageFormatProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->maxExtent));
}

void transform_tohost_VkInstanceCreateInfo(VkDecoderGlobalState* resourceTracker,
                                           VkInstanceCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pApplicationInfo) {
        transform_tohost_VkApplicationInfo(resourceTracker,
                                           (VkApplicationInfo*)(toTransform->pApplicationInfo));
    }
}

void transform_fromhost_VkInstanceCreateInfo(VkDecoderGlobalState* resourceTracker,
                                             VkInstanceCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pApplicationInfo) {
        transform_fromhost_VkApplicationInfo(resourceTracker,
                                             (VkApplicationInfo*)(toTransform->pApplicationInfo));
    }
}

void transform_tohost_VkMemoryHeap(VkDecoderGlobalState* resourceTracker,
                                   VkMemoryHeap* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkMemoryHeap(VkDecoderGlobalState* resourceTracker,
                                     VkMemoryHeap* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkMemoryType(VkDecoderGlobalState* resourceTracker,
                                   VkMemoryType* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkMemoryType(VkDecoderGlobalState* resourceTracker,
                                     VkMemoryType* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceFeatures(VkDecoderGlobalState* resourceTracker,
                                               VkPhysicalDeviceFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPhysicalDeviceFeatures(VkDecoderGlobalState* resourceTracker,
                                                 VkPhysicalDeviceFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceLimits(VkDecoderGlobalState* resourceTracker,
                                             VkPhysicalDeviceLimits* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPhysicalDeviceLimits(VkDecoderGlobalState* resourceTracker,
                                               VkPhysicalDeviceLimits* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceMemoryProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMemoryProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_TYPES; ++i) {
        transform_tohost_VkMemoryType(resourceTracker,
                                      (VkMemoryType*)(toTransform->memoryTypes + i));
    }
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_HEAPS; ++i) {
        transform_tohost_VkMemoryHeap(resourceTracker,
                                      (VkMemoryHeap*)(toTransform->memoryHeaps + i));
    }
}

void transform_fromhost_VkPhysicalDeviceMemoryProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMemoryProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_TYPES; ++i) {
        transform_fromhost_VkMemoryType(resourceTracker,
                                        (VkMemoryType*)(toTransform->memoryTypes + i));
    }
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_HEAPS; ++i) {
        transform_fromhost_VkMemoryHeap(resourceTracker,
                                        (VkMemoryHeap*)(toTransform->memoryHeaps + i));
    }
}

void transform_tohost_VkPhysicalDeviceSparseProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceSparseProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPhysicalDeviceSparseProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceSparseProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceProperties(VkDecoderGlobalState* resourceTracker,
                                                 VkPhysicalDeviceProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkPhysicalDeviceLimits(resourceTracker,
                                            (VkPhysicalDeviceLimits*)(&toTransform->limits));
    transform_tohost_VkPhysicalDeviceSparseProperties(
        resourceTracker, (VkPhysicalDeviceSparseProperties*)(&toTransform->sparseProperties));
}

void transform_fromhost_VkPhysicalDeviceProperties(VkDecoderGlobalState* resourceTracker,
                                                   VkPhysicalDeviceProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkPhysicalDeviceLimits(resourceTracker,
                                              (VkPhysicalDeviceLimits*)(&toTransform->limits));
    transform_fromhost_VkPhysicalDeviceSparseProperties(
        resourceTracker, (VkPhysicalDeviceSparseProperties*)(&toTransform->sparseProperties));
}

void transform_tohost_VkQueueFamilyProperties(VkDecoderGlobalState* resourceTracker,
                                              VkQueueFamilyProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkExtent3D(resourceTracker,
                                (VkExtent3D*)(&toTransform->minImageTransferGranularity));
}

void transform_fromhost_VkQueueFamilyProperties(VkDecoderGlobalState* resourceTracker,
                                                VkQueueFamilyProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkExtent3D(resourceTracker,
                                  (VkExtent3D*)(&toTransform->minImageTransferGranularity));
}

void transform_tohost_VkDeviceQueueCreateInfo(VkDecoderGlobalState* resourceTracker,
                                              VkDeviceQueueCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceQueueCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                VkDeviceQueueCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceCreateInfo(VkDecoderGlobalState* resourceTracker,
                                         VkDeviceCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pQueueCreateInfos) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->queueCreateInfoCount; ++i) {
                transform_tohost_VkDeviceQueueCreateInfo(
                    resourceTracker,
                    (VkDeviceQueueCreateInfo*)(toTransform->pQueueCreateInfos + i));
            }
        }
    }
    if (toTransform->pEnabledFeatures) {
        transform_tohost_VkPhysicalDeviceFeatures(
            resourceTracker, (VkPhysicalDeviceFeatures*)(toTransform->pEnabledFeatures));
    }
}

void transform_fromhost_VkDeviceCreateInfo(VkDecoderGlobalState* resourceTracker,
                                           VkDeviceCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pQueueCreateInfos) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->queueCreateInfoCount; ++i) {
                transform_fromhost_VkDeviceQueueCreateInfo(
                    resourceTracker,
                    (VkDeviceQueueCreateInfo*)(toTransform->pQueueCreateInfos + i));
            }
        }
    }
    if (toTransform->pEnabledFeatures) {
        transform_fromhost_VkPhysicalDeviceFeatures(
            resourceTracker, (VkPhysicalDeviceFeatures*)(toTransform->pEnabledFeatures));
    }
}

void transform_tohost_VkExtensionProperties(VkDecoderGlobalState* resourceTracker,
                                            VkExtensionProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkExtensionProperties(VkDecoderGlobalState* resourceTracker,
                                              VkExtensionProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkLayerProperties(VkDecoderGlobalState* resourceTracker,
                                        VkLayerProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkLayerProperties(VkDecoderGlobalState* resourceTracker,
                                          VkLayerProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                   VkSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                     VkSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMappedMemoryRange(VkDecoderGlobalState* resourceTracker,
                                          VkMappedMemoryRange* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->offset, 1,
        (VkDeviceSize*)&toTransform->size, 1, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMappedMemoryRange(VkDecoderGlobalState* resourceTracker,
                                            VkMappedMemoryRange* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->offset, 1,
        (VkDeviceSize*)&toTransform->size, 1, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryAllocateInfo(VkDecoderGlobalState* resourceTracker,
                                           VkMemoryAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost(
        (VkDeviceMemory*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr, 0,
        (uint32_t*)&toTransform->memoryTypeIndex, 1, (uint32_t*)nullptr, 0);
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryAllocateInfo(VkDecoderGlobalState* resourceTracker,
                                             VkMemoryAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost(
        (VkDeviceMemory*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr, 0,
        (uint32_t*)&toTransform->memoryTypeIndex, 1, (uint32_t*)nullptr, 0);
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryRequirements(VkDecoderGlobalState* resourceTracker,
                                           VkMemoryRequirements* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost(
        (VkDeviceMemory*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr, 0,
        (uint32_t*)nullptr, 0, (uint32_t*)&toTransform->memoryTypeBits, 1);
}

void transform_fromhost_VkMemoryRequirements(VkDecoderGlobalState* resourceTracker,
                                             VkMemoryRequirements* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost(
        (VkDeviceMemory*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr, 0,
        (uint32_t*)nullptr, 0, (uint32_t*)&toTransform->memoryTypeBits, 1);
}

void transform_tohost_VkSparseMemoryBind(VkDecoderGlobalState* resourceTracker,
                                         VkSparseMemoryBind* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1,
        (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
}

void transform_fromhost_VkSparseMemoryBind(VkDecoderGlobalState* resourceTracker,
                                           VkSparseMemoryBind* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1,
        (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
}

void transform_tohost_VkSparseBufferMemoryBindInfo(VkDecoderGlobalState* resourceTracker,
                                                   VkSparseBufferMemoryBindInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i) {
                transform_tohost_VkSparseMemoryBind(resourceTracker,
                                                    (VkSparseMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_fromhost_VkSparseBufferMemoryBindInfo(VkDecoderGlobalState* resourceTracker,
                                                     VkSparseBufferMemoryBindInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i) {
                transform_fromhost_VkSparseMemoryBind(
                    resourceTracker, (VkSparseMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_tohost_VkSparseImageOpaqueMemoryBindInfo(
    VkDecoderGlobalState* resourceTracker, VkSparseImageOpaqueMemoryBindInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i) {
                transform_tohost_VkSparseMemoryBind(resourceTracker,
                                                    (VkSparseMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_fromhost_VkSparseImageOpaqueMemoryBindInfo(
    VkDecoderGlobalState* resourceTracker, VkSparseImageOpaqueMemoryBindInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i) {
                transform_fromhost_VkSparseMemoryBind(
                    resourceTracker, (VkSparseMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_tohost_VkImageSubresource(VkDecoderGlobalState* resourceTracker,
                                         VkImageSubresource* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkImageSubresource(VkDecoderGlobalState* resourceTracker,
                                           VkImageSubresource* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkSparseImageMemoryBind(VkDecoderGlobalState* resourceTracker,
                                              VkSparseImageMemoryBind* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1,
        (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    transform_tohost_VkImageSubresource(resourceTracker,
                                        (VkImageSubresource*)(&toTransform->subresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->offset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkSparseImageMemoryBind(VkDecoderGlobalState* resourceTracker,
                                                VkSparseImageMemoryBind* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1,
        (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    transform_fromhost_VkImageSubresource(resourceTracker,
                                          (VkImageSubresource*)(&toTransform->subresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->offset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkSparseImageMemoryBindInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkSparseImageMemoryBindInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i) {
                transform_tohost_VkSparseImageMemoryBind(
                    resourceTracker, (VkSparseImageMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_fromhost_VkSparseImageMemoryBindInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkSparseImageMemoryBindInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i) {
                transform_fromhost_VkSparseImageMemoryBind(
                    resourceTracker, (VkSparseImageMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_tohost_VkBindSparseInfo(VkDecoderGlobalState* resourceTracker,
                                       VkBindSparseInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pBufferBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bufferBindCount; ++i) {
                transform_tohost_VkSparseBufferMemoryBindInfo(
                    resourceTracker,
                    (VkSparseBufferMemoryBindInfo*)(toTransform->pBufferBinds + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pImageOpaqueBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageOpaqueBindCount; ++i) {
                transform_tohost_VkSparseImageOpaqueMemoryBindInfo(
                    resourceTracker,
                    (VkSparseImageOpaqueMemoryBindInfo*)(toTransform->pImageOpaqueBinds + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pImageBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageBindCount; ++i) {
                transform_tohost_VkSparseImageMemoryBindInfo(
                    resourceTracker, (VkSparseImageMemoryBindInfo*)(toTransform->pImageBinds + i));
            }
        }
    }
}

void transform_fromhost_VkBindSparseInfo(VkDecoderGlobalState* resourceTracker,
                                         VkBindSparseInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pBufferBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bufferBindCount; ++i) {
                transform_fromhost_VkSparseBufferMemoryBindInfo(
                    resourceTracker,
                    (VkSparseBufferMemoryBindInfo*)(toTransform->pBufferBinds + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pImageOpaqueBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageOpaqueBindCount; ++i) {
                transform_fromhost_VkSparseImageOpaqueMemoryBindInfo(
                    resourceTracker,
                    (VkSparseImageOpaqueMemoryBindInfo*)(toTransform->pImageOpaqueBinds + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pImageBinds) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageBindCount; ++i) {
                transform_fromhost_VkSparseImageMemoryBindInfo(
                    resourceTracker, (VkSparseImageMemoryBindInfo*)(toTransform->pImageBinds + i));
            }
        }
    }
}

void transform_tohost_VkSparseImageFormatProperties(VkDecoderGlobalState* resourceTracker,
                                                    VkSparseImageFormatProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageGranularity));
}

void transform_fromhost_VkSparseImageFormatProperties(VkDecoderGlobalState* resourceTracker,
                                                      VkSparseImageFormatProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageGranularity));
}

void transform_tohost_VkSparseImageMemoryRequirements(
    VkDecoderGlobalState* resourceTracker, VkSparseImageMemoryRequirements* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkSparseImageFormatProperties(
        resourceTracker, (VkSparseImageFormatProperties*)(&toTransform->formatProperties));
}

void transform_fromhost_VkSparseImageMemoryRequirements(
    VkDecoderGlobalState* resourceTracker, VkSparseImageMemoryRequirements* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkSparseImageFormatProperties(
        resourceTracker, (VkSparseImageFormatProperties*)(&toTransform->formatProperties));
}

void transform_tohost_VkFenceCreateInfo(VkDecoderGlobalState* resourceTracker,
                                        VkFenceCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkFenceCreateInfo(VkDecoderGlobalState* resourceTracker,
                                          VkFenceCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSemaphoreCreateInfo(VkDecoderGlobalState* resourceTracker,
                                            VkSemaphoreCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreCreateInfo(VkDecoderGlobalState* resourceTracker,
                                              VkSemaphoreCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkEventCreateInfo(VkDecoderGlobalState* resourceTracker,
                                        VkEventCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkEventCreateInfo(VkDecoderGlobalState* resourceTracker,
                                          VkEventCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkQueryPoolCreateInfo(VkDecoderGlobalState* resourceTracker,
                                            VkQueryPoolCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkQueryPoolCreateInfo(VkDecoderGlobalState* resourceTracker,
                                              VkQueryPoolCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferCreateInfo(VkDecoderGlobalState* resourceTracker,
                                         VkBufferCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferCreateInfo(VkDecoderGlobalState* resourceTracker,
                                           VkBufferCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferViewCreateInfo(VkDecoderGlobalState* resourceTracker,
                                             VkBufferViewCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferViewCreateInfo(VkDecoderGlobalState* resourceTracker,
                                               VkBufferViewCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageCreateInfo(VkDecoderGlobalState* resourceTracker,
                                        VkImageCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkImageCreateInfo(VkDecoderGlobalState* resourceTracker,
                                          VkImageCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkSubresourceLayout(VkDecoderGlobalState* resourceTracker,
                                          VkSubresourceLayout* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkSubresourceLayout(VkDecoderGlobalState* resourceTracker,
                                            VkSubresourceLayout* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkComponentMapping(VkDecoderGlobalState* resourceTracker,
                                         VkComponentMapping* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkComponentMapping(VkDecoderGlobalState* resourceTracker,
                                           VkComponentMapping* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkImageViewCreateInfo(VkDecoderGlobalState* resourceTracker,
                                            VkImageViewCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkComponentMapping(resourceTracker,
                                        (VkComponentMapping*)(&toTransform->components));
    transform_tohost_VkImageSubresourceRange(
        resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_fromhost_VkImageViewCreateInfo(VkDecoderGlobalState* resourceTracker,
                                              VkImageViewCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkComponentMapping(resourceTracker,
                                          (VkComponentMapping*)(&toTransform->components));
    transform_fromhost_VkImageSubresourceRange(
        resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_tohost_VkShaderModuleCreateInfo(VkDecoderGlobalState* resourceTracker,
                                               VkShaderModuleCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkShaderModuleCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                 VkShaderModuleCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineCacheCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                VkPipelineCacheCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineCacheCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkPipelineCacheCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSpecializationMapEntry(VkDecoderGlobalState* resourceTracker,
                                               VkSpecializationMapEntry* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkSpecializationMapEntry(VkDecoderGlobalState* resourceTracker,
                                                 VkSpecializationMapEntry* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkSpecializationInfo(VkDecoderGlobalState* resourceTracker,
                                           VkSpecializationInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pMapEntries) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->mapEntryCount; ++i) {
                transform_tohost_VkSpecializationMapEntry(
                    resourceTracker, (VkSpecializationMapEntry*)(toTransform->pMapEntries + i));
            }
        }
    }
}

void transform_fromhost_VkSpecializationInfo(VkDecoderGlobalState* resourceTracker,
                                             VkSpecializationInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pMapEntries) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->mapEntryCount; ++i) {
                transform_fromhost_VkSpecializationMapEntry(
                    resourceTracker, (VkSpecializationMapEntry*)(toTransform->pMapEntries + i));
            }
        }
    }
}

void transform_tohost_VkPipelineShaderStageCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineShaderStageCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pSpecializationInfo) {
        transform_tohost_VkSpecializationInfo(
            resourceTracker, (VkSpecializationInfo*)(toTransform->pSpecializationInfo));
    }
}

void transform_fromhost_VkPipelineShaderStageCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineShaderStageCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pSpecializationInfo) {
        transform_fromhost_VkSpecializationInfo(
            resourceTracker, (VkSpecializationInfo*)(toTransform->pSpecializationInfo));
    }
}

void transform_tohost_VkComputePipelineCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkComputePipelineCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkPipelineShaderStageCreateInfo(
        resourceTracker, (VkPipelineShaderStageCreateInfo*)(&toTransform->stage));
}

void transform_fromhost_VkComputePipelineCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkComputePipelineCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkPipelineShaderStageCreateInfo(
        resourceTracker, (VkPipelineShaderStageCreateInfo*)(&toTransform->stage));
}

void transform_tohost_VkVertexInputBindingDescription(
    VkDecoderGlobalState* resourceTracker, VkVertexInputBindingDescription* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkVertexInputBindingDescription(
    VkDecoderGlobalState* resourceTracker, VkVertexInputBindingDescription* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkVertexInputAttributeDescription(
    VkDecoderGlobalState* resourceTracker, VkVertexInputAttributeDescription* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkVertexInputAttributeDescription(
    VkDecoderGlobalState* resourceTracker, VkVertexInputAttributeDescription* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineVertexInputStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineVertexInputStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pVertexBindingDescriptions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->vertexBindingDescriptionCount; ++i) {
                transform_tohost_VkVertexInputBindingDescription(
                    resourceTracker,
                    (VkVertexInputBindingDescription*)(toTransform->pVertexBindingDescriptions +
                                                       i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pVertexAttributeDescriptions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->vertexAttributeDescriptionCount; ++i) {
                transform_tohost_VkVertexInputAttributeDescription(
                    resourceTracker,
                    (VkVertexInputAttributeDescription*)(toTransform->pVertexAttributeDescriptions +
                                                         i));
            }
        }
    }
}

void transform_fromhost_VkPipelineVertexInputStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineVertexInputStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pVertexBindingDescriptions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->vertexBindingDescriptionCount; ++i) {
                transform_fromhost_VkVertexInputBindingDescription(
                    resourceTracker,
                    (VkVertexInputBindingDescription*)(toTransform->pVertexBindingDescriptions +
                                                       i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pVertexAttributeDescriptions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->vertexAttributeDescriptionCount; ++i) {
                transform_fromhost_VkVertexInputAttributeDescription(
                    resourceTracker,
                    (VkVertexInputAttributeDescription*)(toTransform->pVertexAttributeDescriptions +
                                                         i));
            }
        }
    }
}

void transform_tohost_VkPipelineInputAssemblyStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineInputAssemblyStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineInputAssemblyStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineInputAssemblyStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineTessellationStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineTessellationStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineTessellationStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineTessellationStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkViewport(VkDecoderGlobalState* resourceTracker, VkViewport* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkViewport(VkDecoderGlobalState* resourceTracker, VkViewport* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineViewportStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineViewportStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pViewports) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->viewportCount; ++i) {
                transform_tohost_VkViewport(resourceTracker,
                                            (VkViewport*)(toTransform->pViewports + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pScissors) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->scissorCount; ++i) {
                transform_tohost_VkRect2D(resourceTracker, (VkRect2D*)(toTransform->pScissors + i));
            }
        }
    }
}

void transform_fromhost_VkPipelineViewportStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineViewportStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pViewports) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->viewportCount; ++i) {
                transform_fromhost_VkViewport(resourceTracker,
                                              (VkViewport*)(toTransform->pViewports + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pScissors) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->scissorCount; ++i) {
                transform_fromhost_VkRect2D(resourceTracker,
                                            (VkRect2D*)(toTransform->pScissors + i));
            }
        }
    }
}

void transform_tohost_VkPipelineRasterizationStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineRasterizationStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRasterizationStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineRasterizationStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineMultisampleStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineMultisampleStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineMultisampleStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineMultisampleStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkStencilOpState(VkDecoderGlobalState* resourceTracker,
                                       VkStencilOpState* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkStencilOpState(VkDecoderGlobalState* resourceTracker,
                                         VkStencilOpState* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineDepthStencilStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineDepthStencilStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkStencilOpState(resourceTracker, (VkStencilOpState*)(&toTransform->front));
    transform_tohost_VkStencilOpState(resourceTracker, (VkStencilOpState*)(&toTransform->back));
}

void transform_fromhost_VkPipelineDepthStencilStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineDepthStencilStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkStencilOpState(resourceTracker, (VkStencilOpState*)(&toTransform->front));
    transform_fromhost_VkStencilOpState(resourceTracker, (VkStencilOpState*)(&toTransform->back));
}

void transform_tohost_VkPipelineColorBlendAttachmentState(
    VkDecoderGlobalState* resourceTracker, VkPipelineColorBlendAttachmentState* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPipelineColorBlendAttachmentState(
    VkDecoderGlobalState* resourceTracker, VkPipelineColorBlendAttachmentState* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineColorBlendStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineColorBlendStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i) {
                transform_tohost_VkPipelineColorBlendAttachmentState(
                    resourceTracker,
                    (VkPipelineColorBlendAttachmentState*)(toTransform->pAttachments + i));
            }
        }
    }
}

void transform_fromhost_VkPipelineColorBlendStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineColorBlendStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i) {
                transform_fromhost_VkPipelineColorBlendAttachmentState(
                    resourceTracker,
                    (VkPipelineColorBlendAttachmentState*)(toTransform->pAttachments + i));
            }
        }
    }
}

void transform_tohost_VkPipelineDynamicStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineDynamicStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineDynamicStateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineDynamicStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkGraphicsPipelineCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                   VkGraphicsPipelineCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pStages) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->stageCount; ++i) {
                transform_tohost_VkPipelineShaderStageCreateInfo(
                    resourceTracker, (VkPipelineShaderStageCreateInfo*)(toTransform->pStages + i));
            }
        }
    }
    if (toTransform->pVertexInputState) {
        transform_tohost_VkPipelineVertexInputStateCreateInfo(
            resourceTracker,
            (VkPipelineVertexInputStateCreateInfo*)(toTransform->pVertexInputState));
    }
    if (toTransform->pInputAssemblyState) {
        transform_tohost_VkPipelineInputAssemblyStateCreateInfo(
            resourceTracker,
            (VkPipelineInputAssemblyStateCreateInfo*)(toTransform->pInputAssemblyState));
    }
    if (toTransform->pTessellationState) {
        transform_tohost_VkPipelineTessellationStateCreateInfo(
            resourceTracker,
            (VkPipelineTessellationStateCreateInfo*)(toTransform->pTessellationState));
    }
    if (toTransform->pViewportState) {
        transform_tohost_VkPipelineViewportStateCreateInfo(
            resourceTracker, (VkPipelineViewportStateCreateInfo*)(toTransform->pViewportState));
    }
    if (toTransform->pRasterizationState) {
        transform_tohost_VkPipelineRasterizationStateCreateInfo(
            resourceTracker,
            (VkPipelineRasterizationStateCreateInfo*)(toTransform->pRasterizationState));
    }
    if (toTransform->pMultisampleState) {
        transform_tohost_VkPipelineMultisampleStateCreateInfo(
            resourceTracker,
            (VkPipelineMultisampleStateCreateInfo*)(toTransform->pMultisampleState));
    }
    if (toTransform->pDepthStencilState) {
        transform_tohost_VkPipelineDepthStencilStateCreateInfo(
            resourceTracker,
            (VkPipelineDepthStencilStateCreateInfo*)(toTransform->pDepthStencilState));
    }
    if (toTransform->pColorBlendState) {
        transform_tohost_VkPipelineColorBlendStateCreateInfo(
            resourceTracker, (VkPipelineColorBlendStateCreateInfo*)(toTransform->pColorBlendState));
    }
    if (toTransform->pDynamicState) {
        transform_tohost_VkPipelineDynamicStateCreateInfo(
            resourceTracker, (VkPipelineDynamicStateCreateInfo*)(toTransform->pDynamicState));
    }
}

void transform_fromhost_VkGraphicsPipelineCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                     VkGraphicsPipelineCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pStages) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->stageCount; ++i) {
                transform_fromhost_VkPipelineShaderStageCreateInfo(
                    resourceTracker, (VkPipelineShaderStageCreateInfo*)(toTransform->pStages + i));
            }
        }
    }
    if (toTransform->pVertexInputState) {
        transform_fromhost_VkPipelineVertexInputStateCreateInfo(
            resourceTracker,
            (VkPipelineVertexInputStateCreateInfo*)(toTransform->pVertexInputState));
    }
    if (toTransform->pInputAssemblyState) {
        transform_fromhost_VkPipelineInputAssemblyStateCreateInfo(
            resourceTracker,
            (VkPipelineInputAssemblyStateCreateInfo*)(toTransform->pInputAssemblyState));
    }
    if (toTransform->pTessellationState) {
        transform_fromhost_VkPipelineTessellationStateCreateInfo(
            resourceTracker,
            (VkPipelineTessellationStateCreateInfo*)(toTransform->pTessellationState));
    }
    if (toTransform->pViewportState) {
        transform_fromhost_VkPipelineViewportStateCreateInfo(
            resourceTracker, (VkPipelineViewportStateCreateInfo*)(toTransform->pViewportState));
    }
    if (toTransform->pRasterizationState) {
        transform_fromhost_VkPipelineRasterizationStateCreateInfo(
            resourceTracker,
            (VkPipelineRasterizationStateCreateInfo*)(toTransform->pRasterizationState));
    }
    if (toTransform->pMultisampleState) {
        transform_fromhost_VkPipelineMultisampleStateCreateInfo(
            resourceTracker,
            (VkPipelineMultisampleStateCreateInfo*)(toTransform->pMultisampleState));
    }
    if (toTransform->pDepthStencilState) {
        transform_fromhost_VkPipelineDepthStencilStateCreateInfo(
            resourceTracker,
            (VkPipelineDepthStencilStateCreateInfo*)(toTransform->pDepthStencilState));
    }
    if (toTransform->pColorBlendState) {
        transform_fromhost_VkPipelineColorBlendStateCreateInfo(
            resourceTracker, (VkPipelineColorBlendStateCreateInfo*)(toTransform->pColorBlendState));
    }
    if (toTransform->pDynamicState) {
        transform_fromhost_VkPipelineDynamicStateCreateInfo(
            resourceTracker, (VkPipelineDynamicStateCreateInfo*)(toTransform->pDynamicState));
    }
}

void transform_tohost_VkPushConstantRange(VkDecoderGlobalState* resourceTracker,
                                          VkPushConstantRange* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPushConstantRange(VkDecoderGlobalState* resourceTracker,
                                            VkPushConstantRange* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineLayoutCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                 VkPipelineLayoutCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pPushConstantRanges) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->pushConstantRangeCount; ++i) {
                transform_tohost_VkPushConstantRange(
                    resourceTracker, (VkPushConstantRange*)(toTransform->pPushConstantRanges + i));
            }
        }
    }
}

void transform_fromhost_VkPipelineLayoutCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                   VkPipelineLayoutCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pPushConstantRanges) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->pushConstantRangeCount; ++i) {
                transform_fromhost_VkPushConstantRange(
                    resourceTracker, (VkPushConstantRange*)(toTransform->pPushConstantRanges + i));
            }
        }
    }
}

void transform_tohost_VkSamplerCreateInfo(VkDecoderGlobalState* resourceTracker,
                                          VkSamplerCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSamplerCreateInfo(VkDecoderGlobalState* resourceTracker,
                                            VkSamplerCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCopyDescriptorSet(VkDecoderGlobalState* resourceTracker,
                                          VkCopyDescriptorSet* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCopyDescriptorSet(VkDecoderGlobalState* resourceTracker,
                                            VkCopyDescriptorSet* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorBufferInfo(VkDecoderGlobalState* resourceTracker,
                                             VkDescriptorBufferInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDescriptorBufferInfo(VkDecoderGlobalState* resourceTracker,
                                               VkDescriptorBufferInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDescriptorImageInfo(VkDecoderGlobalState* resourceTracker,
                                            VkDescriptorImageInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDescriptorImageInfo(VkDecoderGlobalState* resourceTracker,
                                              VkDescriptorImageInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDescriptorPoolSize(VkDecoderGlobalState* resourceTracker,
                                           VkDescriptorPoolSize* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDescriptorPoolSize(VkDecoderGlobalState* resourceTracker,
                                             VkDescriptorPoolSize* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDescriptorPoolCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                 VkDescriptorPoolCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pPoolSizes) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->poolSizeCount; ++i) {
                transform_tohost_VkDescriptorPoolSize(
                    resourceTracker, (VkDescriptorPoolSize*)(toTransform->pPoolSizes + i));
            }
        }
    }
}

void transform_fromhost_VkDescriptorPoolCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                   VkDescriptorPoolCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pPoolSizes) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->poolSizeCount; ++i) {
                transform_fromhost_VkDescriptorPoolSize(
                    resourceTracker, (VkDescriptorPoolSize*)(toTransform->pPoolSizes + i));
            }
        }
    }
}

void transform_tohost_VkDescriptorSetAllocateInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkDescriptorSetAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorSetAllocateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkDescriptorSetAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorSetLayoutBinding(VkDecoderGlobalState* resourceTracker,
                                                   VkDescriptorSetLayoutBinding* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDescriptorSetLayoutBinding(VkDecoderGlobalState* resourceTracker,
                                                     VkDescriptorSetLayoutBinding* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDescriptorSetLayoutCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkDescriptorSetLayoutCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pBindings) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindingCount; ++i) {
                transform_tohost_VkDescriptorSetLayoutBinding(
                    resourceTracker, (VkDescriptorSetLayoutBinding*)(toTransform->pBindings + i));
            }
        }
    }
}

void transform_fromhost_VkDescriptorSetLayoutCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkDescriptorSetLayoutCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pBindings) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindingCount; ++i) {
                transform_fromhost_VkDescriptorSetLayoutBinding(
                    resourceTracker, (VkDescriptorSetLayoutBinding*)(toTransform->pBindings + i));
            }
        }
    }
}

void transform_tohost_VkWriteDescriptorSet(VkDecoderGlobalState* resourceTracker,
                                           VkWriteDescriptorSet* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pImageInfo) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorCount; ++i) {
                transform_tohost_VkDescriptorImageInfo(
                    resourceTracker, (VkDescriptorImageInfo*)(toTransform->pImageInfo + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pBufferInfo) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorCount; ++i) {
                transform_tohost_VkDescriptorBufferInfo(
                    resourceTracker, (VkDescriptorBufferInfo*)(toTransform->pBufferInfo + i));
            }
        }
    }
}

void transform_fromhost_VkWriteDescriptorSet(VkDecoderGlobalState* resourceTracker,
                                             VkWriteDescriptorSet* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pImageInfo) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorCount; ++i) {
                transform_fromhost_VkDescriptorImageInfo(
                    resourceTracker, (VkDescriptorImageInfo*)(toTransform->pImageInfo + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pBufferInfo) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorCount; ++i) {
                transform_fromhost_VkDescriptorBufferInfo(
                    resourceTracker, (VkDescriptorBufferInfo*)(toTransform->pBufferInfo + i));
            }
        }
    }
}

void transform_tohost_VkAttachmentDescription(VkDecoderGlobalState* resourceTracker,
                                              VkAttachmentDescription* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkAttachmentDescription(VkDecoderGlobalState* resourceTracker,
                                                VkAttachmentDescription* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkAttachmentReference(VkDecoderGlobalState* resourceTracker,
                                            VkAttachmentReference* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkAttachmentReference(VkDecoderGlobalState* resourceTracker,
                                              VkAttachmentReference* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkFramebufferCreateInfo(VkDecoderGlobalState* resourceTracker,
                                              VkFramebufferCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkFramebufferCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                VkFramebufferCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubpassDescription(VkDecoderGlobalState* resourceTracker,
                                           VkSubpassDescription* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pInputAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->inputAttachmentCount; ++i) {
                transform_tohost_VkAttachmentReference(
                    resourceTracker, (VkAttachmentReference*)(toTransform->pInputAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pColorAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i) {
                transform_tohost_VkAttachmentReference(
                    resourceTracker, (VkAttachmentReference*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pResolveAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i) {
                transform_tohost_VkAttachmentReference(
                    resourceTracker,
                    (VkAttachmentReference*)(toTransform->pResolveAttachments + i));
            }
        }
    }
    if (toTransform->pDepthStencilAttachment) {
        transform_tohost_VkAttachmentReference(
            resourceTracker, (VkAttachmentReference*)(toTransform->pDepthStencilAttachment));
    }
}

void transform_fromhost_VkSubpassDescription(VkDecoderGlobalState* resourceTracker,
                                             VkSubpassDescription* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pInputAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->inputAttachmentCount; ++i) {
                transform_fromhost_VkAttachmentReference(
                    resourceTracker, (VkAttachmentReference*)(toTransform->pInputAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pColorAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i) {
                transform_fromhost_VkAttachmentReference(
                    resourceTracker, (VkAttachmentReference*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pResolveAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i) {
                transform_fromhost_VkAttachmentReference(
                    resourceTracker,
                    (VkAttachmentReference*)(toTransform->pResolveAttachments + i));
            }
        }
    }
    if (toTransform->pDepthStencilAttachment) {
        transform_fromhost_VkAttachmentReference(
            resourceTracker, (VkAttachmentReference*)(toTransform->pDepthStencilAttachment));
    }
}

void transform_tohost_VkSubpassDependency(VkDecoderGlobalState* resourceTracker,
                                          VkSubpassDependency* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkSubpassDependency(VkDecoderGlobalState* resourceTracker,
                                            VkSubpassDependency* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkRenderPassCreateInfo(VkDecoderGlobalState* resourceTracker,
                                             VkRenderPassCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i) {
                transform_tohost_VkAttachmentDescription(
                    resourceTracker, (VkAttachmentDescription*)(toTransform->pAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pSubpasses) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->subpassCount; ++i) {
                transform_tohost_VkSubpassDescription(
                    resourceTracker, (VkSubpassDescription*)(toTransform->pSubpasses + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pDependencies) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->dependencyCount; ++i) {
                transform_tohost_VkSubpassDependency(
                    resourceTracker, (VkSubpassDependency*)(toTransform->pDependencies + i));
            }
        }
    }
}

void transform_fromhost_VkRenderPassCreateInfo(VkDecoderGlobalState* resourceTracker,
                                               VkRenderPassCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i) {
                transform_fromhost_VkAttachmentDescription(
                    resourceTracker, (VkAttachmentDescription*)(toTransform->pAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pSubpasses) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->subpassCount; ++i) {
                transform_fromhost_VkSubpassDescription(
                    resourceTracker, (VkSubpassDescription*)(toTransform->pSubpasses + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pDependencies) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->dependencyCount; ++i) {
                transform_fromhost_VkSubpassDependency(
                    resourceTracker, (VkSubpassDependency*)(toTransform->pDependencies + i));
            }
        }
    }
}

void transform_tohost_VkCommandPoolCreateInfo(VkDecoderGlobalState* resourceTracker,
                                              VkCommandPoolCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCommandPoolCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                VkCommandPoolCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCommandBufferAllocateInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkCommandBufferAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCommandBufferAllocateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkCommandBufferAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCommandBufferInheritanceInfo(VkDecoderGlobalState* resourceTracker,
                                                     VkCommandBufferInheritanceInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCommandBufferInheritanceInfo(
    VkDecoderGlobalState* resourceTracker, VkCommandBufferInheritanceInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCommandBufferBeginInfo(VkDecoderGlobalState* resourceTracker,
                                               VkCommandBufferBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pInheritanceInfo) {
        transform_tohost_VkCommandBufferInheritanceInfo(
            resourceTracker, (VkCommandBufferInheritanceInfo*)(toTransform->pInheritanceInfo));
    }
}

void transform_fromhost_VkCommandBufferBeginInfo(VkDecoderGlobalState* resourceTracker,
                                                 VkCommandBufferBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pInheritanceInfo) {
        transform_fromhost_VkCommandBufferInheritanceInfo(
            resourceTracker, (VkCommandBufferInheritanceInfo*)(toTransform->pInheritanceInfo));
    }
}

void transform_tohost_VkBufferCopy(VkDecoderGlobalState* resourceTracker,
                                   VkBufferCopy* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkBufferCopy(VkDecoderGlobalState* resourceTracker,
                                     VkBufferCopy* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkImageSubresourceLayers(VkDecoderGlobalState* resourceTracker,
                                               VkImageSubresourceLayers* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkImageSubresourceLayers(VkDecoderGlobalState* resourceTracker,
                                                 VkImageSubresourceLayers* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkBufferImageCopy(VkDecoderGlobalState* resourceTracker,
                                        VkBufferImageCopy* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_fromhost_VkBufferImageCopy(VkDecoderGlobalState* resourceTracker,
                                          VkBufferImageCopy* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_tohost_VkClearColorValue(VkDecoderGlobalState* resourceTracker,
                                        VkClearColorValue* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkClearColorValue(VkDecoderGlobalState* resourceTracker,
                                          VkClearColorValue* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkClearDepthStencilValue(VkDecoderGlobalState* resourceTracker,
                                               VkClearDepthStencilValue* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkClearDepthStencilValue(VkDecoderGlobalState* resourceTracker,
                                                 VkClearDepthStencilValue* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkClearValue(VkDecoderGlobalState* resourceTracker,
                                   VkClearValue* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkClearColorValue(resourceTracker, (VkClearColorValue*)(&toTransform->color));
    transform_tohost_VkClearDepthStencilValue(
        resourceTracker, (VkClearDepthStencilValue*)(&toTransform->depthStencil));
}

void transform_fromhost_VkClearValue(VkDecoderGlobalState* resourceTracker,
                                     VkClearValue* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkClearColorValue(resourceTracker,
                                         (VkClearColorValue*)(&toTransform->color));
    transform_fromhost_VkClearDepthStencilValue(
        resourceTracker, (VkClearDepthStencilValue*)(&toTransform->depthStencil));
}

void transform_tohost_VkClearAttachment(VkDecoderGlobalState* resourceTracker,
                                        VkClearAttachment* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkClearValue(resourceTracker, (VkClearValue*)(&toTransform->clearValue));
}

void transform_fromhost_VkClearAttachment(VkDecoderGlobalState* resourceTracker,
                                          VkClearAttachment* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkClearValue(resourceTracker, (VkClearValue*)(&toTransform->clearValue));
}

void transform_tohost_VkClearRect(VkDecoderGlobalState* resourceTracker, VkClearRect* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->rect));
}

void transform_fromhost_VkClearRect(VkDecoderGlobalState* resourceTracker,
                                    VkClearRect* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->rect));
}

void transform_tohost_VkImageBlit(VkDecoderGlobalState* resourceTracker, VkImageBlit* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->srcOffsets + i));
    }
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->dstOffsets + i));
    }
}

void transform_fromhost_VkImageBlit(VkDecoderGlobalState* resourceTracker,
                                    VkImageBlit* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->srcOffsets + i));
    }
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->dstOffsets + i));
    }
}

void transform_tohost_VkImageCopy(VkDecoderGlobalState* resourceTracker, VkImageCopy* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkImageCopy(VkDecoderGlobalState* resourceTracker,
                                    VkImageCopy* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkImageResolve(VkDecoderGlobalState* resourceTracker,
                                     VkImageResolve* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkImageResolve(VkDecoderGlobalState* resourceTracker,
                                       VkImageResolve* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkRenderPassBeginInfo(VkDecoderGlobalState* resourceTracker,
                                            VkRenderPassBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->renderArea));
    if (toTransform) {
        if (toTransform->pClearValues) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->clearValueCount; ++i) {
                transform_tohost_VkClearValue(resourceTracker,
                                              (VkClearValue*)(toTransform->pClearValues + i));
            }
        }
    }
}

void transform_fromhost_VkRenderPassBeginInfo(VkDecoderGlobalState* resourceTracker,
                                              VkRenderPassBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->renderArea));
    if (toTransform) {
        if (toTransform->pClearValues) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->clearValueCount; ++i) {
                transform_fromhost_VkClearValue(resourceTracker,
                                                (VkClearValue*)(toTransform->pClearValues + i));
            }
        }
    }
}

#endif
#ifdef VK_VERSION_1_1
void transform_tohost_VkPhysicalDeviceSubgroupProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceSubgroupProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSubgroupProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceSubgroupProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindBufferMemoryInfo(VkDecoderGlobalState* resourceTracker,
                                             VkBindBufferMemoryInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1,
        (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBindBufferMemoryInfo(VkDecoderGlobalState* resourceTracker,
                                               VkBindBufferMemoryInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1,
        (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindImageMemoryInfo(VkDecoderGlobalState* resourceTracker,
                                            VkBindImageMemoryInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1,
        (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBindImageMemoryInfo(VkDecoderGlobalState* resourceTracker,
                                              VkBindImageMemoryInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1,
        (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevice16BitStorageFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDevice16BitStorageFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevice16BitStorageFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDevice16BitStorageFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryDedicatedRequirements(VkDecoderGlobalState* resourceTracker,
                                                    VkMemoryDedicatedRequirements* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryDedicatedRequirements(VkDecoderGlobalState* resourceTracker,
                                                      VkMemoryDedicatedRequirements* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryDedicatedAllocateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkMemoryDedicatedAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryDedicatedAllocateInfo(VkDecoderGlobalState* resourceTracker,
                                                      VkMemoryDedicatedAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryAllocateFlagsInfo(VkDecoderGlobalState* resourceTracker,
                                                VkMemoryAllocateFlagsInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryAllocateFlagsInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkMemoryAllocateFlagsInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceGroupRenderPassBeginInfo(
    VkDecoderGlobalState* resourceTracker, VkDeviceGroupRenderPassBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pDeviceRenderAreas) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->deviceRenderAreaCount; ++i) {
                transform_tohost_VkRect2D(resourceTracker,
                                          (VkRect2D*)(toTransform->pDeviceRenderAreas + i));
            }
        }
    }
}

void transform_fromhost_VkDeviceGroupRenderPassBeginInfo(
    VkDecoderGlobalState* resourceTracker, VkDeviceGroupRenderPassBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pDeviceRenderAreas) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->deviceRenderAreaCount; ++i) {
                transform_fromhost_VkRect2D(resourceTracker,
                                            (VkRect2D*)(toTransform->pDeviceRenderAreas + i));
            }
        }
    }
}

void transform_tohost_VkDeviceGroupCommandBufferBeginInfo(
    VkDecoderGlobalState* resourceTracker, VkDeviceGroupCommandBufferBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceGroupCommandBufferBeginInfo(
    VkDecoderGlobalState* resourceTracker, VkDeviceGroupCommandBufferBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceGroupSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                              VkDeviceGroupSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceGroupSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                                VkDeviceGroupSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceGroupBindSparseInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkDeviceGroupBindSparseInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceGroupBindSparseInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkDeviceGroupBindSparseInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindBufferMemoryDeviceGroupInfo(
    VkDecoderGlobalState* resourceTracker, VkBindBufferMemoryDeviceGroupInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBindBufferMemoryDeviceGroupInfo(
    VkDecoderGlobalState* resourceTracker, VkBindBufferMemoryDeviceGroupInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindImageMemoryDeviceGroupInfo(
    VkDecoderGlobalState* resourceTracker, VkBindImageMemoryDeviceGroupInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pSplitInstanceBindRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->splitInstanceBindRegionCount; ++i) {
                transform_tohost_VkRect2D(resourceTracker,
                                          (VkRect2D*)(toTransform->pSplitInstanceBindRegions + i));
            }
        }
    }
}

void transform_fromhost_VkBindImageMemoryDeviceGroupInfo(
    VkDecoderGlobalState* resourceTracker, VkBindImageMemoryDeviceGroupInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pSplitInstanceBindRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->splitInstanceBindRegionCount; ++i) {
                transform_fromhost_VkRect2D(
                    resourceTracker, (VkRect2D*)(toTransform->pSplitInstanceBindRegions + i));
            }
        }
    }
}

void transform_tohost_VkPhysicalDeviceGroupProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceGroupProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceGroupProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceGroupProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceGroupDeviceCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkDeviceGroupDeviceCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceGroupDeviceCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                      VkDeviceGroupDeviceCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferMemoryRequirementsInfo2(
    VkDecoderGlobalState* resourceTracker, VkBufferMemoryRequirementsInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferMemoryRequirementsInfo2(
    VkDecoderGlobalState* resourceTracker, VkBufferMemoryRequirementsInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageMemoryRequirementsInfo2(VkDecoderGlobalState* resourceTracker,
                                                     VkImageMemoryRequirementsInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageMemoryRequirementsInfo2(
    VkDecoderGlobalState* resourceTracker, VkImageMemoryRequirementsInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageSparseMemoryRequirementsInfo2(
    VkDecoderGlobalState* resourceTracker, VkImageSparseMemoryRequirementsInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageSparseMemoryRequirementsInfo2(
    VkDecoderGlobalState* resourceTracker, VkImageSparseMemoryRequirementsInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryRequirements2(VkDecoderGlobalState* resourceTracker,
                                            VkMemoryRequirements2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkMemoryRequirements(
        resourceTracker, (VkMemoryRequirements*)(&toTransform->memoryRequirements));
}

void transform_fromhost_VkMemoryRequirements2(VkDecoderGlobalState* resourceTracker,
                                              VkMemoryRequirements2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkMemoryRequirements(
        resourceTracker, (VkMemoryRequirements*)(&toTransform->memoryRequirements));
}

void transform_tohost_VkSparseImageMemoryRequirements2(
    VkDecoderGlobalState* resourceTracker, VkSparseImageMemoryRequirements2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkSparseImageMemoryRequirements(
        resourceTracker, (VkSparseImageMemoryRequirements*)(&toTransform->memoryRequirements));
}

void transform_fromhost_VkSparseImageMemoryRequirements2(
    VkDecoderGlobalState* resourceTracker, VkSparseImageMemoryRequirements2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkSparseImageMemoryRequirements(
        resourceTracker, (VkSparseImageMemoryRequirements*)(&toTransform->memoryRequirements));
}

void transform_tohost_VkPhysicalDeviceFeatures2(VkDecoderGlobalState* resourceTracker,
                                                VkPhysicalDeviceFeatures2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkPhysicalDeviceFeatures(resourceTracker,
                                              (VkPhysicalDeviceFeatures*)(&toTransform->features));
}

void transform_fromhost_VkPhysicalDeviceFeatures2(VkDecoderGlobalState* resourceTracker,
                                                  VkPhysicalDeviceFeatures2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkPhysicalDeviceFeatures(
        resourceTracker, (VkPhysicalDeviceFeatures*)(&toTransform->features));
}

void transform_tohost_VkPhysicalDeviceProperties2(VkDecoderGlobalState* resourceTracker,
                                                  VkPhysicalDeviceProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkPhysicalDeviceProperties(
        resourceTracker, (VkPhysicalDeviceProperties*)(&toTransform->properties));
}

void transform_fromhost_VkPhysicalDeviceProperties2(VkDecoderGlobalState* resourceTracker,
                                                    VkPhysicalDeviceProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkPhysicalDeviceProperties(
        resourceTracker, (VkPhysicalDeviceProperties*)(&toTransform->properties));
}

void transform_tohost_VkFormatProperties2(VkDecoderGlobalState* resourceTracker,
                                          VkFormatProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkFormatProperties(resourceTracker,
                                        (VkFormatProperties*)(&toTransform->formatProperties));
}

void transform_fromhost_VkFormatProperties2(VkDecoderGlobalState* resourceTracker,
                                            VkFormatProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkFormatProperties(resourceTracker,
                                          (VkFormatProperties*)(&toTransform->formatProperties));
}

void transform_tohost_VkImageFormatProperties2(VkDecoderGlobalState* resourceTracker,
                                               VkImageFormatProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageFormatProperties(
        resourceTracker, (VkImageFormatProperties*)(&toTransform->imageFormatProperties));
}

void transform_fromhost_VkImageFormatProperties2(VkDecoderGlobalState* resourceTracker,
                                                 VkImageFormatProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageFormatProperties(
        resourceTracker, (VkImageFormatProperties*)(&toTransform->imageFormatProperties));
}

void transform_tohost_VkPhysicalDeviceImageFormatInfo2(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceImageFormatInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImageFormatInfo2(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceImageFormatInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkQueueFamilyProperties2(VkDecoderGlobalState* resourceTracker,
                                               VkQueueFamilyProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkQueueFamilyProperties(
        resourceTracker, (VkQueueFamilyProperties*)(&toTransform->queueFamilyProperties));
}

void transform_fromhost_VkQueueFamilyProperties2(VkDecoderGlobalState* resourceTracker,
                                                 VkQueueFamilyProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkQueueFamilyProperties(
        resourceTracker, (VkQueueFamilyProperties*)(&toTransform->queueFamilyProperties));
}

void transform_tohost_VkPhysicalDeviceMemoryProperties2(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMemoryProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkPhysicalDeviceMemoryProperties(
        resourceTracker, (VkPhysicalDeviceMemoryProperties*)(&toTransform->memoryProperties));
}

void transform_fromhost_VkPhysicalDeviceMemoryProperties2(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMemoryProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkPhysicalDeviceMemoryProperties(
        resourceTracker, (VkPhysicalDeviceMemoryProperties*)(&toTransform->memoryProperties));
}

void transform_tohost_VkSparseImageFormatProperties2(VkDecoderGlobalState* resourceTracker,
                                                     VkSparseImageFormatProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkSparseImageFormatProperties(
        resourceTracker, (VkSparseImageFormatProperties*)(&toTransform->properties));
}

void transform_fromhost_VkSparseImageFormatProperties2(
    VkDecoderGlobalState* resourceTracker, VkSparseImageFormatProperties2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkSparseImageFormatProperties(
        resourceTracker, (VkSparseImageFormatProperties*)(&toTransform->properties));
}

void transform_tohost_VkPhysicalDeviceSparseImageFormatInfo2(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceSparseImageFormatInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSparseImageFormatInfo2(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceSparseImageFormatInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePointClippingProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDevicePointClippingProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePointClippingProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDevicePointClippingProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkInputAttachmentAspectReference(
    VkDecoderGlobalState* resourceTracker, VkInputAttachmentAspectReference* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkInputAttachmentAspectReference(
    VkDecoderGlobalState* resourceTracker, VkInputAttachmentAspectReference* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkRenderPassInputAttachmentAspectCreateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkRenderPassInputAttachmentAspectCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pAspectReferences) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->aspectReferenceCount; ++i) {
                transform_tohost_VkInputAttachmentAspectReference(
                    resourceTracker,
                    (VkInputAttachmentAspectReference*)(toTransform->pAspectReferences + i));
            }
        }
    }
}

void transform_fromhost_VkRenderPassInputAttachmentAspectCreateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkRenderPassInputAttachmentAspectCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pAspectReferences) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->aspectReferenceCount; ++i) {
                transform_fromhost_VkInputAttachmentAspectReference(
                    resourceTracker,
                    (VkInputAttachmentAspectReference*)(toTransform->pAspectReferences + i));
            }
        }
    }
}

void transform_tohost_VkImageViewUsageCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                 VkImageViewUsageCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageViewUsageCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                   VkImageViewUsageCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineTessellationDomainOriginStateCreateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineTessellationDomainOriginStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineTessellationDomainOriginStateCreateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineTessellationDomainOriginStateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkRenderPassMultiviewCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkRenderPassMultiviewCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkRenderPassMultiviewCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkRenderPassMultiviewCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMultiviewFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMultiviewFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMultiviewFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMultiviewFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMultiviewProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMultiviewProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMultiviewProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMultiviewProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVariablePointersFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVariablePointersFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVariablePointersFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVariablePointersFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceProtectedMemoryFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceProtectedMemoryFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceProtectedMemoryFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceProtectedMemoryFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceProtectedMemoryProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceProtectedMemoryProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceProtectedMemoryProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceProtectedMemoryProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceQueueInfo2(VkDecoderGlobalState* resourceTracker,
                                         VkDeviceQueueInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceQueueInfo2(VkDecoderGlobalState* resourceTracker,
                                           VkDeviceQueueInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkProtectedSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                            VkProtectedSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkProtectedSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                              VkProtectedSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSamplerYcbcrConversionCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkSamplerYcbcrConversionCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkComponentMapping(resourceTracker,
                                        (VkComponentMapping*)(&toTransform->components));
}

void transform_fromhost_VkSamplerYcbcrConversionCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkSamplerYcbcrConversionCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkComponentMapping(resourceTracker,
                                          (VkComponentMapping*)(&toTransform->components));
}

void transform_tohost_VkSamplerYcbcrConversionInfo(VkDecoderGlobalState* resourceTracker,
                                                   VkSamplerYcbcrConversionInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSamplerYcbcrConversionInfo(VkDecoderGlobalState* resourceTracker,
                                                     VkSamplerYcbcrConversionInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindImagePlaneMemoryInfo(VkDecoderGlobalState* resourceTracker,
                                                 VkBindImagePlaneMemoryInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBindImagePlaneMemoryInfo(VkDecoderGlobalState* resourceTracker,
                                                   VkBindImagePlaneMemoryInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImagePlaneMemoryRequirementsInfo(
    VkDecoderGlobalState* resourceTracker, VkImagePlaneMemoryRequirementsInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImagePlaneMemoryRequirementsInfo(
    VkDecoderGlobalState* resourceTracker, VkImagePlaneMemoryRequirementsInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSamplerYcbcrConversionImageFormatProperties(
    VkDecoderGlobalState* resourceTracker,
    VkSamplerYcbcrConversionImageFormatProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSamplerYcbcrConversionImageFormatProperties(
    VkDecoderGlobalState* resourceTracker,
    VkSamplerYcbcrConversionImageFormatProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorUpdateTemplateEntry(
    VkDecoderGlobalState* resourceTracker, VkDescriptorUpdateTemplateEntry* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDescriptorUpdateTemplateEntry(
    VkDecoderGlobalState* resourceTracker, VkDescriptorUpdateTemplateEntry* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDescriptorUpdateTemplateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkDescriptorUpdateTemplateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pDescriptorUpdateEntries) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorUpdateEntryCount; ++i) {
                transform_tohost_VkDescriptorUpdateTemplateEntry(
                    resourceTracker,
                    (VkDescriptorUpdateTemplateEntry*)(toTransform->pDescriptorUpdateEntries + i));
            }
        }
    }
}

void transform_fromhost_VkDescriptorUpdateTemplateCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkDescriptorUpdateTemplateCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pDescriptorUpdateEntries) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorUpdateEntryCount; ++i) {
                transform_fromhost_VkDescriptorUpdateTemplateEntry(
                    resourceTracker,
                    (VkDescriptorUpdateTemplateEntry*)(toTransform->pDescriptorUpdateEntries + i));
            }
        }
    }
}

void transform_tohost_VkExternalMemoryProperties(VkDecoderGlobalState* resourceTracker,
                                                 VkExternalMemoryProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkExternalMemoryProperties(VkDecoderGlobalState* resourceTracker,
                                                   VkExternalMemoryProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceExternalImageFormatInfo(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceExternalImageFormatInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExternalImageFormatInfo(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceExternalImageFormatInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalImageFormatProperties(
    VkDecoderGlobalState* resourceTracker, VkExternalImageFormatProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    resourceTracker->transformImpl_VkExternalMemoryProperties_tohost(
        &toTransform->externalMemoryProperties, 1);
    transform_tohost_VkExternalMemoryProperties(
        resourceTracker, (VkExternalMemoryProperties*)(&toTransform->externalMemoryProperties));
}

void transform_fromhost_VkExternalImageFormatProperties(
    VkDecoderGlobalState* resourceTracker, VkExternalImageFormatProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    resourceTracker->transformImpl_VkExternalMemoryProperties_fromhost(
        &toTransform->externalMemoryProperties, 1);
    transform_fromhost_VkExternalMemoryProperties(
        resourceTracker, (VkExternalMemoryProperties*)(&toTransform->externalMemoryProperties));
}

void transform_tohost_VkPhysicalDeviceExternalBufferInfo(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceExternalBufferInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExternalBufferInfo(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceExternalBufferInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalBufferProperties(VkDecoderGlobalState* resourceTracker,
                                                 VkExternalBufferProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    resourceTracker->transformImpl_VkExternalMemoryProperties_tohost(
        &toTransform->externalMemoryProperties, 1);
    transform_tohost_VkExternalMemoryProperties(
        resourceTracker, (VkExternalMemoryProperties*)(&toTransform->externalMemoryProperties));
}

void transform_fromhost_VkExternalBufferProperties(VkDecoderGlobalState* resourceTracker,
                                                   VkExternalBufferProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    resourceTracker->transformImpl_VkExternalMemoryProperties_fromhost(
        &toTransform->externalMemoryProperties, 1);
    transform_fromhost_VkExternalMemoryProperties(
        resourceTracker, (VkExternalMemoryProperties*)(&toTransform->externalMemoryProperties));
}

void transform_tohost_VkPhysicalDeviceIDProperties(VkDecoderGlobalState* resourceTracker,
                                                   VkPhysicalDeviceIDProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceIDProperties(VkDecoderGlobalState* resourceTracker,
                                                     VkPhysicalDeviceIDProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalMemoryImageCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkExternalMemoryImageCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExternalMemoryImageCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkExternalMemoryImageCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalMemoryBufferCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkExternalMemoryBufferCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExternalMemoryBufferCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkExternalMemoryBufferCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExportMemoryAllocateInfo(VkDecoderGlobalState* resourceTracker,
                                                 VkExportMemoryAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExportMemoryAllocateInfo(VkDecoderGlobalState* resourceTracker,
                                                   VkExportMemoryAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceExternalFenceInfo(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceExternalFenceInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExternalFenceInfo(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceExternalFenceInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalFenceProperties(VkDecoderGlobalState* resourceTracker,
                                                VkExternalFenceProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExternalFenceProperties(VkDecoderGlobalState* resourceTracker,
                                                  VkExternalFenceProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExportFenceCreateInfo(VkDecoderGlobalState* resourceTracker,
                                              VkExportFenceCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExportFenceCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                VkExportFenceCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExportSemaphoreCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkExportSemaphoreCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExportSemaphoreCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkExportSemaphoreCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceExternalSemaphoreInfo(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceExternalSemaphoreInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExternalSemaphoreInfo(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceExternalSemaphoreInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalSemaphoreProperties(VkDecoderGlobalState* resourceTracker,
                                                    VkExternalSemaphoreProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExternalSemaphoreProperties(VkDecoderGlobalState* resourceTracker,
                                                      VkExternalSemaphoreProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMaintenance3Properties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMaintenance3Properties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMaintenance3Properties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMaintenance3Properties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorSetLayoutSupport(VkDecoderGlobalState* resourceTracker,
                                                   VkDescriptorSetLayoutSupport* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorSetLayoutSupport(VkDecoderGlobalState* resourceTracker,
                                                     VkDescriptorSetLayoutSupport* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderDrawParametersFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderDrawParametersFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderDrawParametersFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderDrawParametersFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_VERSION_1_2
void transform_tohost_VkPhysicalDeviceVulkan11Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan11Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan11Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan11Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVulkan11Properties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan11Properties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan11Properties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan11Properties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVulkan12Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan12Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan12Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan12Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkConformanceVersion(VkDecoderGlobalState* resourceTracker,
                                           VkConformanceVersion* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkConformanceVersion(VkDecoderGlobalState* resourceTracker,
                                             VkConformanceVersion* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceVulkan12Properties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan12Properties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkConformanceVersion(
        resourceTracker, (VkConformanceVersion*)(&toTransform->conformanceVersion));
}

void transform_fromhost_VkPhysicalDeviceVulkan12Properties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan12Properties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkConformanceVersion(
        resourceTracker, (VkConformanceVersion*)(&toTransform->conformanceVersion));
}

void transform_tohost_VkImageFormatListCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkImageFormatListCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageFormatListCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkImageFormatListCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkAttachmentDescription2(VkDecoderGlobalState* resourceTracker,
                                               VkAttachmentDescription2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkAttachmentDescription2(VkDecoderGlobalState* resourceTracker,
                                                 VkAttachmentDescription2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkAttachmentReference2(VkDecoderGlobalState* resourceTracker,
                                             VkAttachmentReference2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkAttachmentReference2(VkDecoderGlobalState* resourceTracker,
                                               VkAttachmentReference2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubpassDescription2(VkDecoderGlobalState* resourceTracker,
                                            VkSubpassDescription2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pInputAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->inputAttachmentCount; ++i) {
                transform_tohost_VkAttachmentReference2(
                    resourceTracker, (VkAttachmentReference2*)(toTransform->pInputAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pColorAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i) {
                transform_tohost_VkAttachmentReference2(
                    resourceTracker, (VkAttachmentReference2*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pResolveAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i) {
                transform_tohost_VkAttachmentReference2(
                    resourceTracker,
                    (VkAttachmentReference2*)(toTransform->pResolveAttachments + i));
            }
        }
    }
    if (toTransform->pDepthStencilAttachment) {
        transform_tohost_VkAttachmentReference2(
            resourceTracker, (VkAttachmentReference2*)(toTransform->pDepthStencilAttachment));
    }
}

void transform_fromhost_VkSubpassDescription2(VkDecoderGlobalState* resourceTracker,
                                              VkSubpassDescription2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pInputAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->inputAttachmentCount; ++i) {
                transform_fromhost_VkAttachmentReference2(
                    resourceTracker, (VkAttachmentReference2*)(toTransform->pInputAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pColorAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i) {
                transform_fromhost_VkAttachmentReference2(
                    resourceTracker, (VkAttachmentReference2*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pResolveAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i) {
                transform_fromhost_VkAttachmentReference2(
                    resourceTracker,
                    (VkAttachmentReference2*)(toTransform->pResolveAttachments + i));
            }
        }
    }
    if (toTransform->pDepthStencilAttachment) {
        transform_fromhost_VkAttachmentReference2(
            resourceTracker, (VkAttachmentReference2*)(toTransform->pDepthStencilAttachment));
    }
}

void transform_tohost_VkSubpassDependency2(VkDecoderGlobalState* resourceTracker,
                                           VkSubpassDependency2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSubpassDependency2(VkDecoderGlobalState* resourceTracker,
                                             VkSubpassDependency2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkRenderPassCreateInfo2(VkDecoderGlobalState* resourceTracker,
                                              VkRenderPassCreateInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i) {
                transform_tohost_VkAttachmentDescription2(
                    resourceTracker, (VkAttachmentDescription2*)(toTransform->pAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pSubpasses) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->subpassCount; ++i) {
                transform_tohost_VkSubpassDescription2(
                    resourceTracker, (VkSubpassDescription2*)(toTransform->pSubpasses + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pDependencies) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->dependencyCount; ++i) {
                transform_tohost_VkSubpassDependency2(
                    resourceTracker, (VkSubpassDependency2*)(toTransform->pDependencies + i));
            }
        }
    }
}

void transform_fromhost_VkRenderPassCreateInfo2(VkDecoderGlobalState* resourceTracker,
                                                VkRenderPassCreateInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i) {
                transform_fromhost_VkAttachmentDescription2(
                    resourceTracker, (VkAttachmentDescription2*)(toTransform->pAttachments + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pSubpasses) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->subpassCount; ++i) {
                transform_fromhost_VkSubpassDescription2(
                    resourceTracker, (VkSubpassDescription2*)(toTransform->pSubpasses + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pDependencies) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->dependencyCount; ++i) {
                transform_fromhost_VkSubpassDependency2(
                    resourceTracker, (VkSubpassDependency2*)(toTransform->pDependencies + i));
            }
        }
    }
}

void transform_tohost_VkSubpassBeginInfo(VkDecoderGlobalState* resourceTracker,
                                         VkSubpassBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSubpassBeginInfo(VkDecoderGlobalState* resourceTracker,
                                           VkSubpassBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubpassEndInfo(VkDecoderGlobalState* resourceTracker,
                                       VkSubpassEndInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSubpassEndInfo(VkDecoderGlobalState* resourceTracker,
                                         VkSubpassEndInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevice8BitStorageFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDevice8BitStorageFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevice8BitStorageFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDevice8BitStorageFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceDriverProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceDriverProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkConformanceVersion(
        resourceTracker, (VkConformanceVersion*)(&toTransform->conformanceVersion));
}

void transform_fromhost_VkPhysicalDeviceDriverProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceDriverProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkConformanceVersion(
        resourceTracker, (VkConformanceVersion*)(&toTransform->conformanceVersion));
}

void transform_tohost_VkPhysicalDeviceShaderAtomicInt64Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceShaderAtomicInt64Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderAtomicInt64Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceShaderAtomicInt64Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderFloat16Int8Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceShaderFloat16Int8Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderFloat16Int8Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceShaderFloat16Int8Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceFloatControlsProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceFloatControlsProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceFloatControlsProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceFloatControlsProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceDescriptorIndexingFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDescriptorIndexingFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceDescriptorIndexingProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDescriptorIndexingProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    VkDecoderGlobalState* resourceTracker,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    VkDecoderGlobalState* resourceTracker,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubpassDescriptionDepthStencilResolve(
    VkDecoderGlobalState* resourceTracker, VkSubpassDescriptionDepthStencilResolve* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pDepthStencilResolveAttachment) {
        transform_tohost_VkAttachmentReference2(
            resourceTracker,
            (VkAttachmentReference2*)(toTransform->pDepthStencilResolveAttachment));
    }
}

void transform_fromhost_VkSubpassDescriptionDepthStencilResolve(
    VkDecoderGlobalState* resourceTracker, VkSubpassDescriptionDepthStencilResolve* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pDepthStencilResolveAttachment) {
        transform_fromhost_VkAttachmentReference2(
            resourceTracker,
            (VkAttachmentReference2*)(toTransform->pDepthStencilResolveAttachment));
    }
}

void transform_tohost_VkPhysicalDeviceDepthStencilResolveProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceDepthStencilResolveProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDepthStencilResolveProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceDepthStencilResolveProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceScalarBlockLayoutFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceScalarBlockLayoutFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceScalarBlockLayoutFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceScalarBlockLayoutFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageStencilUsageCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkImageStencilUsageCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageStencilUsageCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                      VkImageStencilUsageCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSamplerReductionModeCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkSamplerReductionModeCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSamplerReductionModeCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkSamplerReductionModeCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVulkanMemoryModelFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkanMemoryModelFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkanMemoryModelFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkanMemoryModelFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceImagelessFramebufferFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceImagelessFramebufferFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImagelessFramebufferFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceImagelessFramebufferFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkFramebufferAttachmentImageInfo(
    VkDecoderGlobalState* resourceTracker, VkFramebufferAttachmentImageInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkFramebufferAttachmentImageInfo(
    VkDecoderGlobalState* resourceTracker, VkFramebufferAttachmentImageInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkFramebufferAttachmentsCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkFramebufferAttachmentsCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pAttachmentImageInfos) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentImageInfoCount; ++i) {
                transform_tohost_VkFramebufferAttachmentImageInfo(
                    resourceTracker,
                    (VkFramebufferAttachmentImageInfo*)(toTransform->pAttachmentImageInfos + i));
            }
        }
    }
}

void transform_fromhost_VkFramebufferAttachmentsCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkFramebufferAttachmentsCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pAttachmentImageInfos) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentImageInfoCount; ++i) {
                transform_fromhost_VkFramebufferAttachmentImageInfo(
                    resourceTracker,
                    (VkFramebufferAttachmentImageInfo*)(toTransform->pAttachmentImageInfos + i));
            }
        }
    }
}

void transform_tohost_VkRenderPassAttachmentBeginInfo(
    VkDecoderGlobalState* resourceTracker, VkRenderPassAttachmentBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkRenderPassAttachmentBeginInfo(
    VkDecoderGlobalState* resourceTracker, VkRenderPassAttachmentBeginInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkAttachmentReferenceStencilLayout(
    VkDecoderGlobalState* resourceTracker, VkAttachmentReferenceStencilLayout* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkAttachmentReferenceStencilLayout(
    VkDecoderGlobalState* resourceTracker, VkAttachmentReferenceStencilLayout* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkAttachmentDescriptionStencilLayout(
    VkDecoderGlobalState* resourceTracker, VkAttachmentDescriptionStencilLayout* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkAttachmentDescriptionStencilLayout(
    VkDecoderGlobalState* resourceTracker, VkAttachmentDescriptionStencilLayout* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceHostQueryResetFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceHostQueryResetFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceHostQueryResetFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceHostQueryResetFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceTimelineSemaphoreFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceTimelineSemaphoreFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTimelineSemaphoreFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceTimelineSemaphoreFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceTimelineSemaphoreProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTimelineSemaphoreProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTimelineSemaphoreProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTimelineSemaphoreProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSemaphoreTypeCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                VkSemaphoreTypeCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreTypeCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkSemaphoreTypeCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkTimelineSemaphoreSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkTimelineSemaphoreSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkTimelineSemaphoreSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                                      VkTimelineSemaphoreSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSemaphoreWaitInfo(VkDecoderGlobalState* resourceTracker,
                                          VkSemaphoreWaitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreWaitInfo(VkDecoderGlobalState* resourceTracker,
                                            VkSemaphoreWaitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSemaphoreSignalInfo(VkDecoderGlobalState* resourceTracker,
                                            VkSemaphoreSignalInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreSignalInfo(VkDecoderGlobalState* resourceTracker,
                                              VkSemaphoreSignalInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceBufferDeviceAddressFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceBufferDeviceAddressFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceBufferDeviceAddressFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceBufferDeviceAddressFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferDeviceAddressInfo(VkDecoderGlobalState* resourceTracker,
                                                VkBufferDeviceAddressInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferDeviceAddressInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkBufferDeviceAddressInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferOpaqueCaptureAddressCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkBufferOpaqueCaptureAddressCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferOpaqueCaptureAddressCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkBufferOpaqueCaptureAddressCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryOpaqueCaptureAddressAllocateInfo(
    VkDecoderGlobalState* resourceTracker, VkMemoryOpaqueCaptureAddressAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryOpaqueCaptureAddressAllocateInfo(
    VkDecoderGlobalState* resourceTracker, VkMemoryOpaqueCaptureAddressAllocateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceMemoryOpaqueCaptureAddressInfo(
    VkDecoderGlobalState* resourceTracker, VkDeviceMemoryOpaqueCaptureAddressInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost((VkDeviceMemory*)&toTransform->memory, 1,
                                                  (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr,
                                                  0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceMemoryOpaqueCaptureAddressInfo(
    VkDecoderGlobalState* resourceTracker, VkDeviceMemoryOpaqueCaptureAddressInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost(
        (VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr,
        0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_VERSION_1_3
void transform_tohost_VkPhysicalDeviceVulkan13Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan13Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan13Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan13Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVulkan13Properties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan13Properties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan13Properties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceVulkan13Properties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineCreationFeedback(VkDecoderGlobalState* resourceTracker,
                                                 VkPipelineCreationFeedback* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPipelineCreationFeedback(VkDecoderGlobalState* resourceTracker,
                                                   VkPipelineCreationFeedback* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineCreationFeedbackCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineCreationFeedbackCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pPipelineCreationFeedback) {
        transform_tohost_VkPipelineCreationFeedback(
            resourceTracker, (VkPipelineCreationFeedback*)(toTransform->pPipelineCreationFeedback));
    }
    if (toTransform) {
        if (toTransform->pPipelineStageCreationFeedbacks) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->pipelineStageCreationFeedbackCount;
                 ++i) {
                transform_tohost_VkPipelineCreationFeedback(
                    resourceTracker,
                    (VkPipelineCreationFeedback*)(toTransform->pPipelineStageCreationFeedbacks +
                                                  i));
            }
        }
    }
}

void transform_fromhost_VkPipelineCreationFeedbackCreateInfo(
    VkDecoderGlobalState* resourceTracker, VkPipelineCreationFeedbackCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pPipelineCreationFeedback) {
        transform_fromhost_VkPipelineCreationFeedback(
            resourceTracker, (VkPipelineCreationFeedback*)(toTransform->pPipelineCreationFeedback));
    }
    if (toTransform) {
        if (toTransform->pPipelineStageCreationFeedbacks) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->pipelineStageCreationFeedbackCount;
                 ++i) {
                transform_fromhost_VkPipelineCreationFeedback(
                    resourceTracker,
                    (VkPipelineCreationFeedback*)(toTransform->pPipelineStageCreationFeedbacks +
                                                  i));
            }
        }
    }
}

void transform_tohost_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceToolProperties(VkDecoderGlobalState* resourceTracker,
                                                     VkPhysicalDeviceToolProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceToolProperties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceToolProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePrivateDataFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDevicePrivateDataFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePrivateDataFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDevicePrivateDataFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDevicePrivateDataCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkDevicePrivateDataCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDevicePrivateDataCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                      VkDevicePrivateDataCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPrivateDataSlotCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkPrivateDataSlotCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPrivateDataSlotCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkPrivateDataSlotCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryBarrier2(VkDecoderGlobalState* resourceTracker,
                                       VkMemoryBarrier2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryBarrier2(VkDecoderGlobalState* resourceTracker,
                                         VkMemoryBarrier2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferMemoryBarrier2(VkDecoderGlobalState* resourceTracker,
                                             VkBufferMemoryBarrier2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferMemoryBarrier2(VkDecoderGlobalState* resourceTracker,
                                               VkBufferMemoryBarrier2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageMemoryBarrier2(VkDecoderGlobalState* resourceTracker,
                                            VkImageMemoryBarrier2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceRange(
        resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_fromhost_VkImageMemoryBarrier2(VkDecoderGlobalState* resourceTracker,
                                              VkImageMemoryBarrier2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceRange(
        resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_tohost_VkDependencyInfo(VkDecoderGlobalState* resourceTracker,
                                       VkDependencyInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pMemoryBarriers) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->memoryBarrierCount; ++i) {
                transform_tohost_VkMemoryBarrier2(
                    resourceTracker, (VkMemoryBarrier2*)(toTransform->pMemoryBarriers + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pBufferMemoryBarriers) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bufferMemoryBarrierCount; ++i) {
                transform_tohost_VkBufferMemoryBarrier2(
                    resourceTracker,
                    (VkBufferMemoryBarrier2*)(toTransform->pBufferMemoryBarriers + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pImageMemoryBarriers) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageMemoryBarrierCount; ++i) {
                transform_tohost_VkImageMemoryBarrier2(
                    resourceTracker,
                    (VkImageMemoryBarrier2*)(toTransform->pImageMemoryBarriers + i));
            }
        }
    }
}

void transform_fromhost_VkDependencyInfo(VkDecoderGlobalState* resourceTracker,
                                         VkDependencyInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pMemoryBarriers) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->memoryBarrierCount; ++i) {
                transform_fromhost_VkMemoryBarrier2(
                    resourceTracker, (VkMemoryBarrier2*)(toTransform->pMemoryBarriers + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pBufferMemoryBarriers) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bufferMemoryBarrierCount; ++i) {
                transform_fromhost_VkBufferMemoryBarrier2(
                    resourceTracker,
                    (VkBufferMemoryBarrier2*)(toTransform->pBufferMemoryBarriers + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pImageMemoryBarriers) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageMemoryBarrierCount; ++i) {
                transform_fromhost_VkImageMemoryBarrier2(
                    resourceTracker,
                    (VkImageMemoryBarrier2*)(toTransform->pImageMemoryBarriers + i));
            }
        }
    }
}

void transform_tohost_VkSemaphoreSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                            VkSemaphoreSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                              VkSemaphoreSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCommandBufferSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                                VkCommandBufferSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCommandBufferSubmitInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkCommandBufferSubmitInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubmitInfo2(VkDecoderGlobalState* resourceTracker,
                                    VkSubmitInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pWaitSemaphoreInfos) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->waitSemaphoreInfoCount; ++i) {
                transform_tohost_VkSemaphoreSubmitInfo(
                    resourceTracker,
                    (VkSemaphoreSubmitInfo*)(toTransform->pWaitSemaphoreInfos + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pCommandBufferInfos) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->commandBufferInfoCount; ++i) {
                transform_tohost_VkCommandBufferSubmitInfo(
                    resourceTracker,
                    (VkCommandBufferSubmitInfo*)(toTransform->pCommandBufferInfos + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pSignalSemaphoreInfos) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->signalSemaphoreInfoCount; ++i) {
                transform_tohost_VkSemaphoreSubmitInfo(
                    resourceTracker,
                    (VkSemaphoreSubmitInfo*)(toTransform->pSignalSemaphoreInfos + i));
            }
        }
    }
}

void transform_fromhost_VkSubmitInfo2(VkDecoderGlobalState* resourceTracker,
                                      VkSubmitInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pWaitSemaphoreInfos) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->waitSemaphoreInfoCount; ++i) {
                transform_fromhost_VkSemaphoreSubmitInfo(
                    resourceTracker,
                    (VkSemaphoreSubmitInfo*)(toTransform->pWaitSemaphoreInfos + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pCommandBufferInfos) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->commandBufferInfoCount; ++i) {
                transform_fromhost_VkCommandBufferSubmitInfo(
                    resourceTracker,
                    (VkCommandBufferSubmitInfo*)(toTransform->pCommandBufferInfos + i));
            }
        }
    }
    if (toTransform) {
        if (toTransform->pSignalSemaphoreInfos) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->signalSemaphoreInfoCount; ++i) {
                transform_fromhost_VkSemaphoreSubmitInfo(
                    resourceTracker,
                    (VkSemaphoreSubmitInfo*)(toTransform->pSignalSemaphoreInfos + i));
            }
        }
    }
}

void transform_tohost_VkPhysicalDeviceSynchronization2Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceSynchronization2Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSynchronization2Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceSynchronization2Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceImageRobustnessFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceImageRobustnessFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImageRobustnessFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceImageRobustnessFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferCopy2(VkDecoderGlobalState* resourceTracker,
                                    VkBufferCopy2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferCopy2(VkDecoderGlobalState* resourceTracker,
                                      VkBufferCopy2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCopyBufferInfo2(VkDecoderGlobalState* resourceTracker,
                                        VkCopyBufferInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_tohost_VkBufferCopy2(resourceTracker,
                                               (VkBufferCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyBufferInfo2(VkDecoderGlobalState* resourceTracker,
                                          VkCopyBufferInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_fromhost_VkBufferCopy2(resourceTracker,
                                                 (VkBufferCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkImageCopy2(VkDecoderGlobalState* resourceTracker,
                                   VkImageCopy2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkImageCopy2(VkDecoderGlobalState* resourceTracker,
                                     VkImageCopy2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkCopyImageInfo2(VkDecoderGlobalState* resourceTracker,
                                       VkCopyImageInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_tohost_VkImageCopy2(resourceTracker,
                                              (VkImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyImageInfo2(VkDecoderGlobalState* resourceTracker,
                                         VkCopyImageInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_fromhost_VkImageCopy2(resourceTracker,
                                                (VkImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkBufferImageCopy2(VkDecoderGlobalState* resourceTracker,
                                         VkBufferImageCopy2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_fromhost_VkBufferImageCopy2(VkDecoderGlobalState* resourceTracker,
                                           VkBufferImageCopy2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_tohost_VkCopyBufferToImageInfo2(VkDecoderGlobalState* resourceTracker,
                                               VkCopyBufferToImageInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_tohost_VkBufferImageCopy2(
                    resourceTracker, (VkBufferImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyBufferToImageInfo2(VkDecoderGlobalState* resourceTracker,
                                                 VkCopyBufferToImageInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_fromhost_VkBufferImageCopy2(
                    resourceTracker, (VkBufferImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkCopyImageToBufferInfo2(VkDecoderGlobalState* resourceTracker,
                                               VkCopyImageToBufferInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_tohost_VkBufferImageCopy2(
                    resourceTracker, (VkBufferImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyImageToBufferInfo2(VkDecoderGlobalState* resourceTracker,
                                                 VkCopyImageToBufferInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_fromhost_VkBufferImageCopy2(
                    resourceTracker, (VkBufferImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkImageBlit2(VkDecoderGlobalState* resourceTracker,
                                   VkImageBlit2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->srcOffsets + i));
    }
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->dstOffsets + i));
    }
}

void transform_fromhost_VkImageBlit2(VkDecoderGlobalState* resourceTracker,
                                     VkImageBlit2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->srcOffsets + i));
    }
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->dstOffsets + i));
    }
}

void transform_tohost_VkBlitImageInfo2(VkDecoderGlobalState* resourceTracker,
                                       VkBlitImageInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_tohost_VkImageBlit2(resourceTracker,
                                              (VkImageBlit2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkBlitImageInfo2(VkDecoderGlobalState* resourceTracker,
                                         VkBlitImageInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_fromhost_VkImageBlit2(resourceTracker,
                                                (VkImageBlit2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkImageResolve2(VkDecoderGlobalState* resourceTracker,
                                      VkImageResolve2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_tohost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkImageResolve2(VkDecoderGlobalState* resourceTracker,
                                        VkImageResolve2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_fromhost_VkImageSubresourceLayers(
        resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkResolveImageInfo2(VkDecoderGlobalState* resourceTracker,
                                          VkResolveImageInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_tohost_VkImageResolve2(resourceTracker,
                                                 (VkImageResolve2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkResolveImageInfo2(VkDecoderGlobalState* resourceTracker,
                                            VkResolveImageInfo2* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i) {
                transform_fromhost_VkImageResolve2(resourceTracker,
                                                   (VkImageResolve2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkPhysicalDeviceSubgroupSizeControlFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSubgroupSizeControlFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceSubgroupSizeControlProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSubgroupSizeControlProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceInlineUniformBlockFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceInlineUniformBlockFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceInlineUniformBlockProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceInlineUniformBlockProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkWriteDescriptorSetInlineUniformBlock(
    VkDecoderGlobalState* resourceTracker, VkWriteDescriptorSetInlineUniformBlock* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkWriteDescriptorSetInlineUniformBlock(
    VkDecoderGlobalState* resourceTracker, VkWriteDescriptorSetInlineUniformBlock* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorPoolInlineUniformBlockCreateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkDescriptorPoolInlineUniformBlockCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorPoolInlineUniformBlockCreateInfo(
    VkDecoderGlobalState* resourceTracker,
    VkDescriptorPoolInlineUniformBlockCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkRenderingAttachmentInfo(VkDecoderGlobalState* resourceTracker,
                                                VkRenderingAttachmentInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkClearValue(resourceTracker, (VkClearValue*)(&toTransform->clearValue));
}

void transform_fromhost_VkRenderingAttachmentInfo(VkDecoderGlobalState* resourceTracker,
                                                  VkRenderingAttachmentInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkClearValue(resourceTracker, (VkClearValue*)(&toTransform->clearValue));
}

void transform_tohost_VkRenderingInfo(VkDecoderGlobalState* resourceTracker,
                                      VkRenderingInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->renderArea));
    if (toTransform) {
        if (toTransform->pColorAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i) {
                transform_tohost_VkRenderingAttachmentInfo(
                    resourceTracker,
                    (VkRenderingAttachmentInfo*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform->pDepthAttachment) {
        transform_tohost_VkRenderingAttachmentInfo(
            resourceTracker, (VkRenderingAttachmentInfo*)(toTransform->pDepthAttachment));
    }
    if (toTransform->pStencilAttachment) {
        transform_tohost_VkRenderingAttachmentInfo(
            resourceTracker, (VkRenderingAttachmentInfo*)(toTransform->pStencilAttachment));
    }
}

void transform_fromhost_VkRenderingInfo(VkDecoderGlobalState* resourceTracker,
                                        VkRenderingInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->renderArea));
    if (toTransform) {
        if (toTransform->pColorAttachments) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i) {
                transform_fromhost_VkRenderingAttachmentInfo(
                    resourceTracker,
                    (VkRenderingAttachmentInfo*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform->pDepthAttachment) {
        transform_fromhost_VkRenderingAttachmentInfo(
            resourceTracker, (VkRenderingAttachmentInfo*)(toTransform->pDepthAttachment));
    }
    if (toTransform->pStencilAttachment) {
        transform_fromhost_VkRenderingAttachmentInfo(
            resourceTracker, (VkRenderingAttachmentInfo*)(toTransform->pStencilAttachment));
    }
}

void transform_tohost_VkPipelineRenderingCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                    VkPipelineRenderingCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRenderingCreateInfo(VkDecoderGlobalState* resourceTracker,
                                                      VkPipelineRenderingCreateInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceDynamicRenderingFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceDynamicRenderingFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDynamicRenderingFeatures(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceDynamicRenderingFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCommandBufferInheritanceRenderingInfo(
    VkDecoderGlobalState* resourceTracker, VkCommandBufferInheritanceRenderingInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCommandBufferInheritanceRenderingInfo(
    VkDecoderGlobalState* resourceTracker, VkCommandBufferInheritanceRenderingInfo* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderIntegerDotProductProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceTexelBufferAlignmentProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentProperties(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentProperties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkFormatProperties3(VkDecoderGlobalState* resourceTracker,
                                          VkFormatProperties3* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkFormatProperties3(VkDecoderGlobalState* resourceTracker,
                                            VkFormatProperties3* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMaintenance4Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMaintenance4Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMaintenance4Features(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMaintenance4Features* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMaintenance4Properties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMaintenance4Properties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMaintenance4Properties(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceMaintenance4Properties* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceBufferMemoryRequirements(
    VkDecoderGlobalState* resourceTracker, VkDeviceBufferMemoryRequirements* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pCreateInfo) {
        transform_tohost_VkBufferCreateInfo(resourceTracker,
                                            (VkBufferCreateInfo*)(toTransform->pCreateInfo));
    }
}

void transform_fromhost_VkDeviceBufferMemoryRequirements(
    VkDecoderGlobalState* resourceTracker, VkDeviceBufferMemoryRequirements* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pCreateInfo) {
        transform_fromhost_VkBufferCreateInfo(resourceTracker,
                                              (VkBufferCreateInfo*)(toTransform->pCreateInfo));
    }
}

void transform_tohost_VkDeviceImageMemoryRequirements(
    VkDecoderGlobalState* resourceTracker, VkDeviceImageMemoryRequirements* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pCreateInfo) {
        resourceTracker->transformImpl_VkImageCreateInfo_tohost(toTransform->pCreateInfo, 1);
        transform_tohost_VkImageCreateInfo(resourceTracker,
                                           (VkImageCreateInfo*)(toTransform->pCreateInfo));
    }
}

void transform_fromhost_VkDeviceImageMemoryRequirements(
    VkDecoderGlobalState* resourceTracker, VkDeviceImageMemoryRequirements* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pCreateInfo) {
        resourceTracker->transformImpl_VkImageCreateInfo_fromhost(toTransform->pCreateInfo, 1);
        transform_fromhost_VkImageCreateInfo(resourceTracker,
                                             (VkImageCreateInfo*)(toTransform->pCreateInfo));
    }
}

#endif
#ifdef VK_KHR_surface
#endif
#ifdef VK_KHR_swapchain
#endif
#ifdef VK_KHR_xcb_surface
#endif
#ifdef VK_KHR_android_surface
#endif
#ifdef VK_KHR_win32_surface
#endif
#ifdef VK_KHR_dynamic_rendering
void transform_tohost_VkRenderingFragmentShadingRateAttachmentInfoKHR(
    VkDecoderGlobalState* resourceTracker,
    VkRenderingFragmentShadingRateAttachmentInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkExtent2D(resourceTracker,
                                (VkExtent2D*)(&toTransform->shadingRateAttachmentTexelSize));
}

void transform_fromhost_VkRenderingFragmentShadingRateAttachmentInfoKHR(
    VkDecoderGlobalState* resourceTracker,
    VkRenderingFragmentShadingRateAttachmentInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkExtent2D(resourceTracker,
                                  (VkExtent2D*)(&toTransform->shadingRateAttachmentTexelSize));
}

void transform_tohost_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    VkDecoderGlobalState* resourceTracker,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    VkDecoderGlobalState* resourceTracker,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkAttachmentSampleCountInfoAMD(VkDecoderGlobalState* resourceTracker,
                                                     VkAttachmentSampleCountInfoAMD* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkAttachmentSampleCountInfoAMD(
    VkDecoderGlobalState* resourceTracker, VkAttachmentSampleCountInfoAMD* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMultiviewPerViewAttributesInfoNVX(
    VkDecoderGlobalState* resourceTracker, VkMultiviewPerViewAttributesInfoNVX* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMultiviewPerViewAttributesInfoNVX(
    VkDecoderGlobalState* resourceTracker, VkMultiviewPerViewAttributesInfoNVX* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_KHR_get_physical_device_properties2
#endif
#ifdef VK_KHR_maintenance1
#endif
#ifdef VK_KHR_external_memory_capabilities
#endif
#ifdef VK_KHR_external_memory
#endif
#ifdef VK_KHR_external_memory_win32
#endif
#ifdef VK_KHR_external_memory_fd
#endif
#ifdef VK_KHR_external_semaphore_capabilities
#endif
#ifdef VK_KHR_external_semaphore
#endif
#ifdef VK_KHR_external_semaphore_win32
#endif
#ifdef VK_KHR_external_semaphore_fd
void transform_tohost_VkImportSemaphoreFdInfoKHR(VkDecoderGlobalState* resourceTracker,
                                                 VkImportSemaphoreFdInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImportSemaphoreFdInfoKHR(VkDecoderGlobalState* resourceTracker,
                                                   VkImportSemaphoreFdInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSemaphoreGetFdInfoKHR(VkDecoderGlobalState* resourceTracker,
                                              VkSemaphoreGetFdInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreGetFdInfoKHR(VkDecoderGlobalState* resourceTracker,
                                                VkSemaphoreGetFdInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_KHR_shader_float16_int8
#endif
#ifdef VK_KHR_incremental_present
void transform_tohost_VkRectLayerKHR(VkDecoderGlobalState* resourceTracker,
                                     VkRectLayerKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkOffset2D(resourceTracker, (VkOffset2D*)(&toTransform->offset));
    transform_tohost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->extent));
}

void transform_fromhost_VkRectLayerKHR(VkDecoderGlobalState* resourceTracker,
                                       VkRectLayerKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkOffset2D(resourceTracker, (VkOffset2D*)(&toTransform->offset));
    transform_fromhost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->extent));
}

void transform_tohost_VkPresentRegionKHR(VkDecoderGlobalState* resourceTracker,
                                         VkPresentRegionKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pRectangles) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->rectangleCount; ++i) {
                transform_tohost_VkRectLayerKHR(resourceTracker,
                                                (VkRectLayerKHR*)(toTransform->pRectangles + i));
            }
        }
    }
}

void transform_fromhost_VkPresentRegionKHR(VkDecoderGlobalState* resourceTracker,
                                           VkPresentRegionKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform) {
        if (toTransform->pRectangles) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->rectangleCount; ++i) {
                transform_fromhost_VkRectLayerKHR(resourceTracker,
                                                  (VkRectLayerKHR*)(toTransform->pRectangles + i));
            }
        }
    }
}

void transform_tohost_VkPresentRegionsKHR(VkDecoderGlobalState* resourceTracker,
                                          VkPresentRegionsKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->swapchainCount; ++i) {
                transform_tohost_VkPresentRegionKHR(
                    resourceTracker, (VkPresentRegionKHR*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkPresentRegionsKHR(VkDecoderGlobalState* resourceTracker,
                                            VkPresentRegionsKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform) {
        if (toTransform->pRegions) {
            for (uint32_t i = 0; i < (uint32_t)toTransform->swapchainCount; ++i) {
                transform_fromhost_VkPresentRegionKHR(
                    resourceTracker, (VkPresentRegionKHR*)(toTransform->pRegions + i));
            }
        }
    }
}

#endif
#ifdef VK_KHR_descriptor_update_template
#endif
#ifdef VK_KHR_imageless_framebuffer
#endif
#ifdef VK_KHR_create_renderpass2
#endif
#ifdef VK_KHR_external_fence_capabilities
#endif
#ifdef VK_KHR_external_fence
#endif
#ifdef VK_KHR_external_fence_fd
void transform_tohost_VkImportFenceFdInfoKHR(VkDecoderGlobalState* resourceTracker,
                                             VkImportFenceFdInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImportFenceFdInfoKHR(VkDecoderGlobalState* resourceTracker,
                                               VkImportFenceFdInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkFenceGetFdInfoKHR(VkDecoderGlobalState* resourceTracker,
                                          VkFenceGetFdInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkFenceGetFdInfoKHR(VkDecoderGlobalState* resourceTracker,
                                            VkFenceGetFdInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_KHR_maintenance2
#endif
#ifdef VK_KHR_dedicated_allocation
#endif
#ifdef VK_KHR_storage_buffer_storage_class
#endif
#ifdef VK_KHR_get_memory_requirements2
#endif
#ifdef VK_KHR_image_format_list
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
#endif
#ifdef VK_KHR_bind_memory2
#endif
#ifdef VK_KHR_maintenance3
#endif
#ifdef VK_KHR_shader_subgroup_extended_types
#endif
#ifdef VK_KHR_vulkan_memory_model
#endif
#ifdef VK_KHR_shader_terminate_invocation
#endif
#ifdef VK_KHR_buffer_device_address
#endif
#ifdef VK_KHR_pipeline_executable_properties
void transform_tohost_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineInfoKHR(VkDecoderGlobalState* resourceTracker,
                                        VkPipelineInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineInfoKHR(VkDecoderGlobalState* resourceTracker,
                                          VkPipelineInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineExecutablePropertiesKHR(
    VkDecoderGlobalState* resourceTracker, VkPipelineExecutablePropertiesKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineExecutablePropertiesKHR(
    VkDecoderGlobalState* resourceTracker, VkPipelineExecutablePropertiesKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineExecutableInfoKHR(VkDecoderGlobalState* resourceTracker,
                                                  VkPipelineExecutableInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineExecutableInfoKHR(VkDecoderGlobalState* resourceTracker,
                                                    VkPipelineExecutableInfoKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineExecutableStatisticValueKHR(
    VkDecoderGlobalState* resourceTracker, VkPipelineExecutableStatisticValueKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPipelineExecutableStatisticValueKHR(
    VkDecoderGlobalState* resourceTracker, VkPipelineExecutableStatisticValueKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineExecutableStatisticKHR(
    VkDecoderGlobalState* resourceTracker, VkPipelineExecutableStatisticKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkPipelineExecutableStatisticValueKHR(
        resourceTracker, (VkPipelineExecutableStatisticValueKHR*)(&toTransform->value));
}

void transform_fromhost_VkPipelineExecutableStatisticKHR(
    VkDecoderGlobalState* resourceTracker, VkPipelineExecutableStatisticKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkPipelineExecutableStatisticValueKHR(
        resourceTracker, (VkPipelineExecutableStatisticValueKHR*)(&toTransform->value));
}

void transform_tohost_VkPipelineExecutableInternalRepresentationKHR(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineExecutableInternalRepresentationKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineExecutableInternalRepresentationKHR(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineExecutableInternalRepresentationKHR* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_KHR_shader_integer_dot_product
#endif
#ifdef VK_KHR_shader_non_semantic_info
#endif
#ifdef VK_KHR_synchronization2
void transform_tohost_VkQueueFamilyCheckpointProperties2NV(
    VkDecoderGlobalState* resourceTracker, VkQueueFamilyCheckpointProperties2NV* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkQueueFamilyCheckpointProperties2NV(
    VkDecoderGlobalState* resourceTracker, VkQueueFamilyCheckpointProperties2NV* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCheckpointData2NV(VkDecoderGlobalState* resourceTracker,
                                          VkCheckpointData2NV* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCheckpointData2NV(VkDecoderGlobalState* resourceTracker,
                                            VkCheckpointData2NV* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
#endif
#ifdef VK_KHR_copy_commands2
#endif
#ifdef VK_KHR_format_feature_flags2
#endif
#ifdef VK_KHR_maintenance4
#endif
#ifdef VK_ANDROID_native_buffer
void transform_tohost_VkNativeBufferUsage2ANDROID(VkDecoderGlobalState* resourceTracker,
                                                  VkNativeBufferUsage2ANDROID* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkNativeBufferUsage2ANDROID(VkDecoderGlobalState* resourceTracker,
                                                    VkNativeBufferUsage2ANDROID* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkNativeBufferANDROID(VkDecoderGlobalState* resourceTracker,
                                            VkNativeBufferANDROID* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkNativeBufferUsage2ANDROID(
        resourceTracker, (VkNativeBufferUsage2ANDROID*)(&toTransform->usage2));
}

void transform_fromhost_VkNativeBufferANDROID(VkDecoderGlobalState* resourceTracker,
                                              VkNativeBufferANDROID* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkNativeBufferUsage2ANDROID(
        resourceTracker, (VkNativeBufferUsage2ANDROID*)(&toTransform->usage2));
}

void transform_tohost_VkSwapchainImageCreateInfoANDROID(
    VkDecoderGlobalState* resourceTracker, VkSwapchainImageCreateInfoANDROID* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSwapchainImageCreateInfoANDROID(
    VkDecoderGlobalState* resourceTracker, VkSwapchainImageCreateInfoANDROID* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePresentationPropertiesANDROID(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDevicePresentationPropertiesANDROID* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePresentationPropertiesANDROID(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDevicePresentationPropertiesANDROID* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_transform_feedback
void transform_tohost_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineRasterizationStateStreamCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineRasterizationStateStreamCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRasterizationStateStreamCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineRasterizationStateStreamCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_AMD_gpu_shader_half_float
#endif
#ifdef VK_EXT_texture_compression_astc_hdr
#endif
#ifdef VK_EXT_swapchain_colorspace
#endif
#ifdef VK_EXT_queue_family_foreign
#endif
#ifdef VK_EXT_debug_utils
#endif
#ifdef VK_ANDROID_external_memory_android_hardware_buffer
#endif
#ifdef VK_EXT_inline_uniform_block
#endif
#ifdef VK_EXT_shader_stencil_export
#endif
#ifdef VK_EXT_pipeline_creation_feedback
#endif
#ifdef VK_NV_shader_subgroup_partitioned
#endif
#ifdef VK_EXT_metal_surface
#endif
#ifdef VK_EXT_subgroup_size_control
#endif
#ifdef VK_EXT_tooling_info
#endif
#ifdef VK_EXT_provoking_vertex
void transform_tohost_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_line_rasterization
void transform_tohost_VkPhysicalDeviceLineRasterizationFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceLineRasterizationFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceLineRasterizationFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceLineRasterizationFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceLineRasterizationPropertiesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceLineRasterizationPropertiesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceLineRasterizationPropertiesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceLineRasterizationPropertiesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineRasterizationLineStateCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineRasterizationLineStateCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRasterizationLineStateCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPipelineRasterizationLineStateCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_index_type_uint8
void transform_tohost_VkPhysicalDeviceIndexTypeUint8FeaturesEXT(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceIndexTypeUint8FeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceIndexTypeUint8FeaturesEXT(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDeviceIndexTypeUint8FeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_extended_dynamic_state
void transform_tohost_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_swapchain_maintenance1
void transform_tohost_VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSwapchainPresentFenceInfoEXT(VkDecoderGlobalState* resourceTracker,
                                                     VkSwapchainPresentFenceInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSwapchainPresentFenceInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkSwapchainPresentFenceInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSwapchainPresentModesCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkSwapchainPresentModesCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSwapchainPresentModesCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkSwapchainPresentModesCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSwapchainPresentModeInfoEXT(VkDecoderGlobalState* resourceTracker,
                                                    VkSwapchainPresentModeInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSwapchainPresentModeInfoEXT(VkDecoderGlobalState* resourceTracker,
                                                      VkSwapchainPresentModeInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSwapchainPresentScalingCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkSwapchainPresentScalingCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSwapchainPresentScalingCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkSwapchainPresentScalingCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkReleaseSwapchainImagesInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkReleaseSwapchainImagesInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkReleaseSwapchainImagesInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkReleaseSwapchainImagesInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
#endif
#ifdef VK_EXT_texel_buffer_alignment
void transform_tohost_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_device_memory_report
void transform_tohost_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceMemoryReportCallbackDataEXT(
    VkDecoderGlobalState* resourceTracker, VkDeviceMemoryReportCallbackDataEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceMemoryReportCallbackDataEXT(
    VkDecoderGlobalState* resourceTracker, VkDeviceMemoryReportCallbackDataEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceDeviceMemoryReportCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkDeviceDeviceMemoryReportCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceDeviceMemoryReportCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkDeviceDeviceMemoryReportCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_custom_border_color
void transform_tohost_VkSamplerCustomBorderColorCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkSamplerCustomBorderColorCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkClearColorValue(resourceTracker,
                                       (VkClearColorValue*)(&toTransform->customBorderColor));
}

void transform_fromhost_VkSamplerCustomBorderColorCreateInfoEXT(
    VkDecoderGlobalState* resourceTracker, VkSamplerCustomBorderColorCreateInfoEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkClearColorValue(resourceTracker,
                                         (VkClearColorValue*)(&toTransform->customBorderColor));
}

void transform_tohost_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_private_data
#endif
#ifdef VK_EXT_pipeline_creation_cache_control
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void transform_tohost_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_image_robustness
#endif
#ifdef VK_EXT_image_compression_control
void transform_tohost_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageCompressionControlEXT(VkDecoderGlobalState* resourceTracker,
                                                   VkImageCompressionControlEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageCompressionControlEXT(VkDecoderGlobalState* resourceTracker,
                                                     VkImageCompressionControlEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubresourceLayout2EXT(VkDecoderGlobalState* resourceTracker,
                                              VkSubresourceLayout2EXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkSubresourceLayout(resourceTracker,
                                         (VkSubresourceLayout*)(&toTransform->subresourceLayout));
}

void transform_fromhost_VkSubresourceLayout2EXT(VkDecoderGlobalState* resourceTracker,
                                                VkSubresourceLayout2EXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkSubresourceLayout(resourceTracker,
                                           (VkSubresourceLayout*)(&toTransform->subresourceLayout));
}

void transform_tohost_VkImageSubresource2EXT(VkDecoderGlobalState* resourceTracker,
                                             VkImageSubresource2EXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresource(resourceTracker,
                                        (VkImageSubresource*)(&toTransform->imageSubresource));
}

void transform_fromhost_VkImageSubresource2EXT(VkDecoderGlobalState* resourceTracker,
                                               VkImageSubresource2EXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresource(resourceTracker,
                                          (VkImageSubresource*)(&toTransform->imageSubresource));
}

void transform_tohost_VkImageCompressionPropertiesEXT(
    VkDecoderGlobalState* resourceTracker, VkImageCompressionPropertiesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageCompressionPropertiesEXT(
    VkDecoderGlobalState* resourceTracker, VkImageCompressionPropertiesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_4444_formats
void transform_tohost_VkPhysicalDevice4444FormatsFeaturesEXT(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDevice4444FormatsFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevice4444FormatsFeaturesEXT(
    VkDecoderGlobalState* resourceTracker, VkPhysicalDevice4444FormatsFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void transform_tohost_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_extended_dynamic_state2
void transform_tohost_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_GOOGLE_gfxstream
void transform_tohost_VkImportColorBufferGOOGLE(VkDecoderGlobalState* resourceTracker,
                                                VkImportColorBufferGOOGLE* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImportColorBufferGOOGLE(VkDecoderGlobalState* resourceTracker,
                                                  VkImportColorBufferGOOGLE* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImportBufferGOOGLE(VkDecoderGlobalState* resourceTracker,
                                           VkImportBufferGOOGLE* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImportBufferGOOGLE(VkDecoderGlobalState* resourceTracker,
                                             VkImportBufferGOOGLE* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCreateBlobGOOGLE(VkDecoderGlobalState* resourceTracker,
                                         VkCreateBlobGOOGLE* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCreateBlobGOOGLE(VkDecoderGlobalState* resourceTracker,
                                           VkCreateBlobGOOGLE* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_load_store_op_none
#endif
#ifdef VK_EXT_image_compression_control_swapchain
void transform_tohost_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    VkDecoderGlobalState* resourceTracker,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* toTransform) {
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext) {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
void transform_tohost_extension_struct(VkDecoderGlobalState* resourceTracker,
                                       void* structExtension_out) {
    if (!structExtension_out) {
        return;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension_out);
    switch (structType) {
#ifdef VK_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: {
            transform_tohost_VkShaderModuleCreateInfo(
                resourceTracker, reinterpret_cast<VkShaderModuleCreateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceSubgroupProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceSubgroupProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: {
            transform_tohost_VkPhysicalDevice16BitStorageFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevice16BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: {
            transform_tohost_VkMemoryDedicatedRequirements(
                resourceTracker,
                reinterpret_cast<VkMemoryDedicatedRequirements*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: {
            transform_tohost_VkMemoryDedicatedAllocateInfo(
                resourceTracker,
                reinterpret_cast<VkMemoryDedicatedAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: {
            transform_tohost_VkMemoryAllocateFlagsInfo(
                resourceTracker, reinterpret_cast<VkMemoryAllocateFlagsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: {
            transform_tohost_VkDeviceGroupRenderPassBeginInfo(
                resourceTracker,
                reinterpret_cast<VkDeviceGroupRenderPassBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: {
            transform_tohost_VkDeviceGroupCommandBufferBeginInfo(
                resourceTracker,
                reinterpret_cast<VkDeviceGroupCommandBufferBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: {
            transform_tohost_VkDeviceGroupSubmitInfo(
                resourceTracker, reinterpret_cast<VkDeviceGroupSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: {
            transform_tohost_VkDeviceGroupBindSparseInfo(
                resourceTracker,
                reinterpret_cast<VkDeviceGroupBindSparseInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: {
            transform_tohost_VkBindBufferMemoryDeviceGroupInfo(
                resourceTracker,
                reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: {
            transform_tohost_VkBindImageMemoryDeviceGroupInfo(
                resourceTracker,
                reinterpret_cast<VkBindImageMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: {
            transform_tohost_VkDeviceGroupDeviceCreateInfo(
                resourceTracker,
                reinterpret_cast<VkDeviceGroupDeviceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: {
            transform_tohost_VkPhysicalDeviceFeatures2(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceFeatures2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: {
            transform_tohost_VkPhysicalDevicePointClippingProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevicePointClippingProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: {
            transform_tohost_VkRenderPassInputAttachmentAspectCreateInfo(
                resourceTracker, reinterpret_cast<VkRenderPassInputAttachmentAspectCreateInfo*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: {
            transform_tohost_VkImageViewUsageCreateInfo(
                resourceTracker,
                reinterpret_cast<VkImageViewUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: {
            transform_tohost_VkPipelineTessellationDomainOriginStateCreateInfo(
                resourceTracker,
                reinterpret_cast<VkPipelineTessellationDomainOriginStateCreateInfo*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: {
            transform_tohost_VkRenderPassMultiviewCreateInfo(
                resourceTracker,
                reinterpret_cast<VkRenderPassMultiviewCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: {
            transform_tohost_VkPhysicalDeviceMultiviewFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceMultiviewFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceMultiviewProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceMultiviewProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: {
            transform_tohost_VkPhysicalDeviceVariablePointersFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVariablePointersFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: {
            transform_tohost_VkPhysicalDeviceProtectedMemoryFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceProtectedMemoryProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceProtectedMemoryProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: {
            transform_tohost_VkProtectedSubmitInfo(
                resourceTracker, reinterpret_cast<VkProtectedSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: {
            transform_tohost_VkSamplerYcbcrConversionInfo(
                resourceTracker,
                reinterpret_cast<VkSamplerYcbcrConversionInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: {
            transform_tohost_VkBindImagePlaneMemoryInfo(
                resourceTracker,
                reinterpret_cast<VkBindImagePlaneMemoryInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: {
            transform_tohost_VkImagePlaneMemoryRequirementsInfo(
                resourceTracker,
                reinterpret_cast<VkImagePlaneMemoryRequirementsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: {
            transform_tohost_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: {
            transform_tohost_VkSamplerYcbcrConversionImageFormatProperties(
                resourceTracker, reinterpret_cast<VkSamplerYcbcrConversionImageFormatProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: {
            resourceTracker->transformImpl_VkPhysicalDeviceExternalImageFormatInfo_tohost(
                reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out), 1);
            transform_tohost_VkPhysicalDeviceExternalImageFormatInfo(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: {
            resourceTracker->transformImpl_VkExternalImageFormatProperties_tohost(
                reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out), 1);
            transform_tohost_VkExternalImageFormatProperties(
                resourceTracker,
                reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceIDProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceIDProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: {
            resourceTracker->transformImpl_VkExternalMemoryImageCreateInfo_tohost(
                reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out), 1);
            transform_tohost_VkExternalMemoryImageCreateInfo(
                resourceTracker,
                reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: {
            resourceTracker->transformImpl_VkExternalMemoryBufferCreateInfo_tohost(
                reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out), 1);
            transform_tohost_VkExternalMemoryBufferCreateInfo(
                resourceTracker,
                reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: {
            resourceTracker->transformImpl_VkExportMemoryAllocateInfo_tohost(
                reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out), 1);
            transform_tohost_VkExportMemoryAllocateInfo(
                resourceTracker,
                reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: {
            transform_tohost_VkExportFenceCreateInfo(
                resourceTracker, reinterpret_cast<VkExportFenceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: {
            transform_tohost_VkExportSemaphoreCreateInfo(
                resourceTracker,
                reinterpret_cast<VkExportSemaphoreCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceMaintenance3Properties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceMaintenance3Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: {
            transform_tohost_VkPhysicalDeviceShaderDrawParametersFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderDrawParametersFeatures*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: {
            transform_tohost_VkPhysicalDeviceVulkan11Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan11Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceVulkan11Properties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan11Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: {
            transform_tohost_VkPhysicalDeviceVulkan12Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan12Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceVulkan12Properties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan12Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: {
            transform_tohost_VkImageFormatListCreateInfo(
                resourceTracker,
                reinterpret_cast<VkImageFormatListCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: {
            transform_tohost_VkPhysicalDevice8BitStorageFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevice8BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceDriverProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceDriverProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: {
            transform_tohost_VkPhysicalDeviceShaderAtomicInt64Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: {
            transform_tohost_VkPhysicalDeviceShaderFloat16Int8Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceFloatControlsProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceFloatControlsProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: {
            transform_tohost_VkDescriptorSetLayoutBindingFlagsCreateInfo(
                resourceTracker, reinterpret_cast<VkDescriptorSetLayoutBindingFlagsCreateInfo*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: {
            transform_tohost_VkPhysicalDeviceDescriptorIndexingFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceDescriptorIndexingProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceDescriptorIndexingProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: {
            transform_tohost_VkDescriptorSetVariableDescriptorCountAllocateInfo(
                resourceTracker,
                reinterpret_cast<VkDescriptorSetVariableDescriptorCountAllocateInfo*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: {
            transform_tohost_VkDescriptorSetVariableDescriptorCountLayoutSupport(
                resourceTracker,
                reinterpret_cast<VkDescriptorSetVariableDescriptorCountLayoutSupport*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: {
            transform_tohost_VkSubpassDescriptionDepthStencilResolve(
                resourceTracker,
                reinterpret_cast<VkSubpassDescriptionDepthStencilResolve*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceDepthStencilResolveProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceDepthStencilResolveProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: {
            transform_tohost_VkPhysicalDeviceScalarBlockLayoutFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: {
            transform_tohost_VkImageStencilUsageCreateInfo(
                resourceTracker,
                reinterpret_cast<VkImageStencilUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: {
            transform_tohost_VkSamplerReductionModeCreateInfo(
                resourceTracker,
                reinterpret_cast<VkSamplerReductionModeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceSamplerFilterMinmaxProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceSamplerFilterMinmaxProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: {
            transform_tohost_VkPhysicalDeviceVulkanMemoryModelFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: {
            transform_tohost_VkPhysicalDeviceImagelessFramebufferFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceImagelessFramebufferFeatures*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: {
            transform_tohost_VkFramebufferAttachmentsCreateInfo(
                resourceTracker,
                reinterpret_cast<VkFramebufferAttachmentsCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: {
            transform_tohost_VkRenderPassAttachmentBeginInfo(
                resourceTracker,
                reinterpret_cast<VkRenderPassAttachmentBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: {
            transform_tohost_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: {
            transform_tohost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: {
            transform_tohost_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: {
            transform_tohost_VkAttachmentReferenceStencilLayout(
                resourceTracker,
                reinterpret_cast<VkAttachmentReferenceStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: {
            transform_tohost_VkAttachmentDescriptionStencilLayout(
                resourceTracker,
                reinterpret_cast<VkAttachmentDescriptionStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: {
            transform_tohost_VkPhysicalDeviceHostQueryResetFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceHostQueryResetFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: {
            transform_tohost_VkPhysicalDeviceTimelineSemaphoreFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceTimelineSemaphoreProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: {
            transform_tohost_VkSemaphoreTypeCreateInfo(
                resourceTracker, reinterpret_cast<VkSemaphoreTypeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: {
            transform_tohost_VkTimelineSemaphoreSubmitInfo(
                resourceTracker,
                reinterpret_cast<VkTimelineSemaphoreSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: {
            transform_tohost_VkPhysicalDeviceBufferDeviceAddressFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceBufferDeviceAddressFeatures*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: {
            transform_tohost_VkBufferOpaqueCaptureAddressCreateInfo(
                resourceTracker,
                reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: {
            transform_tohost_VkMemoryOpaqueCaptureAddressAllocateInfo(
                resourceTracker,
                reinterpret_cast<VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: {
            transform_tohost_VkPhysicalDeviceVulkan13Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan13Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceVulkan13Properties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan13Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO: {
            transform_tohost_VkPipelineCreationFeedbackCreateInfo(
                resourceTracker,
                reinterpret_cast<VkPipelineCreationFeedbackCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES: {
            transform_tohost_VkPhysicalDeviceShaderTerminateInvocationFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderTerminateInvocationFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES: {
            transform_tohost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: {
            transform_tohost_VkPhysicalDevicePrivateDataFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevicePrivateDataFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO: {
            transform_tohost_VkDevicePrivateDataCreateInfo(
                resourceTracker,
                reinterpret_cast<VkDevicePrivateDataCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES: {
            transform_tohost_VkPhysicalDevicePipelineCreationCacheControlFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevicePipelineCreationCacheControlFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2: {
            transform_tohost_VkMemoryBarrier2(
                resourceTracker, reinterpret_cast<VkMemoryBarrier2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES: {
            transform_tohost_VkPhysicalDeviceSynchronization2Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceSynchronization2Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES: {
            transform_tohost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES: {
            transform_tohost_VkPhysicalDeviceImageRobustnessFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceImageRobustnessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES: {
            transform_tohost_VkPhysicalDeviceSubgroupSizeControlFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlFeatures*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceSubgroupSizeControlProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO: {
            transform_tohost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
                resourceTracker,
                reinterpret_cast<VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES: {
            transform_tohost_VkPhysicalDeviceInlineUniformBlockFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceInlineUniformBlockProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceInlineUniformBlockProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK: {
            transform_tohost_VkWriteDescriptorSetInlineUniformBlock(
                resourceTracker,
                reinterpret_cast<VkWriteDescriptorSetInlineUniformBlock*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO: {
            transform_tohost_VkDescriptorPoolInlineUniformBlockCreateInfo(
                resourceTracker, reinterpret_cast<VkDescriptorPoolInlineUniformBlockCreateInfo*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES: {
            transform_tohost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO: {
            transform_tohost_VkPipelineRenderingCreateInfo(
                resourceTracker,
                reinterpret_cast<VkPipelineRenderingCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES: {
            transform_tohost_VkPhysicalDeviceDynamicRenderingFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO: {
            transform_tohost_VkCommandBufferInheritanceRenderingInfo(
                resourceTracker,
                reinterpret_cast<VkCommandBufferInheritanceRenderingInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES: {
            transform_tohost_VkPhysicalDeviceShaderIntegerDotProductFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductFeatures*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceShaderIntegerDotProductProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductProperties*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceTexelBufferAlignmentProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3: {
            transform_tohost_VkFormatProperties3(
                resourceTracker, reinterpret_cast<VkFormatProperties3*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES: {
            transform_tohost_VkPhysicalDeviceMaintenance4Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceMaintenance4Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES: {
            transform_tohost_VkPhysicalDeviceMaintenance4Properties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceMaintenance4Properties*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_dynamic_rendering
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: {
            transform_tohost_VkRenderingFragmentShadingRateAttachmentInfoKHR(
                resourceTracker, reinterpret_cast<VkRenderingFragmentShadingRateAttachmentInfoKHR*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT: {
            transform_tohost_VkRenderingFragmentDensityMapAttachmentInfoEXT(
                resourceTracker, reinterpret_cast<VkRenderingFragmentDensityMapAttachmentInfoEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD: {
            transform_tohost_VkAttachmentSampleCountInfoAMD(
                resourceTracker,
                reinterpret_cast<VkAttachmentSampleCountInfoAMD*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX: {
            transform_tohost_VkMultiviewPerViewAttributesInfoNVX(
                resourceTracker,
                reinterpret_cast<VkMultiviewPerViewAttributesInfoNVX*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: {
            transform_tohost_VkPresentRegionsKHR(
                resourceTracker, reinterpret_cast<VkPresentRegionsKHR*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: {
            transform_tohost_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(
                    structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_synchronization2
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV: {
            transform_tohost_VkQueueFamilyCheckpointProperties2NV(
                resourceTracker,
                reinterpret_cast<VkQueueFamilyCheckpointProperties2NV*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID: {
            transform_tohost_VkNativeBufferANDROID(
                resourceTracker, reinterpret_cast<VkNativeBufferANDROID*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT: {
            transform_tohost_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: {
            transform_tohost_VkPipelineRasterizationStateStreamCreateInfoEXT(
                resourceTracker, reinterpret_cast<VkPipelineRasterizationStateStreamCreateInfoEXT*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceProvokingVertexFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT: {
            transform_tohost_VkPhysicalDeviceProvokingVertexPropertiesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceProvokingVertexPropertiesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT: {
            transform_tohost_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
                resourceTracker,
                reinterpret_cast<VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(
                    structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_line_rasterization
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceLineRasterizationFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceLineRasterizationFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT: {
            transform_tohost_VkPhysicalDeviceLineRasterizationPropertiesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceLineRasterizationPropertiesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT: {
            transform_tohost_VkPipelineRasterizationLineStateCreateInfoEXT(
                resourceTracker, reinterpret_cast<VkPipelineRasterizationLineStateCreateInfoEXT*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_index_type_uint8
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceIndexTypeUint8FeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceIndexTypeUint8FeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_swapchain_maintenance1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT: {
            transform_tohost_VkSwapchainPresentFenceInfoEXT(
                resourceTracker,
                reinterpret_cast<VkSwapchainPresentFenceInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT: {
            transform_tohost_VkSwapchainPresentModesCreateInfoEXT(
                resourceTracker,
                reinterpret_cast<VkSwapchainPresentModesCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT: {
            transform_tohost_VkSwapchainPresentModeInfoEXT(
                resourceTracker,
                reinterpret_cast<VkSwapchainPresentModeInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT: {
            transform_tohost_VkSwapchainPresentScalingCreateInfoEXT(
                resourceTracker,
                reinterpret_cast<VkSwapchainPresentScalingCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: {
            transform_tohost_VkDeviceDeviceMemoryReportCreateInfoEXT(
                resourceTracker,
                reinterpret_cast<VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: {
            transform_tohost_VkSamplerCustomBorderColorCreateInfoEXT(
                resourceTracker,
                reinterpret_cast<VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT: {
            transform_tohost_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(
                    structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT: {
            transform_tohost_VkImageCompressionControlEXT(
                resourceTracker,
                reinterpret_cast<VkImageCompressionControlEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT: {
            transform_tohost_VkImageCompressionPropertiesEXT(
                resourceTracker,
                reinterpret_cast<VkImageCompressionPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: {
            transform_tohost_VkPhysicalDevice4444FormatsFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: {
            transform_tohost_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(
                    structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(
                    structExtension_out));
            break;
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE: {
            transform_tohost_VkImportColorBufferGOOGLE(
                resourceTracker, reinterpret_cast<VkImportColorBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE: {
            transform_tohost_VkImportBufferGOOGLE(
                resourceTracker, reinterpret_cast<VkImportBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE: {
            transform_tohost_VkCreateBlobGOOGLE(
                resourceTracker, reinterpret_cast<VkCreateBlobGOOGLE*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT: {
            transform_tohost_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(
                    structExtension_out));
            break;
        }
#endif
        default: {
            return;
        }
    }
}

void transform_fromhost_extension_struct(VkDecoderGlobalState* resourceTracker,
                                         void* structExtension_out) {
    if (!structExtension_out) {
        return;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension_out);
    switch (structType) {
#ifdef VK_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: {
            transform_fromhost_VkShaderModuleCreateInfo(
                resourceTracker, reinterpret_cast<VkShaderModuleCreateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceSubgroupProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceSubgroupProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: {
            transform_fromhost_VkPhysicalDevice16BitStorageFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevice16BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: {
            transform_fromhost_VkMemoryDedicatedRequirements(
                resourceTracker,
                reinterpret_cast<VkMemoryDedicatedRequirements*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: {
            transform_fromhost_VkMemoryDedicatedAllocateInfo(
                resourceTracker,
                reinterpret_cast<VkMemoryDedicatedAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: {
            transform_fromhost_VkMemoryAllocateFlagsInfo(
                resourceTracker, reinterpret_cast<VkMemoryAllocateFlagsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: {
            transform_fromhost_VkDeviceGroupRenderPassBeginInfo(
                resourceTracker,
                reinterpret_cast<VkDeviceGroupRenderPassBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: {
            transform_fromhost_VkDeviceGroupCommandBufferBeginInfo(
                resourceTracker,
                reinterpret_cast<VkDeviceGroupCommandBufferBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: {
            transform_fromhost_VkDeviceGroupSubmitInfo(
                resourceTracker, reinterpret_cast<VkDeviceGroupSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: {
            transform_fromhost_VkDeviceGroupBindSparseInfo(
                resourceTracker,
                reinterpret_cast<VkDeviceGroupBindSparseInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: {
            transform_fromhost_VkBindBufferMemoryDeviceGroupInfo(
                resourceTracker,
                reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: {
            transform_fromhost_VkBindImageMemoryDeviceGroupInfo(
                resourceTracker,
                reinterpret_cast<VkBindImageMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: {
            transform_fromhost_VkDeviceGroupDeviceCreateInfo(
                resourceTracker,
                reinterpret_cast<VkDeviceGroupDeviceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: {
            transform_fromhost_VkPhysicalDeviceFeatures2(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceFeatures2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: {
            transform_fromhost_VkPhysicalDevicePointClippingProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevicePointClippingProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: {
            transform_fromhost_VkRenderPassInputAttachmentAspectCreateInfo(
                resourceTracker, reinterpret_cast<VkRenderPassInputAttachmentAspectCreateInfo*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: {
            transform_fromhost_VkImageViewUsageCreateInfo(
                resourceTracker,
                reinterpret_cast<VkImageViewUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: {
            transform_fromhost_VkPipelineTessellationDomainOriginStateCreateInfo(
                resourceTracker,
                reinterpret_cast<VkPipelineTessellationDomainOriginStateCreateInfo*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: {
            transform_fromhost_VkRenderPassMultiviewCreateInfo(
                resourceTracker,
                reinterpret_cast<VkRenderPassMultiviewCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: {
            transform_fromhost_VkPhysicalDeviceMultiviewFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceMultiviewFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceMultiviewProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceMultiviewProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: {
            transform_fromhost_VkPhysicalDeviceVariablePointersFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVariablePointersFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: {
            transform_fromhost_VkPhysicalDeviceProtectedMemoryFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceProtectedMemoryProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceProtectedMemoryProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: {
            transform_fromhost_VkProtectedSubmitInfo(
                resourceTracker, reinterpret_cast<VkProtectedSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: {
            transform_fromhost_VkSamplerYcbcrConversionInfo(
                resourceTracker,
                reinterpret_cast<VkSamplerYcbcrConversionInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: {
            transform_fromhost_VkBindImagePlaneMemoryInfo(
                resourceTracker,
                reinterpret_cast<VkBindImagePlaneMemoryInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: {
            transform_fromhost_VkImagePlaneMemoryRequirementsInfo(
                resourceTracker,
                reinterpret_cast<VkImagePlaneMemoryRequirementsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: {
            transform_fromhost_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: {
            transform_fromhost_VkSamplerYcbcrConversionImageFormatProperties(
                resourceTracker, reinterpret_cast<VkSamplerYcbcrConversionImageFormatProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: {
            resourceTracker->transformImpl_VkPhysicalDeviceExternalImageFormatInfo_fromhost(
                reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out), 1);
            transform_fromhost_VkPhysicalDeviceExternalImageFormatInfo(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: {
            resourceTracker->transformImpl_VkExternalImageFormatProperties_fromhost(
                reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out), 1);
            transform_fromhost_VkExternalImageFormatProperties(
                resourceTracker,
                reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceIDProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceIDProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: {
            resourceTracker->transformImpl_VkExternalMemoryImageCreateInfo_fromhost(
                reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out), 1);
            transform_fromhost_VkExternalMemoryImageCreateInfo(
                resourceTracker,
                reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: {
            resourceTracker->transformImpl_VkExternalMemoryBufferCreateInfo_fromhost(
                reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out), 1);
            transform_fromhost_VkExternalMemoryBufferCreateInfo(
                resourceTracker,
                reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: {
            resourceTracker->transformImpl_VkExportMemoryAllocateInfo_fromhost(
                reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out), 1);
            transform_fromhost_VkExportMemoryAllocateInfo(
                resourceTracker,
                reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: {
            transform_fromhost_VkExportFenceCreateInfo(
                resourceTracker, reinterpret_cast<VkExportFenceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: {
            transform_fromhost_VkExportSemaphoreCreateInfo(
                resourceTracker,
                reinterpret_cast<VkExportSemaphoreCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceMaintenance3Properties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceMaintenance3Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: {
            transform_fromhost_VkPhysicalDeviceShaderDrawParametersFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderDrawParametersFeatures*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: {
            transform_fromhost_VkPhysicalDeviceVulkan11Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan11Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceVulkan11Properties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan11Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: {
            transform_fromhost_VkPhysicalDeviceVulkan12Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan12Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceVulkan12Properties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan12Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: {
            transform_fromhost_VkImageFormatListCreateInfo(
                resourceTracker,
                reinterpret_cast<VkImageFormatListCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: {
            transform_fromhost_VkPhysicalDevice8BitStorageFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevice8BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceDriverProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceDriverProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: {
            transform_fromhost_VkPhysicalDeviceShaderAtomicInt64Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: {
            transform_fromhost_VkPhysicalDeviceShaderFloat16Int8Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceFloatControlsProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceFloatControlsProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: {
            transform_fromhost_VkDescriptorSetLayoutBindingFlagsCreateInfo(
                resourceTracker, reinterpret_cast<VkDescriptorSetLayoutBindingFlagsCreateInfo*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: {
            transform_fromhost_VkPhysicalDeviceDescriptorIndexingFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceDescriptorIndexingProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceDescriptorIndexingProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: {
            transform_fromhost_VkDescriptorSetVariableDescriptorCountAllocateInfo(
                resourceTracker,
                reinterpret_cast<VkDescriptorSetVariableDescriptorCountAllocateInfo*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: {
            transform_fromhost_VkDescriptorSetVariableDescriptorCountLayoutSupport(
                resourceTracker,
                reinterpret_cast<VkDescriptorSetVariableDescriptorCountLayoutSupport*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: {
            transform_fromhost_VkSubpassDescriptionDepthStencilResolve(
                resourceTracker,
                reinterpret_cast<VkSubpassDescriptionDepthStencilResolve*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceDepthStencilResolveProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceDepthStencilResolveProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: {
            transform_fromhost_VkPhysicalDeviceScalarBlockLayoutFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: {
            transform_fromhost_VkImageStencilUsageCreateInfo(
                resourceTracker,
                reinterpret_cast<VkImageStencilUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: {
            transform_fromhost_VkSamplerReductionModeCreateInfo(
                resourceTracker,
                reinterpret_cast<VkSamplerReductionModeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceSamplerFilterMinmaxProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceSamplerFilterMinmaxProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: {
            transform_fromhost_VkPhysicalDeviceVulkanMemoryModelFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: {
            transform_fromhost_VkPhysicalDeviceImagelessFramebufferFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceImagelessFramebufferFeatures*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: {
            transform_fromhost_VkFramebufferAttachmentsCreateInfo(
                resourceTracker,
                reinterpret_cast<VkFramebufferAttachmentsCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: {
            transform_fromhost_VkRenderPassAttachmentBeginInfo(
                resourceTracker,
                reinterpret_cast<VkRenderPassAttachmentBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: {
            transform_fromhost_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: {
            transform_fromhost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: {
            transform_fromhost_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: {
            transform_fromhost_VkAttachmentReferenceStencilLayout(
                resourceTracker,
                reinterpret_cast<VkAttachmentReferenceStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: {
            transform_fromhost_VkAttachmentDescriptionStencilLayout(
                resourceTracker,
                reinterpret_cast<VkAttachmentDescriptionStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: {
            transform_fromhost_VkPhysicalDeviceHostQueryResetFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceHostQueryResetFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: {
            transform_fromhost_VkPhysicalDeviceTimelineSemaphoreFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceTimelineSemaphoreProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: {
            transform_fromhost_VkSemaphoreTypeCreateInfo(
                resourceTracker, reinterpret_cast<VkSemaphoreTypeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: {
            transform_fromhost_VkTimelineSemaphoreSubmitInfo(
                resourceTracker,
                reinterpret_cast<VkTimelineSemaphoreSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: {
            transform_fromhost_VkPhysicalDeviceBufferDeviceAddressFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceBufferDeviceAddressFeatures*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: {
            transform_fromhost_VkBufferOpaqueCaptureAddressCreateInfo(
                resourceTracker,
                reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: {
            transform_fromhost_VkMemoryOpaqueCaptureAddressAllocateInfo(
                resourceTracker,
                reinterpret_cast<VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: {
            transform_fromhost_VkPhysicalDeviceVulkan13Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan13Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceVulkan13Properties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceVulkan13Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO: {
            transform_fromhost_VkPipelineCreationFeedbackCreateInfo(
                resourceTracker,
                reinterpret_cast<VkPipelineCreationFeedbackCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES: {
            transform_fromhost_VkPhysicalDeviceShaderTerminateInvocationFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderTerminateInvocationFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES: {
            transform_fromhost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: {
            transform_fromhost_VkPhysicalDevicePrivateDataFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevicePrivateDataFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO: {
            transform_fromhost_VkDevicePrivateDataCreateInfo(
                resourceTracker,
                reinterpret_cast<VkDevicePrivateDataCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES: {
            transform_fromhost_VkPhysicalDevicePipelineCreationCacheControlFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevicePipelineCreationCacheControlFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2: {
            transform_fromhost_VkMemoryBarrier2(
                resourceTracker, reinterpret_cast<VkMemoryBarrier2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES: {
            transform_fromhost_VkPhysicalDeviceSynchronization2Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceSynchronization2Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES: {
            transform_fromhost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES: {
            transform_fromhost_VkPhysicalDeviceImageRobustnessFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceImageRobustnessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES: {
            transform_fromhost_VkPhysicalDeviceSubgroupSizeControlFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlFeatures*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceSubgroupSizeControlProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO: {
            transform_fromhost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
                resourceTracker,
                reinterpret_cast<VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES: {
            transform_fromhost_VkPhysicalDeviceInlineUniformBlockFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceInlineUniformBlockProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceInlineUniformBlockProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK: {
            transform_fromhost_VkWriteDescriptorSetInlineUniformBlock(
                resourceTracker,
                reinterpret_cast<VkWriteDescriptorSetInlineUniformBlock*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO: {
            transform_fromhost_VkDescriptorPoolInlineUniformBlockCreateInfo(
                resourceTracker, reinterpret_cast<VkDescriptorPoolInlineUniformBlockCreateInfo*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES: {
            transform_fromhost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO: {
            transform_fromhost_VkPipelineRenderingCreateInfo(
                resourceTracker,
                reinterpret_cast<VkPipelineRenderingCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES: {
            transform_fromhost_VkPhysicalDeviceDynamicRenderingFeatures(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO: {
            transform_fromhost_VkCommandBufferInheritanceRenderingInfo(
                resourceTracker,
                reinterpret_cast<VkCommandBufferInheritanceRenderingInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES: {
            transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductFeatures(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductFeatures*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductProperties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductProperties*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentProperties(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentProperties*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3: {
            transform_fromhost_VkFormatProperties3(
                resourceTracker, reinterpret_cast<VkFormatProperties3*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES: {
            transform_fromhost_VkPhysicalDeviceMaintenance4Features(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceMaintenance4Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES: {
            transform_fromhost_VkPhysicalDeviceMaintenance4Properties(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceMaintenance4Properties*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_dynamic_rendering
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: {
            transform_fromhost_VkRenderingFragmentShadingRateAttachmentInfoKHR(
                resourceTracker, reinterpret_cast<VkRenderingFragmentShadingRateAttachmentInfoKHR*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT: {
            transform_fromhost_VkRenderingFragmentDensityMapAttachmentInfoEXT(
                resourceTracker, reinterpret_cast<VkRenderingFragmentDensityMapAttachmentInfoEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD: {
            transform_fromhost_VkAttachmentSampleCountInfoAMD(
                resourceTracker,
                reinterpret_cast<VkAttachmentSampleCountInfoAMD*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX: {
            transform_fromhost_VkMultiviewPerViewAttributesInfoNVX(
                resourceTracker,
                reinterpret_cast<VkMultiviewPerViewAttributesInfoNVX*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: {
            transform_fromhost_VkPresentRegionsKHR(
                resourceTracker, reinterpret_cast<VkPresentRegionsKHR*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: {
            transform_fromhost_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(
                    structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_synchronization2
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV: {
            transform_fromhost_VkQueueFamilyCheckpointProperties2NV(
                resourceTracker,
                reinterpret_cast<VkQueueFamilyCheckpointProperties2NV*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID: {
            transform_fromhost_VkNativeBufferANDROID(
                resourceTracker, reinterpret_cast<VkNativeBufferANDROID*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT: {
            transform_fromhost_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: {
            transform_fromhost_VkPipelineRasterizationStateStreamCreateInfoEXT(
                resourceTracker, reinterpret_cast<VkPipelineRasterizationStateStreamCreateInfoEXT*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceProvokingVertexFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT: {
            transform_fromhost_VkPhysicalDeviceProvokingVertexPropertiesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceProvokingVertexPropertiesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT: {
            transform_fromhost_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
                resourceTracker,
                reinterpret_cast<VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(
                    structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_line_rasterization
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceLineRasterizationFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceLineRasterizationFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT: {
            transform_fromhost_VkPhysicalDeviceLineRasterizationPropertiesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceLineRasterizationPropertiesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT: {
            transform_fromhost_VkPipelineRasterizationLineStateCreateInfoEXT(
                resourceTracker, reinterpret_cast<VkPipelineRasterizationLineStateCreateInfoEXT*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_index_type_uint8
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceIndexTypeUint8FeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceIndexTypeUint8FeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_swapchain_maintenance1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT: {
            transform_fromhost_VkSwapchainPresentFenceInfoEXT(
                resourceTracker,
                reinterpret_cast<VkSwapchainPresentFenceInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT: {
            transform_fromhost_VkSwapchainPresentModesCreateInfoEXT(
                resourceTracker,
                reinterpret_cast<VkSwapchainPresentModesCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT: {
            transform_fromhost_VkSwapchainPresentModeInfoEXT(
                resourceTracker,
                reinterpret_cast<VkSwapchainPresentModeInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT: {
            transform_fromhost_VkSwapchainPresentScalingCreateInfoEXT(
                resourceTracker,
                reinterpret_cast<VkSwapchainPresentScalingCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: {
            transform_fromhost_VkDeviceDeviceMemoryReportCreateInfoEXT(
                resourceTracker,
                reinterpret_cast<VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: {
            transform_fromhost_VkSamplerCustomBorderColorCreateInfoEXT(
                resourceTracker,
                reinterpret_cast<VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT: {
            transform_fromhost_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(
                                     structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
                resourceTracker, reinterpret_cast<VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(
                                     structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(
                    structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(
                    structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT: {
            transform_fromhost_VkImageCompressionControlEXT(
                resourceTracker,
                reinterpret_cast<VkImageCompressionControlEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT: {
            transform_fromhost_VkImageCompressionPropertiesEXT(
                resourceTracker,
                reinterpret_cast<VkImageCompressionPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDevice4444FormatsFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(
                    structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(
                    structExtension_out));
            break;
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE: {
            transform_fromhost_VkImportColorBufferGOOGLE(
                resourceTracker, reinterpret_cast<VkImportColorBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE: {
            transform_fromhost_VkImportBufferGOOGLE(
                resourceTracker, reinterpret_cast<VkImportBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE: {
            transform_fromhost_VkCreateBlobGOOGLE(
                resourceTracker, reinterpret_cast<VkCreateBlobGOOGLE*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT: {
            transform_fromhost_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
                resourceTracker,
                reinterpret_cast<VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(
                    structExtension_out));
            break;
        }
#endif
        default: {
            return;
        }
    }
}

}  // namespace vk
}  // namespace gfxstream
