/* util-string.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-string.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* GLib's character-based substring function.*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "geary-engine.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

gchar* g_utf8_substring (const gchar* str,
                         glong start_pos,
                         glong end_pos);
static gboolean _vala_unichar_array_contains (gunichar * stack,
                                       gssize stack_length,
                                       const gunichar needle);

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gboolean
geary_string_is_empty_or_whitespace (const gchar* str)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (str == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = string_get (str, (glong) 0) == GEARY_STRING_EOS;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = string_strip (str);
		_tmp3_ = _tmp2_;
		_tmp0_ = string_get (_tmp3_, (glong) 0) == GEARY_STRING_EOS;
		_g_free0 (_tmp3_);
	}
	result = _tmp0_;
	return result;
}

inline gboolean
geary_string_is_empty (const gchar* str)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (str == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = string_get (str, (glong) 0) == GEARY_STRING_EOS;
	}
	result = _tmp0_;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gint
geary_string_count_char (const gchar* s,
                         gunichar c)
{
	gint count = 0;
	gint result;
	g_return_val_if_fail (s != NULL, 0);
	count = 0;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					gint _tmp2_;
					index = index + 1;
					_tmp1_ = index;
					count = count + 1;
					_tmp2_ = count;
				}
				_tmp0_ = FALSE;
				index = string_index_of_char (s, c, index);
				if (!(index >= 0)) {
					break;
				}
			}
		}
	}
	result = count;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gboolean
_vala_unichar_array_contains (gunichar * stack,
                              gssize stack_length,
                              const gunichar needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
geary_string_contains_any_char (const gchar* str,
                                gunichar* chars,
                                gint chars_length1)
{
	gint index = 0;
	gunichar ch = 0U;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	index = 0;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		_tmp1_ = string_get_next_char (str, &index, &_tmp0_);
		ch = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		if (_vala_unichar_array_contains (chars, chars_length1, ch)) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

guint
geary_string_stri_hash (const gchar* str)
{
	GHashFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	guint result;
	g_return_val_if_fail (str != NULL, 0U);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_utf8_strdown (str, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp0_ (_tmp2_);
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
geary_string_stri_equal (const gchar* a,
                         const gchar* b)
{
	GEqualFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = g_str_equal;
	_tmp1_ = g_utf8_strdown (a, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strdown (b, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}

gint
geary_string_stri_cmp (const gchar* a,
                       const gchar* b)
{
	GCompareFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = g_utf8_strdown (a, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strdown (b, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}

/**
 * Removes redundant white space and non-printing characters.
 *
 * @return the input string /str/, modified so that any non-printing
 * characters are converted to spaces, all consecutive spaces are
 * coalesced into a single space, and stripped of leading and trailing
 * white space. If //null// is passed in, the empty string is
 * returned.
 */
gchar*
geary_string_reduce_whitespace (const gchar* str)
{
	const gchar* _tmp0_ = NULL;
	gchar* s = NULL;
	gchar* _tmp1_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = str;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	s = _tmp1_;
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = g_regex_new (GEARY_STRING_WS_OR_NP, 0, 0, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = s;
		_tmp6_ = g_regex_replace (_tmp2_, _tmp5_, (gssize) -1, 0, " ", 0, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (s);
		s = _tmp7_;
		_g_free0 (_tmp4_);
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (s);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp8_ = s;
	_tmp9_ = string_strip (_tmp8_);
	result = _tmp9_;
	_g_free0 (s);
	return result;
}

gchar*
geary_string_safe_byte_substring (const gchar* s,
                                  gssize max_length)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = strlen (s);
	_tmp1_ = _tmp0_;
	if (((gssize) _tmp1_) < max_length) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (s);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_utf8_substring (s, (glong) 0, (glong) g_utf8_strlen (s, max_length));
	result = _tmp3_;
	return result;
}

