/* util-numeric.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-numeric.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

inline gint
geary_numeric_int_floor (gint value,
                         gint floor)
{
	gint _tmp0_ = 0;
	gint result;
	if (value >= floor) {
		_tmp0_ = value;
	} else {
		_tmp0_ = floor;
	}
	result = _tmp0_;
	return result;
}

inline gint64
geary_numeric_int64_floor (gint64 value,
                           gint64 floor)
{
	gint64 _tmp0_ = 0LL;
	gint64 result;
	if (value >= floor) {
		_tmp0_ = value;
	} else {
		_tmp0_ = floor;
	}
	result = _tmp0_;
	return result;
}

inline gint
geary_numeric_int_ceiling (gint value,
                           gint ceiling)
{
	gint _tmp0_ = 0;
	gint result;
	if (value <= ceiling) {
		_tmp0_ = value;
	} else {
		_tmp0_ = ceiling;
	}
	result = _tmp0_;
	return result;
}

inline gint64
geary_numeric_int64_ceiling (gint64 value,
                             gint64 ceiling)
{
	gint64 _tmp0_ = 0LL;
	gint64 result;
	if (value <= ceiling) {
		_tmp0_ = value;
	} else {
		_tmp0_ = ceiling;
	}
	result = _tmp0_;
	return result;
}

inline guint
geary_numeric_uint_ceiling (guint value,
                            guint ceiling)
{
	guint _tmp0_ = 0U;
	guint result;
	if (value <= ceiling) {
		_tmp0_ = value;
	} else {
		_tmp0_ = ceiling;
	}
	result = _tmp0_;
	return result;
}

inline gboolean
geary_numeric_int_in_range_inclusive (gint value,
                                      gint min,
                                      gint max)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (value >= min) {
		_tmp0_ = value <= max;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

inline gboolean
geary_numeric_int64_in_range_inclusive (gint64 value,
                                        gint64 min,
                                        gint64 max)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (value >= min) {
		_tmp0_ = value <= max;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

inline gboolean
geary_numeric_int_in_range_exclusive (gint value,
                                      gint min,
                                      gint max)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (value > min) {
		_tmp0_ = value < max;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

inline gboolean
geary_numeric_int64_in_range_exclusive (gint64 value,
                                        gint64 min,
                                        gint64 max)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (value > min) {
		_tmp0_ = value < max;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

inline gint
geary_numeric_int_round_up (gint value,
                            gint multiple_of)
{
	gint _tmp0_ = 0;
	gint result;
	if ((value % multiple_of) != 0) {
		_tmp0_ = multiple_of;
	} else {
		_tmp0_ = 0;
	}
	result = ((value / multiple_of) * multiple_of) + _tmp0_;
	return result;
}

gint
geary_numeric_int64_compare (void* a,
                             void* b)
{
	gint64 diff = 0LL;
	gint result;
	diff = (*((gint64*) a)) - (*((gint64*) b));
	if (diff < ((gint64) 0)) {
		result = -1;
		return result;
	} else {
		if (diff > ((gint64) 0)) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}

