/* application-folder-store-factory.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application-folder-store-factory.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gee.h>
#include "geary-client-46.0.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_ID_FORMAT "%s:%s"
#define APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_ID_PATH_SEP ">"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define APPLICATION_TYPE_FOLDER_STORE_FACTORY (application_folder_store_factory_get_type ())
#define APPLICATION_FOLDER_STORE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_FOLDER_STORE_FACTORY, ApplicationFolderStoreFactory))
#define APPLICATION_FOLDER_STORE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_FOLDER_STORE_FACTORY, ApplicationFolderStoreFactoryClass))
#define APPLICATION_IS_FOLDER_STORE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_FOLDER_STORE_FACTORY))
#define APPLICATION_IS_FOLDER_STORE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_FOLDER_STORE_FACTORY))
#define APPLICATION_FOLDER_STORE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_FOLDER_STORE_FACTORY, ApplicationFolderStoreFactoryClass))

typedef struct _ApplicationFolderStoreFactory ApplicationFolderStoreFactory;
typedef struct _ApplicationFolderStoreFactoryClass ApplicationFolderStoreFactoryClass;
typedef struct _ApplicationFolderStoreFactoryPrivate ApplicationFolderStoreFactoryPrivate;

#define APPLICATION_PLUGIN_MANAGER_TYPE_ACCOUNT_IMPL (application_plugin_manager_account_impl_get_type ())
#define APPLICATION_PLUGIN_MANAGER_ACCOUNT_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_ACCOUNT_IMPL, ApplicationPluginManagerAccountImpl))
#define APPLICATION_PLUGIN_MANAGER_ACCOUNT_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_PLUGIN_MANAGER_TYPE_ACCOUNT_IMPL, ApplicationPluginManagerAccountImplClass))
#define APPLICATION_PLUGIN_MANAGER_IS_ACCOUNT_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_ACCOUNT_IMPL))
#define APPLICATION_PLUGIN_MANAGER_IS_ACCOUNT_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_PLUGIN_MANAGER_TYPE_ACCOUNT_IMPL))
#define APPLICATION_PLUGIN_MANAGER_ACCOUNT_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_ACCOUNT_IMPL, ApplicationPluginManagerAccountImplClass))

typedef struct _ApplicationPluginManagerAccountImpl ApplicationPluginManagerAccountImpl;
typedef struct _ApplicationPluginManagerAccountImplClass ApplicationPluginManagerAccountImplClass;

#define APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL (application_folder_store_factory_folder_impl_get_type ())
#define APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImpl))
#define APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImplClass))
#define APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL))
#define APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL))
#define APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImplClass))

typedef struct _ApplicationFolderStoreFactoryFolderImpl ApplicationFolderStoreFactoryFolderImpl;
typedef struct _ApplicationFolderStoreFactoryFolderImplClass ApplicationFolderStoreFactoryFolderImplClass;

#define APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL (application_folder_store_factory_folder_store_impl_get_type ())
#define APPLICATION_FOLDER_STORE_FACTORY_FOLDER_STORE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, ApplicationFolderStoreFactoryFolderStoreImpl))
#define APPLICATION_FOLDER_STORE_FACTORY_FOLDER_STORE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, ApplicationFolderStoreFactoryFolderStoreImplClass))
#define APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_STORE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL))
#define APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_STORE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL))
#define APPLICATION_FOLDER_STORE_FACTORY_FOLDER_STORE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, ApplicationFolderStoreFactoryFolderStoreImplClass))

typedef struct _ApplicationFolderStoreFactoryFolderStoreImpl ApplicationFolderStoreFactoryFolderStoreImpl;
typedef struct _ApplicationFolderStoreFactoryFolderStoreImplClass ApplicationFolderStoreFactoryFolderStoreImplClass;
enum  {
	APPLICATION_FOLDER_STORE_FACTORY_0_PROPERTY,
	APPLICATION_FOLDER_STORE_FACTORY_NUM_PROPERTIES
};
static GParamSpec* application_folder_store_factory_properties[APPLICATION_FOLDER_STORE_FACTORY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ApplicationFolderStoreFactoryFolderStoreImplPrivate ApplicationFolderStoreFactoryFolderStoreImplPrivate;
enum  {
	APPLICATION_FOLDER_STORE_FACTORY_FOLDER_STORE_IMPL_0_PROPERTY,
	APPLICATION_FOLDER_STORE_FACTORY_FOLDER_STORE_IMPL_FOLDER_VARIANT_TYPE_PROPERTY,
	APPLICATION_FOLDER_STORE_FACTORY_FOLDER_STORE_IMPL_NUM_PROPERTIES
};
static GParamSpec* application_folder_store_factory_folder_store_impl_properties[APPLICATION_FOLDER_STORE_FACTORY_FOLDER_STORE_IMPL_NUM_PROPERTIES];
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

#define APPLICATION_EMAIL_STORE_FACTORY_TYPE_ID_IMPL (application_email_store_factory_id_impl_get_type ())
#define APPLICATION_EMAIL_STORE_FACTORY_ID_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_EMAIL_STORE_FACTORY_TYPE_ID_IMPL, ApplicationEmailStoreFactoryIdImpl))
#define APPLICATION_EMAIL_STORE_FACTORY_ID_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_EMAIL_STORE_FACTORY_TYPE_ID_IMPL, ApplicationEmailStoreFactoryIdImplClass))
#define APPLICATION_EMAIL_STORE_FACTORY_IS_ID_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_EMAIL_STORE_FACTORY_TYPE_ID_IMPL))
#define APPLICATION_EMAIL_STORE_FACTORY_IS_ID_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_EMAIL_STORE_FACTORY_TYPE_ID_IMPL))
#define APPLICATION_EMAIL_STORE_FACTORY_ID_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_EMAIL_STORE_FACTORY_TYPE_ID_IMPL, ApplicationEmailStoreFactoryIdImplClass))

typedef struct _ApplicationEmailStoreFactoryIdImpl ApplicationEmailStoreFactoryIdImpl;
typedef struct _ApplicationEmailStoreFactoryIdImplClass ApplicationEmailStoreFactoryIdImplClass;
typedef struct _ApplicationEmailStoreFactoryIdImplPrivate ApplicationEmailStoreFactoryIdImplPrivate;
typedef struct _ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData;
typedef struct _ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData;
typedef struct _ApplicationFolderStoreFactoryFolderImplPrivate ApplicationFolderStoreFactoryFolderImplPrivate;
enum  {
	APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_0_PROPERTY,
	APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_PERSISTENT_ID_PROPERTY,
	APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_DISPLAY_NAME_PROPERTY,
	APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_USED_AS_PROPERTY,
	APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_ACCOUNT_PROPERTY,
	APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_BACKING_PROPERTY,
	APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_NUM_PROPERTIES
};
static GParamSpec* application_folder_store_factory_folder_impl_properties[APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_NUM_PROPERTIES];

struct _ApplicationFolderStoreFactory {
	GearyBaseObject parent_instance;
	ApplicationFolderStoreFactoryPrivate * priv;
};

struct _ApplicationFolderStoreFactoryClass {
	GearyBaseObjectClass parent_class;
};

struct _ApplicationFolderStoreFactoryPrivate {
	GeeMap* accounts;
	GeeMap* folders;
	GeeSet* stores;
};

struct _ApplicationFolderStoreFactoryFolderStoreImpl {
	GearyBaseObject parent_instance;
	ApplicationFolderStoreFactoryFolderStoreImplPrivate * priv;
};

struct _ApplicationFolderStoreFactoryFolderStoreImplClass {
	GearyBaseObjectClass parent_class;
};

struct _ApplicationFolderStoreFactoryFolderStoreImplPrivate {
	GVariantType* _folder_variant_type;
	ApplicationFolderStoreFactory* factory;
};

struct _ApplicationEmailStoreFactoryIdImpl {
	GearyBaseObject parent_instance;
	ApplicationPluginManagerAccountImpl* account_impl;
	ApplicationEmailStoreFactoryIdImplPrivate * priv;
};

struct _ApplicationEmailStoreFactoryIdImplClass {
	GearyBaseObjectClass parent_class;
};

struct _ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationFolderStoreFactoryFolderStoreImpl* self;
	PluginEmailIdentifier* target;
	GCancellable* cancellable;
	GeeCollection* result;
	GeeLinkedList* folders;
	GeeLinkedList* _tmp0_;
	ApplicationEmailStoreFactoryIdImpl* id;
	ApplicationEmailStoreFactoryIdImpl* _tmp1_;
	ApplicationEmailStoreFactoryIdImpl* _tmp2_;
	ApplicationAccountContext* context;
	ApplicationEmailStoreFactoryIdImpl* _tmp3_;
	ApplicationPluginManagerAccountImpl* _tmp4_;
	ApplicationAccountContext* _tmp5_;
	ApplicationAccountContext* _tmp6_;
	ApplicationAccountContext* _tmp7_;
	GeeMultiMap* multi_folders;
	ApplicationAccountContext* _tmp8_;
	GearyAccount* _tmp9_;
	GearyAccount* _tmp10_;
	ApplicationEmailStoreFactoryIdImpl* _tmp11_;
	GearyEmailIdentifier* _tmp12_;
	GearyEmailIdentifier* _tmp13_;
	GeeCollection* _tmp14_;
	GeeCollection* _tmp15_;
	GeeMultiMap* _tmp16_;
	GeeMultiMap* _tmp17_;
	GeeMultiMap* _tmp18_;
	GeeIterator* _path_it;
	GeeMultiMap* _tmp19_;
	ApplicationEmailStoreFactoryIdImpl* _tmp20_;
	GearyEmailIdentifier* _tmp21_;
	GearyEmailIdentifier* _tmp22_;
	GeeCollection* _tmp23_;
	GeeCollection* _tmp24_;
	GeeIterator* _tmp25_;
	GeeIterator* _tmp26_;
	GeeIterator* _tmp27_;
	GearyFolderPath* path;
	GeeIterator* _tmp28_;
	gpointer _tmp29_;
	GearyFolder* folder;
	ApplicationAccountContext* _tmp30_;
	GearyAccount* _tmp31_;
	GearyAccount* _tmp32_;
	GearyFolderPath* _tmp33_;
	GearyFolder* _tmp34_;
	GeeLinkedList* _tmp35_;
	ApplicationFolderStoreFactory* _tmp36_;
	GeeMap* _tmp37_;
	GearyFolder* _tmp38_;
	gpointer _tmp39_;
	ApplicationFolderStoreFactoryFolderImpl* _tmp40_;
	GError* _inner_error0_;
};

struct _ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationFolderStoreFactoryFolderStoreImpl* self;
	PluginAccount* target;
	gchar* name;
	GCancellable* cancellable;
	PluginFolder* result;
	ApplicationPluginManagerAccountImpl* account;
	ApplicationPluginManagerAccountImpl* _tmp0_;
	ApplicationPluginManagerAccountImpl* _tmp1_;
	GError* _tmp2_;
	GearyFolder* engine;
	ApplicationPluginManagerAccountImpl* _tmp3_;
	ApplicationAccountContext* _tmp4_;
	ApplicationAccountContext* _tmp5_;
	GearyAccount* _tmp6_;
	GearyAccount* _tmp7_;
	GearyFolder* _tmp8_;
	PluginFolder* folder;
	ApplicationFolderStoreFactory* _tmp9_;
	GearyFolder* _tmp10_;
	PluginFolder* _tmp11_;
	PluginFolder* _tmp12_;
	GError* _tmp13_;
	GError* _inner_error0_;
};

struct _ApplicationFolderStoreFactoryFolderImpl {
	GearyBaseObject parent_instance;
	ApplicationFolderStoreFactoryFolderImplPrivate * priv;
};

struct _ApplicationFolderStoreFactoryFolderImplClass {
	GearyBaseObjectClass parent_class;
};

struct _ApplicationFolderStoreFactoryFolderImplPrivate {
	gchar* _persistent_id;
	ApplicationPluginManagerAccountImpl* _account;
	ApplicationFolderContext* _backing;
};

static gint ApplicationFolderStoreFactory_private_offset;
static gpointer application_folder_store_factory_parent_class = NULL;
static gint ApplicationFolderStoreFactoryFolderStoreImpl_private_offset;
static gpointer application_folder_store_factory_folder_store_impl_parent_class = NULL;
static PluginFolderStoreIface * application_folder_store_factory_folder_store_impl_plugin_folder_store_parent_iface = NULL;
static gint ApplicationFolderStoreFactoryFolderImpl_private_offset;
static gpointer application_folder_store_factory_folder_impl_parent_class = NULL;
static PluginFolderIface * application_folder_store_factory_folder_impl_plugin_folder_parent_iface = NULL;

VALA_EXTERN GType application_folder_store_factory_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType application_plugin_manager_account_impl_get_type (void) G_GNUC_CONST ;
static GType application_folder_store_factory_folder_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType application_folder_store_factory_folder_store_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN ApplicationFolderStoreFactory* application_folder_store_factory_new (GeeMap* accounts);
VALA_EXTERN ApplicationFolderStoreFactory* application_folder_store_factory_construct (GType object_type,
                                                                           GeeMap* accounts);
VALA_EXTERN void application_folder_store_factory_destroy (ApplicationFolderStoreFactory* self,
                                               GError** error);
static void application_folder_store_factory_folder_store_impl_destroy (ApplicationFolderStoreFactoryFolderStoreImpl* self);
VALA_EXTERN PluginFolderStore* application_folder_store_factory_new_folder_store (ApplicationFolderStoreFactory* self);
static ApplicationFolderStoreFactoryFolderStoreImpl* application_folder_store_factory_folder_store_impl_new (ApplicationFolderStoreFactory* factory);
static ApplicationFolderStoreFactoryFolderStoreImpl* application_folder_store_factory_folder_store_impl_construct (GType object_type,
                                                                                                            ApplicationFolderStoreFactory* factory);
VALA_EXTERN void application_folder_store_factory_destroy_folder_store (ApplicationFolderStoreFactory* self,
                                                            PluginFolderStore* plugin);
VALA_EXTERN PluginFolder* application_folder_store_factory_to_plugin_folder (ApplicationFolderStoreFactory* self,
                                                                 GearyFolder* engine);
VALA_EXTERN GearyFolder* application_folder_store_factory_to_engine_folder (ApplicationFolderStoreFactory* self,
                                                                PluginFolder* plugin);
static ApplicationFolderContext* application_folder_store_factory_folder_impl_get_backing (ApplicationFolderStoreFactoryFolderImpl* self);
VALA_EXTERN ApplicationFolderContext* application_folder_store_factory_to_folder_context (ApplicationFolderStoreFactory* self,
                                                                              PluginFolder* plugin);
VALA_EXTERN GearyFolder* application_folder_store_factory_get_folder_for_variant (ApplicationFolderStoreFactory* self,
                                                                      GVariant* target);
static gchar* _variant_get4 (GVariant* value);
VALA_EXTERN void application_folder_store_factory_add_account (ApplicationFolderStoreFactory* self,
                                                   ApplicationAccountContext* added);
static void application_folder_store_factory_on_folders_available (ApplicationFolderStoreFactory* self,
                                                            ApplicationAccountContext* account,
                                                            GeeCollection* available);
static void _application_folder_store_factory_on_folders_available_application_account_context_folders_available (ApplicationAccountContext* _sender,
                                                                                                           GeeCollection* available,
                                                                                                           gpointer self);
static void application_folder_store_factory_on_folders_unavailable (ApplicationFolderStoreFactory* self,
                                                              ApplicationAccountContext* account,
                                                              GeeCollection* unavailable);
static void _application_folder_store_factory_on_folders_unavailable_application_account_context_folders_unavailable (ApplicationAccountContext* _sender,
                                                                                                               GeeCollection* unavailable,
                                                                                                               gpointer self);
static void application_folder_store_factory_on_folders_use_changed (ApplicationFolderStoreFactory* self,
                                                              GearyAccount* account,
                                                              GeeCollection* changed);
static void _application_folder_store_factory_on_folders_use_changed_geary_account_folders_use_changed (GearyAccount* _sender,
                                                                                                 GeeCollection* altered,
                                                                                                 gpointer self);
static void application_folder_store_factory_add_folders (ApplicationFolderStoreFactory* self,
                                                   ApplicationAccountContext* account,
                                                   GeeCollection* to_add);
VALA_EXTERN void application_folder_store_factory_remove_account (ApplicationFolderStoreFactory* self,
                                                      ApplicationAccountContext* removed);
static void application_folder_store_factory_remove_folders (ApplicationFolderStoreFactory* self,
                                                      ApplicationAccountContext* account,
                                                      GeeCollection* to_remove);
VALA_EXTERN void application_folder_store_factory_main_window_added (ApplicationFolderStoreFactory* self,
                                                         ApplicationMainWindow* added);
static void application_folder_store_factory_on_folder_selected (ApplicationFolderStoreFactory* self,
                                                          GObject* object,
                                                          GParamSpec* param);
static void _application_folder_store_factory_on_folder_selected_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self);
static ApplicationFolderStoreFactoryFolderImpl* application_folder_store_factory_folder_impl_new (ApplicationFolderContext* backing,
                                                                                           ApplicationPluginManagerAccountImpl* account);
static ApplicationFolderStoreFactoryFolderImpl* application_folder_store_factory_folder_impl_construct (GType object_type,
                                                                                                 ApplicationFolderContext* backing,
                                                                                                 ApplicationPluginManagerAccountImpl* account);
static ApplicationFolderStoreFactoryFolderImpl* __lambda16_ (ApplicationFolderStoreFactory* self,
                                                      ApplicationFolderContext* context);
static gpointer ___lambda16__gee_map_func (gpointer g,
                                    gpointer self);
static ApplicationFolderStoreFactoryFolderImpl* __lambda17_ (ApplicationFolderStoreFactory* self,
                                                      ApplicationFolderContext* context);
static gpointer ___lambda17__gee_map_func (gpointer g,
                                    gpointer self);
static GeeCollection* application_folder_store_factory_to_plugin_folders (ApplicationFolderStoreFactory* self,
                                                                   GeeCollection* folders);
static ApplicationFolderStoreFactoryFolderImpl* __lambda18_ (ApplicationFolderStoreFactory* self,
                                                      GearyFolder* f);
static gpointer ___lambda18__gee_map_func (gpointer g,
                                    gpointer self);
static void application_folder_store_factory_folder_impl_folder_type_changed (ApplicationFolderStoreFactoryFolderImpl* self);
static GeeCollection* application_folder_store_factory_folder_store_impl_real_get_folders (PluginFolderStore* base);
static void application_folder_store_factory_folder_store_impl_real_list_containing_folders_data_free (gpointer _data);
static void application_folder_store_factory_folder_store_impl_real_list_containing_folders (PluginFolderStore* base,
                                                                                      PluginEmailIdentifier* target,
                                                                                      GCancellable* cancellable,
                                                                                      GAsyncReadyCallback _callback_,
                                                                                      gpointer _user_data_);
static gboolean application_folder_store_factory_folder_store_impl_real_list_containing_folders_co (ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData* _data_);
VALA_EXTERN GType application_email_store_factory_id_impl_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationAccountContext* application_plugin_manager_account_impl_get_backing (ApplicationPluginManagerAccountImpl* self);
VALA_EXTERN GearyEmailIdentifier* application_email_store_factory_id_impl_get_backing (ApplicationEmailStoreFactoryIdImpl* self);
static void application_folder_store_factory_folder_store_impl_list_containing_folders_ready (GObject* source_object,
                                                                                       GAsyncResult* _res_,
                                                                                       gpointer _user_data_);
static void application_folder_store_factory_folder_store_impl_real_create_personal_folder_data_free (gpointer _data);
static void application_folder_store_factory_folder_store_impl_real_create_personal_folder (PluginFolderStore* base,
                                                                                     PluginAccount* target,
                                                                                     const gchar* name,
                                                                                     GCancellable* cancellable,
                                                                                     GAsyncReadyCallback _callback_,
                                                                                     gpointer _user_data_);
static gboolean application_folder_store_factory_folder_store_impl_real_create_personal_folder_co (ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData* _data_);
static void application_folder_store_factory_folder_store_impl_create_personal_folder_ready (GObject* source_object,
                                                                                      GAsyncResult* _res_,
                                                                                      gpointer _user_data_);
static PluginFolder* application_folder_store_factory_folder_store_impl_real_get_folder_for_variant (PluginFolderStore* base,
                                                                                              GVariant* variant);
static void application_folder_store_factory_folder_store_impl_finalize (GObject * obj);
static GType application_folder_store_factory_folder_store_impl_get_type_once (void);
static void _vala_application_folder_store_factory_folder_store_impl_get_property (GObject * object,
                                                                            guint property_id,
                                                                            GValue * value,
                                                                            GParamSpec * pspec);
static void application_folder_store_factory_folder_impl_set_backing (ApplicationFolderStoreFactoryFolderImpl* self,
                                                               ApplicationFolderContext* value);
static GVariant* application_folder_store_factory_folder_impl_real_to_variant (PluginFolder* base);
static GVariant* _variant_new3 (const gchar* value);
static void application_folder_store_factory_folder_impl_finalize (GObject * obj);
static GType application_folder_store_factory_folder_impl_get_type_once (void);
static void _vala_application_folder_store_factory_folder_impl_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_application_folder_store_factory_folder_impl_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static void application_folder_store_factory_finalize (GObject * obj);
static GType application_folder_store_factory_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
application_folder_store_factory_get_instance_private (ApplicationFolderStoreFactory* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationFolderStoreFactory_private_offset);
}

/**
     * Constructs a new factory instance.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ApplicationFolderStoreFactory*
application_folder_store_factory_construct (GType object_type,
                                            GeeMap* accounts)
{
	ApplicationFolderStoreFactory * self = NULL;
	GeeMap* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (accounts, GEE_TYPE_MAP), NULL);
	self = (ApplicationFolderStoreFactory*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (accounts);
	_g_object_unref0 (self->priv->accounts);
	self->priv->accounts = _tmp0_;
	return self;
}

ApplicationFolderStoreFactory*
application_folder_store_factory_new (GeeMap* accounts)
{
	return application_folder_store_factory_construct (APPLICATION_TYPE_FOLDER_STORE_FACTORY, accounts);
}

/** Clearing all state of the store. */
void
application_folder_store_factory_destroy (ApplicationFolderStoreFactory* self,
                                          GError** error)
{
	GeeSet* _tmp6_;
	GeeMap* _tmp7_;
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	{
		GeeIterator* _store_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->stores;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
		_store_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			ApplicationFolderStoreFactoryFolderStoreImpl* store = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			ApplicationFolderStoreFactoryFolderStoreImpl* _tmp5_;
			_tmp2_ = _store_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _store_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			store = (ApplicationFolderStoreFactoryFolderStoreImpl*) _tmp4_;
			_tmp5_ = store;
			application_folder_store_factory_folder_store_impl_destroy (_tmp5_);
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	_tmp6_ = self->priv->stores;
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp7_ = self->priv->folders;
	gee_map_clear (_tmp7_);
}

/** Constructs a new folder store for use by plugin contexts. */
PluginFolderStore*
application_folder_store_factory_new_folder_store (ApplicationFolderStoreFactory* self)
{
	ApplicationFolderStoreFactoryFolderStoreImpl* store = NULL;
	ApplicationFolderStoreFactoryFolderStoreImpl* _tmp0_;
	GeeSet* _tmp1_;
	PluginFolderStore* result;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self), NULL);
	_tmp0_ = application_folder_store_factory_folder_store_impl_new (self);
	store = _tmp0_;
	_tmp1_ = self->priv->stores;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), store);
	result = G_TYPE_CHECK_INSTANCE_CAST (store, PLUGIN_TYPE_FOLDER_STORE, PluginFolderStore);
	return result;
}

/** Destroys a folder store once is no longer required. */
void
application_folder_store_factory_destroy_folder_store (ApplicationFolderStoreFactory* self,
                                                       PluginFolderStore* plugin)
{
	ApplicationFolderStoreFactoryFolderStoreImpl* impl = NULL;
	ApplicationFolderStoreFactoryFolderStoreImpl* _tmp0_;
	ApplicationFolderStoreFactoryFolderStoreImpl* _tmp1_;
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	g_return_if_fail (PLUGIN_IS_FOLDER_STORE (plugin));
	_tmp0_ = _g_object_ref0 (APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_STORE_IMPL (plugin) ? ((ApplicationFolderStoreFactoryFolderStoreImpl*) plugin) : NULL);
	impl = _tmp0_;
	_tmp1_ = impl;
	if (_tmp1_ != NULL) {
		ApplicationFolderStoreFactoryFolderStoreImpl* _tmp2_;
		GeeSet* _tmp3_;
		ApplicationFolderStoreFactoryFolderStoreImpl* _tmp4_;
		_tmp2_ = impl;
		application_folder_store_factory_folder_store_impl_destroy (_tmp2_);
		_tmp3_ = self->priv->stores;
		_tmp4_ = impl;
		gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), _tmp4_);
	}
	_g_object_unref0 (impl);
}

/** Returns the plugin folder for the given engine folder. */
PluginFolder*
application_folder_store_factory_to_plugin_folder (ApplicationFolderStoreFactory* self,
                                                   GearyFolder* engine)
{
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	PluginFolder* result;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (engine, GEARY_TYPE_FOLDER), NULL);
	_tmp0_ = self->priv->folders;
	_tmp1_ = gee_map_get (_tmp0_, engine);
	result = G_TYPE_CHECK_INSTANCE_CAST ((ApplicationFolderStoreFactoryFolderImpl*) _tmp1_, PLUGIN_TYPE_FOLDER, PluginFolder);
	return result;
}

/** Returns the engine folder for the given plugin folder. */
GearyFolder*
application_folder_store_factory_to_engine_folder (ApplicationFolderStoreFactory* self,
                                                   PluginFolder* plugin)
{
	ApplicationFolderStoreFactoryFolderImpl* impl = NULL;
	ApplicationFolderStoreFactoryFolderImpl* _tmp0_;
	GearyFolder* _tmp1_ = NULL;
	ApplicationFolderStoreFactoryFolderImpl* _tmp2_;
	GearyFolder* _tmp8_;
	GearyFolder* result;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self), NULL);
	g_return_val_if_fail (PLUGIN_IS_FOLDER (plugin), NULL);
	_tmp0_ = _g_object_ref0 (APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_IMPL (plugin) ? ((ApplicationFolderStoreFactoryFolderImpl*) plugin) : NULL);
	impl = _tmp0_;
	_tmp2_ = impl;
	if (_tmp2_ != NULL) {
		ApplicationFolderStoreFactoryFolderImpl* _tmp3_;
		ApplicationFolderContext* _tmp4_;
		ApplicationFolderContext* _tmp5_;
		GearyFolder* _tmp6_;
		GearyFolder* _tmp7_;
		_tmp3_ = impl;
		_tmp4_ = application_folder_store_factory_folder_impl_get_backing (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = application_folder_context_get_folder (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = NULL;
	}
	_tmp8_ = _g_object_ref0 (_tmp1_);
	result = _tmp8_;
	_g_object_unref0 (impl);
	return result;
}

/** Returns the folder context for the given plugin folder. */
ApplicationFolderContext*
application_folder_store_factory_to_folder_context (ApplicationFolderStoreFactory* self,
                                                    PluginFolder* plugin)
{
	ApplicationFolderStoreFactoryFolderImpl* impl = NULL;
	ApplicationFolderStoreFactoryFolderImpl* _tmp0_;
	ApplicationFolderContext* _tmp1_ = NULL;
	ApplicationFolderStoreFactoryFolderImpl* _tmp2_;
	ApplicationFolderContext* _tmp6_;
	ApplicationFolderContext* result;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self), NULL);
	g_return_val_if_fail (PLUGIN_IS_FOLDER (plugin), NULL);
	_tmp0_ = _g_object_ref0 (APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_IMPL (plugin) ? ((ApplicationFolderStoreFactoryFolderImpl*) plugin) : NULL);
	impl = _tmp0_;
	_tmp2_ = impl;
	if (_tmp2_ != NULL) {
		ApplicationFolderStoreFactoryFolderImpl* _tmp3_;
		ApplicationFolderContext* _tmp4_;
		ApplicationFolderContext* _tmp5_;
		_tmp3_ = impl;
		_tmp4_ = application_folder_store_factory_folder_impl_get_backing (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp1_);
	result = _tmp6_;
	_g_object_unref0 (impl);
	return result;
}

/** Returns the folder context for the given plugin folder id. */
static gchar*
_variant_get4 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

GearyFolder*
application_folder_store_factory_get_folder_for_variant (ApplicationFolderStoreFactory* self,
                                                         GVariant* target)
{
	gchar* id = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ApplicationAccountContext* context = NULL;
	GearyFolder* folder = NULL;
	ApplicationAccountContext* _tmp23_;
	GError* _inner_error0_ = NULL;
	GearyFolder* result;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self), NULL);
	g_return_val_if_fail (target != NULL, NULL);
	_tmp0_ = g_variant_get_child_value (target, (gsize) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = _variant_get4 (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_unref0 (_tmp1_);
	id = _tmp3_;
	context = NULL;
	{
		GeeIterator* _key_it = NULL;
		GeeMap* _tmp4_;
		GeeSet* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp4_ = self->priv->accounts;
		_tmp5_ = gee_map_get_keys (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_key_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			ApplicationAccountContext* key = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			ApplicationAccountContext* _tmp13_;
			GearyAccount* _tmp14_;
			GearyAccount* _tmp15_;
			GearyAccountInformation* _tmp16_;
			GearyAccountInformation* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp10_ = _key_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _key_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			key = (ApplicationAccountContext*) _tmp12_;
			_tmp13_ = key;
			_tmp14_ = application_account_context_get_account (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = geary_account_get_information (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = geary_account_information_get_id (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = id;
			if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
				ApplicationAccountContext* _tmp21_;
				ApplicationAccountContext* _tmp22_;
				_tmp21_ = key;
				_tmp22_ = _g_object_ref0 (_tmp21_);
				_g_object_unref0 (context);
				context = _tmp22_;
				_g_object_unref0 (key);
				break;
			}
			_g_object_unref0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	folder = NULL;
	_tmp23_ = context;
	if (_tmp23_ != NULL) {
		{
			GearyFolderPath* path = NULL;
			ApplicationAccountContext* _tmp24_;
			GearyAccount* _tmp25_;
			GearyAccount* _tmp26_;
			GVariant* _tmp27_;
			GVariant* _tmp28_;
			GVariant* _tmp29_;
			GVariant* _tmp30_;
			GearyFolderPath* _tmp31_;
			GearyFolderPath* _tmp32_;
			GearyFolder* _tmp33_ = NULL;
			ApplicationAccountContext* _tmp34_;
			GearyAccount* _tmp35_;
			GearyAccount* _tmp36_;
			GearyFolderPath* _tmp37_;
			GearyFolder* _tmp38_;
			GearyFolder* _tmp39_;
			_tmp24_ = context;
			_tmp25_ = application_account_context_get_account (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_variant_get_child_value (target, (gsize) 1);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_variant_get_variant (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = geary_account_to_folder_path (_tmp26_, _tmp30_, &_inner_error0_);
			_tmp32_ = _tmp31_;
			_g_variant_unref0 (_tmp30_);
			_g_variant_unref0 (_tmp28_);
			path = _tmp32_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp34_ = context;
			_tmp35_ = application_account_context_get_account (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = path;
			_tmp38_ = geary_account_get_folder (_tmp36_, _tmp37_, &_inner_error0_);
			_tmp33_ = _tmp38_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (path);
				goto __catch0_g_error;
			}
			_tmp39_ = _tmp33_;
			_tmp33_ = NULL;
			_g_object_unref0 (folder);
			folder = _tmp39_;
			_g_object_unref0 (_tmp33_);
			_g_object_unref0 (path);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp40_;
			const gchar* _tmp41_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp40_ = err;
			_tmp41_ = _tmp40_->message;
			g_debug ("application-folder-store-factory.vala:226: Could not find account/fold" \
"er %s", _tmp41_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (folder);
			_g_object_unref0 (context);
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = folder;
	_g_object_unref0 (context);
	_g_free0 (id);
	return result;
}

static void
_application_folder_store_factory_on_folders_available_application_account_context_folders_available (ApplicationAccountContext* _sender,
                                                                                                      GeeCollection* available,
                                                                                                      gpointer self)
{
	application_folder_store_factory_on_folders_available ((ApplicationFolderStoreFactory*) self, _sender, available);
}

static void
_application_folder_store_factory_on_folders_unavailable_application_account_context_folders_unavailable (ApplicationAccountContext* _sender,
                                                                                                          GeeCollection* unavailable,
                                                                                                          gpointer self)
{
	application_folder_store_factory_on_folders_unavailable ((ApplicationFolderStoreFactory*) self, _sender, unavailable);
}

static void
_application_folder_store_factory_on_folders_use_changed_geary_account_folders_use_changed (GearyAccount* _sender,
                                                                                            GeeCollection* altered,
                                                                                            gpointer self)
{
	application_folder_store_factory_on_folders_use_changed ((ApplicationFolderStoreFactory*) self, _sender, altered);
}

void
application_folder_store_factory_add_account (ApplicationFolderStoreFactory* self,
                                              ApplicationAccountContext* added)
{
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	GeeCollection* folders = NULL;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (added));
	g_signal_connect_object (added, "folders-available", (GCallback) _application_folder_store_factory_on_folders_available_application_account_context_folders_available, self, 0);
	g_signal_connect_object (added, "folders-unavailable", (GCallback) _application_folder_store_factory_on_folders_unavailable_application_account_context_folders_unavailable, self, 0);
	_tmp0_ = application_account_context_get_account (added);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "folders-use-changed", (GCallback) _application_folder_store_factory_on_folders_use_changed_geary_account_folders_use_changed, self, 0);
	_tmp2_ = application_account_context_get_folders (added);
	folders = _tmp2_;
	_tmp3_ = folders;
	_tmp4_ = gee_collection_get_is_empty (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		GeeCollection* _tmp6_;
		_tmp6_ = folders;
		application_folder_store_factory_add_folders (self, added, _tmp6_);
	}
	_g_object_unref0 (folders);
}

void
application_folder_store_factory_remove_account (ApplicationFolderStoreFactory* self,
                                                 ApplicationAccountContext* removed)
{
	guint _tmp0_;
	guint _tmp1_;
	GearyAccount* _tmp2_;
	GearyAccount* _tmp3_;
	guint _tmp4_;
	GeeCollection* folders = NULL;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (removed));
	g_signal_parse_name ("folders-available", APPLICATION_TYPE_ACCOUNT_CONTEXT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (removed, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _application_folder_store_factory_on_folders_available_application_account_context_folders_available, self);
	g_signal_parse_name ("folders-unavailable", APPLICATION_TYPE_ACCOUNT_CONTEXT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (removed, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _application_folder_store_factory_on_folders_unavailable_application_account_context_folders_unavailable, self);
	_tmp2_ = application_account_context_get_account (removed);
	_tmp3_ = _tmp2_;
	g_signal_parse_name ("folders-use-changed", GEARY_TYPE_ACCOUNT, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _application_folder_store_factory_on_folders_use_changed_geary_account_folders_use_changed, self);
	_tmp5_ = application_account_context_get_folders (removed);
	folders = _tmp5_;
	_tmp6_ = folders;
	_tmp7_ = gee_collection_get_is_empty (_tmp6_);
	_tmp8_ = _tmp7_;
	if (!_tmp8_) {
		GeeCollection* _tmp9_;
		_tmp9_ = folders;
		application_folder_store_factory_remove_folders (self, removed, _tmp9_);
	}
	_g_object_unref0 (folders);
}

static void
_application_folder_store_factory_on_folder_selected_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self)
{
	application_folder_store_factory_on_folder_selected ((ApplicationFolderStoreFactory*) self, _sender, pspec);
}

void
application_folder_store_factory_main_window_added (ApplicationFolderStoreFactory* self,
                                                    ApplicationMainWindow* added)
{
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	g_return_if_fail (APPLICATION_IS_MAIN_WINDOW (added));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (added, G_TYPE_OBJECT, GObject), "notify::selected-folder", (GCallback) _application_folder_store_factory_on_folder_selected_g_object_notify, self, 0);
}

static ApplicationFolderStoreFactoryFolderImpl*
__lambda16_ (ApplicationFolderStoreFactory* self,
             ApplicationFolderContext* context)
{
	GeeMap* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	gpointer _tmp3_;
	ApplicationFolderStoreFactoryFolderImpl* result;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_CONTEXT (context), NULL);
	_tmp0_ = self->priv->folders;
	_tmp1_ = application_folder_context_get_folder (context);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_map_get (_tmp0_, _tmp2_);
	result = (ApplicationFolderStoreFactoryFolderImpl*) _tmp3_;
	_g_object_unref0 (context);
	return result;
}

static gpointer
___lambda16__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = __lambda16_ ((ApplicationFolderStoreFactory*) self, (ApplicationFolderContext*) g);
	return result;
}

static void
application_folder_store_factory_add_folders (ApplicationFolderStoreFactory* self,
                                              ApplicationAccountContext* account,
                                              GeeCollection* to_add)
{
	GeeBidirList* folder_impls = NULL;
	GearyIterable* _tmp14_;
	GearyIterable* _tmp15_;
	GearyIterable* _tmp16_;
	GearyIterable* _tmp17_;
	GeeLinkedList* _tmp18_;
	GeeLinkedList* _tmp19_;
	GeeBidirList* _tmp20_;
	GeeBidirList* _tmp21_;
	GeeBidirList* _tmp22_;
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (account));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_add, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _context_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (to_add, GEE_TYPE_ITERABLE, GeeIterable));
		_context_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ApplicationFolderContext* context = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GeeMap* _tmp4_;
			ApplicationFolderContext* _tmp5_;
			GearyFolder* _tmp6_;
			GearyFolder* _tmp7_;
			ApplicationFolderContext* _tmp8_;
			GeeMap* _tmp9_;
			gpointer _tmp10_;
			ApplicationPluginManagerAccountImpl* _tmp11_;
			ApplicationFolderStoreFactoryFolderImpl* _tmp12_;
			ApplicationFolderStoreFactoryFolderImpl* _tmp13_;
			_tmp1_ = _context_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _context_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			context = (ApplicationFolderContext*) _tmp3_;
			_tmp4_ = self->priv->folders;
			_tmp5_ = context;
			_tmp6_ = application_folder_context_get_folder (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = context;
			_tmp9_ = self->priv->accounts;
			_tmp10_ = gee_map_get (_tmp9_, account);
			_tmp11_ = (ApplicationPluginManagerAccountImpl*) _tmp10_;
			_tmp12_ = application_folder_store_factory_folder_impl_new (_tmp8_, _tmp11_);
			_tmp13_ = _tmp12_;
			gee_map_set (_tmp4_, _tmp7_, _tmp13_);
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (context);
		}
		_g_object_unref0 (_context_it);
	}
	_tmp14_ = geary_traverse (APPLICATION_TYPE_FOLDER_CONTEXT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (to_add, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp15_ = _tmp14_;
	_tmp16_ = geary_iterable_map (_tmp15_, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, ___lambda16__gee_map_func, self);
	_tmp17_ = _tmp16_;
	_tmp18_ = geary_iterable_to_linked_list (_tmp17_, NULL, NULL, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp19_);
	_g_object_unref0 (_tmp17_);
	_g_object_unref0 (_tmp15_);
	folder_impls = _tmp22_;
	{
		GeeIterator* _store_it = NULL;
		GeeSet* _tmp23_;
		GeeIterator* _tmp24_;
		_tmp23_ = self->priv->stores;
		_tmp24_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ITERABLE, GeeIterable));
		_store_it = _tmp24_;
		while (TRUE) {
			GeeIterator* _tmp25_;
			ApplicationFolderStoreFactoryFolderStoreImpl* store = NULL;
			GeeIterator* _tmp26_;
			gpointer _tmp27_;
			ApplicationFolderStoreFactoryFolderStoreImpl* _tmp28_;
			GeeBidirList* _tmp29_;
			_tmp25_ = _store_it;
			if (!gee_iterator_next (_tmp25_)) {
				break;
			}
			_tmp26_ = _store_it;
			_tmp27_ = gee_iterator_get (_tmp26_);
			store = (ApplicationFolderStoreFactoryFolderStoreImpl*) _tmp27_;
			_tmp28_ = store;
			_tmp29_ = folder_impls;
			g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, PLUGIN_TYPE_FOLDER_STORE, PluginFolderStore), "folders-available", G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection));
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	_g_object_unref0 (folder_impls);
}

static ApplicationFolderStoreFactoryFolderImpl*
__lambda17_ (ApplicationFolderStoreFactory* self,
             ApplicationFolderContext* context)
{
	GeeMap* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	gpointer _tmp3_;
	ApplicationFolderStoreFactoryFolderImpl* result;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_CONTEXT (context), NULL);
	_tmp0_ = self->priv->folders;
	_tmp1_ = application_folder_context_get_folder (context);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_map_get (_tmp0_, _tmp2_);
	result = (ApplicationFolderStoreFactoryFolderImpl*) _tmp3_;
	_g_object_unref0 (context);
	return result;
}

static gpointer
___lambda17__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = __lambda17_ ((ApplicationFolderStoreFactory*) self, (ApplicationFolderContext*) g);
	return result;
}

static void
application_folder_store_factory_remove_folders (ApplicationFolderStoreFactory* self,
                                                 ApplicationAccountContext* account,
                                                 GeeCollection* to_remove)
{
	GeeBidirList* folder_impls = NULL;
	GearyIterable* _tmp0_;
	GearyIterable* _tmp1_;
	GearyIterable* _tmp2_;
	GearyIterable* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* _tmp5_;
	GeeBidirList* _tmp6_;
	GeeBidirList* _tmp7_;
	GeeBidirList* _tmp8_;
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (account));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_remove, GEE_TYPE_COLLECTION));
	_tmp0_ = geary_traverse (APPLICATION_TYPE_FOLDER_CONTEXT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (to_remove, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_iterable_map (_tmp1_, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, ___lambda17__gee_map_func, self);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_iterable_to_linked_list (_tmp3_, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	folder_impls = _tmp8_;
	{
		GeeIterator* _store_it = NULL;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp9_ = self->priv->stores;
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
		_store_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			ApplicationFolderStoreFactoryFolderStoreImpl* store = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			ApplicationFolderStoreFactoryFolderStoreImpl* _tmp14_;
			GeeBidirList* _tmp15_;
			_tmp11_ = _store_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _store_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			store = (ApplicationFolderStoreFactoryFolderStoreImpl*) _tmp13_;
			_tmp14_ = store;
			_tmp15_ = folder_impls;
			g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, PLUGIN_TYPE_FOLDER_STORE, PluginFolderStore), "folders-unavailable", G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	{
		GeeIterator* _context_it = NULL;
		GeeIterator* _tmp16_;
		_tmp16_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (to_remove, GEE_TYPE_ITERABLE, GeeIterable));
		_context_it = _tmp16_;
		while (TRUE) {
			GeeIterator* _tmp17_;
			ApplicationFolderContext* context = NULL;
			GeeIterator* _tmp18_;
			gpointer _tmp19_;
			GeeMap* _tmp20_;
			ApplicationFolderContext* _tmp21_;
			GearyFolder* _tmp22_;
			GearyFolder* _tmp23_;
			_tmp17_ = _context_it;
			if (!gee_iterator_next (_tmp17_)) {
				break;
			}
			_tmp18_ = _context_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			context = (ApplicationFolderContext*) _tmp19_;
			_tmp20_ = self->priv->folders;
			_tmp21_ = context;
			_tmp22_ = application_folder_context_get_folder (_tmp21_);
			_tmp23_ = _tmp22_;
			gee_map_unset (_tmp20_, _tmp23_, NULL);
			_g_object_unref0 (context);
		}
		_g_object_unref0 (_context_it);
	}
	_g_object_unref0 (folder_impls);
}

static ApplicationFolderStoreFactoryFolderImpl*
__lambda18_ (ApplicationFolderStoreFactory* self,
             GearyFolder* f)
{
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	ApplicationFolderStoreFactoryFolderImpl* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (f, GEARY_TYPE_FOLDER), NULL);
	_tmp0_ = self->priv->folders;
	_tmp1_ = gee_map_get (_tmp0_, f);
	result = (ApplicationFolderStoreFactoryFolderImpl*) _tmp1_;
	_g_object_unref0 (f);
	return result;
}

static gpointer
___lambda18__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = __lambda18_ ((ApplicationFolderStoreFactory*) self, (GearyFolder*) g);
	return result;
}

static GeeCollection*
application_folder_store_factory_to_plugin_folders (ApplicationFolderStoreFactory* self,
                                                    GeeCollection* folders)
{
	GearyIterable* _tmp0_;
	GearyIterable* _tmp1_;
	GearyIterable* _tmp2_;
	GearyIterable* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* _tmp5_;
	GeeBidirList* _tmp6_;
	GeeBidirList* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* result;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folders, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = geary_traverse (GEARY_TYPE_FOLDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (folders, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_iterable_map (_tmp1_, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, ___lambda18__gee_map_func, self);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_iterable_to_linked_list (_tmp3_, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
	_tmp7_ = _tmp6_;
	_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp8_;
	return result;
}

static void
application_folder_store_factory_on_folders_available (ApplicationFolderStoreFactory* self,
                                                       ApplicationAccountContext* account,
                                                       GeeCollection* available)
{
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (account));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (available, GEE_TYPE_COLLECTION));
	application_folder_store_factory_add_folders (self, account, available);
}

static void
application_folder_store_factory_on_folders_unavailable (ApplicationFolderStoreFactory* self,
                                                         ApplicationAccountContext* account,
                                                         GeeCollection* unavailable)
{
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (account));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (unavailable, GEE_TYPE_COLLECTION));
	application_folder_store_factory_remove_folders (self, account, unavailable);
}

static void
application_folder_store_factory_on_folders_use_changed (ApplicationFolderStoreFactory* self,
                                                         GearyAccount* account,
                                                         GeeCollection* changed)
{
	GeeCollection* folders = NULL;
	GeeCollection* _tmp0_;
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (changed, GEE_TYPE_COLLECTION));
	_tmp0_ = application_folder_store_factory_to_plugin_folders (self, changed);
	folders = _tmp0_;
	{
		GeeIterator* _folder_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = folders;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_folder_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			ApplicationFolderStoreFactoryFolderImpl* folder = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			ApplicationFolderStoreFactoryFolderImpl* _tmp6_;
			_tmp3_ = _folder_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _folder_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			folder = (ApplicationFolderStoreFactoryFolderImpl*) _tmp5_;
			_tmp6_ = folder;
			application_folder_store_factory_folder_impl_folder_type_changed (_tmp6_);
			_g_object_unref0 (folder);
		}
		_g_object_unref0 (_folder_it);
	}
	{
		GeeIterator* _store_it = NULL;
		GeeSet* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp7_ = self->priv->stores;
		_tmp8_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable));
		_store_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			ApplicationFolderStoreFactoryFolderStoreImpl* store = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			ApplicationFolderStoreFactoryFolderStoreImpl* _tmp12_;
			GeeCollection* _tmp13_;
			_tmp9_ = _store_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _store_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			store = (ApplicationFolderStoreFactoryFolderStoreImpl*) _tmp11_;
			_tmp12_ = store;
			_tmp13_ = folders;
			g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, PLUGIN_TYPE_FOLDER_STORE, PluginFolderStore), "folders-type-changed", _tmp13_);
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	_g_object_unref0 (folders);
}

static void
application_folder_store_factory_on_folder_selected (ApplicationFolderStoreFactory* self,
                                                     GObject* object,
                                                     GParamSpec* param)
{
	ApplicationMainWindow* main = NULL;
	ApplicationMainWindow* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	g_return_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (object, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (param, G_TYPE_PARAM));
	_tmp0_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (object) ? ((ApplicationMainWindow*) object) : NULL);
	main = _tmp0_;
	_tmp1_ = main;
	if (_tmp1_ != NULL) {
		GearyFolder* selected = NULL;
		ApplicationMainWindow* _tmp2_;
		GearyFolder* _tmp3_;
		GearyFolder* _tmp4_;
		GearyFolder* _tmp5_;
		GearyFolder* _tmp6_;
		_tmp2_ = main;
		_tmp3_ = application_main_window_get_selected_folder (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		selected = _tmp5_;
		_tmp6_ = selected;
		if (_tmp6_ != NULL) {
			PluginFolder* plugin = NULL;
			GearyFolder* _tmp7_;
			PluginFolder* _tmp8_;
			PluginFolder* _tmp9_;
			_tmp7_ = selected;
			_tmp8_ = application_folder_store_factory_to_plugin_folder (self, _tmp7_);
			plugin = _tmp8_;
			_tmp9_ = plugin;
			if (_tmp9_ != NULL) {
				{
					GeeIterator* _store_it = NULL;
					GeeSet* _tmp10_;
					GeeIterator* _tmp11_;
					_tmp10_ = self->priv->stores;
					_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
					_store_it = _tmp11_;
					while (TRUE) {
						GeeIterator* _tmp12_;
						ApplicationFolderStoreFactoryFolderStoreImpl* store = NULL;
						GeeIterator* _tmp13_;
						gpointer _tmp14_;
						ApplicationFolderStoreFactoryFolderStoreImpl* _tmp15_;
						PluginFolder* _tmp16_;
						_tmp12_ = _store_it;
						if (!gee_iterator_next (_tmp12_)) {
							break;
						}
						_tmp13_ = _store_it;
						_tmp14_ = gee_iterator_get (_tmp13_);
						store = (ApplicationFolderStoreFactoryFolderStoreImpl*) _tmp14_;
						_tmp15_ = store;
						_tmp16_ = plugin;
						g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, PLUGIN_TYPE_FOLDER_STORE, PluginFolderStore), "folder-selected", _tmp16_);
						_g_object_unref0 (store);
					}
					_g_object_unref0 (_store_it);
				}
			}
			_g_object_unref0 (plugin);
		}
		_g_object_unref0 (selected);
	}
	_g_object_unref0 (main);
}

static inline gpointer
application_folder_store_factory_folder_store_impl_get_instance_private (ApplicationFolderStoreFactoryFolderStoreImpl* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationFolderStoreFactoryFolderStoreImpl_private_offset);
}

static const GVariantType*
application_folder_store_factory_folder_store_impl_real_get_folder_variant_type (PluginFolderStore* base)
{
	const GVariantType* result;
	ApplicationFolderStoreFactoryFolderStoreImpl* self;
	const GVariantType* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, ApplicationFolderStoreFactoryFolderStoreImpl);
	_tmp0_ = self->priv->_folder_variant_type;
	result = _tmp0_;
	return result;
}

static ApplicationFolderStoreFactoryFolderStoreImpl*
application_folder_store_factory_folder_store_impl_construct (GType object_type,
                                                              ApplicationFolderStoreFactory* factory)
{
	ApplicationFolderStoreFactoryFolderStoreImpl * self = NULL;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_STORE_FACTORY (factory), NULL);
	self = (ApplicationFolderStoreFactoryFolderStoreImpl*) geary_base_object_construct (object_type);
	self->priv->factory = factory;
	return self;
}

static ApplicationFolderStoreFactoryFolderStoreImpl*
application_folder_store_factory_folder_store_impl_new (ApplicationFolderStoreFactory* factory)
{
	return application_folder_store_factory_folder_store_impl_construct (APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, factory);
}

static GeeCollection*
application_folder_store_factory_folder_store_impl_real_get_folders (PluginFolderStore* base)
{
	ApplicationFolderStoreFactoryFolderStoreImpl * self;
	ApplicationFolderStoreFactory* _tmp0_;
	GeeMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, ApplicationFolderStoreFactoryFolderStoreImpl);
	_tmp0_ = self->priv->factory;
	_tmp1_ = _tmp0_->priv->folders;
	_tmp2_ = gee_map_get_values (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_collection_get_read_only_view (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	result = _tmp7_;
	return result;
}

static void
application_folder_store_factory_folder_store_impl_real_list_containing_folders_data_free (gpointer _data)
{
	ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->target);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData, _data_);
}

static void
application_folder_store_factory_folder_store_impl_real_list_containing_folders (PluginFolderStore* base,
                                                                                 PluginEmailIdentifier* target,
                                                                                 GCancellable* cancellable,
                                                                                 GAsyncReadyCallback _callback_,
                                                                                 gpointer _user_data_)
{
	ApplicationFolderStoreFactoryFolderStoreImpl * self;
	ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData* _data_;
	ApplicationFolderStoreFactoryFolderStoreImpl* _tmp0_;
	PluginEmailIdentifier* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (PLUGIN_IS_EMAIL_IDENTIFIER (target));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, ApplicationFolderStoreFactoryFolderStoreImpl);
	_data_ = g_slice_new0 (ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_folder_store_factory_folder_store_impl_real_list_containing_folders_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (target);
	_g_object_unref0 (_data_->target);
	_data_->target = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_folder_store_factory_folder_store_impl_real_list_containing_folders_co (_data_);
}

static GeeCollection*
application_folder_store_factory_folder_store_impl_list_containing_folders_finish (PluginFolderStore* base,
                                                                                   GAsyncResult* _res_,
                                                                                   GError** error)
{
	GeeCollection* result;
	ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_folder_store_factory_folder_store_impl_list_containing_folders_ready (GObject* source_object,
                                                                                  GAsyncResult* _res_,
                                                                                  gpointer _user_data_)
{
	ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_folder_store_factory_folder_store_impl_real_list_containing_folders_co (_data_);
}

static gboolean
application_folder_store_factory_folder_store_impl_real_list_containing_folders_co (ApplicationFolderStoreFactoryFolderStoreImplListContainingFoldersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_linked_list_new (PLUGIN_TYPE_FOLDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->folders = _data_->_tmp0_;
	_data_->_tmp1_ = _g_object_ref0 (APPLICATION_EMAIL_STORE_FACTORY_IS_ID_IMPL (_data_->target) ? ((ApplicationEmailStoreFactoryIdImpl*) _data_->target) : NULL);
	_data_->id = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->id;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->id;
		_data_->_tmp4_ = _data_->_tmp3_->account_impl;
		_data_->_tmp5_ = application_plugin_manager_account_impl_get_backing (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
		_data_->context = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->context;
		_data_->_tmp9_ = application_account_context_get_account (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = _data_->id;
		_data_->_tmp12_ = application_email_store_factory_id_impl_get_backing (_data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = geary_collection_single (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_state_ = 1;
		geary_account_get_containing_folders_async (_data_->_tmp10_, _data_->_tmp15_, _data_->cancellable, application_folder_store_factory_folder_store_impl_list_containing_folders_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp16_ = geary_account_get_containing_folders_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp17_ = _data_->_tmp16_;
		_g_object_unref0 (_data_->_tmp15_);
		_data_->multi_folders = _data_->_tmp17_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->context);
			_g_object_unref0 (_data_->id);
			_g_object_unref0 (_data_->folders);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp18_ = _data_->multi_folders;
		if (_data_->_tmp18_ != NULL) {
			{
				_data_->_tmp19_ = _data_->multi_folders;
				_data_->_tmp20_ = _data_->id;
				_data_->_tmp21_ = application_email_store_factory_id_impl_get_backing (_data_->_tmp20_);
				_data_->_tmp22_ = _data_->_tmp21_;
				_data_->_tmp23_ = gee_multi_map_get (_data_->_tmp19_, _data_->_tmp22_);
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_tmp25_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, GEE_TYPE_ITERABLE, GeeIterable));
				_data_->_tmp26_ = _data_->_tmp25_;
				_g_object_unref0 (_data_->_tmp24_);
				_data_->_path_it = _data_->_tmp26_;
				while (TRUE) {
					_data_->_tmp27_ = _data_->_path_it;
					if (!gee_iterator_next (_data_->_tmp27_)) {
						break;
					}
					_data_->_tmp28_ = _data_->_path_it;
					_data_->_tmp29_ = gee_iterator_get (_data_->_tmp28_);
					_data_->path = (GearyFolderPath*) _data_->_tmp29_;
					_data_->_tmp30_ = _data_->context;
					_data_->_tmp31_ = application_account_context_get_account (_data_->_tmp30_);
					_data_->_tmp32_ = _data_->_tmp31_;
					_data_->_tmp33_ = _data_->path;
					_data_->_tmp34_ = geary_account_get_folder (_data_->_tmp32_, _data_->_tmp33_, &_data_->_inner_error0_);
					_data_->folder = _data_->_tmp34_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->path);
						_g_object_unref0 (_data_->_path_it);
						_g_object_unref0 (_data_->multi_folders);
						_g_object_unref0 (_data_->context);
						_g_object_unref0 (_data_->id);
						_g_object_unref0 (_data_->folders);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp35_ = _data_->folders;
					_data_->_tmp36_ = _data_->self->priv->factory;
					_data_->_tmp37_ = _data_->_tmp36_->priv->folders;
					_data_->_tmp38_ = _data_->folder;
					_data_->_tmp39_ = gee_map_get (_data_->_tmp37_, _data_->_tmp38_);
					_data_->_tmp40_ = (ApplicationFolderStoreFactoryFolderImpl*) _data_->_tmp39_;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp35_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp40_, PLUGIN_TYPE_FOLDER, PluginFolder));
					_g_object_unref0 (_data_->_tmp40_);
					_g_object_unref0 (_data_->folder);
					_g_object_unref0 (_data_->path);
				}
				_g_object_unref0 (_data_->_path_it);
			}
		}
		_g_object_unref0 (_data_->multi_folders);
		_g_object_unref0 (_data_->context);
	}
	_data_->result = G_TYPE_CHECK_INSTANCE_CAST (_data_->folders, GEE_TYPE_COLLECTION, GeeCollection);
	_g_object_unref0 (_data_->id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_folder_store_factory_folder_store_impl_real_create_personal_folder_data_free (gpointer _data)
{
	ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->target);
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData, _data_);
}

static void
application_folder_store_factory_folder_store_impl_real_create_personal_folder (PluginFolderStore* base,
                                                                                PluginAccount* target,
                                                                                const gchar* name,
                                                                                GCancellable* cancellable,
                                                                                GAsyncReadyCallback _callback_,
                                                                                gpointer _user_data_)
{
	ApplicationFolderStoreFactoryFolderStoreImpl * self;
	ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData* _data_;
	ApplicationFolderStoreFactoryFolderStoreImpl* _tmp0_;
	PluginAccount* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (PLUGIN_IS_ACCOUNT (target));
	g_return_if_fail (name != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, ApplicationFolderStoreFactoryFolderStoreImpl);
	_data_ = g_slice_new0 (ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_folder_store_factory_folder_store_impl_real_create_personal_folder_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (target);
	_g_object_unref0 (_data_->target);
	_data_->target = _tmp1_;
	_tmp2_ = g_strdup (name);
	_g_free0 (_data_->name);
	_data_->name = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_folder_store_factory_folder_store_impl_real_create_personal_folder_co (_data_);
}

static PluginFolder*
application_folder_store_factory_folder_store_impl_create_personal_folder_finish (PluginFolderStore* base,
                                                                                  GAsyncResult* _res_,
                                                                                  GError** error)
{
	PluginFolder* result;
	ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_folder_store_factory_folder_store_impl_create_personal_folder_ready (GObject* source_object,
                                                                                 GAsyncResult* _res_,
                                                                                 gpointer _user_data_)
{
	ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_folder_store_factory_folder_store_impl_real_create_personal_folder_co (_data_);
}

static gboolean
application_folder_store_factory_folder_store_impl_real_create_personal_folder_co (ApplicationFolderStoreFactoryFolderStoreImplCreatePersonalFolderData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _g_object_ref0 (APPLICATION_PLUGIN_MANAGER_IS_ACCOUNT_IMPL (_data_->target) ? ((ApplicationPluginManagerAccountImpl*) _data_->target) : NULL);
	_data_->account = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->account;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = g_error_new_literal (PLUGIN_ERROR, PLUGIN_ERROR_NOT_SUPPORTED, "Invalid account object");
		_data_->_inner_error0_ = _data_->_tmp2_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->account);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->account;
	_data_->_tmp4_ = application_plugin_manager_account_impl_get_backing (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = application_account_context_get_account (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_state_ = 1;
	geary_account_create_personal_folder (_data_->_tmp7_, _data_->name, GEARY_FOLDER_SPECIAL_USE_NONE, _data_->cancellable, application_folder_store_factory_folder_store_impl_create_personal_folder_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = geary_account_create_personal_folder_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
	_data_->engine = _data_->_tmp8_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->account);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->self->priv->factory;
	_data_->_tmp10_ = _data_->engine;
	_data_->_tmp11_ = application_folder_store_factory_to_plugin_folder (_data_->_tmp9_, _data_->_tmp10_);
	_data_->folder = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->folder;
	if (_data_->_tmp12_ == NULL) {
		_data_->_tmp13_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "No plugin folder found for the created folder");
		_data_->_inner_error0_ = _data_->_tmp13_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->folder);
		_g_object_unref0 (_data_->engine);
		_g_object_unref0 (_data_->account);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->folder;
	_g_object_unref0 (_data_->engine);
	_g_object_unref0 (_data_->account);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static PluginFolder*
application_folder_store_factory_folder_store_impl_real_get_folder_for_variant (PluginFolderStore* base,
                                                                                GVariant* variant)
{
	ApplicationFolderStoreFactoryFolderStoreImpl * self;
	GearyFolder* folder = NULL;
	ApplicationFolderStoreFactory* _tmp0_;
	GearyFolder* _tmp1_;
	ApplicationFolderStoreFactory* _tmp2_;
	GeeMap* _tmp3_;
	gpointer _tmp4_;
	PluginFolder* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, ApplicationFolderStoreFactoryFolderStoreImpl);
	g_return_val_if_fail (variant != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = application_folder_store_factory_get_folder_for_variant (_tmp0_, variant);
	folder = _tmp1_;
	_tmp2_ = self->priv->factory;
	_tmp3_ = _tmp2_->priv->folders;
	_tmp4_ = gee_map_get (_tmp3_, folder);
	result = G_TYPE_CHECK_INSTANCE_CAST ((ApplicationFolderStoreFactoryFolderImpl*) _tmp4_, PLUGIN_TYPE_FOLDER, PluginFolder);
	_g_object_unref0 (folder);
	return result;
}

static void
application_folder_store_factory_folder_store_impl_destroy (ApplicationFolderStoreFactoryFolderStoreImpl* self)
{
	g_return_if_fail (APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_STORE_IMPL (self));
}

static void
application_folder_store_factory_folder_store_impl_class_init (ApplicationFolderStoreFactoryFolderStoreImplClass * klass,
                                                               gpointer klass_data)
{
	application_folder_store_factory_folder_store_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationFolderStoreFactoryFolderStoreImpl_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_application_folder_store_factory_folder_store_impl_get_property;
	G_OBJECT_CLASS (klass)->finalize = application_folder_store_factory_folder_store_impl_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_FOLDER_STORE_FACTORY_FOLDER_STORE_IMPL_FOLDER_VARIANT_TYPE_PROPERTY, application_folder_store_factory_folder_store_impl_properties[APPLICATION_FOLDER_STORE_FACTORY_FOLDER_STORE_IMPL_FOLDER_VARIANT_TYPE_PROPERTY] = g_param_spec_boxed ("folder-variant-type", "folder-variant-type", "folder-variant-type", G_TYPE_VARIANT_TYPE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
application_folder_store_factory_folder_store_impl_plugin_folder_store_interface_init (PluginFolderStoreIface * iface,
                                                                                       gpointer iface_data)
{
	application_folder_store_factory_folder_store_impl_plugin_folder_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_folders = (GeeCollection* (*) (PluginFolderStore*)) application_folder_store_factory_folder_store_impl_real_get_folders;
	iface->list_containing_folders = (void (*) (PluginFolderStore*, PluginEmailIdentifier*, GCancellable*, GAsyncReadyCallback, gpointer)) application_folder_store_factory_folder_store_impl_real_list_containing_folders;
	iface->list_containing_folders_finish = (GeeCollection* (*) (PluginFolderStore*, GAsyncResult*, GError**)) application_folder_store_factory_folder_store_impl_list_containing_folders_finish;
	iface->create_personal_folder = (void (*) (PluginFolderStore*, PluginAccount*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) application_folder_store_factory_folder_store_impl_real_create_personal_folder;
	iface->create_personal_folder_finish = (PluginFolder* (*) (PluginFolderStore*, GAsyncResult*, GError**)) application_folder_store_factory_folder_store_impl_create_personal_folder_finish;
	iface->get_folder_for_variant = (PluginFolder* (*) (PluginFolderStore*, GVariant*)) application_folder_store_factory_folder_store_impl_real_get_folder_for_variant;
	iface->get_folder_variant_type = application_folder_store_factory_folder_store_impl_real_get_folder_variant_type;
}

static void
application_folder_store_factory_folder_store_impl_instance_init (ApplicationFolderStoreFactoryFolderStoreImpl * self,
                                                                  gpointer klass)
{
	GVariantType* _tmp0_;
	self->priv = application_folder_store_factory_folder_store_impl_get_instance_private (self);
	_tmp0_ = g_variant_type_new ("(sv)");
	self->priv->_folder_variant_type = _tmp0_;
}

static void
application_folder_store_factory_folder_store_impl_finalize (GObject * obj)
{
	ApplicationFolderStoreFactoryFolderStoreImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, ApplicationFolderStoreFactoryFolderStoreImpl);
	_g_variant_type_free0 (self->priv->_folder_variant_type);
	G_OBJECT_CLASS (application_folder_store_factory_folder_store_impl_parent_class)->finalize (obj);
}

static GType
application_folder_store_factory_folder_store_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationFolderStoreFactoryFolderStoreImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_folder_store_factory_folder_store_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationFolderStoreFactoryFolderStoreImpl), 0, (GInstanceInitFunc) application_folder_store_factory_folder_store_impl_instance_init, NULL };
	static const GInterfaceInfo plugin_folder_store_info = { (GInterfaceInitFunc) application_folder_store_factory_folder_store_impl_plugin_folder_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType application_folder_store_factory_folder_store_impl_type_id;
	application_folder_store_factory_folder_store_impl_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationFolderStoreFactoryFolderStoreImpl", &g_define_type_info, 0);
	g_type_add_interface_static (application_folder_store_factory_folder_store_impl_type_id, PLUGIN_TYPE_FOLDER_STORE, &plugin_folder_store_info);
	ApplicationFolderStoreFactoryFolderStoreImpl_private_offset = g_type_add_instance_private (application_folder_store_factory_folder_store_impl_type_id, sizeof (ApplicationFolderStoreFactoryFolderStoreImplPrivate));
	return application_folder_store_factory_folder_store_impl_type_id;
}

static GType
application_folder_store_factory_folder_store_impl_get_type (void)
{
	static volatile gsize application_folder_store_factory_folder_store_impl_type_id__once = 0;
	if (g_once_init_enter (&application_folder_store_factory_folder_store_impl_type_id__once)) {
		GType application_folder_store_factory_folder_store_impl_type_id;
		application_folder_store_factory_folder_store_impl_type_id = application_folder_store_factory_folder_store_impl_get_type_once ();
		g_once_init_leave (&application_folder_store_factory_folder_store_impl_type_id__once, application_folder_store_factory_folder_store_impl_type_id);
	}
	return application_folder_store_factory_folder_store_impl_type_id__once;
}

static void
_vala_application_folder_store_factory_folder_store_impl_get_property (GObject * object,
                                                                       guint property_id,
                                                                       GValue * value,
                                                                       GParamSpec * pspec)
{
	ApplicationFolderStoreFactoryFolderStoreImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, ApplicationFolderStoreFactoryFolderStoreImpl);
	switch (property_id) {
		case APPLICATION_FOLDER_STORE_FACTORY_FOLDER_STORE_IMPL_FOLDER_VARIANT_TYPE_PROPERTY:
		g_value_set_boxed (value, plugin_folder_store_get_folder_variant_type (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER_STORE, PluginFolderStore)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
application_folder_store_factory_folder_impl_get_instance_private (ApplicationFolderStoreFactoryFolderImpl* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationFolderStoreFactoryFolderImpl_private_offset);
}

static const gchar*
application_folder_store_factory_folder_impl_real_get_persistent_id (PluginFolder* base)
{
	const gchar* result;
	ApplicationFolderStoreFactoryFolderImpl* self;
	const gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImpl);
	_tmp0_ = self->priv->_persistent_id;
	result = _tmp0_;
	return result;
}

static const gchar*
application_folder_store_factory_folder_impl_real_get_display_name (PluginFolder* base)
{
	const gchar* result;
	ApplicationFolderStoreFactoryFolderImpl* self;
	ApplicationFolderContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImpl);
	_tmp0_ = self->priv->_backing;
	_tmp1_ = application_folder_context_get_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static GearyFolderSpecialUse
application_folder_store_factory_folder_impl_real_get_used_as (PluginFolder* base)
{
	GearyFolderSpecialUse result;
	ApplicationFolderStoreFactoryFolderImpl* self;
	ApplicationFolderContext* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	GearyFolderSpecialUse _tmp3_;
	GearyFolderSpecialUse _tmp4_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImpl);
	_tmp0_ = self->priv->_backing;
	_tmp1_ = application_folder_context_get_folder (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_folder_get_used_as (_tmp2_);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}

static PluginAccount*
application_folder_store_factory_folder_impl_real_get_account (PluginFolder* base)
{
	PluginAccount* result;
	ApplicationFolderStoreFactoryFolderImpl* self;
	ApplicationPluginManagerAccountImpl* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImpl);
	_tmp0_ = self->priv->_account;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PLUGIN_TYPE_ACCOUNT, PluginAccount);
	return result;
}

static ApplicationFolderContext*
application_folder_store_factory_folder_impl_get_backing (ApplicationFolderStoreFactoryFolderImpl* self)
{
	ApplicationFolderContext* result;
	ApplicationFolderContext* _tmp0_;
	g_return_val_if_fail (APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_IMPL (self), NULL);
	_tmp0_ = self->priv->_backing;
	result = _tmp0_;
	return result;
}

static void
application_folder_store_factory_folder_impl_set_backing (ApplicationFolderStoreFactoryFolderImpl* self,
                                                          ApplicationFolderContext* value)
{
	ApplicationFolderContext* old_value;
	g_return_if_fail (APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_IMPL (self));
	old_value = application_folder_store_factory_folder_impl_get_backing (self);
	if (old_value != value) {
		ApplicationFolderContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_backing);
		self->priv->_backing = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_folder_store_factory_folder_impl_properties[APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_BACKING_PROPERTY]);
	}
}

static ApplicationFolderStoreFactoryFolderImpl*
application_folder_store_factory_folder_impl_construct (GType object_type,
                                                        ApplicationFolderContext* backing,
                                                        ApplicationPluginManagerAccountImpl* account)
{
	ApplicationFolderStoreFactoryFolderImpl * self = NULL;
	ApplicationPluginManagerAccountImpl* _tmp0_;
	ApplicationAccountContext* _tmp1_;
	ApplicationAccountContext* _tmp2_;
	GearyAccount* _tmp3_;
	GearyAccount* _tmp4_;
	GearyAccountInformation* _tmp5_;
	GearyAccountInformation* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GearyFolder* _tmp9_;
	GearyFolder* _tmp10_;
	GearyFolderPath* _tmp11_;
	GearyFolderPath* _tmp12_;
	gint _tmp13_ = 0;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	g_return_val_if_fail (APPLICATION_IS_FOLDER_CONTEXT (backing), NULL);
	g_return_val_if_fail ((account == NULL) || APPLICATION_PLUGIN_MANAGER_IS_ACCOUNT_IMPL (account), NULL);
	self = (ApplicationFolderStoreFactoryFolderImpl*) geary_base_object_construct (object_type);
	application_folder_store_factory_folder_impl_set_backing (self, backing);
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (self->priv->_account);
	self->priv->_account = _tmp0_;
	_tmp1_ = application_plugin_manager_account_impl_get_backing (account);
	_tmp2_ = _tmp1_;
	_tmp3_ = application_account_context_get_account (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_account_get_information (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_account_information_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = application_folder_context_get_folder (backing);
	_tmp10_ = _tmp9_;
	_tmp11_ = geary_folder_get_path (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp14_ = geary_folder_path_as_array (_tmp12_, &_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp13_;
	_tmp16_ = g_strjoin (APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_ID_PATH_SEP, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf (APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_ID_FORMAT, _tmp8_, _tmp17_);
	_g_free0 (self->priv->_persistent_id);
	self->priv->_persistent_id = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	application_folder_store_factory_folder_impl_folder_type_changed (self);
	return self;
}

static ApplicationFolderStoreFactoryFolderImpl*
application_folder_store_factory_folder_impl_new (ApplicationFolderContext* backing,
                                                  ApplicationPluginManagerAccountImpl* account)
{
	return application_folder_store_factory_folder_impl_construct (APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, backing, account);
}

static GVariant*
_variant_new3 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
application_folder_store_factory_folder_impl_real_to_variant (PluginFolder* base)
{
	ApplicationFolderStoreFactoryFolderImpl * self;
	GearyFolder* folder = NULL;
	ApplicationFolderContext* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	GearyFolder* _tmp3_;
	GearyAccount* _tmp4_;
	GearyAccount* _tmp5_;
	GearyAccountInformation* _tmp6_;
	GearyAccountInformation* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GVariant* _tmp10_;
	GearyFolderPath* _tmp11_;
	GearyFolderPath* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GVariant** _tmp16_;
	GVariant** _tmp17_;
	gint _tmp17__length1;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GVariant* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImpl);
	_tmp0_ = self->priv->_backing;
	_tmp1_ = application_folder_context_get_folder (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	folder = _tmp3_;
	_tmp4_ = geary_folder_get_account (folder);
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_account_get_information (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = geary_account_information_get_id (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _variant_new3 (_tmp9_);
	_tmp11_ = geary_folder_get_path (folder);
	_tmp12_ = _tmp11_;
	_tmp13_ = geary_folder_path_to_variant (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_variant_new_variant (_tmp14_);
	g_variant_ref_sink (_tmp15_);
	_tmp16_ = g_new0 (GVariant*, 2 + 1);
	_tmp16_[0] = _tmp10_;
	_tmp16_[1] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 2;
	_tmp18_ = g_variant_new_tuple (_tmp17_, 2);
	g_variant_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_variant_unref0 (_tmp14_);
	result = _tmp19_;
	_g_object_unref0 (folder);
	return result;
}

static void
application_folder_store_factory_folder_impl_folder_type_changed (ApplicationFolderStoreFactoryFolderImpl* self)
{
	g_return_if_fail (APPLICATION_FOLDER_STORE_FACTORY_IS_FOLDER_IMPL (self));
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "used-as");
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "display-name");
}

static void
application_folder_store_factory_folder_impl_class_init (ApplicationFolderStoreFactoryFolderImplClass * klass,
                                                         gpointer klass_data)
{
	application_folder_store_factory_folder_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationFolderStoreFactoryFolderImpl_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_application_folder_store_factory_folder_impl_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_folder_store_factory_folder_impl_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_folder_store_factory_folder_impl_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_PERSISTENT_ID_PROPERTY, application_folder_store_factory_folder_impl_properties[APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_PERSISTENT_ID_PROPERTY] = g_param_spec_string ("persistent-id", "persistent-id", "persistent-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_DISPLAY_NAME_PROPERTY, application_folder_store_factory_folder_impl_properties[APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_USED_AS_PROPERTY, application_folder_store_factory_folder_impl_properties[APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_USED_AS_PROPERTY] = g_param_spec_enum ("used-as", "used-as", "used-as", GEARY_FOLDER_TYPE_SPECIAL_USE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_ACCOUNT_PROPERTY, application_folder_store_factory_folder_impl_properties[APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", PLUGIN_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_BACKING_PROPERTY, application_folder_store_factory_folder_impl_properties[APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_BACKING_PROPERTY] = g_param_spec_object ("backing", "backing", "backing", APPLICATION_TYPE_FOLDER_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
application_folder_store_factory_folder_impl_plugin_folder_interface_init (PluginFolderIface * iface,
                                                                           gpointer iface_data)
{
	application_folder_store_factory_folder_impl_plugin_folder_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_variant = (GVariant* (*) (PluginFolder*)) application_folder_store_factory_folder_impl_real_to_variant;
	iface->get_persistent_id = application_folder_store_factory_folder_impl_real_get_persistent_id;
	iface->get_display_name = application_folder_store_factory_folder_impl_real_get_display_name;
	iface->get_used_as = application_folder_store_factory_folder_impl_real_get_used_as;
	iface->get_account = application_folder_store_factory_folder_impl_real_get_account;
}

static void
application_folder_store_factory_folder_impl_instance_init (ApplicationFolderStoreFactoryFolderImpl * self,
                                                            gpointer klass)
{
	self->priv = application_folder_store_factory_folder_impl_get_instance_private (self);
}

static void
application_folder_store_factory_folder_impl_finalize (GObject * obj)
{
	ApplicationFolderStoreFactoryFolderImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImpl);
	_g_free0 (self->priv->_persistent_id);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->priv->_backing);
	G_OBJECT_CLASS (application_folder_store_factory_folder_impl_parent_class)->finalize (obj);
}

static GType
application_folder_store_factory_folder_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationFolderStoreFactoryFolderImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_folder_store_factory_folder_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationFolderStoreFactoryFolderImpl), 0, (GInstanceInitFunc) application_folder_store_factory_folder_impl_instance_init, NULL };
	static const GInterfaceInfo plugin_folder_info = { (GInterfaceInitFunc) application_folder_store_factory_folder_impl_plugin_folder_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType application_folder_store_factory_folder_impl_type_id;
	application_folder_store_factory_folder_impl_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationFolderStoreFactoryFolderImpl", &g_define_type_info, 0);
	g_type_add_interface_static (application_folder_store_factory_folder_impl_type_id, PLUGIN_TYPE_FOLDER, &plugin_folder_info);
	ApplicationFolderStoreFactoryFolderImpl_private_offset = g_type_add_instance_private (application_folder_store_factory_folder_impl_type_id, sizeof (ApplicationFolderStoreFactoryFolderImplPrivate));
	return application_folder_store_factory_folder_impl_type_id;
}

static GType
application_folder_store_factory_folder_impl_get_type (void)
{
	static volatile gsize application_folder_store_factory_folder_impl_type_id__once = 0;
	if (g_once_init_enter (&application_folder_store_factory_folder_impl_type_id__once)) {
		GType application_folder_store_factory_folder_impl_type_id;
		application_folder_store_factory_folder_impl_type_id = application_folder_store_factory_folder_impl_get_type_once ();
		g_once_init_leave (&application_folder_store_factory_folder_impl_type_id__once, application_folder_store_factory_folder_impl_type_id);
	}
	return application_folder_store_factory_folder_impl_type_id__once;
}

static void
_vala_application_folder_store_factory_folder_impl_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	ApplicationFolderStoreFactoryFolderImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImpl);
	switch (property_id) {
		case APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_PERSISTENT_ID_PROPERTY:
		g_value_set_string (value, plugin_folder_get_persistent_id (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER, PluginFolder)));
		break;
		case APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, plugin_folder_get_display_name (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER, PluginFolder)));
		break;
		case APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_USED_AS_PROPERTY:
		g_value_set_enum (value, plugin_folder_get_used_as (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER, PluginFolder)));
		break;
		case APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_ACCOUNT_PROPERTY:
		g_value_set_object (value, plugin_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER, PluginFolder)));
		break;
		case APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_BACKING_PROPERTY:
		g_value_set_object (value, application_folder_store_factory_folder_impl_get_backing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_folder_store_factory_folder_impl_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	ApplicationFolderStoreFactoryFolderImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, ApplicationFolderStoreFactoryFolderImpl);
	switch (property_id) {
		case APPLICATION_FOLDER_STORE_FACTORY_FOLDER_IMPL_BACKING_PROPERTY:
		application_folder_store_factory_folder_impl_set_backing (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
application_folder_store_factory_class_init (ApplicationFolderStoreFactoryClass * klass,
                                             gpointer klass_data)
{
	application_folder_store_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationFolderStoreFactory_private_offset);
	G_OBJECT_CLASS (klass)->finalize = application_folder_store_factory_finalize;
}

static void
application_folder_store_factory_instance_init (ApplicationFolderStoreFactory * self,
                                                gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashSet* _tmp1_;
	self->priv = application_folder_store_factory_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (GEARY_TYPE_FOLDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_IMPL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->folders = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	_tmp1_ = gee_hash_set_new (APPLICATION_FOLDER_STORE_FACTORY_TYPE_FOLDER_STORE_IMPL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->stores = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
}

static void
application_folder_store_factory_finalize (GObject * obj)
{
	ApplicationFolderStoreFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_FOLDER_STORE_FACTORY, ApplicationFolderStoreFactory);
	_g_object_unref0 (self->priv->accounts);
	_g_object_unref0 (self->priv->folders);
	_g_object_unref0 (self->priv->stores);
	G_OBJECT_CLASS (application_folder_store_factory_parent_class)->finalize (obj);
}

/**
 * A factory for constructing plugin folder stores and folder objects.
 *
 * This class provides a common implementation that shares folder
 * objects between different plugin context instances.
 */
static GType
application_folder_store_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationFolderStoreFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_folder_store_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationFolderStoreFactory), 0, (GInstanceInitFunc) application_folder_store_factory_instance_init, NULL };
	GType application_folder_store_factory_type_id;
	application_folder_store_factory_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationFolderStoreFactory", &g_define_type_info, 0);
	ApplicationFolderStoreFactory_private_offset = g_type_add_instance_private (application_folder_store_factory_type_id, sizeof (ApplicationFolderStoreFactoryPrivate));
	return application_folder_store_factory_type_id;
}

GType
application_folder_store_factory_get_type (void)
{
	static volatile gsize application_folder_store_factory_type_id__once = 0;
	if (g_once_init_enter (&application_folder_store_factory_type_id__once)) {
		GType application_folder_store_factory_type_id;
		application_folder_store_factory_type_id = application_folder_store_factory_get_type_once ();
		g_once_init_leave (&application_folder_store_factory_type_id__once, application_folder_store_factory_type_id);
	}
	return application_folder_store_factory_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

