/* WindowManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowManager.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "gala.h"
#include <clutter/clutter.h>
#include <glib.h>
#include <meta/keybindings.h>
#include <glib-object.h>
#include <meta/window.h>
#include <meta/workspace.h>
#include <meta/common.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_MODAL_PROXY_0_PROPERTY,
	GALA_MODAL_PROXY_GRAB_PROPERTY,
	GALA_MODAL_PROXY_NUM_PROPERTIES
};
static GParamSpec* gala_modal_proxy_properties[GALA_MODAL_PROXY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaModalProxyPrivate {
	ClutterGrab* _grab;
	GalaGestureAction* allowed_actions;
	gint allowed_actions_length1;
	gint _allowed_actions_size_;
	GalaKeybindingFilter _keybinding_filter;
	gpointer _keybinding_filter_target;
	GDestroyNotify _keybinding_filter_target_destroy_notify;
};

static gint GalaModalProxy_private_offset;
static gpointer gala_modal_proxy_parent_class = NULL;

static gboolean _gala_modal_proxy__keybinding_filter_lambda21_ (void);
static gboolean __gala_modal_proxy__keybinding_filter_lambda21__gala_keybinding_filter (MetaKeyBinding* binding,
                                                                                 gpointer self);
static GalaGestureAction* _vala_array_dup5 (GalaGestureAction* self,
                                     gssize length);
static gboolean _vala_gala_gesture_action_array_contains (GalaGestureAction * stack,
                                                   gssize stack_length,
                                                   const GalaGestureAction needle);
static void gala_modal_proxy_finalize (GObject * obj);
static GType gala_modal_proxy_get_type_once (void);
static void _vala_gala_modal_proxy_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_gala_modal_proxy_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static GType gala_window_manager_get_type_once (void);

static inline gpointer
gala_modal_proxy_get_instance_private (GalaModalProxy* self)
{
	return G_STRUCT_MEMBER_P (self, GalaModalProxy_private_offset);
}

static gboolean
_gala_modal_proxy__keybinding_filter_lambda21_ (void)
{
	gboolean result;
	result = TRUE;
	return result;
}

static gboolean
__gala_modal_proxy__keybinding_filter_lambda21__gala_keybinding_filter (MetaKeyBinding* binding,
                                                                        gpointer self)
{
	gboolean result;
	result = _gala_modal_proxy__keybinding_filter_lambda21_ ();
	return result;
}

GalaKeybindingFilter
gala_modal_proxy_get_keybinding_filter (GalaModalProxy* self,
                                        gpointer* result_target)
{
	GalaKeybindingFilter _tmp0_;
	gpointer _tmp0__target;
	GalaKeybindingFilter _tmp1_;
	gpointer _tmp1__target;
	GalaKeybindingFilter result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keybinding_filter;
	_tmp0__target = self->priv->_keybinding_filter_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}

void
gala_modal_proxy_set_keybinding_filter (GalaModalProxy* self,
                                        GalaKeybindingFilter filter,
                                        gpointer filter_target)
{
	g_return_if_fail (self != NULL);
	(self->priv->_keybinding_filter_target_destroy_notify == NULL) ? NULL : (self->priv->_keybinding_filter_target_destroy_notify (self->priv->_keybinding_filter_target), NULL);
	self->priv->_keybinding_filter = NULL;
	self->priv->_keybinding_filter_target = NULL;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
	self->priv->_keybinding_filter = filter;
	self->priv->_keybinding_filter_target = filter_target;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
}

GalaModalProxy*
gala_modal_proxy_construct (GType object_type)
{
	GalaModalProxy * self = NULL;
	self = (GalaModalProxy*) g_object_new (object_type, NULL);
	return self;
}

GalaModalProxy*
gala_modal_proxy_new (void)
{
	return gala_modal_proxy_construct (GALA_TYPE_MODAL_PROXY);
}

/**
         * Small utility to allow all keybindings
         */
void
gala_modal_proxy_allow_all_keybindings (GalaModalProxy* self)
{
	g_return_if_fail (self != NULL);
	(self->priv->_keybinding_filter_target_destroy_notify == NULL) ? NULL : (self->priv->_keybinding_filter_target_destroy_notify (self->priv->_keybinding_filter_target), NULL);
	self->priv->_keybinding_filter = NULL;
	self->priv->_keybinding_filter_target = NULL;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
	self->priv->_keybinding_filter = NULL;
	self->priv->_keybinding_filter_target = NULL;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
}

static GalaGestureAction*
_vala_array_dup5 (GalaGestureAction* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (GalaGestureAction));
	}
	return NULL;
}

void
gala_modal_proxy_allow_actions (GalaModalProxy* self,
                                GalaGestureAction* actions,
                                gint actions_length1)
{
	GalaGestureAction* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (actions != NULL) ? _vala_array_dup5 (actions, actions_length1) : actions;
	_tmp0__length1 = actions_length1;
	self->priv->allowed_actions = (g_free (self->priv->allowed_actions), NULL);
	self->priv->allowed_actions = _tmp0_;
	self->priv->allowed_actions_length1 = _tmp0__length1;
	self->priv->_allowed_actions_size_ = self->priv->allowed_actions_length1;
}

static gboolean
_vala_gala_gesture_action_array_contains (GalaGestureAction * stack,
                                          gssize stack_length,
                                          const GalaGestureAction needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
gala_modal_proxy_filter_action (GalaModalProxy* self,
                                GalaGestureAction action)
{
	GalaGestureAction* _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->allowed_actions;
	_tmp0__length1 = self->priv->allowed_actions_length1;
	result = !_vala_gala_gesture_action_array_contains (_tmp0_, _tmp0__length1, action);
	return result;
}

ClutterGrab*
gala_modal_proxy_get_grab (GalaModalProxy* self)
{
	ClutterGrab* result;
	ClutterGrab* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_grab;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_modal_proxy_set_grab (GalaModalProxy* self,
                           ClutterGrab* value)
{
	ClutterGrab* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_modal_proxy_get_grab (self);
	if (old_value != value) {
		ClutterGrab* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_grab);
		self->priv->_grab = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_modal_proxy_properties[GALA_MODAL_PROXY_GRAB_PROPERTY]);
	}
}

static void
gala_modal_proxy_class_init (GalaModalProxyClass * klass,
                             gpointer klass_data)
{
	gala_modal_proxy_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaModalProxy_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_modal_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_modal_proxy_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_modal_proxy_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MODAL_PROXY_GRAB_PROPERTY, gala_modal_proxy_properties[GALA_MODAL_PROXY_GRAB_PROPERTY] = g_param_spec_object ("grab", "grab", "grab", clutter_grab_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gala_modal_proxy_instance_init (GalaModalProxy * self,
                                gpointer klass)
{
	self->priv = gala_modal_proxy_get_instance_private (self);
	self->priv->_keybinding_filter = __gala_modal_proxy__keybinding_filter_lambda21__gala_keybinding_filter;
	self->priv->_keybinding_filter_target = NULL;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
}

static void
gala_modal_proxy_finalize (GObject * obj)
{
	GalaModalProxy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MODAL_PROXY, GalaModalProxy);
	_g_object_unref0 (self->priv->_grab);
	self->priv->allowed_actions = (g_free (self->priv->allowed_actions), NULL);
	(self->priv->_keybinding_filter_target_destroy_notify == NULL) ? NULL : (self->priv->_keybinding_filter_target_destroy_notify (self->priv->_keybinding_filter_target), NULL);
	self->priv->_keybinding_filter = NULL;
	self->priv->_keybinding_filter_target = NULL;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gala_modal_proxy_parent_class)->finalize (obj);
}

/**
     * A minimal class mostly used to identify your call to {@link WindowManager.push_modal} and used
     * to end your modal mode again with {@link WindowManager.pop_modal}
     */
 G_GNUC_NO_INLINE static GType
gala_modal_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaModalProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_modal_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaModalProxy), 0, (GInstanceInitFunc) gala_modal_proxy_instance_init, NULL };
	GType gala_modal_proxy_type_id;
	gala_modal_proxy_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaModalProxy", &g_define_type_info, 0);
	GalaModalProxy_private_offset = g_type_add_instance_private (gala_modal_proxy_type_id, sizeof (GalaModalProxyPrivate));
	return gala_modal_proxy_type_id;
}

GType
gala_modal_proxy_get_type (void)
{
	static gsize gala_modal_proxy_type_id__once = 0;
	if (g_once_init_enter (&gala_modal_proxy_type_id__once)) {
		GType gala_modal_proxy_type_id;
		gala_modal_proxy_type_id = gala_modal_proxy_get_type_once ();
		g_once_init_leave (&gala_modal_proxy_type_id__once, gala_modal_proxy_type_id);
	}
	return gala_modal_proxy_type_id__once;
}

static void
_vala_gala_modal_proxy_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GalaModalProxy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MODAL_PROXY, GalaModalProxy);
	switch (property_id) {
		case GALA_MODAL_PROXY_GRAB_PROPERTY:
		g_value_set_object (value, gala_modal_proxy_get_grab (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_modal_proxy_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GalaModalProxy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MODAL_PROXY, GalaModalProxy);
	switch (property_id) {
		case GALA_MODAL_PROXY_GRAB_PROPERTY:
		gala_modal_proxy_set_grab (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

/**
         * Enters the modal mode, which will block keybindings and gestures. See {@link ModalProxy} for
         * how to allow certain gestures and keybindings.
         * If {@link grab} is true all events will be redirected to the given {@link Clutter.Actor}.
         * If {@link grab} is false other actors and shell windows may still receive events.
         * Normal windows will never receive keyboard focus though they will still receive pointer events
         * if {@link grab} is false and their {@link Meta.WindowActor} is visible.
         *
         * @param actor The actor to grab events for
         * @param grab Whether to grab all events onto the actor
         *
         * @return a {@link ModalProxy} which is needed to end the modal mode again and provides some
         *         some basic control on the behavior of the window manager while it is in modal mode.
         */
GalaModalProxy*
gala_window_manager_push_modal (GalaWindowManager* self,
                                ClutterActor* actor,
                                gboolean grab)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->push_modal) {
		return _iface_->push_modal (self, actor, grab);
	}
	return NULL;
}

/**
         * May exit the modal mode again, unless another component has called {@link push_modal}
         *
         * @param proxy The {@link ModalProxy} received from {@link push_modal}
         */
void
gala_window_manager_pop_modal (GalaWindowManager* self,
                               GalaModalProxy* proxy)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->pop_modal) {
		_iface_->pop_modal (self, proxy);
	}
}

/**
         * Returns whether the window manager is currently in modal mode.
         * @see push_modal
         */
gboolean
gala_window_manager_is_modal (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->is_modal) {
		return _iface_->is_modal (self);
	}
	return FALSE;
}

/**
         * Tests if a given {@link ModalProxy} is valid and may be popped. Should not be necessary
         * to use this function in most cases, but it may be helpful for debugging. Gala catches
         * invalid proxies as well and emits a warning in that case.
         *
         * @param proxy The {@link ModalProxy} to check
         * @return      Returns true if the prox is valid
         */
gboolean
gala_window_manager_modal_proxy_valid (GalaWindowManager* self,
                                       GalaModalProxy* proxy)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->modal_proxy_valid) {
		return _iface_->modal_proxy_valid (self, proxy);
	}
	return FALSE;
}

/**
         * Tells the window manager to perform the given action.
         *
         * @param type The type of action to perform
         */
void
gala_window_manager_perform_action (GalaWindowManager* self,
                                    GalaActionType type)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->perform_action) {
		_iface_->perform_action (self, type);
	}
}

/**
         * Moves the window to the given workspace.
         *
         * @param window    The window to be moved
         * @param workspace The workspace the window should be moved to
         */
void
gala_window_manager_move_window (GalaWindowManager* self,
                                 MetaWindow* window,
                                 MetaWorkspace* workspace,
                                 guint32 timestamp)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->move_window) {
		_iface_->move_window (self, window, workspace, timestamp);
	}
}

/**
         * Switches to the next workspace in the given direction.
         *
         * @param direction The direction in which to switch
         */
void
gala_window_manager_switch_to_next_workspace (GalaWindowManager* self,
                                              MetaMotionDirection direction,
                                              guint32 timestamp)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->switch_to_next_workspace) {
		_iface_->switch_to_next_workspace (self, direction, timestamp);
	}
}

/**
         * Gets action command from gsettings and executes it.
         *
         * @param action_key The gsettings key of action. Available keys are stored in ActionKeys
         */
void
gala_window_manager_launch_action (GalaWindowManager* self,
                                   const gchar* action_key)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->launch_action) {
		_iface_->launch_action (self, action_key);
	}
}

/**
         * Checks whether the action should currently be prohibited.
         * @return true if the action should be prohibited, false otherwise
         */
gboolean
gala_window_manager_filter_action (GalaWindowManager* self,
                                   GalaGestureAction action)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->filter_action) {
		return _iface_->filter_action (self, action);
	}
	return FALSE;
}

ClutterActor*
gala_window_manager_get_ui_group (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_ui_group) {
		return _iface_->get_ui_group (self);
	}
	return NULL;
}

void
gala_window_manager_set_ui_group (GalaWindowManager* self,
                                  ClutterActor* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_ui_group) {
		_iface_->set_ui_group (self, value);
	}
}

ClutterStage*
gala_window_manager_get_stage (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_stage) {
		return _iface_->get_stage (self);
	}
	return NULL;
}

void
gala_window_manager_set_stage (GalaWindowManager* self,
                               ClutterStage* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_stage) {
		_iface_->set_stage (self, value);
	}
}

ClutterActor*
gala_window_manager_get_window_group (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_window_group) {
		return _iface_->get_window_group (self);
	}
	return NULL;
}

void
gala_window_manager_set_window_group (GalaWindowManager* self,
                                      ClutterActor* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_window_group) {
		_iface_->set_window_group (self, value);
	}
}

ClutterActor*
gala_window_manager_get_top_window_group (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_top_window_group) {
		return _iface_->get_top_window_group (self);
	}
	return NULL;
}

void
gala_window_manager_set_top_window_group (GalaWindowManager* self,
                                          ClutterActor* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_top_window_group) {
		_iface_->set_top_window_group (self, value);
	}
}

MetaBackgroundGroup*
gala_window_manager_get_background_group (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_background_group) {
		return _iface_->get_background_group (self);
	}
	return NULL;
}

void
gala_window_manager_set_background_group (GalaWindowManager* self,
                                          MetaBackgroundGroup* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_background_group) {
		_iface_->set_background_group (self, value);
	}
}

static void
gala_window_manager_default_init (GalaWindowManagerIface * iface,
                                  gpointer iface_data)
{
	/**
	         * This is the container you'll most likely want to add your component to. It wraps
	         * every other container listed in this interface and is a direct child of the stage.
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("ui-group", "ui-group", "ui-group", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The stage of the window manager
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("stage", "stage", "stage", clutter_stage_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * A group containing all 'usual' windows
	         * @see top_window_group
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("window-group", "window-group", "window-group", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The top window group contains special windows that are always placed on top
	         * like fullscreen windows.
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("top-window-group", "top-window-group", "top-window-group", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The background group is a container for the background actors forming the wallpaper
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("background-group", "background-group", "background-group", meta_background_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

 G_GNUC_NO_INLINE static GType
gala_window_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_window_manager_type_id;
	gala_window_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaWindowManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_window_manager_type_id, meta_plugin_get_type ());
	return gala_window_manager_type_id;
}

GType
gala_window_manager_get_type (void)
{
	static gsize gala_window_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_window_manager_type_id__once)) {
		GType gala_window_manager_type_id;
		gala_window_manager_type_id = gala_window_manager_get_type_once ();
		g_once_init_leave (&gala_window_manager_type_id__once, gala_window_manager_type_id);
	}
	return gala_window_manager_type_id__once;
}

