/* BrowseTreeView.c generated by valac 0.56.18, the Vala compiler
 * generated from BrowseTreeView.vala, do not modify */

/* BrowseTreeView.vala
 *
 * Copyright (C) 2024 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include "font-manager.h"
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_CELL_RENDERER_HEADER (font_manager_cell_renderer_header_get_type ())
#define FONT_MANAGER_CELL_RENDERER_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CELL_RENDERER_HEADER, FontManagerCellRendererHeader))
#define FONT_MANAGER_CELL_RENDERER_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CELL_RENDERER_HEADER, FontManagerCellRendererHeaderClass))
#define FONT_MANAGER_IS_CELL_RENDERER_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CELL_RENDERER_HEADER))
#define FONT_MANAGER_IS_CELL_RENDERER_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CELL_RENDERER_HEADER))
#define FONT_MANAGER_CELL_RENDERER_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CELL_RENDERER_HEADER, FontManagerCellRendererHeaderClass))

typedef struct _FontManagerCellRendererHeader FontManagerCellRendererHeader;
typedef struct _FontManagerCellRendererHeaderClass FontManagerCellRendererHeaderClass;
typedef struct _FontManagerCellRendererHeaderPrivate FontManagerCellRendererHeaderPrivate;
enum  {
	FONT_MANAGER_CELL_RENDERER_HEADER_0_PROPERTY,
	FONT_MANAGER_CELL_RENDERER_HEADER_STYLE_CLASS_PROPERTY,
	FONT_MANAGER_CELL_RENDERER_HEADER_RENDER_BACKGROUND_PROPERTY,
	FONT_MANAGER_CELL_RENDERER_HEADER_NUM_PROPERTIES
};
static GParamSpec* font_manager_cell_renderer_header_properties[FONT_MANAGER_CELL_RENDERER_HEADER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FONT_MANAGER_TYPE_BROWSE_LIST_VIEW (font_manager_browse_list_view_get_type ())
#define FONT_MANAGER_BROWSE_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BROWSE_LIST_VIEW, FontManagerBrowseListView))
#define FONT_MANAGER_BROWSE_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BROWSE_LIST_VIEW, FontManagerBrowseListViewClass))
#define FONT_MANAGER_IS_BROWSE_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BROWSE_LIST_VIEW))
#define FONT_MANAGER_IS_BROWSE_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BROWSE_LIST_VIEW))
#define FONT_MANAGER_BROWSE_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BROWSE_LIST_VIEW, FontManagerBrowseListViewClass))

typedef struct _FontManagerBrowseListView FontManagerBrowseListView;
typedef struct _FontManagerBrowseListViewClass FontManagerBrowseListViewClass;
typedef struct _FontManagerBrowseListViewPrivate FontManagerBrowseListViewPrivate;

#define FONT_MANAGER_TYPE_BASE_FONT_MODEL (font_manager_base_font_model_get_type ())
#define FONT_MANAGER_BASE_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModel))
#define FONT_MANAGER_BASE_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModelClass))
#define FONT_MANAGER_IS_BASE_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL))
#define FONT_MANAGER_IS_BASE_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_FONT_MODEL))
#define FONT_MANAGER_BASE_FONT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModelClass))

typedef struct _FontManagerBaseFontModel FontManagerBaseFontModel;
typedef struct _FontManagerBaseFontModelClass FontManagerBaseFontModelClass;
enum  {
	FONT_MANAGER_BROWSE_LIST_VIEW_0_PROPERTY,
	FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_SIZE_PROPERTY,
	FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_TEXT_PROPERTY,
	FONT_MANAGER_BROWSE_LIST_VIEW_FONT_MODEL_PROPERTY,
	FONT_MANAGER_BROWSE_LIST_VIEW_NUM_PROPERTIES
};
static GParamSpec* font_manager_browse_list_view_properties[FONT_MANAGER_BROWSE_LIST_VIEW_NUM_PROPERTIES];
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define FONT_MANAGER_TYPE_FONT_MODEL (font_manager_font_model_get_type ())
#define FONT_MANAGER_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModel))
#define FONT_MANAGER_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModelClass))
#define FONT_MANAGER_IS_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_MODEL))
#define FONT_MANAGER_IS_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_MODEL))
#define FONT_MANAGER_FONT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModelClass))

typedef struct _FontManagerFontModel FontManagerFontModel;
typedef struct _FontManagerFontModelClass FontManagerFontModelClass;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerCellRendererHeader {
	GtkCellRendererText parent_instance;
	FontManagerCellRendererHeaderPrivate * priv;
};

struct _FontManagerCellRendererHeaderClass {
	GtkCellRendererTextClass parent_class;
};

struct _FontManagerCellRendererHeaderPrivate {
	gchar* _style_class;
	gboolean _render_background;
};

struct _FontManagerBrowseListView {
	GtkTreeView parent_instance;
	FontManagerBrowseListViewPrivate * priv;
};

struct _FontManagerBrowseListViewClass {
	GtkTreeViewClass parent_class;
};

struct _FontManagerBrowseListViewPrivate {
	gdouble _preview_size;
	gchar* _preview_text;
	FontManagerBaseFontModel* _font_model;
	gboolean update_required;
	GtkTreeStore* store;
};

static gint FontManagerCellRendererHeader_private_offset;
static gpointer font_manager_cell_renderer_header_parent_class = NULL;
static gint FontManagerBrowseListView_private_offset;
static gpointer font_manager_browse_list_view_parent_class = NULL;

VALA_EXTERN GType font_manager_cell_renderer_header_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCellRendererHeader, g_object_unref)
static void font_manager_cell_renderer_header_real_snapshot (GtkCellRenderer* base,
                                                      GtkSnapshot* snapshot,
                                                      GtkWidget* widget,
                                                      GdkRectangle* background_area,
                                                      GdkRectangle* cell_area,
                                                      GtkCellRendererState flags);
VALA_EXTERN gboolean font_manager_cell_renderer_header_get_render_background (FontManagerCellRendererHeader* self);
VALA_EXTERN const gchar* font_manager_cell_renderer_header_get_style_class (FontManagerCellRendererHeader* self);
VALA_EXTERN FontManagerCellRendererHeader* font_manager_cell_renderer_header_new (void);
VALA_EXTERN FontManagerCellRendererHeader* font_manager_cell_renderer_header_construct (GType object_type);
VALA_EXTERN void font_manager_cell_renderer_header_set_style_class (FontManagerCellRendererHeader* self,
                                                        const gchar* value);
VALA_EXTERN void font_manager_cell_renderer_header_set_render_background (FontManagerCellRendererHeader* self,
                                                              gboolean value);
static GObject * font_manager_cell_renderer_header_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void font_manager_cell_renderer_header_finalize (GObject * obj);
static GType font_manager_cell_renderer_header_get_type_once (void);
static void _vala_font_manager_cell_renderer_header_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_font_manager_cell_renderer_header_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
VALA_EXTERN GType font_manager_browse_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBrowseListView, g_object_unref)
VALA_EXTERN GType font_manager_base_font_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseFontModel, g_object_unref)
VALA_EXTERN void font_manager_browse_list_view_queue_update (FontManagerBrowseListView* self);
VALA_EXTERN FontManagerBaseFontModel* font_manager_browse_list_view_get_font_model (FontManagerBrowseListView* self);
static void font_manager_browse_list_view_update_model (FontManagerBrowseListView* self);
VALA_EXTERN GType font_manager_font_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontModel, g_object_unref)
VALA_EXTERN GListModel* font_manager_font_model_get_child_model (FontManagerFontModel* self,
                                                     GObject* item);
static void font_manager_browse_list_view_cell_data_func (FontManagerBrowseListView* self,
                                                   GtkTreeViewColumn* layout,
                                                   GtkCellRenderer* cell,
                                                   GtkTreeModel* model,
                                                   GtkTreeIter* treeiter);
VALA_EXTERN gdouble font_manager_browse_list_view_get_preview_size (FontManagerBrowseListView* self);
VALA_EXTERN const gchar* font_manager_browse_list_view_get_preview_text (FontManagerBrowseListView* self);
VALA_EXTERN gboolean font_manager_have_valid_preview_text (const gchar* preview_text);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static gdouble font_manager_browse_list_view_get_parent_font_size (FontManagerBrowseListView* self);
VALA_EXTERN FontManagerBrowseListView* font_manager_browse_list_view_new (void);
VALA_EXTERN FontManagerBrowseListView* font_manager_browse_list_view_construct (GType object_type);
VALA_EXTERN void font_manager_browse_list_view_set_preview_size (FontManagerBrowseListView* self,
                                                     gdouble value);
VALA_EXTERN void font_manager_browse_list_view_set_preview_text (FontManagerBrowseListView* self,
                                                     const gchar* value);
VALA_EXTERN void font_manager_browse_list_view_set_font_model (FontManagerBrowseListView* self,
                                                   FontManagerBaseFontModel* value);
static GObject * font_manager_browse_list_view_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _font_manager_browse_list_view_cell_data_func_gtk_tree_cell_data_func (GtkTreeViewColumn* tree_column,
                                                                            GtkCellRenderer* cell,
                                                                            GtkTreeModel* tree_model,
                                                                            GtkTreeIter* iter,
                                                                            gpointer self);
static void _font_manager_browse_list_view___lambda123_ (FontManagerBrowseListView* self);
static void __font_manager_browse_list_view___lambda123__gtk_widget_map (GtkWidget* _sender,
                                                                  gpointer self);
static void _font_manager_browse_list_view___lambda124_ (FontManagerBrowseListView* self);
static void __font_manager_browse_list_view___lambda124__gtk_widget_unmap (GtkWidget* _sender,
                                                                    gpointer self);
static void _font_manager_browse_list_view___lambda125_ (FontManagerBrowseListView* self);
static void __font_manager_browse_list_view___lambda125__g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _font_manager_browse_list_view___lambda126_ (FontManagerBrowseListView* self);
static void __font_manager_browse_list_view___lambda126__g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _font_manager_browse_list_view___lambda127_ (FontManagerBrowseListView* self);
static void __lambda128_ (FontManagerBrowseListView* self);
static void ___lambda128__font_manager_base_font_model_items_updated (FontManagerBaseFontModel* _sender,
                                                               gpointer self);
static void __font_manager_browse_list_view___lambda127__g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void font_manager_browse_list_view_finalize (GObject * obj);
static GType font_manager_browse_list_view_get_type_once (void);
static void _vala_font_manager_browse_list_view_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_font_manager_browse_list_view_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
font_manager_cell_renderer_header_get_instance_private (FontManagerCellRendererHeader* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerCellRendererHeader_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
font_manager_cell_renderer_header_real_snapshot (GtkCellRenderer* base,
                                                 GtkSnapshot* snapshot,
                                                 GtkWidget* widget,
                                                 GdkRectangle* background_area,
                                                 GdkRectangle* cell_area,
                                                 GtkCellRendererState flags)
{
	FontManagerCellRendererHeader * self;
	gboolean _tmp0_;
	GdkRectangle _tmp30_;
	GdkRectangle _tmp31_;
	self = (FontManagerCellRendererHeader*) base;
	g_return_if_fail (snapshot != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = self->priv->_render_background;
	if (_tmp0_) {
		GdkRectangle a = {0};
		GdkRectangle _tmp1_;
		GdkRectangle _tmp2_ = {0};
		GtkStyleContext* ctx = NULL;
		GtkStyleContext* _tmp3_;
		GtkStyleContext* _tmp4_;
		GtkStateFlags state = 0U;
		GtkStyleContext* _tmp5_;
		GtkBorder m = {0};
		GtkStyleContext* _tmp6_;
		GtkBorder _tmp7_ = {0};
		gint16 _tmp8_ = 0;
		GtkBorder _tmp11_;
		GtkBorder _tmp12_;
		GtkBorder _tmp13_;
		GtkBorder _tmp14_;
		GtkBorder _tmp15_;
		GtkStyleContext* _tmp16_;
		GtkStyleContext* _tmp17_;
		const gchar* _tmp18_;
		GtkStyleContext* _tmp19_;
		GdkRectangle _tmp20_;
		GdkRectangle _tmp21_;
		GdkRectangle _tmp22_;
		GdkRectangle _tmp23_;
		GtkStyleContext* _tmp24_;
		GdkRectangle _tmp25_;
		GdkRectangle _tmp26_;
		GdkRectangle _tmp27_;
		GdkRectangle _tmp28_;
		GtkStyleContext* _tmp29_;
		_tmp1_ = *cell_area;
		gtk_cell_renderer_get_aligned_area ((GtkCellRenderer*) self, widget, flags, &_tmp1_, &_tmp2_);
		a = _tmp2_;
		_tmp3_ = gtk_widget_get_style_context (widget);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		ctx = _tmp4_;
		_tmp5_ = ctx;
		state = gtk_style_context_get_state (_tmp5_);
		_tmp6_ = ctx;
		gtk_style_context_get_margin (_tmp6_, &_tmp7_);
		m = _tmp7_;
		if ((state & GTK_STATE_FLAG_DIR_LTR) != 0) {
			GtkBorder _tmp9_;
			_tmp9_ = m;
			_tmp8_ = _tmp9_.left;
		} else {
			GtkBorder _tmp10_;
			_tmp10_ = m;
			_tmp8_ = _tmp10_.right;
		}
		a.x = a.x + _tmp8_;
		_tmp11_ = m;
		a.y = a.y + _tmp11_.top;
		_tmp12_ = m;
		_tmp13_ = m;
		a.width = a.width - (_tmp12_.left + _tmp13_.right);
		_tmp14_ = m;
		_tmp15_ = m;
		a.height = a.height - (_tmp14_.top + _tmp15_.bottom);
		_tmp16_ = ctx;
		gtk_style_context_save (_tmp16_);
		_tmp17_ = ctx;
		_tmp18_ = self->priv->_style_class;
		gtk_style_context_add_class (_tmp17_, _tmp18_);
		gtk_snapshot_push_opacity (snapshot, 0.9);
		_tmp19_ = ctx;
		_tmp20_ = a;
		_tmp21_ = a;
		_tmp22_ = a;
		_tmp23_ = a;
		gtk_snapshot_render_background (snapshot, _tmp19_, (gdouble) _tmp20_.x, (gdouble) _tmp21_.y, (gdouble) _tmp22_.width, (gdouble) _tmp23_.height);
		_tmp24_ = ctx;
		_tmp25_ = a;
		_tmp26_ = a;
		_tmp27_ = a;
		_tmp28_ = a;
		gtk_snapshot_render_frame (snapshot, _tmp24_, (gdouble) _tmp25_.x, (gdouble) _tmp26_.y, (gdouble) _tmp27_.width, (gdouble) _tmp28_.height);
		gtk_snapshot_pop (snapshot);
		_tmp29_ = ctx;
		gtk_style_context_restore (_tmp29_);
		_g_object_unref0 (ctx);
	}
	_tmp30_ = *background_area;
	_tmp31_ = *cell_area;
	GTK_CELL_RENDERER_CLASS (font_manager_cell_renderer_header_parent_class)->snapshot ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_cell_renderer_text_get_type (), GtkCellRendererText), snapshot, widget, &_tmp30_, &_tmp31_, flags);
	return;
}

FontManagerCellRendererHeader*
font_manager_cell_renderer_header_construct (GType object_type)
{
	FontManagerCellRendererHeader * self = NULL;
	self = (FontManagerCellRendererHeader*) g_object_new (object_type, NULL);
	return self;
}

FontManagerCellRendererHeader*
font_manager_cell_renderer_header_new (void)
{
	return font_manager_cell_renderer_header_construct (FONT_MANAGER_TYPE_CELL_RENDERER_HEADER);
}

const gchar*
font_manager_cell_renderer_header_get_style_class (FontManagerCellRendererHeader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_style_class;
	result = _tmp0_;
	return result;
}

void
font_manager_cell_renderer_header_set_style_class (FontManagerCellRendererHeader* self,
                                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_cell_renderer_header_get_style_class (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_style_class);
		self->priv->_style_class = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_cell_renderer_header_properties[FONT_MANAGER_CELL_RENDERER_HEADER_STYLE_CLASS_PROPERTY]);
	}
}

gboolean
font_manager_cell_renderer_header_get_render_background (FontManagerCellRendererHeader* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_render_background;
	return result;
}

void
font_manager_cell_renderer_header_set_render_background (FontManagerCellRendererHeader* self,
                                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_cell_renderer_header_get_render_background (self);
	if (old_value != value) {
		self->priv->_render_background = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_cell_renderer_header_properties[FONT_MANAGER_CELL_RENDERER_HEADER_RENDER_BACKGROUND_PROPERTY]);
	}
}

static GObject *
font_manager_cell_renderer_header_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerCellRendererHeader * self;
	parent_class = G_OBJECT_CLASS (font_manager_cell_renderer_header_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_CELL_RENDERER_HEADER, FontManagerCellRendererHeader);
	gtk_cell_renderer_set_alignment ((GtkCellRenderer*) self, 0.0f, 0.5f);
	gtk_cell_renderer_set_padding ((GtkCellRenderer*) self, 24, 4);
	return obj;
}

static void
font_manager_cell_renderer_header_class_init (FontManagerCellRendererHeaderClass * klass,
                                              gpointer klass_data)
{
	font_manager_cell_renderer_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerCellRendererHeader_private_offset);
	((GtkCellRendererClass *) klass)->snapshot = (void (*) (GtkCellRenderer*, GtkSnapshot*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) font_manager_cell_renderer_header_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_cell_renderer_header_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_cell_renderer_header_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_cell_renderer_header_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_cell_renderer_header_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CELL_RENDERER_HEADER_STYLE_CLASS_PROPERTY, font_manager_cell_renderer_header_properties[FONT_MANAGER_CELL_RENDERER_HEADER_STYLE_CLASS_PROPERTY] = g_param_spec_string ("style-class", "style-class", "style-class", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CELL_RENDERER_HEADER_RENDER_BACKGROUND_PROPERTY, font_manager_cell_renderer_header_properties[FONT_MANAGER_CELL_RENDERER_HEADER_RENDER_BACKGROUND_PROPERTY] = g_param_spec_boolean ("render-background", "render-background", "render-background", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_cell_renderer_header_instance_init (FontManagerCellRendererHeader * self,
                                                 gpointer klass)
{
	gchar* _tmp0_;
	self->priv = font_manager_cell_renderer_header_get_instance_private (self);
	_tmp0_ = g_strdup ("CharacterMapCount");
	self->priv->_style_class = _tmp0_;
	self->priv->_render_background = TRUE;
}

static void
font_manager_cell_renderer_header_finalize (GObject * obj)
{
	FontManagerCellRendererHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_CELL_RENDERER_HEADER, FontManagerCellRendererHeader);
	_g_free0 (self->priv->_style_class);
	G_OBJECT_CLASS (font_manager_cell_renderer_header_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_cell_renderer_header_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerCellRendererHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_cell_renderer_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerCellRendererHeader), 0, (GInstanceInitFunc) font_manager_cell_renderer_header_instance_init, NULL };
	GType font_manager_cell_renderer_header_type_id;
	font_manager_cell_renderer_header_type_id = g_type_register_static (gtk_cell_renderer_text_get_type (), "FontManagerCellRendererHeader", &g_define_type_info, 0);
	FontManagerCellRendererHeader_private_offset = g_type_add_instance_private (font_manager_cell_renderer_header_type_id, sizeof (FontManagerCellRendererHeaderPrivate));
	return font_manager_cell_renderer_header_type_id;
}

GType
font_manager_cell_renderer_header_get_type (void)
{
	static volatile gsize font_manager_cell_renderer_header_type_id__once = 0;
	if (g_once_init_enter (&font_manager_cell_renderer_header_type_id__once)) {
		GType font_manager_cell_renderer_header_type_id;
		font_manager_cell_renderer_header_type_id = font_manager_cell_renderer_header_get_type_once ();
		g_once_init_leave (&font_manager_cell_renderer_header_type_id__once, font_manager_cell_renderer_header_type_id);
	}
	return font_manager_cell_renderer_header_type_id__once;
}

static void
_vala_font_manager_cell_renderer_header_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	FontManagerCellRendererHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_CELL_RENDERER_HEADER, FontManagerCellRendererHeader);
	switch (property_id) {
		case FONT_MANAGER_CELL_RENDERER_HEADER_STYLE_CLASS_PROPERTY:
		g_value_set_string (value, font_manager_cell_renderer_header_get_style_class (self));
		break;
		case FONT_MANAGER_CELL_RENDERER_HEADER_RENDER_BACKGROUND_PROPERTY:
		g_value_set_boolean (value, font_manager_cell_renderer_header_get_render_background (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_cell_renderer_header_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	FontManagerCellRendererHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_CELL_RENDERER_HEADER, FontManagerCellRendererHeader);
	switch (property_id) {
		case FONT_MANAGER_CELL_RENDERER_HEADER_STYLE_CLASS_PROPERTY:
		font_manager_cell_renderer_header_set_style_class (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_CELL_RENDERER_HEADER_RENDER_BACKGROUND_PROPERTY:
		font_manager_cell_renderer_header_set_render_background (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_browse_list_view_get_instance_private (FontManagerBrowseListView* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerBrowseListView_private_offset);
}

void
font_manager_browse_list_view_queue_update (FontManagerBrowseListView* self)
{
	gboolean _tmp0_ = FALSE;
	FontManagerBaseFontModel* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->update_required = TRUE;
	_tmp1_ = self->priv->_font_model;
	if (_tmp1_ != NULL) {
		_tmp0_ = gtk_widget_is_visible ((GtkWidget*) self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		font_manager_browse_list_view_update_model (self);
	}
	return;
}

static void
font_manager_browse_list_view_update_model (FontManagerBrowseListView* self)
{
	GtkTreeStore* _tmp0_;
	guint item_count = 0U;
	FontManagerBaseFontModel* _tmp1_;
	GtkTreeStore* _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_store_new (1, json_object_get_type ());
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp0_;
	_tmp1_ = self->priv->_font_model;
	item_count = g_list_model_get_n_items ((GListModel*) _tmp1_);
	if (item_count < ((guint) 1)) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GObject* item = NULL;
				FontManagerBaseFontModel* _tmp4_;
				GObject* _tmp5_;
				GObject* _tmp6_;
				GtkTreeIter iter = {0};
				GtkTreeStore* _tmp7_;
				GtkTreeIter _tmp8_ = {0};
				GtkTreeStore* _tmp9_;
				GtkTreeIter _tmp10_;
				GObject* _tmp11_;
				JsonObject* _tmp12_;
				JsonObject* _tmp13_;
				JsonObject* _tmp14_;
				GListModel* child_model = NULL;
				FontManagerBaseFontModel* _tmp15_;
				GObject* _tmp16_;
				GListModel* _tmp17_;
				guint child_count = 0U;
				GListModel* _tmp18_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(((guint) i) < item_count)) {
					break;
				}
				_tmp4_ = self->priv->_font_model;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, (guint) i);
				item = _tmp5_;
				_tmp6_ = item;
				_vala_assert (_tmp6_ != NULL, "item != null");
				_tmp7_ = self->priv->store;
				gtk_tree_store_append (_tmp7_, &_tmp8_, NULL);
				iter = _tmp8_;
				_tmp9_ = self->priv->store;
				_tmp10_ = iter;
				_tmp11_ = item;
				g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, font_manager_family_get_type (), FontManagerFamily), "source-object", &_tmp12_, NULL);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp13_;
				gtk_tree_store_set (_tmp9_, &_tmp10_, 0, _tmp14_, -1, -1);
				_json_object_unref0 (_tmp14_);
				_tmp15_ = self->priv->_font_model;
				_tmp16_ = item;
				_tmp17_ = font_manager_font_model_get_child_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModel), _tmp16_);
				child_model = _tmp17_;
				_tmp18_ = child_model;
				child_count = g_list_model_get_n_items (_tmp18_);
				if (child_count < ((guint) 1)) {
					_g_object_unref0 (child_model);
					_g_object_unref0 (item);
					continue;
				}
				{
					gint c = 0;
					c = 0;
					{
						gboolean _tmp19_ = FALSE;
						_tmp19_ = TRUE;
						while (TRUE) {
							GObject* child = NULL;
							GListModel* _tmp21_;
							GObject* _tmp22_;
							GObject* _tmp23_;
							GtkTreeIter child_iter = {0};
							GtkTreeStore* _tmp24_;
							GtkTreeIter _tmp25_;
							GtkTreeIter _tmp26_ = {0};
							GtkTreeStore* _tmp27_;
							GtkTreeIter _tmp28_;
							GObject* _tmp29_;
							JsonObject* _tmp30_;
							JsonObject* _tmp31_;
							JsonObject* _tmp32_;
							if (!_tmp19_) {
								gint _tmp20_;
								_tmp20_ = c;
								c = _tmp20_ + 1;
							}
							_tmp19_ = FALSE;
							if (!(((guint) c) < child_count)) {
								break;
							}
							_tmp21_ = child_model;
							_tmp22_ = g_list_model_get_item (_tmp21_, (guint) c);
							child = _tmp22_;
							_tmp23_ = child;
							_vala_assert (_tmp23_ != NULL, "child != null");
							_tmp24_ = self->priv->store;
							_tmp25_ = iter;
							gtk_tree_store_append (_tmp24_, &_tmp26_, &_tmp25_);
							child_iter = _tmp26_;
							_tmp27_ = self->priv->store;
							_tmp28_ = child_iter;
							_tmp29_ = child;
							g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, font_manager_font_get_type (), FontManagerFont), "source-object", &_tmp30_, NULL);
							_tmp31_ = _tmp30_;
							_tmp32_ = _tmp31_;
							gtk_tree_store_set (_tmp27_, &_tmp28_, 0, _tmp32_, -1, -1);
							_json_object_unref0 (_tmp32_);
							_g_object_unref0 (child);
						}
					}
				}
				_g_object_unref0 (child_model);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp33_ = self->priv->store;
	gtk_tree_view_set_model ((GtkTreeView*) self, (GtkTreeModel*) _tmp33_);
	gtk_tree_view_expand_all ((GtkTreeView*) self);
	self->priv->update_required = FALSE;
	return;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
font_manager_browse_list_view_cell_data_func (FontManagerBrowseListView* self,
                                              GtkTreeViewColumn* layout,
                                              GtkCellRenderer* cell,
                                              GtkTreeModel* model,
                                              GtkTreeIter* treeiter)
{
	GValue val = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	JsonObject* obj = NULL;
	void* _tmp2_;
	JsonObject* _tmp3_;
	JsonObject* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (treeiter != NULL);
	_tmp0_ = *treeiter;
	gtk_tree_model_get_value (model, &_tmp0_, 0, &_tmp1_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp1_;
	_tmp2_ = g_value_get_boxed (&val);
	_tmp3_ = _json_object_ref0 ((JsonObject*) _tmp2_);
	obj = _tmp3_;
	_tmp4_ = obj;
	if (json_object_has_member (_tmp4_, "style")) {
		gchar* desc = NULL;
		JsonObject* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* sample = NULL;
		JsonObject* _tmp8_;
		PangoFontDescription* font = NULL;
		const gchar* _tmp12_;
		PangoFontDescription* _tmp13_;
		PangoFontDescription* _tmp14_;
		gdouble _tmp15_;
		const gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp18_;
		gchar* text = NULL;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		GValue _tmp29_ = {0};
		PangoFontDescription* _tmp30_;
		GValue _tmp31_ = {0};
		_tmp5_ = obj;
		_tmp6_ = json_object_get_string_member (_tmp5_, "description");
		_tmp7_ = g_strdup (_tmp6_);
		desc = _tmp7_;
		sample = NULL;
		_tmp8_ = obj;
		if (json_object_has_member (_tmp8_, "preview-text")) {
			JsonObject* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = obj;
			_tmp10_ = json_object_get_string_member (_tmp9_, "preview-text");
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (sample);
			sample = _tmp11_;
		}
		_tmp12_ = desc;
		_tmp13_ = pango_font_description_from_string (_tmp12_);
		font = _tmp13_;
		_tmp14_ = font;
		_tmp15_ = self->priv->_preview_size;
		pango_font_description_set_absolute_size (_tmp14_, _tmp15_ * PANGO_SCALE);
		_tmp18_ = self->priv->_preview_text;
		if (_tmp18_ != NULL) {
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp19_ = self->priv->_preview_text;
			_tmp20_ = string_strip (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp17_ = g_strcmp0 (_tmp21_, "") != 0;
			_g_free0 (_tmp21_);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			const gchar* _tmp22_;
			_tmp22_ = self->priv->_preview_text;
			_tmp16_ = _tmp22_;
		} else {
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_;
			_tmp24_ = sample;
			if (font_manager_have_valid_preview_text (_tmp24_)) {
				const gchar* _tmp25_;
				_tmp25_ = sample;
				_tmp23_ = _tmp25_;
			} else {
				const gchar* _tmp26_;
				_tmp26_ = desc;
				_tmp23_ = _tmp26_;
			}
			_tmp16_ = _tmp23_;
		}
		_tmp27_ = g_strdup (_tmp16_);
		text = _tmp27_;
		_tmp28_ = text;
		g_value_init (&_tmp29_, G_TYPE_STRING);
		g_value_set_string (&_tmp29_, _tmp28_);
		g_object_set_property ((GObject*) cell, "text", &_tmp29_);
		G_IS_VALUE (&_tmp29_) ? (g_value_unset (&_tmp29_), NULL) : NULL;
		_tmp30_ = font;
		g_value_init (&_tmp31_, pango_font_description_get_type ());
		g_value_set_boxed (&_tmp31_, _tmp30_);
		g_object_set_property ((GObject*) cell, "font-desc", &_tmp31_);
		G_IS_VALUE (&_tmp31_) ? (g_value_unset (&_tmp31_), NULL) : NULL;
		font_manager_cell_renderer_header_set_render_background (G_TYPE_CHECK_INSTANCE_CAST (cell, FONT_MANAGER_TYPE_CELL_RENDERER_HEADER, FontManagerCellRendererHeader), FALSE);
		_g_free0 (text);
		__vala_PangoFontDescription_free0 (font);
		_g_free0 (sample);
		_g_free0 (desc);
	} else {
		PangoFontDescription* font = NULL;
		PangoFontDescription* _tmp32_;
		PangoFontDescription* _tmp33_;
		PangoFontDescription* _tmp34_;
		PangoFontDescription* _tmp35_;
		GValue _tmp36_ = {0};
		JsonObject* _tmp37_;
		const gchar* _tmp38_;
		GValue _tmp39_ = {0};
		_tmp32_ = pango_font_description_from_string ("");
		font = _tmp32_;
		_tmp33_ = font;
		pango_font_description_set_absolute_size (_tmp33_, font_manager_browse_list_view_get_parent_font_size (self) * PANGO_SCALE);
		_tmp34_ = font;
		pango_font_description_set_weight (_tmp34_, PANGO_WEIGHT_MEDIUM);
		_tmp35_ = font;
		g_value_init (&_tmp36_, pango_font_description_get_type ());
		g_value_set_boxed (&_tmp36_, _tmp35_);
		g_object_set_property ((GObject*) cell, "font-desc", &_tmp36_);
		G_IS_VALUE (&_tmp36_) ? (g_value_unset (&_tmp36_), NULL) : NULL;
		_tmp37_ = obj;
		_tmp38_ = json_object_get_string_member (_tmp37_, "family");
		g_value_init (&_tmp39_, G_TYPE_STRING);
		g_value_set_string (&_tmp39_, _tmp38_);
		g_object_set_property ((GObject*) cell, "text", &_tmp39_);
		G_IS_VALUE (&_tmp39_) ? (g_value_unset (&_tmp39_), NULL) : NULL;
		font_manager_cell_renderer_header_set_render_background (G_TYPE_CHECK_INSTANCE_CAST (cell, FONT_MANAGER_TYPE_CELL_RENDERER_HEADER, FontManagerCellRendererHeader), TRUE);
		__vala_PangoFontDescription_free0 (font);
	}
	g_value_unset (&val);
	_json_object_unref0 (obj);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	return;
}

static gdouble
font_manager_browse_list_view_get_parent_font_size (FontManagerBrowseListView* self)
{
	gdouble desc_size = 0.0;
	gdouble _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_preview_size;
	desc_size = _tmp0_;
	if (desc_size <= ((gdouble) 10)) {
		result = desc_size + 2;
		return result;
	} else {
		if (desc_size <= ((gdouble) 20)) {
			result = desc_size / 1.1;
			return result;
		} else {
			if (desc_size <= ((gdouble) 30)) {
				result = desc_size / 1.2;
				return result;
			} else {
				if (desc_size <= ((gdouble) 50)) {
					result = desc_size / 1.5;
					return result;
				} else {
					result = desc_size / 2;
					return result;
				}
			}
		}
	}
}

FontManagerBrowseListView*
font_manager_browse_list_view_construct (GType object_type)
{
	FontManagerBrowseListView * self = NULL;
	self = (FontManagerBrowseListView*) g_object_new (object_type, NULL);
	return self;
}

FontManagerBrowseListView*
font_manager_browse_list_view_new (void)
{
	return font_manager_browse_list_view_construct (FONT_MANAGER_TYPE_BROWSE_LIST_VIEW);
}

gdouble
font_manager_browse_list_view_get_preview_size (FontManagerBrowseListView* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_preview_size;
	return result;
}

void
font_manager_browse_list_view_set_preview_size (FontManagerBrowseListView* self,
                                                gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_list_view_get_preview_size (self);
	if (old_value != value) {
		self->priv->_preview_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_list_view_properties[FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_SIZE_PROPERTY]);
	}
}

const gchar*
font_manager_browse_list_view_get_preview_text (FontManagerBrowseListView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_preview_text;
	result = _tmp0_;
	return result;
}

void
font_manager_browse_list_view_set_preview_text (FontManagerBrowseListView* self,
                                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_list_view_get_preview_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_preview_text);
		self->priv->_preview_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_list_view_properties[FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_TEXT_PROPERTY]);
	}
}

FontManagerBaseFontModel*
font_manager_browse_list_view_get_font_model (FontManagerBrowseListView* self)
{
	FontManagerBaseFontModel* result;
	FontManagerBaseFontModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_font_model;
	result = _tmp0_;
	return result;
}

void
font_manager_browse_list_view_set_font_model (FontManagerBrowseListView* self,
                                              FontManagerBaseFontModel* value)
{
	FontManagerBaseFontModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_list_view_get_font_model (self);
	if (old_value != value) {
		FontManagerBaseFontModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_font_model);
		self->priv->_font_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_list_view_properties[FONT_MANAGER_BROWSE_LIST_VIEW_FONT_MODEL_PROPERTY]);
	}
}

static void
_font_manager_browse_list_view_cell_data_func_gtk_tree_cell_data_func (GtkTreeViewColumn* tree_column,
                                                                       GtkCellRenderer* cell,
                                                                       GtkTreeModel* tree_model,
                                                                       GtkTreeIter* iter,
                                                                       gpointer self)
{
	font_manager_browse_list_view_cell_data_func ((FontManagerBrowseListView*) self, tree_column, cell, tree_model, iter);
}

static void
_font_manager_browse_list_view___lambda123_ (FontManagerBrowseListView* self)
{
	gboolean _tmp0_ = FALSE;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	_tmp1_ = gtk_tree_view_get_model ((GtkTreeView*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		GtkTreeStore* _tmp3_;
		_tmp3_ = self->priv->store;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		font_manager_browse_list_view_queue_update (self);
	} else {
		gboolean _tmp4_ = FALSE;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* _tmp6_;
		_tmp5_ = gtk_tree_view_get_model ((GtkTreeView*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			GtkTreeStore* _tmp7_;
			_tmp7_ = self->priv->store;
			_tmp4_ = _tmp7_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GtkTreeStore* _tmp8_;
			_tmp8_ = self->priv->store;
			gtk_tree_view_set_model ((GtkTreeView*) self, (GtkTreeModel*) _tmp8_);
		}
	}
	gtk_tree_view_expand_all ((GtkTreeView*) self);
}

static void
__font_manager_browse_list_view___lambda123__gtk_widget_map (GtkWidget* _sender,
                                                             gpointer self)
{
	_font_manager_browse_list_view___lambda123_ ((FontManagerBrowseListView*) self);
}

static void
_font_manager_browse_list_view___lambda124_ (FontManagerBrowseListView* self)
{
	gtk_tree_view_set_model ((GtkTreeView*) self, NULL);
}

static void
__font_manager_browse_list_view___lambda124__gtk_widget_unmap (GtkWidget* _sender,
                                                               gpointer self)
{
	_font_manager_browse_list_view___lambda124_ ((FontManagerBrowseListView*) self);
}

static void
_font_manager_browse_list_view___lambda125_ (FontManagerBrowseListView* self)
{
	GtkTreeViewColumn* _tmp0_;
	_tmp0_ = gtk_tree_view_get_column ((GtkTreeView*) self, 0);
	gtk_tree_view_column_queue_resize (_tmp0_);
}

static void
__font_manager_browse_list_view___lambda125__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	_font_manager_browse_list_view___lambda125_ ((FontManagerBrowseListView*) self);
}

static void
_font_manager_browse_list_view___lambda126_ (FontManagerBrowseListView* self)
{
	GtkTreeViewColumn* _tmp0_;
	_tmp0_ = gtk_tree_view_get_column ((GtkTreeView*) self, 0);
	gtk_tree_view_column_queue_resize (_tmp0_);
}

static void
__font_manager_browse_list_view___lambda126__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	_font_manager_browse_list_view___lambda126_ ((FontManagerBrowseListView*) self);
}

static void
__lambda128_ (FontManagerBrowseListView* self)
{
	font_manager_browse_list_view_queue_update (self);
}

static void
___lambda128__font_manager_base_font_model_items_updated (FontManagerBaseFontModel* _sender,
                                                          gpointer self)
{
	__lambda128_ ((FontManagerBrowseListView*) self);
}

static void
_font_manager_browse_list_view___lambda127_ (FontManagerBrowseListView* self)
{
	FontManagerBaseFontModel* _tmp0_;
	font_manager_browse_list_view_queue_update (self);
	_tmp0_ = self->priv->_font_model;
	g_signal_connect_object (_tmp0_, "items-updated", (GCallback) ___lambda128__font_manager_base_font_model_items_updated, self, 0);
}

static void
__font_manager_browse_list_view___lambda127__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	_font_manager_browse_list_view___lambda127_ ((FontManagerBrowseListView*) self);
}

static GObject *
font_manager_browse_list_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerBrowseListView * self;
	FontManagerCellRendererHeader* cell_renderer = NULL;
	FontManagerCellRendererHeader* _tmp0_;
	FontManagerCellRendererHeader* _tmp1_;
	GtkTreeViewColumn* _tmp2_;
	GtkTreeSelection* _tmp3_;
	parent_class = G_OBJECT_CLASS (font_manager_browse_list_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BROWSE_LIST_VIEW, FontManagerBrowseListView);
	font_manager_widget_set_name ((GtkWidget*) self, "BrowseListView");
	gtk_tree_view_set_model ((GtkTreeView*) self, NULL);
	font_manager_widget_set_expand ((GtkWidget*) self, TRUE);
	font_manager_widget_set_margin ((GtkWidget*) self, 12);
	gtk_tree_view_set_enable_tree_lines ((GtkTreeView*) self, TRUE);
	_tmp0_ = font_manager_cell_renderer_header_new ();
	g_object_ref_sink (_tmp0_);
	cell_renderer = _tmp0_;
	_tmp1_ = cell_renderer;
	gtk_tree_view_insert_column_with_data_func ((GtkTreeView*) self, 0, "", (GtkCellRenderer*) _tmp1_, _font_manager_browse_list_view_cell_data_func_gtk_tree_cell_data_func, g_object_ref (self), g_object_unref);
	_tmp2_ = gtk_tree_view_get_column ((GtkTreeView*) self, 0);
	gtk_tree_view_column_set_expand (_tmp2_, TRUE);
	_tmp3_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
	gtk_tree_selection_set_mode (_tmp3_, GTK_SELECTION_NONE);
	gtk_tree_view_set_headers_visible ((GtkTreeView*) self, FALSE);
	gtk_tree_view_set_show_expanders ((GtkTreeView*) self, FALSE);
	gtk_tree_view_set_level_indentation ((GtkTreeView*) self, 24);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) __font_manager_browse_list_view___lambda123__gtk_widget_map, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "unmap", (GCallback) __font_manager_browse_list_view___lambda124__gtk_widget_unmap, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::preview-size", (GCallback) __font_manager_browse_list_view___lambda125__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::preview-text", (GCallback) __font_manager_browse_list_view___lambda126__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::font-model", (GCallback) __font_manager_browse_list_view___lambda127__g_object_notify, self, 0);
	_g_object_unref0 (cell_renderer);
	return obj;
}

static void
font_manager_browse_list_view_class_init (FontManagerBrowseListViewClass * klass,
                                          gpointer klass_data)
{
	font_manager_browse_list_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerBrowseListView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_browse_list_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_browse_list_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_browse_list_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_browse_list_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_SIZE_PROPERTY, font_manager_browse_list_view_properties[FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_SIZE_PROPERTY] = g_param_spec_double ("preview-size", "preview-size", "preview-size", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 16, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_TEXT_PROPERTY, font_manager_browse_list_view_properties[FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_TEXT_PROPERTY] = g_param_spec_string ("preview-text", "preview-text", "preview-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_LIST_VIEW_FONT_MODEL_PROPERTY, font_manager_browse_list_view_properties[FONT_MANAGER_BROWSE_LIST_VIEW_FONT_MODEL_PROPERTY] = g_param_spec_object ("font-model", "font-model", "font-model", FONT_MANAGER_TYPE_BASE_FONT_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_browse_list_view_instance_init (FontManagerBrowseListView * self,
                                             gpointer klass)
{
	self->priv = font_manager_browse_list_view_get_instance_private (self);
	self->priv->_preview_size = (gdouble) 16;
	self->priv->_preview_text = NULL;
	self->priv->_font_model = NULL;
	self->priv->update_required = FALSE;
	self->priv->store = NULL;
}

static void
font_manager_browse_list_view_finalize (GObject * obj)
{
	FontManagerBrowseListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BROWSE_LIST_VIEW, FontManagerBrowseListView);
	_g_free0 (self->priv->_preview_text);
	_g_object_unref0 (self->priv->_font_model);
	_g_object_unref0 (self->priv->store);
	G_OBJECT_CLASS (font_manager_browse_list_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_browse_list_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerBrowseListViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_browse_list_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerBrowseListView), 0, (GInstanceInitFunc) font_manager_browse_list_view_instance_init, NULL };
	GType font_manager_browse_list_view_type_id;
	font_manager_browse_list_view_type_id = g_type_register_static (gtk_tree_view_get_type (), "FontManagerBrowseListView", &g_define_type_info, 0);
	FontManagerBrowseListView_private_offset = g_type_add_instance_private (font_manager_browse_list_view_type_id, sizeof (FontManagerBrowseListViewPrivate));
	return font_manager_browse_list_view_type_id;
}

GType
font_manager_browse_list_view_get_type (void)
{
	static volatile gsize font_manager_browse_list_view_type_id__once = 0;
	if (g_once_init_enter (&font_manager_browse_list_view_type_id__once)) {
		GType font_manager_browse_list_view_type_id;
		font_manager_browse_list_view_type_id = font_manager_browse_list_view_get_type_once ();
		g_once_init_leave (&font_manager_browse_list_view_type_id__once, font_manager_browse_list_view_type_id);
	}
	return font_manager_browse_list_view_type_id__once;
}

static void
_vala_font_manager_browse_list_view_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	FontManagerBrowseListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BROWSE_LIST_VIEW, FontManagerBrowseListView);
	switch (property_id) {
		case FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_SIZE_PROPERTY:
		g_value_set_double (value, font_manager_browse_list_view_get_preview_size (self));
		break;
		case FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_TEXT_PROPERTY:
		g_value_set_string (value, font_manager_browse_list_view_get_preview_text (self));
		break;
		case FONT_MANAGER_BROWSE_LIST_VIEW_FONT_MODEL_PROPERTY:
		g_value_set_object (value, font_manager_browse_list_view_get_font_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_browse_list_view_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	FontManagerBrowseListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BROWSE_LIST_VIEW, FontManagerBrowseListView);
	switch (property_id) {
		case FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_SIZE_PROPERTY:
		font_manager_browse_list_view_set_preview_size (self, g_value_get_double (value));
		break;
		case FONT_MANAGER_BROWSE_LIST_VIEW_PREVIEW_TEXT_PROPERTY:
		font_manager_browse_list_view_set_preview_text (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_BROWSE_LIST_VIEW_FONT_MODEL_PROPERTY:
		font_manager_browse_list_view_set_font_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

