/* persona.c generated by valac 0.56.18, the Vala compiler
 * generated from persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2013 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_PERSONA_0_PROPERTY,
	FOLKS_PERSONA_IID_PROPERTY,
	FOLKS_PERSONA_UID_PROPERTY,
	FOLKS_PERSONA_DISPLAY_ID_PROPERTY,
	FOLKS_PERSONA_IS_USER_PROPERTY,
	FOLKS_PERSONA_STORE_PROPERTY,
	FOLKS_PERSONA_INDIVIDUAL_PROPERTY,
	FOLKS_PERSONA_LINKABLE_PROPERTIES_PROPERTY,
	FOLKS_PERSONA_WRITEABLE_PROPERTIES_PROPERTY,
	FOLKS_PERSONA_NUM_PROPERTIES
};
static GParamSpec* folks_persona_properties[FOLKS_PERSONA_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

/**
 * Errors which can be thrown when asynchronously setting a property of a
 * {@link Persona} using a setter method defined on an interface such as
 * {@link AliasDetails}.
 *
 * @since 0.6.2
 */
struct _FolksPersonaPrivate {
	gchar* _iid;
	gchar* _uid;
	gchar* _display_id;
	gboolean _is_user;
	FolksPersonaStore* _store;
	FolksIndividual* _individual;
};

static gint FolksPersona_private_offset;
static gpointer folks_persona_parent_class = NULL;

VALA_EXTERN void folks_persona_set_individual (FolksPersona* self,
                                   FolksIndividual* value);
static void _folks_persona_individual_weak_notify_cb (FolksPersona* self,
                                               GObject* obj);
static void folks_persona_real_linkable_property_to_links (FolksPersona* self,
                                                    const gchar* prop_name,
                                                    FolksPersonaLinkablePropertyCallback callback,
                                                    gpointer callback_target);
static void _folks_persona_add_escaped_uid_component (GString* uid,
                                               const gchar* component);
static gchar* _folks_persona_unescape_uid_component (const gchar* component);
static void __folks_persona_individual_weak_notify_cb_gweak_notify (gpointer self,
                                                             GObject* object);
static void folks_persona_finalize (GObject * obj);
static GType folks_persona_get_type_once (void);
static void _vala_folks_persona_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_folks_persona_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
folks_property_error_quark (void)
{
	return g_quark_from_static_string ("folks-property-error-quark");
}

static GType
folks_property_error_get_type_once (void)
{
	static const GEnumValue values[] = {{FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, "FOLKS_PROPERTY_ERROR_NOT_WRITEABLE", "not-writeable"}, {FOLKS_PROPERTY_ERROR_INVALID_VALUE, "FOLKS_PROPERTY_ERROR_INVALID_VALUE", "invalid-value"}, {FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, "FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR", "unknown-error"}, {FOLKS_PROPERTY_ERROR_UNAVAILABLE, "FOLKS_PROPERTY_ERROR_UNAVAILABLE", "unavailable"}, {0, NULL, NULL}};
	GType folks_property_error_type_id;
	folks_property_error_type_id = g_enum_register_static ("FolksPropertyError", values);
	return folks_property_error_type_id;
}

GType
folks_property_error_get_type (void)
{
	static volatile gsize folks_property_error_type_id__once = 0;
	if (g_once_init_enter (&folks_property_error_type_id__once)) {
		GType folks_property_error_type_id;
		folks_property_error_type_id = folks_property_error_get_type_once ();
		g_once_init_leave (&folks_property_error_type_id__once, folks_property_error_type_id);
	}
	return folks_property_error_type_id__once;
}

static inline gpointer
folks_persona_get_instance_private (FolksPersona* self)
{
	return G_STRUCT_MEMBER_P (self, FolksPersona_private_offset);
}

static void
_folks_persona_individual_weak_notify_cb (FolksPersona* self,
                                          GObject* obj)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = self->priv->_iid;
	g_debug ("persona.vala:163: Individual %p has been destroyed; resetting the Indi" \
"vidual of %s", obj, _tmp0_);
	self->priv->_individual = NULL;
	g_object_notify ((GObject*) self, "individual");
}

/**
   * Produce one or more mapping strings for the given property's value.
   *
   * This is a virtual method, to be overridden by subclasses of {@link Persona}
   * who have linkable properties. Each of their linkable properties should be
   * handled by their implementation of this function, examining the current
   * value of the property and calling ``callback`` with one or more mapping
   * strings for the property's value. Each of these mapping strings will be
   * added to the {@link IndividualAggregator}'s link map, related to the
   * {@link Individual} instance which contains this {@link Persona}.
   *
   * @param prop_name the name of the linkable property to use, which must be
   * listed in {@link Persona.linkable_properties}
   * @param callback a callback to execute for each of the mapping strings
   * generated by this property
   * @see Persona.linkable_properties
   * @since 0.1.13
   */
static void
folks_persona_real_linkable_property_to_links (FolksPersona* self,
                                               const gchar* prop_name,
                                               FolksPersonaLinkablePropertyCallback callback,
                                               gpointer callback_target)
{
	g_return_if_fail (prop_name != NULL);
	g_assert_not_reached ();
}

void
folks_persona_linkable_property_to_links (FolksPersona* self,
                                          const gchar* prop_name,
                                          FolksPersonaLinkablePropertyCallback callback,
                                          gpointer callback_target)
{
	FolksPersonaClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FOLKS_PERSONA_GET_CLASS (self);
	if (_klass_->linkable_property_to_links) {
		_klass_->linkable_property_to_links (self, prop_name, callback, callback_target);
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
_folks_persona_add_escaped_uid_component (GString* uid,
                                          const gchar* component)
{
	g_return_if_fail (uid != NULL);
	g_return_if_fail (component != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gchar c = '\0';
				gboolean _tmp4_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = strlen (component);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				c = string_get (component, (glong) i);
				if (c == ':') {
					_tmp4_ = TRUE;
				} else {
					_tmp4_ = c == '\\';
				}
				if (_tmp4_) {
					g_string_append_c (uid, '\\');
				}
				g_string_append_c (uid, c);
			}
		}
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
_folks_persona_unescape_uid_component (const gchar* component)
{
	gchar* unescaped = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (component != NULL, NULL);
	_tmp0_ = string_replace (component, "\\:", ":");
	unescaped = _tmp0_;
	_tmp1_ = string_replace (unescaped, "\\", "\\\\");
	result = _tmp1_;
	_g_free0 (unescaped);
	return result;
}

/**
   * Build a UID from the given components.
   *
   * Each component is escaped before the UID is built. All components must be
   * non-empty strings.
   *
   * @param backend_name the {@link Backend.name}
   * @param persona_store_id the {@link PersonaStore.id}
   * @param persona_id the Persona identifier (backend-specific)
   * @return a valid UID
   * @see Persona.split_uid
   * @since 0.1.13
   */
gchar*
folks_persona_build_uid (const gchar* backend_name,
                         const gchar* persona_store_id,
                         const gchar* persona_id)
{
	glong min_total_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GString* uid = NULL;
	GString* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (backend_name != NULL, NULL);
	g_return_val_if_fail (persona_store_id != NULL, NULL);
	g_return_val_if_fail (persona_id != NULL, NULL);
	_vala_return_val_if_fail (g_strcmp0 (backend_name, "") != 0, "backend_name != \"\"", NULL);
	_vala_return_val_if_fail (g_strcmp0 (persona_store_id, "") != 0, "persona_store_id != \"\"", NULL);
	_vala_return_val_if_fail (g_strcmp0 (persona_id, "") != 0, "persona_id != \"\"", NULL);
	_tmp0_ = strlen (backend_name);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (persona_store_id);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (persona_id);
	_tmp5_ = _tmp4_;
	min_total_length = (glong) ((((_tmp1_ + _tmp3_) + _tmp5_) + 2) + 1);
	_tmp6_ = g_string_sized_new ((gsize) min_total_length);
	uid = _tmp6_;
	_folks_persona_add_escaped_uid_component (uid, backend_name);
	g_string_append_c (uid, ':');
	_folks_persona_add_escaped_uid_component (uid, persona_store_id);
	g_string_append_c (uid, ':');
	_folks_persona_add_escaped_uid_component (uid, persona_id);
	_tmp7_ = uid->str;
	uid->str = NULL;
	result = _tmp7_;
	_g_string_free0 (uid);
	return result;
}

/**
   * Split a UID into its component parts.
   *
   * Each component is unescaped before being returned. The UID //must// be
   * correctly formed.
   *
   * @param uid a valid UID
   * @param backend_name the {@link Backend.name}
   * @param persona_store_id the {@link PersonaStore.id}
   * @param persona_id the Persona identifier (backend-specific)
   * @see Persona.build_uid
   * @since 0.1.13
   */
static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

void
folks_persona_split_uid (const gchar* uid,
                         gchar** backend_name,
                         gchar** persona_store_id,
                         gchar** persona_id)
{
	gchar* _vala_backend_name = NULL;
	gchar* _vala_persona_store_id = NULL;
	gchar* _vala_persona_id = NULL;
	gsize backend_name_length = 0UL;
	gsize persona_store_id_length = 0UL;
	gboolean escaped = FALSE;
	gboolean _tmp9_ = FALSE;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_if_fail (uid != NULL);
	_vala_assert (g_utf8_validate (uid, (gssize) -1, NULL), "uid.validate ()");
	backend_name_length = (gsize) 0;
	persona_store_id_length = (gsize) 0;
	escaped = FALSE;
	{
		const gchar* i = NULL;
		i = uid;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				if (!_tmp0_) {
					const gchar* _tmp1_;
					const gchar* _tmp2_;
					_tmp1_ = i;
					_tmp2_ = g_utf8_next_char (_tmp1_);
					i = _tmp2_;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				if (!(string_get_char (_tmp3_, (glong) 0) != ((gunichar) '\0'))) {
					break;
				}
				_tmp4_ = i;
				if (string_get_char (_tmp4_, (glong) 0) == ((gunichar) '\\')) {
					escaped = !escaped;
				} else {
					gboolean _tmp5_ = FALSE;
					if (escaped == FALSE) {
						const gchar* _tmp6_;
						_tmp6_ = i;
						_tmp5_ = string_get_char (_tmp6_, (glong) 0) == ((gunichar) ':');
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						if (backend_name_length == ((gsize) 0)) {
							const gchar* _tmp7_;
							_tmp7_ = i;
							backend_name_length = ((gchar*) _tmp7_) - ((gchar*) uid);
						} else {
							const gchar* _tmp8_;
							_tmp8_ = i;
							persona_store_id_length = ((((gchar*) _tmp8_) - ((gchar*) uid)) - backend_name_length) - 1;
						}
					}
				}
			}
		}
	}
	if (backend_name_length != ((gsize) 0)) {
		_tmp9_ = persona_store_id_length != ((gsize) 0);
	} else {
		_tmp9_ = FALSE;
	}
	_vala_assert (_tmp9_, "backend_name_length != 0 && persona_store_id_length != 0");
	_tmp10_ = string_substring (uid, (glong) 0, (glong) backend_name_length);
	_tmp11_ = _tmp10_;
	_tmp12_ = _folks_persona_unescape_uid_component (_tmp11_);
	_g_free0 (_vala_backend_name);
	_vala_backend_name = _tmp12_;
	_g_free0 (_tmp11_);
	_tmp13_ = string_substring ((const gchar*) ((((gchar*) uid) + backend_name_length) + 1), (glong) 0, (glong) persona_store_id_length);
	_tmp14_ = _tmp13_;
	_tmp15_ = _folks_persona_unescape_uid_component (_tmp14_);
	_g_free0 (_vala_persona_store_id);
	_vala_persona_store_id = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp16_ = _folks_persona_unescape_uid_component ((const gchar*) (((((gchar*) uid) + backend_name_length) + persona_store_id_length) + 2));
	_g_free0 (_vala_persona_id);
	_vala_persona_id = _tmp16_;
	if (backend_name) {
		*backend_name = _vala_backend_name;
	} else {
		_g_free0 (_vala_backend_name);
	}
	if (persona_store_id) {
		*persona_store_id = _vala_persona_store_id;
	} else {
		_g_free0 (_vala_persona_store_id);
	}
	if (persona_id) {
		*persona_id = _vala_persona_id;
	} else {
		_g_free0 (_vala_persona_id);
	}
}

FolksPersona*
folks_persona_construct (GType object_type)
{
	FolksPersona * self = NULL;
	self = (FolksPersona*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
folks_persona_get_iid (FolksPersona* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_iid;
	result = _tmp0_;
	return result;
}

static void
folks_persona_set_iid (FolksPersona* self,
                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_persona_get_iid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_iid);
		self->priv->_iid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folks_persona_properties[FOLKS_PERSONA_IID_PROPERTY]);
	}
}

const gchar*
folks_persona_get_uid (FolksPersona* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uid;
	result = _tmp0_;
	return result;
}

static void
folks_persona_set_uid (FolksPersona* self,
                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_persona_get_uid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uid);
		self->priv->_uid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folks_persona_properties[FOLKS_PERSONA_UID_PROPERTY]);
	}
}

const gchar*
folks_persona_get_display_id (FolksPersona* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_id;
	result = _tmp0_;
	return result;
}

static void
folks_persona_set_display_id (FolksPersona* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_persona_get_display_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_id);
		self->priv->_display_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folks_persona_properties[FOLKS_PERSONA_DISPLAY_ID_PROPERTY]);
	}
}

gboolean
folks_persona_get_is_user (FolksPersona* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_user;
	return result;
}

static void
folks_persona_set_is_user (FolksPersona* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_persona_get_is_user (self);
	if (old_value != value) {
		self->priv->_is_user = value;
		g_object_notify_by_pspec ((GObject *) self, folks_persona_properties[FOLKS_PERSONA_IS_USER_PROPERTY]);
	}
}

FolksPersonaStore*
folks_persona_get_store (FolksPersona* self)
{
	FolksPersonaStore* result;
	FolksPersonaStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}

static void
folks_persona_set_store (FolksPersona* self,
                         FolksPersonaStore* value)
{
	FolksPersonaStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_persona_get_store (self);
	if (old_value != value) {
		self->priv->_store = value;
		g_object_notify_by_pspec ((GObject *) self, folks_persona_properties[FOLKS_PERSONA_STORE_PROPERTY]);
	}
}

FolksIndividual*
folks_persona_get_individual (FolksPersona* self)
{
	FolksIndividual* result;
	gboolean _tmp0_ = FALSE;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_individual;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FolksIndividual* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		_tmp2_ = self->priv->_individual;
		_tmp3_ = folks_individual_get_personas (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
		_tmp4_ = _tmp3_;
		_tmp0_ = gee_collection_contains ((GeeCollection*) _tmp4_, self);
	}
	_vala_assert (_tmp0_, "this._individual == null ||               ((!) this._individual).personas.contains (this)");
	_tmp5_ = self->priv->_individual;
	result = _tmp5_;
	return result;
}

static void
__folks_persona_individual_weak_notify_cb_gweak_notify (gpointer self,
                                                        GObject* object)
{
	_folks_persona_individual_weak_notify_cb ((FolksPersona*) self, object);
}

void
folks_persona_set_individual (FolksPersona* self,
                              FolksIndividual* value)
{
	gboolean _tmp0_ = FALSE;
	FolksIndividual* _tmp3_;
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		_tmp0_ = TRUE;
	} else {
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		_tmp1_ = folks_individual_get_personas (G_TYPE_CHECK_INSTANCE_CAST (value, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
		_tmp2_ = _tmp1_;
		_tmp0_ = gee_collection_contains ((GeeCollection*) _tmp2_, self);
	}
	_vala_assert (_tmp0_, "value == null || ((!) value).personas.contains (this)");
	_tmp3_ = self->priv->_individual;
	if (_tmp3_ != NULL) {
		FolksIndividual* _tmp4_;
		_tmp4_ = self->priv->_individual;
		g_object_weak_unref ((GObject*) _tmp4_, __folks_persona_individual_weak_notify_cb_gweak_notify, self);
	}
	if (value != NULL) {
		g_object_weak_ref ((GObject*) value, __folks_persona_individual_weak_notify_cb_gweak_notify, self);
	}
	self->priv->_individual = value;
	g_object_notify_by_pspec ((GObject *) self, folks_persona_properties[FOLKS_PERSONA_INDIVIDUAL_PROPERTY]);
}

gchar**
folks_persona_get_linkable_properties (FolksPersona* self,
                                       gint* result_length1)
{
	FolksPersonaClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_PERSONA_GET_CLASS (self);
	if (_klass_->get_linkable_properties) {
		return _klass_->get_linkable_properties (self, result_length1);
	}
	return NULL;
}

gchar**
folks_persona_get_writeable_properties (FolksPersona* self,
                                        gint* result_length1)
{
	FolksPersonaClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_PERSONA_GET_CLASS (self);
	if (_klass_->get_writeable_properties) {
		return _klass_->get_writeable_properties (self, result_length1);
	}
	return NULL;
}

static void
folks_persona_class_init (FolksPersonaClass * klass,
                          gpointer klass_data)
{
	folks_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksPersona_private_offset);
	((FolksPersonaClass *) klass)->linkable_property_to_links = (void (*) (FolksPersona*, const gchar*, FolksPersonaLinkablePropertyCallback, gpointer)) folks_persona_real_linkable_property_to_links;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_persona_finalize;
	/**
	   * The internal ID used to represent the Persona for linking.
	   *
	   * This is opaque, and shouldn't be parsed or considered meaningful by
	   * clients.
	   *
	   * The internal ID should be unique within a backend, but may not be unique
	   * across backends, so that links can be made between Personas with similar
	   * internal IDs.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_IID_PROPERTY, folks_persona_properties[FOLKS_PERSONA_IID_PROPERTY] = g_param_spec_string ("iid", "iid", "iid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The universal ID used to represent the Persona outside its {@link Backend}.
	   *
	   * This is opaque, and should only be parsed by clients using
	   * {@link Persona.split_uid}.
	   *
	   * This is the canonical way to refer to any Persona. It is guaranteed to be
	   * unique within the Persona's {@link PersonaStore}.
	   *
	   * A Persona's UID is immutable over the life of the Persona in the backing
	   * store, so a given UID is guaranteed to refer to the same Persona each time
	   * libfolks is used, until the Persona is permanently removed from its backing
	   * store.
	   *
	   * @see Persona.build_uid
	   * @see Persona.split_uid
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_UID_PROPERTY, folks_persona_properties[FOLKS_PERSONA_UID_PROPERTY] = g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The human-readable, service-specific universal ID used to represent the
	   * Persona.
	   *
	   * For example: ``foo@@xmpp.example.org``.
	   *
	   * This should be used whenever the user needs to be presented with a
	   * familiar, service-specific ID. For instance, in a prompt for the user to
	   * select a specific IM contact within an {@link Individual} to begin a chat
	   * with.
	   *
	   * This is not guaranteed to be unique outside of the Persona's
	   * {@link PersonaStore}, but is guaranteed to be unique within it. If a
	   * suitable human-readable ID isn’t available from the backend, the display ID
	   * will be equal to the {@link Persona.iid}.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_DISPLAY_ID_PROPERTY, folks_persona_properties[FOLKS_PERSONA_DISPLAY_ID_PROPERTY] = g_param_spec_string ("display-id", "display-id", "display-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * Whether the Persona is the user.
	   *
	   * Iff the Persona represents the user (the person who owns the account in
	   * the respective backend) this is ``true``.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_IS_USER_PROPERTY, folks_persona_properties[FOLKS_PERSONA_IS_USER_PROPERTY] = g_param_spec_boolean ("is-user", "is-user", "is-user", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The {@link PersonaStore} which contains this Persona.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_PROPERTY, folks_persona_properties[FOLKS_PERSONA_STORE_PROPERTY] = g_param_spec_object ("store", "store", "store", FOLKS_TYPE_PERSONA_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The {@link Individual} which contains this Persona.
	   *
	   * This may be ``null``, but should only ever be so when the Persona has just
	   * been created, when its {@link PersonaStore} is being destroyed, or when
	   * it's moving between {@link Individual}s.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_INDIVIDUAL_PROPERTY, folks_persona_properties[FOLKS_PERSONA_INDIVIDUAL_PROPERTY] = g_param_spec_object ("individual", "individual", "individual", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The names of the properties of this Persona which are linkable.
	   *
	   * If a property name is in this list, and the Persona is from a
	   * {@link PersonaStore} whose trust level is {@link PersonaStoreTrust.FULL},
	   * the {@link IndividualAggregator} should be able to reliably use the value
	   * of the property from a given Persona instance to link the Persona with
	   * other Personas and form {@link Individual}s.
	   *
	   * Note that {@link Persona.uid} is always implicitly a member of this list,
	   * and doesn't need to be added explicitly.
	   *
	   * This list will have no effect if the Persona's {@link PersonaStore} trust
	   * level is not {@link PersonaStoreTrust.FULL}.
	   *
	   * This property value is guaranteed to be constant for a given persona,
	   * but may vary between personas in the same store.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_LINKABLE_PROPERTIES_PROPERTY, folks_persona_properties[FOLKS_PERSONA_LINKABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * The names of the properties of this Persona which are writeable.
	   *
	   * If a property name is in this list, setting the property should result in
	   * the updated value being stored in the backend's permanent storage (unless
	   * it gets rejected due to being invalid, or a different error occurs).
	   *
	   * It's intended that this property value will be constant for a given Persona
	   * subclass, but this isn't guaranteed; it's possible that Persona subclasses
	   * may vary the value of this property at run time.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_WRITEABLE_PROPERTIES_PROPERTY, folks_persona_properties[FOLKS_PERSONA_WRITEABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
folks_persona_instance_init (FolksPersona * self,
                             gpointer klass)
{
	self->priv = folks_persona_get_instance_private (self);
	self->priv->_individual = NULL;
}

static void
folks_persona_finalize (GObject * obj)
{
	FolksPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_PERSONA, FolksPersona);
	folks_persona_set_individual (self, NULL);
	_g_free0 (self->priv->_iid);
	_g_free0 (self->priv->_uid);
	_g_free0 (self->priv->_display_id);
	G_OBJECT_CLASS (folks_persona_parent_class)->finalize (obj);
}

/**
 * Represents a "shard" of a person from a single source (a single
 * {@link Backend}), such as an XMPP contact from Telepathy or a vCard contact
 * from evolution-data-server.
 *
 * All the personas belonging to one physical person are aggregated to form a
 * single {@link Individual} representing that person.
 *
 * Properties of a persona are provided by implementing "details" interfaces,
 * such as {@link NameDetails} or {@link EmailDetails}. They must be accessed
 * through these interfaces. Different backends' subclasses of {@link Persona}
 * may implement different sets of interfaces. The set of interfaces implemented
 * by a given persona is guaranteed not to change over the lifetime of that
 * persona.
 */
static GType
folks_persona_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPersona), 0, (GInstanceInitFunc) folks_persona_instance_init, NULL };
	GType folks_persona_type_id;
	folks_persona_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPersona", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	FolksPersona_private_offset = g_type_add_instance_private (folks_persona_type_id, sizeof (FolksPersonaPrivate));
	return folks_persona_type_id;
}

GType
folks_persona_get_type (void)
{
	static volatile gsize folks_persona_type_id__once = 0;
	if (g_once_init_enter (&folks_persona_type_id__once)) {
		GType folks_persona_type_id;
		folks_persona_type_id = folks_persona_get_type_once ();
		g_once_init_leave (&folks_persona_type_id__once, folks_persona_type_id);
	}
	return folks_persona_type_id__once;
}

static void
_vala_folks_persona_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	FolksPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_PERSONA, FolksPersona);
	switch (property_id) {
		case FOLKS_PERSONA_IID_PROPERTY:
		g_value_set_string (value, folks_persona_get_iid (self));
		break;
		case FOLKS_PERSONA_UID_PROPERTY:
		g_value_set_string (value, folks_persona_get_uid (self));
		break;
		case FOLKS_PERSONA_DISPLAY_ID_PROPERTY:
		g_value_set_string (value, folks_persona_get_display_id (self));
		break;
		case FOLKS_PERSONA_IS_USER_PROPERTY:
		g_value_set_boolean (value, folks_persona_get_is_user (self));
		break;
		case FOLKS_PERSONA_STORE_PROPERTY:
		g_value_set_object (value, folks_persona_get_store (self));
		break;
		case FOLKS_PERSONA_INDIVIDUAL_PROPERTY:
		g_value_set_object (value, folks_persona_get_individual (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_persona_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	FolksPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_PERSONA, FolksPersona);
	switch (property_id) {
		case FOLKS_PERSONA_IID_PROPERTY:
		folks_persona_set_iid (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_UID_PROPERTY:
		folks_persona_set_uid (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_DISPLAY_ID_PROPERTY:
		folks_persona_set_display_id (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_IS_USER_PROPERTY:
		folks_persona_set_is_user (self, g_value_get_boolean (value));
		break;
		case FOLKS_PERSONA_STORE_PROPERTY:
		folks_persona_set_store (self, g_value_get_object (value));
		break;
		case FOLKS_PERSONA_INDIVIDUAL_PROPERTY:
		folks_persona_set_individual (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

