#include <stdlib.h>
#include <string.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#define YYPREFIX "yy"
#line 22 "parse.y"
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <grp.h>
#include <pwd.h>
#include <string.h>
#include <syslog.h>

#include "fdm.h"
#include "deliver.h"
#include "fetch.h"
#include "match.h"

struct strb	*parse_tags;
struct macros	 parse_macros;
struct macro	*parse_last;	/* last command-line argument macro */

u_int		 parse_ruleidx;
u_int		 parse_actionidx;

ARRAY_DECL(, struct rule *) parse_rulestack;
struct rule	*parse_rule;

struct files	 parse_filestack;
struct file	*parse_file;

int		 yyparse(void);

int
parse_conf(const char *path, struct strings *macros)
{
	struct macro	*macro;
	FILE		*f;
	u_int		 i;

	if ((f = fopen(path, "r")) == NULL)
		return (-1);

	ARRAY_INIT(&parse_rulestack);
	parse_rule = NULL;

	ARRAY_INIT(&parse_filestack);
	parse_file = xmalloc(sizeof *parse_file);

	parse_file->f = f;
	parse_file->line = 0;
	parse_file->path = path;

	strb_create(&parse_tags);
	default_tags(&parse_tags, NULL);
	add_tag(&parse_tags, "home", "%s", conf.user_home);

	TAILQ_INIT(&parse_macros);
	parse_last = NULL;
	for (i = 0; i < ARRAY_LENGTH(macros); i++) {
		parse_last = extract_macro(ARRAY_ITEM(macros, i));
		TAILQ_INSERT_TAIL(&parse_macros, parse_last, entry);
	}

	parse_file->line++;
	yyparse();

	if (!ARRAY_EMPTY(&parse_rulestack))
		yyerror("missing }");
	ARRAY_FREE(&parse_rulestack);

	ARRAY_FREE(&parse_filestack);
	xfree(parse_file);

	while (!TAILQ_EMPTY(&parse_macros)) {
		macro = TAILQ_FIRST(&parse_macros);
		TAILQ_REMOVE(&parse_macros, macro, entry);

		if (macro->type == MACRO_STRING)
			xfree(macro->value.str);
		xfree(macro);
	}

	strb_destroy(&parse_tags);

	fclose(f);
	return (0);
}

__dead printflike1 void
yyerror(const char *fmt, ...)
{
	va_list	ap;
	char   *s;

	xasprintf(&s,
	    "%s: %s at line %d", parse_file->path, fmt, parse_file->line);

	va_start(ap, fmt);
	log_vwrite(LOG_CRIT, s, ap);
	va_end(ap);

	exit(1);
}
#line 255 "parse.y"
#ifndef YYSTYPE_DEFINED
#define YYSTYPE_DEFINED
typedef union
{
	long long		 number;
	char			*string;
	int			 flag;
	u_int			 locks;
	struct {
		struct fetch	*fetch;
		void		*data;
	} fetch;
	struct {
		char		*host;
		char		*port;
	} server;
	enum area		 area;
	enum exprop		 exprop;
	struct actitem		*actitem;
	struct actlist		*actlist;
	struct expr		*expr;
	struct expritem		*expritem;
	struct strings		*strings;
	struct replstrs		*replstrs;
	enum fetch_only		 only;
	struct {
		char		*path;
		enum fetch_only	 only;
	} poponly;
	struct {
		int		 flags;
		char		*str;
	} re;
	gid_t			 localgid;
	enum cmp		 cmp;
	struct rule		*rule;
	struct {
		char		*user;
		int		 user_netrc;
		char		*pass;
		int		 pass_netrc;
	} userpass;
	userfunction		 ufn;
	struct userfunctions	*ufns;
} YYSTYPE;
#endif /* YYSTYPE_DEFINED */
#line 161 "parse.c"
#define TOKACCOUNT 257
#define TOKACCOUNTS 258
#define TOKACTION 259
#define TOKACTIONS 260
#define TOKADDHEADER 261
#define TOKADDTOCACHE 262
#define TOKAGE 263
#define TOKALL 264
#define TOKALLOWMANY 265
#define TOKAND 266
#define TOKANYNAME 267
#define TOKANYSIZE 268
#define TOKANYTYPE 269
#define TOKAPPEND 270
#define TOKATTACHMENT 271
#define TOKBODY 272
#define TOKBYTES 273
#define TOKCACHE 274
#define TOKCASE 275
#define TOKCMDUSER 276
#define TOKCOMPRESS 277
#define TOKCONTINUE 278
#define TOKCOUNT 279
#define TOKDAYS 280
#define TOKDEFUSER 281
#define TOKDELTOOBIG 282
#define TOKDISABLED 283
#define TOKDOMAIN 284
#define TOKDOTLOCK 285
#define TOKDROP 286
#define TOKEQ 287
#define TOKEXEC 288
#define TOKEXPIRE 289
#define TOKFCNTL 290
#define TOKFILEGROUP 291
#define TOKFILEUMASK 292
#define TOKFLOCK 293
#define TOKFOLDER 294
#define TOKFOLDERS 295
#define TOKFROM 296
#define TOKGIGABYTES 297
#define TOKGROUP 298
#define TOKGROUPS 299
#define TOKHEADER 300
#define TOKHEADERS 301
#define TOKHOURS 302
#define TOKIGNOREERRORS 303
#define TOKIMAP 304
#define TOKIMAPS 305
#define TOKIMPLACT 306
#define TOKIN 307
#define TOKINCACHE 308
#define TOKINSECURE 309
#define TOKINVALID 310
#define TOKKEEP 311
#define TOKKEY 312
#define TOKKILOBYTES 313
#define TOKLMTP 314
#define TOKLOCKFILE 315
#define TOKLOCKTIMEOUT 316
#define TOKLOCKTYPES 317
#define TOKLOCKWAIT 318
#define TOKLOOKUPORDER 319
#define TOKMAILDIR 320
#define TOKMAILDIRS 321
#define TOKMATCH 322
#define TOKMATCHED 323
#define TOKMAXSIZE 324
#define TOKMBOX 325
#define TOKMBOXES 326
#define TOKMEGABYTES 327
#define TOKMINUTES 328
#define TOKMONTHS 329
#define TOKNE 330
#define TOKNEWONLY 331
#define TOKNNTP 332
#define TOKNNTPS 333
#define TOKNOAPOP 334
#define TOKNOCRAMMD5 335
#define TOKNOCREATE 336
#define TOKNOLOGIN 337
#define TOKNONE 338
#define TOKNOPLAIN 339
#define TOKNORECEIVED 340
#define TOKNOT 341
#define TOKNOUIDL 342
#define TOKNOVERIFY 343
#define TOKXOAUTH2 344
#define TOKOAUTHBEARER 345
#define TOKOLDONLY 346
#define TOKOR 347
#define TOKPARALLELACCOUNTS 348
#define TOKPASS 349
#define TOKPASSWD 350
#define TOKPIPE 351
#define TOKPOP3 352
#define TOKPOP3S 353
#define TOKPORT 354
#define TOKPROXY 355
#define TOKPURGEAFTER 356
#define TOKQUEUEHIGH 357
#define TOKQUEUELOW 358
#define TOKREMOVEFROMCACHE 359
#define TOKREMOVEHEADER 360
#define TOKREMOVEHEADERS 361
#define TOKRETURNS 362
#define TOKREWRITE 363
#define TOKSECONDS 364
#define TOKSERVER 365
#define TOKSET 366
#define TOKSIZE 367
#define TOKSMTP 368
#define TOKSTARTTLS 369
#define TOKSTDIN 370
#define TOKSTDOUT 371
#define TOKSTRING 372
#define TOKSTRIPCHARACTERS 373
#define TOKTAG 374
#define TOKTAGGED 375
#define TOKTIMEOUT 376
#define TOKTO 377
#define TOKTOTALSIZE 378
#define TOKUNMATCHED 379
#define TOKUSER 380
#define TOKUSERS 381
#define TOKVALUE 382
#define TOKVERIFYCERTS 383
#define TOKWEEKS 384
#define TOKWRITE 385
#define TOKYEARS 386
#define NONE 387
#define NUMBER 388
#define STRING 389
#define STRMACRO 390
#define NUMMACRO 391
#define STRCOMMAND 392
#define NUMCOMMAND 393
#define YYERRCODE 256
const short yylhs[] =
	{                                        -1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   82,
   82,   83,   83,   84,   84,   85,   85,   86,   86,   87,
   87,   88,   88,   89,   89,   59,   59,   60,   60,   55,
   55,   55,   56,   56,   37,   37,   37,   57,   58,   35,
   35,   35,   35,   35,   36,   36,   36,   36,   36,   36,
   36,   36,   39,   39,   81,   79,   79,   79,   79,   79,
   79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
   79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
   79,   79,   79,   77,   77,   43,   43,   63,   63,   64,
   64,   73,   74,   74,   45,   45,   65,   65,   66,   66,
   68,   68,   33,   33,   33,   34,   34,   34,   32,   32,
   62,   62,   47,   47,   47,   48,   48,   13,   13,   15,
   15,   14,   14,   52,   52,   51,   51,   53,   53,   54,
   54,   18,   18,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    2,    2,   76,   76,   46,   46,   44,   44,   12,   12,
    3,    3,    3,    3,   38,   38,   49,   49,    5,    5,
    6,    6,    4,    4,   16,   16,   17,   17,   10,   10,
    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
    9,    9,    9,    9,    9,    9,    9,    8,    8,    7,
    7,   50,   50,   50,   50,   80,   78,   69,   69,   61,
   61,   67,   67,   24,   24,   25,   25,   26,   26,   28,
   28,   27,   27,   29,   29,   30,   30,   31,   31,   19,
   19,   20,   20,   40,   40,   21,   21,   22,   22,   23,
   23,   72,   72,   72,   72,   71,   70,   70,   42,   42,
   41,   41,   11,   11,   11,   11,   11,   11,   11,   11,
   75,
};
const short yylen[] =
	{                                         2,
    0,    2,    2,    2,    2,    2,    2,    2,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    2,    1,    2,    0,    1,
    1,    1,    1,    3,    1,    1,    1,    1,    1,    1,
    2,    2,    2,    2,    1,    2,    2,    2,    2,    2,
    2,    2,    2,    0,    3,    3,    3,    3,    2,    3,
    2,    2,    2,    3,    3,    3,    3,    3,    3,    3,
    3,    2,    3,    3,    3,    3,    2,    2,    3,    3,
    3,    3,    3,    3,    3,    2,    1,    2,    1,    2,
    1,    1,    2,    1,    2,    4,    2,    4,    2,    4,
    2,    4,    1,    1,    1,    2,    1,    1,    1,    1,
    0,    2,    0,    2,    4,    2,    1,    1,    0,    1,
    0,    1,    0,    2,    2,    3,    2,    0,    2,    0,
    2,    1,    0,    2,    2,    2,    2,    1,    3,    3,
   12,    4,    4,    1,    3,    4,    4,    1,    1,    1,
    2,    1,    4,    6,    2,    4,    2,    4,    0,    1,
    0,    2,    2,    2,    1,    0,    1,    0,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    2,    3,    2,   10,    3,    4,    5,    5,    2,    2,
    4,    3,    5,    5,    5,    4,    4,    3,    2,    1,
    2,    4,    6,    3,    1,    1,    3,    0,    1,    0,
    2,    2,    4,    1,    0,    1,    0,    1,    0,    1,
    0,    1,    0,    1,    0,    1,    0,    1,    0,    1,
    0,    1,    0,    1,    1,    1,    1,    1,    1,    1,
    1,    4,    0,    2,    2,    4,    1,    0,    3,    0,
    1,    0,    9,    6,   13,    6,    1,    1,    1,    8,
    6,
};
const short yydefred[] =
	{                                      1,
    0,    0,    0,    0,    0,    0,    9,    0,    0,  206,
    2,    3,    4,    5,    6,    7,    8,   31,   32,   30,
   33,    0,    0,    0,    0,    0,  118,    0,    0,    0,
   63,    0,    0,   61,    0,    0,   62,    0,    0,    0,
    0,   59,    0,    0,   78,   77,    0,    0,    0,    0,
    0,    0,    0,   72,    0,    0,    0,  122,    0,   12,
   13,    0,    0,    0,   55,  205,    0,  207,  179,  180,
    0,    0,   14,   15,    0,  181,    0,    0,  175,    0,
  189,  176,    0,    0,    0,  190,    0,  183,    0,  117,
    0,    0,    0,   79,   36,   37,   35,   80,  110,  109,
   81,   83,   74,   73,   58,   60,    0,  105,  103,  104,
  108,  107,    0,   92,   94,    0,   56,    0,   70,   71,
   76,   75,   68,   69,    0,   67,    0,   85,   34,    0,
   10,   11,    0,    0,  178,  149,  238,  239,  150,    0,
    0,    0,    0,   24,   25,    0,    0,  144,    0,  177,
    0,  153,    0,    0,    0,  148,  138,    0,    0,    0,
    0,   53,    0,    0,    0,  199,  192,  169,  170,    0,
    0,    0,    0,    0,    0,  116,    0,    0,    0,    0,
    0,    0,  182,    0,    0,   49,   46,   47,   51,   48,
   50,   52,  106,   93,   41,   44,   42,   43,    0,   20,
   21,   22,   23,  240,  241,    0,  237,  257,    0,    0,
    0,    0,  258,  259,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  152,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  160,  204,    0,
    0,  198,  191,    0,    0,    0,  171,  172,    0,  173,
  174,    0,    0,  186,    0,    0,    0,  162,  164,  163,
    0,    0,    0,  120,  261,    0,    0,    0,    0,   97,
    0,   99,    0,    0,  139,    0,    0,    0,    0,  132,
  140,    0,    0,    0,  145,  154,  151,    0,    0,    0,
    0,    0,  115,    0,    0,  202,  195,  193,  194,    0,
  187,    0,    0,  156,    0,    0,    0,    0,    0,   91,
    0,    0,    0,    0,    0,  126,    0,    0,  143,    0,
  142,    0,  245,    0,   18,   19,    0,    0,  158,   96,
    0,    0,    0,    0,  247,    0,  234,  235,    0,    0,
  209,    0,    0,   16,   17,    0,    0,   98,   90,  100,
  125,  124,    0,    0,  230,    0,    0,  203,  165,    0,
    0,    0,    0,    0,  232,    0,  251,    0,    0,  101,
    0,    0,  212,  242,  214,    0,    0,    0,  256,  254,
  249,    0,    0,   89,    0,    0,    0,  216,    0,  167,
    0,  246,  222,    0,    0,  102,   88,    0,  213,  218,
    0,  184,  220,    0,    0,  224,  260,    0,  253,    0,
    0,    0,  226,    0,    0,  228,  141,    0,  255,
};
const short yydgoto[] =
	{                                       1,
  227,  228,  183,  249,  170,  251,   28,   71,   29,   72,
  209,  239,   30,   59,  265,  153,  154,  281,  356,  366,
  210,  155,  212,  376,  389,  401,  394,  404,  407,  414,
  417,   98,  112,  113,  117,  106,  107,  360,   65,  339,
  368,  340,  291,  156,  157,   88,   62,   89,  391,   68,
  220,  316,  319,  279,   21,   22,   90,  310,  275,  285,
  327,  257,  385,  311,  213,  214,  346,  341,  342,  334,
  335,  290,  115,  116,   11,   12,   13,   14,   15,   16,
   17,  158,   63,   91,  347,  343,  215,  216,  159,
};
const short yysindex[] =
	{                                      0,
  715, -304, -304, -304, -252, 4601,    0,   31,   48,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   73, -138, -314,   73, -171,    0, -107, -243, -180,
    0, -304, -304,    0,  704, -213,    0, -246, -304, -242,
 -244,    0, -197, -242,    0,    0, -242, -304, -320, -242,
 -242, -304, -242,    0, -304, -242, -304,    0, -314,    0,
    0, 4202, -120, -242,    0,    0, -184,    0,    0,    0,
 -243, -252,    0,    0,  -32,    0, -234, -304,    0, -304,
    0,    0,   -7, -304, -304,    0, -304,    0, -152,    0,
  -99,   73,   73,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -265,    0,    0,    0,
    0,    0, -160,    0,    0, -197,    0, -215,    0,    0,
    0,    0,    0,    0,   73,    0,   73,    0,    0, 1359,
    0,    0, -304, -304,    0,    0,    0,    0,    0, -200,
 -304, -304, -304,    0,    0, -304, -200,    0, -304,    0,
 4538,    0, -304, -304, -200,    0,    0,  -72,    8, -304,
   73,    0, -110, 4040, -252,    0,    0,    0,    0, -242,
 -304,   -7, -304,  -53,   -7,    0, -143, -242,  -35,   73,
  -43, -220,    0, -304,   73,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -179,    0,
    0,    0,    0,    0,    0, -178,    0,    0, -137, -200,
 -200, -200,    0,    0,   15,   38,   -5, -136, -304, -117,
   73,  -39, -131,   73, -117,  -41,    0, 4332,   73,   73,
 -306, -304,   73, -304,   73,   25,   73,    0,    0, 4470,
 -110,    0,    0,   73, -242,   73,    0,    0, -242,    0,
    0, -242, -304,    0, -253, -304, -176,    0,    0,    0,
   60, -304, -304,    0,    0, -306, -306, -306, -304,    0,
 -304,    0, -304,   73,    0, -304, -170, -304, -194,    0,
    0, -304, -194, -304,    0,    0,    0, -304, -304, -154,
   64,   83,    0,   73, 4408,    0,    0,    0,    0,   73,
    0,   73,  148,    0, -189, -189, -277, -154, -164,    0,
   91,  118,   73,   73,  396,    0,   73, -304,    0,   73,
    0,   73,    0, -155,    0,    0, -147, -304,    0,    0,
 -110, -242, -304, -154,    0, -277,    0,    0,  -77, -133,
    0, -277,   43,    0,    0,  -76,   47,    0,    0,    0,
    0,    0,   73, -304,    0, -132,   73,    0,    0,  158,
 -145, -277, -133, -304,    0, -147,    0, -147, -304,    0,
 -304, -304,    0,    0,    0, -134, -253, -304,    0,    0,
    0, -129, -132,    0,  123, -147,  129,    0, -130,    0,
  176,    0,    0, -149, -134,    0,    0,  -88,    0,    0,
 -149,    0,    0,  -88, -130,    0,    0,  -88,    0, -149,
 -122,  -88,    0, -118, -122,    0,    0, -118,    0,};
const short yyrindex[] =
	{                                      0,
    0,    0,    0,    0, -161,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    1, 3850, 4264,  100,   29,    0, -100,  359,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1454,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  370, -161,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  612,    0,
    0,  873, 3485,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1329,    0,    0,    0,
    0,    0, 3687,    0,    0, 3705,    0, 3115,    0,    0,
    0,    0,    0,    0, 3724,    0, 3737,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 4134,    0, 3743,    0, -161,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  901,
 -127,    0,    0,    0,  967,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -141,    0,
    0,    0,    0,    0,    0, -126,    0,    0, 3757,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1477,
 1762, 1857,    0, 1952, 1477, 2047,    0,    0, 2142, 2237,
  458,    0, 2332,    0, 2427,    0,  134,    0,    0,    0,
 3743,    0,    0, 1085,    0, 1204,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3407, 3286, -135,    0,    0,
    0,    0,    0, 2522,    0,    0,  200,    0, 2617,    0,
    0,    0, 2617,    0,    0,    0,    0,    0,    0,  576,
    0,    0,    0,  140,    0,    0,    0,    0,    0, 1233,
    0, -125,    0,    0,  994,    0, 3474, 3305,    0,    0,
    0,    0, 2712, 2807,    0,    0, 1572,    0,    0, 2902,
    0, 2997,    0,  339,    0,    0,  813,    0,    0,    0,
 3743,  183,    0,  468,    0,  281,    0,    0,    0, 3544,
    0, 3345,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 3092,    0,    0,  932,  695,    0,    0,    0,
    0,  738,  754,    0,    0, 3638,    0, 3445,    0,    0,
    0,    0,    0,    0,    0, 1050,  189,    0,    0,    0,
    0,  501,   57,    0,    0,  975,    0,    0, 1169,    0,
    0,    0,    0, 3679, 3536,    0,    0, 1131,    0,    0,
 1287,    0,    0, 1131, 3585,    0,    0, 1382,    0, 3647,
 1667,  657,    0, 3187,  517,    0,    0, 1228,    0,};
const short yygindex[] =
	{                                      0,
  -51,   -8,    0,    0,  -52,    0,    0,    0,  -60,  162,
    0, -202,    0,    0,    0,  206,    0,    0, -296, -123,
    0,  111,    0, -119, -153, -159,    0, -351, -297, -166,
 -173,    0,  137,    0, -165,  -28,  -30,    0,    0, -315,
 -111,  -84, -128,  186,    0,    0,   20, -245,    0,    0,
  -54,    0,  -26,   30,  209, 4106, 3889,  113,    0,    0,
    0,    0, -104,    5,    0,    0,    0,    0,  -42,    0,
  -24, -206,  164,    0,    0,    0,    0,    0,    0,    0,
    0,  216,    0,    0,    0,    4,    0,    0,    0,
};
#define YYTABLESIZE 4984
const short yytable[] =
	{                                      57,
   38,   57,  160,   57,   99,  102,  168,   57,  169,  301,
  152,  166,  254,  118,  186,   66,  119,  121,  122,  123,
  124,   78,   69,  184,  126,  128,  367,  168,   54,  169,
  178,  236,  171,  172,  173,  162,  187,   57,  296,  103,
  108,   38,  288,  258,  174,  109,  367,   67,  110,  408,
  232,  259,  168,  337,  169,  261,  215,  195,  412,  307,
  308,  309,  188,  189,  104,   60,   61,   95,  338,  382,
   96,  383,   97,  289,  131,  132,   73,   74,  130,  297,
  260,  196,   75,   76,   18,   19,  299,   20,   27,  398,
   77,   55,  225,  111,   78,  119,  119,  197,  190,   39,
  231,  119,  119,   70,  242,  292,  409,   79,   56,  119,
  411,  198,  241,  119,  415,   57,   26,   64,  191,  245,
  192,  250,  252,   38,  108,   38,  119,   80,  358,  109,
  234,  390,  110,  344,  345,   18,   19,  269,   20,  325,
  326,  243,   81,  175,   58,   95,  119,  118,   96,  293,
   97,  105,  114,   54,  182,  266,  267,  268,  113,  113,
  271,  119,  243,  243,  219,  369,  101,  238,  253,  372,
   82,  262,  263,  264,   95,  276,  287,   96,  278,   97,
  282,  215,  318,  315,  304,  303,   83,  332,  329,  119,
  333,   84,  177,  354,   85,  355,  364,  371,   86,  127,
  365,  377,  375,  378,  388,  119,  400,  330,   18,   19,
  119,   20,  393,  119,  118,  348,  402,  119,  298,  403,
  406,  118,  413,  238,   39,  416,  166,  119,  119,  168,
  119,  295,  165,  247,  111,   87,  112,  280,  236,  380,
  211,  405,  350,  287,  419,  410,  218,  396,  418,  193,
  379,  363,  163,  399,  283,  223,  321,   38,   87,   38,
   38,   38,   38,  395,   86,  129,   38,  387,   18,   19,
   38,   20,   60,   61,   38,  312,  248,  167,   38,  194,
  250,  336,  164,   38,  351,   54,   38,   54,   38,   18,
   19,  362,   20,  328,   38,   38,   38,    0,   38,   38,
    0,  359,   54,    0,   38,   38,    0,   38,    0,   38,
    0,   38,    0,  215,   38,  215,   18,   19,    0,   20,
   38,   38,   38,    0,  127,   38,   38,  270,  272,    0,
  215,   38,   38,   38,   38,   38,  256,   38,  244,   38,
  284,  255,   38,   38,   38,   38,   38,   38,    0,   38,
   54,   38,   38,   38,   38,    0,   39,    0,   39,   38,
   38,   38,    0,   38,    0,  215,   38,  215,   38,   38,
   38,   38,    0,   39,   38,    0,  273,   38,  215,    0,
   38,   38,    0,   18,   19,   38,   20,   38,   39,   38,
   38,   38,   38,  215,   54,  215,   18,   19,    0,   20,
  215,  215,    0,   18,   19,  250,   20,    0,   39,    0,
   39,   39,    0,   18,   19,   54,   20,    0,   54,   54,
    0,   39,  215,  349,  349,  215,   18,   19,    0,   20,
    0,   18,   19,   39,   20,   18,   19,    0,   20,    0,
    0,   39,   39,  215,    0,    0,  215,  215,   18,   19,
    0,   20,   18,   19,    0,   20,  127,  243,  127,  127,
  127,  127,    0,  244,    0,   39,    0,  208,   39,  127,
    0,   18,   19,  127,   20,    0,  381,  127,    0,   18,
   19,  200,   20,  386,    0,  127,   39,  127,   39,   39,
   39,   39,  201,  127,  127,  127,    0,  127,  127,    0,
  223,    0,    0,  127,  127,    0,   18,   19,  127,   20,
  127,   18,   19,  127,   20,    0,  227,   18,   19,  127,
   20,  127,   87,   87,  127,   87,    0,    0,   86,   86,
  127,   86,    0,  127,  127,    0,  127,  250,  127,  250,
    0,  127,  127,  127,  127,  127,    0,    0,  127,    0,
  127,    0,    0,    0,  250,    0,    0,    0,  127,  127,
  127,    0,  127,    0,    0,  127,    0,  127,  127,    0,
  127,    0,    0,  127,    0,  210,  127,    0,    0,  127,
    0,    0,  243,    0,  127,    0,  127,    0,    0,  127,
  127,  250,  208,    0,    0,  244,    0,  244,  244,  244,
  244,    0,  250,    0,    0,    0,    0,    0,  244,    0,
    0,    0,  244,    0,  250,    0,  244,  200,  200,    0,
    0,    0,    0,    0,  244,  223,  244,    0,  201,  201,
    0,    0,  244,  244,    0,    0,  244,  244,    0,    0,
    0,  227,  244,  244,    0,    0,  250,  244,    0,  244,
    0,    0,  244,    0,    0,    0,  225,    0,  244,    0,
  244,    0,    0,  244,    0,    0,    0,  250,    0,  244,
  250,  250,  244,  244,    0,  244,    0,  244,    0,    0,
  244,  244,  244,  244,  244,    0,    0,    0,    0,  244,
    0,    0,    0,    0,  211,    0,    0,  244,  244,  244,
  210,  244,    0,    0,  244,    0,  244,  244,    0,  244,
    0,    0,  244,    0,  243,    0,  243,  243,  243,  243,
    0,    0,    0,  244,  208,  244,  208,  243,  244,  244,
    0,  243,    0,    0,  161,  243,    0,  252,  200,  200,
    0,  208,    0,  243,    0,  243,    0,    0,    0,  201,
  201,  243,  243,  233,    0,    0,    0,  223,    0,  223,
    0,  243,  243,    0,    0,    0,  243,    0,  243,    0,
    0,  243,    0,  227,  223,  227,    0,  243,  208,  243,
    0,  225,  243,   95,   18,   19,   96,   20,   97,  208,
  227,    0,  243,    0,  243,    0,  243,    0,  208,    0,
  243,  243,  243,    0,    0,    0,    0,    0,  243,  223,
    0,  223,  231,  208,    0,    0,  243,  243,  243,  211,
  243,    0,  223,  243,    0,  243,  243,  227,  243,    0,
    0,  243,  210,  208,  210,  210,  210,  210,  227,   10,
    0,    0,  243,    0,  243,  210,    0,  243,  243,  210,
    0,    0,    0,  210,  208,    0,    0,  208,  208,    0,
  227,  210,  252,  210,    0,    0,  223,    0,    0,  223,
  161,  161,   65,    0,    0,    0,    0,  161,  233,  210,
  210,    0,  227,    0,  210,    0,  210,  223,    0,  210,
  223,  223,    0,    0,    0,  210,    0,  210,    0,    0,
  210,    0,    0,  227,    0,    0,  227,  227,    0,    0,
  210,    0,  210,  225,  210,  225,    0,    0,  210,  210,
  210,    0,    0,    0,    0,    0,  210,    0,    0,    0,
  225,  215,    0,    0,  210,  210,  210,  231,  210,    0,
    0,  210,    0,  210,  210,    0,  210,    0,    0,  210,
    0,  211,    0,  211,  211,  211,  211,    0,  161,    0,
  210,    0,  210,    0,  211,  210,  210,  225,  211,    0,
    0,    2,  211,    3,  231,    0,    0,    0,  225,    0,
  211,    0,  211,    0,    0,    0,    0,    0,    4,    0,
    0,  161,  161,  248,  252,    0,  252,   65,  211,  211,
  225,  225,    0,  211,    0,  211,    0,    0,  211,    0,
  233,  252,  233,    0,  211,    0,  211,    0,    0,  211,
    0,    0,  225,  185,    0,    0,    0,  233,    0,  211,
    0,  211,    0,  211,    0,    0,    5,  211,  211,  211,
    0,    0,    0,  225,    0,  211,  225,  225,  252,  217,
    0,    0,    0,  211,  211,  211,  215,  211,    0,  252,
  211,    0,  211,  211,  233,  211,    0,    0,  211,  231,
    0,  231,  231,  231,  231,  233,    0,    0,    0,  211,
    6,  211,  231,   94,  211,  211,  231,    0,    0,  155,
  231,   95,   18,   19,   96,   20,   97,    0,  231,  231,
  231,    7,    0,  252,    8,    9,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  231,  231,  248,  233,
    0,  231,    0,  231,  252,    0,  231,  252,  252,   65,
  225,   65,  231,    0,  231,    0,    0,  231,    0,    0,
  233,    0,    0,  233,  233,    0,   65,  231,    0,  231,
    0,  231,    0,    0,    0,    0,  231,  231,    0,  185,
  185,    0,    0,  231,    0,    0,  185,    0,  219,    0,
    0,  231,  231,  231,  217,  231,    0,    0,  231,    0,
  231,  231,    0,  231,    0,    0,  231,    0,  215,    0,
  215,  215,  215,  215,   65,    0,    0,  231,    0,  231,
    0,  215,  231,  231,    0,  215,    0,  197,    0,  215,
    0,    0,    0,    0,    0,    0,    0,  215,    0,  215,
    0,    0,    0,    0,    0,  155,  155,  229,    0,    0,
    0,  231,  155,  231,    0,  215,  215,    0,   65,    0,
  215,    0,  215,    0,    0,  215,    0,  185,  231,    0,
  248,  215,  248,  215,    0,  225,  215,    0,    0,   65,
    0,    0,   65,   65,    0,    0,    0,  248,  215,    0,
  215,    0,    0,    0,    0,  215,  215,    0,    0,    0,
  185,  185,  215,  231,    0,  231,  221,  248,  248,    0,
  215,  215,  215,  219,  215,    0,  231,  215,    0,  215,
  215,    0,  215,    0,  248,  215,  217,    0,  217,  217,
  217,  217,    0,  155,    0,  248,  215,    0,  215,  217,
    0,  215,  215,  217,  248,    0,  196,  217,   45,    0,
    0,    0,    0,    0,    0,  217,    0,  217,    0,  248,
  231,    0,    0,  197,  197,    0,  155,  155,    0,    0,
  197,    0,  229,  217,  217,  188,    0,    0,  217,  248,
  217,  231,    0,  217,  231,  231,    0,    0,    0,  217,
    0,  217,    0,    0,  217,    0,    0,    0,    0,    0,
  248,  225,    0,  248,  248,    0,  217,  225,    0,  225,
    0,    0,    0,  217,  217,    0,    0,    0,    0,    0,
  217,    0,    0,    0,  225,    0,    0,    0,  217,  217,
  217,  221,  217,    0,    0,  217,    0,  217,  217,    0,
  217,    0,    0,  217,    0,  219,    0,  219,  219,  219,
  219,  197,    0,    0,  217,    0,  217,    0,  219,  217,
  217,  225,  219,    0,    0,    0,  219,    0,    0,    0,
    0,   45,  225,   45,  219,    0,  219,    0,    0,    0,
    0,    0,  196,  196,  197,  197,    0,    0,    0,  196,
    0,    0,  219,  219,    0,    0,  130,  219,    0,  219,
    0,    0,  219,    0,  229,    0,  229,    0,  219,    0,
  219,  188,  188,  219,    0,    0,  225,    0,  188,    0,
    0,  229,    0,    0,    0,    0,  225,    0,    0,    0,
    0,    0,  219,  219,    0,    0,    0,  225,    0,  219,
  225,  225,    0,    0,    0,    0,    0,  219,  219,  219,
    0,  219,    0,    0,  219,    0,  219,  219,  229,  219,
    0,    0,  219,  221,    0,  221,  221,  221,  221,  229,
  196,    0,    0,  219,    0,  219,  221,    0,  219,  219,
  221,    0,    0,    0,  221,    0,    0,    0,    0,    0,
    0,  131,  221,    0,  221,    0,    0,    0,    0,  188,
    0,    0,    0,  196,  196,   45,    0,   45,   45,    0,
  221,  221,    0,  229,   45,  221,    0,  221,    0,    0,
  221,  130,   45,    0,    0,    0,  221,    0,  221,    0,
    0,  221,  188,  188,  229,    0,    0,  229,  229,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  221,  221,    0,    0,    0,    0,    0,  221,  225,    0,
  225,  225,  225,  225,    0,  221,  221,  221,    0,  221,
   45,  225,  221,    0,  221,  225,    0,  221,    0,  225,
  221,    0,  199,  138,    0,    0,  227,  225,    0,  225,
    0,  221,    0,  221,    0,   45,  221,  221,  200,  201,
    0,    0,    0,  202,  203,  225,  225,    0,    0,    0,
  204,  205,  225,    0,   45,  225,  131,    0,    0,    0,
    0,  225,    0,  225,    0,    0,  225,    0,   45,   45,
  206,  207,    0,    0,    0,   45,    0,    0,   45,   45,
    0,    0,    0,    0,    0,  225,  225,    0,  208,    0,
    0,    0,  225,  130,    0,  130,  130,  130,  130,    0,
  225,  225,  225,    0,  225,    0,  130,  225,    0,  225,
  130,    0,  225,    0,  130,  225,    0,  113,  113,    0,
    0,  137,  130,    0,  130,    0,  225,    0,  225,    0,
    0,  225,  225,  113,  113,    0,    0,    0,  113,  113,
  130,  130,    0,    0,    0,  113,  113,  130,    0,    0,
  130,  227,    0,    0,    0,    0,  130,    0,  130,    0,
    0,  130,    0,    0,    0,  113,  113,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  113,    0,    0,    0,  130,  131,    0,
  131,  131,  131,  131,    0,  130,  130,  130,    0,  130,
    0,  131,  130,    0,  130,  131,    0,  130,    0,  131,
  130,    0,    0,  130,    0,    0,  133,  131,    0,  131,
    0,  130,    0,  130,    0,    0,  130,  130,    0,    0,
    0,    0,    0,    0,    0,  131,  131,    0,    0,    0,
    0,    0,  131,    0,    0,  131,  137,    0,    0,    0,
    0,  131,    0,  131,    0,    0,  131,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  131,  227,    0,  227,  227,  227,  227,    0,
  131,  131,  131,    0,  131,    0,  227,  131,    0,  131,
  227,    0,  131,    0,  227,  131,    0,    0,  131,    0,
    0,  135,  227,    0,  227,    0,  131,    0,  131,    0,
    0,  131,  131,    0,    0,    0,    0,    0,    0,    0,
  227,  227,    0,    0,    0,    0,    0,  227,    0,    0,
  227,  133,    0,    0,    0,    0,  227,    0,  227,    0,
    0,  227,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  227,    0,    0,    0,    0,    0,    0,  227,  137,    0,
  137,  137,  137,  137,    0,  227,  227,  227,    0,  227,
    0,  137,  227,    0,  227,  137,    0,  227,    0,  137,
  227,    0,    0,    0,    0,    0,   29,  137,    0,  137,
    0,  227,    0,  227,    0,    0,  227,  227,    0,    0,
    0,    0,    0,    0,    0,  137,  137,    0,    0,    0,
    0,    0,  137,    0,    0,  137,  135,    0,    0,    0,
    0,  137,    0,  137,    0,    0,  137,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  137,  133,    0,  133,  133,  133,  133,    0,
  137,  137,  137,    0,  137,    0,  133,  137,    0,  137,
  133,    0,  137,    0,  133,  137,    0,    0,    0,    0,
    0,  134,  133,    0,  133,    0,  137,    0,  137,    0,
    0,  137,  137,    0,    0,    0,    0,    0,    0,    0,
  133,  133,    0,    0,    0,    0,    0,  133,    0,    0,
  133,   29,    0,    0,    0,    0,  133,    0,  133,    0,
    0,  133,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  133,  135,    0,
  135,  135,  135,  135,    0,  133,  133,  133,    0,  133,
    0,  135,  133,    0,  133,  135,    0,  133,    0,  135,
  133,    0,    0,    0,    0,    0,  136,  135,    0,  135,
    0,  133,    0,  133,    0,    0,  133,  133,    0,    0,
    0,    0,    0,    0,    0,  135,  135,    0,    0,    0,
    0,    0,  135,    0,    0,  135,  134,    0,    0,    0,
    0,  135,    0,  135,    0,    0,  135,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  135,   29,    0,   29,   29,   29,   29,    0,
  135,  135,  135,    0,  135,    0,   29,  135,    0,  135,
   29,    0,  135,    0,   29,  135,    0,    0,    0,    0,
    0,  157,   29,    0,   29,    0,  135,    0,  135,    0,
    0,  135,  135,    0,    0,    0,    0,    0,    0,    0,
   29,   29,    0,    0,    0,    0,    0,   29,    0,    0,
   29,  136,    0,    0,    0,    0,   29,    0,   29,    0,
    0,   29,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   29,  134,    0,
  134,  134,  134,  134,    0,   29,   29,   29,    0,   29,
    0,  134,   29,    0,   29,  134,    0,   29,    0,  134,
   29,    0,    0,    0,    0,    0,   95,  134,    0,  134,
    0,   29,    0,   29,    0,    0,   29,   29,    0,    0,
    0,    0,    0,    0,    0,  134,  134,    0,    0,    0,
    0,    0,  134,    0,    0,  134,  157,    0,    0,    0,
    0,  134,    0,  134,    0,    0,  134,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  134,  136,    0,  136,  136,  136,  136,    0,
  134,  134,  134,    0,  134,    0,  136,  134,    0,  134,
  136,    0,  134,    0,  136,  134,    0,    0,    0,    0,
    0,   27,  136,    0,  136,    0,  134,    0,  134,    0,
    0,  134,  134,    0,    0,    0,    0,    0,    0,    0,
  136,  136,    0,    0,    0,    0,    0,  136,    0,    0,
  136,   95,    0,    0,    0,    0,  136,    0,  136,    0,
    0,  136,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  136,  157,    0,
  157,  157,  157,  157,    0,  136,  136,  136,    0,  136,
    0,  157,  136,    0,  136,  157,    0,  136,    0,  157,
  136,    0,    0,    0,    0,    0,  128,  157,    0,  157,
    0,  136,    0,  136,    0,    0,  136,  136,    0,    0,
    0,    0,    0,    0,    0,  157,  157,    0,    0,    0,
    0,    0,  157,    0,    0,  157,   27,    0,    0,    0,
    0,  157,    0,  157,    0,    0,  157,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  157,   95,    0,   95,   95,   95,   95,    0,
  157,  157,  157,    0,  157,    0,   95,  157,    0,  157,
   95,    0,  157,    0,   95,  157,    0,    0,    0,    0,
    0,   26,   95,    0,   95,    0,  157,    0,  157,    0,
    0,  157,  157,    0,    0,    0,    0,    0,    0,    0,
   95,   95,    0,    0,    0,    0,    0,   95,    0,    0,
   95,  128,    0,    0,    0,    0,   95,    0,   95,    0,
    0,   95,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   95,   27,    0,
   27,   27,   27,   27,    0,   95,   95,   95,    0,   95,
    0,   27,   95,    0,   95,   27,    0,   95,    0,   27,
   95,    0,    0,    0,    0,    0,  146,   27,    0,   27,
    0,   95,    0,   95,    0,    0,   95,   95,    0,    0,
    0,    0,    0,    0,    0,   27,   27,    0,    0,    0,
    0,    0,   27,    0,    0,   27,   26,    0,    0,    0,
    0,   27,    0,   27,    0,    0,   27,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   27,  128,    0,  128,  128,  128,  128,    0,
   27,   27,   27,    0,   27,    0,  128,   27,    0,   27,
  128,    0,   27,    0,  128,   27,    0,    0,    0,    0,
    0,  147,  128,    0,  128,    0,   27,    0,   27,    0,
    0,   27,   27,    0,    0,    0,    0,    0,    0,    0,
  128,  128,    0,    0,    0,    0,    0,  128,    0,    0,
  128,  146,    0,    0,    0,    0,  128,    0,  128,    0,
    0,  128,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  128,   26,    0,
   26,   26,   26,   26,    0,  128,  128,  128,    0,  128,
    0,   26,  128,    0,  128,   26,    0,  128,    0,   26,
  128,    0,    0,    0,    0,    0,   28,   26,    0,   26,
    0,  128,    0,  128,    0,    0,  128,  128,    0,    0,
    0,    0,    0,    0,    0,   26,   26,    0,    0,    0,
    0,    0,   26,    0,    0,   26,  147,    0,    0,    0,
    0,   26,    0,   26,    0,    0,   26,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   26,  146,    0,  146,  146,  146,  146,    0,
   26,   26,   26,    0,   26,    0,  146,   26,    0,   26,
  146,    0,   26,    0,  146,   26,    0,    0,    0,    0,
    0,  129,  146,    0,  146,    0,   26,    0,   26,    0,
    0,   26,   26,    0,    0,    0,    0,    0,    0,    0,
  146,  146,    0,    0,   40,    0,    0,  146,    0,    0,
  146,   28,    0,    0,    0,    0,  146,    0,  146,    0,
    0,  146,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  146,  147,    0,
  147,  147,  147,  147,    0,  146,  146,  146,    0,  146,
    0,  147,  146,    0,  146,  147,    0,  146,    0,  147,
  146,    0,    0,    0,    0,    0,  229,  147,    0,  147,
    0,  146,    0,  146,    0,    0,  146,  146,    0,    0,
    0,    0,    0,    0,    0,  147,  147,    0,    0,    0,
    0,    0,  147,    0,    0,  147,  129,    0,    0,    0,
    0,  147,    0,  147,    0,    0,  147,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   40,    0,   40,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  147,   28,    0,   28,   28,   28,   28,    0,
  147,  147,  147,    0,  147,    0,   28,  147,    0,  147,
   28,    0,  147,    0,   28,  147,    0,    0,    0,    0,
    0,    0,   28,    0,   28,  243,  147,    0,  147,    0,
    0,  147,  147,    0,    0,    0,    0,    0,    0,    0,
   28,   28,    0,    0,  208,    0,    0,   28,    0,    0,
   28,  229,    0,    0,    0,    0,   28,    0,   28,    0,
    0,   28,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  252,    0,    0,   28,  129,    0,
  129,  129,  129,  129,    0,   28,   28,   28,    0,   28,
    0,  129,   28,    0,   28,  129,    0,   28,    0,  129,
   28,   40,    0,   40,   40,    0,    0,  129,    0,  129,
   40,   28,    0,   28,    0,    0,   28,   28,   40,    0,
    0,    0,    0,    0,    0,  129,  129,    0,    0,    0,
    0,    0,  129,    0,    0,  129,  243,    0,    0,    0,
  243,  129,    0,  129,    0,    0,  129,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  208,
    0,    0,    0,    0,    0,    0,   40,    0,    0,    0,
    0,    0,  129,  229,  231,  229,  229,  229,  229,    0,
  129,  129,  129,    0,  129,    0,  229,  129,    0,  129,
  229,   40,  129,    0,  229,  129,    0,    0,    0,  252,
    0,    0,  229,  250,  229,    0,  129,    0,  129,    0,
   40,  129,  129,    0,   64,    0,    0,    0,    0,    0,
  229,  229,    0,    0,   40,   40,    0,  229,    0,    0,
  229,   40,    0,    0,   40,   40,  229,    0,  229,    0,
    0,  229,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  243,    0,    0,    0,  217,    0,  229,    0,    0,
    0,    0,  243,  233,  243,  229,  229,  229,    0,  229,
    0,    0,  229,    0,  229,    0,    0,  229,    0,  243,
  229,  208,    0,  208,    0,    0,    0,    0,    0,  231,
    0,  229,    0,  229,    0,    0,  229,  229,  208,  243,
  243,    0,    0,    0,  219,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  243,    0,  243,    0,  250,    0,
    0,  252,    0,  252,    0,    0,    0,  243,    0,   64,
    0,    0,    0,  208,    0,  208,  243,    0,  252,    0,
  243,    0,  243,    0,  243,    0,  208,    0,  243,  243,
  243,  243,    0,    0,    0,  208,    0,  231,    0,  208,
    0,  208,    0,  208,    0,    0,  221,  208,  208,  208,
  208,  243,    0,  252,  243,  252,    0,    0,    0,    0,
  217,    0,    0,  243,    0,  243,  252,    0,  233,    0,
  208,    0,  243,  208,    0,  243,  243,    0,  221,  252,
  243,  252,    0,  252,    0,    0,   57,  252,  252,  252,
    0,  208,    0,    0,  208,  208,    0,    0,    0,    0,
    0,  231,    0,  231,   82,    0,    0,    0,    0,  219,
  252,    0,    0,  252,    0,  243,    0,  243,  231,    0,
    0,    0,    0,   66,    0,    0,    0,    0,  243,    0,
  250,  252,  250,    0,  252,  252,   84,  243,    0,    0,
  243,   64,  159,   64,    0,    0,    0,  250,  243,  243,
    0,    0,  243,  231,    0,  231,  121,    0,   64,    0,
    0,    0,  231,    0,    0,    0,  231,    0,    0,    0,
    0,  221,  243,    0,    0,  243,    0,    0,    0,  231,
    0,  231,  250,  231,  250,    0,    0,    0,  231,  231,
    0,    0,  217,  243,  217,  250,  243,  243,    0,    0,
  233,    0,  233,  221,    0,    0,   64,  250,    0,  217,
  231,   57,    0,  231,    0,  250,  250,  233,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   82,
    0,  231,    0,    0,  231,  231,    0,    0,    0,  250,
    0,  219,  250,  219,  217,    0,  217,    0,   66,    0,
   64,    0,  233,    0,  233,    0,    0,  217,  219,    0,
  250,   84,    0,  250,  250,  233,    0,  159,    0,    0,
    0,   64,  217,    0,   64,   64,    0,    0,    0,  217,
  217,  121,    0,    0,    0,  233,  233,    0,    0,    0,
   23,   24,    0,  219,  231,  219,  231,    0,    0,    0,
    0,  217,    0,  221,  217,  221,  219,    0,    0,  233,
    0,  231,  233,    0,    0,    0,    0,    0,    0,    0,
  221,    0,  217,  100,    0,  217,  217,    0,  219,  219,
  233,    0,    0,  233,  233,  221,  120,  221,    0,    0,
    0,    0,    0,   57,    0,   57,  231,    0,  231,    0,
  219,    0,  221,  219,    0,  221,    0,  221,    0,  231,
   57,   82,    0,   82,    0,    0,  176,    0,  221,    0,
    0,  219,    0,    0,  219,  219,    0,    0,   82,  231,
   66,    0,   66,    0,    0,    0,    0,  221,    0,  221,
  221,  221,    0,   84,    0,   84,    0,   66,    0,  159,
  221,  159,    0,  231,    0,    0,  231,    0,   57,    0,
   84,    0,  221,  121,    0,  121,  159,    0,    0,    0,
    0,    0,    0,    0,  231,    0,   82,  231,  231,    0,
  121,    0,    0,  221,    0,    0,  221,  221,    0,    0,
    0,    0,    0,    0,  221,   66,    0,    0,    0,    0,
    0,    0,   57,    0,    0,    0,    0,    0,   84,    0,
    0,    0,    0,    0,  159,  221,    0,    0,  221,  221,
   82,    0,    0,   57,    0,    0,   57,   57,  121,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   66,
    0,   82,    0,    0,   82,   82,    0,    0,    0,    0,
    0,    0,   84,    0,    0,    0,    0,  277,  159,   25,
   66,    0,    0,   66,   66,    0,    0,    0,    0,    0,
    0,    0,  121,   84,    0,    0,   84,   84,    0,  159,
    0,    0,  159,  159,    0,    0,    0,   92,   93,    0,
    0,    0,    0,  121,   25,    0,  121,  121,    0,    0,
  305,  306,    0,  123,  123,    0,    0,  125,    0,    0,
  127,    0,  240,    0,    0,    0,    0,    0,  161,  123,
  123,    0,    0,    0,  123,  123,  323,  324,    0,    0,
    0,  123,  123,    0,    0,   25,    0,    0,    0,  179,
  180,    0,  181,    0,    0,    0,  185,    0,    0,    0,
    0,  123,  123,  352,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  123,
    0,  361,    0,    0,    0,    0,    0,    0,    0,  123,
  123,  370,    0,    0,    0,  373,    0,    0,  217,   25,
    0,    0,  374,    0,    0,    0,  221,  222,   25,    0,
    0,  224,    0,    0,  226,    0,  114,  384,  229,  230,
  384,    0,    0,  233,  235,  237,  392,    0,    0,  233,
    0,    0,    0,  397,    0,  397,  244,    0,  246,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  237,
    0,    0,    0,    0,    0,    0,    0,    0,  131,  132,
  133,  134,    0,    0,    0,    0,    0,    0,    0,  135,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   25,   25,  274,    0,  151,  136,    0,   79,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  237,    0,  237,
    0,  294,    0,  137,  138,  237,    0,    0,    0,    0,
  139,    0,    0,  140,    0,    0,    0,    0,  300,  141,
    0,  302,    0,    0,  142,    0,  294,    0,    0,    0,
    0,    0,    0,    0,   25,    0,   25,    0,  313,    0,
    0,  314,    0,  317,    0,    0,  113,  320,    0,  322,
   82,    0,  114,  114,  114,  114,  294,  294,  143,  144,
  145,    0,  146,  114,    0,    0,    0,  147,    0,    0,
  148,    0,    0,  149,    0,    0,   25,   25,    0,  114,
    0,  114,    0,  353,  150,    0,    0,    0,   18,   19,
    0,   20,    0,  357,    0,    0,    0,  114,  114,    0,
    0,    0,    0,    0,  114,    0,    0,  114,    0,    0,
    0,    0,    0,  114,  114,    0,  286,    0,  114,  114,
  131,  132,  133,  134,    0,  114,  114,    0,    0,   25,
    0,  135,    0,    0,    0,    0,   25,    0,    0,    0,
    0,    0,    0,    0,  114,  114,  114,  136,    0,   79,
    0,    0,  114,  114,  114,    0,  114,    0,    0,    0,
    0,  114,    0,  114,  114,  137,  138,  114,    0,    0,
    0,    0,  139,    0,    0,  140,    0,    0,  114,    0,
    0,  141,  113,  113,  113,  113,  142,    0,    0,    0,
    0,    0,  331,  113,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  113,
    0,  113,   82,    0,    0,    0,    0,    0,    0,    0,
  143,  144,  145,    0,  146,    0,    0,  113,  113,  147,
    0,    0,  148,    0,  113,  149,    0,  113,    0,    0,
    0,    0,    0,  113,    0,    0,  150,    0,  113,    0,
  131,  132,  133,  134,    0,    0,    0,    0,    0,    0,
    0,  135,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  113,    0,    0,  136,    0,   79,
    0,    0,  113,  113,  113,    0,  113,    0,    0,    0,
    0,  113,    0,    0,  113,  137,  138,  113,    0,    0,
    0,    0,  139,    0,    0,  140,    0,    0,  113,    0,
    0,  141,    0,    0,    0,    0,  142,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  131,  132,  133,  134,
    0,    0,    0,    0,    0,    0,    0,  135,    0,    0,
    0,    0,   82,    0,    0,    0,    0,    0,    0,    0,
  143,  144,  145,  136,  146,   79,    0,    0,    0,  147,
    0,    0,  148,    0,    0,  149,    0,    0,    0,    0,
    0,  137,  138,    0,    0,    0,  150,    0,  139,    0,
    0,  140,    0,    0,    0,    0,    0,  141,  131,  132,
  133,  134,  142,    0,    0,    0,    0,    0,    0,  135,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  136,    0,   79,   82,    0,
    0,    0,    0,    0,    0,    0,  143,  144,  145,    0,
  146,    0,    0,  137,  138,  147,    0,    0,  148,    0,
  139,  149,    0,  140,    0,    0,    0,    0,    0,  141,
    0,    0,  150,    0,  142,    0,  131,  132,  133,  134,
    0,    0,    0,    0,    0,    0,    0,  135,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   82,    0,    0,  136,    0,   79,    0,    0,  143,  144,
  145,    0,  146,    0,    0,    0,    0,  147,    0,    0,
  148,  137,  138,  149,    0,    0,    0,    0,  139,    0,
    0,  140,    0,    0,  150,    0,    0,  141,   18,   19,
    0,   20,  142,    0,    0,   31,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,   34,    0,    0,    0,    0,    0,   82,    0,
    0,   35,   36,    0,    0,    0,  143,  144,  145,    0,
  146,    0,    0,   37,    0,  147,   38,    0,  148,    0,
    0,  149,    0,    0,    0,   39,   40,   41,   42,   43,
    0,    0,  150,    0,   44,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   45,    0,    0,    0,
   46,    0,    0,    0,    0,    0,    0,    0,   47,    0,
    0,    0,    0,    0,    0,   48,   49,   50,   51,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   52,    0,    0,   53,    0,    0,    0,
    0,    0,    0,   54,
};
const short yycheck[] =
	{                                      43,
    0,   43,  123,   43,   35,   36,   60,   43,   62,  255,
   62,   72,  178,   44,  280,  123,   47,  338,   49,   50,
   51,  275,  266,  123,   53,   56,  342,   60,    0,   62,
   83,  160,  267,  268,  269,   64,  302,   43,  241,  286,
  285,   41,  349,  264,  279,  290,  362,   28,  293,  401,
  123,  272,   60,  331,   62,  184,    0,  273,  410,  266,
  267,  268,  328,  329,  311,  380,  381,  388,  346,  366,
  391,  368,  393,  380,  259,  260,  257,  258,   59,  245,
  301,  297,  263,  264,  389,  390,  252,  392,  341,  386,
  271,   61,  147,  338,  275,  257,  258,  313,  364,    0,
  155,  263,  264,  347,  165,  234,  404,  288,   61,  271,
  408,  327,  164,  275,  412,   43,    4,  289,  384,  172,
  386,  174,  175,  123,  285,  125,  288,  308,  331,  290,
  123,  377,  293,  298,  299,  389,  390,  123,  392,  294,
  295,  170,  323,  378,  283,  388,  308,  178,  391,  125,
  393,   39,  350,  125,  307,  210,  211,  212,  259,  260,
  123,  323,  298,  299,  365,  123,  380,  278,  312,  123,
  351,  351,  351,  311,  388,  312,  228,  391,  296,  393,
  312,  125,  377,  354,  125,  362,  367,   40,  125,  351,
  380,  372,   80,  349,  375,  343,  274,  274,  379,    0,
  334,   44,  335,  349,  339,  367,  337,  125,  389,  390,
  372,  392,  342,  375,  245,  125,   41,  379,  249,  369,
  309,  252,  345,  365,  125,  344,   44,  389,  390,   41,
  392,  240,   71,  287,  362,   30,  362,  277,  365,  363,
  130,  395,  125,  295,  418,  405,  134,  125,  415,  113,
  362,  336,   67,  125,  225,  143,  283,  257,  125,  259,
  260,  261,  262,  383,  125,   57,  266,  372,  389,  390,
  270,  392,  380,  381,  274,  271,  330,  310,  278,  116,
    0,  306,   67,  283,  315,  257,  286,  259,  288,  389,
  390,  334,  392,  290,  294,  295,  296,   -1,  298,  299,
   -1,  332,  274,   -1,  304,  305,   -1,  307,   -1,  309,
   -1,  311,   -1,  257,  314,  259,  389,  390,   -1,  392,
  320,  321,  322,   -1,  125,  325,  326,  215,  216,   -1,
  274,  331,  332,  333,  334,  335,  380,  337,    0,  339,
  382,  377,  342,  343,  344,  345,  346,  347,   -1,  349,
  322,  351,  352,  353,  354,   -1,  257,   -1,  259,  359,
  360,  361,   -1,  363,   -1,  309,  366,  311,  368,  369,
  370,  371,   -1,  274,  374,   -1,  382,  377,  322,   -1,
  380,  381,   -1,  389,  390,  385,  392,  387,  289,  389,
  390,  391,  392,  337,  366,  339,  389,  390,   -1,  392,
  344,  345,   -1,  389,  390,  125,  392,   -1,  309,   -1,
  311,  312,   -1,  389,  390,  387,  392,   -1,  390,  391,
   -1,  322,  366,  311,  312,  369,  389,  390,   -1,  392,
   -1,  389,  390,  334,  392,  389,  390,   -1,  392,   -1,
   -1,  342,  343,  387,   -1,   -1,  390,  391,  389,  390,
   -1,  392,  389,  390,   -1,  392,  257,    0,  259,  260,
  261,  262,   -1,  125,   -1,  366,   -1,    0,  369,  270,
   -1,  389,  390,  274,  392,   -1,  364,  278,   -1,  389,
  390,  123,  392,  371,   -1,  286,  387,  288,  389,  390,
  391,  392,  123,  294,  295,  296,   -1,  298,  299,   -1,
    0,   -1,   -1,  304,  305,   -1,  389,  390,  309,  392,
  311,  389,  390,  314,  392,   -1,    0,  389,  390,  320,
  392,  322,  389,  390,  325,  392,   -1,   -1,  389,  390,
  331,  392,   -1,  334,  335,   -1,  337,  257,  339,  259,
   -1,  342,  343,  344,  345,  346,   -1,   -1,  349,   -1,
  351,   -1,   -1,   -1,  274,   -1,   -1,   -1,  359,  360,
  361,   -1,  363,   -1,   -1,  366,   -1,  368,  369,   -1,
  371,   -1,   -1,  374,   -1,    0,  377,   -1,   -1,  380,
   -1,   -1,  125,   -1,  385,   -1,  387,   -1,   -1,  390,
  391,  311,  125,   -1,   -1,  257,   -1,  259,  260,  261,
  262,   -1,  322,   -1,   -1,   -1,   -1,   -1,  270,   -1,
   -1,   -1,  274,   -1,  334,   -1,  278,  259,  260,   -1,
   -1,   -1,   -1,   -1,  286,  125,  288,   -1,  259,  260,
   -1,   -1,  294,  295,   -1,   -1,  298,  299,   -1,   -1,
   -1,  125,  304,  305,   -1,   -1,  366,  309,   -1,  311,
   -1,   -1,  314,   -1,   -1,   -1,    0,   -1,  320,   -1,
  322,   -1,   -1,  325,   -1,   -1,   -1,  387,   -1,  331,
  390,  391,  334,  335,   -1,  337,   -1,  339,   -1,   -1,
  342,  343,  344,  345,  346,   -1,   -1,   -1,   -1,  351,
   -1,   -1,   -1,   -1,    0,   -1,   -1,  359,  360,  361,
  125,  363,   -1,   -1,  366,   -1,  368,  369,   -1,  371,
   -1,   -1,  374,   -1,  257,   -1,  259,  260,  261,  262,
   -1,   -1,   -1,  385,  257,  387,  259,  270,  390,  391,
   -1,  274,   -1,   -1,  123,  278,   -1,    0,  380,  381,
   -1,  274,   -1,  286,   -1,  288,   -1,   -1,   -1,  380,
  381,  294,  295,    0,   -1,   -1,   -1,  257,   -1,  259,
   -1,  304,  305,   -1,   -1,   -1,  309,   -1,  311,   -1,
   -1,  314,   -1,  257,  274,  259,   -1,  320,  311,  322,
   -1,  125,  325,  388,  389,  390,  391,  392,  393,  322,
  274,   -1,  335,   -1,  337,   -1,  339,   -1,  331,   -1,
  343,  344,  345,   -1,   -1,   -1,   -1,   -1,  351,  309,
   -1,  311,    0,  346,   -1,   -1,  359,  360,  361,  125,
  363,   -1,  322,  366,   -1,  368,  369,  311,  371,   -1,
   -1,  374,  257,  366,  259,  260,  261,  262,  322,  125,
   -1,   -1,  385,   -1,  387,  270,   -1,  390,  391,  274,
   -1,   -1,   -1,  278,  387,   -1,   -1,  390,  391,   -1,
  344,  286,  125,  288,   -1,   -1,  366,   -1,   -1,  369,
  259,  260,    0,   -1,   -1,   -1,   -1,  266,  125,  304,
  305,   -1,  366,   -1,  309,   -1,  311,  387,   -1,  314,
  390,  391,   -1,   -1,   -1,  320,   -1,  322,   -1,   -1,
  325,   -1,   -1,  387,   -1,   -1,  390,  391,   -1,   -1,
  335,   -1,  337,  257,  339,  259,   -1,   -1,  343,  344,
  345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,
  274,    0,   -1,   -1,  359,  360,  361,  125,  363,   -1,
   -1,  366,   -1,  368,  369,   -1,  371,   -1,   -1,  374,
   -1,  257,   -1,  259,  260,  261,  262,   -1,  347,   -1,
  385,   -1,  387,   -1,  270,  390,  391,  311,  274,   -1,
   -1,  257,  278,  259,    0,   -1,   -1,   -1,  322,   -1,
  286,   -1,  288,   -1,   -1,   -1,   -1,   -1,  274,   -1,
   -1,  380,  381,    0,  257,   -1,  259,  125,  304,  305,
  344,  345,   -1,  309,   -1,  311,   -1,   -1,  314,   -1,
  257,  274,  259,   -1,  320,   -1,  322,   -1,   -1,  325,
   -1,   -1,  366,  123,   -1,   -1,   -1,  274,   -1,  335,
   -1,  337,   -1,  339,   -1,   -1,  322,  343,  344,  345,
   -1,   -1,   -1,  387,   -1,  351,  390,  391,  311,    0,
   -1,   -1,   -1,  359,  360,  361,  125,  363,   -1,  322,
  366,   -1,  368,  369,  311,  371,   -1,   -1,  374,  257,
   -1,  259,  260,  261,  262,  322,   -1,   -1,   -1,  385,
  366,  387,  270,  380,  390,  391,  274,   -1,   -1,  123,
  278,  388,  389,  390,  391,  392,  393,   -1,  286,  125,
  288,  387,   -1,  366,  390,  391,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  304,  305,  125,  366,
   -1,  309,   -1,  311,  387,   -1,  314,  390,  391,  257,
    0,  259,  320,   -1,  322,   -1,   -1,  325,   -1,   -1,
  387,   -1,   -1,  390,  391,   -1,  274,  335,   -1,  337,
   -1,  339,   -1,   -1,   -1,   -1,  344,  345,   -1,  259,
  260,   -1,   -1,  351,   -1,   -1,  266,   -1,    0,   -1,
   -1,  359,  360,  361,  125,  363,   -1,   -1,  366,   -1,
  368,  369,   -1,  371,   -1,   -1,  374,   -1,  257,   -1,
  259,  260,  261,  262,  322,   -1,   -1,  385,   -1,  387,
   -1,  270,  390,  391,   -1,  274,   -1,  123,   -1,  278,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  286,   -1,  288,
   -1,   -1,   -1,   -1,   -1,  259,  260,    0,   -1,   -1,
   -1,  257,  266,  259,   -1,  304,  305,   -1,  366,   -1,
  309,   -1,  311,   -1,   -1,  314,   -1,  347,  274,   -1,
  257,  320,  259,  322,   -1,  125,  325,   -1,   -1,  387,
   -1,   -1,  390,  391,   -1,   -1,   -1,  274,  337,   -1,
  339,   -1,   -1,   -1,   -1,  344,  345,   -1,   -1,   -1,
  380,  381,  351,  309,   -1,  311,    0,  294,  295,   -1,
  359,  360,  361,  125,  363,   -1,  322,  366,   -1,  368,
  369,   -1,  371,   -1,  311,  374,  257,   -1,  259,  260,
  261,  262,   -1,  347,   -1,  322,  385,   -1,  387,  270,
   -1,  390,  391,  274,  331,   -1,  123,  278,    0,   -1,
   -1,   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,  346,
  366,   -1,   -1,  259,  260,   -1,  380,  381,   -1,   -1,
  266,   -1,  125,  304,  305,  123,   -1,   -1,  309,  366,
  311,  387,   -1,  314,  390,  391,   -1,   -1,   -1,  320,
   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,
  387,    0,   -1,  390,  391,   -1,  337,  257,   -1,  259,
   -1,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
  351,   -1,   -1,   -1,  274,   -1,   -1,   -1,  359,  360,
  361,  125,  363,   -1,   -1,  366,   -1,  368,  369,   -1,
  371,   -1,   -1,  374,   -1,  257,   -1,  259,  260,  261,
  262,  347,   -1,   -1,  385,   -1,  387,   -1,  270,  390,
  391,  311,  274,   -1,   -1,   -1,  278,   -1,   -1,   -1,
   -1,  123,  322,  125,  286,   -1,  288,   -1,   -1,   -1,
   -1,   -1,  259,  260,  380,  381,   -1,   -1,   -1,  266,
   -1,   -1,  304,  305,   -1,   -1,    0,  309,   -1,  311,
   -1,   -1,  314,   -1,  257,   -1,  259,   -1,  320,   -1,
  322,  259,  260,  325,   -1,   -1,  366,   -1,  266,   -1,
   -1,  274,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,
   -1,   -1,  344,  345,   -1,   -1,   -1,  387,   -1,  351,
  390,  391,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
   -1,  363,   -1,   -1,  366,   -1,  368,  369,  311,  371,
   -1,   -1,  374,  257,   -1,  259,  260,  261,  262,  322,
  347,   -1,   -1,  385,   -1,  387,  270,   -1,  390,  391,
  274,   -1,   -1,   -1,  278,   -1,   -1,   -1,   -1,   -1,
   -1,    0,  286,   -1,  288,   -1,   -1,   -1,   -1,  347,
   -1,   -1,   -1,  380,  381,  257,   -1,  259,  260,   -1,
  304,  305,   -1,  366,  266,  309,   -1,  311,   -1,   -1,
  314,  125,  274,   -1,   -1,   -1,  320,   -1,  322,   -1,
   -1,  325,  380,  381,  387,   -1,   -1,  390,  391,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,  351,  257,   -1,
  259,  260,  261,  262,   -1,  359,  360,  361,   -1,  363,
  322,  270,  366,   -1,  368,  274,   -1,  371,   -1,  278,
  374,   -1,  304,  305,   -1,   -1,    0,  286,   -1,  288,
   -1,  385,   -1,  387,   -1,  347,  390,  391,  320,  321,
   -1,   -1,   -1,  325,  326,  304,  305,   -1,   -1,   -1,
  332,  333,  311,   -1,  366,  314,  125,   -1,   -1,   -1,
   -1,  320,   -1,  322,   -1,   -1,  325,   -1,  380,  381,
  352,  353,   -1,   -1,   -1,  387,   -1,   -1,  390,  391,
   -1,   -1,   -1,   -1,   -1,  344,  345,   -1,  370,   -1,
   -1,   -1,  351,  257,   -1,  259,  260,  261,  262,   -1,
  359,  360,  361,   -1,  363,   -1,  270,  366,   -1,  368,
  274,   -1,  371,   -1,  278,  374,   -1,  304,  305,   -1,
   -1,    0,  286,   -1,  288,   -1,  385,   -1,  387,   -1,
   -1,  390,  391,  320,  321,   -1,   -1,   -1,  325,  326,
  304,  305,   -1,   -1,   -1,  332,  333,  311,   -1,   -1,
  314,  125,   -1,   -1,   -1,   -1,  320,   -1,  322,   -1,
   -1,  325,   -1,   -1,   -1,  352,  353,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  370,   -1,   -1,   -1,  351,  257,   -1,
  259,  260,  261,  262,   -1,  359,  360,  361,   -1,  363,
   -1,  270,  366,   -1,  368,  274,   -1,  371,   -1,  278,
  374,   -1,   -1,  377,   -1,   -1,    0,  286,   -1,  288,
   -1,  385,   -1,  387,   -1,   -1,  390,  391,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,  125,   -1,   -1,   -1,
   -1,  320,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  351,  257,   -1,  259,  260,  261,  262,   -1,
  359,  360,  361,   -1,  363,   -1,  270,  366,   -1,  368,
  274,   -1,  371,   -1,  278,  374,   -1,   -1,  377,   -1,
   -1,    0,  286,   -1,  288,   -1,  385,   -1,  387,   -1,
   -1,  390,  391,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,   -1,   -1,   -1,  311,   -1,   -1,
  314,  125,   -1,   -1,   -1,   -1,  320,   -1,  322,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  344,   -1,   -1,   -1,   -1,   -1,   -1,  351,  257,   -1,
  259,  260,  261,  262,   -1,  359,  360,  361,   -1,  363,
   -1,  270,  366,   -1,  368,  274,   -1,  371,   -1,  278,
  374,   -1,   -1,   -1,   -1,   -1,    0,  286,   -1,  288,
   -1,  385,   -1,  387,   -1,   -1,  390,  391,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,  125,   -1,   -1,   -1,
   -1,  320,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  351,  257,   -1,  259,  260,  261,  262,   -1,
  359,  360,  361,   -1,  363,   -1,  270,  366,   -1,  368,
  274,   -1,  371,   -1,  278,  374,   -1,   -1,   -1,   -1,
   -1,    0,  286,   -1,  288,   -1,  385,   -1,  387,   -1,
   -1,  390,  391,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,   -1,   -1,   -1,  311,   -1,   -1,
  314,  125,   -1,   -1,   -1,   -1,  320,   -1,  322,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  351,  257,   -1,
  259,  260,  261,  262,   -1,  359,  360,  361,   -1,  363,
   -1,  270,  366,   -1,  368,  274,   -1,  371,   -1,  278,
  374,   -1,   -1,   -1,   -1,   -1,    0,  286,   -1,  288,
   -1,  385,   -1,  387,   -1,   -1,  390,  391,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,  125,   -1,   -1,   -1,
   -1,  320,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  351,  257,   -1,  259,  260,  261,  262,   -1,
  359,  360,  361,   -1,  363,   -1,  270,  366,   -1,  368,
  274,   -1,  371,   -1,  278,  374,   -1,   -1,   -1,   -1,
   -1,    0,  286,   -1,  288,   -1,  385,   -1,  387,   -1,
   -1,  390,  391,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,   -1,   -1,   -1,  311,   -1,   -1,
  314,  125,   -1,   -1,   -1,   -1,  320,   -1,  322,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  351,  257,   -1,
  259,  260,  261,  262,   -1,  359,  360,  361,   -1,  363,
   -1,  270,  366,   -1,  368,  274,   -1,  371,   -1,  278,
  374,   -1,   -1,   -1,   -1,   -1,    0,  286,   -1,  288,
   -1,  385,   -1,  387,   -1,   -1,  390,  391,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,  125,   -1,   -1,   -1,
   -1,  320,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  351,  257,   -1,  259,  260,  261,  262,   -1,
  359,  360,  361,   -1,  363,   -1,  270,  366,   -1,  368,
  274,   -1,  371,   -1,  278,  374,   -1,   -1,   -1,   -1,
   -1,    0,  286,   -1,  288,   -1,  385,   -1,  387,   -1,
   -1,  390,  391,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,   -1,   -1,   -1,  311,   -1,   -1,
  314,  125,   -1,   -1,   -1,   -1,  320,   -1,  322,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  351,  257,   -1,
  259,  260,  261,  262,   -1,  359,  360,  361,   -1,  363,
   -1,  270,  366,   -1,  368,  274,   -1,  371,   -1,  278,
  374,   -1,   -1,   -1,   -1,   -1,    0,  286,   -1,  288,
   -1,  385,   -1,  387,   -1,   -1,  390,  391,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,  125,   -1,   -1,   -1,
   -1,  320,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  351,  257,   -1,  259,  260,  261,  262,   -1,
  359,  360,  361,   -1,  363,   -1,  270,  366,   -1,  368,
  274,   -1,  371,   -1,  278,  374,   -1,   -1,   -1,   -1,
   -1,    0,  286,   -1,  288,   -1,  385,   -1,  387,   -1,
   -1,  390,  391,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,   -1,   -1,   -1,  311,   -1,   -1,
  314,  125,   -1,   -1,   -1,   -1,  320,   -1,  322,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  351,  257,   -1,
  259,  260,  261,  262,   -1,  359,  360,  361,   -1,  363,
   -1,  270,  366,   -1,  368,  274,   -1,  371,   -1,  278,
  374,   -1,   -1,   -1,   -1,   -1,    0,  286,   -1,  288,
   -1,  385,   -1,  387,   -1,   -1,  390,  391,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,  125,   -1,   -1,   -1,
   -1,  320,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  351,  257,   -1,  259,  260,  261,  262,   -1,
  359,  360,  361,   -1,  363,   -1,  270,  366,   -1,  368,
  274,   -1,  371,   -1,  278,  374,   -1,   -1,   -1,   -1,
   -1,    0,  286,   -1,  288,   -1,  385,   -1,  387,   -1,
   -1,  390,  391,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,   -1,   -1,   -1,  311,   -1,   -1,
  314,  125,   -1,   -1,   -1,   -1,  320,   -1,  322,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  351,  257,   -1,
  259,  260,  261,  262,   -1,  359,  360,  361,   -1,  363,
   -1,  270,  366,   -1,  368,  274,   -1,  371,   -1,  278,
  374,   -1,   -1,   -1,   -1,   -1,    0,  286,   -1,  288,
   -1,  385,   -1,  387,   -1,   -1,  390,  391,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,  125,   -1,   -1,   -1,
   -1,  320,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  351,  257,   -1,  259,  260,  261,  262,   -1,
  359,  360,  361,   -1,  363,   -1,  270,  366,   -1,  368,
  274,   -1,  371,   -1,  278,  374,   -1,   -1,   -1,   -1,
   -1,    0,  286,   -1,  288,   -1,  385,   -1,  387,   -1,
   -1,  390,  391,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,    0,   -1,   -1,  311,   -1,   -1,
  314,  125,   -1,   -1,   -1,   -1,  320,   -1,  322,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  351,  257,   -1,
  259,  260,  261,  262,   -1,  359,  360,  361,   -1,  363,
   -1,  270,  366,   -1,  368,  274,   -1,  371,   -1,  278,
  374,   -1,   -1,   -1,   -1,   -1,    0,  286,   -1,  288,
   -1,  385,   -1,  387,   -1,   -1,  390,  391,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,  125,   -1,   -1,   -1,
   -1,  320,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  123,   -1,  125,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  351,  257,   -1,  259,  260,  261,  262,   -1,
  359,  360,  361,   -1,  363,   -1,  270,  366,   -1,  368,
  274,   -1,  371,   -1,  278,  374,   -1,   -1,   -1,   -1,
   -1,   -1,  286,   -1,  288,    0,  385,   -1,  387,   -1,
   -1,  390,  391,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,    0,   -1,   -1,  311,   -1,   -1,
  314,  125,   -1,   -1,   -1,   -1,  320,   -1,  322,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,    0,   -1,   -1,  351,  257,   -1,
  259,  260,  261,  262,   -1,  359,  360,  361,   -1,  363,
   -1,  270,  366,   -1,  368,  274,   -1,  371,   -1,  278,
  374,  257,   -1,  259,  260,   -1,   -1,  286,   -1,  288,
  266,  385,   -1,  387,   -1,   -1,  390,  391,  274,   -1,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,    0,   -1,   -1,   -1,
  125,  320,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,
   -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,   -1,   -1,
   -1,   -1,  351,  257,    0,  259,  260,  261,  262,   -1,
  359,  360,  361,   -1,  363,   -1,  270,  366,   -1,  368,
  274,  347,  371,   -1,  278,  374,   -1,   -1,   -1,  125,
   -1,   -1,  286,    0,  288,   -1,  385,   -1,  387,   -1,
  366,  390,  391,   -1,    0,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,  380,  381,   -1,  311,   -1,   -1,
  314,  387,   -1,   -1,  390,  391,  320,   -1,  322,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  125,   -1,   -1,   -1,    0,   -1,  351,   -1,   -1,
   -1,   -1,  257,    0,  259,  359,  360,  361,   -1,  363,
   -1,   -1,  366,   -1,  368,   -1,   -1,  371,   -1,  274,
  374,  257,   -1,  259,   -1,   -1,   -1,   -1,   -1,  125,
   -1,  385,   -1,  387,   -1,   -1,  390,  391,  274,  294,
  295,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  309,   -1,  311,   -1,  125,   -1,
   -1,  257,   -1,  259,   -1,   -1,   -1,  322,   -1,  125,
   -1,   -1,   -1,  309,   -1,  311,  331,   -1,  274,   -1,
  335,   -1,  337,   -1,  339,   -1,  322,   -1,  343,  344,
  345,  346,   -1,   -1,   -1,  331,   -1,    0,   -1,  335,
   -1,  337,   -1,  339,   -1,   -1,    0,  343,  344,  345,
  346,  366,   -1,  309,  369,  311,   -1,   -1,   -1,   -1,
  125,   -1,   -1,  257,   -1,  259,  322,   -1,  125,   -1,
  366,   -1,  387,  369,   -1,  390,  391,   -1,    0,  335,
  274,  337,   -1,  339,   -1,   -1,    0,  343,  344,  345,
   -1,  387,   -1,   -1,  390,  391,   -1,   -1,   -1,   -1,
   -1,  257,   -1,  259,    0,   -1,   -1,   -1,   -1,  125,
  366,   -1,   -1,  369,   -1,  309,   -1,  311,  274,   -1,
   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,  322,   -1,
  257,  387,  259,   -1,  390,  391,    0,  331,   -1,   -1,
  334,  257,    0,  259,   -1,   -1,   -1,  274,  342,  343,
   -1,   -1,  346,  309,   -1,  311,    0,   -1,  274,   -1,
   -1,   -1,  125,   -1,   -1,   -1,  322,   -1,   -1,   -1,
   -1,  125,  366,   -1,   -1,  369,   -1,   -1,   -1,  335,
   -1,  337,  309,  339,  311,   -1,   -1,   -1,  344,  345,
   -1,   -1,  257,  387,  259,  322,  390,  391,   -1,   -1,
  257,   -1,  259,  125,   -1,   -1,  322,  334,   -1,  274,
  366,  125,   -1,  369,   -1,  342,  343,  274,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,
   -1,  387,   -1,   -1,  390,  391,   -1,   -1,   -1,  366,
   -1,  257,  369,  259,  309,   -1,  311,   -1,  125,   -1,
  366,   -1,  309,   -1,  311,   -1,   -1,  322,  274,   -1,
  387,  125,   -1,  390,  391,  322,   -1,  125,   -1,   -1,
   -1,  387,  337,   -1,  390,  391,   -1,   -1,   -1,  344,
  345,  125,   -1,   -1,   -1,  342,  343,   -1,   -1,   -1,
    2,    3,   -1,  309,  257,  311,  259,   -1,   -1,   -1,
   -1,  366,   -1,  257,  369,  259,  322,   -1,   -1,  366,
   -1,  274,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  274,   -1,  387,   35,   -1,  390,  391,   -1,  344,  345,
  387,   -1,   -1,  390,  391,  257,   48,  259,   -1,   -1,
   -1,   -1,   -1,  257,   -1,  259,  309,   -1,  311,   -1,
  366,   -1,  274,  369,   -1,  309,   -1,  311,   -1,  322,
  274,  257,   -1,  259,   -1,   -1,   78,   -1,  322,   -1,
   -1,  387,   -1,   -1,  390,  391,   -1,   -1,  274,  342,
  257,   -1,  259,   -1,   -1,   -1,   -1,  309,   -1,  311,
  344,  345,   -1,  257,   -1,  259,   -1,  274,   -1,  257,
  322,  259,   -1,  366,   -1,   -1,  369,   -1,  322,   -1,
  274,   -1,  366,  257,   -1,  259,  274,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  387,   -1,  322,  390,  391,   -1,
  274,   -1,   -1,  387,   -1,   -1,  390,  391,   -1,   -1,
   -1,   -1,   -1,   -1,  366,  322,   -1,   -1,   -1,   -1,
   -1,   -1,  366,   -1,   -1,   -1,   -1,   -1,  322,   -1,
   -1,   -1,   -1,   -1,  322,  387,   -1,   -1,  390,  391,
  366,   -1,   -1,  387,   -1,   -1,  390,  391,  322,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,
   -1,  387,   -1,   -1,  390,  391,   -1,   -1,   -1,   -1,
   -1,   -1,  366,   -1,   -1,   -1,   -1,  219,  366,    4,
  387,   -1,   -1,  390,  391,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  366,  387,   -1,   -1,  390,  391,   -1,  387,
   -1,   -1,  390,  391,   -1,   -1,   -1,   32,   33,   -1,
   -1,   -1,   -1,  387,   39,   -1,  390,  391,   -1,   -1,
  262,  263,   -1,  304,  305,   -1,   -1,   52,   -1,   -1,
   55,   -1,  123,   -1,   -1,   -1,   -1,   -1,   63,  320,
  321,   -1,   -1,   -1,  325,  326,  288,  289,   -1,   -1,
   -1,  332,  333,   -1,   -1,   80,   -1,   -1,   -1,   84,
   85,   -1,   87,   -1,   -1,   -1,   91,   -1,   -1,   -1,
   -1,  352,  353,  315,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,
   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  380,
  381,  343,   -1,   -1,   -1,  347,   -1,   -1,  133,  134,
   -1,   -1,  354,   -1,   -1,   -1,  141,  142,  143,   -1,
   -1,  146,   -1,   -1,  149,   -1,  123,  369,  153,  154,
  372,   -1,   -1,  158,  159,  160,  378,   -1,   -1,  164,
   -1,   -1,   -1,  385,   -1,  387,  171,   -1,  173,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  184,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  259,  260,
  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  270,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  215,  216,  217,   -1,  123,  286,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  232,   -1,  234,
   -1,  236,   -1,  304,  305,  240,   -1,   -1,   -1,   -1,
  311,   -1,   -1,  314,   -1,   -1,   -1,   -1,  253,  320,
   -1,  256,   -1,   -1,  325,   -1,  261,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  269,   -1,  271,   -1,  273,   -1,
   -1,  276,   -1,  278,   -1,   -1,  123,  282,   -1,  284,
  351,   -1,  259,  260,  261,  262,  291,  292,  359,  360,
  361,   -1,  363,  270,   -1,   -1,   -1,  368,   -1,   -1,
  371,   -1,   -1,  374,   -1,   -1,  311,  312,   -1,  286,
   -1,  288,   -1,  318,  385,   -1,   -1,   -1,  389,  390,
   -1,  392,   -1,  328,   -1,   -1,   -1,  304,  305,   -1,
   -1,   -1,   -1,   -1,  311,   -1,   -1,  314,   -1,   -1,
   -1,   -1,   -1,  320,  321,   -1,  125,   -1,  325,  326,
  259,  260,  261,  262,   -1,  332,  333,   -1,   -1,  364,
   -1,  270,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  351,  352,  353,  286,   -1,  288,
   -1,   -1,  359,  360,  361,   -1,  363,   -1,   -1,   -1,
   -1,  368,   -1,  370,  371,  304,  305,  374,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,   -1,   -1,  385,   -1,
   -1,  320,  259,  260,  261,  262,  325,   -1,   -1,   -1,
   -1,   -1,  125,  270,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  286,
   -1,  288,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,   -1,  363,   -1,   -1,  304,  305,  368,
   -1,   -1,  371,   -1,  311,  374,   -1,  314,   -1,   -1,
   -1,   -1,   -1,  320,   -1,   -1,  385,   -1,  325,   -1,
  259,  260,  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  270,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  351,   -1,   -1,  286,   -1,  288,
   -1,   -1,  359,  360,  361,   -1,  363,   -1,   -1,   -1,
   -1,  368,   -1,   -1,  371,  304,  305,  374,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  314,   -1,   -1,  385,   -1,
   -1,  320,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  259,  260,  261,  262,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  270,   -1,   -1,
   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  286,  363,  288,   -1,   -1,   -1,  368,
   -1,   -1,  371,   -1,   -1,  374,   -1,   -1,   -1,   -1,
   -1,  304,  305,   -1,   -1,   -1,  385,   -1,  311,   -1,
   -1,  314,   -1,   -1,   -1,   -1,   -1,  320,  259,  260,
  261,  262,  325,   -1,   -1,   -1,   -1,   -1,   -1,  270,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  286,   -1,  288,  351,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,   -1,
  363,   -1,   -1,  304,  305,  368,   -1,   -1,  371,   -1,
  311,  374,   -1,  314,   -1,   -1,   -1,   -1,   -1,  320,
   -1,   -1,  385,   -1,  325,   -1,  259,  260,  261,  262,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  270,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  351,   -1,   -1,  286,   -1,  288,   -1,   -1,  359,  360,
  361,   -1,  363,   -1,   -1,   -1,   -1,  368,   -1,   -1,
  371,  304,  305,  374,   -1,   -1,   -1,   -1,  311,   -1,
   -1,  314,   -1,   -1,  385,   -1,   -1,  320,  389,  390,
   -1,  392,  325,   -1,   -1,  265,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  276,   -1,   -1,   -1,
   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,  351,   -1,
   -1,  291,  292,   -1,   -1,   -1,  359,  360,  361,   -1,
  363,   -1,   -1,  303,   -1,  368,  306,   -1,  371,   -1,
   -1,  374,   -1,   -1,   -1,  315,  316,  317,  318,  319,
   -1,   -1,  385,   -1,  324,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,
   -1,   -1,   -1,   -1,   -1,  355,  356,  357,  358,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  373,   -1,   -1,  376,   -1,   -1,   -1,
   -1,   -1,   -1,  383,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 393
#if YYDEBUG
const char * const yyname[] =
	{
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'",0,"'+'","','",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'<'","'='",
"'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,"TOKACCOUNT","TOKACCOUNTS","TOKACTION","TOKACTIONS","TOKADDHEADER",
"TOKADDTOCACHE","TOKAGE","TOKALL","TOKALLOWMANY","TOKAND","TOKANYNAME",
"TOKANYSIZE","TOKANYTYPE","TOKAPPEND","TOKATTACHMENT","TOKBODY","TOKBYTES",
"TOKCACHE","TOKCASE","TOKCMDUSER","TOKCOMPRESS","TOKCONTINUE","TOKCOUNT",
"TOKDAYS","TOKDEFUSER","TOKDELTOOBIG","TOKDISABLED","TOKDOMAIN","TOKDOTLOCK",
"TOKDROP","TOKEQ","TOKEXEC","TOKEXPIRE","TOKFCNTL","TOKFILEGROUP",
"TOKFILEUMASK","TOKFLOCK","TOKFOLDER","TOKFOLDERS","TOKFROM","TOKGIGABYTES",
"TOKGROUP","TOKGROUPS","TOKHEADER","TOKHEADERS","TOKHOURS","TOKIGNOREERRORS",
"TOKIMAP","TOKIMAPS","TOKIMPLACT","TOKIN","TOKINCACHE","TOKINSECURE",
"TOKINVALID","TOKKEEP","TOKKEY","TOKKILOBYTES","TOKLMTP","TOKLOCKFILE",
"TOKLOCKTIMEOUT","TOKLOCKTYPES","TOKLOCKWAIT","TOKLOOKUPORDER","TOKMAILDIR",
"TOKMAILDIRS","TOKMATCH","TOKMATCHED","TOKMAXSIZE","TOKMBOX","TOKMBOXES",
"TOKMEGABYTES","TOKMINUTES","TOKMONTHS","TOKNE","TOKNEWONLY","TOKNNTP",
"TOKNNTPS","TOKNOAPOP","TOKNOCRAMMD5","TOKNOCREATE","TOKNOLOGIN","TOKNONE",
"TOKNOPLAIN","TOKNORECEIVED","TOKNOT","TOKNOUIDL","TOKNOVERIFY","TOKXOAUTH2",
"TOKOAUTHBEARER","TOKOLDONLY","TOKOR","TOKPARALLELACCOUNTS","TOKPASS",
"TOKPASSWD","TOKPIPE","TOKPOP3","TOKPOP3S","TOKPORT","TOKPROXY","TOKPURGEAFTER",
"TOKQUEUEHIGH","TOKQUEUELOW","TOKREMOVEFROMCACHE","TOKREMOVEHEADER",
"TOKREMOVEHEADERS","TOKRETURNS","TOKREWRITE","TOKSECONDS","TOKSERVER","TOKSET",
"TOKSIZE","TOKSMTP","TOKSTARTTLS","TOKSTDIN","TOKSTDOUT","TOKSTRING",
"TOKSTRIPCHARACTERS","TOKTAG","TOKTAGGED","TOKTIMEOUT","TOKTO","TOKTOTALSIZE",
"TOKUNMATCHED","TOKUSER","TOKUSERS","TOKVALUE","TOKVERIFYCERTS","TOKWEEKS",
"TOKWRITE","TOKYEARS","NONE","NUMBER","STRING","STRMACRO","NUMMACRO",
"STRCOMMAND","NUMCOMMAND",
};
const char * const yyrule[] =
	{"$accept : cmds",
"cmds :",
"cmds : cmds account",
"cmds : cmds defaction",
"cmds : cmds defmacro",
"cmds : cmds rule",
"cmds : cmds set",
"cmds : cmds close",
"cmds : cmds cache",
"cmds : cmds NONE",
"actionp : TOKACTION",
"actionp : TOKACTIONS",
"userp : TOKUSER",
"userp : TOKUSERS",
"accountp : TOKACCOUNT",
"accountp : TOKACCOUNTS",
"groupp : TOKGROUP",
"groupp : TOKGROUPS",
"folderp : TOKFOLDER",
"folderp : TOKFOLDERS",
"maildirp : TOKMAILDIR",
"maildirp : TOKMAILDIRS",
"mboxp : TOKMBOX",
"mboxp : TOKMBOXES",
"rmheaderp : TOKREMOVEHEADER",
"rmheaderp : TOKREMOVEHEADERS",
"val : TOKVALUE strv",
"val : strv",
"optval : TOKVALUE strv",
"optval :",
"xstrv : STRCOMMAND",
"xstrv : STRING",
"xstrv : STRMACRO",
"strv : xstrv",
"strv : strv '+' xstrv",
"numv : NUMCOMMAND",
"numv : NUMBER",
"numv : NUMMACRO",
"replstrv : strv",
"replpathv : strv",
"size : numv",
"size : numv TOKBYTES",
"size : numv TOKKILOBYTES",
"size : numv TOKMEGABYTES",
"size : numv TOKGIGABYTES",
"time : numv",
"time : numv TOKHOURS",
"time : numv TOKMINUTES",
"time : numv TOKSECONDS",
"time : numv TOKDAYS",
"time : numv TOKWEEKS",
"time : numv TOKMONTHS",
"time : numv TOKYEARS",
"expire : TOKEXPIRE time",
"expire :",
"cache : TOKCACHE replpathv expire",
"set : TOKSET TOKMAXSIZE size",
"set : TOKSET TOKLOCKTYPES locklist",
"set : TOKSET TOKLOCKFILE replpathv",
"set : TOKSET TOKLOCKWAIT",
"set : TOKSET TOKLOCKTIMEOUT time",
"set : TOKSET TOKDELTOOBIG",
"set : TOKSET TOKIGNOREERRORS",
"set : TOKSET TOKALLOWMANY",
"set : TOKSET TOKDEFUSER strv",
"set : TOKSET TOKCMDUSER strv",
"set : TOKSET TOKSTRIPCHARACTERS strv",
"set : TOKSET TOKTIMEOUT time",
"set : TOKSET TOKQUEUEHIGH numv",
"set : TOKSET TOKQUEUELOW numv",
"set : TOKSET TOKPARALLELACCOUNTS numv",
"set : TOKSET TOKPROXY replstrv",
"set : TOKSET TOKVERIFYCERTS",
"set : TOKSET TOKIMPLACT TOKKEEP",
"set : TOKSET TOKIMPLACT TOKDROP",
"set : TOKSET TOKPURGEAFTER numv",
"set : TOKSET TOKPURGEAFTER TOKNONE",
"set : TOKSET TOKNORECEIVED",
"set : TOKSET TOKNOCREATE",
"set : TOKSET TOKFILEGROUP TOKUSER",
"set : TOKSET TOKFILEGROUP localgid",
"set : TOKSET TOKFILEUMASK TOKUSER",
"set : TOKSET TOKLOOKUPORDER ufnlist",
"set : TOKSET TOKFILEUMASK numv",
"defmacro : STRMACRO '=' strv",
"defmacro : NUMMACRO '=' numv",
"replstrslist : replstrslist strv",
"replstrslist : strv",
"stringslist : stringslist replstrv",
"stringslist : replstrv",
"pathslist : pathslist replpathv",
"pathslist : replpathv",
"ufn : TOKPASSWD",
"ufnlist : ufnlist ufn",
"ufnlist : ufn",
"rmheaders : rmheaderp strv",
"rmheaders : rmheaderp '{' replstrslist '}'",
"maildirs : maildirp replpathv",
"maildirs : maildirp '{' pathslist '}'",
"mboxes : mboxp replpathv",
"mboxes : mboxp '{' pathslist '}'",
"folders : folderp replstrv",
"folders : folderp '{' stringslist '}'",
"lock : TOKFCNTL",
"lock : TOKFLOCK",
"lock : TOKDOTLOCK",
"locklist : locklist lock",
"locklist : lock",
"locklist : TOKNONE",
"localgid : replstrv",
"localgid : numv",
"user :",
"user : TOKUSER strv",
"users :",
"users : userp strv",
"users : userp '{' replstrslist '}'",
"casere : TOKCASE replstrv",
"casere : replstrv",
"not : TOKNOT",
"not :",
"keep : TOKKEEP",
"keep :",
"disabled : TOKDISABLED",
"disabled :",
"port : TOKPORT replstrv",
"port : TOKPORT numv",
"server : TOKSERVER replstrv port",
"server : TOKSERVER replstrv",
"to :",
"to : TOKTO strv",
"from :",
"from : TOKFROM strv",
"compress : TOKCOMPRESS",
"compress :",
"actitem : execpipe strv",
"actitem : TOKREWRITE strv",
"actitem : writeappend strv",
"actitem : TOKMAILDIR strv",
"actitem : rmheaders",
"actitem : TOKADDHEADER strv val",
"actitem : TOKMBOX strv compress",
"actitem : imaptype server userpassnetrc folder1 verify nocrammd5 noplain nologin starttls insecure oauthbearer xoauth2",
"actitem : TOKSMTP server from to",
"actitem : TOKLMTP server from to",
"actitem : TOKSTDOUT",
"actitem : TOKTAG strv optval",
"actitem : TOKADDTOCACHE replpathv TOKKEY strv",
"actitem : TOKREMOVEFROMCACHE replpathv TOKKEY strv",
"actitem : actions",
"actitem : TOKDROP",
"actitem : TOKKEEP",
"actlist : actlist actitem",
"actlist : actitem",
"defaction : TOKACTION replstrv users actitem",
"defaction : TOKACTION replstrv users '{' actlist '}'",
"accounts : accountp strv",
"accounts : accountp '{' replstrslist '}'",
"actions : actionp strv",
"actions : actionp '{' replstrslist '}'",
"cont :",
"cont : TOKCONTINUE",
"area :",
"area : TOKIN TOKALL",
"area : TOKIN TOKHEADERS",
"area : TOKIN TOKBODY",
"retrc : numv",
"retrc :",
"retre : casere",
"retre :",
"ltgt : '<'",
"ltgt : '>'",
"eqne : TOKEQ",
"eqne : TOKNE",
"cmp : ltgt",
"cmp : eqne",
"execpipe : TOKEXEC",
"execpipe : TOKPIPE",
"writeappend : TOKWRITE",
"writeappend : TOKAPPEND",
"exprop : TOKAND",
"exprop : TOKOR",
"expritem : not TOKALL",
"expritem : not casere area",
"expritem : not accounts",
"expritem : not execpipe strv user TOKRETURNS '(' retrc ',' retre ')'",
"expritem : not TOKTAGGED strv",
"expritem : not TOKSIZE ltgt size",
"expritem : not TOKSTRING strv TOKTO casere",
"expritem : not TOKINCACHE replpathv TOKKEY strv",
"expritem : not TOKMATCHED",
"expritem : not TOKUNMATCHED",
"expritem : not TOKAGE ltgt time",
"expritem : not TOKAGE TOKINVALID",
"expritem : not TOKATTACHMENT TOKCOUNT cmp numv",
"expritem : not TOKATTACHMENT TOKTOTALSIZE ltgt size",
"expritem : not TOKATTACHMENT TOKANYSIZE ltgt size",
"expritem : not TOKATTACHMENT TOKANYTYPE strv",
"expritem : not TOKATTACHMENT TOKANYNAME strv",
"exprlist : exprlist exprop expritem",
"exprlist : exprop expritem",
"expr : expritem",
"expr : expritem exprlist",
"perform : users actionp actitem cont",
"perform : users actionp '{' actlist '}' cont",
"perform : users actions cont",
"perform : '{'",
"close : '}'",
"rule : TOKMATCH expr perform",
"folderlist :",
"folderlist : folders",
"folder1 :",
"folder1 : folderp strv",
"groups : groupp replstrv",
"groups : groupp '{' stringslist '}'",
"nocrammd5 : TOKNOCRAMMD5",
"nocrammd5 :",
"noplain : TOKNOPLAIN",
"noplain :",
"nologin : TOKNOLOGIN",
"nologin :",
"starttls : TOKSTARTTLS",
"starttls :",
"uidl : TOKNOUIDL",
"uidl :",
"insecure : TOKINSECURE",
"insecure :",
"oauthbearer : TOKOAUTHBEARER",
"oauthbearer :",
"xoauth2 : TOKXOAUTH2",
"xoauth2 :",
"verify : TOKNOVERIFY",
"verify :",
"apop : TOKNOAPOP",
"apop :",
"only : TOKNEWONLY",
"only : TOKOLDONLY",
"poptype : TOKPOP3",
"poptype : TOKPOP3S",
"imaptype : TOKIMAP",
"imaptype : TOKIMAPS",
"nntptype : TOKNNTP",
"nntptype : TOKNNTPS",
"userpassnetrc : TOKUSER replstrv TOKPASS replstrv",
"userpassnetrc :",
"userpassnetrc : TOKUSER replstrv",
"userpassnetrc : TOKPASS replstrv",
"userpassreqd : TOKUSER replstrv TOKPASS replstrv",
"userpass : userpassreqd",
"userpass :",
"poponly : only TOKCACHE replpathv",
"poponly :",
"imaponly : only",
"imaponly :",
"fetchtype : poptype server userpassnetrc poponly apop verify uidl starttls insecure",
"fetchtype : TOKPOP3 TOKPIPE replstrv userpassreqd poponly apop",
"fetchtype : imaptype server userpassnetrc folderlist imaponly verify nocrammd5 noplain nologin starttls insecure oauthbearer xoauth2",
"fetchtype : TOKIMAP TOKPIPE replstrv userpass folderlist imaponly",
"fetchtype : TOKSTDIN",
"fetchtype : maildirs",
"fetchtype : mboxes",
"fetchtype : nntptype server userpassnetrc groups TOKCACHE replpathv verify insecure",
"account : TOKACCOUNT replstrv disabled users fetchtype keep",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
/* LINTUSED */
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
unsigned int yystacksize;
int yyparse(void);
#line 2495 "parse.y"

/* Programs */
#line 1848 "parse.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(void)
{
    unsigned int newsize;
    long sslen;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    sslen = yyssp - yyss;
#ifdef SIZE_MAX
#define YY_SIZE_MAX SIZE_MAX
#else
#define YY_SIZE_MAX 0xffffffffU
#endif
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newss)
        goto bail;
    newss = (short *)realloc(yyss, newsize * sizeof *newss);
    if (newss == NULL)
        goto bail;
    yyss = newss;
    yyssp = newss + sslen;
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newvs)
        goto bail;
    newvs = (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs);
    if (newvs == NULL)
        goto bail;
    yyvs = newvs;
    yyvsp = newvs + sslen;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
bail:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return -1;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse(void)
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif /* YYDEBUG */

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yyvsp[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 26:
#line 364 "parse.y"
{
	     yyval.string = yyvsp[0].string;
     }
break;
case 27:
#line 368 "parse.y"
{
	     yyval.string = yyvsp[0].string;
     }
break;
case 28:
#line 373 "parse.y"
{
		yyval.string = yyvsp[0].string;
	}
break;
case 29:
#line 377 "parse.y"
{
		yyval.string = NULL;
	}
break;
case 30:
#line 382 "parse.y"
{
	       yyval.string = run_command(yyvsp[0].string, parse_file->path);
	       xfree(yyvsp[0].string);
       }
break;
case 31:
#line 387 "parse.y"
{
	       yyval.string = yyvsp[0].string;
       }
break;
case 32:
#line 391 "parse.y"
{
	       struct macro	*macro;

	       if (strlen(yyvsp[0].string) > MAXNAMESIZE)
		       yyerror("macro name too long: %s", yyvsp[0].string);

	       if ((macro = find_macro(yyvsp[0].string)) == NULL)
		       yyerror("undefined macro: %s", yyvsp[0].string);
	       if (macro->type != MACRO_STRING)
		       yyerror("string macro expected: %s", yyvsp[0].string);

	       yyval.string = xstrdup(macro->value.str);

	       xfree(yyvsp[0].string);
       }
break;
case 33:
#line 408 "parse.y"
{
	      yyval.string = yyvsp[0].string;
      }
break;
case 34:
#line 412 "parse.y"
{
	      size_t	size;

	      size = strlen(yyvsp[-2].string) + strlen(yyvsp[0].string) + 1;
	      yyval.string = xrealloc(yyvsp[-2].string, 1, size);
	      strlcat(yyval.string, yyvsp[0].string, size);
	      xfree(yyvsp[0].string);
      }
break;
case 35:
#line 422 "parse.y"
{
	      const char	*errstr;
	      char		*s;

	      s = run_command(yyvsp[0].string, parse_file->path);

	      yyval.number = strtonum(s, 0, LLONG_MAX, &errstr);
	      if (errstr != NULL)
		      yyerror("number is %s", errstr);

	      xfree(s);

	      xfree(yyvsp[0].string);
      }
break;
case 36:
#line 437 "parse.y"
{
	      yyval.number = yyvsp[0].number;
      }
break;
case 37:
#line 441 "parse.y"
{
	      struct macro	*macro;

	      if (strlen(yyvsp[0].string) > MAXNAMESIZE)
		      yyerror("macro name too long: %s", yyvsp[0].string);

	      if ((macro = find_macro(yyvsp[0].string)) == NULL)
		      yyerror("undefined macro: %s", yyvsp[0].string);
	      if (macro->type != MACRO_NUMBER)
		      yyerror("number macro expected: %s", yyvsp[0].string);

	      yyval.number = macro->value.num;

	      xfree(yyvsp[0].string);
      }
break;
case 38:
#line 458 "parse.y"
{
		  struct replstr	 rs;
		  struct userdata	*ud;

		  if ((ud = user_lookup(conf.def_user, conf.user_order)) != NULL)
			  update_tags(&parse_tags, ud);
		  rs.str = yyvsp[0].string;
		  yyval.string = replacestr(&rs, parse_tags, NULL, NULL);
		  xfree(yyvsp[0].string);
	  }
break;
case 39:
#line 470 "parse.y"
{
		  struct replpath	 rp;
		  struct userdata	*ud;

		  if ((ud = user_lookup(conf.def_user, conf.user_order)) != NULL)
			  update_tags(&parse_tags, ud);
		  rp.str = yyvsp[0].string;
		  yyval.string = replacepath(&rp, parse_tags, NULL, NULL, conf.user_home);
		  xfree(yyvsp[0].string);
	   }
break;
case 40:
#line 482 "parse.y"
{
	      yyval.number = yyvsp[0].number;
      }
break;
case 41:
#line 486 "parse.y"
{
	      yyval.number = yyvsp[-1].number;
      }
break;
case 42:
#line 490 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / 1024)
		      yyerror("size is too big");
	      yyval.number = yyvsp[-1].number * 1024;
      }
break;
case 43:
#line 496 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / (1024 * 1024))
		      yyerror("size is too big");
	      yyval.number = yyvsp[-1].number * (1024 * 1024);
      }
break;
case 44:
#line 502 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / (1024 * 1024 * 1024))
		      yyerror("size is too big");
	      yyval.number = yyvsp[-1].number * (1024 * 1024 * 1024);
      }
break;
case 45:
#line 509 "parse.y"
{
	      yyval.number = yyvsp[0].number;
      }
break;
case 46:
#line 513 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_HOUR)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_HOUR;
      }
break;
case 47:
#line 519 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_MINUTE)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_MINUTE;
      }
break;
case 48:
#line 525 "parse.y"
{
	      yyval.number = yyvsp[-1].number;
      }
break;
case 49:
#line 529 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_DAY)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_DAY;
      }
break;
case 50:
#line 535 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_WEEK)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_WEEK;
      }
break;
case 51:
#line 541 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_MONTH)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_MONTH;
      }
break;
case 52:
#line 547 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_YEAR)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_YEAR;
      }
break;
case 53:
#line 554 "parse.y"
{
#if UINT64_MAX < LLONG_MAX
		if (yyvsp[0].number > UINT64_MAX)
			yyerror("time too long");
#endif

		yyval.number = yyvsp[0].number;
	}
break;
case 54:
#line 563 "parse.y"
{
		yyval.number = -1;
	}
break;
case 55:
#line 568 "parse.y"
{
	       struct cache	*cache;

	       TAILQ_FOREACH(cache, &conf.caches, entry) {
		       if (strcmp(cache->path, yyvsp[-1].string) == 0)
			       yyerror("duplicate cache path");
	       }

	       cache = xcalloc(1, sizeof *cache);
	       cache->path = yyvsp[-1].string;
	       cache->expire = yyvsp[0].number;

	       TAILQ_INSERT_TAIL(&conf.caches, cache, entry);

	       log_debug2("added cache \"%s\": expire %lld", cache->path, yyvsp[0].number);
       }
break;
case 56:
#line 586 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("zero maximum size");
	     if (yyvsp[0].number > MAXMAILSIZE)
		     yyerror("maximum size too large: %lld", yyvsp[0].number);
	     conf.max_size = yyvsp[0].number;
     }
break;
case 57:
#line 594 "parse.y"
{
	     if (yyvsp[0].locks & LOCK_FCNTL && yyvsp[0].locks & LOCK_FLOCK)
		     yyerror("fcntl and flock locking cannot be used together");
	     conf.lock_types = yyvsp[0].locks;
     }
break;
case 58:
#line 600 "parse.y"
{
	     if (conf.lock_file != NULL)
		     xfree(conf.lock_file);
	     conf.lock_file = yyvsp[0].string;
     }
break;
case 59:
#line 606 "parse.y"
{
	     conf.lock_wait = 1;
     }
break;
case 60:
#line 610 "parse.y"
{
	     conf.lock_timeout = yyvsp[0].number;
     }
break;
case 61:
#line 614 "parse.y"
{
	     conf.del_big = 1;
     }
break;
case 62:
#line 618 "parse.y"
{
	     conf.ignore_errors = 1;
     }
break;
case 63:
#line 622 "parse.y"
{
	     conf.allow_many = 1;
     }
break;
case 64:
#line 626 "parse.y"
{
	     if (conf.def_user == NULL)
		     conf.def_user = yyvsp[0].string;
     }
break;
case 65:
#line 631 "parse.y"
{
	     if (conf.cmd_user == NULL)
		     conf.cmd_user = yyvsp[0].string;
     }
break;
case 66:
#line 636 "parse.y"
{
	     xfree(conf.strip_chars);
	     conf.strip_chars = yyvsp[0].string;
     }
break;
case 67:
#line 641 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("zero timeout");
	     if (yyvsp[0].number > INT_MAX / 1000)
		     yyerror("timeout too long: %lld", yyvsp[0].number);
	     conf.timeout = yyvsp[0].number * 1000;
     }
break;
case 68:
#line 649 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("zero queue-high");
	     if (yyvsp[0].number > MAXQUEUEVALUE)
		     yyerror("queue-high too big: %lld", yyvsp[0].number);
	     if (conf.queue_low != -1 && yyvsp[0].number <= conf.queue_low)
		     yyerror("queue-high must be larger than queue-low");
	     conf.queue_high = yyvsp[0].number;
     }
break;
case 69:
#line 659 "parse.y"
{
	     if (yyvsp[0].number > MAXQUEUEVALUE)
		     yyerror("queue-low too big: %lld", yyvsp[0].number);
	     if (conf.queue_high == -1)
		     yyerror("queue-high not specified");
	     if (yyvsp[0].number >= conf.queue_high)
		     yyerror("queue-low must be smaller than queue-high");
	     conf.queue_low = yyvsp[0].number;
     }
break;
case 70:
#line 669 "parse.y"
{
	     if (yyvsp[0].number > INT_MAX)
		     yyerror("parallel-accounts too big: %lld", yyvsp[0].number);
	     if (yyvsp[0].number == 0)
		     yyerror("parallel-accounts cannot be zero");
	     conf.max_accts = yyvsp[0].number;
     }
break;
case 71:
#line 677 "parse.y"
{
	     if (conf.proxy != NULL) {
		     xfree(conf.proxy->server.host);
		     xfree(conf.proxy->server.port);
		     if (conf.proxy->user != NULL)
			     xfree(conf.proxy->user);
		     if (conf.proxy->pass != NULL)
			     xfree(conf.proxy->pass);
	     }
	     if ((conf.proxy = getproxy(yyvsp[0].string)) == NULL)
		     yyerror("invalid proxy");
	     xfree(yyvsp[0].string);
     }
break;
case 72:
#line 691 "parse.y"
{
	     conf.verify_certs = 1;
     }
break;
case 73:
#line 695 "parse.y"
{
	     conf.impl_act = DECISION_KEEP;
     }
break;
case 74:
#line 699 "parse.y"
{
	     conf.impl_act = DECISION_DROP;
     }
break;
case 75:
#line 703 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("invalid purge-after value: 0");
	     if (yyvsp[0].number > UINT_MAX)
		     yyerror("purge-after value too large: %lld", yyvsp[0].number);

	     conf.purge_after = yyvsp[0].number;
     }
break;
case 76:
#line 712 "parse.y"
{
	     conf.purge_after = 0;
     }
break;
case 77:
#line 716 "parse.y"
{
	     conf.no_received = 1;
     }
break;
case 78:
#line 720 "parse.y"
{
	     conf.no_create = 1;
     }
break;
case 79:
#line 724 "parse.y"
{
	     conf.file_group = -1;
     }
break;
case 80:
#line 728 "parse.y"
{
	     conf.file_group = yyvsp[0].localgid;
     }
break;
case 81:
#line 732 "parse.y"
{
	     conf.file_umask = umask(0);
	     umask(conf.file_umask);
     }
break;
case 82:
#line 737 "parse.y"
{
	     ARRAY_FREEALL(conf.user_order);
	     conf.user_order = yyvsp[0].ufns;
     }
break;
case 83:
#line 742 "parse.y"
{
	     char	s[8];
	     u_int	n;

	     /*
	      * We can't differentiate umasks in octal from normal numbers
	      * (requiring a leading zero a la C would be nice, but it would
	      * potentially break existing configs), so we need to fiddle to
	      * convert.
	      */
	     memset(s, 0, sizeof s);
	     xsnprintf(s, sizeof s, "%03lld", yyvsp[0].number);
	     if (s[3] != '\0' || s[0] < '0' || s[0] > '7' ||
		 s[1] < 0 || s[1] > '7' || s[2] < '0' || s[2] > '7')
		     yyerror("invalid umask: %s", s);
	     if (sscanf(s, "%o", &n) != 1)
		     yyerror("invalid umask: %s", s);
	     conf.file_umask = n;
     }
break;
case 84:
#line 763 "parse.y"
{
		  struct macro	*macro;

		  if (strlen(yyvsp[-2].string) > MAXNAMESIZE)
			  yyerror("macro name too long: %s", yyvsp[-2].string);

		  macro = xmalloc(sizeof *macro);
		  strlcpy(macro->name, yyvsp[-2].string, sizeof macro->name);
		  macro->type = MACRO_STRING;
		  macro->value.str = yyvsp[0].string;

		  if (parse_last == NULL)
			  TAILQ_INSERT_HEAD(&parse_macros, macro, entry);
		  else {
			  TAILQ_INSERT_AFTER(
			      &parse_macros, parse_last, macro, entry);
		  }

		  log_debug3("added macro \"%s\": \"%s\"", macro->name,
		      macro->value.str);
		  xfree(yyvsp[-2].string);
	  }
break;
case 85:
#line 786 "parse.y"
{
		  struct macro	*macro;

		  if (strlen(yyvsp[-2].string) > MAXNAMESIZE)
			  yyerror("macro name too long: %s", yyvsp[-2].string);

		  macro = xmalloc(sizeof *macro);
		  strlcpy(macro->name, yyvsp[-2].string, sizeof macro->name);
		  macro->type = MACRO_NUMBER;
		  macro->value.num = yyvsp[0].number;

		  if (parse_last == NULL)
			  TAILQ_INSERT_HEAD(&parse_macros, macro, entry);
		  else {
			  TAILQ_INSERT_AFTER(
			      &parse_macros, parse_last, macro, entry);
		  }

		  log_debug3("added macro \"%s\": %lld", macro->name,
		      macro->value.num);
		  xfree(yyvsp[-2].string);
	  }
break;
case 86:
#line 810 "parse.y"
{
		      if (*yyvsp[0].string == '\0')
			      yyerror("empty string in list");

		      yyval.replstrs = yyvsp[-1].replstrs;
		      ARRAY_EXPAND(yyval.replstrs, 1);
		      ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	      }
break;
case 87:
#line 819 "parse.y"
{
		      if (*yyvsp[0].string == '\0')
			     yyerror("empty string in list");

		      yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		      ARRAY_INIT(yyval.replstrs);
		      ARRAY_EXPAND(yyval.replstrs, 1);
		      ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	      }
break;
case 88:
#line 830 "parse.y"
{
		     if (*yyvsp[0].string == '\0')
			     yyerror("empty string in list");

		     yyval.strings = yyvsp[-1].strings;
		     ARRAY_ADD(yyval.strings, yyvsp[0].string);
	     }
break;
case 89:
#line 838 "parse.y"
{
		     if (*yyvsp[0].string == '\0')
			     yyerror("empty string in list");

		     yyval.strings = xmalloc(sizeof *yyval.strings);
		     ARRAY_INIT(yyval.strings);
		     ARRAY_ADD(yyval.strings, yyvsp[0].string);
	     }
break;
case 90:
#line 848 "parse.y"
{
		   if (*yyvsp[0].string == '\0')
			   yyerror("invalid path");

		   yyval.strings = yyvsp[-1].strings;
		   ARRAY_ADD(yyval.strings, yyvsp[0].string);
	   }
break;
case 91:
#line 856 "parse.y"
{
		   if (*yyvsp[0].string == '\0')
			   yyerror("invalid path");

		   yyval.strings = xmalloc(sizeof *yyval.strings);
		   ARRAY_INIT(yyval.strings);
		   ARRAY_ADD(yyval.strings, yyvsp[0].string);
	   }
break;
case 92:
#line 866 "parse.y"
{
	     yyval.ufn = &passwd_lookup;
     }
break;
case 93:
#line 871 "parse.y"
{
		 yyval.ufns = yyvsp[-1].ufns;
		 ARRAY_ADD(yyval.ufns, yyvsp[0].ufn);
	 }
break;
case 94:
#line 876 "parse.y"
{
		 yyval.ufns = xmalloc(sizeof *yyval.ufns);
		 ARRAY_INIT(yyval.ufns);
		 ARRAY_ADD(yyval.ufns, yyvsp[0].ufn);
	 }
break;
case 95:
#line 883 "parse.y"
{
		   if (*yyvsp[0].string == '\0')
			   yyerror("invalid header");

		   yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		   ARRAY_INIT(yyval.replstrs);
		   ARRAY_EXPAND(yyval.replstrs, 1);
		   ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	   }
break;
case 96:
#line 893 "parse.y"
{
		   yyval.replstrs = yyvsp[-1].replstrs;
	   }
break;
case 97:
#line 898 "parse.y"
{
		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid path");

		  yyval.strings = xmalloc(sizeof *yyval.strings);
		  ARRAY_INIT(yyval.strings);
		  ARRAY_ADD(yyval.strings, yyvsp[0].string);
	  }
break;
case 98:
#line 907 "parse.y"
{
		  yyval.strings = yyvsp[-1].strings;
	  }
break;
case 99:
#line 912 "parse.y"
{
		if (*yyvsp[0].string == '\0')
			yyerror("invalid path");

		yyval.strings = xmalloc(sizeof *yyval.strings);
		ARRAY_INIT(yyval.strings);
		ARRAY_ADD(yyval.strings, yyvsp[0].string);
	}
break;
case 100:
#line 921 "parse.y"
{
		yyval.strings = yyvsp[-1].strings;
	}
break;
case 101:
#line 926 "parse.y"
{
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid folder");

		 yyval.strings = xmalloc(sizeof *yyval.strings);
		 ARRAY_INIT(yyval.strings);
		 ARRAY_ADD(yyval.strings, yyvsp[0].string);
	 }
break;
case 102:
#line 935 "parse.y"
{
		 yyval.strings = yyvsp[-1].strings;
	 }
break;
case 103:
#line 940 "parse.y"
{
	      yyval.locks = LOCK_FCNTL;
      }
break;
case 104:
#line 944 "parse.y"
{
	      yyval.locks = LOCK_FLOCK;
      }
break;
case 105:
#line 948 "parse.y"
{
	      yyval.locks = LOCK_DOTLOCK;
      }
break;
case 106:
#line 953 "parse.y"
{
		  yyval.locks = yyvsp[-1].locks | yyvsp[0].locks;
	  }
break;
case 107:
#line 957 "parse.y"
{
		  yyval.locks = yyvsp[0].locks;
	  }
break;
case 108:
#line 961 "parse.y"
{
		  yyval.locks = 0;
	  }
break;
case 109:
#line 966 "parse.y"
{
		  struct group	*gr;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid group");

		  gr = getgrnam(yyvsp[0].string);
		  if (gr == NULL)
			  yyerror("unknown group: %s", yyvsp[0].string);
		  yyval.localgid = gr->gr_gid;
		  endgrent();

		  xfree(yyvsp[0].string);
	  }
break;
case 110:
#line 981 "parse.y"
{
		  struct group	*gr;

		  if (yyvsp[0].number > GID_MAX)
			  yyerror("invalid gid: %llu", yyvsp[0].number);
		  gr = getgrgid(yyvsp[0].number);
		  if (gr == NULL)
			  yyerror("unknown gid: %llu", yyvsp[0].number);
		  yyval.localgid = gr->gr_gid;
		  endgrent();
	  }
break;
case 111:
#line 994 "parse.y"
{
	      yyval.string = NULL;
      }
break;
case 112:
#line 998 "parse.y"
{
	      yyval.string = yyvsp[0].string;
      }
break;
case 113:
#line 1003 "parse.y"
{
	       yyval.replstrs = NULL;
       }
break;
case 114:
#line 1007 "parse.y"
{
	       yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
	       ARRAY_INIT(yyval.replstrs);
	       ARRAY_EXPAND(yyval.replstrs, 1);
	       ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
       }
break;
case 115:
#line 1014 "parse.y"
{
	       yyval.replstrs = yyvsp[-1].replstrs;
       }
break;
case 116:
#line 1019 "parse.y"
{
		/* match case */
		yyval.re.flags = 0;
		yyval.re.str = yyvsp[0].string;
	}
break;
case 117:
#line 1025 "parse.y"
{
		/* ignore case */
		yyval.re.flags = RE_IGNCASE;
		yyval.re.str = yyvsp[0].string;
	}
break;
case 118:
#line 1032 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 119:
#line 1036 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 120:
#line 1041 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 121:
#line 1045 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 122:
#line 1050 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 123:
#line 1054 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 124:
#line 1059 "parse.y"
{
	      if (*yyvsp[0].string == '\0')
		      yyerror("invalid port");

	      yyval.string = yyvsp[0].string;
      }
break;
case 125:
#line 1066 "parse.y"
{
	      if (yyvsp[0].number == 0 || yyvsp[0].number > 65535)
		      yyerror("invalid port");

	      xasprintf(&yyval.string, "%lld", yyvsp[0].number);
      }
break;
case 126:
#line 1074 "parse.y"
{
		if (*yyvsp[-1].string == '\0')
			yyerror("invalid host");

		yyval.server.host = yyvsp[-1].string;
		yyval.server.port = yyvsp[0].string;
	}
break;
case 127:
#line 1082 "parse.y"
{
		if (*yyvsp[0].string == '\0')
			yyerror("invalid host");

		yyval.server.host = yyvsp[0].string;
		yyval.server.port = NULL;
	}
break;
case 128:
#line 1091 "parse.y"
{
	    yyval.string = NULL;
    }
break;
case 129:
#line 1095 "parse.y"
{
	    yyval.string = yyvsp[0].string;
    }
break;
case 130:
#line 1100 "parse.y"
{
	      yyval.string = NULL;
      }
break;
case 131:
#line 1104 "parse.y"
{
	      yyval.string = yyvsp[0].string;
      }
break;
case 132:
#line 1109 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 133:
#line 1113 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 134:
#line 1118 "parse.y"
{
		 struct deliver_pipe_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid command");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_pipe;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->pipe = yyvsp[-1].flag;
		 data->cmd.str = yyvsp[0].string;
	 }
break;
case 135:
#line 1134 "parse.y"
{
		 struct deliver_rewrite_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid command");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_rewrite;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->cmd.str = yyvsp[0].string;
	 }
break;
case 136:
#line 1149 "parse.y"
{
		 struct deliver_write_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid path");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_write;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->append = yyvsp[-1].flag;
		 data->path.str = yyvsp[0].string;
	 }
break;
case 137:
#line 1165 "parse.y"
{
		 struct deliver_maildir_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid path");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_maildir;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->path.str = yyvsp[0].string;
	 }
break;
case 138:
#line 1180 "parse.y"
{
		 struct deliver_remove_header_data *data;

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_remove_header;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->hdrs = yyvsp[0].replstrs;
	 }
break;
case 139:
#line 1192 "parse.y"
{
		 struct deliver_add_header_data	*data;

		 if (*yyvsp[-1].string == '\0')
			 yyerror("invalid header");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_add_header;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->hdr.str = yyvsp[-1].string;
		 data->value.str = yyvsp[0].string;
	 }
break;
case 140:
#line 1208 "parse.y"
{
		 struct deliver_mbox_data	*data;

		 if (*yyvsp[-1].string == '\0')
			 yyerror("invalid path");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_mbox;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->path.str = yyvsp[-1].string;
		 data->compress = yyvsp[0].flag;
	 }
break;
case 141:
#line 1225 "parse.y"
{
		 struct deliver_imap_data	*data;

		 if (yyvsp[-11].flag && yyvsp[-3].flag)
			 yyerror("use either imaps or set starttls");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_imap;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 if (yyvsp[-9].userpass.user && yyvsp[-9].userpass.pass == NULL) {
			 data->user = yyvsp[-9].userpass.user;
			 find_netrc(yyvsp[-10].server.host, &data->user, &data->pass);
		 } else if (yyvsp[-9].userpass.user_netrc && yyvsp[-9].userpass.pass_netrc)
			 find_netrc(yyvsp[-10].server.host, &data->user, &data->pass);
		 else {
			 if (yyvsp[-9].userpass.user_netrc)
				 find_netrc(yyvsp[-10].server.host, &data->user, NULL);
			 else
				 data->user = yyvsp[-9].userpass.user;
			 if (yyvsp[-9].userpass.pass_netrc)
				 find_netrc(yyvsp[-10].server.host, NULL, &data->pass);
			 else
				 data->pass = yyvsp[-9].userpass.pass;
		 }

		 data->folder.str = yyvsp[-8].string;
		 data->server.ssl = yyvsp[-11].flag;
		 data->server.verify = yyvsp[-7].flag;
		 data->server.host = yyvsp[-10].server.host;
		 if (yyvsp[-10].server.port != NULL)
			 data->server.port = yyvsp[-10].server.port;
		 else if (yyvsp[-11].flag)
			 data->server.port = xstrdup("imaps");
		 else
			 data->server.port = xstrdup("imap");
		 data->server.ai = NULL;
		 data->nocrammd5 = yyvsp[-6].flag;
		 data->noplain = yyvsp[-5].flag;
		 data->nologin = yyvsp[-4].flag;
		 data->starttls = yyvsp[-3].flag;
		 data->server.insecure = yyvsp[-2].flag;
		 data->oauthbearer = yyvsp[-2].flag;
		 data->xoauth2 = yyvsp[-1].flag;
	 }
break;
case 142:
#line 1273 "parse.y"
{
		 struct deliver_smtp_data	*data;

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_smtp;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->server.host = yyvsp[-2].server.host;
		 if (yyvsp[-2].server.port != NULL)
			 data->server.port = yyvsp[-2].server.port;
		 else
			 data->server.port = xstrdup("smtp");
		 data->server.ai = NULL;
		 data->from.str = yyvsp[-1].string;
		 data->to.str = yyvsp[0].string;
	 }
break;
case 143:
#line 1292 "parse.y"
{
		 struct deliver_lmtp_data       *data;

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_lmtp;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 if (*yyvsp[-2].server.host == '/')
			data->socket = yyvsp[-2].server.host;
		 else {
			data->server.host = yyvsp[-2].server.host;
			if (yyvsp[-2].server.port != NULL)
				data->server.port = yyvsp[-2].server.port;
			else
				data->server.port = xstrdup("24");
		 }
		 data->from.str = yyvsp[-1].string;
		 data->to.str = yyvsp[0].string;
	 }
break;
case 144:
#line 1314 "parse.y"
{
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_stdout;
	 }
break;
case 145:
#line 1319 "parse.y"
{
		 struct deliver_tag_data	*data;

		 if (*yyvsp[-1].string == '\0')
			 yyerror("invalid tag");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_tag;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->key.str = yyvsp[-1].string;
		 data->value.str = yyvsp[0].string;
	 }
break;
case 146:
#line 1335 "parse.y"
{
		 struct deliver_add_to_cache_data	*data;

		 if (*yyvsp[-2].string == '\0')
			 yyerror("invalid path");
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid key");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_add_to_cache;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->key.str = yyvsp[0].string;
		 data->path = yyvsp[-2].string;
	 }
break;
case 147:
#line 1353 "parse.y"
{
		 struct deliver_remove_from_cache_data	*data;

		 if (*yyvsp[-2].string == '\0')
			 yyerror("invalid path");
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid key");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_remove_from_cache;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->key.str = yyvsp[0].string;
		 data->path = yyvsp[-2].string;
	 }
break;
case 148:
#line 1371 "parse.y"
{
		 struct deliver_action_data	*data;

		 /*
		  * This is a special-case, handled when the list of delivery
		  * targets is resolved rather than by calling a deliver
		  * function, so the deliver pointer is NULL.
		  */
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = NULL;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->actions = yyvsp[0].replstrs;
	 }
break;
case 149:
#line 1388 "parse.y"
{
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_drop;
	 }
break;
case 150:
#line 1393 "parse.y"
{
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_keep;
	 }
break;
case 151:
#line 1399 "parse.y"
{
		 yyval.actlist = yyvsp[-1].actlist;

		 TAILQ_INSERT_TAIL(yyval.actlist, yyvsp[0].actitem, entry);
		 yyvsp[0].actitem->idx = parse_actionidx++;
	 }
break;
case 152:
#line 1406 "parse.y"
{
		 yyval.actlist = xmalloc(sizeof *yyval.actlist);
		 TAILQ_INIT(yyval.actlist);

		 TAILQ_INSERT_HEAD(yyval.actlist, yyvsp[0].actitem, entry);
		 yyvsp[0].actitem->idx = 0;

		 parse_actionidx = 1;
	 }
break;
case 153:
#line 1417 "parse.y"
{
		   struct action	*t;

		   if (strlen(yyvsp[-2].string) >= MAXNAMESIZE)
			   yyerror("action name too long: %s", yyvsp[-2].string);
		   if (*yyvsp[-2].string == '\0')
			   yyerror("invalid action name");
		   if (find_action(yyvsp[-2].string) != NULL)
			   yyerror("duplicate action: %s", yyvsp[-2].string);

		   t = xmalloc(sizeof *t);
		   strlcpy(t->name, yyvsp[-2].string, sizeof t->name);

		   t->list = xmalloc(sizeof *t->list);
		   TAILQ_INIT(t->list);
		   TAILQ_INSERT_HEAD(t->list, yyvsp[0].actitem, entry);
		   yyvsp[0].actitem->idx = 0;

		   t->users = yyvsp[-1].replstrs;
		   TAILQ_INSERT_TAIL(&conf.actions, t, entry);

		   print_action(t);

		   xfree(yyvsp[-2].string);
	   }
break;
case 154:
#line 1443 "parse.y"
{
		   struct action	*t;

		   if (strlen(yyvsp[-4].string) >= MAXNAMESIZE)
			   yyerror("action name too long: %s", yyvsp[-4].string);
		   if (*yyvsp[-4].string == '\0')
			   yyerror("invalid action name");
		   if (find_action(yyvsp[-4].string) != NULL)
			   yyerror("duplicate action: %s", yyvsp[-4].string);

		   t = xmalloc(sizeof *t);
		   strlcpy(t->name, yyvsp[-4].string, sizeof t->name);

		   t->list = yyvsp[-1].actlist;

		   t->users = yyvsp[-3].replstrs;
		   TAILQ_INSERT_TAIL(&conf.actions, t, entry);

		   print_action(t);

		   xfree(yyvsp[-4].string);
	   }
break;
case 155:
#line 1467 "parse.y"
{
		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid account name");
		  if (!have_accounts(yyvsp[0].string))
			  yyerror("no matching accounts: %s", yyvsp[0].string);

		  yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		  ARRAY_INIT(yyval.replstrs);
		  ARRAY_EXPAND(yyval.replstrs, 1);
		  ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	  }
break;
case 156:
#line 1479 "parse.y"
{
		  yyval.replstrs = yyvsp[-1].replstrs;
	  }
break;
case 157:
#line 1484 "parse.y"
{
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid action name");

		 yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		 ARRAY_INIT(yyval.replstrs);
		 ARRAY_EXPAND(yyval.replstrs, 1);
		 ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	 }
break;
case 158:
#line 1494 "parse.y"
{
		 yyval.replstrs = yyvsp[-1].replstrs;
	 }
break;
case 159:
#line 1499 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 160:
#line 1503 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 161:
#line 1508 "parse.y"
{
	      yyval.area = AREA_ANY;
      }
break;
case 162:
#line 1512 "parse.y"
{
	      yyval.area = AREA_ANY;
      }
break;
case 163:
#line 1516 "parse.y"
{
	      yyval.area = AREA_HEADERS;
      }
break;
case 164:
#line 1520 "parse.y"
{
	      yyval.area = AREA_BODY;
      }
break;
case 165:
#line 1525 "parse.y"
{
	       if (yyvsp[0].number < 0 || yyvsp[0].number > 255)
		       yyerror("invalid return code");

	       yyval.number = yyvsp[0].number;
       }
break;
case 166:
#line 1532 "parse.y"
{
	       yyval.number = -1;
       }
break;
case 167:
#line 1537 "parse.y"
{
	       yyval.re = yyvsp[0].re;
       }
break;
case 168:
#line 1541 "parse.y"
{
	       yyval.re.str = NULL;
       }
break;
case 169:
#line 1546 "parse.y"
{
	     yyval.cmp = CMP_LT;
     }
break;
case 170:
#line 1550 "parse.y"
{
	     yyval.cmp = CMP_GT;
     }
break;
case 171:
#line 1555 "parse.y"
{
	      yyval.cmp = CMP_EQ;
      }
break;
case 172:
#line 1559 "parse.y"
{
	      yyval.cmp = CMP_NE;
      }
break;
case 173:
#line 1564 "parse.y"
{
	     yyval.cmp = yyvsp[0].cmp;
     }
break;
case 174:
#line 1568 "parse.y"
{
	     yyval.cmp = yyvsp[0].cmp;
     }
break;
case 175:
#line 1573 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 176:
#line 1577 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 177:
#line 1582 "parse.y"
{
		     yyval.flag = 0;
	     }
break;
case 178:
#line 1586 "parse.y"
{
		     yyval.flag = 1;
	     }
break;
case 179:
#line 1591 "parse.y"
{
		yyval.exprop = OP_AND;
	}
break;
case 180:
#line 1595 "parse.y"
{
		yyval.exprop = OP_OR;
	}
break;
case 181:
#line 1600 "parse.y"
{
		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_all;
		  yyval.expritem->inverted = yyvsp[-1].flag;
	  }
break;
case 182:
#line 1606 "parse.y"
{
		  struct match_regexp_data	*data;
		  char				*cause;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_regexp;
		  yyval.expritem->inverted = yyvsp[-2].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->area = yyvsp[0].area;

		  if (re_compile(&data->re, yyvsp[-1].re.str, yyvsp[-1].re.flags, &cause) != 0)
			  yyerror("%s", cause);
		  xfree(yyvsp[-1].re.str);
	  }
break;
case 183:
#line 1624 "parse.y"
{
		  struct match_account_data	*data;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_account;
		  yyval.expritem->inverted = yyvsp[-1].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->accounts = yyvsp[0].replstrs;
	  }
break;
case 184:
#line 1637 "parse.y"
{
		  struct match_command_data	*data;
		  char				*cause;

		  if (*yyvsp[-7].string == '\0' || (yyvsp[-7].string[0] == '|' && yyvsp[-7].string[1] == '\0'))
			  yyerror("invalid command");
		  if (yyvsp[-3].number == -1 && yyvsp[-1].re.str == NULL)
			  yyerror("return code or regexp must be specified");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_command;
		  yyval.expritem->inverted = yyvsp[-9].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->user.str = yyvsp[-6].string;
		  data->pipe = yyvsp[-8].flag;
		  data->cmd.str = yyvsp[-7].string;

		  data->ret = yyvsp[-3].number;

		  if (yyvsp[-1].re.str != NULL) {
			  if (re_compile(
			      &data->re, yyvsp[-1].re.str, yyvsp[-1].re.flags, &cause) != 0)
				  yyerror("%s", cause);
			  xfree(yyvsp[-1].re.str);
		  }

	  }
break;
case 185:
#line 1668 "parse.y"
{
		  struct match_tagged_data	*data;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid tag");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_tagged;
		  yyval.expritem->inverted = yyvsp[-2].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->tag.str = yyvsp[0].string;
	  }
break;
case 186:
#line 1685 "parse.y"
{
		  struct match_size_data	*data;

#if SIZE_MAX < LLONG_MAX
		  if (yyvsp[0].number > SIZE_MAX)
			  yyerror("size too large");
#endif

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_size;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->size = yyvsp[0].number;
		  data->cmp = yyvsp[-1].cmp;
	  }
break;
case 187:
#line 1705 "parse.y"
{
		  struct match_string_data	*data;
		  char				*cause;

		  if (*yyvsp[-2].string == '\0')
			  yyerror("invalid string");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_string;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->str.str = yyvsp[-2].string;
		  if (re_compile(
		      &data->re, yyvsp[0].re.str, yyvsp[0].re.flags|RE_NOSUBST, &cause) != 0)
			  yyerror("%s", cause);
		  xfree(yyvsp[0].re.str);
	  }
break;
case 188:
#line 1727 "parse.y"
{
		  struct match_in_cache_data	*data;

		  if (*yyvsp[-2].string == '\0')
			  yyerror("invalid path");
		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid key");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_in_cache;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->key.str = yyvsp[0].string;
		  data->path = yyvsp[-2].string;
	  }
break;
case 189:
#line 1747 "parse.y"
{
		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_matched;
		  yyval.expritem->inverted = yyvsp[-1].flag;
	  }
break;
case 190:
#line 1754 "parse.y"
{
		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_unmatched;
		  yyval.expritem->inverted = yyvsp[-1].flag;
	  }
break;
case 191:
#line 1761 "parse.y"
{
		  struct match_age_data	*data;

		  if (yyvsp[0].number == 0)
			  yyerror("invalid time");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_age;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->time = yyvsp[0].number;
		  data->cmp = yyvsp[-1].cmp;
	  }
break;
case 192:
#line 1779 "parse.y"
{
		  struct match_age_data	*data;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_age;
		  yyval.expritem->inverted = yyvsp[-2].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->time = -1;
	  }
break;
case 193:
#line 1793 "parse.y"
{
		  struct match_attachment_data	*data;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_COUNT;
		  data->cmp = yyvsp[-1].cmp;
		  data->value.num = yyvsp[0].number;
	  }
break;
case 194:
#line 1809 "parse.y"
{
		  struct match_attachment_data	*data;

#if SIZE_MAX < LLONG_MAX
		  if (yyvsp[0].number > SIZE_MAX)
			  yyerror("size too large");
#endif

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_TOTALSIZE;
		  data->cmp = yyvsp[-1].cmp;
		  data->value.size = yyvsp[0].number;
	  }
break;
case 195:
#line 1830 "parse.y"
{
		  struct match_attachment_data	*data;

#if SIZE_MAX < LLONG_MAX
		  if (yyvsp[0].number > SIZE_MAX)
			  yyerror("size too large");
#endif

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_ANYSIZE;
		  data->cmp = yyvsp[-1].cmp;
		  data->value.size = yyvsp[0].number;
	  }
break;
case 196:
#line 1851 "parse.y"
{
		  struct match_attachment_data	*data;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid string");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_ANYTYPE;
		  data->value.str.str = yyvsp[0].string;
	  }
break;
case 197:
#line 1869 "parse.y"
{
		  struct match_attachment_data	*data;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid string");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_ANYNAME;
		  data->value.str.str = yyvsp[0].string;
	  }
break;
case 198:
#line 1888 "parse.y"
{
		  yyval.expr = yyvsp[-2].expr;

		  yyvsp[0].expritem->op = yyvsp[-1].exprop;
		  TAILQ_INSERT_TAIL(yyval.expr, yyvsp[0].expritem, entry);
	  }
break;
case 199:
#line 1895 "parse.y"
{
		  yyval.expr = xmalloc(sizeof *yyval.expr);
		  TAILQ_INIT(yyval.expr);

		  yyvsp[0].expritem->op = yyvsp[-1].exprop;
		  TAILQ_INSERT_HEAD(yyval.expr, yyvsp[0].expritem, entry);
	  }
break;
case 200:
#line 1904 "parse.y"
{
	      yyval.expr = xmalloc(sizeof *yyval.expr);
	      TAILQ_INIT(yyval.expr);

	      TAILQ_INSERT_HEAD(yyval.expr, yyvsp[0].expritem, entry);
      }
break;
case 201:
#line 1911 "parse.y"
{
	      yyval.expr = yyvsp[0].expr;

	      TAILQ_INSERT_HEAD(yyval.expr, yyvsp[-1].expritem, entry);
      }
break;
case 202:
#line 1918 "parse.y"
{
		 struct action	*t;

		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->actions = NULL;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = !yyvsp[0].flag;
		 yyval.rule->users = yyvsp[-3].replstrs;

		 t = yyval.rule->lambda = xcalloc(1, sizeof *yyval.rule->lambda);
		 xsnprintf(t->name, sizeof t->name, "<rule %u>", yyval.rule->idx);
		 t->users = NULL;
		 t->list = xmalloc(sizeof *t->list);
		 TAILQ_INIT(t->list);
		 TAILQ_INSERT_HEAD(t->list, yyvsp[-1].actitem, entry);
		 yyvsp[-1].actitem->idx = 0;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);
	 }
break;
case 203:
#line 1942 "parse.y"
{
		 struct action	*t;

		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->actions = NULL;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = !yyvsp[0].flag;
		 yyval.rule->users = yyvsp[-5].replstrs;

		 t = yyval.rule->lambda = xcalloc(1, sizeof *yyval.rule->lambda);
		 xsnprintf(t->name, sizeof t->name, "<rule %u>", yyval.rule->idx);
		 t->users = NULL;
		 t->list = yyvsp[-2].actlist;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);
	 }
break;
case 204:
#line 1963 "parse.y"
{
		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->lambda = NULL;
		 yyval.rule->actions = yyvsp[-1].replstrs;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = !yyvsp[0].flag;
		 yyval.rule->users = yyvsp[-2].replstrs;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);
	 }
break;
case 205:
#line 1978 "parse.y"
{
		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->lambda = NULL;
		 yyval.rule->actions = NULL;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = 0;
		 yyval.rule->users = NULL;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);

		 ARRAY_ADD(&parse_rulestack, parse_rule);
		 parse_rule = yyval.rule;
	 }
break;
case 206:
#line 1997 "parse.y"
{
	       if (parse_rule == NULL)
		       yyerror("missing {");

	       parse_rule = ARRAY_LAST(&parse_rulestack);
	       ARRAY_TRUNC(&parse_rulestack, 1);
       }
break;
case 207:
#line 2006 "parse.y"
{
	      yyvsp[0].rule->expr = yyvsp[-1].expr;
	      print_rule(yyvsp[0].rule);
      }
break;
case 208:
#line 2012 "parse.y"
{
		    yyval.strings = xmalloc(sizeof *yyval.strings);
		    ARRAY_INIT(yyval.strings);
		    ARRAY_ADD(yyval.strings, xstrdup("INBOX"));
	    }
break;
case 209:
#line 2018 "parse.y"
{
		    yyval.strings = yyvsp[0].strings;
	    }
break;
case 210:
#line 2023 "parse.y"
{
		 yyval.string = xstrdup("INBOX");
	 }
break;
case 211:
#line 2027 "parse.y"
{
		 yyval.string = yyvsp[0].string;
	 }
break;
case 212:
#line 2033 "parse.y"
{
		if (*yyvsp[0].string == '\0')
			yyerror("invalid group");

		yyval.strings = xmalloc(sizeof *yyval.strings);
		ARRAY_INIT(yyval.strings);
		ARRAY_ADD(yyval.strings, yyvsp[0].string);
	}
break;
case 213:
#line 2042 "parse.y"
{
		yyval.strings = yyvsp[-1].strings;
	}
break;
case 214:
#line 2047 "parse.y"
{
		   yyval.flag = 1;
	   }
break;
case 215:
#line 2051 "parse.y"
{
		   yyval.flag = 0;
	   }
break;
case 216:
#line 2056 "parse.y"
{
		 yyval.flag = 1;
	 }
break;
case 217:
#line 2060 "parse.y"
{
		 yyval.flag = 0;
	 }
break;
case 218:
#line 2065 "parse.y"
{
		 yyval.flag = 1;
	 }
break;
case 219:
#line 2069 "parse.y"
{
		 yyval.flag = 0;
	 }
break;
case 220:
#line 2074 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 221:
#line 2078 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 222:
#line 2084 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 223:
#line 2088 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 224:
#line 2093 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 225:
#line 2097 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 226:
#line 2102 "parse.y"
{
		     yyval.flag = 1;
	     }
break;
case 227:
#line 2106 "parse.y"
{
		     yyval.flag = 0;
	     }
break;
case 228:
#line 2111 "parse.y"
{
		 yyval.flag = 1;
	 }
break;
case 229:
#line 2115 "parse.y"
{
		 yyval.flag = 0;
	 }
break;
case 230:
#line 2120 "parse.y"
{
		yyval.flag = 0;
	}
break;
case 231:
#line 2124 "parse.y"
{
		yyval.flag = 1;
	}
break;
case 232:
#line 2129 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 233:
#line 2133 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 234:
#line 2138 "parse.y"
{
	      yyval.only = FETCH_ONLY_NEW;
      }
break;
case 235:
#line 2142 "parse.y"
{
	      yyval.only = FETCH_ONLY_OLD;
      }
break;
case 236:
#line 2147 "parse.y"
{
		 yyval.flag = 0;
	 }
break;
case 237:
#line 2151 "parse.y"
{
		 yyval.flag = 1;
	 }
break;
case 238:
#line 2156 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 239:
#line 2160 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 240:
#line 2165 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 241:
#line 2169 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 242:
#line 2174 "parse.y"
{
		       if (*yyvsp[-2].string == '\0')
			       yyerror("invalid user");
		       if (*yyvsp[0].string == '\0')
			       yyerror("invalid pass");

		       yyval.userpass.user = yyvsp[-2].string;
		       yyval.userpass.user_netrc = 0;
		       yyval.userpass.pass = yyvsp[0].string;
		       yyval.userpass.pass_netrc = 0;
	       }
break;
case 243:
#line 2186 "parse.y"
{
		       yyval.userpass.user = NULL;
		       yyval.userpass.user_netrc = 1;
		       yyval.userpass.pass = NULL;
		       yyval.userpass.pass_netrc = 1;
	       }
break;
case 244:
#line 2193 "parse.y"
{
		       if (*yyvsp[0].string == '\0')
			       yyerror("invalid user");

		       yyval.userpass.user = yyvsp[0].string;
		       yyval.userpass.user_netrc = 0;
		       yyval.userpass.pass = NULL;
		       yyval.userpass.pass_netrc = 1;
	       }
break;
case 245:
#line 2203 "parse.y"
{
		       if (*yyvsp[0].string == '\0')
			       yyerror("invalid pass");

		       yyval.userpass.user = NULL;
		       yyval.userpass.user_netrc = 1;
		       yyval.userpass.pass = yyvsp[0].string;
		       yyval.userpass.pass_netrc = 0;
	       }
break;
case 246:
#line 2214 "parse.y"
{
		      if (*yyvsp[-2].string == '\0')
			      yyerror("invalid user");
		      if (*yyvsp[0].string == '\0')
			      yyerror("invalid pass");

		      yyval.userpass.user = yyvsp[-2].string;
		      yyval.userpass.user_netrc = 0;
		      yyval.userpass.pass = yyvsp[0].string;
		      yyval.userpass.pass_netrc = 0;
	      }
break;
case 247:
#line 2227 "parse.y"
{
		  yyval.userpass.user = yyvsp[0].userpass.user;
		  yyval.userpass.user_netrc = yyvsp[0].userpass.user_netrc;
		  yyval.userpass.pass = yyvsp[0].userpass.pass;
		  yyval.userpass.pass_netrc = yyvsp[0].userpass.pass_netrc;
	  }
break;
case 248:
#line 2234 "parse.y"
{
		  yyval.userpass.user = NULL;
		  yyval.userpass.user_netrc = 0;
		  yyval.userpass.pass = NULL;
		  yyval.userpass.pass_netrc = 0;
	  }
break;
case 249:
#line 2242 "parse.y"
{
		 yyval.poponly.path = yyvsp[0].string;
		 yyval.poponly.only = yyvsp[-2].only;
	 }
break;
case 250:
#line 2247 "parse.y"
{
		 yyval.poponly.path = NULL;
		 yyval.poponly.only = FETCH_ONLY_ALL;
	 }
break;
case 251:
#line 2253 "parse.y"
{
		  yyval.only = yyvsp[0].only;
	  }
break;
case 252:
#line 2257 "parse.y"
{
		  yyval.only = FETCH_ONLY_ALL;
	  }
break;
case 253:
#line 2263 "parse.y"
{
		   struct fetch_pop3_data	*data;

		   if (yyvsp[-8].flag && yyvsp[-1].flag)
			   yyerror("use either pop3s or set starttls");

		   yyval.fetch.fetch = &fetch_pop3;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;

		   if (yyvsp[-6].userpass.user && yyvsp[-6].userpass.pass == NULL) {
			   data->user = yyvsp[-6].userpass.user;
			   find_netrc(yyvsp[-7].server.host, &data->user, &data->pass);
		   } else if (yyvsp[-6].userpass.user_netrc && yyvsp[-6].userpass.pass_netrc)
			  find_netrc(yyvsp[-7].server.host, &data->user, &data->pass);
		   else {
			   if (yyvsp[-6].userpass.user_netrc)
				   find_netrc(yyvsp[-7].server.host, &data->user, NULL);
			   else
				   data->user = yyvsp[-6].userpass.user;
			   if (yyvsp[-6].userpass.pass_netrc)
				   find_netrc(yyvsp[-7].server.host, NULL, &data->pass);
			   else
				   data->pass = yyvsp[-6].userpass.pass;
		   }

		   data->server.ssl = yyvsp[-8].flag;
		   data->server.verify = yyvsp[-3].flag;
		   data->server.host = yyvsp[-7].server.host;
		   if (yyvsp[-7].server.port != NULL)
			   data->server.port = yyvsp[-7].server.port;
		   else if (yyvsp[-8].flag)
			   data->server.port = xstrdup("pop3s");
		   else
			   data->server.port = xstrdup("pop3");
		   data->server.ai = NULL;
		   data->apop = yyvsp[-4].flag;
		   data->uidl = yyvsp[-2].flag;
		   data->starttls = yyvsp[-1].flag;
		   data->server.insecure = yyvsp[0].flag;

		   data->path = yyvsp[-5].poponly.path;
		   data->only = yyvsp[-5].poponly.only;
	   }
break;
case 254:
#line 2308 "parse.y"
{
		   struct fetch_pop3_data	*data;

		   yyval.fetch.fetch = &fetch_pop3pipe;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->user = yyvsp[-2].userpass.user;
		   data->pass = yyvsp[-2].userpass.pass;
		   data->pipecmd = yyvsp[-3].string;
		   if (data->pipecmd == NULL || *data->pipecmd == '\0')
			   yyerror("invalid pipe command");
		   data->apop = yyvsp[0].flag;
		   data->path = yyvsp[-1].poponly.path;
		   data->only = yyvsp[-1].poponly.only;
	   }
break;
case 255:
#line 2325 "parse.y"
{
		   struct fetch_imap_data	*data;

		   if (yyvsp[-12].flag && yyvsp[-3].flag)
			   yyerror("use either imaps or set starttls");

		   yyval.fetch.fetch = &fetch_imap;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;

		   if (yyvsp[-10].userpass.user && yyvsp[-10].userpass.pass == NULL) {
			   data->user = yyvsp[-10].userpass.user;
			   find_netrc(yyvsp[-11].server.host, &data->user, &data->pass);
		   } else if (yyvsp[-10].userpass.user_netrc && yyvsp[-10].userpass.pass_netrc)
			   find_netrc(yyvsp[-11].server.host, &data->user, &data->pass);
		   else {
			   if (yyvsp[-10].userpass.user_netrc)
				   find_netrc(yyvsp[-11].server.host, &data->user, NULL);
			   else
				   data->user = yyvsp[-10].userpass.user;
			   if (yyvsp[-10].userpass.pass_netrc)
				   find_netrc(yyvsp[-11].server.host, NULL, &data->pass);
			   else
				   data->pass = yyvsp[-10].userpass.pass;
		   }

		   data->folders = yyvsp[-9].strings;
		   data->server.ssl = yyvsp[-12].flag;
		   data->server.verify = yyvsp[-7].flag;
		   data->server.host = yyvsp[-11].server.host;
		   if (yyvsp[-11].server.port != NULL)
			   data->server.port = yyvsp[-11].server.port;
		   else if (yyvsp[-12].flag)
			   data->server.port = xstrdup("imaps");
		   else
			   data->server.port = xstrdup("imap");
		   data->server.ai = NULL;
		   data->only = yyvsp[-8].only;
		   data->nocrammd5 = yyvsp[-6].flag;
		   data->noplain = yyvsp[-5].flag;
		   data->nologin = yyvsp[-4].flag;
		   data->starttls = yyvsp[-3].flag;
		   data->server.insecure = yyvsp[-2].flag;
		   data->oauthbearer = yyvsp[-1].flag;
		   data->xoauth2 = yyvsp[0].flag;
	   }
break;
case 256:
#line 2372 "parse.y"
{
		   struct fetch_imap_data	*data;

		   yyval.fetch.fetch = &fetch_imappipe;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->user = yyvsp[-2].userpass.user;
		   data->pass = yyvsp[-2].userpass.pass;
		   data->folders = yyvsp[-1].strings;
		   data->pipecmd = yyvsp[-3].string;
		   if (data->pipecmd == NULL || *data->pipecmd == '\0')
			   yyerror("invalid pipe command");
		   data->only = yyvsp[0].only;
	   }
break;
case 257:
#line 2387 "parse.y"
{
		   yyval.fetch.fetch = &fetch_stdin;
	   }
break;
case 258:
#line 2391 "parse.y"
{
		   struct fetch_maildir_data	*data;

		   yyval.fetch.fetch = &fetch_maildir;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->maildirs = yyvsp[0].strings;
	   }
break;
case 259:
#line 2400 "parse.y"
{
		   struct fetch_mbox_data	*data;

		   yyval.fetch.fetch = &fetch_mbox;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->mboxes = yyvsp[0].strings;
	   }
break;
case 260:
#line 2410 "parse.y"
{
		   struct fetch_nntp_data	*data;
		   char				*cause;

		   if (*yyvsp[-2].string == '\0')
			   yyerror("invalid cache");

		   yyval.fetch.fetch = &fetch_nntp;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;

		   if (yyvsp[-5].userpass.user && yyvsp[-5].userpass.pass == NULL) {
			   data->user = yyvsp[-5].userpass.user;
			   find_netrc(yyvsp[-6].server.host, &data->user, &data->pass);
		   } else if (yyvsp[-5].userpass.user_netrc && yyvsp[-5].userpass.pass_netrc) {
			   if (find_netrc1(yyvsp[-6].server.host, &data->user, &data->pass,
			       &cause) != 0) {
				   log_debug2("%s", cause);
				   xfree(cause);
				   data->user = NULL;
				   data->pass = NULL;
			   }
		   } else {
			   if (yyvsp[-5].userpass.user_netrc)
				   find_netrc(yyvsp[-6].server.host, &data->user, NULL);
			   else
				   data->user = yyvsp[-5].userpass.user;
			   if (yyvsp[-5].userpass.pass_netrc)
				   find_netrc(yyvsp[-6].server.host, NULL, &data->pass);
			   else
				   data->pass = yyvsp[-5].userpass.pass;
		   }

		   data->names = yyvsp[-4].strings;
		   data->path = yyvsp[-2].string;
		   if (data->path == NULL || *data->path == '\0')
			   yyerror("invalid cache");

		   data->server.ssl = yyvsp[-7].flag;
		   data->server.verify = yyvsp[-1].flag;
		   data->server.insecure = yyvsp[0].flag;
		   data->server.host = yyvsp[-6].server.host;
		   if (yyvsp[-6].server.port != NULL)
			   data->server.port = yyvsp[-6].server.port;
		   else if (yyvsp[-7].flag)
			   data->server.port = xstrdup("nntps");
		   else
			   data->server.port = xstrdup("nntp");
		   data->server.ai = NULL;
	   }
break;
case 261:
#line 2462 "parse.y"
{
		 struct account		*a;
		 char			*su, desc[DESCBUFSIZE];

		 if (strlen(yyvsp[-4].string) >= MAXNAMESIZE)
			 yyerror("account name too long: %s", yyvsp[-4].string);
		 if (*yyvsp[-4].string == '\0')
			 yyerror("invalid account name");
		 if (find_account(yyvsp[-4].string) != NULL)
			 yyerror("duplicate account: %s", yyvsp[-4].string);

		 a = xcalloc(1, sizeof *a);
		 strlcpy(a->name, yyvsp[-4].string, sizeof a->name);
		 a->keep = yyvsp[0].flag;
		 a->disabled = yyvsp[-3].flag;
		 a->users = yyvsp[-2].replstrs;
		 a->fetch = yyvsp[-1].fetch.fetch;
		 a->data = yyvsp[-1].fetch.data;
		 TAILQ_INSERT_TAIL(&conf.accounts, a, entry);

		 if (a->users != NULL)
			 su = fmt_replstrs(" users=", a->users);
		 else
			 su = xstrdup("");
		 a->fetch->desc(a, desc, sizeof desc);
		 log_debug2("added account \"%s\":%s fetch=%s", a->name, su,
		     desc);
		 xfree(su);

		 xfree(yyvsp[-4].string);
	 }
break;
#line 4556 "parse.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (1);
yyaccept:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (0);
}
