/* Generated by wayland-scanner 1.23.0 */

#ifndef APPMENU_CLIENT_PROTOCOL_H
#define APPMENU_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_appmenu The appmenu protocol
 * @section page_ifaces_appmenu Interfaces
 * - @subpage page_iface_org_kde_kwin_appmenu_manager - appmenu dbus address interface
 * - @subpage page_iface_org_kde_kwin_appmenu - appmenu dbus address interface
 * @section page_copyright_appmenu Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2017 David Edmundson
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_appmenu;
struct org_kde_kwin_appmenu_manager;
struct wl_surface;

#ifndef ORG_KDE_KWIN_APPMENU_MANAGER_INTERFACE
#define ORG_KDE_KWIN_APPMENU_MANAGER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_appmenu_manager org_kde_kwin_appmenu_manager
 * @section page_iface_org_kde_kwin_appmenu_manager_desc Description
 *
 * This interface allows a client to link a window (or wl_surface) to an com.canonical.dbusmenu
 * interface registered on DBus.
 * @section page_iface_org_kde_kwin_appmenu_manager_api API
 * See @ref iface_org_kde_kwin_appmenu_manager.
 */
/**
 * @defgroup iface_org_kde_kwin_appmenu_manager The org_kde_kwin_appmenu_manager interface
 *
 * This interface allows a client to link a window (or wl_surface) to an com.canonical.dbusmenu
 * interface registered on DBus.
 */
extern const struct wl_interface org_kde_kwin_appmenu_manager_interface;
#endif
#ifndef ORG_KDE_KWIN_APPMENU_INTERFACE
#define ORG_KDE_KWIN_APPMENU_INTERFACE
/**
 * @page page_iface_org_kde_kwin_appmenu org_kde_kwin_appmenu
 * @section page_iface_org_kde_kwin_appmenu_desc Description
 *
 * The DBus service name and object path where the appmenu interface is present
 * The object should be registered on the session bus before sending this request.
 * If not applicable, clients should remove this object.
 * @section page_iface_org_kde_kwin_appmenu_api API
 * See @ref iface_org_kde_kwin_appmenu.
 */
/**
 * @defgroup iface_org_kde_kwin_appmenu The org_kde_kwin_appmenu interface
 *
 * The DBus service name and object path where the appmenu interface is present
 * The object should be registered on the session bus before sending this request.
 * If not applicable, clients should remove this object.
 */
extern const struct wl_interface org_kde_kwin_appmenu_interface;
#endif

#define ORG_KDE_KWIN_APPMENU_MANAGER_CREATE 0


/**
 * @ingroup iface_org_kde_kwin_appmenu_manager
 */
#define ORG_KDE_KWIN_APPMENU_MANAGER_CREATE_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_appmenu_manager */
static inline void
org_kde_kwin_appmenu_manager_set_user_data(struct org_kde_kwin_appmenu_manager *org_kde_kwin_appmenu_manager, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_appmenu_manager, user_data);
}

/** @ingroup iface_org_kde_kwin_appmenu_manager */
static inline void *
org_kde_kwin_appmenu_manager_get_user_data(struct org_kde_kwin_appmenu_manager *org_kde_kwin_appmenu_manager)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_appmenu_manager);
}

static inline uint32_t
org_kde_kwin_appmenu_manager_get_version(struct org_kde_kwin_appmenu_manager *org_kde_kwin_appmenu_manager)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_appmenu_manager);
}

/** @ingroup iface_org_kde_kwin_appmenu_manager */
static inline void
org_kde_kwin_appmenu_manager_destroy(struct org_kde_kwin_appmenu_manager *org_kde_kwin_appmenu_manager)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_appmenu_manager);
}

/**
 * @ingroup iface_org_kde_kwin_appmenu_manager
 */
static inline struct org_kde_kwin_appmenu *
org_kde_kwin_appmenu_manager_create(struct org_kde_kwin_appmenu_manager *org_kde_kwin_appmenu_manager, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_appmenu_manager,
			 ORG_KDE_KWIN_APPMENU_MANAGER_CREATE, &org_kde_kwin_appmenu_interface, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_appmenu_manager), 0, NULL, surface);

	return (struct org_kde_kwin_appmenu *) id;
}

#define ORG_KDE_KWIN_APPMENU_SET_ADDRESS 0
#define ORG_KDE_KWIN_APPMENU_RELEASE 1


/**
 * @ingroup iface_org_kde_kwin_appmenu
 */
#define ORG_KDE_KWIN_APPMENU_SET_ADDRESS_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_appmenu
 */
#define ORG_KDE_KWIN_APPMENU_RELEASE_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_appmenu */
static inline void
org_kde_kwin_appmenu_set_user_data(struct org_kde_kwin_appmenu *org_kde_kwin_appmenu, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_appmenu, user_data);
}

/** @ingroup iface_org_kde_kwin_appmenu */
static inline void *
org_kde_kwin_appmenu_get_user_data(struct org_kde_kwin_appmenu *org_kde_kwin_appmenu)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_appmenu);
}

static inline uint32_t
org_kde_kwin_appmenu_get_version(struct org_kde_kwin_appmenu *org_kde_kwin_appmenu)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_appmenu);
}

/** @ingroup iface_org_kde_kwin_appmenu */
static inline void
org_kde_kwin_appmenu_destroy(struct org_kde_kwin_appmenu *org_kde_kwin_appmenu)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_appmenu);
}

/**
 * @ingroup iface_org_kde_kwin_appmenu
 *
 * Set or update the service name and object path.
 * Strings should be formatted in Latin-1 matching the relevant DBus specifications.
 */
static inline void
org_kde_kwin_appmenu_set_address(struct org_kde_kwin_appmenu *org_kde_kwin_appmenu, const char *service_name, const char *object_path)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_appmenu,
			 ORG_KDE_KWIN_APPMENU_SET_ADDRESS, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_appmenu), 0, service_name, object_path);
}

/**
 * @ingroup iface_org_kde_kwin_appmenu
 */
static inline void
org_kde_kwin_appmenu_release(struct org_kde_kwin_appmenu *org_kde_kwin_appmenu)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_appmenu,
			 ORG_KDE_KWIN_APPMENU_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_appmenu), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
