/* ContractKeyFile.c generated by valac 0.56.17, the Vala compiler
 * generated from ContractKeyFile.vala, do not modify */

/*
 * Copyright (C) 2013-2017 elementary Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>

#define CONTRACTOR_CONTRACT_KEY_FILE_CONTRACTOR_GROUP "Contractor Entry"
#define CONTRACTOR_CONTRACT_KEY_FILE_DESKTOP_GROUP G_KEY_FILE_DESKTOP_GROUP
#define CONTRACTOR_CONTRACT_KEY_FILE_NAME_KEY G_KEY_FILE_DESKTOP_KEY_NAME
#define CONTRACTOR_CONTRACT_KEY_FILE_DESCRIPTION_KEY "Description"
#define CONTRACTOR_CONTRACT_KEY_FILE_ICON_KEY G_KEY_FILE_DESKTOP_KEY_ICON
#define CONTRACTOR_CONTRACT_KEY_FILE_MIMETYPE_KEY G_KEY_FILE_DESKTOP_KEY_MIME_TYPE
#define CONTRACTOR_CONTRACT_KEY_FILE_MAX_FILE_SIZE_KEY "MaxFileSize"
#define CONTRACTOR_CONTRACT_KEY_FILE_EXEC_KEY G_KEY_FILE_DESKTOP_KEY_EXEC
#define CONTRACTOR_CONTRACT_KEY_FILE_TRY_EXEC_KEY G_KEY_FILE_DESKTOP_KEY_TRY_EXEC
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTRACTOR_TYPE_CONTRACT_KEY_FILE (contractor_contract_key_file_get_type ())
#define CONTRACTOR_CONTRACT_KEY_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT_KEY_FILE, ContractorContractKeyFile))
#define CONTRACTOR_CONTRACT_KEY_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT_KEY_FILE, ContractorContractKeyFileClass))
#define CONTRACTOR_IS_CONTRACT_KEY_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT_KEY_FILE))
#define CONTRACTOR_IS_CONTRACT_KEY_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT_KEY_FILE))
#define CONTRACTOR_CONTRACT_KEY_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT_KEY_FILE, ContractorContractKeyFileClass))

typedef struct _ContractorContractKeyFile ContractorContractKeyFile;
typedef struct _ContractorContractKeyFileClass ContractorContractKeyFileClass;
typedef struct _ContractorContractKeyFilePrivate ContractorContractKeyFilePrivate;
enum  {
	CONTRACTOR_CONTRACT_KEY_FILE_0_PROPERTY,
	CONTRACTOR_CONTRACT_KEY_FILE_NUM_PROPERTIES
};
static GParamSpec* contractor_contract_key_file_properties[CONTRACTOR_CONTRACT_KEY_FILE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define CONTRACTOR_TYPE_CONTRACT_FILE (contractor_contract_file_get_type ())
#define CONTRACTOR_CONTRACT_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT_FILE, ContractorContractFile))
#define CONTRACTOR_CONTRACT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT_FILE, ContractorContractFileClass))
#define CONTRACTOR_IS_CONTRACT_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT_FILE))
#define CONTRACTOR_IS_CONTRACT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT_FILE))
#define CONTRACTOR_CONTRACT_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT_FILE, ContractorContractFileClass))

typedef struct _ContractorContractFile ContractorContractFile;
typedef struct _ContractorContractFileClass ContractorContractFileClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ContractorContractKeyFile {
	GObject parent_instance;
	ContractorContractKeyFilePrivate * priv;
};

struct _ContractorContractKeyFileClass {
	GObjectClass parent_class;
};

struct _ContractorContractKeyFilePrivate {
	gchar* text_domain;
	GKeyFile* keyfile;
};

static gint ContractorContractKeyFile_private_offset;
static gpointer contractor_contract_key_file_parent_class = NULL;

VALA_EXTERN GType contractor_contract_key_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContractKeyFile, g_object_unref)
VALA_EXTERN GType contractor_contract_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContractFile, g_object_unref)
VALA_EXTERN ContractorContractKeyFile* contractor_contract_key_file_new (ContractorContractFile* contract_file,
                                                             GError** error);
VALA_EXTERN ContractorContractKeyFile* contractor_contract_key_file_construct (GType object_type,
                                                                   ContractorContractFile* contract_file,
                                                                   GError** error);
VALA_EXTERN gchar* contractor_contract_file_get_contents (ContractorContractFile* self,
                                              GError** error);
static gchar* contractor_contract_key_file_preprocess_contents (const gchar* contents);
static void contractor_contract_key_file_verify_exec (ContractorContractKeyFile* self,
                                               GError** error);
static gchar* contractor_contract_key_file_get_text_domain (ContractorContractKeyFile* self,
                                                     GError** error);
VALA_EXTERN GAppInfo* contractor_contract_key_file_get_app_info (ContractorContractKeyFile* self,
                                                     GError** error);
VALA_EXTERN gchar* contractor_contract_key_file_get_name (ContractorContractKeyFile* self,
                                              GError** error);
static gchar* contractor_contract_key_file_get_locale_string (ContractorContractKeyFile* self,
                                                       const gchar* key,
                                                       GError** error);
VALA_EXTERN gchar* contractor_contract_key_file_get_description (ContractorContractKeyFile* self,
                                                     GError** error);
VALA_EXTERN gchar* contractor_contract_key_file_get_icon (ContractorContractKeyFile* self,
                                              GError** error);
VALA_EXTERN gchar** contractor_contract_key_file_get_mimetypes (ContractorContractKeyFile* self,
                                                    gint* result_length1,
                                                    GError** error);
VALA_EXTERN gint64 contractor_contract_key_file_get_max_file_size (ContractorContractKeyFile* self,
                                                       GError** error);
static void contractor_contract_key_file_verify_string (const gchar* str,
                                                 const gchar* key,
                                                 GError** error);
VALA_EXTERN gchar* contractor_translations_get_string (const gchar* domain,
                                           const gchar* to_translate);
VALA_EXTERN gboolean contractor_string_is_empty (const gchar* str);
static void contractor_contract_key_file_finalize (GObject * obj);
static GType contractor_contract_key_file_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* CONTRACTOR_CONTRACT_KEY_FILE_SUPPORTED_GETTEXT_DOMAIN_KEYS[3] = {"Gettext-Domain", "X-Ubuntu-Gettext-Domain", "X-GNOME-Gettext-Domain"};

static inline gpointer
contractor_contract_key_file_get_instance_private (ContractorContractKeyFile* self)
{
	return G_STRUCT_MEMBER_P (self, ContractorContractKeyFile_private_offset);
}

/**
     * the constructor to create a ContractKeyFile object which loads the
     * content of the passed ContractFile object and sets up an internally
     * stored KeyFile object to access individual contract fields
     *
     * @param contract_file ContractFile object from which the content should be loaded
     */
ContractorContractKeyFile*
contractor_contract_key_file_construct (GType object_type,
                                        ContractorContractFile* contract_file,
                                        GError** error)
{
	ContractorContractKeyFile * self = NULL;
	gchar* contract_file_contents = NULL;
	gchar* _tmp0_;
	gchar* contents = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GKeyFile* _tmp3_;
	GKeyFile* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GKeyFile* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GAppInfo* _tmp13_;
	GAppInfo* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (contract_file != NULL, NULL);
	self = (ContractorContractKeyFile*) g_object_new (object_type, NULL);
	_tmp0_ = contractor_contract_file_get_contents (contract_file, &_inner_error0_);
	contract_file_contents = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp1_ = contract_file_contents;
	_tmp2_ = contractor_contract_key_file_preprocess_contents (_tmp1_);
	contents = _tmp2_;
	_tmp3_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->keyfile);
	self->priv->keyfile = _tmp3_;
	_tmp4_ = self->priv->keyfile;
	_tmp5_ = contents;
	_tmp6_ = contents;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	g_key_file_load_from_data (_tmp4_, _tmp5_, (gsize) _tmp8_, G_KEY_FILE_NONE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (contents);
		_g_free0 (contract_file_contents);
		_g_object_unref0 (self);
		return NULL;
	}
	contractor_contract_key_file_verify_exec (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (contents);
		_g_free0 (contract_file_contents);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp9_ = self->priv->keyfile;
	g_key_file_set_string (_tmp9_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TYPE, G_KEY_FILE_DESKTOP_TYPE_APPLICATION);
	_tmp11_ = contractor_contract_key_file_get_text_domain (self, &_inner_error0_);
	_tmp10_ = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (contents);
		_g_free0 (contract_file_contents);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp12_ = _tmp10_;
	_tmp10_ = NULL;
	_g_free0 (self->priv->text_domain);
	self->priv->text_domain = _tmp12_;
	_tmp13_ = contractor_contract_key_file_get_app_info (self, &_inner_error0_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp14_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp10_);
		_g_free0 (contents);
		_g_free0 (contract_file_contents);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_free0 (_tmp10_);
	_g_free0 (contents);
	_g_free0 (contract_file_contents);
	return self;
}

ContractorContractKeyFile*
contractor_contract_key_file_new (ContractorContractFile* contract_file,
                                  GError** error)
{
	return contractor_contract_key_file_construct (CONTRACTOR_TYPE_CONTRACT_KEY_FILE, contract_file, error);
}

GAppInfo*
contractor_contract_key_file_get_app_info (ContractorContractKeyFile* self,
                                           GError** error)
{
	GDesktopAppInfo* app_info = NULL;
	GKeyFile* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GError* _inner_error0_ = NULL;
	GAppInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = g_desktop_app_info_new_from_keyfile (_tmp0_);
	app_info = _tmp1_;
	_tmp2_ = app_info;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_NOENT, "%s's file is probably missing.", CONTRACTOR_CONTRACT_KEY_FILE_TRY_EXEC_KEY);
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (app_info);
		return NULL;
	}
	result = (GAppInfo*) app_info;
	return result;
}

/**
     * gets the contracts name from the key file
     *
     * @return the contracts name
     */
gchar*
contractor_contract_key_file_get_name (ContractorContractKeyFile* self,
                                       GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = contractor_contract_key_file_get_locale_string (self, CONTRACTOR_CONTRACT_KEY_FILE_NAME_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

/**
     * gets the contracts description from the key file
     *
     * @return the contracts description
     */
gchar*
contractor_contract_key_file_get_description (ContractorContractKeyFile* self,
                                              GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = contractor_contract_key_file_get_locale_string (self, CONTRACTOR_CONTRACT_KEY_FILE_DESCRIPTION_KEY, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

/**
     * gets the contracts icon from the key file
     *
     * @return the contracts icon, e.g. add-files-to-archive
     */
gchar*
contractor_contract_key_file_get_icon (ContractorContractKeyFile* self,
                                       GError** error)
{
	gchar* _tmp0_ = NULL;
	GKeyFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = g_key_file_get_string (_tmp1_, CONTRACTOR_CONTRACT_KEY_FILE_DESKTOP_GROUP, CONTRACTOR_CONTRACT_KEY_FILE_ICON_KEY, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

/**
     * gets the contracts supported MIME types from the key file
     *
     * @return an array of MIME type strings, e.g. text, image
     */
gchar**
contractor_contract_key_file_get_mimetypes (ContractorContractKeyFile* self,
                                            gint* result_length1,
                                            GError** error)
{
	gchar** _tmp0_ = NULL;
	GKeyFile* _tmp1_;
	gsize _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp0__length1;
	gint __tmp0__size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->keyfile;
	_tmp3_ = g_key_file_get_string_list (_tmp1_, CONTRACTOR_CONTRACT_KEY_FILE_DESKTOP_GROUP, CONTRACTOR_CONTRACT_KEY_FILE_MIMETYPE_KEY, &_tmp2_, &_inner_error0_);
	_tmp0_ = _tmp3_;
	_tmp0__length1 = _tmp2_;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = _tmp0_;
	_tmp4__length1 = _tmp0__length1;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
     * gets the contracts supported maximal file size from the key file
     * the return value can be used directly in GLib
     *
     * @return the maximal file size in bytes as int64
     */
gint64
contractor_contract_key_file_get_max_file_size (ContractorContractKeyFile* self,
                                                GError** error)
{
	gint64 _tmp0_ = 0LL;
	GKeyFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp1_ = self->priv->keyfile;
	_tmp0_ = g_key_file_get_int64 (_tmp1_, CONTRACTOR_CONTRACT_KEY_FILE_DESKTOP_GROUP, CONTRACTOR_CONTRACT_KEY_FILE_MAX_FILE_SIZE_KEY, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp2_ = -1LL;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static void
contractor_contract_key_file_verify_exec (ContractorContractKeyFile* self,
                                          GError** error)
{
	gchar* exec = NULL;
	GKeyFile* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = g_key_file_get_string (_tmp0_, CONTRACTOR_CONTRACT_KEY_FILE_DESKTOP_GROUP, CONTRACTOR_CONTRACT_KEY_FILE_EXEC_KEY, &_inner_error0_);
	exec = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = exec;
	contractor_contract_key_file_verify_string (_tmp2_, CONTRACTOR_CONTRACT_KEY_FILE_EXEC_KEY, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (exec);
		return;
	}
	_g_free0 (exec);
}

static gchar*
contractor_contract_key_file_get_text_domain (ContractorContractKeyFile* self,
                                              GError** error)
{
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		const gchar** domain_key_collection = NULL;
		gint domain_key_collection_length1 = 0;
		gint _domain_key_collection_size_ = 0;
		gint domain_key_it = 0;
		domain_key_collection = CONTRACTOR_CONTRACT_KEY_FILE_SUPPORTED_GETTEXT_DOMAIN_KEYS;
		domain_key_collection_length1 = G_N_ELEMENTS (CONTRACTOR_CONTRACT_KEY_FILE_SUPPORTED_GETTEXT_DOMAIN_KEYS);
		for (domain_key_it = 0; domain_key_it < domain_key_collection_length1; domain_key_it = domain_key_it + 1) {
			const gchar* domain_key = NULL;
			domain_key = domain_key_collection[domain_key_it];
			{
				gboolean _tmp0_ = FALSE;
				GKeyFile* _tmp1_;
				const gchar* _tmp2_;
				_tmp1_ = self->priv->keyfile;
				_tmp2_ = domain_key;
				_tmp0_ = g_key_file_has_key (_tmp1_, CONTRACTOR_CONTRACT_KEY_FILE_DESKTOP_GROUP, _tmp2_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				}
				if (_tmp0_) {
					gchar* _tmp3_ = NULL;
					GKeyFile* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp4_ = self->priv->keyfile;
					_tmp5_ = domain_key;
					_tmp6_ = g_key_file_get_string (_tmp4_, CONTRACTOR_CONTRACT_KEY_FILE_DESKTOP_GROUP, _tmp5_, &_inner_error0_);
					_tmp3_ = _tmp6_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						return NULL;
					}
					_tmp7_ = _tmp3_;
					_tmp3_ = NULL;
					result = _tmp7_;
					_g_free0 (_tmp3_);
					return result;
				}
			}
		}
	}
	_tmp8_ = g_strdup ("");
	result = _tmp8_;
	return result;
}

static gchar*
contractor_contract_key_file_get_locale_string (ContractorContractKeyFile* self,
                                                const gchar* key,
                                                GError** error)
{
	gchar* locale_string = NULL;
	GKeyFile* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->keyfile;
	_tmp1_ = g_key_file_get_locale_string (_tmp0_, CONTRACTOR_CONTRACT_KEY_FILE_DESKTOP_GROUP, key, NULL, &_inner_error0_);
	locale_string = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = locale_string;
	contractor_contract_key_file_verify_string (_tmp2_, key, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (locale_string);
		return NULL;
	}
	_tmp3_ = self->priv->text_domain;
	_tmp4_ = locale_string;
	_tmp5_ = contractor_translations_get_string (_tmp3_, _tmp4_);
	result = _tmp5_;
	_g_free0 (locale_string);
	return result;
}

static void
contractor_contract_key_file_verify_string (const gchar* str,
                                            const gchar* key,
                                            GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (key != NULL);
	if (contractor_string_is_empty (str)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, "%s key is empty.", key);
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
contractor_contract_key_file_preprocess_contents (const gchar* contents)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (contents != NULL, NULL);
	_tmp0_ = string_replace (contents, CONTRACTOR_CONTRACT_KEY_FILE_CONTRACTOR_GROUP, CONTRACTOR_CONTRACT_KEY_FILE_DESKTOP_GROUP);
	result = _tmp0_;
	return result;
}

static void
contractor_contract_key_file_class_init (ContractorContractKeyFileClass * klass,
                                         gpointer klass_data)
{
	contractor_contract_key_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContractorContractKeyFile_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contractor_contract_key_file_finalize;
}

static void
contractor_contract_key_file_instance_init (ContractorContractKeyFile * self,
                                            gpointer klass)
{
	self->priv = contractor_contract_key_file_get_instance_private (self);
}

static void
contractor_contract_key_file_finalize (GObject * obj)
{
	ContractorContractKeyFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTRACTOR_TYPE_CONTRACT_KEY_FILE, ContractorContractKeyFile);
	_g_free0 (self->priv->text_domain);
	_g_key_file_unref0 (self->priv->keyfile);
	G_OBJECT_CLASS (contractor_contract_key_file_parent_class)->finalize (obj);
}

static GType
contractor_contract_key_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContractorContractKeyFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contractor_contract_key_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContractorContractKeyFile), 0, (GInstanceInitFunc) contractor_contract_key_file_instance_init, NULL };
	GType contractor_contract_key_file_type_id;
	contractor_contract_key_file_type_id = g_type_register_static (G_TYPE_OBJECT, "ContractorContractKeyFile", &g_define_type_info, 0);
	ContractorContractKeyFile_private_offset = g_type_add_instance_private (contractor_contract_key_file_type_id, sizeof (ContractorContractKeyFilePrivate));
	return contractor_contract_key_file_type_id;
}

GType
contractor_contract_key_file_get_type (void)
{
	static volatile gsize contractor_contract_key_file_type_id__once = 0;
	if (g_once_init_enter (&contractor_contract_key_file_type_id__once)) {
		GType contractor_contract_key_file_type_id;
		contractor_contract_key_file_type_id = contractor_contract_key_file_get_type_once ();
		g_once_init_leave (&contractor_contract_key_file_type_id__once, contractor_contract_key_file_type_id);
	}
	return contractor_contract_key_file_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

