/* fb2Reader.c generated by valac 0.56.18, the Vala compiler
 * generated from fb2Reader.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and is used for parsing FB2 file formats
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <granite.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>

#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE _ ("Problem in extracting contents of book. Ensure there is a valid eBook " \
"file here: ")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE _ ("Invalid content found. Ensure there is a valid eBook file here: ")
#define BOOKWORM_APP_CONSTANTS_bookworm_id "com.github.babluboy.bookworm"
#define BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION "/tmp/" BOOKWORM_APP_CONSTANTS_bookworm_id "/"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE _ ("Unknown Book")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_FB2_READER (bookworm_app_fb2_reader_get_type ())
#define BOOKWORM_APP_FB2_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_FB2_READER, BookwormAppfb2Reader))
#define BOOKWORM_APP_FB2_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_FB2_READER, BookwormAppfb2ReaderClass))
#define BOOKWORM_APP_IS_FB2_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_FB2_READER))
#define BOOKWORM_APP_IS_FB2_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_FB2_READER))
#define BOOKWORM_APP_FB2_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_FB2_READER, BookwormAppfb2ReaderClass))

typedef struct _BookwormAppfb2Reader BookwormAppfb2Reader;
typedef struct _BookwormAppfb2ReaderClass BookwormAppfb2ReaderClass;
typedef struct _BookwormAppfb2ReaderPrivate BookwormAppfb2ReaderPrivate;

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_XML_DATA (bookworm_app_xml_data_get_type ())
#define BOOKWORM_APP_XML_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_XML_DATA, BookwormAppXMLData))
#define BOOKWORM_APP_XML_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_XML_DATA, BookwormAppXMLDataClass))
#define BOOKWORM_APP_IS_XML_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_XML_DATA))
#define BOOKWORM_APP_IS_XML_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_XML_DATA))
#define BOOKWORM_APP_XML_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_XML_DATA, BookwormAppXMLDataClass))

typedef struct _BookwormAppXMLData BookwormAppXMLData;
typedef struct _BookwormAppXMLDataClass BookwormAppXMLDataClass;
typedef struct _BookwormAppXMLDataPrivate BookwormAppXMLDataPrivate;
#define _bookworm_app_xml_data_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_xml_data_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_XML_PARSER (bookworm_app_xml_parser_get_type ())
#define BOOKWORM_APP_XML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_XML_PARSER, BookwormAppXmlParser))
#define BOOKWORM_APP_XML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_XML_PARSER, BookwormAppXmlParserClass))
#define BOOKWORM_APP_IS_XML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_XML_PARSER))
#define BOOKWORM_APP_IS_XML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_XML_PARSER))
#define BOOKWORM_APP_XML_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_XML_PARSER, BookwormAppXmlParserClass))

typedef struct _BookwormAppXmlParser BookwormAppXmlParser;
typedef struct _BookwormAppXmlParserClass BookwormAppXmlParserClass;
#define _bookworm_app_xml_parser_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_xml_parser_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BookwormAppParamSpecfb2Reader BookwormAppParamSpecfb2Reader;

struct _BookwormAppfb2Reader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppfb2ReaderPrivate * priv;
};

struct _BookwormAppfb2ReaderClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppfb2Reader *self);
};

struct _BookwormAppXMLData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppXMLDataPrivate * priv;
	gboolean shouldExtractionStart;
	gboolean useLocalTagName;
	gboolean isContainerTagMatched;
	gchar* currentTagName;
	GString* charBuffer;
	gchar* containerTagName;
	gchar* inputTagName;
	gchar* inputAttributeName;
	gboolean isXMLExtraction;
	gboolean enforceAttributeData;
	GeeArrayList* extractedTagValues;
	GeeArrayList* extractedTagAttributes;
};

struct _BookwormAppXMLDataClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppXMLData *self);
};

struct _BookwormAppParamSpecfb2Reader {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_fb2_reader_parent_class = NULL;
VALA_EXTERN gchar* bookworm_app_fb2_reader_fb2_location;
gchar* bookworm_app_fb2_reader_fb2_location = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_bookworm_settings;
VALA_EXTERN gchar* bookworm_app_bookworm_bookworm_config_path;

VALA_EXTERN gpointer bookworm_app_fb2_reader_ref (gpointer instance);
VALA_EXTERN void bookworm_app_fb2_reader_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_fb2_reader (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_fb2_reader (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_fb2_reader (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_fb2_reader (const GValue* value);
VALA_EXTERN GType bookworm_app_fb2_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppfb2Reader, bookworm_app_fb2_reader_unref)
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN BookwormAppBook* bookworm_app_fb2_reader_parseFictionBook (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIsBookParsed (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_fb2_reader_extractEBook (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_book_getBookExtractionLocation (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setIsBookParsed (BookwormAppBook* self,
                                        gboolean isParsed);
VALA_EXTERN void bookworm_app_book_setParsingIssue (BookwormAppBook* self,
                                        const gchar* aParsingIssue);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIsBookCoverImagePresent (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_fb2_reader_setCoverImage (BookwormAppBook* aBook);
VALA_EXTERN BookwormAppBook* bookworm_app_fb2_reader_setBookMetaData (BookwormAppBook* aBook);
VALA_EXTERN gboolean bookworm_app_fb2_reader_isFB2Format (const gchar* eBookLocation);
VALA_EXTERN gpointer bookworm_app_xml_data_ref (gpointer instance);
VALA_EXTERN void bookworm_app_xml_data_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_xml_data (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_xml_data (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_xml_data (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_xml_data (const GValue* value);
VALA_EXTERN GType bookworm_app_xml_data_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppXMLData, bookworm_app_xml_data_unref)
VALA_EXTERN BookwormAppXMLData* bookworm_app_xml_data_new (void);
VALA_EXTERN BookwormAppXMLData* bookworm_app_xml_data_construct (GType object_type);
VALA_EXTERN gpointer bookworm_app_xml_parser_ref (gpointer instance);
VALA_EXTERN void bookworm_app_xml_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_xml_parser (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_xml_parser (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_xml_parser (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_xml_parser (const GValue* value);
VALA_EXTERN GType bookworm_app_xml_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppXmlParser, bookworm_app_xml_parser_unref)
VALA_EXTERN BookwormAppXmlParser* bookworm_app_xml_parser_new (void);
VALA_EXTERN BookwormAppXmlParser* bookworm_app_xml_parser_construct (GType object_type);
VALA_EXTERN GeeArrayList* bookworm_app_xml_parser_extractDataFromXML (BookwormAppXmlParser* self,
                                                          const gchar* path,
                                                          GeeArrayList* inputDataList,
                                                          gboolean isXMLExtraction);
VALA_EXTERN gchar* bookworm_app_book_to_string (BookwormAppBook* self);
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN gboolean bookworm_app_settings_get_is_local_storage_enabled (BookwormAppSettings* self);
VALA_EXTERN gchar* bookworm_app_utils_fileOperations (const gchar* operation,
                                          const gchar* path,
                                          const gchar* filename,
                                          const gchar* contents);
VALA_EXTERN void bookworm_app_book_setBookExtractionLocation (BookwormAppBook* self,
                                                  const gchar* aBookExtractionLocation);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
VALA_EXTERN gchar* bookworm_app_utils_getFullPathFromFilename (const gchar* rootDirectoryToSearch,
                                                   const gchar* fileName);
VALA_EXTERN void bookworm_app_book_setBookContentList (BookwormAppBook* self,
                                           const gchar* contentList);
VALA_EXTERN void bookworm_app_book_setBaseLocationOfContents (BookwormAppBook* self,
                                                  const gchar* aBaseLocationOfContents);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
VALA_EXTERN gchar* bookworm_app_utils_decodeHTMLChars (const gchar* inputString);
VALA_EXTERN void bookworm_app_book_setIsBookCoverImagePresent (BookwormAppBook* self,
                                                   gboolean isABookCoverImagePresent);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_setBookCoverImage (BookwormAppBook* aBook,
                                                       const gchar* bookCoverImageLocation);
VALA_EXTERN void bookworm_app_book_setBookAuthor (BookwormAppBook* self,
                                      const gchar* aBookAuthor);
VALA_EXTERN void bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                     const gchar* aBookTitle);
VALA_EXTERN gchar* bookworm_app_book_getBookAuthor (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
VALA_EXTERN BookwormAppfb2Reader* bookworm_app_fb2_reader_new (void);
VALA_EXTERN BookwormAppfb2Reader* bookworm_app_fb2_reader_construct (GType object_type);
static void bookworm_app_fb2_reader_finalize (BookwormAppfb2Reader * obj);
static GType bookworm_app_fb2_reader_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_FILE_CHOOSER_FILTER_IMAGES[5];

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 32 "../src/fb2Reader.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 291 "fb2Reader.c"
}

BookwormAppBook*
bookworm_app_fb2_reader_parseFictionBook (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BookwormAppBook* _tmp24_;
	BookwormAppBook* result;
#line 26 "../src/fb2Reader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 27 "../src/fb2Reader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 27 "../src/fb2Reader.vala"
	_tmp1_ = _tmp0_;
#line 27 "../src/fb2Reader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:parseFictionBook] book.location=", _tmp1_, NULL);
#line 27 "../src/fb2Reader.vala"
	_tmp3_ = _tmp2_;
#line 27 "../src/fb2Reader.vala"
	g_info ("fb2Reader.vala:27: %s", _tmp3_);
#line 27 "../src/fb2Reader.vala"
	_g_free0 (_tmp3_);
#line 27 "../src/fb2Reader.vala"
	_g_free0 (_tmp1_);
#line 29 "../src/fb2Reader.vala"
	if (!bookworm_app_book_getIsBookParsed (aBook)) {
#line 321 "fb2Reader.c"
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		BookwormAppBook* _tmp8_;
		BookwormAppBook* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gboolean _tmp12_;
		GeeArrayList* _tmp14_;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gboolean _tmp18_;
		BookwormAppBook* _tmp22_;
		BookwormAppBook* _tmp23_;
#line 30 "../src/fb2Reader.vala"
		_tmp4_ = bookworm_app_book_getBookLocation (aBook);
#line 30 "../src/fb2Reader.vala"
		_tmp5_ = _tmp4_;
#line 30 "../src/fb2Reader.vala"
		_tmp6_ = g_strconcat ("Starting to parse FB2 Book located at:", _tmp5_, NULL);
#line 30 "../src/fb2Reader.vala"
		_tmp7_ = _tmp6_;
#line 30 "../src/fb2Reader.vala"
		g_debug ("fb2Reader.vala:30: %s", _tmp7_);
#line 30 "../src/fb2Reader.vala"
		_g_free0 (_tmp7_);
#line 30 "../src/fb2Reader.vala"
		_g_free0 (_tmp5_);
#line 32 "../src/fb2Reader.vala"
		_tmp8_ = _bookworm_app_book_ref0 (aBook);
#line 32 "../src/fb2Reader.vala"
		_tmp9_ = bookworm_app_fb2_reader_extractEBook (_tmp8_);
#line 32 "../src/fb2Reader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 32 "../src/fb2Reader.vala"
		aBook = _tmp9_;
#line 33 "../src/fb2Reader.vala"
		_tmp10_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 33 "../src/fb2Reader.vala"
		_tmp11_ = _tmp10_;
#line 33 "../src/fb2Reader.vala"
		_tmp12_ = g_strcmp0 ("false", _tmp11_) == 0;
#line 33 "../src/fb2Reader.vala"
		_g_free0 (_tmp11_);
#line 33 "../src/fb2Reader.vala"
		if (_tmp12_) {
#line 370 "fb2Reader.c"
			BookwormAppBook* _tmp13_;
#line 34 "../src/fb2Reader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 35 "../src/fb2Reader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 36 "../src/fb2Reader.vala"
			_tmp13_ = _bookworm_app_book_ref0 (aBook);
#line 36 "../src/fb2Reader.vala"
			result = _tmp13_;
#line 36 "../src/fb2Reader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 36 "../src/fb2Reader.vala"
			return result;
#line 384 "fb2Reader.c"
		}
#line 40 "../src/fb2Reader.vala"
		_tmp14_ = bookworm_app_book_getBookContentList (aBook);
#line 40 "../src/fb2Reader.vala"
		_tmp15_ = _tmp14_;
#line 40 "../src/fb2Reader.vala"
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
#line 40 "../src/fb2Reader.vala"
		_tmp17_ = _tmp16_;
#line 40 "../src/fb2Reader.vala"
		_tmp18_ = _tmp17_ < 1;
#line 40 "../src/fb2Reader.vala"
		_g_object_unref0 (_tmp15_);
#line 40 "../src/fb2Reader.vala"
		if (_tmp18_) {
#line 400 "fb2Reader.c"
			BookwormAppBook* _tmp19_;
#line 41 "../src/fb2Reader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 42 "../src/fb2Reader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE);
#line 43 "../src/fb2Reader.vala"
			_tmp19_ = _bookworm_app_book_ref0 (aBook);
#line 43 "../src/fb2Reader.vala"
			result = _tmp19_;
#line 43 "../src/fb2Reader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 43 "../src/fb2Reader.vala"
			return result;
#line 414 "fb2Reader.c"
		}
#line 47 "../src/fb2Reader.vala"
		if (!bookworm_app_book_getIsBookCoverImagePresent (aBook)) {
#line 418 "fb2Reader.c"
			BookwormAppBook* _tmp20_;
			BookwormAppBook* _tmp21_;
#line 48 "../src/fb2Reader.vala"
			_tmp20_ = _bookworm_app_book_ref0 (aBook);
#line 48 "../src/fb2Reader.vala"
			_tmp21_ = bookworm_app_fb2_reader_setCoverImage (_tmp20_);
#line 48 "../src/fb2Reader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 48 "../src/fb2Reader.vala"
			aBook = _tmp21_;
#line 429 "fb2Reader.c"
		}
#line 52 "../src/fb2Reader.vala"
		_tmp22_ = _bookworm_app_book_ref0 (aBook);
#line 52 "../src/fb2Reader.vala"
		_tmp23_ = bookworm_app_fb2_reader_setBookMetaData (_tmp22_);
#line 52 "../src/fb2Reader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 52 "../src/fb2Reader.vala"
		aBook = _tmp23_;
#line 54 "../src/fb2Reader.vala"
		bookworm_app_book_setIsBookParsed (aBook, TRUE);
#line 441 "fb2Reader.c"
	}
#line 57 "../src/fb2Reader.vala"
	g_info ("fb2Reader.vala:57: [END] [FUNCTION:parseEPubBook]");
#line 58 "../src/fb2Reader.vala"
	_tmp24_ = _bookworm_app_book_ref0 (aBook);
#line 58 "../src/fb2Reader.vala"
	result = _tmp24_;
#line 58 "../src/fb2Reader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 58 "../src/fb2Reader.vala"
	return result;
#line 453 "fb2Reader.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 75 "../src/fb2Reader.vala"
	return self ? g_object_ref (self) : NULL;
#line 461 "fb2Reader.c"
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
#line 37 "glib-2.0.vapi"
	if (self) {
#line 470 "fb2Reader.c"
		gchar* _tmp0_;
#line 38 "glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "glib-2.0.vapi"
		result = _tmp0_;
#line 38 "glib-2.0.vapi"
		return result;
#line 478 "fb2Reader.c"
	} else {
		gchar* _tmp1_;
#line 40 "glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "glib-2.0.vapi"
		result = _tmp1_;
#line 40 "glib-2.0.vapi"
		return result;
#line 487 "fb2Reader.c"
	}
}

gboolean
bookworm_app_fb2_reader_isFB2Format (const gchar* eBookLocation)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean fb2Format = FALSE;
	GeeArrayList* inputDataList = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	BookwormAppXMLData* _tmp7_ = NULL;
	BookwormAppXMLData* _tmp8_;
	BookwormAppXmlParser* thisParser = NULL;
	BookwormAppXmlParser* _tmp9_;
	GeeArrayList* extractedDataList = NULL;
	GeeArrayList* _tmp10_;
	BookwormAppXmlParser* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean result;
#line 61 "../src/fb2Reader.vala"
	g_return_val_if_fail (eBookLocation != NULL, FALSE);
#line 62 "../src/fb2Reader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:isFB2Format] extractionLocation=", eBookLocation, NULL);
#line 62 "../src/fb2Reader.vala"
	_tmp1_ = _tmp0_;
#line 62 "../src/fb2Reader.vala"
	g_info ("fb2Reader.vala:62: %s", _tmp1_);
#line 62 "../src/fb2Reader.vala"
	_g_free0 (_tmp1_);
#line 63 "../src/fb2Reader.vala"
	fb2Format = FALSE;
#line 64 "../src/fb2Reader.vala"
	_tmp2_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 64 "../src/fb2Reader.vala"
	inputDataList = _tmp2_;
#line 65 "../src/fb2Reader.vala"
	_tmp3_ = inputDataList;
#line 65 "../src/fb2Reader.vala"
	_tmp4_ = g_strdup ("FictionBook");
#line 65 "../src/fb2Reader.vala"
	_tmp5_ = g_strdup ("body");
#line 65 "../src/fb2Reader.vala"
	_tmp6_ = g_strdup ("");
#line 65 "../src/fb2Reader.vala"
	_tmp7_ = bookworm_app_xml_data_new ();
#line 65 "../src/fb2Reader.vala"
	_g_free0 (_tmp7_->containerTagName);
#line 65 "../src/fb2Reader.vala"
	_tmp7_->containerTagName = _tmp4_;
#line 65 "../src/fb2Reader.vala"
	_g_free0 (_tmp7_->inputTagName);
#line 65 "../src/fb2Reader.vala"
	_tmp7_->inputTagName = _tmp5_;
#line 65 "../src/fb2Reader.vala"
	_g_free0 (_tmp7_->inputAttributeName);
#line 65 "../src/fb2Reader.vala"
	_tmp7_->inputAttributeName = _tmp6_;
#line 65 "../src/fb2Reader.vala"
	_tmp7_->isXMLExtraction = TRUE;
#line 65 "../src/fb2Reader.vala"
	_tmp8_ = _tmp7_;
#line 65 "../src/fb2Reader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp8_);
#line 65 "../src/fb2Reader.vala"
	_bookworm_app_xml_data_unref0 (_tmp8_);
#line 73 "../src/fb2Reader.vala"
	_tmp9_ = bookworm_app_xml_parser_new ();
#line 73 "../src/fb2Reader.vala"
	thisParser = _tmp9_;
#line 74 "../src/fb2Reader.vala"
	_tmp10_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 74 "../src/fb2Reader.vala"
	extractedDataList = _tmp10_;
#line 75 "../src/fb2Reader.vala"
	_tmp11_ = thisParser;
#line 75 "../src/fb2Reader.vala"
	_tmp12_ = inputDataList;
#line 75 "../src/fb2Reader.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 75 "../src/fb2Reader.vala"
	_tmp14_ = bookworm_app_xml_parser_extractDataFromXML (_tmp11_, eBookLocation, _tmp13_, FALSE);
#line 75 "../src/fb2Reader.vala"
	_g_object_unref0 (extractedDataList);
#line 75 "../src/fb2Reader.vala"
	extractedDataList = _tmp14_;
#line 76 "../src/fb2Reader.vala"
	_tmp15_ = extractedDataList;
#line 76 "../src/fb2Reader.vala"
	_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
#line 76 "../src/fb2Reader.vala"
	_tmp17_ = _tmp16_;
#line 76 "../src/fb2Reader.vala"
	if (_tmp17_ > 0) {
#line 77 "../src/fb2Reader.vala"
		fb2Format = TRUE;
#line 597 "fb2Reader.c"
	}
#line 79 "../src/fb2Reader.vala"
	if (!fb2Format) {
#line 601 "fb2Reader.c"
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
#line 80 "../src/fb2Reader.vala"
		_tmp18_ = g_strconcat ("Error while checking format of FB2 file [", eBookLocation, NULL);
#line 80 "../src/fb2Reader.vala"
		_tmp19_ = _tmp18_;
#line 80 "../src/fb2Reader.vala"
		_tmp20_ = g_strconcat (_tmp19_, "], tag name \"FictionBook\" not found", NULL);
#line 80 "../src/fb2Reader.vala"
		_tmp21_ = _tmp20_;
#line 80 "../src/fb2Reader.vala"
		g_warning ("fb2Reader.vala:80: %s", _tmp21_);
#line 80 "../src/fb2Reader.vala"
		_g_free0 (_tmp21_);
#line 80 "../src/fb2Reader.vala"
		_g_free0 (_tmp19_);
#line 620 "fb2Reader.c"
	}
#line 83 "../src/fb2Reader.vala"
	_tmp22_ = bool_to_string (fb2Format);
#line 83 "../src/fb2Reader.vala"
	_tmp23_ = _tmp22_;
#line 83 "../src/fb2Reader.vala"
	_tmp24_ = g_strconcat ("[END] [FUNCTION:isFB2Format] fb2Format check:", _tmp23_, NULL);
#line 83 "../src/fb2Reader.vala"
	_tmp25_ = _tmp24_;
#line 83 "../src/fb2Reader.vala"
	g_info ("fb2Reader.vala:83: %s", _tmp25_);
#line 83 "../src/fb2Reader.vala"
	_g_free0 (_tmp25_);
#line 83 "../src/fb2Reader.vala"
	_g_free0 (_tmp23_);
#line 84 "../src/fb2Reader.vala"
	result = fb2Format;
#line 84 "../src/fb2Reader.vala"
	_g_object_unref0 (extractedDataList);
#line 84 "../src/fb2Reader.vala"
	_bookworm_app_xml_parser_unref0 (thisParser);
#line 84 "../src/fb2Reader.vala"
	_g_object_unref0 (inputDataList);
#line 84 "../src/fb2Reader.vala"
	return result;
#line 646 "fb2Reader.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 670 "fb2Reader.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 678 "fb2Reader.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 684 "fb2Reader.c"
	}
}

BookwormAppBook*
bookworm_app_fb2_reader_extractEBook (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* extractionLocation = NULL;
	gchar* _tmp4_;
	gchar* status = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	BookwormAppSettings* _tmp7_;
	BookwormAppSettings* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gboolean _tmp47_;
	const gchar* _tmp64_;
	GeeArrayList* inputDataList = NULL;
	GeeArrayList* _tmp66_;
	GeeArrayList* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	BookwormAppXMLData* _tmp71_ = NULL;
	BookwormAppXMLData* _tmp72_;
	BookwormAppXmlParser* thisParser = NULL;
	BookwormAppXmlParser* _tmp73_;
	GeeArrayList* extractedDataList = NULL;
	GeeArrayList* _tmp74_;
	BookwormAppXmlParser* _tmp75_;
	const gchar* _tmp76_;
	GeeArrayList* _tmp77_;
	GeeArrayList* _tmp78_;
	GeeArrayList* _tmp79_;
	GeeArrayList* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gint filecount = 0;
	gchar* baseLocationOfContents = NULL;
	const gchar* _tmp140_;
	gchar* _tmp141_;
	const gchar* _tmp142_;
	const gchar* _tmp143_;
	gchar* _tmp144_;
	gchar* _tmp145_;
	GeeArrayList* _tmp146_;
	GeeArrayList* _tmp147_;
	gint _tmp148_;
	gint _tmp149_;
	gboolean _tmp150_;
	gchar* _tmp157_;
	gchar* _tmp158_;
	gchar* _tmp159_;
	gchar* _tmp160_;
	BookwormAppBook* _tmp161_;
	BookwormAppBook* result;
#line 87 "../src/fb2Reader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 88 "../src/fb2Reader.vala"
	_tmp0_ = bookworm_app_book_to_string (aBook);
#line 88 "../src/fb2Reader.vala"
	_tmp1_ = _tmp0_;
#line 88 "../src/fb2Reader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:extractEBook] : ", _tmp1_, NULL);
#line 88 "../src/fb2Reader.vala"
	_tmp3_ = _tmp2_;
#line 88 "../src/fb2Reader.vala"
	g_info ("fb2Reader.vala:88: %s", _tmp3_);
#line 88 "../src/fb2Reader.vala"
	_g_free0 (_tmp3_);
#line 88 "../src/fb2Reader.vala"
	_g_free0 (_tmp1_);
#line 89 "../src/fb2Reader.vala"
	_tmp4_ = g_strdup ("false");
#line 89 "../src/fb2Reader.vala"
	extractionLocation = _tmp4_;
#line 90 "../src/fb2Reader.vala"
	_tmp5_ = g_strdup ("false");
#line 90 "../src/fb2Reader.vala"
	status = _tmp5_;
#line 92 "../src/fb2Reader.vala"
	_tmp6_ = bookworm_app_book_getBookLocation (aBook);
#line 92 "../src/fb2Reader.vala"
	_g_free0 (bookworm_app_fb2_reader_fb2_location);
#line 92 "../src/fb2Reader.vala"
	bookworm_app_fb2_reader_fb2_location = _tmp6_;
#line 94 "../src/fb2Reader.vala"
	_tmp7_ = bookworm_app_bookworm_settings;
#line 94 "../src/fb2Reader.vala"
	if (_tmp7_ == NULL) {
#line 797 "fb2Reader.c"
		BookwormAppSettings* _tmp8_;
#line 95 "../src/fb2Reader.vala"
		_tmp8_ = bookworm_app_settings_get_instance ();
#line 95 "../src/fb2Reader.vala"
		_g_object_unref0 (bookworm_app_bookworm_settings);
#line 95 "../src/fb2Reader.vala"
		bookworm_app_bookworm_settings = _tmp8_;
#line 805 "fb2Reader.c"
	}
#line 97 "../src/fb2Reader.vala"
	_tmp9_ = bookworm_app_bookworm_settings;
#line 97 "../src/fb2Reader.vala"
	_tmp10_ = bookworm_app_settings_get_is_local_storage_enabled (_tmp9_);
#line 97 "../src/fb2Reader.vala"
	_tmp11_ = _tmp10_;
#line 97 "../src/fb2Reader.vala"
	if (_tmp11_) {
#line 815 "fb2Reader.c"
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
#line 98 "../src/fb2Reader.vala"
		_tmp12_ = bookworm_app_bookworm_bookworm_config_path;
#line 98 "../src/fb2Reader.vala"
		_tmp13_ = g_strconcat (_tmp12_, "/books/", NULL);
#line 98 "../src/fb2Reader.vala"
		_tmp14_ = _tmp13_;
#line 98 "../src/fb2Reader.vala"
		_tmp15_ = bookworm_app_fb2_reader_fb2_location;
#line 98 "../src/fb2Reader.vala"
		_tmp16_ = g_file_new_for_path (_tmp15_);
#line 98 "../src/fb2Reader.vala"
		_tmp17_ = _tmp16_;
#line 98 "../src/fb2Reader.vala"
		_tmp18_ = g_file_get_basename (_tmp17_);
#line 98 "../src/fb2Reader.vala"
		_tmp19_ = _tmp18_;
#line 98 "../src/fb2Reader.vala"
		_tmp20_ = g_strconcat (_tmp14_, _tmp19_, NULL);
#line 98 "../src/fb2Reader.vala"
		_g_free0 (extractionLocation);
#line 98 "../src/fb2Reader.vala"
		extractionLocation = _tmp20_;
#line 98 "../src/fb2Reader.vala"
		_g_free0 (_tmp19_);
#line 98 "../src/fb2Reader.vala"
		_g_object_unref0 (_tmp17_);
#line 98 "../src/fb2Reader.vala"
		_g_free0 (_tmp14_);
#line 853 "fb2Reader.c"
	} else {
		const gchar* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
#line 102 "../src/fb2Reader.vala"
		_tmp21_ = bookworm_app_fb2_reader_fb2_location;
#line 102 "../src/fb2Reader.vala"
		_tmp22_ = g_file_new_for_path (_tmp21_);
#line 102 "../src/fb2Reader.vala"
		_tmp23_ = _tmp22_;
#line 102 "../src/fb2Reader.vala"
		_tmp24_ = g_file_get_basename (_tmp23_);
#line 102 "../src/fb2Reader.vala"
		_tmp25_ = _tmp24_;
#line 102 "../src/fb2Reader.vala"
		_tmp26_ = g_strconcat (BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION, _tmp25_, NULL);
#line 102 "../src/fb2Reader.vala"
		_g_free0 (extractionLocation);
#line 102 "../src/fb2Reader.vala"
		extractionLocation = _tmp26_;
#line 102 "../src/fb2Reader.vala"
		_g_free0 (_tmp25_);
#line 102 "../src/fb2Reader.vala"
		_g_object_unref0 (_tmp23_);
#line 881 "fb2Reader.c"
	}
#line 105 "../src/fb2Reader.vala"
	_tmp27_ = extractionLocation;
#line 105 "../src/fb2Reader.vala"
	_tmp28_ = g_strconcat ("Based on caching preference, the extraction location determined as:", _tmp27_, NULL);
#line 105 "../src/fb2Reader.vala"
	_tmp29_ = _tmp28_;
#line 105 "../src/fb2Reader.vala"
	g_debug ("fb2Reader.vala:105: %s", _tmp29_);
#line 105 "../src/fb2Reader.vala"
	_g_free0 (_tmp29_);
#line 107 "../src/fb2Reader.vala"
	_tmp30_ = extractionLocation;
#line 107 "../src/fb2Reader.vala"
	_tmp31_ = bookworm_app_utils_fileOperations ("CREATEDIR", _tmp30_, "", "");
#line 107 "../src/fb2Reader.vala"
	_tmp32_ = _tmp31_;
#line 107 "../src/fb2Reader.vala"
	_g_free0 (_tmp32_);
#line 108 "../src/fb2Reader.vala"
	_tmp33_ = extractionLocation;
#line 108 "../src/fb2Reader.vala"
	_tmp34_ = g_strconcat ("Directory created for extraction location:", _tmp33_, NULL);
#line 108 "../src/fb2Reader.vala"
	_tmp35_ = _tmp34_;
#line 108 "../src/fb2Reader.vala"
	g_debug ("fb2Reader.vala:108: %s", _tmp35_);
#line 108 "../src/fb2Reader.vala"
	_g_free0 (_tmp35_);
#line 109 "../src/fb2Reader.vala"
	_tmp36_ = extractionLocation;
#line 109 "../src/fb2Reader.vala"
	bookworm_app_book_setBookExtractionLocation (aBook, _tmp36_);
#line 110 "../src/fb2Reader.vala"
	_tmp37_ = extractionLocation;
#line 110 "../src/fb2Reader.vala"
	if (g_strcmp0 ("false", _tmp37_) == 0) {
#line 919 "fb2Reader.c"
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		BookwormAppBook* _tmp43_;
#line 111 "../src/fb2Reader.vala"
		_tmp38_ = bookworm_app_fb2_reader_fb2_location;
#line 111 "../src/fb2Reader.vala"
		_tmp39_ = g_strconcat ("Failure in determining extraction location for FB2 file [", _tmp38_, NULL);
#line 111 "../src/fb2Reader.vala"
		_tmp40_ = _tmp39_;
#line 111 "../src/fb2Reader.vala"
		_tmp41_ = g_strconcat (_tmp40_, "]", NULL);
#line 111 "../src/fb2Reader.vala"
		_tmp42_ = _tmp41_;
#line 111 "../src/fb2Reader.vala"
		g_warning ("fb2Reader.vala:111: %s", _tmp42_);
#line 111 "../src/fb2Reader.vala"
		_g_free0 (_tmp42_);
#line 111 "../src/fb2Reader.vala"
		_g_free0 (_tmp40_);
#line 112 "../src/fb2Reader.vala"
		bookworm_app_book_setBookExtractionLocation (aBook, "false");
#line 113 "../src/fb2Reader.vala"
		_tmp43_ = _bookworm_app_book_ref0 (aBook);
#line 113 "../src/fb2Reader.vala"
		result = _tmp43_;
#line 113 "../src/fb2Reader.vala"
		_g_free0 (status);
#line 113 "../src/fb2Reader.vala"
		_g_free0 (extractionLocation);
#line 113 "../src/fb2Reader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 113 "../src/fb2Reader.vala"
		return result;
#line 956 "fb2Reader.c"
	}
#line 117 "../src/fb2Reader.vala"
	_tmp44_ = bookworm_app_fb2_reader_fb2_location;
#line 117 "../src/fb2Reader.vala"
	_tmp45_ = g_utf8_strup (_tmp44_, (gssize) -1);
#line 117 "../src/fb2Reader.vala"
	_tmp46_ = _tmp45_;
#line 117 "../src/fb2Reader.vala"
	_tmp47_ = string_last_index_of (_tmp46_, ".FB2.ZIP", 0) != -1;
#line 117 "../src/fb2Reader.vala"
	_g_free0 (_tmp46_);
#line 117 "../src/fb2Reader.vala"
	if (_tmp47_) {
#line 970 "fb2Reader.c"
		gchar* unzip_status = NULL;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		const gchar* _tmp60_;
#line 119 "../src/fb2Reader.vala"
		_tmp48_ = bookworm_app_fb2_reader_fb2_location;
#line 119 "../src/fb2Reader.vala"
		_tmp49_ = g_strconcat ("unzip -o \"", _tmp48_, NULL);
#line 119 "../src/fb2Reader.vala"
		_tmp50_ = _tmp49_;
#line 119 "../src/fb2Reader.vala"
		_tmp51_ = g_strconcat (_tmp50_, "\" -d \"", NULL);
#line 119 "../src/fb2Reader.vala"
		_tmp52_ = _tmp51_;
#line 119 "../src/fb2Reader.vala"
		_tmp53_ = extractionLocation;
#line 119 "../src/fb2Reader.vala"
		_tmp54_ = g_strconcat (_tmp52_, _tmp53_, NULL);
#line 119 "../src/fb2Reader.vala"
		_tmp55_ = _tmp54_;
#line 119 "../src/fb2Reader.vala"
		_tmp56_ = g_strconcat (_tmp55_, "\"", NULL);
#line 119 "../src/fb2Reader.vala"
		_tmp57_ = _tmp56_;
#line 119 "../src/fb2Reader.vala"
		_tmp58_ = bookworm_app_utils_execute_sync_command (_tmp57_);
#line 119 "../src/fb2Reader.vala"
		_tmp59_ = _tmp58_;
#line 119 "../src/fb2Reader.vala"
		_g_free0 (_tmp57_);
#line 119 "../src/fb2Reader.vala"
		_g_free0 (_tmp55_);
#line 119 "../src/fb2Reader.vala"
		_g_free0 (_tmp52_);
#line 119 "../src/fb2Reader.vala"
		_g_free0 (_tmp50_);
#line 119 "../src/fb2Reader.vala"
		unzip_status = _tmp59_;
#line 122 "../src/fb2Reader.vala"
		_tmp60_ = unzip_status;
#line 122 "../src/fb2Reader.vala"
		if (g_strcmp0 ("false", _tmp60_) == 0) {
#line 1023 "fb2Reader.c"
			BookwormAppBook* _tmp61_;
#line 124 "../src/fb2Reader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 125 "../src/fb2Reader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE);
#line 126 "../src/fb2Reader.vala"
			_tmp61_ = _bookworm_app_book_ref0 (aBook);
#line 126 "../src/fb2Reader.vala"
			result = _tmp61_;
#line 126 "../src/fb2Reader.vala"
			_g_free0 (unzip_status);
#line 126 "../src/fb2Reader.vala"
			_g_free0 (status);
#line 126 "../src/fb2Reader.vala"
			_g_free0 (extractionLocation);
#line 126 "../src/fb2Reader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 126 "../src/fb2Reader.vala"
			return result;
#line 1043 "fb2Reader.c"
		} else {
			const gchar* _tmp62_;
			gchar* _tmp63_;
#line 129 "../src/fb2Reader.vala"
			_tmp62_ = extractionLocation;
#line 129 "../src/fb2Reader.vala"
			_tmp63_ = bookworm_app_utils_getFullPathFromFilename (_tmp62_, "*.fb2");
#line 129 "../src/fb2Reader.vala"
			_g_free0 (bookworm_app_fb2_reader_fb2_location);
#line 129 "../src/fb2Reader.vala"
			bookworm_app_fb2_reader_fb2_location = _tmp63_;
#line 1055 "fb2Reader.c"
		}
#line 117 "../src/fb2Reader.vala"
		_g_free0 (unzip_status);
#line 1059 "fb2Reader.c"
	}
#line 134 "../src/fb2Reader.vala"
	_tmp64_ = bookworm_app_fb2_reader_fb2_location;
#line 134 "../src/fb2Reader.vala"
	if (!bookworm_app_fb2_reader_isFB2Format (_tmp64_)) {
#line 1065 "fb2Reader.c"
		BookwormAppBook* _tmp65_;
#line 135 "../src/fb2Reader.vala"
		bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 136 "../src/fb2Reader.vala"
		bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE);
#line 137 "../src/fb2Reader.vala"
		_tmp65_ = _bookworm_app_book_ref0 (aBook);
#line 137 "../src/fb2Reader.vala"
		result = _tmp65_;
#line 137 "../src/fb2Reader.vala"
		_g_free0 (status);
#line 137 "../src/fb2Reader.vala"
		_g_free0 (extractionLocation);
#line 137 "../src/fb2Reader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 137 "../src/fb2Reader.vala"
		return result;
#line 1083 "fb2Reader.c"
	}
#line 141 "../src/fb2Reader.vala"
	_tmp66_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 141 "../src/fb2Reader.vala"
	inputDataList = _tmp66_;
#line 142 "../src/fb2Reader.vala"
	_tmp67_ = inputDataList;
#line 142 "../src/fb2Reader.vala"
	_tmp68_ = g_strdup ("body");
#line 142 "../src/fb2Reader.vala"
	_tmp69_ = g_strdup ("section");
#line 142 "../src/fb2Reader.vala"
	_tmp70_ = g_strdup ("");
#line 142 "../src/fb2Reader.vala"
	_tmp71_ = bookworm_app_xml_data_new ();
#line 142 "../src/fb2Reader.vala"
	_g_free0 (_tmp71_->containerTagName);
#line 142 "../src/fb2Reader.vala"
	_tmp71_->containerTagName = _tmp68_;
#line 142 "../src/fb2Reader.vala"
	_g_free0 (_tmp71_->inputTagName);
#line 142 "../src/fb2Reader.vala"
	_tmp71_->inputTagName = _tmp69_;
#line 142 "../src/fb2Reader.vala"
	_g_free0 (_tmp71_->inputAttributeName);
#line 142 "../src/fb2Reader.vala"
	_tmp71_->inputAttributeName = _tmp70_;
#line 142 "../src/fb2Reader.vala"
	_tmp71_->isXMLExtraction = TRUE;
#line 142 "../src/fb2Reader.vala"
	_tmp72_ = _tmp71_;
#line 142 "../src/fb2Reader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, _tmp72_);
#line 142 "../src/fb2Reader.vala"
	_bookworm_app_xml_data_unref0 (_tmp72_);
#line 150 "../src/fb2Reader.vala"
	_tmp73_ = bookworm_app_xml_parser_new ();
#line 150 "../src/fb2Reader.vala"
	thisParser = _tmp73_;
#line 151 "../src/fb2Reader.vala"
	_tmp74_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 151 "../src/fb2Reader.vala"
	extractedDataList = _tmp74_;
#line 152 "../src/fb2Reader.vala"
	_tmp75_ = thisParser;
#line 152 "../src/fb2Reader.vala"
	_tmp76_ = bookworm_app_fb2_reader_fb2_location;
#line 152 "../src/fb2Reader.vala"
	_tmp77_ = inputDataList;
#line 152 "../src/fb2Reader.vala"
	_tmp78_ = _g_object_ref0 (_tmp77_);
#line 152 "../src/fb2Reader.vala"
	_tmp79_ = bookworm_app_xml_parser_extractDataFromXML (_tmp75_, _tmp76_, _tmp78_, FALSE);
#line 152 "../src/fb2Reader.vala"
	_g_object_unref0 (extractedDataList);
#line 152 "../src/fb2Reader.vala"
	extractedDataList = _tmp79_;
#line 153 "../src/fb2Reader.vala"
	_tmp80_ = extractedDataList;
#line 153 "../src/fb2Reader.vala"
	_tmp81_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp80_);
#line 153 "../src/fb2Reader.vala"
	_tmp82_ = _tmp81_;
#line 153 "../src/fb2Reader.vala"
	_tmp83_ = g_strdup_printf ("%i", _tmp82_);
#line 153 "../src/fb2Reader.vala"
	_tmp84_ = _tmp83_;
#line 153 "../src/fb2Reader.vala"
	_tmp85_ = g_strconcat ("No. of sections found in FB2 file:", _tmp84_, NULL);
#line 153 "../src/fb2Reader.vala"
	_tmp86_ = _tmp85_;
#line 153 "../src/fb2Reader.vala"
	g_debug ("fb2Reader.vala:153: %s", _tmp86_);
#line 153 "../src/fb2Reader.vala"
	_g_free0 (_tmp86_);
#line 153 "../src/fb2Reader.vala"
	_g_free0 (_tmp84_);
#line 155 "../src/fb2Reader.vala"
	filecount = 1;
#line 1163 "fb2Reader.c"
	{
		GeeArrayList* _aExtractedData_list = NULL;
		GeeArrayList* _tmp87_;
		gint _aExtractedData_size = 0;
		GeeArrayList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _aExtractedData_index = 0;
#line 156 "../src/fb2Reader.vala"
		_tmp87_ = extractedDataList;
#line 156 "../src/fb2Reader.vala"
		_aExtractedData_list = _tmp87_;
#line 156 "../src/fb2Reader.vala"
		_tmp88_ = _aExtractedData_list;
#line 156 "../src/fb2Reader.vala"
		_tmp89_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp88_);
#line 156 "../src/fb2Reader.vala"
		_tmp90_ = _tmp89_;
#line 156 "../src/fb2Reader.vala"
		_aExtractedData_size = _tmp90_;
#line 156 "../src/fb2Reader.vala"
		_aExtractedData_index = -1;
#line 156 "../src/fb2Reader.vala"
		while (TRUE) {
#line 1188 "fb2Reader.c"
			gint _tmp91_;
			gint _tmp92_;
			BookwormAppXMLData* aExtractedData = NULL;
			GeeArrayList* _tmp93_;
			gpointer _tmp94_;
#line 156 "../src/fb2Reader.vala"
			_aExtractedData_index = _aExtractedData_index + 1;
#line 156 "../src/fb2Reader.vala"
			_tmp91_ = _aExtractedData_index;
#line 156 "../src/fb2Reader.vala"
			_tmp92_ = _aExtractedData_size;
#line 156 "../src/fb2Reader.vala"
			if (!(_tmp91_ < _tmp92_)) {
#line 156 "../src/fb2Reader.vala"
				break;
#line 1204 "fb2Reader.c"
			}
#line 156 "../src/fb2Reader.vala"
			_tmp93_ = _aExtractedData_list;
#line 156 "../src/fb2Reader.vala"
			_tmp94_ = gee_abstract_list_get ((GeeAbstractList*) _tmp93_, _aExtractedData_index);
#line 156 "../src/fb2Reader.vala"
			aExtractedData = (BookwormAppXMLData*) _tmp94_;
#line 1212 "fb2Reader.c"
			{
				GeeArrayList* _aTagValue_list = NULL;
				BookwormAppXMLData* _tmp95_;
				GeeArrayList* _tmp96_;
				gint _aTagValue_size = 0;
				GeeArrayList* _tmp97_;
				gint _tmp98_;
				gint _tmp99_;
				gint _aTagValue_index = 0;
#line 157 "../src/fb2Reader.vala"
				_tmp95_ = aExtractedData;
#line 157 "../src/fb2Reader.vala"
				_tmp96_ = _tmp95_->extractedTagValues;
#line 157 "../src/fb2Reader.vala"
				_aTagValue_list = _tmp96_;
#line 157 "../src/fb2Reader.vala"
				_tmp97_ = _aTagValue_list;
#line 157 "../src/fb2Reader.vala"
				_tmp98_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp97_);
#line 157 "../src/fb2Reader.vala"
				_tmp99_ = _tmp98_;
#line 157 "../src/fb2Reader.vala"
				_aTagValue_size = _tmp99_;
#line 157 "../src/fb2Reader.vala"
				_aTagValue_index = -1;
#line 157 "../src/fb2Reader.vala"
				while (TRUE) {
#line 1240 "fb2Reader.c"
					gint _tmp100_;
					gint _tmp101_;
					gchar* aTagValue = NULL;
					GeeArrayList* _tmp102_;
					gpointer _tmp103_;
					gchar* filename = NULL;
					const gchar* _tmp104_;
					GFile* _tmp105_;
					GFile* _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					gchar* _tmp109_;
					gchar* _tmp110_;
					gchar* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					gchar* _tmp114_;
					gchar* _tmp115_;
					gchar* _tmp116_;
					const gchar* _tmp117_;
					const gchar* _tmp118_;
					const gchar* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					gchar* _tmp122_;
					gchar* _tmp123_;
					gchar* _tmp124_;
					const gchar* _tmp125_;
#line 157 "../src/fb2Reader.vala"
					_aTagValue_index = _aTagValue_index + 1;
#line 157 "../src/fb2Reader.vala"
					_tmp100_ = _aTagValue_index;
#line 157 "../src/fb2Reader.vala"
					_tmp101_ = _aTagValue_size;
#line 157 "../src/fb2Reader.vala"
					if (!(_tmp100_ < _tmp101_)) {
#line 157 "../src/fb2Reader.vala"
						break;
#line 1279 "fb2Reader.c"
					}
#line 157 "../src/fb2Reader.vala"
					_tmp102_ = _aTagValue_list;
#line 157 "../src/fb2Reader.vala"
					_tmp103_ = gee_abstract_list_get ((GeeAbstractList*) _tmp102_, _aTagValue_index);
#line 157 "../src/fb2Reader.vala"
					aTagValue = (gchar*) _tmp103_;
#line 158 "../src/fb2Reader.vala"
					_tmp104_ = bookworm_app_fb2_reader_fb2_location;
#line 158 "../src/fb2Reader.vala"
					_tmp105_ = g_file_new_for_path (_tmp104_);
#line 158 "../src/fb2Reader.vala"
					_tmp106_ = _tmp105_;
#line 158 "../src/fb2Reader.vala"
					_tmp107_ = g_file_get_basename (_tmp106_);
#line 158 "../src/fb2Reader.vala"
					_tmp108_ = _tmp107_;
#line 158 "../src/fb2Reader.vala"
					_tmp109_ = g_strconcat (_tmp108_, "_", NULL);
#line 158 "../src/fb2Reader.vala"
					_tmp110_ = _tmp109_;
#line 158 "../src/fb2Reader.vala"
					_tmp111_ = g_strdup_printf ("%i", filecount);
#line 158 "../src/fb2Reader.vala"
					_tmp112_ = _tmp111_;
#line 158 "../src/fb2Reader.vala"
					_tmp113_ = g_strconcat (_tmp110_, _tmp112_, NULL);
#line 158 "../src/fb2Reader.vala"
					_tmp114_ = _tmp113_;
#line 158 "../src/fb2Reader.vala"
					_tmp115_ = g_strconcat (_tmp114_, ".html", NULL);
#line 158 "../src/fb2Reader.vala"
					_tmp116_ = _tmp115_;
#line 158 "../src/fb2Reader.vala"
					_g_free0 (_tmp114_);
#line 158 "../src/fb2Reader.vala"
					_g_free0 (_tmp112_);
#line 158 "../src/fb2Reader.vala"
					_g_free0 (_tmp110_);
#line 158 "../src/fb2Reader.vala"
					_g_free0 (_tmp108_);
#line 158 "../src/fb2Reader.vala"
					_g_object_unref0 (_tmp106_);
#line 158 "../src/fb2Reader.vala"
					filename = _tmp116_;
#line 159 "../src/fb2Reader.vala"
					_tmp117_ = extractionLocation;
#line 159 "../src/fb2Reader.vala"
					_tmp118_ = filename;
#line 159 "../src/fb2Reader.vala"
					_tmp119_ = aTagValue;
#line 159 "../src/fb2Reader.vala"
					_tmp120_ = g_strconcat ("<html><body>", _tmp119_, NULL);
#line 159 "../src/fb2Reader.vala"
					_tmp121_ = _tmp120_;
#line 159 "../src/fb2Reader.vala"
					_tmp122_ = g_strconcat (_tmp121_, "</body></html>", NULL);
#line 159 "../src/fb2Reader.vala"
					_tmp123_ = _tmp122_;
#line 159 "../src/fb2Reader.vala"
					_tmp124_ = bookworm_app_utils_fileOperations ("WRITE", _tmp117_, _tmp118_, _tmp123_);
#line 159 "../src/fb2Reader.vala"
					_g_free0 (status);
#line 159 "../src/fb2Reader.vala"
					status = _tmp124_;
#line 159 "../src/fb2Reader.vala"
					_g_free0 (_tmp123_);
#line 159 "../src/fb2Reader.vala"
					_g_free0 (_tmp121_);
#line 165 "../src/fb2Reader.vala"
					filecount = filecount + 1;
#line 166 "../src/fb2Reader.vala"
					_tmp125_ = status;
#line 166 "../src/fb2Reader.vala"
					if (g_strcmp0 ("true", _tmp125_) == 0) {
#line 1355 "fb2Reader.c"
						const gchar* _tmp126_;
						gchar* _tmp127_;
						gchar* _tmp128_;
						const gchar* _tmp129_;
						gchar* _tmp130_;
						gchar* _tmp131_;
						const gchar* _tmp132_;
						gchar* _tmp133_;
						gchar* _tmp134_;
						gchar* _tmp135_;
						gchar* _tmp136_;
						const gchar* _tmp137_;
						gchar* _tmp138_;
						gchar* _tmp139_;
#line 167 "../src/fb2Reader.vala"
						_tmp126_ = extractionLocation;
#line 167 "../src/fb2Reader.vala"
						_tmp127_ = g_strconcat (_tmp126_, "/", NULL);
#line 167 "../src/fb2Reader.vala"
						_tmp128_ = _tmp127_;
#line 167 "../src/fb2Reader.vala"
						_tmp129_ = filename;
#line 167 "../src/fb2Reader.vala"
						_tmp130_ = g_strconcat (_tmp128_, _tmp129_, NULL);
#line 167 "../src/fb2Reader.vala"
						_tmp131_ = _tmp130_;
#line 167 "../src/fb2Reader.vala"
						bookworm_app_book_setBookContentList (aBook, _tmp131_);
#line 167 "../src/fb2Reader.vala"
						_g_free0 (_tmp131_);
#line 167 "../src/fb2Reader.vala"
						_g_free0 (_tmp128_);
#line 168 "../src/fb2Reader.vala"
						_tmp132_ = extractionLocation;
#line 168 "../src/fb2Reader.vala"
						_tmp133_ = g_strconcat ("Extracted contents written to file:", _tmp132_, NULL);
#line 168 "../src/fb2Reader.vala"
						_tmp134_ = _tmp133_;
#line 168 "../src/fb2Reader.vala"
						_tmp135_ = g_strconcat (_tmp134_, "/", NULL);
#line 168 "../src/fb2Reader.vala"
						_tmp136_ = _tmp135_;
#line 168 "../src/fb2Reader.vala"
						_tmp137_ = filename;
#line 168 "../src/fb2Reader.vala"
						_tmp138_ = g_strconcat (_tmp136_, _tmp137_, NULL);
#line 168 "../src/fb2Reader.vala"
						_tmp139_ = _tmp138_;
#line 168 "../src/fb2Reader.vala"
						g_debug ("fb2Reader.vala:168: %s", _tmp139_);
#line 168 "../src/fb2Reader.vala"
						_g_free0 (_tmp139_);
#line 168 "../src/fb2Reader.vala"
						_g_free0 (_tmp136_);
#line 168 "../src/fb2Reader.vala"
						_g_free0 (_tmp134_);
#line 1412 "fb2Reader.c"
					}
#line 157 "../src/fb2Reader.vala"
					_g_free0 (filename);
#line 157 "../src/fb2Reader.vala"
					_g_free0 (aTagValue);
#line 1418 "fb2Reader.c"
				}
			}
#line 156 "../src/fb2Reader.vala"
			_bookworm_app_xml_data_unref0 (aExtractedData);
#line 1423 "fb2Reader.c"
		}
	}
#line 172 "../src/fb2Reader.vala"
	_tmp140_ = extractionLocation;
#line 172 "../src/fb2Reader.vala"
	_tmp141_ = g_strdup (_tmp140_);
#line 172 "../src/fb2Reader.vala"
	baseLocationOfContents = _tmp141_;
#line 173 "../src/fb2Reader.vala"
	_tmp142_ = baseLocationOfContents;
#line 173 "../src/fb2Reader.vala"
	bookworm_app_book_setBaseLocationOfContents (aBook, _tmp142_);
#line 174 "../src/fb2Reader.vala"
	_tmp143_ = baseLocationOfContents;
#line 174 "../src/fb2Reader.vala"
	_tmp144_ = g_strconcat ("Base location for FB2 extracted contents:", _tmp143_, NULL);
#line 174 "../src/fb2Reader.vala"
	_tmp145_ = _tmp144_;
#line 174 "../src/fb2Reader.vala"
	g_debug ("fb2Reader.vala:174: %s", _tmp145_);
#line 174 "../src/fb2Reader.vala"
	_g_free0 (_tmp145_);
#line 176 "../src/fb2Reader.vala"
	_tmp146_ = bookworm_app_book_getBookContentList (aBook);
#line 176 "../src/fb2Reader.vala"
	_tmp147_ = _tmp146_;
#line 176 "../src/fb2Reader.vala"
	_tmp148_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp147_);
#line 176 "../src/fb2Reader.vala"
	_tmp149_ = _tmp148_;
#line 176 "../src/fb2Reader.vala"
	_tmp150_ = _tmp149_ < 1;
#line 176 "../src/fb2Reader.vala"
	_g_object_unref0 (_tmp147_);
#line 176 "../src/fb2Reader.vala"
	if (_tmp150_) {
#line 1460 "fb2Reader.c"
		const gchar* _tmp151_;
		gchar* _tmp152_;
		gchar* _tmp153_;
		gchar* _tmp154_;
		gchar* _tmp155_;
		BookwormAppBook* _tmp156_;
#line 177 "../src/fb2Reader.vala"
		_tmp151_ = bookworm_app_fb2_reader_fb2_location;
#line 177 "../src/fb2Reader.vala"
		_tmp152_ = g_strconcat ("Failure in extracting contents of FB2 file [", _tmp151_, NULL);
#line 177 "../src/fb2Reader.vala"
		_tmp153_ = _tmp152_;
#line 177 "../src/fb2Reader.vala"
		_tmp154_ = g_strconcat (_tmp153_, "]", NULL);
#line 177 "../src/fb2Reader.vala"
		_tmp155_ = _tmp154_;
#line 177 "../src/fb2Reader.vala"
		g_warning ("fb2Reader.vala:177: %s", _tmp155_);
#line 177 "../src/fb2Reader.vala"
		_g_free0 (_tmp155_);
#line 177 "../src/fb2Reader.vala"
		_g_free0 (_tmp153_);
#line 178 "../src/fb2Reader.vala"
		bookworm_app_book_setBookExtractionLocation (aBook, "false");
#line 179 "../src/fb2Reader.vala"
		_tmp156_ = _bookworm_app_book_ref0 (aBook);
#line 179 "../src/fb2Reader.vala"
		result = _tmp156_;
#line 179 "../src/fb2Reader.vala"
		_g_free0 (baseLocationOfContents);
#line 179 "../src/fb2Reader.vala"
		_g_object_unref0 (extractedDataList);
#line 179 "../src/fb2Reader.vala"
		_bookworm_app_xml_parser_unref0 (thisParser);
#line 179 "../src/fb2Reader.vala"
		_g_object_unref0 (inputDataList);
#line 179 "../src/fb2Reader.vala"
		_g_free0 (status);
#line 179 "../src/fb2Reader.vala"
		_g_free0 (extractionLocation);
#line 179 "../src/fb2Reader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 179 "../src/fb2Reader.vala"
		return result;
#line 1505 "fb2Reader.c"
	}
#line 181 "../src/fb2Reader.vala"
	_tmp157_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 181 "../src/fb2Reader.vala"
	_tmp158_ = _tmp157_;
#line 181 "../src/fb2Reader.vala"
	_tmp159_ = g_strconcat ("[END] [FUNCTION:extractEBook] FB2 book extracted successfully at locat" \
"ion:", _tmp158_, NULL);
#line 181 "../src/fb2Reader.vala"
	_tmp160_ = _tmp159_;
#line 181 "../src/fb2Reader.vala"
	g_info ("fb2Reader.vala:181: %s", _tmp160_);
#line 181 "../src/fb2Reader.vala"
	_g_free0 (_tmp160_);
#line 181 "../src/fb2Reader.vala"
	_g_free0 (_tmp158_);
#line 182 "../src/fb2Reader.vala"
	_tmp161_ = _bookworm_app_book_ref0 (aBook);
#line 182 "../src/fb2Reader.vala"
	result = _tmp161_;
#line 182 "../src/fb2Reader.vala"
	_g_free0 (baseLocationOfContents);
#line 182 "../src/fb2Reader.vala"
	_g_object_unref0 (extractedDataList);
#line 182 "../src/fb2Reader.vala"
	_bookworm_app_xml_parser_unref0 (thisParser);
#line 182 "../src/fb2Reader.vala"
	_g_object_unref0 (inputDataList);
#line 182 "../src/fb2Reader.vala"
	_g_free0 (status);
#line 182 "../src/fb2Reader.vala"
	_g_free0 (extractionLocation);
#line 182 "../src/fb2Reader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 182 "../src/fb2Reader.vala"
	return result;
#line 1541 "fb2Reader.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 1560 "fb2Reader.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1582 "fb2Reader.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1586 "fb2Reader.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1592 "fb2Reader.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1596 "fb2Reader.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1600 "fb2Reader.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1608 "fb2Reader.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1636 "fb2Reader.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 1645 "fb2Reader.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1659 "fb2Reader.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 1668 "fb2Reader.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1682 "fb2Reader.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1691 "fb2Reader.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1700 "fb2Reader.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 1723 "fb2Reader.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 1732 "fb2Reader.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1751 "fb2Reader.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1755 "fb2Reader.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1761 "fb2Reader.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1771 "fb2Reader.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1779 "fb2Reader.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1783 "fb2Reader.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 1789 "fb2Reader.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 1799 "fb2Reader.c"
}

static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
#line 234 "../src/fb2Reader.vala"
	if (length > 0) {
#line 234 "../src/fb2Reader.vala"
		return _vala_memdup2 (self, length * sizeof (guint8));
#line 1810 "fb2Reader.c"
	}
#line 234 "../src/fb2Reader.vala"
	return NULL;
#line 1814 "fb2Reader.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 1835 "fb2Reader.c"
}

BookwormAppBook*
bookworm_app_fb2_reader_setCoverImage (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* bookCoverLocation = NULL;
	gchar* _tmp4_;
	GeeArrayList* inputDataList = NULL;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	BookwormAppXMLData* _tmp10_ = NULL;
	BookwormAppXMLData* _tmp11_;
	GeeArrayList* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	BookwormAppXMLData* _tmp16_ = NULL;
	BookwormAppXMLData* _tmp17_;
	BookwormAppXmlParser* thisParser = NULL;
	BookwormAppXmlParser* _tmp18_;
	GeeArrayList* extractedDataList = NULL;
	GeeArrayList* _tmp19_;
	BookwormAppXmlParser* _tmp20_;
	const gchar* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* image_id = NULL;
	GeeArrayList* _tmp25_;
	GeeArrayList* image_type = NULL;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp133_;
	GeeArrayList* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	BookwormAppXMLData* _tmp138_ = NULL;
	BookwormAppXMLData* _tmp139_;
	BookwormAppXmlParser* _tmp140_;
	GeeArrayList* _tmp141_;
	BookwormAppXmlParser* _tmp142_;
	const gchar* _tmp143_;
	GeeArrayList* _tmp144_;
	GeeArrayList* _tmp145_;
	GeeArrayList* _tmp146_;
	GeeArrayList* _tmp147_;
	gint _tmp148_;
	gint _tmp149_;
	gchar* _tmp150_;
	gchar* _tmp151_;
	gchar* _tmp152_;
	gchar* _tmp153_;
	gboolean _tmp154_ = FALSE;
	GeeArrayList* _tmp155_;
	gint _tmp156_;
	gint _tmp157_;
	gboolean _tmp236_ = FALSE;
	const gchar* _tmp237_;
	gint _tmp238_;
	gint _tmp239_;
	gchar* _tmp248_;
	gchar* _tmp249_;
	gchar* _tmp250_;
	gchar* _tmp251_;
	gchar* _tmp252_;
	gchar* _tmp253_;
	const gchar* _tmp254_;
	gchar* _tmp255_;
	gchar* _tmp256_;
	BookwormAppBook* _tmp257_;
	GError* _inner_error0_ = NULL;
	BookwormAppBook* result;
#line 185 "../src/fb2Reader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 186 "../src/fb2Reader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 186 "../src/fb2Reader.vala"
	_tmp1_ = _tmp0_;
#line 186 "../src/fb2Reader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:setCoverImage] book.location=", _tmp1_, NULL);
#line 186 "../src/fb2Reader.vala"
	_tmp3_ = _tmp2_;
#line 186 "../src/fb2Reader.vala"
	g_info ("fb2Reader.vala:186: %s", _tmp3_);
#line 186 "../src/fb2Reader.vala"
	_g_free0 (_tmp3_);
#line 186 "../src/fb2Reader.vala"
	_g_free0 (_tmp1_);
#line 187 "../src/fb2Reader.vala"
	_tmp4_ = g_strdup ("");
#line 187 "../src/fb2Reader.vala"
	bookCoverLocation = _tmp4_;
#line 190 "../src/fb2Reader.vala"
	_tmp5_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 190 "../src/fb2Reader.vala"
	inputDataList = _tmp5_;
#line 191 "../src/fb2Reader.vala"
	_tmp6_ = inputDataList;
#line 191 "../src/fb2Reader.vala"
	_tmp7_ = g_strdup ("FictionBook");
#line 191 "../src/fb2Reader.vala"
	_tmp8_ = g_strdup ("binary");
#line 191 "../src/fb2Reader.vala"
	_tmp9_ = g_strdup ("id");
#line 191 "../src/fb2Reader.vala"
	_tmp10_ = bookworm_app_xml_data_new ();
#line 191 "../src/fb2Reader.vala"
	_g_free0 (_tmp10_->containerTagName);
#line 191 "../src/fb2Reader.vala"
	_tmp10_->containerTagName = _tmp7_;
#line 191 "../src/fb2Reader.vala"
	_g_free0 (_tmp10_->inputTagName);
#line 191 "../src/fb2Reader.vala"
	_tmp10_->inputTagName = _tmp8_;
#line 191 "../src/fb2Reader.vala"
	_g_free0 (_tmp10_->inputAttributeName);
#line 191 "../src/fb2Reader.vala"
	_tmp10_->inputAttributeName = _tmp9_;
#line 191 "../src/fb2Reader.vala"
	_tmp11_ = _tmp10_;
#line 191 "../src/fb2Reader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp11_);
#line 191 "../src/fb2Reader.vala"
	_bookworm_app_xml_data_unref0 (_tmp11_);
#line 198 "../src/fb2Reader.vala"
	_tmp12_ = inputDataList;
#line 198 "../src/fb2Reader.vala"
	_tmp13_ = g_strdup ("FictionBook");
#line 198 "../src/fb2Reader.vala"
	_tmp14_ = g_strdup ("binary");
#line 198 "../src/fb2Reader.vala"
	_tmp15_ = g_strdup ("content-type");
#line 198 "../src/fb2Reader.vala"
	_tmp16_ = bookworm_app_xml_data_new ();
#line 198 "../src/fb2Reader.vala"
	_g_free0 (_tmp16_->containerTagName);
#line 198 "../src/fb2Reader.vala"
	_tmp16_->containerTagName = _tmp13_;
#line 198 "../src/fb2Reader.vala"
	_g_free0 (_tmp16_->inputTagName);
#line 198 "../src/fb2Reader.vala"
	_tmp16_->inputTagName = _tmp14_;
#line 198 "../src/fb2Reader.vala"
	_g_free0 (_tmp16_->inputAttributeName);
#line 198 "../src/fb2Reader.vala"
	_tmp16_->inputAttributeName = _tmp15_;
#line 198 "../src/fb2Reader.vala"
	_tmp17_ = _tmp16_;
#line 198 "../src/fb2Reader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp17_);
#line 198 "../src/fb2Reader.vala"
	_bookworm_app_xml_data_unref0 (_tmp17_);
#line 205 "../src/fb2Reader.vala"
	_tmp18_ = bookworm_app_xml_parser_new ();
#line 205 "../src/fb2Reader.vala"
	thisParser = _tmp18_;
#line 206 "../src/fb2Reader.vala"
	_tmp19_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 206 "../src/fb2Reader.vala"
	extractedDataList = _tmp19_;
#line 207 "../src/fb2Reader.vala"
	_tmp20_ = thisParser;
#line 207 "../src/fb2Reader.vala"
	_tmp21_ = bookworm_app_fb2_reader_fb2_location;
#line 207 "../src/fb2Reader.vala"
	_tmp22_ = inputDataList;
#line 207 "../src/fb2Reader.vala"
	_tmp23_ = _g_object_ref0 (_tmp22_);
#line 207 "../src/fb2Reader.vala"
	_tmp24_ = bookworm_app_xml_parser_extractDataFromXML (_tmp20_, _tmp21_, _tmp23_, FALSE);
#line 207 "../src/fb2Reader.vala"
	_g_object_unref0 (extractedDataList);
#line 207 "../src/fb2Reader.vala"
	extractedDataList = _tmp24_;
#line 209 "../src/fb2Reader.vala"
	_tmp25_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 209 "../src/fb2Reader.vala"
	image_id = _tmp25_;
#line 210 "../src/fb2Reader.vala"
	_tmp26_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 210 "../src/fb2Reader.vala"
	image_type = _tmp26_;
#line 2025 "fb2Reader.c"
	{
		gint i = 0;
#line 212 "../src/fb2Reader.vala"
		i = 0;
#line 2030 "fb2Reader.c"
		{
			gboolean _tmp27_ = FALSE;
#line 212 "../src/fb2Reader.vala"
			_tmp27_ = TRUE;
#line 212 "../src/fb2Reader.vala"
			while (TRUE) {
#line 2037 "fb2Reader.c"
				gint number_of_extracted_images = 0;
				GeeArrayList* _tmp29_;
				gpointer _tmp30_;
				BookwormAppXMLData* _tmp31_;
				GeeArrayList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
#line 212 "../src/fb2Reader.vala"
				if (!_tmp27_) {
#line 2052 "fb2Reader.c"
					gint _tmp28_;
#line 212 "../src/fb2Reader.vala"
					_tmp28_ = i;
#line 212 "../src/fb2Reader.vala"
					i = _tmp28_ + 1;
#line 2058 "fb2Reader.c"
				}
#line 212 "../src/fb2Reader.vala"
				_tmp27_ = FALSE;
#line 212 "../src/fb2Reader.vala"
				if (!(i < 2)) {
#line 212 "../src/fb2Reader.vala"
					break;
#line 2066 "fb2Reader.c"
				}
#line 214 "../src/fb2Reader.vala"
				_tmp29_ = extractedDataList;
#line 214 "../src/fb2Reader.vala"
				_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, i);
#line 214 "../src/fb2Reader.vala"
				_tmp31_ = (BookwormAppXMLData*) _tmp30_;
#line 214 "../src/fb2Reader.vala"
				_tmp32_ = _tmp31_->extractedTagAttributes;
#line 214 "../src/fb2Reader.vala"
				_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
#line 214 "../src/fb2Reader.vala"
				_tmp34_ = _tmp33_;
#line 214 "../src/fb2Reader.vala"
				_tmp35_ = _tmp34_;
#line 214 "../src/fb2Reader.vala"
				_bookworm_app_xml_data_unref0 (_tmp31_);
#line 214 "../src/fb2Reader.vala"
				number_of_extracted_images = _tmp35_;
#line 215 "../src/fb2Reader.vala"
				_tmp36_ = g_strdup_printf ("%i", number_of_extracted_images);
#line 215 "../src/fb2Reader.vala"
				_tmp37_ = _tmp36_;
#line 215 "../src/fb2Reader.vala"
				_tmp38_ = g_strconcat ("Size of binary tags=", _tmp37_, NULL);
#line 215 "../src/fb2Reader.vala"
				_tmp39_ = _tmp38_;
#line 215 "../src/fb2Reader.vala"
				g_debug ("fb2Reader.vala:215: %s", _tmp39_);
#line 215 "../src/fb2Reader.vala"
				_g_free0 (_tmp39_);
#line 215 "../src/fb2Reader.vala"
				_g_free0 (_tmp37_);
#line 2100 "fb2Reader.c"
				{
					gint j = 0;
#line 216 "../src/fb2Reader.vala"
					j = 0;
#line 2105 "fb2Reader.c"
					{
						gboolean _tmp40_ = FALSE;
#line 216 "../src/fb2Reader.vala"
						_tmp40_ = TRUE;
#line 216 "../src/fb2Reader.vala"
						while (TRUE) {
#line 2112 "fb2Reader.c"
							gchar* aAttributeValue = NULL;
							GeeArrayList* _tmp42_;
							gpointer _tmp43_;
							BookwormAppXMLData* _tmp44_;
							GeeArrayList* _tmp45_;
							gpointer _tmp46_;
							gchar* _tmp47_;
							const gchar* _tmp48_;
#line 216 "../src/fb2Reader.vala"
							if (!_tmp40_) {
#line 2123 "fb2Reader.c"
								gint _tmp41_;
#line 216 "../src/fb2Reader.vala"
								_tmp41_ = j;
#line 216 "../src/fb2Reader.vala"
								j = _tmp41_ + 1;
#line 2129 "fb2Reader.c"
							}
#line 216 "../src/fb2Reader.vala"
							_tmp40_ = FALSE;
#line 216 "../src/fb2Reader.vala"
							if (!(j < number_of_extracted_images)) {
#line 216 "../src/fb2Reader.vala"
								break;
#line 2137 "fb2Reader.c"
							}
#line 217 "../src/fb2Reader.vala"
							_tmp42_ = extractedDataList;
#line 217 "../src/fb2Reader.vala"
							_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, i);
#line 217 "../src/fb2Reader.vala"
							_tmp44_ = (BookwormAppXMLData*) _tmp43_;
#line 217 "../src/fb2Reader.vala"
							_tmp45_ = _tmp44_->extractedTagAttributes;
#line 217 "../src/fb2Reader.vala"
							_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, j);
#line 217 "../src/fb2Reader.vala"
							_tmp47_ = (gchar*) _tmp46_;
#line 217 "../src/fb2Reader.vala"
							_bookworm_app_xml_data_unref0 (_tmp44_);
#line 217 "../src/fb2Reader.vala"
							aAttributeValue = _tmp47_;
#line 218 "../src/fb2Reader.vala"
							_tmp48_ = aAttributeValue;
#line 218 "../src/fb2Reader.vala"
							if (string_contains (_tmp48_, "image/")) {
#line 2159 "fb2Reader.c"
								GeeArrayList* _tmp49_;
								const gchar* _tmp50_;
								gchar* _tmp51_;
								gchar* _tmp52_;
								GeeArrayList* _tmp53_;
								GeeArrayList* _tmp54_;
								gint _tmp55_;
								gint _tmp56_;
								gpointer _tmp57_;
								gchar* _tmp58_;
								gchar* _tmp59_;
								gchar* _tmp60_;
#line 219 "../src/fb2Reader.vala"
								_tmp49_ = image_type;
#line 219 "../src/fb2Reader.vala"
								_tmp50_ = aAttributeValue;
#line 219 "../src/fb2Reader.vala"
								_tmp51_ = string_replace (_tmp50_, "image/", "");
#line 219 "../src/fb2Reader.vala"
								_tmp52_ = _tmp51_;
#line 219 "../src/fb2Reader.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp52_);
#line 219 "../src/fb2Reader.vala"
								_g_free0 (_tmp52_);
#line 220 "../src/fb2Reader.vala"
								_tmp53_ = image_type;
#line 220 "../src/fb2Reader.vala"
								_tmp54_ = image_type;
#line 220 "../src/fb2Reader.vala"
								_tmp55_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp54_);
#line 220 "../src/fb2Reader.vala"
								_tmp56_ = _tmp55_;
#line 220 "../src/fb2Reader.vala"
								_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, _tmp56_ - 1);
#line 220 "../src/fb2Reader.vala"
								_tmp58_ = (gchar*) _tmp57_;
#line 220 "../src/fb2Reader.vala"
								_tmp59_ = g_strconcat ("Image Type determined as:", _tmp58_, NULL);
#line 220 "../src/fb2Reader.vala"
								_tmp60_ = _tmp59_;
#line 220 "../src/fb2Reader.vala"
								g_debug ("fb2Reader.vala:220: %s", _tmp60_);
#line 220 "../src/fb2Reader.vala"
								_g_free0 (_tmp60_);
#line 220 "../src/fb2Reader.vala"
								_g_free0 (_tmp58_);
#line 2206 "fb2Reader.c"
							} else {
								GeeArrayList* _tmp61_;
								const gchar* _tmp62_;
								GeeArrayList* _tmp63_;
								GeeArrayList* _tmp64_;
								gint _tmp65_;
								gint _tmp66_;
								gpointer _tmp67_;
								gchar* _tmp68_;
								gchar* _tmp69_;
								gchar* _tmp70_;
#line 223 "../src/fb2Reader.vala"
								_tmp61_ = image_id;
#line 223 "../src/fb2Reader.vala"
								_tmp62_ = aAttributeValue;
#line 223 "../src/fb2Reader.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp62_);
#line 224 "../src/fb2Reader.vala"
								_tmp63_ = image_id;
#line 224 "../src/fb2Reader.vala"
								_tmp64_ = image_id;
#line 224 "../src/fb2Reader.vala"
								_tmp65_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp64_);
#line 224 "../src/fb2Reader.vala"
								_tmp66_ = _tmp65_;
#line 224 "../src/fb2Reader.vala"
								_tmp67_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, _tmp66_ - 1);
#line 224 "../src/fb2Reader.vala"
								_tmp68_ = (gchar*) _tmp67_;
#line 224 "../src/fb2Reader.vala"
								_tmp69_ = g_strconcat ("Image Id determined as:", _tmp68_, NULL);
#line 224 "../src/fb2Reader.vala"
								_tmp70_ = _tmp69_;
#line 224 "../src/fb2Reader.vala"
								g_debug ("fb2Reader.vala:224: %s", _tmp70_);
#line 224 "../src/fb2Reader.vala"
								_g_free0 (_tmp70_);
#line 224 "../src/fb2Reader.vala"
								_g_free0 (_tmp68_);
#line 2246 "fb2Reader.c"
							}
#line 216 "../src/fb2Reader.vala"
							_g_free0 (aAttributeValue);
#line 2250 "fb2Reader.c"
						}
					}
				}
			}
		}
	}
	{
		gint k = 0;
#line 229 "../src/fb2Reader.vala"
		k = 0;
#line 2261 "fb2Reader.c"
		{
			gboolean _tmp71_ = FALSE;
#line 229 "../src/fb2Reader.vala"
			_tmp71_ = TRUE;
#line 229 "../src/fb2Reader.vala"
			while (TRUE) {
#line 2268 "fb2Reader.c"
				GeeArrayList* _tmp73_;
				gint _tmp74_;
				gint _tmp75_;
				gchar* encoded_image_data = NULL;
				GeeArrayList* _tmp76_;
				gpointer _tmp77_;
				BookwormAppXMLData* _tmp78_;
				GeeArrayList* _tmp79_;
				gpointer _tmp80_;
				gchar* _tmp81_;
				const gchar* _tmp82_;
				gint _tmp83_;
				gint _tmp84_;
#line 229 "../src/fb2Reader.vala"
				if (!_tmp71_) {
#line 2284 "fb2Reader.c"
					gint _tmp72_;
#line 229 "../src/fb2Reader.vala"
					_tmp72_ = k;
#line 229 "../src/fb2Reader.vala"
					k = _tmp72_ + 1;
#line 2290 "fb2Reader.c"
				}
#line 229 "../src/fb2Reader.vala"
				_tmp71_ = FALSE;
#line 229 "../src/fb2Reader.vala"
				_tmp73_ = image_id;
#line 229 "../src/fb2Reader.vala"
				_tmp74_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp73_);
#line 229 "../src/fb2Reader.vala"
				_tmp75_ = _tmp74_;
#line 229 "../src/fb2Reader.vala"
				if (!(k < _tmp75_)) {
#line 229 "../src/fb2Reader.vala"
					break;
#line 2304 "fb2Reader.c"
				}
#line 230 "../src/fb2Reader.vala"
				_tmp76_ = extractedDataList;
#line 230 "../src/fb2Reader.vala"
				_tmp77_ = gee_abstract_list_get ((GeeAbstractList*) _tmp76_, 0);
#line 230 "../src/fb2Reader.vala"
				_tmp78_ = (BookwormAppXMLData*) _tmp77_;
#line 230 "../src/fb2Reader.vala"
				_tmp79_ = _tmp78_->extractedTagValues;
#line 230 "../src/fb2Reader.vala"
				_tmp80_ = gee_abstract_list_get ((GeeAbstractList*) _tmp79_, k);
#line 230 "../src/fb2Reader.vala"
				_tmp81_ = (gchar*) _tmp80_;
#line 230 "../src/fb2Reader.vala"
				_bookworm_app_xml_data_unref0 (_tmp78_);
#line 230 "../src/fb2Reader.vala"
				encoded_image_data = _tmp81_;
#line 231 "../src/fb2Reader.vala"
				_tmp82_ = encoded_image_data;
#line 231 "../src/fb2Reader.vala"
				_tmp83_ = strlen (_tmp82_);
#line 231 "../src/fb2Reader.vala"
				_tmp84_ = _tmp83_;
#line 231 "../src/fb2Reader.vala"
				if (_tmp84_ > 0) {
#line 2330 "fb2Reader.c"
					const gchar* _tmp85_;
					gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					guchar* data = NULL;
					const gchar* _tmp92_;
					gsize _tmp93_ = 0;
					guchar* _tmp94_;
					gint data_length1;
					gint _data_size_;
					GMemoryInputStream* mis = NULL;
					guchar* _tmp95_;
					gint _tmp95__length1;
					guint8* _tmp96_;
					gint _tmp96__length1;
					GDestroyNotify _tmp97_;
					GMemoryInputStream* _tmp98_;
					GdkPixbuf* pixbuf = NULL;
					GMemoryInputStream* _tmp99_;
					GdkPixbuf* _tmp100_;
					gchar* image_location = NULL;
					gchar* _tmp101_;
					gchar* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					GeeArrayList* _tmp105_;
					gpointer _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					gchar* _tmp109_;
#line 232 "../src/fb2Reader.vala"
					_tmp85_ = encoded_image_data;
#line 232 "../src/fb2Reader.vala"
					_tmp86_ = string_substring (_tmp85_, (glong) 0, (glong) 20);
#line 232 "../src/fb2Reader.vala"
					_tmp87_ = _tmp86_;
#line 232 "../src/fb2Reader.vala"
					_tmp88_ = g_strconcat ("Found encoded image data:", _tmp87_, NULL);
#line 232 "../src/fb2Reader.vala"
					_tmp89_ = _tmp88_;
#line 232 "../src/fb2Reader.vala"
					_tmp90_ = g_strconcat (_tmp89_, "....", NULL);
#line 232 "../src/fb2Reader.vala"
					_tmp91_ = _tmp90_;
#line 232 "../src/fb2Reader.vala"
					g_debug ("fb2Reader.vala:232: %s", _tmp91_);
#line 232 "../src/fb2Reader.vala"
					_g_free0 (_tmp91_);
#line 232 "../src/fb2Reader.vala"
					_g_free0 (_tmp89_);
#line 232 "../src/fb2Reader.vala"
					_g_free0 (_tmp87_);
#line 233 "../src/fb2Reader.vala"
					_tmp92_ = encoded_image_data;
#line 233 "../src/fb2Reader.vala"
					_tmp94_ = g_base64_decode (_tmp92_, &_tmp93_);
#line 233 "../src/fb2Reader.vala"
					data = _tmp94_;
#line 233 "../src/fb2Reader.vala"
					data_length1 = _tmp93_;
#line 233 "../src/fb2Reader.vala"
					_data_size_ = data_length1;
#line 234 "../src/fb2Reader.vala"
					_tmp95_ = data;
#line 234 "../src/fb2Reader.vala"
					_tmp95__length1 = data_length1;
#line 234 "../src/fb2Reader.vala"
					_tmp96_ = (_tmp95_ != NULL) ? _vala_array_dup2 (_tmp95_, _tmp95__length1) : _tmp95_;
#line 234 "../src/fb2Reader.vala"
					_tmp96__length1 = _tmp95__length1;
#line 234 "../src/fb2Reader.vala"
					_tmp97_ = g_free;
#line 234 "../src/fb2Reader.vala"
					_tmp98_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp96_, _tmp96__length1, _tmp97_);
#line 234 "../src/fb2Reader.vala"
					mis = _tmp98_;
#line 235 "../src/fb2Reader.vala"
					_tmp99_ = mis;
#line 235 "../src/fb2Reader.vala"
					_tmp100_ = gdk_pixbuf_new_from_stream ((GInputStream*) _tmp99_, NULL, &_inner_error0_);
#line 235 "../src/fb2Reader.vala"
					pixbuf = _tmp100_;
#line 235 "../src/fb2Reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 235 "../src/fb2Reader.vala"
						_g_object_unref0 (mis);
#line 235 "../src/fb2Reader.vala"
						data = (g_free (data), NULL);
#line 235 "../src/fb2Reader.vala"
						_g_free0 (encoded_image_data);
#line 235 "../src/fb2Reader.vala"
						_g_object_unref0 (image_type);
#line 235 "../src/fb2Reader.vala"
						_g_object_unref0 (image_id);
#line 235 "../src/fb2Reader.vala"
						_g_object_unref0 (extractedDataList);
#line 235 "../src/fb2Reader.vala"
						_bookworm_app_xml_parser_unref0 (thisParser);
#line 235 "../src/fb2Reader.vala"
						_g_object_unref0 (inputDataList);
#line 235 "../src/fb2Reader.vala"
						_g_free0 (bookCoverLocation);
#line 235 "../src/fb2Reader.vala"
						_bookworm_app_book_unref0 (aBook);
#line 235 "../src/fb2Reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 235 "../src/fb2Reader.vala"
						g_clear_error (&_inner_error0_);
#line 235 "../src/fb2Reader.vala"
						return NULL;
#line 2444 "fb2Reader.c"
					}
#line 236 "../src/fb2Reader.vala"
					_tmp101_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 236 "../src/fb2Reader.vala"
					_tmp102_ = _tmp101_;
#line 236 "../src/fb2Reader.vala"
					_tmp103_ = g_strconcat (_tmp102_, "/", NULL);
#line 236 "../src/fb2Reader.vala"
					_tmp104_ = _tmp103_;
#line 236 "../src/fb2Reader.vala"
					_tmp105_ = image_id;
#line 236 "../src/fb2Reader.vala"
					_tmp106_ = gee_abstract_list_get ((GeeAbstractList*) _tmp105_, k);
#line 236 "../src/fb2Reader.vala"
					_tmp107_ = (gchar*) _tmp106_;
#line 236 "../src/fb2Reader.vala"
					_tmp108_ = g_strconcat (_tmp104_, _tmp107_, NULL);
#line 236 "../src/fb2Reader.vala"
					_tmp109_ = _tmp108_;
#line 236 "../src/fb2Reader.vala"
					_g_free0 (_tmp107_);
#line 236 "../src/fb2Reader.vala"
					_g_free0 (_tmp104_);
#line 236 "../src/fb2Reader.vala"
					_g_free0 (_tmp102_);
#line 236 "../src/fb2Reader.vala"
					image_location = _tmp109_;
#line 2472 "fb2Reader.c"
					{
						GdkPixbuf* _tmp110_;
						const gchar* _tmp111_;
						GeeArrayList* _tmp112_;
						gpointer _tmp113_;
						gchar* _tmp114_;
						const gchar* _tmp115_;
						gint _tmp116_;
						gint _tmp117_;
#line 238 "../src/fb2Reader.vala"
						_tmp110_ = pixbuf;
#line 238 "../src/fb2Reader.vala"
						_tmp111_ = image_location;
#line 238 "../src/fb2Reader.vala"
						_tmp112_ = image_type;
#line 238 "../src/fb2Reader.vala"
						_tmp113_ = gee_abstract_list_get ((GeeAbstractList*) _tmp112_, k);
#line 238 "../src/fb2Reader.vala"
						_tmp114_ = (gchar*) _tmp113_;
#line 238 "../src/fb2Reader.vala"
						gdk_pixbuf_save (_tmp110_, _tmp111_, _tmp114_, &_inner_error0_, NULL);
#line 238 "../src/fb2Reader.vala"
						_g_free0 (_tmp114_);
#line 238 "../src/fb2Reader.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2498 "fb2Reader.c"
							goto __catch0_g_error;
						}
#line 240 "../src/fb2Reader.vala"
						_tmp115_ = bookCoverLocation;
#line 240 "../src/fb2Reader.vala"
						_tmp116_ = strlen (_tmp115_);
#line 240 "../src/fb2Reader.vala"
						_tmp117_ = _tmp116_;
#line 240 "../src/fb2Reader.vala"
						if (_tmp117_ < 1) {
#line 2509 "fb2Reader.c"
							const gchar* _tmp118_;
							gchar* _tmp119_;
							const gchar* _tmp120_;
							gchar* _tmp121_;
							gchar* _tmp122_;
#line 241 "../src/fb2Reader.vala"
							_tmp118_ = image_location;
#line 241 "../src/fb2Reader.vala"
							_tmp119_ = g_strdup (_tmp118_);
#line 241 "../src/fb2Reader.vala"
							_g_free0 (bookCoverLocation);
#line 241 "../src/fb2Reader.vala"
							bookCoverLocation = _tmp119_;
#line 242 "../src/fb2Reader.vala"
							_tmp120_ = bookCoverLocation;
#line 242 "../src/fb2Reader.vala"
							_tmp121_ = g_strconcat ("Assigning the first image as cover image:", _tmp120_, NULL);
#line 242 "../src/fb2Reader.vala"
							_tmp122_ = _tmp121_;
#line 242 "../src/fb2Reader.vala"
							g_debug ("fb2Reader.vala:242: %s", _tmp122_);
#line 242 "../src/fb2Reader.vala"
							_g_free0 (_tmp122_);
#line 2533 "fb2Reader.c"
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						gchar* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						gchar* _tmp126_;
						gchar* _tmp127_;
						gchar* _tmp128_;
						GError* _tmp129_;
						const gchar* _tmp130_;
						gchar* _tmp131_;
						gchar* _tmp132_;
#line 237 "../src/fb2Reader.vala"
						e = _inner_error0_;
#line 237 "../src/fb2Reader.vala"
						_inner_error0_ = NULL;
#line 245 "../src/fb2Reader.vala"
						_tmp123_ = bookworm_app_book_getBookLocation (aBook);
#line 245 "../src/fb2Reader.vala"
						_tmp124_ = _tmp123_;
#line 245 "../src/fb2Reader.vala"
						_tmp125_ = g_strconcat ("Failure in writting decoded image data in FB2 file [", _tmp124_, NULL);
#line 245 "../src/fb2Reader.vala"
						_tmp126_ = _tmp125_;
#line 245 "../src/fb2Reader.vala"
						_tmp127_ = g_strconcat (_tmp126_, "]:", NULL);
#line 245 "../src/fb2Reader.vala"
						_tmp128_ = _tmp127_;
#line 245 "../src/fb2Reader.vala"
						_tmp129_ = e;
#line 245 "../src/fb2Reader.vala"
						_tmp130_ = _tmp129_->message;
#line 245 "../src/fb2Reader.vala"
						_tmp131_ = g_strconcat (_tmp128_, _tmp130_, NULL);
#line 245 "../src/fb2Reader.vala"
						_tmp132_ = _tmp131_;
#line 245 "../src/fb2Reader.vala"
						g_warning ("fb2Reader.vala:245: %s", _tmp132_);
#line 245 "../src/fb2Reader.vala"
						_g_free0 (_tmp132_);
#line 245 "../src/fb2Reader.vala"
						_g_free0 (_tmp128_);
#line 245 "../src/fb2Reader.vala"
						_g_free0 (_tmp126_);
#line 245 "../src/fb2Reader.vala"
						_g_free0 (_tmp124_);
#line 237 "../src/fb2Reader.vala"
						_g_error_free0 (e);
#line 2586 "fb2Reader.c"
					}
					__finally0:
#line 237 "../src/fb2Reader.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 237 "../src/fb2Reader.vala"
						_g_free0 (image_location);
#line 237 "../src/fb2Reader.vala"
						_g_object_unref0 (pixbuf);
#line 237 "../src/fb2Reader.vala"
						_g_object_unref0 (mis);
#line 237 "../src/fb2Reader.vala"
						data = (g_free (data), NULL);
#line 237 "../src/fb2Reader.vala"
						_g_free0 (encoded_image_data);
#line 237 "../src/fb2Reader.vala"
						_g_object_unref0 (image_type);
#line 237 "../src/fb2Reader.vala"
						_g_object_unref0 (image_id);
#line 237 "../src/fb2Reader.vala"
						_g_object_unref0 (extractedDataList);
#line 237 "../src/fb2Reader.vala"
						_bookworm_app_xml_parser_unref0 (thisParser);
#line 237 "../src/fb2Reader.vala"
						_g_object_unref0 (inputDataList);
#line 237 "../src/fb2Reader.vala"
						_g_free0 (bookCoverLocation);
#line 237 "../src/fb2Reader.vala"
						_bookworm_app_book_unref0 (aBook);
#line 237 "../src/fb2Reader.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 237 "../src/fb2Reader.vala"
						g_clear_error (&_inner_error0_);
#line 237 "../src/fb2Reader.vala"
						return NULL;
#line 2621 "fb2Reader.c"
					}
#line 231 "../src/fb2Reader.vala"
					_g_free0 (image_location);
#line 231 "../src/fb2Reader.vala"
					_g_object_unref0 (pixbuf);
#line 231 "../src/fb2Reader.vala"
					_g_object_unref0 (mis);
#line 231 "../src/fb2Reader.vala"
					data = (g_free (data), NULL);
#line 2631 "fb2Reader.c"
				}
#line 229 "../src/fb2Reader.vala"
				_g_free0 (encoded_image_data);
#line 2635 "fb2Reader.c"
			}
		}
	}
#line 251 "../src/fb2Reader.vala"
	_tmp133_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 251 "../src/fb2Reader.vala"
	_g_object_unref0 (inputDataList);
#line 251 "../src/fb2Reader.vala"
	inputDataList = _tmp133_;
#line 252 "../src/fb2Reader.vala"
	_tmp134_ = inputDataList;
#line 252 "../src/fb2Reader.vala"
	_tmp135_ = g_strdup ("");
#line 252 "../src/fb2Reader.vala"
	_tmp136_ = g_strdup ("coverpage");
#line 252 "../src/fb2Reader.vala"
	_tmp137_ = g_strdup ("");
#line 252 "../src/fb2Reader.vala"
	_tmp138_ = bookworm_app_xml_data_new ();
#line 252 "../src/fb2Reader.vala"
	_g_free0 (_tmp138_->containerTagName);
#line 252 "../src/fb2Reader.vala"
	_tmp138_->containerTagName = _tmp135_;
#line 252 "../src/fb2Reader.vala"
	_g_free0 (_tmp138_->inputTagName);
#line 252 "../src/fb2Reader.vala"
	_tmp138_->inputTagName = _tmp136_;
#line 252 "../src/fb2Reader.vala"
	_g_free0 (_tmp138_->inputAttributeName);
#line 252 "../src/fb2Reader.vala"
	_tmp138_->inputAttributeName = _tmp137_;
#line 252 "../src/fb2Reader.vala"
	_tmp138_->isXMLExtraction = TRUE;
#line 252 "../src/fb2Reader.vala"
	_tmp139_ = _tmp138_;
#line 252 "../src/fb2Reader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp134_, _tmp139_);
#line 252 "../src/fb2Reader.vala"
	_bookworm_app_xml_data_unref0 (_tmp139_);
#line 260 "../src/fb2Reader.vala"
	_tmp140_ = bookworm_app_xml_parser_new ();
#line 260 "../src/fb2Reader.vala"
	_bookworm_app_xml_parser_unref0 (thisParser);
#line 260 "../src/fb2Reader.vala"
	thisParser = _tmp140_;
#line 261 "../src/fb2Reader.vala"
	_tmp141_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 261 "../src/fb2Reader.vala"
	_g_object_unref0 (extractedDataList);
#line 261 "../src/fb2Reader.vala"
	extractedDataList = _tmp141_;
#line 262 "../src/fb2Reader.vala"
	_tmp142_ = thisParser;
#line 262 "../src/fb2Reader.vala"
	_tmp143_ = bookworm_app_fb2_reader_fb2_location;
#line 262 "../src/fb2Reader.vala"
	_tmp144_ = inputDataList;
#line 262 "../src/fb2Reader.vala"
	_tmp145_ = _g_object_ref0 (_tmp144_);
#line 262 "../src/fb2Reader.vala"
	_tmp146_ = bookworm_app_xml_parser_extractDataFromXML (_tmp142_, _tmp143_, _tmp145_, FALSE);
#line 262 "../src/fb2Reader.vala"
	_g_object_unref0 (extractedDataList);
#line 262 "../src/fb2Reader.vala"
	extractedDataList = _tmp146_;
#line 263 "../src/fb2Reader.vala"
	_tmp147_ = extractedDataList;
#line 263 "../src/fb2Reader.vala"
	_tmp148_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp147_);
#line 263 "../src/fb2Reader.vala"
	_tmp149_ = _tmp148_;
#line 263 "../src/fb2Reader.vala"
	_tmp150_ = g_strdup_printf ("%i", _tmp149_);
#line 263 "../src/fb2Reader.vala"
	_tmp151_ = _tmp150_;
#line 263 "../src/fb2Reader.vala"
	_tmp152_ = g_strconcat ("Number of results for coverpage image XML query:", _tmp151_, NULL);
#line 263 "../src/fb2Reader.vala"
	_tmp153_ = _tmp152_;
#line 263 "../src/fb2Reader.vala"
	g_debug ("fb2Reader.vala:263: %s", _tmp153_);
#line 263 "../src/fb2Reader.vala"
	_g_free0 (_tmp153_);
#line 263 "../src/fb2Reader.vala"
	_g_free0 (_tmp151_);
#line 264 "../src/fb2Reader.vala"
	_tmp155_ = extractedDataList;
#line 264 "../src/fb2Reader.vala"
	_tmp156_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp155_);
#line 264 "../src/fb2Reader.vala"
	_tmp157_ = _tmp156_;
#line 264 "../src/fb2Reader.vala"
	if (_tmp157_ > 0) {
#line 2729 "fb2Reader.c"
		GeeArrayList* _tmp158_;
		gpointer _tmp159_;
		BookwormAppXMLData* _tmp160_;
		GeeArrayList* _tmp161_;
		gint _tmp162_;
		gint _tmp163_;
#line 264 "../src/fb2Reader.vala"
		_tmp158_ = extractedDataList;
#line 264 "../src/fb2Reader.vala"
		_tmp159_ = gee_abstract_list_get ((GeeAbstractList*) _tmp158_, 0);
#line 264 "../src/fb2Reader.vala"
		_tmp160_ = (BookwormAppXMLData*) _tmp159_;
#line 264 "../src/fb2Reader.vala"
		_tmp161_ = _tmp160_->extractedTagValues;
#line 264 "../src/fb2Reader.vala"
		_tmp162_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp161_);
#line 264 "../src/fb2Reader.vala"
		_tmp163_ = _tmp162_;
#line 264 "../src/fb2Reader.vala"
		_tmp154_ = _tmp163_ > 0;
#line 264 "../src/fb2Reader.vala"
		_bookworm_app_xml_data_unref0 (_tmp160_);
#line 2752 "fb2Reader.c"
	} else {
#line 264 "../src/fb2Reader.vala"
		_tmp154_ = FALSE;
#line 2756 "fb2Reader.c"
	}
#line 264 "../src/fb2Reader.vala"
	if (_tmp154_) {
#line 2760 "fb2Reader.c"
		gchar* name_of_cover_image = NULL;
		GeeArrayList* _tmp164_;
		gpointer _tmp165_;
		BookwormAppXMLData* _tmp166_;
		GeeArrayList* _tmp167_;
		gpointer _tmp168_;
		gchar* _tmp169_;
		gchar* _tmp170_;
		gchar* _tmp171_;
		const gchar* _tmp172_;
		gchar* _tmp173_;
		gchar* _tmp174_;
		gboolean _tmp175_ = FALSE;
		const gchar* _tmp176_;
		gint _tmp177_;
		gint _tmp178_;
#line 265 "../src/fb2Reader.vala"
		_tmp164_ = extractedDataList;
#line 265 "../src/fb2Reader.vala"
		_tmp165_ = gee_abstract_list_get ((GeeAbstractList*) _tmp164_, 0);
#line 265 "../src/fb2Reader.vala"
		_tmp166_ = (BookwormAppXMLData*) _tmp165_;
#line 265 "../src/fb2Reader.vala"
		_tmp167_ = _tmp166_->extractedTagValues;
#line 265 "../src/fb2Reader.vala"
		_tmp168_ = gee_abstract_list_get ((GeeAbstractList*) _tmp167_, 0);
#line 265 "../src/fb2Reader.vala"
		_tmp169_ = (gchar*) _tmp168_;
#line 265 "../src/fb2Reader.vala"
		_tmp170_ = bookworm_app_utils_decodeHTMLChars (_tmp169_);
#line 265 "../src/fb2Reader.vala"
		_tmp171_ = _tmp170_;
#line 265 "../src/fb2Reader.vala"
		_g_free0 (_tmp169_);
#line 265 "../src/fb2Reader.vala"
		_bookworm_app_xml_data_unref0 (_tmp166_);
#line 265 "../src/fb2Reader.vala"
		name_of_cover_image = _tmp171_;
#line 266 "../src/fb2Reader.vala"
		_tmp172_ = name_of_cover_image;
#line 266 "../src/fb2Reader.vala"
		_tmp173_ = g_strconcat ("Results of cover page query:", _tmp172_, NULL);
#line 266 "../src/fb2Reader.vala"
		_tmp174_ = _tmp173_;
#line 266 "../src/fb2Reader.vala"
		g_debug ("fb2Reader.vala:266: %s", _tmp174_);
#line 266 "../src/fb2Reader.vala"
		_g_free0 (_tmp174_);
#line 267 "../src/fb2Reader.vala"
		_tmp176_ = name_of_cover_image;
#line 267 "../src/fb2Reader.vala"
		_tmp177_ = strlen (_tmp176_);
#line 267 "../src/fb2Reader.vala"
		_tmp178_ = _tmp177_;
#line 267 "../src/fb2Reader.vala"
		if (_tmp178_ > 1) {
#line 2817 "fb2Reader.c"
			const gchar* _tmp179_;
			gchar** _tmp180_;
			gchar** _tmp181_;
			gchar** _tmp182_;
			gint _tmp182__length1;
#line 267 "../src/fb2Reader.vala"
			_tmp179_ = name_of_cover_image;
#line 267 "../src/fb2Reader.vala"
			_tmp181_ = _tmp180_ = g_strsplit (_tmp179_, " ", 0);
#line 267 "../src/fb2Reader.vala"
			_tmp182_ = _tmp181_;
#line 267 "../src/fb2Reader.vala"
			_tmp182__length1 = _vala_array_length (_tmp180_);
#line 267 "../src/fb2Reader.vala"
			_tmp175_ = _vala_array_length (_tmp180_) > 1;
#line 267 "../src/fb2Reader.vala"
			_tmp182_ = (_vala_array_free (_tmp182_, _tmp182__length1, (GDestroyNotify) g_free), NULL);
#line 2835 "fb2Reader.c"
		} else {
#line 267 "../src/fb2Reader.vala"
			_tmp175_ = FALSE;
#line 2839 "fb2Reader.c"
		}
#line 267 "../src/fb2Reader.vala"
		if (_tmp175_) {
#line 2843 "fb2Reader.c"
			{
				gint i = 0;
#line 268 "../src/fb2Reader.vala"
				i = 0;
#line 2848 "fb2Reader.c"
				{
					gboolean _tmp183_ = FALSE;
#line 268 "../src/fb2Reader.vala"
					_tmp183_ = TRUE;
#line 268 "../src/fb2Reader.vala"
					while (TRUE) {
#line 2855 "fb2Reader.c"
						const gchar* _tmp185_;
						gchar** _tmp186_;
						gchar** _tmp187_;
						gchar** _tmp188_;
						gint _tmp188__length1;
						gboolean _tmp189_;
						gboolean _tmp190_ = FALSE;
						const gchar* _tmp191_;
						gchar** _tmp192_;
						gchar** _tmp193_;
						gchar** _tmp194_;
						gint _tmp194__length1;
						const gchar* _tmp195_;
						gboolean _tmp196_;
#line 268 "../src/fb2Reader.vala"
						if (!_tmp183_) {
#line 2872 "fb2Reader.c"
							gint _tmp184_;
#line 268 "../src/fb2Reader.vala"
							_tmp184_ = i;
#line 268 "../src/fb2Reader.vala"
							i = _tmp184_ + 1;
#line 2878 "fb2Reader.c"
						}
#line 268 "../src/fb2Reader.vala"
						_tmp183_ = FALSE;
#line 268 "../src/fb2Reader.vala"
						_tmp185_ = name_of_cover_image;
#line 268 "../src/fb2Reader.vala"
						_tmp187_ = _tmp186_ = g_strsplit (_tmp185_, " ", 0);
#line 268 "../src/fb2Reader.vala"
						_tmp188_ = _tmp187_;
#line 268 "../src/fb2Reader.vala"
						_tmp188__length1 = _vala_array_length (_tmp186_);
#line 268 "../src/fb2Reader.vala"
						_tmp189_ = !(i < _vala_array_length (_tmp186_));
#line 268 "../src/fb2Reader.vala"
						_tmp188_ = (_vala_array_free (_tmp188_, _tmp188__length1, (GDestroyNotify) g_free), NULL);
#line 268 "../src/fb2Reader.vala"
						if (_tmp189_) {
#line 268 "../src/fb2Reader.vala"
							break;
#line 2898 "fb2Reader.c"
						}
#line 269 "../src/fb2Reader.vala"
						_tmp191_ = name_of_cover_image;
#line 269 "../src/fb2Reader.vala"
						_tmp193_ = _tmp192_ = g_strsplit (_tmp191_, " ", 0);
#line 269 "../src/fb2Reader.vala"
						_tmp194_ = _tmp193_;
#line 269 "../src/fb2Reader.vala"
						_tmp194__length1 = _vala_array_length (_tmp192_);
#line 269 "../src/fb2Reader.vala"
						_tmp195_ = _tmp194_[i];
#line 269 "../src/fb2Reader.vala"
						_tmp196_ = string_contains (_tmp195_, "href");
#line 269 "../src/fb2Reader.vala"
						_tmp194_ = (_vala_array_free (_tmp194_, _tmp194__length1, (GDestroyNotify) g_free), NULL);
#line 269 "../src/fb2Reader.vala"
						if (_tmp196_) {
#line 2916 "fb2Reader.c"
							const gchar* _tmp197_;
							gchar** _tmp198_;
							gchar** _tmp199_;
							gchar** _tmp200_;
							gint _tmp200__length1;
#line 269 "../src/fb2Reader.vala"
							_tmp197_ = name_of_cover_image;
#line 269 "../src/fb2Reader.vala"
							_tmp199_ = _tmp198_ = g_strsplit (_tmp197_, " ", 0);
#line 269 "../src/fb2Reader.vala"
							_tmp200_ = _tmp199_;
#line 269 "../src/fb2Reader.vala"
							_tmp200__length1 = _vala_array_length (_tmp198_);
#line 269 "../src/fb2Reader.vala"
							_tmp190_ = i < _vala_array_length (_tmp198_);
#line 269 "../src/fb2Reader.vala"
							_tmp200_ = (_vala_array_free (_tmp200_, _tmp200__length1, (GDestroyNotify) g_free), NULL);
#line 2934 "fb2Reader.c"
						} else {
#line 269 "../src/fb2Reader.vala"
							_tmp190_ = FALSE;
#line 2938 "fb2Reader.c"
						}
#line 269 "../src/fb2Reader.vala"
						if (_tmp190_) {
#line 2942 "fb2Reader.c"
							const gchar* _tmp201_;
							gchar** _tmp202_;
							gchar** _tmp203_;
							gchar** _tmp204_;
							gint _tmp204__length1;
							const gchar* _tmp205_;
							gchar* _tmp206_;
							const gchar* _tmp207_;
							gchar* _tmp208_;
							gchar* _tmp209_;
							gchar* _tmp210_;
							gchar* _tmp211_;
							gchar* _tmp212_;
							const gchar* _tmp213_;
							gchar* _tmp214_;
							gchar* _tmp215_;
#line 270 "../src/fb2Reader.vala"
							_tmp201_ = name_of_cover_image;
#line 270 "../src/fb2Reader.vala"
							_tmp203_ = _tmp202_ = g_strsplit (_tmp201_, " ", 0);
#line 270 "../src/fb2Reader.vala"
							_tmp204_ = _tmp203_;
#line 270 "../src/fb2Reader.vala"
							_tmp204__length1 = _vala_array_length (_tmp202_);
#line 270 "../src/fb2Reader.vala"
							_tmp205_ = _tmp204_[i + 1];
#line 270 "../src/fb2Reader.vala"
							_tmp206_ = g_strdup (_tmp205_);
#line 270 "../src/fb2Reader.vala"
							_g_free0 (name_of_cover_image);
#line 270 "../src/fb2Reader.vala"
							name_of_cover_image = _tmp206_;
#line 270 "../src/fb2Reader.vala"
							_tmp204_ = (_vala_array_free (_tmp204_, _tmp204__length1, (GDestroyNotify) g_free), NULL);
#line 271 "../src/fb2Reader.vala"
							_tmp207_ = name_of_cover_image;
#line 271 "../src/fb2Reader.vala"
							_tmp208_ = string_replace (_tmp207_, "#", "");
#line 271 "../src/fb2Reader.vala"
							_tmp209_ = _tmp208_;
#line 271 "../src/fb2Reader.vala"
							_tmp210_ = string_replace (_tmp209_, ">", "");
#line 271 "../src/fb2Reader.vala"
							_tmp211_ = _tmp210_;
#line 271 "../src/fb2Reader.vala"
							_tmp212_ = string_strip (_tmp211_);
#line 271 "../src/fb2Reader.vala"
							_g_free0 (name_of_cover_image);
#line 271 "../src/fb2Reader.vala"
							name_of_cover_image = _tmp212_;
#line 271 "../src/fb2Reader.vala"
							_g_free0 (_tmp211_);
#line 271 "../src/fb2Reader.vala"
							_g_free0 (_tmp209_);
#line 272 "../src/fb2Reader.vala"
							_tmp213_ = name_of_cover_image;
#line 272 "../src/fb2Reader.vala"
							_tmp214_ = g_strconcat ("Determined cover image name as:", _tmp213_, NULL);
#line 272 "../src/fb2Reader.vala"
							_tmp215_ = _tmp214_;
#line 272 "../src/fb2Reader.vala"
							g_debug ("fb2Reader.vala:272: %s", _tmp215_);
#line 272 "../src/fb2Reader.vala"
							_g_free0 (_tmp215_);
#line 3007 "fb2Reader.c"
							{
								gboolean _tmp216_ = FALSE;
#line 273 "../src/fb2Reader.vala"
								i = 0;
#line 273 "../src/fb2Reader.vala"
								_tmp216_ = TRUE;
#line 273 "../src/fb2Reader.vala"
								while (TRUE) {
#line 3016 "fb2Reader.c"
									const gchar* _tmp218_;
									gchar* _tmp219_;
									gchar* _tmp220_;
									const gchar* _tmp221_;
									const gchar* _tmp222_;
									gchar* _tmp223_;
									gchar* _tmp224_;
									gboolean _tmp225_;
#line 273 "../src/fb2Reader.vala"
									if (!_tmp216_) {
#line 3027 "fb2Reader.c"
										gint _tmp217_;
#line 273 "../src/fb2Reader.vala"
										_tmp217_ = i;
#line 273 "../src/fb2Reader.vala"
										i = _tmp217_ + 1;
#line 3033 "fb2Reader.c"
									}
#line 273 "../src/fb2Reader.vala"
									_tmp216_ = FALSE;
#line 273 "../src/fb2Reader.vala"
									if (!(i < G_N_ELEMENTS (BOOKWORM_APP_CONSTANTS_FILE_CHOOSER_FILTER_IMAGES))) {
#line 273 "../src/fb2Reader.vala"
										break;
#line 3041 "fb2Reader.c"
									}
#line 275 "../src/fb2Reader.vala"
									_tmp218_ = BOOKWORM_APP_CONSTANTS_FILE_CHOOSER_FILTER_IMAGES[i];
#line 275 "../src/fb2Reader.vala"
									_tmp219_ = g_strconcat ("Checking if cover image is of type:", _tmp218_, NULL);
#line 275 "../src/fb2Reader.vala"
									_tmp220_ = _tmp219_;
#line 275 "../src/fb2Reader.vala"
									g_debug ("fb2Reader.vala:275: %s", _tmp220_);
#line 275 "../src/fb2Reader.vala"
									_g_free0 (_tmp220_);
#line 276 "../src/fb2Reader.vala"
									_tmp221_ = name_of_cover_image;
#line 276 "../src/fb2Reader.vala"
									_tmp222_ = BOOKWORM_APP_CONSTANTS_FILE_CHOOSER_FILTER_IMAGES[i];
#line 276 "../src/fb2Reader.vala"
									_tmp223_ = string_replace (_tmp222_, "*", "");
#line 276 "../src/fb2Reader.vala"
									_tmp224_ = _tmp223_;
#line 276 "../src/fb2Reader.vala"
									_tmp225_ = string_contains (_tmp221_, _tmp224_);
#line 276 "../src/fb2Reader.vala"
									_g_free0 (_tmp224_);
#line 276 "../src/fb2Reader.vala"
									if (_tmp225_) {
#line 3067 "fb2Reader.c"
										const gchar* _tmp226_;
										gchar* _tmp227_;
										gchar* _tmp228_;
										gchar* _tmp229_;
										gchar* _tmp230_;
										const gchar* _tmp231_;
										gchar* _tmp232_;
										const gchar* _tmp233_;
										gchar* _tmp234_;
										gchar* _tmp235_;
#line 277 "../src/fb2Reader.vala"
										_tmp226_ = name_of_cover_image;
#line 277 "../src/fb2Reader.vala"
										_tmp227_ = g_strconcat ("Determined cover image as:", _tmp226_, NULL);
#line 277 "../src/fb2Reader.vala"
										_tmp228_ = _tmp227_;
#line 277 "../src/fb2Reader.vala"
										g_debug ("fb2Reader.vala:277: %s", _tmp228_);
#line 277 "../src/fb2Reader.vala"
										_g_free0 (_tmp228_);
#line 278 "../src/fb2Reader.vala"
										_tmp229_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 278 "../src/fb2Reader.vala"
										_tmp230_ = _tmp229_;
#line 278 "../src/fb2Reader.vala"
										_tmp231_ = name_of_cover_image;
#line 278 "../src/fb2Reader.vala"
										_tmp232_ = bookworm_app_utils_getFullPathFromFilename (_tmp230_, _tmp231_);
#line 278 "../src/fb2Reader.vala"
										_g_free0 (bookCoverLocation);
#line 278 "../src/fb2Reader.vala"
										bookCoverLocation = _tmp232_;
#line 278 "../src/fb2Reader.vala"
										_g_free0 (_tmp230_);
#line 282 "../src/fb2Reader.vala"
										_tmp233_ = bookCoverLocation;
#line 282 "../src/fb2Reader.vala"
										_tmp234_ = g_strconcat ("Overriding image location to:", _tmp233_, NULL);
#line 282 "../src/fb2Reader.vala"
										_tmp235_ = _tmp234_;
#line 282 "../src/fb2Reader.vala"
										g_debug ("fb2Reader.vala:282: %s", _tmp235_);
#line 282 "../src/fb2Reader.vala"
										_g_free0 (_tmp235_);
#line 283 "../src/fb2Reader.vala"
										break;
#line 3114 "fb2Reader.c"
									}
								}
							}
						}
					}
				}
			}
		}
#line 264 "../src/fb2Reader.vala"
		_g_free0 (name_of_cover_image);
#line 3125 "fb2Reader.c"
	}
#line 292 "../src/fb2Reader.vala"
	_tmp237_ = bookCoverLocation;
#line 292 "../src/fb2Reader.vala"
	_tmp238_ = strlen (_tmp237_);
#line 292 "../src/fb2Reader.vala"
	_tmp239_ = _tmp238_;
#line 292 "../src/fb2Reader.vala"
	if (_tmp239_ < 1) {
#line 292 "../src/fb2Reader.vala"
		_tmp236_ = TRUE;
#line 3137 "fb2Reader.c"
	} else {
		const gchar* _tmp240_;
#line 292 "../src/fb2Reader.vala"
		_tmp240_ = bookCoverLocation;
#line 292 "../src/fb2Reader.vala"
		_tmp236_ = g_strcmp0 (_tmp240_, "") == 0;
#line 3144 "fb2Reader.c"
	}
#line 292 "../src/fb2Reader.vala"
	if (_tmp236_) {
#line 3148 "fb2Reader.c"
		gchar* _tmp241_;
		gchar* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
#line 293 "../src/fb2Reader.vala"
		bookworm_app_book_setIsBookCoverImagePresent (aBook, FALSE);
#line 294 "../src/fb2Reader.vala"
		_tmp241_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 294 "../src/fb2Reader.vala"
		_tmp242_ = _tmp241_;
#line 294 "../src/fb2Reader.vala"
		_tmp243_ = g_strconcat ("Cover image not found for book located at:", _tmp242_, NULL);
#line 294 "../src/fb2Reader.vala"
		_tmp244_ = _tmp243_;
#line 294 "../src/fb2Reader.vala"
		g_debug ("fb2Reader.vala:294: %s", _tmp244_);
#line 294 "../src/fb2Reader.vala"
		_g_free0 (_tmp244_);
#line 294 "../src/fb2Reader.vala"
		_g_free0 (_tmp242_);
#line 3169 "fb2Reader.c"
	} else {
		BookwormAppBook* _tmp245_;
		const gchar* _tmp246_;
		BookwormAppBook* _tmp247_;
#line 297 "../src/fb2Reader.vala"
		_tmp245_ = _bookworm_app_book_ref0 (aBook);
#line 297 "../src/fb2Reader.vala"
		_tmp246_ = bookCoverLocation;
#line 297 "../src/fb2Reader.vala"
		_tmp247_ = bookworm_app_utils_setBookCoverImage (_tmp245_, _tmp246_);
#line 297 "../src/fb2Reader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 297 "../src/fb2Reader.vala"
		aBook = _tmp247_;
#line 3184 "fb2Reader.c"
	}
#line 300 "../src/fb2Reader.vala"
	_tmp248_ = bookworm_app_book_getBookLocation (aBook);
#line 300 "../src/fb2Reader.vala"
	_tmp249_ = _tmp248_;
#line 300 "../src/fb2Reader.vala"
	_tmp250_ = g_strconcat ("[END] [FUNCTION:setCoverImage] book.location=", _tmp249_, NULL);
#line 300 "../src/fb2Reader.vala"
	_tmp251_ = _tmp250_;
#line 300 "../src/fb2Reader.vala"
	_tmp252_ = g_strconcat (_tmp251_, ", bookCoverLocation=", NULL);
#line 300 "../src/fb2Reader.vala"
	_tmp253_ = _tmp252_;
#line 300 "../src/fb2Reader.vala"
	_tmp254_ = bookCoverLocation;
#line 300 "../src/fb2Reader.vala"
	_tmp255_ = g_strconcat (_tmp253_, _tmp254_, NULL);
#line 300 "../src/fb2Reader.vala"
	_tmp256_ = _tmp255_;
#line 300 "../src/fb2Reader.vala"
	g_info ("fb2Reader.vala:300: %s", _tmp256_);
#line 300 "../src/fb2Reader.vala"
	_g_free0 (_tmp256_);
#line 300 "../src/fb2Reader.vala"
	_g_free0 (_tmp253_);
#line 300 "../src/fb2Reader.vala"
	_g_free0 (_tmp251_);
#line 300 "../src/fb2Reader.vala"
	_g_free0 (_tmp249_);
#line 301 "../src/fb2Reader.vala"
	_tmp257_ = _bookworm_app_book_ref0 (aBook);
#line 301 "../src/fb2Reader.vala"
	result = _tmp257_;
#line 301 "../src/fb2Reader.vala"
	_g_object_unref0 (image_type);
#line 301 "../src/fb2Reader.vala"
	_g_object_unref0 (image_id);
#line 301 "../src/fb2Reader.vala"
	_g_object_unref0 (extractedDataList);
#line 301 "../src/fb2Reader.vala"
	_bookworm_app_xml_parser_unref0 (thisParser);
#line 301 "../src/fb2Reader.vala"
	_g_object_unref0 (inputDataList);
#line 301 "../src/fb2Reader.vala"
	_g_free0 (bookCoverLocation);
#line 301 "../src/fb2Reader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 301 "../src/fb2Reader.vala"
	return result;
#line 3234 "fb2Reader.c"
}

BookwormAppBook*
bookworm_app_fb2_reader_setBookMetaData (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeArrayList* inputDataList = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BookwormAppXMLData* _tmp9_ = NULL;
	BookwormAppXMLData* _tmp10_;
	GeeArrayList* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	BookwormAppXMLData* _tmp15_ = NULL;
	BookwormAppXMLData* _tmp16_;
	GeeArrayList* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	BookwormAppXMLData* _tmp21_ = NULL;
	BookwormAppXMLData* _tmp22_;
	BookwormAppXmlParser* thisParser = NULL;
	BookwormAppXmlParser* _tmp23_;
	GeeArrayList* extractedDataList = NULL;
	GeeArrayList* _tmp24_;
	BookwormAppXmlParser* _tmp25_;
	const gchar* _tmp26_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	GeeArrayList* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GeeArrayList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gboolean _tmp48_ = FALSE;
	GeeArrayList* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	gboolean _tmp72_ = FALSE;
	GeeArrayList* _tmp73_;
	gint _tmp74_;
	gint _tmp75_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	BookwormAppBook* _tmp102_;
	BookwormAppBook* result;
#line 304 "../src/fb2Reader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 305 "../src/fb2Reader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 305 "../src/fb2Reader.vala"
	_tmp1_ = _tmp0_;
#line 305 "../src/fb2Reader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:setBookMetaData] book.location=", _tmp1_, NULL);
#line 305 "../src/fb2Reader.vala"
	_tmp3_ = _tmp2_;
#line 305 "../src/fb2Reader.vala"
	g_info ("fb2Reader.vala:305: %s", _tmp3_);
#line 305 "../src/fb2Reader.vala"
	_g_free0 (_tmp3_);
#line 305 "../src/fb2Reader.vala"
	_g_free0 (_tmp1_);
#line 308 "../src/fb2Reader.vala"
	bookworm_app_book_setBookAuthor (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE);
#line 309 "../src/fb2Reader.vala"
	bookworm_app_book_setBookTitle (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE);
#line 312 "../src/fb2Reader.vala"
	_tmp4_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 312 "../src/fb2Reader.vala"
	inputDataList = _tmp4_;
#line 313 "../src/fb2Reader.vala"
	_tmp5_ = inputDataList;
#line 313 "../src/fb2Reader.vala"
	_tmp6_ = g_strdup ("author");
#line 313 "../src/fb2Reader.vala"
	_tmp7_ = g_strdup ("first-name");
#line 313 "../src/fb2Reader.vala"
	_tmp8_ = g_strdup ("");
#line 313 "../src/fb2Reader.vala"
	_tmp9_ = bookworm_app_xml_data_new ();
#line 313 "../src/fb2Reader.vala"
	_g_free0 (_tmp9_->containerTagName);
#line 313 "../src/fb2Reader.vala"
	_tmp9_->containerTagName = _tmp6_;
#line 313 "../src/fb2Reader.vala"
	_g_free0 (_tmp9_->inputTagName);
#line 313 "../src/fb2Reader.vala"
	_tmp9_->inputTagName = _tmp7_;
#line 313 "../src/fb2Reader.vala"
	_g_free0 (_tmp9_->inputAttributeName);
#line 313 "../src/fb2Reader.vala"
	_tmp9_->inputAttributeName = _tmp8_;
#line 313 "../src/fb2Reader.vala"
	_tmp10_ = _tmp9_;
#line 313 "../src/fb2Reader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp10_);
#line 313 "../src/fb2Reader.vala"
	_bookworm_app_xml_data_unref0 (_tmp10_);
#line 320 "../src/fb2Reader.vala"
	_tmp11_ = inputDataList;
#line 320 "../src/fb2Reader.vala"
	_tmp12_ = g_strdup ("author");
#line 320 "../src/fb2Reader.vala"
	_tmp13_ = g_strdup ("last-name");
#line 320 "../src/fb2Reader.vala"
	_tmp14_ = g_strdup ("");
#line 320 "../src/fb2Reader.vala"
	_tmp15_ = bookworm_app_xml_data_new ();
#line 320 "../src/fb2Reader.vala"
	_g_free0 (_tmp15_->containerTagName);
#line 320 "../src/fb2Reader.vala"
	_tmp15_->containerTagName = _tmp12_;
#line 320 "../src/fb2Reader.vala"
	_g_free0 (_tmp15_->inputTagName);
#line 320 "../src/fb2Reader.vala"
	_tmp15_->inputTagName = _tmp13_;
#line 320 "../src/fb2Reader.vala"
	_g_free0 (_tmp15_->inputAttributeName);
#line 320 "../src/fb2Reader.vala"
	_tmp15_->inputAttributeName = _tmp14_;
#line 320 "../src/fb2Reader.vala"
	_tmp16_ = _tmp15_;
#line 320 "../src/fb2Reader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp16_);
#line 320 "../src/fb2Reader.vala"
	_bookworm_app_xml_data_unref0 (_tmp16_);
#line 327 "../src/fb2Reader.vala"
	_tmp17_ = inputDataList;
#line 327 "../src/fb2Reader.vala"
	_tmp18_ = g_strdup ("description");
#line 327 "../src/fb2Reader.vala"
	_tmp19_ = g_strdup ("book-title");
#line 327 "../src/fb2Reader.vala"
	_tmp20_ = g_strdup ("");
#line 327 "../src/fb2Reader.vala"
	_tmp21_ = bookworm_app_xml_data_new ();
#line 327 "../src/fb2Reader.vala"
	_g_free0 (_tmp21_->containerTagName);
#line 327 "../src/fb2Reader.vala"
	_tmp21_->containerTagName = _tmp18_;
#line 327 "../src/fb2Reader.vala"
	_g_free0 (_tmp21_->inputTagName);
#line 327 "../src/fb2Reader.vala"
	_tmp21_->inputTagName = _tmp19_;
#line 327 "../src/fb2Reader.vala"
	_g_free0 (_tmp21_->inputAttributeName);
#line 327 "../src/fb2Reader.vala"
	_tmp21_->inputAttributeName = _tmp20_;
#line 327 "../src/fb2Reader.vala"
	_tmp22_ = _tmp21_;
#line 327 "../src/fb2Reader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp22_);
#line 327 "../src/fb2Reader.vala"
	_bookworm_app_xml_data_unref0 (_tmp22_);
#line 334 "../src/fb2Reader.vala"
	_tmp23_ = bookworm_app_xml_parser_new ();
#line 334 "../src/fb2Reader.vala"
	thisParser = _tmp23_;
#line 335 "../src/fb2Reader.vala"
	_tmp24_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 335 "../src/fb2Reader.vala"
	extractedDataList = _tmp24_;
#line 336 "../src/fb2Reader.vala"
	_tmp25_ = thisParser;
#line 336 "../src/fb2Reader.vala"
	_tmp26_ = bookworm_app_fb2_reader_fb2_location;
#line 336 "../src/fb2Reader.vala"
	_tmp27_ = inputDataList;
#line 336 "../src/fb2Reader.vala"
	_tmp28_ = _g_object_ref0 (_tmp27_);
#line 336 "../src/fb2Reader.vala"
	_tmp29_ = bookworm_app_xml_parser_extractDataFromXML (_tmp25_, _tmp26_, _tmp28_, FALSE);
#line 336 "../src/fb2Reader.vala"
	_g_object_unref0 (extractedDataList);
#line 336 "../src/fb2Reader.vala"
	extractedDataList = _tmp29_;
#line 338 "../src/fb2Reader.vala"
	_tmp31_ = extractedDataList;
#line 338 "../src/fb2Reader.vala"
	_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
#line 338 "../src/fb2Reader.vala"
	_tmp33_ = _tmp32_;
#line 338 "../src/fb2Reader.vala"
	if (_tmp33_ > 0) {
#line 3437 "fb2Reader.c"
		GeeArrayList* _tmp34_;
		gpointer _tmp35_;
		BookwormAppXMLData* _tmp36_;
		GeeArrayList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
#line 338 "../src/fb2Reader.vala"
		_tmp34_ = extractedDataList;
#line 338 "../src/fb2Reader.vala"
		_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, 0);
#line 338 "../src/fb2Reader.vala"
		_tmp36_ = (BookwormAppXMLData*) _tmp35_;
#line 338 "../src/fb2Reader.vala"
		_tmp37_ = _tmp36_->extractedTagValues;
#line 338 "../src/fb2Reader.vala"
		_tmp38_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp37_);
#line 338 "../src/fb2Reader.vala"
		_tmp39_ = _tmp38_;
#line 338 "../src/fb2Reader.vala"
		_tmp30_ = _tmp39_ > 0;
#line 338 "../src/fb2Reader.vala"
		_bookworm_app_xml_data_unref0 (_tmp36_);
#line 3460 "fb2Reader.c"
	} else {
#line 338 "../src/fb2Reader.vala"
		_tmp30_ = FALSE;
#line 3464 "fb2Reader.c"
	}
#line 338 "../src/fb2Reader.vala"
	if (_tmp30_) {
#line 3468 "fb2Reader.c"
		GeeArrayList* _tmp40_;
		gpointer _tmp41_;
		BookwormAppXMLData* _tmp42_;
		GeeArrayList* _tmp43_;
		gpointer _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
#line 339 "../src/fb2Reader.vala"
		_tmp40_ = extractedDataList;
#line 339 "../src/fb2Reader.vala"
		_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, 0);
#line 339 "../src/fb2Reader.vala"
		_tmp42_ = (BookwormAppXMLData*) _tmp41_;
#line 339 "../src/fb2Reader.vala"
		_tmp43_ = _tmp42_->extractedTagValues;
#line 339 "../src/fb2Reader.vala"
		_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, 0);
#line 339 "../src/fb2Reader.vala"
		_tmp45_ = (gchar*) _tmp44_;
#line 339 "../src/fb2Reader.vala"
		_tmp46_ = bookworm_app_utils_decodeHTMLChars (_tmp45_);
#line 339 "../src/fb2Reader.vala"
		_tmp47_ = _tmp46_;
#line 339 "../src/fb2Reader.vala"
		bookworm_app_book_setBookAuthor (aBook, _tmp47_);
#line 339 "../src/fb2Reader.vala"
		_g_free0 (_tmp47_);
#line 339 "../src/fb2Reader.vala"
		_g_free0 (_tmp45_);
#line 339 "../src/fb2Reader.vala"
		_bookworm_app_xml_data_unref0 (_tmp42_);
#line 3501 "fb2Reader.c"
	}
#line 342 "../src/fb2Reader.vala"
	_tmp49_ = extractedDataList;
#line 342 "../src/fb2Reader.vala"
	_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp49_);
#line 342 "../src/fb2Reader.vala"
	_tmp51_ = _tmp50_;
#line 342 "../src/fb2Reader.vala"
	if (_tmp51_ > 1) {
#line 3511 "fb2Reader.c"
		GeeArrayList* _tmp52_;
		gpointer _tmp53_;
		BookwormAppXMLData* _tmp54_;
		GeeArrayList* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
#line 342 "../src/fb2Reader.vala"
		_tmp52_ = extractedDataList;
#line 342 "../src/fb2Reader.vala"
		_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp52_, 1);
#line 342 "../src/fb2Reader.vala"
		_tmp54_ = (BookwormAppXMLData*) _tmp53_;
#line 342 "../src/fb2Reader.vala"
		_tmp55_ = _tmp54_->extractedTagValues;
#line 342 "../src/fb2Reader.vala"
		_tmp56_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp55_);
#line 342 "../src/fb2Reader.vala"
		_tmp57_ = _tmp56_;
#line 342 "../src/fb2Reader.vala"
		_tmp48_ = _tmp57_ > 0;
#line 342 "../src/fb2Reader.vala"
		_bookworm_app_xml_data_unref0 (_tmp54_);
#line 3534 "fb2Reader.c"
	} else {
#line 342 "../src/fb2Reader.vala"
		_tmp48_ = FALSE;
#line 3538 "fb2Reader.c"
	}
#line 342 "../src/fb2Reader.vala"
	if (_tmp48_) {
#line 3542 "fb2Reader.c"
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		GeeArrayList* _tmp62_;
		gpointer _tmp63_;
		BookwormAppXMLData* _tmp64_;
		GeeArrayList* _tmp65_;
		gpointer _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
#line 343 "../src/fb2Reader.vala"
		_tmp58_ = bookworm_app_book_getBookAuthor (aBook);
#line 343 "../src/fb2Reader.vala"
		_tmp59_ = _tmp58_;
#line 343 "../src/fb2Reader.vala"
		_tmp60_ = g_strconcat (_tmp59_, " ", NULL);
#line 343 "../src/fb2Reader.vala"
		_tmp61_ = _tmp60_;
#line 343 "../src/fb2Reader.vala"
		_tmp62_ = extractedDataList;
#line 343 "../src/fb2Reader.vala"
		_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) _tmp62_, 1);
#line 343 "../src/fb2Reader.vala"
		_tmp64_ = (BookwormAppXMLData*) _tmp63_;
#line 343 "../src/fb2Reader.vala"
		_tmp65_ = _tmp64_->extractedTagValues;
#line 343 "../src/fb2Reader.vala"
		_tmp66_ = gee_abstract_list_get ((GeeAbstractList*) _tmp65_, 0);
#line 343 "../src/fb2Reader.vala"
		_tmp67_ = (gchar*) _tmp66_;
#line 343 "../src/fb2Reader.vala"
		_tmp68_ = bookworm_app_utils_decodeHTMLChars (_tmp67_);
#line 343 "../src/fb2Reader.vala"
		_tmp69_ = _tmp68_;
#line 343 "../src/fb2Reader.vala"
		_tmp70_ = g_strconcat (_tmp61_, _tmp69_, NULL);
#line 343 "../src/fb2Reader.vala"
		_tmp71_ = _tmp70_;
#line 343 "../src/fb2Reader.vala"
		bookworm_app_book_setBookAuthor (aBook, _tmp71_);
#line 343 "../src/fb2Reader.vala"
		_g_free0 (_tmp71_);
#line 343 "../src/fb2Reader.vala"
		_g_free0 (_tmp69_);
#line 343 "../src/fb2Reader.vala"
		_g_free0 (_tmp67_);
#line 343 "../src/fb2Reader.vala"
		_bookworm_app_xml_data_unref0 (_tmp64_);
#line 343 "../src/fb2Reader.vala"
		_g_free0 (_tmp61_);
#line 343 "../src/fb2Reader.vala"
		_g_free0 (_tmp59_);
#line 3599 "fb2Reader.c"
	}
#line 348 "../src/fb2Reader.vala"
	_tmp73_ = extractedDataList;
#line 348 "../src/fb2Reader.vala"
	_tmp74_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp73_);
#line 348 "../src/fb2Reader.vala"
	_tmp75_ = _tmp74_;
#line 348 "../src/fb2Reader.vala"
	if (_tmp75_ > 2) {
#line 3609 "fb2Reader.c"
		GeeArrayList* _tmp76_;
		gpointer _tmp77_;
		BookwormAppXMLData* _tmp78_;
		GeeArrayList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
#line 348 "../src/fb2Reader.vala"
		_tmp76_ = extractedDataList;
#line 348 "../src/fb2Reader.vala"
		_tmp77_ = gee_abstract_list_get ((GeeAbstractList*) _tmp76_, 2);
#line 348 "../src/fb2Reader.vala"
		_tmp78_ = (BookwormAppXMLData*) _tmp77_;
#line 348 "../src/fb2Reader.vala"
		_tmp79_ = _tmp78_->extractedTagValues;
#line 348 "../src/fb2Reader.vala"
		_tmp80_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp79_);
#line 348 "../src/fb2Reader.vala"
		_tmp81_ = _tmp80_;
#line 348 "../src/fb2Reader.vala"
		_tmp72_ = _tmp81_ > 0;
#line 348 "../src/fb2Reader.vala"
		_bookworm_app_xml_data_unref0 (_tmp78_);
#line 3632 "fb2Reader.c"
	} else {
#line 348 "../src/fb2Reader.vala"
		_tmp72_ = FALSE;
#line 3636 "fb2Reader.c"
	}
#line 348 "../src/fb2Reader.vala"
	if (_tmp72_) {
#line 3640 "fb2Reader.c"
		GeeArrayList* _tmp82_;
		gpointer _tmp83_;
		BookwormAppXMLData* _tmp84_;
		GeeArrayList* _tmp85_;
		gpointer _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
#line 349 "../src/fb2Reader.vala"
		_tmp82_ = extractedDataList;
#line 349 "../src/fb2Reader.vala"
		_tmp83_ = gee_abstract_list_get ((GeeAbstractList*) _tmp82_, 2);
#line 349 "../src/fb2Reader.vala"
		_tmp84_ = (BookwormAppXMLData*) _tmp83_;
#line 349 "../src/fb2Reader.vala"
		_tmp85_ = _tmp84_->extractedTagValues;
#line 349 "../src/fb2Reader.vala"
		_tmp86_ = gee_abstract_list_get ((GeeAbstractList*) _tmp85_, 0);
#line 349 "../src/fb2Reader.vala"
		_tmp87_ = (gchar*) _tmp86_;
#line 349 "../src/fb2Reader.vala"
		_tmp88_ = bookworm_app_utils_decodeHTMLChars (_tmp87_);
#line 349 "../src/fb2Reader.vala"
		_tmp89_ = _tmp88_;
#line 349 "../src/fb2Reader.vala"
		bookworm_app_book_setBookTitle (aBook, _tmp89_);
#line 349 "../src/fb2Reader.vala"
		_g_free0 (_tmp89_);
#line 349 "../src/fb2Reader.vala"
		_g_free0 (_tmp87_);
#line 349 "../src/fb2Reader.vala"
		_bookworm_app_xml_data_unref0 (_tmp84_);
#line 3673 "fb2Reader.c"
	}
#line 351 "../src/fb2Reader.vala"
	_tmp90_ = bookworm_app_book_getBookAuthor (aBook);
#line 351 "../src/fb2Reader.vala"
	_tmp91_ = _tmp90_;
#line 351 "../src/fb2Reader.vala"
	_tmp92_ = g_strconcat ("[END] [FUNCTION:setBookMetaData] Determined author[", _tmp91_, NULL);
#line 351 "../src/fb2Reader.vala"
	_tmp93_ = _tmp92_;
#line 351 "../src/fb2Reader.vala"
	_tmp94_ = g_strconcat (_tmp93_, "] and title[", NULL);
#line 351 "../src/fb2Reader.vala"
	_tmp95_ = _tmp94_;
#line 351 "../src/fb2Reader.vala"
	_tmp96_ = bookworm_app_book_getBookTitle (aBook);
#line 351 "../src/fb2Reader.vala"
	_tmp97_ = _tmp96_;
#line 351 "../src/fb2Reader.vala"
	_tmp98_ = g_strconcat (_tmp95_, _tmp97_, NULL);
#line 351 "../src/fb2Reader.vala"
	_tmp99_ = _tmp98_;
#line 351 "../src/fb2Reader.vala"
	_tmp100_ = g_strconcat (_tmp99_, "]", NULL);
#line 351 "../src/fb2Reader.vala"
	_tmp101_ = _tmp100_;
#line 351 "../src/fb2Reader.vala"
	g_info ("fb2Reader.vala:351: %s", _tmp101_);
#line 351 "../src/fb2Reader.vala"
	_g_free0 (_tmp101_);
#line 351 "../src/fb2Reader.vala"
	_g_free0 (_tmp99_);
#line 351 "../src/fb2Reader.vala"
	_g_free0 (_tmp97_);
#line 351 "../src/fb2Reader.vala"
	_g_free0 (_tmp95_);
#line 351 "../src/fb2Reader.vala"
	_g_free0 (_tmp93_);
#line 351 "../src/fb2Reader.vala"
	_g_free0 (_tmp91_);
#line 352 "../src/fb2Reader.vala"
	_tmp102_ = _bookworm_app_book_ref0 (aBook);
#line 352 "../src/fb2Reader.vala"
	result = _tmp102_;
#line 352 "../src/fb2Reader.vala"
	_g_object_unref0 (extractedDataList);
#line 352 "../src/fb2Reader.vala"
	_bookworm_app_xml_parser_unref0 (thisParser);
#line 352 "../src/fb2Reader.vala"
	_g_object_unref0 (inputDataList);
#line 352 "../src/fb2Reader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 352 "../src/fb2Reader.vala"
	return result;
#line 3727 "fb2Reader.c"
}

BookwormAppfb2Reader*
bookworm_app_fb2_reader_construct (GType object_type)
{
	BookwormAppfb2Reader* self = NULL;
#line 22 "../src/fb2Reader.vala"
	self = (BookwormAppfb2Reader*) g_type_create_instance (object_type);
#line 22 "../src/fb2Reader.vala"
	return self;
#line 3738 "fb2Reader.c"
}

BookwormAppfb2Reader*
bookworm_app_fb2_reader_new (void)
{
#line 22 "../src/fb2Reader.vala"
	return bookworm_app_fb2_reader_construct (BOOKWORM_APP_TYPE_FB2_READER);
#line 3746 "fb2Reader.c"
}

static void
bookworm_app_value_fb2_reader_init (GValue* value)
{
#line 22 "../src/fb2Reader.vala"
	value->data[0].v_pointer = NULL;
#line 3754 "fb2Reader.c"
}

static void
bookworm_app_value_fb2_reader_free_value (GValue* value)
{
#line 22 "../src/fb2Reader.vala"
	if (value->data[0].v_pointer) {
#line 22 "../src/fb2Reader.vala"
		bookworm_app_fb2_reader_unref (value->data[0].v_pointer);
#line 3764 "fb2Reader.c"
	}
}

static void
bookworm_app_value_fb2_reader_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
#line 22 "../src/fb2Reader.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "../src/fb2Reader.vala"
		dest_value->data[0].v_pointer = bookworm_app_fb2_reader_ref (src_value->data[0].v_pointer);
#line 3776 "fb2Reader.c"
	} else {
#line 22 "../src/fb2Reader.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3780 "fb2Reader.c"
	}
}

static gpointer
bookworm_app_value_fb2_reader_peek_pointer (const GValue* value)
{
#line 22 "../src/fb2Reader.vala"
	return value->data[0].v_pointer;
#line 3789 "fb2Reader.c"
}

static gchar*
bookworm_app_value_fb2_reader_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
#line 22 "../src/fb2Reader.vala"
	if (collect_values[0].v_pointer) {
#line 3800 "fb2Reader.c"
		BookwormAppfb2Reader * object;
		object = collect_values[0].v_pointer;
#line 22 "../src/fb2Reader.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "../src/fb2Reader.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3807 "fb2Reader.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "../src/fb2Reader.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3811 "fb2Reader.c"
		}
#line 22 "../src/fb2Reader.vala"
		value->data[0].v_pointer = bookworm_app_fb2_reader_ref (object);
#line 3815 "fb2Reader.c"
	} else {
#line 22 "../src/fb2Reader.vala"
		value->data[0].v_pointer = NULL;
#line 3819 "fb2Reader.c"
	}
#line 22 "../src/fb2Reader.vala"
	return NULL;
#line 3823 "fb2Reader.c"
}

static gchar*
bookworm_app_value_fb2_reader_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	BookwormAppfb2Reader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "../src/fb2Reader.vala"
	if (!object_p) {
#line 22 "../src/fb2Reader.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3838 "fb2Reader.c"
	}
#line 22 "../src/fb2Reader.vala"
	if (!value->data[0].v_pointer) {
#line 22 "../src/fb2Reader.vala"
		*object_p = NULL;
#line 3844 "fb2Reader.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "../src/fb2Reader.vala"
		*object_p = value->data[0].v_pointer;
#line 3848 "fb2Reader.c"
	} else {
#line 22 "../src/fb2Reader.vala"
		*object_p = bookworm_app_fb2_reader_ref (value->data[0].v_pointer);
#line 3852 "fb2Reader.c"
	}
#line 22 "../src/fb2Reader.vala"
	return NULL;
#line 3856 "fb2Reader.c"
}

GParamSpec*
bookworm_app_param_spec_fb2_reader (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	BookwormAppParamSpecfb2Reader* spec;
#line 22 "../src/fb2Reader.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_FB2_READER), NULL);
#line 22 "../src/fb2Reader.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "../src/fb2Reader.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "../src/fb2Reader.vala"
	return G_PARAM_SPEC (spec);
#line 3875 "fb2Reader.c"
}

gpointer
bookworm_app_value_get_fb2_reader (const GValue* value)
{
#line 22 "../src/fb2Reader.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_FB2_READER), NULL);
#line 22 "../src/fb2Reader.vala"
	return value->data[0].v_pointer;
#line 3885 "fb2Reader.c"
}

void
bookworm_app_value_set_fb2_reader (GValue* value,
                                   gpointer v_object)
{
	BookwormAppfb2Reader * old;
#line 22 "../src/fb2Reader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_FB2_READER));
#line 22 "../src/fb2Reader.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/fb2Reader.vala"
	if (v_object) {
#line 22 "../src/fb2Reader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_FB2_READER));
#line 22 "../src/fb2Reader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/fb2Reader.vala"
		value->data[0].v_pointer = v_object;
#line 22 "../src/fb2Reader.vala"
		bookworm_app_fb2_reader_ref (value->data[0].v_pointer);
#line 3907 "fb2Reader.c"
	} else {
#line 22 "../src/fb2Reader.vala"
		value->data[0].v_pointer = NULL;
#line 3911 "fb2Reader.c"
	}
#line 22 "../src/fb2Reader.vala"
	if (old) {
#line 22 "../src/fb2Reader.vala"
		bookworm_app_fb2_reader_unref (old);
#line 3917 "fb2Reader.c"
	}
}

void
bookworm_app_value_take_fb2_reader (GValue* value,
                                    gpointer v_object)
{
	BookwormAppfb2Reader * old;
#line 22 "../src/fb2Reader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_FB2_READER));
#line 22 "../src/fb2Reader.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/fb2Reader.vala"
	if (v_object) {
#line 22 "../src/fb2Reader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_FB2_READER));
#line 22 "../src/fb2Reader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/fb2Reader.vala"
		value->data[0].v_pointer = v_object;
#line 3938 "fb2Reader.c"
	} else {
#line 22 "../src/fb2Reader.vala"
		value->data[0].v_pointer = NULL;
#line 3942 "fb2Reader.c"
	}
#line 22 "../src/fb2Reader.vala"
	if (old) {
#line 22 "../src/fb2Reader.vala"
		bookworm_app_fb2_reader_unref (old);
#line 3948 "fb2Reader.c"
	}
}

static void
bookworm_app_fb2_reader_class_init (BookwormAppfb2ReaderClass * klass,
                                    gpointer klass_data)
{
	gchar* _tmp0_;
#line 22 "../src/fb2Reader.vala"
	bookworm_app_fb2_reader_parent_class = g_type_class_peek_parent (klass);
#line 22 "../src/fb2Reader.vala"
	((BookwormAppfb2ReaderClass *) klass)->finalize = bookworm_app_fb2_reader_finalize;
#line 24 "../src/fb2Reader.vala"
	_tmp0_ = g_strdup ("");
#line 24 "../src/fb2Reader.vala"
	bookworm_app_fb2_reader_fb2_location = _tmp0_;
#line 3965 "fb2Reader.c"
}

static void
bookworm_app_fb2_reader_instance_init (BookwormAppfb2Reader * self,
                                       gpointer klass)
{
#line 22 "../src/fb2Reader.vala"
	self->ref_count = 1;
#line 3974 "fb2Reader.c"
}

static void
bookworm_app_fb2_reader_finalize (BookwormAppfb2Reader * obj)
{
	BookwormAppfb2Reader * self;
#line 22 "../src/fb2Reader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_FB2_READER, BookwormAppfb2Reader);
#line 22 "../src/fb2Reader.vala"
	g_signal_handlers_destroy (self);
#line 3985 "fb2Reader.c"
}

static GType
bookworm_app_fb2_reader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_fb2_reader_init, bookworm_app_value_fb2_reader_free_value, bookworm_app_value_fb2_reader_copy_value, bookworm_app_value_fb2_reader_peek_pointer, "p", bookworm_app_value_fb2_reader_collect_value, "p", bookworm_app_value_fb2_reader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppfb2ReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_fb2_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppfb2Reader), 0, (GInstanceInitFunc) bookworm_app_fb2_reader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_fb2_reader_type_id;
	bookworm_app_fb2_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppfb2Reader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_fb2_reader_type_id;
}

GType
bookworm_app_fb2_reader_get_type (void)
{
	static volatile gsize bookworm_app_fb2_reader_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_fb2_reader_type_id__once)) {
		GType bookworm_app_fb2_reader_type_id;
		bookworm_app_fb2_reader_type_id = bookworm_app_fb2_reader_get_type_once ();
		g_once_init_leave (&bookworm_app_fb2_reader_type_id__once, bookworm_app_fb2_reader_type_id);
	}
	return bookworm_app_fb2_reader_type_id__once;
}

gpointer
bookworm_app_fb2_reader_ref (gpointer instance)
{
	BookwormAppfb2Reader * self;
	self = instance;
#line 22 "../src/fb2Reader.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "../src/fb2Reader.vala"
	return instance;
#line 4020 "fb2Reader.c"
}

void
bookworm_app_fb2_reader_unref (gpointer instance)
{
	BookwormAppfb2Reader * self;
	self = instance;
#line 22 "../src/fb2Reader.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "../src/fb2Reader.vala"
		BOOKWORM_APP_FB2_READER_GET_CLASS (self)->finalize (self);
#line 22 "../src/fb2Reader.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4034 "fb2Reader.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

