/* keyboard.c generated by valac 0.56.18, the Vala compiler
 * generated from keyboard.vala, do not modify */

/* keyboard.vala
 *
 * Copyright 2022 Vojtěch Perník
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <adwaita.h>
#include <float.h>
#include <math.h>
#include <errno.h>

#define WG_KEYBOARD_MARGIN 6
#define WG_KEYBOARD_SPACING 4
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WG_TYPE_KEYBOARD (wg_keyboard_get_type ())
#define WG_KEYBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WG_TYPE_KEYBOARD, WGKeyboard))
#define WG_KEYBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WG_TYPE_KEYBOARD, WGKeyboardClass))
#define WG_IS_KEYBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WG_TYPE_KEYBOARD))
#define WG_IS_KEYBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WG_TYPE_KEYBOARD))
#define WG_KEYBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WG_TYPE_KEYBOARD, WGKeyboardClass))

typedef struct _WGKeyboard WGKeyboard;
typedef struct _WGKeyboardClass WGKeyboardClass;
typedef struct _WGKeyboardPrivate WGKeyboardPrivate;

#define WG_TYPE_KEY (wg_key_get_type ())
#define WG_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WG_TYPE_KEY, WGKey))
#define WG_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WG_TYPE_KEY, WGKeyClass))
#define WG_IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WG_TYPE_KEY))
#define WG_IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WG_TYPE_KEY))
#define WG_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WG_TYPE_KEY, WGKeyClass))

typedef struct _WGKey WGKey;
typedef struct _WGKeyClass WGKeyClass;
enum  {
	WG_KEYBOARD_0_PROPERTY,
	WG_KEYBOARD_GAME_OVER_PROPERTY,
	WG_KEYBOARD_NUM_PROPERTIES
};
static GParamSpec* wg_keyboard_properties[WG_KEYBOARD_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef enum  {
	WG_CELL_STATE_CORRECT,
	WG_CELL_STATE_WRONG,
	WG_CELL_STATE_WRONG_POSITION,
	WG_CELL_STATE_UNKNOWN,
	WG_CELL_STATE_NONE
} WGCellState;

#define WG_TYPE_CELL_STATE (wg_cell_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	WG_KEYBOARD_INSERT_SIGNAL,
	WG_KEYBOARD_BACKSPACE_SIGNAL,
	WG_KEYBOARD_ENTER_SIGNAL,
	WG_KEYBOARD_NUM_SIGNALS
};
static guint wg_keyboard_signals[WG_KEYBOARD_NUM_SIGNALS] = {0};

struct _WGKeyboard {
	GtkBox parent_instance;
	WGKeyboardPrivate * priv;
};

struct _WGKeyboardClass {
	GtkBoxClass parent_class;
};

struct _WGKeyboardPrivate {
	gboolean _game_over;
	GHashTable* keys;
};

static gint WGKeyboard_private_offset;
static gpointer wg_keyboard_parent_class = NULL;

VALA_EXTERN GType wg_keyboard_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WGKeyboard, g_object_unref)
VALA_EXTERN GType wg_key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WGKey, g_object_unref)
VALA_EXTERN WGKeyboard* wg_keyboard_new (void);
VALA_EXTERN WGKeyboard* wg_keyboard_construct (GType object_type);
VALA_EXTERN void wg_keyboard_reset (WGKeyboard* self);
VALA_EXTERN GType wg_cell_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void wg_key_set_state (WGKey* self,
                       WGCellState value);
VALA_EXTERN void wg_keyboard_set_key_state (WGKeyboard* self,
                                const gchar* val,
                                WGCellState state);
static void wg_keyboard_clicked (WGKeyboard* self,
                          const gchar* val);
VALA_EXTERN gboolean wg_keyboard_get_game_over (WGKeyboard* self);
VALA_EXTERN void wg_keyboard_set_game_over (WGKeyboard* self,
                                gboolean value);
static GObject * wg_keyboard_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN gchar* wg_data_get_keyboard (void);
static gdouble* _double_dup (gdouble* self);
VALA_EXTERN WGKey* wg_key_new (const gchar* display_val,
                   const gchar* val,
                   gdouble size,
                   gint spacing);
VALA_EXTERN WGKey* wg_key_construct (GType object_type,
                         const gchar* display_val,
                         const gchar* val,
                         gdouble size,
                         gint spacing);
VALA_EXTERN const gchar* wg_key_get_val (WGKey* self);
static void _wg_keyboard_clicked_wg_key_clicked (WGKey* _sender,
                                          const gchar* val,
                                          gpointer self);
static void _wg_keyboard___lambda12_ (WGKeyboard* self);
static void __wg_keyboard___lambda12__g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self);
static void wg_keyboard_finalize (GObject * obj);
static GType wg_keyboard_get_type_once (void);
static void _vala_wg_keyboard_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_wg_keyboard_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
wg_keyboard_get_instance_private (WGKeyboard* self)
{
	return G_STRUCT_MEMBER_P (self, WGKeyboard_private_offset);
}

WGKeyboard*
wg_keyboard_construct (GType object_type)
{
	WGKeyboard * self = NULL;
	self = (WGKeyboard*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", WG_KEYBOARD_SPACING, NULL);
	return self;
}

WGKeyboard*
wg_keyboard_new (void)
{
	return wg_keyboard_construct (WG_TYPE_KEYBOARD);
}

void
wg_keyboard_reset (WGKeyboard* self)
{
	GList* _keys = NULL;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->keys;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	_keys = _tmp1_;
	_tmp2_ = _keys;
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp2_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			WGKey* key = NULL;
			key = (WGKey*) key_it->data;
			{
				WGKey* _tmp3_;
				_tmp3_ = key;
				wg_key_set_state (_tmp3_, WG_CELL_STATE_NONE);
			}
		}
	}
	(_keys == NULL) ? NULL : (_keys = (g_list_free (_keys), NULL));
}

void
wg_keyboard_set_key_state (WGKeyboard* self,
                           const gchar* val,
                           WGCellState state)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->keys;
	if (!g_hash_table_contains (_tmp0_, val)) {
		return;
	}
	_tmp1_ = self->priv->keys;
	_tmp2_ = g_hash_table_lookup (_tmp1_, val);
	wg_key_set_state ((WGKey*) _tmp2_, state);
}

static void
wg_keyboard_clicked (WGKeyboard* self,
                     const gchar* val)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("enter")))) {
		switch (0) {
			default:
			{
				g_signal_emit (self, wg_keyboard_signals[WG_KEYBOARD_ENTER_SIGNAL], 0);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("backspace")))) {
		switch (0) {
			default:
			{
				g_signal_emit (self, wg_keyboard_signals[WG_KEYBOARD_BACKSPACE_SIGNAL], 0);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_signal_emit (self, wg_keyboard_signals[WG_KEYBOARD_INSERT_SIGNAL], 0, val);
				break;
			}
		}
	}
}

gboolean
wg_keyboard_get_game_over (WGKeyboard* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_game_over;
	return result;
}

void
wg_keyboard_set_game_over (WGKeyboard* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = wg_keyboard_get_game_over (self);
	if (old_value != value) {
		self->priv->_game_over = value;
		g_object_notify_by_pspec ((GObject *) self, wg_keyboard_properties[WG_KEYBOARD_GAME_OVER_PROPERTY]);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
double_try_parse (const gchar* str,
                  gdouble* _result_,
                  const gchar** unparsed)
{
	gdouble _vala__result_ = 0.0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = errno != ERANGE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_wg_keyboard_clicked_wg_key_clicked (WGKey* _sender,
                                     const gchar* val,
                                     gpointer self)
{
	wg_keyboard_clicked ((WGKeyboard*) self, val);
}

static void
_wg_keyboard___lambda12_ (WGKeyboard* self)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->_game_over;
	gtk_widget_set_sensitive ((GtkWidget*) self, !_tmp0_);
}

static void
__wg_keyboard___lambda12__g_object_notify (GObject* _sender,
                                           GParamSpec* pspec,
                                           gpointer self)
{
	_wg_keyboard___lambda12_ ((WGKeyboard*) self);
}

static GObject *
wg_keyboard_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WGKeyboard * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	parent_class = G_OBJECT_CLASS (wg_keyboard_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WG_TYPE_KEYBOARD, WGKeyboard);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->keys);
	self->priv->keys = _tmp2_;
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) self, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 6);
	gtk_widget_set_margin_start ((GtkWidget*) self, 6);
	gtk_widget_set_margin_end ((GtkWidget*) self, 6);
	_tmp3_ = wg_data_get_keyboard ();
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ";", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_free0 (_tmp4_);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp7_;
		line_collection_length1 = _tmp7__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp8_;
			gchar* line = NULL;
			_tmp8_ = g_strdup (line_collection[line_it]);
			line = _tmp8_;
			{
				GtkBox* box = NULL;
				GtkBox* _tmp9_;
				GtkBox* _tmp10_;
				GtkBox* _tmp11_;
				GtkBox* _tmp12_;
				const gchar* _tmp13_;
				gchar** _tmp14_;
				gchar** _tmp15_;
				_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, WG_KEYBOARD_SPACING);
				g_object_ref_sink (_tmp9_);
				box = _tmp9_;
				_tmp10_ = box;
				gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp10_);
				_tmp11_ = box;
				gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
				_tmp12_ = box;
				gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
				_tmp13_ = line;
				_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, ",", 0);
				{
					gchar** _key_str_collection = NULL;
					gint _key_str_collection_length1 = 0;
					gint __key_str_collection_size_ = 0;
					gint _key_str_it = 0;
					_key_str_collection = _tmp15_;
					_key_str_collection_length1 = _vala_array_length (_tmp14_);
					for (_key_str_it = 0; _key_str_it < _key_str_collection_length1; _key_str_it = _key_str_it + 1) {
						gchar* _tmp16_;
						gchar* _key_str = NULL;
						_tmp16_ = g_strdup (_key_str_collection[_key_str_it]);
						_key_str = _tmp16_;
						{
							gchar* _key = NULL;
							const gchar* _tmp17_;
							gchar* _tmp18_;
							const gchar* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							gchar** parts = NULL;
							const gchar* _tmp23_;
							gchar** _tmp24_;
							gchar** _tmp25_;
							gint parts_length1;
							gint _parts_size_;
							gchar** _tmp26_;
							gint _tmp26__length1;
							gchar* display_val = NULL;
							gchar* val = NULL;
							gdouble* size = NULL;
							gchar** _tmp27_;
							gint _tmp27__length1;
							const gchar* _tmp52_;
							gdouble* _tmp53_;
							WGKey* key = NULL;
							const gchar* _tmp56_;
							const gchar* _tmp57_;
							gdouble* _tmp58_;
							WGKey* _tmp59_;
							GHashTable* _tmp60_;
							WGKey* _tmp61_;
							const gchar* _tmp62_;
							const gchar* _tmp63_;
							GHashTable* _tmp64_;
							WGKey* _tmp65_;
							const gchar* _tmp66_;
							const gchar* _tmp67_;
							gchar* _tmp68_;
							WGKey* _tmp69_;
							WGKey* _tmp70_;
							GtkBox* _tmp71_;
							WGKey* _tmp72_;
							WGKey* _tmp73_;
							_tmp17_ = _key_str;
							_tmp18_ = string_strip (_tmp17_);
							_key = _tmp18_;
							_tmp19_ = _key;
							_tmp20_ = string_replace (_tmp19_, "{", "");
							_tmp21_ = _tmp20_;
							_tmp22_ = string_replace (_tmp21_, "}", "");
							_g_free0 (_key);
							_key = _tmp22_;
							_g_free0 (_tmp21_);
							_tmp23_ = _key;
							_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "/", 0);
							parts = _tmp25_;
							parts_length1 = _vala_array_length (_tmp24_);
							_parts_size_ = parts_length1;
							_tmp26_ = parts;
							_tmp26__length1 = parts_length1;
							if (_tmp26__length1 <= 0) {
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (_key);
								_g_free0 (_key_str);
								continue;
							}
							display_val = NULL;
							val = NULL;
							size = NULL;
							_tmp27_ = parts;
							_tmp27__length1 = parts_length1;
							{
								gchar** _part_collection = NULL;
								gint _part_collection_length1 = 0;
								gint __part_collection_size_ = 0;
								gint _part_it = 0;
								_part_collection = _tmp27_;
								_part_collection_length1 = _tmp27__length1;
								for (_part_it = 0; _part_it < _part_collection_length1; _part_it = _part_it + 1) {
									gchar* _tmp28_;
									gchar* _part = NULL;
									_tmp28_ = g_strdup (_part_collection[_part_it]);
									_part = _tmp28_;
									{
										gboolean _tmp29_ = FALSE;
										gboolean _tmp30_ = FALSE;
										const gchar* _tmp31_;
										gchar* part = NULL;
										const gchar* _tmp34_;
										gchar* _tmp35_;
										const gchar* _tmp36_;
										gint _tmp37_;
										gint _tmp38_;
										const gchar* _tmp39_;
										gdouble _parsed = 0.0;
										gboolean _tmp42_ = FALSE;
										gdouble* _tmp43_;
										const gchar* _tmp49_;
										_tmp31_ = display_val;
										if (_tmp31_ != NULL) {
											const gchar* _tmp32_;
											_tmp32_ = val;
											_tmp30_ = _tmp32_ != NULL;
										} else {
											_tmp30_ = FALSE;
										}
										if (_tmp30_) {
											gdouble* _tmp33_;
											_tmp33_ = size;
											_tmp29_ = _tmp33_ != NULL;
										} else {
											_tmp29_ = FALSE;
										}
										if (_tmp29_) {
											_g_free0 (_part);
											break;
										}
										_tmp34_ = _part;
										_tmp35_ = string_strip (_tmp34_);
										part = _tmp35_;
										_tmp36_ = part;
										_tmp37_ = strlen (_tmp36_);
										_tmp38_ = _tmp37_;
										if (_tmp38_ == 0) {
											_g_free0 (part);
											_g_free0 (_part);
											continue;
										}
										_tmp39_ = display_val;
										if (_tmp39_ == NULL) {
											const gchar* _tmp40_;
											gchar* _tmp41_;
											_tmp40_ = part;
											_tmp41_ = g_strdup (_tmp40_);
											_g_free0 (display_val);
											display_val = _tmp41_;
											_g_free0 (part);
											_g_free0 (_part);
											continue;
										}
										_parsed = (gdouble) -1;
										_tmp43_ = size;
										if (_tmp43_ == NULL) {
											const gchar* _tmp44_;
											gdouble _tmp45_ = 0.0;
											gboolean _tmp46_;
											_tmp44_ = part;
											_tmp46_ = double_try_parse (_tmp44_, &_tmp45_, NULL);
											_parsed = _tmp45_;
											_tmp42_ = _tmp46_;
										} else {
											_tmp42_ = FALSE;
										}
										if (_tmp42_) {
											gdouble _tmp47_ = 0.0;
											gdouble* _tmp48_;
											if (_parsed < ((gdouble) 1)) {
												_tmp47_ = (gdouble) 1;
											} else {
												_tmp47_ = _parsed;
											}
											_tmp48_ = __double_dup0 (&_tmp47_);
											_g_free0 (size);
											size = _tmp48_;
											_g_free0 (part);
											_g_free0 (_part);
											continue;
										}
										_tmp49_ = val;
										if (_tmp49_ == NULL) {
											const gchar* _tmp50_;
											gchar* _tmp51_;
											_tmp50_ = part;
											_tmp51_ = g_strdup (_tmp50_);
											_g_free0 (val);
											val = _tmp51_;
										}
										_g_free0 (part);
										_g_free0 (_part);
									}
								}
							}
							_tmp52_ = display_val;
							if (_tmp52_ == NULL) {
								_g_free0 (size);
								_g_free0 (val);
								_g_free0 (display_val);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (_key);
								_g_free0 (_key_str);
								continue;
							}
							_tmp53_ = size;
							if (_tmp53_ == NULL) {
								gdouble _tmp54_;
								gdouble* _tmp55_;
								_tmp54_ = (gdouble) 1;
								_tmp55_ = __double_dup0 (&_tmp54_);
								_g_free0 (size);
								size = _tmp55_;
							}
							_tmp56_ = display_val;
							_tmp57_ = val;
							_tmp58_ = size;
							_tmp59_ = wg_key_new (_tmp56_, _tmp57_, *_tmp58_, WG_KEYBOARD_SPACING);
							g_object_ref_sink (_tmp59_);
							key = _tmp59_;
							_tmp60_ = self->priv->keys;
							_tmp61_ = key;
							_tmp62_ = wg_key_get_val (_tmp61_);
							_tmp63_ = _tmp62_;
							if (g_hash_table_contains (_tmp60_, _tmp63_)) {
								_g_object_unref0 (key);
								_g_free0 (size);
								_g_free0 (val);
								_g_free0 (display_val);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (_key);
								_g_free0 (_key_str);
								continue;
							}
							_tmp64_ = self->priv->keys;
							_tmp65_ = key;
							_tmp66_ = wg_key_get_val (_tmp65_);
							_tmp67_ = _tmp66_;
							_tmp68_ = g_strdup (_tmp67_);
							_tmp69_ = key;
							_tmp70_ = _g_object_ref0 (_tmp69_);
							g_hash_table_insert (_tmp64_, _tmp68_, _tmp70_);
							_tmp71_ = box;
							_tmp72_ = key;
							gtk_box_append (_tmp71_, (GtkWidget*) _tmp72_);
							_tmp73_ = key;
							g_signal_connect_object (_tmp73_, "clicked", (GCallback) _wg_keyboard_clicked_wg_key_clicked, self, 0);
							_g_object_unref0 (key);
							_g_free0 (size);
							_g_free0 (val);
							_g_free0 (display_val);
							parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (_key);
							_g_free0 (_key_str);
						}
					}
					_key_str_collection = (_vala_array_free (_key_str_collection, _key_str_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_object_unref0 (box);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	g_signal_connect_object ((GObject*) self, "notify::game-over", (GCallback) __wg_keyboard___lambda12__g_object_notify, self, 0);
	return obj;
}

static void
wg_keyboard_class_init (WGKeyboardClass * klass,
                        gpointer klass_data)
{
	wg_keyboard_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WGKeyboard_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_wg_keyboard_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_wg_keyboard_set_property;
	G_OBJECT_CLASS (klass)->constructor = wg_keyboard_constructor;
	G_OBJECT_CLASS (klass)->finalize = wg_keyboard_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_KEYBOARD_GAME_OVER_PROPERTY, wg_keyboard_properties[WG_KEYBOARD_GAME_OVER_PROPERTY] = g_param_spec_boolean ("game-over", "game-over", "game-over", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	wg_keyboard_signals[WG_KEYBOARD_INSERT_SIGNAL] = g_signal_new ("insert", WG_TYPE_KEYBOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	wg_keyboard_signals[WG_KEYBOARD_BACKSPACE_SIGNAL] = g_signal_new ("backspace", WG_TYPE_KEYBOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	wg_keyboard_signals[WG_KEYBOARD_ENTER_SIGNAL] = g_signal_new ("enter", WG_TYPE_KEYBOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
wg_keyboard_instance_init (WGKeyboard * self,
                           gpointer klass)
{
	self->priv = wg_keyboard_get_instance_private (self);
	self->priv->_game_over = FALSE;
}

static void
wg_keyboard_finalize (GObject * obj)
{
	WGKeyboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WG_TYPE_KEYBOARD, WGKeyboard);
	_g_hash_table_unref0 (self->priv->keys);
	G_OBJECT_CLASS (wg_keyboard_parent_class)->finalize (obj);
}

static GType
wg_keyboard_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WGKeyboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wg_keyboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WGKeyboard), 0, (GInstanceInitFunc) wg_keyboard_instance_init, NULL };
	GType wg_keyboard_type_id;
	wg_keyboard_type_id = g_type_register_static (gtk_box_get_type (), "WGKeyboard", &g_define_type_info, 0);
	WGKeyboard_private_offset = g_type_add_instance_private (wg_keyboard_type_id, sizeof (WGKeyboardPrivate));
	return wg_keyboard_type_id;
}

GType
wg_keyboard_get_type (void)
{
	static volatile gsize wg_keyboard_type_id__once = 0;
	if (g_once_init_enter (&wg_keyboard_type_id__once)) {
		GType wg_keyboard_type_id;
		wg_keyboard_type_id = wg_keyboard_get_type_once ();
		g_once_init_leave (&wg_keyboard_type_id__once, wg_keyboard_type_id);
	}
	return wg_keyboard_type_id__once;
}

static void
_vala_wg_keyboard_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	WGKeyboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WG_TYPE_KEYBOARD, WGKeyboard);
	switch (property_id) {
		case WG_KEYBOARD_GAME_OVER_PROPERTY:
		g_value_set_boolean (value, wg_keyboard_get_game_over (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_wg_keyboard_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	WGKeyboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WG_TYPE_KEYBOARD, WGKeyboard);
	switch (property_id) {
		case WG_KEYBOARD_GAME_OVER_PROPERTY:
		wg_keyboard_set_game_over (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

