/* TestCases.c generated by valac 0.56.17, the Vala compiler
 * generated from TestCases.vala, do not modify */

/*
Copyright (C) 2012, 2013, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include <glib-object.h>
#include <glib.h>
#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <loadfont.h>
#include <stdio.h>
#include <xmlbird.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_TYPE_TEST_CASES (bird_font_test_cases_get_type ())
#define BIRD_FONT_TEST_CASES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_TEST_CASES, BirdFontTestCases))
#define BIRD_FONT_TEST_CASES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_TEST_CASES, BirdFontTestCasesClass))
#define BIRD_FONT_IS_TEST_CASES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_TEST_CASES))
#define BIRD_FONT_IS_TEST_CASES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_TEST_CASES))
#define BIRD_FONT_TEST_CASES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_TEST_CASES, BirdFontTestCasesClass))

typedef struct _BirdFontTestCases BirdFontTestCases;
typedef struct _BirdFontTestCasesClass BirdFontTestCasesClass;
typedef struct _BirdFontTestCasesPrivate BirdFontTestCasesPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _bird_font_svg_parser_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_svg_parser_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))

#define BIRD_FONT_TEST_CASES_TYPE_POINT (bird_font_test_cases_point_get_type ())
#define BIRD_FONT_TEST_CASES_POINT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TEST_CASES_TYPE_POINT, BirdFontTestCasesPoint))
#define BIRD_FONT_TEST_CASES_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TEST_CASES_TYPE_POINT, BirdFontTestCasesPointClass))
#define BIRD_FONT_TEST_CASES_IS_POINT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TEST_CASES_TYPE_POINT))
#define BIRD_FONT_TEST_CASES_IS_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TEST_CASES_TYPE_POINT))
#define BIRD_FONT_TEST_CASES_POINT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TEST_CASES_TYPE_POINT, BirdFontTestCasesPointClass))

typedef struct _BirdFontTestCasesPoint BirdFontTestCasesPoint;
typedef struct _BirdFontTestCasesPointClass BirdFontTestCasesPointClass;
typedef struct _BirdFontTestCasesPointPrivate BirdFontTestCasesPointPrivate;
#define _bird_font_test_cases_point_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_test_cases_point_unref (var), NULL)))
typedef struct _Block67Data Block67Data;
typedef struct _BirdFontTestCasesParamSpecPoint BirdFontTestCasesParamSpecPoint;
typedef struct _BirdFontParamSpecTestCases BirdFontParamSpecTestCases;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BirdFontTestCases {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BirdFontTestCasesPrivate * priv;
	GList* test_cases;
};

struct _BirdFontTestCasesClass {
	GTypeClass parent_class;
	void (*finalize) (BirdFontTestCases *self);
};

struct _BirdFontTestCasesPoint {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BirdFontTestCasesPointPrivate * priv;
	gint x;
	gint y;
};

struct _BirdFontTestCasesPointClass {
	GTypeClass parent_class;
	void (*finalize) (BirdFontTestCasesPoint *self);
};

struct _Block67Data {
	int _ref_count_;
	BirdFontPath* path;
};

struct _BirdFontTestCasesParamSpecPoint {
	GParamSpec parent_instance;
};

struct _BirdFontParamSpecTestCases {
	GParamSpec parent_instance;
};

static gpointer bird_font_test_cases_parent_class = NULL;
static gpointer bird_font_test_cases_point_parent_class = NULL;

VALA_EXTERN gpointer bird_font_test_cases_ref (gpointer instance);
VALA_EXTERN void bird_font_test_cases_unref (gpointer instance);
VALA_EXTERN GParamSpec* bird_font_param_spec_test_cases (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void bird_font_value_set_test_cases (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void bird_font_value_take_test_cases (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer bird_font_value_get_test_cases (const GValue* value);
VALA_EXTERN GType bird_font_test_cases_get_type (void) G_GNUC_CONST ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN BirdFontTestCases* bird_font_test_cases_new (void);
VALA_EXTERN BirdFontTestCases* bird_font_test_cases_construct (GType object_type);
static void bird_font_test_cases_add (BirdFontTestCases* self,
                               GCallback callback,
                               const gchar* name);
VALA_EXTERN void bird_font_test_cases_test_overview (void);
static void _bird_font_test_cases_test_overview_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_data_reader (void);
static void _bird_font_test_cases_test_data_reader_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_argument (void);
static void _bird_font_test_cases_test_argument_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_glyph_ranges (void);
static void _bird_font_test_cases_test_glyph_ranges_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_hex (void);
static void _bird_font_test_cases_test_hex_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_reverse_path (void);
static void _bird_font_test_cases_test_reverse_path_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_reverse_random_triangles (void);
static void _bird_font_test_cases_test_reverse_random_triangles_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_coordinates (void);
static void _bird_font_test_cases_test_coordinates_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_drawing (void);
static void _bird_font_test_cases_test_drawing_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_delete_points (void);
static void _bird_font_test_cases_test_delete_points_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_convert_to_quadratic_bezier_path (void);
static void _bird_font_test_cases_test_convert_to_quadratic_bezier_path_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_over_path (void);
static void _bird_font_test_cases_test_over_path_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_export (void);
static void _bird_font_test_cases_test_export_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_background_coordinates (void);
static void _bird_font_test_cases_test_background_coordinates_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_spin_button (void);
static void _bird_font_test_cases_test_spin_button_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_inkscape_import (void);
static void _bird_font_test_cases_test_inkscape_import_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_illustrator_import (void);
static void _bird_font_test_cases_test_illustrator_import_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_parse_quadratic_paths (void);
static void _bird_font_test_cases_test_parse_quadratic_paths_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_freetype (void);
static void _bird_font_test_cases_test_freetype_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_preview (void);
static void _bird_font_test_cases_test_preview_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_kerning (void);
static void _bird_font_test_cases_test_kerning_gcallback (void);
static void bird_font_test_cases_test_boundaries (void);
static void _bird_font_test_cases_test_boundaries_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_codepages (void);
static void _bird_font_test_cases_test_codepages_gcallback (void);
VALA_EXTERN void bird_font_test_cases_test_double_quadratic (void);
static void _bird_font_test_cases_test_double_quadratic_gcallback (void);
static void bird_font_test_cases_test_raster_path (void);
static void _bird_font_test_cases_test_raster_path_gcallback (void);
static void bird_font_test_cases_test_file_path (void);
static void _bird_font_test_cases_test_file_path_gcallback (void);
static void bird_font_test_cases_test_xml (void);
static void _bird_font_test_cases_test_xml_gcallback (void);
static void bird_font_test_cases_add_bechmark (BirdFontTestCases* self,
                                        GCallback callback,
                                        const gchar* name);
VALA_EXTERN void bird_font_test_cases_benchmark_stroke (void);
static void _bird_font_test_cases_benchmark_stroke_gcallback (void);
VALA_EXTERN GList* bird_font_test_cases_get_test_functions (BirdFontTestCases* self);
VALA_EXTERN void bird_font_test_cases_load_test_font (void);
VALA_EXTERN void bird_font_test_cases_test_open_next_glyph (void);
VALA_EXTERN GFile* bird_font_bird_font_get_settings_directory (void);
VALA_EXTERN void bird_font_test_cases_test_select_action (BirdFontTool* t);
VALA_EXTERN void bird_font_test_cases_test_click_action (BirdFontTool* t,
                                             gint b,
                                             gint x,
                                             gint y);
static void bird_font_test_cases_test_hex_conv (gunichar h,
                                         const gchar* sr,
                                         gint r);
VALA_EXTERN void bird_font_test_cases_test_move_action (BirdFontTool* t,
                                            gint x,
                                            gint y);
static void bird_font_test_cases_test_reverse_coordinate (gint x,
                                                   gint y,
                                                   gdouble px,
                                                   gdouble py,
                                                   const gchar* n);
static void bird_font_test_cases_test_last_is_clockwise (const gchar* name);
static gboolean bird_font_test_cases_test_reverse_last (const gchar* name);
static gpointer bird_font_test_cases_point_ref (gpointer instance);
static void bird_font_test_cases_point_unref (gpointer instance);
static GParamSpec* bird_font_test_cases_param_spec_point (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags) G_GNUC_UNUSED ;
static void bird_font_test_cases_value_set_point (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED ;
static void bird_font_test_cases_value_take_point (GValue* value,
                                            gpointer v_object) G_GNUC_UNUSED ;
static gpointer bird_font_test_cases_value_get_point (const GValue* value) G_GNUC_UNUSED ;
static GType bird_font_test_cases_point_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static BirdFontTestCasesPoint* bird_font_test_cases_p (gint x,
                                                gint y);
static BirdFontTestCasesPoint* bird_font_test_cases_point_new (gint x,
                                                        gint y);
static BirdFontTestCasesPoint* bird_font_test_cases_point_construct (GType object_type,
                                                              gint x,
                                                              gint y);
static void bird_font_test_cases_test_triangle (BirdFontTestCasesPoint* a,
                                         BirdFontTestCasesPoint* b,
                                         BirdFontTestCasesPoint* c,
                                         const gchar* name);
static void bird_font_test_cases_test_various_triangles (void);
static BirdFontTool* bird_font_test_cases_select_pen (void);
static Block67Data* block67_data_ref (Block67Data* _data67_);
static void block67_data_unref (void * _userdata_);
static gboolean ____lambda219_ (Block67Data* _data67_,
                         gdouble cx,
                         gdouble cy,
                         gdouble ct);
static gboolean _____lambda219__bird_font_path_raster_iterator (gdouble x,
                                                         gdouble y,
                                                         gdouble step,
                                                         gpointer self);
static void bird_font_test_cases_print_tags (BTag* tag);
static void bird_font_test_cases_print_attributes (BTag* tag);
static void bird_font_test_cases_point_finalize (BirdFontTestCasesPoint * obj);
static GType bird_font_test_cases_point_get_type_once (void);
static void bird_font_test_cases_finalize (BirdFontTestCases * obj);
static GType bird_font_test_cases_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_bird_font_test_cases_test_overview_gcallback (void)
{
	bird_font_test_cases_test_overview ();
}

static void
_bird_font_test_cases_test_data_reader_gcallback (void)
{
	bird_font_test_cases_test_data_reader ();
}

static void
_bird_font_test_cases_test_argument_gcallback (void)
{
	bird_font_test_cases_test_argument ();
}

static void
_bird_font_test_cases_test_glyph_ranges_gcallback (void)
{
	bird_font_test_cases_test_glyph_ranges ();
}

static void
_bird_font_test_cases_test_hex_gcallback (void)
{
	bird_font_test_cases_test_hex ();
}

static void
_bird_font_test_cases_test_reverse_path_gcallback (void)
{
	bird_font_test_cases_test_reverse_path ();
}

static void
_bird_font_test_cases_test_reverse_random_triangles_gcallback (void)
{
	bird_font_test_cases_test_reverse_random_triangles ();
}

static void
_bird_font_test_cases_test_coordinates_gcallback (void)
{
	bird_font_test_cases_test_coordinates ();
}

static void
_bird_font_test_cases_test_drawing_gcallback (void)
{
	bird_font_test_cases_test_drawing ();
}

static void
_bird_font_test_cases_test_delete_points_gcallback (void)
{
	bird_font_test_cases_test_delete_points ();
}

static void
_bird_font_test_cases_test_convert_to_quadratic_bezier_path_gcallback (void)
{
	bird_font_test_cases_test_convert_to_quadratic_bezier_path ();
}

static void
_bird_font_test_cases_test_over_path_gcallback (void)
{
	bird_font_test_cases_test_over_path ();
}

static void
_bird_font_test_cases_test_export_gcallback (void)
{
	bird_font_test_cases_test_export ();
}

static void
_bird_font_test_cases_test_background_coordinates_gcallback (void)
{
	bird_font_test_cases_test_background_coordinates ();
}

static void
_bird_font_test_cases_test_spin_button_gcallback (void)
{
	bird_font_test_cases_test_spin_button ();
}

static void
_bird_font_test_cases_test_inkscape_import_gcallback (void)
{
	bird_font_test_cases_test_inkscape_import ();
}

static void
_bird_font_test_cases_test_illustrator_import_gcallback (void)
{
	bird_font_test_cases_test_illustrator_import ();
}

static void
_bird_font_test_cases_test_parse_quadratic_paths_gcallback (void)
{
	bird_font_test_cases_test_parse_quadratic_paths ();
}

static void
_bird_font_test_cases_test_freetype_gcallback (void)
{
	bird_font_test_cases_test_freetype ();
}

static void
_bird_font_test_cases_test_preview_gcallback (void)
{
	bird_font_test_cases_test_preview ();
}

static void
_bird_font_test_cases_test_kerning_gcallback (void)
{
	bird_font_test_cases_test_kerning ();
}

static void
_bird_font_test_cases_test_boundaries_gcallback (void)
{
	bird_font_test_cases_test_boundaries ();
}

static void
_bird_font_test_cases_test_codepages_gcallback (void)
{
	bird_font_test_cases_test_codepages ();
}

static void
_bird_font_test_cases_test_double_quadratic_gcallback (void)
{
	bird_font_test_cases_test_double_quadratic ();
}

static void
_bird_font_test_cases_test_raster_path_gcallback (void)
{
	bird_font_test_cases_test_raster_path ();
}

static void
_bird_font_test_cases_test_file_path_gcallback (void)
{
	bird_font_test_cases_test_file_path ();
}

static void
_bird_font_test_cases_test_xml_gcallback (void)
{
	bird_font_test_cases_test_xml ();
}

static void
_bird_font_test_cases_benchmark_stroke_gcallback (void)
{
	bird_font_test_cases_benchmark_stroke ();
}

BirdFontTestCases*
bird_font_test_cases_construct (GType object_type)
{
	BirdFontTestCases* self = NULL;
	self = (BirdFontTestCases*) g_type_create_instance (object_type);
	bird_font_test_cases_add (self, _bird_font_test_cases_test_overview_gcallback, "Overview");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_data_reader_gcallback, "Font data reader");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_argument_gcallback, "Argument list");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_glyph_ranges_gcallback, "Glyph ranges");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_hex_gcallback, "Unicode hex values");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_reverse_path_gcallback, "Reverse path");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_reverse_random_triangles_gcallback, "Reverse random paths");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_coordinates_gcallback, "Coordinates");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_drawing_gcallback, "Pen tool");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_delete_points_gcallback, "Delete edit points");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_convert_to_quadratic_bezier_path_gcallback, "Convert to quadratic path");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_over_path_gcallback, "Over path");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_export_gcallback, "Export");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_background_coordinates_gcallback, "Background coordinates");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_spin_button_gcallback, "Spin button");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_inkscape_import_gcallback, "Inkscape import");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_illustrator_import_gcallback, "Illustrator import");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_parse_quadratic_paths_gcallback, "Quadratic paths");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_freetype_gcallback, "Freetype");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_preview_gcallback, "Preview");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_kerning_gcallback, "Kerning");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_boundaries_gcallback, "Boundaries");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_codepages_gcallback, "Codepages");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_double_quadratic_gcallback, "Double quadratic");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_raster_path_gcallback, "Raster path");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_file_path_gcallback, "File path");
	bird_font_test_cases_add (self, _bird_font_test_cases_test_xml_gcallback, "XML");
	bird_font_test_cases_add_bechmark (self, _bird_font_test_cases_benchmark_stroke_gcallback, "Stroke");
	return self;
}

BirdFontTestCases*
bird_font_test_cases_new (void)
{
	return bird_font_test_cases_construct (BIRD_FONT_TYPE_TEST_CASES);
}

static void
bird_font_test_cases_add_bechmark (BirdFontTestCases* self,
                                   GCallback callback,
                                   const gchar* name)
{
	BirdFontTest* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_test_new (callback, name, TRUE);
	self->test_cases = g_list_append (self->test_cases, _tmp0_);
}

static void
bird_font_test_cases_add (BirdFontTestCases* self,
                          GCallback callback,
                          const gchar* name)
{
	BirdFontTest* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_test_new (callback, name, FALSE);
	self->test_cases = g_list_append (self->test_cases, _tmp0_);
}

GList*
bird_font_test_cases_get_test_functions (BirdFontTestCases* self)
{
	GList* _tmp0_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->test_cases;
	result = _tmp0_;
	return result;
}

void
bird_font_test_cases_test_double_quadratic (void)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	GeeArrayList* paths = NULL;
	GeeArrayList* _tmp1_;
	BirdFontPath* pn = NULL;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	paths = _tmp1_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _p_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp2_ = g;
		_tmp3_ = bird_font_glyph_get_all_paths (_tmp2_);
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontPath* _tmp11_;
			BirdFontPath* _tmp12_;
			BirdFontPath* _tmp13_;
			GeeArrayList* _tmp14_;
			BirdFontPath* _tmp15_;
			_p_index = _p_index + 1;
			_tmp7_ = _p_index;
			_tmp8_ = _p_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _p_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _p_index);
			p = (BirdFontPath*) _tmp10_;
			_tmp11_ = p;
			_tmp12_ = bird_font_path_copy (_tmp11_);
			_g_object_unref0 (pn);
			pn = _tmp12_;
			_tmp13_ = pn;
			bird_font_path_add_hidden_double_points (_tmp13_);
			_tmp14_ = paths;
			_tmp15_ = pn;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp16_;
		gint _p_size = 0;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _p_index = 0;
		_tmp16_ = paths;
		_p_list = _tmp16_;
		_tmp17_ = _p_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_p_size = _tmp19_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp22_;
			gpointer _tmp23_;
			BirdFontGlyph* _tmp24_;
			BirdFontPath* _tmp25_;
			_p_index = _p_index + 1;
			_tmp20_ = _p_index;
			_tmp21_ = _p_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _p_list;
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _p_index);
			p = (BirdFontPath*) _tmp23_;
			_tmp24_ = g;
			_tmp25_ = p;
			bird_font_glyph_add_path (_tmp24_, _tmp25_);
			_g_object_unref0 (p);
		}
	}
	_g_object_unref0 (pn);
	_g_object_unref0 (paths);
	_g_object_unref0 (g);
}

void
bird_font_test_cases_test_codepages (void)
{
	BirdFontCodePageBits* pages = NULL;
	BirdFontCodePageBits* _tmp0_;
	guint32 p0 = 0U;
	guint32 p1 = 0U;
	BirdFontCodePageBits* _tmp1_;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	BirdFontCodePageBits* _tmp5_;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	gboolean _tmp8_ = FALSE;
	BirdFontCodePageBits* _tmp9_;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	gboolean _tmp12_ = FALSE;
	BirdFontCodePageBits* _tmp13_;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	gboolean _tmp16_ = FALSE;
	_tmp0_ = bird_font_code_page_bits_new ();
	pages = _tmp0_;
	_tmp1_ = pages;
	bird_font_code_page_bits_get_bits (_tmp1_, 243U, &_tmp2_, &_tmp3_);
	p0 = (guint32) _tmp2_;
	p1 = (guint32) _tmp3_;
	if (p0 == ((guint32) 0)) {
		_tmp4_ = p1 == ((guint32) 0);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		g_warning ("TestCases.vala:90: Codepage for Hungarian is not set.");
	}
	_tmp5_ = pages;
	bird_font_code_page_bits_get_bits (_tmp5_, 246U, &_tmp6_, &_tmp7_);
	p0 = (guint32) _tmp6_;
	p1 = (guint32) _tmp7_;
	if (p0 == ((guint32) 0)) {
		_tmp8_ = p1 == ((guint32) 0);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		g_warning ("TestCases.vala:95: Codepage for Swedish is not set.");
	}
	_tmp9_ = pages;
	bird_font_code_page_bits_get_bits (_tmp9_, 65410U, &_tmp10_, &_tmp11_);
	p0 = (guint32) _tmp10_;
	p1 = (guint32) _tmp11_;
	if (p0 == ((guint32) 0)) {
		_tmp12_ = p1 == ((guint32) 0);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		g_warning ("TestCases.vala:100: Codepage for Japanese is not set.");
	}
	_tmp13_ = pages;
	bird_font_code_page_bits_get_bits (_tmp13_, 39532U, &_tmp14_, &_tmp15_);
	p0 = (guint32) _tmp14_;
	p1 = (guint32) _tmp15_;
	if (p0 == ((guint32) 0)) {
		_tmp16_ = p1 == ((guint32) 0);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		g_warning ("TestCases.vala:105: Codepage for Chinese is not set.");
	}
	_g_object_unref0 (pages);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
bird_font_test_cases_load_test_font (void)
{
	gchar* fn = NULL;
	gchar* _tmp0_;
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp1_;
	BirdFontFont* _tmp2_;
	BirdFontFont* _tmp3_;
	const gchar* _tmp4_;
	BirdFontFont* _tmp5_;
	BirdFontFont* _tmp10_;
	_tmp0_ = g_strdup ("./fonts/Decibel.bf");
	fn = _tmp0_;
	_tmp1_ = bird_font_bird_font_new_font ();
	f = _tmp1_;
	_tmp2_ = f;
	bird_font_font_set_read_only (_tmp2_, TRUE);
	_tmp3_ = f;
	_tmp4_ = fn;
	bird_font_font_set_file (_tmp3_, _tmp4_);
	_tmp5_ = f;
	if (!bird_font_font_load (_tmp5_)) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = fn;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("Failed to load fond ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		g_warning ("TestCases.vala:117: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_object_unref0 (f);
		_g_free0 (fn);
		return;
	}
	_tmp10_ = f;
	if (bird_font_font_length (_tmp10_) == ((guint) 0)) {
		g_warning ("TestCases.vala:122: No glyphs in font.");
	}
	_g_object_unref0 (f);
	_g_free0 (fn);
}

void
bird_font_test_cases_test_kerning (void)
{
	BirdFontKerningDisplay* k = NULL;
	BirdFontFont* font = NULL;
	BirdFontGlyph* g = NULL;
	BirdFontKerningDisplay* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontFont* _tmp2_;
	bird_font_test_cases_load_test_font ();
	_tmp0_ = bird_font_main_window_get_kerning_display ();
	_g_object_unref0 (k);
	k = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp1_;
	bird_font_menu_tab_show_kerning_context ();
	_tmp2_ = font;
	if (bird_font_font_length (_tmp2_) == ((guint) 0)) {
		g_warning ("TestCases.vala:138: No font loaded.");
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				BirdFontKerningDisplay* _tmp19_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							BirdFontFont* _tmp7_;
							BirdFontFont* _tmp8_;
							BirdFontGlyph* _tmp9_;
							BirdFontGlyph* _tmp10_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = j;
								j = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							if (!(j < 10)) {
								break;
							}
							_tmp7_ = font;
							_tmp8_ = font;
							_tmp9_ = bird_font_font_get_glyph_index (_tmp7_, (gunichar) g_random_int_range ((gint32) 0, (gint32) (((gint) bird_font_font_length (_tmp8_)) - 1)));
							_g_object_unref0 (g);
							g = _tmp9_;
							_tmp10_ = g;
							g_return_if_fail (_tmp10_ != NULL);
							if ((g_random_int_range ((gint32) 1, (gint32) 9) % 3) == ((gint32) 0)) {
								BirdFontKerningDisplay* _tmp11_;
								_tmp11_ = k;
								bird_font_kerning_display_add_kerning_class (_tmp11_, (gint) g_random_int_range ((gint32) 0, (gint32) 9));
							} else {
								BirdFontKerningDisplay* _tmp12_;
								BirdFontGlyph* _tmp13_;
								gchar* _tmp14_;
								gchar* _tmp15_;
								_tmp12_ = k;
								_tmp13_ = g;
								_tmp14_ = bird_font_glyph_get_unichar_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
								_tmp15_ = _tmp14_;
								bird_font_kerning_display_add_text (_tmp12_, _tmp15_);
								_g_free0 (_tmp15_);
							}
							bird_font_glyph_canvas_redraw ();
							bird_font_tool_yield ();
						}
					}
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							BirdFontKerningDisplay* _tmp18_;
							if (!_tmp16_) {
								gint _tmp17_;
								_tmp17_ = j;
								j = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							if (!(j < 10)) {
								break;
							}
							_tmp18_ = k;
							bird_font_kerning_display_set_absolute_kerning (_tmp18_, (gint) g_random_int_range ((gint32) 1, (gint32) 9), (gdouble) g_random_int_range ((gint32) 0, (gint32) 30));
							bird_font_glyph_canvas_redraw ();
							bird_font_tool_yield ();
						}
					}
				}
				_tmp19_ = k;
				bird_font_kerning_display_new_line (_tmp19_);
				bird_font_glyph_canvas_redraw ();
				bird_font_tool_yield ();
			}
		}
	}
	_g_object_unref0 (g);
	_g_object_unref0 (font);
	_g_object_unref0 (k);
}

void
bird_font_test_cases_benchmark_stroke (void)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	bird_font_test_cases_test_open_next_glyph ();
	bird_font_test_cases_test_illustrator_import ();
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (glyph);
	glyph = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 5)) {
					break;
				}
				{
					GeeArrayList* _p_list = NULL;
					BirdFontGlyph* _tmp3_;
					GeeArrayList* _tmp4_;
					gint _p_size = 0;
					GeeArrayList* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					gint _p_index = 0;
					_tmp3_ = glyph;
					_tmp4_ = bird_font_glyph_get_all_paths (_tmp3_);
					_p_list = _tmp4_;
					_tmp5_ = _p_list;
					_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
					_tmp7_ = _tmp6_;
					_p_size = _tmp7_;
					_p_index = -1;
					while (TRUE) {
						gint _tmp8_;
						gint _tmp9_;
						BirdFontPath* p = NULL;
						GeeArrayList* _tmp10_;
						gpointer _tmp11_;
						BirdFontPath* _tmp12_;
						BirdFontGlyph* _tmp13_;
						_p_index = _p_index + 1;
						_tmp8_ = _p_index;
						_tmp9_ = _p_size;
						if (!(_tmp8_ < _tmp9_)) {
							break;
						}
						_tmp10_ = _p_list;
						_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _p_index);
						p = (BirdFontPath*) _tmp11_;
						_tmp12_ = p;
						bird_font_path_set_stroke (_tmp12_, i / 100.0);
						_tmp13_ = glyph;
						bird_font_glyph_update_view (_tmp13_);
						bird_font_tool_yield ();
						_g_object_unref0 (p);
					}
					_g_object_unref0 (_p_list);
				}
			}
		}
	}
	_g_object_unref0 (glyph);
}

void
bird_font_test_cases_test_freetype (void)
{
	GString* data = NULL;
	gint _error_ = 0;
	GFile* f = NULL;
	GFile* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	BirdFontFont* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	BirdFontFont* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_ = 0;
	GString* _tmp16_;
	GString* _tmp17_;
	BirdFontFont* _tmp18_;
	_tmp0_ = bird_font_bird_font_get_settings_directory ();
	f = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	_tmp2_ = font;
	bird_font_font_set_name (_tmp2_, "TEST_FONT");
	bird_font_test_cases_test_illustrator_import ();
	bird_font_test_cases_test_inkscape_import ();
	bird_font_tool_yield ();
	_tmp3_ = f;
	if (!bird_font_export_tool_export_ttf_font_path (_tmp3_, TRUE)) {
		g_warning ("TestCases.vala:197: TTF export failed.");
	}
	_tmp4_ = f;
	_tmp5_ = font;
	_tmp6_ = bird_font_font_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, ".ttf", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = bird_font_get_child (_tmp4_, _tmp9_);
	_g_object_unref0 (f);
	f = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp11_ = f;
	if (!g_file_query_exists (_tmp11_, NULL)) {
		g_warning ("TestCases.vala:202: File does not exist.");
	}
	_tmp12_ = f;
	_tmp13_ = g_file_get_path (_tmp12_);
	_tmp14_ = (gchar*) _tmp13_;
	_tmp16_ = load_freetype_font (_tmp14_, &_tmp15_);
	_error_ = _tmp15_;
	_g_string_free0 (data);
	data = _tmp16_;
	_g_free0 (_tmp14_);
	if (_error_ != 0) {
		g_warning ("TestCases.vala:207: Failed to load font.");
		_g_object_unref0 (font);
		_g_object_unref0 (f);
		_g_string_free0 (data);
		return;
	}
	_tmp17_ = data;
	if (_tmp17_ == NULL) {
		g_warning ("TestCases.vala:212: No bf data.");
		_g_object_unref0 (font);
		_g_object_unref0 (f);
		_g_string_free0 (data);
		return;
	}
	bird_font_tool_yield ();
	_tmp18_ = font;
	bird_font_font_load (_tmp18_);
	_g_object_unref0 (font);
	_g_object_unref0 (f);
	_g_string_free0 (data);
}

void
bird_font_test_cases_test_parse_quadratic_paths (void)
{
	BirdFontGlyph* g = NULL;
	BirdFontSvgParser* parser = NULL;
	BirdFontSvgParser* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp2_;
	BirdFontPathList* _tmp3_;
	BirdFontPathList* _tmp4_;
	BirdFontGlyph* _tmp5_;
	BirdFontGlyph* _tmp6_;
	BirdFontPathList* _tmp7_;
	BirdFontPathList* _tmp8_;
	BirdFontGlyph* _tmp9_;
	BirdFontGlyph* _tmp10_;
	BirdFontPathList* _tmp11_;
	BirdFontPathList* _tmp12_;
	BirdFontGlyph* _tmp13_;
	BirdFontGlyph* _tmp14_;
	BirdFontPathList* _tmp15_;
	BirdFontPathList* _tmp16_;
	_tmp0_ = bird_font_svg_parser_new ();
	parser = _tmp0_;
	bird_font_test_cases_test_open_next_glyph ();
	bird_font_svg_parser_set_format (parser, BIRD_FONT_SVG_FORMAT_INKSCAPE);
	_tmp1_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp1_;
	_tmp2_ = g;
	_tmp3_ = bird_font_svg_parser_parse_svg_data (parser, "M20,300 Q400,50 600,300 T1000,300Q1200 50 1400 300Q1600 50 1800 600 L " \
"1800 700 L 200 700 z", _tmp2_, FALSE, (gdouble) 1);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	bird_font_toolbox_select_tool_by_name ("full_glyph");
	_tmp5_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp5_;
	_tmp6_ = g;
	_tmp7_ = bird_font_svg_parser_parse_svg_data (parser, "M300 400 h-200 l0 1000 h200z", _tmp6_, TRUE, (gdouble) 1);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	bird_font_toolbox_select_tool_by_name ("full_glyph");
	bird_font_svg_parser_set_format (parser, BIRD_FONT_SVG_FORMAT_ILLUSTRATOR);
	_tmp9_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp9_;
	_tmp10_ = g;
	_tmp11_ = bird_font_svg_parser_parse_svg_data (parser, "M20,300 Q400,50 600,300 T1000,300Q1200 50 1400 300Q1600 50 1800 600 L " \
"1800 700 L 200 700 z", _tmp10_, FALSE, (gdouble) 1);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp12_);
	bird_font_toolbox_select_tool_by_name ("full_glyph");
	_tmp13_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp13_;
	_tmp14_ = g;
	_tmp15_ = bird_font_svg_parser_parse_svg_data (parser, "M300 400 h-200 l0 1000 h200z", _tmp14_, TRUE, (gdouble) 1);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp16_);
	bird_font_toolbox_select_tool_by_name ("full_glyph");
	_bird_font_svg_parser_unref0 (parser);
	_g_object_unref0 (g);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_test_cases_test_illustrator_import (void)
{
	BirdFontGlyph* g = NULL;
	BirdFontSvgParser* parser = NULL;
	BirdFontSvgParser* _tmp0_;
	gchar* illustrator_data = NULL;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = bird_font_svg_parser_new ();
	parser = _tmp0_;
	_tmp1_ = g_strdup ("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" \
"<!-- Generator: Adobe Illustrator 15.0.2, SVG Export Plug-In . SVG Ver" \
"sion: 6.00 Build 0)  -->\n" \
"<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/G" \
"raphics/SVG/1.1/DTD/svg11.dtd\">\n" \
"<svg version=\"1.1\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg" \
"\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"\n" \
"\t width=\"595.28px\" height=\"841.89px\" viewBox=\"0 0 595.28 841.89\"" \
" enable-background=\"new 0 0 595.28 841.89\" xml:space=\"preserve\">\n" \
"<path fill=\"#FFFFFF\" stroke=\"#000000\" stroke-miterlimit=\"10\" d=\"" \
"M49.102,263.776\"/>\n" \
"<g>\n" \
"\t<g>\n" \
"\t\t<path d=\"M3.037,3.799c0.006-0.057,0.013-0.114,0.019-0.171c0.111-1" \
".002-1.577-0.438-1.89,0.01c0.007-0.012,0.013-0.024,0.02-0.036\n" \
"\t\t\tC1.49,3.626,1.795,3.651,2.1,3.676C2.061,3.954,2.195,4.022,2.5,3." \
"88c0.346-0.007,0.691-0.009,1.036-0.006\n" \
"\t\t\tC4.45,3.876,5.367,3.971,6.279,4.015c1.569,0.075,3.033-0.056,4.44" \
"1-0.776c1.18-0.604,0.111-1.501-0.824-1.022\n" \
"\t\t\tc-2.19,1.121-5.157,0.242-7.563,0.39C1.281,2.67,0.104,3.19,0.182," \
"4.371C0.218,4.488,0.29,4.577,0.395,4.639\n" \
"\t\t\tC1.397,5.095,2.39,4.668,2.997,3.797c-0.63,0.003-1.26,0.006-1.89," \
"0.01C1.101,3.864,1.095,3.921,1.088,3.979\n" \
"\t\t\tC0.985,4.903,2.948,4.596,3.037,3.799L3.037,3.799z\"/>\n" \
"\t</g>\n" \
"</g>\n" \
"<g>\n" \
"\t<g>\n" \
"\t\t<path d=\"M4.668,3.559C4.614,5.102,4.586,6.642,4.63,8.186c0.02,0.6" \
"79-0.033,1.363-0.054,2.041\n" \
"\t\t\tc-0.017,0.587,0.309,1.136-0.299,1.16c-0.563,0.022-1.708,1.045-0." \
"669,1.263c1.091,0.229,2.12,0.154,3.229,0.118\n" \
"\t\t\tc1.057-0.035,1.522-1.348,0.201-1.305c-0.76,0.025-1.539,0.124-2.2" \
"93-0.035c-0.223,0.421-0.446,0.842-0.669,1.263\n" \
"\t\t\tc1.091-0.043,2.411-0.278,2.5-1.583c0.173-2.551-0.048-5.164,0.042" \
"-7.728C6.65,2.432,4.696,2.761,4.668,3.559L4.668,3.559z\"/>\n" \
"\t</g>\n" \
"</g>\n" \
"<g>\n" \
"\t<g>\n" \
"\t\t<path d=\"M10.014,7.024C9.189,7.82,8.786,8.42,8.661,9.58c-0.098,0." \
"906-0.05,1.599,0.515,2.346\n" \
"\t\t\tc1.215,1.608,3.572,0.777,5.021,0.102c0.216-0.101,0.627-0.469,0.2" \
"08-0.612c-0.437-0.149-0.964,0.034-1.358,0.218\n" \
"\t\t\tc-1.281,0.597-2.335-0.241-2.516-1.55C10.356,8.81,10.916,7.8,11.7" \
"84,6.961c0.336-0.325-0.288-0.434-0.486-0.427\n" \
"\t\t\tC10.843,6.55,10.346,6.704,10.014,7.024L10.014,7.024z\"/>\n" \
"\t</g>\n" \
"</g>\n" \
"<g>\n" \
"\t<g>\n" \
"\t\t<path d=\"M11.415,7.436c0.267-0.022,0.588-0.066,0.852,0.006c-0.072" \
"-0.02-0.12-0.251-0.072-0.044\n" \
"\t\t\tc0.021,0.091-0.01,0.268-0.007,0.372c0.003,0.135,0.007,0.264-0.00" \
"3,0.399c0.001-0.022,0.038-0.029-0.014-0.024\n" \
"\t\t\tc-0.343,0.036-0.735,0.108-1.079,0.09c-0.478-0.026-1.041,0.124-1." \
"254,0.606c-0.187,0.423,0.169,0.847,0.604,0.87\n" \
"\t\t\tc1.314,0.07,3.575-0.07,3.716-1.796c0.043-0.535,0.063-1.19-0.354-" \
"1.581c-0.544-0.511-1.554-0.451-2.239-0.394\n" \
"\t\t\tc-0.441,0.037-1.006,0.31-1.056,0.81C10.459,7.24,11.007,7.47,11.4" \
"15,7.436L11.415,7.436z\"/>\n" \
"\t</g>\n" \
"</g>\n" \
"<g>\n" \
"\t<g>\n" \
"\t\t<path d=\"M17.85,6.628c-0.13,0.059-0.265,0.102-0.404,0.131c0.104-0" \
".019,0.122-0.021,0.051-0.008\n" \
"\t\t\tc0.112-0.013,0.218-0.015,0.33-0.013c0.152,0.002,0.394,0.013,0.46" \
"6,0.17c0.207,0.454,2.073-0.208,1.932-0.518\n" \
"\t\t\tc-0.203-0.445-0.951-0.422-1.354-0.417c-0.719,0.01-1.468,0.13-2.1" \
"26,0.43c-0.143,0.065-0.675,0.39-0.243,0.477\n" \
"\t\t\tC16.934,6.969,17.461,6.806,17.85,6.628L17.85,6.628z\"/>\n" \
"\t</g>\n" \
"</g>\n" \
"<g>\n" \
"\t<g>\n" \
"\t\t<path d=\"M16.858,6.049c-1.111,0.292-2.424,1.692-1.018,2.544c1.076" \
",0.653,3.576,0.595,2.513,2.572\n" \
"\t\t\tc-0.206,0.382,0.683,0.367,0.816,0.348c0.419-0.059,0.897-0.228,1." \
"107-0.619c0.548-1.019,0.155-1.903-0.79-2.432\n" \
"\t\t\tc-0.418-0.234-0.906-0.356-1.363-0.491c-0.251-0.075-0.492-0.155-0" \
".732-0.259c-0.302-0.131-0.08-0.863-0.304-0.804\n" \
"\t\t\tc0.242-0.063,0.952-0.313,0.851-0.688C17.838,5.842,17.1,5.985,16." \
"858,6.049L16.858,6.049z\"/>\n" \
"\t</g>\n" \
"</g>\n" \
"<g>\n" \
"\t<g>\n" \
"\t\t<path d=\"M14.983,10.708c-0.036,0.299-0.137,0.716,0.08,0.972c0.244" \
",0.286,0.663,0.358,1.01,0.435\n" \
"\t\t\tc0.994,0.221,1.846,0.177,2.792-0.243c0.185-0.082,0.844-0.417,0.5" \
"33-0.711c-0.296-0.28-0.951-0.124-1.269,0.018\n" \
"\t\t\tc-0.317,0.141-0.505,0.035-0.853-0.039c-0.444-0.095-0.42-0.276-0." \
"369-0.702C16.991,9.74,15.055,10.114,14.983,10.708\n" \
"\t\t\tL14.983,10.708z\"/>\n" \
"\t</g>\n" \
"</g>\n" \
"<g>\n" \
"\t<g>\n" \
"\t\t<path d=\"M21.915,6.956c1.207,0.189,2.389,0.085,3.601,0.082c0.424-" \
"0.001,1.009-0.321,1.063-0.784\n" \
"\t\t\tc0.06-0.506-0.514-0.641-0.895-0.639c-1.048,0.003-2.059,0.093-3.1" \
"03-0.071C21.625,5.394,20.618,6.752,21.915,6.956L21.915,6.956z\n" \
"\t\t\t\"/>\n" \
"\t</g>\n" \
"</g>\n" \
"<g>\n" \
"\t<g>\n" \
"\t\t<path d=\"M21.948,5.359c-0.002,1.245-0.005,2.491-0.045,3.735c-0.02" \
"3,0.708-0.252,1.594,0.142,2.241\n" \
"\t\t\tc0.911,1.494,3.401,0.492,4.227-0.546c0.544-0.685-1.407-0.547-1.8" \
"02-0.051c-0.708,0.891-0.653-1.618-0.634-1.881\n" \
"\t\t\tc0.087-1.235,0.043-2.497,0.045-3.735C23.883,4.302,21.949,4.715,2" \
"1.948,5.359L21.948,5.359z\"/>\n" \
"\t</g>\n" \
"</g>\n" \
"</svg>");
	illustrator_data = _tmp1_;
	{
		GFile* temp_file = NULL;
		GFileIOStream* ios = NULL;
		GDataOutputStream* d = NULL;
		GFileOutputStream* os = NULL;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFileIOStream* _tmp7_ = NULL;
		GFile* _tmp8_;
		GFileIOStream* _tmp9_;
		GFileIOStream* _tmp10_;
		GFileIOStream* _tmp11_;
		GOutputStream* _tmp12_;
		GOutputStream* _tmp13_;
		GFileOutputStream* _tmp14_;
		GFileOutputStream* _tmp15_;
		GDataOutputStream* _tmp16_;
		GDataOutputStream* _tmp17_;
		const gchar* _tmp18_;
		GDataOutputStream* _tmp19_;
		GFile* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GFile* _tmp23_;
		BirdFontGlyph* _tmp24_;
		BirdFontSvgParser* _tmp25_;
		BirdFontSvgParser* _tmp26_;
		BirdFontGlyph* _tmp27_;
		_tmp2_ = bird_font_bird_font_get_settings_directory ();
		_tmp3_ = _tmp2_;
		_tmp4_ = bird_font_get_child (_tmp3_, "illustrator_test.svg");
		_g_object_unref0 (temp_file);
		temp_file = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_tmp5_ = temp_file;
		if (g_file_query_exists (_tmp5_, NULL)) {
			GFile* _tmp6_;
			_tmp6_ = temp_file;
			g_file_delete (_tmp6_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (os);
				_g_object_unref0 (d);
				_g_object_unref0 (ios);
				_g_object_unref0 (temp_file);
				goto __catch0_g_error;
			}
		}
		_tmp8_ = temp_file;
		_tmp9_ = g_file_create_readwrite (_tmp8_, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (os);
			_g_object_unref0 (d);
			_g_object_unref0 (ios);
			_g_object_unref0 (temp_file);
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (ios);
		ios = _tmp10_;
		_tmp11_ = ios;
		_tmp12_ = g_io_stream_get_output_stream ((GIOStream*) G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_file_io_stream_get_type (), GFileIOStream));
		_tmp13_ = _tmp12_;
		_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, g_file_output_stream_get_type ()) ? ((GFileOutputStream*) _tmp13_) : NULL);
		_g_object_unref0 (os);
		os = _tmp14_;
		_tmp15_ = os;
		_tmp16_ = g_data_output_stream_new ((GOutputStream*) G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_file_output_stream_get_type (), GFileOutputStream));
		_g_object_unref0 (d);
		d = _tmp16_;
		_tmp17_ = d;
		_tmp18_ = illustrator_data;
		g_data_output_stream_put_string (_tmp17_, _tmp18_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (os);
			_g_object_unref0 (d);
			_g_object_unref0 (ios);
			_g_object_unref0 (temp_file);
			goto __catch0_g_error;
		}
		_tmp19_ = d;
		g_output_stream_close ((GOutputStream*) _tmp19_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (os);
			_g_object_unref0 (d);
			_g_object_unref0 (ios);
			_g_object_unref0 (temp_file);
			goto __catch0_g_error;
		}
		bird_font_test_cases_test_open_next_glyph ();
		_tmp20_ = temp_file;
		_tmp21_ = g_file_get_path (_tmp20_);
		_tmp22_ = (gchar*) _tmp21_;
		bird_font_svg_parser_import_svg (_tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = temp_file;
		g_file_delete (_tmp23_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (os);
			_g_object_unref0 (d);
			_g_object_unref0 (ios);
			_g_object_unref0 (temp_file);
			goto __catch0_g_error;
		}
		_tmp24_ = bird_font_main_window_get_current_glyph ();
		_g_object_unref0 (g);
		g = _tmp24_;
		_tmp25_ = parser;
		bird_font_svg_parser_set_format (_tmp25_, BIRD_FONT_SVG_FORMAT_ILLUSTRATOR);
		_tmp26_ = parser;
		_tmp27_ = g;
		bird_font_svg_parser_add_path_to_glyph (_tmp26_, "M67.4,43.5c0,1.1-0.9,2-2,2c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2C66.5,41.5," \
"67.4,42.4,67.4,43.5z", _tmp27_, FALSE, (gdouble) 1);
		bird_font_toolbox_select_tool_by_name ("full_glyph");
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (os);
		_g_object_unref0 (d);
		_g_object_unref0 (ios);
		_g_object_unref0 (temp_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_warning ("TestCases.vala:363: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (illustrator_data);
		_bird_font_svg_parser_unref0 (parser);
		_g_object_unref0 (g);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (illustrator_data);
	_bird_font_svg_parser_unref0 (parser);
	_g_object_unref0 (g);
}

void
bird_font_test_cases_test_inkscape_import (void)
{
	gchar* inkscape_data = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_strdup ("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n" \
"<svg\n" \
"   xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n" \
"   xmlns:cc=\"http://creativecommons.org/ns#\"\n" \
"   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n" \
"   xmlns:svg=\"http://www.w3.org/2000/svg\"\n" \
"   xmlns=\"http://www.w3.org/2000/svg\"\n" \
"   xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd" \
"\"\n" \
"   xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\"\n" \
"   width=\"56\"\n" \
"   height=\"111\"\n" \
"   id=\"glyph_A\"\n" \
"   version=\"1.1\"\n" \
"   inkscape:version=\"0.48.2 r9819\"\n" \
"   sodipodi:docname=\"Glyph_template.svg\">\n" \
"  <metadata\n" \
"\t id=\"metadata10\">\n" \
"\t<rdf:RDF>\n" \
"\t  <cc:Work\n" \
"\t\t rdf:about=\"\">\n" \
"\t\t<dc:format>image/svg+xml</dc:format>\n" \
"\t\t<dc:type\n" \
"\t\t   rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\" />\n" \
"\t\t<dc:title></dc:title>\n" \
"\t  </cc:Work>\n" \
"\t</rdf:RDF>\n" \
"  </metadata>\n" \
"  <defs\n" \
"\t id=\"defs8\" />\n" \
"  <sodipodi:namedview\n" \
"\t id=\"namedview3\"\n" \
"\t showgrid=\"false\"\n" \
"\t inkscape:zoom=\"1\"\n" \
"\t inkscape:cx=\"-27.517479\"\n" \
"\t inkscape:cy=\"43.414876\"\n" \
"\t inkscape:window-width=\"721\"\n" \
"\t inkscape:window-height=\"429\"\n" \
"\t inkscape:window-x=\"557\"\n" \
"\t inkscape:window-y=\"24\"\n" \
"\t inkscape:window-maximized=\"0\"\n" \
"\t inkscape:current-layer=\"glyph_A\"\n" \
"\t inkscape:object-paths=\"true\">\n" \
"\t<sodipodi:guide\n" \
"\t   orientation=\"0,1\"\n" \
"\t   position=\"0,39\"\n" \
"\t   id=\"baseline\" />\n" \
"  </sodipodi:namedview>\n" \
"  <path\n" \
"\t style=\"fill:#000000;fill-opacity:1;stroke:none\"\n" \
"\t id=\"path3142\"\n" \
"\t d=\"M 2.4461236,18.613363 C 3.4535706,17.30804 4.565697,16.070157 5" \
".7189269,14.889064 9.7698153,10.543221 17.324067,7.5616696 21.327378,5" \
".1981153 25.286661,2.860555 13.350954,9.773823 9.3627418,12.061677 16." \
"280624,7.4352732 19.834614,4.1353939 26.808001,3.7441018 c 1.967367,-0" \
".074299 3.936743,-0.05736 5.905091,-0.051608 1.741423,0.3127973 3.4280" \
"71,0.6890467 5.085162,1.2943721 1.392556,0.6843074 2.448976,1.7917908 " \
"3.622959,2.766069 1.120096,1.0121812 2.001523,2.1988012 2.819774,3.462" \
"5798 0.849867,1.417783 1.525325,2.83856 1.899606,4.455126 0.609221,1.5" \
"91091 0.969893,3.232962 1.176184,4.91949 0.18844,1.961102 0.190368,3.9" \
"33599 0.19931,5.901817 -0.02338,1.98962 0.05666,3.98236 -0.06167,5.969" \
"29 -0.326157,1.726864 -0.640714,3.446402 -0.799219,5.198174 -0.141202," \
"1.943199 -0.145653,3.892792 -0.153936,5.840056 -0.0035,2.000837 7.65e-" \
"4,4.001679 0.0028,6.002516 0.0019,2.000867 0.0023,4.001735 0.0026,6.00" \
"2602 -0.119448,1.837413 0.05012,3.609162 0.411903,5.404108 0.436533,1." \
"339043 1.162712,2.583413 2.144788,3.594149 1.406807,1.142779 3.002396," \
"1.683088 4.761485,1.987684 1.194717,0.02857 2.577648,0.517596 3.736705" \
",0.02255 0.232429,-0.09927 0.843546,-0.555586 0.622914,-0.432299 -4.03" \
"3997,2.254157 -8.043973,4.551038 -12.065959,6.826557 0.179915,-0.14537" \
"9 0.359829,-0.290757 0.539744,-0.436135 0,0 13.621702,-5.579012 13.621" \
"702,-5.579012 l 0,0 c -0.167578,0.175551 -0.335155,0.351102 -0.502733," \
"0.526654 -8.740107,5.12179 -10.300507,8.97968 -17.955597,7.404265 -1.9" \
"57383,-0.50948 -3.799128,-1.304798 -5.299977,-2.701355 -1.123481,-1.26" \
"1267 -2.039019,-2.666586 -2.534331,-4.296084 -0.383149,-1.891076 -0.64" \
"6571,-3.750061 -0.493931,-5.690321 -1.27e-4,-2.000559 -2.84e-4,-4.0011" \
"19 -0.0017,-6.001678 -0.0017,-2.002107 -0.0049,-4.004212 -0.0062,-6.00" \
"632 0.0014,-1.974097 -0.0026,-3.949232 0.08455,-5.921848 0.102996,-1.7" \
"75437 0.264342,-3.552014 0.742963,-5.2725 0.434483,-1.889017 0.07193,-" \
"3.87962 0.190989,-5.804901 -0.0055,-1.914254 -0.0023,-3.8318 -0.157754" \
",-5.741122 -0.175482,-1.642594 -0.511621,-3.23618 -1.128362,-4.775955 " \
"-0.299347,-1.455042 -0.914171,-2.699067 -1.678627,-3.966466 -0.757218," \
"-1.14089 -1.561752,-2.21279 -2.610877,-3.106654 -1.010538,-0.897967 -2" \
".015327,-1.827459 -3.298779,-2.322908 -1.523105,-0.512447 -3.13219,-0." \
"816768 -4.732721,-0.938511 -1.950528,0.0034 -3.90631,-0.0079 -5.849616" \
",0.18331 C 9.3832464,13.223396 1.1561405,19.629883 23.07831,6.7491978 " \
"18.671333,9.2959874 14.344902,11.987543 9.8573789,14.389567 5.8103531," \
"16.555807 17.78997,9.7680895 21.756041,7.4569649 c 0.21409,-0.1247553 " \
"-0.441297,0.229177 -0.642719,0.3734938 -0.63252,0.4531925 -1.255742,0." \
"879984 -1.87055,1.3612245 -0.990862,1.2263148 -2.173114,2.3052708 -3.2" \
"10427,3.4772508 0,0 -13.5862214,5.944429 -13.5862214,5.944429 z\"\n" \
"\t inkscape:connector-curvature=\"0\" />\n" \
"  <path\n" \
"\t style=\"fill:#000000;fill-opacity:1;stroke:none\"\n" \
"\t id=\"path3150\"\n" \
"\t d=\"m 44.537632,32.349942 c -5.147586,4.026032 -10.873455,6.771035 " \
"-16.655502,10.098737 -0.71409,0.686928 -1.63002,0.452279 -2.474519,0.6" \
"71405 -0.401059,0.104064 -0.753081,0.349262 -1.144818,0.484244 0.73667" \
"6,0.02838 -2.473393,1.416554 -1.731752,0.983942 29.062029,-16.9524 1.8" \
"1009,-0.272962 -1.896399,1.014801 -1.286917,0.200555 -2.275566,1.04237" \
"5 -3.532153,1.301287 -0.405308,0.554267 -1.065095,0.524248 -1.613699,0" \
".795566 -0.662739,0.327763 -1.122742,0.692276 -1.857371,0.928714 -0.76" \
"0106,0.785065 -1.819224,0.812321 -2.767366,1.163123 -0.474696,0.175632" \
" -0.902223,0.461763 -1.370835,0.653036 -0.256593,0.07288 -0.525961,0.1" \
"10449 -0.76978,0.218632 C 8.268551,50.865263 6.9846029,51.632281 7.415" \
"4555,51.383232 27.533295,39.754369 22.52409,42.532955 18.240391,45.295" \
"266 c -1.165488,0.819073 -2.012315,1.89418 -2.774998,3.081098 -0.84528" \
"4,1.267918 -1.306169,2.696946 -1.894144,4.085429 -0.709336,1.412367 -0" \
".787279,2.808431 -0.584867,4.335462 0.415146,1.308403 0.866784,2.61859" \
"2 1.690615,3.729211 0.711541,1.116569 1.843939,1.954136 3.05544,2.4716" \
"47 1.434799,0.587706 2.820424,1.107721 4.370221,1.331222 1.863012,0.20" \
"1467 3.740237,0.197001 5.61174,0.204627 1.061154,-0.422861 2.259141,-0" \
".406524 3.338121,-0.726337 0.500528,-0.148359 0.95492,-0.423492 1.4428" \
"89,-0.609031 0.259577,-0.07197 0.531931,-0.107987 0.778732,-0.215924 0" \
".228316,-0.09985 0.420765,-0.267119 0.631148,-0.400678 0.226794,-0.107" \
"396 0.447133,-0.229644 0.680383,-0.322187 0.768356,-0.304847 1.479129," \
"-0.382367 2.210911,-0.783628 0.236171,-0.09699 0.929553,-0.418726 0.70" \
"8513,-0.290959 -3.986257,2.304163 -8.00314,4.554946 -12.009817,6.82341" \
"4 -0.211901,0.119973 0.413749,-0.25711 0.625248,-0.37779 4.424854,-2.5" \
"24796 8.855737,-5.039013 13.283606,-7.55852 0,0 -11.493423,9.1721 -11." \
"493423,9.1721 l 0,0 c 25.632954,-14.826031 4.799005,-2.558131 -2.65245" \
"1,1.337169 -1.491162,0.456817 -2.849157,1.212206 -4.348056,1.647882 -1" \
".608784,0.520829 -3.334322,0.82218 -5.021523,0.881289 -1.937875,-0.024" \
"4 -3.888043,-0.04197 -5.802052,-0.381372 C 8.46504,72.371171 6.9529525" \
",71.749159 5.4402732,71.071006 4.1002399,70.2927 2.824761,69.338054 2," \
"68 1.0937305,66.666625 0.5063194,65.186179 6.26e-5,63.660049 -0.288224" \
"5,61.935817 -0.448618,60.290055 0.2235018,58.61527 c 0.1864285,-0.4602" \
"98 0.454071,-0.886178 0.6246649,-1.352577 0.3555415,-0.972041 0.443037" \
"5,-2.039925 1.2194084,-2.823626 0.4742277,-1.223862 1.4594908,-2.85122" \
"6 2.5303973,-3.615873 0.5972416,-0.654754 0.3607951,-0.495492 1.116928" \
"3,-0.93613 5.5407473,-3.22888 9.7725723,-6.443379 15.3177753,-8.545059" \
" 1.391905,-0.595239 2.821693,-1.08014 4.148056,-1.823818 1.170505,-0.6" \
"12883 2.349173,-1.244779 3.589444,-1.688564 1.099136,-0.541341 2.26555" \
"8,-0.860322 3.384995,-1.366026 5.518505,-3.123477 -15.359314,8.690656 " \
"-11.325042,6.562985 4.683757,-2.470209 9.826663,-6.265044 15.072968,-8" \
".467654 1.169288,-0.37991 2.379509,-0.540929 3.409749,-1.289413 -29.66" \
"6352,17.271684 -10.82022,7.119963 -8.585469,4.48399 0,0 13.810255,-5.4" \
"03563 13.810255,-5.403563 z\"\n" \
"\t inkscape:connector-curvature=\"0\" />\n" \
"</svg>");
	inkscape_data = _tmp0_;
	{
		GFile* temp_file = NULL;
		GFileIOStream* ios = NULL;
		GDataOutputStream* d = NULL;
		GFileOutputStream* os = NULL;
		GFile* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFileIOStream* _tmp6_ = NULL;
		GFile* _tmp7_;
		GFileIOStream* _tmp8_;
		GFileIOStream* _tmp9_;
		GFileIOStream* _tmp10_;
		GOutputStream* _tmp11_;
		GOutputStream* _tmp12_;
		GFileOutputStream* _tmp13_;
		GFileOutputStream* _tmp14_;
		GDataOutputStream* _tmp15_;
		GDataOutputStream* _tmp16_;
		const gchar* _tmp17_;
		GDataOutputStream* _tmp18_;
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GFile* _tmp22_;
		_tmp1_ = bird_font_bird_font_get_settings_directory ();
		_tmp2_ = _tmp1_;
		_tmp3_ = bird_font_get_child (_tmp2_, "inkscape_test.svg");
		_g_object_unref0 (temp_file);
		temp_file = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp4_ = temp_file;
		if (g_file_query_exists (_tmp4_, NULL)) {
			GFile* _tmp5_;
			_tmp5_ = temp_file;
			g_file_delete (_tmp5_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (os);
				_g_object_unref0 (d);
				_g_object_unref0 (ios);
				_g_object_unref0 (temp_file);
				goto __catch0_g_error;
			}
		}
		_tmp7_ = temp_file;
		_tmp8_ = g_file_create_readwrite (_tmp7_, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (os);
			_g_object_unref0 (d);
			_g_object_unref0 (ios);
			_g_object_unref0 (temp_file);
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (ios);
		ios = _tmp9_;
		_tmp10_ = ios;
		_tmp11_ = g_io_stream_get_output_stream ((GIOStream*) G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_file_io_stream_get_type (), GFileIOStream));
		_tmp12_ = _tmp11_;
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, g_file_output_stream_get_type ()) ? ((GFileOutputStream*) _tmp12_) : NULL);
		_g_object_unref0 (os);
		os = _tmp13_;
		_tmp14_ = os;
		_tmp15_ = g_data_output_stream_new ((GOutputStream*) G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_file_output_stream_get_type (), GFileOutputStream));
		_g_object_unref0 (d);
		d = _tmp15_;
		_tmp16_ = d;
		_tmp17_ = inkscape_data;
		g_data_output_stream_put_string (_tmp16_, _tmp17_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (os);
			_g_object_unref0 (d);
			_g_object_unref0 (ios);
			_g_object_unref0 (temp_file);
			goto __catch0_g_error;
		}
		_tmp18_ = d;
		g_output_stream_close ((GOutputStream*) _tmp18_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (os);
			_g_object_unref0 (d);
			_g_object_unref0 (ios);
			_g_object_unref0 (temp_file);
			goto __catch0_g_error;
		}
		bird_font_test_cases_test_open_next_glyph ();
		_tmp19_ = temp_file;
		_tmp20_ = g_file_get_path (_tmp19_);
		_tmp21_ = (gchar*) _tmp20_;
		bird_font_svg_parser_import_svg (_tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = temp_file;
		g_file_delete (_tmp22_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (os);
			_g_object_unref0 (d);
			_g_object_unref0 (ios);
			_g_object_unref0 (temp_file);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (os);
		_g_object_unref0 (d);
		_g_object_unref0 (ios);
		_g_object_unref0 (temp_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("TestCases.vala:450: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (inkscape_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (inkscape_data);
}

void
bird_font_test_cases_test_spin_button (void)
{
	BirdFontSpinButton* s = NULL;
	BirdFontSpinButton* _tmp0_;
	gdouble last = 0.0;
	gchar* e = NULL;
	gchar* _tmp1_;
	BirdFontSpinButton* _tmp2_;
	BirdFontSpinButton* _tmp3_;
	BirdFontSpinButton* _tmp4_;
	BirdFontSpinButton* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	BirdFontSpinButton* _tmp10_;
	BirdFontSpinButton* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	BirdFontSpinButton* _tmp16_;
	BirdFontSpinButton* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean _tmp26_;
	BirdFontSpinButton* _tmp28_;
	BirdFontSpinButton* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gboolean _tmp32_;
	BirdFontSpinButton* _tmp34_;
	BirdFontSpinButton* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_;
	_tmp0_ = bird_font_spin_button_new (NULL, "");
	s = _tmp0_;
	_tmp1_ = g_strdup ("Wrong value in SpinButton");
	e = _tmp1_;
	_tmp2_ = s;
	bird_font_spin_button_set_max (_tmp2_, (gdouble) 1);
	_tmp3_ = s;
	bird_font_spin_button_set_min (_tmp3_, (gdouble) 0);
	_tmp4_ = s;
	bird_font_spin_button_set_value (_tmp4_, "0.000", TRUE, TRUE);
	_tmp5_ = s;
	_tmp6_ = bird_font_spin_button_get_display_value (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strcmp0 (_tmp7_, "0.000") != 0;
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		const gchar* _tmp9_;
		_tmp9_ = e;
		g_warning ("TestCases.vala:464: %s", _tmp9_);
	}
	_tmp10_ = s;
	bird_font_spin_button_increase (_tmp10_);
	_tmp11_ = s;
	_tmp12_ = bird_font_spin_button_get_display_value (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strcmp0 (_tmp13_, "0.001") != 0;
	_g_free0 (_tmp13_);
	if (_tmp14_) {
		const gchar* _tmp15_;
		_tmp15_ = e;
		g_warning ("TestCases.vala:470: %s", _tmp15_);
	}
	_tmp16_ = s;
	last = bird_font_spin_button_get_value (_tmp16_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				BirdFontSpinButton* _tmp19_;
				BirdFontSpinButton* _tmp20_;
				BirdFontSpinButton* _tmp22_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < 100)) {
					break;
				}
				_tmp19_ = s;
				bird_font_spin_button_increase (_tmp19_);
				_tmp20_ = s;
				if (last > bird_font_spin_button_get_value (_tmp20_)) {
					const gchar* _tmp21_;
					_tmp21_ = e;
					g_warning ("TestCases.vala:477: %s", _tmp21_);
				}
				_tmp22_ = s;
				last = bird_font_spin_button_get_value (_tmp22_);
			}
		}
	}
	_tmp23_ = s;
	_tmp24_ = bird_font_spin_button_get_display_value (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strcmp0 (_tmp25_, "0.101") != 0;
	_g_free0 (_tmp25_);
	if (_tmp26_) {
		const gchar* _tmp27_;
		_tmp27_ = e;
		g_warning ("TestCases.vala:483: %s", _tmp27_);
	}
	_tmp28_ = s;
	bird_font_spin_button_set_value (_tmp28_, "1.000", TRUE, TRUE);
	_tmp29_ = s;
	_tmp30_ = bird_font_spin_button_get_display_value (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strcmp0 (_tmp31_, "1.000") != 0;
	_g_free0 (_tmp31_);
	if (_tmp32_) {
		const gchar* _tmp33_;
		_tmp33_ = e;
		g_warning ("TestCases.vala:489: %s", _tmp33_);
	}
	_tmp34_ = s;
	last = bird_font_spin_button_get_value (_tmp34_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp35_ = FALSE;
			_tmp35_ = TRUE;
			while (TRUE) {
				BirdFontSpinButton* _tmp37_;
				BirdFontSpinButton* _tmp38_;
				BirdFontSpinButton* _tmp40_;
				if (!_tmp35_) {
					gint _tmp36_;
					_tmp36_ = i;
					i = _tmp36_ + 1;
				}
				_tmp35_ = FALSE;
				if (!(i < 100)) {
					break;
				}
				_tmp37_ = s;
				bird_font_spin_button_decrease (_tmp37_);
				_tmp38_ = s;
				if (last < bird_font_spin_button_get_value (_tmp38_)) {
					const gchar* _tmp39_;
					_tmp39_ = e;
					g_warning ("TestCases.vala:496: %s", _tmp39_);
				}
				_tmp40_ = s;
				last = bird_font_spin_button_get_value (_tmp40_);
			}
		}
	}
	_tmp41_ = s;
	_tmp42_ = bird_font_spin_button_get_display_value (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strcmp0 (_tmp43_, "0.900") != 0;
	_g_free0 (_tmp43_);
	if (_tmp44_) {
		const gchar* _tmp45_;
		_tmp45_ = e;
		g_warning ("TestCases.vala:502: %s", _tmp45_);
	}
	_g_free0 (e);
	_g_object_unref0 (s);
}

void
bird_font_test_cases_test_background_coordinates (void)
{
	BirdFontBackgroundImage* bg = NULL;
	BirdFontBackgroundImage* _tmp0_;
	BirdFontBackgroundImage* _tmp1_;
	BirdFontBackgroundImage* _tmp2_;
	BirdFontBackgroundImage* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontBackgroundImage* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gboolean _tmp9_ = FALSE;
	BirdFontBackgroundImage* _tmp10_;
	BirdFontBackgroundImage* _tmp12_;
	BirdFontBackgroundImage* _tmp13_;
	BirdFontBackgroundImage* _tmp14_;
	BirdFontBackgroundImage* _tmp15_;
	gboolean _tmp16_ = FALSE;
	BirdFontBackgroundImage* _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	_tmp0_ = bird_font_background_image_new ("");
	bg = _tmp0_;
	_tmp1_ = bg;
	bird_font_background_image_set_position (_tmp1_, (gdouble) 100, (gdouble) 100);
	_tmp2_ = bg;
	_tmp3_ = bg;
	_tmp4_ = bird_font_background_image_get_img_offset_x (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = bg;
	_tmp7_ = bird_font_background_image_get_img_offset_y (_tmp6_);
	_tmp8_ = _tmp7_;
	bird_font_background_image_set_img_offset (_tmp2_, _tmp5_, _tmp8_);
	_tmp10_ = bg;
	if (_tmp10_->img_x == ((gdouble) 100)) {
		BirdFontBackgroundImage* _tmp11_;
		_tmp11_ = bg;
		_tmp9_ = _tmp11_->img_y == ((gdouble) 100);
	} else {
		_tmp9_ = FALSE;
	}
	g_warn_if_fail (_tmp9_);
	_tmp12_ = bg;
	bird_font_background_image_set_img_offset (_tmp12_, (gdouble) 100, (gdouble) 100);
	_tmp13_ = bg;
	_tmp14_ = bg;
	_tmp15_ = bg;
	bird_font_background_image_set_position (_tmp13_, _tmp14_->img_x, _tmp15_->img_y);
	_tmp17_ = bg;
	_tmp18_ = bird_font_background_image_get_img_offset_x (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == ((gdouble) 100)) {
		BirdFontBackgroundImage* _tmp20_;
		gdouble _tmp21_;
		gdouble _tmp22_;
		_tmp20_ = bg;
		_tmp21_ = bird_font_background_image_get_img_offset_y (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ == ((gdouble) 100);
	} else {
		_tmp16_ = FALSE;
	}
	g_warn_if_fail (_tmp16_);
	_g_object_unref0 (bg);
}

void
bird_font_test_cases_test_export (void)
{
	BirdFontGlyph* g = NULL;
	BirdFontPath* p = NULL;
	BirdFontPath* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontPath* _tmp2_;
	BirdFontEditPoint* _tmp3_;
	BirdFontEditPoint* _tmp4_;
	BirdFontPath* _tmp5_;
	BirdFontEditPoint* _tmp6_;
	BirdFontEditPoint* _tmp7_;
	BirdFontPath* _tmp8_;
	BirdFontEditPoint* _tmp9_;
	BirdFontEditPoint* _tmp10_;
	BirdFontPath* _tmp11_;
	BirdFontGlyph* _tmp12_;
	BirdFontPath* _tmp13_;
	_tmp0_ = bird_font_path_new ();
	p = _tmp0_;
	bird_font_test_cases_test_open_next_glyph ();
	_tmp1_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp1_;
	_tmp2_ = p;
	_tmp3_ = bird_font_path_add (_tmp2_, (gdouble) -10, (gdouble) -10);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	_tmp5_ = p;
	_tmp6_ = bird_font_path_add (_tmp5_, (gdouble) 50, (gdouble) 50);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp7_);
	_tmp8_ = p;
	_tmp9_ = bird_font_path_add (_tmp8_, (gdouble) 10, (gdouble) -10);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp10_);
	_tmp11_ = p;
	bird_font_path_close (_tmp11_);
	_tmp12_ = g;
	_tmp13_ = p;
	bird_font_glyph_add_path (_tmp12_, _tmp13_);
	bird_font_menu_tab_preview ();
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				bird_font_menu_tab_export_fonts_in_background ();
				bird_font_tool_yield ();
			}
		}
	}
	_g_object_unref0 (p);
	_g_object_unref0 (g);
}

void
bird_font_test_cases_test_preview (void)
{
	BirdFontGlyph* g = NULL;
	BirdFontPath* p = NULL;
	BirdFontPath* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontPath* _tmp2_;
	BirdFontEditPoint* _tmp3_;
	BirdFontEditPoint* _tmp4_;
	BirdFontPath* _tmp5_;
	BirdFontEditPoint* _tmp6_;
	BirdFontEditPoint* _tmp7_;
	BirdFontPath* _tmp8_;
	BirdFontEditPoint* _tmp9_;
	BirdFontEditPoint* _tmp10_;
	BirdFontPath* _tmp11_;
	BirdFontEditPoint* _tmp12_;
	BirdFontEditPoint* _tmp13_;
	BirdFontPath* _tmp14_;
	BirdFontGlyph* _tmp15_;
	BirdFontPath* _tmp16_;
	_tmp0_ = bird_font_path_new ();
	p = _tmp0_;
	bird_font_test_cases_test_open_next_glyph ();
	_tmp1_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp1_;
	_tmp2_ = p;
	_tmp3_ = bird_font_path_add (_tmp2_, (gdouble) -10, (gdouble) 10);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	_tmp5_ = p;
	_tmp6_ = bird_font_path_add (_tmp5_, (gdouble) 10, (gdouble) 10);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp7_);
	_tmp8_ = p;
	_tmp9_ = bird_font_path_add (_tmp8_, (gdouble) 10, (gdouble) -10);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp10_);
	_tmp11_ = p;
	_tmp12_ = bird_font_path_add (_tmp11_, (gdouble) -10, (gdouble) -10);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp13_);
	_tmp14_ = p;
	bird_font_path_close (_tmp14_);
	_tmp15_ = g;
	_tmp16_ = p;
	bird_font_glyph_add_path (_tmp15_, _tmp16_);
	bird_font_menu_tab_preview ();
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				BirdFontTabBar* _tmp19_;
				BirdFontTabBar* _tmp20_;
				BirdFontTabBar* _tmp21_;
				BirdFontTabBar* _tmp22_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < 100)) {
					break;
				}
				_tmp19_ = bird_font_main_window_get_tab_bar ();
				_tmp20_ = _tmp19_;
				bird_font_tab_bar_select_tab_name (_tmp20_, "Files");
				_g_object_unref0 (_tmp20_);
				bird_font_tool_yield ();
				_tmp21_ = bird_font_main_window_get_tab_bar ();
				_tmp22_ = _tmp21_;
				bird_font_tab_bar_select_tab_name (_tmp22_, "Preview");
				_g_object_unref0 (_tmp22_);
				bird_font_tool_yield ();
			}
		}
	}
	_g_object_unref0 (p);
	_g_object_unref0 (g);
}

void
bird_font_test_cases_test_over_path (void)
{
	BirdFontGlyph* g = NULL;
	BirdFontPath* p = NULL;
	BirdFontPath* _tmp0_;
	BirdFontTool* pen_tool = NULL;
	BirdFontToolbox* _tmp1_;
	BirdFontToolbox* _tmp2_;
	BirdFontTool* _tmp3_;
	BirdFontTool* _tmp4_;
	BirdFontGlyph* _tmp5_;
	BirdFontTool* _tmp6_;
	BirdFontTool* _tmp7_;
	BirdFontTool* _tmp8_;
	BirdFontTool* _tmp9_;
	BirdFontTool* _tmp10_;
	BirdFontTool* _tmp11_;
	BirdFontGlyph* _tmp12_;
	BirdFontGlyph* _tmp13_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	BirdFontGlyph* _tmp17_;
	BirdFontGlyph* _tmp18_;
	GeeArrayList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	BirdFontPath* _tmp22_;
	BirdFontEditPoint* _tmp23_;
	BirdFontEditPoint* _tmp24_;
	BirdFontPath* _tmp25_;
	BirdFontEditPoint* _tmp26_;
	BirdFontEditPoint* _tmp27_;
	BirdFontPath* _tmp28_;
	BirdFontEditPoint* _tmp29_;
	BirdFontEditPoint* _tmp30_;
	BirdFontPath* _tmp31_;
	BirdFontEditPoint* _tmp32_;
	BirdFontEditPoint* _tmp33_;
	BirdFontPath* _tmp34_;
	BirdFontGlyph* _tmp35_;
	BirdFontPath* _tmp36_;
	BirdFontGlyph* _tmp37_;
	BirdFontPath* _tmp38_;
	BirdFontPath* _tmp39_;
	BirdFontPath* _tmp40_;
	_tmp0_ = bird_font_path_new ();
	p = _tmp0_;
	_tmp1_ = bird_font_main_window_get_toolbox ();
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_toolbox_get_tool (_tmp2_, "pen_tool");
	_g_object_unref0 (pen_tool);
	pen_tool = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp4_ = pen_tool;
	bird_font_test_cases_test_select_action (_tmp4_);
	bird_font_test_cases_test_open_next_glyph ();
	_tmp5_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp5_;
	_tmp6_ = pen_tool;
	bird_font_test_cases_test_click_action (_tmp6_, 3, 10, 10);
	_tmp7_ = pen_tool;
	bird_font_test_cases_test_click_action (_tmp7_, 3, 10, 10);
	_tmp8_ = pen_tool;
	bird_font_test_cases_test_click_action (_tmp8_, 3, 100, 10);
	_tmp9_ = pen_tool;
	bird_font_test_cases_test_click_action (_tmp9_, 3, 100, 100);
	_tmp10_ = pen_tool;
	bird_font_test_cases_test_click_action (_tmp10_, 3, 10, 100);
	_tmp11_ = pen_tool;
	bird_font_test_cases_test_click_action (_tmp11_, 2, 0, 0);
	_tmp12_ = g;
	bird_font_glyph_close_path (_tmp12_);
	_tmp13_ = g;
	_tmp14_ = _tmp13_->active_paths;
	_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	g_warn_if_fail (_tmp16_ == 0);
	_tmp17_ = g;
	bird_font_glyph_select_path (_tmp17_, (gdouble) 50, (gdouble) 50);
	_tmp18_ = g;
	_tmp19_ = _tmp18_->active_paths;
	_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
	_tmp21_ = _tmp20_;
	g_warn_if_fail (_tmp21_ == 1);
	_tmp22_ = p;
	_tmp23_ = bird_font_path_add (_tmp22_, (gdouble) -10, (gdouble) 10);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp24_);
	_tmp25_ = p;
	_tmp26_ = bird_font_path_add (_tmp25_, (gdouble) 10, (gdouble) 10);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (_tmp27_);
	_tmp28_ = p;
	_tmp29_ = bird_font_path_add (_tmp28_, (gdouble) 10, (gdouble) -10);
	_tmp30_ = _tmp29_;
	_g_object_unref0 (_tmp30_);
	_tmp31_ = p;
	_tmp32_ = bird_font_path_add (_tmp31_, (gdouble) -10, (gdouble) -10);
	_tmp33_ = _tmp32_;
	_g_object_unref0 (_tmp33_);
	_tmp34_ = p;
	bird_font_path_update_region_boundaries (_tmp34_);
	_tmp35_ = g;
	_tmp36_ = p;
	bird_font_glyph_add_path (_tmp35_, _tmp36_);
	_tmp37_ = g;
	bird_font_glyph_close_path (_tmp37_);
	_tmp38_ = p;
	if (!bird_font_path_is_over_coordinate (_tmp38_, (gdouble) 0, (gdouble) 0)) {
		g_warning ("TestCases.vala:603: Coordinate 0, 0 is not in path.");
	}
	_tmp39_ = p;
	if (!bird_font_path_is_over_coordinate (_tmp39_, (gdouble) -10, (gdouble) 10)) {
		g_warning ("TestCases.vala:607: Corner corrdinate -10, 10 is not in path.");
	}
	_tmp40_ = p;
	g_warn_if_fail (!bird_font_path_is_over_coordinate (_tmp40_, (gdouble) -20, (gdouble) -20));
	{
		gdouble x = 0.0;
		x = (gdouble) -10;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				if (!_tmp41_) {
					x += 0.1;
				}
				_tmp41_ = FALSE;
				if (!(x <= ((gdouble) 10))) {
					break;
				}
				{
					gdouble y = 0.0;
					y = (gdouble) 10;
					{
						gboolean _tmp42_ = FALSE;
						_tmp42_ = TRUE;
						while (TRUE) {
							BirdFontPath* _tmp43_;
							if (!_tmp42_) {
								y += 0.1;
							}
							_tmp42_ = FALSE;
							if (!(y <= ((gdouble) 10))) {
								break;
							}
							_tmp43_ = p;
							g_warn_if_fail (bird_font_path_is_over_coordinate (_tmp43_, x, y));
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (pen_tool);
	_g_object_unref0 (p);
	_g_object_unref0 (g);
}

void
bird_font_test_cases_test_convert_to_quadratic_bezier_path (void)
{
	BirdFontGlyph* g = NULL;
	BirdFontPath* p = NULL;
	BirdFontPath* p1 = NULL;
	BirdFontEditPoint* e0 = NULL;
	BirdFontEditPoint* e1 = NULL;
	BirdFontEditPoint* e2 = NULL;
	BirdFontEditPoint* e3 = NULL;
	GList* paths = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontPath* _tmp14_;
	BirdFontPath* _tmp15_;
	BirdFontGlyph* _tmp16_;
	BirdFontPath* _tmp17_;
	BirdFontEditPoint* _tmp18_;
	BirdFontEditPoint* _tmp19_;
	BirdFontPath* _tmp20_;
	BirdFontEditPoint* _tmp21_;
	BirdFontEditPoint* _tmp22_;
	BirdFontPath* _tmp23_;
	BirdFontEditPoint* _tmp24_;
	BirdFontEditPoint* _tmp25_;
	BirdFontPath* _tmp26_;
	BirdFontEditPoint* _tmp27_;
	BirdFontEditPoint* _tmp28_;
	BirdFontPath* _tmp29_;
	BirdFontGlyph* _tmp30_;
	BirdFontPath* _tmp31_;
	BirdFontGlyph* _tmp32_;
	BirdFontPath* _tmp33_;
	BirdFontPath* _tmp34_;
	BirdFontPath* _tmp35_;
	BirdFontEditPoint* _tmp36_;
	BirdFontEditPoint* _tmp37_;
	BirdFontEditPoint* _tmp38_;
	BirdFontEditPoint* _tmp39_;
	BirdFontPath* _tmp40_;
	BirdFontEditPoint* _tmp41_;
	BirdFontEditPoint* _tmp42_;
	BirdFontEditPoint* _tmp43_;
	BirdFontPath* _tmp44_;
	BirdFontEditPoint* _tmp45_;
	BirdFontEditPoint* _tmp46_;
	BirdFontEditPoint* _tmp47_;
	BirdFontPath* _tmp48_;
	BirdFontEditPoint* _tmp49_;
	BirdFontEditPoint* _tmp50_;
	BirdFontEditPoint* _tmp51_;
	BirdFontPath* _tmp52_;
	BirdFontEditPoint* _tmp53_;
	BirdFontEditPoint* _tmp54_;
	BirdFontEditPoint* _tmp55_;
	BirdFontPath* _tmp56_;
	BirdFontEditPoint* _tmp57_;
	BirdFontEditPoint* _tmp58_;
	BirdFontEditPoint* _tmp59_;
	BirdFontEditPoint* _tmp60_;
	BirdFontEditPoint* _tmp61_;
	BirdFontEditPoint* _tmp62_;
	BirdFontEditPoint* _tmp63_;
	BirdFontEditPoint* _tmp64_;
	BirdFontGlyph* _tmp65_;
	BirdFontPath* _tmp66_;
	BirdFontGlyph* _tmp67_;
	BirdFontPath* _tmp68_;
	BirdFontPath* _tmp69_;
	BirdFontPath* _tmp70_;
	GList* _tmp71_;
	paths = NULL;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp0_;
	{
		GeeArrayList* _path_list = NULL;
		BirdFontGlyph* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _path_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _path_index = 0;
		_tmp1_ = g;
		_tmp2_ = bird_font_glyph_get_all_paths (_tmp1_);
		_path_list = _tmp2_;
		_tmp3_ = _path_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_path_size = _tmp5_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			BirdFontPath* _tmp11_;
			BirdFontPath* _tmp12_;
			BirdFontPath* _tmp13_;
			_path_index = _path_index + 1;
			_tmp6_ = _path_index;
			_tmp7_ = _path_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _path_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _path_index);
			path = (BirdFontPath*) _tmp9_;
			_tmp10_ = path;
			_tmp11_ = bird_font_path_get_quadratic_points (_tmp10_);
			paths = g_list_append (paths, _tmp11_);
			_tmp12_ = path;
			_tmp13_ = bird_font_path_copy (_tmp12_);
			paths = g_list_append (paths, _tmp13_);
			_g_object_unref0 (path);
		}
		_g_object_unref0 (_path_list);
	}
	bird_font_test_cases_test_open_next_glyph ();
	_tmp14_ = bird_font_path_new ();
	_g_object_unref0 (p);
	p = _tmp14_;
	_tmp15_ = bird_font_path_new ();
	_g_object_unref0 (p1);
	p1 = _tmp15_;
	_tmp16_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp16_;
	_tmp17_ = p;
	_tmp18_ = bird_font_path_add (_tmp17_, (gdouble) -10, (gdouble) 10);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp19_);
	_tmp20_ = p;
	_tmp21_ = bird_font_path_add (_tmp20_, (gdouble) 10, (gdouble) 10);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp22_);
	_tmp23_ = p;
	_tmp24_ = bird_font_path_add (_tmp23_, (gdouble) 10, (gdouble) -10);
	_tmp25_ = _tmp24_;
	_g_object_unref0 (_tmp25_);
	_tmp26_ = p;
	_tmp27_ = bird_font_path_add (_tmp26_, (gdouble) -10, (gdouble) -10);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (_tmp28_);
	_tmp29_ = p;
	bird_font_path_close (_tmp29_);
	_tmp30_ = g;
	_tmp31_ = p;
	bird_font_glyph_add_path (_tmp30_, _tmp31_);
	_tmp32_ = g;
	_tmp33_ = p1;
	_tmp34_ = bird_font_path_get_quadratic_points (_tmp33_);
	_tmp35_ = _tmp34_;
	bird_font_glyph_add_path (_tmp32_, _tmp35_);
	_g_object_unref0 (_tmp35_);
	_tmp36_ = bird_font_edit_point_new ((gdouble) 20, (gdouble) 40, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (e0);
	e0 = _tmp36_;
	_tmp37_ = bird_font_edit_point_new ((gdouble) 40, (gdouble) 40, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (e1);
	e1 = _tmp37_;
	_tmp38_ = bird_font_edit_point_new ((gdouble) 40, (gdouble) 20, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (e2);
	e2 = _tmp38_;
	_tmp39_ = bird_font_edit_point_new ((gdouble) 20, (gdouble) 20, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (e3);
	e3 = _tmp39_;
	_tmp40_ = p1;
	_tmp41_ = e0;
	_tmp42_ = bird_font_path_add_point (_tmp40_, _tmp41_);
	_tmp43_ = _tmp42_;
	_g_object_unref0 (_tmp43_);
	_tmp44_ = p1;
	_tmp45_ = e1;
	_tmp46_ = bird_font_path_add_point (_tmp44_, _tmp45_);
	_tmp47_ = _tmp46_;
	_g_object_unref0 (_tmp47_);
	_tmp48_ = p1;
	_tmp49_ = e2;
	_tmp50_ = bird_font_path_add_point (_tmp48_, _tmp49_);
	_tmp51_ = _tmp50_;
	_g_object_unref0 (_tmp51_);
	_tmp52_ = p1;
	_tmp53_ = e3;
	_tmp54_ = bird_font_path_add_point (_tmp52_, _tmp53_);
	_tmp55_ = _tmp54_;
	_g_object_unref0 (_tmp55_);
	_tmp56_ = p1;
	bird_font_path_close (_tmp56_);
	_tmp57_ = e0;
	bird_font_edit_point_set_tie_handle (_tmp57_, TRUE);
	_tmp58_ = e1;
	bird_font_edit_point_set_tie_handle (_tmp58_, TRUE);
	_tmp59_ = e2;
	bird_font_edit_point_set_tie_handle (_tmp59_, TRUE);
	_tmp60_ = e3;
	bird_font_edit_point_set_tie_handle (_tmp60_, TRUE);
	_tmp61_ = e0;
	bird_font_edit_point_process_tied_handle (_tmp61_);
	_tmp62_ = e1;
	bird_font_edit_point_process_tied_handle (_tmp62_);
	_tmp63_ = e2;
	bird_font_edit_point_process_tied_handle (_tmp63_);
	_tmp64_ = e3;
	bird_font_edit_point_process_tied_handle (_tmp64_);
	_tmp65_ = g;
	_tmp66_ = p1;
	bird_font_glyph_add_path (_tmp65_, _tmp66_);
	_tmp67_ = g;
	_tmp68_ = p1;
	_tmp69_ = bird_font_path_get_quadratic_points (_tmp68_);
	_tmp70_ = _tmp69_;
	bird_font_glyph_add_path (_tmp67_, _tmp70_);
	_g_object_unref0 (_tmp70_);
	_tmp71_ = paths;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp71_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			BirdFontPath* _tmp72_;
			BirdFontPath* path = NULL;
			_tmp72_ = _g_object_ref0 ((BirdFontPath*) path_it->data);
			path = _tmp72_;
			{
				BirdFontGlyph* _tmp73_;
				BirdFontPath* _tmp74_;
				_tmp73_ = g;
				_tmp74_ = path;
				bird_font_glyph_add_path (_tmp73_, _tmp74_);
				_g_object_unref0 (path);
			}
		}
	}
	(paths == NULL) ? NULL : (paths = (_g_list_free__g_object_unref0_ (paths), NULL));
	_g_object_unref0 (e3);
	_g_object_unref0 (e2);
	_g_object_unref0 (e1);
	_g_object_unref0 (e0);
	_g_object_unref0 (p1);
	_g_object_unref0 (p);
	_g_object_unref0 (g);
}

void
bird_font_test_cases_test_overview (void)
{
	BirdFontOverview* o = NULL;
	BirdFontOverview* _tmp0_;
	BirdFontOverview* _tmp1_;
	_tmp0_ = bird_font_main_window_get_overview ();
	o = _tmp0_;
	_tmp1_ = o;
	g_warn_if_fail (bird_font_overview_selected_char_is_visible (_tmp1_));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				BirdFontOverview* _tmp4_;
				BirdFontOverview* _tmp5_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				_tmp4_ = o;
				bird_font_overview_key_down (_tmp4_);
				_tmp5_ = o;
				g_warn_if_fail (bird_font_overview_selected_char_is_visible (_tmp5_));
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				BirdFontOverview* _tmp8_;
				BirdFontOverview* _tmp9_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < 15)) {
					break;
				}
				_tmp8_ = o;
				bird_font_overview_key_up (_tmp8_);
				_tmp9_ = o;
				g_warn_if_fail (bird_font_overview_selected_char_is_visible (_tmp9_));
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				BirdFontOverview* _tmp12_;
				BirdFontOverview* _tmp13_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				if (!(i < 6)) {
					break;
				}
				_tmp12_ = o;
				bird_font_overview_key_down (_tmp12_);
				_tmp13_ = o;
				g_warn_if_fail (bird_font_overview_selected_char_is_visible (_tmp13_));
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				BirdFontOverview* _tmp16_;
				BirdFontOverview* _tmp17_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				_tmp16_ = o;
				bird_font_overview_key_down (_tmp16_);
				_tmp17_ = o;
				g_warn_if_fail (bird_font_overview_selected_char_is_visible (_tmp17_));
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				BirdFontOverview* _tmp20_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				if (!(i < 2000)) {
					break;
				}
				_tmp20_ = o;
				bird_font_overview_scroll_adjustment (_tmp20_, (gdouble) 5);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				BirdFontOverview* _tmp23_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				if (!(i < 2000)) {
					break;
				}
				_tmp23_ = o;
				bird_font_overview_scroll_adjustment (_tmp23_, (gdouble) -5);
			}
		}
	}
	_g_object_unref0 (o);
}

void
bird_font_test_cases_test_data_reader (void)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	guint len = 0U;
	gint v = 0;
	GError* _inner_error0_ = NULL;
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	{
		BirdFontFontData* _tmp1_;
		BirdFontFontData* _tmp2_;
		BirdFontFontData* _tmp3_;
		BirdFontFontData* _tmp4_;
		guint8* _tmp5_;
		guint8 _tmp6_;
		BirdFontFontData* _tmp7_;
		BirdFontFontData* _tmp8_;
		BirdFontFontData* _tmp9_;
		BirdFontFontData* _tmp10_;
		BirdFontFontData* _tmp14_;
		gint16 _tmp15_ = 0;
		BirdFontFontData* _tmp16_;
		BirdFontFontData* _tmp17_;
		BirdFontFontData* _tmp18_;
		BirdFontFontData* _tmp19_;
		gint16 _tmp20_ = 0;
		BirdFontFontData* _tmp21_;
		BirdFontFontData* _tmp22_;
		BirdFontFontData* _tmp23_;
		BirdFontFontData* _tmp24_;
		BirdFontFontData* _tmp25_;
		BirdFontFontData* _tmp26_;
		_tmp1_ = fd;
		bird_font_font_data_add (_tmp1_, (guint8) 7);
		_tmp2_ = fd;
		bird_font_font_data_add_ulong (_tmp2_, (guint32) 0x5F0F3CF5, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = fd;
		bird_font_font_data_add_ulong (_tmp3_, (guint32) 9, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = fd;
		_tmp5_ = _tmp4_->table_data;
		_tmp6_ = _tmp5_[0];
		g_warn_if_fail (((gint) _tmp6_) == 7);
		_tmp7_ = fd;
		g_warn_if_fail (((gint) bird_font_font_data_read (_tmp7_)) == 7);
		_tmp8_ = fd;
		g_warn_if_fail (bird_font_font_data_read_ulong (_tmp8_) == ((guint32) 0x5F0F3CF5));
		_tmp9_ = fd;
		g_warn_if_fail (bird_font_font_data_read_ulong (_tmp9_) == ((guint32) 9));
		_tmp10_ = bird_font_font_data_new ((guint32) 1024);
		_g_object_unref0 (fd);
		fd = _tmp10_;
		{
			gint16 i = 0;
			i = (gint16) 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					BirdFontFontData* _tmp13_;
					if (!_tmp11_) {
						gint16 _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					if (!(((gint) i) < 2048)) {
						break;
					}
					_tmp13_ = fd;
					bird_font_font_data_add_short (_tmp13_, i, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
			}
		}
		_tmp14_ = fd;
		bird_font_font_data_seek (_tmp14_, (guint) (2 * 80));
		_tmp16_ = fd;
		_tmp15_ = bird_font_font_data_read_short (_tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_warn_if_fail (((gint) _tmp15_) == 80);
		_tmp17_ = fd;
		bird_font_font_data_seek (_tmp17_, (guint) 100);
		_tmp18_ = fd;
		bird_font_font_data_add_short (_tmp18_, (gint16) 7, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp19_ = fd;
		bird_font_font_data_seek (_tmp19_, (guint) 100);
		_tmp21_ = fd;
		_tmp20_ = bird_font_font_data_read_short (_tmp21_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_warn_if_fail (((gint) _tmp20_) == 7);
		_tmp22_ = fd;
		bird_font_font_data_seek_end (_tmp22_);
		_tmp23_ = fd;
		len = bird_font_font_data_length (_tmp23_);
		_tmp24_ = fd;
		bird_font_font_data_add (_tmp24_, (guint8) 0);
		_tmp25_ = fd;
		g_warn_if_fail ((len + 1) == bird_font_font_data_length (_tmp25_));
		_tmp26_ = fd;
		bird_font_font_data_seek_end (_tmp26_);
		{
			gint i = 0;
			i = -1131;
			{
				gboolean _tmp27_ = FALSE;
				_tmp27_ = TRUE;
				while (TRUE) {
					BirdFontFontData* _tmp29_;
					if (!_tmp27_) {
						gint _tmp28_;
						_tmp28_ = i;
						i = _tmp28_ + 1;
					}
					_tmp27_ = FALSE;
					if (!(i < 1131)) {
						break;
					}
					_tmp29_ = fd;
					bird_font_font_data_add_charstring_value (_tmp29_, i, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
			}
		}
		{
			gint i = 0;
			i = -1131;
			{
				gboolean _tmp30_ = FALSE;
				_tmp30_ = TRUE;
				while (TRUE) {
					gint _tmp32_ = 0;
					BirdFontFontData* _tmp33_;
					if (!_tmp30_) {
						gint _tmp31_;
						_tmp31_ = i;
						i = _tmp31_ + 1;
					}
					_tmp30_ = FALSE;
					if (!(i < 1131)) {
						break;
					}
					_tmp33_ = fd;
					_tmp32_ = bird_font_font_data_read_charstring_value (_tmp33_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					v = _tmp32_;
					if (v != i) {
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						_tmp34_ = g_strdup_printf ("%i", i);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strdup_printf ("%i", v);
						_tmp37_ = _tmp36_;
						_tmp38_ = g_strconcat ("expecting ", _tmp35_, " got ", _tmp37_, "\n", NULL);
						_tmp39_ = _tmp38_;
						g_warning ("TestCases.vala:754: %s", _tmp39_);
						_g_free0 (_tmp39_);
						_g_free0 (_tmp37_);
						_g_free0 (_tmp35_);
					}
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp40_;
		const gchar* _tmp41_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = e;
		_tmp41_ = _tmp40_->message;
		g_warning ("TestCases.vala:759: %s", _tmp41_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (fd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (fd);
}

void
bird_font_test_cases_test_argument (void)
{
	BirdFontArgument* arg = NULL;
	BirdFontArgument* _tmp0_;
	BirdFontArgument* _tmp1_;
	BirdFontArgument* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BirdFontArgument* _tmp5_;
	BirdFontArgument* _tmp6_;
	BirdFontArgument* _tmp7_;
	BirdFontArgument* _tmp8_;
	BirdFontArgument* _tmp9_;
	BirdFontArgument* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	BirdFontArgument* _tmp13_;
	BirdFontArgument* _tmp14_;
	BirdFontArgument* _tmp15_;
	_tmp0_ = bird_font_argument_new ("supplement -t \"Argument list\" --unknown -unknown --help -s");
	arg = _tmp0_;
	_tmp1_ = arg;
	g_return_if_fail (bird_font_argument_has_argument (_tmp1_, "--test"));
	_tmp2_ = arg;
	_tmp3_ = bird_font_argument_get_argument (_tmp2_, "--test");
	_tmp4_ = (gchar*) _tmp3_;
	g_return_if_fail (g_strcmp0 (_tmp4_, "\"Argument list\"") == 0);
	_g_free0 (_tmp4_);
	_tmp5_ = arg;
	g_return_if_fail (bird_font_argument_has_argument (_tmp5_, "--unknown"));
	_tmp6_ = arg;
	g_return_if_fail (bird_font_argument_has_argument (_tmp6_, "--help"));
	_tmp7_ = arg;
	g_return_if_fail (bird_font_argument_has_argument (_tmp7_, "--slow"));
	_tmp8_ = arg;
	g_return_if_fail (bird_font_argument_validate (_tmp8_) != 0);
	_tmp9_ = bird_font_argument_new ("supplement --test \"Argument list\"");
	_g_object_unref0 (arg);
	arg = _tmp9_;
	_tmp10_ = arg;
	_tmp11_ = bird_font_argument_get_argument (_tmp10_, "--test");
	_tmp12_ = (gchar*) _tmp11_;
	g_return_if_fail (g_strcmp0 (_tmp12_, "\"Argument list\"") == 0);
	_g_free0 (_tmp12_);
	_tmp13_ = arg;
	g_return_if_fail (!bird_font_argument_has_argument (_tmp13_, "--help"));
	_tmp14_ = arg;
	g_return_if_fail (!bird_font_argument_has_argument (_tmp14_, "--slow"));
	_tmp15_ = arg;
	g_return_if_fail (bird_font_argument_validate (_tmp15_) == 0);
	_g_object_unref0 (arg);
}

void
bird_font_test_cases_test_glyph_ranges (void)
{
	BirdFontGlyphRange* gr = NULL;
	BirdFontGlyphRange* _tmp0_;
	BirdFontGlyphRange* gr_az = NULL;
	BirdFontGlyphRange* _tmp1_;
	BirdFontGlyphRange* _tmp2_;
	BirdFontGlyphRange* _tmp3_;
	BirdFontGlyphRange* _tmp4_;
	BirdFontGlyphRange* _tmp5_;
	BirdFontGlyphRange* _tmp6_;
	BirdFontGlyphRange* _tmp7_;
	BirdFontGlyphRange* _tmp8_;
	BirdFontGlyphRange* _tmp9_;
	BirdFontGlyphRange* _tmp10_;
	BirdFontGlyphRange* _tmp11_;
	BirdFontGlyphRange* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	BirdFontGlyphRange* _tmp16_;
	GeeArrayList* _tmp17_;
	gpointer _tmp18_;
	BirdFontUniRange* _tmp19_;
	BirdFontGlyphRange* _tmp38_;
	BirdFontGlyphRange* _tmp39_;
	BirdFontGlyphRange* _tmp40_;
	BirdFontGlyphRange* _tmp41_;
	BirdFontGlyphRange* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	BirdFontGlyphRange* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	BirdFontGlyphRange* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	BirdFontGlyphRange* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	BirdFontGlyphRange* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	BirdFontGlyphRange* _tmp57_;
	BirdFontGlyphRange* _tmp58_;
	BirdFontGlyphRange* _tmp59_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = bird_font_glyph_range_new ();
	gr = _tmp0_;
	_tmp1_ = bird_font_glyph_range_new ();
	gr_az = _tmp1_;
	_tmp2_ = gr;
	bird_font_glyph_range_add_range (_tmp2_, (gunichar) 'b', (gunichar) 'c');
	_tmp3_ = gr;
	bird_font_glyph_range_add_single (_tmp3_, (gunichar) 'd');
	_tmp4_ = gr;
	bird_font_glyph_range_add_range (_tmp4_, (gunichar) 'e', (gunichar) 'h');
	_tmp5_ = gr;
	bird_font_glyph_range_add_range (_tmp5_, (gunichar) 'k', (gunichar) 'm');
	_tmp6_ = gr;
	bird_font_glyph_range_add_range (_tmp6_, (gunichar) 'o', (gunichar) 'u');
	_tmp7_ = gr;
	bird_font_glyph_range_add_range (_tmp7_, (gunichar) 'a', (gunichar) 'd');
	_tmp8_ = gr;
	bird_font_glyph_range_add_range (_tmp8_, (gunichar) 'f', (gunichar) 'z');
	_tmp9_ = gr;
	bird_font_glyph_range_add_range (_tmp9_, (gunichar) 'b', (gunichar) 'd');
	_tmp10_ = gr;
	bird_font_glyph_range_print_all (_tmp10_);
	_tmp11_ = gr;
	g_return_if_fail (bird_font_glyph_range_length (_tmp11_) == ((guint32) (('z' - 'a') + 1)));
	_tmp12_ = gr;
	_tmp13_ = bird_font_glyph_range_get_ranges (_tmp12_);
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	g_return_if_fail (_tmp15_ == 1);
	_tmp16_ = gr;
	_tmp17_ = bird_font_glyph_range_get_ranges (_tmp16_);
	_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, 0);
	_tmp19_ = (BirdFontUniRange*) _tmp18_;
	g_return_if_fail (bird_font_uni_range_length (_tmp19_) == ((gunichar) (('z' - 'a') + 1)));
	_g_object_unref0 (_tmp19_);
	{
		gunichar i = 0U;
		i = (gunichar) 'a';
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				guint index = 0U;
				gchar* c = NULL;
				BirdFontGlyphRange* _tmp22_;
				gchar* _tmp23_;
				GString* s = NULL;
				GString* _tmp24_;
				GString* _tmp25_;
				const gchar* _tmp26_;
				GString* _tmp27_;
				const gchar* _tmp28_;
				if (!_tmp20_) {
					gunichar _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				if (!(i <= ((gunichar) 'z'))) {
					break;
				}
				index = (guint) (i - 'a');
				_tmp22_ = gr;
				_tmp23_ = bird_font_glyph_range_get_char (_tmp22_, (guint32) index);
				c = _tmp23_;
				_tmp24_ = g_string_new ("");
				s = _tmp24_;
				_tmp25_ = s;
				g_string_append_unichar (_tmp25_, i);
				_tmp26_ = c;
				_tmp27_ = s;
				_tmp28_ = _tmp27_->str;
				if (g_strcmp0 (_tmp26_, _tmp28_) != 0) {
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					GString* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp29_ = c;
					_tmp30_ = string_to_string (_tmp29_);
					_tmp31_ = s;
					_tmp32_ = _tmp31_->str;
					_tmp33_ = string_to_string (_tmp32_);
					_tmp34_ = g_strdup_printf ("%u", index);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_strconcat ("wrong glyph in glyph range got \"", _tmp30_, "\" expected \"", _tmp33_, "\" for index ", _tmp35_, ".", NULL);
					_tmp37_ = _tmp36_;
					g_warning ("TestCases.vala:808: %s", _tmp37_);
					_g_free0 (_tmp37_);
					_g_free0 (_tmp35_);
				}
				_g_string_free0 (s);
				_g_free0 (c);
			}
		}
	}
	_tmp38_ = bird_font_glyph_range_new ();
	_bird_font_glyph_range_unref0 (gr);
	gr = _tmp38_;
	_tmp39_ = gr;
	bird_font_glyph_range_add_single (_tmp39_, (gunichar) 'a');
	_tmp40_ = gr;
	bird_font_glyph_range_add_range (_tmp40_, (gunichar) 'c', (gunichar) 'e');
	_tmp41_ = gr;
	bird_font_glyph_range_add_single (_tmp41_, 9674U);
	_tmp42_ = gr;
	_tmp43_ = bird_font_glyph_range_get_char (_tmp42_, (guint32) 0);
	_tmp44_ = _tmp43_;
	g_return_if_fail (g_strcmp0 (_tmp44_, "a") == 0);
	_g_free0 (_tmp44_);
	_tmp45_ = gr;
	_tmp46_ = bird_font_glyph_range_get_char (_tmp45_, (guint32) 1);
	_tmp47_ = _tmp46_;
	g_return_if_fail (g_strcmp0 (_tmp47_, "c") == 0);
	_g_free0 (_tmp47_);
	_tmp48_ = gr;
	_tmp49_ = bird_font_glyph_range_get_char (_tmp48_, (guint32) 2);
	_tmp50_ = _tmp49_;
	g_return_if_fail (g_strcmp0 (_tmp50_, "d") == 0);
	_g_free0 (_tmp50_);
	_tmp51_ = gr;
	_tmp52_ = bird_font_glyph_range_get_char (_tmp51_, (guint32) 3);
	_tmp53_ = _tmp52_;
	g_return_if_fail (g_strcmp0 (_tmp53_, "e") == 0);
	_g_free0 (_tmp53_);
	_tmp54_ = gr;
	_tmp55_ = bird_font_glyph_range_get_char (_tmp54_, (guint32) 4);
	_tmp56_ = _tmp55_;
	g_return_if_fail (g_strcmp0 (_tmp56_, "◊") == 0);
	_g_free0 (_tmp56_);
	_tmp57_ = gr_az;
	bird_font_glyph_range_add_range (_tmp57_, (gunichar) 'a', (gunichar) 'z');
	_tmp58_ = gr_az;
	if (!bird_font_glyph_range_has_character (_tmp58_, "g")) {
		g_warning ("TestCases.vala:825: Can not g in range a-z ");
	}
	_tmp59_ = gr_az;
	if (bird_font_glyph_range_has_character (_tmp59_, "å")) {
		g_warning ("TestCases.vala:829: Range a-z has å");
	}
	{
		BirdFontGlyphRange* _tmp60_;
		BirdFontGlyphRange* _tmp61_;
		BirdFontGlyphRange* _tmp62_;
		BirdFontGlyphRange* _tmp63_;
		BirdFontGlyphRange* _tmp64_;
		_tmp60_ = bird_font_glyph_range_new ();
		_bird_font_glyph_range_unref0 (gr);
		gr = _tmp60_;
		_tmp61_ = gr;
		bird_font_glyph_range_parse_ranges (_tmp61_, "- Ç ü-ý é á-â ä Ů-ű ç Ł-ń ë Ő-ő í-î Ä É Ĺ-ĺ ó-ô ö-÷ Ľ-ľ Ö-× Ü-Ý ú Ź-" \
"ž Ę-ě «-­ » ░-▓ │ ┤ Á-Â ╣ ═-║ ╗ ╝ ┐ └ ┴ ┬ ├ ─ ┼ Ă-ć ╚ ╔ ╩ ╦ ╠ ╬ ¤ Č-đ " \
"Ë Ň-ň Í-Î ┘ ┌ █ ▄ Ş-ť ▀ Ó-Ô ß Ŕ-ŕ Ú ´ ˝ ˛ ˇ ˘-˙ §-¨ ¸ ° Ř-ś ■  ", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			_bird_font_glyph_range_unref0 (gr_az);
			_bird_font_glyph_range_unref0 (gr);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp62_ = gr;
		if (!bird_font_glyph_range_has_character (_tmp62_, "Ă")) {
			g_warning ("TestCases.vala:837: Latin 2 range does not have Ă");
		}
		_tmp63_ = gr;
		if (!bird_font_glyph_range_has_unichar (_tmp63_, 258U)) {
			g_warning ("TestCases.vala:841: Latin 2 range  does not have Ă");
		}
		_tmp64_ = gr;
		if (!bird_font_glyph_range_has_unichar (_tmp64_, 243U)) {
			g_warning ("TestCases.vala:845: Latin 2 range  does not have ó");
		}
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp65_;
		const gchar* _tmp66_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp65_ = e;
		_tmp66_ = _tmp65_->message;
		g_warning ("TestCases.vala:848: %s", _tmp66_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_bird_font_glyph_range_unref0 (gr_az);
		_bird_font_glyph_range_unref0 (gr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_bird_font_glyph_range_unref0 (gr_az);
	_bird_font_glyph_range_unref0 (gr);
}

void
bird_font_test_cases_test_hex (void)
{
	bird_font_test_cases_test_hex_conv ((gunichar) 'H', "U+48", 72);
	bird_font_test_cases_test_hex_conv ((gunichar) '1', "U+31", 49);
	bird_font_test_cases_test_hex_conv (229U, "U+e5", 229);
	bird_font_test_cases_test_hex_conv (9674U, "U+25ca", 9674);
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
bird_font_test_cases_test_hex_conv (gunichar h,
                                    const gchar* sr,
                                    gint r)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gunichar t = 0U;
	const gchar* _tmp1_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (sr != NULL);
	_tmp0_ = bird_font_font_to_hex (h);
	s = _tmp0_;
	t = bird_font_font_to_unichar (sr);
	_tmp1_ = s;
	if (g_strcmp0 (_tmp1_, sr) != 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = s;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = string_to_string (sr);
		_tmp5_ = g_strconcat ("(", _tmp3_, " != \"", _tmp4_, "\")", NULL);
		_tmp6_ = _tmp5_;
		g_warning ("TestCases.vala:863: %s", _tmp6_);
		_g_free0 (_tmp6_);
	}
	if (((gint) t) != r) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = t != h;
	}
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp8_ = g_strdup_printf ("%i", (gint) t);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%i", r);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_unichar_to_string (t);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_unichar_to_string (h);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp9_, " != ", _tmp11_, " || ", _tmp13_, " != '", _tmp15_, "'", NULL);
		_tmp17_ = _tmp16_;
		g_warning ("TestCases.vala:864: %s", _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	_g_free0 (s);
}

/** Draw a test glyph. */
void
bird_font_test_cases_test_drawing (void)
{
	BirdFontTool* pen_tool = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontTool* _tmp2_;
	BirdFontTool* _tmp3_;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_toolbox_get_tool (_tmp1_, "pen_tool");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	pen_tool = _tmp3_;
	bird_font_test_cases_test_select_action (pen_tool);
	bird_font_test_cases_test_open_next_glyph ();
	bird_font_test_cases_test_click_action (pen_tool, 1, 30, 30);
	bird_font_test_cases_test_click_action (pen_tool, 1, 60, 30);
	bird_font_test_cases_test_click_action (pen_tool, 1, 60, 60);
	bird_font_test_cases_test_click_action (pen_tool, 1, 30, 60);
	bird_font_test_cases_test_click_action (pen_tool, 3, 0, 0);
	bird_font_test_cases_test_click_action (pen_tool, 3, 35, 35);
	bird_font_test_cases_test_move_action (pen_tool, 100, 200);
	bird_font_test_cases_test_move_action (pen_tool, 20, 300);
	bird_font_test_cases_test_move_action (pen_tool, 0, 0);
	bird_font_test_cases_test_move_action (pen_tool, 70, 50);
	bird_font_test_cases_test_click_action (pen_tool, 1, 70, 50);
	bird_font_test_cases_test_click_action (pen_tool, 1, 70, 50);
	bird_font_test_cases_test_click_action (pen_tool, 1, 70, 100);
	bird_font_test_cases_test_click_action (pen_tool, 1, 50, 100);
	bird_font_test_cases_test_click_action (pen_tool, 1, 50, 50);
	bird_font_test_cases_test_click_action (pen_tool, 3, 0, 0);
	bird_font_tool_yield ();
	_g_object_unref0 (pen_tool);
}

/** Test path coordinates and reverse path coordinates. */
static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
bird_font_test_cases_test_coordinates (void)
{
	gint x = 0;
	gint y = 0;
	gint xc = 0;
	gint yc = 0;
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble mx = 0.0;
	gdouble my = 0.0;
	gchar* n = NULL;
	BirdFontTool* pen_tool = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontTool* _tmp2_;
	BirdFontTool* _tmp3_;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp4_;
	BirdFontGlyph* _tmp5_;
	BirdFontWidgetAllocation* _tmp6_;
	BirdFontGlyph* _tmp7_;
	BirdFontWidgetAllocation* _tmp8_;
	BirdFontGlyph* _tmp9_;
	BirdFontGlyph* _tmp10_;
	BirdFontGlyph* _tmp11_;
	gboolean _tmp12_ = FALSE;
	BirdFontTool* _tmp23_;
	gchar* _tmp24_;
	BirdFontGlyph* _tmp25_;
	BirdFontTool* _tmp26_;
	BirdFontTool* _tmp27_;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_toolbox_get_tool (_tmp1_, "pen_tool");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	pen_tool = _tmp3_;
	bird_font_test_cases_test_open_next_glyph ();
	_tmp4_ = bird_font_main_window_get_current_glyph ();
	g = _tmp4_;
	_tmp5_ = g;
	_tmp6_ = _tmp5_->allocation;
	xc = (gint) (_tmp6_->width / 2.0);
	_tmp7_ = g;
	_tmp8_ = _tmp7_->allocation;
	yc = (gint) (_tmp8_->height / 2.0);
	_tmp9_ = g;
	bird_font_glyph_default_zoom (_tmp9_);
	x = 10;
	y = 15;
	px = bird_font_glyph_path_coordinate_x ((gdouble) x);
	py = bird_font_glyph_path_coordinate_y ((gdouble) y);
	_tmp10_ = g;
	mx = ((x * bird_font_glyph_ivz ()) - bird_font_glyph_xc ()) + _tmp10_->view_offset_x;
	_tmp11_ = g;
	my = (bird_font_glyph_yc () - (y * bird_font_glyph_ivz ())) - _tmp11_->view_offset_y;
	if (mx != px) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = my != py;
	}
	if (_tmp12_) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp13_ = double_to_string (mx);
		_tmp14_ = _tmp13_;
		_tmp15_ = double_to_string (px);
		_tmp16_ = _tmp15_;
		_tmp17_ = double_to_string (my);
		_tmp18_ = _tmp17_;
		_tmp19_ = double_to_string (py);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat ("bad coordinate ", _tmp14_, " != ", _tmp16_, " || ", _tmp18_, " != ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		g_warning ("TestCases.vala:932: %s", _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
	}
	bird_font_test_cases_test_reverse_coordinate (x, y, px, py, "ten fifteen");
	_tmp23_ = pen_tool;
	bird_font_test_cases_test_click_action (_tmp23_, 1, x, y);
	_tmp24_ = g_strdup ("Offset no zoom");
	_g_free0 (n);
	n = _tmp24_;
	_tmp25_ = g;
	bird_font_font_display_reset_zoom ((BirdFontFontDisplay*) _tmp25_);
	px = bird_font_glyph_path_coordinate_x ((gdouble) x);
	py = bird_font_glyph_path_coordinate_y ((gdouble) y);
	bird_font_test_cases_test_reverse_coordinate (x, y, px, py, n);
	_tmp26_ = pen_tool;
	bird_font_test_cases_test_click_action (_tmp26_, 1, x, y);
	_tmp27_ = pen_tool;
	bird_font_test_cases_test_click_action (_tmp27_, 3, x, y);
	_g_object_unref0 (g);
	_g_object_unref0 (pen_tool);
	_g_free0 (n);
}

static void
bird_font_test_cases_test_reverse_coordinate (gint x,
                                              gint y,
                                              gdouble px,
                                              gdouble py,
                                              const gchar* n)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (n != NULL);
	if (x != bird_font_glyph_reverse_path_coordinate_x (px)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = bird_font_glyph_reverse_path_coordinate_y (py) != y;
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp1_ = string_to_string (n);
		_tmp2_ = g_strdup_printf ("%i", x);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("%i", bird_font_glyph_reverse_path_coordinate_x (px));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%i", bird_font_glyph_reverse_path_coordinate_y (py));
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%i", y);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Reverse coordinates does not match current point for test case \"", _tmp1_, "\".\n ", _tmp3_, " != ", _tmp5_, " || ", _tmp7_, " != ", _tmp9_, " (x != Glyph.reverse_path_coordinate_x (px) || Glyph.reverse_path_coor" \
"dinate_y (py) != y)", NULL);
		_tmp11_ = _tmp10_;
		g_warning ("TestCases.vala:954: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
}

static void
bird_font_test_cases_test_last_is_clockwise (const gchar* name)
{
	gboolean d = FALSE;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontPath* _tmp2_;
	BirdFontPath* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_glyph_get_last_path (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_PATH, BirdFontPath);
	_tmp4_ = bird_font_path_is_clockwise (_tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	d = _tmp4_;
	if (!d) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = string_to_string (name);
		_tmp6_ = g_strconcat ("\nPath ", _tmp5_, " is counter clockwise, in test_last_is_clockwise", NULL);
		_tmp7_ = _tmp6_;
		g_critical ("TestCases.vala:962: %s", _tmp7_);
		_g_free0 (_tmp7_);
	}
}

static gboolean
bird_font_test_cases_test_reverse_last (const gchar* name)
{
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontPath* _tmp2_;
	BirdFontPath* _tmp3_;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp4_;
	BirdFontGlyph* _tmp5_;
	BirdFontPath* p = NULL;
	BirdFontGlyph* _tmp6_;
	BirdFontPath* _tmp7_;
	gboolean direction = FALSE;
	BirdFontPath* _tmp8_;
	BirdFontPath* _tmp9_;
	BirdFontPath* _tmp10_;
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_glyph_get_last_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_vala_return_val_if_fail (_tmp3_ != NULL, "MainWindow.get_current_glyph ().get_last_path () != null", FALSE);
	_tmp4_ = bird_font_main_window_get_current_glyph ();
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	g = _tmp5_;
	_tmp6_ = g;
	_tmp7_ = bird_font_glyph_get_last_path (_tmp6_);
	p = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, BIRD_FONT_TYPE_PATH, BirdFontPath);
	_tmp8_ = p;
	direction = bird_font_path_is_clockwise (_tmp8_);
	_tmp9_ = p;
	bird_font_path_reverse (_tmp9_);
	_tmp10_ = p;
	if (direction == bird_font_path_is_clockwise (_tmp10_)) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		FILE* _tmp14_;
		BirdFontPath* _tmp15_;
		GeeArrayList* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp11_ = string_to_string (name);
		_tmp12_ = g_strconcat ("Direction did not change after reverseing path \"", _tmp11_, "\"\n", NULL);
		_tmp13_ = _tmp12_;
		g_critical ("TestCases.vala:977: %s", _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = stderr;
		_tmp15_ = p;
		_tmp16_ = bird_font_path_get_points (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat ("Path length: ", _tmp21_, " \n", NULL);
		_tmp23_ = _tmp22_;
		fprintf (_tmp14_, "%s", _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		result = FALSE;
		_g_object_unref0 (p);
		_g_object_unref0 (g);
		return result;
	}
	bird_font_tool_yield ();
	result = TRUE;
	_g_object_unref0 (p);
	_g_object_unref0 (g);
	return result;
}

static BirdFontTestCasesPoint*
bird_font_test_cases_p (gint x,
                        gint y)
{
	BirdFontTestCasesPoint* _tmp0_;
	BirdFontTestCasesPoint* result;
	_tmp0_ = bird_font_test_cases_point_new (x, y);
	result = _tmp0_;
	return result;
}

static void
bird_font_test_cases_test_triangle (BirdFontTestCasesPoint* a,
                                    BirdFontTestCasesPoint* b,
                                    BirdFontTestCasesPoint* c,
                                    const gchar* name)
{
	BirdFontTool* pen_tool = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontTool* _tmp2_;
	BirdFontTool* _tmp3_;
	BirdFontTabBar* _tmp4_;
	BirdFontTabBar* _tmp5_;
	BirdFontOverview* _tmp6_;
	BirdFontOverview* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_toolbox_get_tool (_tmp1_, "pen_tool");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	pen_tool = _tmp3_;
	bird_font_tool_yield ();
	_tmp4_ = bird_font_main_window_get_tab_bar ();
	_tmp5_ = _tmp4_;
	bird_font_tab_bar_select_overview (_tmp5_);
	_g_object_unref0 (_tmp5_);
	bird_font_tool_yield ();
	_tmp6_ = bird_font_main_window_get_overview ();
	_tmp7_ = _tmp6_;
	bird_font_overview_open_current_glyph (_tmp7_);
	_g_object_unref0 (_tmp7_);
	bird_font_test_cases_test_select_action (pen_tool);
	bird_font_test_cases_test_click_action (pen_tool, 3, a->x, a->y);
	bird_font_test_cases_test_click_action (pen_tool, 3, b->x, b->y);
	bird_font_test_cases_test_click_action (pen_tool, 3, c->x, c->y);
	_tmp8_ = string_to_string (name);
	_tmp9_ = g_strdup_printf ("%i", a->x);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%i", a->y);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%i", b->x);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("%i", b->y);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup_printf ("%i", c->x);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("%i", c->y);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat ("Triangle reverse \"", _tmp8_, "\" (", _tmp10_, ", ", _tmp12_, "), (", _tmp14_, ", ", _tmp16_, "), (", _tmp18_, ", ", _tmp20_, ") failed.", NULL);
	_tmp22_ = _tmp21_;
	bird_font_test_cases_test_reverse_last (_tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	bird_font_tool_yield ();
	_g_object_unref0 (pen_tool);
}

static void
bird_font_test_cases_test_various_triangles (void)
{
	BirdFontTestCasesPoint* _tmp0_;
	BirdFontTestCasesPoint* _tmp1_;
	BirdFontTestCasesPoint* _tmp2_;
	BirdFontTestCasesPoint* _tmp3_;
	BirdFontTestCasesPoint* _tmp4_;
	BirdFontTestCasesPoint* _tmp5_;
	BirdFontTestCasesPoint* _tmp6_;
	BirdFontTestCasesPoint* _tmp7_;
	BirdFontTestCasesPoint* _tmp8_;
	BirdFontTestCasesPoint* _tmp9_;
	BirdFontTestCasesPoint* _tmp10_;
	BirdFontTestCasesPoint* _tmp11_;
	BirdFontTestCasesPoint* _tmp12_;
	BirdFontTestCasesPoint* _tmp13_;
	BirdFontTestCasesPoint* _tmp14_;
	BirdFontTestCasesPoint* _tmp15_;
	BirdFontTestCasesPoint* _tmp16_;
	BirdFontTestCasesPoint* _tmp17_;
	BirdFontTestCasesPoint* _tmp18_;
	BirdFontTestCasesPoint* _tmp19_;
	BirdFontTestCasesPoint* _tmp20_;
	BirdFontTestCasesPoint* _tmp21_;
	BirdFontTestCasesPoint* _tmp22_;
	BirdFontTestCasesPoint* _tmp23_;
	_tmp0_ = bird_font_test_cases_p (287, 261);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_test_cases_p (155, 81);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_test_cases_p (200, 104);
	_tmp5_ = _tmp4_;
	bird_font_test_cases_test_triangle (_tmp1_, _tmp3_, _tmp5_, "First");
	_bird_font_test_cases_point_unref0 (_tmp5_);
	_bird_font_test_cases_point_unref0 (_tmp3_);
	_bird_font_test_cases_point_unref0 (_tmp1_);
	_tmp6_ = bird_font_test_cases_p (65, 100);
	_tmp7_ = _tmp6_;
	_tmp8_ = bird_font_test_cases_p (168, 100);
	_tmp9_ = _tmp8_;
	_tmp10_ = bird_font_test_cases_p (196, 177);
	_tmp11_ = _tmp10_;
	bird_font_test_cases_test_triangle (_tmp7_, _tmp9_, _tmp11_, "Second");
	_bird_font_test_cases_point_unref0 (_tmp11_);
	_bird_font_test_cases_point_unref0 (_tmp9_);
	_bird_font_test_cases_point_unref0 (_tmp7_);
	_tmp12_ = bird_font_test_cases_p (132, 68);
	_tmp13_ = _tmp12_;
	_tmp14_ = bird_font_test_cases_p (195, 283);
	_tmp15_ = _tmp14_;
	_tmp16_ = bird_font_test_cases_p (195, 222);
	_tmp17_ = _tmp16_;
	bird_font_test_cases_test_triangle (_tmp13_, _tmp15_, _tmp17_, "Third");
	_bird_font_test_cases_point_unref0 (_tmp17_);
	_bird_font_test_cases_point_unref0 (_tmp15_);
	_bird_font_test_cases_point_unref0 (_tmp13_);
	_tmp18_ = bird_font_test_cases_p (144, 267);
	_tmp19_ = _tmp18_;
	_tmp20_ = bird_font_test_cases_p (147, 27);
	_tmp21_ = _tmp20_;
	_tmp22_ = bird_font_test_cases_p (296, 267);
	_tmp23_ = _tmp22_;
	bird_font_test_cases_test_triangle (_tmp19_, _tmp21_, _tmp23_, "Fourth");
	_bird_font_test_cases_point_unref0 (_tmp23_);
	_bird_font_test_cases_point_unref0 (_tmp21_);
	_bird_font_test_cases_point_unref0 (_tmp19_);
}

void
bird_font_test_cases_test_reverse_path (void)
{
	BirdFontTool* pen_tool = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontTool* _tmp2_;
	BirdFontTool* _tmp3_;
	BirdFontTabBar* _tmp4_;
	BirdFontTabBar* _tmp5_;
	BirdFontOverview* _tmp6_;
	BirdFontOverview* _tmp7_;
	gint x_offset = 0;
	gint y_offset = 0;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_toolbox_get_tool (_tmp1_, "pen_tool");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	pen_tool = _tmp3_;
	bird_font_tool_yield ();
	_tmp4_ = bird_font_main_window_get_tab_bar ();
	_tmp5_ = _tmp4_;
	bird_font_tab_bar_select_overview (_tmp5_);
	_g_object_unref0 (_tmp5_);
	bird_font_tool_yield ();
	_tmp6_ = bird_font_main_window_get_overview ();
	_tmp7_ = _tmp6_;
	bird_font_overview_open_current_glyph (_tmp7_);
	_g_object_unref0 (_tmp7_);
	bird_font_test_cases_test_select_action (pen_tool);
	x_offset = 10;
	y_offset = 10;
	bird_font_test_cases_test_open_next_glyph ();
	bird_font_test_cases_test_various_triangles ();
	bird_font_test_cases_test_open_next_glyph ();
	y_offset += 160;
	bird_font_test_cases_test_click_action (pen_tool, 3, 10 + x_offset, 20 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 3, 17 + x_offset, 17 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 3, 20 + x_offset, 0 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 2, 0, 0);
	bird_font_test_cases_test_last_is_clockwise ("Clockwise triangle 1.2");
	bird_font_test_cases_test_click_action (pen_tool, 3, 115, 137);
	bird_font_test_cases_test_click_action (pen_tool, 3, 89, 74);
	bird_font_test_cases_test_click_action (pen_tool, 3, 188, 232);
	bird_font_test_cases_test_click_action (pen_tool, 2, 0, 0);
	bird_font_test_cases_test_reverse_last ("Triangle 0");
	y_offset += 20;
	bird_font_test_cases_test_click_action (pen_tool, 3, 10 + x_offset, 20 + y_offset);
	bird_font_test_cases_test_reverse_last ("Point");
	bird_font_test_cases_test_click_action (pen_tool, 2, 0, 0);
	y_offset += 20;
	bird_font_test_cases_test_click_action (pen_tool, 3, 10 + x_offset, 20 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 3, 10 + x_offset, 20 + y_offset);
	bird_font_test_cases_test_reverse_last ("Double point");
	bird_font_test_cases_test_click_action (pen_tool, 2, 0, 0);
	y_offset += 20;
	bird_font_test_cases_test_click_action (pen_tool, 3, 10 + x_offset, 30 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 3, 10 + x_offset, 20 + y_offset);
	bird_font_test_cases_test_reverse_last ("Vertical line");
	bird_font_test_cases_test_click_action (pen_tool, 2, 0, 0);
	y_offset += 20;
	bird_font_test_cases_test_click_action (pen_tool, 1, 30 + x_offset, 20 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 1, 10 + x_offset, 20 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 3, 0, 0);
	bird_font_test_cases_test_reverse_last ("Horisontal line");
	bird_font_test_cases_test_click_action (pen_tool, 2, 0, 0);
	y_offset += 20;
	bird_font_test_cases_test_click_action (pen_tool, 3, 10 + x_offset, -10 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 3, 20 + x_offset, 20 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 3, 30 + x_offset, 0 + y_offset);
	bird_font_test_cases_test_reverse_last ("Triangle reverse 1");
	bird_font_test_cases_test_click_action (pen_tool, 2, 0, 0);
	y_offset += 20;
	bird_font_test_cases_test_click_action (pen_tool, 3, 100 + x_offset, 150 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 3, 150 + x_offset, 150 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 3, 150 + x_offset, 100 + y_offset);
	bird_font_test_cases_test_click_action (pen_tool, 3, 100 + x_offset, 100 + y_offset);
	bird_font_test_cases_test_reverse_last ("Box 1");
	bird_font_test_cases_test_click_action (pen_tool, 2, 0, 0);
	_g_object_unref0 (pen_tool);
}

static BirdFontTool*
bird_font_test_cases_select_pen (void)
{
	BirdFontTool* pen_tool = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontTool* _tmp2_;
	BirdFontTool* _tmp3_;
	BirdFontTool* result;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_toolbox_get_tool (_tmp1_, "pen_tool");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	pen_tool = _tmp3_;
	bird_font_test_cases_test_select_action (pen_tool);
	result = pen_tool;
	return result;
}

void
bird_font_test_cases_test_delete_points (void)
{
	BirdFontPenTool* pen = NULL;
	BirdFontTool* _tmp0_;
	bird_font_test_cases_test_open_next_glyph ();
	_tmp0_ = bird_font_test_cases_select_pen ();
	_g_object_unref0 (pen);
	pen = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BIRD_FONT_TYPE_PEN_TOOL, BirdFontPenTool);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				BirdFontPenTool* _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i <= 10)) {
					break;
				}
				_tmp3_ = pen;
				bird_font_test_cases_test_click_action ((BirdFontTool*) _tmp3_, 3, 20 * i, 20);
			}
		}
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				BirdFontPenTool* _tmp6_;
				BirdFontPenTool* _tmp7_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i <= 10)) {
					break;
				}
				_tmp6_ = pen;
				bird_font_test_cases_test_move_action ((BirdFontTool*) _tmp6_, 20 * i, 20);
				_tmp7_ = pen;
				bird_font_test_cases_test_click_action ((BirdFontTool*) _tmp7_, 1, 20 * i, 20);
				bird_font_pen_tool_delete_selected_points ();
			}
		}
	}
	_g_object_unref0 (pen);
}

void
bird_font_test_cases_test_reverse_random_triangles (void)
{
	BirdFontTool* pen = NULL;
	gint ax = 0;
	gint bx = 0;
	gint cx = 0;
	gint ay = 0;
	gint by = 0;
	gint cy = 0;
	gboolean r = FALSE;
	BirdFontTool* _tmp0_;
	r = TRUE;
	bird_font_test_cases_test_open_next_glyph ();
	_tmp0_ = bird_font_test_cases_select_pen ();
	_g_object_unref0 (pen);
	pen = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				BirdFontTool* _tmp3_;
				BirdFontTool* _tmp4_;
				BirdFontTool* _tmp5_;
				BirdFontTool* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 30)) {
					break;
				}
				bird_font_tool_yield ();
				ax = (gint) g_random_int_range ((gint32) 0, (gint32) 300);
				bx = (gint) g_random_int_range ((gint32) 0, (gint32) 300);
				cx = (gint) g_random_int_range ((gint32) 0, (gint32) 300);
				ay = (gint) g_random_int_range ((gint32) 0, (gint32) 300);
				by = (gint) g_random_int_range ((gint32) 0, (gint32) 300);
				cy = (gint) g_random_int_range ((gint32) 0, (gint32) 300);
				_tmp3_ = pen;
				bird_font_test_cases_test_click_action (_tmp3_, 3, ax, ay);
				_tmp4_ = pen;
				bird_font_test_cases_test_click_action (_tmp4_, 3, bx, by);
				_tmp5_ = pen;
				bird_font_test_cases_test_click_action (_tmp5_, 3, cx, cy);
				_tmp6_ = pen;
				bird_font_test_cases_test_click_action (_tmp6_, 2, 0, 0);
				_tmp7_ = g_strdup_printf ("%i", i + 1);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strdup_printf ("%i", ax);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup_printf ("%i", ay);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strdup_printf ("%i", bx);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strdup_printf ("%i", by);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strdup_printf ("%i", cx);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strdup_printf ("%i", cy);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat ("Random triangle № ", _tmp8_, " (", _tmp10_, ", ", _tmp12_, "), (", _tmp14_, ", ", _tmp16_, "), (", _tmp18_, ", ", _tmp20_, ")", NULL);
				_tmp22_ = _tmp21_;
				r = bird_font_test_cases_test_reverse_last (_tmp22_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
				_g_free0 (_tmp8_);
				if (!r) {
					BirdFontTool* _tmp23_;
					BirdFontTool* _tmp24_;
					BirdFontTool* _tmp25_;
					BirdFontTool* _tmp26_;
					BirdFontTool* _tmp27_;
					bird_font_test_cases_test_open_next_glyph ();
					_tmp23_ = bird_font_test_cases_select_pen ();
					_g_object_unref0 (pen);
					pen = _tmp23_;
					_tmp24_ = pen;
					bird_font_test_cases_test_click_action (_tmp24_, 3, ax, ay);
					_tmp25_ = pen;
					bird_font_test_cases_test_click_action (_tmp25_, 3, bx, by);
					_tmp26_ = pen;
					bird_font_test_cases_test_click_action (_tmp26_, 3, cx, cy);
					_tmp27_ = pen;
					bird_font_test_cases_test_click_action (_tmp27_, 2, 0, 0);
					_g_object_unref0 (pen);
					return;
				}
				bird_font_test_cases_test_open_next_glyph ();
			}
		}
	}
	if (r) {
		bird_font_test_cases_test_open_next_glyph ();
	}
	_g_object_unref0 (pen);
}

/** Help function to test button press actions. */
void
bird_font_test_cases_test_click_action (BirdFontTool* t,
                                        gint b,
                                        gint x,
                                        gint y)
{
	g_return_if_fail (t != NULL);
	bird_font_tool_yield ();
	g_signal_emit_by_name (t, "press-action", t, b, x, y);
	bird_font_tool_yield ();
	g_signal_emit_by_name (t, "release-action", t, b, x, y);
}

/** Help function to test select action for this tool. */
void
bird_font_test_cases_test_select_action (BirdFontTool* t)
{
	BirdFontToolbox* tb = NULL;
	BirdFontToolbox* _tmp0_;
	g_return_if_fail (t != NULL);
	_tmp0_ = bird_font_main_window_get_toolbox ();
	tb = _tmp0_;
	bird_font_tool_yield ();
	bird_font_toolbox_select_tool (tb, t);
	_g_object_unref0 (tb);
}

void
bird_font_test_cases_test_move_action (BirdFontTool* t,
                                       gint x,
                                       gint y)
{
	g_return_if_fail (t != NULL);
	bird_font_tool_yield ();
	g_signal_emit_by_name (t, "move-action", t, x, y);
}

void
bird_font_test_cases_test_open_next_glyph (void)
{
	BirdFontOverview* o = NULL;
	BirdFontOverview* _tmp0_;
	BirdFontTabBar* _tmp1_;
	BirdFontTabBar* _tmp2_;
	_tmp0_ = bird_font_main_window_get_overview ();
	o = _tmp0_;
	_tmp1_ = bird_font_main_window_get_tab_bar ();
	_tmp2_ = _tmp1_;
	bird_font_tab_bar_select_overview (_tmp2_);
	_g_object_unref0 (_tmp2_);
	bird_font_toolbox_select_tool_by_name ("utf_8");
	bird_font_tool_yield ();
	bird_font_overview_select_next_glyph (o);
	bird_font_tool_yield ();
	bird_font_overview_open_current_glyph (o);
	bird_font_tool_yield ();
	_g_object_unref0 (o);
}

static void
bird_font_test_cases_test_boundaries (void)
{
	bird_font_preferences_draw_boundaries = TRUE;
}

static Block67Data*
block67_data_ref (Block67Data* _data67_)
{
	g_atomic_int_inc (&_data67_->_ref_count_);
	return _data67_;
}

static void
block67_data_unref (void * _userdata_)
{
	Block67Data* _data67_;
	_data67_ = (Block67Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data67_->_ref_count_)) {
		_g_object_unref0 (_data67_->path);
		g_slice_free (Block67Data, _data67_);
	}
}

static gboolean
____lambda219_ (Block67Data* _data67_,
                gdouble cx,
                gdouble cy,
                gdouble ct)
{
	BirdFontPath* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	gboolean result;
	_tmp0_ = _data67_->path;
	_tmp1_ = bird_font_path_add (_tmp0_, cx, cy);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	result = TRUE;
	return result;
}

static gboolean
_____lambda219__bird_font_path_raster_iterator (gdouble x,
                                                gdouble y,
                                                gdouble step,
                                                gpointer self)
{
	gboolean result;
	result = ____lambda219_ (self, x, y, step);
	return result;
}

static void
bird_font_test_cases_test_raster_path (void)
{
	Block67Data* _data67_;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontPathList* pl = NULL;
	BirdFontPathList* _tmp1_;
	_data67_ = g_slice_new0 (Block67Data);
	_data67_->_ref_count_ = 1;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	pl = _tmp1_;
	bird_font_test_cases_test_open_next_glyph ();
	bird_font_test_cases_test_inkscape_import ();
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _p_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp2_ = g;
		_tmp3_ = bird_font_glyph_get_all_paths (_tmp2_);
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontPath* _tmp11_;
			BirdFontPath* _tmp12_;
			BirdFontPathList* _tmp13_;
			BirdFontPath* _tmp14_;
			_p_index = _p_index + 1;
			_tmp7_ = _p_index;
			_tmp8_ = _p_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _p_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _p_index);
			p = (BirdFontPath*) _tmp10_;
			_tmp11_ = bird_font_path_new ();
			_g_object_unref0 (_data67_->path);
			_data67_->path = _tmp11_;
			_tmp12_ = p;
			bird_font_path_all_of_path (_tmp12_, _____lambda219__bird_font_path_raster_iterator, _data67_, -1);
			_tmp13_ = pl;
			_tmp14_ = _data67_->path;
			bird_font_path_list_add (_tmp13_, _tmp14_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	bird_font_test_cases_test_open_next_glyph ();
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp15_;
		GeeArrayList* _tmp16_;
		gint _p_size = 0;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _p_index = 0;
		_tmp15_ = pl;
		_tmp16_ = _tmp15_->paths;
		_p_list = _tmp16_;
		_tmp17_ = _p_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_p_size = _tmp19_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp22_;
			gpointer _tmp23_;
			BirdFontGlyph* _tmp24_;
			BirdFontPath* _tmp25_;
			_p_index = _p_index + 1;
			_tmp20_ = _p_index;
			_tmp21_ = _p_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _p_list;
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _p_index);
			p = (BirdFontPath*) _tmp23_;
			_tmp24_ = g;
			_tmp25_ = p;
			bird_font_glyph_add_path (_tmp24_, _tmp25_);
			_g_object_unref0 (p);
		}
	}
	_g_object_unref0 (pl);
	_g_object_unref0 (g);
	block67_data_unref (_data67_);
	_data67_ = NULL;
}

static void
bird_font_test_cases_test_file_path (void)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	GFile* file = NULL;
	gchar* folder = NULL;
	BirdFontFont* _tmp1_;
	gchar* _tmp2_;
	BirdFontFont* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	BirdFontFont* _tmp10_;
	gchar* _tmp11_;
	BirdFontFont* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	BirdFontFont* _tmp19_;
	gchar* _tmp20_;
	GFile* _tmp21_;
	BirdFontFont* _tmp22_;
	gchar* _tmp23_;
	GFile* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gboolean _tmp28_;
	BirdFontFont* _tmp33_;
	gchar* _tmp34_;
	BirdFontFont* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	_tmp0_ = bird_font_font_new ();
	f = _tmp0_;
	_tmp1_ = f;
	_tmp2_ = g_strdup ("E:\\Typeface.bf");
	_g_free0 (_tmp1_->font_file);
	_tmp1_->font_file = _tmp2_;
	_tmp3_ = f;
	_tmp4_ = bird_font_font_get_folder_path (_tmp3_);
	_g_free0 (folder);
	folder = _tmp4_;
	_tmp5_ = folder;
	if (g_strcmp0 (_tmp5_, "E:") != 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = folder;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("Wrong folder, ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		g_warning ("TestCases.vala:1254: %s", _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = f;
	_tmp11_ = g_strdup ("/home/user/Typeface.bf");
	_g_free0 (_tmp10_->font_file);
	_tmp10_->font_file = _tmp11_;
	_tmp12_ = f;
	_tmp13_ = bird_font_font_get_folder_path (_tmp12_);
	_g_free0 (folder);
	folder = _tmp13_;
	_tmp14_ = folder;
	if (g_strcmp0 (_tmp14_, "/home/user") != 0) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = folder;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = g_strconcat ("Wrong folder, ", _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		g_warning ("TestCases.vala:1260: %s", _tmp18_);
		_g_free0 (_tmp18_);
	}
	_tmp19_ = f;
	_tmp20_ = g_strdup ("./Typeface.bf");
	_g_free0 (_tmp19_->font_file);
	_tmp19_->font_file = _tmp20_;
	_tmp21_ = g_file_new_for_path (".");
	_g_object_unref0 (file);
	file = _tmp21_;
	_tmp22_ = f;
	_tmp23_ = bird_font_font_get_folder_path (_tmp22_);
	_g_free0 (folder);
	folder = _tmp23_;
	_tmp24_ = file;
	_tmp25_ = g_file_get_path (_tmp24_);
	_tmp26_ = (gchar*) _tmp25_;
	_tmp27_ = folder;
	_tmp28_ = g_strcmp0 (_tmp26_, _tmp27_) != 0;
	_g_free0 (_tmp26_);
	if (_tmp28_) {
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp29_ = folder;
		_tmp30_ = string_to_string (_tmp29_);
		_tmp31_ = g_strconcat ("Wrong folder, ", _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		g_warning ("TestCases.vala:1267: %s", _tmp32_);
		_g_free0 (_tmp32_);
	}
	_tmp33_ = f;
	_tmp34_ = g_strdup ("./Typeface.bf");
	_g_free0 (_tmp33_->font_file);
	_tmp33_->font_file = _tmp34_;
	_tmp35_ = f;
	_tmp36_ = bird_font_font_get_folder_path (_tmp35_);
	_g_free0 (folder);
	folder = _tmp36_;
	_tmp37_ = folder;
	if (!g_str_has_prefix (_tmp37_, "/")) {
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp38_ = folder;
		_tmp39_ = string_to_string (_tmp38_);
		_tmp40_ = g_strconcat ("Wrong folder, ", _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		g_warning ("TestCases.vala:1273: %s", _tmp41_);
		_g_free0 (_tmp41_);
	}
	_g_free0 (folder);
	_g_object_unref0 (file);
	_g_object_unref0 (f);
}

static void
bird_font_test_cases_test_xml (void)
{
	BTag* root = NULL;
	BXmlParser* parser = NULL;
	BXmlParser* _tmp0_;
	BXmlParser* _tmp1_;
	BTag* _tmp2_;
	BTag* _tmp3_;
	BXmlParser* _tmp4_;
	_tmp0_ = b_xml_parser_new ("<g><g><g></g><g><g></g></g></g></g>");
	_g_object_unref0 (parser);
	parser = _tmp0_;
	_tmp1_ = parser;
	_tmp2_ = b_xml_parser_get_root_tag (_tmp1_);
	_g_object_unref0 (root);
	root = _tmp2_;
	_tmp3_ = root;
	bird_font_test_cases_print_tags (_tmp3_);
	_tmp4_ = parser;
	if (b_xml_parser_validate (_tmp4_)) {
		BXmlParser* _tmp5_;
		BTag* _tmp6_;
		BTag* _tmp7_;
		_tmp5_ = parser;
		_tmp6_ = b_xml_parser_get_root_tag (_tmp5_);
		_g_object_unref0 (root);
		root = _tmp6_;
		_tmp7_ = root;
		bird_font_test_cases_print_tags (_tmp7_);
	} else {
		g_warning ("TestCases.vala:1290: Invalid XML code.");
	}
	_g_object_unref0 (parser);
	_g_object_unref0 (root);
}

static void
bird_font_test_cases_print_tags (BTag* tag)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (tag != NULL);
	_tmp0_ = b_tag_get_name (tag);
	_tmp1_ = _tmp0_;
	g_print ("%s", _tmp1_);
	_g_free0 (_tmp1_);
	g_print ("\n");
	bird_font_test_cases_print_attributes (tag);
	_tmp2_ = b_tag_get_content (tag);
	_tmp3_ = _tmp2_;
	g_print ("%s", _tmp3_);
	_g_free0 (_tmp3_);
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp4_;
		_tmp4_ = b_tag_iterator (tag);
		_t_it = _tmp4_;
		while (TRUE) {
			BTagIterator* _tmp5_;
			BTag* t = NULL;
			BTagIterator* _tmp6_;
			BTag* _tmp7_;
			BTag* _tmp8_;
			_tmp5_ = _t_it;
			if (!b_tag_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _t_it;
			_tmp7_ = b_tag_iterator_get (_tmp6_);
			t = _tmp7_;
			_tmp8_ = t;
			bird_font_test_cases_print_tags (_tmp8_);
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
}

static void
bird_font_test_cases_print_attributes (BTag* tag)
{
	BAttributes* attributes = NULL;
	BAttributes* _tmp0_;
	g_return_if_fail (tag != NULL);
	_tmp0_ = b_tag_get_attributes (tag);
	attributes = _tmp0_;
	{
		BAttributesIterator* _attribute_it = NULL;
		BAttributes* _tmp1_;
		BAttributesIterator* _tmp2_;
		_tmp1_ = attributes;
		_tmp2_ = b_attributes_iterator (_tmp1_);
		_attribute_it = _tmp2_;
		while (TRUE) {
			BAttributesIterator* _tmp3_;
			BAttribute* attribute = NULL;
			BAttributesIterator* _tmp4_;
			BAttribute* _tmp5_;
			BAttribute* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp3_ = _attribute_it;
			if (!b_attributes_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _attribute_it;
			_tmp5_ = b_attributes_iterator_get (_tmp4_);
			attribute = _tmp5_;
			g_print ("\t");
			_tmp6_ = attribute;
			_tmp7_ = b_attribute_get_name (_tmp6_);
			_tmp8_ = _tmp7_;
			g_print ("%s", _tmp8_);
			_g_free0 (_tmp8_);
			g_print ("\n");
			_g_object_unref0 (attribute);
		}
		_g_object_unref0 (_attribute_it);
	}
	_g_object_unref0 (attributes);
}

static BirdFontTestCasesPoint*
bird_font_test_cases_point_construct (GType object_type,
                                      gint x,
                                      gint y)
{
	BirdFontTestCasesPoint* self = NULL;
	self = (BirdFontTestCasesPoint*) g_type_create_instance (object_type);
	self->x = x;
	self->y = y;
	return self;
}

static BirdFontTestCasesPoint*
bird_font_test_cases_point_new (gint x,
                                gint y)
{
	return bird_font_test_cases_point_construct (BIRD_FONT_TEST_CASES_TYPE_POINT, x, y);
}

static void
bird_font_test_cases_value_point_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_test_cases_value_point_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_test_cases_point_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_test_cases_value_point_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_test_cases_point_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_test_cases_value_point_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_test_cases_value_point_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontTestCasesPoint * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_test_cases_point_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_test_cases_value_point_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	BirdFontTestCasesPoint ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_test_cases_point_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
bird_font_test_cases_param_spec_point (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	BirdFontTestCasesParamSpecPoint* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TEST_CASES_TYPE_POINT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
bird_font_test_cases_value_get_point (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TEST_CASES_TYPE_POINT), NULL);
	return value->data[0].v_pointer;
}

static void
bird_font_test_cases_value_set_point (GValue* value,
                                      gpointer v_object)
{
	BirdFontTestCasesPoint * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TEST_CASES_TYPE_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TEST_CASES_TYPE_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_test_cases_point_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_test_cases_point_unref (old);
	}
}

static void
bird_font_test_cases_value_take_point (GValue* value,
                                       gpointer v_object)
{
	BirdFontTestCasesPoint * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TEST_CASES_TYPE_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TEST_CASES_TYPE_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_test_cases_point_unref (old);
	}
}

static void
bird_font_test_cases_point_class_init (BirdFontTestCasesPointClass * klass,
                                       gpointer klass_data)
{
	bird_font_test_cases_point_parent_class = g_type_class_peek_parent (klass);
	((BirdFontTestCasesPointClass *) klass)->finalize = bird_font_test_cases_point_finalize;
}

static void
bird_font_test_cases_point_instance_init (BirdFontTestCasesPoint * self,
                                          gpointer klass)
{
	self->ref_count = 1;
}

static void
bird_font_test_cases_point_finalize (BirdFontTestCasesPoint * obj)
{
	BirdFontTestCasesPoint * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TEST_CASES_TYPE_POINT, BirdFontTestCasesPoint);
	g_signal_handlers_destroy (self);
}

static GType
bird_font_test_cases_point_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_test_cases_value_point_init, bird_font_test_cases_value_point_free_value, bird_font_test_cases_value_point_copy_value, bird_font_test_cases_value_point_peek_pointer, "p", bird_font_test_cases_value_point_collect_value, "p", bird_font_test_cases_value_point_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontTestCasesPointClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_test_cases_point_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTestCasesPoint), 0, (GInstanceInitFunc) bird_font_test_cases_point_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_test_cases_point_type_id;
	bird_font_test_cases_point_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontTestCasesPoint", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_test_cases_point_type_id;
}

static GType
bird_font_test_cases_point_get_type (void)
{
	static volatile gsize bird_font_test_cases_point_type_id__once = 0;
	if (g_once_init_enter (&bird_font_test_cases_point_type_id__once)) {
		GType bird_font_test_cases_point_type_id;
		bird_font_test_cases_point_type_id = bird_font_test_cases_point_get_type_once ();
		g_once_init_leave (&bird_font_test_cases_point_type_id__once, bird_font_test_cases_point_type_id);
	}
	return bird_font_test_cases_point_type_id__once;
}

static gpointer
bird_font_test_cases_point_ref (gpointer instance)
{
	BirdFontTestCasesPoint * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
bird_font_test_cases_point_unref (gpointer instance)
{
	BirdFontTestCasesPoint * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_TEST_CASES_POINT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
bird_font_value_test_cases_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_test_cases_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_test_cases_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_test_cases_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_test_cases_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_test_cases_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_test_cases_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontTestCases * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_test_cases_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_test_cases_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	BirdFontTestCases ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_test_cases_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_test_cases (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	BirdFontParamSpecTestCases* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_TEST_CASES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_test_cases (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_TEST_CASES), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_test_cases (GValue* value,
                                gpointer v_object)
{
	BirdFontTestCases * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_TEST_CASES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_TEST_CASES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_test_cases_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_test_cases_unref (old);
	}
}

void
bird_font_value_take_test_cases (GValue* value,
                                 gpointer v_object)
{
	BirdFontTestCases * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_TEST_CASES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_TEST_CASES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_test_cases_unref (old);
	}
}

static void
bird_font_test_cases_class_init (BirdFontTestCasesClass * klass,
                                 gpointer klass_data)
{
	bird_font_test_cases_parent_class = g_type_class_peek_parent (klass);
	((BirdFontTestCasesClass *) klass)->finalize = bird_font_test_cases_finalize;
}

static void
bird_font_test_cases_instance_init (BirdFontTestCases * self,
                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
bird_font_test_cases_finalize (BirdFontTestCases * obj)
{
	BirdFontTestCases * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_TEST_CASES, BirdFontTestCases);
	g_signal_handlers_destroy (self);
	(self->test_cases == NULL) ? NULL : (self->test_cases = (_g_list_free__g_object_unref0_ (self->test_cases), NULL));
}

/** All the things we want to test listed is here. */
static GType
bird_font_test_cases_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_test_cases_init, bird_font_value_test_cases_free_value, bird_font_value_test_cases_copy_value, bird_font_value_test_cases_peek_pointer, "p", bird_font_value_test_cases_collect_value, "p", bird_font_value_test_cases_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontTestCasesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_test_cases_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTestCases), 0, (GInstanceInitFunc) bird_font_test_cases_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_test_cases_type_id;
	bird_font_test_cases_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontTestCases", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_test_cases_type_id;
}

GType
bird_font_test_cases_get_type (void)
{
	static volatile gsize bird_font_test_cases_type_id__once = 0;
	if (g_once_init_enter (&bird_font_test_cases_type_id__once)) {
		GType bird_font_test_cases_type_id;
		bird_font_test_cases_type_id = bird_font_test_cases_get_type_once ();
		g_once_init_leave (&bird_font_test_cases_type_id__once, bird_font_test_cases_type_id);
	}
	return bird_font_test_cases_type_id__once;
}

gpointer
bird_font_test_cases_ref (gpointer instance)
{
	BirdFontTestCases * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_test_cases_unref (gpointer instance)
{
	BirdFontTestCases * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_TEST_CASES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

