/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the inverse of a displacement field.


InverseDisplacementFieldImageFilter takes a displacement field as input and computes the displacement
field that is its inverse. If the input displacement field was mapping
coordinates from a space A into a space B, the output of this filter
will map coordinates from the space B into the space A.

Given that both the input and output displacement field are
represented as discrete images with pixel type vector, the inverse
will be only an estimation and will probably not correspond to a
perfect inverse. The precision of the inverse can be improved at the
price of increasing the computation time and memory consumption in
this filter.

The method used for computing the inverse displacement field is to
subsample the input field using a regular grid and create Kerned-Base
Spline in which the reference landmarks are the coordinates of the
deformed point and the target landmarks are the negative of the
displacement vectors. The kernel-base spline is then used for
regularly sampling the output space and recover vector values for
every single pixel.

The subsampling factor used for the regular grid of the input field
will determine the number of landmarks in the KernelBased spline and
therefore it will have a dramatic effect on both the precision of
output displacement field and the computational time required for the
filter to complete the estimation. A large subsampling factor will
result in few landmarks in the KernelBased spline, therefore on fast
computation and low precision. A small subsampling factor will result
in a large number of landmarks in the KernelBased spline, therefore a
large memory consumption, long computation time and high precision for
the inverse estimation.

This filter expects both the input and output images to be of pixel
type Vector .
See:
 itk::simple::InverseDisplacementField for the procedural interface

 itk::InverseDisplacementFieldImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkInverseDisplacementFieldImageFilter.h
*/
public class InverseDisplacementFieldImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected InverseDisplacementFieldImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.InverseDisplacementFieldImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(InverseDisplacementFieldImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(InverseDisplacementFieldImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::InverseDisplacementFieldImageFilter::~InverseDisplacementFieldImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_InverseDisplacementFieldImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::InverseDisplacementFieldImageFilter::InverseDisplacementFieldImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  InverseDisplacementFieldImageFilter() {
    this(SimpleITKJNI.new_InverseDisplacementFieldImageFilter(), true);
  }

  /**
Self&amp; itk::simple::InverseDisplacementFieldImageFilter::SetSize(std::vector&lt; uint32_t &gt; Size)

Set the size of the output image.

*/
public  void setSize(VectorUInt32 Size) {
    SimpleITKJNI.InverseDisplacementFieldImageFilter_setSize(swigCPtr, this, VectorUInt32.getCPtr(Size), Size);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::InverseDisplacementFieldImageFilter::GetSize() const

Get the size of the output image.

*/
public  VectorUInt32 getSize() {
    return new VectorUInt32(SimpleITKJNI.InverseDisplacementFieldImageFilter_getSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::InverseDisplacementFieldImageFilter::SetOutputOrigin(std::vector&lt; double &gt; OutputOrigin)

Set the output image origin.

*/
public  void setOutputOrigin(VectorDouble OutputOrigin) {
    SimpleITKJNI.InverseDisplacementFieldImageFilter_setOutputOrigin(swigCPtr, this, VectorDouble.getCPtr(OutputOrigin), OutputOrigin);
  }

  /**
std::vector&lt;double&gt; itk::simple::InverseDisplacementFieldImageFilter::GetOutputOrigin() const

Get the output image origin.

*/
public  VectorDouble getOutputOrigin() {
    return new VectorDouble(SimpleITKJNI.InverseDisplacementFieldImageFilter_getOutputOrigin(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::InverseDisplacementFieldImageFilter::SetOutputSpacing(std::vector&lt; double &gt; OutputSpacing)

Set the output image spacing.

*/
public  void setOutputSpacing(VectorDouble OutputSpacing) {
    SimpleITKJNI.InverseDisplacementFieldImageFilter_setOutputSpacing(swigCPtr, this, VectorDouble.getCPtr(OutputSpacing), OutputSpacing);
  }

  /**
std::vector&lt;double&gt; itk::simple::InverseDisplacementFieldImageFilter::GetOutputSpacing() const

Get the output image spacing.

*/
public  VectorDouble getOutputSpacing() {
    return new VectorDouble(SimpleITKJNI.InverseDisplacementFieldImageFilter_getOutputSpacing(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::InverseDisplacementFieldImageFilter::SetSubsamplingFactor(unsigned int SubsamplingFactor)

Set/Get the factor used for subsampling the input displacement field.
A large value in this factor will produce a fast computation of the
inverse field but with low precision. A small value of this factor
will produce a precise computation of the inverse field at the price
of large memory consumption and long computational time.

*/
public  void setSubsamplingFactor(long SubsamplingFactor) {
    SimpleITKJNI.InverseDisplacementFieldImageFilter_setSubsamplingFactor(swigCPtr, this, SubsamplingFactor);
  }

  /**
unsigned int itk::simple::InverseDisplacementFieldImageFilter::GetSubsamplingFactor() const

Set/Get the factor used for subsampling the input displacement field.
A large value in this factor will produce a fast computation of the
inverse field but with low precision. A small value of this factor
will produce a precise computation of the inverse field at the price
of large memory consumption and long computational time.

*/
public  long getSubsamplingFactor() {
    return SimpleITKJNI.InverseDisplacementFieldImageFilter_getSubsamplingFactor(swigCPtr, this);
  }

  /**
std::string itk::simple::InverseDisplacementFieldImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.InverseDisplacementFieldImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::InverseDisplacementFieldImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.InverseDisplacementFieldImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::InverseDisplacementFieldImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.InverseDisplacementFieldImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
void itk::simple::InverseDisplacementFieldImageFilter::SetReferenceImage(const Image &amp;refImage)

This methods sets the output size, origin, and direction to that of
the provided image

*/
public  void setReferenceImage(Image refImage) {
    SimpleITKJNI.InverseDisplacementFieldImageFilter_setReferenceImage(swigCPtr, this, Image.getCPtr(refImage), refImage);
  }

}
