/*
 * Copyright (c) 2010-2011 Atheros Communications, Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef AR9003_PHY_H
#define AR9003_PHY_H

/*
 * Channel Register Map
 */
#define AR_CHAN_BASE	0x9800

#define AR_PHY_TIMING1      (AR_CHAN_BASE + 0x0)
#define AR_PHY_TIMING2      (AR_CHAN_BASE + 0x4)
#define AR_PHY_TIMING3      (AR_CHAN_BASE + 0x8)
#define AR_PHY_TIMING4      (AR_CHAN_BASE + 0xc)
#define AR_PHY_TIMING5      (AR_CHAN_BASE + 0x10)
#define AR_PHY_TIMING6      (AR_CHAN_BASE + 0x14)
#define AR_PHY_TIMING11     (AR_CHAN_BASE + 0x18)
#define AR_PHY_SPUR_REG     (AR_CHAN_BASE + 0x1c)
#define AR_PHY_RX_IQCAL_CORR_B0    (AR_CHAN_BASE + 0xdc)
#define AR_PHY_TX_IQCAL_CONTROL_3  (AR_CHAN_BASE + 0xb0)
#define AR_PHY_TIMING_CONTROL4_DO_GAIN_DC_IQ_CAL_SHIFT 16

#define AR_PHY_TIMING11_SPUR_FREQ_SD    0x3FF00000
#define AR_PHY_TIMING11_SPUR_FREQ_SD_S  20

#define AR_PHY_TIMING11_SPUR_DELTA_PHASE 0x000FFFFF
#define AR_PHY_TIMING11_SPUR_DELTA_PHASE_S 0

#define AR_PHY_TIMING11_USE_SPUR_FILTER_IN_AGC 0x40000000
#define AR_PHY_TIMING11_USE_SPUR_FILTER_IN_AGC_S 30

#define AR_PHY_TIMING11_USE_SPUR_FILTER_IN_SELFCOR 0x80000000
#define AR_PHY_TIMING11_USE_SPUR_FILTER_IN_SELFCOR_S 31

#define AR_PHY_SPUR_REG_ENABLE_NF_RSSI_SPUR_MIT         0x4000000
#define AR_PHY_SPUR_REG_ENABLE_NF_RSSI_SPUR_MIT_S       26

#define AR_PHY_SPUR_REG_ENABLE_MASK_PPM                         0x20000     /* bins move with freq offset */
#define AR_PHY_SPUR_REG_ENABLE_MASK_PPM_S                       17
#define AR_PHY_SPUR_REG_SPUR_RSSI_THRESH            0x000000FF
#define AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_S          0
#define AR_PHY_SPUR_REG_EN_VIT_SPUR_RSSI                        0x00000100
#define AR_PHY_SPUR_REG_EN_VIT_SPUR_RSSI_S                      8
#define AR_PHY_SPUR_REG_MASK_RATE_CNTL                          0x03FC0000
#define AR_PHY_SPUR_REG_MASK_RATE_CNTL_S			18

#define AR_PHY_RX_IQCAL_CORR_B0_LOOPBACK_IQCORR_EN   0x20000000
#define AR_PHY_RX_IQCAL_CORR_B0_LOOPBACK_IQCORR_EN_S         29

#define AR_PHY_TX_IQCAL_CONTROL_3_IQCORR_EN   0x80000000
#define AR_PHY_TX_IQCAL_CONTROL_3_IQCORR_EN_S         31

#define AR_PHY_FIND_SIG_LOW  (AR_CHAN_BASE + 0x20)

#define AR_PHY_SFCORR           (AR_CHAN_BASE + 0x24)
#define AR_PHY_SFCORR_LOW       (AR_CHAN_BASE + 0x28)
#define AR_PHY_SFCORR_EXT       (AR_CHAN_BASE + 0x2c)

#define AR_PHY_EXT_CCA              (AR_CHAN_BASE + 0x30)
#define AR_PHY_RADAR_0              (AR_CHAN_BASE + 0x34)
#define AR_PHY_RADAR_1              (AR_CHAN_BASE + 0x38)
#define AR_PHY_RADAR_EXT            (AR_CHAN_BASE + 0x3c)
#define AR_PHY_MULTICHAIN_CTRL      (AR_CHAN_BASE + 0x80)
#define AR_PHY_PERCHAIN_CSD         (AR_CHAN_BASE + 0x84)

#define AR_PHY_TX_PHASE_RAMP_0      (AR_CHAN_BASE + 0xd0)
#define AR_PHY_ADC_GAIN_DC_CORR_0   (AR_CHAN_BASE + 0xd4)
#define AR_PHY_IQ_ADC_MEAS_0_B0     (AR_CHAN_BASE + 0xc0)
#define AR_PHY_IQ_ADC_MEAS_1_B0     (AR_CHAN_BASE + 0xc4)
#define AR_PHY_IQ_ADC_MEAS_2_B0     (AR_CHAN_BASE + 0xc8)
#define AR_PHY_IQ_ADC_MEAS_3_B0     (AR_CHAN_BASE + 0xcc)

/* The following registers changed position from AR9300 1.0 to AR9300 2.0 */
#define AR_PHY_TX_PHASE_RAMP_0_9300_10      (AR_CHAN_BASE + 0xd0 - 0x10)
#define AR_PHY_ADC_GAIN_DC_CORR_0_9300_10   (AR_CHAN_BASE + 0xd4 - 0x10)
#define AR_PHY_IQ_ADC_MEAS_0_B0_9300_10     (AR_CHAN_BASE + 0xc0 + 0x8)
#define AR_PHY_IQ_ADC_MEAS_1_B0_9300_10     (AR_CHAN_BASE + 0xc4 + 0x8)
#define AR_PHY_IQ_ADC_MEAS_2_B0_9300_10     (AR_CHAN_BASE + 0xc8 + 0x8)
#define AR_PHY_IQ_ADC_MEAS_3_B0_9300_10     (AR_CHAN_BASE + 0xcc + 0x8)

#define AR_PHY_TX_CRC               (AR_CHAN_BASE + 0xa0)
#define AR_PHY_TST_DAC_CONST        (AR_CHAN_BASE + 0xa4)
#define AR_PHY_SPUR_REPORT_0        (AR_CHAN_BASE + 0xa8)
#define AR_PHY_CHAN_INFO_TAB_0      (AR_CHAN_BASE + 0x300)

/*
 * Channel Field Definitions
 */
#define AR_PHY_TIMING2_USE_FORCE_PPM    0x00001000
#define AR_PHY_TIMING2_FORCE_PPM_VAL    0x00000fff
#define AR_PHY_TIMING3_DSC_MAN      0xFFFE0000
#define AR_PHY_TIMING3_DSC_MAN_S    17
#define AR_PHY_TIMING3_DSC_EXP      0x0001E000
#define AR_PHY_TIMING3_DSC_EXP_S    13
#define AR_PHY_TIMING4_IQCAL_LOG_COUNT_MAX 0xF000
#define AR_PHY_TIMING4_IQCAL_LOG_COUNT_MAX_S   12
#define AR_PHY_TIMING4_DO_CAL    0x10000

#define AR_PHY_TIMING4_ENABLE_PILOT_MASK        0x10000000
#define AR_PHY_TIMING4_ENABLE_PILOT_MASK_S      28
#define AR_PHY_TIMING4_ENABLE_CHAN_MASK         0x20000000
#define AR_PHY_TIMING4_ENABLE_CHAN_MASK_S       29

#define AR_PHY_TIMING4_ENABLE_SPUR_FILTER 0x40000000
#define AR_PHY_TIMING4_ENABLE_SPUR_FILTER_S 30
#define AR_PHY_TIMING4_ENABLE_SPUR_RSSI 0x80000000
#define AR_PHY_TIMING4_ENABLE_SPUR_RSSI_S 31

#define AR_PHY_NEW_ADC_GAIN_CORR_ENABLE 0x40000000
#define AR_PHY_NEW_ADC_DC_OFFSET_CORR_ENABLE 0x80000000
#define AR_PHY_SFCORR_LOW_USE_SELF_CORR_LOW  0x00000001
#define AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW    0x00003F00
#define AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_S  8
#define AR_PHY_SFCORR_LOW_M1_THRESH_LOW      0x001FC000
#define AR_PHY_SFCORR_LOW_M1_THRESH_LOW_S    14
#define AR_PHY_SFCORR_LOW_M2_THRESH_LOW      0x0FE00000
#define AR_PHY_SFCORR_LOW_M2_THRESH_LOW_S    21
#define AR_PHY_SFCORR_M2COUNT_THR    0x0000001F
#define AR_PHY_SFCORR_M2COUNT_THR_S  0
#define AR_PHY_SFCORR_M1_THRESH      0x00FE0000
#define AR_PHY_SFCORR_M1_THRESH_S    17
#define AR_PHY_SFCORR_M2_THRESH      0x7F000000
#define AR_PHY_SFCORR_M2_THRESH_S    24
#define AR_PHY_SFCORR_EXT_M1_THRESH       0x0000007F
#define AR_PHY_SFCORR_EXT_M1_THRESH_S     0
#define AR_PHY_SFCORR_EXT_M2_THRESH       0x00003F80
#define AR_PHY_SFCORR_EXT_M2_THRESH_S     7
#define AR_PHY_SFCORR_EXT_M1_THRESH_LOW   0x001FC000
#define AR_PHY_SFCORR_EXT_M1_THRESH_LOW_S 14
#define AR_PHY_SFCORR_EXT_M2_THRESH_LOW   0x0FE00000
#define AR_PHY_SFCORR_EXT_M2_THRESH_LOW_S 21
#define AR_PHY_SFCORR_EXT_SPUR_SUBCHANNEL_SD 0x10000000
#define AR_PHY_SFCORR_EXT_SPUR_SUBCHANNEL_SD_S 28
#define AR_PHY_SFCORR_SPUR_SUBCHNL_SD_S   28
#define AR_PHY_EXT_CCA_THRESH62 0x007F0000
#define AR_PHY_EXT_CCA_THRESH62_S       16
#define AR_PHY_EXT_MINCCA_PWR   0x01FF0000
#define AR_PHY_EXT_MINCCA_PWR_S 16
#define AR_PHY_EXT_CYCPWR_THR1 0x0000FE00L
#define AR_PHY_EXT_CYCPWR_THR1_S 9
#define AR_PHY_TIMING5_CYCPWR_THR1  0x000000FE
#define AR_PHY_TIMING5_CYCPWR_THR1_S    1
#define AR_PHY_TIMING5_CYCPWR_THR1_ENABLE  0x00000001
#define AR_PHY_TIMING5_CYCPWR_THR1_ENABLE_S    0
#define AR_PHY_TIMING5_CYCPWR_THR1A  0x007F0000
#define AR_PHY_TIMING5_CYCPWR_THR1A_S    16
#define AR_PHY_TIMING5_RSSI_THR1A     (0x7F << 16)
#define AR_PHY_TIMING5_RSSI_THR1A_S   16
#define AR_PHY_TIMING5_RSSI_THR1A_ENA (0x1 << 15)
#define AR_PHY_RADAR_0_ENA  0x00000001
#define AR_PHY_RADAR_0_FFT_ENA  0x80000000
#define AR_PHY_RADAR_0_INBAND   0x0000003e
#define AR_PHY_RADAR_0_INBAND_S 1
#define AR_PHY_RADAR_0_PRSSI    0x00000FC0
#define AR_PHY_RADAR_0_PRSSI_S  6
#define AR_PHY_RADAR_0_HEIGHT   0x0003F000
#define AR_PHY_RADAR_0_HEIGHT_S 12
#define AR_PHY_RADAR_0_RRSSI    0x00FC0000
#define AR_PHY_RADAR_0_RRSSI_S  18
#define AR_PHY_RADAR_0_FIRPWR   0x7F000000
#define AR_PHY_RADAR_0_FIRPWR_S 24
#define AR_PHY_RADAR_1_RELPWR_ENA       0x00800000
#define AR_PHY_RADAR_1_USE_FIR128       0x00400000
#define AR_PHY_RADAR_1_RELPWR_THRESH    0x003F0000
#define AR_PHY_RADAR_1_RELPWR_THRESH_S  16
#define AR_PHY_RADAR_1_BLOCK_CHECK      0x00008000
#define AR_PHY_RADAR_1_MAX_RRSSI        0x00004000
#define AR_PHY_RADAR_1_RELSTEP_CHECK    0x00002000
#define AR_PHY_RADAR_1_RELSTEP_THRESH   0x00001F00
#define AR_PHY_RADAR_1_RELSTEP_THRESH_S 8
#define AR_PHY_RADAR_1_MAXLEN           0x000000FF
#define AR_PHY_RADAR_1_MAXLEN_S         0
#define AR_PHY_RADAR_EXT_ENA            0x00004000
#define AR_PHY_RADAR_DC_PWR_THRESH      0x007f8000
#define AR_PHY_RADAR_DC_PWR_THRESH_S    15
#define AR_PHY_RADAR_LB_DC_CAP          0x7f800000
#define AR_PHY_RADAR_LB_DC_CAP_S        23
#define AR_PHY_FIND_SIG_LOW_FIRSTEP_LOW (0x3f << 6)
#define AR_PHY_FIND_SIG_LOW_FIRSTEP_LOW_S   6
#define AR_PHY_FIND_SIG_LOW_FIRPWR      (0x7f << 12)
#define AR_PHY_FIND_SIG_LOW_FIRPWR_S    12
#define AR_PHY_FIND_SIG_LOW_FIRPWR_SIGN_BIT 19
#define AR_PHY_FIND_SIG_LOW_RELSTEP     0x1f
#define AR_PHY_FIND_SIG_LOW_RELSTEP_S   0
#define AR_PHY_FIND_SIG_LOW_RELSTEP_SIGN_BIT 5
#define AR_PHY_CHAN_INFO_TAB_S2_READ    0x00000008
#define AR_PHY_CHAN_INFO_TAB_S2_READ_S           3
#define AR_PHY_RX_IQCAL_CORR_IQCORR_Q_Q_COFF 0x0000007F
#define AR_PHY_RX_IQCAL_CORR_IQCORR_Q_Q_COFF_S   0
#define AR_PHY_RX_IQCAL_CORR_IQCORR_Q_I_COFF 0x00003F80
#define AR_PHY_RX_IQCAL_CORR_IQCORR_Q_I_COFF_S   7
#define AR_PHY_RX_IQCAL_CORR_IQCORR_ENABLE   0x00004000
#define AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_Q_COFF   0x003f8000
#define AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_Q_COFF_S 15
#define AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_I_COFF   0x1fc00000
#define AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_I_COFF_S 22

/*
 * MRC Register Map
 */
#define AR_MRC_BASE	0x9c00

#define AR_PHY_TIMING_3A       (AR_MRC_BASE + 0x0)
#define AR_PHY_LDPC_CNTL1      (AR_MRC_BASE + 0x4)
#define AR_PHY_LDPC_CNTL2      (AR_MRC_BASE + 0x8)
#define AR_PHY_PILOT_SPUR_MASK (AR_MRC_BASE + 0xc)
#define AR_PHY_CHAN_SPUR_MASK  (AR_MRC_BASE + 0x10)
#define AR_PHY_SGI_DELTA       (AR_MRC_BASE + 0x14)
#define AR_PHY_ML_CNTL_1       (AR_MRC_BASE + 0x18)
#define AR_PHY_ML_CNTL_2       (AR_MRC_BASE + 0x1c)
#define AR_PHY_TST_ADC         (AR_MRC_BASE + 0x20)

#define AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_IDX_A      0x00000FE0
#define AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_IDX_A_S    5
#define AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_A          0x1F
#define AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_A_S        0
#define AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_IDX_B      0x00FE0000
#define AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_IDX_B_S    17
#define AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_B          0x0001F000
#define AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_B_S        12

#define AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_IDX_A        0x00000FE0
#define AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_IDX_A_S      5
#define AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_A            0x1F
#define AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_A_S		0
#define AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_IDX_B	0x00FE0000
#define AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_IDX_B_S	17
#define AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_B		0x0001F000
#define AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_B_S		12


/*
 * MRC Feild Definitions
 */
#define AR_PHY_SGI_DSC_MAN   0x0007FFF0
#define AR_PHY_SGI_DSC_MAN_S 4
#define AR_PHY_SGI_DSC_EXP   0x0000000F
#define AR_PHY_SGI_DSC_EXP_S 0
/*
 * BBB Register Map
 */
#define AR_BBB_BASE	0x9d00

/*
 * AGC Register Map
 */
#define AR_AGC_BASE	0x9e00

#define AR_PHY_SETTLING         (AR_AGC_BASE + 0x0)
#define AR_PHY_FORCEMAX_GAINS_0 (AR_AGC_BASE + 0x4)
#define AR_PHY_GAINS_MINOFF0    (AR_AGC_BASE + 0x8)
#define AR_PHY_DESIRED_SZ       (AR_AGC_BASE + 0xc)
#define AR_PHY_FIND_SIG         (AR_AGC_BASE + 0x10)
#define AR_PHY_AGC              (AR_AGC_BASE + 0x14)
#define AR_PHY_EXT_ATTEN_CTL_0  (AR_AGC_BASE + 0x18)
#define AR_PHY_CCA_0            (AR_AGC_BASE + 0x1c)
#define AR_PHY_EXT_CCA0         (AR_AGC_BASE + 0x20)
#define AR_PHY_RESTART          (AR_AGC_BASE + 0x24)

/*
 * Antenna Diversity  settings
 */
#define AR_PHY_MC_GAIN_CTRL     (AR_AGC_BASE + 0x28)
#define AR_ANT_DIV_CTRL_ALL	0x7e000000
#define AR_ANT_DIV_CTRL_ALL_S	25
#define AR_ANT_DIV_ENABLE	0x1000000
#define AR_ANT_DIV_ENABLE_S	24


#define AR_PHY_ANT_FAST_DIV_BIAS                0x00007e00
#define AR_PHY_ANT_FAST_DIV_BIAS_S              9
#define AR_PHY_ANT_SW_RX_PROT                   0x00800000
#define AR_PHY_ANT_SW_RX_PROT_S                 23
#define AR_PHY_ANT_DIV_LNADIV                   0x01000000
#define AR_PHY_ANT_DIV_LNADIV_S                 24
#define AR_PHY_ANT_DIV_ALT_LNACONF              0x06000000
#define AR_PHY_ANT_DIV_ALT_LNACONF_S            25
#define AR_PHY_ANT_DIV_MAIN_LNACONF             0x18000000
#define AR_PHY_ANT_DIV_MAIN_LNACONF_S           27
#define AR_PHY_ANT_DIV_ALT_GAINTB               0x20000000
#define AR_PHY_ANT_DIV_ALT_GAINTB_S             29
#define AR_PHY_ANT_DIV_MAIN_GAINTB              0x40000000
#define AR_PHY_ANT_DIV_MAIN_GAINTB_S            30

#define AR_PHY_ANT_DIV_LNA1_MINUS_LNA2          0x0
#define AR_PHY_ANT_DIV_LNA2                     0x1
#define AR_PHY_ANT_DIV_LNA1                     0x2
#define AR_PHY_ANT_DIV_LNA1_PLUS_LNA2           0x3

#define AR_PHY_EXTCHN_PWRTHR1   (AR_AGC_BASE + 0x2c)
#define AR_PHY_EXT_CHN_WIN      (AR_AGC_BASE + 0x30)
#define AR_PHY_20_40_DET_THR    (AR_AGC_BASE + 0x34)
#define AR_PHY_RIFS_SRCH        (AR_AGC_BASE + 0x38)
#define AR_PHY_PEAK_DET_CTRL_1  (AR_AGC_BASE + 0x3c)
#define AR_PHY_PEAK_DET_CTRL_2  (AR_AGC_BASE + 0x40)
#define AR_PHY_RX_GAIN_BOUNDS_1 (AR_AGC_BASE + 0x44)
#define AR_PHY_RX_GAIN_BOUNDS_2 (AR_AGC_BASE + 0x48)
#define AR_PHY_RSSI_0           (AR_AGC_BASE + 0x180)
#define AR_PHY_SPUR_CCK_REP0    (AR_AGC_BASE + 0x184)

#define AR_PHY_CCK_DETECT       (AR_AGC_BASE + 0x1c0)
#define AR_FAST_DIV_ENABLE	0x2000
#define AR_FAST_DIV_ENABLE_S	13

#define AR_PHY_DAG_CTRLCCK      (AR_AGC_BASE + 0x1c4)
#define AR_PHY_IQCORR_CTRL_CCK  (AR_AGC_BASE + 0x1c8)

#define AR_PHY_CCK_SPUR_MIT     (AR_AGC_BASE + 0x1cc)
#define AR_PHY_CCK_SPUR_MIT_SPUR_RSSI_THR                           0x000001fe
#define AR_PHY_CCK_SPUR_MIT_SPUR_RSSI_THR_S                                  1
#define AR_PHY_CCK_SPUR_MIT_SPUR_FILTER_TYPE                        0x60000000
#define AR_PHY_CCK_SPUR_MIT_SPUR_FILTER_TYPE_S                              29
#define AR_PHY_CCK_SPUR_MIT_USE_CCK_SPUR_MIT                        0x00000001
#define AR_PHY_CCK_SPUR_MIT_USE_CCK_SPUR_MIT_S                               0
#define AR_PHY_CCK_SPUR_MIT_CCK_SPUR_FREQ                           0x1ffffe00
#define AR_PHY_CCK_SPUR_MIT_CCK_SPUR_FREQ_S                                  9

#define AR_PHY_MRC_CCK_CTRL         (AR_AGC_BASE + 0x1d0)
#define AR_PHY_MRC_CCK_ENABLE       0x00000001
#define AR_PHY_MRC_CCK_ENABLE_S              0
#define AR_PHY_MRC_CCK_MUX_REG      0x00000002
#define AR_PHY_MRC_CCK_MUX_REG_S             1

#define AR_PHY_RX_OCGAIN        (AR_AGC_BASE + 0x200)

#define AR_PHY_CCA_NOM_VAL_9300_2GHZ          -110
#define AR_PHY_CCA_NOM_VAL_9300_5GHZ          -115
#define AR_PHY_CCA_MIN_GOOD_VAL_9300_2GHZ     -125
#define AR_PHY_CCA_MIN_GOOD_VAL_9300_5GHZ     -125
#define AR_PHY_CCA_MAX_GOOD_VAL_9300_2GHZ     -95
#define AR_PHY_CCA_MAX_GOOD_VAL_9300_5GHZ     -100

#define AR_PHY_CCA_NOM_VAL_9462_2GHZ          -127
#define AR_PHY_CCA_MIN_GOOD_VAL_9462_2GHZ     -127
#define AR_PHY_CCA_NOM_VAL_9462_5GHZ          -127
#define AR_PHY_CCA_MIN_GOOD_VAL_9462_5GHZ     -127

#define AR_PHY_CCA_NOM_VAL_9330_2GHZ          -118

#define AR9300_EXT_LNA_CTL_GPIO_AR9485 9

/*
 * AGC Field Definitions
 */
#define AR_PHY_EXT_ATTEN_CTL_RXTX_MARGIN    0x00FC0000
#define AR_PHY_EXT_ATTEN_CTL_RXTX_MARGIN_S  18
#define AR_PHY_EXT_ATTEN_CTL_BSW_MARGIN     0x00003C00
#define AR_PHY_EXT_ATTEN_CTL_BSW_MARGIN_S   10
#define AR_PHY_EXT_ATTEN_CTL_BSW_ATTEN      0x0000001F
#define AR_PHY_EXT_ATTEN_CTL_BSW_ATTEN_S    0
#define AR_PHY_EXT_ATTEN_CTL_XATTEN2_MARGIN     0x003E0000
#define AR_PHY_EXT_ATTEN_CTL_XATTEN2_MARGIN_S   17
#define AR_PHY_EXT_ATTEN_CTL_XATTEN1_MARGIN     0x0001F000
#define AR_PHY_EXT_ATTEN_CTL_XATTEN1_MARGIN_S   12
#define AR_PHY_EXT_ATTEN_CTL_XATTEN2_DB         0x00000FC0
#define AR_PHY_EXT_ATTEN_CTL_XATTEN2_DB_S       6
#define AR_PHY_EXT_ATTEN_CTL_XATTEN1_DB         0x0000003F
#define AR_PHY_EXT_ATTEN_CTL_XATTEN1_DB_S       0
#define AR_PHY_RXGAIN_TXRX_ATTEN    0x0003F000
#define AR_PHY_RXGAIN_TXRX_ATTEN_S  12
#define AR_PHY_RXGAIN_TXRX_RF_MAX   0x007C0000
#define AR_PHY_RXGAIN_TXRX_RF_MAX_S 18
#define AR9280_PHY_RXGAIN_TXRX_ATTEN    0x00003F80
#define AR9280_PHY_RXGAIN_TXRX_ATTEN_S  7
#define AR9280_PHY_RXGAIN_TXRX_MARGIN   0x001FC000
#define AR9280_PHY_RXGAIN_TXRX_MARGIN_S 14
#define AR_PHY_SETTLING_SWITCH  0x00003F80
#define AR_PHY_SETTLING_SWITCH_S    7
#define AR_PHY_DESIRED_SZ_ADC       0x000000FF
#define AR_PHY_DESIRED_SZ_ADC_S     0
#define AR_PHY_DESIRED_SZ_PGA       0x0000FF00
#define AR_PHY_DESIRED_SZ_PGA_S     8
#define AR_PHY_DESIRED_SZ_TOT_DES   0x0FF00000
#define AR_PHY_DESIRED_SZ_TOT_DES_S 20
#define AR_PHY_MINCCA_PWR       0x1FF00000
#define AR_PHY_MINCCA_PWR_S     20
#define AR_PHY_CCA_THRESH62     0x0007F000
#define AR_PHY_CCA_THRESH62_S   12
#define AR9280_PHY_MINCCA_PWR       0x1FF00000
#define AR9280_PHY_MINCCA_PWR_S     20
#define AR9280_PHY_CCA_THRESH62     0x000FF000
#define AR9280_PHY_CCA_THRESH62_S   12
#define AR_PHY_EXT_CCA0_THRESH62    0x000000FF
#define AR_PHY_EXT_CCA0_THRESH62_S  0
#define AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK          0x0000003F
#define AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_S        0
#define AR_PHY_CCK_DETECT_ANT_SWITCH_TIME           0x00001FC0
#define AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_S         6
#define AR_PHY_CCK_DETECT_BB_ENABLE_ANT_FAST_DIV    0x2000

#define AR_PHY_DAG_CTRLCCK_EN_RSSI_THR  0x00000200
#define AR_PHY_DAG_CTRLCCK_EN_RSSI_THR_S  9
#define AR_PHY_DAG_CTRLCCK_RSSI_THR 0x0001FC00
#define AR_PHY_DAG_CTRLCCK_RSSI_THR_S   10

#define AR_PHY_RIFS_INIT_DELAY         0x3ff0000
#define AR_PHY_AGC_QUICK_DROP       0x03c00000
#define AR_PHY_AGC_QUICK_DROP_S     22
#define AR_PHY_AGC_COARSE_LOW       0x00007F80
#define AR_PHY_AGC_COARSE_LOW_S     7
#define AR_PHY_AGC_COARSE_HIGH      0x003F8000
#define AR_PHY_AGC_COARSE_HIGH_S    15
#define AR_PHY_AGC_COARSE_PWR_CONST 0x0000007F
#define AR_PHY_AGC_COARSE_PWR_CONST_S   0
#define AR_PHY_FIND_SIG_FIRSTEP  0x0003F000
#define AR_PHY_FIND_SIG_FIRSTEP_S        12
#define AR_PHY_FIND_SIG_FIRPWR   0x03FC0000
#define AR_PHY_FIND_SIG_FIRPWR_S         18
#define AR_PHY_FIND_SIG_FIRPWR_SIGN_BIT  25
#define AR_PHY_FIND_SIG_RELPWR   (0x1f << 6)
#define AR_PHY_FIND_SIG_RELPWR_S          6
#define AR_PHY_FIND_SIG_RELPWR_SIGN_BIT  11
#define AR_PHY_FIND_SIG_RELSTEP        0x1f
#define AR_PHY_FIND_SIG_RELSTEP_S         0
#define AR_PHY_FIND_SIG_RELSTEP_SIGN_BIT  5
#define AR_PHY_RESTART_ENABLE_DIV_M2FLAG 0x00200000
#define AR_PHY_RESTART_ENABLE_DIV_M2FLAG_S 21
#define AR_PHY_RESTART_DIV_GC   0x001C0000
#define AR_PHY_RESTART_DIV_GC_S 18
#define AR_PHY_RESTART_ENA      0x01
#define AR_PHY_DC_RESTART_DIS   0x40000000

#define AR_PHY_TPC_OLPC_GAIN_DELTA_PAL_ON       0xFF000000
#define AR_PHY_TPC_OLPC_GAIN_DELTA_PAL_ON_S     24
#define AR_PHY_TPC_OLPC_GAIN_DELTA              0x00FF0000
#define AR_PHY_TPC_OLPC_GAIN_DELTA_S            16

#define AR_PHY_TPC_6_ERROR_EST_MODE             0x03000000
#define AR_PHY_TPC_6_ERROR_EST_MODE_S           24

/*
 * SM Register Map
 */
#define AR_SM_BASE	0xa200

#define AR_PHY_D2_CHIP_ID        (AR_SM_BASE + 0x0)
#define AR_PHY_GEN_CTRL          (AR_SM_BASE + 0x4)
#define AR_PHY_MODE              (AR_SM_BASE + 0x8)
#define AR_PHY_ACTIVE            (AR_SM_BASE + 0xc)
#define AR_PHY_SPUR_MASK_A       (AR_SM_BASE + 0x20)
#define AR_PHY_SPUR_MASK_B       (AR_SM_BASE + 0x24)
#define AR_PHY_SPECTRAL_SCAN     (AR_SM_BASE + 0x28)
#define AR_PHY_RADAR_BW_FILTER   (AR_SM_BASE + 0x2c)
#define AR_PHY_SEARCH_START_DELAY (AR_SM_BASE + 0x30)
#define AR_PHY_MAX_RX_LEN        (AR_SM_BASE + 0x34)
#define AR_PHY_FRAME_CTL         (AR_SM_BASE + 0x38)
#define AR_PHY_RFBUS_REQ         (AR_SM_BASE + 0x3c)
#define AR_PHY_RFBUS_GRANT       (AR_SM_BASE + 0x40)
#define AR_PHY_RIFS              (AR_SM_BASE + 0x44)
#define AR_PHY_RX_CLR_DELAY      (AR_SM_BASE + 0x50)
#define AR_PHY_RX_DELAY          (AR_SM_BASE + 0x54)

#define AR_PHY_XPA_TIMING_CTL    (AR_SM_BASE + 0x64)
#define AR_PHY_MISC_PA_CTL       (AR_SM_BASE + 0x80)
#define AR_PHY_SWITCH_CHAIN_0    (AR_SM_BASE + 0x84)
#define AR_PHY_SWITCH_COM        (AR_SM_BASE + 0x88)
#define AR_PHY_SWITCH_COM_2      (AR_SM_BASE + 0x8c)
#define AR_PHY_RX_CHAINMASK      (AR_SM_BASE + 0xa0)
#define AR_PHY_CAL_CHAINMASK     (AR_SM_BASE + 0xc0)
#define AR_PHY_CALMODE           (AR_SM_BASE + 0xc8)
#define AR_PHY_FCAL_1            (AR_SM_BASE + 0xcc)
#define AR_PHY_FCAL_2_0          (AR_SM_BASE + 0xd0)
#define AR_PHY_DFT_TONE_CTL_0    (AR_SM_BASE + 0xd4)
#define AR_PHY_CL_CAL_CTL        (AR_SM_BASE + 0xd8)
#define AR_PHY_CL_TAB_0          (AR_SM_BASE + 0x100)
#define AR_PHY_SYNTH_CONTROL     (AR_SM_BASE + 0x140)
#define AR_PHY_ADDAC_CLK_SEL     (AR_SM_BASE + 0x144)
#define AR_PHY_PLL_CTL           (AR_SM_BASE + 0x148)
#define AR_PHY_ANALOG_SWAP       (AR_SM_BASE + 0x14c)
#define AR_PHY_ADDAC_PARA_CTL    (AR_SM_BASE + 0x150)
#define AR_PHY_XPA_CFG           (AR_SM_BASE + 0x158)

#define AR_PHY_FRAME_CTL_CF_OVERLAP_WINDOW  3
#define AR_PHY_FRAME_CTL_CF_OVERLAP_WINDOW_S    0

#define AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_IDX_A           0x0001FC00
#define AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_IDX_A_S         10
#define AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_A                       0x3FF
#define AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_A_S                     0

#define AR_PHY_TEST              (AR_SM_BASE + 0x160)

#define AR_PHY_TEST_BBB_OBS_SEL       0x780000
#define AR_PHY_TEST_BBB_OBS_SEL_S     19

#define AR_PHY_TEST_RX_OBS_SEL_BIT5_S 23
#define AR_PHY_TEST_RX_OBS_SEL_BIT5   (1 << AR_PHY_TEST_RX_OBS_SEL_BIT5_S)

#define AR_PHY_TEST_CHAIN_SEL      0xC0000000
#define AR_PHY_TEST_CHAIN_SEL_S    30

#define AR_PHY_TEST_CTL_STATUS   (AR_SM_BASE + 0x164)
#define AR_PHY_TEST_CTL_TSTDAC_EN         0x1
#define AR_PHY_TEST_CTL_TSTDAC_EN_S       0
#define AR_PHY_TEST_CTL_TX_OBS_SEL        0x1C
#define AR_PHY_TEST_CTL_TX_OBS_SEL_S      2
#define AR_PHY_TEST_CTL_TX_OBS_MUX_SEL    0x60
#define AR_PHY_TEST_CTL_TX_OBS_MUX_SEL_S  5
#define AR_PHY_TEST_CTL_TSTADC_EN         0x100
#define AR_PHY_TEST_CTL_TSTADC_EN_S       8
#define AR_PHY_TEST_CTL_RX_OBS_SEL        0x3C00
#define AR_PHY_TEST_CTL_RX_OBS_SEL_S      10
#define AR_PHY_TEST_CTL_DEBUGPORT_SEL	  0xe0000000
#define AR_PHY_TEST_CTL_DEBUGPORT_SEL_S	  29


#define AR_PHY_TSTDAC            (AR_SM_BASE + 0x168)

#define AR_PHY_CHAN_STATUS       (AR_SM_BASE + 0x16c)

#define AR_PHY_CHAN_INFO_MEMORY				(AR_SM_BASE + 0x170)
#define AR_PHY_CHAN_INFO_MEMORY_CHANINFOMEM_S2_READ	0x00000008
#define AR_PHY_CHAN_INFO_MEMORY_CHANINFOMEM_S2_READ_S	3

#define AR_PHY_CHNINFO_NOISEPWR  (AR_SM_BASE + 0x174)
#define AR_PHY_CHNINFO_GAINDIFF  (AR_SM_BASE + 0x178)
#define AR_PHY_CHNINFO_FINETIM   (AR_SM_BASE + 0x17c)
#define AR_PHY_CHAN_INFO_GAIN_0  (AR_SM_BASE + 0x180)
#define AR_PHY_SCRAMBLER_SEED    (AR_SM_BASE + 0x190)
#define AR_PHY_CCK_TX_CTRL       (AR_SM_BASE + 0x194)

#define AR_PHY_HEAVYCLIP_CTL     (AR_SM_BASE + 0x1a4)
#define AR_PHY_HEAVYCLIP_20      (AR_SM_BASE + 0x1a8)
#define AR_PHY_HEAVYCLIP_40      (AR_SM_BASE + 0x1ac)
#define AR_PHY_ILLEGAL_TXRATE    (AR_SM_BASE + 0x1b0)

#define AR_PHY_POWER_TX_RATE(_d) (AR_SM_BASE + 0x1c0 + ((_d) << 2))

#define AR_PHY_PWRTX_MAX         (AR_SM_BASE + 0x1f0)
#define AR_PHY_POWER_TX_SUB      (AR_SM_BASE + 0x1f4)

#define AR_PHY_TPC_1				(AR_SM_BASE + 0x1f8)
#define AR_PHY_TPC_1_FORCED_DAC_GAIN		0x0000003e
#define AR_PHY_TPC_1_FORCED_DAC_GAIN_S		1
#define AR_PHY_TPC_1_FORCE_DAC_GAIN		0x00000001
#define AR_PHY_TPC_1_FORCE_DAC_GAIN_S		0

#define AR_PHY_TPC_4_B0				(AR_SM_BASE + 0x204)
#define AR_PHY_TPC_5_B0				(AR_SM_BASE + 0x208)
#define AR_PHY_TPC_6_B0				(AR_SM_BASE + 0x20c)

#define AR_PHY_TPC_11_B0			(AR_SM_BASE + 0x220)
#define AR_PHY_TPC_11_B1			(AR_SM1_BASE + 0x220)
#define AR_PHY_TPC_11_B2			(AR_SM2_BASE + 0x220)
#define AR_PHY_TPC_11_OLPC_GAIN_DELTA		0x00ff0000
#define AR_PHY_TPC_11_OLPC_GAIN_DELTA_S		16

#define AR_PHY_TPC_12				(AR_SM_BASE + 0x224)
#define AR_PHY_TPC_12_DESIRED_SCALE_HT40_5	0x3e000000
#define AR_PHY_TPC_12_DESIRED_SCALE_HT40_5_S	25

#define AR_PHY_TPC_18				(AR_SM_BASE + 0x23c)
#define AR_PHY_TPC_18_THERM_CAL_VALUE           0x000000ff
#define AR_PHY_TPC_18_THERM_CAL_VALUE_S         0
#define AR_PHY_TPC_18_VOLT_CAL_VALUE		0x0000ff00
#define AR_PHY_TPC_18_VOLT_CAL_VALUE_S		8

#define AR_PHY_TPC_19				(AR_SM_BASE + 0x240)
#define AR_PHY_TPC_19_ALPHA_VOLT		0x001f0000
#define AR_PHY_TPC_19_ALPHA_VOLT_S		16
#define AR_PHY_TPC_19_ALPHA_THERM		0xff
#define AR_PHY_TPC_19_ALPHA_THERM_S		0

#define AR_PHY_TX_FORCED_GAIN				(AR_SM_BASE + 0x258)
#define AR_PHY_TX_FORCED_GAIN_FORCE_TX_GAIN		0x00000001
#define AR_PHY_TX_FORCED_GAIN_FORCE_TX_GAIN_S		0
#define AR_PHY_TX_FORCED_GAIN_FORCED_TXBB1DBGAIN	0x0000000e
#define AR_PHY_TX_FORCED_GAIN_FORCED_TXBB1DBGAIN_S	1
#define AR_PHY_TX_FORCED_GAIN_FORCED_TXBB6DBGAIN	0x00000030
#define AR_PHY_TX_FORCED_GAIN_FORCED_TXBB6DBGAIN_S	4
#define AR_PHY_TX_FORCED_GAIN_FORCED_TXMXRGAIN		0x000003c0
#define AR_PHY_TX_FORCED_GAIN_FORCED_TXMXRGAIN_S	6
#define AR_PHY_TX_FORCED_GAIN_FORCED_PADRVGNA		0x00003c00
#define AR_PHY_TX_FORCED_GAIN_FORCED_PADRVGNA_S		10
#define AR_PHY_TX_FORCED_GAIN_FORCED_PADRVGNB		0x0003c000
#define AR_PHY_TX_FORCED_GAIN_FORCED_PADRVGNB_S		14
#define AR_PHY_TX_FORCED_GAIN_FORCED_PADRVGNC		0x003c0000
#define AR_PHY_TX_FORCED_GAIN_FORCED_PADRVGNC_S		18
#define AR_PHY_TX_FORCED_GAIN_FORCED_PADRVGND		0x00c00000
#define AR_PHY_TX_FORCED_GAIN_FORCED_PADRVGND_S		22
#define AR_PHY_TX_FORCED_GAIN_FORCED_ENABLE_PAL		0x01000000
#define AR_PHY_TX_FORCED_GAIN_FORCED_ENABLE_PAL_S	24


#define AR_PHY_PDADC_TAB_0       (AR_SM_BASE + 0x280)

#define AR_PHY_TXGAIN_TABLE      (AR_SM_BASE + 0x300)

#define AR_PHY_TX_IQCAL_CONTROL_0   (AR_SM_BASE + (AR_SREV_9485(ah) ? \
						 0x3c4 : 0x444))
#define AR_PHY_TX_IQCAL_CONTROL_1   (AR_SM_BASE + (AR_SREV_9485(ah) ? \
						 0x3c8 : 0x448))
#define AR_PHY_TX_IQCAL_START       (AR_SM_BASE + (AR_SREV_9485(ah) ? \
						 0x3c4 : 0x440))
#define AR_PHY_TX_IQCAL_STATUS_B0   (AR_SM_BASE + (AR_SREV_9485(ah) ? \
						 0x3f0 : 0x48c))
#define AR_PHY_TX_IQCAL_CORR_COEFF_B0(_i)    (AR_SM_BASE + \
					     (AR_SREV_9485(ah) ? \
					      0x3d0 : 0x450) + ((_i) << 2))
#define AR_PHY_RTT_CTRL			(AR_SM_BASE + 0x380)

#define AR_PHY_WATCHDOG_STATUS      (AR_SM_BASE + 0x5c0)
#define AR_PHY_WATCHDOG_CTL_1       (AR_SM_BASE + 0x5c4)
#define AR_PHY_WATCHDOG_CTL_2       (AR_SM_BASE + 0x5c8)
#define AR_PHY_WATCHDOG_CTL         (AR_SM_BASE + 0x5cc)
#define AR_PHY_ONLY_WARMRESET       (AR_SM_BASE + 0x5d0)
#define AR_PHY_ONLY_CTL             (AR_SM_BASE + 0x5d4)
#define AR_PHY_ECO_CTRL             (AR_SM_BASE + 0x5dc)

#define AR_PHY_BB_THERM_ADC_1				(AR_SM_BASE + 0x248)
#define AR_PHY_BB_THERM_ADC_1_INIT_THERM		0x000000ff
#define AR_PHY_BB_THERM_ADC_1_INIT_THERM_S		0

#define AR_PHY_BB_THERM_ADC_3				(AR_SM_BASE + 0x250)
#define AR_PHY_BB_THERM_ADC_3_THERM_ADC_SCALE_GAIN	0x0001ff00
#define AR_PHY_BB_THERM_ADC_3_THERM_ADC_SCALE_GAIN_S	8
#define AR_PHY_BB_THERM_ADC_3_THERM_ADC_OFFSET		0x000000ff
#define AR_PHY_BB_THERM_ADC_3_THERM_ADC_OFFSET_S	0

#define AR_PHY_BB_THERM_ADC_4				(AR_SM_BASE + 0x254)
#define AR_PHY_BB_THERM_ADC_4_LATEST_THERM_VALUE	0x000000ff
#define AR_PHY_BB_THERM_ADC_4_LATEST_THERM_VALUE_S	0
#define AR_PHY_BB_THERM_ADC_4_LATEST_VOLT_VALUE		0x0000ff00
#define AR_PHY_BB_THERM_ADC_4_LATEST_VOLT_VALUE_S	8

/* AIC Registers */
#define AR_PHY_AIC_CTRL_0_B0	(AR_SM_BASE + 0x4b0)
#define AR_PHY_AIC_CTRL_1_B0	(AR_SM_BASE + 0x4b4)
#define AR_PHY_AIC_CTRL_2_B0	(AR_SM_BASE + 0x4b8)
#define AR_PHY_AIC_CTRL_3_B0	(AR_SM_BASE + 0x4bc)
#define AR_PHY_AIC_STAT_0_B0	(AR_SM_BASE + 0x4c4))
#define AR_PHY_AIC_STAT_1_B0	(AR_SM_BASE + 0x4c8))
#define AR_PHY_AIC_CTRL_4_B0	(AR_SM_BASE + 0x4c0)
#define AR_PHY_AIC_STAT_2_B0	(AR_SM_BASE + 0x4cc)

#define AR_PHY_65NM_CH0_TXRF3       0x16048
#define AR_PHY_65NM_CH0_TXRF3_CAPDIV2G		0x0000001e
#define AR_PHY_65NM_CH0_TXRF3_CAPDIV2G_S	1

#define AR_PHY_65NM_CH0_SYNTH4      0x1608c
#define AR_PHY_SYNTH4_LONG_SHIFT_SELECT   ((AR_SREV_9462(ah) || AR_SREV_9565(ah)) ? 0x00000001 : 0x00000002)
#define AR_PHY_SYNTH4_LONG_SHIFT_SELECT_S ((AR_SREV_9462(ah) || AR_SREV_9565(ah)) ? 0 : 1)
#define AR_PHY_65NM_CH0_SYNTH7      0x16098
#define AR_PHY_65NM_CH0_BIAS1       0x160c0
#define AR_PHY_65NM_CH0_BIAS2       0x160c4
#define AR_PHY_65NM_CH0_BIAS4       0x160cc
#define AR_PHY_65NM_CH0_RXTX4       0x1610c
#define AR_PHY_65NM_CH1_RXTX4       0x1650c
#define AR_PHY_65NM_CH2_RXTX4       0x1690c

#define AR_CH0_TOP	(AR_SREV_9300(ah) ? 0x16288 : \
			 (((AR_SREV_9462(ah) || AR_SREV_9565(ah)) ? 0x1628c : 0x16280)))
#define AR_CH0_TOP_XPABIASLVL (AR_SREV_9550(ah) ? 0x3c0 : 0x300)
#define AR_CH0_TOP_XPABIASLVL_S (AR_SREV_9550(ah) ? 6 : 8)

#define AR_CH0_THERM	(AR_SREV_9300(ah) ? 0x16290 : \
				((AR_SREV_9485(ah) ? 0x1628c : 0x16294)))
#define AR_CH0_THERM_XPABIASLVL_MSB 0x3
#define AR_CH0_THERM_XPABIASLVL_MSB_S 0
#define AR_CH0_THERM_XPASHORT2GND 0x4
#define AR_CH0_THERM_XPASHORT2GND_S 2

#define AR_SWITCH_TABLE_COM_ALL (0xffff)
#define AR_SWITCH_TABLE_COM_ALL_S (0)
#define AR_SWITCH_TABLE_COM_AR9462_ALL (0xffffff)
#define AR_SWITCH_TABLE_COM_AR9462_ALL_S (0)
#define AR_SWITCH_TABLE_COM_AR9550_ALL (0xffffff)
#define AR_SWITCH_TABLE_COM_AR9550_ALL_S (0)
#define AR_SWITCH_TABLE_COM_SPDT (0x00f00000)
#define AR_SWITCH_TABLE_COM_SPDT_ALL (0x0000fff0)
#define AR_SWITCH_TABLE_COM_SPDT_ALL_S (4)

#define AR_SWITCH_TABLE_COM2_ALL (0xffffff)
#define AR_SWITCH_TABLE_COM2_ALL_S (0)

#define AR_SWITCH_TABLE_ALL (0xfff)
#define AR_SWITCH_TABLE_ALL_S (0)

#define AR_PHY_65NM_CH0_THERM       (AR_SREV_9300(ah) ? 0x16290 :\
				     ((AR_SREV_9462(ah) || AR_SREV_9565(ah)) ? 0x16294 : 0x1628c))

#define AR_PHY_65NM_CH0_THERM_LOCAL   0x80000000
#define AR_PHY_65NM_CH0_THERM_LOCAL_S 31
#define AR_PHY_65NM_CH0_THERM_START   0x20000000
#define AR_PHY_65NM_CH0_THERM_START_S 29
#define AR_PHY_65NM_CH0_THERM_SAR_ADC_OUT   0x0000ff00
#define AR_PHY_65NM_CH0_THERM_SAR_ADC_OUT_S 8

#define AR_CH0_TOP2		(AR_SREV_9300(ah) ? 0x1628c : \
					(AR_SREV_9462(ah) ? 0x16290 : 0x16284))
#define AR_CH0_TOP2_XPABIASLVL		0xf000
#define AR_CH0_TOP2_XPABIASLVL_S	12

#define AR_CH0_XTAL		(AR_SREV_9300(ah) ? 0x16294 : \
				 ((AR_SREV_9462(ah) || AR_SREV_9565(ah)) ? 0x16298 : 0x16290))
#define AR_CH0_XTAL_CAPINDAC	0x7f000000
#define AR_CH0_XTAL_CAPINDAC_S	24
#define AR_CH0_XTAL_CAPOUTDAC	0x00fe0000
#define AR_CH0_XTAL_CAPOUTDAC_S	17

#define AR_PHY_PMU1		((AR_SREV_9462(ah) || AR_SREV_9565(ah)) ? 0x16340 : 0x16c40)
#define AR_PHY_PMU1_PWD		0x1
#define AR_PHY_PMU1_PWD_S	0

#define AR_PHY_PMU2		((AR_SREV_9462(ah) || AR_SREV_9565(ah)) ? 0x16344 : 0x16c44)
#define AR_PHY_PMU2_PGM		0x00200000
#define AR_PHY_PMU2_PGM_S	21

#define AR_PHY_RX1DB_BIQUAD_LONG_SHIFT		0x00380000
#define AR_PHY_RX1DB_BIQUAD_LONG_SHIFT_S	19
#define AR_PHY_RX6DB_BIQUAD_LONG_SHIFT		0x00c00000
#define AR_PHY_RX6DB_BIQUAD_LONG_SHIFT_S	22
#define AR_PHY_LNAGAIN_LONG_SHIFT		0xe0000000
#define AR_PHY_LNAGAIN_LONG_SHIFT_S		29
#define AR_PHY_MXRGAIN_LONG_SHIFT		0x03000000
#define AR_PHY_MXRGAIN_LONG_SHIFT_S		24
#define AR_PHY_VGAGAIN_LONG_SHIFT		0x1c000000
#define AR_PHY_VGAGAIN_LONG_SHIFT_S		26
#define AR_PHY_SCFIR_GAIN_LONG_SHIFT		0x00000001
#define AR_PHY_SCFIR_GAIN_LONG_SHIFT_S		0
#define AR_PHY_MANRXGAIN_LONG_SHIFT		0x00000002
#define AR_PHY_MANRXGAIN_LONG_SHIFT_S		1

/*
 * SM Field Definitions
 */
#define AR_PHY_CL_CAL_ENABLE          0x00000002
#define AR_PHY_PARALLEL_CAL_ENABLE    0x00000001
#define AR_PHY_TPCRG1_PD_CAL_ENABLE   0x00400000
#define AR_PHY_TPCRG1_PD_CAL_ENABLE_S 22

#define AR_PHY_ADDAC_PARACTL_OFF_PWDADC 0x00008000

#define AR_PHY_FCAL20_CAP_STATUS_0    0x01f00000
#define AR_PHY_FCAL20_CAP_STATUS_0_S  20

#define AR_PHY_RFBUS_REQ_EN     0x00000001  /* request for RF bus */
#define AR_PHY_RFBUS_GRANT_EN   0x00000001  /* RF bus granted */
#define AR_PHY_GC_TURBO_MODE       0x00000001  /* set turbo mode bits */
#define AR_PHY_GC_TURBO_SHORT      0x00000002  /* set short symbols to turbo mode setting */
#define AR_PHY_GC_DYN2040_EN       0x00000004  /* enable dyn 20/40 mode */
#define AR_PHY_GC_DYN2040_PRI_ONLY 0x00000008  /* dyn 20/40 - primary only */
#define AR_PHY_GC_DYN2040_PRI_CH   0x00000010  /* dyn 20/40 - primary ch offset (0=+10MHz, 1=-10MHz)*/
#define AR_PHY_GC_DYN2040_PRI_CH_S 4
#define AR_PHY_GC_DYN2040_EXT_CH   0x00000020  /* dyn 20/40 - ext ch spacing (0=20MHz/ 1=25MHz) */
#define AR_PHY_GC_HT_EN            0x00000040  /* ht enable */
#define AR_PHY_GC_SHORT_GI_40      0x00000080  /* allow short GI for HT 40 */
#define AR_PHY_GC_WALSH            0x00000100  /* walsh spatial spreading for 2 chains,2 streams TX */
#define AR_PHY_GC_SINGLE_HT_LTF1   0x00000200  /* single length (4us) 1st HT long training symbol */
#define AR_PHY_GC_GF_DETECT_EN     0x00000400  /* enable Green Field detection. Only affects rx, not tx */
#define AR_PHY_GC_ENABLE_DAC_FIFO  0x00000800  /* fifo between bb and dac */
#define AR_PHY_RX_DELAY_DELAY      0x00003FFF  /* delay from wakeup to rx ena */

#define AR_PHY_CALMODE_IQ           0x00000000
#define AR_PHY_CALMODE_ADC_GAIN     0x00000001
#define AR_PHY_CALMODE_ADC_DC_PER   0x00000002
#define AR_PHY_CALMODE_ADC_DC_INIT  0x00000003
#define AR_PHY_SWAP_ALT_CHAIN       0x00000040
#define AR_PHY_MODE_OFDM            0x00000000
#define AR_PHY_MODE_CCK             0x00000001
#define AR_PHY_MODE_DYNAMIC         0x00000004
#define AR_PHY_MODE_DYNAMIC_S       2
#define AR_PHY_MODE_HALF            0x00000020
#define AR_PHY_MODE_QUARTER         0x00000040
#define AR_PHY_MAC_CLK_MODE         0x00000080
#define AR_PHY_MODE_DYN_CCK_DISABLE 0x00000100
#define AR_PHY_MODE_SVD_HALF        0x00000200
#define AR_PHY_ACTIVE_EN    0x00000001
#define AR_PHY_ACTIVE_DIS   0x00000000
#define AR_PHY_FORCE_XPA_CFG    0x000000001
#define AR_PHY_FORCE_XPA_CFG_S  0
#define AR_PHY_XPA_TIMING_CTL_TX_END_XPAB_OFF    0xFF000000
#define AR_PHY_XPA_TIMING_CTL_TX_END_XPAB_OFF_S  24
#define AR_PHY_XPA_TIMING_CTL_TX_END_XPAA_OFF    0x00FF0000
#define AR_PHY_XPA_TIMING_CTL_TX_END_XPAA_OFF_S  16
#define AR_PHY_XPA_TIMING_CTL_FRAME_XPAB_ON      0x0000FF00
#define AR_PHY_XPA_TIMING_CTL_FRAME_XPAB_ON_S    8
#define AR_PHY_XPA_TIMING_CTL_FRAME_XPAA_ON      0x000000FF
#define AR_PHY_XPA_TIMING_CTL_FRAME_XPAA_ON_S    0
#define AR_PHY_TX_END_TO_A2_RX_ON       0x00FF0000
#define AR_PHY_TX_END_TO_A2_RX_ON_S     16
#define AR_PHY_TX_END_DATA_START  0x000000FF
#define AR_PHY_TX_END_DATA_START_S  0
#define AR_PHY_TX_END_PA_ON       0x0000FF00
#define AR_PHY_TX_END_PA_ON_S       8
#define AR_PHY_TPCRG5_PD_GAIN_OVERLAP   0x0000000F
#define AR_PHY_TPCRG5_PD_GAIN_OVERLAP_S     0
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_1    0x000003F0
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_1_S  4
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_2    0x0000FC00
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_2_S  10
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_3    0x003F0000
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_3_S  16
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_4    0x0FC00000
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_4_S  22
#define AR_PHY_TPCRG1_NUM_PD_GAIN   0x0000c000
#define AR_PHY_TPCRG1_NUM_PD_GAIN_S 14
#define AR_PHY_TPCRG1_PD_GAIN_1    0x00030000
#define AR_PHY_TPCRG1_PD_GAIN_1_S  16
#define AR_PHY_TPCRG1_PD_GAIN_2    0x000C0000
#define AR_PHY_TPCRG1_PD_GAIN_2_S  18
#define AR_PHY_TPCRG1_PD_GAIN_3    0x00300000
#define AR_PHY_TPCRG1_PD_GAIN_3_S  20
#define AR_PHY_TPCGR1_FORCED_DAC_GAIN   0x0000003e
#define AR_PHY_TPCGR1_FORCED_DAC_GAIN_S 1
#define AR_PHY_TPCGR1_FORCE_DAC_GAIN    0x00000001
#define AR_PHY_TXGAIN_FORCE               0x00000001
#define AR_PHY_TXGAIN_FORCE_S		  0
#define AR_PHY_TXGAIN_FORCED_PADVGNRA     0x00003c00
#define AR_PHY_TXGAIN_FORCED_PADVGNRA_S   10
#define AR_PHY_TXGAIN_FORCED_PADVGNRB     0x0003c000
#define AR_PHY_TXGAIN_FORCED_PADVGNRB_S   14
#define AR_PHY_TXGAIN_FORCED_PADVGNRD     0x00c00000
#define AR_PHY_TXGAIN_FORCED_PADVGNRD_S   22
#define AR_PHY_TXGAIN_FORCED_TXMXRGAIN    0x000003c0
#define AR_PHY_TXGAIN_FORCED_TXMXRGAIN_S  6
#define AR_PHY_TXGAIN_FORCED_TXBB1DBGAIN  0x0000000e
#define AR_PHY_TXGAIN_FORCED_TXBB1DBGAIN_S 1

#define AR_PHY_POWER_TX_RATE1   0x9934
#define AR_PHY_POWER_TX_RATE2   0x9938
#define AR_PHY_POWER_TX_RATE_MAX    0x993c
#define AR_PHY_POWER_TX_RATE_MAX_TPC_ENABLE 0x00000040
#define PHY_AGC_CLR             0x10000000
#define RFSILENT_BB             0x00002000
#define AR_PHY_CHAN_INFO_GAIN_DIFF_PPM_MASK          0xFFF
#define AR_PHY_CHAN_INFO_GAIN_DIFF_PPM_SIGNED_BIT    0x800
#define AR_PHY_CHAN_INFO_GAIN_DIFF_UPPER_LIMIT         320
#define AR_PHY_CHAN_INFO_MEMORY_CAPTURE_MASK         0x0001
#define AR_PHY_RX_DELAY_DELAY   0x00003FFF
#define AR_PHY_CCK_TX_CTRL_JAPAN    0x00000010

#define AR_PHY_SPECTRAL_SCAN_ENABLE           0x00000001
#define AR_PHY_SPECTRAL_SCAN_ENABLE_S         0
#define AR_PHY_SPECTRAL_SCAN_ACTIVE           0x00000002
#define AR_PHY_SPECTRAL_SCAN_ACTIVE_S         1
#define AR_PHY_SPECTRAL_SCAN_FFT_PERIOD       0x000000F0
#define AR_PHY_SPECTRAL_SCAN_FFT_PERIOD_S     4
#define AR_PHY_SPECTRAL_SCAN_PERIOD           0x0000FF00
#define AR_PHY_SPECTRAL_SCAN_PERIOD_S         8
#define AR_PHY_SPECTRAL_SCAN_COUNT            0x0FFF0000
#define AR_PHY_SPECTRAL_SCAN_COUNT_S          16
#define AR_PHY_SPECTRAL_SCAN_SHORT_REPEAT     0x10000000
#define AR_PHY_SPECTRAL_SCAN_SHORT_REPEAT_S   28
#define AR_PHY_SPECTRAL_SCAN_PRIORITY         0x20000000
#define AR_PHY_SPECTRAL_SCAN_PRIORITY_S       29
#define AR_PHY_SPECTRAL_SCAN_USE_ERR5         0x40000000
#define AR_PHY_SPECTRAL_SCAN_USE_ERR5_S       30
#define AR_PHY_SPECTRAL_SCAN_COMPRESSED_RPT   0x80000000
#define AR_PHY_SPECTRAL_SCAN_COMPRESSED_RPT_S 31

#define AR_PHY_CHANNEL_STATUS_RX_CLEAR      0x00000004
#define AR_PHY_RTT_CTRL_ENA_RADIO_RETENTION     0x00000001
#define AR_PHY_RTT_CTRL_ENA_RADIO_RETENTION_S   0
#define AR_PHY_RTT_CTRL_RESTORE_MASK            0x0000007E
#define AR_PHY_RTT_CTRL_RESTORE_MASK_S          1
#define AR_PHY_RTT_CTRL_FORCE_RADIO_RESTORE     0x00000080
#define AR_PHY_RTT_CTRL_FORCE_RADIO_RESTORE_S   7
#define AR_PHY_RTT_SW_RTT_TABLE_ACCESS          0x00000001
#define AR_PHY_RTT_SW_RTT_TABLE_ACCESS_S        0
#define AR_PHY_RTT_SW_RTT_TABLE_WRITE           0x00000002
#define AR_PHY_RTT_SW_RTT_TABLE_WRITE_S         1
#define AR_PHY_RTT_SW_RTT_TABLE_ADDR            0x0000001C
#define AR_PHY_RTT_SW_RTT_TABLE_ADDR_S          2
#define AR_PHY_RTT_SW_RTT_TABLE_DATA            0xFFFFFFF0
#define AR_PHY_RTT_SW_RTT_TABLE_DATA_S          4
#define AR_PHY_TX_IQCAL_CONTROL_0_ENABLE_TXIQ_CAL                   0x80000000
#define AR_PHY_TX_IQCAL_CONTROL_0_ENABLE_TXIQ_CAL_S                         31
#define AR_PHY_TX_IQCAL_CONTROL_1_IQCORR_I_Q_COFF_DELPT             0x01fc0000
#define AR_PHY_TX_IQCAL_CONTROL_1_IQCORR_I_Q_COFF_DELPT_S                   18
#define AR_PHY_TX_IQCAL_START_DO_CAL	    0x00000001
#define AR_PHY_TX_IQCAL_START_DO_CAL_S	    0

#define AR_PHY_TX_IQCAL_STATUS_FAILED    0x00000001
#define AR_PHY_CALIBRATED_GAINS_0	 0x3e
#define AR_PHY_CALIBRATED_GAINS_0_S	 1

#define AR_PHY_TX_IQCAL_CORR_COEFF_00_COEFF_TABLE      0x00003fff
#define AR_PHY_TX_IQCAL_CORR_COEFF_00_COEFF_TABLE_S    0
#define AR_PHY_TX_IQCAL_CORR_COEFF_01_COEFF_TABLE      0x0fffc000
#define AR_PHY_TX_IQCAL_CORR_COEFF_01_COEFF_TABLE_S    14

#define AR_PHY_65NM_CH0_RXTX4_THERM_ON          0x10000000
#define AR_PHY_65NM_CH0_RXTX4_THERM_ON_S        28
#define AR_PHY_65NM_CH0_RXTX4_THERM_ON_OVR      0x20000000
#define AR_PHY_65NM_CH0_RXTX4_THERM_ON_OVR_S    29

#define AR_PHY_65NM_RXTX4_XLNA_BIAS		0xC0000000
#define AR_PHY_65NM_RXTX4_XLNA_BIAS_S		30

/*
 * Channel 1 Register Map
 */
#define AR_CHAN1_BASE	0xa800

#define AR_PHY_EXT_CCA_1            (AR_CHAN1_BASE + 0x30)
#define AR_PHY_TX_PHASE_RAMP_1      (AR_CHAN1_BASE + 0xd0)
#define AR_PHY_ADC_GAIN_DC_CORR_1   (AR_CHAN1_BASE + 0xd4)

#define AR_PHY_SPUR_REPORT_1        (AR_CHAN1_BASE + 0xa8)
#define AR_PHY_CHAN_INFO_TAB_1      (AR_CHAN1_BASE + 0x300)
#define AR_PHY_RX_IQCAL_CORR_B1     (AR_CHAN1_BASE + 0xdc)

/*
 * Channel 1 Field Definitions
 */
#define AR_PHY_CH1_EXT_MINCCA_PWR   0x01FF0000
#define AR_PHY_CH1_EXT_MINCCA_PWR_S 16

/*
 * AGC 1 Register Map
 */
#define AR_AGC1_BASE	0xae00

#define AR_PHY_FORCEMAX_GAINS_1      (AR_AGC1_BASE + 0x4)
#define AR_PHY_EXT_ATTEN_CTL_1       (AR_AGC1_BASE + 0x18)
#define AR_PHY_CCA_1                 (AR_AGC1_BASE + 0x1c)
#define AR_PHY_CCA_CTRL_1            (AR_AGC1_BASE + 0x20)
#define AR_PHY_RSSI_1                (AR_AGC1_BASE + 0x180)
#define AR_PHY_SPUR_CCK_REP_1        (AR_AGC1_BASE + 0x184)
#define AR_PHY_RX_OCGAIN_2           (AR_AGC1_BASE + 0x200)

/*
 * AGC 1 Field Definitions
 */
#define AR_PHY_CH1_MINCCA_PWR   0x1FF00000
#define AR_PHY_CH1_MINCCA_PWR_S 20

/*
 * SM 1 Register Map
 */
#define AR_SM1_BASE	0xb200

#define AR_PHY_SWITCH_CHAIN_1   (AR_SM1_BASE + 0x84)
#define AR_PHY_FCAL_2_1         (AR_SM1_BASE + 0xd0)
#define AR_PHY_DFT_TONE_CTL_1   (AR_SM1_BASE + 0xd4)
#define AR_PHY_CL_TAB_1         (AR_SM1_BASE + 0x100)
#define AR_PHY_CHAN_INFO_GAIN_1 (AR_SM1_BASE + 0x180)
#define AR_PHY_TPC_4_B1         (AR_SM1_BASE + 0x204)
#define AR_PHY_TPC_5_B1         (AR_SM1_BASE + 0x208)
#define AR_PHY_TPC_6_B1         (AR_SM1_BASE + 0x20c)
#define AR_PHY_TPC_11_B1        (AR_SM1_BASE + 0x220)
#define AR_PHY_PDADC_TAB_1	(AR_SM1_BASE + (AR_SREV_9462_20_OR_LATER(ah) ? \
					0x280 : 0x240))
#define AR_PHY_TPC_19_B1	(AR_SM1_BASE + 0x240)
#define AR_PHY_TPC_19_B1_ALPHA_THERM		0xff
#define AR_PHY_TPC_19_B1_ALPHA_THERM_S		0
#define AR_PHY_TX_IQCAL_STATUS_B1   (AR_SM1_BASE + 0x48c)
#define AR_PHY_TX_IQCAL_CORR_COEFF_B1(_i)    (AR_SM1_BASE + 0x450 + ((_i) << 2))

/* SM 1 AIC Registers */

#define AR_PHY_AIC_CTRL_0_B1	(AR_SM1_BASE + 0x4b0)
#define AR_PHY_AIC_CTRL_1_B1	(AR_SM1_BASE + 0x4b4)
#define AR_PHY_AIC_CTRL_2_B1	(AR_SM1_BASE + 0x4b8)
#define AR_PHY_AIC_STAT_0_B1	(AR_SM1_BASE + (AR_SREV_9462_10(ah) ? \
					0x4c0 : 0x4c4))
#define AR_PHY_AIC_STAT_1_B1	(AR_SM1_BASE + (AR_SREV_9462_10(ah) ? \
					0x4c4 : 0x4c8))
#define AR_PHY_AIC_CTRL_4_B1	(AR_SM1_BASE + 0x4c0)
#define AR_PHY_AIC_STAT_2_B1	(AR_SM1_BASE + 0x4cc)

#define AR_PHY_AIC_SRAM_ADDR_B1	(AR_SM1_BASE + 0x5f0)
#define AR_PHY_AIC_SRAM_DATA_B1	(AR_SM1_BASE + 0x5f4)

#define AR_PHY_RTT_TABLE_SW_INTF_B(i)	(0x384 + ((i) ? \
					AR_SM1_BASE : AR_SM_BASE))
#define AR_PHY_RTT_TABLE_SW_INTF_1_B(i)	(0x388 + ((i) ? \
					AR_SM1_BASE : AR_SM_BASE))
/*
 * Channel 2 Register Map
 */
#define AR_CHAN2_BASE	0xb800

#define AR_PHY_EXT_CCA_2            (AR_CHAN2_BASE + 0x30)
#define AR_PHY_TX_PHASE_RAMP_2      (AR_CHAN2_BASE + 0xd0)
#define AR_PHY_ADC_GAIN_DC_CORR_2   (AR_CHAN2_BASE + 0xd4)

#define AR_PHY_SPUR_REPORT_2        (AR_CHAN2_BASE + 0xa8)
#define AR_PHY_CHAN_INFO_TAB_2      (AR_CHAN2_BASE + 0x300)
#define AR_PHY_RX_IQCAL_CORR_B2     (AR_CHAN2_BASE + 0xdc)

/*
 * Channel 2 Field Definitions
 */
#define AR_PHY_CH2_EXT_MINCCA_PWR   0x01FF0000
#define AR_PHY_CH2_EXT_MINCCA_PWR_S 16
/*
 * AGC 2 Register Map
 */
#define AR_AGC2_BASE	0xbe00

#define AR_PHY_FORCEMAX_GAINS_2      (AR_AGC2_BASE + 0x4)
#define AR_PHY_EXT_ATTEN_CTL_2       (AR_AGC2_BASE + 0x18)
#define AR_PHY_CCA_2                 (AR_AGC2_BASE + 0x1c)
#define AR_PHY_CCA_CTRL_2            (AR_AGC2_BASE + 0x20)
#define AR_PHY_RSSI_2                (AR_AGC2_BASE + 0x180)

/*
 * AGC 2 Field Definitions
 */
#define AR_PHY_CH2_MINCCA_PWR   0x1FF00000
#define AR_PHY_CH2_MINCCA_PWR_S 20

/*
 * SM 2 Register Map
 */
#define AR_SM2_BASE	0xc200

#define AR_PHY_SWITCH_CHAIN_2    (AR_SM2_BASE + 0x84)
#define AR_PHY_FCAL_2_2          (AR_SM2_BASE + 0xd0)
#define AR_PHY_DFT_TONE_CTL_2    (AR_SM2_BASE + 0xd4)
#define AR_PHY_CL_TAB_2          (AR_SM2_BASE + 0x100)
#define AR_PHY_CHAN_INFO_GAIN_2  (AR_SM2_BASE + 0x180)
#define AR_PHY_TPC_4_B2          (AR_SM2_BASE + 0x204)
#define AR_PHY_TPC_5_B2          (AR_SM2_BASE + 0x208)
#define AR_PHY_TPC_6_B2          (AR_SM2_BASE + 0x20c)
#define AR_PHY_TPC_11_B2         (AR_SM2_BASE + 0x220)
#define AR_PHY_TPC_19_B2         (AR_SM2_BASE + 0x240)
#define AR_PHY_TX_IQCAL_STATUS_B2   (AR_SM2_BASE + 0x48c)
#define AR_PHY_TX_IQCAL_CORR_COEFF_B2(_i)    (AR_SM2_BASE + 0x450 + ((_i) << 2))

#define AR_PHY_TX_IQCAL_STATUS_B2_FAILED    0x00000001

/*
 * AGC 3 Register Map
 */
#define AR_AGC3_BASE	0xce00

#define AR_PHY_RSSI_3            (AR_AGC3_BASE + 0x180)

/* GLB Registers */
#define AR_GLB_BASE	0x20000
#define AR_GLB_GPIO_CONTROL	(AR_GLB_BASE)
#define AR_PHY_GLB_CONTROL	(AR_GLB_BASE + 0x44)
#define AR_GLB_SCRATCH(_ah)	(AR_GLB_BASE + \
					(AR_SREV_9462_20_OR_LATER(_ah) ? 0x4c : 0x50))
#define AR_GLB_STATUS		(AR_GLB_BASE + 0x48)

/*
 * Misc helper defines
 */
#define AR_PHY_CHAIN_OFFSET     (AR_CHAN1_BASE - AR_CHAN_BASE)

#define AR_PHY_NEW_ADC_DC_GAIN_CORR(_i) (AR_PHY_ADC_GAIN_DC_CORR_0 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_NEW_ADC_DC_GAIN_CORR_9300_10(_i) (AR_PHY_ADC_GAIN_DC_CORR_0_9300_10 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_SWITCH_CHAIN(_i)     (AR_PHY_SWITCH_CHAIN_0 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_EXT_ATTEN_CTL(_i)    (AR_PHY_EXT_ATTEN_CTL_0 + (AR_PHY_CHAIN_OFFSET * (_i)))

#define AR_PHY_RXGAIN(_i)           (AR_PHY_FORCEMAX_GAINS_0 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_TPCRG5(_i)           (AR_PHY_TPC_5_B0 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_PDADC_TAB(_i)        (AR_PHY_PDADC_TAB_0 + (AR_PHY_CHAIN_OFFSET * (_i)))

#define AR_PHY_CAL_MEAS_0(_i)       (AR_PHY_IQ_ADC_MEAS_0_B0 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_CAL_MEAS_1(_i)       (AR_PHY_IQ_ADC_MEAS_1_B0 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_CAL_MEAS_2(_i)       (AR_PHY_IQ_ADC_MEAS_2_B0 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_CAL_MEAS_3(_i)       (AR_PHY_IQ_ADC_MEAS_3_B0 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_CAL_MEAS_0_9300_10(_i) (AR_PHY_IQ_ADC_MEAS_0_B0_9300_10 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_CAL_MEAS_1_9300_10(_i) (AR_PHY_IQ_ADC_MEAS_1_B0_9300_10 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_CAL_MEAS_2_9300_10(_i) (AR_PHY_IQ_ADC_MEAS_2_B0_9300_10 + (AR_PHY_CHAIN_OFFSET * (_i)))
#define AR_PHY_CAL_MEAS_3_9300_10(_i) (AR_PHY_IQ_ADC_MEAS_3_B0_9300_10 + (AR_PHY_CHAIN_OFFSET * (_i)))

#define AR_PHY_WATCHDOG_NON_IDLE_ENABLE    0x00000001
#define AR_PHY_WATCHDOG_IDLE_ENABLE        0x00000002
#define AR_PHY_WATCHDOG_IDLE_MASK          0xFFFF0000
#define AR_PHY_WATCHDOG_NON_IDLE_MASK      0x0000FFFC

#define AR_PHY_WATCHDOG_RST_ENABLE         0x00000002
#define AR_PHY_WATCHDOG_IRQ_ENABLE         0x00000004
#define AR_PHY_WATCHDOG_CNTL2_MASK         0xFFFFFFF9

#define AR_PHY_WATCHDOG_INFO               0x00000007
#define AR_PHY_WATCHDOG_INFO_S             0
#define AR_PHY_WATCHDOG_DET_HANG           0x00000008
#define AR_PHY_WATCHDOG_DET_HANG_S         3
#define AR_PHY_WATCHDOG_RADAR_SM           0x000000F0
#define AR_PHY_WATCHDOG_RADAR_SM_S         4
#define AR_PHY_WATCHDOG_RX_OFDM_SM         0x00000F00
#define AR_PHY_WATCHDOG_RX_OFDM_SM_S       8
#define AR_PHY_WATCHDOG_RX_CCK_SM          0x0000F000
#define AR_PHY_WATCHDOG_RX_CCK_SM_S        12
#define AR_PHY_WATCHDOG_TX_OFDM_SM         0x000F0000
#define AR_PHY_WATCHDOG_TX_OFDM_SM_S       16
#define AR_PHY_WATCHDOG_TX_CCK_SM          0x00F00000
#define AR_PHY_WATCHDOG_TX_CCK_SM_S        20
#define AR_PHY_WATCHDOG_AGC_SM             0x0F000000
#define AR_PHY_WATCHDOG_AGC_SM_S           24
#define AR_PHY_WATCHDOG_SRCH_SM            0xF0000000
#define AR_PHY_WATCHDOG_SRCH_SM_S          28

#define AR_PHY_WATCHDOG_STATUS_CLR         0x00000008

/*
 * PAPRD registers
 */
#define AR_PHY_XPA_TIMING_CTL		(AR_SM_BASE + 0x64)

#define AR_PHY_PAPRD_AM2AM		(AR_CHAN_BASE + 0xe4)
#define AR_PHY_PAPRD_AM2AM_MASK		0x01ffffff
#define AR_PHY_PAPRD_AM2AM_MASK_S	0

#define AR_PHY_PAPRD_AM2PM		(AR_CHAN_BASE + 0xe8)
#define AR_PHY_PAPRD_AM2PM_MASK		0x01ffffff
#define AR_PHY_PAPRD_AM2PM_MASK_S	0

#define AR_PHY_PAPRD_HT40		(AR_CHAN_BASE + 0xec)
#define AR_PHY_PAPRD_HT40_MASK		0x01ffffff
#define AR_PHY_PAPRD_HT40_MASK_S	0

#define AR_PHY_PAPRD_CTRL0_B0				(AR_CHAN_BASE + 0xf0)
#define AR_PHY_PAPRD_CTRL0_B1				(AR_CHAN1_BASE + 0xf0)
#define AR_PHY_PAPRD_CTRL0_B2				(AR_CHAN2_BASE + 0xf0)
#define AR_PHY_PAPRD_CTRL0_PAPRD_ENABLE			0x00000001
#define AR_PHY_PAPRD_CTRL0_PAPRD_ENABLE_S		0
#define AR_PHY_PAPRD_CTRL0_USE_SINGLE_TABLE_MASK	0x00000002
#define AR_PHY_PAPRD_CTRL0_USE_SINGLE_TABLE_MASK_S	1
#define AR_PHY_PAPRD_CTRL0_PAPRD_MAG_THRSH		0xf8000000
#define AR_PHY_PAPRD_CTRL0_PAPRD_MAG_THRSH_S		27

#define AR_PHY_PAPRD_CTRL1_B0				(AR_CHAN_BASE + 0xf4)
#define AR_PHY_PAPRD_CTRL1_B1				(AR_CHAN1_BASE + 0xf4)
#define AR_PHY_PAPRD_CTRL1_B2				(AR_CHAN2_BASE + 0xf4)
#define AR_PHY_PAPRD_CTRL1_ADAPTIVE_SCALING_ENA		0x00000001
#define AR_PHY_PAPRD_CTRL1_ADAPTIVE_SCALING_ENA_S	0
#define AR_PHY_PAPRD_CTRL1_ADAPTIVE_AM2AM_ENABLE	0x00000002
#define AR_PHY_PAPRD_CTRL1_ADAPTIVE_AM2AM_ENABLE_S	1
#define AR_PHY_PAPRD_CTRL1_ADAPTIVE_AM2PM_ENABLE	0x00000004
#define AR_PHY_PAPRD_CTRL1_ADAPTIVE_AM2PM_ENABLE_S	2
#define AR_PHY_PAPRD_CTRL1_PAPRD_POWER_AT_AM2AM_CAL	0x000001f8
#define AR_PHY_PAPRD_CTRL1_PAPRD_POWER_AT_AM2AM_CAL_S	3
#define AR_PHY_PAPRD_CTRL1_PA_GAIN_SCALE_FACT_MASK	0x0001fe00
#define AR_PHY_PAPRD_CTRL1_PA_GAIN_SCALE_FACT_MASK_S	9
#define AR_PHY_PAPRD_CTRL1_PAPRD_MAG_SCALE_FACT		0x0ffe0000
#define AR_PHY_PAPRD_CTRL1_PAPRD_MAG_SCALE_FACT_S	17

#define AR_PHY_PAPRD_TRAINER_CNTL1 (AR_SM_BASE + (AR_SREV_9485(ah) ? 0x580 : 0x490))

#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_CF_PAPRD_TRAIN_ENABLE	0x00000001
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_CF_PAPRD_TRAIN_ENABLE_S	0
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_AGC2_SETTLING	0x0000007e
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_AGC2_SETTLING_S	1
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_IQCORR_ENABLE	0x00000100
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_IQCORR_ENABLE_S	8
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_RX_BB_GAIN_FORCE	0x00000200
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_RX_BB_GAIN_FORCE_S	9
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_TX_GAIN_FORCE	0x00000400
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_TX_GAIN_FORCE_S	10
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_LB_ENABLE		0x00000800
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_LB_ENABLE_S		11
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_LB_SKIP		0x0003f000
#define AR_PHY_PAPRD_TRAINER_CNTL1_CF_PAPRD_LB_SKIP_S		12

#define AR_PHY_PAPRD_TRAINER_CNTL2 (AR_SM_BASE + (AR_SREV_9485(ah) ? 0x584 : 0x494))

#define AR_PHY_PAPRD_TRAINER_CNTL2_CF_PAPRD_INIT_RX_BB_GAIN	0xFFFFFFFF
#define AR_PHY_PAPRD_TRAINER_CNTL2_CF_PAPRD_INIT_RX_BB_GAIN_S	0

#define AR_PHY_PAPRD_TRAINER_CNTL3 (AR_SM_BASE + (AR_SREV_9485(ah) ? 0x588 : 0x498))

#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_ADC_DESIRED_SIZE	0x0000003f
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_ADC_DESIRED_SIZE_S	0
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_QUICK_DROP		0x00000fc0
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_QUICK_DROP_S	6
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_MIN_LOOPBACK_DEL	0x0001f000
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_MIN_LOOPBACK_DEL_S	12
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_NUM_CORR_STAGES	0x000e0000
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_NUM_CORR_STAGES_S	17
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_COARSE_CORR_LEN	0x00f00000
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_COARSE_CORR_LEN_S	20
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_FINE_CORR_LEN	0x0f000000
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_FINE_CORR_LEN_S	24
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_BBTXMIX_DISABLE	0x20000000
#define AR_PHY_PAPRD_TRAINER_CNTL3_CF_PAPRD_BBTXMIX_DISABLE_S	29

#define AR_PHY_PAPRD_TRAINER_CNTL4 (AR_SM_BASE + (AR_SREV_9485(ah) ? 0x58c : 0x49c))

#define AR_PHY_PAPRD_TRAINER_CNTL4_CF_PAPRD_NUM_TRAIN_SAMPLES	0x03ff0000
#define AR_PHY_PAPRD_TRAINER_CNTL4_CF_PAPRD_NUM_TRAIN_SAMPLES_S	16
#define AR_PHY_PAPRD_TRAINER_CNTL4_CF_PAPRD_SAFETY_DELTA	0x0000f000
#define AR_PHY_PAPRD_TRAINER_CNTL4_CF_PAPRD_SAFETY_DELTA_S	12
#define AR_PHY_PAPRD_TRAINER_CNTL4_CF_PAPRD_MIN_CORR		0x00000fff
#define AR_PHY_PAPRD_TRAINER_CNTL4_CF_PAPRD_MIN_CORR_S		0

#define AR_PHY_PAPRD_PRE_POST_SCALE_0_B0			(AR_CHAN_BASE + 0x100)
#define AR_PHY_PAPRD_PRE_POST_SCALE_1_B0			(AR_CHAN_BASE + 0x104)
#define AR_PHY_PAPRD_PRE_POST_SCALE_2_B0			(AR_CHAN_BASE + 0x108)
#define AR_PHY_PAPRD_PRE_POST_SCALE_3_B0			(AR_CHAN_BASE + 0x10c)
#define AR_PHY_PAPRD_PRE_POST_SCALE_4_B0			(AR_CHAN_BASE + 0x110)
#define AR_PHY_PAPRD_PRE_POST_SCALE_5_B0			(AR_CHAN_BASE + 0x114)
#define AR_PHY_PAPRD_PRE_POST_SCALE_6_B0			(AR_CHAN_BASE + 0x118)
#define AR_PHY_PAPRD_PRE_POST_SCALE_7_B0			(AR_CHAN_BASE + 0x11c)
#define AR_PHY_PAPRD_PRE_POST_SCALING				0x3FFFF
#define AR_PHY_PAPRD_PRE_POST_SCALING_S				0

#define AR_PHY_PAPRD_TRAINER_STAT1 (AR_SM_BASE + (AR_SREV_9485(ah) ? 0x590 : 0x4a0))

#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_TRAIN_DONE		0x00000001
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_TRAIN_DONE_S		0
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_TRAIN_INCOMPLETE	0x00000002
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_TRAIN_INCOMPLETE_S	1
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_CORR_ERR		0x00000004
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_CORR_ERR_S		2
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_TRAIN_ACTIVE		0x00000008
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_TRAIN_ACTIVE_S		3
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_RX_GAIN_IDX		0x000001f0
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_RX_GAIN_IDX_S		4
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_AGC2_PWR		0x0001fe00
#define AR_PHY_PAPRD_TRAINER_STAT1_PAPRD_AGC2_PWR_S		9

#define AR_PHY_PAPRD_TRAINER_STAT2 (AR_SM_BASE + (AR_SREV_9485(ah) ? 0x594 : 0x4a4))

#define AR_PHY_PAPRD_TRAINER_STAT2_PAPRD_FINE_VAL		0x0000ffff
#define AR_PHY_PAPRD_TRAINER_STAT2_PAPRD_FINE_VAL_S		0
#define AR_PHY_PAPRD_TRAINER_STAT2_PAPRD_COARSE_IDX		0x001f0000
#define AR_PHY_PAPRD_TRAINER_STAT2_PAPRD_COARSE_IDX_S		16
#define AR_PHY_PAPRD_TRAINER_STAT2_PAPRD_FINE_IDX		0x00600000
#define AR_PHY_PAPRD_TRAINER_STAT2_PAPRD_FINE_IDX_S		21

#define AR_PHY_PAPRD_TRAINER_STAT3 (AR_SM_BASE + (AR_SREV_9485(ah) ? 0x598 : 0x4a8))

#define AR_PHY_PAPRD_TRAINER_STAT3_PAPRD_TRAIN_SAMPLES_CNT	0x000fffff
#define AR_PHY_PAPRD_TRAINER_STAT3_PAPRD_TRAIN_SAMPLES_CNT_S	0

#define AR_PHY_PAPRD_MEM_TAB_B0			(AR_CHAN_BASE + 0x120)
#define AR_PHY_PAPRD_MEM_TAB_B1			(AR_CHAN1_BASE + 0x120)
#define AR_PHY_PAPRD_MEM_TAB_B2			(AR_CHAN2_BASE + 0x120)

#define AR_PHY_PA_GAIN123_B0			(AR_CHAN_BASE + 0xf8)
#define AR_PHY_PA_GAIN123_B1			(AR_CHAN1_BASE + 0xf8)
#define AR_PHY_PA_GAIN123_B2			(AR_CHAN2_BASE + 0xf8)
#define AR_PHY_PA_GAIN123_PA_GAIN1		0x3FF
#define AR_PHY_PA_GAIN123_PA_GAIN1_S		0

#define AR_PHY_POWERTX_RATE5			(AR_SM_BASE + 0x1d0)
#define AR_PHY_POWERTX_RATE5_POWERTXHT20_0	0x3F
#define AR_PHY_POWERTX_RATE5_POWERTXHT20_0_S	0

#define AR_PHY_POWERTX_RATE6			(AR_SM_BASE + 0x1d4)
#define AR_PHY_POWERTX_RATE6_POWERTXHT20_5	0x3F00
#define AR_PHY_POWERTX_RATE6_POWERTXHT20_5_S	8

#define AR_PHY_POWERTX_RATE8			(AR_SM_BASE + 0x1dc)
#define AR_PHY_POWERTX_RATE8_POWERTXHT40_5	0x3F00
#define AR_PHY_POWERTX_RATE8_POWERTXHT40_5_S	8

#define AR_PHY_CL_TAB_CL_GAIN_MOD		0x1f
#define AR_PHY_CL_TAB_CL_GAIN_MOD_S		0

#define AR_BTCOEX_WL_LNADIV                                0x1a64
#define AR_BTCOEX_WL_LNADIV_PREDICTED_PERIOD               0x00003FFF
#define AR_BTCOEX_WL_LNADIV_PREDICTED_PERIOD_S             0
#define AR_BTCOEX_WL_LNADIV_DPDT_IGNORE_PRIORITY           0x00004000
#define AR_BTCOEX_WL_LNADIV_DPDT_IGNORE_PRIORITY_S         14
#define AR_BTCOEX_WL_LNADIV_FORCE_ON                       0x00008000
#define AR_BTCOEX_WL_LNADIV_FORCE_ON_S                     15
#define AR_BTCOEX_WL_LNADIV_MODE_OPTION                    0x00030000
#define AR_BTCOEX_WL_LNADIV_MODE_OPTION_S                  16
#define AR_BTCOEX_WL_LNADIV_MODE                           0x007c0000
#define AR_BTCOEX_WL_LNADIV_MODE_S                         18
#define AR_BTCOEX_WL_LNADIV_ALLOWED_TX_ANTDIV_WL_TX_REQ    0x00800000
#define AR_BTCOEX_WL_LNADIV_ALLOWED_TX_ANTDIV_WL_TX_REQ_S  23
#define AR_BTCOEX_WL_LNADIV_DISABLE_TX_ANTDIV_ENABLE       0x01000000
#define AR_BTCOEX_WL_LNADIV_DISABLE_TX_ANTDIV_ENABLE_S     24
#define AR_BTCOEX_WL_LNADIV_CONTINUOUS_BT_ACTIVE_PROTECT   0x02000000
#define AR_BTCOEX_WL_LNADIV_CONTINUOUS_BT_ACTIVE_PROTECT_S 25
#define AR_BTCOEX_WL_LNADIV_BT_INACTIVE_THRESHOLD          0xFC000000
#define AR_BTCOEX_WL_LNADIV_BT_INACTIVE_THRESHOLD_S        26

/* Manual Peak detector calibration */
#define AR_PHY_65NM_BASE                               0x16000
#define AR_PHY_65NM_RXRF_GAINSTAGES(i)                 (AR_PHY_65NM_BASE + \
							(i * 0x400) + 0x8)
#define AR_PHY_65NM_RXRF_GAINSTAGES_RX_OVERRIDE        0x80000000
#define AR_PHY_65NM_RXRF_GAINSTAGES_RX_OVERRIDE_S      31
#define AR_PHY_65NM_RXRF_GAINSTAGES_LNAON_CALDC        0x00000002
#define AR_PHY_65NM_RXRF_GAINSTAGES_LNAON_CALDC_S      1
#define AR_PHY_65NM_RXRF_GAINSTAGES_LNA2G_GAIN_OVR     0x70000000
#define AR_PHY_65NM_RXRF_GAINSTAGES_LNA2G_GAIN_OVR_S   28
#define AR_PHY_65NM_RXRF_GAINSTAGES_LNA5G_GAIN_OVR     0x03800000
#define AR_PHY_65NM_RXRF_GAINSTAGES_LNA5G_GAIN_OVR_S   23

#define AR_PHY_65NM_RXTX2(i)                           (AR_PHY_65NM_BASE + \
							(i * 0x400) + 0x104)
#define AR_PHY_65NM_RXTX2_RXON_OVR                     0x00001000
#define AR_PHY_65NM_RXTX2_RXON_OVR_S                   12
#define AR_PHY_65NM_RXTX2_RXON                         0x00000800
#define AR_PHY_65NM_RXTX2_RXON_S                       11

#define AR_PHY_65NM_RXRF_AGC(i)                        (AR_PHY_65NM_BASE + \
							(i * 0x400) + 0xc)
#define AR_PHY_65NM_RXRF_AGC_AGC_OVERRIDE              0x80000000
#define AR_PHY_65NM_RXRF_AGC_AGC_OVERRIDE_S            31
#define AR_PHY_65NM_RXRF_AGC_AGC_ON_OVR                0x40000000
#define AR_PHY_65NM_RXRF_AGC_AGC_ON_OVR_S              30
#define AR_PHY_65NM_RXRF_AGC_AGC_CAL_OVR               0x20000000
#define AR_PHY_65NM_RXRF_AGC_AGC_CAL_OVR_S             29
#define AR_PHY_65NM_RXRF_AGC_AGC2G_DBDAC_OVR           0x1E000000
#define AR_PHY_65NM_RXRF_AGC_AGC2G_DBDAC_OVR_S         25
#define AR_PHY_65NM_RXRF_AGC_AGC5G_DBDAC_OVR           0x00078000
#define AR_PHY_65NM_RXRF_AGC_AGC5G_DBDAC_OVR_S         15
#define AR_PHY_65NM_RXRF_AGC_AGC2G_CALDAC_OVR          0x01F80000
#define AR_PHY_65NM_RXRF_AGC_AGC2G_CALDAC_OVR_S        19
#define AR_PHY_65NM_RXRF_AGC_AGC5G_CALDAC_OVR          0x00007e00
#define AR_PHY_65NM_RXRF_AGC_AGC5G_CALDAC_OVR_S        9
#define AR_PHY_65NM_RXRF_AGC_AGC_OUT                   0x00000004
#define AR_PHY_65NM_RXRF_AGC_AGC_OUT_S                 2

#endif  /* AR9003_PHY_H */
