/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.strategy.partition;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.strategy.partition.SelectPartitionStrategy;
import org.apache.uniffle.coordinator.util.CoordinatorUtils;
import org.apache.uniffle.shaded.guava.collect.Lists;

public class ContinuousSelectPartitionStrategy
implements SelectPartitionStrategy {
    @Override
    public SortedMap<PartitionRange, List<ServerNode>> assign(int totalPartitionNum, int partitionNumPerRange, int replica, List<ServerNode> candidatesNodes, int estimateTaskConcurrency) {
        TreeMap<PartitionRange, List<ServerNode>> assignments = new TreeMap<PartitionRange, List<ServerNode>>();
        int serverNum = candidatesNodes.size();
        List<List<PartitionRange>> rangesGroup = CoordinatorUtils.generateRangesGroup(totalPartitionNum, partitionNumPerRange, serverNum, estimateTaskConcurrency);
        for (int rc = 0; rc < replica; ++rc) {
            for (int i = 0; i < rangesGroup.size(); ++i) {
                ServerNode node = candidatesNodes.get((i + rc) % serverNum);
                List<PartitionRange> ranges = rangesGroup.get(i);
                ranges.forEach(range -> {
                    List serverNodes = assignments.computeIfAbsent((PartitionRange)range, key -> Lists.newArrayList());
                    serverNodes.add(node);
                });
            }
        }
        return assignments;
    }
}

