/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.handle;

import org.apache.uniffle.common.netty.client.TransportClient;
import org.apache.uniffle.common.netty.handle.BaseMessageHandler;
import org.apache.uniffle.common.netty.handle.MessageHandler;
import org.apache.uniffle.common.netty.protocol.RequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportRequestHandler
extends MessageHandler<RequestMessage> {
    private static final Logger logger = LoggerFactory.getLogger(TransportRequestHandler.class);
    private final TransportClient reverseClient;
    private final BaseMessageHandler msgHandler;

    public TransportRequestHandler(TransportClient reverseClient, BaseMessageHandler msgHandler) {
        this.reverseClient = reverseClient;
        this.msgHandler = msgHandler;
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        this.msgHandler.exceptionCaught(cause, this.reverseClient);
    }

    @Override
    public void channelActive() {
        logger.debug("channelActive: {}", (Object)this.reverseClient.getSocketAddress());
    }

    @Override
    public void channelInactive() {
        logger.debug("channelInactive: {}", (Object)this.reverseClient.getSocketAddress());
    }

    @Override
    public void handle(RequestMessage request) {
        this.msgHandler.receive(this.reverseClient, request);
    }
}

