/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.coordinator.strategy.assignment.PartitionRangeAssignment;
import org.apache.uniffle.guava.collect.Lists;
import org.apache.uniffle.guava.collect.Maps;
import org.apache.uniffle.proto.RssProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorUtils.class);
    public static final String COORDINATOR_ID = "coordinator.id";

    public static RssProtos.GetShuffleAssignmentsResponse toGetShuffleAssignmentsResponse(PartitionRangeAssignment pra) {
        List<RssProtos.PartitionRangeAssignment> praList = pra.convertToGrpcProto();
        return RssProtos.GetShuffleAssignmentsResponse.newBuilder().addAllAssignments(praList).build();
    }

    public static int nextIdx(int idx, int size) {
        if (++idx >= size) {
            idx = 0;
        }
        return idx;
    }

    public static List<List<PartitionRange>> generateRangesGroup(int totalPartitionNum, int partitionNumPerRange, int serverNum, int estimateTaskConcurrency) {
        ArrayList<List<PartitionRange>> res = Lists.newArrayList();
        if (totalPartitionNum <= 0 || partitionNumPerRange <= 0) {
            return res;
        }
        int rangePerGroup = (estimateTaskConcurrency = Math.min(totalPartitionNum, estimateTaskConcurrency)) > serverNum * partitionNumPerRange ? Math.floorDiv(estimateTaskConcurrency, serverNum * partitionNumPerRange) : 1;
        int totalRanges = (int)Math.ceil((double)totalPartitionNum * 1.0 / (double)partitionNumPerRange);
        int groupCount = 0;
        int round = Math.floorDiv(totalRanges, rangePerGroup * serverNum);
        int remainRange = totalRanges % (rangePerGroup * serverNum);
        int lastRoundRangePerGroup = Math.floorDiv(remainRange, serverNum);
        int lastRoundRemainRange = remainRange % serverNum;
        int rangeInGroupCount = 0;
        ArrayList<PartitionRange> rangeGroup = Lists.newArrayList();
        for (int start = 0; start < totalPartitionNum; start += partitionNumPerRange) {
            int end = start + partitionNumPerRange - 1;
            PartitionRange range = new PartitionRange(start, end);
            rangeGroup.add(range);
            boolean isLastRound = groupCount >= round * serverNum;
            int groupIndexInRound = groupCount % serverNum;
            if ((isLastRound || ++rangeInGroupCount != rangePerGroup) && (!isLastRound || (groupIndexInRound >= lastRoundRemainRange || rangeInGroupCount != lastRoundRangePerGroup + 1) && (groupIndexInRound < lastRoundRemainRange || rangeInGroupCount != lastRoundRangePerGroup))) continue;
            res.add(Lists.newArrayList(rangeGroup));
            rangeGroup.clear();
            rangeInGroupCount = 0;
            ++groupCount;
        }
        if (!rangeGroup.isEmpty()) {
            res.add(Lists.newArrayList(rangeGroup));
        }
        return res;
    }

    public static List<PartitionRange> generateRanges(int totalPartitionNum, int partitionNumPerRange) {
        ArrayList<PartitionRange> ranges = new ArrayList<PartitionRange>();
        if (totalPartitionNum <= 0 || partitionNumPerRange <= 0) {
            return ranges;
        }
        for (int start = 0; start < totalPartitionNum; start += partitionNumPerRange) {
            int end = start + partitionNumPerRange - 1;
            PartitionRange range = new PartitionRange(start, end);
            ranges.add(range);
        }
        return ranges;
    }

    public static Map<String, Map<String, String>> extractRemoteStorageConf(String confString) {
        HashMap<String, Map<String, String>> res = Maps.newHashMap();
        if (StringUtils.isEmpty((CharSequence)confString)) {
            return res;
        }
        Object[] clusterConfItems = confString.split(";");
        String msg = "Cluster specific conf[{}] format[cluster,k1=v1;...] is wrong.";
        if (ArrayUtils.isEmpty((Object[])clusterConfItems)) {
            LOG.warn(msg, (Object)confString);
            return res;
        }
        for (Object s : clusterConfItems) {
            Object[] item = ((String)s).split(",");
            if (ArrayUtils.isEmpty((Object[])item) || item.length < 2) {
                LOG.warn(msg, s);
                return Maps.newHashMap();
            }
            Object clusterId = item[0];
            HashMap<String, String> curClusterConf = Maps.newHashMap();
            for (int i = 1; i < item.length; ++i) {
                String[] kv = ((String)item[i]).split("=");
                if (ArrayUtils.isEmpty((Object[])item) || kv.length != 2) {
                    LOG.warn(msg, s);
                    return Maps.newHashMap();
                }
                String key = kv[0].trim();
                String value = kv[1].trim();
                if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) {
                    LOG.warn("This cluster conf[{}] format is wrong[k=v]", s);
                    return Maps.newHashMap();
                }
                curClusterConf.put(key, value);
            }
            res.put((String)clusterId, curClusterConf);
        }
        return res;
    }
}

