/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage;

import org.apache.uniffle.common.StorageType;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.storage.HadoopStorageManager;
import org.apache.uniffle.server.storage.LocalStorageManager;
import org.apache.uniffle.server.storage.MultiStorageManager;
import org.apache.uniffle.server.storage.StorageManager;

public class StorageManagerFactory {
    public static StorageManagerFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    public StorageManager createStorageManager(ShuffleServerConf conf) {
        org.apache.uniffle.storage.util.StorageType type = org.apache.uniffle.storage.util.StorageType.valueOf((String)((StorageType)conf.get(ShuffleServerConf.RSS_STORAGE_TYPE)).name());
        if (org.apache.uniffle.storage.util.StorageType.LOCALFILE.equals((Object)type) || org.apache.uniffle.storage.util.StorageType.MEMORY_LOCALFILE.equals((Object)type)) {
            return new LocalStorageManager(conf);
        }
        if (org.apache.uniffle.storage.util.StorageType.HDFS.equals((Object)type) || org.apache.uniffle.storage.util.StorageType.MEMORY_HDFS.equals((Object)type)) {
            return new HadoopStorageManager(conf);
        }
        if (org.apache.uniffle.storage.util.StorageType.LOCALFILE_HDFS.equals((Object)type) || org.apache.uniffle.storage.util.StorageType.MEMORY_LOCALFILE_HDFS.equals((Object)type)) {
            return new MultiStorageManager(conf);
        }
        throw new IllegalArgumentException("unknown storageType was found");
    }

    private static class LazyHolder {
        static final StorageManagerFactory INSTANCE = new StorageManagerFactory();

        private LazyHolder() {
        }
    }
}

