/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.uniffle.client.api.CoordinatorClient;
import org.apache.uniffle.client.factory.CoordinatorClientFactory;
import org.apache.uniffle.client.request.RssSendHeartBeatRequest;
import org.apache.uniffle.client.response.RssSendHeartBeatResponse;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.storage.StorageInfo;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.guava.annotations.VisibleForTesting;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterHeartBeat {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterHeartBeat.class);
    private final long heartBeatInitialDelay;
    private final long heartBeatInterval;
    private final ShuffleServer shuffleServer;
    private final String coordinatorQuorum;
    private final List<CoordinatorClient> coordinatorClients;
    private final ScheduledExecutorService service = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"startHeartBeat");
    private final ExecutorService heartBeatExecutorService;

    public RegisterHeartBeat(ShuffleServer shuffleServer) {
        ShuffleServerConf conf = shuffleServer.getShuffleServerConf();
        this.heartBeatInitialDelay = conf.getLong(ShuffleServerConf.SERVER_HEARTBEAT_DELAY);
        this.heartBeatInterval = conf.getLong(ShuffleServerConf.SERVER_HEARTBEAT_INTERVAL);
        this.coordinatorQuorum = conf.getString(ShuffleServerConf.RSS_COORDINATOR_QUORUM);
        CoordinatorClientFactory factory = new CoordinatorClientFactory((ClientType)conf.get(ShuffleServerConf.RSS_CLIENT_TYPE));
        this.coordinatorClients = factory.createCoordinatorClient(this.coordinatorQuorum);
        this.shuffleServer = shuffleServer;
        this.heartBeatExecutorService = ThreadUtils.getDaemonFixedThreadPool((int)conf.getInteger(ShuffleServerConf.SERVER_HEARTBEAT_THREAD_NUM), (String)"sendHeartBeat");
    }

    public void startHeartBeat() {
        LOG.info("Start heartbeat to coordinator {} after {}ms and interval is {}ms", new Object[]{this.coordinatorQuorum, this.heartBeatInitialDelay, this.heartBeatInterval});
        Runnable runnable = () -> {
            try {
                this.sendHeartBeat(this.shuffleServer.getId(), this.shuffleServer.getIp(), this.shuffleServer.getGrpcPort(), this.shuffleServer.getUsedMemory(), this.shuffleServer.getPreAllocatedMemory(), this.shuffleServer.getAvailableMemory(), this.shuffleServer.getEventNumInFlush(), this.shuffleServer.getTags(), this.shuffleServer.getServerStatus(), this.shuffleServer.getStorageManager().getStorageInfo(), this.shuffleServer.getNettyPort());
            }
            catch (Exception e) {
                LOG.warn("Error happened when send heart beat to coordinator");
            }
        };
        this.service.scheduleAtFixedRate(runnable, this.heartBeatInitialDelay, this.heartBeatInterval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    boolean sendHeartBeat(String id, String ip, int grpcPort, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags, ServerStatus serverStatus, Map<String, StorageInfo> localStorageInfo, int nettyPort) {
        boolean sendSuccessfully = false;
        RssSendHeartBeatRequest request = new RssSendHeartBeatRequest(id, ip, grpcPort, usedMemory, preAllocatedMemory, availableMemory, eventNumInFlush, this.heartBeatInterval, tags, serverStatus, localStorageInfo, nettyPort);
        List respFutures = this.coordinatorClients.stream().map(client -> this.heartBeatExecutorService.submit(() -> client.sendHeartBeat(request))).collect(Collectors.toList());
        String msg = "";
        for (Future rf : respFutures) {
            try {
                if (((RssSendHeartBeatResponse)rf.get(request.getTimeout() * 2L, TimeUnit.MILLISECONDS)).getStatusCode() != StatusCode.SUCCESS) continue;
                sendSuccessfully = true;
            }
            catch (Exception e) {
                msg = e.getMessage();
            }
        }
        if (!sendSuccessfully) {
            LOG.error(msg);
        }
        return sendSuccessfully;
    }

    public void shutdown() {
        this.heartBeatExecutorService.shutdownNow();
        this.service.shutdownNow();
    }
}

