package org.apache.stratum.scheduler;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This bean represents the settings used to create a JobDetail object for use in the Quartz scheduler.
 *
 * @author <a href="mailto:john@zenplex.com">John Thorhauer</a>
 * @version $Id: JobConfig.java 264191 2005-08-29 18:07:52Z henning $
 */
public class JobConfig
{
    /** The name that the Job will use. */
    private String name;

    /** The group the job will be associated with */
    private String group;

    /** The full package/class name for the Job that will run */
    private String className;

    /**
     * Default contructor
     */
    public JobConfig()
    {
    }

    /**
     * This is the name by which the job will be identified in Quartz
     *
     * @param s name of the Job
     */
    public void setName(String s)
    {
        this.name = s;
    }

    /**
     * The name of the job
     *
     * @return name of the Job
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * This is the group with which the job will be associated in Quartz.
     *
     * @param s name of the Group
     */
    public void setGroup(String s)
    {
        this.group = s;
    }

    /**
     * The group name that this job will be associated with
     *
     * @return the group name
     */
    public String getGroup()
    {
        return this.group;
    }

    /**
     * This is the full package/class name of the job that Quartz will run
     *
     * @param s class name
     */
    public void setClassName(String s)
    {
        this.className = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return the full package/class name
     */
    public String getClassName()
    {
        return this.className;
    }
}
