package org.apache.stratum.lifecycle;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * The Suspendable interface is used when a component will need to temporarily halt execution of a component. The execution may be
 * halted so that you can reconfigure/ recompose/recontextualize component.
 *
 * @author <a href="mailto:donaldp@apache.org">Peter Donald</a>
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 */
public interface Suspendable
{
    /**
     * Suspends the component.
     */
    void suspend();

    /**
     * Resumes the component.
     */
    void resume();
}
