/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.lib.meta.SourceTracker;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.lib.xml.Commentable;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.meta.MetaDataModes;
import org.apache.openjpa.util.MetaDataException;

public class QueryResultMapping
implements MetaDataModes,
SourceTracker,
Commentable {
    private static final Localizer _loc = Localizer.forPackage(QueryResultMapping.class);
    private final String _name;
    private final MappingRepository _repos;
    private File _file = null;
    private Object _scope = null;
    private int _srcType = 0;
    private int _lineNum = 0;
    private int _colNum = 0;
    private int _mode = 4;
    private Class<?> _class = null;
    private int _idx = 0;
    private String[] _comments = null;
    private List<Object> _colList = null;
    private List<PCResult> _pcList = null;
    private PCResult[] _pcs = null;
    private Object[] _cols = null;

    QueryResultMapping(String name, MappingRepository repos) {
        this._name = name;
        this._repos = repos;
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getDefiningType() {
        return this._class;
    }

    public void setDefiningType(Class<?> cls) {
        this._class = cls;
    }

    public Object[] getColumnResults() {
        if (this._cols == null) {
            Object[] cols = this._colList == null ? new Object[]{} : this._colList.toArray();
            this._cols = cols;
        }
        return this._cols;
    }

    public void addColumnResult(Object id) {
        this._cols = null;
        if (this._colList == null) {
            this._colList = new ArrayList<Object>();
        }
        this._colList.add(id);
    }

    public PCResult[] getPCResults() {
        if (this._pcs == null) {
            PCResult[] pcs = this._pcList == null ? new PCResult[]{} : this._pcList.toArray(new PCResult[this._pcList.size()]);
            this._pcs = pcs;
        }
        return this._pcs;
    }

    public PCResult addPCResult(Class<?> candidate) {
        this._pcs = null;
        PCResult pc = new PCResult(candidate);
        if (this._pcList == null) {
            this._pcList = new ArrayList<PCResult>();
        }
        this._pcList.add(pc);
        return pc;
    }

    public int getSourceMode() {
        return this._mode;
    }

    public void setSourceMode(int mode) {
        this._mode = mode;
    }

    public int getListingIndex() {
        return this._idx;
    }

    public void setListingIndex(int idx) {
        this._idx = idx;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public String[] getComments() {
        return this._comments == null ? EMPTY_COMMENTS : this._comments;
    }

    @Override
    public void setComments(String[] comments) {
        this._comments = comments;
    }

    @Override
    public File getSourceFile() {
        return this._file;
    }

    @Override
    public Object getSourceScope() {
        return this._scope;
    }

    @Override
    public int getSourceType() {
        return this._srcType;
    }

    public void setSource(File file, Object scope, int srcType) {
        this._file = file;
        this._scope = scope;
        this._srcType = srcType;
    }

    @Override
    public String getResourceName() {
        return this._class == null ? this._name : this._class.getName() + ":" + this._name;
    }

    @Override
    public int getLineNumber() {
        return this._lineNum;
    }

    public void setLineNumber(int lineNum) {
        this._lineNum = lineNum;
    }

    @Override
    public int getColNumber() {
        return this._colNum;
    }

    public void setColNumber(int colNum) {
        this._colNum = colNum;
    }

    private static class MultiColumnMap
    implements ColumnMap {
        private final List<Column> _cols;
        private final Object[] _ids;

        public MultiColumnMap(Column[] cols) {
            this._cols = Arrays.asList(cols);
            this._ids = new Object[cols.length];
        }

        @Override
        public Object map(Column col) {
            int idx = this._cols.indexOf(col);
            return idx == -1 ? col : this._ids[idx];
        }

        public void set(Column col, Object id) {
            int idx = this._cols.indexOf(col);
            if (idx != -1) {
                this._ids[idx] = id;
            }
        }

        public String toString() {
            return String.valueOf(this._cols) + "=" + String.valueOf(Arrays.asList(this._ids));
        }
    }

    private static class SingleColumnMap
    implements ColumnMap {
        private final Object _id;

        public SingleColumnMap(Object id) {
            this._id = id;
        }

        @Override
        public Object map(Column col) {
            return this._id;
        }

        public String toString() {
            return this._id.toString();
        }
    }

    private static interface ColumnMap {
        public Object map(Column var1);
    }

    private static class FetchInfo {
        public final BitSet excludes;
        public final BitSet eager;

        public FetchInfo(ClassMapping type) {
            FieldMapping[] fms = type.getFieldMappings();
            this.eager = new BitSet(fms.length);
            this.excludes = new BitSet(fms.length);
            for (int i = 0; i < fms.length; ++i) {
                if (fms[i].isPrimaryKey()) continue;
                this.excludes.set(i);
            }
        }
    }

    public class PCResult {
        public static final String DISCRIMINATOR = "<discriminator>";
        private final Class<?> _candidate;
        private ClassMapping _candidateMap = null;
        private Map<String, Object> _rawMappings = null;
        private Map<List<MetaDataContext>, ColumnMap> _mappings = null;
        private Map<List<MetaDataContext>, FetchInfo> _eager = null;
        private FetchInfo _fetchInfo = null;
        private Collection<String> _constructorParams = null;

        private PCResult(Class<?> candidate) {
            this._candidate = candidate;
        }

        public Class<?> getCandidateType() {
            return this._candidate;
        }

        public ClassMapping getCandidateTypeMapping() {
            if (this._candidateMap == null) {
                this._candidateMap = QueryResultMapping.this._repos.getMapping(this._candidate, null, true);
            }
            return this._candidateMap;
        }

        public String[] getMappingPaths() {
            if (this._rawMappings == null) {
                return new String[0];
            }
            Set<String> keys = this._rawMappings.keySet();
            return keys.toArray(new String[keys.size()]);
        }

        public Object getMapping(String path) {
            return this._rawMappings == null ? null : this._rawMappings.get(path);
        }

        public void addMapping(String path, Object id) {
            if (StringUtil.isEmpty(path)) {
                throw new MetaDataException(_loc.get("null-path", QueryResultMapping.this, this._candidate));
            }
            this._mappings = null;
            this._eager = null;
            this._fetchInfo = null;
            if (this._rawMappings == null) {
                this._rawMappings = new HashMap<String, Object>();
            }
            this._rawMappings.put(path, id);
        }

        public Object map(List<MetaDataContext> path, Object id, Joins joins) {
            if (this._rawMappings == null || !(id instanceof Column)) {
                return id;
            }
            this.resolve();
            ColumnMap cm = this._mappings.get(path);
            return cm == null ? id : cm.map((Column)id);
        }

        public boolean hasEager(List<MetaDataContext> path, FieldMapping field) {
            if (this._rawMappings == null) {
                return false;
            }
            this.resolve();
            if (path.isEmpty()) {
                return this._fetchInfo.eager.get(field.getIndex());
            }
            if (this._eager == null) {
                return false;
            }
            FetchInfo info = this._eager.get(path);
            return info != null && info.eager.get(field.getIndex());
        }

        public BitSet getExcludes(List<MetaDataContext> path) {
            if (this._rawMappings == null) {
                return null;
            }
            this.resolve();
            if (path.isEmpty()) {
                return this._fetchInfo.excludes;
            }
            if (this._eager == null) {
                return null;
            }
            FetchInfo info = this._eager.get(path);
            return info == null ? null : info.excludes;
        }

        private synchronized void resolve() {
            if (this._rawMappings == null || this._mappings != null) {
                return;
            }
            this._mappings = new HashMap<List<MetaDataContext>, ColumnMap>();
            this._fetchInfo = new FetchInfo(this.getCandidateTypeMapping());
            for (Map.Entry<String, Object> entry : this._rawMappings.entrySet()) {
                this.resolveMapping(entry.getKey(), entry.getValue());
            }
        }

        private void resolveMapping(String path, Object id) {
            String[] tokens = StringUtil.split(path, ".", 0);
            ArrayList<MetaDataContext> rpath = new ArrayList<MetaDataContext>(tokens.length);
            ClassMapping candidate = this.getCandidateTypeMapping();
            FieldMapping fm = null;
            for (int i = 0; i < tokens.length - 1; ++i) {
                fm = candidate.getFieldMapping(tokens[i]);
                if (fm == null) {
                    throw new MetaDataException(_loc.get("bad-path", QueryResultMapping.this, this._candidate, path));
                }
                if (fm.getEmbeddedMapping() != null) {
                    this.recordIncluded(candidate, rpath, fm);
                    candidate = fm.getEmbeddedMapping();
                } else {
                    candidate = fm.getTypeMapping();
                }
                if (candidate == null) {
                    throw new MetaDataException(_loc.get("untraversable-path", QueryResultMapping.this, this._candidate, path));
                }
                rpath.add(fm);
            }
            String lastToken = tokens[tokens.length - 1];
            if (DISCRIMINATOR.equals(lastToken)) {
                Discriminator discrim = candidate.getDiscriminator();
                rpath.add(discrim);
                this.assertSingleColumn(discrim.getColumns(), path);
                this._mappings.put(rpath, new SingleColumnMap(id));
            } else {
                FieldMapping last = candidate.getFieldMapping(lastToken);
                if (last == null) {
                    throw new MetaDataException(_loc.get("untraversable-path", QueryResultMapping.this, this._candidate, path));
                }
                Column[] cols = last.getColumns();
                this.assertSingleColumn(cols, path);
                Column col = cols[0];
                if (fm != null && fm.getDeclaredTypeCode() == 29) {
                    this.addComplexColumnMapping(fm, rpath, col, id);
                    return;
                }
                if (fm != null && fm.getForeignKey() != null) {
                    Column fkCol = fm.getForeignKey().getColumn(col);
                    if (fkCol != null) {
                        this.addComplexColumnMapping(fm, new ArrayList<MetaDataContext>(rpath), fkCol, id);
                    } else {
                        this.recordEager(candidate, rpath, fm);
                        this.recordIncluded(candidate, rpath, last);
                    }
                } else {
                    this.recordIncluded(candidate, rpath, last);
                }
                rpath.add(last);
                this._mappings.put(rpath, new SingleColumnMap(id));
            }
        }

        private void addComplexColumnMapping(FieldMapping fm, List<MetaDataContext> rpath, Column col, Object id) {
            if (fm.getColumns().length == 1) {
                this._mappings.put(rpath, new SingleColumnMap(id));
            } else {
                MultiColumnMap mcm = (MultiColumnMap)this._mappings.get(rpath);
                if (mcm == null) {
                    mcm = new MultiColumnMap(fm.getColumns());
                    this._mappings.put(rpath, mcm);
                }
                mcm.set(col, id);
            }
        }

        private void assertSingleColumn(Column[] cols, String path) {
            if (cols.length != 1) {
                throw new MetaDataException(_loc.get("num-cols-path", QueryResultMapping.this, this._candidate, path));
            }
        }

        private void recordEager(ClassMapping candidate, List<MetaDataContext> path, FieldMapping fm) {
            if (path.size() == 1) {
                this._fetchInfo.eager.set(fm.getIndex());
                this._fetchInfo.excludes.clear(fm.getIndex());
            } else {
                FetchInfo info;
                ArrayList<MetaDataContext> copy = new ArrayList<MetaDataContext>(path.size() - 1);
                for (int i = 0; i < copy.size(); ++i) {
                    copy.add(path.get(i));
                }
                if (this._eager == null) {
                    this._eager = new HashMap<List<MetaDataContext>, FetchInfo>();
                }
                if ((info = this._eager.get(copy)) == null) {
                    info = new FetchInfo(candidate);
                    this._eager.put(copy, info);
                }
                info.eager.set(fm.getIndex());
                info.excludes.clear(fm.getIndex());
            }
        }

        private void recordIncluded(ClassMapping candidate, List<MetaDataContext> path, FieldMapping fm) {
            if (path.isEmpty()) {
                this._fetchInfo.excludes.clear(fm.getIndex());
            } else {
                FetchInfo info;
                if (this._eager == null) {
                    this._eager = new HashMap<List<MetaDataContext>, FetchInfo>();
                }
                if ((info = this._eager.get(path)) == null) {
                    info = new FetchInfo(candidate);
                    this._eager.put(new ArrayList<MetaDataContext>(path), info);
                }
                info.excludes.clear(fm.getIndex());
            }
        }

        public void addConstructorParam(String name) {
            if (this._constructorParams == null) {
                this._constructorParams = new ArrayList<String>();
            }
            this._constructorParams.add(name);
        }
    }
}

