/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.functionobjects.SwapIndex;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.utils.GPUStatistics;

public class ReorgGPUInstruction
extends GPUInstruction {
    private ReorgGPUInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(op, in, null, out, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.Reorg;
    }

    public static ReorgGPUInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 2);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        if (!opcode.equalsIgnoreCase("r'")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a ReorgInstruction: " + str);
        }
        return new ReorgGPUInstruction(new ReorgOperator(SwapIndex.getSwapIndexFnObject()), in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        MatrixObject mat = this.getMatrixInputForGPUInstruction(ec, this._input1.getName());
        int rlen = (int)mat.getNumColumns();
        int clen = (int)mat.getNumRows();
        ec.setMetaData(this._output.getName(), rlen, clen);
        LibMatrixCUDA.transpose(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
        ec.releaseMatrixInputForGPUInstruction(this._input1.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }
}

