/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.scheduler.HDFSCacheTaskLocation;
import org.apache.spark.scheduler.HostTaskLocation;
import org.apache.spark.scheduler.TaskLocation;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class TaskLocation$ {
    public static final TaskLocation$ MODULE$;
    private final String inMemoryLocationTag;
    private final String executorLocationTag;

    static {
        new TaskLocation$();
    }

    public String inMemoryLocationTag() {
        return this.inMemoryLocationTag;
    }

    public String executorLocationTag() {
        return this.executorLocationTag;
    }

    public TaskLocation apply(String host, String executorId) {
        return new ExecutorCacheTaskLocation(host, executorId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TaskLocation apply(String str) {
        Product product;
        String hstr = new StringOps(Predef$.MODULE$.augmentString(str)).stripPrefix(this.inMemoryLocationTag());
        if (hstr.equals(str)) {
            if (str.startsWith(this.executorLocationTag())) {
                Tuple2 tuple2;
                String hostAndExecutorId = new StringOps(Predef$.MODULE$.augmentString(str)).stripPrefix(this.executorLocationTag());
                String[] splits = hostAndExecutorId.split("_", 2);
                Predef$.MODULE$.require(splits.length == 2, (Function0)new Serializable(str){
                    public static final long serialVersionUID = 0L;
                    private final String str$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Illegal executor location format: ").append((Object)this.str$1).toString();
                    }
                    {
                        this.str$1 = str$1;
                    }
                });
                String[] stringArray = splits;
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) throw new MatchError((Object)stringArray);
                String host = (String)((SeqLike)option.get()).apply(0);
                String executorId = (String)((SeqLike)option.get()).apply(1);
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)host, (Object)executorId);
                String host2 = (String)tuple22._1();
                String executorId2 = (String)tuple22._2();
                product = new ExecutorCacheTaskLocation(host2, executorId2);
                return product;
            } else {
                product = new HostTaskLocation(str);
            }
            return product;
        } else {
            product = new HDFSCacheTaskLocation(hstr);
        }
        return product;
    }

    private TaskLocation$() {
        MODULE$ = this;
        this.inMemoryLocationTag = "hdfs_cache_";
        this.executorLocationTag = "executor_";
    }
}

