/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api.mlcontext;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.api.mlcontext.MLContextException;
import org.apache.sysds.api.mlcontext.Script;
import org.apache.sysds.runtime.io.IOUtilFunctions;

public class ScriptFactory {
    public static Script dmlFromFile(String scriptFilePath) {
        return ScriptFactory.scriptFromFile(scriptFilePath);
    }

    public static Script dmlFromInputStream(InputStream inputStream) {
        return ScriptFactory.scriptFromInputStream(inputStream);
    }

    public static Script dmlFromLocalFile(File localScriptFile) {
        return ScriptFactory.scriptFromLocalFile(localScriptFile);
    }

    public static Script dmlFromString(String scriptString) {
        return ScriptFactory.scriptFromString(scriptString);
    }

    public static Script dmlFromUrl(String scriptUrlPath) {
        return ScriptFactory.scriptFromUrl(scriptUrlPath);
    }

    public static Script dmlFromUrl(URL scriptUrl) {
        return ScriptFactory.scriptFromUrl(scriptUrl);
    }

    public static Script dmlFromResource(String resourcePath) {
        return ScriptFactory.scriptFromResource(resourcePath);
    }

    private static Script scriptFromFile(String scriptFilePath) {
        String scriptString = ScriptFactory.getScriptStringFromFile(scriptFilePath);
        return ScriptFactory.scriptFromString(scriptString).setName(scriptFilePath);
    }

    private static Script scriptFromInputStream(InputStream inputStream) {
        String scriptString = ScriptFactory.getScriptStringFromInputStream(inputStream);
        return ScriptFactory.scriptFromString(scriptString);
    }

    private static Script scriptFromLocalFile(File localScriptFile) {
        String scriptString = ScriptFactory.getScriptStringFromFile(localScriptFile);
        return ScriptFactory.scriptFromString(scriptString).setName(localScriptFile.getName());
    }

    private static Script scriptFromString(String scriptString) {
        return new Script(scriptString);
    }

    private static Script scriptFromUrl(String scriptUrlPath) {
        String scriptString = ScriptFactory.getScriptStringFromUrl(scriptUrlPath);
        return ScriptFactory.scriptFromString(scriptString).setName(scriptUrlPath);
    }

    private static Script scriptFromUrl(URL scriptUrl) {
        String scriptString = ScriptFactory.getScriptStringFromUrl(scriptUrl);
        return ScriptFactory.scriptFromString(scriptString).setName(scriptUrl.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Script scriptFromResource(String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        try (InputStream inputStream = ScriptFactory.class.getResourceAsStream(resourcePath);){
            Script script = ScriptFactory.scriptFromInputStream(inputStream).setName(resourcePath);
            return script;
        }
        catch (Exception e) {
            throw new MLContextException("Error trying to read script from resource: " + resourcePath, e);
        }
    }

    public static Script dml(String scriptString) {
        return ScriptFactory.dmlFromString(scriptString);
    }

    private static String getScriptStringFromFile(File file) {
        if (file == null) {
            throw new MLContextException("Script file is null");
        }
        String filePath = file.getPath();
        try {
            return FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            throw new MLContextException("Error trying to read script string from file: " + filePath, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getScriptStringFromFile(String scriptFilePath) {
        if (scriptFilePath == null) {
            throw new MLContextException("Script file path is null");
        }
        try {
            if (!(scriptFilePath.startsWith("hdfs:") || scriptFilePath.startsWith("gpfs:") || IOUtilFunctions.isObjectStoreFileScheme(new Path(scriptFilePath)))) {
                File scriptFile = new File(scriptFilePath);
                return FileUtils.readFileToString((File)scriptFile);
            }
            Path path = new Path(scriptFilePath);
            FileSystem fs = IOUtilFunctions.getFileSystem(path);
            try (FSDataInputStream fsdis = fs.open(path);){
                String string = IOUtils.toString((InputStream)fsdis);
                return string;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new MLContextException("Error trying to read script string from file: " + scriptFilePath, e);
        }
    }

    private static String getScriptStringFromInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new MLContextException("InputStream is null");
        }
        try {
            return IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new MLContextException("Error trying to read script string from InputStream", e);
        }
    }

    private static String getScriptStringFromUrl(String scriptUrlPath) {
        if (scriptUrlPath == null) {
            throw new MLContextException("Script URL path is null");
        }
        try {
            URL url = new URL(scriptUrlPath);
            return ScriptFactory.getScriptStringFromUrl(url);
        }
        catch (MalformedURLException e) {
            throw new MLContextException("Error trying to read script string from URL path: " + scriptUrlPath, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getScriptStringFromUrl(URL url) {
        if (url == null) {
            throw new MLContextException("URL is null");
        }
        String urlString = url.toString();
        if (!urlString.toLowerCase().startsWith("http:") && !urlString.toLowerCase().startsWith("https:")) {
            throw new MLContextException("Currently only reading from http and https URLs is supported");
        }
        try (InputStream is = url.openStream();){
            String string = IOUtils.toString((InputStream)is);
            return string;
        }
        catch (IOException e) {
            throw new MLContextException("Error trying to read script string from URL: " + url, e);
        }
    }
}

