/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.clients.producer;

public final class ProducerRecord<K, V> {
    private final String topic;
    private final Integer partition;
    private final K key;
    private final V value;
    private final Long timestamp;

    public ProducerRecord(String topic, Integer partition2, Long timestamp, K key, V value2) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null.");
        }
        if (timestamp != null && timestamp < 0L) {
            throw new IllegalArgumentException(String.format("Invalid timestamp: %d. Timestamp should always be non-negative or null.", timestamp));
        }
        if (partition2 != null && partition2 < 0) {
            throw new IllegalArgumentException(String.format("Invalid partition: %d. Partition number should always be non-negative or null.", partition2));
        }
        this.topic = topic;
        this.partition = partition2;
        this.key = key;
        this.value = value2;
        this.timestamp = timestamp;
    }

    public ProducerRecord(String topic, Integer partition2, K key, V value2) {
        this(topic, partition2, null, key, value2);
    }

    public ProducerRecord(String topic, K key, V value2) {
        this(topic, null, null, key, value2);
    }

    public ProducerRecord(String topic, V value2) {
        this(topic, null, null, null, value2);
    }

    public String topic() {
        return this.topic;
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public Integer partition() {
        return this.partition;
    }

    public String toString() {
        String key = this.key == null ? "null" : this.key.toString();
        String value2 = this.value == null ? "null" : this.value.toString();
        String timestamp = this.timestamp == null ? "null" : this.timestamp.toString();
        return "ProducerRecord(topic=" + this.topic + ", partition=" + this.partition + ", key=" + key + ", value=" + value2 + ", timestamp=" + timestamp + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProducerRecord)) {
            return false;
        }
        ProducerRecord that = (ProducerRecord)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.partition != null ? !this.partition.equals(that.partition) : that.partition != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null);
    }

    public int hashCode() {
        int result2 = this.topic != null ? this.topic.hashCode() : 0;
        result2 = 31 * result2 + (this.partition != null ? this.partition.hashCode() : 0);
        result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
        result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
        result2 = 31 * result2 + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result2;
    }
}

