/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.util.function.Predicate;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.QuickSelectSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;

public class Filter<T extends Summary> {
    private final Predicate<T> predicate;

    public Filter(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public CompactSketch<T> filter(Sketch<T> sketchIn) {
        if (sketchIn == null) {
            return new CompactSketch(null, null, Long.MAX_VALUE, true);
        }
        QuickSelectSketch<Summary> sketch = new QuickSelectSketch<Summary>(sketchIn.getRetainedEntries(), ResizeFactor.X1.lg(), null);
        SketchIterator<T> it = sketchIn.iterator();
        while (it.next()) {
            T summary = it.getSummary();
            if (!this.predicate.test(summary)) continue;
            sketch.insert(it.getHash(), summary.copy());
        }
        sketch.setThetaLong(sketchIn.getThetaLong());
        if (!sketchIn.isEmpty()) {
            sketch.setEmpty(false);
        }
        return sketch.compact();
    }
}

