/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.CountMinSketchAgg;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

@ExpressionDescription(usage="\n    _FUNC_(col, eps, confidence, seed) - Returns a count-min sketch of a column with the given esp,\n      confidence and seed. The result is an array of bytes, which can be deserialized to a\n      `CountMinSketch` before usage. Count-min sketch is a probabilistic data structure used for\n      cardinality estimation using sub-linear space.\n  ", examples="\n    Examples:\n      > SELECT hex(_FUNC_(col, 0.5d, 0.5d, 1)) FROM VALUES (1), (2), (1) AS tab(col);\n       0000000100000000000000030000000100000004000000005D8D6AB90000000000000000000000000000000200000000000000010000000000000000\n  ", group="agg_funcs", since="2.2.0")
public final class CountMinSketchAggExpressionBuilder$
implements ExpressionBuilder {
    public static CountMinSketchAggExpressionBuilder$ MODULE$;
    private final FunctionSignature defaultFunctionSignature;

    static {
        new CountMinSketchAggExpressionBuilder$();
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    public final FunctionSignature defaultFunctionSignature() {
        return this.defaultFunctionSignature;
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return new Some((Object)this.defaultFunctionSignature());
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        Predef$.MODULE$.assert(expressions.size() == 4);
        return new CountMinSketchAgg((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (Expression)expressions.apply(3));
    }

    private CountMinSketchAggExpressionBuilder$() {
        MODULE$ = this;
        FunctionBuilderBase.$init$(this);
        this.defaultFunctionSignature = new FunctionSignature((Seq<InputParameter>)((Seq)new .colon.colon((Object)new InputParameter("column", InputParameter$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new InputParameter("epsilon", InputParameter$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new InputParameter("confidence", InputParameter$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new InputParameter("seed", InputParameter$.MODULE$.apply$default$2()), (List)Nil$.MODULE$))))));
    }
}

