/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.authentication.BoundObjectReference;
import io.fabric8.kubernetes.api.model.authentication.BoundObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.authentication.BoundObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.authentication.TokenRequestSpec;
import io.fabric8.kubernetes.api.model.authentication.TokenRequestSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TokenRequestSpecFluentImpl<A extends TokenRequestSpecFluent<A>>
extends BaseFluent<A>
implements TokenRequestSpecFluent<A> {
    private List<String> audiences = new ArrayList<String>();
    private BoundObjectReferenceBuilder boundObjectRef;
    private Long expirationSeconds;
    private Map<String, Object> additionalProperties;

    public TokenRequestSpecFluentImpl() {
    }

    public TokenRequestSpecFluentImpl(TokenRequestSpec instance) {
        if (instance != null) {
            this.withAudiences(instance.getAudiences());
            this.withBoundObjectRef(instance.getBoundObjectRef());
            this.withExpirationSeconds(instance.getExpirationSeconds());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAudiences(String ... items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAudiences(Collection<String> items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    @Override
    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    @Override
    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    @Override
    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    @Override
    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
            this._visitables.remove((Object)"audiences");
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    @Override
    @Deprecated
    public BoundObjectReference getBoundObjectRef() {
        return this.boundObjectRef != null ? this.boundObjectRef.build() : null;
    }

    @Override
    public BoundObjectReference buildBoundObjectRef() {
        return this.boundObjectRef != null ? this.boundObjectRef.build() : null;
    }

    @Override
    public A withBoundObjectRef(BoundObjectReference boundObjectRef) {
        this._visitables.get((Object)"boundObjectRef").remove(this.boundObjectRef);
        if (boundObjectRef != null) {
            this.boundObjectRef = new BoundObjectReferenceBuilder(boundObjectRef);
            this._visitables.get((Object)"boundObjectRef").add(this.boundObjectRef);
        } else {
            this.boundObjectRef = null;
            this._visitables.get((Object)"boundObjectRef").remove(this.boundObjectRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBoundObjectRef() {
        return this.boundObjectRef != null;
    }

    @Override
    public A withNewBoundObjectRef(String apiVersion, String kind, String name, String uid) {
        return this.withBoundObjectRef(new BoundObjectReference(apiVersion, kind, name, uid));
    }

    @Override
    public TokenRequestSpecFluent.BoundObjectRefNested<A> withNewBoundObjectRef() {
        return new BoundObjectRefNestedImpl();
    }

    @Override
    public TokenRequestSpecFluent.BoundObjectRefNested<A> withNewBoundObjectRefLike(BoundObjectReference item) {
        return new BoundObjectRefNestedImpl(item);
    }

    @Override
    public TokenRequestSpecFluent.BoundObjectRefNested<A> editBoundObjectRef() {
        return this.withNewBoundObjectRefLike(this.getBoundObjectRef());
    }

    @Override
    public TokenRequestSpecFluent.BoundObjectRefNested<A> editOrNewBoundObjectRef() {
        return this.withNewBoundObjectRefLike(this.getBoundObjectRef() != null ? this.getBoundObjectRef() : new BoundObjectReferenceBuilder().build());
    }

    @Override
    public TokenRequestSpecFluent.BoundObjectRefNested<A> editOrNewBoundObjectRefLike(BoundObjectReference item) {
        return this.withNewBoundObjectRefLike(this.getBoundObjectRef() != null ? this.getBoundObjectRef() : item);
    }

    @Override
    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    @Override
    public A withExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasExpirationSeconds() {
        return this.expirationSeconds != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenRequestSpecFluentImpl that = (TokenRequestSpecFluentImpl)o;
        if (!Objects.equals(this.audiences, that.audiences)) {
            return false;
        }
        if (!Objects.equals(this.boundObjectRef, that.boundObjectRef)) {
            return false;
        }
        if (!Objects.equals(this.expirationSeconds, that.expirationSeconds)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.boundObjectRef, this.expirationSeconds, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.audiences != null && !this.audiences.isEmpty()) {
            sb.append("audiences:");
            sb.append(this.audiences + ",");
        }
        if (this.boundObjectRef != null) {
            sb.append("boundObjectRef:");
            sb.append(this.boundObjectRef + ",");
        }
        if (this.expirationSeconds != null) {
            sb.append("expirationSeconds:");
            sb.append(this.expirationSeconds + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class BoundObjectRefNestedImpl<N>
    extends BoundObjectReferenceFluentImpl<TokenRequestSpecFluent.BoundObjectRefNested<N>>
    implements TokenRequestSpecFluent.BoundObjectRefNested<N>,
    Nested<N> {
        BoundObjectReferenceBuilder builder;

        BoundObjectRefNestedImpl(BoundObjectReference item) {
            this.builder = new BoundObjectReferenceBuilder(this, item);
        }

        BoundObjectRefNestedImpl() {
            this.builder = new BoundObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)TokenRequestSpecFluentImpl.this.withBoundObjectRef(this.builder.build());
        }

        @Override
        public N endBoundObjectRef() {
            return this.and();
        }
    }
}

