% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\name{write.text}
\alias{write.text}
\alias{write.text,SparkDataFrame,character-method}
\title{Save the content of SparkDataFrame in a text file at the specified path.}
\usage{
write.text(x, path, ...)

\S4method{write.text}{SparkDataFrame,character}(x, path, mode = "error", ...)
}
\arguments{
\item{x}{A SparkDataFrame}

\item{path}{The directory where the file is saved}

\item{...}{additional argument(s) passed to the method.
You can find the text-specific options for writing text files in
\url{https://spark.apache.org/docs/latest/sql-data-sources-text.html#data-source-option}{Data Source Option} in the version you use.}

\item{mode}{one of 'append', 'overwrite', 'error', 'errorifexists', 'ignore'
save mode (it is 'error' by default)}
}
\description{
Save the content of the SparkDataFrame in a text file at the specified path.
The SparkDataFrame must have only one column of string type with the name "value".
Each row becomes a new line in the output file. The text files will be encoded as UTF-8.
}
\note{
write.text since 2.0.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.txt"
df <- read.text(path)
write.text(df, "/tmp/sparkr-tmp/")
}
}
\seealso{
Other SparkDataFrame functions: 
\code{\link{SparkDataFrame-class}},
\code{\link{agg}()},
\code{\link{alias}()},
\code{\link{arrange}()},
\code{\link{as.data.frame}()},
\code{\link{attach,SparkDataFrame-method}},
\code{\link{broadcast}()},
\code{\link{cache}()},
\code{\link{checkpoint}()},
\code{\link{coalesce}()},
\code{\link{collect}()},
\code{\link{colnames}()},
\code{\link{coltypes}()},
\code{\link{createOrReplaceTempView}()},
\code{\link{crossJoin}()},
\code{\link{cube}()},
\code{\link{dapply}()},
\code{\link{dapplyCollect}()},
\code{\link{describe}()},
\code{\link{dim}()},
\code{\link{distinct}()},
\code{\link{drop}()},
\code{\link{dropDuplicates}()},
\code{\link{dropna}()},
\code{\link{dtypes}()},
\code{\link{except}()},
\code{\link{exceptAll}()},
\code{\link{explain}()},
\code{\link{filter}()},
\code{\link{first}()},
\code{\link{gapply}()},
\code{\link{gapplyCollect}()},
\code{\link{getNumPartitions}()},
\code{\link{group_by}()},
\code{\link{head}()},
\code{\link{hint}()},
\code{\link{histogram}()},
\code{\link{insertInto}()},
\code{\link{intersect}()},
\code{\link{intersectAll}()},
\code{\link{isLocal}()},
\code{\link{isStreaming}()},
\code{\link{join}()},
\code{\link{limit}()},
\code{\link{localCheckpoint}()},
\code{\link{merge}()},
\code{\link{mutate}()},
\code{\link{ncol}()},
\code{\link{nrow}()},
\code{\link{persist}()},
\code{\link{printSchema}()},
\code{\link{randomSplit}()},
\code{\link{rbind}()},
\code{\link{rename}()},
\code{\link{repartition}()},
\code{\link{repartitionByRange}()},
\code{\link{rollup}()},
\code{\link{sample}()},
\code{\link{saveAsTable}()},
\code{\link{schema}()},
\code{\link{select}()},
\code{\link{selectExpr}()},
\code{\link{show}()},
\code{\link{showDF}()},
\code{\link{storageLevel}()},
\code{\link{str}()},
\code{\link{subset}()},
\code{\link{summary}()},
\code{\link{take}()},
\code{\link{toJSON}()},
\code{\link{union}()},
\code{\link{unionAll}()},
\code{\link{unionByName}()},
\code{\link{unpersist}()},
\code{\link{unpivot}()},
\code{\link{with}()},
\code{\link{withColumn}()},
\code{\link{withWatermark}()},
\code{\link{write.df}()},
\code{\link{write.jdbc}()},
\code{\link{write.json}()},
\code{\link{write.orc}()},
\code{\link{write.parquet}()},
\code{\link{write.stream}()}
}
\concept{SparkDataFrame functions}
