/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.undertow.worker.thread.pool;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.skywalking.apm.agent.core.meter.Gauge;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.plugin.undertow.worker.thread.pool.util.XnioWorkerTaskPoolAccessor;
import org.xnio.XnioWorker;

public class XnioWorkerConstructorInterceptor
implements InstanceConstructorInterceptor {
    private static final String THREAD_POOL_NAME = "undertow_worker_pool";
    private static final Map<String, Function<XnioWorkerTaskPoolAccessor, Supplier<Double>>> METRIC_MAP = new HashMap<String, Function<XnioWorkerTaskPoolAccessor, Supplier<Double>>>(){
        {
            this.put("core_pool_size", threadPoolExecutor -> () -> threadPoolExecutor.getCorePoolSize());
            this.put("max_pool_size", threadPoolExecutor -> () -> threadPoolExecutor.getMaximumPoolSize());
            this.put("pool_size", threadPoolExecutor -> () -> threadPoolExecutor.getPoolSize());
            this.put("queue_size", threadPoolExecutor -> () -> threadPoolExecutor.getQueueSize());
            this.put("active_size", threadPoolExecutor -> () -> threadPoolExecutor.getActiveCount());
        }
    };

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) throws Throwable {
        this.buildThreadPoolMeterMetric(new XnioWorkerTaskPoolAccessor((XnioWorker)objInst));
    }

    private void buildThreadPoolMeterMetric(XnioWorkerTaskPoolAccessor xnioWorkerTaskPoolAccessor) {
        String threadPoolMeterName = "thread_pool";
        String poolNameTag = "pool_name";
        String metricTypeTag = "metric_type";
        METRIC_MAP.forEach((key, value) -> {
            if (Objects.equals(key, "pool_size")) {
                if (xnioWorkerTaskPoolAccessor.isContainsGetPoolSizeMethod()) {
                    ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)threadPoolMeterName, (Supplier)((Supplier)value.apply(xnioWorkerTaskPoolAccessor))).tag(poolNameTag, THREAD_POOL_NAME)).tag(metricTypeTag, key)).build();
                }
            } else {
                ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)threadPoolMeterName, (Supplier)((Supplier)value.apply(xnioWorkerTaskPoolAccessor))).tag(poolNameTag, THREAD_POOL_NAME)).tag(metricTypeTag, key)).build();
            }
        });
    }
}

